---
sidebar_position: 1
sidebar_label: 2024
---

# 2024 Changelog

### ClickHouse release v24.12.1.1614-stable (a6d2b2e35b2) FIXME as compared to v24.12.1.1-new (e4c9b022237)

#### Backward Incompatible Change
* Functions `greatest` and `least` now ignore NULL input values, whereas they previously returned NULL if one of the arguments was NULL. For example, `SELECT greatest(1, 2, NULL)` now returns 2. This makes the behavior compatible with PostgreSQL. [#65519](https://github.com/ClickHouse/ClickHouse/pull/65519) ([kevinyhzou](https://github.com/KevinyhZou)).
* The legacy MongoDB integration based on the Poco driver has been removed. Server setting `use_legacy_mongodb_integration` is obsolete and has no effect anymore. [#71997](https://github.com/ClickHouse/ClickHouse/pull/71997) ([Kirill Nikiforov](https://github.com/allmazz)).

#### New Feature
* Added a query that allows to attach MergeTree tables as ReplicatedMergeTree and vice versa. [#65401](https://github.com/ClickHouse/ClickHouse/pull/65401) ([Kirill](https://github.com/kirillgarbar)).
* Implement SYSTEM LOAD PRIMARY KEY command to load primary indexes for all parts of a specified table or for all tables if no table is specified. This will be useful for benchmarks and to prevent extra latency during query execution. [#66252](https://github.com/ClickHouse/ClickHouse/pull/66252) ([ZAWA_ll](https://github.com/Zawa-ll)).
* Added statement `SYSTEM LOAD PRIMARY KEY` for loading the primary indexes of all parts in a specified table or for all tables if no table is specified. This can be useful for benchmarking and to prevent extra latency during query execution. [#67733](https://github.com/ClickHouse/ClickHouse/pull/67733) ([ZAWA_ll](https://github.com/Zawa-ll)).
* [The Iceberg data storage](https://iceberg.apache.org/spec/#file-system-operations) format provides the user with extensive options for modifying the schema of their table. In this pull request, reading a table in Iceberg format has been implemented, where the order of columns, column names, and simple type extensions have been changed. [#69445](https://github.com/ClickHouse/ClickHouse/pull/69445) ([Daniil Ivanik](https://github.com/divanik)).
* Add function `toUnixTimestamp64Second` which converts a `DateTime64` to a `Int64` value with fixed second precision, so we can support return negative value if date is before 00:00:00 UTC on Thursday, 1 January 1970. [#70597](https://github.com/ClickHouse/ClickHouse/pull/70597) ([zhanglistar](https://github.com/zhanglistar)).
* Add new setting `enforce_index_structure_match_on_partition_manipulation` to allow attach when source table's projections and secondary indices is a subset of those in the target table. Close [#70602](https://github.com/ClickHouse/ClickHouse/issues/70602). [#70603](https://github.com/ClickHouse/ClickHouse/pull/70603) ([zwy991114](https://github.com/zwy991114)).
* The output of function `cast` differs with Apache Spark which cause difference in gluten project, see https://github.com/apache/incubator-gluten/issues/7602 This PR adds Spark text output format support feature, default closed. [#70957](https://github.com/ClickHouse/ClickHouse/pull/70957) ([zhanglistar](https://github.com/zhanglistar)).
* This PR introduces a new setting `allow_experimental_reverse_key` that enables support for descending sort order in MergeTree sorting keys. This is useful for time series analysis, especially TopN queries. Example usage: ```sql CREATE TABLE example ( time DateTime, key Int32, value String ) ENGINE = MergeTree ORDER BY (time DESC, key); -- Descending order for 'time' field SETTINGS allow_experimental_reverse_key = 1;. [#71095](https://github.com/ClickHouse/ClickHouse/pull/71095) ([Amos Bird](https://github.com/amosbird)).
* Integrate with Iceberg REST Catalog. [#71542](https://github.com/ClickHouse/ClickHouse/pull/71542) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added an option to select the side of the join that will act as the inner (build) table in the query plan. This is controlled by `query_plan_join_swap_table`, which can be set to `auto`. In this mode, ClickHouse will try to choose the table with the smallest number of rows. [#71577](https://github.com/ClickHouse/ClickHouse/pull/71577) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add syntax ALTER USER {ADD|MODIFY|DROP SETTING}, ALTER USER {ADD|DROP PROFILE}, the same for ALTER ROLE and ALTER PROFILE. [#72050](https://github.com/ClickHouse/ClickHouse/pull/72050) ([pufit](https://github.com/pufit)).
* Added `arrayPrAUC` function, which calculates the AUC (Area Under the Curve) for the Precision Recall curve. [#72073](https://github.com/ClickHouse/ClickHouse/pull/72073) ([Emmanuel](https://github.com/emmanuelsdias)).
* Added cache for primary index of `MergeTree` tables (can be enabled by table setting `use_primary_key_cache`). If lazy load and cache are enabled for primary index, it will be loaded to cache on demand (similar to mark cache) instead of keeping it in memory forever. Added prewarm of primary index on inserts/mergs/fetches of data parts and on restarts of table (can be enabled by setting `prewarm_primary_key_cache`). [#72102](https://github.com/ClickHouse/ClickHouse/pull/72102) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73593](https://github.com/ClickHouse/ClickHouse/issues/73593): `SELECT` and `VIEW` statements now support aliases, e.g. `SELECT b FROM (SELECT number, number*2 FROM numbers(2)) AS x (a, b);`. This enables TPC-H query 15 to run without modifications. [#72480](https://github.com/ClickHouse/ClickHouse/pull/72480) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Add indexOfAssumeSorted function for array types. Optimizes the search in the case of a sorted in non-decreasing order array. [#72517](https://github.com/ClickHouse/ClickHouse/pull/72517) ([Eric Kurbanov](https://github.com/erickurbanov)).
* Allows to use a delimiter as a optional second argument for aggregate function `groupConcat`. [#72540](https://github.com/ClickHouse/ClickHouse/pull/72540) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* A new setting, `http_response_headers` which allows you to customize the HTTP response headers. For example, you can tell the browser to render a picture that is stored in the database. This closes [#59620](https://github.com/ClickHouse/ClickHouse/issues/59620). [#72656](https://github.com/ClickHouse/ClickHouse/pull/72656) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add function `fromUnixTimestamp64Second` which converts a Int64 Unix timestamp value to a DateTime64. [#73146](https://github.com/ClickHouse/ClickHouse/pull/73146) ([Robert Schulze](https://github.com/rschu1ze)).

#### Performance Improvement
* Memory usage of `clickhouse disks remove --recursive` is reduced for object storage disks. [#67323](https://github.com/ClickHouse/ClickHouse/pull/67323) ([Kirill](https://github.com/kirillgarbar)).
* Enable JIT compilation for more expressions: abs/bitCount/sign/modulo/pmod/isNull/isNotNull/assumeNotNull/to(U)Int*/toFloat*, comparison functions(=, <, >, >=, <=), logical functions(and, or). [#70598](https://github.com/ClickHouse/ClickHouse/pull/70598) ([李扬](https://github.com/taiyang-li)).
* Now `parallel_hash` algorithm will be used (if applicable) when `join_algorithm` setting is set to `default`. Two previous alternatives (`direct` and `hash`) are still considered when `parallel_hash` cannot be used. [#70788](https://github.com/ClickHouse/ClickHouse/pull/70788) ([Nikita Taranov](https://github.com/nickitat)).
* Add option to extract common expressions from `WHERE` and `ON` expressions in order to reduce the number of hash tables used during joins. Can be enabled by `optimize_extract_common_expressions = 1`. [#71537](https://github.com/ClickHouse/ClickHouse/pull/71537) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Allows to use indexes on `SELECT` with `LowCardinality(String)`. [#71598](https://github.com/ClickHouse/ClickHouse/pull/71598) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* During query execution with parallel replicas and enabled local plan, skip index analysis on workers. The coordinator will choose ranges to read for workers based on index analysis on its side (on query initiator). [#72109](https://github.com/ClickHouse/ClickHouse/pull/72109) ([Igor Nikonov](https://github.com/devcrafter)).
* Bring back optimization for reading subcolumns of single column in Compact parts from https://github.com/ClickHouse/ClickHouse/pull/57631. It was deleted accidentally. [#72285](https://github.com/ClickHouse/ClickHouse/pull/72285) ([Pavel Kruglov](https://github.com/Avogar)).
* Speedup sorting of `LowCardinality(String)` columns by de-virtualizing calls in comparator. [#72337](https://github.com/ClickHouse/ClickHouse/pull/72337) ([Alexander Gololobov](https://github.com/davenger)).
* Optimize function argMin/Max for some simple data types. [#72350](https://github.com/ClickHouse/ClickHouse/pull/72350) ([alesapin](https://github.com/alesapin)).
* Optimize locking with shared locks in the memory tracker to reduce lock contention. [#72375](https://github.com/ClickHouse/ClickHouse/pull/72375) ([Jiebin Sun](https://github.com/jiebinn)).
* Add a new setting, `use_async_executor_for_materialized_views`. Use async and potentially multithreaded execution of materialized view query, can speedup views processing during INSERT, but also consume more memory. [#72497](https://github.com/ClickHouse/ClickHouse/pull/72497) ([alesapin](https://github.com/alesapin)).
* Default values for settings `max_size_to_preallocate_for_aggregation`, `max_size_to_preallocate_for_joins` were further increased to `10^12`, so the optimisation will be applied in more cases. [#72555](https://github.com/ClickHouse/ClickHouse/pull/72555) ([Nikita Taranov](https://github.com/nickitat)).
* Improved performance of deserialization of states of aggregate functions (in data type `AggregateFunction` and in distributed queries). Slightly improved performance of parsing of format `RowBinary`. [#72818](https://github.com/ClickHouse/ClickHouse/pull/72818) ([Anton Popov](https://github.com/CurtizJ)).

#### Improvement
* Adding a new cancellation logic: `CancellationChecker` checks timeouts for every started query and stops them once the timeout has reached. [#69880](https://github.com/ClickHouse/ClickHouse/pull/69880) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Remove the `allow_experimental_join_condition` setting, allowing non-equi conditions by default. [#69910](https://github.com/ClickHouse/ClickHouse/pull/69910) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Settings from server config (users.xml) now apply on the client too. Useful for format settings, e.g. `date_time_output_format`. [#71178](https://github.com/ClickHouse/ClickHouse/pull/71178) ([Michael Kolupaev](https://github.com/al13n321)).
* Fixes [#71227](https://github.com/ClickHouse/ClickHouse/issues/71227). [#71286](https://github.com/ClickHouse/ClickHouse/pull/71286) ([Arthur Passos](https://github.com/arthurpassos)).
* Automatic `GROUP BY`/`ORDER BY` to disk based on the server/user memory usage. Controlled with `max_bytes_ratio_before_external_group_by`/`max_bytes_ratio_before_external_sort` query settings. [#71406](https://github.com/ClickHouse/ClickHouse/pull/71406) ([Azat Khuzhin](https://github.com/azat)).
* Function `translate` now supports character deletion if the `from` argument contains more characters than the `to` argument. Example: `SELECT translate('clickhouse', 'clickhouse', 'CLICK')` now returns `CLICK`. [#71441](https://github.com/ClickHouse/ClickHouse/pull/71441) ([shuai.xu](https://github.com/shuai-xu)).
* Support ALTER from Object to JSON. [#71784](https://github.com/ClickHouse/ClickHouse/pull/71784) ([Pavel Kruglov](https://github.com/Avogar)).
* Split ranges in `MergeTreeReadPoolParallelReplicasInOrder` to consume less memory during reading. [#72173](https://github.com/ClickHouse/ClickHouse/pull/72173) ([JIaQi](https://github.com/JiaQiTang98)).
* Respect `prefer_locahost_replica` when building plan for distributed `INSERT ... SELECT`. [#72190](https://github.com/ClickHouse/ClickHouse/pull/72190) ([filimonov](https://github.com/filimonov)).
* The problem is [described here](https://github.com/ClickHouse/ClickHouse/issues/72091). Azure Iceberg Writer creates Iceberg metadata files (as well as manifest files) that violate specs. In this PR I added an attempt to read v1 iceberg format metadata with v2 reader (cause they write it in a this way), and added error when they didn't create corresponding fields in a manifest file. [#72277](https://github.com/ClickHouse/ClickHouse/pull/72277) ([Daniil Ivanik](https://github.com/divanik)).
* Move JSON/Dynamic/Variant types from experimental features to beta. [#72294](https://github.com/ClickHouse/ClickHouse/pull/72294) ([Pavel Kruglov](https://github.com/Avogar)).
* Now it's allowed to `CREATE MATERIALIZED VIEW` with `UNION [ALL]` in query. Behavior is the same as for matview with `JOIN`: **only first table in `SELECT` expression will work as trigger for insert** , all other tables will be ignored. [#72347](https://github.com/ClickHouse/ClickHouse/pull/72347) ([alesapin](https://github.com/alesapin)).
* Speed up insertions into merge tree in case of a single value of partition key inside inserted batch. [#72348](https://github.com/ClickHouse/ClickHouse/pull/72348) ([alesapin](https://github.com/alesapin)).
* All small utilities previously stored in `/utils` folder and required manual compilation from sources are now a part of main ClickHouse bundle. This closes: [#72404](https://github.com/ClickHouse/ClickHouse/issues/72404). [#72426](https://github.com/ClickHouse/ClickHouse/pull/72426) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Implement creating tables in parallel while restoring from a backup. Before this PR the `RESTORE` command always created tables in one thread, which could be slow in case of backups containing many tables. [#72427](https://github.com/ClickHouse/ClickHouse/pull/72427) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add the new MergeTreeIndexGranularityInternalArraysTotalSize metric to system.metrics. This metric is needed to find the instances with huge datasets susceptible to the high memory usage issue. [#72490](https://github.com/ClickHouse/ClickHouse/pull/72490) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Added source query validation when ClickHouse is used as a source for a dictionary. [#72548](https://github.com/ClickHouse/ClickHouse/pull/72548) ([Alexey Katsman](https://github.com/alexkats)).
* Ensure that ClickHouse will see ZooKeeper changes on config reloads. [#72593](https://github.com/ClickHouse/ClickHouse/pull/72593) ([Azat Khuzhin](https://github.com/azat)).
* Better memory usage approximation of cached marks to reduce total memory usage of the cache. [#72630](https://github.com/ClickHouse/ClickHouse/pull/72630) ([Antonio Andelic](https://github.com/antonio2368)).
* Add a new `StartupScriptsExecutionState` metric. The metric can have three values: 0 = startup scripts have not finished yet, 1 = startup scripts executed successfully, 2 = startup scripts failed. We need this metric because we need to know if startup scripts are being executed successfully in the cloud, especially after releases to base configurations. [#72637](https://github.com/ClickHouse/ClickHouse/pull/72637) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#73472](https://github.com/ClickHouse/ClickHouse/issues/73472): Support subcolumns in MergeTree sorting key and skip indexes. [#72644](https://github.com/ClickHouse/ClickHouse/pull/72644) ([Pavel Kruglov](https://github.com/Avogar)).
* All spellings of word `Null` now recognised when query uses `Format Null`. Previously other forms (e.g. `NULL`) did not result in exceptions being thrown, but at the same time format `Null` wasn't actually used in those cases. [#72658](https://github.com/ClickHouse/ClickHouse/pull/72658) ([Nikita Taranov](https://github.com/nickitat)).
* Add retries to creating a replicated table. [#72682](https://github.com/ClickHouse/ClickHouse/pull/72682) ([Vitaly Baranov](https://github.com/vitlibar)).
* Allow unknown values in set that are not present in Enum. Fix [#72662](https://github.com/ClickHouse/ClickHouse/issues/72662). [#72686](https://github.com/ClickHouse/ClickHouse/pull/72686) ([zhanglistar](https://github.com/zhanglistar)).
* Add total_bytes_with_inactive to system.tables to count the total bytes of inactive parts. [#72690](https://github.com/ClickHouse/ClickHouse/pull/72690) ([Kai Zhu](https://github.com/nauu)).
* Add MergeTreeSettings to system.settings_changes. [#72694](https://github.com/ClickHouse/ClickHouse/pull/72694) ([Raúl Marín](https://github.com/Algunenano)).
* Support string search operator(eg. like) for Enum data type, fix [#72661](https://github.com/ClickHouse/ClickHouse/issues/72661). [#72732](https://github.com/ClickHouse/ClickHouse/pull/72732) ([zhanglistar](https://github.com/zhanglistar)).
* Support JSON type in notEmpty function. [#72741](https://github.com/ClickHouse/ClickHouse/pull/72741) ([Pavel Kruglov](https://github.com/Avogar)).
* Support parsing GCS S3 error `AuthenticationRequired`. [#72753](https://github.com/ClickHouse/ClickHouse/pull/72753) ([Vitaly Baranov](https://github.com/vitlibar)).
* Support Dynamic type in functions ifNull and coalesce. [#72772](https://github.com/ClickHouse/ClickHouse/pull/72772) ([Pavel Kruglov](https://github.com/Avogar)).
* Add S3 request settings `http_max_fields`, `http_max_field_name_size`, `http_max_field_value_size` and use them while parsing S3 API responses during making a backup or restoring. [#72778](https://github.com/ClickHouse/ClickHouse/pull/72778) ([Vitaly Baranov](https://github.com/vitlibar)).
* Delete table metadata in keeper in Storage S3(Azure)Queue only after last table using this metadata is dropped. [#72810](https://github.com/ClickHouse/ClickHouse/pull/72810) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added `JoinBuildTableRowCount/JoinProbeTableRowCount/JoinResultRowCount` profile events. [#72842](https://github.com/ClickHouse/ClickHouse/pull/72842) ([Vladimir Cherkasov](https://github.com/vdimir)).
* From now if `compress` option is specified for a table of `Memory` engine, data will always be compressed as soon as compressed representation is at least one byte smaller than the original data. Previously it was required to be at least twice smaller. [#72895](https://github.com/ClickHouse/ClickHouse/pull/72895) ([Nikita Taranov](https://github.com/nickitat)).
* Support Dynamic in functions toFloat64/touInt32/etc. [#72989](https://github.com/ClickHouse/ClickHouse/pull/72989) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73470](https://github.com/ClickHouse/ClickHouse/issues/73470): Improve extraction of common expression in disjunctions. Allow simplifying the resulting filter expression even if there's no common subexpression for all the disjuncts. Continuation of [#71537](https://github.com/ClickHouse/ClickHouse/issues/71537). [#73271](https://github.com/ClickHouse/ClickHouse/pull/73271) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#73389](https://github.com/ClickHouse/ClickHouse/issues/73389): Introduce a setting `least_greatest_legacy_null_behavior` (default: `false`) which controls if functions `least` and `greatest` handle `NULL` arguments by unconditionally returning `NULL` (if `true`) or by ignoring them (if `false`). [#73344](https://github.com/ClickHouse/ClickHouse/pull/73344) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#73449](https://github.com/ClickHouse/ClickHouse/issues/73449): Use Keeper multi requests in cleanup thread ObjectStorageQueueMetadata. [#73357](https://github.com/ClickHouse/ClickHouse/pull/73357) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73476](https://github.com/ClickHouse/ClickHouse/issues/73476): A new MongoDB driver is now the default. Users who like to continue using the legacy driver can set server setting `use_legacy_mongodb_integration` to true. [#73359](https://github.com/ClickHouse/ClickHouse/pull/73359) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#73437](https://github.com/ClickHouse/ClickHouse/issues/73437): When ClickHouse runs under cgroup we will still collect system-wide asynchronous metrics related to system load, process scheduling, memory etc. They might provide useful signals when ClickHouse is the only process on the host with high resource consumption. [#73369](https://github.com/ClickHouse/ClickHouse/pull/73369) ([Nikita Taranov](https://github.com/nickitat)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fix possible intersecting parts for MergeTree (after moving to detached failed). [#70476](https://github.com/ClickHouse/ClickHouse/pull/70476) ([Azat Khuzhin](https://github.com/azat)).
* Disallow creation of tables with names exceeding the maximum allowed length. Previously, tables with overly long names could be created but would fail on drop; now, such tables cannot be created at all. [#70810](https://github.com/ClickHouse/ClickHouse/pull/70810) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fixed zombie processes after after library bridge crash. [#71301](https://github.com/ClickHouse/ClickHouse/pull/71301) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Fix NoSuchKey error during transaction rollback when creating a directory fails for the palin_rewritable disk. [#71439](https://github.com/ClickHouse/ClickHouse/pull/71439) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix serialization of Dynamic values in Pretty JSON formats. [#71923](https://github.com/ClickHouse/ClickHouse/pull/71923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73489](https://github.com/ClickHouse/ClickHouse/issues/73489): `RESTORE` operations for access entities required more permission than necessary because of unhandled partial revokes. This PR fixes the issue. Closes [#71853](https://github.com/ClickHouse/ClickHouse/issues/71853). [#71958](https://github.com/ClickHouse/ClickHouse/pull/71958) ([pufit](https://github.com/pufit)).
* Add inferred format name to create query in File/S3/URL/HDFS/Azure engines. Previously the format name was inferred each time the server was restarted, and if the specified data files were removed, it led to errors during server startup. [#72108](https://github.com/ClickHouse/ClickHouse/pull/72108) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix bugs when using UDF in join on expression with the old analyzer. [#72179](https://github.com/ClickHouse/ClickHouse/pull/72179) ([Raúl Marín](https://github.com/Algunenano)).
* Fixes some small bugs in `StorageObjectStorage`. Needs to enable `use_hive_partitioning` by default. [#72185](https://github.com/ClickHouse/ClickHouse/pull/72185) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix a bug where `min_age_to_force_merge_on_partition_only` was getting stuck trying to merge down the same partition repeatedly that was already merged to a single part and not merging partitions that had multiple parts. [#72209](https://github.com/ClickHouse/ClickHouse/pull/72209) ([Christoph Wurm](https://github.com/cwurm)).
* Fixed a crash in `SimpleSquashingChunksTransform` that occurred in rare cases when processing sparse columns. [#72226](https://github.com/ClickHouse/ClickHouse/pull/72226) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fixed data race in `GraceHashJoin` as the result of which some rows might be missing in the join output. [#72233](https://github.com/ClickHouse/ClickHouse/pull/72233) ([Nikita Taranov](https://github.com/nickitat)).
* Fixed `ALTER DELETE` queries with materialized `_block_number` column (if setting `enable_block_number_column` is enabled). [#72261](https://github.com/ClickHouse/ClickHouse/pull/72261) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed data race when `ColumnDynamic::dumpStructure()` is called concurrently e.g. in `ConcurrentHashJoin` constructor. [#72278](https://github.com/ClickHouse/ClickHouse/pull/72278) ([Nikita Taranov](https://github.com/nickitat)).
* Fix possible `LOGICAL_ERROR` with duplicate columns in `ORDER BY ... WITH FILL`. [#72387](https://github.com/ClickHouse/ClickHouse/pull/72387) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fixed mismatched types in several cases after applying `optimize_functions_to_subcolumns`. [#72394](https://github.com/ClickHouse/ClickHouse/pull/72394) ([Anton Popov](https://github.com/CurtizJ)).
* Use `AWS_CONTAINER_AUTHORIZATION_TOKEN_FILE` instead of `AWS_CONTAINER_AUTHORIZATION_TOKEN_PATH`. Fixes [#71074](https://github.com/ClickHouse/ClickHouse/issues/71074). [#72397](https://github.com/ClickHouse/ClickHouse/pull/72397) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix failure on parsing `BACKUP DATABASE db EXCEPT TABLES db.table` queries. [#72429](https://github.com/ClickHouse/ClickHouse/pull/72429) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Don't allow creating empty Variant. [#72454](https://github.com/ClickHouse/ClickHouse/pull/72454) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix invalid formatting of `result_part_path` in `system.merges`. [#72567](https://github.com/ClickHouse/ClickHouse/pull/72567) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix parsing a glob with one element. [#72572](https://github.com/ClickHouse/ClickHouse/pull/72572) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix query generation for the follower server in case of a distributed query with ARRAY JOIN. Fixes [#69276](https://github.com/ClickHouse/ClickHouse/issues/69276). [#72608](https://github.com/ClickHouse/ClickHouse/pull/72608) ([Dmitry Novik](https://github.com/novikd)).
* Fix a bug when DateTime64 in DateTime64 returns nothing. [#72640](https://github.com/ClickHouse/ClickHouse/pull/72640) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fixed inconsistent metadata when adding a new replica to a Replicated database that has a table created with `flatten_nested=0`. [#72685](https://github.com/ClickHouse/ClickHouse/pull/72685) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix advanced SSL configuration for Keeper's internal communication. [#72730](https://github.com/ClickHouse/ClickHouse/pull/72730) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix "No such key" error in S3Queue Unordered mode with `tracked_files_limit` setting smaller than s3 files appearance rate. [#72738](https://github.com/ClickHouse/ClickHouse/pull/72738) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Dropping mark cache might take noticeable time if it is big. If we hold context mutex during this it block many other activities, even new client connection cannot be established until it is released. And holding this mutex is not actually required for synchronization, it is enough to have a local reference to the cache via shared ptr. [#72749](https://github.com/ClickHouse/ClickHouse/pull/72749) ([Alexander Gololobov](https://github.com/davenger)).
* PK cache was heavily underestimating it's size on one of the test instances. In particular LowCardinality columns were not including dictionary size. The fix is to use column->allocatedBytes() plus some more overhead estimates for cache entry size. [#72750](https://github.com/ClickHouse/ClickHouse/pull/72750) ([Alexander Gololobov](https://github.com/davenger)).
* Fix exception thrown in RemoteQueryExecutor when user does not exist locally. [#72759](https://github.com/ClickHouse/ClickHouse/pull/72759) ([Andrey Zvonov](https://github.com/zvonand)).
* Fixed mutations with materialized `_block_number` column (if setting `enable_block_number_column` is enabled). [#72854](https://github.com/ClickHouse/ClickHouse/pull/72854) ([Anton Popov](https://github.com/CurtizJ)).
* Fix backup/restore with plain rewritable disk in case there are empty files in backup. [#72858](https://github.com/ClickHouse/ClickHouse/pull/72858) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Properly cancel inserts in DistributedAsyncInsertDirectoryQueue. [#72885](https://github.com/ClickHouse/ClickHouse/pull/72885) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixed crash while parsing of incorrect data into sparse columns (can happen with enabled setting `enable_parsing_to_custom_serialization`). [#72891](https://github.com/ClickHouse/ClickHouse/pull/72891) ([Anton Popov](https://github.com/CurtizJ)).
* Fix potential crash during backup restore. [#72947](https://github.com/ClickHouse/ClickHouse/pull/72947) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed bug in `parallel_hash` JOIN method that might appear when query has complex condition in the `ON` clause with inequality filters. [#72993](https://github.com/ClickHouse/ClickHouse/pull/72993) ([Nikita Taranov](https://github.com/nickitat)).
* Use default format settings during JSON parsing to avoid broken deserialization. [#73043](https://github.com/ClickHouse/ClickHouse/pull/73043) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix crash in transactions with unsupported storage. [#73045](https://github.com/ClickHouse/ClickHouse/pull/73045) ([Raúl Marín](https://github.com/Algunenano)).
* Fix possible overestimate memory tracking (difference between `MemoryTracking` and `MemoryResident` kept growing). [#73081](https://github.com/ClickHouse/ClickHouse/pull/73081) ([Azat Khuzhin](https://github.com/azat)).
* Check for duplicate JSON keys during Tuple parsing. Previously it could lead to logical error `Invalid number of rows in Chunk` during parsing. [#73082](https://github.com/ClickHouse/ClickHouse/pull/73082) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73500](https://github.com/ClickHouse/ClickHouse/issues/73500): Fix positive timezone formatting of formatDateTime scalar function. [#73091](https://github.com/ClickHouse/ClickHouse/pull/73091) ([ollidraese](https://github.com/ollidraese)).
* Backported in [#73429](https://github.com/ClickHouse/ClickHouse/issues/73429): Fix crash in StorageObjectStorageQueue. [#73274](https://github.com/ClickHouse/ClickHouse/pull/73274) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73413](https://github.com/ClickHouse/ClickHouse/issues/73413): Fixed filtering by `_etag` column while reading from `s3` storage and table function. [#73353](https://github.com/ClickHouse/ClickHouse/pull/73353) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73531](https://github.com/ClickHouse/ClickHouse/issues/73531): Fixed a logical error when reading from single-replica cluster with parallel replicas enabled. [#73403](https://github.com/ClickHouse/ClickHouse/pull/73403) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#73605](https://github.com/ClickHouse/ClickHouse/issues/73605): Fix ObjectStorageQueue with ZooKeeper and older Keeper. [#73420](https://github.com/ClickHouse/ClickHouse/pull/73420) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73558](https://github.com/ClickHouse/ClickHouse/issues/73558): Fix data race when creating vector similarity index. [#73517](https://github.com/ClickHouse/ClickHouse/pull/73517) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73628](https://github.com/ClickHouse/ClickHouse/issues/73628): Fixed error in function `tupleElement` which may appear in some cases for tuples with `LowCardinality` elelments and enabled setting `optimize_functions_to_subcolumns`. [#73548](https://github.com/ClickHouse/ClickHouse/pull/73548) ([Anton Popov](https://github.com/CurtizJ)).

#### Build/Testing/Packaging Improvement
* Get rid of `/etc/systemd/system/clickhouse-server.service` removal introduced in 22.3 [#39323](https://github.com/ClickHouse/ClickHouse/issues/39323). [#72259](https://github.com/ClickHouse/ClickHouse/pull/72259) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Split large translation units to avoid compilation failures due to memory/cpu limitations. [#72352](https://github.com/ClickHouse/ClickHouse/pull/72352) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* OSX: Build with ICU support. [#73083](https://github.com/ClickHouse/ClickHouse/pull/73083) ([Raúl Marín](https://github.com/Algunenano)).

#### NO CL CATEGORY

* Backported in [#73239](https://github.com/ClickHouse/ClickHouse/issues/73239):. [#72898](https://github.com/ClickHouse/ClickHouse/pull/72898) ([Sema Checherinda](https://github.com/CheSema)).

#### NO CL ENTRY

* NO CL ENTRY:  'CI: Stress test with praktika'. [#72257](https://github.com/ClickHouse/ClickHouse/pull/72257) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Short circuit optimization for functions executed over Nullable arguments"'. [#72258](https://github.com/ClickHouse/ClickHouse/pull/72258) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Resubmit [#68682](https://github.com/ClickHouse/ClickHouse/issues/68682)"'. [#72421](https://github.com/ClickHouse/ClickHouse/pull/72421) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "make d-tor Finalizer more obvious"'. [#72642](https://github.com/ClickHouse/ClickHouse/pull/72642) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Revert "make d-tor Finalizer more obvious""'. [#72654](https://github.com/ClickHouse/ClickHouse/pull/72654) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "More insistent compression in `StorageMemory`"'. [#72836](https://github.com/ClickHouse/ClickHouse/pull/72836) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Revert "Revert "make d-tor Finalizer more obvious"""'. [#72882](https://github.com/ClickHouse/ClickHouse/pull/72882) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Enable JIT compilation for more expressions"'. [#73010](https://github.com/ClickHouse/ClickHouse/pull/73010) ([Raúl Marín](https://github.com/Algunenano)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix `ListObjects` in azure blob storage. [#65691](https://github.com/ClickHouse/ClickHouse/pull/65691) ([Anton Popov](https://github.com/CurtizJ)).
* Add integration tests for Refreshable Materialized Views (mv4). [#68154](https://github.com/ClickHouse/ClickHouse/pull/68154) ([Nikita Fomichev](https://github.com/fm4v)).
* Add `chcache` util. [#70413](https://github.com/ClickHouse/ClickHouse/pull/70413) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix code in `extractObjectKeyFromURL`. [#71267](https://github.com/ClickHouse/ClickHouse/pull/71267) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Force_connected for retry resume connection establisher. [#71297](https://github.com/ClickHouse/ClickHouse/pull/71297) ([lizhuoyu5](https://github.com/lzydmxy)).
* After https://github.com/ClickHouse/ClickHouse/pull/70442 (not included in any release yet) we use new Native serialization for JSON and Dynamic, but it breaks new client - old server communication. This PR fixes it. Also add a setting `merge_tree_use_v1_object_and_dynamic_serialization` that allows to use V1 serialization in newer versions (it can be used during upgrades to new version to be able to rollback). [#71816](https://github.com/ClickHouse/ClickHouse/pull/71816) ([Pavel Kruglov](https://github.com/Avogar)).
* fix index_granularity_bytes to make test stable. [#71919](https://github.com/ClickHouse/ClickHouse/pull/71919) ([Sema Checherinda](https://github.com/CheSema)).
* Fix a problem with cast. [#72020](https://github.com/ClickHouse/ClickHouse/pull/72020) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix docker build step in CreateRelease workflow. [#72077](https://github.com/ClickHouse/ClickHouse/pull/72077) ([Max Kainov](https://github.com/maxknv)).
* CI: some adjustments to libfuzzer. [#72191](https://github.com/ClickHouse/ClickHouse/pull/72191) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Remove log message `Table is in readonly mode` while dropping a table. [#72192](https://github.com/ClickHouse/ClickHouse/pull/72192) ([Vitaly Baranov](https://github.com/vitlibar)).
* Ignore throwIf in 00002_log_and_exception_messages_formatting. [#72204](https://github.com/ClickHouse/ClickHouse/pull/72204) ([Raúl Marín](https://github.com/Algunenano)).
* Add sparse checkout to google-cloud-cpp submodule. [#72205](https://github.com/ClickHouse/ClickHouse/pull/72205) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix calculating dynamic columns sizes on vertical merge. Follow-up for https://github.com/ClickHouse/ClickHouse/pull/71526. [#72211](https://github.com/ClickHouse/ClickHouse/pull/72211) ([Pavel Kruglov](https://github.com/Avogar)).
* Remove unnecessary double compilation of some internal files. [#72216](https://github.com/ClickHouse/ClickHouse/pull/72216) ([Raúl Marín](https://github.com/Algunenano)).
* Remove some unused files from contrib deps. [#72217](https://github.com/ClickHouse/ClickHouse/pull/72217) ([Raúl Marín](https://github.com/Algunenano)).
* Update version after release. [#72218](https://github.com/ClickHouse/ClickHouse/pull/72218) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Unit tests with praktika. [#72230](https://github.com/ClickHouse/ClickHouse/pull/72230) ([Max Kainov](https://github.com/maxknv)).
* Revert "CI: Stress test with praktika". [#72231](https://github.com/ClickHouse/ClickHouse/pull/72231) ([Max Kainov](https://github.com/maxknv)).
* Enable SimSIMD on ARM with Clang 19. [#72254](https://github.com/ClickHouse/ClickHouse/pull/72254) ([Robert Schulze](https://github.com/rschu1ze)).
* Update version_date.tsv and changelog after v24.10.3.21-stable. [#72255](https://github.com/ClickHouse/ClickHouse/pull/72255) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Changelog for 24.11. [#72260](https://github.com/ClickHouse/ClickHouse/pull/72260) ([Raúl Marín](https://github.com/Algunenano)).
* Update version_date.tsv and changelog after v24.8.8.17-lts. [#72266](https://github.com/ClickHouse/ClickHouse/pull/72266) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Apply colors correctly to terminal output. [#72283](https://github.com/ClickHouse/ClickHouse/pull/72283) ([Antonio Andelic](https://github.com/antonio2368)).
* Use PreformattedMessage in S3Exception. [#72291](https://github.com/ClickHouse/ClickHouse/pull/72291) ([Raúl Marín](https://github.com/Algunenano)).
* disable a cloud setting. [#72292](https://github.com/ClickHouse/ClickHouse/pull/72292) ([Han Fei](https://github.com/hanfei1991)).
* Fix check in `test_postgresql_replica_database_engine_2`. [#72304](https://github.com/ClickHouse/ClickHouse/pull/72304) ([Nikita Taranov](https://github.com/nickitat)).
* Add some random final modifier to some classes. [#72346](https://github.com/ClickHouse/ClickHouse/pull/72346) ([alesapin](https://github.com/alesapin)).
* Remove flaky test test_move_shared_lock_fail_keeper_unavailable and extend the stable one. [#72357](https://github.com/ClickHouse/ClickHouse/pull/72357) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Enable clang-tidy `bugprone-reserved-identifier`. [#72360](https://github.com/ClickHouse/ClickHouse/pull/72360) ([Robert Schulze](https://github.com/rschu1ze)).
* 24.11 changelog missing entries and changes. [#72379](https://github.com/ClickHouse/ClickHouse/pull/72379) ([Raúl Marín](https://github.com/Algunenano)).
* Fix typo in intersect.md. [#72381](https://github.com/ClickHouse/ClickHouse/pull/72381) ([Nikita Taranov](https://github.com/nickitat)).
* fix finalize/cancel write buffers. [#72386](https://github.com/ClickHouse/ClickHouse/pull/72386) ([Sema Checherinda](https://github.com/CheSema)).
* Fix data race in Squashing with LowCardinality. [#72392](https://github.com/ClickHouse/ClickHouse/pull/72392) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix ANY JOIN with parallel replicas. [#72393](https://github.com/ClickHouse/ClickHouse/pull/72393) ([Igor Nikonov](https://github.com/devcrafter)).
* make d-tor Finalizer more obvious. [#72395](https://github.com/ClickHouse/ClickHouse/pull/72395) ([Sema Checherinda](https://github.com/CheSema)).
* make operations_to_execute as shared ptr. [#72400](https://github.com/ClickHouse/ClickHouse/pull/72400) ([Sema Checherinda](https://github.com/CheSema)).
* Better error message on bad keeper snapshots. [#72402](https://github.com/ClickHouse/ClickHouse/pull/72402) ([Raúl Marín](https://github.com/Algunenano)).
* Fix uncaught exception in ScatteredBlock. [#72405](https://github.com/ClickHouse/ClickHouse/pull/72405) ([Nikita Taranov](https://github.com/nickitat)).
* Do not load index in `mergeTreeIndex` table function if not needed. [#72407](https://github.com/ClickHouse/ClickHouse/pull/72407) ([Anton Popov](https://github.com/CurtizJ)).
* ABORT_ON_LOGICAL_ERROR was removed in favor of DEBUG_OR_SANITIZER_BUILD. [#72425](https://github.com/ClickHouse/ClickHouse/pull/72425) ([Raúl Marín](https://github.com/Algunenano)).
* Fix adding a garbage `'=1:19.1.4~*'` file. [#72432](https://github.com/ClickHouse/ClickHouse/pull/72432) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Rename allowed_feature_tier to allow_feature_tier. [#72455](https://github.com/ClickHouse/ClickHouse/pull/72455) ([Raúl Marín](https://github.com/Algunenano)).
* Remove duplicate checks of clang-tidy `bugprone-reserved-identifier`. [#72457](https://github.com/ClickHouse/ClickHouse/pull/72457) ([Robert Schulze](https://github.com/rschu1ze)).
* Resubmit [#68682](https://github.com/ClickHouse/ClickHouse/issues/68682), att2. [#72460](https://github.com/ClickHouse/ClickHouse/pull/72460) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Randomize settings for primary key cache. [#72479](https://github.com/ClickHouse/ClickHouse/pull/72479) ([Anton Popov](https://github.com/CurtizJ)).
* Update version_date.tsv and changelog after v24.11.1.2557-stable. [#72495](https://github.com/ClickHouse/ClickHouse/pull/72495) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Backported in [#73251](https://github.com/ClickHouse/ClickHouse/issues/73251): Fix: threesome joins with parallel replicas. [#72510](https://github.com/ClickHouse/ClickHouse/pull/72510) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix data race in `ProfileEvents::Counters::setParent()`. This PR fixes [#60376](https://github.com/ClickHouse/ClickHouse/issues/60376). [#72518](https://github.com/ClickHouse/ClickHouse/pull/72518) ([Vitaly Baranov](https://github.com/vitlibar)).
* SettingsChangesHistory: disable allow_experimental_shared_set_join. [#72519](https://github.com/ClickHouse/ClickHouse/pull/72519) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Remove functional tests with hdfs. [#72531](https://github.com/ClickHouse/ClickHouse/pull/72531) ([Max Kainov](https://github.com/maxknv)).
* fix async insert in TCP. [#72545](https://github.com/ClickHouse/ClickHouse/pull/72545) ([Sema Checherinda](https://github.com/CheSema)).
* Improve praktika imports. [#72546](https://github.com/ClickHouse/ClickHouse/pull/72546) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Increase timeout in `test_short_disconnection_doesnt_stop_restore` (see failures: [1](https://s3.amazonaws.com/clickhouse-test-reports/0/22c961c684e32221f32fa18570f12e158f70a039/integration_tests__asan__[2_4].html), [2](https://s3.amazonaws.com/clickhouse-test-reports/0/7c3d015113b0a45b2c75d5244bf12b7099ecbfea/integration_tests__asan__[2_4].html)). Fixes [#72388](https://github.com/ClickHouse/ClickHouse/issues/72388). [#72552](https://github.com/ClickHouse/ClickHouse/pull/72552) ([Vitaly Baranov](https://github.com/vitlibar)).
* Devirtualize serialize call in AggregateFunction. [#72556](https://github.com/ClickHouse/ClickHouse/pull/72556) ([alesapin](https://github.com/alesapin)).
* Fix possible CI failures due to slow logs proxy tables shutdown. [#72558](https://github.com/ClickHouse/ClickHouse/pull/72558) ([Azat Khuzhin](https://github.com/azat)).
* Fix 03167_improvement_table_name_too_long. [#72566](https://github.com/ClickHouse/ClickHouse/pull/72566) ([Nikita Taranov](https://github.com/nickitat)).
* Update README.md - Update Meetups. [#72574](https://github.com/ClickHouse/ClickHouse/pull/72574) ([Tanya Bragin](https://github.com/tbragin)).
* Update trusted contributors. [#72575](https://github.com/ClickHouse/ClickHouse/pull/72575) ([Kai Zhu](https://github.com/nauu)).
* Update NuRaft. [#72584](https://github.com/ClickHouse/ClickHouse/pull/72584) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix data race in Squashing with ColumnConst. [#72586](https://github.com/ClickHouse/ClickHouse/pull/72586) ([Vladimir Cherkasov](https://github.com/vdimir)).
* fix pipeline cancelation. [#72587](https://github.com/ClickHouse/ClickHouse/pull/72587) ([Sema Checherinda](https://github.com/CheSema)).
* Revert "Merge pull request [#65488](https://github.com/ClickHouse/ClickHouse/issues/65488) from zvonand/zvonand-ttl". [#72599](https://github.com/ClickHouse/ClickHouse/pull/72599) ([Anton Popov](https://github.com/CurtizJ)).
* Fix inaccurate `MemoryTracking` metric in case of allocation failures. [#72603](https://github.com/ClickHouse/ClickHouse/pull/72603) ([Azat Khuzhin](https://github.com/azat)).
* Fix data race in prewarm of mark cache. [#72611](https://github.com/ClickHouse/ClickHouse/pull/72611) ([Anton Popov](https://github.com/CurtizJ)).
* Remove flaky test_page_cache. [#72613](https://github.com/ClickHouse/ClickHouse/pull/72613) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix tests for `SYSTEM LOAD PRIMARY KEY`. [#72615](https://github.com/ClickHouse/ClickHouse/pull/72615) ([Anton Popov](https://github.com/CurtizJ)).
* Excessive logging might consume noticeable time. Let's track it. [#72643](https://github.com/ClickHouse/ClickHouse/pull/72643) ([Alexander Gololobov](https://github.com/davenger)).
* Better prewarm of mark and primary index caches. [#72651](https://github.com/ClickHouse/ClickHouse/pull/72651) ([Anton Popov](https://github.com/CurtizJ)).
* Fix formatting in InterpreterCreateQuery.cpp. [#72655](https://github.com/ClickHouse/ClickHouse/pull/72655) ([Vitaly Baranov](https://github.com/vitlibar)).
* Safer Field::safeGet?. [#72659](https://github.com/ClickHouse/ClickHouse/pull/72659) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Align PR setting changes history with 24.10. [#72706](https://github.com/ClickHouse/ClickHouse/pull/72706) ([Igor Nikonov](https://github.com/devcrafter)).
* Remove heavy header from WriteHelpers.h. [#72715](https://github.com/ClickHouse/ClickHouse/pull/72715) ([Raúl Marín](https://github.com/Algunenano)).
* Improve build of AggregateFunctionAvgWeighted.cpp. [#72716](https://github.com/ClickHouse/ClickHouse/pull/72716) ([Raúl Marín](https://github.com/Algunenano)).
* Remove some nested includes. [#72722](https://github.com/ClickHouse/ClickHouse/pull/72722) ([Raúl Marín](https://github.com/Algunenano)).
* Remove `ostr` from structure `IAST::FormatSettings`. This is part 1 of https://github.com/ClickHouse/ClickHouse/pull/45649. [#72723](https://github.com/ClickHouse/ClickHouse/pull/72723) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix clickhouse-test reporting 'No tests were run' after running tests. [#72731](https://github.com/ClickHouse/ClickHouse/pull/72731) ([Michael Kolupaev](https://github.com/al13n321)).
* add a check to debug LOGICAL ERROR of dictionary update. [#72734](https://github.com/ClickHouse/ClickHouse/pull/72734) ([Han Fei](https://github.com/hanfei1991)).
* Fix potential `Context has expired` error for Y-shaped JOIN. Was triggered in [#71429](https://github.com/ClickHouse/ClickHouse/issues/71429). [#72735](https://github.com/ClickHouse/ClickHouse/pull/72735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add dmesg outptut for the case of build failure. [#72736](https://github.com/ClickHouse/ClickHouse/pull/72736) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* We encountered problem that sometimes link to Context in a Source dies earlier than Source itself, which leads to logical error. In this we replace weak_ptr to context to shared_ptr to prevent this. [#72746](https://github.com/ClickHouse/ClickHouse/pull/72746) ([Daniil Ivanik](https://github.com/divanik)).
* Extract QueryPlan steps serialization from [#69652](https://github.com/ClickHouse/ClickHouse/issues/69652). [#72747](https://github.com/ClickHouse/ClickHouse/pull/72747) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* More insistent compression in `StorageMemory`. [#72770](https://github.com/ClickHouse/ClickHouse/pull/72770) ([Nikita Taranov](https://github.com/nickitat)).
* Make the List Blob Azure work regardless if the endpoint has a trailing slash or not. [#72791](https://github.com/ClickHouse/ClickHouse/pull/72791) ([Francesco Ciocchetti](https://github.com/primeroz)).
* Use TeePopen to get the integration tests output during run; Add `TeePopen.terminate` method. [#72793](https://github.com/ClickHouse/ClickHouse/pull/72793) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Workaround flakiness in `02812_from_to_utc_timestamp`. [#72797](https://github.com/ClickHouse/ClickHouse/pull/72797) ([Nikita Taranov](https://github.com/nickitat)).
* Cloud test. [#72800](https://github.com/ClickHouse/ClickHouse/pull/72800) ([Raúl Marín](https://github.com/Algunenano)).
* Remove more nested includes. [#72812](https://github.com/ClickHouse/ClickHouse/pull/72812) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73289](https://github.com/ClickHouse/ClickHouse/issues/73289): fix clickhouse_driver inserts. [#72813](https://github.com/ClickHouse/ClickHouse/pull/72813) ([Sema Checherinda](https://github.com/CheSema)).
* This should improve situations when marks cache is full and tasks from cancelled queries keep thrashing it. [#72814](https://github.com/ClickHouse/ClickHouse/pull/72814) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#73205](https://github.com/ClickHouse/ClickHouse/issues/73205): output format does not write to the canceled buffer. [#72815](https://github.com/ClickHouse/ClickHouse/pull/72815) ([Sema Checherinda](https://github.com/CheSema)).
* Disable test with distributed cache. [#72820](https://github.com/ClickHouse/ClickHouse/pull/72820) ([Anton Popov](https://github.com/CurtizJ)).
* Fix segfault in `CascadeWriteBuffer::getResultBuffers()`. [#72834](https://github.com/ClickHouse/ClickHouse/pull/72834) ([Vitaly Baranov](https://github.com/vitlibar)).
* Attempt to prevent the runner's sudden death on OOMs. [#72835](https://github.com/ClickHouse/ClickHouse/pull/72835) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* setup_minio: Do not add aws credentials twice. [#72857](https://github.com/ClickHouse/ClickHouse/pull/72857) ([Nikita Fomichev](https://github.com/fm4v)).
* Update README.md - Update meetups. [#72871](https://github.com/ClickHouse/ClickHouse/pull/72871) ([Tanya Bragin](https://github.com/tbragin)).
* Follow up to [#72858](https://github.com/ClickHouse/ClickHouse/issues/72858). [#72884](https://github.com/ClickHouse/ClickHouse/pull/72884) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Docs: Follow-up to [#71441](https://github.com/ClickHouse/ClickHouse/issues/71441). [#72889](https://github.com/ClickHouse/ClickHouse/pull/72889) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix flaky 03271_ghdata_object_to_json_alter test. [#72890](https://github.com/ClickHouse/ClickHouse/pull/72890) ([Pavel Kruglov](https://github.com/Avogar)).
* Docs: Fix data type links. [#72894](https://github.com/ClickHouse/ClickHouse/pull/72894) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix flaky test. [#72896](https://github.com/ClickHouse/ClickHouse/pull/72896) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update next community call. [#72937](https://github.com/ClickHouse/ClickHouse/pull/72937) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73350](https://github.com/ClickHouse/ClickHouse/issues/73350): Remove needless code duplication between `arrayROCAUC` and `arrrayAUCPR`. [#72950](https://github.com/ClickHouse/ClickHouse/pull/72950) ([Emmanuel](https://github.com/emmanuelsdias)).
* Try fix `01290_max_execution_speed_distributed`. [#72951](https://github.com/ClickHouse/ClickHouse/pull/72951) ([Nikita Taranov](https://github.com/nickitat)).
* Use absl::Mutex instead of std::shared_mutex on non-Linux OSs. [#72969](https://github.com/ClickHouse/ClickHouse/pull/72969) ([Raúl Marín](https://github.com/Algunenano)).
* Better PG Empty Array Prompt. [#72990](https://github.com/ClickHouse/ClickHouse/pull/72990) ([Shichao Jin](https://github.com/jsc0218)).
* Revert "Add total_bytes_with_inactive to system.tables". [#72992](https://github.com/ClickHouse/ClickHouse/pull/72992) ([Robert Schulze](https://github.com/rschu1ze)).
* We encountered a problem that some Iceberg writers write optional field identifier-field-ids inconsistently in different places (metadata json file and manifest file e.g). So this pr checks only table schema as it is without any other fields. [#73001](https://github.com/ClickHouse/ClickHouse/pull/73001) ([Daniil Ivanik](https://github.com/divanik)).
* Fix flakiness of 01319_query_formatting_in_server_log.sql. [#73013](https://github.com/ClickHouse/ClickHouse/pull/73013) ([Raúl Marín](https://github.com/Algunenano)).
* Add tests for some mutations with enabled column `_block_number`. [#73017](https://github.com/ClickHouse/ClickHouse/pull/73017) ([Anton Popov](https://github.com/CurtizJ)).
* Preallocate queue buffer to the same size as it was before flush. [#73049](https://github.com/ClickHouse/ClickHouse/pull/73049) ([Alexander Gololobov](https://github.com/davenger)).
* remove commented code. [#73080](https://github.com/ClickHouse/ClickHouse/pull/73080) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73285](https://github.com/ClickHouse/ClickHouse/issues/73285): Mark server setting `use_legacy_mongodb_integration` as obsolete. [#73253](https://github.com/ClickHouse/ClickHouse/pull/73253) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#73384](https://github.com/ClickHouse/ClickHouse/issues/73384): Fix bug in global join without key. [#73269](https://github.com/ClickHouse/ClickHouse/pull/73269) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#73308](https://github.com/ClickHouse/ClickHouse/issues/73308): fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73396](https://github.com/ClickHouse/ClickHouse/issues/73396): Remove unused and confusing setting. [#73368](https://github.com/ClickHouse/ClickHouse/pull/73368) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73514](https://github.com/ClickHouse/ClickHouse/issues/73514): Make the delimiter as a second argument for `groupConcat`. [#73380](https://github.com/ClickHouse/ClickHouse/pull/73380) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#73577](https://github.com/ClickHouse/ClickHouse/issues/73577): Sync Google Cloud config. [#73545](https://github.com/ClickHouse/ClickHouse/pull/73545) ([Pablo Marcos](https://github.com/pamarcos)).

