---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.10.4.191-stable (927d50586cd) FIXME as compared to v24.10.3.21-stable (e668b927efb)

#### Backward Incompatible Change
* Backported in [#72865](https://github.com/ClickHouse/ClickHouse/issues/72865): The table engines Kafka, NATS and RabbitMQ are now covered by their own grants in the `SOURCES` hierarchy. Add grants to any non-default database users that create tables with these engine types. [#71250](https://github.com/ClickHouse/ClickHouse/pull/71250) ([Christoph Wurm](https://github.com/cwurm)).

#### New Feature
* Backported in [#74317](https://github.com/ClickHouse/ClickHouse/issues/74317): When `min_age_to_force_merge_seconds` and `min_age_to_force_merge_on_partition_only` are both enabled, the part merging will ignore the max bytes limit. [#73656](https://github.com/ClickHouse/ClickHouse/pull/73656) ([Kai Zhu](https://github.com/nauu)).

#### Performance Improvement
* Backported in [#72595](https://github.com/ClickHouse/ClickHouse/issues/72595): During query execution with parallel replicas and enabled local plan, skip index analysis on workers. The coordinator will choose ranges to read for workers based on index analysis on its side (on query initiator). [#72109](https://github.com/ClickHouse/ClickHouse/pull/72109) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73033](https://github.com/ClickHouse/ClickHouse/issues/73033): Bring back optimization for reading subcolumns of single column in Compact parts from https://github.com/ClickHouse/ClickHouse/pull/57631. It was deleted accidentally. [#72285](https://github.com/ClickHouse/ClickHouse/pull/72285) ([Pavel Kruglov](https://github.com/Avogar)).

#### Improvement
* Backported in [#73565](https://github.com/ClickHouse/ClickHouse/issues/73565): Fix the issue where ClickHouse in Docker containers printed "get_mempolicy: Operation not permitted" into stderr due to restricted syscalls. [#70900](https://github.com/ClickHouse/ClickHouse/pull/70900) ([filimonov](https://github.com/filimonov)).
* Backported in [#73242](https://github.com/ClickHouse/ClickHouse/issues/73242): The methods `removeObject` and `removeObjects` are not idempotent. When retries happen due to network errors, the result could be `object not found` because it has been deleted at previous attempts. [#71529](https://github.com/ClickHouse/ClickHouse/pull/71529) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72758](https://github.com/ClickHouse/ClickHouse/issues/72758): The problem is [described here](https://github.com/ClickHouse/ClickHouse/issues/72091). Azure Iceberg Writer creates Iceberg metadata files (as well as manifest files) that violate specs. In this PR I added an attempt to read v1 iceberg format metadata with v2 reader (cause they write it in a this way), and added error when they didn't create corresponding fields in a manifest file. [#72277](https://github.com/ClickHouse/ClickHouse/pull/72277) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#72675](https://github.com/ClickHouse/ClickHouse/issues/72675): Better memory usage approximation of cached marks to reduce total memory usage of the cache. [#72630](https://github.com/ClickHouse/ClickHouse/pull/72630) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73063](https://github.com/ClickHouse/ClickHouse/issues/73063): Support parsing GCS S3 error `AuthenticationRequired`. [#72753](https://github.com/ClickHouse/ClickHouse/pull/72753) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#73055](https://github.com/ClickHouse/ClickHouse/issues/73055): Add S3 request settings `http_max_fields`, `http_max_field_name_size`, `http_max_field_value_size` and use them while parsing S3 API responses during making a backup or restoring. [#72778](https://github.com/ClickHouse/ClickHouse/pull/72778) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#73453](https://github.com/ClickHouse/ClickHouse/issues/73453): Use Keeper multi requests in cleanup thread ObjectStorageQueueMetadata. [#73357](https://github.com/ClickHouse/ClickHouse/pull/73357) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#72414](https://github.com/ClickHouse/ClickHouse/issues/72414): The parts deduplicated during `ATTACH PART` query don't get stuck with the `attaching_` prefix anymore. [#65636](https://github.com/ClickHouse/ClickHouse/pull/65636) ([Kirill](https://github.com/kirillgarbar)).
* Backported in [#73007](https://github.com/ClickHouse/ClickHouse/issues/73007): Fixed zombie processes after after library bridge crash. [#71301](https://github.com/ClickHouse/ClickHouse/pull/71301) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#73140](https://github.com/ClickHouse/ClickHouse/issues/73140): Fix error column "attgenerated" does not exist for old PostgreSQL, fix [#60651](https://github.com/ClickHouse/ClickHouse/issues/60651). [#71396](https://github.com/ClickHouse/ClickHouse/pull/71396) ([0xMihalich](https://github.com/0xMihalich)).
* Backported in [#72725](https://github.com/ClickHouse/ClickHouse/issues/72725): Fix NoSuchKey error during transaction rollback when creating a directory fails for the palin_rewritable disk. [#71439](https://github.com/ClickHouse/ClickHouse/pull/71439) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#72172](https://github.com/ClickHouse/ClickHouse/issues/72172): Fix counting column size in wide part for Dynamic and JSON types. [#71526](https://github.com/ClickHouse/ClickHouse/pull/71526) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72273](https://github.com/ClickHouse/ClickHouse/issues/72273): Fix serialization of Dynamic values in Pretty JSON formats. [#71923](https://github.com/ClickHouse/ClickHouse/pull/71923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73367](https://github.com/ClickHouse/ClickHouse/issues/73367): Fixed case when `s3`/`s3Cluster` functions could return incomplete result or throw an exception. It involved using glob pattern in s3 uri (like `pattern/*`) and an empty object should exist with the key `pattern/` (such objects automatically created by S3 Console). Also default value for setting `s3_skip_empty_files` changed from `false` to `true` by default. [#71947](https://github.com/ClickHouse/ClickHouse/pull/71947) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#73485](https://github.com/ClickHouse/ClickHouse/issues/73485): `RESTORE` operations for access entities required more permission than necessary because of unhandled partial revokes. This PR fixes the issue. Closes [#71853](https://github.com/ClickHouse/ClickHouse/issues/71853). [#71958](https://github.com/ClickHouse/ClickHouse/pull/71958) ([pufit](https://github.com/pufit)).
* Backported in [#72159](https://github.com/ClickHouse/ClickHouse/issues/72159): Allow only SELECT queries in EXPLAIN AST used inside subquery. Other types of queries lead to logical error: 'Bad cast from type DB::ASTCreateQuery to DB::ASTSelectWithUnionQuery' or `Inconsistent AST formatting`. [#71982](https://github.com/ClickHouse/ClickHouse/pull/71982) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74156](https://github.com/ClickHouse/ClickHouse/issues/74156): Avoid pause after `ALTER TABLE REPLACE/MOVE PARTITION FROM/TO TABLE`. Retrieve correct settings for background task scheduling. [#72024](https://github.com/ClickHouse/ClickHouse/pull/72024) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#72118](https://github.com/ClickHouse/ClickHouse/issues/72118): Fix formatting of `MOVE PARTITION ... TO TABLE ...` alter commands when `format_alter_commands_with_parentheses` is enabled. [#72080](https://github.com/ClickHouse/ClickHouse/pull/72080) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#73375](https://github.com/ClickHouse/ClickHouse/issues/73375): Add inferred format name to create query in File/S3/URL/HDFS/Azure engines. Previously the format name was inferred each time the server was restarted, and if the specified data files were removed, it led to errors during server startup. [#72108](https://github.com/ClickHouse/ClickHouse/pull/72108) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72301](https://github.com/ClickHouse/ClickHouse/issues/72301): Fix bugs when using UDF in join on expression with the old analyzer. [#72179](https://github.com/ClickHouse/ClickHouse/pull/72179) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#72243](https://github.com/ClickHouse/ClickHouse/issues/72243): Fix a bug where `min_age_to_force_merge_on_partition_only` was getting stuck trying to merge down the same partition repeatedly that was already merged to a single part and not merging partitions that had multiple parts. [#72209](https://github.com/ClickHouse/ClickHouse/pull/72209) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#73735](https://github.com/ClickHouse/ClickHouse/issues/73735): Fixed a crash in `SimpleSquashingChunksTransform` that occurred in rare cases when processing sparse columns. [#72226](https://github.com/ClickHouse/ClickHouse/pull/72226) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#72327](https://github.com/ClickHouse/ClickHouse/issues/72327): Fixed data race in `GraceHashJoin` as the result of which some rows might be missing in the join output. [#72233](https://github.com/ClickHouse/ClickHouse/pull/72233) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72370](https://github.com/ClickHouse/ClickHouse/issues/72370): Fixed `ALTER DELETE` queries with materialized `_block_number` column (if setting `enable_block_number_column` is enabled). [#72261](https://github.com/ClickHouse/ClickHouse/pull/72261) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72316](https://github.com/ClickHouse/ClickHouse/issues/72316): Fixed data race when `ColumnDynamic::dumpStructure()` is called concurrently e.g. in `ConcurrentHashJoin` constructor. [#72278](https://github.com/ClickHouse/ClickHouse/pull/72278) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72527](https://github.com/ClickHouse/ClickHouse/issues/72527): Fixed mismatched types in several cases after applying `optimize_functions_to_subcolumns`. [#72394](https://github.com/ClickHouse/ClickHouse/pull/72394) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72506](https://github.com/ClickHouse/ClickHouse/issues/72506): Fix failure on parsing `BACKUP DATABASE db EXCEPT TABLES db.table` queries. [#72429](https://github.com/ClickHouse/ClickHouse/pull/72429) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72954](https://github.com/ClickHouse/ClickHouse/issues/72954): Don't allow creating empty Variant. [#72454](https://github.com/ClickHouse/ClickHouse/pull/72454) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72712](https://github.com/ClickHouse/ClickHouse/issues/72712): Fix parsing a glob with one element. [#72572](https://github.com/ClickHouse/ClickHouse/pull/72572) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72930](https://github.com/ClickHouse/ClickHouse/issues/72930): Fix query generation for the follower server in case of a distributed query with ARRAY JOIN. Fixes [#69276](https://github.com/ClickHouse/ClickHouse/issues/69276). [#72608](https://github.com/ClickHouse/ClickHouse/pull/72608) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#72850](https://github.com/ClickHouse/ClickHouse/issues/72850): Fixed inconsistent metadata when adding a new replica to a Replicated database that has a table created with `flatten_nested=0`. [#72685](https://github.com/ClickHouse/ClickHouse/pull/72685) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#72785](https://github.com/ClickHouse/ClickHouse/issues/72785): Fix advanced SSL configuration for Keeper's internal communication. [#72730](https://github.com/ClickHouse/ClickHouse/pull/72730) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73024](https://github.com/ClickHouse/ClickHouse/issues/73024): Fixed mutations with materialized `_block_number` column (if setting `enable_block_number_column` is enabled). [#72854](https://github.com/ClickHouse/ClickHouse/pull/72854) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73318](https://github.com/ClickHouse/ClickHouse/issues/73318): Fix the situation when a user can't run `REVOKE ALL ON *.*` because of implicit grants in the target access entity. [#72872](https://github.com/ClickHouse/ClickHouse/pull/72872) ([pufit](https://github.com/pufit)).
* Backported in [#72912](https://github.com/ClickHouse/ClickHouse/issues/72912): Fixed crash while parsing of incorrect data into sparse columns (can happen with enabled setting `enable_parsing_to_custom_serialization`). [#72891](https://github.com/ClickHouse/ClickHouse/pull/72891) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72983](https://github.com/ClickHouse/ClickHouse/issues/72983): Fix potential crash during backup restore. [#72947](https://github.com/ClickHouse/ClickHouse/pull/72947) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73159](https://github.com/ClickHouse/ClickHouse/issues/73159): Fix crash in transactions with unsupported storage. [#73045](https://github.com/ClickHouse/ClickHouse/pull/73045) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73128](https://github.com/ClickHouse/ClickHouse/issues/73128): Fix possible overestimate memory tracking (difference between `MemoryTracking` and `MemoryResident` kept growing). [#73081](https://github.com/ClickHouse/ClickHouse/pull/73081) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#73110](https://github.com/ClickHouse/ClickHouse/issues/73110): Check for duplicate JSON keys during Tuple parsing. Previously it could lead to logical error `Invalid number of rows in Chunk` during parsing. [#73082](https://github.com/ClickHouse/ClickHouse/pull/73082) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73496](https://github.com/ClickHouse/ClickHouse/issues/73496): Fix positive timezone formatting of formatDateTime scalar function. [#73091](https://github.com/ClickHouse/ClickHouse/pull/73091) ([ollidraese](https://github.com/ollidraese)).
* Backported in [#74141](https://github.com/ClickHouse/ClickHouse/issues/74141): Propagate format settings to NativeWriter in TCPHandler, so settings like `output_format_native_write_json_as_string` are applied correctly. [#73179](https://github.com/ClickHouse/ClickHouse/pull/73179) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73559](https://github.com/ClickHouse/ClickHouse/issues/73559): Fix crash in StorageObjectStorageQueue. [#73274](https://github.com/ClickHouse/ClickHouse/pull/73274) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73409](https://github.com/ClickHouse/ClickHouse/issues/73409): Fixed filtering by `_etag` column while reading from `s3` storage and table function. [#73353](https://github.com/ClickHouse/ClickHouse/pull/73353) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73891](https://github.com/ClickHouse/ClickHouse/issues/73891): Fix preparing for squashin for Dynamic and JSON columns. Previously in some cases new types could be inserted into shared variant/shared data even when the limit on types/paths is not reached. [#73388](https://github.com/ClickHouse/ClickHouse/pull/73388) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73527](https://github.com/ClickHouse/ClickHouse/issues/73527): Fixed a logical error when reading from single-replica cluster with parallel replicas enabled. [#73403](https://github.com/ClickHouse/ClickHouse/pull/73403) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#73601](https://github.com/ClickHouse/ClickHouse/issues/73601): Fix ObjectStorageQueue with ZooKeeper and older Keeper. [#73420](https://github.com/ClickHouse/ClickHouse/pull/73420) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73578](https://github.com/ClickHouse/ClickHouse/issues/73578): Fix data race when creating vector similarity index. [#73517](https://github.com/ClickHouse/ClickHouse/pull/73517) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#74437](https://github.com/ClickHouse/ClickHouse/issues/74437): Fixes segfault when the source of the dictionary contains a function with wrong data. [#73535](https://github.com/ClickHouse/ClickHouse/pull/73535) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#73624](https://github.com/ClickHouse/ClickHouse/issues/73624): Fixed error in function `tupleElement` which may appear in some cases for tuples with `LowCardinality` elelments and enabled setting `optimize_functions_to_subcolumns`. [#73548](https://github.com/ClickHouse/ClickHouse/pull/73548) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73761](https://github.com/ClickHouse/ClickHouse/issues/73761): Fix parsing enum glob followed by range one. Fixes [#73473](https://github.com/ClickHouse/ClickHouse/issues/73473). [#73569](https://github.com/ClickHouse/ClickHouse/pull/73569) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#73815](https://github.com/ClickHouse/ClickHouse/issues/73815): Fixed parallel_replicas_for_non_replicated_merge_tree being ignored in subqueries for non-replicated tables. [#73584](https://github.com/ClickHouse/ClickHouse/pull/73584) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73677](https://github.com/ClickHouse/ClickHouse/issues/73677): Do not interpret queries in `EXPLAIN SYNTAX` to avoid logical errors with incorrect processing stage for distributed queries. Fixes [#65205](https://github.com/ClickHouse/ClickHouse/issues/65205). [#73634](https://github.com/ClickHouse/ClickHouse/pull/73634) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#74140](https://github.com/ClickHouse/ClickHouse/issues/74140): Fix possible data inconsistency in Dynamic column. Fixes possible logical error `Nested columns sizes are inconsistent with local_discriminators column size`. [#73644](https://github.com/ClickHouse/ClickHouse/pull/73644) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73731](https://github.com/ClickHouse/ClickHouse/issues/73731): Fix crash in LIMIT BY COLUMNS. [#73686](https://github.com/ClickHouse/ClickHouse/pull/73686) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#74025](https://github.com/ClickHouse/ClickHouse/issues/74025): Fix deserialization of Dynamic/Object structure. It could lead to CANNOT_READ_ALL_DATA exceptions. [#73767](https://github.com/ClickHouse/ClickHouse/pull/73767) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74096](https://github.com/ClickHouse/ClickHouse/issues/74096): Fixes [#72078](https://github.com/ClickHouse/ClickHouse/issues/72078) ( S3 Express Support was broken ). [#73777](https://github.com/ClickHouse/ClickHouse/pull/73777) ([Sameer Tamsekar](https://github.com/stamsekar)).
* Backported in [#74040](https://github.com/ClickHouse/ClickHouse/issues/74040): Fix high memory usage during nested Maps creation. [#73982](https://github.com/ClickHouse/ClickHouse/pull/73982) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74053](https://github.com/ClickHouse/ClickHouse/issues/74053): Fix: alias can be not added to the projection if it is referenced by another alias and selected in inverse order. [#74033](https://github.com/ClickHouse/ClickHouse/pull/74033) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#74106](https://github.com/ClickHouse/ClickHouse/issues/74106): A disk using the plain_rewritable metadata can be shared among multiple server instances. It is expected for one instance to read a metadata object while another modifies it. Object not found errors are ignored during plain_rewritable initialization with Azure storage, similar to the behavior implemented for S3. [#74059](https://github.com/ClickHouse/ClickHouse/pull/74059) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#74132](https://github.com/ClickHouse/ClickHouse/issues/74132): Fixes case when the user specifies keyword arguments in the kafka table engine. [#74064](https://github.com/ClickHouse/ClickHouse/pull/74064) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#74175](https://github.com/ClickHouse/ClickHouse/issues/74175): Fix crash when reading a subcolumn from the compressed Memory engine table. Fixes [#74009](https://github.com/ClickHouse/ClickHouse/issues/74009). [#74161](https://github.com/ClickHouse/ClickHouse/pull/74161) ([Nikita Taranov](https://github.com/nickitat)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#72488](https://github.com/ClickHouse/ClickHouse/issues/72488): Fix flaky test 03262_column_sizes_with_dynamic_structure. [#71931](https://github.com/ClickHouse/ClickHouse/pull/71931) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73195](https://github.com/ClickHouse/ClickHouse/issues/73195): fix cancelation for PartitionedSink. [#72126](https://github.com/ClickHouse/ClickHouse/pull/72126) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72223](https://github.com/ClickHouse/ClickHouse/issues/72223): Fixed a test which was flaky-flaky. [#72147](https://github.com/ClickHouse/ClickHouse/pull/72147) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#72253](https://github.com/ClickHouse/ClickHouse/issues/72253): Add sparse checkout to google-cloud-cpp submodule. [#72205](https://github.com/ClickHouse/ClickHouse/pull/72205) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#72745](https://github.com/ClickHouse/ClickHouse/issues/72745): Fix calculating dynamic columns sizes on vertical merge. Follow-up for https://github.com/ClickHouse/ClickHouse/pull/71526. [#72211](https://github.com/ClickHouse/ClickHouse/pull/72211) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72478](https://github.com/ClickHouse/ClickHouse/issues/72478): Remove flaky test test_move_shared_lock_fail_keeper_unavailable and extend the stable one. [#72357](https://github.com/ClickHouse/ClickHouse/pull/72357) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#73229](https://github.com/ClickHouse/ClickHouse/issues/73229): fix finalize/cancel write buffers. [#72386](https://github.com/ClickHouse/ClickHouse/pull/72386) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72561](https://github.com/ClickHouse/ClickHouse/issues/72561): Fix ANY JOIN with parallel replicas. [#72393](https://github.com/ClickHouse/ClickHouse/pull/72393) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#72450](https://github.com/ClickHouse/ClickHouse/issues/72450): make operations_to_execute as shared ptr. [#72400](https://github.com/ClickHouse/ClickHouse/pull/72400) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73246](https://github.com/ClickHouse/ClickHouse/issues/73246): Fix: threesome joins with parallel replicas. [#72510](https://github.com/ClickHouse/ClickHouse/pull/72510) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73462](https://github.com/ClickHouse/ClickHouse/issues/73462): Fix data race in `ProfileEvents::Counters::setParent()`. This PR fixes [#60376](https://github.com/ClickHouse/ClickHouse/issues/60376). [#72518](https://github.com/ClickHouse/ClickHouse/pull/72518) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#72539](https://github.com/ClickHouse/ClickHouse/issues/72539): SettingsChangesHistory: disable allow_experimental_shared_set_join. [#72519](https://github.com/ClickHouse/ClickHouse/pull/72519) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#72679](https://github.com/ClickHouse/ClickHouse/issues/72679): Update NuRaft. [#72584](https://github.com/ClickHouse/ClickHouse/pull/72584) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#72740](https://github.com/ClickHouse/ClickHouse/issues/72740): Revert "Merge pull request [#65488](https://github.com/ClickHouse/ClickHouse/issues/65488) from zvonand/zvonand-ttl". [#72599](https://github.com/ClickHouse/ClickHouse/pull/72599) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72767](https://github.com/ClickHouse/ClickHouse/issues/72767): Fix potential `Context has expired` error for Y-shaped JOIN. Was triggered in [#71429](https://github.com/ClickHouse/ClickHouse/issues/71429). [#72735](https://github.com/ClickHouse/ClickHouse/pull/72735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#73858](https://github.com/ClickHouse/ClickHouse/issues/73858): Fix use-after-free in loadPathPrefixMap on thread pool exception. [#72870](https://github.com/ClickHouse/ClickHouse/pull/72870) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#73303](https://github.com/ClickHouse/ClickHouse/issues/73303): fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73670](https://github.com/ClickHouse/ClickHouse/issues/73670): Add a setting. [#73281](https://github.com/ClickHouse/ClickHouse/pull/73281) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73788](https://github.com/ClickHouse/ClickHouse/issues/73788): Fix if condition in [#63151](https://github.com/ClickHouse/ClickHouse/issues/63151). [#73504](https://github.com/ClickHouse/ClickHouse/pull/73504) ([Andrey Zvonov](https://github.com/zvonand)).
* Backported in [#73586](https://github.com/ClickHouse/ClickHouse/issues/73586): Sync Google Cloud config. [#73545](https://github.com/ClickHouse/ClickHouse/pull/73545) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#73751](https://github.com/ClickHouse/ClickHouse/issues/73751): Update `test_storage_s3_queue/test.py::test_upgrade(2)`. [#73607](https://github.com/ClickHouse/ClickHouse/pull/73607) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73941](https://github.com/ClickHouse/ClickHouse/issues/73941): Reverts ClickHouse/ClickHouse[#62944](https://github.com/ClickHouse/ClickHouse/issues/62944) (there was a crash in the CI because of this). [#73738](https://github.com/ClickHouse/ClickHouse/pull/73738) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#74297](https://github.com/ClickHouse/ClickHouse/issues/74297): Better error message when applying row policy. [#73739](https://github.com/ClickHouse/ClickHouse/pull/73739) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#74461](https://github.com/ClickHouse/ClickHouse/issues/74461): Make `version_helper` populated from every commit. [#74399](https://github.com/ClickHouse/ClickHouse/pull/74399) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#74488](https://github.com/ClickHouse/ClickHouse/issues/74488): Avoid special PR packet processing if PR is disabled. [#74402](https://github.com/ClickHouse/ClickHouse/pull/74402) ([Igor Nikonov](https://github.com/devcrafter)).

