---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v22.3.1.1262-prestable (92ab33f560e) FIXME as compared to v22.2.1.2139-prestable (75366fc95e5)

#### Backward Incompatible Change
* Improvement the toDatetime function overflows. When the date string is very large, it will be converted to 1970. [#32898](https://github.com/ClickHouse/ClickHouse/pull/32898) ([HaiBo Li](https://github.com/marising)).
* Make arrayCompact behave as other higher-order functions: perform compaction not of lambda function results but on original array. If you using nontrivial lambda functions in arrayCompact you may restore old behaviour by wrapping arrayCompact arguments into arrayMap. Closes [#34010](https://github.com/ClickHouse/ClickHouse/issues/34010) [#18535](https://github.com/ClickHouse/ClickHouse/issues/18535) [#14778](https://github.com/ClickHouse/ClickHouse/issues/14778). [#34795](https://github.com/ClickHouse/ClickHouse/pull/34795) ([Alexandre Snarskii](https://github.com/snar)).

#### New Feature
* New data type `Object(<schema_format>)`, which supports storing of semi-structured data (for now JSON only). Data is written to such types as string. Then all paths are extracted according to format of semi-structured data and written as separate columns in most optimal types, that can store all their values. Those columns can be queried by names that match paths in source data. E.g `data.key1.key2` or with cast operator `data.key1.key2::Int64`. [#23932](https://github.com/ClickHouse/ClickHouse/pull/23932) ([Anton Popov](https://github.com/CurtizJ)).
* Support authentication of users connected via SSL by their X.509 certificate. [#31484](https://github.com/ClickHouse/ClickHouse/pull/31484) ([eungenue](https://github.com/eungenue)).
* related to issue: [#30715](https://github.com/ClickHouse/ClickHouse/issues/30715). Add three functions for map data type: 1. mapReplace(map1, map2) - replaces values for keys in map1 with the values of the corresponding keys in map2; adds keys from map2 that don't exist in map1. 2. mapFilter 3. mapMap mapFilter and mapMap are higher order functions , accept two arguments, first argument is a lambda function with k, v pair , the second argument is a map type column. [#33698](https://github.com/ClickHouse/ClickHouse/pull/33698) ([hexiaoting](https://github.com/hexiaoting)).
* Add local cache for disk s3. Closes [#28961](https://github.com/ClickHouse/ClickHouse/issues/28961). [#33717](https://github.com/ClickHouse/ClickHouse/pull/33717) ([Kseniia Sumarokova](https://github.com/kssenii)).
* - Add startsWith & endsWith function for arrays, closes [#33982](https://github.com/ClickHouse/ClickHouse/issues/33982). [#34368](https://github.com/ClickHouse/ClickHouse/pull/34368) ([usurai](https://github.com/usurai)).
* Implement DateTime64 transform from and to arrow column, which closes [#8280](https://github.com/ClickHouse/ClickHouse/issues/8280) and closes [#28574](https://github.com/ClickHouse/ClickHouse/issues/28574). [#34561](https://github.com/ClickHouse/ClickHouse/pull/34561) ([李扬](https://github.com/taiyang-li)).
* Add cpu/mem metric for clickhouse-local. Close [#34545](https://github.com/ClickHouse/ClickHouse/issues/34545). [#34605](https://github.com/ClickHouse/ClickHouse/pull/34605) ([李扬](https://github.com/taiyang-li)).
* Support schema inference for inserting into table functions file/hdfs/s3/url. [#34732](https://github.com/ClickHouse/ClickHouse/pull/34732) ([Kruglov Pavel](https://github.com/Avogar)).
* A new settings called <allow_plaintext_password><allow_no_password> is added in server configuration which on/off insecure AUTH_TYPE plaintext-password and no_password. By default the property is set to true which means authType Plaintext_password & NO_password is allowed. [#34738](https://github.com/ClickHouse/ClickHouse/pull/34738) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Add new table function `hive`, usage as follow ``` hive('<hive metastore url>', '<hive database>', '<hive table name>', '<columns definition>', '<partition columns>') ``` for example ``` SELECT * FROM hive('thrift://hivetest:9083', 'test', 'demo', '`id` Nullable(String), `score` Nullable(Int32), `day` Nullable(String)', 'day') ```. [#34946](https://github.com/ClickHouse/ClickHouse/pull/34946) ([lgbo](https://github.com/lgbo-ustc)).
* - When use clickhouse-client logining, If user and password is not specified in command line or configuration file, get them from `CLICKHOUSE_USER` and `CLICKHOUSE_PASSWORD` environment variables. Close [#34538](https://github.com/ClickHouse/ClickHouse/issues/34538). [#34947](https://github.com/ClickHouse/ClickHouse/pull/34947) ([DR](https://github.com/freedomDR)).
* Added date_time_input_format = 'best_effort_us'. Closes [#34799](https://github.com/ClickHouse/ClickHouse/issues/34799). [#34982](https://github.com/ClickHouse/ClickHouse/pull/34982) ([WenYao](https://github.com/Cai-Yao)).
* Changed the Play UI to select a theme by the following priority: * 'theme' GET parameter * 'theme' in localStorage * According to OS preference (didn't work before). [#35068](https://github.com/ClickHouse/ClickHouse/pull/35068) ([peledni](https://github.com/peledni)).
* ``` sql ) explain ast graph = 1 select * from system.parts;. [#35173](https://github.com/ClickHouse/ClickHouse/pull/35173) ([李扬](https://github.com/taiyang-li)).
* Add `database_replicated_allow_only_replicated_engine` setting. When enabled, it only allowed to create `Replicated` tables in `Replicated` database. [#35214](https://github.com/ClickHouse/ClickHouse/pull/35214) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Performance Improvement
* Calling std::distance on large list will decrease performance, use a version in Node to substitute with more memory 80MB/1000w Nodes. The logic is: Every node is list has a version with type size_t, setting in insert or insertOrReplace method using the class member variable current_version. The version is only increase at enableSnapshot method. When doing a snapshot, call snapshotSizeWithVersion to get snapshot size and version(snapshot_up_to_version). When traversing the list, if node version is less then or equal to snapshot_up_to_version, then protects it from deleting if node version is bigger than snapshot_up_to_version, we can do anything to it. [#34486](https://github.com/ClickHouse/ClickHouse/pull/34486) ([zhanglistar](https://github.com/zhanglistar)).
* Compaction of log store in Nuraft need acquire an inner lock which also used in normal commit process, so we delete useless logs in `compact` method of Changelog class in a background thread. See details on: https://github.com/ClickHouse-Extras/NuRaft/blob/1707a7572aa66ec5d0a2dbe2bf5effa3352e6b2d/src/handle_commit.cxx#L560. [#34534](https://github.com/ClickHouse/ClickHouse/pull/34534) ([zhanglistar](https://github.com/zhanglistar)).
* Don't hold the latest snapshot in memory, instead, reading the snapshot if needed, sequence reading is fast to 200+MBps even on HDD using mmap system call. Writing snapshot data directly to disk using compression method without holding original data and compressed data in memory. [#34584](https://github.com/ClickHouse/ClickHouse/pull/34584) ([zhanglistar](https://github.com/zhanglistar)).
* MergeTree improve insert performance replacing std::stable_sort with pdqsort. [#34750](https://github.com/ClickHouse/ClickHouse/pull/34750) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve the performance of the `ANY` aggregation function by acting over batches. [#34760](https://github.com/ClickHouse/ClickHouse/pull/34760) ([Raúl Marín](https://github.com/Algunenano)).
* Improve performance of `detectCharset `, `detectLanguageUnknown ` functions. Improve performance of `DirectDictionary` if dictionary source is `ClickHouse`. Improve performance of processing queries with large `IN` section. [#34888](https://github.com/ClickHouse/ClickHouse/pull/34888) ([Maksim Kita](https://github.com/kitaisreal)).
* Less lock on connection using atomic stat. Notice that it is an approximate stat. [#35010](https://github.com/ClickHouse/ClickHouse/pull/35010) ([zhanglistar](https://github.com/zhanglistar)).

#### Improvement
* Make the znode ctime and mtime consistent between servers. [#33441](https://github.com/ClickHouse/ClickHouse/pull/33441) ([小路](https://github.com/nicelulu)).
* Hold time lock while assigning tasks to clear old temporary directories in StorageMergeTree. [#34025](https://github.com/ClickHouse/ClickHouse/pull/34025) ([Amos Bird](https://github.com/amosbird)).
* When large files were written with `s3` table function or table engine, the content type on the files was mistakenly set to `application/xml` due to a bug in the AWS SDK. This closes [#33964](https://github.com/ClickHouse/ClickHouse/issues/33964). [#34433](https://github.com/ClickHouse/ClickHouse/pull/34433) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve schema inference with globs in FIle/S3/HDFS/URL engines. Try to use the next path for schema inference in case of error. [#34465](https://github.com/ClickHouse/ClickHouse/pull/34465) ([Kruglov Pavel](https://github.com/Avogar)).
* - Improve the opentelemetry span logs for INSERT operation on distributed table. [#34480](https://github.com/ClickHouse/ClickHouse/pull/34480) ([Frank Chen](https://github.com/FrankChen021)).
* MaterializedMySQL support materialized_mysql_tables_list(a comma-separated list of mysql database tables, which will be replicated by MaterializedMySQL database engine. Default value: empty list — means whole tables will be replicated) settings, mentioned at [#32977](https://github.com/ClickHouse/ClickHouse/issues/32977). [#34487](https://github.com/ClickHouse/ClickHouse/pull/34487) ([zzsmdfj](https://github.com/zzsmdfj)).
* This PR changes restrictive row policies a bit to make them an easier alternative to permissive policies in easy cases. If for a particular table only restrictive policies exist (without permissive policies) users will be able to see some rows. Also `SHOW CREATE ROW POLICY` will always show `AS permissive` or `AS restrictive` in row policy's definition. [#34596](https://github.com/ClickHouse/ClickHouse/pull/34596) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add `encodeURLComponent`, 'encodeURLFormComponent' function. Closes [#31092](https://github.com/ClickHouse/ClickHouse/issues/31092). [#34607](https://github.com/ClickHouse/ClickHouse/pull/34607) ([zzsmdfj](https://github.com/zzsmdfj)).
* Now you can read `system.zookeeper` table without restrictions on path or using `like` expression. This reads can generate quite heavy load for zookeeper so to enable this ability you have to enable setting `allow_unrestricted_reads_from_keeper`. [#34609](https://github.com/ClickHouse/ClickHouse/pull/34609) ([Sergei Trifonov](https://github.com/serxa)).
* Some refactoring and improvement over async and remote buffer related stuff. Separated in each commit. [#34629](https://github.com/ClickHouse/ClickHouse/pull/34629) ([Amos Bird](https://github.com/amosbird)).
* ExecutableUserDefinedFunctions allow to specify argument names. This is necessary for formats where argument name is part of serialization, like `Native`, `JSONEachRow`. Closes [#34604](https://github.com/ClickHouse/ClickHouse/issues/34604). [#34653](https://github.com/ClickHouse/ClickHouse/pull/34653) ([Maksim Kita](https://github.com/kitaisreal)).
* Extract schema only once on table creation and prevent reading from local files/external sources to extract schema on each server startup. [#34684](https://github.com/ClickHouse/ClickHouse/pull/34684) ([Kruglov Pavel](https://github.com/Avogar)).
* Do not reset logging that configured via --log-file/--errorlog-file in case of empty logger.log/logger.errorlog. [#34718](https://github.com/ClickHouse/ClickHouse/pull/34718) ([Amos Bird](https://github.com/amosbird)).
* Support `remote()`/`cluster()` for `parallel_distributed_insert_select=2`. [#34728](https://github.com/ClickHouse/ClickHouse/pull/34728) ([Azat Khuzhin](https://github.com/azat)).
* Add name hints for data skipping indices. Closes [#29698](https://github.com/ClickHouse/ClickHouse/issues/29698). [#34764](https://github.com/ClickHouse/ClickHouse/pull/34764) ([flynn](https://github.com/ucasfl)).
* Now `ALTER TABLE DROP COLUMN columnX` queries for `MergeTree` table engines will work instantly when `columnX` is `ALIAS` column. Fixes [#34660](https://github.com/ClickHouse/ClickHouse/issues/34660). [#34786](https://github.com/ClickHouse/ClickHouse/pull/34786) ([alesapin](https://github.com/alesapin)).
* In previous versions the progress bar in clickhouse-client can jump forward near 50% for no reason. This closes [#34324](https://github.com/ClickHouse/ClickHouse/issues/34324). [#34801](https://github.com/ClickHouse/ClickHouse/pull/34801) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix reading only columns which user asked for. Closes [#34163](https://github.com/ClickHouse/ClickHouse/issues/34163). [#34849](https://github.com/ClickHouse/ClickHouse/pull/34849) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Implement MemoryStatisticsOS for FreeBSD. [#34902](https://github.com/ClickHouse/ClickHouse/pull/34902) ([Alexandre Snarskii](https://github.com/snar)).
* Allow to open empty sqlite db file if it does not exist. Closes [#33367](https://github.com/ClickHouse/ClickHouse/issues/33367). [#34907](https://github.com/ClickHouse/ClickHouse/pull/34907) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow LowCardinality strings for ngrambf_v1/tokenbf_v1 indexes. Closes [#21865](https://github.com/ClickHouse/ClickHouse/issues/21865). [#34911](https://github.com/ClickHouse/ClickHouse/pull/34911) ([Lars Hiller Eidnes](https://github.com/larspars)).
* Ignore per-column `TTL` in `CREATE TABLE AS` if new table engine does not support it (i.e. if the engine is not of `MergeTree` family). [#34938](https://github.com/ClickHouse/ClickHouse/pull/34938) ([Azat Khuzhin](https://github.com/azat)).
* Use connection pool for hive metastore client. [#34940](https://github.com/ClickHouse/ClickHouse/pull/34940) ([lgbo](https://github.com/lgbo-ustc)).
* Currently, if the user changes the settings of the system tables there will be tons of logs and ClickHouse will rename the tables every minute. This fixes [#34929](https://github.com/ClickHouse/ClickHouse/issues/34929). [#34949](https://github.com/ClickHouse/ClickHouse/pull/34949) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* remove unnecessary columns for reading parquet/orc files. [#34954](https://github.com/ClickHouse/ClickHouse/pull/34954) ([lgbo](https://github.com/lgbo-ustc)).
* For random access readbuffer in hive, the first time to read the readbuffer would use the original readbuffer instead of local file. When we read a parquet/orc format file, the readbuffer seeks to the end of the file, which will be blocked until the local file finishes download, and make the whold process slow. [#34957](https://github.com/ClickHouse/ClickHouse/pull/34957) ([lgbo](https://github.com/lgbo-ustc)).
* Add more sanity checks for keeper configuration: now mixing of localhost and non-local servers is not allowed, also add checks for same value of internal raft port and keeper client port. [#35004](https://github.com/ClickHouse/ClickHouse/pull/35004) ([alesapin](https://github.com/alesapin)).
* Functions `dictGetHierarchy`, `dictIsIn`, `dictGetChildren`, `dictGetDescendants` support implicit key cast and constant arguments. Closes [#34970](https://github.com/ClickHouse/ClickHouse/issues/34970). [#35027](https://github.com/ClickHouse/ClickHouse/pull/35027) ([Maksim Kita](https://github.com/kitaisreal)).
* Avoid division by zero in Query Profiler if Linux kernel has a bug. Closes [#34787](https://github.com/ClickHouse/ClickHouse/issues/34787). [#35032](https://github.com/ClickHouse/ClickHouse/pull/35032) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid possible `MEMORY_LIMIT_EXCEEDED` during `INSERT` into `Buffer` with `AggregateFunction`. [#35072](https://github.com/ClickHouse/ClickHouse/pull/35072) ([Azat Khuzhin](https://github.com/azat)).
* Support `view()` for `parallel_distributed_insert_select`. [#35132](https://github.com/ClickHouse/ClickHouse/pull/35132) ([Azat Khuzhin](https://github.com/azat)).
* Add setting to lower column case when reading parquet/ORC file. [#35145](https://github.com/ClickHouse/ClickHouse/pull/35145) ([shuchaome](https://github.com/shuchaome)).
* Do not retry non-rertiable errors. Closes [#35161](https://github.com/ClickHouse/ClickHouse/issues/35161). [#35172](https://github.com/ClickHouse/ClickHouse/pull/35172) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added disk_name to system.part_log. [#35178](https://github.com/ClickHouse/ClickHouse/pull/35178) ([Artyom Yurkov](https://github.com/Varinara)).
* Currently, ClickHouse validates hosts defined under <remote_url_allow_hosts> for URL and Remote Table functions. This PR extends the RemoteHostFilter to Mysql and PostgreSQL table functions. [#35191](https://github.com/ClickHouse/ClickHouse/pull/35191) ([Heena Bansal](https://github.com/HeenaBansal2009)).
* Sometimes it is not enough for us to distinguish queries hierachy only by is_initial_query in system.query_log and system.processes. So distributed_depth is needed. [#35207](https://github.com/ClickHouse/ClickHouse/pull/35207) ([李扬](https://github.com/taiyang-li)).
* Support test mode for clickhouse-local. [#35264](https://github.com/ClickHouse/ClickHouse/pull/35264) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Return const for function getMacro if not in distributed query. Close [#34727](https://github.com/ClickHouse/ClickHouse/issues/34727). [#35289](https://github.com/ClickHouse/ClickHouse/pull/35289) ([李扬](https://github.com/taiyang-li)).
* Reload `remote_url_allow_hosts` after config update. [#35294](https://github.com/ClickHouse/ClickHouse/pull/35294) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Bug Fix
* Ignore obsolete grants in ATTACH GRANT statements. This PR fixes [#34815](https://github.com/ClickHouse/ClickHouse/issues/34815). [#34855](https://github.com/ClickHouse/ClickHouse/pull/34855) ([Vitaly Baranov](https://github.com/vitlibar)).
* When the inner readbuffer's buffer size is too small, NEED_MORE_INPUT in `HadoopSnappyDecoder` will run multi times (>=3)for one compressed block. This makes the input data be copied into the wrong place in `HadoopSnappyDecoder::buffer`. [#35116](https://github.com/ClickHouse/ClickHouse/pull/35116) ([lgbo](https://github.com/lgbo-ustc)).

#### Build/Testing/Packaging Improvement
* Randomize some settings in functional tests. This closes [#32268](https://github.com/ClickHouse/ClickHouse/issues/32268). [#34092](https://github.com/ClickHouse/ClickHouse/pull/34092) ([Kruglov Pavel](https://github.com/Avogar)).
* NA. [#34513](https://github.com/ClickHouse/ClickHouse/pull/34513) ([vzakaznikov](https://github.com/vzakaznikov)).
* Debian package clickhouse-test.deb removed completely. CI use tests from repository and standalone testing via deb package is no longer supported. [#34606](https://github.com/ClickHouse/ClickHouse/pull/34606) ([Ilya Yatsishin](https://github.com/qoega)).
* Set timeout 40 minutes for fast tests. [#34624](https://github.com/ClickHouse/ClickHouse/pull/34624) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Drop PVS test from CI. [#34680](https://github.com/ClickHouse/ClickHouse/pull/34680) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Limit DWARF version for debug info by 4 max, because our internal stack symbolizer cannot parse DWARF version 5. This makes sense if you compile ClickHouse with clang-15. [#34777](https://github.com/ClickHouse/ClickHouse/pull/34777) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve CI scripts arguments. [#34792](https://github.com/ClickHouse/ClickHouse/pull/34792) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Use @robot-clickhouse as an author and committer for PRs like https://github.com/ClickHouse/ClickHouse/pull/34685. [#34793](https://github.com/ClickHouse/ClickHouse/pull/34793) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Separate smaller clickhouse-keeper build. [#35031](https://github.com/ClickHouse/ClickHouse/pull/35031) ([alesapin](https://github.com/alesapin)).
* Clion has the following problems "The breakpoint will not currently be hit. No executable code is associated with this line". [#35179](https://github.com/ClickHouse/ClickHouse/pull/35179) ([小路](https://github.com/nicelulu)).
* Add an ability to build stripped binaries with cmake. [#35196](https://github.com/ClickHouse/ClickHouse/pull/35196) ([alesapin](https://github.com/alesapin)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* Fix distributed subquery max_query_size limitation inconsistency. [#34078](https://github.com/ClickHouse/ClickHouse/pull/34078) ([Chao Ma](https://github.com/godliness)).
* Fix incorrect trivial count result when part movement feature is used [#34089](https://github.com/ClickHouse/ClickHouse/issues/34089). [#34385](https://github.com/ClickHouse/ClickHouse/pull/34385) ([nvartolomei](https://github.com/nvartolomei)).
* Stop to select part for mutate when the other replica has already updated the /log for ReplatedMergeTree engine. [#34633](https://github.com/ClickHouse/ClickHouse/pull/34633) ([Jianmei Zhang](https://github.com/zhangjmruc)).
* Fix `allow_experimental_projection_optimization` with `enable_global_with_statement` (before it may lead to `Stack size too large` error in case of multiple expressions in `WITH` clause, and also it executes scalar subqueries again and again, so not it will be more optimal). [#34650](https://github.com/ClickHouse/ClickHouse/pull/34650) ([Azat Khuzhin](https://github.com/azat)).
* Fix serialization/printing for system queries `RELOAD MODEL`, `RELOAD FUNCTION`, `RESTART DISK` when used `ON CLUSTER`. Closes [#34514](https://github.com/ClickHouse/ClickHouse/issues/34514). [#34696](https://github.com/ClickHouse/ClickHouse/pull/34696) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix ENOENT with fsync_part_directory and Vertical merge. [#34739](https://github.com/ClickHouse/ClickHouse/pull/34739) ([Azat Khuzhin](https://github.com/azat)).
* Fix bug for h3 funcs containing const columns which cause queries to fail. [#34743](https://github.com/ClickHouse/ClickHouse/pull/34743) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix possible failures in S2 functions when queries contain const columns. [#34745](https://github.com/ClickHouse/ClickHouse/pull/34745) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix bugs for multiple columns group by in WindowView. [#34859](https://github.com/ClickHouse/ClickHouse/pull/34859) ([vxider](https://github.com/Vxider)).
* Support DDLs like CREATE USER to be executed on cross replicated cluster. [#34860](https://github.com/ClickHouse/ClickHouse/pull/34860) ([Jianmei Zhang](https://github.com/zhangjmruc)).
* Fix asynchronous inserts to table functions. Fixes [#34864](https://github.com/ClickHouse/ClickHouse/issues/34864). [#34866](https://github.com/ClickHouse/ClickHouse/pull/34866) ([Anton Popov](https://github.com/CurtizJ)).
* Fix possible "Part directory doesn't exist" during `INSERT`. [#34876](https://github.com/ClickHouse/ClickHouse/pull/34876) ([Azat Khuzhin](https://github.com/azat)).
* Fix postgres datetime64 conversion. Closes [#33364](https://github.com/ClickHouse/ClickHouse/issues/33364). [#34910](https://github.com/ClickHouse/ClickHouse/pull/34910) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Avoid busy polling in keeper while searching for changelog files to delete. [#34931](https://github.com/ClickHouse/ClickHouse/pull/34931) ([Azat Khuzhin](https://github.com/azat)).
* Unexpected result when use `in` in `where` in hive query. [#34945](https://github.com/ClickHouse/ClickHouse/pull/34945) ([lgbo](https://github.com/lgbo-ustc)).
* Fix wrong schema inference for unquoted dates in CSV. Closes [#34768](https://github.com/ClickHouse/ClickHouse/issues/34768). [#34961](https://github.com/ClickHouse/ClickHouse/pull/34961) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible rare error `Cannot push block to port which already has data`. Avoid pushing to port with data inside `DelayedSource`. [#34993](https://github.com/ClickHouse/ClickHouse/pull/34993) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible segfault in filelog. Closes [#30749](https://github.com/ClickHouse/ClickHouse/issues/30749). [#34996](https://github.com/ClickHouse/ClickHouse/pull/34996) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix unexpected result when use -state type aggregate function in window frame. [#34999](https://github.com/ClickHouse/ClickHouse/pull/34999) ([metahys](https://github.com/metahys)).
* Fix possible exception `Reading for MergeTree family tables must be done with last position boundary`. Closes [#34979](https://github.com/ClickHouse/ClickHouse/issues/34979). [#35001](https://github.com/ClickHouse/ClickHouse/pull/35001) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix reading from `system.asynchronous_inserts` table if there exists asynchronous insert into table function. [#35050](https://github.com/ClickHouse/ClickHouse/pull/35050) ([Anton Popov](https://github.com/CurtizJ)).
* Fix missing alias after function is optimized to subcolumn when setting `optimize_functions_to_subcolumns` is enabled. Closes [#33798](https://github.com/ClickHouse/ClickHouse/issues/33798). [#35079](https://github.com/ClickHouse/ClickHouse/pull/35079) ([qieqieplus](https://github.com/qieqieplus)).
* Avoid possible deadlock on server shutdown. [#35081](https://github.com/ClickHouse/ClickHouse/pull/35081) ([Azat Khuzhin](https://github.com/azat)).
* Fixed the "update_lag" external dictionary configuration option being unusable with the error message ``Unexpected key `update_lag` in dictionary source configuration``. [#35089](https://github.com/ClickHouse/ClickHouse/pull/35089) ([Jason Chu](https://github.com/1lann)).
* fix issue: [#31469](https://github.com/ClickHouse/ClickHouse/issues/31469). [#35118](https://github.com/ClickHouse/ClickHouse/pull/35118) ([zzsmdfj](https://github.com/zzsmdfj)).
* Fix `optimize_skip_unused_shards_rewrite_in` for signed columns and negative values. [#35134](https://github.com/ClickHouse/ClickHouse/pull/35134) ([Azat Khuzhin](https://github.com/azat)).
* Fixed the incorrect translation YAML config to XML. [#35135](https://github.com/ClickHouse/ClickHouse/pull/35135) ([Miel Donkers](https://github.com/mdonkers)).
* Fix partition pruning error when non-monotonic function is used with IN operator. This fixes [#35136](https://github.com/ClickHouse/ClickHouse/issues/35136). [#35146](https://github.com/ClickHouse/ClickHouse/pull/35146) ([Amos Bird](https://github.com/amosbird)).
* Fix materialised postrgesql adding new table to replication (ATTACH TABLE) after manually removing (DETACH TABLE). Closes [#33800](https://github.com/ClickHouse/ClickHouse/issues/33800). Closes [#34922](https://github.com/ClickHouse/ClickHouse/issues/34922). Closes [#34315](https://github.com/ClickHouse/ClickHouse/issues/34315). [#35158](https://github.com/ClickHouse/ClickHouse/pull/35158) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix materialised postgres `table overrides` for partition by, etc. Closes [#35048](https://github.com/ClickHouse/ClickHouse/issues/35048). [#35162](https://github.com/ClickHouse/ClickHouse/pull/35162) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Schema inference didn't work properly on case of `INSERT INTO FUNCTION s3(...) FROM ...`, it tried to read schema from s3 file instead of from select query. [#35176](https://github.com/ClickHouse/ClickHouse/pull/35176) ([Kruglov Pavel](https://github.com/Avogar)).
* - Fix `replaceRegexpAll`, close [#35117](https://github.com/ClickHouse/ClickHouse/issues/35117). [#35182](https://github.com/ClickHouse/ClickHouse/pull/35182) ([Vladimir C](https://github.com/vdimir)).
* Fix error in query with `WITH TOTALS` in case if `HAVING` returned empty result. This fixes [#33711](https://github.com/ClickHouse/ClickHouse/issues/33711). [#35186](https://github.com/ClickHouse/ClickHouse/pull/35186) ([Amos Bird](https://github.com/amosbird)).
* * Fix reading port from config, close [#34776](https://github.com/ClickHouse/ClickHouse/issues/34776). [#35193](https://github.com/ClickHouse/ClickHouse/pull/35193) ([Vladimir C](https://github.com/vdimir)).
* Make function `cast(value, 'IPv4')`, `cast(value, 'IPv6')` behave same as `toIPv4`, `toIPv6` functions. Changed behavior of incorrect IP address passed into functions `toIPv4`,` toIPv6`, now if invalid IP address passes into this functions exception will be raised, before this function return default value. Added functions `IPv4StringToNumOrDefault`, `IPv4StringToNumOrNull`, `IPv6StringToNumOrDefault`, `IPv6StringOrNull` `toIPv4OrDefault`, `toIPv4OrNull`, `toIPv6OrDefault`, `toIPv6OrNull`. Functions `IPv4StringToNumOrDefault `, `toIPv4OrDefault `, `toIPv6OrDefault ` should be used if previous logic relied on `IPv4StringToNum`, `toIPv4`, `toIPv6` returning default value for invalid address. Added setting `cast_ipv4_ipv6_default_on_conversion_error`, if this setting enabled, then IP address conversion functions will behave as before. Closes [#22825](https://github.com/ClickHouse/ClickHouse/issues/22825). Closes [#5799](https://github.com/ClickHouse/ClickHouse/issues/5799). Closes [#35156](https://github.com/ClickHouse/ClickHouse/issues/35156). [#35240](https://github.com/ClickHouse/ClickHouse/pull/35240) ([Maksim Kita](https://github.com/kitaisreal)).
* Wait for IDiskRemote thread pool properly. [#35257](https://github.com/ClickHouse/ClickHouse/pull/35257) ([Azat Khuzhin](https://github.com/azat)).
* Fix `CHECK TABLE` query in case when sparse columns are enabled in table. [#35274](https://github.com/ClickHouse/ClickHouse/pull/35274) ([Anton Popov](https://github.com/CurtizJ)).
* Fix possible Abort while using Brotli compression with a small `max_read_buffer_size` setting value. The bug was found in https://github.com/ClickHouse/ClickHouse/pull/35047. [#35281](https://github.com/ClickHouse/ClickHouse/pull/35281) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible segfault in JSONEachRow schema inference. [#35291](https://github.com/ClickHouse/ClickHouse/pull/35291) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible `Assertion 'position() != working_buffer.end()' failed` while using lzma compression with small `max_read_buffer_size` setting value. The bug was found in https://github.com/ClickHouse/ClickHouse/pull/35047. [#35295](https://github.com/ClickHouse/ClickHouse/pull/35295) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible segfault while using lz4 compression with a small max_read_buffer_size setting value. The bug was found in https://github.com/ClickHouse/ClickHouse/pull/35047. [#35296](https://github.com/ClickHouse/ClickHouse/pull/35296) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible `Assertion 'position() != working_buffer.end()' failed` while using bzip2 compression with small `max_read_buffer_size` setting value. The bug was found in https://github.com/ClickHouse/ClickHouse/pull/35047. [#35300](https://github.com/ClickHouse/ClickHouse/pull/35300) ([Kruglov Pavel](https://github.com/Avogar)).
* - Fix partial merge join duplicate rows bug, close [#31009](https://github.com/ClickHouse/ClickHouse/issues/31009). [#35311](https://github.com/ClickHouse/ClickHouse/pull/35311) ([Vladimir C](https://github.com/vdimir)).
* Fix segfault in Postgres database when getting create table query if database was created using named collections. Closes [#35312](https://github.com/ClickHouse/ClickHouse/issues/35312). [#35313](https://github.com/ClickHouse/ClickHouse/pull/35313) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bug in S3 zero-copy replication which can lead to errors like `Found parts with the same min block and with the same max block as the missing part` after concurrent fetch/drop table. [#35348](https://github.com/ClickHouse/ClickHouse/pull/35348) ([alesapin](https://github.com/alesapin)).

#### NO CL ENTRY

* NO CL ENTRY:  '[ImgBot] Optimize images'. [#34590](https://github.com/ClickHouse/ClickHouse/pull/34590) ([imgbot[bot]](https://github.com/apps/imgbot)).
* NO CL ENTRY:  'Revert "Allow restrictive row policies without permissive"'. [#34782](https://github.com/ClickHouse/ClickHouse/pull/34782) ([Vitaly Baranov](https://github.com/vitlibar)).
* NO CL ENTRY:  'Revert "Remove "bugs" that do not exist anymore"'. [#35241](https://github.com/ClickHouse/ClickHouse/pull/35241) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Change timezone in Docker"'. [#35243](https://github.com/ClickHouse/ClickHouse/pull/35243) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Fix 00900_long_parquet_load"'. [#35301](https://github.com/ClickHouse/ClickHouse/pull/35301) ([Vladimir C](https://github.com/vdimir)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* [RFC] Update jemalloc to 5.3RC [#33057](https://github.com/ClickHouse/ClickHouse/pull/33057) ([Azat Khuzhin](https://github.com/azat)).
* Remove useless setting experimental_query_deduplication_send_all_part_uuids [#34387](https://github.com/ClickHouse/ClickHouse/pull/34387) ([nvartolomei](https://github.com/nvartolomei)).
* Apply join_use_nulls on types before join [#34529](https://github.com/ClickHouse/ClickHouse/pull/34529) ([Vladimir C](https://github.com/vdimir)).
* Adjust 01681_arg_min_max_if_fix [#34612](https://github.com/ClickHouse/ClickHouse/pull/34612) ([Vladimir C](https://github.com/vdimir)).
* Check overflow in addSeconds/Minues/etc functions [#34619](https://github.com/ClickHouse/ClickHouse/pull/34619) ([Vladimir C](https://github.com/vdimir)).
* Update version after release [#34677](https://github.com/ClickHouse/ClickHouse/pull/34677) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix `positionUTF8` on aarch64 [#34683](https://github.com/ClickHouse/ClickHouse/pull/34683) ([Vladimir C](https://github.com/vdimir)).
* Update version_date.tsv after v22.2.2.1-stable [#34685](https://github.com/ClickHouse/ClickHouse/pull/34685) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Fix ZooKepper paths in zero_copy_schema_converter.py [#34686](https://github.com/ClickHouse/ClickHouse/pull/34686) ([ianton-ru](https://github.com/ianton-ru)).
* Changelog for version 22.2 [#34687](https://github.com/ClickHouse/ClickHouse/pull/34687) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Follow up to PR [#33698](https://github.com/ClickHouse/ClickHouse/issues/33698) [#34689](https://github.com/ClickHouse/ClickHouse/pull/34689) ([Vladimir C](https://github.com/vdimir)).
* Always update ProfileEvents (even on exceptions) [#34690](https://github.com/ClickHouse/ClickHouse/pull/34690) ([nvartolomei](https://github.com/nvartolomei)).
* Function encodeURLComponent minor fixes [#34695](https://github.com/ClickHouse/ClickHouse/pull/34695) ([Maksim Kita](https://github.com/kitaisreal)).
* CMake llvm add status message if not used [#34698](https://github.com/ClickHouse/ClickHouse/pull/34698) ([Maksim Kita](https://github.com/kitaisreal)).
* Adding noexcept for move constructor SharedContextHolder [#34699](https://github.com/ClickHouse/ClickHouse/pull/34699) ([Rajkumar Varada](https://github.com/varadarajkumar)).
* Add new team members to company page [#34701](https://github.com/ClickHouse/ClickHouse/pull/34701) ([Cody Baker](https://github.com/codyrobert)).
* Fix flaky 00502_custom_partitioning_local [#34714](https://github.com/ClickHouse/ClickHouse/pull/34714) ([Azat Khuzhin](https://github.com/azat)).
* Workaround for a bug in NuRaft library [#34715](https://github.com/ClickHouse/ClickHouse/pull/34715) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible memory_tracker use-after-free (for async s3 writes) for merges/mutations [#34717](https://github.com/ClickHouse/ClickHouse/pull/34717) ([Azat Khuzhin](https://github.com/azat)).
* Add taiyang-li to trusted contributors [#34729](https://github.com/ClickHouse/ClickHouse/pull/34729) ([Vladimir C](https://github.com/vdimir)).
* rename name in ci check [#34730](https://github.com/ClickHouse/ClickHouse/pull/34730) ([flynn](https://github.com/ucasfl)).
* Performance tests fix H3 [#34731](https://github.com/ClickHouse/ClickHouse/pull/34731) ([Maksim Kita](https://github.com/kitaisreal)).
* Enable async writes to S3. [#34734](https://github.com/ClickHouse/ClickHouse/pull/34734) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add a patch release for stable/lts packages to release.py [#34740](https://github.com/ClickHouse/ClickHouse/pull/34740) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Print only total profile events for --profile-events-delay-ms=-1 [#34749](https://github.com/ClickHouse/ClickHouse/pull/34749) ([Azat Khuzhin](https://github.com/azat)).
* Fix `parallel_reading_from_replicas` with `clickhouse-bechmark` [#34751](https://github.com/ClickHouse/ClickHouse/pull/34751) ([Azat Khuzhin](https://github.com/azat)).
* Submodules are mandatory [#34753](https://github.com/ClickHouse/ClickHouse/pull/34753) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Changelog for version 22.2 [#34758](https://github.com/ClickHouse/ClickHouse/pull/34758) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Sort additional_html_urls in test report in CI [#34770](https://github.com/ClickHouse/ClickHouse/pull/34770) ([Vladimir C](https://github.com/vdimir)).
* Fix undefined __pthread_mutex_lock/unlock for glibc 2.34+/DISABLE_HERMETIC_BUILD [#34771](https://github.com/ClickHouse/ClickHouse/pull/34771) ([Azat Khuzhin](https://github.com/azat)).
* jemalloc: fix includes order to avoid overlaps [#34783](https://github.com/ClickHouse/ClickHouse/pull/34783) ([Azat Khuzhin](https://github.com/azat)).
* Fix using host/port from config for client [#34791](https://github.com/ClickHouse/ClickHouse/pull/34791) ([Vladimir C](https://github.com/vdimir)).
* Update links for 22.2 and 22.3 release webinars [#34814](https://github.com/ClickHouse/ClickHouse/pull/34814) ([Cody Baker](https://github.com/codyrobert)).
* Add opensee blog post [#34817](https://github.com/ClickHouse/ClickHouse/pull/34817) ([Cody Baker](https://github.com/codyrobert)).
* Try remove trash from StorageFileLog [#34819](https://github.com/ClickHouse/ClickHouse/pull/34819) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix generating system.build_options [#34823](https://github.com/ClickHouse/ClickHouse/pull/34823) ([Azat Khuzhin](https://github.com/azat)).
* Comment output header for team keys [#34828](https://github.com/ClickHouse/ClickHouse/pull/34828) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix untuple condition in IN function [#34836](https://github.com/ClickHouse/ClickHouse/pull/34836) ([Vladimir C](https://github.com/vdimir)).
* Improve certificate reloader [#34887](https://github.com/ClickHouse/ClickHouse/pull/34887) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Update DiskS3.cpp [#34889](https://github.com/ClickHouse/ClickHouse/pull/34889) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Clang tidy improvements [#34893](https://github.com/ClickHouse/ClickHouse/pull/34893) ([Maksim Kita](https://github.com/kitaisreal)).
* Update version_date.tsv after v22.2.3.5-stable [#34898](https://github.com/ClickHouse/ClickHouse/pull/34898) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Add check_prerequisites to release.py [#34901](https://github.com/ClickHouse/ClickHouse/pull/34901) ([Vladimir C](https://github.com/vdimir)).
* Fix filelog storage data paths [#34912](https://github.com/ClickHouse/ClickHouse/pull/34912) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update version_date.tsv after v22.1.4.30-stable [#34913](https://github.com/ClickHouse/ClickHouse/pull/34913) ([github-actions[bot]](https://github.com/apps/github-actions)).
* Fix alignment for aligned_alloc() to fix build for glibc2.35+ [#34919](https://github.com/ClickHouse/ClickHouse/pull/34919) ([Azat Khuzhin](https://github.com/azat)).
* Stop processing multiqueries in clickhouse-client/local on SIGINT [#34923](https://github.com/ClickHouse/ClickHouse/pull/34923) ([Azat Khuzhin](https://github.com/azat)).
* Fix some code comments style [#34935](https://github.com/ClickHouse/ClickHouse/pull/34935) ([hongbin](https://github.com/xlwh)).
* Adjust couple of tests for aarch64 [#34951](https://github.com/ClickHouse/ClickHouse/pull/34951) ([Vladimir C](https://github.com/vdimir)).
* Add benchmarks [#34960](https://github.com/ClickHouse/ClickHouse/pull/34960) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Catch exception in ~WriteBufferFromS3 [#34963](https://github.com/ClickHouse/ClickHouse/pull/34963) ([Vladimir C](https://github.com/vdimir)).
* Disable memory checking test with thread sanitizer [#34964](https://github.com/ClickHouse/ClickHouse/pull/34964) ([alesapin](https://github.com/alesapin)).
* Print number of available logical cores in configuration [#34972](https://github.com/ClickHouse/ClickHouse/pull/34972) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix possible "nmalloc >= ndalloc" jemalloc assertion [#34973](https://github.com/ClickHouse/ClickHouse/pull/34973) ([Azat Khuzhin](https://github.com/azat)).
* Add some benchmarks [#34974](https://github.com/ClickHouse/ClickHouse/pull/34974) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Fix typo [#34975](https://github.com/ClickHouse/ClickHouse/pull/34975) ([Nikita Evsyukov](https://github.com/NikitaEvs)).
* Fix signal-unsafe TSan report in client [#34988](https://github.com/ClickHouse/ClickHouse/pull/34988) ([Azat Khuzhin](https://github.com/azat)).
* Fix non-MergeTree engines for system.*_log [#34989](https://github.com/ClickHouse/ClickHouse/pull/34989) ([Azat Khuzhin](https://github.com/azat)).
* Fix test_storage_postgresql::test_concurrent_queries [#34991](https://github.com/ClickHouse/ClickHouse/pull/34991) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix race between INSERT async_insert=1 and system.asynchronous_inserts [#34992](https://github.com/ClickHouse/ClickHouse/pull/34992) ([Azat Khuzhin](https://github.com/azat)).
* Add option to clickhouse-test to skip aarch64 build [#34995](https://github.com/ClickHouse/ClickHouse/pull/34995) ([Vladimir C](https://github.com/vdimir)).
* clickhouse obfuscator aarch64 fix [#35005](https://github.com/ClickHouse/ClickHouse/pull/35005) ([Vladimir C](https://github.com/vdimir)).
* Fix tutorial link [#35014](https://github.com/ClickHouse/ClickHouse/pull/35014) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* ExecutableUDF function deterministic in scope of query fix [#35018](https://github.com/ClickHouse/ClickHouse/pull/35018) ([Maksim Kita](https://github.com/kitaisreal)).
* fasttest: add timings for "Test time" column in the results table [#35019](https://github.com/ClickHouse/ClickHouse/pull/35019) ([Azat Khuzhin](https://github.com/azat)).
* Always write preprocessed config in XML format [#35020](https://github.com/ClickHouse/ClickHouse/pull/35020) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix read old records from logs [#35021](https://github.com/ClickHouse/ClickHouse/pull/35021) ([alesapin](https://github.com/alesapin)).
* Fix trim function [#35046](https://github.com/ClickHouse/ClickHouse/pull/35046) ([Vladimir C](https://github.com/vdimir)).
* Skip 01086_odbc_roundtrip for aarch, disable force_tests [#35058](https://github.com/ClickHouse/ClickHouse/pull/35058) ([Vladimir C](https://github.com/vdimir)).
* Remove useless define [#35066](https://github.com/ClickHouse/ClickHouse/pull/35066) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Take flush_time into account for scheduling background flush of the Buffer [#35071](https://github.com/ClickHouse/ClickHouse/pull/35071) ([Azat Khuzhin](https://github.com/azat)).
* Try to fix failed tests [#35073](https://github.com/ClickHouse/ClickHouse/pull/35073) ([Kruglov Pavel](https://github.com/Avogar)).
* Do not hide exceptions during mutations [#35080](https://github.com/ClickHouse/ClickHouse/pull/35080) ([Azat Khuzhin](https://github.com/azat)).
* Put downloaded artifacts to a temorary path [#35088](https://github.com/ClickHouse/ClickHouse/pull/35088) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Get rid of duplicate query planing. [#35094](https://github.com/ClickHouse/ClickHouse/pull/35094) ([Amos Bird](https://github.com/amosbird)).
* Temporary supress move partition long for storage S3 [#35097](https://github.com/ClickHouse/ClickHouse/pull/35097) ([alesapin](https://github.com/alesapin)).
* Fix inconsistency in DiskLocal [#35099](https://github.com/ClickHouse/ClickHouse/pull/35099) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Try to build llvm for Aarch64 [#35103](https://github.com/ClickHouse/ClickHouse/pull/35103) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix build fail with gcc [#35123](https://github.com/ClickHouse/ClickHouse/pull/35123) ([zhanghuajie](https://github.com/zhanghuajieHIT)).
* Fix hardcoded page size  [#35129](https://github.com/ClickHouse/ClickHouse/pull/35129) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Delete nodes with attributes `remove` or `replace` if they didn't merge [#35141](https://github.com/ClickHouse/ClickHouse/pull/35141) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Upgrade icu to icu-release-70-1 [#35142](https://github.com/ClickHouse/ClickHouse/pull/35142) ([Yong Wang](https://github.com/kashwy)).
* Merging [#33398](https://github.com/ClickHouse/ClickHouse/issues/33398) [#35157](https://github.com/ClickHouse/ClickHouse/pull/35157) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix typos [#35174](https://github.com/ClickHouse/ClickHouse/pull/35174) ([Zhang Yifan](https://github.com/zhangyifan27)).
* Adjust max_memory_usage in external_aggregation.sql [#35194](https://github.com/ClickHouse/ClickHouse/pull/35194) ([Vladimir C](https://github.com/vdimir)).
* MaterializedMySQL protocol example fix [#35198](https://github.com/ClickHouse/ClickHouse/pull/35198) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove useless files [#35199](https://github.com/ClickHouse/ClickHouse/pull/35199) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless file [#35200](https://github.com/ClickHouse/ClickHouse/pull/35200) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add Segment script to <head> of docs pages [#35203](https://github.com/ClickHouse/ClickHouse/pull/35203) ([Rich Raposa](https://github.com/rfraposa)).
* Cache fix [#35209](https://github.com/ClickHouse/ClickHouse/pull/35209) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Use C++14 aliases for some type traits [#35212](https://github.com/ClickHouse/ClickHouse/pull/35212) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove redundant configs for TestFlows [#35223](https://github.com/ClickHouse/ClickHouse/pull/35223) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Correct some integration tests [#35224](https://github.com/ClickHouse/ClickHouse/pull/35224) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change timezone in Docker [#35225](https://github.com/ClickHouse/ClickHouse/pull/35225) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change timezone example in server config [#35226](https://github.com/ClickHouse/ClickHouse/pull/35226) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Adjust timezone in performance tests [#35227](https://github.com/ClickHouse/ClickHouse/pull/35227) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove "bugs" that do not exist anymore [#35228](https://github.com/ClickHouse/ClickHouse/pull/35228) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change timezone in stateful tests. [#35229](https://github.com/ClickHouse/ClickHouse/pull/35229) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Moved submodules from ClickHouse-Extras to ClickHouse [#35232](https://github.com/ClickHouse/ClickHouse/pull/35232) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove "bugs" that do not exist anymore [#35242](https://github.com/ClickHouse/ClickHouse/pull/35242) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update CachedReadBufferFromRemoteFS.cpp [#35245](https://github.com/ClickHouse/ClickHouse/pull/35245) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a test for [#34682](https://github.com/ClickHouse/ClickHouse/issues/34682) [#35247](https://github.com/ClickHouse/ClickHouse/pull/35247) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable clang tidy for header files [#35248](https://github.com/ClickHouse/ClickHouse/pull/35248) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix possible 01506_buffer_table_alter_block_structure_2 flakiness [#35249](https://github.com/ClickHouse/ClickHouse/pull/35249) ([Azat Khuzhin](https://github.com/azat)).
* Mark build action as failed if it was retried and there was no succeeded builds [#35260](https://github.com/ClickHouse/ClickHouse/pull/35260) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test [#35261](https://github.com/ClickHouse/ClickHouse/pull/35261) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix logical error in remote fs cache [#35275](https://github.com/ClickHouse/ClickHouse/pull/35275) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix code style and other minor corrections after implementing allow_no_password. [#35276](https://github.com/ClickHouse/ClickHouse/pull/35276) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add remote fs cache optimization [#35278](https://github.com/ClickHouse/ClickHouse/pull/35278) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove utils/github-hook/hook.py [#35280](https://github.com/ClickHouse/ClickHouse/pull/35280) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix test [#35282](https://github.com/ClickHouse/ClickHouse/pull/35282) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix 00284_external_aggregation.sql [#35293](https://github.com/ClickHouse/ClickHouse/pull/35293) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix 00900_long_parquet_load [#35299](https://github.com/ClickHouse/ClickHouse/pull/35299) ([Vladimir C](https://github.com/vdimir)).
* Maybe fix use-after-free inside S3 upload thread [#35305](https://github.com/ClickHouse/ClickHouse/pull/35305) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Modified python packages [#35306](https://github.com/ClickHouse/ClickHouse/pull/35306) ([Lalit Srikant](https://github.com/LAL2211)).
* Fix disappeared host and port from client help message [#35309](https://github.com/ClickHouse/ClickHouse/pull/35309) ([Kruglov Pavel](https://github.com/Avogar)).
* Changelog 22.3 [#35344](https://github.com/ClickHouse/ClickHouse/pull/35344) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Replace a few uses of enable_if for SFINAE by concepts [#35347](https://github.com/ClickHouse/ClickHouse/pull/35347) ([Robert Schulze](https://github.com/rschu1ze)).
