---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v22.1.1.2542-prestable FIXME as compared to v21.12.1.9017-prestable

#### Backward Incompatible Change
* Change ZooKeeper path for zero-copy marks for shared data. Fix for remove marks in ZooKeeper for renamed parts. [#32061](https://github.com/ClickHouse/ClickHouse/pull/32061) ([ianton-ru](https://github.com/ianton-ru)).
* - Account for scalar subqueries. With this change, rows read in scalar subqueries are now reported in the query_log. If the scalar subquery is cached (repeated or called for several rows) the rows read are only counted once. This change allows KILLing queries and reporting progress while they are executing scalar subqueries. [#32271](https://github.com/ClickHouse/ClickHouse/pull/32271) ([Raúl Marín](https://github.com/Algunenano)).
* Add `left`, `right`, `leftUTF8`, `rightUTF8` functions. Fix error in implementation of `substringUTF8` function with negative offset (offset from the end of string). The functions `left` and `right` were previously implemented in parser. Upgrade notes: distributed queries with `left` or `right` functions without aliases may throw exception if cluster contains different versions of clickhouse-server. If you are upgrading your cluster and encounter this error, you should finish upgrading your cluster to ensure all nodes have the same version. Also you can add aliases (`AS something`) to the columns in your queries to avoid this issue. [#33407](https://github.com/ClickHouse/ClickHouse/pull/33407) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature
* Implemented sparse serialization. It can reduce usage of disk space and improve performance of some queries for columns, which contain a lot of default (zero) values. It can be enabled by setting `ratio_of_defaults_for_sparse_serialization`. Sparse serialization will be chosen dynamically for column, if it has ratio of number of default values to number of all values above that threshold. Serialization (default or sparse) will be fixed for every column in part, but may varies between parts. [#22535](https://github.com/ClickHouse/ClickHouse/pull/22535) ([Anton Popov](https://github.com/CurtizJ)).
* add grouping sets function, like GROUP BY grouping sets (a, b, (a, b)). [#26869](https://github.com/ClickHouse/ClickHouse/pull/26869) ([taylor12805](https://github.com/taylor12805)).
* Added an ability to read from all replicas within a shard during distributed query. To enable this, set `allow_experimental_parallel_reading_from_replicas=true` and `max_parallel_replicas` to any number. This closes [#26748](https://github.com/ClickHouse/ClickHouse/issues/26748). [#29279](https://github.com/ClickHouse/ClickHouse/pull/29279) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Start and stop servers when hosts and ports configuration changes. [#30549](https://github.com/ClickHouse/ClickHouse/pull/30549) ([Kevin Michel](https://github.com/kmichel-aiven)).
* Create any kind of view with comment. ... [#31062](https://github.com/ClickHouse/ClickHouse/pull/31062) ([Vasily Nemkov](https://github.com/Enmk)).
* Implement hive table engine to access apache hive from clickhouse. Related RFC: [#29245](https://github.com/ClickHouse/ClickHouse/issues/29245). [#31104](https://github.com/ClickHouse/ClickHouse/pull/31104) ([李扬](https://github.com/taiyang-li)).
* * Automatic cluster discovery via Zoo/Keeper. [#31442](https://github.com/ClickHouse/ClickHouse/pull/31442) ([Vladimir C](https://github.com/vdimir)).
* Adding support for disks backed by Azure Blob Storage, in a similar way it has been done for disks backed by AWS S3. Current implementation allows for all the basic disk operations. [#31505](https://github.com/ClickHouse/ClickHouse/pull/31505) ([Jakub Kuklis](https://github.com/jkuklis)).
* * Add "TABLE OVERRIDE" feature for customizing MaterializedMySQL table schemas. [#32325](https://github.com/ClickHouse/ClickHouse/pull/32325) ([Stig Bakken](https://github.com/stigsb)).
* Implement data schema inference for input formats. Allow to skip structure (or write just `auto`) in table functions `file`, `url`, `s3`, `hdfs` and in parameters of `clickhouse-local` . Allow to skip structure in create query for table engines `File`, `HDFS`, `S3`, `URL`, `Merge`, `Buffer`, `Distributed` and `ReplicatedMergeTree` (if we add new replicas). [#32455](https://github.com/ClickHouse/ClickHouse/pull/32455) ([Kruglov Pavel](https://github.com/Avogar)).
* Support TABLE OVERRIDE clause for MaterializedPostgreSQL. RFC: [#31480](https://github.com/ClickHouse/ClickHouse/issues/31480). [#32749](https://github.com/ClickHouse/ClickHouse/pull/32749) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `EXPLAIN TABLE OVERRIDE` query. [#32836](https://github.com/ClickHouse/ClickHouse/pull/32836) ([Stig Bakken](https://github.com/stigsb)).
* If an invalid setting is defined using the `SET` query or using the query parameters in the HTTP request, error message will contain suggestions that are similar to the invalid setting string (if any exists). [#32946](https://github.com/ClickHouse/ClickHouse/pull/32946) ([Antonio Andelic](https://github.com/antonio2368)).
* Add aggregate functions `cramersV`, `cramersVBiasCorrected`, `theilsU` and `contingency`. These functions calculate dependency (measure of association) between categorial values. All these functions are using cross-tab (histogram on pairs) for implementation. You can imagine it like a correlation coefficient but for any discrete values (not necessary numbers). [#33366](https://github.com/ClickHouse/ClickHouse/pull/33366) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added function `arrayLast`. Closes [#33390](https://github.com/ClickHouse/ClickHouse/issues/33390). [#33415](https://github.com/ClickHouse/ClickHouse/pull/33415) ([Maksim Kita](https://github.com/kitaisreal)).
* Add MONTHNAME function. [#33436](https://github.com/ClickHouse/ClickHouse/pull/33436) ([usurai](https://github.com/usurai)).
* Auto detect file extension. Close [#30918](https://github.com/ClickHouse/ClickHouse/issues/30918). [#33443](https://github.com/ClickHouse/ClickHouse/pull/33443) ([zhongyuankai](https://github.com/zhongyuankai)).
* Added function `arrayLastIndex`. [#33465](https://github.com/ClickHouse/ClickHouse/pull/33465) ([Maksim Kita](https://github.com/kitaisreal)).
* Add new h3 miscellaneous functions: `h3DegsToRads`, `h3RadsToDegs`, `h3HexAreaKm2`, `h3CellAreaM2`, `h3CellAreaRads2`. [#33479](https://github.com/ClickHouse/ClickHouse/pull/33479) ([Bharat Nallan](https://github.com/bharatnc)).
* Detect format by file extension in file/hdfs/s3/url table functions and HDFS/S3/URL table engines. [#33565](https://github.com/ClickHouse/ClickHouse/pull/33565) ([Kruglov Pavel](https://github.com/Avogar)).

#### Performance Improvement
* Non significant change. In extremely rare cases when data part is lost on every replica, after merging of some data parts, the subsequent queries may skip less amount of partitions during partition pruning. This hardly affects anything. [#32220](https://github.com/ClickHouse/ClickHouse/pull/32220) ([Azat Khuzhin](https://github.com/azat)).
* Slight performance improvement of `reinterpret` function. [#32587](https://github.com/ClickHouse/ClickHouse/pull/32587) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Reduce allocated memory for dictionaries with string attributes. [#33466](https://github.com/ClickHouse/ClickHouse/pull/33466) ([Maksim Kita](https://github.com/kitaisreal)).
* Avoid exponential backtracking in parser. This closes [#20158](https://github.com/ClickHouse/ClickHouse/issues/20158). [#33481](https://github.com/ClickHouse/ClickHouse/pull/33481) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Now date time conversion functions that generates time before 1970-01-01 00:00:00 will be saturated to zero instead of overflow. [#29953](https://github.com/ClickHouse/ClickHouse/pull/29953) ([Amos Bird](https://github.com/amosbird)).
* Added settings `command_read_timeout`, `command_write_timeout` for `StorageExecutable`, `StorageExecutablePool`, `ExecutableDictionary`, `ExecutablePoolDictionary`, `ExecutableUserDefinedFunctions`. Setting `command_read_timeout` controls timeout for reading data from command stdout in milliseconds. Setting `command_write_timeout` timeout for writing data to command stdin in milliseconds. Added settings `command_termination_timeout` for `ExecutableUserDefinedFunction`, `ExecutableDictionary`, `StorageExecutable`. Added setting `execute_direct` for `ExecutableUserDefinedFunction`, by default true. Added setting `execute_direct` for `ExecutableDictionary`, `ExecutablePoolDictionary`, by default false. [#30957](https://github.com/ClickHouse/ClickHouse/pull/30957) ([Maksim Kita](https://github.com/kitaisreal)).
* Optimize single part projection materialization. This closes [#31669](https://github.com/ClickHouse/ClickHouse/issues/31669). [#31885](https://github.com/ClickHouse/ClickHouse/pull/31885) ([Amos Bird](https://github.com/amosbird)).
* Enable comparison between `Decimal` and `Float`. Closes [#22626](https://github.com/ClickHouse/ClickHouse/issues/22626). [#31966](https://github.com/ClickHouse/ClickHouse/pull/31966) ([flynn](https://github.com/ucasfl)).
* - Ignore parse failure of opentelemetry's `traceparent` header. [#32116](https://github.com/ClickHouse/ClickHouse/pull/32116) ([Frank Chen](https://github.com/FrankChen021)).
* Improve keeper writing performance by optimization the size calculation logic. [#32366](https://github.com/ClickHouse/ClickHouse/pull/32366) ([zhanglistar](https://github.com/zhanglistar)).
* Allows to connect to mongodb 5.0. Closes [#31483](https://github.com/ClickHouse/ClickHouse/issues/31483),. [#32416](https://github.com/ClickHouse/ClickHouse/pull/32416) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable some optimizations for window functions. Closes [#31535](https://github.com/ClickHouse/ClickHouse/issues/31535). Closes [#31620](https://github.com/ClickHouse/ClickHouse/issues/31620). [#32453](https://github.com/ClickHouse/ClickHouse/pull/32453) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow empty credentials for mongo engine. Closes [#26267](https://github.com/ClickHouse/ClickHouse/issues/26267). [#32460](https://github.com/ClickHouse/ClickHouse/pull/32460) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Improve handling nested structures with missing columns while reading protobuf. Follow-up to https://github.com/ClickHouse/ClickHouse/pull/31988. [#32531](https://github.com/ClickHouse/ClickHouse/pull/32531) ([Vitaly Baranov](https://github.com/vitlibar)).
* Events clause support for window view watch query. [#32607](https://github.com/ClickHouse/ClickHouse/pull/32607) ([vxider](https://github.com/Vxider)).
* Add settings `max_concurrent_select_queries` and `max_concurrent_insert_queries` for control concurrent queries by query kind. Close [#3575](https://github.com/ClickHouse/ClickHouse/issues/3575). [#32609](https://github.com/ClickHouse/ClickHouse/pull/32609) ([SuperDJY](https://github.com/cmsxbc)).
* support Date32 for `genarateRandom` engine. [#32643](https://github.com/ClickHouse/ClickHouse/pull/32643) ([nauta](https://github.com/nautaa)).
* Support authSource option for storage MongoDB. Closes [#32594](https://github.com/ClickHouse/ClickHouse/issues/32594). [#32702](https://github.com/ClickHouse/ClickHouse/pull/32702) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow to control connection timeouts for mysql (previously was supported only for dictionary source). Closes [#16669](https://github.com/ClickHouse/ClickHouse/issues/16669). Previously default connect_timeout was rather small, now it is configurable. [#32734](https://github.com/ClickHouse/ClickHouse/pull/32734) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Flush all In-Memory data parts when WAL is not enabled while shutdown server or detaching table. [#32742](https://github.com/ClickHouse/ClickHouse/pull/32742) ([nauta](https://github.com/nautaa)).
* Improve gRPC compression support for [#28671](https://github.com/ClickHouse/ClickHouse/issues/28671). [#32747](https://github.com/ClickHouse/ClickHouse/pull/32747) ([Vitaly Baranov](https://github.com/vitlibar)).
* Added support for specifying subquery as SQL user defined function. Example: `CREATE FUNCTION test AS () -> (SELECT 1)`. Closes [#30755](https://github.com/ClickHouse/ClickHouse/issues/30755). [#32758](https://github.com/ClickHouse/ClickHouse/pull/32758) ([Maksim Kita](https://github.com/kitaisreal)).
* Support hints for clickhouse-client and clickhouse-local. Closes [#32237](https://github.com/ClickHouse/ClickHouse/issues/32237),. [#32841](https://github.com/ClickHouse/ClickHouse/pull/32841) ([凌涛](https://github.com/lingtaolf)).
* - Do not prepend THREADS_COUNT with -j to avoid additional prepending in subprocesses. [#32844](https://github.com/ClickHouse/ClickHouse/pull/32844) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* Added support for `BIT` data type in `MaterializedMySQL`. Closes [#15182](https://github.com/ClickHouse/ClickHouse/issues/15182), [#32233](https://github.com/ClickHouse/ClickHouse/issues/32233). [#32900](https://github.com/ClickHouse/ClickHouse/pull/32900) ([zzsmdfj](https://github.com/zzsmdfj)).
* More efficient handling of globs for url storage. Closes [#32866](https://github.com/ClickHouse/ClickHouse/issues/32866). [#32907](https://github.com/ClickHouse/ClickHouse/pull/32907) ([Kseniia Sumarokova](https://github.com/kssenii)).
* This only happens in unofficial builds. Fixed segfault when inserting data into compressed Decimal, String, FixedString and Array columns. This closes [#32939](https://github.com/ClickHouse/ClickHouse/issues/32939). [#32940](https://github.com/ClickHouse/ClickHouse/pull/32940) ([N. Kolotov](https://github.com/nkolotov)).
* Dictionaries added `Date32` date type support. Closes [#32913](https://github.com/ClickHouse/ClickHouse/issues/32913). [#32971](https://github.com/ClickHouse/ClickHouse/pull/32971) ([Maksim Kita](https://github.com/kitaisreal)).
* Short circuit evaluation function `throwIf` support. Closes [#32969](https://github.com/ClickHouse/ClickHouse/issues/32969). [#32973](https://github.com/ClickHouse/ClickHouse/pull/32973) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve Bool type serialization and deserialization. [#32984](https://github.com/ClickHouse/ClickHouse/pull/32984) ([Kruglov Pavel](https://github.com/Avogar)).
* Send profile info in clickhouse-local. Closes [#33093](https://github.com/ClickHouse/ClickHouse/issues/33093). [#33097](https://github.com/ClickHouse/ClickHouse/pull/33097) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Inject git information into clickhouse binary file. So we can get source code revision easily from clickhouse binary file. [#33124](https://github.com/ClickHouse/ClickHouse/pull/33124) ([李扬](https://github.com/taiyang-li)).
* Validate config keys for external dictionaries. [#33095](https://github.com/ClickHouse/ClickHouse/issues/33095)#issuecomment-1000577517. [#33130](https://github.com/ClickHouse/ClickHouse/pull/33130) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add retry for Postgres connect in case nothing has been fetched yet. Closes [#33199](https://github.com/ClickHouse/ClickHouse/issues/33199). [#33209](https://github.com/ClickHouse/ClickHouse/pull/33209) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Correctly prevent nullable primary keys if necessary. This is for [#32780](https://github.com/ClickHouse/ClickHouse/issues/32780). [#33218](https://github.com/ClickHouse/ClickHouse/pull/33218) ([Amos Bird](https://github.com/amosbird)).
* If storage supports SETTINGS allow to pass them as key value or via config. Add this support for mysql. [#33231](https://github.com/ClickHouse/ClickHouse/pull/33231) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow to cancel formats Arrow / Parquet / ORC which failed to be cancelled it case of big files and setting input_format_allow_seeks as false. Closes [#29678](https://github.com/ClickHouse/ClickHouse/issues/29678). [#33238](https://github.com/ClickHouse/ClickHouse/pull/33238) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Always display resource usage (total CPU usage, total RAM usage and max RAM usage per host) in client. [#33271](https://github.com/ClickHouse/ClickHouse/pull/33271) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* parseDateTimeBestEffort support Unix Timestamp with Milliseconds. [#33276](https://github.com/ClickHouse/ClickHouse/pull/33276) ([Ben](https://github.com/benbiti)).
* Support moving conditions to `PREWHERE` (setting `optimize_move_to_prewhere`) for tables of `Merge` engine if its all underlying tables supports `PREWHERE`. [#33300](https://github.com/ClickHouse/ClickHouse/pull/33300) ([Anton Popov](https://github.com/CurtizJ)).
* Pressing Ctrl+C twice will terminate `clickhouse-benchmark` immediately without waiting for in-flight queries. This closes [#32586](https://github.com/ClickHouse/ClickHouse/issues/32586). [#33303](https://github.com/ClickHouse/ClickHouse/pull/33303) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* support `<secure/>` in cluster configuration. Close [#33270](https://github.com/ClickHouse/ClickHouse/issues/33270). [#33330](https://github.com/ClickHouse/ClickHouse/pull/33330) ([SuperDJY](https://github.com/cmsxbc)).
* `LineAsString` can be used as output format. This closes [#30919](https://github.com/ClickHouse/ClickHouse/issues/30919). [#33331](https://github.com/ClickHouse/ClickHouse/pull/33331) ([Sergei Trifonov](https://github.com/serxa)).
* Allow negative intervals in function `intervalLengthSum`. Their length will be added as well. This closes [#33323](https://github.com/ClickHouse/ClickHouse/issues/33323). [#33335](https://github.com/ClickHouse/ClickHouse/pull/33335) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* clickhouse-local: track memory under --max_memory_usage_in_client option. [#33341](https://github.com/ClickHouse/ClickHouse/pull/33341) ([Azat Khuzhin](https://github.com/azat)).
* Make installation script working on FreeBSD. This closes [#33384](https://github.com/ClickHouse/ClickHouse/issues/33384). [#33418](https://github.com/ClickHouse/ClickHouse/pull/33418) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add some building options in system.build_options. [#33431](https://github.com/ClickHouse/ClickHouse/pull/33431) ([李扬](https://github.com/taiyang-li)).
* Abuse of `untuple` function was leading to exponential complexity of query analysis (found by fuzzer). This closes [#33297](https://github.com/ClickHouse/ClickHouse/issues/33297). [#33445](https://github.com/ClickHouse/ClickHouse/pull/33445) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add config to enable ipv4 or ipv6. This close [#33381](https://github.com/ClickHouse/ClickHouse/issues/33381). [#33450](https://github.com/ClickHouse/ClickHouse/pull/33450) ([Wu Xueyang](https://github.com/wuxueyang96)).
* add function decodeURLFormComponent. Close [#10298](https://github.com/ClickHouse/ClickHouse/issues/10298). [#33451](https://github.com/ClickHouse/ClickHouse/pull/33451) ([SuperDJY](https://github.com/cmsxbc)).
* Implement Materialized view `getVirtuals` function. Close [#11210](https://github.com/ClickHouse/ClickHouse/issues/11210). [#33482](https://github.com/ClickHouse/ClickHouse/pull/33482) ([zhongyuankai](https://github.com/zhongyuankai)).

#### Bug Fix
* Quota limit was not reached, but the limit was exceeded. This PR fixes [#31174](https://github.com/ClickHouse/ClickHouse/issues/31174). [#31656](https://github.com/ClickHouse/ClickHouse/pull/31656) ([sunny](https://github.com/sunny19930321)).
* - ClickHouse Keeper handler should remove operation when response sent. [#32988](https://github.com/ClickHouse/ClickHouse/pull/32988) ([JackyWoo](https://github.com/JackyWoo)).
* Fix null pointer dereference in low cardinality data when deserializing LowCardinality data in the Native format. [#33021](https://github.com/ClickHouse/ClickHouse/pull/33021) ([Harry Lee](https://github.com/HarryLeeIBM)).
* Specifically crafted input data for `Native` format may lead to reading uninitialized memory or crash. This is relevant if `clickhouse-server` is open for write access to adversary. [#33050](https://github.com/ClickHouse/ClickHouse/pull/33050) ([Heena Bansal](https://github.com/HeenaBansal2009)).

#### Build/Testing/Packaging Improvement
* - Add arm64 packages - Stream python logs in realtime with `PYTHONUNBUFFERED=1` - Fix building docker images in docker/packager/packager script. [#32415](https://github.com/ClickHouse/ClickHouse/pull/32415) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Terminate build when linker path not found. [#32437](https://github.com/ClickHouse/ClickHouse/pull/32437) ([JackyWoo](https://github.com/JackyWoo)).
* - Create a global ENV per job - Clean CCACHE after a build is over. [#32478](https://github.com/ClickHouse/ClickHouse/pull/32478) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* PENDING (Should mention submodule updates and versions). [#32484](https://github.com/ClickHouse/ClickHouse/pull/32484) ([Raúl Marín](https://github.com/Algunenano)).
* Remove readline support. [#32574](https://github.com/ClickHouse/ClickHouse/pull/32574) ([Azat Khuzhin](https://github.com/azat)).
* Fix build issue related to azure blob storage. [#32788](https://github.com/ClickHouse/ClickHouse/pull/32788) ([Amos Bird](https://github.com/amosbird)).
* - Unify init scripts for every worker runner type - Install pigz in AMI. [#32800](https://github.com/ClickHouse/ClickHouse/pull/32800) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Use all available in container processors for PVS studio check and fast tests. Delete coverage image. [#32854](https://github.com/ClickHouse/ClickHouse/pull/32854) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* - Rename main to pull_request - Add BuilderDebAarch64 to all workflows - Use docker buildkit, save building cache to docker hub and reuse it - Build x86_64 and arm64 docker images separately, then merge them together to a multi-architecture manifest - Tune many docker images to being multi-architecture - Use the images from the current PR/commit in the following dependent builds - Upgrade mysql client in stateless-tests image - Add functional tests for aarch64 for PR actions (forced green for a while) - Add python typing to some scripts - Add docker buildkit to runners' init script - Add func-tester-aarch64 runners - Use `docker login --password-stdin` to not expose password on exception. [#32911](https://github.com/ClickHouse/ClickHouse/pull/32911) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Enable hermetic build for shared builds. This is mainly for developers. [#32968](https://github.com/ClickHouse/ClickHouse/pull/32968) ([Amos Bird](https://github.com/amosbird)).
* Prepare ClickHouse to be built with musl-libc. It is not enabled by default. [#33134](https://github.com/ClickHouse/ClickHouse/pull/33134) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a simple tool to visualize flaky tests in web browser. [#33185](https://github.com/ClickHouse/ClickHouse/pull/33185) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid strict checking when `ENABLE_AZURE_BLOB_STORAGE = 0`. https://github.com/ClickHouse/ClickHouse/pull/32948#discussion_r773168611 cc @nikitamikhaylov. [#33219](https://github.com/ClickHouse/ClickHouse/pull/33219) ([Amos Bird](https://github.com/amosbird)).
* Add more tests for the nullable primary key feature. Add more tests with different types and merge tree kinds, plus randomly generated data. [#33228](https://github.com/ClickHouse/ClickHouse/pull/33228) ([Amos Bird](https://github.com/amosbird)).
* Don't use particular encoding for diff-strings, it may contain multiple different encodings. [#33336](https://github.com/ClickHouse/ClickHouse/pull/33336) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Avoid strict checking when ENABLE_AZURE_BLOB_STORAGE = 0. This is another try on behalf of https://github.com/ClickHouse/ClickHouse/pull/33219 , which was reverted likely due to CI issues. [#33346](https://github.com/ClickHouse/ClickHouse/pull/33346) ([Amos Bird](https://github.com/amosbird)).
* During migration from Yandex to github actions we've lost static links to the latest master ([doc](https://clickhouse.com/docs/en/getting-started/install/#from-single-binary)) It solves issue [#33480](https://github.com/ClickHouse/ClickHouse/issues/33480) partially. [#33559](https://github.com/ClickHouse/ClickHouse/pull/33559) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Restore a lost description checking. [#33591](https://github.com/ClickHouse/ClickHouse/pull/33591) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add `actionlint` for workflows and verify workflow files via `act --list` to check the correct workflow syntax. [#33612](https://github.com/ClickHouse/ClickHouse/pull/33612) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Remove editing /etc/hosts from Dockerfile. [#33635](https://github.com/ClickHouse/ClickHouse/pull/33635) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Properly separate thrift-cmake from arrow-cmake after https://github.com/ClickHouse/ClickHouse/pull/31104 . cc @taiyang-li. [#33661](https://github.com/ClickHouse/ClickHouse/pull/33661) ([Amos Bird](https://github.com/amosbird)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* Fixed CAST from String to IPv4 or IPv6 and back. Fixed error message in case of failed conversion. [#29224](https://github.com/ClickHouse/ClickHouse/pull/29224) ([Dmitry Novik](https://github.com/novikd)).
* Fix base64Encode adding trailing bytes on small strings. [#31797](https://github.com/ClickHouse/ClickHouse/pull/31797) ([Kevin Michel](https://github.com/kmichel-aiven)).
* Fix unexpected projection removal when detaching parts. [#32067](https://github.com/ClickHouse/ClickHouse/pull/32067) ([Amos Bird](https://github.com/amosbird)).
* Fix 'APPLY lambda' parsing which could lead to client/server crash. [#32138](https://github.com/ClickHouse/ClickHouse/pull/32138) ([Kruglov Pavel](https://github.com/Avogar)).
* Some replication queue entries might hang for `temporary_directories_lifetime` (1 day by default) with `Directory tmp_merge_<part_name>` or `Part ... (state Deleting) already exists, but it will be deleted soon` or similar error. It's fixed. Fixes [#29616](https://github.com/ClickHouse/ClickHouse/issues/29616). [#32201](https://github.com/ClickHouse/ClickHouse/pull/32201) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix unix timestamp Millisecond convert to DateTime64, fractional part calc reversed. [#32240](https://github.com/ClickHouse/ClickHouse/pull/32240) ([Ben](https://github.com/benbiti)).
* Fix broken select query when there are more than 2 row policies on same column, begin at second queries on the same session. [#31606](https://github.com/ClickHouse/ClickHouse/issues/31606). [#32291](https://github.com/ClickHouse/ClickHouse/pull/32291) ([SuperDJY](https://github.com/cmsxbc)).
* Fix failures in queries that are trying to use skipping indices, which are not materialized yet. Fixes [#32292](https://github.com/ClickHouse/ClickHouse/issues/32292) and [#30343](https://github.com/ClickHouse/ClickHouse/issues/30343). [#32359](https://github.com/ClickHouse/ClickHouse/pull/32359) ([Anton Popov](https://github.com/CurtizJ)).
* Fix issue with ambiguous query formatting in distributed queries that led to errors when some table columns were named ALL or DISTINCT. This closes [#32391](https://github.com/ClickHouse/ClickHouse/issues/32391). [#32490](https://github.com/ClickHouse/ClickHouse/pull/32490) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The Proper handle of the case with apache arrow column duplication. [#32507](https://github.com/ClickHouse/ClickHouse/pull/32507) ([Dmitriy Mokhnatkin](https://github.com/DMokhnatkin)).
* Fix crash in `JoinCommon::removeColumnNullability`, close [#32458](https://github.com/ClickHouse/ClickHouse/issues/32458). [#32508](https://github.com/ClickHouse/ClickHouse/pull/32508) ([Vladimir C](https://github.com/vdimir)).
* fix groupBitmapAnd function on distributed table. [#32529](https://github.com/ClickHouse/ClickHouse/pull/32529) ([minhthucdao](https://github.com/dmthuc)).
* Fix async inserts with formats CustomSeparated, Template, Regexp, MsgPack and JSONAsString. Previousely async inserts with these formats didn't read any data. [#32530](https://github.com/ClickHouse/ClickHouse/pull/32530) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix sparse_hashed dict performance with sequential keys (wrong hash function). [#32536](https://github.com/ClickHouse/ClickHouse/pull/32536) ([Azat Khuzhin](https://github.com/azat)).
* Fix table lifetime (i.e. possible use-after-free) in case of parallel DROP TABLE and INSERT. [#32572](https://github.com/ClickHouse/ClickHouse/pull/32572) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible exception at RabbitMQ storage startup by delaying channel creation. [#32584](https://github.com/ClickHouse/ClickHouse/pull/32584) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix surprisingly bad code in function `file`. [#32640](https://github.com/ClickHouse/ClickHouse/pull/32640) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* close [#32504](https://github.com/ClickHouse/ClickHouse/issues/32504). [#32649](https://github.com/ClickHouse/ClickHouse/pull/32649) ([Vladimir C](https://github.com/vdimir)).
* Fix LOGICAL_ERROR when the target of a materialized view is a JOIN or a SET table. [#32669](https://github.com/ClickHouse/ClickHouse/pull/32669) ([Raúl Marín](https://github.com/Algunenano)).
* Fix `optimize_read_in_order` optimization in case when table engine is `Distributed` or `Merge` and its underlying `MergeTree` tables have monotonous function in prefix of sorting key. [#32670](https://github.com/ClickHouse/ClickHouse/pull/32670) ([Anton Popov](https://github.com/CurtizJ)).
* Fix `ALTER TABLE ... MATERIALIZE TTL` query with `TTL ... DELETE WHERE ...` and `TTL ... GROUP BY ...` modes. [#32695](https://github.com/ClickHouse/ClickHouse/pull/32695) ([Anton Popov](https://github.com/CurtizJ)).
* Fix error `Column is not under aggregate function` in case of MV with `GROUP BY (list of columns)` (which is pared as `GROUP BY tuple(...)`) over Kafka/RabbitMQ. Fixes [#32668](https://github.com/ClickHouse/ClickHouse/issues/32668) and [#32744](https://github.com/ClickHouse/ClickHouse/issues/32744). [#32751](https://github.com/ClickHouse/ClickHouse/pull/32751) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* fix crash when used fuzzBits with multiply same FixedString, Close [#32737](https://github.com/ClickHouse/ClickHouse/issues/32737). [#32755](https://github.com/ClickHouse/ClickHouse/pull/32755) ([SuperDJY](https://github.com/cmsxbc)).
* Fix `--database` option for clickhouse-local. [#32797](https://github.com/ClickHouse/ClickHouse/pull/32797) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Server might fail to start if database with `MySQL` engine cannot connect to MySQL server, it's fixed. Fixes [#14441](https://github.com/ClickHouse/ClickHouse/issues/14441). [#32802](https://github.com/ClickHouse/ClickHouse/pull/32802) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Avoid reusing the scalar subquery cache when processing MV blocks. This fixes a bug when the scalar query reference the source table but it means that all subscalar queries in the MV definition will be calculated for each block. [#32811](https://github.com/ClickHouse/ClickHouse/pull/32811) ([Raúl Marín](https://github.com/Algunenano)).
* `MergeTree` table engine might silently skip some mutations if there are too many running mutations or in case of high memory consumption, it's fixed. Fixes [#17882](https://github.com/ClickHouse/ClickHouse/issues/17882). [#32814](https://github.com/ClickHouse/ClickHouse/pull/32814) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix optimization with lazy seek for async reads from remote fs. Closes [#32803](https://github.com/ClickHouse/ClickHouse/issues/32803). [#32835](https://github.com/ClickHouse/ClickHouse/pull/32835) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed --echo option is not used by clickhouse-client in batch mode with single query. [#32843](https://github.com/ClickHouse/ClickHouse/pull/32843) ([N. Kolotov](https://github.com/nkolotov)).
* Fix MV query with multiple chunk result. Fixes [#31419](https://github.com/ClickHouse/ClickHouse/issues/31419). [#32862](https://github.com/ClickHouse/ClickHouse/pull/32862) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Close [#32487](https://github.com/ClickHouse/ClickHouse/issues/32487). [#32914](https://github.com/ClickHouse/ClickHouse/pull/32914) ([Vladimir C](https://github.com/vdimir)).
* Fix ORC stripe reading. [#32929](https://github.com/ClickHouse/ClickHouse/pull/32929) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* Fix a regression in `replaceRegexpAll` function. The function worked incorrectly when matched substring was empty. This closes [#32777](https://github.com/ClickHouse/ClickHouse/issues/32777). This closes [#30245](https://github.com/ClickHouse/ClickHouse/issues/30245). [#32945](https://github.com/ClickHouse/ClickHouse/pull/32945) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UB in case of unexpected EOF during filling a set from HTTP query (i.e. if the client interrupted in the middle, i.e. `timeout 0.15s curl -Ss -F 's=@t.csv;' 'http://127.0.0.1:8123/?s_structure=key+Int&query=SELECT+dummy+IN+s'` and with large enough `t.csv`). [#32955](https://github.com/ClickHouse/ClickHouse/pull/32955) ([Azat Khuzhin](https://github.com/azat)).
* Fix throwing exception like positional argument out of bounds for non-positional arguments. Closes [#31173](https://github.com/ClickHouse/ClickHouse/issues/31173)#event-5789668239. [#32961](https://github.com/ClickHouse/ClickHouse/pull/32961) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix hdfs url check that didn't allow using HA namenode address. Bug was introduced in https://github.com/ClickHouse/ClickHouse/pull/31042. [#32976](https://github.com/ClickHouse/ClickHouse/pull/32976) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix wrong tuple output in CSV format in case of custom csv delimiter. [#32981](https://github.com/ClickHouse/ClickHouse/pull/32981) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix Context leak in case of cancel_http_readonly_queries_on_client_close (i.e. leaking of external tables that had been uploaded the the server and other resources). [#32982](https://github.com/ClickHouse/ClickHouse/pull/32982) ([Azat Khuzhin](https://github.com/azat)).
* Remove obsolete code from ConfigProcessor. Yandex specific code is not used anymore. The code contained one minor defect. This defect was reported by [Mallik Hassan](https://github.com/SadiHassan) in [#33032](https://github.com/ClickHouse/ClickHouse/issues/33032). This closes [#33032](https://github.com/ClickHouse/ClickHouse/issues/33032). [#33026](https://github.com/ClickHouse/ClickHouse/pull/33026) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix s3 table function reading empty file. Closes [#33008](https://github.com/ClickHouse/ClickHouse/issues/33008). [#33037](https://github.com/ClickHouse/ClickHouse/pull/33037) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix error `Invalid version for SerializationLowCardinality key column` in case of reading from `LowCardinality` column with `local_filesystem_read_prefetch` or `remote_filesystem_read_prefetch` enabled. [#33046](https://github.com/ClickHouse/ClickHouse/pull/33046) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Don't allow to write into S3 if path contains globs. [#33142](https://github.com/ClickHouse/ClickHouse/pull/33142) ([Kruglov Pavel](https://github.com/Avogar)).
* fix incorrect metric: StorageBufferBytes. [#33159](https://github.com/ClickHouse/ClickHouse/pull/33159) ([xuyatian](https://github.com/xuyatian)).
* Fix MaterializedPostreSQL detach/attach (removing / adding to replication) tables with non-default schema. Found in [#29535](https://github.com/ClickHouse/ClickHouse/issues/29535). [#33179](https://github.com/ClickHouse/ClickHouse/pull/33179) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make sure unused replication slots are always removed. Found in [#26952](https://github.com/ClickHouse/ClickHouse/issues/26952),. [#33187](https://github.com/ClickHouse/ClickHouse/pull/33187) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix ddl validation. Fix setting `materialized_postgresql_allow_automatic_update`. Closes [#29535](https://github.com/ClickHouse/ClickHouse/issues/29535). [#33200](https://github.com/ClickHouse/ClickHouse/pull/33200) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix WHERE 1=0 for external databases query. Closes [#33152](https://github.com/ClickHouse/ClickHouse/issues/33152). [#33214](https://github.com/ClickHouse/ClickHouse/pull/33214) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add asynchronous inserts (with enabled setting `async_insert`) to query log. Previously such queries didn't appear in query log. [#33239](https://github.com/ClickHouse/ClickHouse/pull/33239) ([Anton Popov](https://github.com/CurtizJ)).
* Fix ACLMap num, because acl_to_num will erase. [#33246](https://github.com/ClickHouse/ClickHouse/pull/33246) ([小路](https://github.com/nicelulu)).
* Fix ACL with explicit digit hash in clickhouse-keeper: now the behavior consistent with zookeeper and generated digest is always accepted. [#33249](https://github.com/ClickHouse/ClickHouse/pull/33249) ([小路](https://github.com/nicelulu)).
* Fix when `COMMENT` for dictionaries does not appear in `system.tables`, `system.dictionaries`. Allow to modify comment for `Dictionary` engine. Closes [#33251](https://github.com/ClickHouse/ClickHouse/issues/33251). [#33261](https://github.com/ClickHouse/ClickHouse/pull/33261) ([Maksim Kita](https://github.com/kitaisreal)).
* The commands `SYSTEM SUSPEND` and `SYSTEM ... THREAD FUZZER` missed access control. It is fixed. Author: Kevin Michel. [#33333](https://github.com/ClickHouse/ClickHouse/pull/33333) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not try to read pass EOF (to workaround a bug in a kernel), this bug can be reproduced on kernels (3.14..5.9), and requires `index_granularity_bytes=0` (i.e. turn off adaptive index granularity). [#33372](https://github.com/ClickHouse/ClickHouse/pull/33372) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible use-after-free for INSERT into MV with concurrent DROP ([#32572](https://github.com/ClickHouse/ClickHouse/issues/32572) significantly reduce the race window, this one should completely eliminate it). [#33386](https://github.com/ClickHouse/ClickHouse/pull/33386) ([Azat Khuzhin](https://github.com/azat)).
* Fix query cancellation in case of allow_experimental_parallel_reading_from_replicas. [#33456](https://github.com/ClickHouse/ClickHouse/pull/33456) ([Azat Khuzhin](https://github.com/azat)).
* Fix DROP MaterializedPostgreSQL database. [#33468](https://github.com/ClickHouse/ClickHouse/pull/33468) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix dictionary expressions for RangeHashedDictionary range min and range max attributes when created using DDL. Closes [#30809](https://github.com/ClickHouse/ClickHouse/issues/30809). [#33478](https://github.com/ClickHouse/ClickHouse/pull/33478) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix an exception `Block structure mismatch` which may happen during insertion into table with default nested `LowCardinality` column. Fixes [#33028](https://github.com/ClickHouse/ClickHouse/issues/33028). [#33504](https://github.com/ClickHouse/ClickHouse/pull/33504) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Close issue: [#33289](https://github.com/ClickHouse/ClickHouse/issues/33289) Fix bug when query view with setting offset and limit. [#33518](https://github.com/ClickHouse/ClickHouse/pull/33518) ([hexiaoting](https://github.com/hexiaoting)).
* Fix parsing incorrect queries with FROM INFILE statement. [#33521](https://github.com/ClickHouse/ClickHouse/pull/33521) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix segfault in arrowSchemaToCHHeader if schema contains Dictionary type. Closes [#33507](https://github.com/ClickHouse/ClickHouse/issues/33507). [#33529](https://github.com/ClickHouse/ClickHouse/pull/33529) ([Kruglov Pavel](https://github.com/Avogar)).
* session_id_counter poniter to next slot. [#33555](https://github.com/ClickHouse/ClickHouse/pull/33555) ([小路](https://github.com/nicelulu)).
* Fix segfault in Avro that appears after the second insert into file. [#33566](https://github.com/ClickHouse/ClickHouse/pull/33566) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix wrong database for JOIN w/o explicit database in distributed queries (Fixes: [#10471](https://github.com/ClickHouse/ClickHouse/issues/10471)). [#33611](https://github.com/ClickHouse/ClickHouse/pull/33611) ([Azat Khuzhin](https://github.com/azat)).

#### Bug Fix (user-visible misbehaviour in official stable release):

* Fix possible crash (or incorrect result) in case of `LowCardinality` arguments of window function. Fixes [#31114](https://github.com/ClickHouse/ClickHouse/issues/31114). [#31888](https://github.com/ClickHouse/ClickHouse/pull/31888) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Bug Fix (v21.9.4.35-stable)

* Fix [#32964](https://github.com/ClickHouse/ClickHouse/issues/32964). [#32965](https://github.com/ClickHouse/ClickHouse/pull/32965) ([save-my-heart](https://github.com/save-my-heart)).

#### NO CL CATEGORY

* Fix Regular Expression while key path search. [#33023](https://github.com/ClickHouse/ClickHouse/pull/33023) ([mreddy017](https://github.com/mreddy017)).
* - Allow to split GraphiteMergeTree rollup rules for plain/tagged metrics (optional rule_type field). [#33494](https://github.com/ClickHouse/ClickHouse/pull/33494) ([Michail Safronov](https://github.com/msaf1980)).

#### NO CL ENTRY

* NO CL ENTRY:  'Update CHANGELOG.md'. [#32472](https://github.com/ClickHouse/ClickHouse/pull/32472) ([Rich Raposa](https://github.com/rfraposa)).
* NO CL ENTRY:  'Revert "Split long tests into multiple checks"'. [#32514](https://github.com/ClickHouse/ClickHouse/pull/32514) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Revert "Split long tests into multiple checks""'. [#32515](https://github.com/ClickHouse/ClickHouse/pull/32515) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'blog post how to enable predictive capabilities in ClickHouse'. [#32768](https://github.com/ClickHouse/ClickHouse/pull/32768) ([Tom Risse](https://github.com/flickerbox-tom)).
* NO CL ENTRY:  'Revert "Fix build issue related to azure blob storage"'. [#32845](https://github.com/ClickHouse/ClickHouse/pull/32845) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Dictionaries added Date32 type support"'. [#33053](https://github.com/ClickHouse/ClickHouse/pull/33053) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Updated Lawrence Berkeley National Lab stats'. [#33066](https://github.com/ClickHouse/ClickHouse/pull/33066) ([Michael Smitasin](https://github.com/michaelsmitasin)).
* NO CL ENTRY:  'fix AggregateFunctionGroupBitmapData function rb_contains rb_remove'. [#33127](https://github.com/ClickHouse/ClickHouse/pull/33127) ([DR](https://github.com/freedomDR)).
* NO CL ENTRY:  'Fix for example request with settings'. [#33143](https://github.com/ClickHouse/ClickHouse/pull/33143) ([Vitaly Artemyev](https://github.com/VitalyArt)).
* NO CL ENTRY:  'Revert "Grouping sets dev"'. [#33186](https://github.com/ClickHouse/ClickHouse/pull/33186) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Optimize MergeTreePartsMover'. [#33225](https://github.com/ClickHouse/ClickHouse/pull/33225) ([zhongyuankai](https://github.com/zhongyuankai)).
* NO CL ENTRY:  'rm redundant judge in hashmap iter operation'. [#33285](https://github.com/ClickHouse/ClickHouse/pull/33285) ([zbtzbtzbt](https://github.com/zbtzbtzbt)).
* NO CL ENTRY:  'fix hang up with command 'drop table system.query_log sync''. [#33293](https://github.com/ClickHouse/ClickHouse/pull/33293) ([zhanghuajie](https://github.com/zhanghuajieHIT)).
* NO CL ENTRY:  'Improve query performance of system tables'. [#33312](https://github.com/ClickHouse/ClickHouse/pull/33312) ([zhongyuankai](https://github.com/zhongyuankai)).
* NO CL ENTRY:  'Revert "Better cmake script for azure blob"'. [#33319](https://github.com/ClickHouse/ClickHouse/pull/33319) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Added Superwall to adopters list'. [#33573](https://github.com/ClickHouse/ClickHouse/pull/33573) ([Justin Hilliard](https://github.com/jahilliard)).
* NO CL ENTRY:  'Revert "Ignore parse failure of opentelemetry header"'. [#33594](https://github.com/ClickHouse/ClickHouse/pull/33594) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Merging [#26074](https://github.com/ClickHouse/ClickHouse/issues/26074) [#26559](https://github.com/ClickHouse/ClickHouse/pull/26559) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix data race in ProtobufSchemas [#27822](https://github.com/ClickHouse/ClickHouse/pull/27822) ([filimonov](https://github.com/filimonov)).
* Add performance tests to new CI [#31467](https://github.com/ClickHouse/ClickHouse/pull/31467) ([alesapin](https://github.com/alesapin)).
* refactor CI tests [#31882](https://github.com/ClickHouse/ClickHouse/pull/31882) ([Constantine Peresypkin](https://github.com/pkit)).
* Add ability to drain connections synchronously [#31965](https://github.com/ClickHouse/ClickHouse/pull/31965) ([Azat Khuzhin](https://github.com/azat)).
* Add docker container for AWS lambda [#32205](https://github.com/ClickHouse/ClickHouse/pull/32205) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* test for [#28280](https://github.com/ClickHouse/ClickHouse/issues/28280) [#32235](https://github.com/ClickHouse/ClickHouse/pull/32235) ([Denny Crane](https://github.com/den-crane)).
* Rename window functions in WindowView [#32324](https://github.com/ClickHouse/ClickHouse/pull/32324) ([vxider](https://github.com/Vxider)).
* Follow-up to [#32140](https://github.com/ClickHouse/ClickHouse/issues/32140) [#32389](https://github.com/ClickHouse/ClickHouse/pull/32389) ([Alexander Tokmakov](https://github.com/tavplubix)).
* clickhouse-local: fix CREATE DATABASE with Atomic engine [#32417](https://github.com/ClickHouse/ClickHouse/pull/32417) ([Azat Khuzhin](https://github.com/azat)).
* Add a test [#16171](https://github.com/ClickHouse/ClickHouse/issues/16171) [#32421](https://github.com/ClickHouse/ClickHouse/pull/32421) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix images names in integration tests [#32438](https://github.com/ClickHouse/ClickHouse/pull/32438) ([alesapin](https://github.com/alesapin)).
* Fix build check empty report [#32440](https://github.com/ClickHouse/ClickHouse/pull/32440) ([alesapin](https://github.com/alesapin)).
* Fix ASTFuzzer [#32447](https://github.com/ClickHouse/ClickHouse/pull/32447) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Try fix attaching gdb in tests [#32448](https://github.com/ClickHouse/ClickHouse/pull/32448) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix arraySlice with null args. [#32456](https://github.com/ClickHouse/ClickHouse/pull/32456) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix unit tests (ubsan) on master [#32459](https://github.com/ClickHouse/ClickHouse/pull/32459) ([alesapin](https://github.com/alesapin)).
* Remove dependency between integration and functional tests [#32461](https://github.com/ClickHouse/ClickHouse/pull/32461) ([alesapin](https://github.com/alesapin)).
* Add automatic workflow rerun [#32462](https://github.com/ClickHouse/ClickHouse/pull/32462) ([alesapin](https://github.com/alesapin)).
* Fix crash in case of MATERIALIZE COLUMN with no default expression. [#32464](https://github.com/ClickHouse/ClickHouse/pull/32464) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update odbc-bridge.md [#32475](https://github.com/ClickHouse/ClickHouse/pull/32475) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix test_prometheus_endpoint [#32476](https://github.com/ClickHouse/ClickHouse/pull/32476) ([Vladimir C](https://github.com/vdimir)).
* 02122_parallel_formatting: Address grep binary warnings [#32477](https://github.com/ClickHouse/ClickHouse/pull/32477) ([Raúl Marín](https://github.com/Algunenano)).
* 01950_kill_large_group_by_query: Increase timeout [#32479](https://github.com/ClickHouse/ClickHouse/pull/32479) ([Raúl Marín](https://github.com/Algunenano)).
* Fix backport workflow [#32485](https://github.com/ClickHouse/ClickHouse/pull/32485) ([alesapin](https://github.com/alesapin)).
* Make 01675_distributed_bytes_to_delay_insert less flaky (use http over client) [#32492](https://github.com/ClickHouse/ClickHouse/pull/32492) ([Azat Khuzhin](https://github.com/azat)).
* Fix 02050_client_profile_events flakiness [#32493](https://github.com/ClickHouse/ClickHouse/pull/32493) ([Azat Khuzhin](https://github.com/azat)).
* Fix integration tests docker images path [#32494](https://github.com/ClickHouse/ClickHouse/pull/32494) ([alesapin](https://github.com/alesapin)).
* Split long tests into multiple checks [#32496](https://github.com/ClickHouse/ClickHouse/pull/32496) ([alesapin](https://github.com/alesapin)).
* Add test for clickhouse-client history navigation [#32497](https://github.com/ClickHouse/ClickHouse/pull/32497) ([Amos Bird](https://github.com/amosbird)).
* Rename window-view function to time window function [#32498](https://github.com/ClickHouse/ClickHouse/pull/32498) ([vxider](https://github.com/Vxider)).
* Disable flaky tests with Window View [#32500](https://github.com/ClickHouse/ClickHouse/pull/32500) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix flaky window view tests [#32503](https://github.com/ClickHouse/ClickHouse/pull/32503) ([vxider](https://github.com/Vxider)).
* Fix queries with hasColumnInTable constant condition and non existing column [#32506](https://github.com/ClickHouse/ClickHouse/pull/32506) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Try to fix attaching gdb 2 [#32511](https://github.com/ClickHouse/ClickHouse/pull/32511) ([Alexander Tokmakov](https://github.com/tavplubix)).
* clickhouse-test: use basename of the test for *.sh tests [#32533](https://github.com/ClickHouse/ClickHouse/pull/32533) ([Azat Khuzhin](https://github.com/azat)).
* Fix processing initial table (--table/stdin) in clickhouse-local [#32534](https://github.com/ClickHouse/ClickHouse/pull/32534) ([Azat Khuzhin](https://github.com/azat)).
* Suppress UBSan errors for avg() function [#32535](https://github.com/ClickHouse/ClickHouse/pull/32535) ([Azat Khuzhin](https://github.com/azat)).
* Fix LOGICAL_ERROR for MATERIALIZED VIEW over table functions (i.e. numbers()) [#32571](https://github.com/ClickHouse/ClickHouse/pull/32571) ([Azat Khuzhin](https://github.com/azat)).
* Improve quota's end-of-interval calculations. [#32575](https://github.com/ClickHouse/ClickHouse/pull/32575) ([Vitaly Baranov](https://github.com/vitlibar)).
* remove unused headers in test [#32578](https://github.com/ClickHouse/ClickHouse/pull/32578) ([Bharat Nallan](https://github.com/bharatnc)).
* Remove arcadia build support [#32580](https://github.com/ClickHouse/ClickHouse/pull/32580) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup perf test runner [#32582](https://github.com/ClickHouse/ClickHouse/pull/32582) ([Azat Khuzhin](https://github.com/azat)).
* [RFC] perf: do not fail in case of slow queries (to avoid hiding possible issues) [#32583](https://github.com/ClickHouse/ClickHouse/pull/32583) ([Azat Khuzhin](https://github.com/azat)).
* Add test for issue 28316 [#32585](https://github.com/ClickHouse/ClickHouse/pull/32585) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bad test [#32571](https://github.com/ClickHouse/ClickHouse/issues/32571) [#32588](https://github.com/ClickHouse/ClickHouse/pull/32588) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix perf test `reinterpret_as` [#32589](https://github.com/ClickHouse/ClickHouse/pull/32589) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix indecent error message [#32591](https://github.com/ClickHouse/ClickHouse/pull/32591) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix strange code in TCPHandler [#32592](https://github.com/ClickHouse/ClickHouse/pull/32592) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: upload logs if task failed [#32618](https://github.com/ClickHouse/ClickHouse/pull/32618) ([Alexander Tokmakov](https://github.com/tavplubix)).
* clickhouse-test: avoid failing with UNKNOWN status in some cases [#32625](https://github.com/ClickHouse/ClickHouse/pull/32625) ([Azat Khuzhin](https://github.com/azat)).
* avoid inconsistent state in Block [#32641](https://github.com/ClickHouse/ClickHouse/pull/32641) ([gulige](https://github.com/gulige)).
* Rerun workflows more times [#32642](https://github.com/ClickHouse/ClickHouse/pull/32642) ([alesapin](https://github.com/alesapin)).
* Remove flaky check from master and split asan test [#32645](https://github.com/ClickHouse/ClickHouse/pull/32645) ([alesapin](https://github.com/alesapin)).
* Split database replicated [#32650](https://github.com/ClickHouse/ClickHouse/pull/32650) ([alesapin](https://github.com/alesapin)).
* Improve exceptions usage in access control [#32662](https://github.com/ClickHouse/ClickHouse/pull/32662) ([Vitaly Baranov](https://github.com/vitlibar)).
* Follow-up to [#32140](https://github.com/ClickHouse/ClickHouse/issues/32140) [#32667](https://github.com/ClickHouse/ClickHouse/pull/32667) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add test_s3_zero_copy_concurrent_merge [#32694](https://github.com/ClickHouse/ClickHouse/pull/32694) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Check trusted contributors in lowercase [#32696](https://github.com/ClickHouse/ClickHouse/pull/32696) ([Vladimir C](https://github.com/vdimir)).
* Mention ClickHouse CLA in CONTRIBUTING.md [#32697](https://github.com/ClickHouse/ClickHouse/pull/32697) ([Ivan Blinkov](https://github.com/blinkov)).
* Rerun release workflows [#32701](https://github.com/ClickHouse/ClickHouse/pull/32701) ([alesapin](https://github.com/alesapin)).
* plausible analytic blog post [#32719](https://github.com/ClickHouse/ClickHouse/pull/32719) ([Tom Risse](https://github.com/flickerbox-tom)).
* Update backport.py [#32720](https://github.com/ClickHouse/ClickHouse/pull/32720) ([Kruglov Pavel](https://github.com/Avogar)).
* Pass -no-pie to the linker call to disable it [#32731](https://github.com/ClickHouse/ClickHouse/pull/32731) ([Raúl Marín](https://github.com/Algunenano)).
* Add severity table to support case form [#32736](https://github.com/ClickHouse/ClickHouse/pull/32736) ([Cody Baker](https://github.com/codyrobert)).
* tests/integration: fix wait_start()/start_clickhouse() [#32739](https://github.com/ClickHouse/ClickHouse/pull/32739) ([Azat Khuzhin](https://github.com/azat)).
* tests/integration: fix waiting of mysql client container [#32740](https://github.com/ClickHouse/ClickHouse/pull/32740) ([Azat Khuzhin](https://github.com/azat)).
* Better control build artifacts [#32745](https://github.com/ClickHouse/ClickHouse/pull/32745) ([alesapin](https://github.com/alesapin)).
* Fix race in skipping index of type `hypothesis` [#32756](https://github.com/ClickHouse/ClickHouse/pull/32756) ([Anton Popov](https://github.com/CurtizJ)).
* Fix build performance [#32766](https://github.com/ClickHouse/ClickHouse/pull/32766) ([alesapin](https://github.com/alesapin)).
* Add test for issue 26912 [#32771](https://github.com/ClickHouse/ClickHouse/pull/32771) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a test for CAST to named tuple just in case. [#32776](https://github.com/ClickHouse/ClickHouse/pull/32776) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix performance build [#32796](https://github.com/ClickHouse/ClickHouse/pull/32796) ([alesapin](https://github.com/alesapin)).
* Trying another stress servers [#32798](https://github.com/ClickHouse/ClickHouse/pull/32798) ([alesapin](https://github.com/alesapin)).
* More diagnostics in gdb script [#32801](https://github.com/ClickHouse/ClickHouse/pull/32801) ([Alexander Tokmakov](https://github.com/tavplubix)).
* CacheDictionary dictionary source access race fix [#32805](https://github.com/ClickHouse/ClickHouse/pull/32805) ([Maksim Kita](https://github.com/kitaisreal)).
* Update NuRaft [#32808](https://github.com/ClickHouse/ClickHouse/pull/32808) ([alesapin](https://github.com/alesapin)).
* Add retries to curl in performance tests. [#32809](https://github.com/ClickHouse/ClickHouse/pull/32809) ([alesapin](https://github.com/alesapin)).
* Made Azure blob storage to obey ENABLE_LIBRARIES flag [#32815](https://github.com/ClickHouse/ClickHouse/pull/32815) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Remove recursive submodules [#32820](https://github.com/ClickHouse/ClickHouse/pull/32820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* test for summap nullable(0) [#32822](https://github.com/ClickHouse/ClickHouse/pull/32822) ([Denny Crane](https://github.com/den-crane)).
* Update CHANGELOG.md [#32823](https://github.com/ClickHouse/ClickHouse/pull/32823) ([Denny Crane](https://github.com/den-crane)).
* Make `test_storage_s3` less flaky [#32825](https://github.com/ClickHouse/ClickHouse/pull/32825) ([Azat Khuzhin](https://github.com/azat)).
* Fix error message for reading from url [#32826](https://github.com/ClickHouse/ClickHouse/pull/32826) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Revert docs release [#32827](https://github.com/ClickHouse/ClickHouse/pull/32827) ([alesapin](https://github.com/alesapin)).
* Fix docs release one more time [#32828](https://github.com/ClickHouse/ClickHouse/pull/32828) ([alesapin](https://github.com/alesapin)).
* Trigger also for workflows changes [#32830](https://github.com/ClickHouse/ClickHouse/pull/32830) ([alesapin](https://github.com/alesapin)).
* Fix docs release one more time [#32831](https://github.com/ClickHouse/ClickHouse/pull/32831) ([alesapin](https://github.com/alesapin)).
* Add dispatch event to docs release [#32832](https://github.com/ClickHouse/ClickHouse/pull/32832) ([alesapin](https://github.com/alesapin)).
* Remove repository before checkout [#32834](https://github.com/ClickHouse/ClickHouse/pull/32834) ([alesapin](https://github.com/alesapin)).
* Fix release branches filter [#32837](https://github.com/ClickHouse/ClickHouse/pull/32837) ([alesapin](https://github.com/alesapin)).
* StorageLiveView fix function style [#32838](https://github.com/ClickHouse/ClickHouse/pull/32838) ([Maksim Kita](https://github.com/kitaisreal)).
* Try fix flaky test: order for test_s3_zero_copy_replication [#32846](https://github.com/ClickHouse/ClickHouse/pull/32846) ([Vladimir C](https://github.com/vdimir)).
* Update TRUSTED_CONTIBUTORS [#32850](https://github.com/ClickHouse/ClickHouse/pull/32850) ([Vladimir C](https://github.com/vdimir)).
* Followup docs check workflow [#32857](https://github.com/ClickHouse/ClickHouse/pull/32857) ([alesapin](https://github.com/alesapin)).
* Always apply const-condition-if optimization. [#32858](https://github.com/ClickHouse/ClickHouse/pull/32858) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use a proper syntax for multiline env in GITHUB_ENV [#32864](https://github.com/ClickHouse/ClickHouse/pull/32864) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix multiline SSH_KEY in GITHUB_ENV file [#32865](https://github.com/ClickHouse/ClickHouse/pull/32865) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* warm up for test_kafka_json_as_string_no_kdc [#32885](https://github.com/ClickHouse/ClickHouse/pull/32885) ([Ilya Golshtein](https://github.com/ilejn)).
* Rename files and code from BlobStorage to AzureBlobStorage [#32886](https://github.com/ClickHouse/ClickHouse/pull/32886) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add dockerhub proxy to CI [#32905](https://github.com/ClickHouse/ClickHouse/pull/32905) ([alesapin](https://github.com/alesapin)).
* Update 01069_window_view_proc_tumble_watch.py [#32908](https://github.com/ClickHouse/ClickHouse/pull/32908) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update test azure_blob_storage::test_table_manipulations [#32909](https://github.com/ClickHouse/ClickHouse/pull/32909) ([Kseniia Sumarokova](https://github.com/kssenii)).
* More retries in perf tests. [#32910](https://github.com/ClickHouse/ClickHouse/pull/32910) ([alesapin](https://github.com/alesapin)).
* fix wrong testcase in gtest_Parser [#32912](https://github.com/ClickHouse/ClickHouse/pull/32912) ([SuperDJY](https://github.com/cmsxbc)).
* Disable percpu arena in jemalloc in case of non deterministic CPU count [#32916](https://github.com/ClickHouse/ClickHouse/pull/32916) ([Azat Khuzhin](https://github.com/azat)).
* [RFC] Add replxx/jemalloc into fasttest build of clickhouse [#32923](https://github.com/ClickHouse/ClickHouse/pull/32923) ([Azat Khuzhin](https://github.com/azat)).
* tests/integration/cleanup_environment: fix obtaining PYTEST_CLEANUP_CONTAINERS [#32931](https://github.com/ClickHouse/ClickHouse/pull/32931) ([Azat Khuzhin](https://github.com/azat)).
* fix typo [#32936](https://github.com/ClickHouse/ClickHouse/pull/32936) ([Denny Crane](https://github.com/den-crane)).
* Fix build issue related to azure blob storage [another try] [#32948](https://github.com/ClickHouse/ClickHouse/pull/32948) ([Amos Bird](https://github.com/amosbird)).
* test for base64encode_trailing_bytes [#31797](https://github.com/ClickHouse/ClickHouse/issues/31797) [#32954](https://github.com/ClickHouse/ClickHouse/pull/32954) ([Denny Crane](https://github.com/den-crane)).
* simplify looping in S2 functions [#32960](https://github.com/ClickHouse/ClickHouse/pull/32960) ([Bharat Nallan](https://github.com/bharatnc)).
* Sync release CI branches in master [#32967](https://github.com/ClickHouse/ClickHouse/pull/32967) ([alesapin](https://github.com/alesapin)).
* Loops remove postfix increment [#32970](https://github.com/ClickHouse/ClickHouse/pull/32970) ([Maksim Kita](https://github.com/kitaisreal)).
* Containers iteration fix erase [#32972](https://github.com/ClickHouse/ClickHouse/pull/32972) ([Maksim Kita](https://github.com/kitaisreal)).
* Merging [#32400](https://github.com/ClickHouse/ClickHouse/issues/32400) [#32974](https://github.com/ClickHouse/ClickHouse/pull/32974) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Decrease log level for some s3 messages. [#32979](https://github.com/ClickHouse/ClickHouse/pull/32979) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Trying to add woboq to new CI [#32983](https://github.com/ClickHouse/ClickHouse/pull/32983) ([alesapin](https://github.com/alesapin)).
* RabbitMQ tests fix [#32985](https://github.com/ClickHouse/ClickHouse/pull/32985) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix clang-tidy  [#32987](https://github.com/ClickHouse/ClickHouse/pull/32987) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix typo [#32992](https://github.com/ClickHouse/ClickHouse/pull/32992) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix weird permission on log directories [#32994](https://github.com/ClickHouse/ClickHouse/pull/32994) ([Håvard Kvålen](https://github.com/havardk)).
* Add Keeper Jepsen check to new CI [#32998](https://github.com/ClickHouse/ClickHouse/pull/32998) ([alesapin](https://github.com/alesapin)).
* Add backport workflow rerun [#33005](https://github.com/ClickHouse/ClickHouse/pull/33005) ([alesapin](https://github.com/alesapin)).
* Remove the possibility of adding columns with table overrides [#33017](https://github.com/ClickHouse/ClickHouse/pull/33017) ([Stig Bakken](https://github.com/stigsb)).
* Merge [#33023](https://github.com/ClickHouse/ClickHouse/issues/33023) [#33027](https://github.com/ClickHouse/ClickHouse/pull/33027) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix cron expression [#33035](https://github.com/ClickHouse/ClickHouse/pull/33035) ([alesapin](https://github.com/alesapin)).
* Make `can be tested` great again [#33036](https://github.com/ClickHouse/ClickHouse/pull/33036) ([alesapin](https://github.com/alesapin)).
* Fix exception in azure write buffer desctructor [#33039](https://github.com/ClickHouse/ClickHouse/pull/33039) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add manual run for woboq [#33042](https://github.com/ClickHouse/ClickHouse/pull/33042) ([alesapin](https://github.com/alesapin)).
* Update Cassandra driver [#33043](https://github.com/ClickHouse/ClickHouse/pull/33043) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Decrease default timeout for integration test [#33044](https://github.com/ClickHouse/ClickHouse/pull/33044) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix merge [#33021](https://github.com/ClickHouse/ClickHouse/issues/33021) [#33049](https://github.com/ClickHouse/ClickHouse/pull/33049) ([Nikolay Degterinsky](https://github.com/evillique)).
* Update banner for january 20 release webinar [#33052](https://github.com/ClickHouse/ClickHouse/pull/33052) ([Cody Baker](https://github.com/codyrobert)).
* Update harmful library [#33058](https://github.com/ClickHouse/ClickHouse/pull/33058) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merge [#33024](https://github.com/ClickHouse/ClickHouse/issues/33024) [#33061](https://github.com/ClickHouse/ClickHouse/pull/33061) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merge [#33022](https://github.com/ClickHouse/ClickHouse/issues/33022) [#33062](https://github.com/ClickHouse/ClickHouse/pull/33062) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merge [#33025](https://github.com/ClickHouse/ClickHouse/issues/33025) [#33063](https://github.com/ClickHouse/ClickHouse/pull/33063) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merge [#33050](https://github.com/ClickHouse/ClickHouse/issues/33050) [#33065](https://github.com/ClickHouse/ClickHouse/pull/33065) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add alternative LRUCache version [#33098](https://github.com/ClickHouse/ClickHouse/pull/33098) ([lgbo](https://github.com/lgbo-ustc)).
* Fix test that was dependent on time zone [#33122](https://github.com/ClickHouse/ClickHouse/pull/33122) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix clang tidy [#33131](https://github.com/ClickHouse/ClickHouse/pull/33131) ([alesapin](https://github.com/alesapin)).
* Fix PVS check [#33135](https://github.com/ClickHouse/ClickHouse/pull/33135) ([alesapin](https://github.com/alesapin)).
* Upload build artifact in case of build failures [#33136](https://github.com/ClickHouse/ClickHouse/pull/33136) ([alesapin](https://github.com/alesapin)).
* Fix woboq codebrowser [#33137](https://github.com/ClickHouse/ClickHouse/pull/33137) ([alesapin](https://github.com/alesapin)).
* Longer timeout for server start in fuzzer [#33138](https://github.com/ClickHouse/ClickHouse/pull/33138) ([alesapin](https://github.com/alesapin)).
* Fix azure blob storage tests failures [#33140](https://github.com/ClickHouse/ClickHouse/pull/33140) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix functions with sparse arguments in case when result type doesn't support sparse serialization [#33146](https://github.com/ClickHouse/ClickHouse/pull/33146) ([Anton Popov](https://github.com/CurtizJ)).
* Add pretty print unknow event [#33148](https://github.com/ClickHouse/ClickHouse/pull/33148) ([alesapin](https://github.com/alesapin)).
* Better pr info for unknown events [#33149](https://github.com/ClickHouse/ClickHouse/pull/33149) ([alesapin](https://github.com/alesapin)).
* Better jepsen [#33150](https://github.com/ClickHouse/ClickHouse/pull/33150) ([alesapin](https://github.com/alesapin)).
* Debugging PR info [#33151](https://github.com/ClickHouse/ClickHouse/pull/33151) ([alesapin](https://github.com/alesapin)).
* Fix shared hermetic builds on Arch linux [#33153](https://github.com/ClickHouse/ClickHouse/pull/33153) ([Azat Khuzhin](https://github.com/azat)).
* Fix ccache with ENABLE_CHECK_HEAVY_BUILDS (ccache 4.0 and 4.1 only affected) [#33154](https://github.com/ClickHouse/ClickHouse/pull/33154) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup trash from Kafka, HDFS and Azure [#33160](https://github.com/ClickHouse/ClickHouse/pull/33160) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix Date32 test [#33161](https://github.com/ClickHouse/ClickHouse/pull/33161) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make test_input_format_parallel_parsing_memory_tracking less flaky [#33163](https://github.com/ClickHouse/ClickHouse/pull/33163) ([Azat Khuzhin](https://github.com/azat)).
* Fix test_async_drain_connection flakiness [#33164](https://github.com/ClickHouse/ClickHouse/pull/33164) ([Azat Khuzhin](https://github.com/azat)).
* Fix clang-tidy [#33168](https://github.com/ClickHouse/ClickHouse/pull/33168) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky test 01622_defaults_for_url_engine [#33169](https://github.com/ClickHouse/ClickHouse/pull/33169) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* materialized postgresql better startup [#33177](https://github.com/ClickHouse/ClickHouse/pull/33177) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible uncaught exception in clickhouse-local [#33189](https://github.com/ClickHouse/ClickHouse/pull/33189) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix tests with event_time/event_date = today(), and add a style check [#33198](https://github.com/ClickHouse/ClickHouse/pull/33198) ([Azat Khuzhin](https://github.com/azat)).
* Fix 01370_client_autocomplete_word_break_characters test logic [#33202](https://github.com/ClickHouse/ClickHouse/pull/33202) ([Azat Khuzhin](https://github.com/azat)).
* More debug in jepsen test [#33207](https://github.com/ClickHouse/ClickHouse/pull/33207) ([alesapin](https://github.com/alesapin)).
* Fix some flaky integration tests [#33215](https://github.com/ClickHouse/ClickHouse/pull/33215) ([alesapin](https://github.com/alesapin)).
* Remove old trash [#33217](https://github.com/ClickHouse/ClickHouse/pull/33217) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix cancel lambda [#33222](https://github.com/ClickHouse/ClickHouse/pull/33222) ([alesapin](https://github.com/alesapin)).
* Fix keeper log messages [#33224](https://github.com/ClickHouse/ClickHouse/pull/33224) ([alesapin](https://github.com/alesapin)).
* Fix clang tidy [#33235](https://github.com/ClickHouse/ClickHouse/pull/33235) ([alesapin](https://github.com/alesapin)).
* Fix flaky test 01650 [#33250](https://github.com/ClickHouse/ClickHouse/pull/33250) ([alesapin](https://github.com/alesapin)).
* Add retries for github api [#33252](https://github.com/ClickHouse/ClickHouse/pull/33252) ([alesapin](https://github.com/alesapin)).
* Add retries to AST fuzzer download and fix flaky test. [#33256](https://github.com/ClickHouse/ClickHouse/pull/33256) ([alesapin](https://github.com/alesapin)).
* Do not ignore eof in expect tests [#33263](https://github.com/ClickHouse/ClickHouse/pull/33263) ([Azat Khuzhin](https://github.com/azat)).
* Fix parsing symbols from resources (for shared builds) [#33264](https://github.com/ClickHouse/ClickHouse/pull/33264) ([Azat Khuzhin](https://github.com/azat)).
* test for [#24410](https://github.com/ClickHouse/ClickHouse/issues/24410) [#33265](https://github.com/ClickHouse/ClickHouse/pull/33265) ([Denny Crane](https://github.com/den-crane)).
* Wait for RabbitMQ container to actually start when it was restarted in test on purpose [#33266](https://github.com/ClickHouse/ClickHouse/pull/33266) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Mark max_alter_threads as obsolete [#33268](https://github.com/ClickHouse/ClickHouse/pull/33268) ([Denny Crane](https://github.com/den-crane)).
* Fix azure tests flakyness because of azure server closing connection [#33269](https://github.com/ClickHouse/ClickHouse/pull/33269) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Test for [#26920](https://github.com/ClickHouse/ClickHouse/issues/26920) [#33272](https://github.com/ClickHouse/ClickHouse/pull/33272) ([Denny Crane](https://github.com/den-crane)).
* Fix test_storage_kafka failures by adjusting retention.ms [#33278](https://github.com/ClickHouse/ClickHouse/pull/33278) ([Azat Khuzhin](https://github.com/azat)).
* Disable FunctionConvertFromString::canBeExecutedOnDefaultArguments [#33286](https://github.com/ClickHouse/ClickHouse/pull/33286) ([Vladimir C](https://github.com/vdimir)).
* Add IAST::QueryKind enum and use it in query limiter [#33294](https://github.com/ClickHouse/ClickHouse/pull/33294) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix clang tidy 3 [#33296](https://github.com/ClickHouse/ClickHouse/pull/33296) ([alesapin](https://github.com/alesapin)).
* Fix jepsen check [#33304](https://github.com/ClickHouse/ClickHouse/pull/33304) ([alesapin](https://github.com/alesapin)).
* Add test for broken connection [#33305](https://github.com/ClickHouse/ClickHouse/pull/33305) ([nvartolomei](https://github.com/nvartolomei)).
* Fix launcher not being defined for ccache < 4.0 and slightly cleanup [#33306](https://github.com/ClickHouse/ClickHouse/pull/33306) ([nvartolomei](https://github.com/nvartolomei)).
* Return early if azure blob storage is not used, otherwise it might with fail with irrelevant errors [#33307](https://github.com/ClickHouse/ClickHouse/pull/33307) ([nvartolomei](https://github.com/nvartolomei)).
* Minor refactor of read buffers with compression [#33318](https://github.com/ClickHouse/ClickHouse/pull/33318) ([Nikolay Degterinsky](https://github.com/evillique)).
* Rename Committed data part state to Active [#33327](https://github.com/ClickHouse/ClickHouse/pull/33327) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Tiny follow-up to pr 33098 [#33334](https://github.com/ClickHouse/ClickHouse/pull/33334) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix inner table parser in window view [#33340](https://github.com/ClickHouse/ClickHouse/pull/33340) ([vxider](https://github.com/Vxider)).
* Cover CustomSeparated/Template formats for Kafka [#33343](https://github.com/ClickHouse/ClickHouse/pull/33343) ([Azat Khuzhin](https://github.com/azat)).
* update copyright in docs [#33353](https://github.com/ClickHouse/ClickHouse/pull/33353) ([Bharat Nallan](https://github.com/bharatnc)).
* UserDefinedExecutableFunction fix exception [#33362](https://github.com/ClickHouse/ClickHouse/pull/33362) ([Maksim Kita](https://github.com/kitaisreal)).
* Trying to merge [#23230](https://github.com/ClickHouse/ClickHouse/issues/23230) [#33368](https://github.com/ClickHouse/ClickHouse/pull/33368) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Print alter command names in EXPLAIN AST [#33383](https://github.com/ClickHouse/ClickHouse/pull/33383) ([Stig Bakken](https://github.com/stigsb)).
* DictionaryStructure fixes [#33388](https://github.com/ClickHouse/ClickHouse/pull/33388) ([Maksim Kita](https://github.com/kitaisreal)).
* tests/stress: add core dumps into artifacts [#33389](https://github.com/ClickHouse/ClickHouse/pull/33389) ([Azat Khuzhin](https://github.com/azat)).
* Update success.html [#33397](https://github.com/ClickHouse/ClickHouse/pull/33397) ([Adri Fernandez](https://github.com/iladriano)).
* Remove obsolete and unsupported Docker Builder [#33345](https://github.com/ClickHouse/ClickHouse/issues/33345) [#33399](https://github.com/ClickHouse/ClickHouse/pull/33399) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Maybe improve robustness of the "query profiler" test [#33422](https://github.com/ClickHouse/ClickHouse/pull/33422) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* fix misleading log message in StorageWindowView [#33432](https://github.com/ClickHouse/ClickHouse/pull/33432) ([flynn](https://github.com/ucasfl)).
* Preparation for [#33167](https://github.com/ClickHouse/ClickHouse/issues/33167). [#33444](https://github.com/ClickHouse/ClickHouse/pull/33444) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Rerun docs release check as well [#33447](https://github.com/ClickHouse/ClickHouse/pull/33447) ([alesapin](https://github.com/alesapin)).
* Update AsynchronousReadIndirectBufferFromRemoteFS.h [#33452](https://github.com/ClickHouse/ClickHouse/pull/33452) ([xiedeyantu](https://github.com/xiedeyantu)).
* Tests visualizer better [#33453](https://github.com/ClickHouse/ClickHouse/pull/33453) ([Dmitry Khorkin](https://github.com/DimaAmega)).
* Function monthName small fix [#33464](https://github.com/ClickHouse/ClickHouse/pull/33464) ([Maksim Kita](https://github.com/kitaisreal)).
* Add a test for operator priorities in SQL [#33487](https://github.com/ClickHouse/ClickHouse/pull/33487) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add new team members to company page [#33506](https://github.com/ClickHouse/ClickHouse/pull/33506) ([Cody Baker](https://github.com/codyrobert)).
* fix variable name in h3 misc funcs [#33510](https://github.com/ClickHouse/ClickHouse/pull/33510) ([Bharat Nallan](https://github.com/bharatnc)).
* H3 functions bad arguments possible crash fix [#33512](https://github.com/ClickHouse/ClickHouse/pull/33512) ([Maksim Kita](https://github.com/kitaisreal)).
* Build with ENABLE_TESTS fix [#33513](https://github.com/ClickHouse/ClickHouse/pull/33513) ([Maksim Kita](https://github.com/kitaisreal)).
* IAST QueryKind style fix [#33514](https://github.com/ClickHouse/ClickHouse/pull/33514) ([Maksim Kita](https://github.com/kitaisreal)).
* Don't print exception twice in client in case of exception in parallel parsing [#33524](https://github.com/ClickHouse/ClickHouse/pull/33524) ([Kruglov Pavel](https://github.com/Avogar)).
* HashTable constant fix [#33525](https://github.com/ClickHouse/ClickHouse/pull/33525) ([Maksim Kita](https://github.com/kitaisreal)).
* Add admixer blog post [#33528](https://github.com/ClickHouse/ClickHouse/pull/33528) ([Cody Baker](https://github.com/codyrobert)).
* Fix clickhouse local interactive exception case [#33535](https://github.com/ClickHouse/ClickHouse/pull/33535) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix parsing queries with FROM INFILE statement again [#33556](https://github.com/ClickHouse/ClickHouse/pull/33556) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix logic for upload upload_master_static_binaries [#33560](https://github.com/ClickHouse/ClickHouse/pull/33560) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Don't upload splitted binaries to builds.clickhouse.com [#33562](https://github.com/ClickHouse/ClickHouse/pull/33562) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix minor bug in TTL and flaky test [#33564](https://github.com/ClickHouse/ClickHouse/pull/33564) ([Alexander Tokmakov](https://github.com/tavplubix)).
* skip MySQLCreateRewritten unit testsuite when enable_mysql is off [#33577](https://github.com/ClickHouse/ClickHouse/pull/33577) ([Suzy Wang](https://github.com/SuzyWangIBMer)).
* Fix test `02156_storage_merge_prewhere` [#33580](https://github.com/ClickHouse/ClickHouse/pull/33580) ([Anton Popov](https://github.com/CurtizJ)).
* Update mongodb.md [#33585](https://github.com/ClickHouse/ClickHouse/pull/33585) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Restore existing static builds links [#33597](https://github.com/ClickHouse/ClickHouse/pull/33597) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix pylint for run_check.py [#33600](https://github.com/ClickHouse/ClickHouse/pull/33600) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix flaky test_dictionaries_postgresql/ [#33601](https://github.com/ClickHouse/ClickHouse/pull/33601) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make ZooKeeper client better interpret keeper server connection reject [#33602](https://github.com/ClickHouse/ClickHouse/pull/33602) ([alesapin](https://github.com/alesapin)).
* Fix broken workflow dependencies [#33608](https://github.com/ClickHouse/ClickHouse/pull/33608) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Force rebuild images in CI [#33609](https://github.com/ClickHouse/ClickHouse/pull/33609) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* YetAnother workflow fix [#33610](https://github.com/ClickHouse/ClickHouse/pull/33610) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Metrics lambda: fix deletion [#33616](https://github.com/ClickHouse/ClickHouse/pull/33616) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add an exception message example [#33623](https://github.com/ClickHouse/ClickHouse/pull/33623) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix two flaky integration tests [#33625](https://github.com/ClickHouse/ClickHouse/pull/33625) ([alesapin](https://github.com/alesapin)).
* Update version to 22.1 not 21.13 [#33626](https://github.com/ClickHouse/ClickHouse/pull/33626) ([alesapin](https://github.com/alesapin)).
* do not construct std::string if there is no error [#33628](https://github.com/ClickHouse/ClickHouse/pull/33628) ([Sergei Trifonov](https://github.com/serxa)).
* Fix test 00900_long_parquet_load [#33629](https://github.com/ClickHouse/ClickHouse/pull/33629) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix error codes order [#33633](https://github.com/ClickHouse/ClickHouse/pull/33633) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix s3 integration tests [#33641](https://github.com/ClickHouse/ClickHouse/pull/33641) ([Kruglov Pavel](https://github.com/Avogar)).
* test for [#33592](https://github.com/ClickHouse/ClickHouse/issues/33592) [#33658](https://github.com/ClickHouse/ClickHouse/pull/33658) ([Denny Crane](https://github.com/den-crane)).
* Update "gosu" version [#33660](https://github.com/ClickHouse/ClickHouse/pull/33660) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix 01814_distributed_push_down_limit flakiness [#33662](https://github.com/ClickHouse/ClickHouse/pull/33662) ([Azat Khuzhin](https://github.com/azat)).
* Add amosbird to trusted user. [#33663](https://github.com/ClickHouse/ClickHouse/pull/33663) ([Amos Bird](https://github.com/amosbird)).
* Fix pr ci restart [#33667](https://github.com/ClickHouse/ClickHouse/pull/33667) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### New Feature / New Tool

* Tool for collecting diagnostics data. [#33175](https://github.com/ClickHouse/ClickHouse/pull/33175) ([Alexander Burmak](https://github.com/Alex-Burmak)).
