---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.9.1.8000-prestable FIXME as compared to v21.8.1.7409-prestable

#### Backward Incompatible Change
* Fix the issue that in case of some sophisticated query with column aliases identical to the names of expressions, bad cast may happen. This fixes [#25447](https://github.com/ClickHouse/ClickHouse/issues/25447). This fixes [#26914](https://github.com/ClickHouse/ClickHouse/issues/26914). This fix may introduce backward incompatibility: if there are different expressions with identical names, exception will be thrown. It may break some rare cases when `enable_optimize_predicate_expression` is set. [#26639](https://github.com/ClickHouse/ClickHouse/pull/26639) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Under clickhouse-local, always treat local addresses with a port as remote. [#26736](https://github.com/ClickHouse/ClickHouse/pull/26736) ([Raúl Marín](https://github.com/Algunenano)).
* Do not allow to apply parametric aggregate function with `-Merge` combinator to aggregate function state if state was produced by aggregate function with different parameters. For example, state of `fooState(42)(x)` cannot be finalized with `fooMerge(s)` or `fooMerge(123)(s)`, parameters must be specified explicitly like `fooMerge(42)(s)` and must be equal. It does not affect some special aggregate functions like `quantile` and `sequence*` that use parameters for finalization only. [#26847](https://github.com/ClickHouse/ClickHouse/pull/26847) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Do not output trailing zeros in text representation of `Decimal` types. Example: `1.23` will be printed instead of `1.230000` for decimal with scale 6. This closes [#15794](https://github.com/ClickHouse/ClickHouse/issues/15794). It may introduce slight incompatibility if your applications somehow relied on the trailing zeros. Serialization in output formats can be controlled with the setting `output_format_decimal_trailing_zeros`. Implementation of `toString` and casting to String is changed unconditionally. [#27680](https://github.com/ClickHouse/ClickHouse/pull/27680) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature
* Implement window function `nth_value(expr, N)` that returns the value of the Nth row of the window frame. [#26334](https://github.com/ClickHouse/ClickHouse/pull/26334) ([Zuo, RuoYu](https://github.com/ryzuo)).
* - Add `REPLACE GRANT` feature. [#26384](https://github.com/ClickHouse/ClickHouse/pull/26384) ([Caspian](https://github.com/Cas-pian)).
* Functions that return (initial_)query_id of the current query. This closes [#23682](https://github.com/ClickHouse/ClickHouse/issues/23682). [#26410](https://github.com/ClickHouse/ClickHouse/pull/26410) ([Alexey Boykov](https://github.com/mathalex)).
* Introduce syntax for here documents. Example `SELECT $doc$VALUE$doc$`. [#26671](https://github.com/ClickHouse/ClickHouse/pull/26671) ([Maksim Kita](https://github.com/kitaisreal)).
* New functions `currentProfiles()`, `enabledProfiles()`, `defaultProfiles()`. [#26714](https://github.com/ClickHouse/ClickHouse/pull/26714) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add new functions `currentRoles()`, `enabledRoles()`, `defaultRoles()`. [#26780](https://github.com/ClickHouse/ClickHouse/pull/26780) ([Vitaly Baranov](https://github.com/vitlibar)).
* Supported cluster macros inside table functions 'cluster' and 'clusterAllReplicas'. [#26913](https://github.com/ClickHouse/ClickHouse/pull/26913) ([Vadim Volodin](https://github.com/PolyProgrammist)).
* Added support for custom query for MySQL, PostgreSQL, ClickHouse, JDBC, Cassandra dictionary source. Closes [#1270](https://github.com/ClickHouse/ClickHouse/issues/1270). [#26995](https://github.com/ClickHouse/ClickHouse/pull/26995) ([Maksim Kita](https://github.com/kitaisreal)).
* add column default_database to system.users. [#27054](https://github.com/ClickHouse/ClickHouse/pull/27054) ([kevin wan](https://github.com/MaxWk)).
* Added `bitmapSubsetOffsetLimit(bitmap, offset, cardinality_limit)` function. It creates a subset of bitmap limit the results to `cardinality_limit` with offset of `offset`. [#27234](https://github.com/ClickHouse/ClickHouse/pull/27234) ([DHBin](https://github.com/DHBin)).
* Add support for `bzip2` compression method for import/export. Closes [#22428](https://github.com/ClickHouse/ClickHouse/issues/22428). [#27377](https://github.com/ClickHouse/ClickHouse/pull/27377) ([Nikolay Degterinsky](https://github.com/evillique)).
* - Add replicated storage of user, roles, row policies, quotas and settings profiles through ZooKeeper (experimental). [#27426](https://github.com/ClickHouse/ClickHouse/pull/27426) ([Kevin Michel](https://github.com/kmichel-aiven)).
* Add "tupleToNameValuePairs", a function that turns a named tuple into an array of pairs. [#27505](https://github.com/ClickHouse/ClickHouse/pull/27505) ([Braulio Valdivielso Martínez](https://github.com/BraulioVM)).
* Enable using constants from with and select in aggregate function parameters. Close [#10945](https://github.com/ClickHouse/ClickHouse/issues/10945). [#27531](https://github.com/ClickHouse/ClickHouse/pull/27531) ([abel-cheng](https://github.com/abel-cheng)).
* Added ComplexKeyRangeHashed dictionary. Closes [#22029](https://github.com/ClickHouse/ClickHouse/issues/22029). [#27629](https://github.com/ClickHouse/ClickHouse/pull/27629) ([Maksim Kita](https://github.com/kitaisreal)).

#### Performance Improvement
* Compile aggregate functions `groupBitOr`, `groupBitAnd`, `groupBitXor`. [#26161](https://github.com/ClickHouse/ClickHouse/pull/26161) ([Maksim Kita](https://github.com/kitaisreal)).
* Compile columns with `Enum` types. [#26237](https://github.com/ClickHouse/ClickHouse/pull/26237) ([Maksim Kita](https://github.com/kitaisreal)).
* - Vectorize the SUM of Nullable integer types with native representation ([David Manzanares](https://github.com/davidmanzanares), [Raúl Marín](https://github.com/Algunenano)). [#26248](https://github.com/ClickHouse/ClickHouse/pull/26248) ([Raúl Marín](https://github.com/Algunenano)).
* Don't build sets for indices when analyzing a query. [#26365](https://github.com/ClickHouse/ClickHouse/pull/26365) ([Raúl Marín](https://github.com/Algunenano)).
* Improve latency of short queries, that require reading from tables with large number of columns. [#26371](https://github.com/ClickHouse/ClickHouse/pull/26371) ([Anton Popov](https://github.com/CurtizJ)).
* Share file descriptors in concurrent reads of the same files. There is no noticeable performance difference on Linux. But the number of opened files will be significantly (10..100 times) lower on typical servers and it makes operations easier. See [#26214](https://github.com/ClickHouse/ClickHouse/issues/26214). [#26768](https://github.com/ClickHouse/ClickHouse/pull/26768) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Specialize date time related comparison to achieve better performance. This fixes [#27083](https://github.com/ClickHouse/ClickHouse/issues/27083) . [#27122](https://github.com/ClickHouse/ClickHouse/pull/27122) ([Amos Bird](https://github.com/amosbird)).
* Improve the performance of fast queries when `max_execution_time=0` by reducing the number of `clock_gettime` system calls. [#27325](https://github.com/ClickHouse/ClickHouse/pull/27325) ([filimonov](https://github.com/filimonov)).
* Less number of `clock_gettime` syscalls that may lead to performance improvement for some types of fast queries. [#27492](https://github.com/ClickHouse/ClickHouse/pull/27492) ([filimonov](https://github.com/filimonov)).

#### Improvement
* Add error id (like `BAD_ARGUMENTS`) to exception messages. This closes [#25862](https://github.com/ClickHouse/ClickHouse/issues/25862). [#26172](https://github.com/ClickHouse/ClickHouse/pull/26172) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove GLOBAL keyword for IN when scalar function is passed. In previous versions, if user specified `GLOBAL IN f(x)` exception was thrown. [#26217](https://github.com/ClickHouse/ClickHouse/pull/26217) ([Amos Bird](https://github.com/amosbird)).
* Apply aggressive IN index analysis for projections so that better projection candidate can be selected. [#26218](https://github.com/ClickHouse/ClickHouse/pull/26218) ([Amos Bird](https://github.com/amosbird)).
* convert timestamp and timestamptz data types to DateTime64 in postgres engine. [#26234](https://github.com/ClickHouse/ClickHouse/pull/26234) ([jasine](https://github.com/jasine)).
* Check for non-deterministic functions in keys, including constant expressions like `now()`, `today()`. This closes [#25875](https://github.com/ClickHouse/ClickHouse/issues/25875). This closes [#11333](https://github.com/ClickHouse/ClickHouse/issues/11333). [#26235](https://github.com/ClickHouse/ClickHouse/pull/26235) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Don't throw exception when querying `system.detached_parts` table if there is custom disk configuration and `detached` directory does not exist on some disks. This closes [#26078](https://github.com/ClickHouse/ClickHouse/issues/26078). [#26236](https://github.com/ClickHouse/ClickHouse/pull/26236) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add information about column sizes in `system.columns` table for `Log` and `TinyLog` tables. This closes [#9001](https://github.com/ClickHouse/ClickHouse/issues/9001). [#26241](https://github.com/ClickHouse/ClickHouse/pull/26241) ([Nikolay Degterinsky](https://github.com/evillique)).
* Added `output_format_avro_string_column_pattern` setting to put specified String columns to Avro as string instead of default bytes. Implements [#22414](https://github.com/ClickHouse/ClickHouse/issues/22414). [#26245](https://github.com/ClickHouse/ClickHouse/pull/26245) ([Ilya Golshtein](https://github.com/ilejn)).
* - Add `system.warnings` table to collect warnings about server configuration. [#26246](https://github.com/ClickHouse/ClickHouse/pull/26246) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Check hash function at table creation, not at sampling. Add settings in MergeTreeSettings, if someone create a table with incorrect sampling column but sampling never be used, disable this settings for starting the server without exception. [#26256](https://github.com/ClickHouse/ClickHouse/pull/26256) ([zhaoyu](https://github.com/zxc111)).
* Make `toTimeZone` monotonicity when timeZone is a constant value to support partition puring when use sql like:. [#26261](https://github.com/ClickHouse/ClickHouse/pull/26261) ([huangzhaowei](https://github.com/SaintBacchus)).
* - When client connect to server, he receives information about all warnings that are already were collected by server. (It can be disabled by using option `--no-warnings`). [#26282](https://github.com/ClickHouse/ClickHouse/pull/26282) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Add a setting `function_range_max_elements_in_block` to tune the safety threshold for data volume generated by function `range`. This closes [#26303](https://github.com/ClickHouse/ClickHouse/issues/26303). [#26305](https://github.com/ClickHouse/ClickHouse/pull/26305) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Control the execution period of clear old temporary directories by parameter with default value. [#26212](https://github.com/ClickHouse/ClickHouse/issues/26212). [#26313](https://github.com/ClickHouse/ClickHouse/pull/26313) ([fastio](https://github.com/fastio)).
* Allow to reuse connections of shards among different clusters. It also avoids creating new connections when using `cluster` table function. [#26318](https://github.com/ClickHouse/ClickHouse/pull/26318) ([Amos Bird](https://github.com/amosbird)).
* Add events to profile calls to sleep / sleepEachRow. [#26320](https://github.com/ClickHouse/ClickHouse/pull/26320) ([Raúl Marín](https://github.com/Algunenano)).
* Save server address in history URLs in web UI if it differs from the origin of web UI. This closes [#26044](https://github.com/ClickHouse/ClickHouse/issues/26044). [#26322](https://github.com/ClickHouse/ClickHouse/pull/26322) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ability to set Distributed directory monitor settings via CREATE TABLE (i.e. `CREATE TABLE dist (key Int) Engine=Distributed(cluster, db, table) SETTINGS monitor_batch_inserts=1` and similar). [#26336](https://github.com/ClickHouse/ClickHouse/pull/26336) ([Azat Khuzhin](https://github.com/azat)).
* Fix behaviour with non-existing host in user allowed host list. [#26368](https://github.com/ClickHouse/ClickHouse/pull/26368) ([ianton-ru](https://github.com/ianton-ru)).
* Added comments for the code written in https://github.com/ClickHouse/ClickHouse/pull/24206; the code has been improved in several places. [#26377](https://github.com/ClickHouse/ClickHouse/pull/26377) ([Vitaly Baranov](https://github.com/vitlibar)).
* Enable `use_hedged_requests` setting that allows to mitigate tail latencies on large clusters. [#26380](https://github.com/ClickHouse/ClickHouse/pull/26380) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Updated protobuf to 3.17.3. Changelogs are available on https://github.com/protocolbuffers/protobuf/releases. [#26424](https://github.com/ClickHouse/ClickHouse/pull/26424) ([Ilya Yatsishin](https://github.com/qoega)).
* After https://github.com/ClickHouse/ClickHouse/pull/26377. Encryption algorithm now should be specified explicitly if it's not default (`aes_128_ctr`):. [#26465](https://github.com/ClickHouse/ClickHouse/pull/26465) ([Vitaly Baranov](https://github.com/vitlibar)).
* Apply `LIMIT` on the shards for queries like `SELECT * FROM dist ORDER BY key LIMIT 10` w/ `distributed_push_down_limit=1`. Avoid running `Distinct`/`LIMIT BY` steps for queries like `SELECT DISTINCT shading_key FROM dist ORDER BY key`. Now `distributed_push_down_limit` is respected by `optimize_distributed_group_by_sharding_key` optimization. [#26466](https://github.com/ClickHouse/ClickHouse/pull/26466) ([Azat Khuzhin](https://github.com/azat)).
* - Set client query kind for mysql and postgresql handler. [#26498](https://github.com/ClickHouse/ClickHouse/pull/26498) ([anneji-dev](https://github.com/anneji-dev)).
* Executable dictionaries (ExecutableDictionarySource, ExecutablePoolDictionarySource) enable creation with DDL query using clickhouse-local. Closes [#22355](https://github.com/ClickHouse/ClickHouse/issues/22355). [#26510](https://github.com/ClickHouse/ClickHouse/pull/26510) ([Maksim Kita](https://github.com/kitaisreal)).
* Add round-robin support for clickhouse-benchmark (it does not differ from the regular multi host/port run except for statistics report). [#26607](https://github.com/ClickHouse/ClickHouse/pull/26607) ([Azat Khuzhin](https://github.com/azat)).
* Improve the high performance machine to use the kafka engine. and it can recuce the query node work load. [#26642](https://github.com/ClickHouse/ClickHouse/pull/26642) ([feihengye](https://github.com/feihengye)).
* Avoid hanging clickhouse-benchmark if connection fails (i.e. on EMFILE). [#26656](https://github.com/ClickHouse/ClickHouse/pull/26656) ([Azat Khuzhin](https://github.com/azat)).
* Fix excessive (x2) connect attempts with skip_unavailable_shards. [#26658](https://github.com/ClickHouse/ClickHouse/pull/26658) ([Azat Khuzhin](https://github.com/azat)).
* - `mapPopulatesSeries` function supports `Map` type. [#26663](https://github.com/ClickHouse/ClickHouse/pull/26663) ([Ildus Kurbangaliev](https://github.com/ildus)).
* Improve handling of KILL QUERY requests. [#26675](https://github.com/ClickHouse/ClickHouse/pull/26675) ([Raúl Marín](https://github.com/Algunenano)).
* SET PROFILE now applies constraints too if they're set for a passed profile. [#26730](https://github.com/ClickHouse/ClickHouse/pull/26730) ([Vitaly Baranov](https://github.com/vitlibar)).
* Support multiple keys for encrypted disk. Display error message if the key is probably wrong. (see https://github.com/ClickHouse/ClickHouse/pull/26465#issuecomment-882015970). [#26733](https://github.com/ClickHouse/ClickHouse/pull/26733) ([Vitaly Baranov](https://github.com/vitlibar)).
* remove uncessary exception thrown. [#26740](https://github.com/ClickHouse/ClickHouse/pull/26740) ([Caspian](https://github.com/Cas-pian)).
* Watchdog is disabled in docker by default. Fix for not handling ctrl+c. [#26757](https://github.com/ClickHouse/ClickHouse/pull/26757) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Changing default roles affects new sessions only. [#26759](https://github.com/ClickHouse/ClickHouse/pull/26759) ([Vitaly Baranov](https://github.com/vitlibar)).
* Less verbose internal RocksDB logs. This closes [#26252](https://github.com/ClickHouse/ClickHouse/issues/26252). [#26789](https://github.com/ClickHouse/ClickHouse/pull/26789) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Expose rocksdb statistics via system.rocksdb table. Read rocksdb options from ClickHouse config (`rocksdb`/`rocksdb_TABLE` keys). [#26821](https://github.com/ClickHouse/ClickHouse/pull/26821) ([Azat Khuzhin](https://github.com/azat)).
* Updated extractAllGroupsHorizontal - upper limit on the number of matches per row can be set via optional third argument. ... [#26961](https://github.com/ClickHouse/ClickHouse/pull/26961) ([Vasily Nemkov](https://github.com/Enmk)).
* Now functions can be shard-level constants, which means if it's executed in the context of some distributed table, it generates a normal column, otherwise it produces a constant value. Notable functions are: `hostName()`, `tcpPort()`, `version()`, `buildId()`, `uptime()`, etc. [#27020](https://github.com/ClickHouse/ClickHouse/pull/27020) ([Amos Bird](https://github.com/amosbird)).
* * Merge join correctly handles empty set in the right. [#27078](https://github.com/ClickHouse/ClickHouse/pull/27078) ([Vladimir C](https://github.com/vdimir)).
* Improve compatibility with non-whole-minute timezone offsets. [#27080](https://github.com/ClickHouse/ClickHouse/pull/27080) ([Raúl Marín](https://github.com/Algunenano)).
* Enable distributed_push_down_limit by default. [#27104](https://github.com/ClickHouse/ClickHouse/pull/27104) ([Azat Khuzhin](https://github.com/azat)).
* Improved the existence condition judgment and empty string node judgment when clickhouse-keeper creates znode. [#27125](https://github.com/ClickHouse/ClickHouse/pull/27125) ([小路](https://github.com/nicelulu)).
* Add compression for `INTO OUTFILE` that automatically choose compression algorithm. Closes [#3473](https://github.com/ClickHouse/ClickHouse/issues/3473). [#27134](https://github.com/ClickHouse/ClickHouse/pull/27134) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* add a new metric called MaxPushedDDLEntryID which is the maximum ddl entry id that current node push to zookeeper. [#27174](https://github.com/ClickHouse/ClickHouse/pull/27174) ([Fuwang Hu](https://github.com/fuwhu)).
* Allow to pass query settings via server URI in Web UI. [#27177](https://github.com/ClickHouse/ClickHouse/pull/27177) ([kolsys](https://github.com/kolsys)).
* Added columns `replica_is_active` that maps replica name to is replica active status to table `system.replicas`. Closes [#27138](https://github.com/ClickHouse/ClickHouse/issues/27138). [#27180](https://github.com/ClickHouse/ClickHouse/pull/27180) ([Maksim Kita](https://github.com/kitaisreal)).
* Try recording `query_kind` even when query fails to start. [#27182](https://github.com/ClickHouse/ClickHouse/pull/27182) ([Amos Bird](https://github.com/amosbird)).
* Mark window functions as ready for general use. Remove the `allow_experimental_window_functions` setting. [#27184](https://github.com/ClickHouse/ClickHouse/pull/27184) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Memory client in client. [#27191](https://github.com/ClickHouse/ClickHouse/pull/27191) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Support schema for postgres database engine. Closes [#27166](https://github.com/ClickHouse/ClickHouse/issues/27166). [#27198](https://github.com/ClickHouse/ClickHouse/pull/27198) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Split global mutex into individual regexp construction. This helps avoid huge regexp construction blocking other related threads. Not sure how to proper test the improvement. [#27211](https://github.com/ClickHouse/ClickHouse/pull/27211) ([Amos Bird](https://github.com/amosbird)).
* Add 10 seconds cache for S3 proxy resolver. [#27216](https://github.com/ClickHouse/ClickHouse/pull/27216) ([ianton-ru](https://github.com/ianton-ru)).
* Add new index data skipping minmax index format for proper Nullable support. [#27250](https://github.com/ClickHouse/ClickHouse/pull/27250) ([Azat Khuzhin](https://github.com/azat)).
* Memory consumed by bitmap aggregate functions now is taken into account for memory limits. This closes [#26555](https://github.com/ClickHouse/ClickHouse/issues/26555). [#27252](https://github.com/ClickHouse/ClickHouse/pull/27252) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add two settings `max_hyperscan_regexp_length` and `max_hyperscan_regexp_total_length` to prevent huge regexp being used in hyperscan related functions, such as `multiMatchAny`. [#27378](https://github.com/ClickHouse/ClickHouse/pull/27378) ([Amos Bird](https://github.com/amosbird)).
* Add setting `log_formatted_queries` to log additional formatted query into `system.query_log`. It's useful for normalized query analysis because functions like `normalizeQuery` and `normalizeQueryKeepNames` don't parse/format queries in order to achieve better performance. [#27380](https://github.com/ClickHouse/ClickHouse/pull/27380) ([Amos Bird](https://github.com/amosbird)).
* Add Cast function for internal usage, which will not preserve type nullability, but non-internal cast will preserve according to setting cast_keep_nullable. Closes [#12636](https://github.com/ClickHouse/ClickHouse/issues/12636). [#27382](https://github.com/ClickHouse/ClickHouse/pull/27382) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Send response with error message if HTTP port is not set and user tries to send HTTP request to TCP port. [#27385](https://github.com/ClickHouse/ClickHouse/pull/27385) ([Braulio Valdivielso Martínez](https://github.com/BraulioVM)).
* Use bytes instead of strings for binary data in the GRPC protocol. [#27431](https://github.com/ClickHouse/ClickHouse/pull/27431) ([Vitaly Baranov](https://github.com/vitlibar)).
* Log client IP address if authentication fails. [#27514](https://github.com/ClickHouse/ClickHouse/pull/27514) ([Misko Lee](https://github.com/imiskolee)).
* Disable arrayJoin on partition expressions. [#27648](https://github.com/ClickHouse/ClickHouse/pull/27648) ([Raúl Marín](https://github.com/Algunenano)).
* - Add `FROM INFILE` command. [#27655](https://github.com/ClickHouse/ClickHouse/pull/27655) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Enables query parameters to be passed in the body of http requests. [#27706](https://github.com/ClickHouse/ClickHouse/pull/27706) ([Hermano Lustosa](https://github.com/hllustosa)).
* Remove duplicate index analysis and avoid possible invalid limit checks during projection analysis. [#27742](https://github.com/ClickHouse/ClickHouse/pull/27742) ([Amos Bird](https://github.com/amosbird)).

#### Bug Fix
* Fix potential crash if more than one `untuple` expression is used. [#26179](https://github.com/ClickHouse/ClickHouse/pull/26179) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove excessive newline in `thread_name` column in `system.stack_trace` table. This fixes [#24124](https://github.com/ClickHouse/ClickHouse/issues/24124). [#26210](https://github.com/ClickHouse/ClickHouse/pull/26210) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix logical error on join with totals, close [#26017](https://github.com/ClickHouse/ClickHouse/issues/26017). [#26250](https://github.com/ClickHouse/ClickHouse/pull/26250) ([Vladimir C](https://github.com/vdimir)).
* Fix zstd decompression in case there are escape sequences at the end of internal buffer. Closes [#26013](https://github.com/ClickHouse/ClickHouse/issues/26013). [#26314](https://github.com/ClickHouse/ClickHouse/pull/26314) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed rare bug in lost replica recovery that may cause replicas to diverge. [#26321](https://github.com/ClickHouse/ClickHouse/pull/26321) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix `optimize_distributed_group_by_sharding_key` for multiple columns (leads to incorrect result w/ `optimize_skip_unused_shards=1`/`allow_nondeterministic_optimize_skip_unused_shards=1` and multiple columns in sharding key expression). [#26353](https://github.com/ClickHouse/ClickHouse/pull/26353) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible crash when login as dropped user. This PR fixes [#26073](https://github.com/ClickHouse/ClickHouse/issues/26073). [#26363](https://github.com/ClickHouse/ClickHouse/pull/26363) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix infinite non joined block stream in `partial_merge_join` close [#26325](https://github.com/ClickHouse/ClickHouse/issues/26325). [#26374](https://github.com/ClickHouse/ClickHouse/pull/26374) ([Vladimir C](https://github.com/vdimir)).
* Now, scalar subquery always returns `Nullable` result if it's type can be `Nullable`. It is needed because in case of empty subquery it's result should be `Null`. Previously, it was possible to get error about incompatible types (type deduction does not execute scalar subquery, and it could use not-nullable type). Scalar subquery with empty result which can't be converted to `Nullable` (like `Array` or `Tuple`) now throws error. Fixes [#25411](https://github.com/ClickHouse/ClickHouse/issues/25411). [#26423](https://github.com/ClickHouse/ClickHouse/pull/26423) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix some fuzzed msan crash. Fixes [#22517](https://github.com/ClickHouse/ClickHouse/issues/22517). [#26428](https://github.com/ClickHouse/ClickHouse/pull/26428) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix broken name resolution after rewriting column aliases. This fixes [#26432](https://github.com/ClickHouse/ClickHouse/issues/26432). [#26475](https://github.com/ClickHouse/ClickHouse/pull/26475) ([Amos Bird](https://github.com/amosbird)).
* Fix issues with `CREATE DICTIONARY` query if dictionary name or database name was quoted. Closes [#26491](https://github.com/ClickHouse/ClickHouse/issues/26491). [#26508](https://github.com/ClickHouse/ClickHouse/pull/26508) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix crash in rabbitmq shutdown in case rabbitmq setup was not started. Closes [#26504](https://github.com/ClickHouse/ClickHouse/issues/26504). [#26529](https://github.com/ClickHouse/ClickHouse/pull/26529) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update `chown` cmd check in clickhouse-server docker entrypoint. It fixes the bug that cluster pod restart failed (or timeout) on kubernetes. [#26545](https://github.com/ClickHouse/ClickHouse/pull/26545) ([Ky Li](https://github.com/Kylinrix)).
* Fix incorrect function names of groupBitmapAnd/Or/Xor. This fixes. [#26557](https://github.com/ClickHouse/ClickHouse/pull/26557) ([Amos Bird](https://github.com/amosbird)).
* Fix history file conversion if file is empty. [#26589](https://github.com/ClickHouse/ClickHouse/pull/26589) ([Azat Khuzhin](https://github.com/azat)).
* Fix potential nullptr dereference in window functions. This fixes [#25276](https://github.com/ClickHouse/ClickHouse/issues/25276). [#26668](https://github.com/ClickHouse/ClickHouse/pull/26668) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* ParallelFormattingOutputFormat: Use mutex to handle the join to the collector_thread (https://github.com/ClickHouse/ClickHouse/issues/26694). [#26703](https://github.com/ClickHouse/ClickHouse/pull/26703) ([Raúl Marín](https://github.com/Algunenano)).
* Sometimes SET ROLE could work incorrectly, this PR fixes that. [#26707](https://github.com/ClickHouse/ClickHouse/pull/26707) ([Vitaly Baranov](https://github.com/vitlibar)).
* Do not remove data on ReplicatedMergeTree table shutdown to avoid creating data to metadata inconsistency. [#26716](https://github.com/ClickHouse/ClickHouse/pull/26716) ([nvartolomei](https://github.com/nvartolomei)).
* Add `event_time_microseconds` value for `REMOVE_PART` in `system.part_log`. In previous versions is was not set. [#26720](https://github.com/ClickHouse/ClickHouse/pull/26720) ([Azat Khuzhin](https://github.com/azat)).
* Aggregate function parameters might be lost when applying some combinators causing exceptions like `Conversion from AggregateFunction(topKArray, Array(String)) to AggregateFunction(topKArray(10), Array(String)) is not supported`. It's fixed. Fixes [#26196](https://github.com/ClickHouse/ClickHouse/issues/26196) and [#26433](https://github.com/ClickHouse/ClickHouse/issues/26433). [#26814](https://github.com/ClickHouse/ClickHouse/pull/26814) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix library-bridge ids load. [#26834](https://github.com/ClickHouse/ClickHouse/pull/26834) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix error `Missing columns: 'xxx'` when `DEFAULT` column references other non materialized column without `DEFAULT` expression. Fixes [#26591](https://github.com/ClickHouse/ClickHouse/issues/26591). [#26900](https://github.com/ClickHouse/ClickHouse/pull/26900) ([alesapin](https://github.com/alesapin)).
* Fix reading of custom TLDs (stops processing with lower buffer or bigger file). [#26948](https://github.com/ClickHouse/ClickHouse/pull/26948) ([Azat Khuzhin](https://github.com/azat)).
* Fix "Unknown column name" error with multiple JOINs in some cases, close [#26899](https://github.com/ClickHouse/ClickHouse/issues/26899). [#26957](https://github.com/ClickHouse/ClickHouse/pull/26957) ([Vladimir C](https://github.com/vdimir)).
* Now partition ID in queries like `ALTER TABLE ... PARTITION ID xxx` validates for correctness. Fixes [#25718](https://github.com/ClickHouse/ClickHouse/issues/25718). [#26963](https://github.com/ClickHouse/ClickHouse/pull/26963) ([alesapin](https://github.com/alesapin)).
* [RFC] Fix possible mutation stack due to race with DROP_RANGE. [#27002](https://github.com/ClickHouse/ClickHouse/pull/27002) ([Azat Khuzhin](https://github.com/azat)).
* Fixed `cache`, `complex_key_cache`, `ssd_cache`, `complex_key_ssd_cache` configuration parsing. Options `allow_read_expired_keys`, `max_update_queue_size`, `update_queue_push_timeout_milliseconds`, `query_wait_timeout_milliseconds` were not parsed for dictionaries with non `cache` type. [#27032](https://github.com/ClickHouse/ClickHouse/pull/27032) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix synchronization in GRPCServer This PR fixes [#27024](https://github.com/ClickHouse/ClickHouse/issues/27024). [#27064](https://github.com/ClickHouse/ClickHouse/pull/27064) ([Vitaly Baranov](https://github.com/vitlibar)).
* - Fix uninitialized memory in functions `multiSearch*` with empty array, close [#27169](https://github.com/ClickHouse/ClickHouse/issues/27169). [#27181](https://github.com/ClickHouse/ClickHouse/pull/27181) ([Vladimir C](https://github.com/vdimir)).
* In rare cases `system.detached_parts` table might contain incorrect information for some parts, it's fixed. Fixes [#27114](https://github.com/ClickHouse/ClickHouse/issues/27114). [#27183](https://github.com/ClickHouse/ClickHouse/pull/27183) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix on-disk format breakage for secondary indices over Nullable column (no stable release had been affected). [#27197](https://github.com/ClickHouse/ClickHouse/pull/27197) ([Azat Khuzhin](https://github.com/azat)).
* Fix column structure in merge join, close [#27091](https://github.com/ClickHouse/ClickHouse/issues/27091). [#27217](https://github.com/ClickHouse/ClickHouse/pull/27217) ([Vladimir C](https://github.com/vdimir)).
* In case of ambiguity, lambda functions prefer its arguments to other aliases or identifiers. [#27235](https://github.com/ClickHouse/ClickHouse/pull/27235) ([Raúl Marín](https://github.com/Algunenano)).
* Fix mutation stuck on invalid partitions in non-replicated MergeTree. [#27248](https://github.com/ClickHouse/ClickHouse/pull/27248) ([Azat Khuzhin](https://github.com/azat)).
* Fix `distributed_group_by_no_merge=2`+`distributed_push_down_limit=1` or `optimize_distributed_group_by_sharding_key=1` with `LIMIT BY` and `LIMIT OFFSET`. [#27249](https://github.com/ClickHouse/ClickHouse/pull/27249) ([Azat Khuzhin](https://github.com/azat)).
* Fix errors like `Expected ColumnLowCardinality, gotUInt8` or `Bad cast from type DB::ColumnVector<char8_t> to DB::ColumnLowCardinality` for some queries with `LowCardinality` in `PREWHERE`. Fixes [#23515](https://github.com/ClickHouse/ClickHouse/issues/23515). [#27298](https://github.com/ClickHouse/ClickHouse/pull/27298) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix `Cannot find column` error for queries with sampling. Was introduced in [#24574](https://github.com/ClickHouse/ClickHouse/issues/24574). Fixes [#26522](https://github.com/ClickHouse/ClickHouse/issues/26522). [#27301](https://github.com/ClickHouse/ClickHouse/pull/27301) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix Mysql protocol when using parallel formats (CSV / TSV). [#27326](https://github.com/ClickHouse/ClickHouse/pull/27326) ([Raúl Marín](https://github.com/Algunenano)).
* Fixed incorrect validation of partition id for MergeTree tables that created with old syntax. [#27328](https://github.com/ClickHouse/ClickHouse/pull/27328) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix incorrect result for query with row-level security, prewhere and LowCardinality filter. Fixes [#27179](https://github.com/ClickHouse/ClickHouse/issues/27179). [#27329](https://github.com/ClickHouse/ClickHouse/pull/27329) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* /proc/info contains metrics like. [#27361](https://github.com/ClickHouse/ClickHouse/pull/27361) ([Mike Kot](https://github.com/myrrc)).
* Fix distributed queries with zero shards and aggregation. [#27427](https://github.com/ClickHouse/ClickHouse/pull/27427) ([Azat Khuzhin](https://github.com/azat)).
* fix metric BackgroundMessageBrokerSchedulePoolTask, maybe mistyped。. [#27452](https://github.com/ClickHouse/ClickHouse/pull/27452) ([Ben](https://github.com/benbiti)).
* Fix crash during projection materialization when some parts contain missing columns. This fixes [#27512](https://github.com/ClickHouse/ClickHouse/issues/27512). [#27528](https://github.com/ClickHouse/ClickHouse/pull/27528) ([Amos Bird](https://github.com/amosbird)).
* Fixed underflow of the time value when constructing it from components. Closes [#27193](https://github.com/ClickHouse/ClickHouse/issues/27193). [#27605](https://github.com/ClickHouse/ClickHouse/pull/27605) ([Vasily Nemkov](https://github.com/Enmk)).
* After setting `max_memory_usage*` to non-zero value it was not possible to reset it back to 0 (unlimited). It's fixed. [#27638](https://github.com/ClickHouse/ClickHouse/pull/27638) ([Alexander Tokmakov](https://github.com/tavplubix)).
* - Fix bug with aliased column in `Distributed` table. [#27652](https://github.com/ClickHouse/ClickHouse/pull/27652) ([Vladimir C](https://github.com/vdimir)).
* Fixed another case of `Unexpected merged part ... intersecting drop range ...` error. [#27656](https://github.com/ClickHouse/ClickHouse/pull/27656) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix postgresql table function resulting in non-closing connections. Closes [#26088](https://github.com/ClickHouse/ClickHouse/issues/26088). [#27662](https://github.com/ClickHouse/ClickHouse/pull/27662) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bad type cast when functions like `arrayHas` are applied to arrays of LowCardinality of Nullable of different non-numeric types like `DateTime` and `DateTime64`. In previous versions bad cast occurs. In new version it will lead to exception. This closes [#26330](https://github.com/ClickHouse/ClickHouse/issues/26330). [#27682](https://github.com/ClickHouse/ClickHouse/pull/27682) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix column filtering with union distinct in subquery. Closes [#27578](https://github.com/ClickHouse/ClickHouse/issues/27578). [#27689](https://github.com/ClickHouse/ClickHouse/pull/27689) ([Kseniia Sumarokova](https://github.com/kssenii)).
* After https://github.com/ClickHouse/ClickHouse/pull/26384. To execute `GRANT WITH REPLACE OPTION` now the current user should have `GRANT OPTION` for access rights it's going to grant AND for access rights it's going to revoke. [#27701](https://github.com/ClickHouse/ClickHouse/pull/27701) ([Vitaly Baranov](https://github.com/vitlibar)).
* After https://github.com/ClickHouse/ClickHouse/pull/25687. Add backquotes for the default database shown in CREATE USER. [#27702](https://github.com/ClickHouse/ClickHouse/pull/27702) ([Vitaly Baranov](https://github.com/vitlibar)).
* Remove duplicated source files in CMakeLists.txt in arrow-cmake. [#27736](https://github.com/ClickHouse/ClickHouse/pull/27736) ([李扬](https://github.com/taiyang-li)).
* Fix possible crash when asynchronous connection draining is enabled and hedged connection is disabled. [#27774](https://github.com/ClickHouse/ClickHouse/pull/27774) ([Amos Bird](https://github.com/amosbird)).
* Prevent crashes for some formats when NULL (tombstone) message was coming from Kafka. Closes [#19255](https://github.com/ClickHouse/ClickHouse/issues/19255). [#27794](https://github.com/ClickHouse/ClickHouse/pull/27794) ([filimonov](https://github.com/filimonov)).
* Fix a rare bug in `DROP PART` which can lead to the error `Unexpected merged part intersects drop range`. [#27807](https://github.com/ClickHouse/ClickHouse/pull/27807) ([alesapin](https://github.com/alesapin)).
* Fix a couple of bugs that may cause replicas to diverge. [#27808](https://github.com/ClickHouse/ClickHouse/pull/27808) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### Build/Testing/Packaging Improvement
* Update RocksDB to 2021-07-16 master. [#26411](https://github.com/ClickHouse/ClickHouse/pull/26411) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `clickhouse-test` supports SQL tests with [Jinja2](https://jinja.palletsprojects.com/en/3.0.x/templates/#synopsis) templates. [#26579](https://github.com/ClickHouse/ClickHouse/pull/26579) ([Vladimir C](https://github.com/vdimir)).
* Fix /clickhouse/window functions/tests/non distributed/errors/error window function in join. [#26744](https://github.com/ClickHouse/ClickHouse/pull/26744) ([vzakaznikov](https://github.com/vzakaznikov)).
* Enabling RBAC TestFlows tests and crossing out new fails. [#26747](https://github.com/ClickHouse/ClickHouse/pull/26747) ([vzakaznikov](https://github.com/vzakaznikov)).
* Tests: Fix CLICKHOUSE_CLIENT_SECURE with the default config. [#26901](https://github.com/ClickHouse/ClickHouse/pull/26901) ([Raúl Marín](https://github.com/Algunenano)).
* Fix linking of auxiliar programs when using dynamic libraries. [#26958](https://github.com/ClickHouse/ClickHouse/pull/26958) ([Raúl Marín](https://github.com/Algunenano)).
* Add CMake options to build with or without specific CPU instruction set. This is for [#17469](https://github.com/ClickHouse/ClickHouse/issues/17469) and [#27509](https://github.com/ClickHouse/ClickHouse/issues/27509). [#27508](https://github.com/ClickHouse/ClickHouse/pull/27508) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add support for build with `clang-13`. This closes [#27705](https://github.com/ClickHouse/ClickHouse/issues/27705). [#27714](https://github.com/ClickHouse/ClickHouse/pull/27714) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve support for build with `clang-13`. [#27777](https://github.com/ClickHouse/ClickHouse/pull/27777) ([Sergei Semin](https://github.com/syominsergey)).

#### Other
* Rename `MaterializeMySQL` to `MaterializedMySQL`. [#26822](https://github.com/ClickHouse/ClickHouse/pull/26822) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### NO CL ENTRY

* NO CL ENTRY:  'Modify code comments'. [#26265](https://github.com/ClickHouse/ClickHouse/pull/26265) ([xiedeyantu](https://github.com/xiedeyantu)).
* NO CL ENTRY:  'Revert "Datatype Date32, support range 1925 to 2283"'. [#26352](https://github.com/ClickHouse/ClickHouse/pull/26352) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Fix CURR_DATABASE empty for 01034_move_partition_from_table_zookeeper.sh'. [#27164](https://github.com/ClickHouse/ClickHouse/pull/27164) ([小路](https://github.com/nicelulu)).
* NO CL ENTRY:  'DOCSUP-12413: macros support in functions cluster and clusterAllReplicas'. [#27759](https://github.com/ClickHouse/ClickHouse/pull/27759) ([olgarev](https://github.com/olgarev)).
* NO CL ENTRY:  'Revert "less sys calls #2: make vdso work again"'. [#27829](https://github.com/ClickHouse/ClickHouse/pull/27829) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Do not miss exceptions from the ThreadPool"'. [#27844](https://github.com/ClickHouse/ClickHouse/pull/27844) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix prometheus metric name [#26140](https://github.com/ClickHouse/ClickHouse/pull/26140) ([Vladimir C](https://github.com/vdimir)).
* Add comments for the implementations of the pad functions [#26147](https://github.com/ClickHouse/ClickHouse/pull/26147) ([Vitaly Baranov](https://github.com/vitlibar)).
* Change color in client for double colon [#26152](https://github.com/ClickHouse/ClickHouse/pull/26152) ([Anton Popov](https://github.com/CurtizJ)).
* Remove misleading stderr output [#26155](https://github.com/ClickHouse/ClickHouse/pull/26155) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Merging [#26041](https://github.com/ClickHouse/ClickHouse/issues/26041). [#26180](https://github.com/ClickHouse/ClickHouse/pull/26180) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad code (default function argument) [#26213](https://github.com/ClickHouse/ClickHouse/pull/26213) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support for `pread` in `ReadBufferFromFile` [#26232](https://github.com/ClickHouse/ClickHouse/pull/26232) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix ReadBufferFromS3 [#26249](https://github.com/ClickHouse/ClickHouse/pull/26249) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix output of TSV in integration tests [#26257](https://github.com/ClickHouse/ClickHouse/pull/26257) ([Anton Popov](https://github.com/CurtizJ)).
* Enum type additional support for compilation [#26258](https://github.com/ClickHouse/ClickHouse/pull/26258) ([Maksim Kita](https://github.com/kitaisreal)).
* Bump poco (now poco fork has CI via github actions) [#26262](https://github.com/ClickHouse/ClickHouse/pull/26262) ([Azat Khuzhin](https://github.com/azat)).
* Add check for sqlite database path [#26266](https://github.com/ClickHouse/ClickHouse/pull/26266) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix arcadia [#26285](https://github.com/ClickHouse/ClickHouse/pull/26285) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* yandex/clickhouse-test-base Dockerfile fix (mysql connector moved) [#26294](https://github.com/ClickHouse/ClickHouse/pull/26294) ([Ilya Golshtein](https://github.com/ilejn)).
* Improve read_file_to_stringcolumn test compatibility [#26317](https://github.com/ClickHouse/ClickHouse/pull/26317) ([Raúl Marín](https://github.com/Algunenano)).
* Make socket poll() 7x faster (by replacing epoll() with poll()) [#26323](https://github.com/ClickHouse/ClickHouse/pull/26323) ([Azat Khuzhin](https://github.com/azat)).
* Modifications to an obscure Yandex TSKV format [#26326](https://github.com/ClickHouse/ClickHouse/pull/26326) ([egatov](https://github.com/egatov)).
* Fixing RBAC sample by tests in TestFlows. [#26329](https://github.com/ClickHouse/ClickHouse/pull/26329) ([vzakaznikov](https://github.com/vzakaznikov)).
* Fix error in stress test script [#26349](https://github.com/ClickHouse/ClickHouse/pull/26349) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky integration test about "replicated max parallel fetches". [#26362](https://github.com/ClickHouse/ClickHouse/pull/26362) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Continuation of [#25774](https://github.com/ClickHouse/ClickHouse/issues/25774) [#26364](https://github.com/ClickHouse/ClickHouse/pull/26364) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Enabling all TestFlows modules except LDAP after Kerberos merge. [#26366](https://github.com/ClickHouse/ClickHouse/pull/26366) ([vzakaznikov](https://github.com/vzakaznikov)).
* Fix flaky test 01293_client_interactive_vertical_multiline_long [#26367](https://github.com/ClickHouse/ClickHouse/pull/26367) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Small bugfix in Block [#26373](https://github.com/ClickHouse/ClickHouse/pull/26373) ([Anton Popov](https://github.com/CurtizJ)).
* More integration tests improvements. [#26375](https://github.com/ClickHouse/ClickHouse/pull/26375) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix arcadia [#26378](https://github.com/ClickHouse/ClickHouse/pull/26378) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add separate step to read from remote. [#26381](https://github.com/ClickHouse/ClickHouse/pull/26381) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix calculating of intersection of access rights. [#26383](https://github.com/ClickHouse/ClickHouse/pull/26383) ([Vitaly Baranov](https://github.com/vitlibar)).
* Less logging in AsynchronousMetrics [#26391](https://github.com/ClickHouse/ClickHouse/pull/26391) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* stress tests report improvements [#26393](https://github.com/ClickHouse/ClickHouse/pull/26393) ([Azat Khuzhin](https://github.com/azat)).
* Fix failed assertion in RocksDB in case of bad_alloc exception during batch write [#26394](https://github.com/ClickHouse/ClickHouse/pull/26394) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add integrity for loaded scripts in play.html [#26409](https://github.com/ClickHouse/ClickHouse/pull/26409) ([Vladimir C](https://github.com/vdimir)).
* Relax condition in flaky test [#26425](https://github.com/ClickHouse/ClickHouse/pull/26425) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Split FunctionsCoding into several files [#26426](https://github.com/ClickHouse/ClickHouse/pull/26426) ([Vladimir C](https://github.com/vdimir)).
* Remove MySQLWireContext [#26429](https://github.com/ClickHouse/ClickHouse/pull/26429) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix "While sending batch" (on Distributed async send) [#26430](https://github.com/ClickHouse/ClickHouse/pull/26430) ([Azat Khuzhin](https://github.com/azat)).
* Tests fixes v21.9.1.7477 [#26431](https://github.com/ClickHouse/ClickHouse/pull/26431) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test_replicated_mutations (due to lack of threads in pool) [#26461](https://github.com/ClickHouse/ClickHouse/pull/26461) ([Azat Khuzhin](https://github.com/azat)).
* Fix undefined-behavior in DirectoryMonitor (for exponential back off) [#26464](https://github.com/ClickHouse/ClickHouse/pull/26464) ([Azat Khuzhin](https://github.com/azat)).
* Remove some code [#26468](https://github.com/ClickHouse/ClickHouse/pull/26468) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Rewrite distributed DDL to Processors [#26469](https://github.com/ClickHouse/ClickHouse/pull/26469) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky test `distributed_ddl_output_mode` [#26470](https://github.com/ClickHouse/ClickHouse/pull/26470) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update link to dpkg-deb in dockerfiles [#26497](https://github.com/ClickHouse/ClickHouse/pull/26497) ([Vladimir C](https://github.com/vdimir)).
* SELECT String from ClickHouse as Avro string - PartialMatch [#26499](https://github.com/ClickHouse/ClickHouse/pull/26499) ([Ilya Golshtein](https://github.com/ilejn)).
* Fix arcadia [#26505](https://github.com/ClickHouse/ClickHouse/pull/26505) ([Anton Popov](https://github.com/CurtizJ)).
* Fix build under AppleClang 12 [#26509](https://github.com/ClickHouse/ClickHouse/pull/26509) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix lagInFrame for nullable types [#26521](https://github.com/ClickHouse/ClickHouse/pull/26521) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Handle empty testset in 'Functional stateless tests flaky check' [#26552](https://github.com/ClickHouse/ClickHouse/pull/26552) ([Vladimir C](https://github.com/vdimir)).
* Remove some streams. [#26590](https://github.com/ClickHouse/ClickHouse/pull/26590) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix flaky test 01622_defaults_for_url_engine [#26617](https://github.com/ClickHouse/ClickHouse/pull/26617) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky test 01509_check_many_parallel_quorum_inserts [#26618](https://github.com/ClickHouse/ClickHouse/pull/26618) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix one possible cause of tests flakiness [#26619](https://github.com/ClickHouse/ClickHouse/pull/26619) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove some code, more C++ way [#26620](https://github.com/ClickHouse/ClickHouse/pull/26620) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix mysql_kill_sync_thread_restore_test [#26673](https://github.com/ClickHouse/ClickHouse/pull/26673) ([Vladimir C](https://github.com/vdimir)).
* Minor bugfix [#26678](https://github.com/ClickHouse/ClickHouse/pull/26678) ([Anton Popov](https://github.com/CurtizJ)).
* copypaste error [#26679](https://github.com/ClickHouse/ClickHouse/pull/26679) ([Denny Crane](https://github.com/den-crane)).
* Fix flaky test `mutation_stuck_after_replace_partition` [#26684](https://github.com/ClickHouse/ClickHouse/pull/26684) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Log errors on integration test listing error in ci-runner [#26691](https://github.com/ClickHouse/ClickHouse/pull/26691) ([Vladimir C](https://github.com/vdimir)).
* more debug checks for window functions [#26701](https://github.com/ClickHouse/ClickHouse/pull/26701) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* record server exit code in fuzzer [#26706](https://github.com/ClickHouse/ClickHouse/pull/26706) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove more streams. [#26713](https://github.com/ClickHouse/ClickHouse/pull/26713) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 01946_test_wrong_host_name_access: Clear DNS in the end [#26715](https://github.com/ClickHouse/ClickHouse/pull/26715) ([Raúl Marín](https://github.com/Algunenano)).
* Setting min_count_to_compile_aggregate_expression fix [#26718](https://github.com/ClickHouse/ClickHouse/pull/26718) ([Maksim Kita](https://github.com/kitaisreal)).
* Compile aggregate functions profile events fix [#26719](https://github.com/ClickHouse/ClickHouse/pull/26719) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix use after free in AsyncDrain connection from S3Cluster [#26731](https://github.com/ClickHouse/ClickHouse/pull/26731) ([Vladimir C](https://github.com/vdimir)).
* Fixed wrong error message in `S3Common` [#26738](https://github.com/ClickHouse/ClickHouse/pull/26738) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Lock mutex before access to std::cerr in clickhouse-benchmark [#26742](https://github.com/ClickHouse/ClickHouse/pull/26742) ([Vladimir C](https://github.com/vdimir)).
* Remove some output streams [#26758](https://github.com/ClickHouse/ClickHouse/pull/26758) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Merging [#25960](https://github.com/ClickHouse/ClickHouse/issues/25960) (Bolonini/read_from_file) [#26777](https://github.com/ClickHouse/ClickHouse/pull/26777) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Heredoc updated tests [#26784](https://github.com/ClickHouse/ClickHouse/pull/26784) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix double unlock in RocksDB [#26786](https://github.com/ClickHouse/ClickHouse/pull/26786) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix sqlite engine attach [#26795](https://github.com/ClickHouse/ClickHouse/pull/26795) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove unneeded mutex during connection draining [#26807](https://github.com/ClickHouse/ClickHouse/pull/26807) ([Amos Bird](https://github.com/amosbird)).
* Make sure table is readonly when restarting fails. [#26808](https://github.com/ClickHouse/ClickHouse/pull/26808) ([Amos Bird](https://github.com/amosbird)).
* Check stdout for messages to retry in clickhouse-test [#26817](https://github.com/ClickHouse/ClickHouse/pull/26817) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix killing unstopped containers in integration tests. [#26818](https://github.com/ClickHouse/ClickHouse/pull/26818) ([Vitaly Baranov](https://github.com/vitlibar)).
* Do not start new hedged connection if query was already canceled. [#26820](https://github.com/ClickHouse/ClickHouse/pull/26820) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Try fix rabbitmq tests [#26826](https://github.com/ClickHouse/ClickHouse/pull/26826) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Wait for self datasource to be initialized in test_jdbc_bridge [#26827](https://github.com/ClickHouse/ClickHouse/pull/26827) ([Ilya Yatsishin](https://github.com/qoega)).
* Flush LazyOutputFormat on query cancel. [#26828](https://github.com/ClickHouse/ClickHouse/pull/26828) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Try fix timeout in functional tests with pytest [#26830](https://github.com/ClickHouse/ClickHouse/pull/26830) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Compile aggregate functions without key [#26845](https://github.com/ClickHouse/ClickHouse/pull/26845) ([Maksim Kita](https://github.com/kitaisreal)).
* Introduce sessions [#26864](https://github.com/ClickHouse/ClickHouse/pull/26864) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix rabbitmq sink [#26871](https://github.com/ClickHouse/ClickHouse/pull/26871) ([Kseniia Sumarokova](https://github.com/kssenii)).
* One more library bridge fix [#26873](https://github.com/ClickHouse/ClickHouse/pull/26873) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix keeper bench compilation [#26874](https://github.com/ClickHouse/ClickHouse/pull/26874) ([Raúl Marín](https://github.com/Algunenano)).
* Better integration tests [#26894](https://github.com/ClickHouse/ClickHouse/pull/26894) ([Ilya Yatsishin](https://github.com/qoega)).
* Maybe fix extremely rare `intersecting parts`. [#26896](https://github.com/ClickHouse/ClickHouse/pull/26896) ([alesapin](https://github.com/alesapin)).
* Try increase diff upper bound [#26897](https://github.com/ClickHouse/ClickHouse/pull/26897) ([Ilya Yatsishin](https://github.com/qoega)).
* Enable Arrow format in Arcadia [#26898](https://github.com/ClickHouse/ClickHouse/pull/26898) ([Vitaly Stoyan](https://github.com/vitstn)).
* Improve test compatibility (00646_url_engine and 01854_HTTP_dict_decompression) [#26915](https://github.com/ClickHouse/ClickHouse/pull/26915) ([Raúl Marín](https://github.com/Algunenano)).
* Update NuRaft [#26916](https://github.com/ClickHouse/ClickHouse/pull/26916) ([alesapin](https://github.com/alesapin)).
* 01921_datatype_date32: Adapt it to work under Pacific/Fiji [#26918](https://github.com/ClickHouse/ClickHouse/pull/26918) ([Raúl Marín](https://github.com/Algunenano)).
* Remove unused files that confuse developers [#26913](https://github.com/ClickHouse/ClickHouse/issues/26913) [#26947](https://github.com/ClickHouse/ClickHouse/pull/26947) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Set allow_remote_fs_zero_copy_replication to true by default [#26951](https://github.com/ClickHouse/ClickHouse/pull/26951) ([ianton-ru](https://github.com/ianton-ru)).
* Hold context in HedgedConnections to prevent use-after-free on settings. [#26953](https://github.com/ClickHouse/ClickHouse/pull/26953) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix client options in stress test [#26959](https://github.com/ClickHouse/ClickHouse/pull/26959) ([Alexander Tokmakov](https://github.com/tavplubix)).
* fix window function partition boundary search [#26960](https://github.com/ClickHouse/ClickHouse/pull/26960) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Print trace from std::terminate exception line-by-line to make it grep easier [#26962](https://github.com/ClickHouse/ClickHouse/pull/26962) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix system.zookeeper_log initialization [#26972](https://github.com/ClickHouse/ClickHouse/pull/26972) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Benchmark script fix [#26974](https://github.com/ClickHouse/ClickHouse/pull/26974) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix 01600_quota_by_forwarded_ip [#26975](https://github.com/ClickHouse/ClickHouse/pull/26975) ([Raúl Marín](https://github.com/Algunenano)).
* 01674_executable_dictionary_implicit_key: executable_dictionary: Use printf [#26978](https://github.com/ClickHouse/ClickHouse/pull/26978) ([Raúl Marín](https://github.com/Algunenano)).
* Remove test_keeper_server usage (for {operation/session}_timeout_ms) [#26984](https://github.com/ClickHouse/ClickHouse/pull/26984) ([Azat Khuzhin](https://github.com/azat)).
* Set insert_quorum_timeout to 1 minute for tests. [#27007](https://github.com/ClickHouse/ClickHouse/pull/27007) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Adjust 00537_quarters to be timezone independent [#27008](https://github.com/ClickHouse/ClickHouse/pull/27008) ([Raúl Marín](https://github.com/Algunenano)).
* Help with [#26424](https://github.com/ClickHouse/ClickHouse/issues/26424) [#27009](https://github.com/ClickHouse/ClickHouse/pull/27009) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Attempt to fix flaky 00705_drop_create_merge_tree [#27023](https://github.com/ClickHouse/ClickHouse/pull/27023) ([Raúl Marín](https://github.com/Algunenano)).
* Improved `runner` to use `pytest` keyword expressions [#27026](https://github.com/ClickHouse/ClickHouse/pull/27026) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Improve 01006_simpod_empty_part_single_column_write [#27028](https://github.com/ClickHouse/ClickHouse/pull/27028) ([Raúl Marín](https://github.com/Algunenano)).
* Improved logging of `hwmon` sensor errors in `AsynchronousMetrics` [#27031](https://github.com/ClickHouse/ClickHouse/pull/27031) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix assertions in Replicated database [#27033](https://github.com/ClickHouse/ClickHouse/pull/27033) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Make test 01852_cast_operator independent of timezone [#27037](https://github.com/ClickHouse/ClickHouse/pull/27037) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Moving to TestFlows 1.7.20 that has native support for parallel tests. [#27040](https://github.com/ClickHouse/ClickHouse/pull/27040) ([vzakaznikov](https://github.com/vzakaznikov)).
* library bridge fixes [#27060](https://github.com/ClickHouse/ClickHouse/pull/27060) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix synchronization while updating from the config of an encrypted disk. [#27065](https://github.com/ClickHouse/ClickHouse/pull/27065) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix excessive logging in NuRaft on server shutdown [#27081](https://github.com/ClickHouse/ClickHouse/pull/27081) ([alesapin](https://github.com/alesapin)).
* Fix test_merge_tree_s3_failover with debug build [#27089](https://github.com/ClickHouse/ClickHouse/pull/27089) ([ianton-ru](https://github.com/ianton-ru)).
* Stateless tests: Keep an DNS error free log [#27092](https://github.com/ClickHouse/ClickHouse/pull/27092) ([Raúl Marín](https://github.com/Algunenano)).
* Normalize hostname in stateless tests [#27093](https://github.com/ClickHouse/ClickHouse/pull/27093) ([Amos Bird](https://github.com/amosbird)).
* Try update AMQP-CPP [#27095](https://github.com/ClickHouse/ClickHouse/pull/27095) ([Ilya Yatsishin](https://github.com/qoega)).
* Try update arrow [#27097](https://github.com/ClickHouse/ClickHouse/pull/27097) ([Ilya Yatsishin](https://github.com/qoega)).
* GlobalSubqueriesVisitor external storage check fix [#27131](https://github.com/ClickHouse/ClickHouse/pull/27131) ([Maksim Kita](https://github.com/kitaisreal)).
* Better code around decompression [#27136](https://github.com/ClickHouse/ClickHouse/pull/27136) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add test for parsing maps with integer keys [#27146](https://github.com/ClickHouse/ClickHouse/pull/27146) ([Anton Popov](https://github.com/CurtizJ)).
* Fix arcadia src/Access gtest  [#27152](https://github.com/ClickHouse/ClickHouse/pull/27152) ([Ilya Yatsishin](https://github.com/qoega)).
* Implement `legacy_column_name_of_tuple_literal` in a less intrusive way [#27153](https://github.com/ClickHouse/ClickHouse/pull/27153) ([Anton Popov](https://github.com/CurtizJ)).
* Updated readIntTextUnsafe [#27155](https://github.com/ClickHouse/ClickHouse/pull/27155) ([Maksim Kita](https://github.com/kitaisreal)).
* Safer `ReadBufferFromS3` for merges and backports [#27168](https://github.com/ClickHouse/ClickHouse/pull/27168) ([Vladimir Chebotarev](https://github.com/excitoon)).
* properly check the settings in perf test [#27190](https://github.com/ClickHouse/ClickHouse/pull/27190) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Save information about used functions/tables/... into query_log on error [#27194](https://github.com/ClickHouse/ClickHouse/pull/27194) ([Azat Khuzhin](https://github.com/azat)).
* Fix polling of /sys/block [#27195](https://github.com/ClickHouse/ClickHouse/pull/27195) ([Azat Khuzhin](https://github.com/azat)).
* Allow parallel execution of *.sql tests with ReplicatedMergeTree (by using {database} macro) [#27214](https://github.com/ClickHouse/ClickHouse/pull/27214) ([Azat Khuzhin](https://github.com/azat)).
* Fix NLP performance test [#27219](https://github.com/ClickHouse/ClickHouse/pull/27219) ([Nikolay Degterinsky](https://github.com/evillique)).
* Update changelog/README.md [#27221](https://github.com/ClickHouse/ClickHouse/pull/27221) ([filimonov](https://github.com/filimonov)).
* more careful handling of reconnects in fuzzer [#27222](https://github.com/ClickHouse/ClickHouse/pull/27222) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* ADDINCL proper fast_float directory [#27224](https://github.com/ClickHouse/ClickHouse/pull/27224) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* DatabaseReplicatedWorker logs_to_keep race fix [#27225](https://github.com/ClickHouse/ClickHouse/pull/27225) ([Maksim Kita](https://github.com/kitaisreal)).
* Revert [#24095](https://github.com/ClickHouse/ClickHouse/issues/24095). User-level settings will affect queries from view. [#27227](https://github.com/ClickHouse/ClickHouse/pull/27227) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Using formatted string literals in clickhouse-test, extracted sort key functions and stacktraces printer [#27228](https://github.com/ClickHouse/ClickHouse/pull/27228) ([Mike Kot](https://github.com/myrrc)).
* Fix polling of /sys/block in case of block devices reopened on error [#27266](https://github.com/ClickHouse/ClickHouse/pull/27266) ([Azat Khuzhin](https://github.com/azat)).
* Remove streams from dicts [#27273](https://github.com/ClickHouse/ClickHouse/pull/27273) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 01099_operators_date_and_timestamp: Use dates that work with all available timezones [#27275](https://github.com/ClickHouse/ClickHouse/pull/27275) ([Raúl Marín](https://github.com/Algunenano)).
* Improve kafka integration test error messages [#27294](https://github.com/ClickHouse/ClickHouse/pull/27294) ([Raúl Marín](https://github.com/Algunenano)).
* Improve 00738_lock_for_inner_table stability [#27300](https://github.com/ClickHouse/ClickHouse/pull/27300) ([Raúl Marín](https://github.com/Algunenano)).
* Add and check system.projection_parts for database filter [#27303](https://github.com/ClickHouse/ClickHouse/pull/27303) ([Azat Khuzhin](https://github.com/azat)).
* Update PVS checksum [#27317](https://github.com/ClickHouse/ClickHouse/pull/27317) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix 01300_client_save_history_when_terminated_long [#27324](https://github.com/ClickHouse/ClickHouse/pull/27324) ([Raúl Marín](https://github.com/Algunenano)).
* Try update contrib/zlib-ng [#27327](https://github.com/ClickHouse/ClickHouse/pull/27327) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix flaky test [#27383](https://github.com/ClickHouse/ClickHouse/pull/27383) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add and check system.mutations for database filter [#27384](https://github.com/ClickHouse/ClickHouse/pull/27384) ([Azat Khuzhin](https://github.com/azat)).
* Correct the key data type used in mapContains [#27423](https://github.com/ClickHouse/ClickHouse/pull/27423) ([Fuwang Hu](https://github.com/fuwhu)).
* Fix tests for WithMergeableStateAfterAggregationAndLimit [#27424](https://github.com/ClickHouse/ClickHouse/pull/27424) ([Azat Khuzhin](https://github.com/azat)).
* Do not miss exceptions from the ThreadPool [#27428](https://github.com/ClickHouse/ClickHouse/pull/27428) ([Azat Khuzhin](https://github.com/azat)).
* Accept error code by error name in client test hints [#27430](https://github.com/ClickHouse/ClickHouse/pull/27430) ([Azat Khuzhin](https://github.com/azat)).
* Added reserve method to Block [#27483](https://github.com/ClickHouse/ClickHouse/pull/27483) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* make it possible to cancel window functions on ctrl+c [#27487](https://github.com/ClickHouse/ClickHouse/pull/27487) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix Nullable const columns in JOIN [#27516](https://github.com/ClickHouse/ClickHouse/pull/27516) ([Vladimir C](https://github.com/vdimir)).
* Fix Logical error: 'Table UUID is not specified in DDL log' [#27521](https://github.com/ClickHouse/ClickHouse/pull/27521) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix 01236_graphite_mt for random timezones [#27525](https://github.com/ClickHouse/ClickHouse/pull/27525) ([Raúl Marín](https://github.com/Algunenano)).
* Add timeout for integration tests runner [#27535](https://github.com/ClickHouse/ClickHouse/pull/27535) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix polling of /sys/class on errors [#27554](https://github.com/ClickHouse/ClickHouse/pull/27554) ([Azat Khuzhin](https://github.com/azat)).
* fix  recalculate QueryMemoryLimitExceeded event error [#27556](https://github.com/ClickHouse/ClickHouse/pull/27556) ([Ben](https://github.com/benbiti)).
* Fix 01961_roaring_memory_tracking for split builds [#27557](https://github.com/ClickHouse/ClickHouse/pull/27557) ([Raúl Marín](https://github.com/Algunenano)).
* Improve the experience of running stateless tests locally [#27561](https://github.com/ClickHouse/ClickHouse/pull/27561) ([Raúl Marín](https://github.com/Algunenano)).
* Fix integration tests [#27562](https://github.com/ClickHouse/ClickHouse/pull/27562) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Dictionaries refactor [#27566](https://github.com/ClickHouse/ClickHouse/pull/27566) ([Maksim Kita](https://github.com/kitaisreal)).
* Less Stopwatch.h [#27569](https://github.com/ClickHouse/ClickHouse/pull/27569) ([filimonov](https://github.com/filimonov)).
* Aggregation temporary disable compilation without key [#27574](https://github.com/ClickHouse/ClickHouse/pull/27574) ([Maksim Kita](https://github.com/kitaisreal)).
* Removed some data streams [#27575](https://github.com/ClickHouse/ClickHouse/pull/27575) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove streams from lv [#27577](https://github.com/ClickHouse/ClickHouse/pull/27577) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* fix ProfileEvents::CompileFunction [#27606](https://github.com/ClickHouse/ClickHouse/pull/27606) ([Ben](https://github.com/benbiti)).
* Refactor mysql format check [#27609](https://github.com/ClickHouse/ClickHouse/pull/27609) ([Raúl Marín](https://github.com/Algunenano)).
* enable part_log by default [#27631](https://github.com/ClickHouse/ClickHouse/pull/27631) ([Denny Crane](https://github.com/den-crane)).
* Remove the remains of ANTLR in the tests [#27637](https://github.com/ClickHouse/ClickHouse/pull/27637) ([Raúl Marín](https://github.com/Algunenano)).
* MV: Improve text logs when doing parallel processing [#27639](https://github.com/ClickHouse/ClickHouse/pull/27639) ([Raúl Marín](https://github.com/Algunenano)).
* Fix test_sqlite_odbc_hashed_dictionary [#27647](https://github.com/ClickHouse/ClickHouse/pull/27647) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a test for [#10735](https://github.com/ClickHouse/ClickHouse/issues/10735) [#27677](https://github.com/ClickHouse/ClickHouse/pull/27677) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disable memory tracking for roaring bitmaps on Mac OS [#27681](https://github.com/ClickHouse/ClickHouse/pull/27681) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use only SSE2 in "unbundled" build [#27683](https://github.com/ClickHouse/ClickHouse/pull/27683) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove trash [#27685](https://github.com/ClickHouse/ClickHouse/pull/27685) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix stress test in `~CompressedWriteBuffer` [#27686](https://github.com/ClickHouse/ClickHouse/pull/27686) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Mark tests for `DatabaseReplicated` as green [#27688](https://github.com/ClickHouse/ClickHouse/pull/27688) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Removed DenseHashMap, DenseHashSet [#27690](https://github.com/ClickHouse/ClickHouse/pull/27690) ([Maksim Kita](https://github.com/kitaisreal)).
* Map data type parsing tests [#27692](https://github.com/ClickHouse/ClickHouse/pull/27692) ([Maksim Kita](https://github.com/kitaisreal)).
* Refactor arrayJoin check on partition expressions [#27733](https://github.com/ClickHouse/ClickHouse/pull/27733) ([Raúl Marín](https://github.com/Algunenano)).
* Fix test 01014_lazy_database_concurrent_recreate_reattach_and_show_tables [#27734](https://github.com/ClickHouse/ClickHouse/pull/27734) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Disable jemalloc under OSX [#27751](https://github.com/ClickHouse/ClickHouse/pull/27751) ([Raúl Marín](https://github.com/Algunenano)).
* Fix jemalloc under osx (zone_register() had been optimized out again) [#27753](https://github.com/ClickHouse/ClickHouse/pull/27753) ([Azat Khuzhin](https://github.com/azat)).
* Fix intersect/except with limit [#27757](https://github.com/ClickHouse/ClickHouse/pull/27757) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add HTTP string parsing test [#27762](https://github.com/ClickHouse/ClickHouse/pull/27762) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix some tests [#27785](https://github.com/ClickHouse/ClickHouse/pull/27785) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Set function divide as suitable for short-circuit in case of Nullable(Decimal) [#27788](https://github.com/ClickHouse/ClickHouse/pull/27788) ([Kruglov Pavel](https://github.com/Avogar)).
* Remove unnecessary files [#27789](https://github.com/ClickHouse/ClickHouse/pull/27789) ([Kruglov Pavel](https://github.com/Avogar)).
* Revert "Mark tests for `DatabaseReplicated` as green" [#27791](https://github.com/ClickHouse/ClickHouse/pull/27791) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove hardening for watches in DDLWorker [#27792](https://github.com/ClickHouse/ClickHouse/pull/27792) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Stateless test: Cleanup leftovers [#27793](https://github.com/ClickHouse/ClickHouse/pull/27793) ([Raúl Marín](https://github.com/Algunenano)).
* Dictionaries key types refactoring [#27795](https://github.com/ClickHouse/ClickHouse/pull/27795) ([Maksim Kita](https://github.com/kitaisreal)).
* Update 01822_short_circuit.reference (after merging [#27680](https://github.com/ClickHouse/ClickHouse/issues/27680)) [#27802](https://github.com/ClickHouse/ClickHouse/pull/27802) ([Azat Khuzhin](https://github.com/azat)).
* Proper shutdown global context [#27804](https://github.com/ClickHouse/ClickHouse/pull/27804) ([Amos Bird](https://github.com/amosbird)).
* 01766_todatetime64_no_timezone_arg: Use a date without timezone changes [#27810](https://github.com/ClickHouse/ClickHouse/pull/27810) ([Raúl Marín](https://github.com/Algunenano)).
* Fix setting name "allow_experimental_database_materialized_postgresql" in the error message [#27824](https://github.com/ClickHouse/ClickHouse/pull/27824) ([Denny Crane](https://github.com/den-crane)).
* Fix bug in short-circuit found by fuzzer [#27826](https://github.com/ClickHouse/ClickHouse/pull/27826) ([Kruglov Pavel](https://github.com/Avogar)).
