---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.8.2.19-prestable FIXME as compared to v21.8.1.7409-prestable

#### Performance Improvement
* Backported in [#26524](https://github.com/ClickHouse/ClickHouse/issues/26524): Improve latency of short queries, that require reading from tables with large number of columns. [#26371](https://github.com/ClickHouse/ClickHouse/pull/26371) ([Anton Popov](https://github.com/CurtizJ)).

#### Bug Fix
* Backported in [#26283](https://github.com/ClickHouse/ClickHouse/issues/26283): Fix `optimize_skip_unused_shards_rewrite_in` for non-UInt64 types (may select incorrect shards eventually or throw `Cannot infer type of an empty tuple` or `Function tuple requires at least one argument`). [#25798](https://github.com/ClickHouse/ClickHouse/pull/25798) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#26587](https://github.com/ClickHouse/ClickHouse/issues/26587): Fixed `Not found column ...` and `Missing column ...` errors when selecting from `MaterializeMySQL`. Fixes [#23708](https://github.com/ClickHouse/ClickHouse/issues/23708), [#24830](https://github.com/ClickHouse/ClickHouse/issues/24830), [#25794](https://github.com/ClickHouse/ClickHouse/issues/25794). [#25822](https://github.com/ClickHouse/ClickHouse/pull/25822) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#26190](https://github.com/ClickHouse/ClickHouse/issues/26190): Fix sharding_key from column w/o function for remote() (before `select * from remote('127.1', system.one, dummy)` leads to `Unknown column: dummy, there are only columns .` error). [#25824](https://github.com/ClickHouse/ClickHouse/pull/25824) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#26284](https://github.com/ClickHouse/ClickHouse/issues/26284): Fix possible mismatched header when using normal projection with prewhere. This fixes [#26020](https://github.com/ClickHouse/ClickHouse/issues/26020). [#26038](https://github.com/ClickHouse/ClickHouse/pull/26038) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#26298](https://github.com/ClickHouse/ClickHouse/issues/26298): Fixed incorrect `sequence_id` in MySQL protocol packets that ClickHouse sends on exception during query execution. It might cause MySQL client to reset connection to ClickHouse server. Fixes [#21184](https://github.com/ClickHouse/ClickHouse/issues/21184). [#26051](https://github.com/ClickHouse/ClickHouse/pull/26051) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#26204](https://github.com/ClickHouse/ClickHouse/issues/26204): Fix potential crash if more than one `untuple` expression is used. [#26179](https://github.com/ClickHouse/ClickHouse/pull/26179) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#26228](https://github.com/ClickHouse/ClickHouse/issues/26228): Remove excessive newline in `thread_name` column in `system.stack_trace` table. This fixes [#24124](https://github.com/ClickHouse/ClickHouse/issues/24124). [#26210](https://github.com/ClickHouse/ClickHouse/pull/26210) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#26358](https://github.com/ClickHouse/ClickHouse/issues/26358): Fix logical error on join with totals, close [#26017](https://github.com/ClickHouse/ClickHouse/issues/26017). [#26250](https://github.com/ClickHouse/ClickHouse/pull/26250) ([Vladimir C](https://github.com/vdimir)).
* Backported in [#26788](https://github.com/ClickHouse/ClickHouse/issues/26788): Fix zstd decompression in case there are escape sequences at the end of internal buffer. Closes [#26013](https://github.com/ClickHouse/ClickHouse/issues/26013). [#26314](https://github.com/ClickHouse/ClickHouse/pull/26314) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#26360](https://github.com/ClickHouse/ClickHouse/issues/26360): Fixed rare bug in lost replica recovery that may cause replicas to diverge. [#26321](https://github.com/ClickHouse/ClickHouse/pull/26321) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#26452](https://github.com/ClickHouse/ClickHouse/issues/26452): Fix `optimize_distributed_group_by_sharding_key` for multiple columns (leads to incorrect result w/ `optimize_skip_unused_shards=1`/`allow_nondeterministic_optimize_skip_unused_shards=1` and multiple columns in sharding key expression). [#26353](https://github.com/ClickHouse/ClickHouse/pull/26353) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#26422](https://github.com/ClickHouse/ClickHouse/issues/26422): Fix possible crash when login as dropped user. This PR fixes [#26073](https://github.com/ClickHouse/ClickHouse/issues/26073). [#26363](https://github.com/ClickHouse/ClickHouse/pull/26363) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#26417](https://github.com/ClickHouse/ClickHouse/issues/26417): Fix infinite non joined block stream in `partial_merge_join` close [#26325](https://github.com/ClickHouse/ClickHouse/issues/26325). [#26374](https://github.com/ClickHouse/ClickHouse/pull/26374) ([Vladimir C](https://github.com/vdimir)).
* Backported in [#26448](https://github.com/ClickHouse/ClickHouse/issues/26448): Fix some fuzzed msan crash. Fixes [#22517](https://github.com/ClickHouse/ClickHouse/issues/22517). [#26428](https://github.com/ClickHouse/ClickHouse/pull/26428) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#26488](https://github.com/ClickHouse/ClickHouse/issues/26488): Fix broken name resolution after rewriting column aliases. This fixes [#26432](https://github.com/ClickHouse/ClickHouse/issues/26432). [#26475](https://github.com/ClickHouse/ClickHouse/pull/26475) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#26613](https://github.com/ClickHouse/ClickHouse/issues/26613): Fix issues with `CREATE DICTIONARY` query if dictionary name or database name was quoted. Closes [#26491](https://github.com/ClickHouse/ClickHouse/issues/26491). [#26508](https://github.com/ClickHouse/ClickHouse/pull/26508) ([Maksim Kita](https://github.com/kitaisreal)).
* Backported in [#26605](https://github.com/ClickHouse/ClickHouse/issues/26605): Fix crash in rabbitmq shutdown in case rabbitmq setup was not started. Closes [#26504](https://github.com/ClickHouse/ClickHouse/issues/26504). [#26529](https://github.com/ClickHouse/ClickHouse/pull/26529) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#26608](https://github.com/ClickHouse/ClickHouse/issues/26608): Update `chown` cmd check in clickhouse-server docker entrypoint. It fixes the bug that cluster pod restart failed (or timeout) on kubernetes. [#26545](https://github.com/ClickHouse/ClickHouse/pull/26545) ([Ky Li](https://github.com/Kylinrix)).
* Backported in [#26648](https://github.com/ClickHouse/ClickHouse/issues/26648): Fix incorrect function names of groupBitmapAnd/Or/Xor. This fixes. [#26557](https://github.com/ClickHouse/ClickHouse/pull/26557) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#26644](https://github.com/ClickHouse/ClickHouse/issues/26644): Fix history file conversion if file is empty. [#26589](https://github.com/ClickHouse/ClickHouse/pull/26589) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#26705](https://github.com/ClickHouse/ClickHouse/issues/26705): Fix potential nullptr dereference in window functions. This fixes [#25276](https://github.com/ClickHouse/ClickHouse/issues/25276). [#26668](https://github.com/ClickHouse/ClickHouse/pull/26668) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Backported in [#26771](https://github.com/ClickHouse/ClickHouse/issues/26771): Sometimes SET ROLE could work incorrectly, this PR fixes that. [#26707](https://github.com/ClickHouse/ClickHouse/pull/26707) ([Vitaly Baranov](https://github.com/vitlibar)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Remove misleading stderr output [#26155](https://github.com/ClickHouse/ClickHouse/pull/26155) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Less logging in AsynchronousMetrics [#26391](https://github.com/ClickHouse/ClickHouse/pull/26391) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove MySQLWireContext [#26429](https://github.com/ClickHouse/ClickHouse/pull/26429) ([Vitaly Baranov](https://github.com/vitlibar)).
* Update link to dpkg-deb in dockerfiles [#26497](https://github.com/ClickHouse/ClickHouse/pull/26497) ([Vladimir C](https://github.com/vdimir)).
