---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.6.1.6891-prestable FIXME as compared to v21.5.1.6601-prestable

#### New Feature
* Add projection support for MergeTree* tables. [#20202](https://github.com/ClickHouse/ClickHouse/pull/20202) ([Amos Bird](https://github.com/amosbird)).
* Add back `indexHint` function. This is for [#21238](https://github.com/ClickHouse/ClickHouse/issues/21238) . This reverts https://github.com/ClickHouse/ClickHouse/pull/9542 . This fixes [#9540](https://github.com/ClickHouse/ClickHouse/issues/9540) . [#21304](https://github.com/ClickHouse/ClickHouse/pull/21304) ([Amos Bird](https://github.com/amosbird)).
* 1. Add aggregate function sumCount. This function returns a tuple of two fields: sum and count. [#21337](https://github.com/ClickHouse/ClickHouse/pull/21337) ([hexiaoting](https://github.com/hexiaoting)).
* Added less secure IMDS credentials provider for S3 which works under docker correctly. [#21852](https://github.com/ClickHouse/ClickHouse/pull/21852) ([Vladimir Chebotarev](https://github.com/excitoon)).
* - New aggregate function `deltaSumTimestamp` for summing the difference between consecutive rows while maintaining ordering during merge by storing timestamps. [#21888](https://github.com/ClickHouse/ClickHouse/pull/21888) ([Russ Frank](https://github.com/rf)).
* - LDAP: implemented user DN detection functionality to use when mapping Active Directory groups to ClickHouse roles. [#22228](https://github.com/ClickHouse/ClickHouse/pull/22228) ([Denis Glazachev](https://github.com/traceon)).
* Introduce a new function: arrayProduct which accept an array as the parameter, and return the product of all the elements in array. Close issue: [#21613](https://github.com/ClickHouse/ClickHouse/issues/21613). [#22242](https://github.com/ClickHouse/ClickHouse/pull/22242) ([hexiaoting](https://github.com/hexiaoting)).
* Add setting `indexes` (boolean, disabled by default) to `EXPLAIN PIPELINE` query. When enabled, shows used indexes, number of filtered parts and granules for every index applied. Supported for `MergeTree*` tables. [#22352](https://github.com/ClickHouse/ClickHouse/pull/22352) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add setting `json` (boolean, 0 by default) for `EXPLAIN PLAN` query. When enabled, query output will be a single `JSON` row. It is recommended to use `TSVRaw` format to avoid unnecessary escaping. [#23082](https://github.com/ClickHouse/ClickHouse/pull/23082) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Added `SYSTEM QUERY RELOAD MODEL`, `SYSTEM QUERY RELOAD MODELS`. Closes [#18722](https://github.com/ClickHouse/ClickHouse/issues/18722). [#23182](https://github.com/ClickHouse/ClickHouse/pull/23182) ([Maksim Kita](https://github.com/kitaisreal)).
* Made progress bar for LocalServer and united it for Client and Local. [#23196](https://github.com/ClickHouse/ClickHouse/pull/23196) ([Egor Savin](https://github.com/Amesaru)).
* Support DDL dictionaries for DatabaseMemory. Closes [#22354](https://github.com/ClickHouse/ClickHouse/issues/22354). Added support for `DETACH DICTIONARY PERMANENTLY`. Added support for `EXCHANGE DICTIONARIES` for Atomic database engine. Added support for moving dictionaries between databases using `RENAME DICTIONARY`. [#23436](https://github.com/ClickHouse/ClickHouse/pull/23436) ([Maksim Kita](https://github.com/kitaisreal)).
* Allow globs `{...}`, which act like shards, and failover options with separator `|` for URL table function. Closes [#17181](https://github.com/ClickHouse/ClickHouse/issues/17181). [#23446](https://github.com/ClickHouse/ClickHouse/pull/23446) ([Kseniia Sumarokova](https://github.com/kssenii)).
* If `insert_null_as_default` = 1, insert default values instead of NULL in `INSERT ... SELECT` and `INSERT ... SELECT ... UNION ALL ...` queries. Closes [#22832](https://github.com/ClickHouse/ClickHouse/issues/22832). [#23524](https://github.com/ClickHouse/ClickHouse/pull/23524) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Implement table comments. closes [#23225](https://github.com/ClickHouse/ClickHouse/issues/23225). [#23548](https://github.com/ClickHouse/ClickHouse/pull/23548) ([flynn](https://github.com/ucasfl)).
* Introduce a new function: arrayProduct which accept an array as the parameter, and return the product of all the elements in array. Closes [#21613](https://github.com/ClickHouse/ClickHouse/issues/21613). [#23782](https://github.com/ClickHouse/ClickHouse/pull/23782) ([Maksim Kita](https://github.com/kitaisreal)).
* Add postgres-like cast operator (`::`). E.g.: `[1, 2]::Array(UInt8)`, `0.1::Decimal(4, 4)`, `number::UInt16`. [#23871](https://github.com/ClickHouse/ClickHouse/pull/23871) ([Anton Popov](https://github.com/CurtizJ)).
* ... [#23910](https://github.com/ClickHouse/ClickHouse/pull/23910) ([Xiang Zhou](https://github.com/javainthinking)).
* Add function splitByRegexp. [#24077](https://github.com/ClickHouse/ClickHouse/pull/24077) ([abel-cheng](https://github.com/abel-cheng)).
* Add `thread_name` column in `system.stack_trace`. This closes [#23256](https://github.com/ClickHouse/ClickHouse/issues/23256). [#24124](https://github.com/ClickHouse/ClickHouse/pull/24124) ([abel-cheng](https://github.com/abel-cheng)).

#### Performance Improvement
* Enable `compile_expressions` setting by default. When this setting enabled, compositions of simple functions and operators will be compiled to native code with LLVM at runtime. [#8482](https://github.com/ClickHouse/ClickHouse/pull/8482) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ORC input format reading by stripe instead of reading entire table into memory by once which is cost memory when file size is huge. [#23102](https://github.com/ClickHouse/ClickHouse/pull/23102) ([Chao Ma](https://github.com/godliness)).
* Update `re2` library. Performance of regular expressions matching is improved. Also this PR adds compatibility with gcc-11. [#24196](https://github.com/ClickHouse/ClickHouse/pull/24196) ([Raúl Marín](https://github.com/Algunenano)).

#### Improvement
* Support Array data type for inserting and selecting data in Arrow, Parquet and ORC formats. [#21770](https://github.com/ClickHouse/ClickHouse/pull/21770) ([taylor12805](https://github.com/taylor12805)).
* Add settings `external_storage_max_read_rows` and `external_storage_max_read_rows` for MySQL table engine, dictionary source and MaterializeMySQL minor data fetches. [#22697](https://github.com/ClickHouse/ClickHouse/pull/22697) ([TCeason](https://github.com/TCeason)).
* Retries on HTTP connection drops in S3. [#22988](https://github.com/ClickHouse/ClickHouse/pull/22988) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix the case when a progress bar in interactive mode in clickhouse-client that appear in the middle of the data may rewrite some parts of visible data in terminal. This closes [#19283](https://github.com/ClickHouse/ClickHouse/issues/19283). [#23050](https://github.com/ClickHouse/ClickHouse/pull/23050) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added possibility to restore MergeTree parts to 'detached' directory for DiskS3. [#23112](https://github.com/ClickHouse/ClickHouse/pull/23112) ([Pavel Kovalenko](https://github.com/Jokser)).
* Skip unavaiable replicas when writing to distributed tables. [#23152](https://github.com/ClickHouse/ClickHouse/pull/23152) ([Amos Bird](https://github.com/amosbird)).
* Support LowCardinality nullability with `join_use_nulls`, close [#15101](https://github.com/ClickHouse/ClickHouse/issues/15101). [#23237](https://github.com/ClickHouse/ClickHouse/pull/23237) ([Vladimir C](https://github.com/vdimir)).
* Disable settings `use_hedged_requests` and `async_socket_for_remote` because there is an evidence that it may cause issues. [#23261](https://github.com/ClickHouse/ClickHouse/pull/23261) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed `quantile(s)TDigest`. Added special handling of singleton centroids according to tdunning/t-digest 3.2+. Also a bug with over-compression of centroids in implementation of earlier version of the algorithm was fixed. [#23314](https://github.com/ClickHouse/ClickHouse/pull/23314) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Allow user to specify empty string instead of database name for `MySQL` storage. Default database will be used for queries. In previous versions it was working for SELECT queries and not support for INSERT was also added. This closes [#19281](https://github.com/ClickHouse/ClickHouse/issues/19281). This can be useful working with `Sphinx` or other MySQL-compatible foreign databases. [#23319](https://github.com/ClickHouse/ClickHouse/pull/23319) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disable min_bytes_to_use_mmap_io by default. [#23322](https://github.com/ClickHouse/ClickHouse/pull/23322) ([Azat Khuzhin](https://github.com/azat)).
* If user applied a misconfiguration by mistakenly setting `max_distributed_connections` to value zero, every query to a `Distributed` table will throw exception with a message containing "logical error". But it's really an expected behaviour, not a logical error, so the exception message was slightly incorrect. It also triggered checks in our CI enviroment that ensures that no logical errors ever happen. Instead we will treat `max_distributed_connections` misconfigured to zero as the minimum possible value (one). [#23348](https://github.com/ClickHouse/ClickHouse/pull/23348) ([Azat Khuzhin](https://github.com/azat)).
* Keep default timezone on DateTime operations if it was not provided explicitly. For example, if you add one second to a value of `DateTime` type without timezone it will remain `DateTime` without timezone. In previous versions the value of default timezone was placed to the returned data type explicitly so it becomes DateTime('something'). This closes [#4854](https://github.com/ClickHouse/ClickHouse/issues/4854). [#23392](https://github.com/ClickHouse/ClickHouse/pull/23392) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Previously, MySQL 5.7.9 was not supported due to SQL incompatibility. Now leave MySQL parameter verification to the MaterializeMySQL. [#23413](https://github.com/ClickHouse/ClickHouse/pull/23413) ([TCeason](https://github.com/TCeason)).
* Possibility to change S3 disk settings in runtime via new `SYSTEM RESTART DISK` SQL command. [#23429](https://github.com/ClickHouse/ClickHouse/pull/23429) ([Pavel Kovalenko](https://github.com/Jokser)).
* Respect lock_acquire_timeout_for_background_operations for OPTIMIZE. [#23623](https://github.com/ClickHouse/ClickHouse/pull/23623) ([Azat Khuzhin](https://github.com/azat)).
* Make big integers production ready. Add support for `UInt128` data type. Fix known issues with the `Decimal256` data type. Support big integers in dictionaries. Support `gcd`/`lcm` functions for big integers. Support big integers in array search and conditional functions. Support `LowCardinality(UUID)`. Support big integers in `generateRandom` table function and `clickhouse-obfuscator`. Fix error with returning `UUID` from scalar subqueries. This fixes [#7834](https://github.com/ClickHouse/ClickHouse/issues/7834). This fixes [#23936](https://github.com/ClickHouse/ClickHouse/issues/23936). This fixes [#4176](https://github.com/ClickHouse/ClickHouse/issues/4176). This fixes [#24018](https://github.com/ClickHouse/ClickHouse/issues/24018). This fixes [#17828](https://github.com/ClickHouse/ClickHouse/issues/17828). Backward incompatible change: values of `UUID` type cannot be compared with integer. For example, instead of writing `uuid != 0` type `uuid != '00000000-0000-0000-0000-000000000000'`. [#23631](https://github.com/ClickHouse/ClickHouse/pull/23631) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `_partition_value` virtual column to MergeTree table family. It can be used to prune partition in a deterministic way. It's needed to implement partition matcher for mutations. [#23673](https://github.com/ClickHouse/ClickHouse/pull/23673) ([Amos Bird](https://github.com/amosbird)).
* Enable `async_socket_for_remote` by default. [#23683](https://github.com/ClickHouse/ClickHouse/pull/23683) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* When there is some `ReplicatedMergeTree` tables whose zookeeper is expired, it will throw the error below when we select the meta data of some table from `system.tables` with `select_sequential_consistency` is enabled: `Session expired (Session expired): While executing Tables`. [#23793](https://github.com/ClickHouse/ClickHouse/pull/23793) ([Fuwang Hu](https://github.com/fuwhu)).
* Added `region` parameter for S3 storage and disk. [#23846](https://github.com/ClickHouse/ClickHouse/pull/23846) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Allow configuring different log levels for different logging channels. Closes [#19569](https://github.com/ClickHouse/ClickHouse/issues/19569). [#23857](https://github.com/ClickHouse/ClickHouse/pull/23857) ([filimonov](https://github.com/filimonov)).
* Add `broken_data_files`/`broken_data_compressed_bytes` into `system.distribution_queue`. Add metric for number of files for asynchronous insertion into Distributed tables that has been marked as broken (`BrokenDistributedFilesToInsert`). [#23885](https://github.com/ClickHouse/ClickHouse/pull/23885) ([Azat Khuzhin](https://github.com/azat)).
* Allow to add specific queue settings via table settng `rabbitmq_queue_settings_list`. (Closes [#23737](https://github.com/ClickHouse/ClickHouse/issues/23737) and [#23918](https://github.com/ClickHouse/ClickHouse/issues/23918)). Allow user to control all RabbitMQ setup: if table setting `rabbitmq_queue_consume` is set to `1` - RabbitMQ table engine will only connect to specified queue and will not perform any RabbitMQ consumer-side setup like declaring exchange, queues, bindings. (Closes [#21757](https://github.com/ClickHouse/ClickHouse/issues/21757)). Add proper cleanup when RabbitMQ table is dropped - delete queues, which the table has declared and all bound exchanges - if they were created by the table. [#23887](https://github.com/ClickHouse/ClickHouse/pull/23887) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Measure found rate (the percentage for which the value was found) for dictionaries (see `found_rate` in `system.dictionaries`). [#23916](https://github.com/ClickHouse/ClickHouse/pull/23916) ([Azat Khuzhin](https://github.com/azat)).
* Add hints for Enum names. Closes [#17112](https://github.com/ClickHouse/ClickHouse/issues/17112). [#23919](https://github.com/ClickHouse/ClickHouse/pull/23919) ([flynn](https://github.com/ucasfl)).
* Add support for HTTP compression (determined by `Content-Encoding` HTTP header) in `http` dictionary source. This fixes [#8912](https://github.com/ClickHouse/ClickHouse/issues/8912). [#23946](https://github.com/ClickHouse/ClickHouse/pull/23946) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Preallocate support for hashed/sparse_hashed dictionaries. [#23979](https://github.com/ClickHouse/ClickHouse/pull/23979) ([Azat Khuzhin](https://github.com/azat)).
* Support specifying table schema for postgresql dictionary source. Closes [#23958](https://github.com/ClickHouse/ClickHouse/issues/23958). [#23980](https://github.com/ClickHouse/ClickHouse/pull/23980) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Log information about OS name, kernel version and CPU architecture on server startup. [#23988](https://github.com/ClickHouse/ClickHouse/pull/23988) ([Azat Khuzhin](https://github.com/azat)).
* enable DateTime64 to be a version column in ReplacingMergeTree. [#23992](https://github.com/ClickHouse/ClickHouse/pull/23992) ([kevin wan](https://github.com/MaxWk)).
* Add support for `ORDER BY WITH FILL` with `DateTime64`. [#24016](https://github.com/ClickHouse/ClickHouse/pull/24016) ([kevin wan](https://github.com/MaxWk)).
* Now `prefer_column_name_to_alias = 1` will also favor column names for `group by`, `having` and `order by`. This fixes [#23882](https://github.com/ClickHouse/ClickHouse/issues/23882). [#24022](https://github.com/ClickHouse/ClickHouse/pull/24022) ([Amos Bird](https://github.com/amosbird)).
* Do not acquire lock for total_bytes/total_rows for Buffer engine. [#24066](https://github.com/ClickHouse/ClickHouse/pull/24066) ([Azat Khuzhin](https://github.com/azat)).
* Flush Buffer tables before shutting down tables (within one database), to avoid discarding blocks due to underlying table had been already detached (and `Destination table default.a_data_01870 doesn't exist. Block of data is discarded` error in the log). [#24067](https://github.com/ClickHouse/ClickHouse/pull/24067) ([Azat Khuzhin](https://github.com/azat)).
* Preserve dictionaries until storage shutdown (this will avoid possible `external dictionary 'DICT' not found` errors at server shutdown during final Buffer flush). [#24068](https://github.com/ClickHouse/ClickHouse/pull/24068) ([Azat Khuzhin](https://github.com/azat)).
* Update zstd to v1.5.0. [#24135](https://github.com/ClickHouse/ClickHouse/pull/24135) ([Raúl Marín](https://github.com/Algunenano)).
* Fix crash when memory allocation fails in simdjson. https://github.com/simdjson/simdjson/pull/1567 . Mark as improvement because it's a rare bug. [#24147](https://github.com/ClickHouse/ClickHouse/pull/24147) ([Amos Bird](https://github.com/amosbird)).

#### Bug Fix
* This PR fixes a crash on shutdown which happened because of currentConnections() could return zero while some connections were still alive. [#23154](https://github.com/ClickHouse/ClickHouse/pull/23154) ([Vitaly Baranov](https://github.com/vitlibar)).
* QueryAliasVisitor to prefer alias for ASTWithAlias if subquery was optimized to constant. Fixes [#22924](https://github.com/ClickHouse/ClickHouse/issues/22924). Fixes [#10401](https://github.com/ClickHouse/ClickHouse/issues/10401). [#23191](https://github.com/ClickHouse/ClickHouse/pull/23191) ([Maksim Kita](https://github.com/kitaisreal)).
* Fixed `Not found column` error when selecting from `MaterializeMySQL` with condition on key column. Fixes [#22432](https://github.com/ClickHouse/ClickHouse/issues/22432). [#23200](https://github.com/ClickHouse/ClickHouse/pull/23200) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed the behavior when disabling `input_format_with_names_use_header ` setting discards all the input with CSVWithNames format. This fixes [#22406](https://github.com/ClickHouse/ClickHouse/issues/22406). [#23202](https://github.com/ClickHouse/ClickHouse/pull/23202) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add type conversion for optimize_skip_unused_shards_rewrite_in (fixes `use-of-uninitialized-value` with `optimize_skip_unused_shards_rewrite_in`). [#23219](https://github.com/ClickHouse/ClickHouse/pull/23219) ([Azat Khuzhin](https://github.com/azat)).
* Fixed simple key dictionary from DDL creation if primary key is not first attribute. Fixes [#23236](https://github.com/ClickHouse/ClickHouse/issues/23236). [#23262](https://github.com/ClickHouse/ClickHouse/pull/23262) ([Maksim Kita](https://github.com/kitaisreal)).
* Fixed very rare (distributed) race condition between creation and removal of ReplicatedMergeTree tables. It might cause exceptions like `node doesn't exist` on attempt to create replicated table. Fixes [#21419](https://github.com/ClickHouse/ClickHouse/issues/21419). [#23294](https://github.com/ClickHouse/ClickHouse/pull/23294) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed very rare race condition on background cleanup of old blocks. It might cause a block not to be deduplicated if it's too close to the end of deduplication window. [#23301](https://github.com/ClickHouse/ClickHouse/pull/23301) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix possible crash in case if `unknown packet` was received form remote query (with `async_socket_for_remote` enabled). Maybe fixes [#21167](https://github.com/ClickHouse/ClickHouse/issues/21167). [#23309](https://github.com/ClickHouse/ClickHouse/pull/23309) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Don't relax NOT conditions during partition pruning. This fixes [#23305](https://github.com/ClickHouse/ClickHouse/issues/23305) and [#21539](https://github.com/ClickHouse/ClickHouse/issues/21539). [#23310](https://github.com/ClickHouse/ClickHouse/pull/23310) ([Amos Bird](https://github.com/amosbird)).
* * Fix bug in dict join with join_algorithm = 'auto'. Close [#23002](https://github.com/ClickHouse/ClickHouse/issues/23002). [#23312](https://github.com/ClickHouse/ClickHouse/pull/23312) ([Vladimir C](https://github.com/vdimir)).
* Fix possible `Block structure mismatch` error for queries with `UNION` which could possibly happen after filter-push-down optimization. Fixes [#23029](https://github.com/ClickHouse/ClickHouse/issues/23029). [#23359](https://github.com/ClickHouse/ClickHouse/pull/23359) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix incompatible constant expression generation during partition pruning based on virtual columns. This fixes https://github.com/ClickHouse/ClickHouse/pull/21401#discussion_r611888913. [#23366](https://github.com/ClickHouse/ClickHouse/pull/23366) ([Amos Bird](https://github.com/amosbird)).
* `ORDER BY` with `COLLATE` was not working correctly if the column is in primary key (or is a monotonic function of it) and the setting `optimize_read_in_order` is not turned off. This closes [#22379](https://github.com/ClickHouse/ClickHouse/issues/22379). Workaround for older versions: turn the setting `optimize_read_in_order` off. [#23375](https://github.com/ClickHouse/ClickHouse/pull/23375) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove support for `argMin` and `argMax` for single `Tuple` argument. The code was not memory-safe. The feature was added by mistake and it is confusing for people. These functions can be reintroduced under different names later. This fixes [#22384](https://github.com/ClickHouse/ClickHouse/issues/22384) and reverts [#17359](https://github.com/ClickHouse/ClickHouse/issues/17359). [#23393](https://github.com/ClickHouse/ClickHouse/pull/23393) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to move more conditions to `PREWHERE` as it was before version 21.1. Insufficient number of moved condtions could lead to worse performance. [#23397](https://github.com/ClickHouse/ClickHouse/pull/23397) ([Anton Popov](https://github.com/CurtizJ)).
* Kafka storage may support parquet format messages. [#23412](https://github.com/ClickHouse/ClickHouse/pull/23412) ([Chao Ma](https://github.com/godliness)).
* Kafka storage may support `arrow` and `arrowstream` format messages. [#23415](https://github.com/ClickHouse/ClickHouse/pull/23415) ([Chao Ma](https://github.com/godliness)).
* Fixed `Cannot unlink file` error on unsuccessful creation of ReplicatedMergeTree table with multidisk configuration. This closes [#21755](https://github.com/ClickHouse/ClickHouse/issues/21755). [#23433](https://github.com/ClickHouse/ClickHouse/pull/23433) ([Alexander Tokmakov](https://github.com/tavplubix)).
* - Bug fix for `deltaSum` aggregate function in counter reset case ... [#23437](https://github.com/ClickHouse/ClickHouse/pull/23437) ([Russ Frank](https://github.com/rf)).
* Fix bug that does not allow cast from empty array literal, to array with dimensions greater than 1. Closes [#14476](https://github.com/ClickHouse/ClickHouse/issues/14476). [#23456](https://github.com/ClickHouse/ClickHouse/pull/23456) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix corner cases in vertical merges with `ReplacingMergeTree`. In rare cases they could lead to fails of merges with exceptions like `Incomplete granules are not allowed while blocks are granules size`. [#23459](https://github.com/ClickHouse/ClickHouse/pull/23459) ([Anton Popov](https://github.com/CurtizJ)).
* When modify column's default value without datatype, and this column is used as ReplacingMergeTree's parameter like column `b` in the below example, then the server will core dump: ``` CREATE TABLE alter_test (a Int32, b DateTime) ENGINE = ReplacingMergeTree(b) ORDER BY a; ALTER TABLE alter_test MODIFY COLUMN `b` DEFAULT now(); ``` the sever throw error: ``` 2021.04.22 09:48:00.685317 [ 2607 ] {} <Trace> BaseDaemon: Received signal 11 2021.04.22 09:48:00.686110 [ 2705 ] {} <Fatal> BaseDaemon: ######################################## 2021.04.22 09:48:00.686336 [ 2705 ] {} <Fatal> BaseDaemon: (version 21.6.1.1, build id: 6459E84DFCF8E778546C5AD2FFE91B3AD71E1B1B) (from thread 2619) (no query) Received signal Segmentation fault (11) 2021.04.22 09:48:00.686572 [ 2705 ] {} <Fatal> BaseDaemon: Address: NULL pointer. Access: read. Address not mapped to object. 2021.04.22 09:48:00.686686 [ 2705 ] {} <Fatal> BaseDaemon: Stack trace: 0x1c2585d7 0x1c254f66 0x1bb7e403 0x1bb58923 0x1bb56a85 0x1c6840ef 0x1c691148 0x2061a05c 0x2061a8e4 0x20775a03 0x207722bd 0x20771048 0x7f6e5c25be25 0x7f6e5bd81bad 2021.04.22 09:48:02.283045 [ 2705 ] {} <Fatal> BaseDaemon: 4. /mnt/disk4/hewenting/ClickHouse/src/src/Storages/MergeTree/MergeTreeData.cpp:1449: DB::(anonymous namespace)::checkVersionColumnTypesConversion(DB::IDataType const*, DB::IDataType const*, std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> >) @ 0x1c2585d7 in /mnt/disk4/hewenting/ClickHouse/build-dbgsrc-clang-dev-nested/programs/clickhouse-server 2021.04.22 09:48:03.714451 [ 2705 ] {} <Fatal> BaseDaemon: 5. /mnt/disk4/hewenting/ClickHouse/src/src/Storages/MergeTree/MergeTreeData.cpp:1582: DB::MergeTreeData::checkAlterIsPossible(DB::AlterCommands const&, std::__1::shared_ptr<DB::Context>) const @ 0x1c254f66 in /mnt/disk4/hewenting/ClickHouse/build-dbgsrc-clang-dev-nested/programs/clickhouse-server 2021.04.22 09:48:04.692949 [ 2705 ] {} <Fatal> BaseDaemon: 6. /mnt/disk4/hewenting/ClickHouse/src/src/Interpreters/InterpreterAlterQuery.cpp:144: DB::InterpreterAlterQuery::execute() @ 0x1bb7e403 in /mnt/disk4/hewenting/ClickHouse/build-dbgsrc-clang-dev-nested/programs/clickhouse-server ```. [#23483](https://github.com/ClickHouse/ClickHouse/pull/23483) ([hexiaoting](https://github.com/hexiaoting)).
* Fix `columns` function when multiple joins in select query. Closes [#22736](https://github.com/ClickHouse/ClickHouse/issues/22736). [#23501](https://github.com/ClickHouse/ClickHouse/pull/23501) ([Maksim Kita](https://github.com/kitaisreal)).
* * Fix bug with `Join` and `WITH TOTALS`, close [#17718](https://github.com/ClickHouse/ClickHouse/issues/17718). [#23549](https://github.com/ClickHouse/ClickHouse/pull/23549) ([Vladimir C](https://github.com/vdimir)).
* Fix restart / stop command hanging. Closes [#20214](https://github.com/ClickHouse/ClickHouse/issues/20214). [#23552](https://github.com/ClickHouse/ClickHouse/pull/23552) ([filimonov](https://github.com/filimonov)).
* Fix misinterpretation of some `LIKE` expressions with escape sequences. [#23610](https://github.com/ClickHouse/ClickHouse/pull/23610) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed server fault when inserting data through HTTP caused an exception. This fixes [#23512](https://github.com/ClickHouse/ClickHouse/issues/23512). [#23643](https://github.com/ClickHouse/ClickHouse/pull/23643) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Added an exception in case of completely the same values in both samples in aggregate function `mannWhitneyUTest`. This fixes [#23646](https://github.com/ClickHouse/ClickHouse/issues/23646). [#23654](https://github.com/ClickHouse/ClickHouse/pull/23654) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fixed a bug in recovery of staled `ReplicatedMergeTree` replica. Some metadata updates could be ignored by staled replica if `ALTER` query was executed during downtime of the replica. [#23742](https://github.com/ClickHouse/ClickHouse/pull/23742) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Avoid possible "Cannot schedule a task" error (in case some exception had been occurred) on INSERT into Distributed. [#23744](https://github.com/ClickHouse/ClickHouse/pull/23744) ([Azat Khuzhin](https://github.com/azat)).
* Fix `heap_use_after_free` when reading from hdfs if `Values` format is used. [#23761](https://github.com/ClickHouse/ClickHouse/pull/23761) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix crash when `PREWHERE` and row policy filter are both in effect with empty result. [#23763](https://github.com/ClickHouse/ClickHouse/pull/23763) ([Amos Bird](https://github.com/amosbird)).
* Fixed remote JDBC bridge timeout connection issue. Closes [#9609](https://github.com/ClickHouse/ClickHouse/issues/9609). [#23771](https://github.com/ClickHouse/ClickHouse/pull/23771) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix `CLEAR COLUMN` does not work when it is referenced by materialized view. Close [#23764](https://github.com/ClickHouse/ClickHouse/issues/23764). [#23781](https://github.com/ClickHouse/ClickHouse/pull/23781) ([flynn](https://github.com/ucasfl)).
* Fix error `Can't initialize pipeline with empty pipe` for queries with `GLOBAL IN/JOIN` and `use_hedged_requests`. Fixes [#23431](https://github.com/ClickHouse/ClickHouse/issues/23431). [#23805](https://github.com/ClickHouse/ClickHouse/pull/23805) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Better handling of URI's in `PocoHTTPClient`. Fixed bug with URLs containing `+` symbol, data with such keys could not be read previously. [#23822](https://github.com/ClickHouse/ClickHouse/pull/23822) ([Vladimir Chebotarev](https://github.com/excitoon)).
* HashedDictionary complex key update field initial load fix. Closes [#23800](https://github.com/ClickHouse/ClickHouse/issues/23800). [#23824](https://github.com/ClickHouse/ClickHouse/pull/23824) ([Maksim Kita](https://github.com/kitaisreal)).
* Better handling of HTTP errors in `PocoHTTPClient`. Response bodies of HTTP errors were being ignored earlier. [#23844](https://github.com/ClickHouse/ClickHouse/pull/23844) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix `distributed_group_by_no_merge=2` with `GROUP BY` and aggregate function wrapped into regular function (had been broken in [#23546](https://github.com/ClickHouse/ClickHouse/issues/23546)). Throw exception in case of someone trying to use `distributed_group_by_no_merge=2` with window functions. Disable `optimize_distributed_group_by_sharding_key` for queries with window functions. [#23906](https://github.com/ClickHouse/ClickHouse/pull/23906) ([Azat Khuzhin](https://github.com/azat)).
* Fix implementation of connection pool of PostgreSQL engine. Closes [#23897](https://github.com/ClickHouse/ClickHouse/issues/23897). [#23909](https://github.com/ClickHouse/ClickHouse/pull/23909) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix keys metrics accounting for CACHE() dictionary with duplicates in the source (leads to `DictCacheKeysRequestedMiss` overflows). [#23929](https://github.com/ClickHouse/ClickHouse/pull/23929) ([Azat Khuzhin](https://github.com/azat)).
* Fix SIGSEGV for external GROUP BY and overflow row (i.e. queries like `SELECT FROM GROUP BY WITH TOTALS SETTINGS max_bytes_before_external_group_by>0, max_rows_to_group_by>0, group_by_overflow_mode='any', totals_mode='before_having'`). [#23962](https://github.com/ClickHouse/ClickHouse/pull/23962) ([Azat Khuzhin](https://github.com/azat)).
* Some `ALTER PARTITION` queries might cause `Part A intersects previous part B` and `Unexpected merged part C intersecting drop range D` errors in replication queue. It's fixed. Fixes [#23296](https://github.com/ClickHouse/ClickHouse/issues/23296). [#23997](https://github.com/ClickHouse/ClickHouse/pull/23997) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix crash in MergeJoin, close [#24010](https://github.com/ClickHouse/ClickHouse/issues/24010). [#24013](https://github.com/ClickHouse/ClickHouse/pull/24013) ([Vladimir C](https://github.com/vdimir)).
* now64() supports optional timezone argument ... [#24091](https://github.com/ClickHouse/ClickHouse/pull/24091) ([Vasily Nemkov](https://github.com/Enmk)).
* Fixed using const `DateTime` value vs `DateTime64` column in WHERE. ... [#24100](https://github.com/ClickHouse/ClickHouse/pull/24100) ([Vasily Nemkov](https://github.com/Enmk)).
* Bug: explain pipeline with` select xxx final `shows wrong pipeline: ``` dell123 :) explain pipeline select z from prewhere_move_select_final final;. [#24116](https://github.com/ClickHouse/ClickHouse/pull/24116) ([hexiaoting](https://github.com/hexiaoting)).
* Fix a rare bug that could lead to a partially initialized table that can serve write requests (insert/alter/so on). Now such tables will be in readonly mode. [#24122](https://github.com/ClickHouse/ClickHouse/pull/24122) ([alesapin](https://github.com/alesapin)).
* Fix race condition which could happen in RBAC under a heavy load. This PR fixes [#24090](https://github.com/ClickHouse/ClickHouse/issues/24090), [#24134](https://github.com/ClickHouse/ClickHouse/issues/24134),. [#24176](https://github.com/ClickHouse/ClickHouse/pull/24176) ([Vitaly Baranov](https://github.com/vitlibar)).
* Update nested column with const condition will make server crash. ``` CREATE TABLE test_wide_nested ( `id` Int, `info.id` Array(Int), `info.name` Array(String), `info.age` Array(Int) ) ENGINE = MergeTree ORDER BY tuple() SETTINGS min_bytes_for_wide_part = 0; set mutations_sync = 1;. [#24183](https://github.com/ClickHouse/ClickHouse/pull/24183) ([hexiaoting](https://github.com/hexiaoting)).
* Fix abnormal server termination due to hdfs becoming not accessible during query execution. Closes [#24117](https://github.com/ClickHouse/ClickHouse/issues/24117). [#24191](https://github.com/ClickHouse/ClickHouse/pull/24191) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix wrong typo at StorageMemory, this bug was introduced at [#15127](https://github.com/ClickHouse/ClickHouse/issues/15127), now fixed, Closes [#24192](https://github.com/ClickHouse/ClickHouse/issues/24192). [#24193](https://github.com/ClickHouse/ClickHouse/pull/24193) ([张中南](https://github.com/plugine)).

#### Build/Testing/Packaging Improvement
* Adding Map type tests in TestFlows. [#21087](https://github.com/ClickHouse/ClickHouse/pull/21087) ([vzakaznikov](https://github.com/vzakaznikov)).
* Testflows tests for DateTime64 Extended Range. [#22729](https://github.com/ClickHouse/ClickHouse/pull/22729) ([Andrey Zvonov](https://github.com/zvonand)).
* CMake will be failed with settings as bellow ` -DENABLE_CASSANDRA=OFF -DENABLE_AMQPCPP=ON ` ... [#22984](https://github.com/ClickHouse/ClickHouse/pull/22984) ([Ben](https://github.com/benbiti)).
* Add simple tool for benchmarking [Zoo]Keeper. [#23038](https://github.com/ClickHouse/ClickHouse/pull/23038) ([alesapin](https://github.com/alesapin)).
* Remove a source of nondeterminism from build. Now builds at different point of time will produce byte-identical binaries. Partially addressed [#22113](https://github.com/ClickHouse/ClickHouse/issues/22113). [#23559](https://github.com/ClickHouse/ClickHouse/pull/23559) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid possible build dependency on locale and filesystem order. This allows reproducible builds. [#23600](https://github.com/ClickHouse/ClickHouse/pull/23600) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Always enable asynchronous-unwind-tables explicitly. It may fix query profiler on AArch64. [#23602](https://github.com/ClickHouse/ClickHouse/pull/23602) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix Memory Sanitizer report in GRPC library. This closes [#19234](https://github.com/ClickHouse/ClickHouse/issues/19234). [#23615](https://github.com/ClickHouse/ClickHouse/pull/23615) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Window functions tests in TestFlows. [#23704](https://github.com/ClickHouse/ClickHouse/pull/23704) ([vzakaznikov](https://github.com/vzakaznikov)).
* Adds support for building on Solaris-derived operating systems. [#23746](https://github.com/ClickHouse/ClickHouse/pull/23746) ([bnaecker](https://github.com/bnaecker)).
* Update librdkafka 1.6.0-RC3 to 1.6.1. [#23874](https://github.com/ClickHouse/ClickHouse/pull/23874) ([filimonov](https://github.com/filimonov)).
* Enabling running of all TestFlows modules in parallel. [#23942](https://github.com/ClickHouse/ClickHouse/pull/23942) ([vzakaznikov](https://github.com/vzakaznikov)).
* Fixing window functions distributed tests by moving to a deterministic sharding key. [#23975](https://github.com/ClickHouse/ClickHouse/pull/23975) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add more benchmarks for hash tables, including the Swiss Table from Google (that appeared to be slower than ClickHouse hash map in our specific usage scenario). [#24111](https://github.com/ClickHouse/ClickHouse/pull/24111) ([Maksim Kita](https://github.com/kitaisreal)).
* Support building on Illumos. [#24144](https://github.com/ClickHouse/ClickHouse/pull/24144) ([bnaecker](https://github.com/bnaecker)).

#### Other
* Automated backporting now looks at the label 'release' of PRs to consider the release branch. [#23363](https://github.com/ClickHouse/ClickHouse/pull/23363) ([Ivan](https://github.com/abyss7)).
* Add test cases for arrayElement. related issue: [#22765](https://github.com/ClickHouse/ClickHouse/issues/22765). [#23484](https://github.com/ClickHouse/ClickHouse/pull/23484) ([hexiaoting](https://github.com/hexiaoting)).
* Rename uniqThetaSketch (https://github.com/ClickHouse/ClickHouse/issues/14893) to uniqTheta. [#24019](https://github.com/ClickHouse/ClickHouse/pull/24019) ([Kruglov Pavel](https://github.com/Avogar)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Function `arrayFold` for folding over array with accumulator"'. [#23248](https://github.com/ClickHouse/ClickHouse/pull/23248) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "[RFC] Fix memory tracking with min_bytes_to_use_mmap_io"'. [#23276](https://github.com/ClickHouse/ClickHouse/pull/23276) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "add uniqThetaSketch"'. [#23334](https://github.com/ClickHouse/ClickHouse/pull/23334) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Fix CI build for gcc-10"'. [#23772](https://github.com/ClickHouse/ClickHouse/pull/23772) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Update syntax.md'. [#24267](https://github.com/ClickHouse/ClickHouse/pull/24267) ([lulichao](https://github.com/lulichao)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Apply idle_connnection_timeout/poll_interval after each query [#21938](https://github.com/ClickHouse/ClickHouse/pull/21938) ([Azat Khuzhin](https://github.com/azat)).
* Do not silently catch errors for writing to S3 [#22208](https://github.com/ClickHouse/ClickHouse/pull/22208) ([Azat Khuzhin](https://github.com/azat)).
* Add dockerhub-proxy to runner [#23138](https://github.com/ClickHouse/ClickHouse/pull/23138) ([Ilya Yatsishin](https://github.com/qoega)).
* merging sumCount fusion PR [#21337](https://github.com/ClickHouse/ClickHouse/issues/21337) [#23159](https://github.com/ClickHouse/ClickHouse/pull/23159) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Minor fixes in ATTACH query [#23189](https://github.com/ClickHouse/ClickHouse/pull/23189) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Merging [#22503](https://github.com/ClickHouse/ClickHouse/issues/22503) [#23195](https://github.com/ClickHouse/ClickHouse/pull/23195) ([Anton Popov](https://github.com/CurtizJ)).
* Fix logical error in stress tests [#23197](https://github.com/ClickHouse/ClickHouse/pull/23197) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* more stable formatting for negate() [#23201](https://github.com/ClickHouse/ClickHouse/pull/23201) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Use double quote identifier in odbc as default in case of error [#23217](https://github.com/ClickHouse/ClickHouse/pull/23217) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add -Wundef for gcc builds [#23258](https://github.com/ClickHouse/ClickHouse/pull/23258) ([Azat Khuzhin](https://github.com/azat)).
* Report an error if jemalloc.background_thread was requested [#23259](https://github.com/ClickHouse/ClickHouse/pull/23259) ([Azat Khuzhin](https://github.com/azat)).
* Add trace_log into stateless/stress test artifacts [#23264](https://github.com/ClickHouse/ClickHouse/pull/23264) ([Azat Khuzhin](https://github.com/azat)).
* Zlib use attribute constructor for functable initialization [#23266](https://github.com/ClickHouse/ClickHouse/pull/23266) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix integration tests for Hedged requests [#23275](https://github.com/ClickHouse/ClickHouse/pull/23275) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Function toDateTime decimal overflow ubsan fix [#23278](https://github.com/ClickHouse/ClickHouse/pull/23278) ([Maksim Kita](https://github.com/kitaisreal)).
* Link keeper-bench to clickhouse_common_zookeeper [#23302](https://github.com/ClickHouse/ClickHouse/pull/23302) ([Raúl Marín](https://github.com/Algunenano)).
* Print errors on db creation in clickhouse-test [#23304](https://github.com/ClickHouse/ClickHouse/pull/23304) ([Alexander Tokmakov](https://github.com/tavplubix)).
* fix broken perf test [#23308](https://github.com/ClickHouse/ClickHouse/pull/23308) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix bad test 01602_max_distributed_connections [#23317](https://github.com/ClickHouse/ClickHouse/pull/23317) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix hdfs reading from files with spaces [#23318](https://github.com/ClickHouse/ClickHouse/pull/23318) ([Kseniia Sumarokova](https://github.com/kssenii)).
* add check that p.pruning works [#23321](https://github.com/ClickHouse/ClickHouse/pull/23321) ([Denny Crane](https://github.com/den-crane)).
* Add test for [#7815](https://github.com/ClickHouse/ClickHouse/issues/7815) [#23332](https://github.com/ClickHouse/ClickHouse/pull/23332) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky test 01666_merge_tree_max_query_limit.sh [#23335](https://github.com/ClickHouse/ClickHouse/pull/23335) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for [#12077](https://github.com/ClickHouse/ClickHouse/issues/12077) [#23352](https://github.com/ClickHouse/ClickHouse/pull/23352) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable clickhouse-odbc-bridge build when ODBC is disabled [#23357](https://github.com/ClickHouse/ClickHouse/pull/23357) ([Denis Glazachev](https://github.com/traceon)).
* Fix AppleClang build [#23358](https://github.com/ClickHouse/ClickHouse/pull/23358) ([Denis Glazachev](https://github.com/traceon)).
* Use Atomic database for development environment [#23377](https://github.com/ClickHouse/ClickHouse/pull/23377) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for [#2582](https://github.com/ClickHouse/ClickHouse/issues/2582) [#23378](https://github.com/ClickHouse/ClickHouse/pull/23378) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for [#1647](https://github.com/ClickHouse/ClickHouse/issues/1647) [#23379](https://github.com/ClickHouse/ClickHouse/pull/23379) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow rabbitmq vhost in table settings [#23452](https://github.com/ClickHouse/ClickHouse/pull/23452) ([Kseniia Sumarokova](https://github.com/kssenii)).
* System dictionaries virtual key column [#23458](https://github.com/ClickHouse/ClickHouse/pull/23458) ([Maksim Kita](https://github.com/kitaisreal)).
* ISSUES-23310 Try fix MySQL 8.0 address already in use [#23462](https://github.com/ClickHouse/ClickHouse/pull/23462) ([Winter Zhang](https://github.com/zhang2014)).
* Fix error in perf test [#23469](https://github.com/ClickHouse/ClickHouse/pull/23469) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* clickhouse-test: print database name on failures [#23486](https://github.com/ClickHouse/ClickHouse/pull/23486) ([Azat Khuzhin](https://github.com/azat)).
* upload cpu model to perf test db [#23514](https://github.com/ClickHouse/ClickHouse/pull/23514) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix function tests flaps [#23517](https://github.com/ClickHouse/ClickHouse/pull/23517) ([Azat Khuzhin](https://github.com/azat)).
* fix pvs warnings [#23520](https://github.com/ClickHouse/ClickHouse/pull/23520) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* ignore empty input chunks generated by joins [#23542](https://github.com/ClickHouse/ClickHouse/pull/23542) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* fix window functions for Distributed tables [#23546](https://github.com/ClickHouse/ClickHouse/pull/23546) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* add more info to perf test report [#23550](https://github.com/ClickHouse/ClickHouse/pull/23550) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* export trace log from stateless tests in flamegraph-friendly format [#23553](https://github.com/ClickHouse/ClickHouse/pull/23553) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* add numactl info to perf test run attributes [#23554](https://github.com/ClickHouse/ClickHouse/pull/23554) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Less chance of OOM in stress tests [#23561](https://github.com/ClickHouse/ClickHouse/pull/23561) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inconsistent formatting for tupleElement (for fuzzer) [#23595](https://github.com/ClickHouse/ClickHouse/pull/23595) ([Azat Khuzhin](https://github.com/azat)).
* Remove unneeded code from CMakeLists [#23597](https://github.com/ClickHouse/ClickHouse/pull/23597) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Somewhat better handling of paths in CMake (incomplete) [#23598](https://github.com/ClickHouse/ClickHouse/pull/23598) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove old trash (a little) [#23599](https://github.com/ClickHouse/ClickHouse/pull/23599) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove some garbage from RocksDB CMakeLists [#23601](https://github.com/ClickHouse/ClickHouse/pull/23601) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add warning about gcc usage [#23603](https://github.com/ClickHouse/ClickHouse/pull/23603) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove garbage from CMakeLists (2) [#23604](https://github.com/ClickHouse/ClickHouse/pull/23604) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove rotten parts of release script [#23605](https://github.com/ClickHouse/ClickHouse/pull/23605) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless file [#23606](https://github.com/ClickHouse/ClickHouse/pull/23606) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Skip CatBoost tests under MSan [#23614](https://github.com/ClickHouse/ClickHouse/pull/23614) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix segfault in TSan on _exit [#23616](https://github.com/ClickHouse/ClickHouse/pull/23616) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad test 01641_memory_tracking_insert_optimize_long [#23617](https://github.com/ClickHouse/ClickHouse/pull/23617) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove pbuilder [#23618](https://github.com/ClickHouse/ClickHouse/pull/23618) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Aggregator remove unused code [#23635](https://github.com/ClickHouse/ClickHouse/pull/23635) ([Maksim Kita](https://github.com/kitaisreal)).
* Merging [#22984](https://github.com/ClickHouse/ClickHouse/issues/22984) [#23637](https://github.com/ClickHouse/ClickHouse/pull/23637) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Move non gtest unit tests to /examples folder [#23644](https://github.com/ClickHouse/ClickHouse/pull/23644) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Kerberized HDFS test is fluky - retries and extra output if failure [#23650](https://github.com/ClickHouse/ClickHouse/pull/23650) ([Ilya Golshtein](https://github.com/ilejn)).
* Fix documentation for DETACH ON CLUSTER PERMANENTLY [#23653](https://github.com/ClickHouse/ClickHouse/pull/23653) ([Azat Khuzhin](https://github.com/azat)).
* Skip integration test for library bridge under MSan [#23662](https://github.com/ClickHouse/ClickHouse/pull/23662) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix a few PVS-Studio warnings [#23663](https://github.com/ClickHouse/ClickHouse/pull/23663) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable use-after-destruction detection in MSan [#23664](https://github.com/ClickHouse/ClickHouse/pull/23664) ([Azat Khuzhin](https://github.com/azat)).
* Fix cyrus-sasl msan warning [#23672](https://github.com/ClickHouse/ClickHouse/pull/23672) ([Ilya Yatsishin](https://github.com/qoega)).
* A little bit faster merge of aggregating states. [#23681](https://github.com/ClickHouse/ClickHouse/pull/23681) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* stable query indexes in perf test [#23707](https://github.com/ClickHouse/ClickHouse/pull/23707) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Minor changes in code [#14254](https://github.com/ClickHouse/ClickHouse/issues/14254) [#23709](https://github.com/ClickHouse/ClickHouse/pull/23709) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix illiterate error message [#23700](https://github.com/ClickHouse/ClickHouse/issues/23700) [#23710](https://github.com/ClickHouse/ClickHouse/pull/23710) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove obsolete compilers [#23711](https://github.com/ClickHouse/ClickHouse/pull/23711) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Follow-up for [#23644](https://github.com/ClickHouse/ClickHouse/issues/23644) [#23712](https://github.com/ClickHouse/ClickHouse/pull/23712) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disable test_odbc_interaction for MSan build [#23722](https://github.com/ClickHouse/ClickHouse/pull/23722) ([Vladimir C](https://github.com/vdimir)).
* fix a typo in query formatting check in fuzzer [#23726](https://github.com/ClickHouse/ClickHouse/pull/23726) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* ExternalLoaderRepository fix arcadia [#23732](https://github.com/ClickHouse/ClickHouse/pull/23732) ([Maksim Kita](https://github.com/kitaisreal)).
* Ignore cmake-in-clickhouse [#23740](https://github.com/ClickHouse/ClickHouse/pull/23740) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Refactor join step [#23743](https://github.com/ClickHouse/ClickHouse/pull/23743) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* clickhouse-test: send TERM to all childs (to avoid hung check triggering) [#23750](https://github.com/ClickHouse/ClickHouse/pull/23750) ([Azat Khuzhin](https://github.com/azat)).
* Improve test_insert_into_distributed [#23751](https://github.com/ClickHouse/ClickHouse/pull/23751) ([Azat Khuzhin](https://github.com/azat)).
* Fix CI build for gcc-10 [#23760](https://github.com/ClickHouse/ClickHouse/pull/23760) ([Maksim Kita](https://github.com/kitaisreal)).
* Update array-functions.md [#23762](https://github.com/ClickHouse/ClickHouse/pull/23762) ([fancno](https://github.com/fancno)).
* Remove unused compilers (fixed for the troublesome "unbundled" build) [#23766](https://github.com/ClickHouse/ClickHouse/pull/23766) ([Maksim Kita](https://github.com/kitaisreal)).
* Slightly better hardening for intersecting parts [#23767](https://github.com/ClickHouse/ClickHouse/pull/23767) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Workaround for PVS-Studio [#23776](https://github.com/ClickHouse/ClickHouse/pull/23776) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add examples folder filter to ya.make.in [#23786](https://github.com/ClickHouse/ClickHouse/pull/23786) ([Maksim Kita](https://github.com/kitaisreal)).
* Function default implementation for nulls small optimization [#23799](https://github.com/ClickHouse/ClickHouse/pull/23799) ([Maksim Kita](https://github.com/kitaisreal)).
* autodetect arch of gosu in server dockerfile [#23802](https://github.com/ClickHouse/ClickHouse/pull/23802) ([filimonov](https://github.com/filimonov)).
* Add test for [#18170](https://github.com/ClickHouse/ClickHouse/issues/18170) [#23813](https://github.com/ClickHouse/ClickHouse/pull/23813) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* clickhouse-test: add missing whitespace before printing database on error [#23820](https://github.com/ClickHouse/ClickHouse/pull/23820) ([Azat Khuzhin](https://github.com/azat)).
* Improve 00840_long_concurrent_select_and_drop_deadlock [#23823](https://github.com/ClickHouse/ClickHouse/pull/23823) ([Azat Khuzhin](https://github.com/azat)).
* Flat, Hashed dictionary include update field bytes into bytes_allocated [#23825](https://github.com/ClickHouse/ClickHouse/pull/23825) ([Maksim Kita](https://github.com/kitaisreal)).
* XDBCBridgeHelper use global context [#23836](https://github.com/ClickHouse/ClickHouse/pull/23836) ([Maksim Kita](https://github.com/kitaisreal)).
* gcc-10 installation no-install-reccomends option fix [#23840](https://github.com/ClickHouse/ClickHouse/pull/23840) ([Maksim Kita](https://github.com/kitaisreal)).
* replxx readline compatibility [#23855](https://github.com/ClickHouse/ClickHouse/pull/23855) ([Azat Khuzhin](https://github.com/azat)).
* Add file paths into logs on failed distributed async sends [#23856](https://github.com/ClickHouse/ClickHouse/pull/23856) ([Azat Khuzhin](https://github.com/azat)).
* Reduce the amount of logs that StorageMergeTree::selectPartsToMutate outputs in busy systems. [#23863](https://github.com/ClickHouse/ClickHouse/pull/23863) ([Raúl Marín](https://github.com/Algunenano)).
* Add DiskRestartProxy.cpp to ya.make [#23868](https://github.com/ClickHouse/ClickHouse/pull/23868) ([Vladimir C](https://github.com/vdimir)).
* Fix some warnings by PVS-Studio [#23877](https://github.com/ClickHouse/ClickHouse/pull/23877) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add Read/WriteBufferFromFileDecorator.cpp to ya.make [#23879](https://github.com/ClickHouse/ClickHouse/pull/23879) ([Vladimir C](https://github.com/vdimir)).
* @CurtizJ convinced me that this test has to be deleted [#23883](https://github.com/ClickHouse/ClickHouse/pull/23883) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* bash completion improvements [#23884](https://github.com/ClickHouse/ClickHouse/pull/23884) ([Azat Khuzhin](https://github.com/azat)).
* Remove obsolete code [#23886](https://github.com/ClickHouse/ClickHouse/pull/23886) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor code simplification (implemented TODO) [#23896](https://github.com/ClickHouse/ClickHouse/pull/23896) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add run options with default config path according to issues/23875 [#23898](https://github.com/ClickHouse/ClickHouse/pull/23898) ([ice1x](https://github.com/ice1x)).
* Fix test_insert_into_distributed flaps [#23903](https://github.com/ClickHouse/ClickHouse/pull/23903) ([Azat Khuzhin](https://github.com/azat)).
* Fix bad test about compression codecs [#23908](https://github.com/ClickHouse/ClickHouse/pull/23908) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cleanup IDatabase.h from extra headers [#23912](https://github.com/ClickHouse/ClickHouse/pull/23912) ([Azat Khuzhin](https://github.com/azat)).
* Minor simplification [#23923](https://github.com/ClickHouse/ClickHouse/pull/23923) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Drop unnecessary ports where applicable [#23928](https://github.com/ClickHouse/ClickHouse/pull/23928) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* Check MIN/MAX attributes in the list of dictionary attributes [#23948](https://github.com/ClickHouse/ClickHouse/pull/23948) ([Azat Khuzhin](https://github.com/azat)).
* typo: fix a typo in Compression/CodecT64 [#23952](https://github.com/ClickHouse/ClickHouse/pull/23952) ([mwish](https://github.com/mapleFU)).
* Don't try GLIBC_COMPATIBILITY for i686 Linux [#23959](https://github.com/ClickHouse/ClickHouse/pull/23959) ([divanorama](https://github.com/divanorama)).
* Function arrayDifference decimal math overflow [#23961](https://github.com/ClickHouse/ClickHouse/pull/23961) ([Maksim Kita](https://github.com/kitaisreal)).
* Use 0 over nan for hit_rate in case of 0 queries to the cache dictionary [#23963](https://github.com/ClickHouse/ClickHouse/pull/23963) ([Azat Khuzhin](https://github.com/azat)).
* Round floats in Aggregator log messages [#23965](https://github.com/ClickHouse/ClickHouse/pull/23965) ([Azat Khuzhin](https://github.com/azat)).
* support longer query ids in trace log for perf tests [#23969](https://github.com/ClickHouse/ClickHouse/pull/23969) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* PVS-Studio fixes, part 6 [#23970](https://github.com/ClickHouse/ClickHouse/pull/23970) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Functional stateless tests fix numbers [#23974](https://github.com/ClickHouse/ClickHouse/pull/23974) ([Maksim Kita](https://github.com/kitaisreal)).
* use LowCardinality for AsynchronousMetricLog name column [#23981](https://github.com/ClickHouse/ClickHouse/pull/23981) ([flynn](https://github.com/ucasfl)).
* Function dictGetOrNull handle empty rows execute [#23990](https://github.com/ClickHouse/ClickHouse/pull/23990) ([Maksim Kita](https://github.com/kitaisreal)).
* CompileDAG fix Sip hash [#24004](https://github.com/ClickHouse/ClickHouse/pull/24004) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix bad code [#24007](https://github.com/ClickHouse/ClickHouse/pull/24007) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better error codes in Keeper when no leader alive [#24017](https://github.com/ClickHouse/ClickHouse/pull/24017) ([alesapin](https://github.com/alesapin)).
* Fix ArenaWithFreeLists test [#24021](https://github.com/ClickHouse/ClickHouse/pull/24021) ([Maksim Kita](https://github.com/kitaisreal)).
* Run check_*_compiler_flag earlier [#24037](https://github.com/ClickHouse/ClickHouse/pull/24037) ([Amos Bird](https://github.com/amosbird)).
* Performance tests disable compile expressions [#24043](https://github.com/ClickHouse/ClickHouse/pull/24043) ([Maksim Kita](https://github.com/kitaisreal)).
* for trivial INSERT SELECT, adjust block size in bytes as well [#24048](https://github.com/ClickHouse/ClickHouse/pull/24048) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Enable thread_local in Arcadia build [#24051](https://github.com/ClickHouse/ClickHouse/pull/24051) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* lower two-level aggregation threshold for uniq test to avoid jitter [#24058](https://github.com/ClickHouse/ClickHouse/pull/24058) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix empty key projection query analysis [#24062](https://github.com/ClickHouse/ClickHouse/pull/24062) ([Amos Bird](https://github.com/amosbird)).
* Generate ya.make for missing UUID.cpp [#24064](https://github.com/ClickHouse/ClickHouse/pull/24064) ([Alexander Gololobov](https://github.com/davenger)).
* bash-completion: complete available formats [#24065](https://github.com/ClickHouse/ClickHouse/pull/24065) ([Azat Khuzhin](https://github.com/azat)).
* Fix concurrent snapshot read/write [#24073](https://github.com/ClickHouse/ClickHouse/pull/24073) ([alesapin](https://github.com/alesapin)).
* Also retry database creation in `clickhouse-test` [#24088](https://github.com/ClickHouse/ClickHouse/pull/24088) ([alesapin](https://github.com/alesapin)).
* Calculate header from ActionsDAG [#24108](https://github.com/ClickHouse/ClickHouse/pull/24108) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix arcadia [#24133](https://github.com/ClickHouse/ClickHouse/pull/24133) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* TestReadAfterAIO: Use the current path instead of /tmp for temporal files [#24139](https://github.com/ClickHouse/ClickHouse/pull/24139) ([Raúl Marín](https://github.com/Algunenano)).
* Fix a few trailing whitespaces in output [#24150](https://github.com/ClickHouse/ClickHouse/pull/24150) ([Azat Khuzhin](https://github.com/azat)).
* IFunction refactoring [#24155](https://github.com/ClickHouse/ClickHouse/pull/24155) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix add projection to replicated mergetree [#24162](https://github.com/ClickHouse/ClickHouse/pull/24162) ([Amos Bird](https://github.com/amosbird)).
* Fix distributed processing when using projection [#24168](https://github.com/ClickHouse/ClickHouse/pull/24168) ([Amos Bird](https://github.com/amosbird)).
* fix tiny code style [#24169](https://github.com/ClickHouse/ClickHouse/pull/24169) ([flynn](https://github.com/ucasfl)).
* fix reinterpretAsFixedString for UUID [#24177](https://github.com/ClickHouse/ClickHouse/pull/24177) ([flynn](https://github.com/ucasfl)).
* Function move file [#24178](https://github.com/ClickHouse/ClickHouse/pull/24178) ([Maksim Kita](https://github.com/kitaisreal)).
* Updated LRUHashMap benchmarks [#24182](https://github.com/ClickHouse/ClickHouse/pull/24182) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove temporary files [#24186](https://github.com/ClickHouse/ClickHouse/pull/24186) ([Kruglov Pavel](https://github.com/Avogar)).
* Try mute grpc msan [#24197](https://github.com/ClickHouse/ClickHouse/pull/24197) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update slack link [#24200](https://github.com/ClickHouse/ClickHouse/pull/24200) ([Ilya Yatsishin](https://github.com/qoega)).
* Simplier isLocalAddress [#24203](https://github.com/ClickHouse/ClickHouse/pull/24203) ([alesapin](https://github.com/alesapin)).
* Increase timeout for server restart in integration tests. [#24205](https://github.com/ClickHouse/ClickHouse/pull/24205) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Addition to [#23997](https://github.com/ClickHouse/ClickHouse/issues/23997) [#24208](https://github.com/ClickHouse/ClickHouse/pull/24208) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Small code simplification [#24210](https://github.com/ClickHouse/ClickHouse/pull/24210) ([Maksim Kita](https://github.com/kitaisreal)).
* Speedup test [test_jbod_balancer/test.py] [#24247](https://github.com/ClickHouse/ClickHouse/pull/24247) ([alesapin](https://github.com/alesapin)).
* remove useless code [#24248](https://github.com/ClickHouse/ClickHouse/pull/24248) ([flynn](https://github.com/ucasfl)).
* One more attempt to fix retries in clickhouse-test [#24249](https://github.com/ClickHouse/ClickHouse/pull/24249) ([alesapin](https://github.com/alesapin)).
* Log exception in Allocator::free [#24256](https://github.com/ClickHouse/ClickHouse/pull/24256) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix broken HTML markup on website [#24265](https://github.com/ClickHouse/ClickHouse/pull/24265) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix arcadia [#24282](https://github.com/ClickHouse/ClickHouse/pull/24282) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fixed Arcadia after IFunctionOverloadResolver interface refactoring [#24284](https://github.com/ClickHouse/ClickHouse/pull/24284) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix isLocalAddress() (ifa_addr maybe NULL) [#24308](https://github.com/ClickHouse/ClickHouse/pull/24308) ([Azat Khuzhin](https://github.com/azat)).
* Fix bad test for Enum hints [#24313](https://github.com/ClickHouse/ClickHouse/pull/24313) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature #14893

* - Add uniqThetaSketch to support [Theta Sketch](https://datasketches.apache.org/docs/Theta/ThetaSketchFramework.html) in ClickHouse. [#22609](https://github.com/ClickHouse/ClickHouse/pull/22609) ([Ping Yu](https://github.com/pingyu)).
* - Add uniqThetaSketch to support [Theta Sketch](https://datasketches.apache.org/docs/Theta/ThetaSketchFramework.html) in ClickHouse. [#23894](https://github.com/ClickHouse/ClickHouse/pull/23894) ([Ping Yu](https://github.com/pingyu)).
