---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.4.1.6422-prestable FIXME as compared to v21.3.1.6185-prestable

#### Backward Incompatible Change
* Now replicas that are processing the `ALTER TABLE ATTACH PART[ITION]` command search in their `detached/` folders before fetching the data from other replicas. As an implementation detail, a new command `ATTACH_PART` is introduced in the replicated log. Parts are searched and compared by their checksums. [#18978](https://github.com/ClickHouse/ClickHouse/pull/18978) ([Mike Kot](https://github.com/myrrc)).
* Column `keys` in table `system.dictionaries` was replaced to columns `key.names` and `key.types`. Columns `key.names`, `key.types`, `attribute.names`, `attribute.types` from `system.dictionaries` table does not require dictionary to be loaded. [#21884](https://github.com/ClickHouse/ClickHouse/pull/21884) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix `cutToFirstSignificantSubdomainCustom()`/`firstSignificantSubdomainCustom()` returning wrong result for 3+ level domains present in custom top-level domain list. For input domains matching these custom top-level domains, the third-level domain was considered to be the first significant one. This is now fixed. This change may introduce incompatibility if the function is used in e.g. the sharding key. [#21946](https://github.com/ClickHouse/ClickHouse/pull/21946) ([Azat Khuzhin](https://github.com/azat)).
* The `toStartOfIntervalFunction` will align hour intervals to the midnight (in previous versions they were aligned to the start of unix epoch). For example, `toStartOfInterval(x, INTERVAL 11 HOUR)` will split every day into three intervals: 00:00:00..10:59:59, 11:00:00..21:59:59 and 22:00:00..23:59:59. This behaviour is more suited for practical needs. This closes [#9510](https://github.com/ClickHouse/ClickHouse/issues/9510). [#22060](https://github.com/ClickHouse/ClickHouse/pull/22060) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature
* Extended range of `DateTime64` to properly support dates from year 1925 to 2283. Improved support of `DateTime` around zero date (`1970-01-01`). ... [#9404](https://github.com/ClickHouse/ClickHouse/pull/9404) ([Vasily Nemkov](https://github.com/Enmk)).
* - Added support of Kerberos authentication for preconfigured users and HTTP requests (GSS-SPNEGO). [#14995](https://github.com/ClickHouse/ClickHouse/pull/14995) ([Denis Glazachev](https://github.com/traceon)).
* Zero-copy replication for ReplicatedMergeTree over S3 storage. [#16240](https://github.com/ClickHouse/ClickHouse/pull/16240) ([ianton-ru](https://github.com/ianton-ru)).
* Support `dictHas` function for `RangeHashedDictionary`. Fixes [#6680](https://github.com/ClickHouse/ClickHouse/issues/6680). [#19816](https://github.com/ClickHouse/ClickHouse/pull/19816) ([Maksim Kita](https://github.com/kitaisreal)).
* Supports implicit key type conversion for JOIN. Closes [#18567](https://github.com/ClickHouse/ClickHouse/issues/18567). [#19885](https://github.com/ClickHouse/ClickHouse/pull/19885) ([Vladimir C](https://github.com/vdimir)).
* Allow customizing timeouts for http connections used for replication independently from other http timeouts. [#20088](https://github.com/ClickHouse/ClickHouse/pull/20088) ([nvartolomei](https://github.com/nvartolomei)).
* Added async update in `ComplexKeyCache`, `SSDCache`, `SSDComplexKeyCache` dictionaries. Added support for Nullable type in `Cache`, `ComplexKeyCache`, `SSDCache`, `SSDComplexKeyCache` dictionaries. Added support for multiple attributes fetch with `dictGet`, `dictGetOrDefault` functions. Fixes [#21517](https://github.com/ClickHouse/ClickHouse/issues/21517). [#20595](https://github.com/ClickHouse/ClickHouse/pull/20595) ([Maksim Kita](https://github.com/kitaisreal)).
* Added `Grant,` `Revoke` and `System` values of `query_kind` column for corresponding queries in `system.query_log` ... [#21102](https://github.com/ClickHouse/ClickHouse/pull/21102) ([Vasily Nemkov](https://github.com/Enmk)).
* Added new SQL command ALTER TABLE 'table_name' UNFREEZE [PARTITION 'part_expr'] WITH NAME 'backup_name'. [#21142](https://github.com/ClickHouse/ClickHouse/pull/21142) ([Pavel Kovalenko](https://github.com/Jokser)).
* Added ExecutablePool dictionary source. Close [#14528](https://github.com/ClickHouse/ClickHouse/issues/14528). [#21321](https://github.com/ClickHouse/ClickHouse/pull/21321) ([Maksim Kita](https://github.com/kitaisreal)).
* - Add function `isIPAddressInRange` to test if an IPv4 or IPv6 address is contained in a given CIDR network prefix. [#21329](https://github.com/ClickHouse/ClickHouse/pull/21329) ([PHO](https://github.com/depressed-pho)).
* Add `_partition_id` virtual column for `MergeTree*` engines. Allow to prune partitions by `_partition_id`. Add `partitionID()` function to calculate partition id string. [#21401](https://github.com/ClickHouse/ClickHouse/pull/21401) ([Amos Bird](https://github.com/amosbird)).
* Add new column `slowdowns_count` to `system.clusters`. When using hedged requests, it shows how many times we switched to another replica because this replica was responding slowly. Also show actual value of `errors_count` in `system.clusters`. [#21480](https://github.com/ClickHouse/ClickHouse/pull/21480) ([Kruglov Pavel](https://github.com/Avogar)).
* Add option `--backslash` for clickhouse-format, which can add a backslash at the end of each line of the formatted query. [#21494](https://github.com/ClickHouse/ClickHouse/pull/21494) ([flynn](https://github.com/ucasfl)).
* Add new optional clause GRANTEES for CREATE/ALTER USER commands:. [#21641](https://github.com/ClickHouse/ClickHouse/pull/21641) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add `ctime` option to `zookeeper-dump-tree`. It allows to dump node creation time. [#21842](https://github.com/ClickHouse/ClickHouse/pull/21842) ([Ilya](https://github.com/HumanUser)).
* Functions 'dictGet', 'dictHas' use current database name if it is not specified for dictionaries created with DDL. Closes [#21632](https://github.com/ClickHouse/ClickHouse/issues/21632). [#21859](https://github.com/ClickHouse/ClickHouse/pull/21859) ([Maksim Kita](https://github.com/kitaisreal)).
* Support `Nullable` type for `PolygonDictionary` attribute. [#21890](https://github.com/ClickHouse/ClickHouse/pull/21890) ([Maksim Kita](https://github.com/kitaisreal)).
* Added table function `dictionary`. It works the same way as `Dictionary` engine. Closes [#21560](https://github.com/ClickHouse/ClickHouse/issues/21560). [#21910](https://github.com/ClickHouse/ClickHouse/pull/21910) ([Maksim Kita](https://github.com/kitaisreal)).
* Add function `timezoneOf` that returns the timezone name of `DateTime` or `DateTime64` data types. This does not close [#9959](https://github.com/ClickHouse/ClickHouse/issues/9959). Fix inconsistencies in function names: add aliases `timezone` and `timeZone` as well as `toTimezone` and `toTimeZone` and `timezoneOf` and `timeZoneOf`. [#22001](https://github.com/ClickHouse/ClickHouse/pull/22001) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `prefer_column_name_to_alias` setting to use original column names instead of aliases. it is needed to be more compatible with common databases' aliasing rules. This is for [#9715](https://github.com/ClickHouse/ClickHouse/issues/9715) and [#9887](https://github.com/ClickHouse/ClickHouse/issues/9887). [#22044](https://github.com/ClickHouse/ClickHouse/pull/22044) ([Amos Bird](https://github.com/amosbird)).
* Improved performance of `dictGetHierarchy`, `dictIsIn` functions. Added functions `dictGetChildren(dictionary, key)`, `dictGetDescendants(dictionary, key, level)`. Function `dictGetChildren` return all children as an array if indexes. It is a inverse transformation for `dictGetHierarchy`. Function `dictGetDescendants` return all descendants as if `dictGetChildren` was applied `level` times recursively. Zero `level` value is equivalent to infinity. Closes [#14656](https://github.com/ClickHouse/ClickHouse/issues/14656). [#22096](https://github.com/ClickHouse/ClickHouse/pull/22096) ([Maksim Kita](https://github.com/kitaisreal)).
* Added function `dictGetOrNull`. It works like `dictGet`, but return `Null` in case key was not found in dictionary. Closes [#22375](https://github.com/ClickHouse/ClickHouse/issues/22375). [#22413](https://github.com/ClickHouse/ClickHouse/pull/22413) ([Maksim Kita](https://github.com/kitaisreal)).

#### Performance Improvement
* Support parallel parsing for `CSVWithNames` and `TSVWithNames` formats. This closes [#21085](https://github.com/ClickHouse/ClickHouse/issues/21085). [#21149](https://github.com/ClickHouse/ClickHouse/pull/21149) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Improved performance by replacing `memcpy` to another implementation. This closes [#18583](https://github.com/ClickHouse/ClickHouse/issues/18583). [#21520](https://github.com/ClickHouse/ClickHouse/pull/21520) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Supported parallel formatting in clickhouse-local and everywhere else. [#21630](https://github.com/ClickHouse/ClickHouse/pull/21630) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Optimize performance of queries like `SELECT ... FINAL ... WHERE`. Now in queries with `FINAL` it's allowed to move to `PREWHERE` columns, which are in sorting key. ... [#21830](https://github.com/ClickHouse/ClickHouse/pull/21830) ([foolchi](https://github.com/foolchi)).
* Faster `GROUP BY` with small `max_rows_to_group_by` and `group_by_overflow_mode='any'`. [#21856](https://github.com/ClickHouse/ClickHouse/pull/21856) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Avoid unnecessary data copy when using codec `NONE`. Please note that codec `NONE` is mostly useless - it's recommended to always use compression (`LZ4` is by default). Despite the common belief, disabling compression may not improve performance (the opposite effect is possible). The `NONE` codec is useful in some cases: - when data is uncompressable; - for synthetic benchmarks. [#22145](https://github.com/ClickHouse/ClickHouse/pull/22145) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add cache for files read with `min_bytes_to_use_mmap_io` setting. It makes significant (2x and more) performance improvement when the value of the setting is small by avoiding frequent mmap/munmap calls and the consequent page faults. Note that mmap IO has major drawbacks that makes it less reliable in production (e.g. hung or SIGBUS on faulty disks; less controllable memory usage). Nevertheless it is good in benchmarks. [#22206](https://github.com/ClickHouse/ClickHouse/pull/22206) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable read with mmap IO for file ranges from 64 MiB (the settings `min_bytes_to_use_mmap_io`). It may lead to moderate performance improvement. [#22326](https://github.com/ClickHouse/ClickHouse/pull/22326) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Introduce a new merge tree setting `min_bytes_to_rebalance_partition_over_jbod` which allows assigning new parts to different disks of a JBOD volume in a balanced way. [#16481](https://github.com/ClickHouse/ClickHouse/pull/16481) ([Amos Bird](https://github.com/amosbird)).
* Improve performance of aggregation in order of sorting key (with enabled setting `optimize_aggregation_in_order`). [#19401](https://github.com/ClickHouse/ClickHouse/pull/19401) ([Anton Popov](https://github.com/CurtizJ)).
* MaterializeMySQL: add minmax skipping index for _version column. [#20382](https://github.com/ClickHouse/ClickHouse/pull/20382) ([Stig Bakken](https://github.com/stigsb)).
* Do not create empty parts on INSERT when `optimize_on_insert` setting enabled. Fixes [#20304](https://github.com/ClickHouse/ClickHouse/issues/20304). [#20387](https://github.com/ClickHouse/ClickHouse/pull/20387) ([Kruglov Pavel](https://github.com/Avogar)).
* - Support more cases to rewrite `CROSS JOIN` to `INNER JOIN`. [#20392](https://github.com/ClickHouse/ClickHouse/pull/20392) ([Vladimir C](https://github.com/vdimir)).
* MaterializeMySQL: Attempt to reconnect to MySQL if the connection is lost. [#20961](https://github.com/ClickHouse/ClickHouse/pull/20961) ([Håvard Kvålen](https://github.com/havardk)).
* Improve support of integer keys in data type `Map`. [#21157](https://github.com/ClickHouse/ClickHouse/pull/21157) ([Anton Popov](https://github.com/CurtizJ)).
* Improve clickhouse-format to not throw exception when there are extra spaces or comment after the last query, and throw exception early with readable message when format `ASTInsertQuery` with data . [#21311](https://github.com/ClickHouse/ClickHouse/pull/21311) ([flynn](https://github.com/ucasfl)).
* Age and Precision in graphite rollup configs should increase from retention to retention. Now it's checked and the wrong config raises an exception. [#21496](https://github.com/ClickHouse/ClickHouse/pull/21496) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add setting `optimize_skip_unused_shards_limit` to limit the number of sharding key values for `optimize_skip_unused_shards`. [#21512](https://github.com/ClickHouse/ClickHouse/pull/21512) ([Azat Khuzhin](https://github.com/azat)).
* Add aliases `simpleJSONExtract/simpleJSONHas` to `visitParam/visitParamExtract{UInt, Int, Bool, Float, Raw, String}`. Fixes [#21383](https://github.com/ClickHouse/ClickHouse/issues/21383). [#21519](https://github.com/ClickHouse/ClickHouse/pull/21519) ([fastio](https://github.com/fastio)).
* Add `last_error_time`/`last_error_message`/`last_error_stacktrace`/`remote` columns for `system.errors`. [#21529](https://github.com/ClickHouse/ClickHouse/pull/21529) ([Azat Khuzhin](https://github.com/azat)).
* If PODArray was instantiated with element size that is neither a fraction or a multiple of 16, buffer overflow was possible. No bugs in current releases exist. [#21533](https://github.com/ClickHouse/ClickHouse/pull/21533) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - Propagate query and session settings for distributed DDL queries. Set `distributed_ddl_entry_format_version` to 2 to enable this. - Added `distributed_ddl_output_mode` setting. Supported modes: `none`, `throw` (default), `null_status_on_timeout` and `never_throw`. - Miscellaneous fixes and improvements for `Replicated` database engine. [#21535](https://github.com/ClickHouse/ClickHouse/pull/21535) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Update clusters only if their configurations were updated. [#21685](https://github.com/ClickHouse/ClickHouse/pull/21685) ([Kruglov Pavel](https://github.com/Avogar)).
* Support replicas priority for postgres dictionary source. [#21710](https://github.com/ClickHouse/ClickHouse/pull/21710) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Closes [#21701](https://github.com/ClickHouse/ClickHouse/issues/21701). Support non-default table schema for postgres storage/table-function. [#21711](https://github.com/ClickHouse/ClickHouse/pull/21711) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Better formatting for `Array` and `Map` data types in Web UI. [#21798](https://github.com/ClickHouse/ClickHouse/pull/21798) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* DiskS3 (experimental feature under development). Fixed bug with the impossibility to move directory if the destination is not empty and cache disk is used. [#21837](https://github.com/ClickHouse/ClickHouse/pull/21837) ([Pavel Kovalenko](https://github.com/Jokser)).
* Add connection pool for PostgreSQL table/database engine and dictionary source. Should fix [#21444](https://github.com/ClickHouse/ClickHouse/issues/21444). [#21839](https://github.com/ClickHouse/ClickHouse/pull/21839) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add profile event HedgedRequestsChangeReplica, change read data timeout from sec to ms. [#21886](https://github.com/ClickHouse/ClickHouse/pull/21886) ([Kruglov Pavel](https://github.com/Avogar)).
* Support `RANGE OFFSET` frame for floating point types. Implement `lagInFrame`/`leadInFrame` window functions, which are analogous to `lag`/`lead`, but respect the window frame. They are identical when the frame is `between unbounded preceding and unbounded following`. This closes [#5485](https://github.com/ClickHouse/ClickHouse/issues/5485). [#21895](https://github.com/ClickHouse/ClickHouse/pull/21895) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Show path to data directory of `EmbeddedRocksDB` tables in system tables. [#21903](https://github.com/ClickHouse/ClickHouse/pull/21903) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Supported `replication_alter_partitions_sync=1` setting for moving partitions from helping table to destination. Decreased default timeouts. Fixes [#21911](https://github.com/ClickHouse/ClickHouse/issues/21911). [#21912](https://github.com/ClickHouse/ClickHouse/pull/21912) ([jasong](https://github.com/songenjie)).
* If partition key of a `MergeTree` table does not include `Date` or `DateTime` columns but includes exactly one `DateTime64` column, expose its values in the `min_time` and `max_time` columns in `system.parts` and `system.parts_columns` tables. Add `min_time` and `max_time` columns to `system.parts_columns` table (these was inconsistency to the `system.parts` table). This closes [#18244](https://github.com/ClickHouse/ClickHouse/issues/18244). [#22011](https://github.com/ClickHouse/ClickHouse/pull/22011) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* * Add option strict_increase to windowFunnel function to calculate each event once (resolve [#21835](https://github.com/ClickHouse/ClickHouse/issues/21835)). [#22025](https://github.com/ClickHouse/ClickHouse/pull/22025) ([Vladimir C](https://github.com/vdimir)).
* Added case insensitive aliases for `CONNECTION_ID()` and `VERSION()` functions. This fixes [#22028](https://github.com/ClickHouse/ClickHouse/issues/22028). [#22042](https://github.com/ClickHouse/ClickHouse/pull/22042) ([Eugene Klimov](https://github.com/Slach)).
* Update used version of simdjson to 0.9.1. This fixes [#21984](https://github.com/ClickHouse/ClickHouse/issues/21984). [#22057](https://github.com/ClickHouse/ClickHouse/pull/22057) ([Vitaly Baranov](https://github.com/vitlibar)).
* Convert `system.errors.stack_trace` from `String` into `Array(UInt64)` (This should decrease overhead for the errors collecting). [#22058](https://github.com/ClickHouse/ClickHouse/pull/22058) ([Azat Khuzhin](https://github.com/azat)).
* If tuple of NULLs, e.g. `(NULL, NULL)` is on the left hand side of `IN` operator with tuples of non-NULLs on the right hand side, e.g. `SELECT (NULL, NULL) IN ((0, 0), (3, 1))` return 0 instead of throwing an exception about incompatible types. The expression may also appear due to optimization of something like `SELECT (NULL, NULL) = (8, 0) OR (NULL, NULL) = (3, 2) OR (NULL, NULL) = (0, 0) OR (NULL, NULL) = (3, 1)`. This closes [#22017](https://github.com/ClickHouse/ClickHouse/issues/22017). [#22063](https://github.com/ClickHouse/ClickHouse/pull/22063) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added possibility to migrate existing S3 disk to the schema with backup-restore capabilities. [#22070](https://github.com/ClickHouse/ClickHouse/pull/22070) ([Pavel Kovalenko](https://github.com/Jokser)).
* Add case-insensitive history search/navigation and subword movement features to clickhouse-client. [#22105](https://github.com/ClickHouse/ClickHouse/pull/22105) ([Amos Bird](https://github.com/amosbird)).
* Add `current_database` column to `system.processes` table. It contains the current database of the query. [#22365](https://github.com/ClickHouse/ClickHouse/pull/22365) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix MSan report for function `range` with `UInt256` argument (support for large integers is experimental). This closes [#22157](https://github.com/ClickHouse/ClickHouse/issues/22157). [#22387](https://github.com/ClickHouse/ClickHouse/pull/22387) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix error `Directory tmp_fetch_XXX already exists` which could happen after failed fetch part. Delete temporary fetch directory if it already exists. Fixes [#14197](https://github.com/ClickHouse/ClickHouse/issues/14197). [#22411](https://github.com/ClickHouse/ClickHouse/pull/22411) ([nvartolomei](https://github.com/nvartolomei)).
* Better exception message in client in case of exception while server is writing blocks. In previous versions client may get misleading message like `Data compressed with different methods`. [#22427](https://github.com/ClickHouse/ClickHouse/pull/22427) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Bug Fix
* Fixed open behavior of remote host filter in case when there is `remote_url_allow_hosts` section in configuration but no entries there. :warning: please add a note about potential issue when upgrading - @alexey-milovidov. [#20058](https://github.com/ClickHouse/ClickHouse/pull/20058) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix name clashes in `PredicateRewriteVisitor`. It caused incorrect `WHERE` filtration after full join. Close [#20497](https://github.com/ClickHouse/ClickHouse/issues/20497). [#20622](https://github.com/ClickHouse/ClickHouse/pull/20622) ([Vladimir C](https://github.com/vdimir)).
* `force_drop_table` flag didn't work for `MATERIALIZED VIEW`, it's fixed. Fixes [#18943](https://github.com/ClickHouse/ClickHouse/issues/18943). [#20626](https://github.com/ClickHouse/ClickHouse/pull/20626) ([Alexander Tokmakov](https://github.com/tavplubix)).
* fix official website documents which introduced cluster secret feature. [#21331](https://github.com/ClickHouse/ClickHouse/pull/21331) ([Chao Ma](https://github.com/godliness)).
* Fix receive and send timeouts and non-blocking read in secure socket. [#21429](https://github.com/ClickHouse/ClickHouse/pull/21429) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix Avro format parsing for Kafka. Fixes [#21437](https://github.com/ClickHouse/ClickHouse/issues/21437). [#21438](https://github.com/ClickHouse/ClickHouse/pull/21438) ([Ilya Golshtein](https://github.com/ilejn)).
* Fixed race on SSL object inside SecureSocket in Poco. [#21456](https://github.com/ClickHouse/ClickHouse/pull/21456) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix that S3 table holds old credentials after config update. [#21457](https://github.com/ClickHouse/ClickHouse/pull/21457) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix table function `clusterAllReplicas` returns wrong `_shard_num`. close [#21481](https://github.com/ClickHouse/ClickHouse/issues/21481). [#21498](https://github.com/ClickHouse/ClickHouse/pull/21498) ([flynn](https://github.com/ucasfl)).
* The ```::poll()``` return ```rc == 1 ```, it could be a request or it could be a response. [#21544](https://github.com/ClickHouse/ClickHouse/pull/21544) ([小路](https://github.com/nicelulu)).
* In case if query has constant `WHERE` condition, and setting `optimize_skip_unused_shards` enabled, all shards may be skipped and query could return incorrect empty result. [#21550](https://github.com/ClickHouse/ClickHouse/pull/21550) ([Amos Bird](https://github.com/amosbird)).
* Fix possible error ` Cannot find column` when `optimize_skip_unused_shards` is enabled and zero shards are used. [#21579](https://github.com/ClickHouse/ClickHouse/pull/21579) ([Azat Khuzhin](https://github.com/azat)).
* `std::terminate` was called if there is an error writing data into s3. [#21624](https://github.com/ClickHouse/ClickHouse/pull/21624) ([Vladimir C](https://github.com/vdimir)).
* Remove unknown columns from joined table in where for queries to external database engines (MySQL, PostgreSQL). close [#14614](https://github.com/ClickHouse/ClickHouse/issues/14614), close [#19288](https://github.com/ClickHouse/ClickHouse/issues/19288) (dup), close [#19645](https://github.com/ClickHouse/ClickHouse/issues/19645) (dup). [#21640](https://github.com/ClickHouse/ClickHouse/pull/21640) ([Vladimir C](https://github.com/vdimir)).
* Fix fsync_part_directory for horizontal merge. [#21642](https://github.com/ClickHouse/ClickHouse/pull/21642) ([Azat Khuzhin](https://github.com/azat)).
* Fix distributed requests cancellation (for example simple select from multiple shards with limit, i.e. `select * from remote('127.{2,3}', system.numbers) limit 100`) with `async_socket_for_remote=1`. [#21643](https://github.com/ClickHouse/ClickHouse/pull/21643) ([Azat Khuzhin](https://github.com/azat)).
* Add type conversion for StorageJoin (previously led to SIGSEGV). [#21646](https://github.com/ClickHouse/ClickHouse/pull/21646) ([Azat Khuzhin](https://github.com/azat)).
* Start accepting connections after DDLWorker and dictionaries initialization. [#21676](https://github.com/ClickHouse/ClickHouse/pull/21676) ([Azat Khuzhin](https://github.com/azat)).
* Fix SIGSEGV on not existing attributes from ip_trie with access_to_key_from_attributes. [#21692](https://github.com/ClickHouse/ClickHouse/pull/21692) ([Azat Khuzhin](https://github.com/azat)).
* Fix function `arrayElement` with type `Map` for constant integer arguments. [#21699](https://github.com/ClickHouse/ClickHouse/pull/21699) ([Anton Popov](https://github.com/CurtizJ)).
* Fix concurrent `OPTIMIZE` and `DROP` for `ReplicatedMergeTree`. [#21716](https://github.com/ClickHouse/ClickHouse/pull/21716) ([Azat Khuzhin](https://github.com/azat)).
* Fix bug for ReplicatedMerge table engines when `ALTER MODIFY COLUMN` query doesn't change the type of decimal column if its size (32 bit or 64 bit) doesn't change. [#21728](https://github.com/ClickHouse/ClickHouse/pull/21728) ([alesapin](https://github.com/alesapin)).
* Reverted S3 connection pools. [#21737](https://github.com/ClickHouse/ClickHouse/pull/21737) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix adding of parts with already existing in destination table names in query `MOVE PARTITION TO TABLE` with non-replicated `MergeTree` tables. [#21760](https://github.com/ClickHouse/ClickHouse/pull/21760) ([ygrek](https://github.com/ygrek)).
* Fix scalar subquery index analysis. This fixes [#21717](https://github.com/ClickHouse/ClickHouse/issues/21717) , which was introduced in https://github.com/ClickHouse/ClickHouse/pull/18896 . [#21766](https://github.com/ClickHouse/ClickHouse/pull/21766) ([Amos Bird](https://github.com/amosbird)).
* Fix possible crashes in aggregate functions with combinator Distinct, while using two-level aggregation. This is a follow-up fix of https://github.com/ClickHouse/ClickHouse/pull/18365 . Can only reproduced in production env. No test case available yet. cc @CurtizJ. [#21818](https://github.com/ClickHouse/ClickHouse/pull/21818) ([Amos Bird](https://github.com/amosbird)).
* Better error handling and logging in WriteBufferFromS3. [#21836](https://github.com/ClickHouse/ClickHouse/pull/21836) ([Pavel Kovalenko](https://github.com/Jokser)).
* Fix incorrect query result (and possible crash) which could happen when `WHERE` or `HAVING` condition is pushed before `GROUP BY`. Fixes [#21773](https://github.com/ClickHouse/ClickHouse/issues/21773). [#21841](https://github.com/ClickHouse/ClickHouse/pull/21841) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix deadlock in first catboost model execution. Closes [#13832](https://github.com/ClickHouse/ClickHouse/issues/13832). [#21844](https://github.com/ClickHouse/ClickHouse/pull/21844) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix wrong `ORDER BY` results when a query contains window functions, and optimization for reading in primary key order is applied. Fixes [#21828](https://github.com/ClickHouse/ClickHouse/issues/21828). [#21915](https://github.com/ClickHouse/ClickHouse/pull/21915) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix reading the HTTP POST request with "multipart/form-data" content type. [#21936](https://github.com/ClickHouse/ClickHouse/pull/21936) ([Ivan](https://github.com/abyss7)).
* Prevent hedged connections overlaps (`Unknown packet 9 from server` error). [#21941](https://github.com/ClickHouse/ClickHouse/pull/21941) ([Azat Khuzhin](https://github.com/azat)).
* Reverted [#15454](https://github.com/ClickHouse/ClickHouse/issues/15454) that may cause significant increase in memory usage while loading external dictionaries of hashed type. This closes [#21935](https://github.com/ClickHouse/ClickHouse/issues/21935). [#21948](https://github.com/ClickHouse/ClickHouse/pull/21948) ([Maksim Kita](https://github.com/kitaisreal)).
* In rare case, merge for `CollapsingMergeTree` may create granule with `index_granularity + 1` rows. Because of this, internal check, added in [#18928](https://github.com/ClickHouse/ClickHouse/issues/18928) (affects 21.2 and 21.3), may fail with error `Incomplete granules are not allowed while blocks are granules size`. This error did not allow parts to merge. [#21976](https://github.com/ClickHouse/ClickHouse/pull/21976) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* The function `decrypt` was lacking a check for the minimal size of data encrypted in AEAD mode. This closes [#21897](https://github.com/ClickHouse/ClickHouse/issues/21897). [#22064](https://github.com/ClickHouse/ClickHouse/pull/22064) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Docker entrypoint: avoid chown of `.` in case when `LOG_PATH` is empty. Closes [#22100](https://github.com/ClickHouse/ClickHouse/issues/22100). [#22102](https://github.com/ClickHouse/ClickHouse/pull/22102) ([filimonov](https://github.com/filimonov)).
* Disable `async_socket_for_remote`/`use_hedged_requests` for buggy linux kernels. [#22109](https://github.com/ClickHouse/ClickHouse/pull/22109) ([Azat Khuzhin](https://github.com/azat)).
* Fix waiting for `OPTIMIZE` and `ALTER` queries for `ReplicatedMergeTree` table engines. Now the query will not hang when the table was detached or restarted. [#22118](https://github.com/ClickHouse/ClickHouse/pull/22118) ([alesapin](https://github.com/alesapin)).
* Fix the background thread pool name. [#22122](https://github.com/ClickHouse/ClickHouse/pull/22122) ([fastio](https://github.com/fastio)).
* Fix error `Invalid number of rows in Chunk` in `JOIN` with `TOTALS` and `arrayJoin`. Closes [#19303](https://github.com/ClickHouse/ClickHouse/issues/19303). [#22129](https://github.com/ClickHouse/ClickHouse/pull/22129) ([Vladimir C](https://github.com/vdimir)).
* Fix docker entrypoint in case `http_port` is not in the config. [#22132](https://github.com/ClickHouse/ClickHouse/pull/22132) ([Ewout](https://github.com/devwout)).
* Fix uncaught exception in InterserverIOHTTPHandler. [#22146](https://github.com/ClickHouse/ClickHouse/pull/22146) ([Azat Khuzhin](https://github.com/azat)).
* Use finalize() over next() for nested writers. [#22147](https://github.com/ClickHouse/ClickHouse/pull/22147) ([Azat Khuzhin](https://github.com/azat)).
* Fix query cancellation with `use_hedged_requests=0` and `async_socket_for_remote=1`. [#22183](https://github.com/ClickHouse/ClickHouse/pull/22183) ([Azat Khuzhin](https://github.com/azat)).
* Fix exception which may happen when `SELECT` has constant `WHERE` condition and source table has columns which names are digits. [#22270](https://github.com/ClickHouse/ClickHouse/pull/22270) ([LiuNeng](https://github.com/liuneng1994)).
* Now clickhouse will not throw `LOGICAL_ERROR` exception when we try to mutate the already covered part. Fixes [#22013](https://github.com/ClickHouse/ClickHouse/issues/22013). [#22291](https://github.com/ClickHouse/ClickHouse/pull/22291) ([alesapin](https://github.com/alesapin)).
* Fixed bug in S3 zero-copy replication for hybrid storage. [#22378](https://github.com/ClickHouse/ClickHouse/pull/22378) ([ianton-ru](https://github.com/ianton-ru)).
* Add (missing) memory accounting in parallel parsing routines. In previous versions OOM was possible when the resultset contains very large blocks of data. This closes [#22008](https://github.com/ClickHouse/ClickHouse/issues/22008). [#22425](https://github.com/ClickHouse/ClickHouse/pull/22425) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove socket from epoll before cancelling packet receiver in HedgedConnections to prevent possible race. I hope it fixes [#22161](https://github.com/ClickHouse/ClickHouse/issues/22161). [#22443](https://github.com/ClickHouse/ClickHouse/pull/22443) ([Kruglov Pavel](https://github.com/Avogar)).

#### Build/Testing/Packaging Improvement
* Fix macOS shared lib build. [#20184](https://github.com/ClickHouse/ClickHouse/pull/20184) ([nvartolomei](https://github.com/nvartolomei)).
* - Added ALL and NONE privilege tests. - Added ROW POLICY tests. - Cleanup of existing tests. - Tests close faster if something fails. [#21354](https://github.com/ClickHouse/ClickHouse/pull/21354) ([MyroTk](https://github.com/MyroTk)).
* Fixing LDAP authentication performance test by removing assertion. [#21507](https://github.com/ClickHouse/ClickHouse/pull/21507) ([vzakaznikov](https://github.com/vzakaznikov)).
* Updating docker/test/testflows/runner/dockerd-entrypoint.sh to use Yandex dockerhub-proxy. [#21551](https://github.com/ClickHouse/ClickHouse/pull/21551) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add llvm-12 binaries name to search in cmake scripts. Implicit constants conversions to mute clang warnings. Updated submodules to build with CMake 3.19. Mute recursion in macro expansion in readpassphrase library. Deprecated -fuse-ld changed to --ld-path for clang. [#21597](https://github.com/ClickHouse/ClickHouse/pull/21597) ([Ilya Yatsishin](https://github.com/qoega)).
* Updating TestFlows to 1.6.74. [#21673](https://github.com/ClickHouse/ClickHouse/pull/21673) ([vzakaznikov](https://github.com/vzakaznikov)).
* Add [jepsen](https://github.com/jepsen-io/jepsen) tests for NuKeeper. [#21677](https://github.com/ClickHouse/ClickHouse/pull/21677) ([alesapin](https://github.com/alesapin)).
* remove decode method with python3. [#21832](https://github.com/ClickHouse/ClickHouse/pull/21832) ([kevin wan](https://github.com/MaxWk)).
* Allow to use clang-tidy with release builds by enabling assertions if it is used. [#21914](https://github.com/ClickHouse/ClickHouse/pull/21914) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Introduce 2 arguments for clickhouse-server image Dockerfile: deb_location & single_binary_location. [#21977](https://github.com/ClickHouse/ClickHouse/pull/21977) ([filimonov](https://github.com/filimonov)).
* Add `tzdata` to Docker containers because reading ORC formats requires it. This closes [#14156](https://github.com/ClickHouse/ClickHouse/issues/14156). [#22000](https://github.com/ClickHouse/ClickHouse/pull/22000) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable status check for SQLancer CI run. [#22015](https://github.com/ClickHouse/ClickHouse/pull/22015) ([Ilya Yatsishin](https://github.com/qoega)).
* Run stateless tests in parallel in CI. Depends on [#22181](https://github.com/ClickHouse/ClickHouse/issues/22181). [#22300](https://github.com/ClickHouse/ClickHouse/pull/22300) ([alesapin](https://github.com/alesapin)).
* try fix [#22289](https://github.com/ClickHouse/ClickHouse/issues/22289) https://clickhouse-test-reports.s3.yandex.net/22289/c71da4a5c8e655f4bdfaa33b92ab022b97dfdf1a/integration_tests_(asan).html#fail1 MySQL is started only once with MaterializeMySQL integration test. [#22341](https://github.com/ClickHouse/ClickHouse/pull/22341) ([Winter Zhang](https://github.com/zhang2014)).
* - Added a way to check memory info for the RBAC testflows tests. [#22403](https://github.com/ClickHouse/ClickHouse/pull/22403) ([MyroTk](https://github.com/MyroTk)).
* Fixed compiling on ppc64le and use the correct instruction pointer register on ppc64le. [#22430](https://github.com/ClickHouse/ClickHouse/pull/22430) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Fix ClickHouse's config embedding and cctz's timezone embedding on ppc64le. ... [#22445](https://github.com/ClickHouse/ClickHouse/pull/22445) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Enable building with jemalloc on ppc64le ... [#22447](https://github.com/ClickHouse/ClickHouse/pull/22447) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Fix Fedora\RHEL\CentOS not finding libclang_rt.builtins on ppc64le ... [#22458](https://github.com/ClickHouse/ClickHouse/pull/22458) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Fix CMake error about internal CMake variable CMAKE_ASM_COMPILE_OBJECT not set on ppc64le ... [#22469](https://github.com/ClickHouse/ClickHouse/pull/22469) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Fix compiling boost on ppc64le ... [#22474](https://github.com/ClickHouse/ClickHouse/pull/22474) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Enable compiling on ppc64le with Clang ... [#22476](https://github.com/ClickHouse/ClickHouse/pull/22476) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Re-enable the S3 (AWS) library on aarch64 ... [#22484](https://github.com/ClickHouse/ClickHouse/pull/22484) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Enable the bundled openldap on ppc64le ... [#22487](https://github.com/ClickHouse/ClickHouse/pull/22487) ([Kfir Itzhak](https://github.com/mastertheknife)).

#### Other
* Update tests for hedged requests. [#21998](https://github.com/ClickHouse/ClickHouse/pull/21998) ([Kruglov Pavel](https://github.com/Avogar)).
* Don't set the same timeouts in ReadBufferFromPocoSocket/WriteBufferFromPocoSocket in nextImpl because it causes a race. [#22343](https://github.com/ClickHouse/ClickHouse/pull/22343) ([Kruglov Pavel](https://github.com/Avogar)).

#### NO CL ENTRY

* NO CL ENTRY:  'Improve the translation of `query_log.md` in Chinese documents'. [#21729](https://github.com/ClickHouse/ClickHouse/pull/21729) ([Pysaoke](https://github.com/baixuexue123)).
* NO CL ENTRY:  'Update gui.md: add SeekTable'. [#21768](https://github.com/ClickHouse/ClickHouse/pull/21768) ([Vitaliy Fedorchenko](https://github.com/VitaliyMF)).
* NO CL ENTRY:  'Flatten libcpuid PEERDIRs'. [#22078](https://github.com/ClickHouse/ClickHouse/pull/22078) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* NO CL ENTRY:  'Revert "quick fix for broken resolution of apt.llvm.org on Yandex infra"'. [#22374](https://github.com/ClickHouse/ClickHouse/pull/22374) ([alesapin](https://github.com/alesapin)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Add soft task timeout for Intergation tests [#16608](https://github.com/ClickHouse/ClickHouse/pull/16608) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Merging geometry functions [#19257](https://github.com/ClickHouse/ClickHouse/pull/19257) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Remove outdated suppressions, part 2 [#19496](https://github.com/ClickHouse/ClickHouse/pull/19496) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Move some CI-related scripts to github [#20946](https://github.com/ClickHouse/ClickHouse/pull/20946) ([Alexander Tokmakov](https://github.com/tavplubix)).
* fix [#21170](https://github.com/ClickHouse/ClickHouse/issues/21170) [#21182](https://github.com/ClickHouse/ClickHouse/pull/21182) ([Tachikoma](https://github.com/ikarishinjieva)).
* Add more tests for quota consumption by the SHOW statement [#21190](https://github.com/ClickHouse/ClickHouse/pull/21190) ([Vitaly Baranov](https://github.com/vitlibar)).
* Save packed keys for GROUP BY with multiple fixed size keys [#21196](https://github.com/ClickHouse/ClickHouse/pull/21196) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Refine MergeTreeData::loadDataParts to not parse format version file and detached directory [#21351](https://github.com/ClickHouse/ClickHouse/pull/21351) ([Fuwang Hu](https://github.com/fuwhu)).
* Persistent nukeeper snapshot storage [#21425](https://github.com/ClickHouse/ClickHouse/pull/21425) ([alesapin](https://github.com/alesapin)).
* Fix logging for optimize_aggregation_in_order=1 (with small max_block_size) [#21436](https://github.com/ClickHouse/ClickHouse/pull/21436) ([Azat Khuzhin](https://github.com/azat)).
* Adjust prewhere_with_row_level_filter performance test [#21442](https://github.com/ClickHouse/ClickHouse/pull/21442) ([Denis Glazachev](https://github.com/traceon)).
* Refactor actions dag [#21459](https://github.com/ClickHouse/ClickHouse/pull/21459) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* add query formatting idempotence check to fuzzer [#21466](https://github.com/ClickHouse/ClickHouse/pull/21466) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix heap-buffer-overflow in highlighting multi-line comments [#21492](https://github.com/ClickHouse/ClickHouse/pull/21492) ([Azat Khuzhin](https://github.com/azat)).
* Fix global stop merges in test [#21508](https://github.com/ClickHouse/ClickHouse/pull/21508) ([alesapin](https://github.com/alesapin)).
* DirectDictionary updated [#21513](https://github.com/ClickHouse/ClickHouse/pull/21513) ([Maksim Kita](https://github.com/kitaisreal)).
* Avoid processing optimize_skip_unused_shards twice [#21526](https://github.com/ClickHouse/ClickHouse/pull/21526) ([Azat Khuzhin](https://github.com/azat)).
* DOCSUP-7197: Escaped Unicode replaced with symbols [#21530](https://github.com/ClickHouse/ClickHouse/pull/21530) ([lehasm](https://github.com/lehasm)).
* Pod array left pad not multiple of element crash fix [#21532](https://github.com/ClickHouse/ClickHouse/pull/21532) ([Maksim Kita](https://github.com/kitaisreal)).
* ShellCommand waitpid eintr signal fix [#21546](https://github.com/ClickHouse/ClickHouse/pull/21546) ([Maksim Kita](https://github.com/kitaisreal)).
* Refactoring of data types serialization [#21562](https://github.com/ClickHouse/ClickHouse/pull/21562) ([Anton Popov](https://github.com/CurtizJ)).
* fix a typo in window functions frame [#21572](https://github.com/ClickHouse/ClickHouse/pull/21572) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Added specialized CacheDictionaryStorage [#21573](https://github.com/ClickHouse/ClickHouse/pull/21573) ([Maksim Kita](https://github.com/kitaisreal)).
* [RFC] Union merge for arcadia_skip_list.txt to avoid frequent conflicts [#21580](https://github.com/ClickHouse/ClickHouse/pull/21580) ([Azat Khuzhin](https://github.com/azat)).
* Enable ipv6 in NuRaft [#21593](https://github.com/ClickHouse/ClickHouse/pull/21593) ([alesapin](https://github.com/alesapin)).
* add an article about ast-based fuzzer [#21608](https://github.com/ClickHouse/ClickHouse/pull/21608) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Changelog 21.3 [#21618](https://github.com/ClickHouse/ClickHouse/pull/21618) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* redefine some errorcode [#21629](https://github.com/ClickHouse/ClickHouse/pull/21629) ([flynn](https://github.com/ucasfl)).
* Fix ambigous column error in joins_in_memory [#21658](https://github.com/ClickHouse/ClickHouse/pull/21658) ([Vladimir C](https://github.com/vdimir)).
* Add test for path as a query parameter in system.zookeeper [#21661](https://github.com/ClickHouse/ClickHouse/pull/21661) ([Kruglov Pavel](https://github.com/Avogar)).
* ExecutablePool fix default max execution time setting [#21662](https://github.com/ClickHouse/ClickHouse/pull/21662) ([Maksim Kita](https://github.com/kitaisreal)).
* DictionaryStructure fix non unique attribute names [#21668](https://github.com/ClickHouse/ClickHouse/pull/21668) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix flaky test_replace_partition [#21674](https://github.com/ClickHouse/ClickHouse/pull/21674) ([Azat Khuzhin](https://github.com/azat)).
* DOC Fix ORDER BY syntax [#21675](https://github.com/ClickHouse/ClickHouse/pull/21675) ([Michael Monashev](https://github.com/MichaelMonashev)).
* PODArray swap fix [#21678](https://github.com/ClickHouse/ClickHouse/pull/21678) ([Maksim Kita](https://github.com/kitaisreal)).
* LibraryDictionarySource fix possible leak [#21686](https://github.com/ClickHouse/ClickHouse/pull/21686) ([Maksim Kita](https://github.com/kitaisreal)).
* Run three nodes with Replicated database and NuKeeper in CI [#21690](https://github.com/ClickHouse/ClickHouse/pull/21690) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix error message in clickhouse-test [#21691](https://github.com/ClickHouse/ClickHouse/pull/21691) ([Azat Khuzhin](https://github.com/azat)).
* Set SOCK_CLOEXEC for sockets (hardcoded via poco update) [#21695](https://github.com/ClickHouse/ClickHouse/pull/21695) ([Azat Khuzhin](https://github.com/azat)).
* Tests fixes (that was found by stress tests) [#21696](https://github.com/ClickHouse/ClickHouse/pull/21696) ([Azat Khuzhin](https://github.com/azat)).
* Fix log_comment for *.sh in clickhouse-test [#21700](https://github.com/ClickHouse/ClickHouse/pull/21700) ([Azat Khuzhin](https://github.com/azat)).
* Remove useless CMake option [#21712](https://github.com/ClickHouse/ClickHouse/pull/21712) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in modulo by constant [#21713](https://github.com/ClickHouse/ClickHouse/pull/21713) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add more variants for memcpy benchmark [#21715](https://github.com/ClickHouse/ClickHouse/pull/21715) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not overlap zookeeper path for ReplicatedMergeTree in stateless *.sh tests [#21724](https://github.com/ClickHouse/ClickHouse/pull/21724) ([Azat Khuzhin](https://github.com/azat)).
* make the fuzzer use sources from the CI [#21754](https://github.com/ClickHouse/ClickHouse/pull/21754) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Add one more variant to memcpy benchmark [#21759](https://github.com/ClickHouse/ClickHouse/pull/21759) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* fix incorrect number of rows for Chunks with no columns in PartialSor... [#21761](https://github.com/ClickHouse/ClickHouse/pull/21761) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* docs(fix): typo [#21775](https://github.com/ClickHouse/ClickHouse/pull/21775) ([Ali Demirci](https://github.com/depyronick)).
* DDLWorker.cpp: fixed exceeded amount of tries typo [#21807](https://github.com/ClickHouse/ClickHouse/pull/21807) ([Eldar Nasyrov](https://github.com/3ldar-nasyrov)).
* fix integration MaterializeMySQL test [#21819](https://github.com/ClickHouse/ClickHouse/pull/21819) ([TCeason](https://github.com/TCeason)).
* more robust error handling in perf test [#21846](https://github.com/ClickHouse/ClickHouse/pull/21846) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* test for [#17302](https://github.com/ClickHouse/ClickHouse/issues/17302) [#21848](https://github.com/ClickHouse/ClickHouse/pull/21848) ([Denny Crane](https://github.com/den-crane)).
* Add bash completion support for clickhouse utils [#21853](https://github.com/ClickHouse/ClickHouse/pull/21853) ([Azat Khuzhin](https://github.com/azat)).
* LRUCache fix exception unsafe element insertion [#21891](https://github.com/ClickHouse/ClickHouse/pull/21891) ([Maksim Kita](https://github.com/kitaisreal)).
* fix fuzzer failure in tupleElement formatting [#21896](https://github.com/ClickHouse/ClickHouse/pull/21896) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix possibly dangling reference to Context [#21913](https://github.com/ClickHouse/ClickHouse/pull/21913) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add stress test for distributed queries [#21944](https://github.com/ClickHouse/ClickHouse/pull/21944) ([Azat Khuzhin](https://github.com/azat)).
* Fix misleading log in WriteBufferFromS3 [#21954](https://github.com/ClickHouse/ClickHouse/pull/21954) ([flynn](https://github.com/ucasfl)).
* Add a test for [#21991](https://github.com/ClickHouse/ClickHouse/issues/21991) [#21995](https://github.com/ClickHouse/ClickHouse/pull/21995) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#11720](https://github.com/ClickHouse/ClickHouse/issues/11720) [#21997](https://github.com/ClickHouse/ClickHouse/pull/21997) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#15784](https://github.com/ClickHouse/ClickHouse/issues/15784) [#22002](https://github.com/ClickHouse/ClickHouse/pull/22002) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* prevent accidental reinterpret_cast in Field::get<> [#22003](https://github.com/ClickHouse/ClickHouse/pull/22003) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix UBSan report in addMonths [#22006](https://github.com/ClickHouse/ClickHouse/pull/22006) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#7963](https://github.com/ClickHouse/ClickHouse/issues/7963) [#22007](https://github.com/ClickHouse/ClickHouse/pull/22007) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in intDiv [#21769](https://github.com/ClickHouse/ClickHouse/issues/21769) [#22009](https://github.com/ClickHouse/ClickHouse/pull/22009) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cast to enum nullable fix [#22026](https://github.com/ClickHouse/ClickHouse/pull/22026) ([Maksim Kita](https://github.com/kitaisreal)).
* Small simplification in ExternalLoader. [#22027](https://github.com/ClickHouse/ClickHouse/pull/22027) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add test for [#21760](https://github.com/ClickHouse/ClickHouse/issues/21760) [#22036](https://github.com/ClickHouse/ClickHouse/pull/22036) ([Anton Popov](https://github.com/CurtizJ)).
* quick fix for broken resolution of apt.llvm.org on Yandex infra [#22055](https://github.com/ClickHouse/ClickHouse/pull/22055) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Darwin cmake disable memcpy benchmark [#22056](https://github.com/ClickHouse/ClickHouse/pull/22056) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix UBSan report in TransformDateTime64 [#22062](https://github.com/ClickHouse/ClickHouse/pull/22062) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in mapPopulateSeries. [#22099](https://github.com/ClickHouse/ClickHouse/pull/22099) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bar with invalid float value [#22114](https://github.com/ClickHouse/ClickHouse/pull/22114) ([flynn](https://github.com/ucasfl)).
* remove useless code [#22117](https://github.com/ClickHouse/ClickHouse/pull/22117) ([flynn](https://github.com/ucasfl)).
* stable formatting for negate() [#22133](https://github.com/ClickHouse/ClickHouse/pull/22133) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* adjust perf test thresholds [#22148](https://github.com/ClickHouse/ClickHouse/pull/22148) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix sleep_in_send_tables_status_ms/sleep_in_send_data_ms in integration tests [#22151](https://github.com/ClickHouse/ClickHouse/pull/22151) ([Azat Khuzhin](https://github.com/azat)).
* Update requirements.txt [#22153](https://github.com/ClickHouse/ClickHouse/pull/22153) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix some flaky order dependent integration tests. [#22170](https://github.com/ClickHouse/ClickHouse/pull/22170) ([alesapin](https://github.com/alesapin)).
* Prevent busy waiting in hedged requests when async_socket_for_remote=0 [#22172](https://github.com/ClickHouse/ClickHouse/pull/22172) ([Kruglov Pavel](https://github.com/Avogar)).
* less flaky functional tests [#22181](https://github.com/ClickHouse/ClickHouse/pull/22181) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* test for [#10489](https://github.com/ClickHouse/ClickHouse/issues/10489) [#22219](https://github.com/ClickHouse/ClickHouse/pull/22219) ([Denny Crane](https://github.com/den-crane)).
* CachedCompressedReadBuffer fix cache usage [#22225](https://github.com/ClickHouse/ClickHouse/pull/22225) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix MSan report in `quantileDeterministic` [#22235](https://github.com/ClickHouse/ClickHouse/pull/22235) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove harmful default parameters [#22238](https://github.com/ClickHouse/ClickHouse/pull/22238) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build error [#22243](https://github.com/ClickHouse/ClickHouse/pull/22243) ([hexiaoting](https://github.com/hexiaoting)).
* Rename NuKeeper and TestKeeper to Keeper in all places [#22274](https://github.com/ClickHouse/ClickHouse/pull/22274) ([alesapin](https://github.com/alesapin)).
* Update materialize-mysql.md [#22275](https://github.com/ClickHouse/ClickHouse/pull/22275) ([曲正鹏](https://github.com/quzhengpeng)).
* Fix native macOS build for ALL_BUILD (Xcode/AppleClang) [#22289](https://github.com/ClickHouse/ClickHouse/pull/22289) ([Denis Glazachev](https://github.com/traceon)).
* Add suffixes for dockerfile arguments [#22301](https://github.com/ClickHouse/ClickHouse/pull/22301) ([filimonov](https://github.com/filimonov)).
* More coarse test for DateLUT [#22320](https://github.com/ClickHouse/ClickHouse/pull/22320) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless code [#22328](https://github.com/ClickHouse/ClickHouse/pull/22328) ([Anton Popov](https://github.com/CurtizJ)).
* Maybe fix false MSan report in GRPC [#22338](https://github.com/ClickHouse/ClickHouse/pull/22338) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove old MSan suppressions (part 3) [#22357](https://github.com/ClickHouse/ClickHouse/pull/22357) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove old MSan suppressions (part 4) [#22358](https://github.com/ClickHouse/ClickHouse/pull/22358) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky tests test_row_policy* and test_quota* [#22371](https://github.com/ClickHouse/ClickHouse/pull/22371) ([Vitaly Baranov](https://github.com/vitlibar)).
* Try fix flaky rabbitmq test [#22380](https://github.com/ClickHouse/ClickHouse/pull/22380) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix UBSan report in mapOp [#22389](https://github.com/ClickHouse/ClickHouse/pull/22389) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove recursive submodules from Arrow [#22390](https://github.com/ClickHouse/ClickHouse/pull/22390) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix some OOMs in stress tests [#22396](https://github.com/ClickHouse/ClickHouse/pull/22396) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Correctly place debug helpers [#22407](https://github.com/ClickHouse/ClickHouse/pull/22407) ([Amos Bird](https://github.com/amosbird)).
* fix error message for invalid window frame start [#22412](https://github.com/ClickHouse/ClickHouse/pull/22412) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix flapping test_s3_zero_copy_replication [#22440](https://github.com/ClickHouse/ClickHouse/pull/22440) ([ianton-ru](https://github.com/ianton-ru)).
* Lower scale of a test [#22446](https://github.com/ClickHouse/ClickHouse/pull/22446) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Adjust Keeper settings for CI [#22470](https://github.com/ClickHouse/ClickHouse/pull/22470) ([Alexander Tokmakov](https://github.com/tavplubix)).
* try clang 11 in fast test [#22472](https://github.com/ClickHouse/ClickHouse/pull/22472) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove TestFlows (2) [#22480](https://github.com/ClickHouse/ClickHouse/pull/22480) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature (datasketches support in clickhouse #14893)

* Support ThetaSketch to do set operations. [#22207](https://github.com/ClickHouse/ClickHouse/pull/22207) ([Ping Yu](https://github.com/pingyu)).
