SET query_plan_use_new_logical_join_step = 0;
SET enable_analyzer = 1;

DROP TABLE IF EXISTS t1;
DROP TABLE IF EXISTS t2;
DROP TABLE IF EXISTS t3;
DROP TABLE IF EXISTS t4;

CREATE TABLE t1 (x Int8) ENGINE = Memory;
INSERT INTO t1 VALUES (1);
CREATE TABLE t2 (x UInt8) ENGINE = Memory;
INSERT INTO t2 VALUES (1);
CREATE TABLE t3 (x UInt16) ENGINE = Memory;
INSERT INTO t3 VALUES (1);
CREATE TABLE t4 (x UInt32) ENGINE = Memory;
INSERT INTO t4 VALUES (1);

SELECT coalesce(t1.x, t2.x, t3.x, t4.x) AS x
FROM t1
FULL OUTER JOIN t2 USING (x)
FULL OUTER JOIN t3 USING (x)
FULL OUTER JOIN t4 USING (x)
;

SELECT 1 as x
FROM t1
FULL OUTER JOIN t2 USING (x)
FULL OUTER JOIN t3 USING (x)
FULL OUTER JOIN t4 USING (x)
;

SELECT 1 as x
FROM t1
RIGHT OUTER JOIN t2 USING (x)
RIGHT OUTER JOIN t3 USING (x)
RIGHT OUTER JOIN t4 USING (x)
;

SELECT 1 as x
FROM t1
LEFT OUTER JOIN t2 USING (x)
LEFT OUTER JOIN t3 USING (x)
LEFT OUTER JOIN t4 USING (x)
;


SELECT 1 as x
FROM t1
RIGHT OUTER JOIN t2 USING (x)
FULL OUTER JOIN t3 USING (x)
INNER JOIN t4 USING (x)
;
