SET allow_experimental_qbit_type = 1;

SELECT 'Test QBit subcolumns: corner cases';
DROP TABLE IF EXISTS qbit;
CREATE TABLE qbit (id UInt32, vec QBit(BFloat16, 3)) ENGINE = Memory;

INSERT INTO qbit VALUES (1, [-1.70141183460469231731687e+38, -1.70141183460469231731687e+38, -1.70141183460469231731687e+38]);
INSERT INTO qbit VALUES (2, [-1.70141183460469231731687e+38, -1.70141183460469231731687e+38, -1.70141183460469231731687e+38]);
INSERT INTO qbit VALUES (3, [-1.70141183460469231731687e+38, -1.70141183460469231731687e+38, -1.70141183460469231731687e+38]);

select vec.0 from qbit; -- { serverError NOT_FOUND_COLUMN_IN_BLOCK }
select vec.17 from qbit; -- { serverError NOT_FOUND_COLUMN_IN_BLOCK }
select bin(vec.1) from qbit;
select bin(vec.4) from qbit;
select bin(vec.15) from qbit;
select bin(vec.16) from qbit;



SELECT 'Test QBit subcolumns: BFloat16';
DROP TABLE IF EXISTS qbit;
CREATE TABLE qbit (id UInt32, vec QBit(BFloat16, 8)) ENGINE = Memory;

INSERT INTO qbit VALUES (1, [14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.04941266465394433815561e-13]);
INSERT INTO qbit VALUES (2, [14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13]);
INSERT INTO qbit VALUES (3, [2, 0, 0, 0, 0, 0, 0, 0]);
INSERT INTO qbit VALUES (4, [-0, 0, 0, 0, 0, 0, 0, 0]);

SELECT bin(vec.1) FROM qbit ORDER BY id;
SELECT bin(vec.2) FROM qbit ORDER BY id;
SELECT bin(vec.7) FROM qbit ORDER BY id;
SELECT bin(vec.15) FROM qbit ORDER BY id;



SELECT 'Test QBit subcolumns: Float32';
DROP TABLE IF EXISTS qbit;
CREATE TABLE qbit (id UInt32, vec QBit(Float32, 8)) ENGINE = Memory;

INSERT INTO qbit VALUES (1, [14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.04941266465394433815561e-13]);
INSERT INTO qbit VALUES (2, [14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13, 14660154687488, -3.03164882520939871213272e-13]);
INSERT INTO qbit VALUES (3, [2, 0, 0, 0, 0, 0, 0, 0]);
INSERT INTO qbit VALUES (4, [-0, 0, 0, 0, 0, 0, 0, 0]);

SELECT bin(vec.1) FROM qbit ORDER BY id;
SELECT bin(vec.2) FROM qbit ORDER BY id;
SELECT bin(vec.7) FROM qbit ORDER BY id;
SELECT bin(vec.15) FROM qbit ORDER BY id;
SELECT bin(vec.23) FROM qbit ORDER BY id;
SELECT bin(vec.31) FROM qbit ORDER BY id;



SELECT 'Test QBit subcolumns: Float64';
DROP TABLE IF EXISTS qbit;
CREATE TABLE qbit (id UInt32, vec QBit(Float64, 8)) ENGINE = Memory;

INSERT INTO qbit VALUES (1, [1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103]);
INSERT INTO qbit VALUES (2, [1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103, 1.19453052916149551265420436166e103, -3.7206620809969885439391603375e-103]);
INSERT INTO qbit VALUES (3, [2, 0, 0, 0, 0, 0, 0, 0]);
INSERT INTO qbit VALUES (4, [-0, 0, 0, 0, 0, 0, 0, 0]);

SELECT bin(vec.1) FROM qbit ORDER BY id;
SELECT bin(vec.2) FROM qbit ORDER BY id;
SELECT bin(vec.7) FROM qbit ORDER BY id;
SELECT bin(vec.15) FROM qbit ORDER BY id;
SELECT bin(vec.23) FROM qbit ORDER BY id;
SELECT bin(vec.31) FROM qbit ORDER BY id;
SELECT bin(vec.39) FROM qbit ORDER BY id;
SELECT bin(vec.47) FROM qbit ORDER BY id;
SELECT bin(vec.55) FROM qbit ORDER BY id;
SELECT bin(vec.63) FROM qbit ORDER BY id;
