#!/usr/bin/env bash

CURDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
# shellcheck source=../shell_config.sh
. "$CURDIR"/../shell_config.sh

$CLICKHOUSE_CLIENT -q "drop table if exists test"
$CLICKHOUSE_CLIENT --allow_experimental_dynamic_type=1 -q "create table test (id UInt64, d Dynamic(max_types=254)) engine=Memory"

$CLICKHOUSE_CLIENT -q "insert into test select 0, NULL"
$CLICKHOUSE_CLIENT -q "insert into test select 1, materialize(42)::UInt8"
$CLICKHOUSE_CLIENT -q "insert into test select 2, materialize(-42)::Int8"
$CLICKHOUSE_CLIENT -q "insert into test select 3, materialize(42)::UInt16"
$CLICKHOUSE_CLIENT -q "insert into test select 4, materialize(-42)::Int16"
$CLICKHOUSE_CLIENT -q "insert into test select 5, materialize(42)::UInt32"
$CLICKHOUSE_CLIENT -q "insert into test select 6, materialize(-42)::Int32"
$CLICKHOUSE_CLIENT -q "insert into test select 7, materialize(42)::UInt64"
$CLICKHOUSE_CLIENT -q "insert into test select 8, materialize(-42)::Int64"
$CLICKHOUSE_CLIENT -q "insert into test select 9, materialize(42)::UInt128"
$CLICKHOUSE_CLIENT -q "insert into test select 10, materialize(-42)::Int128"
$CLICKHOUSE_CLIENT -q "insert into test select 11, materialize(42)::UInt256"
$CLICKHOUSE_CLIENT -q "insert into test select 12, materialize(-42)::Int256"
$CLICKHOUSE_CLIENT -q "insert into test select 13, materialize(42.42)::Float32"
$CLICKHOUSE_CLIENT -q "insert into test select 14, materialize(42.42)::Float64"
$CLICKHOUSE_CLIENT -q "insert into test select 15, materialize('2020-01-01')::Date"
$CLICKHOUSE_CLIENT -q "insert into test select 16, materialize('2020-01-01')::Date32"
$CLICKHOUSE_CLIENT -q "insert into test select 17, materialize('2020-01-01 00:00:00')::DateTime('EST')"
$CLICKHOUSE_CLIENT -q "insert into test select 18, materialize('2020-01-01 00:00:00')::DateTime('CET')"
$CLICKHOUSE_CLIENT -q "insert into test select 19, materialize('2020-01-01 00:00:00.000000')::DateTime64(6, 'EST')"
$CLICKHOUSE_CLIENT -q "insert into test select 20, materialize('2020-01-01 00:00:00.000000')::DateTime64(6, 'CET')"
$CLICKHOUSE_CLIENT -q "insert into test select 21, materialize('Hello, World!')"
$CLICKHOUSE_CLIENT -q "insert into test select 22, materialize('aaaaa')::FixedString(5)"
$CLICKHOUSE_CLIENT -q "insert into test select 23, materialize('a')::Enum8('a' = 1, 'b' = 2, 'c' = -128)"
$CLICKHOUSE_CLIENT -q "insert into test select 24, materialize('a')::Enum16('a' = 1, 'b' = 2, 'c' = -1280)"
$CLICKHOUSE_CLIENT -q "insert into test select 25, materialize(42.42)::Decimal32(3)"
$CLICKHOUSE_CLIENT -q "insert into test select 26, materialize(42.42)::Decimal64(3)"
$CLICKHOUSE_CLIENT -q "insert into test select 27, materialize(42.42)::Decimal128(3)"
$CLICKHOUSE_CLIENT -q "insert into test select 28, materialize(42.42)::Decimal256(3)"
$CLICKHOUSE_CLIENT -q "insert into test select 29, materialize('984ac60f-4d08-4ef1-9c62-d82f343fbc90')::UUID"
$CLICKHOUSE_CLIENT -q "insert into test select 30, materialize([1, 2, 3])::Array(UInt64)"
$CLICKHOUSE_CLIENT -q "insert into test select 31, materialize([[[1], [2]], [[3, 4, 5]]])::Array(Array(Array(UInt64)))"
$CLICKHOUSE_CLIENT -q "insert into test select 32, materialize(tuple(1, 'str', 42.42))::Tuple(UInt32, String, Float32)"
$CLICKHOUSE_CLIENT -q "insert into test select 33, materialize(tuple(1, 'str', 42.42))::Tuple(a UInt32, b String, c Float32)"
$CLICKHOUSE_CLIENT -q "insert into test select 34, materialize(tuple(1, tuple('str', tuple(42.42, -30))))::Tuple(UInt32, Tuple(String, Tuple(Float32, Int8)))"
$CLICKHOUSE_CLIENT -q "insert into test select 35, materialize(tuple(1, tuple('str', tuple(42.42, -30))))::Tuple(a UInt32, b Tuple(c String, d Tuple(e Float32, f Int8)))"
$CLICKHOUSE_CLIENT -q "insert into test select 36, quantileState(0.5)(42::UInt64)"
$CLICKHOUSE_CLIENT -q "insert into test select 37, sumSimpleState(42::UInt64)"
$CLICKHOUSE_CLIENT -q "insert into test select 38, toLowCardinality('Hello, World!')"
$CLICKHOUSE_CLIENT -q "insert into test select 39, materialize(map(1, 'str1', 2, 'str2'))::Map(UInt64, String)"
$CLICKHOUSE_CLIENT -q "insert into test select 40, materialize(map(1, map(1, map(1, 'str1')), 2, map(2, map(2, 'str2'))))::Map(UInt64, Map(UInt64, Map(UInt64, String)))"
$CLICKHOUSE_CLIENT -q "insert into test select 41, materialize('127.0.0.0')::IPv4"
$CLICKHOUSE_CLIENT -q "insert into test select 42, materialize('2001:db8:cafe:1:0:0:0:1')::IPv6"
$CLICKHOUSE_CLIENT -q "insert into test select 43, materialize(true)::Bool"
$CLICKHOUSE_CLIENT -q "insert into test select 44, materialize([tuple(1, 2), tuple(3, 4)])::Nested(a UInt32, b UInt32)"
$CLICKHOUSE_CLIENT -q "insert into test select 45, materialize([(0, 0), (10, 0), (10, 10), (0, 10)])::Ring"
$CLICKHOUSE_CLIENT -q "insert into test select 46, materialize((0, 0))::Point"
$CLICKHOUSE_CLIENT -q "insert into test select 47, materialize([[(20, 20), (50, 20), (50, 50), (20, 50)], [(30, 30), (50, 50), (50, 30)]])::Polygon"
$CLICKHOUSE_CLIENT -q "insert into test select 48, materialize([[[(0, 0), (10, 0), (10, 10), (0, 10)]], [[(20, 20), (50, 20), (50, 50), (20, 50)],[(30, 30), (50, 50), (50, 30)]]])::MultiPolygon"
$CLICKHOUSE_CLIENT -q "insert into test select 49, materialize([map(42, tuple(1, [tuple(2, map(1, 2))]))])"

$CLICKHOUSE_CLIENT -q "select * from test format RowBinary" | $CLICKHOUSE_LOCAL --allow_experimental_dynamic_type=1 --input-format RowBinary --structure 'id UInt64, d Dynamic(max_types=254)' -q "select d, dynamicType(d) from table order by id"
$CLICKHOUSE_CLIENT -q "drop table test"

