-- Tags: no-random-settings, no-random-merge-tree-settings

DROP TABLE IF EXISTS account_test;

CREATE TABLE account_test
(
    `id` UInt64,
    `row_ver` UInt64,
)
ENGINE = ReplacingMergeTree(row_ver)
ORDER BY id
SETTINGS index_granularity = 16, index_granularity_bytes = 0,
         min_rows_for_wide_part = 0, min_bytes_for_wide_part = 0,
         min_rows_for_compact_part = 0, min_bytes_for_compact_part = 0;

SYSTEM STOP MERGES account_test;

INSERT INTO account_test VALUES (11338881281426660955,717769962224129342),(12484100559155738267,7950971667203174918),(7603729260199571867,3255798127676911942),(7023543111808724827,911615979861855126),(10293135086416484571,3264379259750736572),(15561193439904316763,8419819469587131454),(17632407413882870235,7252071832370181502),(17009726455991851227,7525297506591593939),(12392078953873778779,8473049173389293961),(15283366022689446555,11692491360262171467),(9087459014730986523,2783662960221838603),(293823584550906267,4847630088179732782),(15693186194430465755,8163804880526285623),(7353080168325584795,17315892478487497859),(5980311238303466523,6943353798059390089),(14242621660019578011,8684624667957352769),(8241843507567433563,15731952080102886438);
INSERT INTO account_test VALUES (11338881281426660955, 14765404159170880511);

SELECT 'Disabled', * FROM account_test FINAL WHERE id = 11338881281426660955 SETTINGS split_parts_ranges_into_intersecting_and_non_intersecting_final = 0;
SELECT 'Enabled', * FROM account_test FINAL WHERE id = 11338881281426660955 SETTINGS split_parts_ranges_into_intersecting_and_non_intersecting_final = 1;

