DROP TABLE IF EXISTS data_02716_1;
DROP TABLE IF EXISTS data_02716_2;
DROP TABLE IF EXISTS {CLICKHOUSE_DATABASE_1:Identifier}.data_02716_3;
DROP DATABASE IF EXISTS {CLICKHOUSE_DATABASE_1:Identifier};

CREATE TABLE data_02716_1 (v UInt64) ENGINE = MergeTree ORDER BY v;
CREATE TABLE data_02716_2 (v UInt64) ENGINE = MergeTree ORDER BY v;

CREATE DATABASE {CLICKHOUSE_DATABASE_1:Identifier};
CREATE TABLE {CLICKHOUSE_DATABASE_1:Identifier}.data_02716_3 (v UInt64) ENGINE = MergeTree ORDER BY v;

INSERT INTO data_02716_1 SELECT * FROM system.numbers LIMIT 1;

-- { echoOn }
DROP TABLE IF EMPTY data_02716_2;
DROP TABLE IF EMPTY data_02716_1; -- { serverError TABLE_NOT_EMPTY }
TRUNCATE TABLE data_02716_1;
DROP TABLE IF EMPTY data_02716_1;
DROP DATABASE IF EMPTY {CLICKHOUSE_DATABASE_1:Identifier}; -- { serverError NOT_IMPLEMENTED }

SELECT count() FROM system.tables WHERE database = {CLICKHOUSE_DATABASE_1:String};
SELECT count() FROM system.tables WHERE database = 'default' AND name IN ('data_02716_1', 'data_02716_2');
