#!/usr/bin/env bash
# Tags: no-parallel

CURDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
# shellcheck source=../shell_config.sh
. "$CURDIR"/../shell_config.sh

DATABASE='test_02177'
SESSION_ID="$RANDOM$RANDOM$RANDOM"

${CLICKHOUSE_CURL} -sS "${CLICKHOUSE_URL}" -d "DROP DATABASE IF EXISTS ${DATABASE}"
${CLICKHOUSE_CURL} -sS "${CLICKHOUSE_URL}" -d "CREATE DATABASE ${DATABASE}"

CLICKHOUSE_URL_PARAMS="database=${DATABASE}"
[ -v CLICKHOUSE_LOG_COMMENT ] && CLICKHOUSE_URL_PARAMS="${CLICKHOUSE_URL_PARAMS}&log_comment=${CLICKHOUSE_LOG_COMMENT}"
CLICKHOUSE_URL="${CLICKHOUSE_PORT_HTTP_PROTO}://${CLICKHOUSE_HOST}:${CLICKHOUSE_PORT_HTTP}/?${CLICKHOUSE_URL_PARAMS}"

${CLICKHOUSE_CURL} -sS "${CLICKHOUSE_URL}&session_id=${SESSION_ID}" -d 'CREATE TEMPORARY TABLE t AS SELECT currentDatabase()'
${CLICKHOUSE_CURL} -sS "${CLICKHOUSE_URL}&session_id=${SESSION_ID}" -d 'SELECT * FROM t'

${CLICKHOUSE_CURL} -sS "${CLICKHOUSE_URL}" -d "DROP DATABASE ${DATABASE}"
