SELECT
    extractURLParameters('http://bigmir.net/?a=b&c=d'),
    extractURLParameters('http://bigmir.net/?a=b&c=d#e=f'),
    extractURLParameters('http://bigmir.net/?a&c=d#e=f'),
    extractURLParameters('http://bigmir.net/?a=b&c=d#e=f&g=h'),
    extractURLParameters('http://bigmir.net/?a=b&c=d#e'),
    extractURLParameters('http://bigmir.net/?a=b&c=d#e&g=h'),
    extractURLParameters('http://bigmir.net/?a=b&c=d#test?e=f&g=h'),
    extractURLParameters('//bigmir.net/?a=b&c=d'),
    extractURLParameters('//bigmir.net/?a=b&c=d#e=f'),
    extractURLParameters('//bigmir.net/?a&c=d#e=f'),
    extractURLParameters('//bigmir.net/?a=b&c=d#e=f&g=h'),
    extractURLParameters('//bigmir.net/?a=b&c=d#e'),
    extractURLParameters('//bigmir.net/?a=b&c=d#e&g=h'),
    extractURLParameters('//bigmir.net/?a=b&c=d#test?e=f&g=h');

SELECT
    extractURLParameterNames('http://bigmir.net/?a=b&c=d'),
    extractURLParameterNames('http://bigmir.net/?a=b&c=d#e=f'),
    extractURLParameterNames('http://bigmir.net/?a&c=d#e=f'),
    extractURLParameterNames('http://bigmir.net/?a=b&c=d#e=f&g=h'),
    extractURLParameterNames('http://bigmir.net/?a=b&c=d#e'),
    extractURLParameterNames('http://bigmir.net/?a=b&c=d#e&g=h'),
    extractURLParameterNames('http://bigmir.net/?a=b&c=d#test?e=f&g=h'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d#e=f'),
    extractURLParameterNames('//bigmir.net/?a&c=d#e=f'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d#e=f&g=h'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d#e'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d#e&g=h'),
    extractURLParameterNames('//bigmir.net/?a=b&c=d#test?e=f&g=h');

SELECT
    extractURLParameter('http://bigmir.net/?a=b&c=d', 'a'),
    extractURLParameter('http://bigmir.net/?a=b&c=d', 'c'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e=f', 'e'),
    extractURLParameter('http://bigmir.net/?a&c=d#e=f', 'a'),
    extractURLParameter('http://bigmir.net/?a&c=d#e=f', 'c'),
    extractURLParameter('http://bigmir.net/?a&c=d#e=f', 'e'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e=f&g=h', 'g'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e', 'a'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e', 'c'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e', 'e'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'c'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'e'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'g'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'test'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'e'),
    extractURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'g'),
    extractURLParameter('//bigmir.net/?a=b&c=d', 'a'),
    extractURLParameter('//bigmir.net/?a=b&c=d', 'c'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e=f', 'e'),
    extractURLParameter('//bigmir.net/?a&c=d#e=f', 'a'),
    extractURLParameter('//bigmir.net/?a&c=d#e=f', 'c'),
    extractURLParameter('//bigmir.net/?a&c=d#e=f', 'e'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e=f&g=h', 'g'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e', 'a'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e', 'c'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e', 'e'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'c'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'e'),
    extractURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'g'),
    extractURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'test'),
    extractURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'e'),
    extractURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'g');

SELECT
    cutURLParameter('http://bigmir.net/?a=b&c=d', 'a'),
    cutURLParameter('http://bigmir.net/?a=b&c=d', 'c'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e=f', 'e'),
    cutURLParameter('http://bigmir.net/?a&c=d#e=f', 'a'),
    cutURLParameter('http://bigmir.net/?a&c=d#e=f', 'c'),
    cutURLParameter('http://bigmir.net/?a&c=d#e=f', 'e'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e=f&g=h', 'g'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e', 'a'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e', 'c'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e', 'e'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'c'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'e'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#e&g=h', 'g'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'test'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'e'),
    cutURLParameter('http://bigmir.net/?a=b&c=d#test?e=f&g=h', 'g'),
    cutURLParameter('//bigmir.net/?a=b&c=d', 'a'),
    cutURLParameter('//bigmir.net/?a=b&c=d', 'c'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e=f', 'e'),
    cutURLParameter('//bigmir.net/?a&c=d#e=f', 'a'),
    cutURLParameter('//bigmir.net/?a&c=d#e=f', 'c'),
    cutURLParameter('//bigmir.net/?a&c=d#e=f', 'e'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e=f&g=h', 'g'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e', 'a'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e', 'c'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e', 'e'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'c'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'e'),
    cutURLParameter('//bigmir.net/?a=b&c=d#e&g=h', 'g'),
    cutURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'test'),
    cutURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'e'),
    cutURLParameter('//bigmir.net/?a=b&c=d#test?e=f&g=h', 'g');


SELECT
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d')),
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d#e=f')),
    extractURLParameters(materialize('http://bigmir.net/?a&c=d#e=f')),
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d#e=f&g=h')),
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d#e')),
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d#e&g=h')),
    extractURLParameters(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d#e=f')),
    extractURLParameters(materialize('//bigmir.net/?a&c=d#e=f')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d#e=f&g=h')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d#e')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d#e&g=h')),
    extractURLParameters(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'));

SELECT
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d')),
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d#e=f')),
    extractURLParameterNames(materialize('http://bigmir.net/?a&c=d#e=f')),
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d#e=f&g=h')),
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d#e')),
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d#e&g=h')),
    extractURLParameterNames(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d#e=f')),
    extractURLParameterNames(materialize('//bigmir.net/?a&c=d#e=f')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d#e=f&g=h')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d#e')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d#e&g=h')),
    extractURLParameterNames(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'));

SELECT
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d'), 'a'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d'), 'c'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e=f'), 'e'),
    extractURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'a'),
    extractURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'c'),
    extractURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'e'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e=f&g=h'), 'g'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'a'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'c'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'e'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'c'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'e'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'g'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'test'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'e'),
    extractURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'g'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d'), 'a'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d'), 'c'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e=f'), 'e'),
    extractURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'a'),
    extractURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'c'),
    extractURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'e'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e=f&g=h'), 'g'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'a'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'c'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'e'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'c'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'e'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'g'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'test'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'e'),
    extractURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'g');

SELECT
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d'), 'a'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d'), 'c'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e=f'), 'e'),
    cutURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'a'),
    cutURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'c'),
    cutURLParameter(materialize('http://bigmir.net/?a&c=d#e=f'), 'e'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e=f&g=h'), 'g'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'a'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'c'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e'), 'e'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'c'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'e'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#e&g=h'), 'g'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'test'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'e'),
    cutURLParameter(materialize('http://bigmir.net/?a=b&c=d#test?e=f&g=h'), 'g'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d'), 'a'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d'), 'c'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e=f'), 'e'),
    cutURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'a'),
    cutURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'c'),
    cutURLParameter(materialize('//bigmir.net/?a&c=d#e=f'), 'e'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e=f&g=h'), 'g'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'a'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'c'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e'), 'e'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'c'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'e'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#e&g=h'), 'g'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'test'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'e'),
    cutURLParameter(materialize('//bigmir.net/?a=b&c=d#test?e=f&g=h'), 'g');
