---
description: 'Documentation for Tuple functions'
sidebar_label: 'Tuples'
slug: /sql-reference/functions/tuple-functions
title: 'Tuple functions'
doc_type: 'reference'
---

:::note
The documentation below is generated from the `system.functions` system table.
:::

<!-- 
The inner content of the tags below are replaced at doc framework build time with 
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

## untuple {#untuple}

Performs syntactic substitution of [tuple](/sql-reference/data-types/tuple) elements in the call location.

The names of the result columns are implementation-specific and subject to change. Do not assume specific column names after `untuple`.

**Syntax**

```sql
untuple(x)
```

You can use the `EXCEPT` expression to skip columns as a result of the query.

**Arguments**

- `x` — A `tuple` function, column, or tuple of elements. [Tuple](../data-types/tuple.md).

**Returned value**

- None.

**Examples**

Input table:

```text
┌─key─┬─v1─┬─v2─┬─v3─┬─v4─┬─v5─┬─v6────────┐
│   1 │ 10 │ 20 │ 40 │ 30 │ 15 │ (33,'ab') │
│   2 │ 25 │ 65 │ 70 │ 40 │  6 │ (44,'cd') │
│   3 │ 57 │ 30 │ 20 │ 10 │  5 │ (55,'ef') │
│   4 │ 55 │ 12 │  7 │ 80 │ 90 │ (66,'gh') │
│   5 │ 30 │ 50 │ 70 │ 25 │ 55 │ (77,'kl') │
└─────┴────┴────┴────┴────┴────┴───────────┘
```

Example of using a `Tuple`-type column as the `untuple` function parameter:

Query:

```sql
SELECT untuple(v6) FROM kv;
```

Result:

```text
┌─_ut_1─┬─_ut_2─┐
│    33 │ ab    │
│    44 │ cd    │
│    55 │ ef    │
│    66 │ gh    │
│    77 │ kl    │
└───────┴───────┘
```

Example of using an `EXCEPT` expression:

Query:

```sql
SELECT untuple((* EXCEPT (v2, v3),)) FROM kv;
```

Result:

```text
┌─key─┬─v1─┬─v4─┬─v5─┬─v6────────┐
│   1 │ 10 │ 30 │ 15 │ (33,'ab') │
│   2 │ 25 │ 40 │  6 │ (44,'cd') │
│   3 │ 57 │ 10 │  5 │ (55,'ef') │
│   4 │ 55 │ 80 │ 90 │ (66,'gh') │
│   5 │ 30 │ 25 │ 55 │ (77,'kl') │
└─────┴────┴────┴────┴───────────┘
```

## Distance functions {#distance-functions}

All supported functions are described in [distance functions documentation](../../sql-reference/functions/distance-functions.md).
