---
description: 'Documentation for functions used to generate random numbers'
sidebar_label: 'Random number'
slug: /sql-reference/functions/random-functions
title: 'Functions for generating random numbers'
doc_type: 'reference'
---

# Functions for generating random numbers

All functions in this section accept zero or one arguments. The only use of the argument (if provided) is to prevent [common subexpression
elimination](/sql-reference/functions/overview#common-subexpression-elimination) such that two different executions within a row of the same random
function return different random values.

Related content

- Guide: [Generating random data in ClickHouse](/guides/generating-test-data)
- Blog: [Generating random data in ClickHouse](https://clickhouse.com/blog/generating-random-test-distribution-data-for-clickhouse)

:::note
The random numbers are generated by non-cryptographic algorithms.
:::

:::note
The documentation below is generated from the `system.functions` system table.
:::

<!-- 
The inner content of the tags below are replaced at doc framework build time with 
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->
