---
description: 'Documentation for Hash Functions'
sidebar_label: 'Hash'
slug: /sql-reference/functions/hash-functions
title: 'Hash Functions'
doc_type: 'reference'
---

# Hash functions

Hash functions can be used for the deterministic pseudo-random shuffling of elements.

Simhash is a hash function, which returns close hash values for close (similar) arguments.

Most hash functions accept any number of arguments of any types.

:::note
Hash of NULL is NULL. To get a non-NULL hash of a Nullable column, wrap it in a tuple:
```sql
SELECT cityHash64(tuple(NULL))
```
:::

:::note
To calculate hash of the whole contents of a table, use `sum(cityHash64(tuple(*)))` (or other hash function). `tuple` ensures that rows with NULL values are not skipped. `sum` ensures that the order of rows doesn't matter.
:::

<!-- 
The inner content of the tags below are replaced at doc framework build time with 
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->