---
description: 'Returns the cumulative exponential decay over a time series at the index
  `t` in time.'
sidebar_position: 134
slug: /sql-reference/aggregate-functions/reference/exponentialTimeDecayedCount
title: 'exponentialTimeDecayedCount'
doc_type: 'reference'
---

## exponentialTimeDecayedCount {#exponentialtimedecayedcount}

Returns the cumulative exponential decay over a time series at the index `t` in time.

**Syntax**

```sql
exponentialTimeDecayedCount(x)(t)
```

**Arguments**

- `t` — Time. [Integer](../../../sql-reference/data-types/int-uint.md), [Float](../../../sql-reference/data-types/float.md) or [Decimal](../../../sql-reference/data-types/decimal.md), [DateTime](../../data-types/datetime.md), [DateTime64](../../data-types/datetime64.md).

**Parameters**

- `x` — Half-life period. [Integer](../../../sql-reference/data-types/int-uint.md), [Float](../../../sql-reference/data-types/float.md) or [Decimal](../../../sql-reference/data-types/decimal.md).

**Returned values**

- Returns the cumulative exponential decay at the given point in time. [Float64](../../data-types/float.md).

**Example**

Query:

```sql
SELECT
    value,
    time,
    round(exp_smooth, 3),
    bar(exp_smooth, 0, 20, 50) AS bar
FROM
(
    SELECT
        (number % 5) = 0 AS value,
        number AS time,
        exponentialTimeDecayedCount(10)(time) OVER (ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS exp_smooth
    FROM numbers(50)
);
```

Result:

```response
    ┌─value─┬─time─┬─round(exp_smooth, 3)─┬─bar────────────────────────┐
 1. │     1 │    0 │                    1 │ ██▌                        │
 2. │     0 │    1 │                1.905 │ ████▊                      │
 3. │     0 │    2 │                2.724 │ ██████▊                    │
 4. │     0 │    3 │                3.464 │ ████████▋                  │
 5. │     0 │    4 │                4.135 │ ██████████▎                │
 6. │     1 │    5 │                4.741 │ ███████████▊               │
 7. │     0 │    6 │                 5.29 │ █████████████▏             │
 8. │     0 │    7 │                5.787 │ ██████████████▍            │
 9. │     0 │    8 │                6.236 │ ███████████████▌           │
10. │     0 │    9 │                6.643 │ ████████████████▌          │
11. │     1 │   10 │                 7.01 │ █████████████████▌         │
12. │     0 │   11 │                7.343 │ ██████████████████▎        │
13. │     0 │   12 │                7.644 │ ███████████████████        │
14. │     0 │   13 │                7.917 │ ███████████████████▊       │
15. │     0 │   14 │                8.164 │ ████████████████████▍      │
16. │     1 │   15 │                8.387 │ ████████████████████▉      │
17. │     0 │   16 │                8.589 │ █████████████████████▍     │
18. │     0 │   17 │                8.771 │ █████████████████████▉     │
19. │     0 │   18 │                8.937 │ ██████████████████████▎    │
20. │     0 │   19 │                9.086 │ ██████████████████████▋    │
21. │     1 │   20 │                9.222 │ ███████████████████████    │
22. │     0 │   21 │                9.344 │ ███████████████████████▎   │
23. │     0 │   22 │                9.455 │ ███████████████████████▋   │
24. │     0 │   23 │                9.555 │ ███████████████████████▉   │
25. │     0 │   24 │                9.646 │ ████████████████████████   │
26. │     1 │   25 │                9.728 │ ████████████████████████▎  │
27. │     0 │   26 │                9.802 │ ████████████████████████▌  │
28. │     0 │   27 │                9.869 │ ████████████████████████▋  │
29. │     0 │   28 │                 9.93 │ ████████████████████████▊  │
30. │     0 │   29 │                9.985 │ ████████████████████████▉  │
31. │     1 │   30 │               10.035 │ █████████████████████████  │
32. │     0 │   31 │                10.08 │ █████████████████████████▏ │
33. │     0 │   32 │               10.121 │ █████████████████████████▎ │
34. │     0 │   33 │               10.158 │ █████████████████████████▍ │
35. │     0 │   34 │               10.191 │ █████████████████████████▍ │
36. │     1 │   35 │               10.221 │ █████████████████████████▌ │
37. │     0 │   36 │               10.249 │ █████████████████████████▌ │
38. │     0 │   37 │               10.273 │ █████████████████████████▋ │
39. │     0 │   38 │               10.296 │ █████████████████████████▋ │
40. │     0 │   39 │               10.316 │ █████████████████████████▊ │
41. │     1 │   40 │               10.334 │ █████████████████████████▊ │
42. │     0 │   41 │               10.351 │ █████████████████████████▉ │
43. │     0 │   42 │               10.366 │ █████████████████████████▉ │
44. │     0 │   43 │               10.379 │ █████████████████████████▉ │
45. │     0 │   44 │               10.392 │ █████████████████████████▉ │
46. │     1 │   45 │               10.403 │ ██████████████████████████ │
47. │     0 │   46 │               10.413 │ ██████████████████████████ │
48. │     0 │   47 │               10.422 │ ██████████████████████████ │
49. │     0 │   48 │                10.43 │ ██████████████████████████ │
50. │     0 │   49 │               10.438 │ ██████████████████████████ │
    └───────┴──────┴──────────────────────┴────────────────────────────┘
```
