---
description: 'System table containing error codes with the number of times they have
  been triggered.'
keywords: ['system table', 'errors']
slug: /operations/system-tables/errors
title: 'system.errors'
doc_type: 'reference'
---

import SystemTableCloud from '@site/docs/_snippets/_system_table_cloud.md';

<SystemTableCloud/>

Contains error codes with the number of times they have been triggered.

To show all possible error codes, including ones which were not triggered, set setting [system_events_show_zero_values](../settings/settings.md#system_events_show_zero_values) to 1.

Columns:

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

:::note
Counters for some errors may increase during successful query execution. It's not recommended to use this table for server monitoring purposes unless you are sure that corresponding error can not be a false positive.
:::

**Example**

```sql
SELECT name, code, value
FROM system.errors
WHERE value > 0
ORDER BY code ASC
LIMIT 1

┌─name─────────────┬─code─┬─value─┐
│ CANNOT_OPEN_FILE │   76 │     1 │
└──────────────────┴──────┴───────┘
```

```sql
WITH arrayMap(x -> demangle(addressToSymbol(x)), last_error_trace) AS all
SELECT name, arrayStringConcat(all, '\n') AS res
FROM system.errors
LIMIT 1
SETTINGS allow_introspection_functions=1\G
```
