---
description: 'System table containing information about local files that are in the
  queue to be sent to the shards.'
keywords: ['system table', 'distribution_queue']
slug: /operations/system-tables/distribution_queue
title: 'system.distribution_queue'
doc_type: 'reference'
---

Contains information about local files that are in the queue to be sent to the shards. These local files contain new parts that are created by inserting new data into the Distributed table in asynchronous mode.

Columns:

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

**Example**

```sql
SELECT * FROM system.distribution_queue LIMIT 1 FORMAT Vertical;
```

```text
Row 1:
──────
database:              default
table:                 dist
data_path:             ./store/268/268bc070-3aad-4b1a-9cf2-4987580161af/default@127%2E0%2E0%2E2:9000/
is_blocked:            1
error_count:           0
data_files:            1
data_compressed_bytes: 499
last_exception:
```

**See Also**

- [Distributed table engine](../../engines/table-engines/special/distributed.md)
