---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.8.3.66-lts (ea12745c77a) FIXME as compared to v25.8.2.29-lts (874146507b0)

#### Improvement
* Backported in [#86880](https://github.com/ClickHouse/ClickHouse/issues/86880): Add rows/bytes limit for inserted data files in delta lake. Controlled by settings `delta_lake_insert_max_rows_in_data_file` and `delta_lake_insert_max_bytes_in_data_file`. [#86357](https://github.com/ClickHouse/ClickHouse/pull/86357) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86734](https://github.com/ClickHouse/ClickHouse/issues/86734): Fixed error in case of executing `SYSTEM DROP REPLICA` against a Catalog with corrupted metadata. [#86391](https://github.com/ClickHouse/ClickHouse/pull/86391) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#87026](https://github.com/ClickHouse/ClickHouse/issues/87026): Fix misleading “specified upload does not exist” error, which occurs when the original exception is lost in multipart upload because of a race condition. [#86725](https://github.com/ClickHouse/ClickHouse/pull/86725) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#86817](https://github.com/ClickHouse/ClickHouse/issues/86817): Improve performance of RemoveRecursive request in Keeper. [#86789](https://github.com/ClickHouse/ClickHouse/pull/86789) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#86702](https://github.com/ClickHouse/ClickHouse/issues/86702): Mapping between iceberg source ids and parquet names was not adjusted to the schema when the parquet file was written. This PR processes schema relevant for each iceberg data file, not a current one. [#85829](https://github.com/ClickHouse/ClickHouse/pull/85829) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#86959](https://github.com/ClickHouse/ClickHouse/issues/86959): Fix alter update of a column with a subcolumn used in other column materialized expression. Previously materialized column with subcolumn in its expression was not updated properly. [#85985](https://github.com/ClickHouse/ClickHouse/pull/85985) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86695](https://github.com/ClickHouse/ClickHouse/issues/86695): Forbid altering columns whose subcolumns are used in PK or partition expression. [#86005](https://github.com/ClickHouse/ClickHouse/pull/86005) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86519](https://github.com/ClickHouse/ClickHouse/issues/86519): Fix reading subcolumns with non-default column mapping mode in storage DeltaLake. [#86064](https://github.com/ClickHouse/ClickHouse/pull/86064) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#87012](https://github.com/ClickHouse/ClickHouse/issues/87012): Removes UB and fixes problems with parsing of Iceberg partition expression. [#86166](https://github.com/ClickHouse/ClickHouse/pull/86166) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#86949](https://github.com/ClickHouse/ClickHouse/issues/86949): Fix cast from LowCardinality(Nullable(T)) to Dynamic. [#86365](https://github.com/ClickHouse/ClickHouse/pull/86365) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86879](https://github.com/ClickHouse/ClickHouse/issues/86879): Fix logical error during writes to DeltaLake. Closes [#86175](https://github.com/ClickHouse/ClickHouse/issues/86175). [#86367](https://github.com/ClickHouse/ClickHouse/pull/86367) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86719](https://github.com/ClickHouse/ClickHouse/issues/86719): Fix GROUP BY Nullable(JSON). [#86410](https://github.com/ClickHouse/ClickHouse/pull/86410) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87088](https://github.com/ClickHouse/ClickHouse/issues/87088): Fix Backup db engine raising exception on query with zero sized part files. [#86563](https://github.com/ClickHouse/ClickHouse/pull/86563) ([Max Justus Spransy](https://github.com/maxjustus)).
* Backported in [#86875](https://github.com/ClickHouse/ClickHouse/issues/86875): Fix missing chunk header when send_chunk_header is enabled and UDF is invoked via HTTP protocol. [#86606](https://github.com/ClickHouse/ClickHouse/pull/86606) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#86874](https://github.com/ClickHouse/ClickHouse/issues/86874): Fix S3Queue logical error "Expected current processor {} to be equal to {}", which happened because of keeper session expiration. [#86615](https://github.com/ClickHouse/ClickHouse/pull/86615) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86709](https://github.com/ClickHouse/ClickHouse/issues/86709): Do not disable file system cache if Iceberg metadata cache is disabled. [#86635](https://github.com/ClickHouse/ClickHouse/pull/86635) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#86793](https://github.com/ClickHouse/ClickHouse/issues/86793): Fix shutdown in `ArrowFlight` handler. This PR fixes [#86596](https://github.com/ClickHouse/ClickHouse/issues/86596). [#86665](https://github.com/ClickHouse/ClickHouse/pull/86665) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#86928](https://github.com/ClickHouse/ClickHouse/issues/86928): Fix exception `Partition strategy wildcard can not be used without a '_partition_id' wildcard.` when creating a table with `PARTITION BY`, but without partition wildcard, which used to work in versions before 25.8. Closes https://github.com/ClickHouse/clickhouse-private/issues/37567. [#86748](https://github.com/ClickHouse/ClickHouse/pull/86748) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86941](https://github.com/ClickHouse/ClickHouse/issues/86941): Fix writing NULL into JSON shared data in RowBinary input format and add some additional validations in ColumnObject. [#86812](https://github.com/ClickHouse/ClickHouse/pull/86812) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86979](https://github.com/ClickHouse/ClickHouse/issues/86979): Fix TimeSeries engine table breaking creation of new replica in Replicated Database. [#86845](https://github.com/ClickHouse/ClickHouse/pull/86845) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#86863](https://github.com/ClickHouse/ClickHouse/issues/86863): Fix querying `system.distributed_ddl_queue` in cases where tasks are missing certain Keeper nodes. [#86848](https://github.com/ClickHouse/ClickHouse/pull/86848) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87009](https://github.com/ClickHouse/ClickHouse/issues/87009): Fix seeking at the end of the decompressed block. [#86906](https://github.com/ClickHouse/ClickHouse/pull/86906) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86988](https://github.com/ClickHouse/ClickHouse/issues/86988): Process exception which is thrown during asyncronous execution of Iceberg Iterator. [#86932](https://github.com/ClickHouse/ClickHouse/pull/86932) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#87072](https://github.com/ClickHouse/ClickHouse/issues/87072): Correctly cast output of PREWHERE after splitting it into multiple steps. [#87040](https://github.com/ClickHouse/ClickHouse/pull/87040) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87134](https://github.com/ClickHouse/ClickHouse/issues/87134): Fix compatibility of some aggregate function states with String argument. [#87049](https://github.com/ClickHouse/ClickHouse/pull/87049) ([Pavel Kruglov](https://github.com/Avogar)).

#### Build/Testing/Packaging Improvement
* Backported in [#86808](https://github.com/ClickHouse/ClickHouse/issues/86808): Use `openldap` 2.6.10. [#86623](https://github.com/ClickHouse/ClickHouse/pull/86623) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#86773](https://github.com/ClickHouse/ClickHouse/issues/86773): Fix ReadFromFormatInfo serialization. [#86397](https://github.com/ClickHouse/ClickHouse/pull/86397) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86674](https://github.com/ClickHouse/ClickHouse/issues/86674): Check feature flag when adding RemoveRecursive request to Multi. [#86554](https://github.com/ClickHouse/ClickHouse/pull/86554) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#86758](https://github.com/ClickHouse/ClickHouse/issues/86758): Fixing keep-alive on inter-server calls. [#86631](https://github.com/ClickHouse/ClickHouse/pull/86631) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#86888](https://github.com/ClickHouse/ClickHouse/issues/86888): Return fallback for schema resolution for a manifest file entry. [#86832](https://github.com/ClickHouse/ClickHouse/pull/86832) ([Daniil Ivanik](https://github.com/divanik)).

