---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.7.7.68-stable (7e68b82051a) FIXME as compared to v25.7.6.21-stable (a81134c5c92)

#### Improvement
* Backported in [#86732](https://github.com/ClickHouse/ClickHouse/issues/86732): Fixed error in case of executing `SYSTEM DROP REPLICA` against a Catalog with corrupted metadata. [#86391](https://github.com/ClickHouse/ClickHouse/pull/86391) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#86825](https://github.com/ClickHouse/ClickHouse/issues/86825): Improve performance of RemoveRecursive request in Keeper. [#86789](https://github.com/ClickHouse/ClickHouse/pull/86789) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#86058](https://github.com/ClickHouse/ClickHouse/issues/86058): Fixed server crash when a user created with `no_password` attempts to login after the server setting `allow_no_password` was changed to 0. [#84426](https://github.com/ClickHouse/ClickHouse/pull/84426) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#86612](https://github.com/ClickHouse/ClickHouse/issues/86612): Shutdown tables properly when recovering database replica. Improper shutdown would lead to LOGICAL_ERROR for some table engines during database replica recovery. [#84744](https://github.com/ClickHouse/ClickHouse/pull/84744) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#86520](https://github.com/ClickHouse/ClickHouse/issues/86520): Fix segfault in delta-kernel implementation. [#85160](https://github.com/ClickHouse/ClickHouse/pull/85160) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85255](https://github.com/ClickHouse/ClickHouse/issues/85255): Fix reading partitioned data with disabled delta-kernel in `DeltaLake` engine. It was broken in 25.7 (https://github.com/ClickHouse/ClickHouse/pull/81136). [#85223](https://github.com/ClickHouse/ClickHouse/pull/85223) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85652](https://github.com/ClickHouse/ClickHouse/issues/85652): Parameters like `date_time_input_format` have been just ignored when http with multipart. [#85570](https://github.com/ClickHouse/ClickHouse/pull/85570) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#87157](https://github.com/ClickHouse/ClickHouse/issues/87157): Add a check to allow correlated subqueries in the FROM clause only if they use columns from the outer query. Fixes [#85469](https://github.com/ClickHouse/ClickHouse/issues/85469). Fixes [#85402](https://github.com/ClickHouse/ClickHouse/issues/85402). [#85966](https://github.com/ClickHouse/ClickHouse/pull/85966) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#86955](https://github.com/ClickHouse/ClickHouse/issues/86955): Fix alter update of a column with a subcolumn used in other column materialized expression. Previously materialized column with subcolumn in its expression was not updated properly. [#85985](https://github.com/ClickHouse/ClickHouse/pull/85985) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86693](https://github.com/ClickHouse/ClickHouse/issues/86693): Forbid altering columns whose subcolumns are used in PK or partition expression. [#86005](https://github.com/ClickHouse/ClickHouse/pull/86005) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86199](https://github.com/ClickHouse/ClickHouse/issues/86199): Fix using wrong default values for path with Enum hint inside JSON. [#86065](https://github.com/ClickHouse/ClickHouse/pull/86065) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86518](https://github.com/ClickHouse/ClickHouse/issues/86518): Fix logical error during filesystem cache dynamic resize. Closes [#86122](https://github.com/ClickHouse/ClickHouse/issues/86122). Closes https://github.com/ClickHouse/clickhouse-core-incidents/issues/473. [#86130](https://github.com/ClickHouse/ClickHouse/pull/86130) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86947](https://github.com/ClickHouse/ClickHouse/issues/86947): Fix cast from LowCardinality(Nullable(T)) to Dynamic. [#86365](https://github.com/ClickHouse/ClickHouse/pull/86365) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86878](https://github.com/ClickHouse/ClickHouse/issues/86878): Fix GROUP BY Nullable(JSON). [#86410](https://github.com/ClickHouse/ClickHouse/pull/86410) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86580](https://github.com/ClickHouse/ClickHouse/issues/86580): Ignore exceptions during flushing log on shutdown and make shutdown more safe (to avoid SIGSEGV). [#86546](https://github.com/ClickHouse/ClickHouse/pull/86546) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86891](https://github.com/ClickHouse/ClickHouse/issues/86891): Fix missing chunk header when send_chunk_header is enabled and UDF is invoked via HTTP protocol. [#86606](https://github.com/ClickHouse/ClickHouse/pull/86606) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#86872](https://github.com/ClickHouse/ClickHouse/issues/86872): Fix S3Queue logical error "Expected current processor {} to be equal to {}", which happened because of keeper session expiration. [#86615](https://github.com/ClickHouse/ClickHouse/pull/86615) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#87057](https://github.com/ClickHouse/ClickHouse/issues/87057): Fix writing NULL into JSON shared data in RowBinary input format and add some additional validations in ColumnObject. [#86812](https://github.com/ClickHouse/ClickHouse/pull/86812) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86977](https://github.com/ClickHouse/ClickHouse/issues/86977): Fix TimeSeries engine table breaking creation of new replica in Replicated Database. [#86845](https://github.com/ClickHouse/ClickHouse/pull/86845) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#86861](https://github.com/ClickHouse/ClickHouse/issues/86861): Fix querying `system.distributed_ddl_queue` in cases where tasks are missing certain Keeper nodes. [#86848](https://github.com/ClickHouse/ClickHouse/pull/86848) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87054](https://github.com/ClickHouse/ClickHouse/issues/87054): Fix seeking at the end of the decompressed block. [#86906](https://github.com/ClickHouse/ClickHouse/pull/86906) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87191](https://github.com/ClickHouse/ClickHouse/issues/87191): Fixed possible incorrect result of `uniqExact` function with `ROLLUP` and `CUBE` modifiers. [#87014](https://github.com/ClickHouse/ClickHouse/pull/87014) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#87070](https://github.com/ClickHouse/ClickHouse/issues/87070): Correctly cast output of PREWHERE after splitting it into multiple steps. [#87040](https://github.com/ClickHouse/ClickHouse/pull/87040) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87416](https://github.com/ClickHouse/ClickHouse/issues/87416): EmbeddedRocksDB: Path must be inside user_files. [#87109](https://github.com/ClickHouse/ClickHouse/pull/87109) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87311](https://github.com/ClickHouse/ClickHouse/issues/87311): Fix KeeperMap tables created before 25.1, leaving data in ZooKeeper after the DROP query. [#87112](https://github.com/ClickHouse/ClickHouse/pull/87112) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#87393](https://github.com/ClickHouse/ClickHouse/issues/87393): Fixed incorrect accounting of temporary data deallocations in `max_temporary_data_on_disk_size` limit tracking, close [#87118](https://github.com/ClickHouse/ClickHouse/issues/87118). [#87140](https://github.com/ClickHouse/ClickHouse/pull/87140) ([JIaQi](https://github.com/JiaQiTang98)).
* Backported in [#87435](https://github.com/ClickHouse/ClickHouse/issues/87435): Fix "Too large size passed to allocator" `LOGICAL_ERROR` in `JOIN` due to mixed const and non-const blocks. [#87231](https://github.com/ClickHouse/ClickHouse/pull/87231) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#86806](https://github.com/ClickHouse/ClickHouse/issues/86806): Use `openldap` 2.6.10. [#86623](https://github.com/ClickHouse/ClickHouse/pull/86623) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL CATEGORY

* Backported in [#86568](https://github.com/ClickHouse/ClickHouse/issues/86568):. [#86558](https://github.com/ClickHouse/ClickHouse/pull/86558) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#86680](https://github.com/ClickHouse/ClickHouse/issues/86680): Check feature flag when adding RemoveRecursive request to Multi. [#86554](https://github.com/ClickHouse/ClickHouse/pull/86554) ([Antonio Andelic](https://github.com/antonio2368)).

