---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.6.9.98-stable (b242c4182b8) FIXME as compared to v25.6.8.10-stable (c54ce812cd4)

#### Performance Improvement
* Backported in [#85683](https://github.com/ClickHouse/ClickHouse/issues/85683): Improve parallel files processing with delta-kernel-rs backend. [#85642](https://github.com/ClickHouse/ClickHouse/pull/85642) ([Azat Khuzhin](https://github.com/azat)).

#### Improvement
* Backported in [#86063](https://github.com/ClickHouse/ClickHouse/issues/86063): Views, created by ephemeral users, will now store a copy of an actual user and will no longer be invalidated after the ephemeral user is deleted. [#84763](https://github.com/ClickHouse/ClickHouse/pull/84763) ([pufit](https://github.com/pufit)).
* Backported in [#85728](https://github.com/ClickHouse/ClickHouse/issues/85728): Added show_data_lake_catalogs_in_system_tables flag to manage adding data lake tables in system.tables resolves [#85384](https://github.com/ClickHouse/ClickHouse/issues/85384). [#85411](https://github.com/ClickHouse/ClickHouse/pull/85411) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#86251](https://github.com/ClickHouse/ClickHouse/issues/86251): Slow down S3 client threads on retryable errors in S3 Object Storage. This extends the previous setting `backup_slow_all_threads_after_retryable_s3_error` to S3 disks and renames it to the more general `s3_slow_all_threads_after_retryable_error`. [#85918](https://github.com/ClickHouse/ClickHouse/pull/85918) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#86503](https://github.com/ClickHouse/ClickHouse/issues/86503): Add ability to enable JSON logging only for specific channel, for this set `logger.formatting.channel` to one of `syslog`/`console`/`errorlog`/`log`. [#86331](https://github.com/ClickHouse/ClickHouse/pull/86331) ([Azat Khuzhin](https://github.com/azat)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#85757](https://github.com/ClickHouse/ClickHouse/issues/85757): Fixed parquet writer outputting incorrect statistics (min/max) for Decimal types. [#83754](https://github.com/ClickHouse/ClickHouse/pull/83754) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#84942](https://github.com/ClickHouse/ClickHouse/issues/84942): This closes [#81303](https://github.com/ClickHouse/ClickHouse/issues/81303). [#83892](https://github.com/ClickHouse/ClickHouse/pull/83892) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Backported in [#85794](https://github.com/ClickHouse/ClickHouse/issues/85794): Fix writing JSON paths with NULL values in RowBinary format. [#83923](https://github.com/ClickHouse/ClickHouse/pull/83923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#85881](https://github.com/ClickHouse/ClickHouse/issues/85881): Fix reading Variant column with lazy materialization. [#84400](https://github.com/ClickHouse/ClickHouse/pull/84400) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86056](https://github.com/ClickHouse/ClickHouse/issues/86056): Fixed server crash when a user created with `no_password` attempts to login after the server setting `allow_no_password` was changed to 0. [#84426](https://github.com/ClickHouse/ClickHouse/pull/84426) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#85310](https://github.com/ClickHouse/ClickHouse/issues/85310): Now if all TTL are removed from table MergeTree will do nothing related to TTL. [#84441](https://github.com/ClickHouse/ClickHouse/pull/84441) ([alesapin](https://github.com/alesapin)).
* Backported in [#85304](https://github.com/ClickHouse/ClickHouse/issues/85304): Fix ALTER MODIFY ORDER BY not validating TTL columns in sorting keys. TTL columns are now properly rejected when used in ORDER BY clauses during ALTER operations, preventing potential table corruption. [#84536](https://github.com/ClickHouse/ClickHouse/pull/84536) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Backported in [#85115](https://github.com/ClickHouse/ClickHouse/issues/85115): Add a check if a correlated subquery is used in a distributed context to avoid a crash. Fixes [#82205](https://github.com/ClickHouse/ClickHouse/issues/82205). [#85030](https://github.com/ClickHouse/ClickHouse/pull/85030) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#85269](https://github.com/ClickHouse/ClickHouse/issues/85269): Fixing illegal_type_of_argument in mv when types are different. [#85135](https://github.com/ClickHouse/ClickHouse/pull/85135) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#85234](https://github.com/ClickHouse/ClickHouse/issues/85234): Fix `Not-ready Set` for `IN (subquery)` inside `additional_table_filters expression` setting. [#85210](https://github.com/ClickHouse/ClickHouse/pull/85210) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85262](https://github.com/ClickHouse/ClickHouse/issues/85262): Get rid of unnecessary `getStatus()` calls during SYSTEM DROP REPLICA queries. Fixes the case when a table is dropped in the background, and the `Shutdown for storage is called` exception is thrown. [#85220](https://github.com/ClickHouse/ClickHouse/pull/85220) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#85360](https://github.com/ClickHouse/ClickHouse/issues/85360): Fix race in `DeltaLake` engine delta-kernel implementation. [#85221](https://github.com/ClickHouse/ClickHouse/pull/85221) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85502](https://github.com/ClickHouse/ClickHouse/issues/85502): Added missing table name length checks in CREATE OR REPLACE and RENAME queries. [#85326](https://github.com/ClickHouse/ClickHouse/pull/85326) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#85399](https://github.com/ClickHouse/ClickHouse/issues/85399): Fix the creation of RMV on a new replica of the Replicated database if DEFINER is dropped. [#85327](https://github.com/ClickHouse/ClickHouse/pull/85327) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#85524](https://github.com/ClickHouse/ClickHouse/issues/85524): Fix backup of parts with broken projections. [#85362](https://github.com/ClickHouse/ClickHouse/pull/85362) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85424](https://github.com/ClickHouse/ClickHouse/issues/85424): Fix crash and data corruption during ALTER UPDATE for JSON. [#85383](https://github.com/ClickHouse/ClickHouse/pull/85383) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#85617](https://github.com/ClickHouse/ClickHouse/issues/85617): Queries with parallel replicas which uses reading reverse in order optimization can produce incorrect result. [#85406](https://github.com/ClickHouse/ClickHouse/pull/85406) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#85696](https://github.com/ClickHouse/ClickHouse/issues/85696): Fix possible UB (crashes) in case of MEMORY_LIMIT_EXCEEDED during String deserialization. [#85440](https://github.com/ClickHouse/ClickHouse/pull/85440) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#85824](https://github.com/ClickHouse/ClickHouse/issues/85824): Fix incorrect metrics KafkaAssignedPartitions and KafkaConsumersWithAssignment. [#85494](https://github.com/ClickHouse/ClickHouse/pull/85494) ([Ilya Golshtein](https://github.com/ilejn)).
* Backported in [#85687](https://github.com/ClickHouse/ClickHouse/issues/85687): Fix early return condition for S3 request rate slowdown: require either s3_slow_all_threads_after_network_error or backup_slow_all_threads_after_retryable_s3_error to be true to enable slowdown behavior when all threads are paused due to a retryable error, instead of requiring both. [#85505](https://github.com/ClickHouse/ClickHouse/pull/85505) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#85560](https://github.com/ClickHouse/ClickHouse/issues/85560): Fixed rare crash in asynchronous inserts that change settings `log_comment` or `insert_deduplication_token`. [#85540](https://github.com/ClickHouse/ClickHouse/pull/85540) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#85914](https://github.com/ClickHouse/ClickHouse/issues/85914): Fix secrets masking in icebergS3Cluster and icebergAzureCluster table functions. [#85658](https://github.com/ClickHouse/ClickHouse/pull/85658) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#85869](https://github.com/ClickHouse/ClickHouse/issues/85869): Fix coalescing merge tree segfault for large strings. This closes [#84582](https://github.com/ClickHouse/ClickHouse/issues/84582). [#85709](https://github.com/ClickHouse/ClickHouse/pull/85709) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Backported in [#86111](https://github.com/ClickHouse/ClickHouse/issues/86111): Using `distributed_depth` as an indicator of *Cluster function was incorrect and may lead to data duplication; use `client_info.collaborate_with_initiator` instead. [#85734](https://github.com/ClickHouse/ClickHouse/pull/85734) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#85858](https://github.com/ClickHouse/ClickHouse/issues/85858): Fix possible inconsistency for dictionaries with update_field on MEMORY_LIMIT_EXCEEDED errors. [#85807](https://github.com/ClickHouse/ClickHouse/pull/85807) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86265](https://github.com/ClickHouse/ClickHouse/issues/86265): Fix logical error on attempt to `CREATE ... AS (SELECT * FROM s3Cluster(...))` with `DatabaseReplicated`. [#85904](https://github.com/ClickHouse/ClickHouse/pull/85904) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#86161](https://github.com/ClickHouse/ClickHouse/issues/86161): Now unity catalog will ignore schemas with weird data types in case of non-delta tables. Fixes [#85699](https://github.com/ClickHouse/ClickHouse/issues/85699). [#85950](https://github.com/ClickHouse/ClickHouse/pull/85950) ([alesapin](https://github.com/alesapin)).
* Backported in [#86039](https://github.com/ClickHouse/ClickHouse/issues/86039): Fixed a bug in `Replicated` database recovery: if a table name contains the `%` symbol, it could re-create the table with a different name during recovery. [#85987](https://github.com/ClickHouse/ClickHouse/pull/85987) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#86250](https://github.com/ClickHouse/ClickHouse/issues/86250): Fix backup restores failing due to `BACKUP_ENTRY_NOT_FOUND` error when restoring an empty `Memory` table. [#86012](https://github.com/ClickHouse/ClickHouse/pull/86012) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#86197](https://github.com/ClickHouse/ClickHouse/issues/86197): Fix using wrong default values for path with Enum hint inside JSON. [#86065](https://github.com/ClickHouse/ClickHouse/pull/86065) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86289](https://github.com/ClickHouse/ClickHouse/issues/86289): Exception was thrown by a `FINAL` query with skip index if the table (e.g `ReplacingMergeTree`) was created with setting`index_granularity_bytes = 0`. That exception has been fixed now. [#86147](https://github.com/ClickHouse/ClickHouse/pull/86147) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#86306](https://github.com/ClickHouse/ClickHouse/issues/86306): Fix crash in case of const and non-const blocks in one INSERT. [#86230](https://github.com/ClickHouse/ClickHouse/pull/86230) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86346](https://github.com/ClickHouse/ClickHouse/issues/86346): Fix crash during ALTER UPDATE Nullable(JSON). [#86281](https://github.com/ClickHouse/ClickHouse/pull/86281) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86464](https://github.com/ClickHouse/ClickHouse/issues/86464): Fix leaking of `MergesMutationsMemoryTracking` due to `Buffer` tables and fix `query_views_log` for streaming from `Kafka` (and others). [#86422](https://github.com/ClickHouse/ClickHouse/pull/86422) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#85388](https://github.com/ClickHouse/ClickHouse/issues/85388): Increase timeout for test_ttl_compatibility under sanitizers. [#83789](https://github.com/ClickHouse/ClickHouse/pull/83789) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#85593](https://github.com/ClickHouse/ClickHouse/issues/85593): Fix parquet writer outputting incorrect row indices in offset index. [#83876](https://github.com/ClickHouse/ClickHouse/pull/83876) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#85219](https://github.com/ClickHouse/ClickHouse/issues/85219): CI: Enable final job in MasterCI. [#84963](https://github.com/ClickHouse/ClickHouse/pull/84963) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#85282](https://github.com/ClickHouse/ClickHouse/issues/85282): Avoid some copies in Keeper. [#85131](https://github.com/ClickHouse/ClickHouse/pull/85131) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85605](https://github.com/ClickHouse/ClickHouse/issues/85605): Sync read if content is in page cache. [#85405](https://github.com/ClickHouse/ClickHouse/pull/85405) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85832](https://github.com/ClickHouse/ClickHouse/issues/85832): Add compatibility setting to write Date as UInt16 to parquet files. [#85510](https://github.com/ClickHouse/ClickHouse/pull/85510) ([Michael Kolupaev](https://github.com/al13n321)).

