---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.6.3.116-stable (3c68d19c3b3) FIXME as compared to v25.6.2.5-stable (51a12888a03)

#### Performance Improvement
* Backported in [#83343](https://github.com/ClickHouse/ClickHouse/issues/83343): Try to speedup QueryTreeHash a bit. [#82617](https://github.com/ClickHouse/ClickHouse/pull/82617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Improvement
* Backported in [#83207](https://github.com/ClickHouse/ClickHouse/issues/83207): Allow ALTER UPDATE in JSON and Dynamic columns. [#82419](https://github.com/ClickHouse/ClickHouse/pull/82419) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83015](https://github.com/ClickHouse/ClickHouse/issues/83015): Keeper improvement: move changelog files between disk in a background thread. Previously, moving changelog to a different disk would block Keeper globally until the move is finished. This lead to performance degradation if moving is a long operation (e.g. to S3 disk). [#82485](https://github.com/ClickHouse/ClickHouse/pull/82485) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83205](https://github.com/ClickHouse/ClickHouse/issues/83205): `SYSTEM RESTART REPLICA` may fail due to ZooKeeper connection issues. To avoid forgetting about this table, we now retry until the table is created. [#82616](https://github.com/ClickHouse/ClickHouse/pull/82616) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#83270](https://github.com/ClickHouse/ClickHouse/issues/83270): Fix the wrong default value for the `--reconnect` option in `clickhouse-benchmark`. It was changed by mistake in [#79465](https://github.com/ClickHouse/ClickHouse/issues/79465). [#82677](https://github.com/ClickHouse/ClickHouse/pull/82677) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82928](https://github.com/ClickHouse/ClickHouse/issues/82928): Keeper improvement: support specific permissions for world:anyone ACL. [#82755](https://github.com/ClickHouse/ClickHouse/pull/82755) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83146](https://github.com/ClickHouse/ClickHouse/issues/83146): Add columns `commit_time`, `commit_id` to `system.s3queue_log`. [#83016](https://github.com/ClickHouse/ClickHouse/pull/83016) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#83184](https://github.com/ClickHouse/ClickHouse/issues/83184): Consolidate unknown settings warnings in clickhouse client and log them as a summary. [#83042](https://github.com/ClickHouse/ClickHouse/pull/83042) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#83281](https://github.com/ClickHouse/ClickHouse/issues/83281): There was an incorrect dependency check for the INSERT with MVs that have malformed selects and the user might have received an obscure `std::exception` instead of a meaningful error with a clear explanation. This is now fixed. This fixes: [#82889](https://github.com/ClickHouse/ClickHouse/issues/82889). [#83190](https://github.com/ClickHouse/ClickHouse/pull/83190) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#82781](https://github.com/ClickHouse/ClickHouse/issues/82781): Fix filter analysis when only a constant alias column is used in the query. Fixes [#79448](https://github.com/ClickHouse/ClickHouse/issues/79448). [#82037](https://github.com/ClickHouse/ClickHouse/pull/82037) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83148](https://github.com/ClickHouse/ClickHouse/issues/83148): Fix `DatabaseReplicated::getClusterImpl`. If the first element (or elements) of `hosts` has `id == DROPPED_MARK` and there are no other elements for the same shard, the first element of `shards` will be an empty vector, leading to `std::out_of_range`. [#82093](https://github.com/ClickHouse/ClickHouse/pull/82093) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#83211](https://github.com/ClickHouse/ClickHouse/issues/83211): Fix performance degradation in SummingMergeTree that was intorduced in 25.5 in https://github.com/ClickHouse/ClickHouse/pull/79051. [#82130](https://github.com/ClickHouse/ClickHouse/pull/82130) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83217](https://github.com/ClickHouse/ClickHouse/issues/83217): Fix "Context has expired" for Iceberg. [#82146](https://github.com/ClickHouse/ClickHouse/pull/82146) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82946](https://github.com/ClickHouse/ClickHouse/issues/82946): Fix data-races in client (by not using global context) and `session_timezone` overrides (previously in case of `session_timezone` was set in i.e. `users.xml`/client options to non empty and in query context to empty, then, value from `users.xml` was used, while this is wrong, now query context will always have a priority over global context). [#82444](https://github.com/ClickHouse/ClickHouse/pull/82444) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82758](https://github.com/ClickHouse/ClickHouse/issues/82758): Fixes cases where parsing of Time could cause msan issues. This fixes: [#82477](https://github.com/ClickHouse/ClickHouse/issues/82477). [#82514](https://github.com/ClickHouse/ClickHouse/pull/82514) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#82739](https://github.com/ClickHouse/ClickHouse/issues/82739): Setting `use_skip_indexes_if_final_exact_mode` implementation (introduced in 25.6) could fail to select a relevant candidate range depending upon `MergeTree` engine settings / data distribution. That has been resolved now. [#82667](https://github.com/ClickHouse/ClickHouse/pull/82667) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#82737](https://github.com/ClickHouse/ClickHouse/issues/82737): Functions `trim{Left,Right,Both}` now support input strings of type "FixedString(N)". For example, `SELECT trimBoth(toFixedString('abc', 3), 'ac')` now works. [#82691](https://github.com/ClickHouse/ClickHouse/pull/82691) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#82915](https://github.com/ClickHouse/ClickHouse/issues/82915): In AzureBlobStorage, for native copy we compare authentication methods, during which if we get an exception, updated the code to fallback to read and copy (i.e. non native copy). [#82693](https://github.com/ClickHouse/ClickHouse/pull/82693) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#82802](https://github.com/ClickHouse/ClickHouse/issues/82802): Fix deserialization of `groupArraySample`/`groupArrayLast` in case of empty elements (deserialization could skip part of the binary if the input was empty, this can lead to corruption during data read and UNKNOWN_PACKET_FROM_SERVER in TCP protocol). This does not affect numbers and date time types. [#82763](https://github.com/ClickHouse/ClickHouse/pull/82763) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Backported in [#83572](https://github.com/ClickHouse/ClickHouse/issues/83572): Fix backup of an empty `Memory` table, causing the backup restore to fail with with `BACKUP_ENTRY_NOT_FOUND` error. [#82791](https://github.com/ClickHouse/ClickHouse/pull/82791) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#83114](https://github.com/ClickHouse/ClickHouse/issues/83114): Fix exception safety in union/intersect/except_default_mode rewrite. Closes [#82664](https://github.com/ClickHouse/ClickHouse/issues/82664). [#82820](https://github.com/ClickHouse/ClickHouse/pull/82820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83263](https://github.com/ClickHouse/ClickHouse/issues/83263): Fix data races in Iceberg. [#82841](https://github.com/ClickHouse/ClickHouse/pull/82841) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83224](https://github.com/ClickHouse/ClickHouse/issues/83224): Setting `use_skip_indexes_if_final_exact_mode` optimization (introduced in 25.6) could fail to select a relevant candidate range depending upon `MergeTree` engine settings / data distribution. That has been resolved now. [#82879](https://github.com/ClickHouse/ClickHouse/pull/82879) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#83291](https://github.com/ClickHouse/ClickHouse/issues/83291): Set salt for auth data when parsing from AST with type SCRAM_SHA256_PASSWORD. [#82888](https://github.com/ClickHouse/ClickHouse/pull/82888) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#82997](https://github.com/ClickHouse/ClickHouse/issues/82997): When using a non-caching Database implementation, the metadata of the corresponding table is deleted after the columns are returned and the reference is invalidated. [#82939](https://github.com/ClickHouse/ClickHouse/pull/82939) ([buyval01](https://github.com/buyval01)).
* Backported in [#83029](https://github.com/ClickHouse/ClickHouse/issues/83029): Fix filter modification for queries with a JOIN expression with a table with storage `Merge`. Fixes [#82092](https://github.com/ClickHouse/ClickHouse/issues/82092). [#82950](https://github.com/ClickHouse/ClickHouse/pull/82950) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83313](https://github.com/ClickHouse/ClickHouse/issues/83313): Fix LOGICAL_ERROR in QueryMetricLog: Mutex cannot be NULL. [#82979](https://github.com/ClickHouse/ClickHouse/pull/82979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#83086](https://github.com/ClickHouse/ClickHouse/issues/83086): Fixed incorrect output of function `formatDateTime` when formatter `%f` is used together with variable-size formatters (e.g. `%M`). [#83020](https://github.com/ClickHouse/ClickHouse/pull/83020) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#83242](https://github.com/ClickHouse/ClickHouse/issues/83242): Fix performance degradation with the enabled analyzer when secondary queries always read all columns from the VIEWs. Fixes [#81718](https://github.com/ClickHouse/ClickHouse/issues/81718). [#83036](https://github.com/ClickHouse/ClickHouse/pull/83036) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83175](https://github.com/ClickHouse/ClickHouse/issues/83175): Fix misleading error message when restoring a backup on a read-only disk. [#83051](https://github.com/ClickHouse/ClickHouse/pull/83051) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#83201](https://github.com/ClickHouse/ClickHouse/issues/83201): Do not check for cyclic dependencies on create table with no dependencies. It fixes performance degradation of the use cases with creation of thousands of tables that was introduced in https://github.com/ClickHouse/ClickHouse/pull/65405. [#83077](https://github.com/ClickHouse/ClickHouse/pull/83077) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83125](https://github.com/ClickHouse/ClickHouse/issues/83125): Fixes issue with implicit reading of negative Time values into the table and make the docs not confusing. [#83091](https://github.com/ClickHouse/ClickHouse/pull/83091) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#83279](https://github.com/ClickHouse/ClickHouse/issues/83279): After https://github.com/ClickHouse/ClickHouse/pull/79963 the usage of subcolumns in Materialized Views got broken and user might have received an error `Not found column X in block`. This behaviour is fixed. This fixes: [#82784](https://github.com/ClickHouse/ClickHouse/issues/82784). [#83221](https://github.com/ClickHouse/ClickHouse/pull/83221) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#83346](https://github.com/ClickHouse/ClickHouse/issues/83346): Fix crash when calculating the size of a block with empty columns. [#83271](https://github.com/ClickHouse/ClickHouse/pull/83271) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#83475](https://github.com/ClickHouse/ClickHouse/issues/83475): Fix possible crash in Variant type in UNION. [#83295](https://github.com/ClickHouse/ClickHouse/pull/83295) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83405](https://github.com/ClickHouse/ClickHouse/issues/83405): Fix `no_sign_request` for S3 client. It can be used to explicitly avoid signing S3 requests. It can also be defined for specific endpoints using endpoint-based settings. [#83379](https://github.com/ClickHouse/ClickHouse/pull/83379) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83552](https://github.com/ClickHouse/ClickHouse/issues/83552): Fixes a crash that may happen for a query with a setting 'max_threads=1' when executed under load with CPU scheduling enabled. [#83387](https://github.com/ClickHouse/ClickHouse/pull/83387) ([Fan Ziqi](https://github.com/f2quantum)).
* Backported in [#83454](https://github.com/ClickHouse/ClickHouse/issues/83454): Fix `TOO_DEEP_SUBQUERIES` exception when CTE definition references another table expression with the same name. [#83413](https://github.com/ClickHouse/ClickHouse/pull/83413) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83575](https://github.com/ClickHouse/ClickHouse/issues/83575): Fix a bug introduced in https://github.com/ClickHouse/ClickHouse/pull/79963. When inserting into an MV with a definer, the permission check should use the definer's grants. This fixes [#79951](https://github.com/ClickHouse/ClickHouse/issues/79951). [#83502](https://github.com/ClickHouse/ClickHouse/pull/83502) ([pufit](https://github.com/pufit)).

#### Build/Testing/Packaging Improvement
* Backported in [#82711](https://github.com/ClickHouse/ClickHouse/issues/82711): Apply fix for CVE-2025-6375 in Poco from upstream. [#82647](https://github.com/ClickHouse/ClickHouse/pull/82647) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82709](https://github.com/ClickHouse/ClickHouse/issues/82709): Use `libarchive` 3.8.1. [#82648](https://github.com/ClickHouse/ClickHouse/pull/82648) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82707](https://github.com/ClickHouse/ClickHouse/issues/82707): Use `libxml2` v2.14.4. [#82649](https://github.com/ClickHouse/ClickHouse/pull/82649) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83444](https://github.com/ClickHouse/ClickHouse/issues/83444): Use `expat` 2.7.1 inside Poco. [#82661](https://github.com/ClickHouse/ClickHouse/pull/82661) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83090](https://github.com/ClickHouse/ClickHouse/issues/83090): Change `Dockerfile.ubuntu` for clickhouse-server to fit requirements in Docker Official Library. [#83039](https://github.com/ClickHouse/ClickHouse/pull/83039) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NO CL CATEGORY

* Backported in [#82787](https://github.com/ClickHouse/ClickHouse/issues/82787):. [#82771](https://github.com/ClickHouse/ClickHouse/pull/82771) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82873](https://github.com/ClickHouse/ClickHouse/issues/82873):. [#82853](https://github.com/ClickHouse/ClickHouse/pull/82853) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#83481](https://github.com/ClickHouse/ClickHouse/issues/83481): Fix: avoid stale connections with -Cluster functions. [#82018](https://github.com/ClickHouse/ClickHouse/pull/82018) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#82973](https://github.com/ClickHouse/ClickHouse/issues/82973): Keeper: some small digest and auth related fixes. [#82111](https://github.com/ClickHouse/ClickHouse/pull/82111) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82767](https://github.com/ClickHouse/ClickHouse/issues/82767): Add a setting to preserve old behaviour of dateTrunc function. [#82530](https://github.com/ClickHouse/ClickHouse/pull/82530) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82961](https://github.com/ClickHouse/ClickHouse/issues/82961): Add error response for getSessionID. [#82600](https://github.com/ClickHouse/ClickHouse/pull/82600) ([JIaQi](https://github.com/JiaQiTang98)).
* Backported in [#82658](https://github.com/ClickHouse/ClickHouse/issues/82658): Add an option to skip tests failing in FIPS mode. [#82630](https://github.com/ClickHouse/ClickHouse/pull/82630) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83365](https://github.com/ClickHouse/ClickHouse/issues/83365): PR: logging for coordinator responses. [#82705](https://github.com/ClickHouse/ClickHouse/pull/82705) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#82762](https://github.com/ClickHouse/ClickHouse/issues/82762): Fix binary build in MasterCI. [#82749](https://github.com/ClickHouse/ClickHouse/pull/82749) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83564](https://github.com/ClickHouse/ClickHouse/issues/83564): Bring back `--pre-pull` command to the integration tests jobs, it was deleted in [#73291](https://github.com/ClickHouse/ClickHouse/issues/73291). [#83528](https://github.com/ClickHouse/ClickHouse/pull/83528) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

