---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.6.1.3206-stable (4e12d851180) FIXME as compared to v25.6.1.1-new (063c439f433)

#### Backward Incompatible Change
* Minor: Force backup_threads and restore_threads server settings to be non zero. [#80224](https://github.com/ClickHouse/ClickHouse/pull/80224) ([Raúl Marín](https://github.com/Algunenano)).
* Fix bitNot() for String to return a zero-terminated string. [#80791](https://github.com/ClickHouse/ClickHouse/pull/80791) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82079](https://github.com/ClickHouse/ClickHouse/issues/82079): Previously, function `countMatches` would stop counting at the first empty match even if the pattern accepts it. To overcome this issue, `countMatches` now continues execution by advancing by a single character when an empty match occurs. Users who like to retain the old behavior can enable setting `count_matches_stop_at_empty_match`. [#81676](https://github.com/ClickHouse/ClickHouse/pull/81676) ([Elmi Ahmadov](https://github.com/ahmadov)).

#### New Feature
* Allow to write to Merge table engine. [#77484](https://github.com/ClickHouse/ClickHouse/pull/77484) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Add mapContainsValuesLike/mapContainsValues/mapExtractValuesLike functions to filter on map values and their support in bloomfilter based indexes. [#78171](https://github.com/ClickHouse/ClickHouse/pull/78171) ([UnamedRus](https://github.com/UnamedRus)).
* Added query slot scheduling for workloads, see https://clickhouse.com/docs/operations/workload-scheduling#query_scheduling for details. [#78415](https://github.com/ClickHouse/ClickHouse/pull/78415) ([Sergei Trifonov](https://github.com/serxa)).
* Support disallowed values under settings constraints. [#78499](https://github.com/ClickHouse/ClickHouse/pull/78499) ([Bharat Nallan](https://github.com/bharatnc)).
* Add a support for Coalescing Merge Tree. This closes [#78869](https://github.com/ClickHouse/ClickHouse/issues/78869). [#79344](https://github.com/ClickHouse/ClickHouse/pull/79344) ([scanhex12](https://github.com/scanhex12)).
* Added a setting `enable_shared_storage_snapshot_in_query` to enable sharing the same storage snapshot across all subqueries in a single query. This ensures consistent reads from the same table, even when the table is referenced multiple times within a query. [#79471](https://github.com/ClickHouse/ClickHouse/pull/79471) ([Amos Bird](https://github.com/amosbird)).
* Support writing CH JSON columns to Parquet and reading Parquet JSON columns directly as CH JSON columns. [#79649](https://github.com/ClickHouse/ClickHouse/pull/79649) ([Nihal Z. Miaji](https://github.com/nihalzp)).
* Bundle [`chdig`](https://github.com/azat/chdig/) - TUI interface for ClickHouse (top like) as part of ClickHouse. [#79666](https://github.com/ClickHouse/ClickHouse/pull/79666) ([Azat Khuzhin](https://github.com/azat)).
* Add `MultiPolygon` support for `pointInPolygon`. [#79773](https://github.com/ClickHouse/ClickHouse/pull/79773) ([Nihal Z. Miaji](https://github.com/nihalzp)).
* Add support for querying local filesystem-mounted delta tables via `deltaLakeLocal` table function. [#79781](https://github.com/ClickHouse/ClickHouse/pull/79781) ([roykim98](https://github.com/roykim98)).
* Support functions to read WKB format. This partially closes [#43941](https://github.com/ClickHouse/ClickHouse/issues/43941). [#80139](https://github.com/ClickHouse/ClickHouse/pull/80139) ([scanhex12](https://github.com/scanhex12)).
* Add new setting `cast_string_to_date_time_mode` that allows to choose DateTime parsing mode during cast from String. [#80210](https://github.com/ClickHouse/ClickHouse/pull/80210) ([Pavel Kruglov](https://github.com/Avogar)).
* Added Bech32 and Bech32m encoding and decoding functions (issue [#40381](https://github.com/ClickHouse/ClickHouse/issues/40381)). [#80239](https://github.com/ClickHouse/ClickHouse/pull/80239) ([George Larionov](https://github.com/glarik)).
* Support `disk` setting for Atomic and Ordinary DB engines, specifying the disk to store table metadata files. [#80546](https://github.com/ClickHouse/ClickHouse/pull/80546) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Support functions to unpack and compare merge tree parts. [#80573](https://github.com/ClickHouse/ClickHouse/pull/80573) ([Mikhail Artemenko](https://github.com/Michicosun)).
* `timeSeries*` helper functions to speedup some scenarios when working with time series data: - re-sample the data to the time grid with specified start timestamp, end timestamp and step - calculate PromQL-like `delta`, `rate`, `idelta` and `irate`. [#80590](https://github.com/ClickHouse/ClickHouse/pull/80590) ([Alexander Gololobov](https://github.com/davenger)).
* Allow filtering parts selected for query by the disk they reside on. [#80650](https://github.com/ClickHouse/ClickHouse/pull/80650) ([tanner-bruce](https://github.com/tanner-bruce)).
* Backported in [#82248](https://github.com/ClickHouse/ClickHouse/issues/82248): Add 'format_schema_source' setting which defines the source of 'format_schema'. [#80874](https://github.com/ClickHouse/ClickHouse/pull/80874) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Add a landing page with the list of embedded web tools. It will open when requested by a browser-like user agent. [#81129](https://github.com/ClickHouse/ClickHouse/pull/81129) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow for filtering NULL values in arrayFirst, arrayFirstIndex, arrayLast & arrayLastIndex. Fixes [#81113](https://github.com/ClickHouse/ClickHouse/issues/81113). [#81197](https://github.com/ClickHouse/ClickHouse/pull/81197) ([Lennard Eijsackers](https://github.com/Blokje5)).
* Backported in [#82115](https://github.com/ClickHouse/ClickHouse/issues/82115): New data types: Time ([H]HH:MM:SS) and Time64 ([H]HH:MM:SS[.fractional]), and some basic cast functions and functions to interact with other data types. Added settings for compatibility with a legacy function `ToTime`. [#81217](https://github.com/ClickHouse/ClickHouse/pull/81217) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#82081](https://github.com/ClickHouse/ClickHouse/issues/82081): It's now possible to write USE DATABASE {name}. [#81307](https://github.com/ClickHouse/ClickHouse/pull/81307) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#82351](https://github.com/ClickHouse/ClickHouse/issues/82351): Added a new system table `system.codecs` to introspect the available codecs. (issue [#81525](https://github.com/ClickHouse/ClickHouse/issues/81525)). [#81600](https://github.com/ClickHouse/ClickHouse/pull/81600) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Backported in [#82218](https://github.com/ClickHouse/ClickHouse/issues/82218): Support `lag` and `lead` window functions. Closes [#9887](https://github.com/ClickHouse/ClickHouse/issues/9887). [#82108](https://github.com/ClickHouse/ClickHouse/pull/82108) ([Dmitry Novik](https://github.com/novikd)).

#### Experimental Feature
* The explicit parameters are supported via key-value pairs. Currently, supported parameters are a mandatory `tokenizer` and two optional `max_rows_per_postings_list` and `ngram_size`. [#80262](https://github.com/ClickHouse/ClickHouse/pull/80262) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Experimental indexes of type `gin` were renamed to `text`. Existing indexes of type `gin` remain loadable but they will throw an exception (suggesting `text` indexes instead) when one tries to use them in searches. [#80855](https://github.com/ClickHouse/ClickHouse/pull/80855) ([Robert Schulze](https://github.com/rschu1ze)).

#### Performance Improvement
* The existing implementation of `Pipe::resize` creates a single `Resize` or `StrictResize` node by inserting it into the pipeline topology, which then acts as a central hub connecting all input streams (upstream nodes) to a unified set of output streams (downstream nodes). This design leads to contention for the` ExecutingGraph::Node::status_mutex` during pipeline graph execution, especially in high-core-count environments. When pipelines scale to tens or hundreds of streams, this contention results in:. [#77562](https://github.com/ClickHouse/ClickHouse/pull/77562) ([Zhiguo Zhou](https://github.com/ZhiguoZh)).
* Backported in [#81959](https://github.com/ClickHouse/ClickHouse/issues/81959): Introduced an option to offload (de)compression and (de)serialization of blocks into pipeline threads instead of a single thread associated with a network connection. Controlled by the setting `enable_parallel_blocks_marshalling`. It should speed up distributed queries that transfer significant amounts of data between the initiator and remote nodes. [#78694](https://github.com/ClickHouse/ClickHouse/pull/78694) ([Nikita Taranov](https://github.com/nickitat)).
* Replace DELETE FROM ... WHERE 1 queries to TRUNCATE. (Reverted). [#78739](https://github.com/ClickHouse/ClickHouse/pull/78739) ([scanhex12](https://github.com/scanhex12)).
* Performance improvements to all bloom filter types. [#79800](https://github.com/ClickHouse/ClickHouse/pull/79800) ([Delyan Kratunov](https://github.com/dkratunov)).
* Introduced a happy path in `UniqExactSet::merge` when one of the sets is empty. Also, now if the LHS set is two-level and the RHS is single-level, we won't do the conversion to two-level for the RHS. [#79971](https://github.com/ClickHouse/ClickHouse/pull/79971) ([Nikita Taranov](https://github.com/nickitat)).
* Make logging asynchronous by default. You can disable this by setting `<async>false</async>` under `<logger>`. [#80125](https://github.com/ClickHouse/ClickHouse/pull/80125) ([Raúl Marín](https://github.com/Algunenano)).
* Improve memory reuse efficiency and reduce page faults when using the twolevel hashtables. [#80245](https://github.com/ClickHouse/ClickHouse/pull/80245) ([Jiebin Sun](https://github.com/jiebinn)).
* Avoid unnecessary update and reduce lock contention in QueryConditionCache. [#80247](https://github.com/ClickHouse/ClickHouse/pull/80247) ([Jiebin Sun](https://github.com/jiebinn)).
* Trivial opt on `concatenateBlocks`. Maybe it's good for parallel hash join. [#80328](https://github.com/ClickHouse/ClickHouse/pull/80328) ([李扬](https://github.com/taiyang-li)).
* When selecting mark ranges from the primary key range, binary search cannot be used if the primary key is wrapped with functions. This PR improves this limitation: binary search can still be applied when the primary key is wrapped with an always monotonic function chain, or when the RPN contains an element that is always true. This PR closes [#45536](https://github.com/ClickHouse/ClickHouse/issues/45536). [#80597](https://github.com/ClickHouse/ClickHouse/pull/80597) ([zoomxi](https://github.com/zoomxi)).
* Improve shutdown speed of Kafka engine (remove extra 3 seconds delay in case of multiple Kafka tables). [#80796](https://github.com/ClickHouse/ClickHouse/pull/80796) ([Azat Khuzhin](https://github.com/azat)).
* Async insert: Reduce memory usage and improve performance of insert queries. [#80972](https://github.com/ClickHouse/ClickHouse/pull/80972) ([Raúl Marín](https://github.com/Algunenano)).
* Don't profile processors if the log table is disabled. [#81256](https://github.com/ClickHouse/ClickHouse/pull/81256) ([Raúl Marín](https://github.com/Algunenano)).
* Speed up toFixedString when the source is exactly what's requested. [#81257](https://github.com/ClickHouse/ClickHouse/pull/81257) ([Raúl Marín](https://github.com/Algunenano)).
* Don't process quota values if the user is not limited. [#81549](https://github.com/ClickHouse/ClickHouse/pull/81549) ([Raúl Marín](https://github.com/Algunenano)).
* Make ProcfsMetricsProvider thread_local to keep files open between tasks. [#81576](https://github.com/ClickHouse/ClickHouse/pull/81576) ([Raúl Marín](https://github.com/Algunenano)).
* Fixed performance regression in memory tracking. [#81694](https://github.com/ClickHouse/ClickHouse/pull/81694) ([Michael Kolupaev](https://github.com/al13n321)).

#### Improvement
* `EXPLAIN SYNTAX` now uses a new analyzer. It returns AST built from the query tree. Added option `query_tree_passes` to control the number of passes to executed before converting query tree to the AST. [#74536](https://github.com/ClickHouse/ClickHouse/pull/74536) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Use SLRU cache policy in filesystem cache by default. [#75072](https://github.com/ClickHouse/ClickHouse/pull/75072) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Refresh S3 credentials after error `AuthenticationRequired`. [#77353](https://github.com/ClickHouse/ClickHouse/pull/77353) ([Vitaly Baranov](https://github.com/vitlibar)).
* Added dictionary metrics to `system.asynchronous_metrics` - `DictionaryMaxUpdateDelay` - The maximum delay(in seconds) of dictionary update. - `DictionaryTotalFailedUpdates` - Number of errors since last successful loading in all dictionaries. [#78175](https://github.com/ClickHouse/ClickHouse/pull/78175) ([Vlad](https://github.com/codeworse)).
* Improve the sharding key optimization on distributed query. [#78452](https://github.com/ClickHouse/ClickHouse/pull/78452) ([fhw12345](https://github.com/fhw12345)).
* Implement Kafka rebalance like logic for StorageKafka2 using ClickHouse Keeper For each replica we support two types of partition locks: permanent locks and temporary locks. The replica tries to hold permanent locks as long as possible, at any given time there are no more than `all_topic_partitions / active_replicas_count` (here `all_topic_partitions` is the number of all partitions, `active_replicas_count` is the number of active replicas) permanent locks on the replica, if there are more, then the replica releases some partitions. Some partitions are temporarily held by the replica. The maximum number of temporary locks on a replica changes dynamically to give other replicas a chance to take some partitions into permanent locks. When updating temporary locks, the replica releases them all and tries to take some others again. [#78726](https://github.com/ClickHouse/ClickHouse/pull/78726) ([Daria Fomina](https://github.com/sinfillo)).
* Add warning about databases that were potentially created to save broken tables. [#78841](https://github.com/ClickHouse/ClickHouse/pull/78841) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Add _time virtual column in S3Queue engine. [#78926](https://github.com/ClickHouse/ClickHouse/pull/78926) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Make settings controlling connection drop on overloaded CPU hot-reloadable. [#79052](https://github.com/ClickHouse/ClickHouse/pull/79052) ([Alexey Katsman](https://github.com/alexkats)).
* Add container prefix to data paths reported in system.tables for plain disks in Azure blob storage, making reporting consistent with S3 and GCP. [#79241](https://github.com/ClickHouse/ClickHouse/pull/79241) ([Julia Kartseva](https://github.com/jkartseva)).
* Now, ClickHouse also accepts query parameters as `param-<name>` (dash) along with `param_<name>` (underscore). This closes [#63093](https://github.com/ClickHouse/ClickHouse/issues/63093). [#79429](https://github.com/ClickHouse/ClickHouse/pull/79429) ([Engel Danila](https://github.com/aaaengel)).
* Detailed warning msg for bandwidth discount when copying data from local to remote S3 with checksum enabled. [#79464](https://github.com/ClickHouse/ClickHouse/pull/79464) ([VicoWu](https://github.com/VicoWu)).
* Previously when `input_format_parquet_max_block_size = 0` ClickHouse would stuck. Now this behaviour is fixed. This closes [#79394](https://github.com/ClickHouse/ClickHouse/issues/79394). [#79601](https://github.com/ClickHouse/ClickHouse/pull/79601) ([abashkeev](https://github.com/abashkeev)).
* Add `throw_on_error` setting for startup_scripts: when `throw_on_error` is true, the server will not start unless all queries complete successfully. By default, `throw_on_error` is false, preserving the previous behavior. [#79732](https://github.com/ClickHouse/ClickHouse/pull/79732) ([Aleksandr Musorin](https://github.com/AVMusorin)).
* Allow to add `http_response_headers` in `http_handlers` of any kind. [#79975](https://github.com/ClickHouse/ClickHouse/pull/79975) ([Andrey Zvonov](https://github.com/zvonand)).
* Allow moving `GLOBAL [NOT] IN` predicate to `PREWHERE` clause if applicable. [#79996](https://github.com/ClickHouse/ClickHouse/pull/79996) ([Eduard Karacharov](https://github.com/korowa)).
* Function reverse support Tuple data type. Closes [#80053](https://github.com/ClickHouse/ClickHouse/issues/80053). [#80083](https://github.com/ClickHouse/ClickHouse/pull/80083) ([flynn](https://github.com/ucasfl)).
* This tiny patch resolve [#75817](https://github.com/ClickHouse/ClickHouse/issues/75817): allows get `auxiliary_zookeepers` data from `system.zookeeper` table. [#80146](https://github.com/ClickHouse/ClickHouse/pull/80146) ([Nikolay Govorov](https://github.com/mrdimidium)).
* Add asynchronous metrics about the server's TCP sockets. This improves the observability. Closes [#80187](https://github.com/ClickHouse/ClickHouse/issues/80187). [#80188](https://github.com/ClickHouse/ClickHouse/pull/80188) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Function `tokens` now supports `string` as a tokenizer. [#80195](https://github.com/ClickHouse/ClickHouse/pull/80195) ([Robert Schulze](https://github.com/rschu1ze)).
* Parallel replicas: avoid waiting for slow unused replicas if all read tasks have been assigned to other replicas. [#80199](https://github.com/ClickHouse/ClickHouse/pull/80199) ([Igor Nikonov](https://github.com/devcrafter)).
* Support anylast_respect_nulls and any_respect_nulls in simpleaggregatefunction. [#80219](https://github.com/ClickHouse/ClickHouse/pull/80219) ([Diskein](https://github.com/Diskein)).
* Remove unnecessary call `adjustCreateQueryForBackup()` for replicated databases. [#80282](https://github.com/ClickHouse/ClickHouse/pull/80282) ([Vitaly Baranov](https://github.com/vitlibar)).
* Allow extra options (that go after `--` like `-- --config.value='abc'`) in `clickhouse-local` without the equality sign. Closes [#80292](https://github.com/ClickHouse/ClickHouse/issues/80292). [#80293](https://github.com/ClickHouse/ClickHouse/pull/80293) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlight metacharacters in `SHOW ... LIKE` queries. This closes [#80275](https://github.com/ClickHouse/ClickHouse/issues/80275). [#80297](https://github.com/ClickHouse/ClickHouse/pull/80297) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make SQL UDF persistent in `clickhouse-local`. The previously created function will be loaded at startup. This closes [#80085](https://github.com/ClickHouse/ClickHouse/issues/80085). [#80300](https://github.com/ClickHouse/ClickHouse/pull/80300) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support comparison between Time/Time64. [#80327](https://github.com/ClickHouse/ClickHouse/pull/80327) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix description in explain plan for preliminary distinct step. [#80330](https://github.com/ClickHouse/ClickHouse/pull/80330) ([UnamedRus](https://github.com/UnamedRus)).
* Allow to use named collections in ODBC/JDBC. [#80334](https://github.com/ClickHouse/ClickHouse/pull/80334) ([Andrey Zvonov](https://github.com/zvonand)).
* Enable multiple-projection filtering support, allowing to use more than one projection for part-level filtering. This addresses [#55525](https://github.com/ClickHouse/ClickHouse/issues/55525). This is the second step to implement projection index, following [#78429](https://github.com/ClickHouse/ClickHouse/issues/78429). [#80343](https://github.com/ClickHouse/ClickHouse/pull/80343) ([Amos Bird](https://github.com/amosbird)).
* Metrics for number of readonly and broken disks. Indicator logs when DiskLocalCheckThread is started. [#80391](https://github.com/ClickHouse/ClickHouse/pull/80391) ([VicoWu](https://github.com/VicoWu)).
* Implement support for `s3_plain_rewritable` storage with projections. In previous versions, metadata objects in S3 referencing projections would not get updated when moved. Closes [#70258](https://github.com/ClickHouse/ClickHouse/issues/70258). [#80393](https://github.com/ClickHouse/ClickHouse/pull/80393) ([Sav](https://github.com/sberss)).
* Parallel replicas uses separate connection timeout, see `parallel_replicas_connect_timeout_ms` setting. Before `connect_timeout_with_failover_ms`/`connect_timeout_with_failover_secure_ms` settings were used as connection timeout values for parallel replicas queries (1 second by default). [#80421](https://github.com/ClickHouse/ClickHouse/pull/80421) ([Igor Nikonov](https://github.com/devcrafter)).
* The `SYSTEM UNFREEZE` command will not try to look up parts in readonly and write-once disks. This closes [#80430](https://github.com/ClickHouse/ClickHouse/issues/80430). [#80432](https://github.com/ClickHouse/ClickHouse/pull/80432) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Changed log level of a merged parts message from INFO to TRACE. [#80476](https://github.com/ClickHouse/ClickHouse/pull/80476) ([Hans Krutzer](https://github.com/hkrutzer)).
* Implement flattened serialization for Dynamic and JSON in Native format that allows to serialize/deserialize Dynamic and JSON data without special structures like shared variant for Dynamic and shared data for JSON. This serialization can be enabled by setting `output_format_native_use_flattened_dynamic_and_json_serialization`. This serialization can be used for easier support for Dynamic and JSON in TCP protocol in clients in different languages. [#80499](https://github.com/ClickHouse/ClickHouse/pull/80499) ([Pavel Kruglov](https://github.com/Avogar)).
* This change the default behavior of partition pruning for Iceberg table. [#80583](https://github.com/ClickHouse/ClickHouse/pull/80583) ([Melvyn Peignon](https://github.com/melvynator)).
* Add two new ProfileEvents for index search algorithm observability: IndexBinarySearchAlgorithm and IndexGenericExclusionSearchAlgorithm. [#80679](https://github.com/ClickHouse/ClickHouse/pull/80679) ([Pablo Marcos](https://github.com/pamarcos)).
* Do not complain about unsupported MADV_POPULATE_WRITE for older kernels in logs (to avoid logs polluting). [#80704](https://github.com/ClickHouse/ClickHouse/pull/80704) ([Robert Schulze](https://github.com/rschu1ze)).
* Added support for Date32, DateTime64 in TTL. [#80710](https://github.com/ClickHouse/ClickHouse/pull/80710) ([Andrey Zvonov](https://github.com/zvonand)).
* Adjust compatibility values for max_merge_delayed_streams_for_parallel_write. [#80760](https://github.com/ClickHouse/ClickHouse/pull/80760) ([Azat Khuzhin](https://github.com/azat)).
* Fix a crash: if an exception is thrown in an attempt to remove a temporary file (they are used for spilling temporary data on disk) in the destructor, the program can terminate. [#80776](https://github.com/ClickHouse/ClickHouse/pull/80776) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add IF EXISTS modifier to SYSTEM SYNC REPLICA. [#80810](https://github.com/ClickHouse/ClickHouse/pull/80810) ([Raúl Marín](https://github.com/Algunenano)).
* Extend exception message about "Having zero bytes, but read range is not finished...", add finished_download_time column to system.filesystem_cache'. [#80849](https://github.com/ClickHouse/ClickHouse/pull/80849) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Previously, `packed` storage was not supported for the full-text index, because the segment id was updated on-fly by reading and writing (`.gin_sid`) file on disk. In case of packed storage, reading a value from the uncommited file is not supported and this led to an issue. [#80852](https://github.com/ClickHouse/ClickHouse/pull/80852) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add search algorithm section to EXPLAIN output when using it with indexes = 1. If shows either "binary search" or "generic exclusion search". [#80881](https://github.com/ClickHouse/ClickHouse/pull/80881) ([Pablo Marcos](https://github.com/pamarcos)).
* At the beginning of 2024, `prefer_column_name_to_alias` was hardcoded to True for MySQL handler because the new analyzer was not enabled by default. Now, it can be unhardcoded. [#80916](https://github.com/ClickHouse/ClickHouse/pull/80916) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Now `system.iceberg_history` shows history for catalogs databases like glue or iceberg rest. Also renamed `table_name` and `database_name` columns to `table` and `database` in `system.iceberg_history` for consistency. [#80975](https://github.com/ClickHouse/ClickHouse/pull/80975) ([alesapin](https://github.com/alesapin)).
* Allow read-only mode for the `merge` table function, so the `CREATE TEMPORARY TABLE` grant is not required for using it. [#80981](https://github.com/ClickHouse/ClickHouse/pull/80981) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Better introspection of in-memory caches (expose information about caches in `system.metrics` over incomplete `system.asynchronouse_metrics`). Add in-memory caches size (in bytes) into `dashboard.html`. `VectorSimilarityIndexCacheSize`/`IcebergMetadataFilesCacheSize` has been renamed to `VectorSimilarityIndexCacheBytes`/`IcebergMetadataFilesCacheBytes`. [#81023](https://github.com/ClickHouse/ClickHouse/pull/81023) ([Azat Khuzhin](https://github.com/azat)).
* Ignore databases with engines that can't contain RocksDB tables while reading from system.rocksdb. [#81083](https://github.com/ClickHouse/ClickHouse/pull/81083) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Allow `filesystem_caches` and `named_collections` in the `clickhouse-local` configuration file. [#81105](https://github.com/ClickHouse/ClickHouse/pull/81105) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix highlighting of `PARTITION BY` in `INSERT` queries. In previous versions, `PARTITION BY` was not highlighted as a keyword. [#81106](https://github.com/ClickHouse/ClickHouse/pull/81106) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Two mini improvements in Web UI: - correctly handle queries without output, such as `CREATE`, `INSERT` (until recently, these queries resulted in an infinite spinner); - when double clicking on a table, scroll to the top. [#81131](https://github.com/ClickHouse/ClickHouse/pull/81131) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update `c-ares` to `v1.34.5`. [#81159](https://github.com/ClickHouse/ClickHouse/pull/81159) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Upgrade curl to 8.14 to address CVE-2025-5025 and CVE-2025-4947. [#81171](https://github.com/ClickHouse/ClickHouse/pull/81171) ([larryluogit](https://github.com/larryluogit)).
* Upgrade libarchive to 3.7.9 to address: CVE-2024-20696 CVE-2025-25724 CVE-2024-48958 CVE-2024-57970 CVE-2025-1632 CVE-2024-48957 CVE-2024-48615. [#81174](https://github.com/ClickHouse/ClickHouse/pull/81174) ([larryluogit](https://github.com/larryluogit)).
* Upgrade libxml2 to 2.14.3. [#81187](https://github.com/ClickHouse/ClickHouse/pull/81187) ([larryluogit](https://github.com/larryluogit)).
* MemoryResidentWithoutPageCache provides the amount of physical memory used by the server process, excluding userspace page cache, in bytes. This provides a more accurate view of actual memory usage when userspace page cache is utilized. When userspace page cache is disabled, this value equals MemoryResident. [#81233](https://github.com/ClickHouse/ClickHouse/pull/81233) ([Jayme Bird](https://github.com/jaymebrd)).
* Mark manually logged exceptions in client, local server, keeper client and disks app as logged, so that they are not logged twice. [#81271](https://github.com/ClickHouse/ClickHouse/pull/81271) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Setting `use_skip_indexes_if_final` and `use_skip_indexes_if_final_exact_mode` now default to `True`. Queries with `FINAL` clause will now use skip indexes (if applicable) to shortlist granules and also read any additional granules corresponding to matching primary key ranges. Users needing earlier behaviour of approximate/imprecise results can set `use_skip_indexes_if_final_exact_mode` to FALSE after careful evaluation. [#81331](https://github.com/ClickHouse/ClickHouse/pull/81331) ([Shankar Iyer](https://github.com/shankar-iyer)).
* When you have multiple queries in the web UI, it will run the one under the cursor. Continuation of [#80977](https://github.com/ClickHouse/ClickHouse/issues/80977). [#81354](https://github.com/ClickHouse/ClickHouse/pull/81354) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This PR addresses issues with the implementation of is_strict in the monotonicity checks for conversion functions. Currently, some conversion functions, such as toFloat64(UInt32) and toDate(UInt8), incorrectly return is_strict as false when they should return true. [#81359](https://github.com/ClickHouse/ClickHouse/pull/81359) ([zoomxi](https://github.com/zoomxi)).
* In filesystem with journal `mkdir` is written to the journal of filesystem which is persisted to disk. In case of slow disk this can take long time. Definitely make sense to move out from reserve lock scope. [#81371](https://github.com/ClickHouse/ClickHouse/pull/81371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* When checking if a `KeyCondition` matches a continuous range, if the key is wrapped with a non-strict function chain, a `Constraint::POINT` may needs to be converted to a`Constraint::RANGE`. For example: `toDate(event_time) = '2025-06-03'` implies a range for `event_time`: ['2025-06-03 00:00:00', '2025-06-04 00:00:00'). This PR fixes this behavior. [#81400](https://github.com/ClickHouse/ClickHouse/pull/81400) ([zoomxi](https://github.com/zoomxi)).
* Use `postgres` 16.9. [#81437](https://github.com/ClickHouse/ClickHouse/pull/81437) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `openssl` 3.2.4. [#81438](https://github.com/ClickHouse/ClickHouse/pull/81438) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `abseil-cpp` 2025-01-27. [#81440](https://github.com/ClickHouse/ClickHouse/pull/81440) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `mongo-c-driver` 1.30.4. [#81449](https://github.com/ClickHouse/ClickHouse/pull/81449) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `krb5` 1.21.3-final. [#81453](https://github.com/ClickHouse/ClickHouse/pull/81453) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `orc` 2.1.2. [#81455](https://github.com/ClickHouse/ClickHouse/pull/81455) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Add support for the `--database` argument in `clickhouse-local`. You can switch to a previously created database. This closes [#44115](https://github.com/ClickHouse/ClickHouse/issues/44115). [#81465](https://github.com/ClickHouse/ClickHouse/pull/81465) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `clickhouse`/`ch` aliases will invoke `clickhouse-client` instead of `clickhouse-local` if `--host` or `--port` are specified. Continuation of [#79422](https://github.com/ClickHouse/ClickHouse/issues/79422). Closes [#65252](https://github.com/ClickHouse/ClickHouse/issues/65252). [#81509](https://github.com/ClickHouse/ClickHouse/pull/81509) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Now that we have the keeper response time distribution data, we can tune the histogram buckets. [#81516](https://github.com/ClickHouse/ClickHouse/pull/81516) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Postpone reading of Iceberg manifest files until first reading query. [#81619](https://github.com/ClickHouse/ClickHouse/pull/81619) ([Daniil Ivanik](https://github.com/divanik)).
* Use `grpc` 1.73.0. [#81629](https://github.com/ClickHouse/ClickHouse/pull/81629) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `delta-kernel-rs` v0.12.1. [#81707](https://github.com/ClickHouse/ClickHouse/pull/81707) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Add profile event `PageCacheReadBytes`. [#81742](https://github.com/ClickHouse/ClickHouse/pull/81742) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81934](https://github.com/ClickHouse/ClickHouse/issues/81934): Try fix logical error in filesystem cache: "Having zero bytes but range is not finished". [#81868](https://github.com/ClickHouse/ClickHouse/pull/81868) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82363](https://github.com/ClickHouse/ClickHouse/issues/82363): Function `addressToSymbol` and `system.symbols` table will use file offsets instead of virtual memory addresses. [#81896](https://github.com/ClickHouse/ClickHouse/pull/81896) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82623](https://github.com/ClickHouse/ClickHouse/issues/82623): Use `abseil-cpp` 20250512.0. [#81945](https://github.com/ClickHouse/ClickHouse/pull/81945) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82632](https://github.com/ClickHouse/ClickHouse/issues/82632): Use `google-protobuf` v31.1. [#81976](https://github.com/ClickHouse/ClickHouse/pull/81976) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82471](https://github.com/ClickHouse/ClickHouse/issues/82471): Add ability to reload `max_local_read_bandwidth_for_server` and `max_local_write_bandwidth_for_server` on fly without restart server. [#82083](https://github.com/ClickHouse/ClickHouse/pull/82083) ([Kai Zhu](https://github.com/nauu)).
* Backported in [#82595](https://github.com/ClickHouse/ClickHouse/issues/82595): Keeper improvement: add new config `keeper_server.cleanup_old_and_ignore_new_acl`. If enabled, all nodes will have their ACLs cleared while ACL for new requests will be ignored. If the goal is to completely remove ACL from nodes, it's important to leave the config enabled until a new snapshot is created. [#82496](https://github.com/ClickHouse/ClickHouse/pull/82496) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fix parameterized view with SELECT EXCEPT query. Closes [#49447](https://github.com/ClickHouse/ClickHouse/issues/49447). [#57380](https://github.com/ClickHouse/ClickHouse/pull/57380) ([Nikolay Degterinsky](https://github.com/evillique)).
* Analyzer: Fix column projection name after column type promotion in join. Closes [#63345](https://github.com/ClickHouse/ClickHouse/issues/63345). [#63519](https://github.com/ClickHouse/ClickHouse/pull/63519) ([Dmitry Novik](https://github.com/novikd)).
* Fixed a logical error in cases of column name clashes when analyzer_compatibility_join_using_top_level_identifier is enabled. [#75676](https://github.com/ClickHouse/ClickHouse/pull/75676) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix CTE usage in pushed-down predicates when `allow_push_predicate_ast_for_distributed_subqueries` is enabled. Fixes [#75647](https://github.com/ClickHouse/ClickHouse/issues/75647). Fixes [#79672](https://github.com/ClickHouse/ClickHouse/issues/79672). [#77316](https://github.com/ClickHouse/ClickHouse/pull/77316) ([Dmitry Novik](https://github.com/novikd)).
* Fixes an issue where SYSTEM SYNC REPLICA LIGHTWEIGHT 'foo' would report success even when the specified replica didn't exist. The command now properly validates that the replica exists in Keeper before attempting synchronization. [#78405](https://github.com/ClickHouse/ClickHouse/pull/78405) ([Jayme Bird](https://github.com/jaymebrd)).
* Fix crash for a very specific situation when the `currentDatabase` function was used in `CONSTRAINT` sections for `ON CLUSTER` queries Closes [#78100](https://github.com/ClickHouse/ClickHouse/issues/78100). [#79070](https://github.com/ClickHouse/ClickHouse/pull/79070) ([pufit](https://github.com/pufit)).
* Fix passing of external roles in interserver queries. [#79099](https://github.com/ClickHouse/ClickHouse/pull/79099) ([Andrey Zvonov](https://github.com/zvonand)).
* Try to use IColumn instead of Field in SingleValueDataGeneric. It fixes the incorrect return values for some aggregate functions like `argMax` for types `Dynamic/Variant/JSON`. [#79166](https://github.com/ClickHouse/ClickHouse/pull/79166) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix applying use_native_copy and allow_azure_native_copy setting for azure blob storage and updated to use native copy only when credentials match resolves [#78964](https://github.com/ClickHouse/ClickHouse/issues/78964). [#79561](https://github.com/ClickHouse/ClickHouse/pull/79561) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Fix logical errors about a column's unknown origin scope produced while checking if this column is correlated. Fixes [#78183](https://github.com/ClickHouse/ClickHouse/issues/78183). Fixes [#79451](https://github.com/ClickHouse/ClickHouse/issues/79451). [#79727](https://github.com/ClickHouse/ClickHouse/pull/79727) ([Dmitry Novik](https://github.com/novikd)).
* Fix wrong results for grouping sets with ColumnConst and Analyzer. [#79743](https://github.com/ClickHouse/ClickHouse/pull/79743) ([Andrey Zvonov](https://github.com/zvonand)).
* Fix local shard result duplication when reading from distributed table with local replica being stale. [#79761](https://github.com/ClickHouse/ClickHouse/pull/79761) ([Eduard Karacharov](https://github.com/korowa)).
* Fix the sorting order of the NaNs with a negative sign bit. [#79847](https://github.com/ClickHouse/ClickHouse/pull/79847) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Now GROUP BY ALL doesn't take into account the GROUPING part. [#79915](https://github.com/ClickHouse/ClickHouse/pull/79915) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fixed incorrect state merging for `TopK` / `TopKWeighted` functions that would cause excessive error values even when capacity was not exhausted. [#79939](https://github.com/ClickHouse/ClickHouse/pull/79939) ([Joel Höner](https://github.com/athre0z)).
* Respect `readonly` setting in `azure_blob_storage` object storage. [#79954](https://github.com/ClickHouse/ClickHouse/pull/79954) ([Julia Kartseva](https://github.com/jkartseva)).
* Fixed incorrect query results and out-of-memory crashes when using `match(column, '^…')` with backslash-escaped characters. [#79969](https://github.com/ClickHouse/ClickHouse/pull/79969) ([filimonov](https://github.com/filimonov)).
* Disabling hive partitioning for datalakes Partially addresses https://github.com/issues/assigned?issue=ClickHouse%7CClickHouse%7C79937. [#80005](https://github.com/ClickHouse/ClickHouse/pull/80005) ([Daniil Ivanik](https://github.com/divanik)).
* Skip indexes with lambda expressions could not be applied. Fix the case when high-level functions in the index definition exactly match the one in the query. [#80025](https://github.com/ClickHouse/ClickHouse/pull/80025) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix metadata version during attach part on the replica executing ATTACH_PART command from replication log. [#80038](https://github.com/ClickHouse/ClickHouse/pull/80038) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Executable User Defined Functions (eUDF) names are not added to the `used_functions` column of the `system.query_log` table, unlike other functions. This PR implements the addition of the eUDF name if the eUDF was used in the request. [#80073](https://github.com/ClickHouse/ClickHouse/pull/80073) ([Kyamran](https://github.com/nibblerenush)).
* Fix logical error in Arrow format with LowCardinality(FixedString). [#80156](https://github.com/ClickHouse/ClickHouse/pull/80156) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix reading subcolumns from Merge engine. [#80158](https://github.com/ClickHouse/ClickHouse/pull/80158) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix a bug about the comparison between numeric types in `KeyCondition`. [#80207](https://github.com/ClickHouse/ClickHouse/pull/80207) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix AMBIGUOUS_COLUMN_NAME when lazy materialization applied to table with projections. [#80251](https://github.com/ClickHouse/ClickHouse/pull/80251) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix incorrect count optimization for string prefix filters like LIKE 'ab_c%' when using implicit projections. This fixes [#80250](https://github.com/ClickHouse/ClickHouse/issues/80250). [#80261](https://github.com/ClickHouse/ClickHouse/pull/80261) ([Amos Bird](https://github.com/amosbird)).
* Fix improper serialization of nested numeric fields as strings in MongoDB documents. Remove maximum depth limit for documents from MongoDB. [#80289](https://github.com/ClickHouse/ClickHouse/pull/80289) ([Kirill Nikiforov](https://github.com/allmazz)).
* Perform less strict metadata checks for RMT in the Replicated database. Closes [#80296](https://github.com/ClickHouse/ClickHouse/issues/80296). [#80298](https://github.com/ClickHouse/ClickHouse/pull/80298) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix text representation of DateTime and DateTime64 for PostgreSQL storage. [#80301](https://github.com/ClickHouse/ClickHouse/pull/80301) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Allow `DateTime` with timezone in `StripeLog` tables. This closes [#44120](https://github.com/ClickHouse/ClickHouse/issues/44120). [#80304](https://github.com/ClickHouse/ClickHouse/pull/80304) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disable filter-push-down for the predicate with a non-deterministic function in case the query plan step changes the number of rows. Fixes [#40273](https://github.com/ClickHouse/ClickHouse/issues/40273). [#80329](https://github.com/ClickHouse/ClickHouse/pull/80329) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible logical errors and crashes in projections with subcolumns. [#80333](https://github.com/ClickHouse/ClickHouse/pull/80333) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix `NOT_FOUND_COLUMN_IN_BLOCK` error caused by filter-push-down optimization of the logical JOIN sep in case `ON` expression is not a trivial equality. Fixes [#79647](https://github.com/ClickHouse/ClickHouse/issues/79647) Fixes [#77848](https://github.com/ClickHouse/ClickHouse/issues/77848). [#80360](https://github.com/ClickHouse/ClickHouse/pull/80360) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix incorrect result when reading reverse-ordered keys in partitioned tables. This fixes [#79987](https://github.com/ClickHouse/ClickHouse/issues/79987). [#80448](https://github.com/ClickHouse/ClickHouse/pull/80448) ([Amos Bird](https://github.com/amosbird)).
* Fixed wrong sorting in tables with a nullable key and enabled optimize_read_in_order. [#80515](https://github.com/ClickHouse/ClickHouse/pull/80515) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fixed refreshable materialized view DROP getting stuck if the view was paused using SYSTEM STOP REPLICATED VIEW. [#80543](https://github.com/ClickHouse/ClickHouse/pull/80543) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix 'Cannot find column' with constant tuple in distributed query. [#80596](https://github.com/ClickHouse/ClickHouse/pull/80596) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix `shardNum` function in Distributed tables with `join_use_nulls`. [#80612](https://github.com/ClickHouse/ClickHouse/pull/80612) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix incorrect result during reading column that exists in subset of tables in Merge engine. [#80643](https://github.com/ClickHouse/ClickHouse/pull/80643) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix possible SSH protocol (due to hang in replxx). [#80688](https://github.com/ClickHouse/ClickHouse/pull/80688) ([Azat Khuzhin](https://github.com/azat)).
* The timestamp in the iceberg_history table should now be correct. [#80711](https://github.com/ClickHouse/ClickHouse/pull/80711) ([Melvyn Peignon](https://github.com/melvynator)).
* Fix possible crash in case of dictionary registration failed (when `CREATE DICTIONARY` failed with `CANNOT_SCHEDULE_TASK` it is possible to leave dangling pointer in the dictionary registry, which later lead to crash). [#80714](https://github.com/ClickHouse/ClickHouse/pull/80714) ([Azat Khuzhin](https://github.com/azat)).
* Fix handling of enum globs of a single element in object storage table functions. [#80716](https://github.com/ClickHouse/ClickHouse/pull/80716) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix wrong result type of comparison functions with Tuple(Dynamic) and String that led to logical error. [#80728](https://github.com/ClickHouse/ClickHouse/pull/80728) ([Pavel Kruglov](https://github.com/Avogar)).
* Add missing support data type `timestamp_ntz` for unity catalog. Fixes [#79535](https://github.com/ClickHouse/ClickHouse/issues/79535), Fixes [#79875](https://github.com/ClickHouse/ClickHouse/issues/79875). [#80740](https://github.com/ClickHouse/ClickHouse/pull/80740) ([alesapin](https://github.com/alesapin)).
* Backported in [#82189](https://github.com/ClickHouse/ClickHouse/issues/82189): Fix logical error during materialize projection when column type was changed to Nullable. [#80741](https://github.com/ClickHouse/ClickHouse/pull/80741) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix `THERE_IS_NO_COLUMN` error for distributed queries with `IN cte`. Fixes [#75032](https://github.com/ClickHouse/ClickHouse/issues/75032). [#80757](https://github.com/ClickHouse/ClickHouse/pull/80757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix excessive number of files (leads to excessive memory usage) for external ORDER BY. [#80777](https://github.com/ClickHouse/ClickHouse/pull/80777) ([Azat Khuzhin](https://github.com/azat)).
* This PR might close [#80742](https://github.com/ClickHouse/ClickHouse/issues/80742). [#80783](https://github.com/ClickHouse/ClickHouse/pull/80783) ([zoomxi](https://github.com/zoomxi)).
* Fix crash in Kafka due to get_member_id() was creating std::string from NULL (it was likely an issue only in case of connection to broker had been failed). [#80793](https://github.com/ClickHouse/ClickHouse/pull/80793) ([Azat Khuzhin](https://github.com/azat)).
* Properly wait consumers before shutting down Kafka engine (active consumers after shutdown can trigger various debug assertions and also may read data from brokers in background after table has been dropped/detached). [#80795](https://github.com/ClickHouse/ClickHouse/pull/80795) ([Azat Khuzhin](https://github.com/azat)).
* Fix `NOT_FOUND_COLUMN_IN_BLOCK`, which is caused by `predicate-push-down` optimization. Fixes [#80443](https://github.com/ClickHouse/ClickHouse/issues/80443). [#80834](https://github.com/ClickHouse/ClickHouse/pull/80834) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix logical error when resolving star (*) matcher in table function in JOIN with USING. [#80894](https://github.com/ClickHouse/ClickHouse/pull/80894) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix memory accounting for Iceberg metadata files cache. [#80904](https://github.com/ClickHouse/ClickHouse/pull/80904) ([Azat Khuzhin](https://github.com/azat)).
* Fix wrong partitioning with nullable partition key. [#80913](https://github.com/ClickHouse/ClickHouse/pull/80913) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix `Table does not exist` error for distributed queries with pushed-down predicate (`allow_push_predicate_ast_for_distributed_subqueries=1`) when the source table does not exist on the initialtor. Fixes [#77281](https://github.com/ClickHouse/ClickHouse/issues/77281). [#80915](https://github.com/ClickHouse/ClickHouse/pull/80915) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix the logical error in the nested functions with named windows. [#80926](https://github.com/ClickHouse/ClickHouse/pull/80926) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix extremes for nullable and floating-point columns. [#80970](https://github.com/ClickHouse/ClickHouse/pull/80970) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix possible crash while querying from system.tables (likely the case under memory pressure). [#80976](https://github.com/ClickHouse/ClickHouse/pull/80976) ([Azat Khuzhin](https://github.com/azat)).
* Fix atomic rename with truncate for files which compression is inferred from their file extension. [#80979](https://github.com/ClickHouse/ClickHouse/pull/80979) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix ErrorCodes::getName. [#81032](https://github.com/ClickHouse/ClickHouse/pull/81032) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Fix bug when user cannot list tables in Unity Catalog without permissions for all of them. Now all tables are listed properly, attempt to read from restricted table will throw an exception. [#81044](https://github.com/ClickHouse/ClickHouse/pull/81044) ([alesapin](https://github.com/alesapin)).
* Now ClickHouse will ignore errors and unexpected responses from data lake catalogs in `SHOW TABLES` query. Fixes [#79725](https://github.com/ClickHouse/ClickHouse/issues/79725). [#81046](https://github.com/ClickHouse/ClickHouse/pull/81046) ([alesapin](https://github.com/alesapin)).
* Fix parsing of DateTime64 from integers in JSONExtract and JSON type parsing. [#81050](https://github.com/ClickHouse/ClickHouse/pull/81050) ([Pavel Kruglov](https://github.com/Avogar)).
* Reflect date_time_input_format setting in schema inference cache. [#81052](https://github.com/ClickHouse/ClickHouse/pull/81052) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix crash on INSERT if table was DROPed after query started but before columns sent. [#81053](https://github.com/ClickHouse/ClickHouse/pull/81053) ([Azat Khuzhin](https://github.com/azat)).
* Fix use-of-uninitialized-value in quantileDeterministic. [#81062](https://github.com/ClickHouse/ClickHouse/pull/81062) ([Azat Khuzhin](https://github.com/azat)).
* Fix hardlinks count management for metadatastoragefromdisk disk transactions. add tests. [#81066](https://github.com/ClickHouse/ClickHouse/pull/81066) ([Sema Checherinda](https://github.com/CheSema)).
* User Defined Functions (UDF) names are not added to the `system.query_log` table, unlike other functions. This PR implements the addition of the UDF name to one of the two columns `used_executable_user_defined_functions` or `used_sql_user_defined_functions` if the UDF was used in the request. [#81101](https://github.com/ClickHouse/ClickHouse/pull/81101) ([Kyamran](https://github.com/nibblerenush)).
* Fixed `Too large size ... passed to allocator` errors or possible crashes on inserts via http protocol with text formats (`JSON`, `Values`, ...) and omitted `Enum` fields. [#81145](https://github.com/ClickHouse/ClickHouse/pull/81145) ([Anton Popov](https://github.com/CurtizJ)).
* Fix LOGICAL_ERROR in case of Sparse column in INSERT block pushed to non-MT MV. [#81161](https://github.com/ClickHouse/ClickHouse/pull/81161) ([Azat Khuzhin](https://github.com/azat)).
* Fix `Unknown table expression identifier` for `distributed_product_mode_local=local` with cross-replication. [#81162](https://github.com/ClickHouse/ClickHouse/pull/81162) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed incorrectly caching number of rows in parquet files after filtering. [#81184](https://github.com/ClickHouse/ClickHouse/pull/81184) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix fs cache max_size_to_total_space setting when used with relative cache path. [#81237](https://github.com/ClickHouse/ClickHouse/pull/81237) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed clickhouse-local crashing when outputting const tuples or maps in Parquet format. [#81249](https://github.com/ClickHouse/ClickHouse/pull/81249) ([Michael Kolupaev](https://github.com/al13n321)).
* Verify array offsets received over network. [#81269](https://github.com/ClickHouse/ClickHouse/pull/81269) ([Azat Khuzhin](https://github.com/azat)).
* Fix some corner case in query that joins empty tables and uses window functions. The bug leads to exploding number of parallel streams which leads to OOMs. [#81299](https://github.com/ClickHouse/ClickHouse/pull/81299) ([Alexander Gololobov](https://github.com/davenger)).
* Fixes for datalake Cluster functions (`deltaLakeCluster`, `icebergCluster`, etc): (1) fix potential segfault in `DataLakeConfiguration` when using `Cluster` function with old analyzer; (2) remove duplicating data lake metadata updates (extra object storage requests); (3) fix redundant listing in object storage when format is not explicitly specified (which was already done for non-cluster data lake engines). [#81300](https://github.com/ClickHouse/ClickHouse/pull/81300) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make force_restore_data flag recover lost keeper metadata. [#81324](https://github.com/ClickHouse/ClickHouse/pull/81324) ([Raúl Marín](https://github.com/Algunenano)).
* Fix region error in delta-kernel. Fixes [#79914](https://github.com/ClickHouse/ClickHouse/issues/79914). [#81353](https://github.com/ClickHouse/ClickHouse/pull/81353) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable incorrect JIT for divideOrNull. [#81370](https://github.com/ClickHouse/ClickHouse/pull/81370) ([Raúl Marín](https://github.com/Algunenano)).
* Fix insert error when MergeTree table has a long partition column name. [#81390](https://github.com/ClickHouse/ClickHouse/pull/81390) ([hy123q](https://github.com/haoyangqian)).
* Backported in [#81957](https://github.com/ClickHouse/ClickHouse/issues/81957): Fixed possible crash in `Aggregator` in case of exception during merge. [#81450](https://github.com/ClickHouse/ClickHouse/pull/81450) ([Nikita Taranov](https://github.com/nickitat)).
* Don't store content of several manifest files in memory. [#81470](https://github.com/ClickHouse/ClickHouse/pull/81470) ([Daniil Ivanik](https://github.com/divanik)).
* Fix possible crash during shutting down background pools (`background_.*pool_size`). [#81473](https://github.com/ClickHouse/ClickHouse/pull/81473) ([Azat Khuzhin](https://github.com/azat)).
* Fix out-of-bounds read in the `Npy` format happening when writing to a table with the `URL` engine. This closes [#81356](https://github.com/ClickHouse/ClickHouse/issues/81356). [#81502](https://github.com/ClickHouse/ClickHouse/pull/81502) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* There is a chance that Web UI displays `NaN%` (typical JavaScript problems). [#81507](https://github.com/ClickHouse/ClickHouse/pull/81507) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix `DatabaseReplicated` for `database_replicated_enforce_synchronous_settings=1`. [#81564](https://github.com/ClickHouse/ClickHouse/pull/81564) ([Azat Khuzhin](https://github.com/azat)).
* Fix sorting order for LowCardinality(Nullable(...)) types. [#81583](https://github.com/ClickHouse/ClickHouse/pull/81583) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#82334](https://github.com/ClickHouse/ClickHouse/issues/82334): Fix `IN` execution with `transform_null_in=1` with null in the left argument and non-nullable subquery result. [#81584](https://github.com/ClickHouse/ClickHouse/pull/81584) ([Pavel Kruglov](https://github.com/Avogar)).
* Server should not preserve a HTTP connection if the request has not been fully read from the socket. [#81595](https://github.com/ClickHouse/ClickHouse/pull/81595) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#82179](https://github.com/ClickHouse/ClickHouse/issues/82179): Don't validate experimental/suspicious types in default/materialize expression execution during reading from existing table. [#81618](https://github.com/ClickHouse/ClickHouse/pull/81618) ([Pavel Kruglov](https://github.com/Avogar)).
* Make scalar correlated subqueries return a nullable result of the projection expression. Fix the case when a correlated subquery produces an empty result set. [#81632](https://github.com/ClickHouse/ClickHouse/pull/81632) ([Dmitry Novik](https://github.com/novikd)).
* Fix `Unexpected relative path for a deduplicated part` during `ATTACH` to `ReplicatedMergeTree`. [#81647](https://github.com/ClickHouse/ClickHouse/pull/81647) ([Azat Khuzhin](https://github.com/azat)).
* Query settings `use_iceberg_partition_pruning` will not take effect for iceberg storage, because it uses global context rather than query context. it's not critical because its default value is true. this pr can fix it. [#81673](https://github.com/ClickHouse/ClickHouse/pull/81673) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#82128](https://github.com/ClickHouse/ClickHouse/issues/82128): Fix "Context has expired" during merges when dict used in TTL expression. [#81690](https://github.com/ClickHouse/ClickHouse/pull/81690) ([Azat Khuzhin](https://github.com/azat)).
* Add validation for mergetree setting `merge_max_block_size` to ensure that it's non zero. [#81693](https://github.com/ClickHouse/ClickHouse/pull/81693) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix issues with `clickhouse-local` involving stuck `DROP VIEW ` queries. [#81705](https://github.com/ClickHouse/ClickHouse/pull/81705) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix StorageRedis join in some cases. [#81736](https://github.com/ClickHouse/ClickHouse/pull/81736) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix crash in `ConcurrentHashJoin` with empty `USING ()` and old analyzer enabled. [#81754](https://github.com/ClickHouse/ClickHouse/pull/81754) ([Nikita Taranov](https://github.com/nickitat)).
* Keeper fix: block commits of new logs if there is invalid entry in the logs. Previously, if leader applied some logs incorrectly, it would continue to commit new logs, even though the follower would detect digest mismatch and abort. [#81780](https://github.com/ClickHouse/ClickHouse/pull/81780) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82024](https://github.com/ClickHouse/ClickHouse/issues/82024): Fix the issue where required columns are not read during scalar correlated subquery processing. Fixes [#81716](https://github.com/ClickHouse/ClickHouse/issues/81716). [#81805](https://github.com/ClickHouse/ClickHouse/pull/81805) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#81940](https://github.com/ClickHouse/ClickHouse/issues/81940): Someone littered our code with Kusto. Cleaned it up. This closes [#81643](https://github.com/ClickHouse/ClickHouse/issues/81643). [#81885](https://github.com/ClickHouse/ClickHouse/pull/81885) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82294](https://github.com/ClickHouse/ClickHouse/issues/82294): In previous versions, the server returned excessive content for requests to `/js`. This closes [#61890](https://github.com/ClickHouse/ClickHouse/issues/61890). [#81895](https://github.com/ClickHouse/ClickHouse/pull/81895) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82230](https://github.com/ClickHouse/ClickHouse/issues/82230): Previously, `MongoDB` table engine definitions could include a path component in the `host:port` argument which was silently ignored. The mongodb integration refuses to load such tables. With this fix *we allow loading such tables and ignore path component* if `MongoDB` engine has five arguments, using the database name from arguments. *Note:* The fix is not applied for newly created tables or queries with `mongo` table function, as well as for dictionary sources and named collections. [#81942](https://github.com/ClickHouse/ClickHouse/pull/81942) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#82100](https://github.com/ClickHouse/ClickHouse/issues/82100): Fixed possible crash in `Aggregator` in case of exception during merge. [#82022](https://github.com/ClickHouse/ClickHouse/pull/82022) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#82554](https://github.com/ClickHouse/ClickHouse/issues/82554): Fix LOGICAL_ERROR and following crash when using the same column in the TTL for GROUP BY and SET. [#82054](https://github.com/ClickHouse/ClickHouse/pull/82054) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#82395](https://github.com/ClickHouse/ClickHouse/issues/82395): Fix S3 table function argument validation in secret masking, preventing possible `LOGICAL_ERROR`, close [#80620](https://github.com/ClickHouse/ClickHouse/issues/80620). [#82056](https://github.com/ClickHouse/ClickHouse/pull/82056) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#82143](https://github.com/ClickHouse/ClickHouse/issues/82143): Fixing copy-paste error in arraySimilarity, disallowing the use of UInt32 and Int32 weights. Update tests and docs. [#82103](https://github.com/ClickHouse/ClickHouse/pull/82103) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#82320](https://github.com/ClickHouse/ClickHouse/issues/82320): Fix the `Not found column` error for queries with `arrayJoin` under `WHERE` condition and `IndexSet`. [#82113](https://github.com/ClickHouse/ClickHouse/pull/82113) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#82264](https://github.com/ClickHouse/ClickHouse/issues/82264): Fix bug in glue catalog integration. Now clickhouse can read tables with nested data types where some of subcolumns contain decimals, for example: `map<string, decimal(9, 2)>`. Fixes [#81301](https://github.com/ClickHouse/ClickHouse/issues/81301). [#82114](https://github.com/ClickHouse/ClickHouse/pull/82114) ([alesapin](https://github.com/alesapin)).
* Backported in [#82404](https://github.com/ClickHouse/ClickHouse/issues/82404): Fix possible deadlock for remote queries when server is under memory pressure. [#82160](https://github.com/ClickHouse/ClickHouse/pull/82160) ([Kirill](https://github.com/kirillgarbar)).
* Backported in [#82590](https://github.com/ClickHouse/ClickHouse/issues/82590): Fix a bug in table dependencies causing Materialized Views to miss INSERT queries. [#82222](https://github.com/ClickHouse/ClickHouse/pull/82222) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#82296](https://github.com/ClickHouse/ClickHouse/issues/82296): Fix possible data-race between suggestion thread and main client thread. [#82233](https://github.com/ClickHouse/ClickHouse/pull/82233) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82525](https://github.com/ClickHouse/ClickHouse/issues/82525): Add expiration to AWS ECS token so it can be reloaded. [#82422](https://github.com/ClickHouse/ClickHouse/pull/82422) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82581](https://github.com/ClickHouse/ClickHouse/issues/82581): Fix hiding named collection values in logs/query_log. Closes [#82405](https://github.com/ClickHouse/ClickHouse/issues/82405). [#82510](https://github.com/ClickHouse/ClickHouse/pull/82510) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82572](https://github.com/ClickHouse/ClickHouse/issues/82572): Fix a possible crash in logging while terminating a session as the user_id might sometimes be empty. [#82513](https://github.com/ClickHouse/ClickHouse/pull/82513) ([Bharat Nallan](https://github.com/bharatnc)).

#### Build/Testing/Packaging Improvement
* Avoid copying vendored Rust sources to `CARGO_HOME`. [#79560](https://github.com/ClickHouse/ClickHouse/pull/79560) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove dependency on the Sentry library by replacing it with our own endpoint. [#80236](https://github.com/ClickHouse/ClickHouse/pull/80236) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update python dependencies in CI images to address Dependabot alerts. [#80658](https://github.com/ClickHouse/ClickHouse/pull/80658) ([Raúl Marín](https://github.com/Algunenano)).
* Retry reading of replicated DDL stop flag from Keeper at startup to make tests more robust when fault injection is enabled for Keeper. [#80964](https://github.com/ClickHouse/ClickHouse/pull/80964) ([Alexander Gololobov](https://github.com/davenger)).
* Use https for ubuntu archive url. [#81016](https://github.com/ClickHouse/ClickHouse/pull/81016) ([Raúl Marín](https://github.com/Algunenano)).
* Update python dependencies in test images. [#81042](https://github.com/ClickHouse/ClickHouse/pull/81042) ([dependabot[bot]](https://github.com/apps/dependabot)).
* Introduce `flake.nix` for Nix builds. [#81463](https://github.com/ClickHouse/ClickHouse/pull/81463) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix `delta-kernel-rs` requiring network access during build. Closes [#80609](https://github.com/ClickHouse/ClickHouse/issues/80609). [#81602](https://github.com/ClickHouse/ClickHouse/pull/81602) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL CATEGORY

* Backported in [#81986](https://github.com/ClickHouse/ClickHouse/issues/81986):. [#81975](https://github.com/ClickHouse/ClickHouse/pull/81975) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#82393](https://github.com/ClickHouse/ClickHouse/issues/82393):. [#82068](https://github.com/ClickHouse/ClickHouse/pull/82068) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82384](https://github.com/ClickHouse/ClickHouse/issues/82384):. [#82372](https://github.com/ClickHouse/ClickHouse/pull/82372) ([Azat Khuzhin](https://github.com/azat)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Backport Poco fix for concurrent SecureStreamSocket access"'. [#80229](https://github.com/ClickHouse/ClickHouse/pull/80229) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* NO CL ENTRY:  'Revert "Sync system.error_log and system.errors"'. [#80303](https://github.com/ClickHouse/ClickHouse/pull/80303) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Minor improvements to issue templates"'. [#80382](https://github.com/ClickHouse/ClickHouse/pull/80382) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Revert "Minor improvements to issue templates""'. [#80442](https://github.com/ClickHouse/ClickHouse/pull/80442) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Add azat to the trusted list"'. [#80614](https://github.com/ClickHouse/ClickHouse/pull/80614) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Replace DELETE FROM ... WHERE 1 queries to TRUNCATE"'. [#80616](https://github.com/ClickHouse/ClickHouse/pull/80616) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Update SECURITY.md'. [#81327](https://github.com/ClickHouse/ClickHouse/pull/81327) ([San Tran](https://github.com/santrancisco)).
* NO CL ENTRY:  'Revert "Fix azure native copy setting"'. [#81352](https://github.com/ClickHouse/ClickHouse/pull/81352) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Revert "Fix azure native copy setting""'. [#81372](https://github.com/ClickHouse/ClickHouse/pull/81372) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* NO CL ENTRY:  'Revert "hardlinks and rewrite file in disk transaction"'. [#81383](https://github.com/ClickHouse/ClickHouse/pull/81383) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Revert "hardlinks and rewrite file in disk transaction""'. [#81386](https://github.com/ClickHouse/ClickHouse/pull/81386) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Helper functions for PromQL-like time series data queries"'. [#81462](https://github.com/ClickHouse/ClickHouse/pull/81462) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert " Prevent use-after-free in BackgroundSchedulePool::TaskInfo by tracking pool shutdown"'. [#81481](https://github.com/ClickHouse/ClickHouse/pull/81481) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Forbid INSERT/SELECT queries w/ global context"'. [#81689](https://github.com/ClickHouse/ClickHouse/pull/81689) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Update date32.md"'. [#81719](https://github.com/ClickHouse/ClickHouse/pull/81719) ([Pablo Marcos](https://github.com/pamarcos)).
* NO CL ENTRY:  'Revert "Might fix monotonicity of the cast function for big integer types."'. [#81741](https://github.com/ClickHouse/ClickHouse/pull/81741) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* NO CL ENTRY:  'Revert "CI: Functional tests job refactored"'. [#81749](https://github.com/ClickHouse/ClickHouse/pull/81749) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Make ProcfsMetricsProvider thread_local to keep files open between tasks"'. [#81755](https://github.com/ClickHouse/ClickHouse/pull/81755) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Revert "Make ProcfsMetricsProvider thread_local to keep files open between tasks""'. [#81789](https://github.com/ClickHouse/ClickHouse/pull/81789) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Backport [#81868](https://github.com/ClickHouse/ClickHouse/issues/81868) to 25.6: Try fix logical error in fs cache"'. [#82494](https://github.com/ClickHouse/ClickHouse/pull/82494) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Close: [#64571](https://github.com/ClickHouse/ClickHouse/issues/64571). [#76344](https://github.com/ClickHouse/ClickHouse/pull/76344) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix InterpreterDropQuery::executeToDatabaseImpl calling waitDetachedTableNotInUse for non-DETACH queries. [#77664](https://github.com/ClickHouse/ClickHouse/pull/77664) ([Michael Kolupaev](https://github.com/al13n321)).
* CI: Functional tests job refactored. [#79023](https://github.com/ClickHouse/ClickHouse/pull/79023) ([Max Kainov](https://github.com/maxknv)).
* RFC: Pin rust toolchain used for compilation (sync with docker images). [#79078](https://github.com/ClickHouse/ClickHouse/pull/79078) ([Azat Khuzhin](https://github.com/azat)).
* fs cache: minor code changes, add logging, add assert, add test. [#79146](https://github.com/ClickHouse/ClickHouse/pull/79146) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Docker images for FIPS build testing. [#79223](https://github.com/ClickHouse/ClickHouse/pull/79223) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Ignore parse error in system.distributed_ddl_queue. [#79369](https://github.com/ClickHouse/ClickHouse/pull/79369) ([Ilya Golshtein](https://github.com/ilejn)).
* Optimize thread spawning in PipelineExecutor. [#79570](https://github.com/ClickHouse/ClickHouse/pull/79570) ([Sergei Trifonov](https://github.com/serxa)).
* tests: fix flakiness of tests for system.filesystem_cache. [#79633](https://github.com/ClickHouse/ClickHouse/pull/79633) ([Azat Khuzhin](https://github.com/azat)).
* Improvements skip index final exact mode (follow up to PR [#78350](https://github.com/ClickHouse/ClickHouse/issues/78350)). [#79661](https://github.com/ClickHouse/ClickHouse/pull/79661) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Replace one ugly code with another. [#79762](https://github.com/ClickHouse/ClickHouse/pull/79762) ([Nikita Taranov](https://github.com/nickitat)).
* fix flaky test 02935_http_content_type_with_http_headers_progress. [#79804](https://github.com/ClickHouse/ClickHouse/pull/79804) ([Bharat Nallan](https://github.com/bharatnc)).
* Add ability to format query for editor in client (via M-F). [#79822](https://github.com/ClickHouse/ClickHouse/pull/79822) ([Azat Khuzhin](https://github.com/azat)).
* CI: Perf tests: fix historical data insertion. [#79872](https://github.com/ClickHouse/ClickHouse/pull/79872) ([Max Kainov](https://github.com/maxknv)).
* Always log critical exceptions. [#79879](https://github.com/ClickHouse/ClickHouse/pull/79879) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* This reverts https://github.com/ClickHouse/ClickHouse/pull/79898 and restores changes from https://github.com/ClickHouse/ClickHouse/pull/77309. [#79963](https://github.com/ClickHouse/ClickHouse/pull/79963) ([Sema Checherinda](https://github.com/CheSema)).
* TODO: enable it by default in one of the next releases. [#79967](https://github.com/ClickHouse/ClickHouse/pull/79967) ([Pavel Kruglov](https://github.com/Avogar)).
* Prevent use-after-free in BackgroundSchedulePool::TaskInfo by tracking pool shutdown. [#80069](https://github.com/ClickHouse/ClickHouse/pull/80069) ([VicoWu](https://github.com/VicoWu)).
* Stateless tests: replace Log* and Memory engines to MergeTree in parallel replicas job. [#80103](https://github.com/ClickHouse/ClickHouse/pull/80103) ([Nikita Fomichev](https://github.com/fm4v)).
* Remove regular expressions from global variables. [#80171](https://github.com/ClickHouse/ClickHouse/pull/80171) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Provide more information when a Keeper Multi requests times out. [#80176](https://github.com/ClickHouse/ClickHouse/pull/80176) ([Raúl Marín](https://github.com/Algunenano)).
* update how version is checked in macOSX. [#80228](https://github.com/ClickHouse/ClickHouse/pull/80228) ([hp](https://github.com/hp77-creator)).
* Disable OpenSSL init and cleanup for AWS SDK. [#80231](https://github.com/ClickHouse/ClickHouse/pull/80231) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Add a test for [#36016](https://github.com/ClickHouse/ClickHouse/issues/36016). [#80234](https://github.com/ClickHouse/ClickHouse/pull/80234) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix syntax error in post_commit_status. [#80241](https://github.com/ClickHouse/ClickHouse/pull/80241) ([Max Kainov](https://github.com/maxknv)).
* First iteration for La Casa Del Dolor. [#80244](https://github.com/ClickHouse/ClickHouse/pull/80244) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix more flakiness in test_refreshable_mv. [#80274](https://github.com/ClickHouse/ClickHouse/pull/80274) ([Michael Kolupaev](https://github.com/al13n321)).
* Update version after release. [#80278](https://github.com/ClickHouse/ClickHouse/pull/80278) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update 25.5 Community call. [#80280](https://github.com/ClickHouse/ClickHouse/pull/80280) ([Raúl Marín](https://github.com/Algunenano)).
* Maybe fix test_refreshable_mat_view_replicated::test_real_wait_refresh flakiness. [#80283](https://github.com/ClickHouse/ClickHouse/pull/80283) ([Michael Kolupaev](https://github.com/al13n321)).
* CI: Clean up docker directories. [#80285](https://github.com/ClickHouse/ClickHouse/pull/80285) ([Max Kainov](https://github.com/maxknv)).
* Add a test for [#44351](https://github.com/ClickHouse/ClickHouse/issues/44351). [#80305](https://github.com/ClickHouse/ClickHouse/pull/80305) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#46319](https://github.com/ClickHouse/ClickHouse/issues/46319). [#80308](https://github.com/ClickHouse/ClickHouse/pull/80308) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#50048](https://github.com/ClickHouse/ClickHouse/issues/50048). [#80309](https://github.com/ClickHouse/ClickHouse/pull/80309) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor improvements to issue templates. [#80326](https://github.com/ClickHouse/ClickHouse/pull/80326) ([Raúl Marín](https://github.com/Algunenano)).
* Explicit OpenSSL cleanup. [#80332](https://github.com/ClickHouse/ClickHouse/pull/80332) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Disable incorrect test `03322_initial_query_start_time_check`, introduced in https://github.com/ClickHouse/ClickHouse/pull/75087 This closes: [#80287](https://github.com/ClickHouse/ClickHouse/issues/80287). [#80354](https://github.com/ClickHouse/ClickHouse/pull/80354) ([Alexander Tokmakov](https://github.com/tavplubix)).
* try to fix flaky test_storage_s3_queue. [#80361](https://github.com/ClickHouse/ClickHouse/pull/80361) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix creating tables in `test_backup_restore_on_cluster/test_cancel_backup.py`. [#80375](https://github.com/ClickHouse/ClickHouse/pull/80375) ([Vitaly Baranov](https://github.com/vitlibar)).
* Organize Iceberg field name's literals better (part 2). [#80377](https://github.com/ClickHouse/ClickHouse/pull/80377) ([Han Fei](https://github.com/hanfei1991)).
* Fix test `03237_create_or_replace_view_atomically_with_atomic_engine`. [#80380](https://github.com/ClickHouse/ClickHouse/pull/80380) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test `02479_race_condition_between_insert_and_droppin_mv.sh`. [#80383](https://github.com/ClickHouse/ClickHouse/pull/80383) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This test captures the issue in past releases when debug and sanitizer builds crash due to a too strict assert. The issue no longer exists on master. [#80385](https://github.com/ClickHouse/ClickHouse/pull/80385) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix Data Lake tests concurrent run. [#80386](https://github.com/ClickHouse/ClickHouse/pull/80386) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Stateless tests: 02441_alter_delete_and_drop_column.sql: try to fix and add debug info. [#80387](https://github.com/ClickHouse/ClickHouse/pull/80387) ([Nikita Fomichev](https://github.com/fm4v)).
* Context forward declaration. [#80388](https://github.com/ClickHouse/ClickHouse/pull/80388) ([Azat Khuzhin](https://github.com/azat)).
* Fix bad test `01287_max_execution_speed`. [#80411](https://github.com/ClickHouse/ClickHouse/pull/80411) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix bad tests that insert 1000 blocks. [#80412](https://github.com/ClickHouse/ClickHouse/pull/80412) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Clean up style check scripts. [#80413](https://github.com/ClickHouse/ClickHouse/pull/80413) ([Max Kainov](https://github.com/maxknv)).
* Fix a mistake in `EnvironmentChecks.cpp`. [#80422](https://github.com/ClickHouse/ClickHouse/pull/80422) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix [#80418](https://github.com/ClickHouse/ClickHouse/issues/80418) Logical error: std::exception. Code: 1001, type: std::out_of_range, e.what() = vector in executeQueryImpl. [#80427](https://github.com/ClickHouse/ClickHouse/pull/80427) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix [#80429](https://github.com/ClickHouse/ClickHouse/issues/80429) Logical error: SQL user defined function ... must represent lambda expression. [#80431](https://github.com/ClickHouse/ClickHouse/pull/80431) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add 25.5 changelog. [#80433](https://github.com/ClickHouse/ClickHouse/pull/80433) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix (benign) data race on `IMergeTreeDataPart::state`. [#80437](https://github.com/ClickHouse/ClickHouse/pull/80437) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixing creating live and window view creation with populating, it is broken after pr 79596. [#80471](https://github.com/ClickHouse/ClickHouse/pull/80471) ([Sema Checherinda](https://github.com/CheSema)).
* Trim AWS SDK contribs. [#80478](https://github.com/ClickHouse/ClickHouse/pull/80478) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Rename some new experimental settings. [#80511](https://github.com/ClickHouse/ClickHouse/pull/80511) ([Alexander Gololobov](https://github.com/davenger)).
* Fix data race on vptr signallistener::run. [#80514](https://github.com/ClickHouse/ClickHouse/pull/80514) ([Sema Checherinda](https://github.com/CheSema)).
* Bumps [setuptools](https://github.com/pypa/setuptools) from 59.6.0 to 78.1.1. [#80534](https://github.com/ClickHouse/ClickHouse/pull/80534) ([dependabot[bot]](https://github.com/apps/dependabot)).
* tests: unique name for glue container. [#80535](https://github.com/ClickHouse/ClickHouse/pull/80535) ([Aleksandr Musorin](https://github.com/AVMusorin)).
* For new settings meaning time or delays use Milliseconds type. [#80541](https://github.com/ClickHouse/ClickHouse/pull/80541) ([Mikhail Artemenko](https://github.com/Michicosun)).
* better name for geotoh3_lon_lat_input_order. [#80544](https://github.com/ClickHouse/ClickHouse/pull/80544) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix build id lookup in SymbolIndex. [#80545](https://github.com/ClickHouse/ClickHouse/pull/80545) ([Michael Kolupaev](https://github.com/al13n321)).
* CI: Fix log export for AST fuzzer job. [#80569](https://github.com/ClickHouse/ClickHouse/pull/80569) ([Max Kainov](https://github.com/maxknv)).
* Complain earlier about `filesystem_prefetch_max_memory_usage = 0`. [#80572](https://github.com/ClickHouse/ClickHouse/pull/80572) ([Robert Schulze](https://github.com/rschu1ze)).
* Update version_date.tsv and changelog after v25.4.5.24-stable. [#80581](https://github.com/ClickHouse/ClickHouse/pull/80581) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Improve query latency analyzer. [#80589](https://github.com/ClickHouse/ClickHouse/pull/80589) ([Sergei Trifonov](https://github.com/serxa)).
* Test that storage url does not call server on empty data. [#80591](https://github.com/ClickHouse/ClickHouse/pull/80591) ([Sema Checherinda](https://github.com/CheSema)).
* Stateless tests: fix flaky tests in parallel replicas job. [#80593](https://github.com/ClickHouse/ClickHouse/pull/80593) ([Nikita Fomichev](https://github.com/fm4v)).
* Closes [#80342](https://github.com/ClickHouse/ClickHouse/issues/80342). [#80594](https://github.com/ClickHouse/ClickHouse/pull/80594) ([Pavel Kruglov](https://github.com/Avogar)).
* Bumps [setuptools](https://github.com/pypa/setuptools) from 70.0.0 to 78.1.1. <details> <summary>Changelog</summary> <p><em>Sourced from <a href="https://github.com/pypa/setuptools/blob/main/NEWS.rst">setuptools's changelog</a>.</em></p> <blockquote> <h1>v78.1.1</h1> <h2>Bugfixes</h2> <ul> <li>More fully sanitized the filename in PackageIndex._download. (<a href="https://redirect.github.com/pypa/setuptools/issues/4946">[#4946](https://github.com/ClickHouse/ClickHouse/issues/4946)</a>)</li> </ul> <h1>v78.1.0</h1> <h2>Features</h2> <ul> <li>Restore access to _get_vc_env with a warning. (<a href="https://redirect.github.com/pypa/setuptools/issues/4874">[#4874](https://github.com/ClickHouse/ClickHouse/issues/4874)</a>)</li> </ul> <h1>v78.0.2</h1> <h2>Bugfixes</h2> <ul> <li>Postponed removals of deprecated dash-separated and uppercase fields in <code>setup.cfg</code>. All packages with deprecated configurations are advised to move before 2026. (<a href="https://redirect.github.com/pypa/setuptools/issues/4911">[#4911](https://github.com/ClickHouse/ClickHouse/issues/4911)</a>)</li> </ul> <h1>v78.0.1</h1> <h2>Misc</h2> <ul> <li><a href="https://redirect.github.com/pypa/setuptools/issues/4909">[#4909](https://github.com/ClickHouse/ClickHouse/issues/4909)</a></li> </ul> <h1>v78.0.0</h1> <h2>Bugfixes</h2> <ul> <li>Reverted distutils changes that broke the monkey patching of command classes. (<a href="https://redirect.github.com/pypa/setuptools/issues/4902">[#4902](https://github.com/ClickHouse/ClickHouse/issues/4902)</a>)</li> </ul> <h2>Deprecations and Removals</h2> <ul> <li>Setuptools no longer accepts options containing uppercase or dash characters in <code>setup.cfg</code>.</li> </ul> <!-- raw HTML omitted --> </blockquote> <p>... (truncated)</p> </details> <details> <summary>Commits</summary> <ul> <li><a href="https://github.com/pypa/setuptools/commit/8e4868a036b7fae3208d16cb4e5fe6d63c3752df"><code>8e4868a</code></a> Bump version: 78.1.0 → 78.1.1</li> <li><a href="https://github.com/pypa/setuptools/commit/100e9a61ad24d5a147ada57357425a8d40626d09"><code>100e9a6</code></a> Merge pull request <a href="https://redirect.github.com/pypa/setuptools/issues/4951">[#4951](https://github.com/ClickHouse/ClickHouse/issues/4951)</a></li> <li><a href="https://github.com/pypa/setuptools/commit/8faf1d7e0ca309983252e4f21837b73ee12e960f"><code>8faf1d7</code></a> Add news fragment.</li> <li><a href="https://github.com/pypa/setuptools/commit/2ca4a9fe4758fcd39d771d3d3a5b4840aacebdf7"><code>2ca4a9f</code></a> Rely on re.sub to perform the decision in one expression.</li> <li><a href="https://github.com/pypa/setuptools/commit/e409e8002932f2b86aae7b1abc8f8c2ebf96df2c"><code>e409e80</code></a> Extract _sanitize method for sanitizing the filename.</li> <li><a href="https://github.com/pypa/setuptools/commit/250a6d17978f9f6ac3ac887091f2d32886fbbb0b"><code>250a6d1</code></a> Add a check to ensure the name resolves relative to the tmpdir.</li> <li><a href="https://github.com/pypa/setuptools/commit/d8390feaa99091d1ba9626bec0e4ba7072fc507a"><code>d8390fe</code></a> Extract _resolve_download_filename with test.</li> <li><a href="https://github.com/pypa/setuptools/commit/4e1e89392de5cb405e7844cdc8b20fc2755dbaba"><code>4e1e893</code></a> Merge <a href="https://github.com/jaraco/skeleton">https://github.com/jaraco/skeleton</a></li> <li><a href="https://github.com/pypa/setuptools/commit/3a3144f0d2887fa37c06550f42a101e9eebd953a"><code>3a3144f</code></a> Fix typo: <code>pyproject.license</code> -&gt; <code>project.license</code> (<a href="https://redirect.github.com/pypa/setuptools/issues/4931">[#4931](https://github.com/ClickHouse/ClickHouse/issues/4931)</a>)</li> <li><a href="https://github.com/pypa/setuptools/commit/d751068fd2627d6d8f1729e39cbcd8119049998f"><code>d751068</code></a> Fix typo: pyproject.license -&gt; project.license</li> <li>Additional commits viewable in <a href="https://github.com/pypa/setuptools/compare/v70.0.0...v78.1.1">compare view</a></li> </ul> </details> <br />. [#80611](https://github.com/ClickHouse/ClickHouse/pull/80611) ([dependabot[bot]](https://github.com/apps/dependabot)).
* ci: fix "Cannot parse input: expected '\n' before" in performance tests. [#80613](https://github.com/ClickHouse/ClickHouse/pull/80613) ([Azat Khuzhin](https://github.com/azat)).
* Forbid too broad Context.h includes. [#80617](https://github.com/ClickHouse/ClickHouse/pull/80617) ([Azat Khuzhin](https://github.com/azat)).
* The condition that checks if we could use `gin_filter_condition` was unnecessarily difficult to read. The condition was as follows: ```cpp const auto gin_filter_condition = /* dynamic casting */ if (gin_filter_condition == nullptr) // casting failed, use default impl else // use gin_filter_condition specific impl ``` With this change: ```cpp. [#80622](https://github.com/ClickHouse/ClickHouse/pull/80622) ([Elmi Ahmadov](https://github.com/ahmadov)).
* add test with multiple JOIN...USING clauses. [#80624](https://github.com/ClickHouse/ClickHouse/pull/80624) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* clickhouse-test: fix invalid escape sequence '\{'. [#80625](https://github.com/ClickHouse/ClickHouse/pull/80625) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky 00938_dataset_test. [#80629](https://github.com/ClickHouse/ClickHouse/pull/80629) ([Igor Nikonov](https://github.com/devcrafter)).
* Next BuzzHouse update. [#80630](https://github.com/ClickHouse/ClickHouse/pull/80630) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix mistakes in CHANGELOG.md. [#80642](https://github.com/ClickHouse/ClickHouse/pull/80642) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid this issue [#80423](https://github.com/ClickHouse/ClickHouse/issues/80423#issuecomment-2897590879) in the test. The root cause is really complex to fix and we can do it later if we want. Closes [#80423](https://github.com/ClickHouse/ClickHouse/issues/80423#issuecomment-2897590879). [#80644](https://github.com/ClickHouse/ClickHouse/pull/80644) ([Pavel Kruglov](https://github.com/Avogar)).
* tests: fix flaky hms/glue/iceberg tests due to port overlaps. [#80646](https://github.com/ClickHouse/ClickHouse/pull/80646) ([Azat Khuzhin](https://github.com/azat)).
* Add correct introduced_in info to base32 functions. [#80654](https://github.com/ClickHouse/ClickHouse/pull/80654) ([Joanna Hulboj](https://github.com/jh0x)).
* Handle missing slash in metadata_path when printing system.tables. [#80660](https://github.com/ClickHouse/ClickHouse/pull/80660) ([Raúl Marín](https://github.com/Algunenano)).
* Update `rust_vendor` submodule commit. [#80661](https://github.com/ClickHouse/ClickHouse/pull/80661) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Slightly better logging in StorageKeeperMap::dropTable. [#80662](https://github.com/ClickHouse/ClickHouse/pull/80662) ([Nikolay Degterinsky](https://github.com/evillique)).
* Update CHANGELOG.md. [#80663](https://github.com/ClickHouse/ClickHouse/pull/80663) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ci: add a message when the command is killed with timeout (add --verbose). [#80680](https://github.com/ClickHouse/ClickHouse/pull/80680) ([Azat Khuzhin](https://github.com/azat)).
* tests: attempt to fix RabbitMQ tests (pause/unpause breaks RabbitMQ). [#80682](https://github.com/ClickHouse/ClickHouse/pull/80682) ([Azat Khuzhin](https://github.com/azat)).
* Update CHANGELOG.md. [#80683](https://github.com/ClickHouse/ClickHouse/pull/80683) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This reverts https://github.com/ClickHouse/ClickHouse/pull/75735 https://github.com/ClickHouse/ClickHouse/pull/80327. [#80700](https://github.com/ClickHouse/ClickHouse/pull/80700) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Update changelog. [#80702](https://github.com/ClickHouse/ClickHouse/pull/80702) ([Robert Schulze](https://github.com/rschu1ze)).
* Add more debug info when http message header parsing fails. [#80709](https://github.com/ClickHouse/ClickHouse/pull/80709) ([Sema Checherinda](https://github.com/CheSema)).
* Fix 03518_key_condition_binary_search disabling it for ParallelReplicas. [#80712](https://github.com/ClickHouse/ClickHouse/pull/80712) ([Pablo Marcos](https://github.com/pamarcos)).
* Update version_date.tsv and changelog after v25.5.1.2782-stable. [#80713](https://github.com/ClickHouse/ClickHouse/pull/80713) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix more test_refreshable_mat_view_replicated::test_real_wait_refresh flakiness. [#80715](https://github.com/ClickHouse/ClickHouse/pull/80715) ([Michael Kolupaev](https://github.com/al13n321)).
* Ignore "Available disk space for logs at server startup is too low" for non-regular files used for logs. [#80718](https://github.com/ClickHouse/ClickHouse/pull/80718) ([Azat Khuzhin](https://github.com/azat)).
* rust: Move tuikit fork into ClickHouse org. [#80719](https://github.com/ClickHouse/ClickHouse/pull/80719) ([Azat Khuzhin](https://github.com/azat)).
* Replace types in geo parquet with aliases. [#80732](https://github.com/ClickHouse/ClickHouse/pull/80732) ([scanhex12](https://github.com/scanhex12)).
* Sync settings and profile events. [#80738](https://github.com/ClickHouse/ClickHouse/pull/80738) ([Anton Popov](https://github.com/CurtizJ)).
* Avoid timeouts in 03246_alter_from_string_to_json. [#80743](https://github.com/ClickHouse/ClickHouse/pull/80743) ([Pavel Kruglov](https://github.com/Avogar)).
* Decouple StorageObjectStorageSettings and DataLakeStorageSettings. [#80745](https://github.com/ClickHouse/ClickHouse/pull/80745) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix a test after randomization of table engines in the check with parallel replicas. [#80746](https://github.com/ClickHouse/ClickHouse/pull/80746) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* There are the following reasons for this change: 1. `clone` method was used in several places completely unnecessarily (when creating `StorageObjectStorageSource::KeysIterator` it was not needed completely, in `StorageObjectStorageSink` its usage is not warranted as well). 2. `clone` method was based on copy constructor, which was never updated when someone added new fields to the class, making it work incorrectly (though it did not lead to any noticeable problem, because those fields were not used after `clone` had been called, but no guarantee that it would not have caused problems in the future). 3. We forgot to override `clone` method in `DataLakeConfuguration`, which inherits from `S3(Azure/etc)StorageConfiguration`, leading to `DataLakeConfiguration` always becoming its base class after `clone`, which again did not cause any noticeable problem, because of how little usage we made of this object after using `clone`, but it will change in the future. [#80756](https://github.com/ClickHouse/ClickHouse/pull/80756) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add logs for unloading primary keys. This PR will help to investigate [#77722](https://github.com/ClickHouse/ClickHouse/issues/77722). [#80758](https://github.com/ClickHouse/ClickHouse/pull/80758) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix test_refreshable_mv/test.py::test_backup_inner_table flakiness. [#80763](https://github.com/ClickHouse/ClickHouse/pull/80763) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix flakiness of 01155_old_mutation_parts_to_do. [#80764](https://github.com/ClickHouse/ClickHouse/pull/80764) ([Michael Kolupaev](https://github.com/al13n321)).
* Closes [#75982](https://github.com/ClickHouse/ClickHouse/issues/75982). [#80765](https://github.com/ClickHouse/ClickHouse/pull/80765) ([pufit](https://github.com/pufit)).
* Fix crash in replxx due to overlap of history entries. [#80772](https://github.com/ClickHouse/ClickHouse/pull/80772) ([Azat Khuzhin](https://github.com/azat)).
* Set query_id for each task in background schedule pool. [#80773](https://github.com/ClickHouse/ClickHouse/pull/80773) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Forbid ATTACH AS [NOT] REPLICATED if table already exists. [#80816](https://github.com/ClickHouse/ClickHouse/pull/80816) ([Azat Khuzhin](https://github.com/azat)).
* Run performance tests on ARM with label cr-performance. [#80845](https://github.com/ClickHouse/ClickHouse/pull/80845) ([Pablo Marcos](https://github.com/pamarcos)).
* Make 02790_async_queries_in_query_log stable. [#80851](https://github.com/ClickHouse/ClickHouse/pull/80851) ([Raúl Marín](https://github.com/Algunenano)).
* More query latency analyzer improvements. [#80858](https://github.com/ClickHouse/ClickHouse/pull/80858) ([Sergei Trifonov](https://github.com/serxa)).
* Fix and make sure that clickhouse server does not send body on http head request. [#80860](https://github.com/ClickHouse/ClickHouse/pull/80860) ([Sema Checherinda](https://github.com/CheSema)).
* Expose memory used for index granulas in asynchronous metrics. [#80861](https://github.com/ClickHouse/ClickHouse/pull/80861) ([Azat Khuzhin](https://github.com/azat)).
* Adding New meetups reordering old. [#80863](https://github.com/ClickHouse/ClickHouse/pull/80863) ([Tyler Hannan](https://github.com/tylerhannan)).
* Reduce memory usage of performance tests and reduce variance. [#80880](https://github.com/ClickHouse/ClickHouse/pull/80880) ([Raúl Marín](https://github.com/Algunenano)).
* Fix clickhouse-keeper-dbg for non-standalone build. [#80928](https://github.com/ClickHouse/ClickHouse/pull/80928) ([Azat Khuzhin](https://github.com/azat)).
* rust: move vendoring instructions into a separate script. [#80929](https://github.com/ClickHouse/ClickHouse/pull/80929) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test 00814_replicated_minimalistic_part_header_zookeeper. [#80932](https://github.com/ClickHouse/ClickHouse/pull/80932) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Add test for [#76709](https://github.com/ClickHouse/ClickHouse/issues/76709). [#80937](https://github.com/ClickHouse/ClickHouse/pull/80937) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix datarace in timers in librdkafka. [#80945](https://github.com/ClickHouse/ClickHouse/pull/80945) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* tests: temporary disable 03522_storage_kafka_shutdown_smoke to suppress data-race in cJSON. [#80949](https://github.com/ClickHouse/ClickHouse/pull/80949) ([Azat Khuzhin](https://github.com/azat)).
* Do not delete cmake files from rust_vendor submodule. [#80967](https://github.com/ClickHouse/ClickHouse/pull/80967) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fixes [#80317](https://github.com/ClickHouse/ClickHouse/issues/80317). [#80971](https://github.com/ClickHouse/ClickHouse/pull/80971) ([alesapin](https://github.com/alesapin)).
* Disable collecting job stack traces by default. [#80978](https://github.com/ClickHouse/ClickHouse/pull/80978) ([Nikita Taranov](https://github.com/nickitat)).
* rust: match toolchain with the CI/docker-images. [#81019](https://github.com/ClickHouse/ClickHouse/pull/81019) ([Azat Khuzhin](https://github.com/azat)).
* Fix dereferencing an empty optional in `executeInsertSelectWithParallelReplicas`. [#81049](https://github.com/ClickHouse/ClickHouse/pull/81049) ([Nikita Taranov](https://github.com/nickitat)).
* tests: fix 03520_replxx_history_crash. [#81051](https://github.com/ClickHouse/ClickHouse/pull/81051) ([Azat Khuzhin](https://github.com/azat)).
* Switch perf tests to public datasets. [#81067](https://github.com/ClickHouse/ClickHouse/pull/81067) ([Nikita Taranov](https://github.com/nickitat)).
* Add a test for [#68279](https://github.com/ClickHouse/ClickHouse/issues/68279). [#81107](https://github.com/ClickHouse/ClickHouse/pull/81107) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* tests: avoid possible "Bind for 0.0.0.0:2181 failed: port is already allocated" in kafka tests. [#81108](https://github.com/ClickHouse/ClickHouse/pull/81108) ([Azat Khuzhin](https://github.com/azat)).
* Fix UBSan error in `quantileDeterministic`. [#81109](https://github.com/ClickHouse/ClickHouse/pull/81109) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Inhibit random settings in the test `03236_squashing_high_memory`. [#81116](https://github.com/ClickHouse/ClickHouse/pull/81116) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use FunctionArgumentDescriptors for `timezoneOf`. [#81128](https://github.com/ClickHouse/ClickHouse/pull/81128) ([Kenny Sun](https://github.com/hwabis)).
* Disable test `read_in_order_optimization_with_virtual_row` with parallel replicas. [#81130](https://github.com/ClickHouse/ClickHouse/pull/81130) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: praktika: enable parallel docker image build. [#81158](https://github.com/ClickHouse/ClickHouse/pull/81158) ([Max Kainov](https://github.com/maxknv)).
* Propagate exceptions from arguments evaluation in logger. [#81165](https://github.com/ClickHouse/ClickHouse/pull/81165) ([Nikita Taranov](https://github.com/nickitat)).
* Prevent usage of Settings.h and MergeTreeSettings.h in headers. [#81168](https://github.com/ClickHouse/ClickHouse/pull/81168) ([Raúl Marín](https://github.com/Algunenano)).
* Improve logs of test_cancel_backup. [#81169](https://github.com/ClickHouse/ClickHouse/pull/81169) ([Vitaly Baranov](https://github.com/vitlibar)).
* Show microseconds in pytest logs. [#81170](https://github.com/ClickHouse/ClickHouse/pull/81170) ([Vitaly Baranov](https://github.com/vitlibar)).
* Split `02530_dictionaries_update_field` and add `update_lag`. [#81180](https://github.com/ClickHouse/ClickHouse/pull/81180) ([Nikita Taranov](https://github.com/nickitat)).
* Remove Snyk support file. [#81181](https://github.com/ClickHouse/ClickHouse/pull/81181) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix test_real_wait_refresh again. [#81185](https://github.com/ClickHouse/ClickHouse/pull/81185) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix incorrect `parent_part_offset` calculation in unordered MergeTree during merge. This addresses https://github.com/ClickHouse/ClickHouse/pull/78429#issuecomment-2925591105 . Mark as not for changelog, as this is part of ongoing work on projection index which is not landed yet. [#81188](https://github.com/ClickHouse/ClickHouse/pull/81188) ([Amos Bird](https://github.com/amosbird)).
* The previous fix [#63513](https://github.com/ClickHouse/ClickHouse/issues/63513) relied on excessive part locking during query planning, which impacted performance. After the recent refactoring PR [#79417](https://github.com/ClickHouse/ClickHouse/issues/79417), the lifetime management can now be improved with a much simpler and more efficient approach. [#81191](https://github.com/ClickHouse/ClickHouse/pull/81191) ([Amos Bird](https://github.com/amosbird)).
* rust: make sure that correct C++ std library will be used. [#81196](https://github.com/ClickHouse/ClickHouse/pull/81196) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.5.2.47-stable. [#81208](https://github.com/ClickHouse/ClickHouse/pull/81208) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix GH commit POST with large descriptions. [#81209](https://github.com/ClickHouse/ClickHouse/pull/81209) ([Raúl Marín](https://github.com/Algunenano)).
* Less flaky test_hedged_requests_parallel/test.py::test_send_data. [#81210](https://github.com/ClickHouse/ClickHouse/pull/81210) ([Raúl Marín](https://github.com/Algunenano)).
* Resolve race conditions when attach part from log entry. [#81232](https://github.com/ClickHouse/ClickHouse/pull/81232) ([Sema Checherinda](https://github.com/CheSema)).
* Fix clang20 build. [#81234](https://github.com/ClickHouse/ClickHouse/pull/81234) ([Azat Khuzhin](https://github.com/azat)).
* Minor fixes to system.build_options. [#81244](https://github.com/ClickHouse/ClickHouse/pull/81244) ([Raúl Marín](https://github.com/Algunenano)).
* Split Keeper replication out of `ReplicatedAccessStorage` for shared use. [#81245](https://github.com/ClickHouse/ClickHouse/pull/81245) ([Krishna Mannem](https://github.com/kcmannem)).
* Fix handling secure=false in connections credentials. [#81252](https://github.com/ClickHouse/ClickHouse/pull/81252) ([Azat Khuzhin](https://github.com/azat)).
* Build improvements for Rust. [#81266](https://github.com/ClickHouse/ClickHouse/pull/81266) ([Azat Khuzhin](https://github.com/azat)).
* add output for ci cpp check. [#81268](https://github.com/ClickHouse/ClickHouse/pull/81268) ([Xu Jia](https://github.com/XuJia0210)).
* Add the ability to run the `03525_sql_udf_names_in_system_query_log` test in parallel. [#81284](https://github.com/ClickHouse/ClickHouse/pull/81284) ([Kyamran](https://github.com/nibblerenush)).
* Don't hold `NamedSessionsStorage::mutex` while destroying stale sessions. Fixes [#71307](https://github.com/ClickHouse/ClickHouse/issues/71307). [#81310](https://github.com/ClickHouse/ClickHouse/pull/81310) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Mute Decimal overflow with UBSAN. [#81328](https://github.com/ClickHouse/ClickHouse/pull/81328) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Allow running `test_replicated_users` in "flaky check" mode. [#81334](https://github.com/ClickHouse/ClickHouse/pull/81334) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove templates. [#81344](https://github.com/ClickHouse/ClickHouse/pull/81344) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Next update for BuzzHouse and Casa Del Dolor. [#81351](https://github.com/ClickHouse/ClickHouse/pull/81351) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Update version_date.tsv and changelog after v25.4.6.67-stable. [#81357](https://github.com/ClickHouse/ClickHouse/pull/81357) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* mute scary logs when 404 is expected response. [#81360](https://github.com/ClickHouse/ClickHouse/pull/81360) ([Sema Checherinda](https://github.com/CheSema)).
* Some cleanups around tracking memory. [#81373](https://github.com/ClickHouse/ClickHouse/pull/81373) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky kafka rebalance test. [#81374](https://github.com/ClickHouse/ClickHouse/pull/81374) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* CI: Use stateless-test docker in libfuzzer job. [#81380](https://github.com/ClickHouse/ClickHouse/pull/81380) ([Max Kainov](https://github.com/maxknv)).
* Embedded documentation for `divideOrNull`, `moduloOrNull`, `intDivOrNull`, `positiveModuloOrNull`, follow-up [#78276](https://github.com/ClickHouse/ClickHouse/issues/78276). [#81384](https://github.com/ClickHouse/ClickHouse/pull/81384) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#81988](https://github.com/ClickHouse/ClickHouse/issues/81988): Do not send full exception message in reporting of logical errors. [#81416](https://github.com/ClickHouse/ClickHouse/pull/81416) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cache metadata json string in iceberg metadata. [#81429](https://github.com/ClickHouse/ClickHouse/pull/81429) ([Han Fei](https://github.com/hanfei1991)).
* Add more logs to ExternalLoader and catch possible uncaught exceptions. [#81430](https://github.com/ClickHouse/ClickHouse/pull/81430) ([Kseniia Sumarokova](https://github.com/kssenii)).
* If a replica has `allow_ddl=false`, some of the inner queries for RMV can fail. [#81433](https://github.com/ClickHouse/ClickHouse/pull/81433) ([pufit](https://github.com/pufit)).
* Add tests for [#80917](https://github.com/ClickHouse/ClickHouse/issues/80917) and [#81431](https://github.com/ClickHouse/ClickHouse/issues/81431). [#81436](https://github.com/ClickHouse/ClickHouse/pull/81436) ([Dmitry Novik](https://github.com/novikd)).
* Add a test for `EPHEMERAL` columns. [#81464](https://github.com/ClickHouse/ClickHouse/pull/81464) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Now `clickhouse stop` will ignore if pid file does not exist only during polling, otherwise it hides errors. Now `clickhouse stop` will not kill random `clickhouse-server`s (remove `pidof`). Improve some logging. [#81474](https://github.com/ClickHouse/ClickHouse/pull/81474) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test_parallel_replicas_failover. [#81514](https://github.com/ClickHouse/ClickHouse/pull/81514) ([Igor Nikonov](https://github.com/devcrafter)).
* Integration tests: Make `ConfigManager` add test configs atomically. [#81515](https://github.com/ClickHouse/ClickHouse/pull/81515) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fulfill the promise in Docker. [#81519](https://github.com/ClickHouse/ClickHouse/pull/81519) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Maybe this is ok?. [#81520](https://github.com/ClickHouse/ClickHouse/pull/81520) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Resolve two TODOs. [#81521](https://github.com/ClickHouse/ClickHouse/pull/81521) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Hide settings under --verbose for clickhouse-benchmark and improve bash completion scripts. [#81522](https://github.com/ClickHouse/ClickHouse/pull/81522) ([Azat Khuzhin](https://github.com/azat)).
* Fix UBSan error in the Kusto language. [#81523](https://github.com/ClickHouse/ClickHouse/pull/81523) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build under clang-21. [#81545](https://github.com/ClickHouse/ClickHouse/pull/81545) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 03002_part_log_rmt_fetch_merge_error flakiness. [#81547](https://github.com/ClickHouse/ClickHouse/pull/81547) ([Azat Khuzhin](https://github.com/azat)).
* Properly capture Failed{Select,Insert,}Query for ExceptionWhileProcessing - Capture profile events for ExceptionBeforeStart - Fix 01281_unsucceeded_insert_select_queries_counter (https://s3.amazonaws.com/clickhouse-test-reports/json.html?PR=81547&sha=7758bdfecdc5723b967cf73377fc761a98680865&name_0=PR&name_1=Stateless%20tests%20%28release%2C%20ParallelReplicas%2C%20s3%20storage%29). [#81552](https://github.com/ClickHouse/ClickHouse/pull/81552) ([Azat Khuzhin](https://github.com/azat)).
* ci: disable bash tracing by default for clickhouse-test and enable only on CI. [#81553](https://github.com/ClickHouse/ClickHouse/pull/81553) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test_cleanup_after_start flakiness. [#81555](https://github.com/ClickHouse/ClickHouse/pull/81555) ([Azat Khuzhin](https://github.com/azat)).
* query-latency-analyzer: add variance share visualization. [#81560](https://github.com/ClickHouse/ClickHouse/pull/81560) ([Sergei Trifonov](https://github.com/serxa)).
* Updating the meetups. [#81562](https://github.com/ClickHouse/ClickHouse/pull/81562) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Update 25.6 Community Call. [#81574](https://github.com/ClickHouse/ClickHouse/pull/81574) ([Raúl Marín](https://github.com/Algunenano)).
* Add random cluster generation for `La Casa Del Dolor` and setting fixes. [#81578](https://github.com/ClickHouse/ClickHouse/pull/81578) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Forbid INSERT/SELECT queries w/ global context. [#81585](https://github.com/ClickHouse/ClickHouse/pull/81585) ([Azat Khuzhin](https://github.com/azat)).
* Make NATS connection retries less noisy in the logs. [#81587](https://github.com/ClickHouse/ClickHouse/pull/81587) ([Pavel Kruglov](https://github.com/Avogar)).
* add test for [#71558](https://github.com/ClickHouse/ClickHouse/issues/71558). [#81588](https://github.com/ClickHouse/ClickHouse/pull/81588) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Advanced Memory Dashboards. [#81589](https://github.com/ClickHouse/ClickHouse/pull/81589) ([Azat Khuzhin](https://github.com/azat)).
* Revert "Revert "Helper functions for PromQL-like time series data queries"". [#81627](https://github.com/ClickHouse/ClickHouse/pull/81627) ([Alexander Gololobov](https://github.com/davenger)).
* tests: fix 02769_parallel_replicas_unavailable_shards. [#81628](https://github.com/ClickHouse/ClickHouse/pull/81628) ([Azat Khuzhin](https://github.com/azat)).
* Update README.md for Singapore, Sydney, Bangalore and Perth meetups. [#81639](https://github.com/ClickHouse/ClickHouse/pull/81639) ([Cheryl Tuquib](https://github.com/chetuquib)).
* Add profile events about server keep alive connections. [#81661](https://github.com/ClickHouse/ClickHouse/pull/81661) ([Sema Checherinda](https://github.com/CheSema)).
* Fix CVE-2023-0286 / CVE-2023-5678. [#81672](https://github.com/ClickHouse/ClickHouse/pull/81672) ([Robert Schulze](https://github.com/rschu1ze)).
* rm flaky test test_bug_insert_lz4_arrow_http_chunk_keepalive. [#81675](https://github.com/ClickHouse/ClickHouse/pull/81675) ([Sema Checherinda](https://github.com/CheSema)).
* fix logical error when we read a file that cannot infer schema. [#81684](https://github.com/ClickHouse/ClickHouse/pull/81684) ([Han Fei](https://github.com/hanfei1991)).
* Modernize `grpc` logging. [#81699](https://github.com/ClickHouse/ClickHouse/pull/81699) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* tests: increase timeout for RabbitMQ restarts. [#81702](https://github.com/ClickHouse/ClickHouse/pull/81702) ([Azat Khuzhin](https://github.com/azat)).
* Update `chcache` dependencies. [#81706](https://github.com/ClickHouse/ClickHouse/pull/81706) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* ci: get back separate file with Fatal messages for fuzzer jobs. [#81725](https://github.com/ClickHouse/ClickHouse/pull/81725) ([Azat Khuzhin](https://github.com/azat)).
* Fix: `appendRemovalTIDToVersionMetadata` for covered_parts in `MergeTreeTransaction::addNewPartAndRemoveCovered `so that there is a removal_id in the transaction metadata file even when it is removed without a transaction. Hence, when restarting, it can load the outdated parts successfully without triggering: ``` Logical error: \'Data part 202410_1_42_8 is Outdated and has creation TID (94, 40, 3ce64a6c-c10e-4c02-8891-47977f2b6a1a) and CSN 95, but does not have removal tid. It\'s a bug or a result of manual intervention.\'. ```. [#81734](https://github.com/ClickHouse/ClickHouse/pull/81734) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix abseil build. [#81750](https://github.com/ClickHouse/ClickHouse/pull/81750) ([Elmi Ahmadov](https://github.com/ahmadov)).
* CI: Functional tests job refactored (revert-revert). [#81751](https://github.com/ClickHouse/ClickHouse/pull/81751) ([Max Kainov](https://github.com/maxknv)).
* tests: fix 02843_backup_use_same_s3_credentials_for_base_backup. [#81758](https://github.com/ClickHouse/ClickHouse/pull/81758) ([Azat Khuzhin](https://github.com/azat)).
* Remove ThreadStatus from the client. [#81759](https://github.com/ClickHouse/ClickHouse/pull/81759) ([Azat Khuzhin](https://github.com/azat)).
* Remove `grpc/opentelemetry-cpp` submodule. [#81760](https://github.com/ClickHouse/ClickHouse/pull/81760) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Next update for BuzzHouse and `La Casa del Dolor`. [#81782](https://github.com/ClickHouse/ClickHouse/pull/81782) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix std::out_of_range in system.clusters for Replicated database w/o replicas. [#81788](https://github.com/ClickHouse/ClickHouse/pull/81788) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 01596_setting_limit_offset flakiness with async INSERTs. [#81790](https://github.com/ClickHouse/ClickHouse/pull/81790) ([Azat Khuzhin](https://github.com/azat)).
* tests: remove static database from 03149_analyzer_join_projection_name{,_2}. [#81791](https://github.com/ClickHouse/ClickHouse/pull/81791) ([Azat Khuzhin](https://github.com/azat)).
* Remove verbose logging. [#81793](https://github.com/ClickHouse/ClickHouse/pull/81793) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Try to fix flaky hms tests. [#81804](https://github.com/ClickHouse/ClickHouse/pull/81804) ([scanhex12](https://github.com/scanhex12)).
* tests: fix SharedEngineReplacer for running multiple tests in parallel. [#81815](https://github.com/ClickHouse/ClickHouse/pull/81815) ([Azat Khuzhin](https://github.com/azat)).
* Wait for all running queries to create a finish event in `query_log`. [#81825](https://github.com/ClickHouse/ClickHouse/pull/81825) ([Mikhail Artemenko](https://github.com/Michicosun)).
* CI: Skip flaky check jobs if no updates in tests. [#81860](https://github.com/ClickHouse/ClickHouse/pull/81860) ([Max Kainov](https://github.com/maxknv)).
* tests: fix analyzer detection (fixes CI). [#81862](https://github.com/ClickHouse/ClickHouse/pull/81862) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix *_log tables with non-local default disk. [#81863](https://github.com/ClickHouse/ClickHouse/pull/81863) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix Perf tests job config. [#81864](https://github.com/ClickHouse/ClickHouse/pull/81864) ([Max Kainov](https://github.com/maxknv)).
* ci: attempt to fix SMT replacer (fixes private CI). [#81866](https://github.com/ClickHouse/ClickHouse/pull/81866) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix max_memory_usage_in_client flakiness. [#81867](https://github.com/ClickHouse/ClickHouse/pull/81867) ([Azat Khuzhin](https://github.com/azat)).
* tests: avoid modifying existing files in shebang test. [#81869](https://github.com/ClickHouse/ClickHouse/pull/81869) ([Azat Khuzhin](https://github.com/azat)).
* Fix overriding --path and any settings from CLI arguments in clickhouse-local. [#81870](https://github.com/ClickHouse/ClickHouse/pull/81870) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix flaky check job failure on no tests. [#81872](https://github.com/ClickHouse/ClickHouse/pull/81872) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix Perf test job config 2. [#81874](https://github.com/ClickHouse/ClickHouse/pull/81874) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix error in azure stress test. [#81875](https://github.com/ClickHouse/ClickHouse/pull/81875) ([Max Kainov](https://github.com/maxknv)).
* CI: One more fix in perf job script. [#81884](https://github.com/ClickHouse/ClickHouse/pull/81884) ([Max Kainov](https://github.com/maxknv)).
* tests: enable some debugging for 02160_client_autocomplete_parse_query. [#81894](https://github.com/ClickHouse/ClickHouse/pull/81894) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81953](https://github.com/ClickHouse/ClickHouse/issues/81953): Fix `test_keeper_invalid_digest`. [#81925](https://github.com/ClickHouse/ClickHouse/pull/81925) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#81966](https://github.com/ClickHouse/ClickHouse/issues/81966):  CI: Fix corner case in changed files check. [#81941](https://github.com/ClickHouse/ClickHouse/pull/81941) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#82349](https://github.com/ClickHouse/ClickHouse/issues/82349): Minor fixes for 25.6 settings. [#81947](https://github.com/ClickHouse/ClickHouse/pull/81947) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#81979](https://github.com/ClickHouse/ClickHouse/issues/81979): CI: Fix minio access denied failure. [#81965](https://github.com/ClickHouse/ClickHouse/pull/81965) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#82397](https://github.com/ClickHouse/ClickHouse/issues/82397): Fix test_refreshable_mat_view_replicated test_append flakiness. [#81973](https://github.com/ClickHouse/ClickHouse/pull/81973) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#82203](https://github.com/ClickHouse/ClickHouse/issues/82203): Msan fix of sparse grams. this closes https://github.com/clickhouse/clickhouse/issues/81903. [#82002](https://github.com/ClickHouse/ClickHouse/pull/82002) ([scanhex12](https://github.com/scanhex12)).
* Backported in [#82255](https://github.com/ClickHouse/ClickHouse/issues/82255): Broken in https://github.com/ClickHouse/ClickHouse/pull/81245. [#82039](https://github.com/ClickHouse/ClickHouse/pull/82039) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#82096](https://github.com/ClickHouse/ClickHouse/issues/82096): Fix possible uncaught exception in offloaded serialization. [#82065](https://github.com/ClickHouse/ClickHouse/pull/82065) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82247](https://github.com/ClickHouse/ClickHouse/issues/82247): Fix bloom filter index column selection for mapContains functions. [#82110](https://github.com/ClickHouse/ClickHouse/pull/82110) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#82501](https://github.com/ClickHouse/ClickHouse/issues/82501): Fix crash in flattened Dynamic serialization. [#82117](https://github.com/ClickHouse/ClickHouse/pull/82117) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82216](https://github.com/ClickHouse/ClickHouse/issues/82216): Follow up to [#81868](https://github.com/ClickHouse/ClickHouse/issues/81868). [#82163](https://github.com/ClickHouse/ClickHouse/pull/82163) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82245](https://github.com/ClickHouse/ClickHouse/issues/82245): Make `use_legacy_to_time` not important. [#82195](https://github.com/ClickHouse/ClickHouse/pull/82195) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#82346](https://github.com/ClickHouse/ClickHouse/issues/82346): Fix compatibility for `use_legacy_to_time`. It should be enabled on old instances. [#82271](https://github.com/ClickHouse/ClickHouse/pull/82271) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#82391](https://github.com/ClickHouse/ClickHouse/issues/82391): Sync changes. [#82287](https://github.com/ClickHouse/ClickHouse/pull/82287) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82426](https://github.com/ClickHouse/ClickHouse/issues/82426): Disable `03532_crash_in_aggregation_because_of_lost_exception` with distr. [#82399](https://github.com/ClickHouse/ClickHouse/pull/82399) ([Nikita Taranov](https://github.com/nickitat)).

