---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.4.8.56-stable (9eda4814b6c) FIXME as compared to v25.4.7.66-stable (767e6c72db2)

#### Improvement
* Backported in [#82417](https://github.com/ClickHouse/ClickHouse/issues/82417): Support unix timestapms with fractional part in best effort DateTime64 parsing. [#78908](https://github.com/ClickHouse/ClickHouse/pull/78908) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82413](https://github.com/ClickHouse/ClickHouse/issues/82413): Hash functions now support NULLs inside arrays, tuples, and maps. (issues [#48365](https://github.com/ClickHouse/ClickHouse/issues/48365) and [#48623](https://github.com/ClickHouse/ClickHouse/issues/48623)). [#79008](https://github.com/ClickHouse/ClickHouse/pull/79008) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81801](https://github.com/ClickHouse/ClickHouse/issues/81801): Add profile event `PageCacheReadBytes`. [#81742](https://github.com/ClickHouse/ClickHouse/pull/81742) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82593](https://github.com/ClickHouse/ClickHouse/issues/82593): Keeper improvement: add new config `keeper_server.cleanup_old_and_ignore_new_acl`. If enabled, all nodes will have their ACLs cleared while ACL for new requests will be ignored. If the goal is to completely remove ACL from nodes, it's important to leave the config enabled until a new snapshot is created. [#82496](https://github.com/ClickHouse/ClickHouse/pull/82496) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82858](https://github.com/ClickHouse/ClickHouse/issues/82858): After https://github.com/ClickHouse/ClickHouse/pull/73834, the `X-ClickHouse-Progress` and `X-ClickHouse-Summary` header formats have been modified to omit zero values. This PR intends to return the previous behaviour for `X-ClickHouse-Summary` only, because it makes sense. [#82727](https://github.com/ClickHouse/ClickHouse/pull/82727) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#82924](https://github.com/ClickHouse/ClickHouse/issues/82924): Keeper improvement: support specific permissions for world:anyone ACL. [#82755](https://github.com/ClickHouse/ClickHouse/pull/82755) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#82185](https://github.com/ClickHouse/ClickHouse/issues/82185): Fix logical error during materialize projection when column type was changed to Nullable. [#80741](https://github.com/ClickHouse/ClickHouse/pull/80741) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81811](https://github.com/ClickHouse/ClickHouse/issues/81811): Fix `Table does not exist` error for distributed queries with pushed-down predicate (`allow_push_predicate_ast_for_distributed_subqueries=1`) when the source table does not exist on the initialtor. Fixes [#77281](https://github.com/ClickHouse/ClickHouse/issues/77281). [#80915](https://github.com/ClickHouse/ClickHouse/pull/80915) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#82014](https://github.com/ClickHouse/ClickHouse/issues/82014): Fix `Unknown table expression identifier` for `distributed_product_mode_local=local` with cross-replication. [#81162](https://github.com/ClickHouse/ClickHouse/pull/81162) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#82330](https://github.com/ClickHouse/ClickHouse/issues/82330): Fix `IN` execution with `transform_null_in=1` with null in the left argument and non-nullable subquery result. [#81584](https://github.com/ClickHouse/ClickHouse/pull/81584) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82175](https://github.com/ClickHouse/ClickHouse/issues/82175): Don't validate experimental/suspicious types in default/materialize expression execution during reading from existing table. [#81618](https://github.com/ClickHouse/ClickHouse/pull/81618) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82124](https://github.com/ClickHouse/ClickHouse/issues/82124): Fix "Context has expired" during merges when dict used in TTL expression. [#81690](https://github.com/ClickHouse/ClickHouse/pull/81690) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#82323](https://github.com/ClickHouse/ClickHouse/issues/82323): In previous versions, the server returned excessive content for requests to `/js`. This closes [#61890](https://github.com/ClickHouse/ClickHouse/issues/61890). [#81895](https://github.com/ClickHouse/ClickHouse/pull/81895) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82235](https://github.com/ClickHouse/ClickHouse/issues/82235): Previously, `MongoDB` table engine definitions could include a path component in the `host:port` argument which was silently ignored. The mongodb integration refuses to load such tables. With this fix *we allow loading such tables and ignore path component* if `MongoDB` engine has five arguments, using the database name from arguments. *Note:* The fix is not applied for newly created tables or queries with `mongo` table function, as well as for dictionary sources and named collections. [#81942](https://github.com/ClickHouse/ClickHouse/pull/81942) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#82777](https://github.com/ClickHouse/ClickHouse/issues/82777): Fix filter analysis when only a constant alias column is used in the query. Fixes [#79448](https://github.com/ClickHouse/ClickHouse/issues/79448). [#82037](https://github.com/ClickHouse/ClickHouse/pull/82037) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#82550](https://github.com/ClickHouse/ClickHouse/issues/82550): Fix LOGICAL_ERROR and following crash when using the same column in the TTL for GROUP BY and SET. [#82054](https://github.com/ClickHouse/ClickHouse/pull/82054) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#82153](https://github.com/ClickHouse/ClickHouse/issues/82153): Fixing copy-paste error in arraySimilarity, disallowing the use of UInt32 and Int32 weights. Update tests and docs. [#82103](https://github.com/ClickHouse/ClickHouse/pull/82103) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#82316](https://github.com/ClickHouse/ClickHouse/issues/82316): Fix the `Not found column` error for queries with `arrayJoin` under `WHERE` condition and `IndexSet`. [#82113](https://github.com/ClickHouse/ClickHouse/pull/82113) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#82558](https://github.com/ClickHouse/ClickHouse/issues/82558): Fix possible deadlock for remote queries when server is under memory pressure. [#82160](https://github.com/ClickHouse/ClickHouse/pull/82160) ([Kirill](https://github.com/kirillgarbar)).
* Backported in [#82521](https://github.com/ClickHouse/ClickHouse/issues/82521): Add expiration to AWS ECS token so it can be reloaded. [#82422](https://github.com/ClickHouse/ClickHouse/pull/82422) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82577](https://github.com/ClickHouse/ClickHouse/issues/82577): Fix hiding named collection values in logs/query_log. Closes [#82405](https://github.com/ClickHouse/ClickHouse/issues/82405). [#82510](https://github.com/ClickHouse/ClickHouse/pull/82510) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82568](https://github.com/ClickHouse/ClickHouse/issues/82568): Fix a possible crash in logging while terminating a session as the user_id might sometimes be empty. [#82513](https://github.com/ClickHouse/ClickHouse/pull/82513) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#82686](https://github.com/ClickHouse/ClickHouse/issues/82686): Fix `LOGICAL_ERROR` during row policy expression analysis for correlated columns. [#82618](https://github.com/ClickHouse/ClickHouse/pull/82618) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#82733](https://github.com/ClickHouse/ClickHouse/issues/82733): Functions `trim{Left,Right,Both}` now support input strings of type "FixedString(N)". For example, `SELECT trimBoth(toFixedString('abc', 3), 'ac')` now works. [#82691](https://github.com/ClickHouse/ClickHouse/pull/82691) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#82798](https://github.com/ClickHouse/ClickHouse/issues/82798): Fix deserialization of `groupArraySample`/`groupArrayLast` in case of empty elements (deserialization could skip part of the binary if the input was empty, this can lead to corruption during data read and UNKNOWN_PACKET_FROM_SERVER in TCP protocol). This does not affect numbers and date time types. [#82763](https://github.com/ClickHouse/ClickHouse/pull/82763) ([Pedro Ferreira](https://github.com/PedroTadim)).

#### Build/Testing/Packaging Improvement
* Backported in [#82864](https://github.com/ClickHouse/ClickHouse/issues/82864): Use `libxml2` v2.14.4. [#82649](https://github.com/ClickHouse/ClickHouse/pull/82649) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#82458](https://github.com/ClickHouse/ClickHouse/issues/82458): Fix more flakiness in test_refreshable_mv. [#80274](https://github.com/ClickHouse/ClickHouse/pull/80274) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#82212](https://github.com/ClickHouse/ClickHouse/issues/82212): Follow up to [#81868](https://github.com/ClickHouse/ClickHouse/issues/81868). [#82163](https://github.com/ClickHouse/ClickHouse/pull/82163) ([Kseniia Sumarokova](https://github.com/kssenii)).

