---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.4.6.67-stable (407b1e14129) FIXME as compared to v25.4.5.24-stable (0f9619ed591)

#### Backward Incompatible Change
* Backported in [#80822](https://github.com/ClickHouse/ClickHouse/issues/80822): Fix bitNot() for String to return a zero-terminated string. [#80791](https://github.com/ClickHouse/ClickHouse/pull/80791) ([Azat Khuzhin](https://github.com/azat)).

#### Improvement
* Backported in [#80769](https://github.com/ClickHouse/ClickHouse/issues/80769): Adjust compatibility values for max_merge_delayed_streams_for_parallel_write. [#80760](https://github.com/ClickHouse/ClickHouse/pull/80760) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81228](https://github.com/ClickHouse/ClickHouse/issues/81228): Upgrade libarchive to 3.7.9 to address: CVE-2024-20696 CVE-2025-25724 CVE-2024-48958 CVE-2024-57970 CVE-2025-1632 CVE-2024-48957 CVE-2024-48615. [#81174](https://github.com/ClickHouse/ClickHouse/pull/81174) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81315](https://github.com/ClickHouse/ClickHouse/issues/81315): MemoryResidentWithoutPageCache provides the amount of physical memory used by the server process, excluding userspace page cache, in bytes. This provides a more accurate view of actual memory usage when userspace page cache is utilized. When userspace page cache is disabled, this value equals MemoryResident. [#81233](https://github.com/ClickHouse/ClickHouse/pull/81233) ([Jayme Bird](https://github.com/jaymebrd)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#80475](https://github.com/ClickHouse/ClickHouse/issues/80475): Analyzer: Fix column projection name after column type promotion in join. Closes [#63345](https://github.com/ClickHouse/ClickHouse/issues/63345). [#63519](https://github.com/ClickHouse/ClickHouse/pull/63519) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#79892](https://github.com/ClickHouse/ClickHouse/issues/79892): Fix some cases where secondary index was not applied with analyzer. Fixes [#65607](https://github.com/ClickHouse/ClickHouse/issues/65607) , fixes [#69373](https://github.com/ClickHouse/ClickHouse/issues/69373). [#78485](https://github.com/ClickHouse/ClickHouse/pull/78485) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80531](https://github.com/ClickHouse/ClickHouse/issues/80531): Fix the sorting order of the NaNs with a negative sign bit. [#79847](https://github.com/ClickHouse/ClickHouse/pull/79847) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#80456](https://github.com/ClickHouse/ClickHouse/issues/80456): Fix logical error in Arrow format with LowCardinality(FixedString). [#80156](https://github.com/ClickHouse/ClickHouse/pull/80156) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80323](https://github.com/ClickHouse/ClickHouse/issues/80323): Fix incorrect count optimization for string prefix filters like LIKE 'ab_c%' when using implicit projections. This fixes [#80250](https://github.com/ClickHouse/ClickHouse/issues/80250). [#80261](https://github.com/ClickHouse/ClickHouse/pull/80261) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#80578](https://github.com/ClickHouse/ClickHouse/issues/80578): Perform less strict metadata checks for RMT in the Replicated database. Closes [#80296](https://github.com/ClickHouse/ClickHouse/issues/80296). [#80298](https://github.com/ClickHouse/ClickHouse/pull/80298) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#80961](https://github.com/ClickHouse/ClickHouse/issues/80961): Disable filter-push-down for the predicate with a non-deterministic function in case the query plan step changes the number of rows. Fixes [#40273](https://github.com/ClickHouse/ClickHouse/issues/40273). [#80329](https://github.com/ClickHouse/ClickHouse/pull/80329) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80556](https://github.com/ClickHouse/ClickHouse/issues/80556): Fixed refreshable materialized view DROP getting stuck if the view was paused using SYSTEM STOP REPLICATED VIEW. [#80543](https://github.com/ClickHouse/ClickHouse/pull/80543) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#80671](https://github.com/ClickHouse/ClickHouse/issues/80671): Fix 'Cannot find column' with constant tuple in distributed query. [#80596](https://github.com/ClickHouse/ClickHouse/pull/80596) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#80753](https://github.com/ClickHouse/ClickHouse/issues/80753): Fix possible crash in case of dictionary registration failed (when `CREATE DICTIONARY` failed with `CANNOT_SCHEDULE_TASK` it is possible to leave dangling pointer in the dictionary registry, which later lead to crash). [#80714](https://github.com/ClickHouse/ClickHouse/pull/80714) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81141](https://github.com/ClickHouse/ClickHouse/issues/81141): Fix wrong result type of comparison functions with Tuple(Dynamic) and String that led to logical error. [#80728](https://github.com/ClickHouse/ClickHouse/pull/80728) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80899](https://github.com/ClickHouse/ClickHouse/issues/80899): Fix `THERE_IS_NO_COLUMN` error for distributed queries with `IN cte`. Fixes [#75032](https://github.com/ClickHouse/ClickHouse/issues/75032). [#80757](https://github.com/ClickHouse/ClickHouse/pull/80757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80969](https://github.com/ClickHouse/ClickHouse/issues/80969): Fix excessive number of files (leads to excessive memory usage) for external ORDER BY. [#80777](https://github.com/ClickHouse/ClickHouse/pull/80777) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#80870](https://github.com/ClickHouse/ClickHouse/issues/80870): Fix crash in Kafka due to get_member_id() was creating std::string from NULL (it was likely an issue only in case of connection to broker had been failed). [#80793](https://github.com/ClickHouse/ClickHouse/pull/80793) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#80910](https://github.com/ClickHouse/ClickHouse/issues/80910): Properly wait consumers before shutting down Kafka engine (active consumers after shutdown can trigger various debug assertions and also may read data from brokers in background after table has been dropped/detached). [#80795](https://github.com/ClickHouse/ClickHouse/pull/80795) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#80934](https://github.com/ClickHouse/ClickHouse/issues/80934): Fix memory accounting for Iceberg metadata files cache. [#80904](https://github.com/ClickHouse/ClickHouse/pull/80904) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81059](https://github.com/ClickHouse/ClickHouse/issues/81059): Fix wrong partitioning with nullable partition key. [#80913](https://github.com/ClickHouse/ClickHouse/pull/80913) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#81097](https://github.com/ClickHouse/ClickHouse/issues/81097): Fix the logical error in the nested functions with named windows. [#80926](https://github.com/ClickHouse/ClickHouse/pull/80926) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#81001](https://github.com/ClickHouse/ClickHouse/issues/81001): Fix extremes for nullable and floating-point columns. [#80970](https://github.com/ClickHouse/ClickHouse/pull/80970) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#80985](https://github.com/ClickHouse/ClickHouse/issues/80985): Fix possible crash while querying from system.tables (likely the case under memory pressure). [#80976](https://github.com/ClickHouse/ClickHouse/pull/80976) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81008](https://github.com/ClickHouse/ClickHouse/issues/81008): Fix atomic rename with truncate for files which compression is inferred from their file extension. [#80979](https://github.com/ClickHouse/ClickHouse/pull/80979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#81079](https://github.com/ClickHouse/ClickHouse/issues/81079): Now ClickHouse will ignore errors and unexpected responses from data lake catalogs in `SHOW TABLES` query. Fixes [#79725](https://github.com/ClickHouse/ClickHouse/issues/79725). [#81046](https://github.com/ClickHouse/ClickHouse/pull/81046) ([alesapin](https://github.com/alesapin)).
* Backported in [#81278](https://github.com/ClickHouse/ClickHouse/issues/81278): Fix parsing of DateTime64 from integers in JSONExtract and JSON type parsing. [#81050](https://github.com/ClickHouse/ClickHouse/pull/81050) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81153](https://github.com/ClickHouse/ClickHouse/issues/81153): Reflect date_time_input_format setting in schema inference cache. [#81052](https://github.com/ClickHouse/ClickHouse/pull/81052) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81205](https://github.com/ClickHouse/ClickHouse/issues/81205): Fixed `Too large size ... passed to allocator` errors or possible crashes on inserts via http protocol with text formats (`JSON`, `Values`, ...) and omitted `Enum` fields. [#81145](https://github.com/ClickHouse/ClickHouse/pull/81145) ([Anton Popov](https://github.com/CurtizJ)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#80254](https://github.com/ClickHouse/ClickHouse/issues/80254): Revert PR 77401 "Use s3 native copy only if source and destination credentials are same". [#80172](https://github.com/ClickHouse/ClickHouse/pull/80172) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#80956](https://github.com/ClickHouse/ClickHouse/issues/80956): Fix Data Lake tests concurrent run. [#80386](https://github.com/ClickHouse/ClickHouse/pull/80386) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#81122](https://github.com/ClickHouse/ClickHouse/issues/81122): tests: temporary disable 03522_storage_kafka_shutdown_smoke to suppress data-race in cJSON. [#80949](https://github.com/ClickHouse/ClickHouse/pull/80949) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81111](https://github.com/ClickHouse/ClickHouse/issues/81111): tests: avoid possible "Bind for 0.0.0.0:2181 failed: port is already allocated" in kafka tests. [#81108](https://github.com/ClickHouse/ClickHouse/pull/81108) ([Azat Khuzhin](https://github.com/azat)).

