---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.3.6.56-lts (39f0a39e4bb) FIXME as compared to v25.3.5.42-lts (14e08ead34a)

#### Performance Improvement
* Backported in [#83337](https://github.com/ClickHouse/ClickHouse/issues/83337): Try to speedup QueryTreeHash a bit. [#82617](https://github.com/ClickHouse/ClickHouse/pull/82617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Improvement
* Backported in [#82503](https://github.com/ClickHouse/ClickHouse/issues/82503): Add ability to reload `max_local_read_bandwidth_for_server` and `max_local_write_bandwidth_for_server` on fly without restart server. [#82083](https://github.com/ClickHouse/ClickHouse/pull/82083) ([Kai Zhu](https://github.com/nauu)).
* Backported in [#83012](https://github.com/ClickHouse/ClickHouse/issues/83012): Keeper improvement: move changelog files between disk in a background thread. Previously, moving changelog to a different disk would block Keeper globally until the move is finished. This lead to performance degradation if moving is a long operation (e.g. to S3 disk). [#82485](https://github.com/ClickHouse/ClickHouse/pull/82485) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82856](https://github.com/ClickHouse/ClickHouse/issues/82856): After https://github.com/ClickHouse/ClickHouse/pull/73834, the `X-ClickHouse-Progress` and `X-ClickHouse-Summary` header formats have been modified to omit zero values. This PR intends to return the previous behaviour for `X-ClickHouse-Summary` only, because it makes sense. [#82727](https://github.com/ClickHouse/ClickHouse/pull/82727) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#79891](https://github.com/ClickHouse/ClickHouse/issues/79891): Fix some cases where secondary index was not applied with analyzer. Fixes [#65607](https://github.com/ClickHouse/ClickHouse/issues/65607) , fixes [#69373](https://github.com/ClickHouse/ClickHouse/issues/69373). [#78485](https://github.com/ClickHouse/ClickHouse/pull/78485) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#83254](https://github.com/ClickHouse/ClickHouse/issues/83254): Fix disabling boundary alignment for cached buffer in external table engines. It was broken in https://github.com/ClickHouse/ClickHouse/pull/81868. [#82493](https://github.com/ClickHouse/ClickHouse/pull/82493) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82796](https://github.com/ClickHouse/ClickHouse/issues/82796): Fix deserialization of `groupArraySample`/`groupArrayLast` in case of empty elements (deserialization could skip part of the binary if the input was empty, this can lead to corruption during data read and UNKNOWN_PACKET_FROM_SERVER in TCP protocol). This does not affect numbers and date time types. [#82763](https://github.com/ClickHouse/ClickHouse/pull/82763) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Backported in [#83108](https://github.com/ClickHouse/ClickHouse/issues/83108): Fix exception safety in union/intersect/except_default_mode rewrite. Closes [#82664](https://github.com/ClickHouse/ClickHouse/issues/82664). [#82820](https://github.com/ClickHouse/ClickHouse/pull/82820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#82991](https://github.com/ClickHouse/ClickHouse/issues/82991): When using a non-caching Database implementation, the metadata of the corresponding table is deleted after the columns are returned and the reference is invalidated. [#82939](https://github.com/ClickHouse/ClickHouse/pull/82939) ([buyval01](https://github.com/buyval01)).
* Backported in [#83023](https://github.com/ClickHouse/ClickHouse/issues/83023): Fix filter modification for queries with a JOIN expression with a table with storage `Merge`. Fixes [#82092](https://github.com/ClickHouse/ClickHouse/issues/82092). [#82950](https://github.com/ClickHouse/ClickHouse/pull/82950) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83307](https://github.com/ClickHouse/ClickHouse/issues/83307): Fix LOGICAL_ERROR in QueryMetricLog: Mutex cannot be NULL. [#82979](https://github.com/ClickHouse/ClickHouse/pull/82979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#83080](https://github.com/ClickHouse/ClickHouse/issues/83080): Fixed incorrect output of function `formatDateTime` when formatter `%f` is used together with variable-size formatters (e.g. `%M`). [#83020](https://github.com/ClickHouse/ClickHouse/pull/83020) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixes this bug in 25.3 (for 25.4+ this issue is irrelevant) [#82601](https://github.com/ClickHouse/ClickHouse/issues/82601). [#83226](https://github.com/ClickHouse/ClickHouse/pull/83226) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Backported in [#83402](https://github.com/ClickHouse/ClickHouse/issues/83402): Fix `no_sign_request` for S3 client. It can be used to explicitly avoid signing S3 requests. It can also be defined for specific endpoints using endpoint-based settings. [#83379](https://github.com/ClickHouse/ClickHouse/pull/83379) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83464](https://github.com/ClickHouse/ClickHouse/issues/83464): Fix `TOO_DEEP_SUBQUERIES` exception when CTE definition references another table expression with the same name. [#83413](https://github.com/ClickHouse/ClickHouse/pull/83413) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83668](https://github.com/ClickHouse/ClickHouse/issues/83668): Fix incorrect memory around max_untracked_memory. [#83607](https://github.com/ClickHouse/ClickHouse/pull/83607) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83660](https://github.com/ClickHouse/ClickHouse/issues/83660): INSERT SELECT with UNION ALL could lead to a null pointer dereference in a corner case. This closes [#83618](https://github.com/ClickHouse/ClickHouse/issues/83618). [#83643](https://github.com/ClickHouse/ClickHouse/pull/83643) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Build/Testing/Packaging Improvement
* Backported in [#83647](https://github.com/ClickHouse/ClickHouse/issues/83647): Apply fix for CVE-2025-6375 in Poco from upstream. [#82647](https://github.com/ClickHouse/ClickHouse/pull/82647) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#82891](https://github.com/ClickHouse/ClickHouse/issues/82891): Use `libarchive` 3.8.1. [#82648](https://github.com/ClickHouse/ClickHouse/pull/82648) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83533](https://github.com/ClickHouse/ClickHouse/issues/83533): Use `expat` 2.7.1 inside Poco. [#82661](https://github.com/ClickHouse/ClickHouse/pull/82661) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#82967](https://github.com/ClickHouse/ClickHouse/issues/82967): Keeper: some small digest and auth related fixes. [#82111](https://github.com/ClickHouse/ClickHouse/pull/82111) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82955](https://github.com/ClickHouse/ClickHouse/issues/82955): Add error response for getSessionID. [#82600](https://github.com/ClickHouse/ClickHouse/pull/82600) ([JIaQi](https://github.com/JiaQiTang98)).
* Backported in [#83566](https://github.com/ClickHouse/ClickHouse/issues/83566): Bring back `--pre-pull` command to the integration tests jobs, it was deleted in [#73291](https://github.com/ClickHouse/ClickHouse/issues/73291). [#83528](https://github.com/ClickHouse/ClickHouse/pull/83528) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backport rabbitmq tests from master to 25.3. [#83581](https://github.com/ClickHouse/ClickHouse/pull/83581) ([Pablo Marcos](https://github.com/pamarcos)).

