---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.3.15.72-lts (5148740fc78) FIXME as compared to v24.3.14.35-lts (cfa4e62b775)

#### New Feature
* Backported in [#74315](https://github.com/ClickHouse/ClickHouse/issues/74315): When `min_age_to_force_merge_seconds` and `min_age_to_force_merge_on_partition_only` are both enabled, the part merging will ignore the max bytes limit. [#73656](https://github.com/ClickHouse/ClickHouse/pull/73656) ([Kai Zhu](https://github.com/nauu)).

#### Improvement
* Backported in [#72302](https://github.com/ClickHouse/ClickHouse/issues/72302): Fix the metadata_version record in ZooKeeper in restarting thread rather than in attach thread. [#70297](https://github.com/ClickHouse/ClickHouse/pull/70297) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#72669](https://github.com/ClickHouse/ClickHouse/issues/72669): Better memory usage approximation of cached marks to reduce total memory usage of the cache. [#72630](https://github.com/ClickHouse/ClickHouse/pull/72630) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#72150](https://github.com/ClickHouse/ClickHouse/issues/72150): This PR makes `RESTORE ON CLUSTER` wait for each `ReplicatedMergeTree` table to stop being readonly before attaching any restored parts to it. Earlier it didn't wait and it could try to attach some parts at nearly the same time as checking other replicas during the table's startup. In rare cases some parts could be not attached at all during `RESTORE ON CLUSTER` because of that issue. [#62207](https://github.com/ClickHouse/ClickHouse/pull/62207) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#72408](https://github.com/ClickHouse/ClickHouse/issues/72408): The parts deduplicated during `ATTACH PART` query don't get stuck with the `attaching_` prefix anymore. [#65636](https://github.com/ClickHouse/ClickHouse/pull/65636) ([Kirill](https://github.com/kirillgarbar)).
* Backported in [#71979](https://github.com/ClickHouse/ClickHouse/issues/71979): After [this issue](https://github.com/ClickHouse/ClickHouse/pull/59946#issuecomment-1943653197) there are quite a few table replicas in production such that their `metadata_version` node value is both equal to `0` and is different from the respective table's `metadata` node version. This leads to `alter` queries failing on such replicas. [#69274](https://github.com/ClickHouse/ClickHouse/pull/69274) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#72396](https://github.com/ClickHouse/ClickHouse/issues/72396): Added missing unescaping in named collections. Without fix clickhouse-server can't start. [#71308](https://github.com/ClickHouse/ClickHouse/pull/71308) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#73354](https://github.com/ClickHouse/ClickHouse/issues/73354): Fix error column "attgenerated" does not exist for old PostgreSQL, fix [#60651](https://github.com/ClickHouse/ClickHouse/issues/60651). [#71396](https://github.com/ClickHouse/ClickHouse/pull/71396) ([0xMihalich](https://github.com/0xMihalich)).
* Backported in [#72141](https://github.com/ClickHouse/ClickHouse/issues/72141): Acquiring zero-copy shared lock before moving a part to zero-copy disk to prevent possible data loss if Keeper is unavailable. [#71845](https://github.com/ClickHouse/ClickHouse/pull/71845) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#72153](https://github.com/ClickHouse/ClickHouse/issues/72153): Allow only SELECT queries in EXPLAIN AST used inside subquery. Other types of queries lead to logical error: 'Bad cast from type DB::ASTCreateQuery to DB::ASTSelectWithUnionQuery' or `Inconsistent AST formatting`. [#71982](https://github.com/ClickHouse/ClickHouse/pull/71982) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74382](https://github.com/ClickHouse/ClickHouse/issues/74382): Avoid pause after `ALTER TABLE REPLACE/MOVE PARTITION FROM/TO TABLE`. Retrieve correct settings for background task scheduling. [#72024](https://github.com/ClickHouse/ClickHouse/pull/72024) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#72112](https://github.com/ClickHouse/ClickHouse/issues/72112): Fix formatting of `MOVE PARTITION ... TO TABLE ...` alter commands when `format_alter_commands_with_parentheses` is enabled. [#72080](https://github.com/ClickHouse/ClickHouse/pull/72080) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#72249](https://github.com/ClickHouse/ClickHouse/issues/72249): Fix a bug where `min_age_to_force_merge_on_partition_only` was getting stuck trying to merge down the same partition repeatedly that was already merged to a single part and not merging partitions that had multiple parts. [#72209](https://github.com/ClickHouse/ClickHouse/pull/72209) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#72321](https://github.com/ClickHouse/ClickHouse/issues/72321): Fixed data race in `GraceHashJoin` as the result of which some rows might be missing in the join output. [#72233](https://github.com/ClickHouse/ClickHouse/pull/72233) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72500](https://github.com/ClickHouse/ClickHouse/issues/72500): Fix failure on parsing `BACKUP DATABASE db EXCEPT TABLES db.table` queries. [#72429](https://github.com/ClickHouse/ClickHouse/pull/72429) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72977](https://github.com/ClickHouse/ClickHouse/issues/72977): Fix potential crash during backup restore. [#72947](https://github.com/ClickHouse/ClickHouse/pull/72947) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73153](https://github.com/ClickHouse/ClickHouse/issues/73153): Fix crash in transactions with unsupported storage. [#73045](https://github.com/ClickHouse/ClickHouse/pull/73045) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73122](https://github.com/ClickHouse/ClickHouse/issues/73122): Fix possible overestimate memory tracking (difference between `MemoryTracking` and `MemoryResident` kept growing). [#73081](https://github.com/ClickHouse/ClickHouse/pull/73081) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#73104](https://github.com/ClickHouse/ClickHouse/issues/73104): Check for duplicate JSON keys during Tuple parsing. Previously it could lead to logical error `Invalid number of rows in Chunk` during parsing. [#73082](https://github.com/ClickHouse/ClickHouse/pull/73082) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74433](https://github.com/ClickHouse/ClickHouse/issues/74433): Fixes segfault when the source of the dictionary contains a function with wrong data. [#73535](https://github.com/ClickHouse/ClickHouse/pull/73535) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#73800](https://github.com/ClickHouse/ClickHouse/issues/73800): Fix parsing enum glob followed by range one. Fixes [#73473](https://github.com/ClickHouse/ClickHouse/issues/73473). [#73569](https://github.com/ClickHouse/ClickHouse/pull/73569) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#73683](https://github.com/ClickHouse/ClickHouse/issues/73683): Do not interpret queries in `EXPLAIN SYNTAX` to avoid logical errors with incorrect processing stage for distributed queries. Fixes [#65205](https://github.com/ClickHouse/ClickHouse/issues/65205). [#73634](https://github.com/ClickHouse/ClickHouse/pull/73634) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#74526](https://github.com/ClickHouse/ClickHouse/issues/74526): Fixed `NOT_FOUND_COLUMN_IN_BLOCK` in queries with `FINAL` and `SAMPLE`. Fixed incorrect result in selects with `FINAL` from `CollapsingMergeTree` and enabled optimizations of `FINAL` . [#73682](https://github.com/ClickHouse/ClickHouse/pull/73682) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73729](https://github.com/ClickHouse/ClickHouse/issues/73729): Fix crash in LIMIT BY COLUMNS. [#73686](https://github.com/ClickHouse/ClickHouse/pull/73686) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#74049](https://github.com/ClickHouse/ClickHouse/issues/74049): Fix: alias can be not added to the projection if it is referenced by another alias and selected in inverse order. [#74033](https://github.com/ClickHouse/ClickHouse/pull/74033) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#72549](https://github.com/ClickHouse/ClickHouse/issues/72549): Remove flaky test test_move_shared_lock_fail_keeper_unavailable and extend the stable one. [#72357](https://github.com/ClickHouse/ClickHouse/pull/72357) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Backported in [#73456](https://github.com/ClickHouse/ClickHouse/issues/73456): Fix data race in `ProfileEvents::Counters::setParent()`. This PR fixes [#60376](https://github.com/ClickHouse/ClickHouse/issues/60376). [#72518](https://github.com/ClickHouse/ClickHouse/pull/72518) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#72761](https://github.com/ClickHouse/ClickHouse/issues/72761): Fix potential `Context has expired` error for Y-shaped JOIN. Was triggered in [#71429](https://github.com/ClickHouse/ClickHouse/issues/71429). [#72735](https://github.com/ClickHouse/ClickHouse/pull/72735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#73297](https://github.com/ClickHouse/ClickHouse/issues/73297): fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73937](https://github.com/ClickHouse/ClickHouse/issues/73937): Reverts ClickHouse/ClickHouse[#62944](https://github.com/ClickHouse/ClickHouse/issues/62944) (there was a crash in the CI because of this). [#73738](https://github.com/ClickHouse/ClickHouse/pull/73738) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#74470](https://github.com/ClickHouse/ClickHouse/issues/74470): Make `version_helper` populated from every commit. [#74399](https://github.com/ClickHouse/ClickHouse/pull/74399) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

