---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.11.5.49-stable (bc766603cce) FIXME as compared to v24.11.4.45-stable (074a009b2a7)

#### Improvement
* Backported in [#75842](https://github.com/ClickHouse/ClickHouse/issues/75842): Add check and logging for decrypting and decompressing. [#75471](https://github.com/ClickHouse/ClickHouse/pull/75471) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#75804](https://github.com/ClickHouse/ClickHouse/issues/75804): Add a config `memory_worker_correct_memory_tracker` to enable correction of internal memory tracker with information from different source read in the background thread periodically. [#75714](https://github.com/ClickHouse/ClickHouse/pull/75714) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#75811](https://github.com/ClickHouse/ClickHouse/issues/75811): Propogate Native format settings properly for client-server communication. [#73924](https://github.com/ClickHouse/ClickHouse/pull/73924) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#74090](https://github.com/ClickHouse/ClickHouse/issues/74090): Fix implicit privileges (worked as wildcard before). [#73932](https://github.com/ClickHouse/ClickHouse/pull/73932) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#75556](https://github.com/ClickHouse/ClickHouse/issues/75556): Fix crash with query `INSERT INTO SELECT` over PostgreSQL interface on macOS (issue [#72938](https://github.com/ClickHouse/ClickHouse/issues/72938)). [#74231](https://github.com/ClickHouse/ClickHouse/pull/74231) ([Artem Yurov](https://github.com/ArtemYurov)).
* Backported in [#75630](https://github.com/ClickHouse/ClickHouse/issues/75630): Fix crash due to uncaught exception in PSQL replication. [#75062](https://github.com/ClickHouse/ClickHouse/pull/75062) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76103](https://github.com/ClickHouse/ClickHouse/issues/76103): Fix nullsafe JOIN handling for LowCardinality nullable data type. Previously JOIN ON with nullsafe comparison, such as `IS NOT DISTINCT FROM`, `<=>` , `a IS NULL AND b IS NULL OR a == b` didn't work correctly with LowCardinality columns. [#75143](https://github.com/ClickHouse/ClickHouse/pull/75143) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#75568](https://github.com/ClickHouse/ClickHouse/issues/75568): Keeper fix: avoid writing to broken changelogs when rolling back logs. [#75197](https://github.com/ClickHouse/ClickHouse/pull/75197) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75652](https://github.com/ClickHouse/ClickHouse/issues/75652): Mask azureblobstorage table engine credentials. [#75319](https://github.com/ClickHouse/ClickHouse/pull/75319) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Backported in [#75744](https://github.com/ClickHouse/ClickHouse/issues/75744): Fix crash in protobuf schema cache that can happen during output in Protobuf format and parallel query `SYSTEM DROP FORMAT SCHEMA CACHE`. [#75357](https://github.com/ClickHouse/ClickHouse/pull/75357) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76096](https://github.com/ClickHouse/ClickHouse/issues/76096): Fix possible error `Elements ... and ... of Nested data structure ... (Array columns) have different array sizes` when JSON subcolumns with Array type are used in JOIN over distributed tables. [#75512](https://github.com/ClickHouse/ClickHouse/pull/75512) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75854](https://github.com/ClickHouse/ClickHouse/issues/75854): Fix interaction between allow_feature_tier and compatibility mergetree setting. [#75635](https://github.com/ClickHouse/ClickHouse/pull/75635) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#75892](https://github.com/ClickHouse/ClickHouse/issues/75892): Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous `RENAME` queries (with `alter_sync = 0`) between columns with different types. [#75693](https://github.com/ClickHouse/ClickHouse/pull/75693) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#76157](https://github.com/ClickHouse/ClickHouse/issues/76157): Rebuild projection on alter modify of its PK column. Previously it could lead to `CANNOT_READ_ALL_DATA` errors during selects after alter modify of the column used in projection PK. [#75720](https://github.com/ClickHouse/ClickHouse/pull/75720) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75823](https://github.com/ClickHouse/ClickHouse/issues/75823): Fixed null pointer dereference in `DistinctSortedStreamTransform`. [#75734](https://github.com/ClickHouse/ClickHouse/pull/75734) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76216](https://github.com/ClickHouse/ClickHouse/issues/76216): `clickhouse-library-bridge` allows opening arbitrary libraries from the filesystem, which makes it safe to run only inside an isolated environment. To prevent a vulnerability when it is run near the clickhouse-server, we will limit the paths of libraries to a location, provided in the configuration. This vulnerability was found with the [ClickHouse Bug Bounty Program](https://github.com/ClickHouse/ClickHouse/issues/38986) by **Arseniy Dugin**. [#75954](https://github.com/ClickHouse/ClickHouse/pull/75954) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Build/Testing/Packaging Improvement
* Backported in [#76221](https://github.com/ClickHouse/ClickHouse/issues/76221): Make all clickhouse-server related actions a function, and execute them only when launching the default binary in `entrypoint.sh`. A long-postponed improvement was suggested in [#50724](https://github.com/ClickHouse/ClickHouse/issues/50724). Added switch `--users` to `clickhouse-extract-from-config` to get values from the `users.xml`. [#75643](https://github.com/ClickHouse/ClickHouse/pull/75643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#75508](https://github.com/ClickHouse/ClickHouse/issues/75508): Fix the flaky test in `test_replicated_merge_tree_s3_zero_copy/test.py::test_drop_table` by reducing the loop count and backoff period to avoid exceeding the client timeout. [#73102](https://github.com/ClickHouse/ClickHouse/pull/73102) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#76383](https://github.com/ClickHouse/ClickHouse/issues/76383): Hopefully fix shutdown crash in ObjectStorageQueueMetadata. [#75323](https://github.com/ClickHouse/ClickHouse/pull/75323) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76369](https://github.com/ClickHouse/ClickHouse/issues/76369): Fix normalizing function names inside ASTTTLElement. [#75757](https://github.com/ClickHouse/ClickHouse/pull/75757) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#75882](https://github.com/ClickHouse/ClickHouse/issues/75882): Fix build. [#75867](https://github.com/ClickHouse/ClickHouse/pull/75867) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Backported in [#76375](https://github.com/ClickHouse/ClickHouse/issues/76375): DisksApp: fix 'Placement info has not been loaded' and 'The IOThreadPool is not initialized'. [#75873](https://github.com/ClickHouse/ClickHouse/pull/75873) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76063](https://github.com/ClickHouse/ClickHouse/issues/76063): Add more test logs for decompressing. [#76023](https://github.com/ClickHouse/ClickHouse/pull/76023) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#76173](https://github.com/ClickHouse/ClickHouse/issues/76173): Improve logging for decrypting files from encrypted disks. [#76128](https://github.com/ClickHouse/ClickHouse/pull/76128) ([Vitaly Baranov](https://github.com/vitlibar)).

