---
sidebar_position: 1
sidebar_label: 2024
---

# 2024 Changelog

### ClickHouse release v24.11.2.101-stable (3cc965d6095) FIXME as compared to v24.11.1.2557-stable (1574e794bf9)

#### Performance Improvement
* Backported in [#72704](https://github.com/ClickHouse/ClickHouse/issues/72704): During query execution with parallel replicas and enabled local plan, skip index analysis on workers. The coordinator will choose ranges to read for workers based on index analysis on its side (on query initiator). [#72109](https://github.com/ClickHouse/ClickHouse/pull/72109) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73035](https://github.com/ClickHouse/ClickHouse/issues/73035): Bring back optimization for reading subcolumns of single column in Compact parts from https://github.com/ClickHouse/ClickHouse/pull/57631. It was deleted accidentally. [#72285](https://github.com/ClickHouse/ClickHouse/pull/72285) ([Pavel Kruglov](https://github.com/Avogar)).

#### Improvement
* Backported in [#72677](https://github.com/ClickHouse/ClickHouse/issues/72677): Better memory usage approximation of cached marks to reduce total memory usage of the cache. [#72630](https://github.com/ClickHouse/ClickHouse/pull/72630) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73065](https://github.com/ClickHouse/ClickHouse/issues/73065): Support parsing GCS S3 error `AuthenticationRequired`. [#72753](https://github.com/ClickHouse/ClickHouse/pull/72753) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#73057](https://github.com/ClickHouse/ClickHouse/issues/73057): Add S3 request settings `http_max_fields`, `http_max_field_name_size`, `http_max_field_value_size` and use them while parsing S3 API responses during making a backup or restoring. [#72778](https://github.com/ClickHouse/ClickHouse/pull/72778) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#73454](https://github.com/ClickHouse/ClickHouse/issues/73454): Use Keeper multi requests in cleanup thread ObjectStorageQueueMetadata. [#73357](https://github.com/ClickHouse/ClickHouse/pull/73357) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#73435](https://github.com/ClickHouse/ClickHouse/issues/73435): When ClickHouse runs under cgroup we will still collect system-wide asynchronous metrics related to system load, process scheduling, memory etc. They might provide useful signals when ClickHouse is the only process on the host with high resource consumption. [#73369](https://github.com/ClickHouse/ClickHouse/pull/73369) ([Nikita Taranov](https://github.com/nickitat)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#73009](https://github.com/ClickHouse/ClickHouse/issues/73009): Fixed zombie processes after after library bridge crash. [#71301](https://github.com/ClickHouse/ClickHouse/pull/71301) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#73487](https://github.com/ClickHouse/ClickHouse/issues/73487): `RESTORE` operations for access entities required more permission than necessary because of unhandled partial revokes. This PR fixes the issue. Closes [#71853](https://github.com/ClickHouse/ClickHouse/issues/71853). [#71958](https://github.com/ClickHouse/ClickHouse/pull/71958) ([pufit](https://github.com/pufit)).
* Backported in [#73376](https://github.com/ClickHouse/ClickHouse/issues/73376): Add inferred format name to create query in File/S3/URL/HDFS/Azure engines. Previously the format name was inferred each time the server was restarted, and if the specified data files were removed, it led to errors during server startup. [#72108](https://github.com/ClickHouse/ClickHouse/pull/72108) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72245](https://github.com/ClickHouse/ClickHouse/issues/72245): Fix a bug where `min_age_to_force_merge_on_partition_only` was getting stuck trying to merge down the same partition repeatedly that was already merged to a single part and not merging partitions that had multiple parts. [#72209](https://github.com/ClickHouse/ClickHouse/pull/72209) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#72529](https://github.com/ClickHouse/ClickHouse/issues/72529): Fixed mismatched types in several cases after applying `optimize_functions_to_subcolumns`. [#72394](https://github.com/ClickHouse/ClickHouse/pull/72394) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72508](https://github.com/ClickHouse/ClickHouse/issues/72508): Fix failure on parsing `BACKUP DATABASE db EXCEPT TABLES db.table` queries. [#72429](https://github.com/ClickHouse/ClickHouse/pull/72429) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#72955](https://github.com/ClickHouse/ClickHouse/issues/72955): Don't allow creating empty Variant. [#72454](https://github.com/ClickHouse/ClickHouse/pull/72454) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#72932](https://github.com/ClickHouse/ClickHouse/issues/72932): Fix query generation for the follower server in case of a distributed query with ARRAY JOIN. Fixes [#69276](https://github.com/ClickHouse/ClickHouse/issues/69276). [#72608](https://github.com/ClickHouse/ClickHouse/pull/72608) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#72852](https://github.com/ClickHouse/ClickHouse/issues/72852): Fixed inconsistent metadata when adding a new replica to a Replicated database that has a table created with `flatten_nested=0`. [#72685](https://github.com/ClickHouse/ClickHouse/pull/72685) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#72787](https://github.com/ClickHouse/ClickHouse/issues/72787): Fix advanced SSL configuration for Keeper's internal communication. [#72730](https://github.com/ClickHouse/ClickHouse/pull/72730) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#72903](https://github.com/ClickHouse/ClickHouse/issues/72903): Fix exception thrown in RemoteQueryExecutor when user does not exist locally. [#72759](https://github.com/ClickHouse/ClickHouse/pull/72759) ([Andrey Zvonov](https://github.com/zvonand)).
* Backported in [#73026](https://github.com/ClickHouse/ClickHouse/issues/73026): Fixed mutations with materialized `_block_number` column (if setting `enable_block_number_column` is enabled). [#72854](https://github.com/ClickHouse/ClickHouse/pull/72854) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72914](https://github.com/ClickHouse/ClickHouse/issues/72914): Fixed crash while parsing of incorrect data into sparse columns (can happen with enabled setting `enable_parsing_to_custom_serialization`). [#72891](https://github.com/ClickHouse/ClickHouse/pull/72891) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72985](https://github.com/ClickHouse/ClickHouse/issues/72985): Fix potential crash during backup restore. [#72947](https://github.com/ClickHouse/ClickHouse/pull/72947) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73273](https://github.com/ClickHouse/ClickHouse/issues/73273): Fixed bug in `parallel_hash` JOIN method that might appear when query has complex condition in the `ON` clause with inequality filters. [#72993](https://github.com/ClickHouse/ClickHouse/pull/72993) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#73161](https://github.com/ClickHouse/ClickHouse/issues/73161): Fix crash in transactions with unsupported storage. [#73045](https://github.com/ClickHouse/ClickHouse/pull/73045) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73130](https://github.com/ClickHouse/ClickHouse/issues/73130): Fix possible overestimate memory tracking (difference between `MemoryTracking` and `MemoryResident` kept growing). [#73081](https://github.com/ClickHouse/ClickHouse/pull/73081) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#73112](https://github.com/ClickHouse/ClickHouse/issues/73112): Check for duplicate JSON keys during Tuple parsing. Previously it could lead to logical error `Invalid number of rows in Chunk` during parsing. [#73082](https://github.com/ClickHouse/ClickHouse/pull/73082) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73498](https://github.com/ClickHouse/ClickHouse/issues/73498): Fix positive timezone formatting of formatDateTime scalar function. [#73091](https://github.com/ClickHouse/ClickHouse/pull/73091) ([ollidraese](https://github.com/ollidraese)).
* Backported in [#73532](https://github.com/ClickHouse/ClickHouse/issues/73532): Fix crash in StorageObjectStorageQueue. [#73274](https://github.com/ClickHouse/ClickHouse/pull/73274) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#73411](https://github.com/ClickHouse/ClickHouse/issues/73411): Fixed filtering by `_etag` column while reading from `s3` storage and table function. [#73353](https://github.com/ClickHouse/ClickHouse/pull/73353) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#73529](https://github.com/ClickHouse/ClickHouse/issues/73529): Fixed a logical error when reading from single-replica cluster with parallel replicas enabled. [#73403](https://github.com/ClickHouse/ClickHouse/pull/73403) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#73573](https://github.com/ClickHouse/ClickHouse/issues/73573): Fix data race when creating vector similarity index. [#73517](https://github.com/ClickHouse/ClickHouse/pull/73517) ([Antonio Andelic](https://github.com/antonio2368)).

#### NO CL CATEGORY

* Backported in [#73237](https://github.com/ClickHouse/ClickHouse/issues/73237):. [#72898](https://github.com/ClickHouse/ClickHouse/pull/72898) ([Sema Checherinda](https://github.com/CheSema)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#72516](https://github.com/ClickHouse/ClickHouse/issues/72516): Fix calculating dynamic columns sizes on vertical merge. Follow-up for https://github.com/ClickHouse/ClickHouse/pull/71526. [#72211](https://github.com/ClickHouse/ClickHouse/pull/72211) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#73231](https://github.com/ClickHouse/ClickHouse/issues/73231): fix finalize/cancel write buffers. [#72386](https://github.com/ClickHouse/ClickHouse/pull/72386) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72563](https://github.com/ClickHouse/ClickHouse/issues/72563): Fix ANY JOIN with parallel replicas. [#72393](https://github.com/ClickHouse/ClickHouse/pull/72393) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#72475](https://github.com/ClickHouse/ClickHouse/issues/72475): Fix uncaught exception in ScatteredBlock. [#72405](https://github.com/ClickHouse/ClickHouse/pull/72405) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#72496](https://github.com/ClickHouse/ClickHouse/issues/72496): Rename allowed_feature_tier to allow_feature_tier. [#72455](https://github.com/ClickHouse/ClickHouse/pull/72455) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#73248](https://github.com/ClickHouse/ClickHouse/issues/73248): Fix: threesome joins with parallel replicas. [#72510](https://github.com/ClickHouse/ClickHouse/pull/72510) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#73465](https://github.com/ClickHouse/ClickHouse/issues/73465): Fix data race in `ProfileEvents::Counters::setParent()`. This PR fixes [#60376](https://github.com/ClickHouse/ClickHouse/issues/60376). [#72518](https://github.com/ClickHouse/ClickHouse/pull/72518) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#73222](https://github.com/ClickHouse/ClickHouse/issues/73222): fix async insert in TCP. [#72545](https://github.com/ClickHouse/ClickHouse/pull/72545) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72681](https://github.com/ClickHouse/ClickHouse/issues/72681): Update NuRaft. [#72584](https://github.com/ClickHouse/ClickHouse/pull/72584) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#72602](https://github.com/ClickHouse/ClickHouse/issues/72602): Fix data race in Squashing with ColumnConst. [#72586](https://github.com/ClickHouse/ClickHouse/pull/72586) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#73213](https://github.com/ClickHouse/ClickHouse/issues/73213): fix pipeline cancelation. [#72587](https://github.com/ClickHouse/ClickHouse/pull/72587) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72649](https://github.com/ClickHouse/ClickHouse/issues/72649): Revert "Merge pull request [#65488](https://github.com/ClickHouse/ClickHouse/issues/65488) from zvonand/zvonand-ttl". [#72599](https://github.com/ClickHouse/ClickHouse/pull/72599) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#72769](https://github.com/ClickHouse/ClickHouse/issues/72769): Fix potential `Context has expired` error for Y-shaped JOIN. Was triggered in [#71429](https://github.com/ClickHouse/ClickHouse/issues/71429). [#72735](https://github.com/ClickHouse/ClickHouse/pull/72735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#73287](https://github.com/ClickHouse/ClickHouse/issues/73287): fix clickhouse_driver inserts. [#72813](https://github.com/ClickHouse/ClickHouse/pull/72813) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73203](https://github.com/ClickHouse/ClickHouse/issues/73203): output format does not write to the canceled buffer. [#72815](https://github.com/ClickHouse/ClickHouse/pull/72815) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#72966](https://github.com/ClickHouse/ClickHouse/issues/72966): setup_minio: Do not add aws credentials twice. [#72857](https://github.com/ClickHouse/ClickHouse/pull/72857) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#73305](https://github.com/ClickHouse/ClickHouse/issues/73305): fix missing finalize call. [#73279](https://github.com/ClickHouse/ClickHouse/pull/73279) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#73587](https://github.com/ClickHouse/ClickHouse/issues/73587): Sync Google Cloud config. [#73545](https://github.com/ClickHouse/ClickHouse/pull/73545) ([Pablo Marcos](https://github.com/pamarcos)).

