---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.8.3.44-lts FIXME as compared to v21.8.2.19-prestable

#### Improvement
* Rename setting. [#26844](https://github.com/ClickHouse/ClickHouse/pull/26844) ([ianton-ru](https://github.com/ianton-ru)).

#### Bug Fix
* Backported in [#27545](https://github.com/ClickHouse/ClickHouse/issues/27545): Now, scalar subquery always returns `Nullable` result if it's type can be `Nullable`. It is needed because in case of empty subquery it's result should be `Null`. Previously, it was possible to get error about incompatible types (type deduction does not execute scalar subquery, and it could use not-nullable type). Scalar subquery with empty result which can't be converted to `Nullable` (like `Array` or `Tuple`) now throws error. Fixes [#25411](https://github.com/ClickHouse/ClickHouse/issues/25411). [#26423](https://github.com/ClickHouse/ClickHouse/pull/26423) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#26856](https://github.com/ClickHouse/ClickHouse/issues/26856): ParallelFormattingOutputFormat: Use mutex to handle the join to the collector_thread (https://github.com/ClickHouse/ClickHouse/issues/26694). [#26703](https://github.com/ClickHouse/ClickHouse/pull/26703) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#26941](https://github.com/ClickHouse/ClickHouse/issues/26941): Do not remove data on ReplicatedMergeTree table shutdown to avoid creating data to metadata inconsistency. [#26716](https://github.com/ClickHouse/ClickHouse/pull/26716) ([nvartolomei](https://github.com/nvartolomei)).
* Backported in [#26981](https://github.com/ClickHouse/ClickHouse/issues/26981): Aggregate function parameters might be lost when applying some combinators causing exceptions like `Conversion from AggregateFunction(topKArray, Array(String)) to AggregateFunction(topKArray(10), Array(String)) is not supported`. It's fixed. Fixes [#26196](https://github.com/ClickHouse/ClickHouse/issues/26196) and [#26433](https://github.com/ClickHouse/ClickHouse/issues/26433). [#26814](https://github.com/ClickHouse/ClickHouse/pull/26814) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#26909](https://github.com/ClickHouse/ClickHouse/issues/26909): Fix library-bridge ids load. [#26834](https://github.com/ClickHouse/ClickHouse/pull/26834) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#26945](https://github.com/ClickHouse/ClickHouse/issues/26945): Fix error `Missing columns: 'xxx'` when `DEFAULT` column references other non materialized column without `DEFAULT` expression. Fixes [#26591](https://github.com/ClickHouse/ClickHouse/issues/26591). [#26900](https://github.com/ClickHouse/ClickHouse/pull/26900) ([alesapin](https://github.com/alesapin)).
* Backported in [#26997](https://github.com/ClickHouse/ClickHouse/issues/26997): Fix reading of custom TLDs (stops processing with lower buffer or bigger file). [#26948](https://github.com/ClickHouse/ClickHouse/pull/26948) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#27030](https://github.com/ClickHouse/ClickHouse/issues/27030): Now partition ID in queries like `ALTER TABLE ... PARTITION ID xxx` validates for correctness. Fixes [#25718](https://github.com/ClickHouse/ClickHouse/issues/25718). [#26963](https://github.com/ClickHouse/ClickHouse/pull/26963) ([alesapin](https://github.com/alesapin)).
* Backported in [#27053](https://github.com/ClickHouse/ClickHouse/issues/27053): [RFC] Fix possible mutation stack due to race with DROP_RANGE. [#27002](https://github.com/ClickHouse/ClickHouse/pull/27002) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#27106](https://github.com/ClickHouse/ClickHouse/issues/27106): Fixed `cache`, `complex_key_cache`, `ssd_cache`, `complex_key_ssd_cache` configuration parsing. Options `allow_read_expired_keys`, `max_update_queue_size`, `update_queue_push_timeout_milliseconds`, `query_wait_timeout_milliseconds` were not parsed for dictionaries with non `cache` type. [#27032](https://github.com/ClickHouse/ClickHouse/pull/27032) ([Maksim Kita](https://github.com/kitaisreal)).
* Backported in [#27160](https://github.com/ClickHouse/ClickHouse/issues/27160): Fix synchronization in GRPCServer This PR fixes [#27024](https://github.com/ClickHouse/ClickHouse/issues/27024). [#27064](https://github.com/ClickHouse/ClickHouse/pull/27064) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#27365](https://github.com/ClickHouse/ClickHouse/issues/27365): - Fix uninitialized memory in functions `multiSearch*` with empty array, close [#27169](https://github.com/ClickHouse/ClickHouse/issues/27169). [#27181](https://github.com/ClickHouse/ClickHouse/pull/27181) ([Vladimir C](https://github.com/vdimir)).
* Backported in [#27263](https://github.com/ClickHouse/ClickHouse/issues/27263): In rare cases `system.detached_parts` table might contain incorrect information for some parts, it's fixed. Fixes [#27114](https://github.com/ClickHouse/ClickHouse/issues/27114). [#27183](https://github.com/ClickHouse/ClickHouse/pull/27183) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#27555](https://github.com/ClickHouse/ClickHouse/issues/27555): Fix mutation stuck on invalid partitions in non-replicated MergeTree. [#27248](https://github.com/ClickHouse/ClickHouse/pull/27248) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#27411](https://github.com/ClickHouse/ClickHouse/issues/27411): Fix `distributed_group_by_no_merge=2`+`distributed_push_down_limit=1` or `optimize_distributed_group_by_sharding_key=1` with `LIMIT BY` and `LIMIT OFFSET`. [#27249](https://github.com/ClickHouse/ClickHouse/pull/27249) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#27507](https://github.com/ClickHouse/ClickHouse/issues/27507): Fix errors like `Expected ColumnLowCardinality, gotUInt8` or `Bad cast from type DB::ColumnVector<char8_t> to DB::ColumnLowCardinality` for some queries with `LowCardinality` in `PREWHERE`. Fixes [#23515](https://github.com/ClickHouse/ClickHouse/issues/23515). [#27298](https://github.com/ClickHouse/ClickHouse/pull/27298) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#27417](https://github.com/ClickHouse/ClickHouse/issues/27417): Fix `Cannot find column` error for queries with sampling. Was introduced in [#24574](https://github.com/ClickHouse/ClickHouse/issues/24574). Fixes [#26522](https://github.com/ClickHouse/ClickHouse/issues/26522). [#27301](https://github.com/ClickHouse/ClickHouse/pull/27301) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#27414](https://github.com/ClickHouse/ClickHouse/issues/27414): Fixed incorrect validation of partition id for MergeTree tables that created with old syntax. [#27328](https://github.com/ClickHouse/ClickHouse/pull/27328) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#27540](https://github.com/ClickHouse/ClickHouse/issues/27540): Fix incorrect result for query with row-level security, prewhere and LowCardinality filter. Fixes [#27179](https://github.com/ClickHouse/ClickHouse/issues/27179). [#27329](https://github.com/ClickHouse/ClickHouse/pull/27329) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#27419](https://github.com/ClickHouse/ClickHouse/issues/27419): /proc/info contains metrics like. [#27361](https://github.com/ClickHouse/ClickHouse/pull/27361) ([Mike Kot](https://github.com/myrrc)).
* Backported in [#27472](https://github.com/ClickHouse/ClickHouse/issues/27472): fix metric BackgroundMessageBrokerSchedulePoolTask, maybe mistyped。. [#27452](https://github.com/ClickHouse/ClickHouse/pull/27452) ([Ben](https://github.com/benbiti)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix mysql_kill_sync_thread_restore_test [#26673](https://github.com/ClickHouse/ClickHouse/pull/26673) ([Vladimir C](https://github.com/vdimir)).
* Fix killing unstopped containers in integration tests. [#26818](https://github.com/ClickHouse/ClickHouse/pull/26818) ([Vitaly Baranov](https://github.com/vitlibar)).
* Try fix rabbitmq tests [#26826](https://github.com/ClickHouse/ClickHouse/pull/26826) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Wait for self datasource to be initialized in test_jdbc_bridge [#26827](https://github.com/ClickHouse/ClickHouse/pull/26827) ([Ilya Yatsishin](https://github.com/qoega)).
* One more library bridge fix [#26873](https://github.com/ClickHouse/ClickHouse/pull/26873) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Better integration tests [#26894](https://github.com/ClickHouse/ClickHouse/pull/26894) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix assertions in Replicated database [#27033](https://github.com/ClickHouse/ClickHouse/pull/27033) ([Alexander Tokmakov](https://github.com/tavplubix)).
* library bridge fixes [#27060](https://github.com/ClickHouse/ClickHouse/pull/27060) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Implement `legacy_column_name_of_tuple_literal` in a less intrusive way [#27153](https://github.com/ClickHouse/ClickHouse/pull/27153) ([Anton Popov](https://github.com/CurtizJ)).
* Revert [#24095](https://github.com/ClickHouse/ClickHouse/issues/24095). User-level settings will affect queries from view. [#27227](https://github.com/ClickHouse/ClickHouse/pull/27227) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update PVS checksum [#27317](https://github.com/ClickHouse/ClickHouse/pull/27317) ([Alexander Tokmakov](https://github.com/tavplubix)).
