---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.5.1.6601-prestable FIXME as compared to v21.4.1.6422-prestable

#### Backward Incompatible Change
* Change comparison of integers and floating point numbers when integer is not exactly representable in the floating point data type. In new version comparison will return false as the rounding error will occur. Example: `9223372036854775808.0 != 9223372036854775808`, because the number `9223372036854775808` is not representable as floating point number exactly (and `9223372036854775808.0` is rounded to `9223372036854776000.0`). But in previous version the comparison will return as the numbers are equal, because if the floating point number `9223372036854776000.0` get converted back to UInt64, it will yield `9223372036854775808`. For the reference, the Python programming language also treats these numbers as equal. But this behaviour was dependend on CPU model (different results on AMD64 and AArch64 for some out-of-range numbers), so we make the comparison more precise. It will treat int and float numbers equal only if int is represented in floating point type exactly. [#22595](https://github.com/ClickHouse/ClickHouse/pull/22595) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### New Feature
* Implement function `arrayFold(x1,...,xn,accum -> expression, array1,...,arrayn, init_accum)` that applies the expression to each element of the array (or set of parallel arrays) and collect result in accumulator. [#21589](https://github.com/ClickHouse/ClickHouse/pull/21589) ([Dmitry Krylov](https://github.com/dmalkr)).
* - Support Apple m1. [#21639](https://github.com/ClickHouse/ClickHouse/pull/21639) ([changvvb](https://github.com/changvvb)).
* Add a setting `max_distributed_depth` that limits the depth of recursive queries to `Distributed` tables. Closes [#20229](https://github.com/ClickHouse/ClickHouse/issues/20229). [#21942](https://github.com/ClickHouse/ClickHouse/pull/21942) ([flynn](https://github.com/ucasfl)).
* Table function, which allows to process files from `s3` in parallel from many nodes in a specified cluster. [#22012](https://github.com/ClickHouse/ClickHouse/pull/22012) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Support for replicas in MySQL/PostgreSQL table engine / table function. Added wrapper storage over MySQL / PostgreSQL storages to allow shards. Closes [#20969](https://github.com/ClickHouse/ClickHouse/issues/20969). [#22217](https://github.com/ClickHouse/ClickHouse/pull/22217) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update paths to the catboost model configs in config reloading. [#22434](https://github.com/ClickHouse/ClickHouse/pull/22434) ([Kruglov Pavel](https://github.com/Avogar)).
* Add new setting `non_replicated_deduplication_window` for non-replicated MergeTree inserts deduplication. [#22514](https://github.com/ClickHouse/ClickHouse/pull/22514) ([alesapin](https://github.com/alesapin)).
* FlatDictionary added `initial_array_size`, `max_array_size` options. [#22521](https://github.com/ClickHouse/ClickHouse/pull/22521) ([Maksim Kita](https://github.com/kitaisreal)).
* Added `ALTER TABLE ... FETCH PART ...` query. It's similar to `FETCH PARTITION`, but fetches only one part. [#22706](https://github.com/ClickHouse/ClickHouse/pull/22706) ([jasong](https://github.com/songenjie)).
* Added `Decimal256` type support in dictionaries. Closes [#20979](https://github.com/ClickHouse/ClickHouse/issues/20979). [#22960](https://github.com/ClickHouse/ClickHouse/pull/22960) ([Maksim Kita](https://github.com/kitaisreal)).

#### Performance Improvement
* Add function alignment for possibly better performance. [#21431](https://github.com/ClickHouse/ClickHouse/pull/21431) ([Daniel Kutenin](https://github.com/danlark1)).
* Exclude values that does not belong to the shard from right part of IN section for distributed queries (under `optimize_skip_unused_shards_rewrite_in`, enabled by default, since it still requires `optimize_skip_unused_shards`). [#21511](https://github.com/ClickHouse/ClickHouse/pull/21511) ([Azat Khuzhin](https://github.com/azat)).
* Disable compression by default when interacting with localhost (with clickhouse-client or server to server with distributed queries) via native protocol. It may improve performance of some import/export operations. This closes [#22234](https://github.com/ClickHouse/ClickHouse/issues/22234). [#22237](https://github.com/ClickHouse/ClickHouse/pull/22237) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve performance of reading from `ArrowStream` input format for sources other then local file (e.g. URL). [#22673](https://github.com/ClickHouse/ClickHouse/pull/22673) ([nvartolomei](https://github.com/nvartolomei)).
* Improve performance of `intDiv` by dynamic dispatch for AVX2. This closes [#22314](https://github.com/ClickHouse/ClickHouse/issues/22314). [#23000](https://github.com/ClickHouse/ClickHouse/pull/23000) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Support dynamic interserver credentials. [#14113](https://github.com/ClickHouse/ClickHouse/pull/14113) ([johnskopis](https://github.com/johnskopis)).
* Add clickhouse-library-bridge for library dictionary source. Closes [#9502](https://github.com/ClickHouse/ClickHouse/issues/9502). [#21509](https://github.com/ClickHouse/ClickHouse/pull/21509) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow publishing Kafka errors to a virtual column of Kafka engine, controlled by the `kafka_handle_error_mode` setting. [#21850](https://github.com/ClickHouse/ClickHouse/pull/21850) ([fastio](https://github.com/fastio)).
* Use nanodbc instead of Poco::ODBC. Closes [#9678](https://github.com/ClickHouse/ClickHouse/issues/9678). Add support for DateTime64 and Decimal* for ODBC table engine. Closes [#21961](https://github.com/ClickHouse/ClickHouse/issues/21961). Fixed issue with cyrillic text being truncated. Closes [#16246](https://github.com/ClickHouse/ClickHouse/issues/16246). Added connection pools for odbc bridge. [#21972](https://github.com/ClickHouse/ClickHouse/pull/21972) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Speeded up reading subset of columns from File-like table engine with internal file written in column oriented data formats (Parquet, Arrow and ORC) This closes [#20129](https://github.com/ClickHouse/ClickHouse/issues/20129) Done by @keen-wolf. [#22299](https://github.com/ClickHouse/ClickHouse/pull/22299) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Correctly check structure of async distributed blocks. [#22325](https://github.com/ClickHouse/ClickHouse/pull/22325) ([Azat Khuzhin](https://github.com/azat)).
* Make `round` function to behave consistently on non-x86_64 platforms. Rounding half to nearest even (Banker's rounding) is used. [#22582](https://github.com/ClickHouse/ClickHouse/pull/22582) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Clear the rest of the screen and show cursor in `clickhouse-client` if previous program has left garbage in terminal. This closes [#16518](https://github.com/ClickHouse/ClickHouse/issues/16518). [#22634](https://github.com/ClickHouse/ClickHouse/pull/22634) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to use CTE in VIEW definition. This closes [#22491](https://github.com/ClickHouse/ClickHouse/issues/22491). [#22657](https://github.com/ClickHouse/ClickHouse/pull/22657) ([Amos Bird](https://github.com/amosbird)).
* Add metric to track how much time is spend during waiting for Buffer layer lock. [#22725](https://github.com/ClickHouse/ClickHouse/pull/22725) ([Azat Khuzhin](https://github.com/azat)).
* Allow RBAC row policy via postgresql protocol. Closes [#22658](https://github.com/ClickHouse/ClickHouse/issues/22658). PostgreSQL protocol is enabled in configuration by default. [#22755](https://github.com/ClickHouse/ClickHouse/pull/22755) ([Kseniia Sumarokova](https://github.com/kssenii)).
* MaterializeMySQL (experimental feature). Make Clickhouse to be able to replicate MySQL databases containing views without failing. This is accomplished by ignoring the views. ... [#22760](https://github.com/ClickHouse/ClickHouse/pull/22760) ([Christian Frøystad](https://github.com/cfroystad)).
* `dateDiff` now works with `DateTime64` arguments (even for values outside of `DateTime` range) ... [#22931](https://github.com/ClickHouse/ClickHouse/pull/22931) ([Vasily Nemkov](https://github.com/Enmk)).
* Set `background_fetches_pool_size` to 8 that is better for production usage with frequent small insertions or slow ZooKeeper cluster. [#22945](https://github.com/ClickHouse/ClickHouse/pull/22945) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix inactive_parts_to_throw_insert=0 with inactive_parts_to_delay_insert>0. [#22947](https://github.com/ClickHouse/ClickHouse/pull/22947) ([Azat Khuzhin](https://github.com/azat)).
* Respect max_part_removal_threads for ReplicatedMergeTree. [#22971](https://github.com/ClickHouse/ClickHouse/pull/22971) ([Azat Khuzhin](https://github.com/azat)).
* Fix an error handling in Poco HTTP Client for AWS. [#22973](https://github.com/ClickHouse/ClickHouse/pull/22973) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* When selecting from MergeTree table with NULL in WHERE condition, in rare cases, exception was thrown. This closes [#20019](https://github.com/ClickHouse/ClickHouse/issues/20019). [#22978](https://github.com/ClickHouse/ClickHouse/pull/22978) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ability to flush buffer only in background for StorageBuffer. [#22986](https://github.com/ClickHouse/ClickHouse/pull/22986) ([Azat Khuzhin](https://github.com/azat)).
* Add ability to run clickhouse-keeper with SSL. Config settings `keeper_server.tcp_port_secure` can be used for secure interaction between client and keeper-server. `keeper_server.raft_configuration.secure` can be used to enable internal secure communication between nodes. [#22992](https://github.com/ClickHouse/ClickHouse/pull/22992) ([alesapin](https://github.com/alesapin)).
* Increase `max_uri_size` (the maximum size of URL in HTTP interface) to 1 MiB by default. This closes [#21197](https://github.com/ClickHouse/ClickHouse/issues/21197). [#22997](https://github.com/ClickHouse/ClickHouse/pull/22997) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not perform optimize_skip_unused_shards for cluster with one node. [#22999](https://github.com/ClickHouse/ClickHouse/pull/22999) ([Azat Khuzhin](https://github.com/azat)).
* Raised the threshold on max number of matches in result of the function `extractAllGroupsHorizontal`. [#23036](https://github.com/ClickHouse/ClickHouse/pull/23036) ([Vasily Nemkov](https://github.com/Enmk)).
* Implement functions `arrayHasAny`, `arrayHasAll`, `has`, `indexOf`, `countEqual` for generic case when types of array elements are different. In previous versions the functions `arrayHasAny`, `arrayHasAll` returned false and `has`, `indexOf`, `countEqual` thrown exception. Also add support for `Decimal` and big integer types in functions `has` and similar. This closes [#20272](https://github.com/ClickHouse/ClickHouse/issues/20272). [#23044](https://github.com/ClickHouse/ClickHouse/pull/23044) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix memory tracking with min_bytes_to_use_mmap_io. [#23211](https://github.com/ClickHouse/ClickHouse/pull/23211) ([Azat Khuzhin](https://github.com/azat)).
* Make function `unhex` case insensitive for compatibility with MySQL. [#23229](https://github.com/ClickHouse/ClickHouse/pull/23229) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Bug Fix
* Fix very rare bug when quorum insert with `quorum_parallel=1` is not really "quorum" because of deduplication. [#18215](https://github.com/ClickHouse/ClickHouse/pull/18215) ([filimonov](https://github.com/filimonov)).
* * Fix "unknown column" error for tables with `Merge` engine in queris with `JOIN` and aggregation. Closes [#18368](https://github.com/ClickHouse/ClickHouse/issues/18368), close [#22226](https://github.com/ClickHouse/ClickHouse/issues/22226). [#21370](https://github.com/ClickHouse/ClickHouse/pull/21370) ([Vladimir C](https://github.com/vdimir)).
* Check if table function view is used as a column. This complements https://github.com/ClickHouse/ClickHouse/pull/20350. [#21465](https://github.com/ClickHouse/ClickHouse/pull/21465) ([Amos Bird](https://github.com/amosbird)).
* Fix bug, which leads to underaggregation of data in case of enabled `optimize_aggregation_in_order` and many parts in table. Slightly improve performance of aggregation with enabled `optimize_aggregation_in_order`. [#21889](https://github.com/ClickHouse/ClickHouse/pull/21889) ([Anton Popov](https://github.com/CurtizJ)).
* Do not limit HTTP chunk size. Fixes [#21907](https://github.com/ClickHouse/ClickHouse/issues/21907). [#22322](https://github.com/ClickHouse/ClickHouse/pull/22322) ([Ivan](https://github.com/abyss7)).
* Buffer overflow (on read) was possible in `tokenbf_v1` full text index. The excessive bytes are not used but the read operation may lead to crash in rare cases. This closes [#19233](https://github.com/ClickHouse/ClickHouse/issues/19233). [#22421](https://github.com/ClickHouse/ClickHouse/pull/22421) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix ClickHouseDictionarySource configuration loop. Closes [#14314](https://github.com/ClickHouse/ClickHouse/issues/14314). [#22479](https://github.com/ClickHouse/ClickHouse/pull/22479) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix bug in partial merge join with `LowCardinality`. Close [#22386](https://github.com/ClickHouse/ClickHouse/issues/22386), close [#22388](https://github.com/ClickHouse/ClickHouse/issues/22388). [#22510](https://github.com/ClickHouse/ClickHouse/pull/22510) ([Vladimir C](https://github.com/vdimir)).
* Follow-up fix for [#21936](https://github.com/ClickHouse/ClickHouse/issues/21936). Also fixes [#22433](https://github.com/ClickHouse/ClickHouse/issues/22433). [#22518](https://github.com/ClickHouse/ClickHouse/pull/22518) ([Ivan](https://github.com/abyss7)).
* Fix deserialization of empty string without newline at end of TSV format. This closes [#20244](https://github.com/ClickHouse/ClickHouse/issues/20244). Possible workaround without version update: set `input_format_null_as_default` to zero. It was zero in old versions. [#22527](https://github.com/ClickHouse/ClickHouse/pull/22527) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UB by unlocking the rwlock of the TinyLog from the same thread. [#22560](https://github.com/ClickHouse/ClickHouse/pull/22560) ([Azat Khuzhin](https://github.com/azat)).
* Avoid UB in *Log engines for rwlock unlock due to unlock from another thread. [#22583](https://github.com/ClickHouse/ClickHouse/pull/22583) ([Azat Khuzhin](https://github.com/azat)).
* Fix usage of function `map` in distributed queries. [#22588](https://github.com/ClickHouse/ClickHouse/pull/22588) ([foolchi](https://github.com/foolchi)).
* Try flush write buffer only if it is initialized. Fixes segfault when client closes connection very early [#22579](https://github.com/ClickHouse/ClickHouse/issues/22579). [#22591](https://github.com/ClickHouse/ClickHouse/pull/22591) ([nvartolomei](https://github.com/nvartolomei)).
* Fixed a bug with unlimited wait for auxiliary AWS requests. [#22594](https://github.com/ClickHouse/ClickHouse/pull/22594) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix LOGICAL_ERROR for Log with nested types w/o columns in the SELECT clause. [#22654](https://github.com/ClickHouse/ClickHouse/pull/22654) ([Azat Khuzhin](https://github.com/azat)).
* Fix wait for mutations on several replicas for ReplicatedMergeTree table engines. Previously, mutation/alter query may finish before mutation actually executed on other replicas. [#22669](https://github.com/ClickHouse/ClickHouse/pull/22669) ([alesapin](https://github.com/alesapin)).
* Fix possible hangs in zk requests in case of OOM exception. Fixes [#22438](https://github.com/ClickHouse/ClickHouse/issues/22438). [#22684](https://github.com/ClickHouse/ClickHouse/pull/22684) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix approx total rows accounting for reverse reading from MergeTree. [#22726](https://github.com/ClickHouse/ClickHouse/pull/22726) ([Azat Khuzhin](https://github.com/azat)).
* * Revert "Move conditions from JOIN ON to WHERE" (ClickHouse/ClickHouse[#19685](https://github.com/ClickHouse/ClickHouse/issues/19685)), close [#22399](https://github.com/ClickHouse/ClickHouse/issues/22399), close [#21671](https://github.com/ClickHouse/ClickHouse/issues/21671). [#22753](https://github.com/ClickHouse/ClickHouse/pull/22753) ([Vladimir C](https://github.com/vdimir)).
* Fix pushdown of `HAVING` in case, when filter column is used in aggregation. [#22763](https://github.com/ClickHouse/ClickHouse/pull/22763) ([Anton Popov](https://github.com/CurtizJ)).
* LIVE VIEW (experimental feature). Fix possible hanging in concurrent DROP/CREATE of TEMPORARY LIVE VIEW in `TemporaryLiveViewCleaner`, see https://gist.github.com/vzakaznikov/0c03195960fc86b56bfe2bc73a90019e. [#22858](https://github.com/ClickHouse/ClickHouse/pull/22858) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix bytes_allocated for sparse_hashed dictionaries. [#22867](https://github.com/ClickHouse/ClickHouse/pull/22867) ([Azat Khuzhin](https://github.com/azat)).
* Fixed a crash when using `mannWhitneyUTest` and `rankCorr` with window functions. This fixes [#22728](https://github.com/ClickHouse/ClickHouse/issues/22728). [#22876](https://github.com/ClickHouse/ClickHouse/pull/22876) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fixed `formatDateTime()` on `DateTime64` and "%C" format specifier fixed `toDateTime64()` for large values and non-zero scale. ... [#22937](https://github.com/ClickHouse/ClickHouse/pull/22937) ([Vasily Nemkov](https://github.com/Enmk)).
* Fix usage of constant columns of type `Map` with nullable values. [#22939](https://github.com/ClickHouse/ClickHouse/pull/22939) ([Anton Popov](https://github.com/CurtizJ)).
* Simplify debian packages. This fixes [#21698](https://github.com/ClickHouse/ClickHouse/issues/21698). [#22976](https://github.com/ClickHouse/ClickHouse/pull/22976) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix error `Cannot find column in ActionsDAG result` which may happen if subquery uses `untuple`. Fixes [#22290](https://github.com/ClickHouse/ClickHouse/issues/22290). [#22991](https://github.com/ClickHouse/ClickHouse/pull/22991) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove non-essential details from suggestions in clickhouse-client. This closes [#22158](https://github.com/ClickHouse/ClickHouse/issues/22158). [#23040](https://github.com/ClickHouse/ClickHouse/pull/23040) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed `Table .inner_id... doesn't exist` error when selecting from Materialized View after detaching it from Atomic database and attaching back. [#23047](https://github.com/ClickHouse/ClickHouse/pull/23047) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Some values were formatted with alignment in center in table cells in `Markdown` format. Not anymore. [#23096](https://github.com/ClickHouse/ClickHouse/pull/23096) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Server might fail to start if `data_type_default_nullable` setting is enabled in default profile, it's fixed. Fixes [#22573](https://github.com/ClickHouse/ClickHouse/issues/22573). [#23185](https://github.com/ClickHouse/ClickHouse/pull/23185) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix missing whitespace in some exception messages about `LowCardinality` type. [#23207](https://github.com/ClickHouse/ClickHouse/pull/23207) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed missing semicolon in exception message. The user may find this exception message unpleasant to read. [#23208](https://github.com/ClickHouse/ClickHouse/pull/23208) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix reading from ODBC when there are many long column names in a table. Closes [#8853](https://github.com/ClickHouse/ClickHouse/issues/8853). [#23215](https://github.com/ClickHouse/ClickHouse/pull/23215) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Build/Testing/Packaging Improvement
* Add on-demand check for clickhouse Keeper. [#22373](https://github.com/ClickHouse/ClickHouse/pull/22373) ([alesapin](https://github.com/alesapin)).
* Disable incompatible libraries (platform specific typically) on ppc64le ... [#22475](https://github.com/ClickHouse/ClickHouse/pull/22475) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Allow building with unbundled xz (lzma) using USE_INTERNAL_XZ_LIBRARY=OFF ... [#22571](https://github.com/ClickHouse/ClickHouse/pull/22571) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Allow query profiling only on x86_64. See [#15174](https://github.com/ClickHouse/ClickHouse/issues/15174)#issuecomment-812954965 and [#15638](https://github.com/ClickHouse/ClickHouse/issues/15638)#issuecomment-703805337. This closes [#15638](https://github.com/ClickHouse/ClickHouse/issues/15638). [#22580](https://github.com/ClickHouse/ClickHouse/pull/22580) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Adjust some tests to output identical results on amd64 and aarch64 (qemu). The result was depending on implementation specific CPU behaviour. [#22590](https://github.com/ClickHouse/ClickHouse/pull/22590) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix some tests on AArch64 platform. [#22596](https://github.com/ClickHouse/ClickHouse/pull/22596) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix ClickHouse Keeper build for MacOS. [#22860](https://github.com/ClickHouse/ClickHouse/pull/22860) ([alesapin](https://github.com/alesapin)).

#### Other
* Fix some points from this comment https://github.com/ClickHouse/ClickHouse/pull/19516#issuecomment-782047840. [#22323](https://github.com/ClickHouse/ClickHouse/pull/22323) ([Ivan](https://github.com/abyss7)).

#### Build/Packaging/Testing Improvement

* Build `jemalloc` with support for [heap profiling](https://github.com/jemalloc/jemalloc/wiki/Use-Case%3A-Heap-Profiling). [#22834](https://github.com/ClickHouse/ClickHouse/pull/22834) ([nvartolomei](https://github.com/nvartolomei)).

#### NO CL ENTRY

* NO CL ENTRY:  'Error message reads better'. [#22983](https://github.com/ClickHouse/ClickHouse/pull/22983) ([Igor O'sten](https://github.com/borodark)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix SIGSEGV by waiting servers thread pool [#21318](https://github.com/ClickHouse/ClickHouse/pull/21318) ([Azat Khuzhin](https://github.com/azat)).
* Better filter push down [#22087](https://github.com/ClickHouse/ClickHouse/pull/22087) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Better tests for finalize in nested writers [#22110](https://github.com/ClickHouse/ClickHouse/pull/22110) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Replace all Context references with std::weak_ptr [#22297](https://github.com/ClickHouse/ClickHouse/pull/22297) ([Ivan](https://github.com/abyss7)).
* make some perf test queries more stable [#22324](https://github.com/ClickHouse/ClickHouse/pull/22324) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* fix ccache broken by prlimit [#22356](https://github.com/ClickHouse/ClickHouse/pull/22356) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove old MSan suppressions (part 5) [#22359](https://github.com/ClickHouse/ClickHouse/pull/22359) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for copier [#22441](https://github.com/ClickHouse/ClickHouse/pull/22441) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix window frame offset check and add more tests [#22459](https://github.com/ClickHouse/ClickHouse/pull/22459) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* FormatSettings null_as_default default value fix [#22528](https://github.com/ClickHouse/ClickHouse/pull/22528) ([Maksim Kita](https://github.com/kitaisreal)).
* Minor fixes in tests for AArch64 [#22534](https://github.com/ClickHouse/ClickHouse/pull/22534) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Filter removed/renamed tests from ci-changed-files.txt for fuzzer [#22542](https://github.com/ClickHouse/ClickHouse/pull/22542) ([Azat Khuzhin](https://github.com/azat)).
* Try fix flaky test [#22543](https://github.com/ClickHouse/ClickHouse/pull/22543) ([Alexander Tokmakov](https://github.com/tavplubix)).
* AppleClang compilation fix [#22561](https://github.com/ClickHouse/ClickHouse/pull/22561) ([Denis Glazachev](https://github.com/traceon)).
* Fix assert in Arena when doing GROUP BY Array of Nothing of non-zero size. [#22565](https://github.com/ClickHouse/ClickHouse/pull/22565) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor improvement in index deserialization [#22586](https://github.com/ClickHouse/ClickHouse/pull/22586) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky test after [#22427](https://github.com/ClickHouse/ClickHouse/issues/22427) [#22587](https://github.com/ClickHouse/ClickHouse/pull/22587) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix comments [#22589](https://github.com/ClickHouse/ClickHouse/pull/22589) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix some uncaught exceptions (in SCOPE_EXIT) under memory pressure [#22592](https://github.com/ClickHouse/ClickHouse/pull/22592) ([Azat Khuzhin](https://github.com/azat)).
* Introduce IStorage::distributedWrite method for distributed INSERT SELECTS [#22593](https://github.com/ClickHouse/ClickHouse/pull/22593) ([Max Akhmedov](https://github.com/zlobober)).
* Fix flaky test 00816_long_concurrent_alter_column [#22628](https://github.com/ClickHouse/ClickHouse/pull/22628) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* FlatDictionary fix perf test [#22629](https://github.com/ClickHouse/ClickHouse/pull/22629) ([Maksim Kita](https://github.com/kitaisreal)).
* DirectDictionary dictGet multiple columns optimization [#22630](https://github.com/ClickHouse/ClickHouse/pull/22630) ([Maksim Kita](https://github.com/kitaisreal)).
* Better retries on ZK errors in sh tests [#22633](https://github.com/ClickHouse/ClickHouse/pull/22633) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add log_comment setting for DROP/CREATE DATABASE in clickhouse-test [#22646](https://github.com/ClickHouse/ClickHouse/pull/22646) ([Azat Khuzhin](https://github.com/azat)).
* Add retires for docker-compose pull in integration tests [#22647](https://github.com/ClickHouse/ClickHouse/pull/22647) ([Azat Khuzhin](https://github.com/azat)).
* Fix impossible invalid-read for system.errors accounting [#22655](https://github.com/ClickHouse/ClickHouse/pull/22655) ([Azat Khuzhin](https://github.com/azat)).
* Skip compiling xz if we're using system xz (unbundled) [#22656](https://github.com/ClickHouse/ClickHouse/pull/22656) ([Kfir Itzhak](https://github.com/mastertheknife)).
* Fix test 01294_create_settings_profile [#22662](https://github.com/ClickHouse/ClickHouse/pull/22662) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix test 01039_row_policy_dcl [#22663](https://github.com/ClickHouse/ClickHouse/pull/22663) ([Anton Popov](https://github.com/CurtizJ)).
* Another attempt to enable pytest [#22664](https://github.com/ClickHouse/ClickHouse/pull/22664) ([Ivan](https://github.com/abyss7)).
* Fix random failures of tests that are using query_log [#22666](https://github.com/ClickHouse/ClickHouse/pull/22666) ([Anton Popov](https://github.com/CurtizJ)).
* fix build error 'always_inline' function might not be inlinable [#22667](https://github.com/ClickHouse/ClickHouse/pull/22667) ([flynn](https://github.com/ucasfl)).
* Add bool type in postgres engine [#22668](https://github.com/ClickHouse/ClickHouse/pull/22668) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix mutation killers tests [#22670](https://github.com/ClickHouse/ClickHouse/pull/22670) ([alesapin](https://github.com/alesapin)).
* Change Aggregatingmergetree to AggregatingMergeTree in docs [#22687](https://github.com/ClickHouse/ClickHouse/pull/22687) ([Kruglov Pavel](https://github.com/Avogar)).
* fix window functions with multiple input streams and no sorting [#22704](https://github.com/ClickHouse/ClickHouse/pull/22704) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove redundant fsync on coordination logs rotation [#22707](https://github.com/ClickHouse/ClickHouse/pull/22707) ([alesapin](https://github.com/alesapin)).
* Fix test 01702_system_query_log [#22708](https://github.com/ClickHouse/ClickHouse/pull/22708) ([Anton Popov](https://github.com/CurtizJ)).
* MemoryStorage sync comments and code [#22721](https://github.com/ClickHouse/ClickHouse/pull/22721) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix potential segfault on Keeper startup [#22743](https://github.com/ClickHouse/ClickHouse/pull/22743) ([alesapin](https://github.com/alesapin)).
* Avoid using harmful function rand() [#22744](https://github.com/ClickHouse/ClickHouse/pull/22744) ([Amos Bird](https://github.com/amosbird)).
* Fix flaky hedged tests [#22746](https://github.com/ClickHouse/ClickHouse/pull/22746) ([Kruglov Pavel](https://github.com/Avogar)).
* add more messages when flushing the logs [#22761](https://github.com/ClickHouse/ClickHouse/pull/22761) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Moved BorrowedObjectPool to common [#22764](https://github.com/ClickHouse/ClickHouse/pull/22764) ([Maksim Kita](https://github.com/kitaisreal)).
* Functions ExternalDictionaries standardize exception throw [#22821](https://github.com/ClickHouse/ClickHouse/pull/22821) ([Maksim Kita](https://github.com/kitaisreal)).
* FileDictionarySource fix absolute file path [#22822](https://github.com/ClickHouse/ClickHouse/pull/22822) ([Maksim Kita](https://github.com/kitaisreal)).
* Small change in replicated database tests run [#22826](https://github.com/ClickHouse/ClickHouse/pull/22826) ([alesapin](https://github.com/alesapin)).
* Slightly improve logging messages for Distributed async sends [#22829](https://github.com/ClickHouse/ClickHouse/pull/22829) ([Azat Khuzhin](https://github.com/azat)).
* Fix what looks like a trivial mistake [#22833](https://github.com/ClickHouse/ClickHouse/pull/22833) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for already fixed issue [#22855](https://github.com/ClickHouse/ClickHouse/pull/22855) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* DataTypeLowCardinality format tsv parsing issue [#22863](https://github.com/ClickHouse/ClickHouse/pull/22863) ([Maksim Kita](https://github.com/kitaisreal)).
* Updated MariaDB connector fix cmake [#22865](https://github.com/ClickHouse/ClickHouse/pull/22865) ([Maksim Kita](https://github.com/kitaisreal)).
* Prettify logs of integration tests [#22868](https://github.com/ClickHouse/ClickHouse/pull/22868) ([Anton Popov](https://github.com/CurtizJ)).
* Util `memcpy-bench` is built only when position independent code is disabled [#22875](https://github.com/ClickHouse/ClickHouse/pull/22875) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix vanilla GCC compilation in macOS [#22885](https://github.com/ClickHouse/ClickHouse/pull/22885) ([Denis Glazachev](https://github.com/traceon)).
* Better diagnostics for OOM in stress test [#22894](https://github.com/ClickHouse/ClickHouse/pull/22894) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dictionaries updated performance tests [#22925](https://github.com/ClickHouse/ClickHouse/pull/22925) ([Maksim Kita](https://github.com/kitaisreal)).
* IAggreagteFunction allocatesMemoryInArena removed default implementation [#22938](https://github.com/ClickHouse/ClickHouse/pull/22938) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix flapping test_merge_tree_s3 test [#22942](https://github.com/ClickHouse/ClickHouse/pull/22942) ([ianton-ru](https://github.com/ianton-ru)).
* less flaky test [#22944](https://github.com/ClickHouse/ClickHouse/pull/22944) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Dictionaries standardize exceptions [#22961](https://github.com/ClickHouse/ClickHouse/pull/22961) ([Maksim Kita](https://github.com/kitaisreal)).
* StorageExternalDistributed arcadia fix [#22962](https://github.com/ClickHouse/ClickHouse/pull/22962) ([Maksim Kita](https://github.com/kitaisreal)).
* Check out of range values in FieldVisitorConverToNumber [#22964](https://github.com/ClickHouse/ClickHouse/pull/22964) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix combinators with common prefix name (State and SimpleState) with libstdc++ [#22977](https://github.com/ClickHouse/ClickHouse/pull/22977) ([Azat Khuzhin](https://github.com/azat)).
* Fix arcadia [#22982](https://github.com/ClickHouse/ClickHouse/pull/22982) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix excessive warning in StorageDistributed with cross-replication [#22990](https://github.com/ClickHouse/ClickHouse/pull/22990) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Update MergeTreeData.cpp Better error message. [#22994](https://github.com/ClickHouse/ClickHouse/pull/22994) ([Denny Crane](https://github.com/den-crane)).
* Fix assertion when filtering tables in StorageMerge [#22998](https://github.com/ClickHouse/ClickHouse/pull/22998) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add a test for [#2719](https://github.com/ClickHouse/ClickHouse/issues/2719) [#23008](https://github.com/ClickHouse/ClickHouse/pull/23008) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix multi response in TestKeeper [#23041](https://github.com/ClickHouse/ClickHouse/pull/23041) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Improve hung check in Stress tests [#23043](https://github.com/ClickHouse/ClickHouse/pull/23043) ([Alexander Tokmakov](https://github.com/tavplubix)).
* blog article about code review [#23045](https://github.com/ClickHouse/ClickHouse/pull/23045) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* LibraryDictionary bridge library interface [#23048](https://github.com/ClickHouse/ClickHouse/pull/23048) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove useless files [#23049](https://github.com/ClickHouse/ClickHouse/pull/23049) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Upload keeper logs from stateless tests [#23077](https://github.com/ClickHouse/ClickHouse/pull/23077) ([alesapin](https://github.com/alesapin)).
* CI runner intergation tests logs update to tar.gz [#23078](https://github.com/ClickHouse/ClickHouse/pull/23078) ([Maksim Kita](https://github.com/kitaisreal)).
* Tiny logging improvements [#23083](https://github.com/ClickHouse/ClickHouse/pull/23083) ([Azat Khuzhin](https://github.com/azat)).
* Block all memory tracking limits in dtors/SCOPE_EXIT_*SAFE/tryLogCurrentException [#23086](https://github.com/ClickHouse/ClickHouse/pull/23086) ([Azat Khuzhin](https://github.com/azat)).
* jemalloc tuning [#23088](https://github.com/ClickHouse/ClickHouse/pull/23088) ([Azat Khuzhin](https://github.com/azat)).
* Rename strange tests [#23111](https://github.com/ClickHouse/ClickHouse/pull/23111) ([alesapin](https://github.com/alesapin)).
* Fix arcadia build S3 [#23114](https://github.com/ClickHouse/ClickHouse/pull/23114) ([Maksim Kita](https://github.com/kitaisreal)).
* Updated zlib [#23153](https://github.com/ClickHouse/ClickHouse/pull/23153) ([Maksim Kita](https://github.com/kitaisreal)).
* [RFC] Change logging from trace to debug for messages with rows/bytes [#23160](https://github.com/ClickHouse/ClickHouse/pull/23160) ([Azat Khuzhin](https://github.com/azat)).
* More verbose logs for debuging test failures with Replicated and Keeper [#23161](https://github.com/ClickHouse/ClickHouse/pull/23161) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix exception message for "parts_to_throw_insert" [#23177](https://github.com/ClickHouse/ClickHouse/pull/23177) ([madianjun](https://github.com/mdianjun)).
* Fix flapping tests test_s3_zero_copy_replication [#23184](https://github.com/ClickHouse/ClickHouse/pull/23184) ([ianton-ru](https://github.com/ianton-ru)).
* Add a test for [#14610](https://github.com/ClickHouse/ClickHouse/issues/14610) [#23209](https://github.com/ClickHouse/ClickHouse/pull/23209) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test for fixed issue [#9363](https://github.com/ClickHouse/ClickHouse/issues/9363) [#23216](https://github.com/ClickHouse/ClickHouse/pull/23216) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Disable postgresql_port in perf tests [#23218](https://github.com/ClickHouse/ClickHouse/pull/23218) ([Azat Khuzhin](https://github.com/azat)).
