---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.3.1.6185-prestable FIXME as compared to v21.2.1.5869-prestable

#### Backward Incompatible Change
* Now all case-insensitive function names will be lower-cased during query analysis. This is needed for projection query routing. [#20174](https://github.com/ClickHouse/ClickHouse/pull/20174) ([Amos Bird](https://github.com/amosbird)).
* Now it's not allowed to create MergeTree tables in old syntax with table TTL because it's just ignored. Attach of old tables is still possible. [#20282](https://github.com/ClickHouse/ClickHouse/pull/20282) ([alesapin](https://github.com/alesapin)).

#### New Feature
* Add experimental `Replicated` database engine. It replicates DDL queries across multiple hosts. [#16193](https://github.com/ClickHouse/ClickHouse/pull/16193) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Distributed query deduplication is a followup to [#16033](https://github.com/ClickHouse/ClickHouse/issues/16033) and partially resolves the proposal [#13574](https://github.com/ClickHouse/ClickHouse/issues/13574). [#17348](https://github.com/ClickHouse/ClickHouse/pull/17348) ([xjewer](https://github.com/xjewer)).
* Add the ability to backup/restore metadata files for DiskS3. [#18377](https://github.com/ClickHouse/ClickHouse/pull/18377) ([Pavel Kovalenko](https://github.com/Jokser)).
* - Included in the pull request. [#18508](https://github.com/ClickHouse/ClickHouse/pull/18508) ([PHO](https://github.com/depressed-pho)).
* Added file() function to read file as a String. This close [#issue:18851](https://github.com/ClickHouse/ClickHouse/issues/18851). [#19204](https://github.com/ClickHouse/ClickHouse/pull/19204) ([keenwolf](https://github.com/keen-wolf)).
* Tables with `MergeTree*` engine now have two new table-level settings for query concurrency control. Setting `max_concurrent_queries` limits the number of concurrently executed queries which are related to this table. Setting `min_marks_to_honor_max_concurrent_queries` tells to apply previous setting only if query reads at least this number of marks. [#19544](https://github.com/ClickHouse/ClickHouse/pull/19544) ([Amos Bird](https://github.com/amosbird)).
* - Mentioned in [#18454](https://github.com/ClickHouse/ClickHouse/issues/18454) - add function `htmlOrxmlCoarseParse`; - support `<script></script>` parse; - support `<style></style>` parse; - support `<![CDATA[]]>` parse; - support white space collapse; - support any `<content>` format parse; - HyperScan to support SIMD; - Everything is done in a single pass. [#19600](https://github.com/ClickHouse/ClickHouse/pull/19600) ([zlx19950903](https://github.com/zlx19950903)).
* Add quota type QUERY_SELECTS and QUERY_INSERTS. [#19603](https://github.com/ClickHouse/ClickHouse/pull/19603) ([JackyWoo](https://github.com/JackyWoo)).
* ExecutableDictionarySource added implicit_key option. Fixes [#14527](https://github.com/ClickHouse/ClickHouse/issues/14527). [#19677](https://github.com/ClickHouse/ClickHouse/pull/19677) ([Maksim Kita](https://github.com/kitaisreal)).
* Added Server Side Encryption Customer Keys (the `x-amz-server-side-encryption-customer-(key/md5)` header) support in S3 client. See [the link](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html). Closes [#19428](https://github.com/ClickHouse/ClickHouse/issues/19428). [#19748](https://github.com/ClickHouse/ClickHouse/pull/19748) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Function `reinterpretAs` updated to support big integers. Fixes [#19691](https://github.com/ClickHouse/ClickHouse/issues/19691). [#19858](https://github.com/ClickHouse/ClickHouse/pull/19858) ([Maksim Kita](https://github.com/kitaisreal)).
* Add setting `insert_shard_id` to support insert data into specific shard from distributed table. [#19961](https://github.com/ClickHouse/ClickHouse/pull/19961) ([flynn](https://github.com/ucasfl)).
* Added timezoneOffset(datetime) function which will give the offset from UTC in seconds. This close [#issue:19850](https://github.com/ClickHouse/ClickHouse/issues/19850). [#19962](https://github.com/ClickHouse/ClickHouse/pull/19962) ([keenwolf](https://github.com/keen-wolf)).
* New `event_time_microseconds column` in `system.part_log` table. [#20027](https://github.com/ClickHouse/ClickHouse/pull/20027) ([Bharat Nallan](https://github.com/bharatnc)).
* ... Add aggregate function `deltaSum` for summing the differences between consecutive rows. [#20057](https://github.com/ClickHouse/ClickHouse/pull/20057) ([Russ Frank](https://github.com/rf)).
* Add two settings to delay or throw error during insertion when there are too many inactive parts. This is useful when server fails to clean up parts quickly enough. [#20178](https://github.com/ClickHouse/ClickHouse/pull/20178) ([Amos Bird](https://github.com/amosbird)).
* Add file engine settings: `engine_file_empty_if_not_exists` and `engine_file_truncate_on_insert`. [#20620](https://github.com/ClickHouse/ClickHouse/pull/20620) ([M0r64n](https://github.com/M0r64n)).

#### Performance Improvement
* Add parallel select final for one part with level>0 when `do_not_merge_across_partitions_select_final` setting is 1. [#19375](https://github.com/ClickHouse/ClickHouse/pull/19375) ([Kruglov Pavel](https://github.com/Avogar)).
* Improved performance of bitmap columns during joins. [#19407](https://github.com/ClickHouse/ClickHouse/pull/19407) ([templarzq](https://github.com/templarzq)).
* Partially reimplement HTTP server to make it making less copies of incoming and outgoing data. It gives up to 1.5 performance improvement on inserting long records over HTTP. [#19516](https://github.com/ClickHouse/ClickHouse/pull/19516) ([Ivan](https://github.com/abyss7)).
* Improve performance of aggregate functions by more strict aliasing. [#19946](https://github.com/ClickHouse/ClickHouse/pull/19946) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix the case when DataType parser may have exponential complexity (found by fuzzer). This closes [#20096](https://github.com/ClickHouse/ClickHouse/issues/20096). [#20132](https://github.com/ClickHouse/ClickHouse/pull/20132) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `compress` setting for `Memory` tables. If it's enabled the table will use less RAM. On some machines and datasets it can also work faster on SELECT, but it is not always the case. This closes [#20093](https://github.com/ClickHouse/ClickHouse/issues/20093). Note: there are reasons why Memory tables can work slower than MergeTree: (1) lack of compression (2) static size of blocks (3) lack of indices and prewhere... [#20168](https://github.com/ClickHouse/ClickHouse/pull/20168) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not squash blocks too much on INSERT SELECT if inserting into Memory table. In previous versions inefficient data representation was created in Memory table after INSERT SELECT. This closes [#13052](https://github.com/ClickHouse/ClickHouse/issues/13052). [#20169](https://github.com/ClickHouse/ClickHouse/pull/20169) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improved performance of aggregation by several fixed size fields (unconfirmed). [#20454](https://github.com/ClickHouse/ClickHouse/pull/20454) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Speed up reading from `Memory` tables in extreme cases (when reading speed is in order of 50 GB/sec) by simplification of pipeline and (consequently) less lock contention in pipeline scheduling. [#20468](https://github.com/ClickHouse/ClickHouse/pull/20468) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve performance of GROUP BY multiple fixed size keys. [#20472](https://github.com/ClickHouse/ClickHouse/pull/20472) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The setting `distributed_aggregation_memory_efficient` is enabled by default. It will lower memory usage and improve performance of distributed queries. [#20599](https://github.com/ClickHouse/ClickHouse/pull/20599) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Slightly better code in aggregation. [#20978](https://github.com/ClickHouse/ClickHouse/pull/20978) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add back intDiv/module vectorConstant specializations for better performance. This fixes [#21293](https://github.com/ClickHouse/ClickHouse/issues/21293) . The regression was introduced in https://github.com/ClickHouse/ClickHouse/pull/18145 . [#21307](https://github.com/ClickHouse/ClickHouse/pull/21307) ([Amos Bird](https://github.com/amosbird)).

#### Improvement
* Fix creation of `TTL` in cases, when its expression is a function and it is the same as `ORDER BY` key. Now it's allowed to set custom aggregation to primary key columns in `TTL` with `GROUP BY`. Backward incompatible: For primary key columns, which are not in `GROUP BY` and aren't set explicitly now is applied function `any` instead of `max`, when TTL is expired. Also if you use TTL with `WHERE` or `GROUP BY` you can see exceptions at merges, while making rolling update. [#15450](https://github.com/ClickHouse/ClickHouse/pull/15450) ([Anton Popov](https://github.com/CurtizJ)).
* Hedged Requests for remote queries. When setting `use_hedged_requests` enabled (by default), allow to establish many connections with different replicas for query. New connection is enabled in case existent connection(s) with replica(s) were not established within `hedged_connection_timeout` or no data was received within `receive_data_timeout`. Query uses the first connection which send non empty progress packet (or data packet, if `allow_changing_replica_until_first_data_packet`); other connections are cancelled. Queries with `max_parallel_replicas > 1` are supported. [#19291](https://github.com/ClickHouse/ClickHouse/pull/19291) ([Kruglov Pavel](https://github.com/Avogar)).
* Print inline frames for fatal stacktraces. [#19317](https://github.com/ClickHouse/ClickHouse/pull/19317) ([Ivan](https://github.com/abyss7)).
* Do not silently ignore write errors. [#19451](https://github.com/ClickHouse/ClickHouse/pull/19451) ([Azat Khuzhin](https://github.com/azat)).
* Added support for `PREWHERE` when tables have row-level security expressions specified. [#19576](https://github.com/ClickHouse/ClickHouse/pull/19576) ([Denis Glazachev](https://github.com/traceon)).
* Add IStoragePolicy interface. [#19608](https://github.com/ClickHouse/ClickHouse/pull/19608) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* Add ability to throttle INSERT into Distributed based on amount of pending bytes for async send (`bytes_to_delay_insert`/`max_delay_to_insert` and `bytes_to_throw_insert` settings for `Distributed` engine has been added). [#19673](https://github.com/ClickHouse/ClickHouse/pull/19673) ([Azat Khuzhin](https://github.com/azat)).
* move Conditions that are not related to JOIN to where clause. [#18720](https://github.com/ClickHouse/ClickHouse/issues/18720). [#19685](https://github.com/ClickHouse/ClickHouse/pull/19685) ([hexiaoting](https://github.com/hexiaoting)).
* Add separate config directive for Buffer profile. [#19721](https://github.com/ClickHouse/ClickHouse/pull/19721) ([Azat Khuzhin](https://github.com/azat)).
* Show MaterializeMySQL tables in `system.parts`. [#19770](https://github.com/ClickHouse/ClickHouse/pull/19770) ([Stig Bakken](https://github.com/stigsb)).
* Initialize MaxDDLEntryID to the last value after restarting. Before this PR, MaxDDLEntryID will remain zero until a new DDLTask is processed. [#19924](https://github.com/ClickHouse/ClickHouse/pull/19924) ([Amos Bird](https://github.com/amosbird)).
* Add conversion of block structure for INSERT into Distributed tables if it does not match. [#19947](https://github.com/ClickHouse/ClickHouse/pull/19947) ([Azat Khuzhin](https://github.com/azat)).
* If user calls `JSONExtract` function with `Float32` type requested, allow inaccurate conversion to the result type. For example the number `0.1` in JSON is double precision and is not representable in Float32, but the user still wants to get it. Previous versions return 0 for non-Nullable type and NULL for Nullable type to indicate that conversion is imprecise. The logic was 100% correct but it was surprising to users and leading to questions. This closes [#13962](https://github.com/ClickHouse/ClickHouse/issues/13962). [#19960](https://github.com/ClickHouse/ClickHouse/pull/19960) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The value of MYSQL_OPT_RECONNECT option can now be controlled by "opt_reconnect" parameter in the config section of mysql replica. [#19998](https://github.com/ClickHouse/ClickHouse/pull/19998) ([Alexander Kazakov](https://github.com/Akazz)).
* Return `DiskType` instead of `String` in IDisk::getType() as in the rest of storage interfaces. [#19999](https://github.com/ClickHouse/ClickHouse/pull/19999) ([Ernest Zaslavsky](https://github.com/kreuzerkrieg)).
* Fix data race in executable dictionary that was possible only on misuse (when the script returns data ignoring its input). [#20045](https://github.com/ClickHouse/ClickHouse/pull/20045) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Show full details of MaterializeMySQL tables in `system.tables`. [#20051](https://github.com/ClickHouse/ClickHouse/pull/20051) ([Stig Bakken](https://github.com/stigsb)).
* Supports system.zookeeper path IN query. [#20105](https://github.com/ClickHouse/ClickHouse/pull/20105) ([小路](https://github.com/nicelulu)).
* 1. SHOW TABLES is now considered as one query in the quota calculations, not two queries. 2. SYSTEM queries now consume quota. 3. Fix calculation of interval's end in quota consumption. [#20106](https://github.com/ClickHouse/ClickHouse/pull/20106) ([Vitaly Baranov](https://github.com/vitlibar)).
* - Fix toDateTime64(toDate()/toDateTime()) for DateTime64 - Implement DateTime64 clamping to match DateTime behaviour. [#20131](https://github.com/ClickHouse/ClickHouse/pull/20131) ([Azat Khuzhin](https://github.com/azat)).
* The setting `access_management` is now configurable on startup by providing `CLICKHOUSE_DEFAULT_ACCESS_MANAGEMENT`, defaults to disabled (`0`) which was the prior value. [#20139](https://github.com/ClickHouse/ClickHouse/pull/20139) ([Marquitos](https://github.com/sonirico)).
* Updated `CacheDictionary`, `ComplexCacheDictionary`, `SSDCacheDictionary`, `SSDComplexKeyDictionary` to use LRUHashMap as underlying index. [#20164](https://github.com/ClickHouse/ClickHouse/pull/20164) ([Maksim Kita](https://github.com/kitaisreal)).
* Support all native integer types in bitmap functions. [#20171](https://github.com/ClickHouse/ClickHouse/pull/20171) ([Amos Bird](https://github.com/amosbird)).
* Normalize count(constant), sum(1) to count(). This is needed for projection query routing. [#20175](https://github.com/ClickHouse/ClickHouse/pull/20175) ([Amos Bird](https://github.com/amosbird)).
* Perform algebraic optimizations of arithmetic expressions inside `avg` aggregate function. close [#20092](https://github.com/ClickHouse/ClickHouse/issues/20092). [#20183](https://github.com/ClickHouse/ClickHouse/pull/20183) ([flynn](https://github.com/ucasfl)).
* Lockless `SYSTEM FLUSH DISTRIBUTED`. [#20215](https://github.com/ClickHouse/ClickHouse/pull/20215) ([Azat Khuzhin](https://github.com/azat)).
* Implicit conversion from integer to Dicimal type might succeeded if integer value doe not fit into Decimal type. Now it throws `ARGUMENT_OUT_OF_BOUND`. [#20232](https://github.com/ClickHouse/ClickHouse/pull/20232) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Do not allow early constant folding of explicitly forbidden functions. [#20303](https://github.com/ClickHouse/ClickHouse/pull/20303) ([Azat Khuzhin](https://github.com/azat)).
* Make FQDN and other DNS related functions work correctly in alpine images. [#20336](https://github.com/ClickHouse/ClickHouse/pull/20336) ([filimonov](https://github.com/filimonov)).
* Fixed race between execution of distributed DDL tasks and cleanup of DDL queue. Now DDL task cannot be removed from ZooKeeper if there are active workers. Fixes [#20016](https://github.com/ClickHouse/ClickHouse/issues/20016). [#20448](https://github.com/ClickHouse/ClickHouse/pull/20448) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Improved serialization for data types combined of Arrays and Tuples. Improved matching enum data types to protobuf enum type. Fixed serialization of the `Map` data type. Omitted values are now set by default. [#20506](https://github.com/ClickHouse/ClickHouse/pull/20506) ([Vitaly Baranov](https://github.com/vitlibar)).
* https://github.com/ClickHouse/ClickHouse/issues/20576. [#20596](https://github.com/ClickHouse/ClickHouse/pull/20596) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Function 'reinterpretAs(x, Type)' renamed into 'reinterpret(x, Type)'. [#20611](https://github.com/ClickHouse/ClickHouse/pull/20611) ([Maksim Kita](https://github.com/kitaisreal)).
* When loading config for mysql source ClickHouse will now randomize the list of replicas with the same priority to ensure the round-robin logics of picking mysql endpoint. This closes [#20629](https://github.com/ClickHouse/ClickHouse/issues/20629). [#20632](https://github.com/ClickHouse/ClickHouse/pull/20632) ([Alexander Kazakov](https://github.com/Akazz)).
* Do only merging of sorted blocks on initiator with distributed_group_by_no_merge. [#20882](https://github.com/ClickHouse/ClickHouse/pull/20882) ([Azat Khuzhin](https://github.com/azat)).
* - Fill only requested columns when querying system.parts & system.parts_columns. Closes [#19570](https://github.com/ClickHouse/ClickHouse/issues/19570). ... [#21035](https://github.com/ClickHouse/ClickHouse/pull/21035) ([Anmol Arora](https://github.com/anmolarora)).
* Usability improvement: more consistent `DateTime64` parsing: recognize the case when unix timestamp with subsecond resolution is specified as scaled integer (like `1111111111222` instead of `1111111111.222`). This closes [#13194](https://github.com/ClickHouse/ClickHouse/issues/13194). [#21053](https://github.com/ClickHouse/ClickHouse/pull/21053) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* MySQL dictionary source will now retry unexpected connection failures (Lost connection to MySQL server during query) which sometimes happen on SSL/TLS connections. [#21237](https://github.com/ClickHouse/ClickHouse/pull/21237) ([Alexander Kazakov](https://github.com/Akazz)).
* Forbid to drop a column if it's referenced by materialized view. Closes [#21164](https://github.com/ClickHouse/ClickHouse/issues/21164). [#21303](https://github.com/ClickHouse/ClickHouse/pull/21303) ([flynn](https://github.com/ucasfl)).
* Provide better compatibility for mysql clients. 1. mysql jdbc 2. mycli. [#21367](https://github.com/ClickHouse/ClickHouse/pull/21367) ([Amos Bird](https://github.com/amosbird)).
* Case-insensitive compression methods for table functions. Also fixed `LZMA` compression method which was checked in upper case. [#21416](https://github.com/ClickHouse/ClickHouse/pull/21416) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### Bug Fix
* Background thread which executes `ON CLUSTER` queries might hang waiting for dropped replicated table to do something. It's fixed. [#19684](https://github.com/ClickHouse/ClickHouse/pull/19684) ([yiguolei](https://github.com/yiguolei)).
* Fix a bug that moving pieces to destination table may failed in case of launching multiple clickhouse-copiers. [#19743](https://github.com/ClickHouse/ClickHouse/pull/19743) ([madianjun](https://github.com/mdianjun)).
* Fix clickhouse-client abort exception while executing only `select`. [#19790](https://github.com/ClickHouse/ClickHouse/pull/19790) ([李扬](https://github.com/taiyang-li)).
* Fix starting the server with tables having default expressions containing dictGet(). Allow getting return type of dictGet() without loading dictionary. [#19805](https://github.com/ClickHouse/ClickHouse/pull/19805) ([Vitaly Baranov](https://github.com/vitlibar)).
* Deadlock was possible if system.text_log is enabled. This fixes [#19874](https://github.com/ClickHouse/ClickHouse/issues/19874). [#19875](https://github.com/ClickHouse/ClickHouse/pull/19875) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* BloomFilter index crash fix. Fixes [#19757](https://github.com/ClickHouse/ClickHouse/issues/19757). [#19884](https://github.com/ClickHouse/ClickHouse/pull/19884) ([Maksim Kita](https://github.com/kitaisreal)).
* - Fix a segfault in function `fromModifiedJulianDay` when the argument type is `Nullable(T)` for any integral types other than Int32. [#19959](https://github.com/ClickHouse/ClickHouse/pull/19959) ([PHO](https://github.com/depressed-pho)).
* `EmbeddedRocksDB` is an experimental storage. Fix the issue with lack of proper type checking. Simplified code. This closes [#19967](https://github.com/ClickHouse/ClickHouse/issues/19967). [#19972](https://github.com/ClickHouse/ClickHouse/pull/19972) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Prevent "Connection refused" in docker during initialization script execution. [#20012](https://github.com/ClickHouse/ClickHouse/pull/20012) ([filimonov](https://github.com/filimonov)).
* MaterializeMySQL: Fix replication for statements that update several tables. [#20066](https://github.com/ClickHouse/ClickHouse/pull/20066) ([Håvard Kvålen](https://github.com/havardk)).
* Fix the case when calculating modulo of division of negative number by small divisor, the resulting data type was not large enough to accomodate the negative result. This closes [#20052](https://github.com/ClickHouse/ClickHouse/issues/20052). [#20067](https://github.com/ClickHouse/ClickHouse/pull/20067) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* * Bugfix in StorageJoin. [#20079](https://github.com/ClickHouse/ClickHouse/pull/20079) ([Vladimir C](https://github.com/vdimir)).
* The `MongoDB` table engine now establishes connection only when it's going to read data. `ATTACH TABLE` won't try to connect anymore. [#20110](https://github.com/ClickHouse/ClickHouse/pull/20110) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix server crash after query with `if` function with `Tuple` type of then/else branches result. `Tuple` type must contain `Array` or another complex type. Fixes [#18356](https://github.com/ClickHouse/ClickHouse/issues/18356). [#20133](https://github.com/ClickHouse/ClickHouse/pull/20133) ([alesapin](https://github.com/alesapin)).
* fix toMinute function to handle special timezone correctly. [#20149](https://github.com/ClickHouse/ClickHouse/pull/20149) ([keenwolf](https://github.com/keen-wolf)).
* Fixes [#19314](https://github.com/ClickHouse/ClickHouse/issues/19314). [#20156](https://github.com/ClickHouse/ClickHouse/pull/20156) ([Ivan](https://github.com/abyss7)).
* Fix CTE when using in INSERT SELECT. This fixes [#20187](https://github.com/ClickHouse/ClickHouse/issues/20187), fixes [#20195](https://github.com/ClickHouse/ClickHouse/issues/20195). [#20211](https://github.com/ClickHouse/ClickHouse/pull/20211) ([Amos Bird](https://github.com/amosbird)).
* Fix rare server crash on config reload during the shutdown. Fixes [#19689](https://github.com/ClickHouse/ClickHouse/issues/19689). [#20224](https://github.com/ClickHouse/ClickHouse/pull/20224) ([alesapin](https://github.com/alesapin)).
* Fix exception during vertical merge for `MergeTree` table engines family which don't allow to perform vertical merges. Fixes [#20259](https://github.com/ClickHouse/ClickHouse/issues/20259). [#20279](https://github.com/ClickHouse/ClickHouse/pull/20279) ([alesapin](https://github.com/alesapin)).
* Fixed the behavior when in case of broken JSON we tried to read the whole file into memory which leads to exception from the allocator. Fixes [#19719](https://github.com/ClickHouse/ClickHouse/issues/19719). [#20286](https://github.com/ClickHouse/ClickHouse/pull/20286) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Restrict to `DROP` or `RENAME` version column of `*CollapsingMergeTree` and `ReplacingMergeTree` table engines. [#20300](https://github.com/ClickHouse/ClickHouse/pull/20300) ([alesapin](https://github.com/alesapin)).
* Fix too often retries of failed background tasks for `ReplicatedMergeTree` table engines family. This could lead to too verbose logging and increased CPU load. Fixes [#20203](https://github.com/ClickHouse/ClickHouse/issues/20203). [#20335](https://github.com/ClickHouse/ClickHouse/pull/20335) ([alesapin](https://github.com/alesapin)).
* Fix incorrect result of binary operations between two constant decimals of different scale. Fixes [#20283](https://github.com/ClickHouse/ClickHouse/issues/20283). [#20339](https://github.com/ClickHouse/ClickHouse/pull/20339) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix null dereference with `join_use_nulls=1`. [#20344](https://github.com/ClickHouse/ClickHouse/pull/20344) ([Azat Khuzhin](https://github.com/azat)).
* Avoid invalid dereference in RANGE_HASHED() dictionary. [#20345](https://github.com/ClickHouse/ClickHouse/pull/20345) ([Azat Khuzhin](https://github.com/azat)).
* Check if table function `view` is used in expression list and throw an error. This fixes [#20342](https://github.com/ClickHouse/ClickHouse/issues/20342). [#20350](https://github.com/ClickHouse/ClickHouse/pull/20350) ([Amos Bird](https://github.com/amosbird)).
* Fix `LOGICAL_ERROR` for `join_use_nulls=1` when JOIN contains const from SELECT. [#20461](https://github.com/ClickHouse/ClickHouse/pull/20461) ([Azat Khuzhin](https://github.com/azat)).
* Fix abnormal server termination when http client goes away. [#20464](https://github.com/ClickHouse/ClickHouse/pull/20464) ([Azat Khuzhin](https://github.com/azat)).
* Fix infinite loop when propagating WITH aliases to subqueries. This fixes [#20388](https://github.com/ClickHouse/ClickHouse/issues/20388). [#20476](https://github.com/ClickHouse/ClickHouse/pull/20476) ([Amos Bird](https://github.com/amosbird)).
* Fix function `transform` does not work properly for floating point keys. Closes [#20460](https://github.com/ClickHouse/ClickHouse/issues/20460). [#20479](https://github.com/ClickHouse/ClickHouse/pull/20479) ([flynn](https://github.com/ucasfl)).
* Add proper checks while parsing directory names for async INSERT (fixes SIGSEGV). [#20498](https://github.com/ClickHouse/ClickHouse/pull/20498) ([Azat Khuzhin](https://github.com/azat)).
* Fix crash which could happen if unknown packet was received from remove query (was introduced in [#17868](https://github.com/ClickHouse/ClickHouse/issues/17868)). [#20547](https://github.com/ClickHouse/ClickHouse/pull/20547) ([Azat Khuzhin](https://github.com/azat)).
* Fix the number of threads for scalar subqueries and subqueries for index (after [#19007](https://github.com/ClickHouse/ClickHouse/issues/19007) single thread was always used). Fixes [#20457](https://github.com/ClickHouse/ClickHouse/issues/20457), [#20512](https://github.com/ClickHouse/ClickHouse/issues/20512). [#20550](https://github.com/ClickHouse/ClickHouse/pull/20550) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed inconsistent behavior of dictionary in case of queries where we look for absent keys in dictionary. [#20578](https://github.com/ClickHouse/ClickHouse/pull/20578) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix subquery with union distinct and limit clause. close [#20597](https://github.com/ClickHouse/ClickHouse/issues/20597). [#20610](https://github.com/ClickHouse/ClickHouse/pull/20610) ([flynn](https://github.com/ucasfl)).
* Fix usage of `-Distinct` combinator with `-State` combinator in aggregate functions. [#20866](https://github.com/ClickHouse/ClickHouse/pull/20866) ([Anton Popov](https://github.com/CurtizJ)).
* `USE database;` query did not work when using MySQL 5.7 client to connect to ClickHouse server, it's fixed. Fixes [#18926](https://github.com/ClickHouse/ClickHouse/issues/18926). [#20878](https://github.com/ClickHouse/ClickHouse/pull/20878) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix 'Empty task was returned from async task queue' on query cancellation. [#20881](https://github.com/ClickHouse/ClickHouse/pull/20881) ([Azat Khuzhin](https://github.com/azat)).
* Closes [#9969](https://github.com/ClickHouse/ClickHouse/issues/9969). Fixed Brotli http compression error, which reproduced for large data sizes, slightly complicated structure and with json output format. Update Brotli to the latest version to include the "fix rare access to uninitialized data in ring-buffer". [#20991](https://github.com/ClickHouse/ClickHouse/pull/20991) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed behaviour, when `ALTER MODIFY COLUMN` created mutation, that will knowingly fail. [#21007](https://github.com/ClickHouse/ClickHouse/pull/21007) ([Anton Popov](https://github.com/CurtizJ)).
* - Block parallel insertions into storage join. [#21009](https://github.com/ClickHouse/ClickHouse/pull/21009) ([Vladimir C](https://github.com/vdimir)).
* Out of bound memory access was possible when formatting specifically crafted out of range value of type `DateTime64`. This closes [#20494](https://github.com/ClickHouse/ClickHouse/issues/20494). This closes [#20543](https://github.com/ClickHouse/ClickHouse/issues/20543). [#21023](https://github.com/ClickHouse/ClickHouse/pull/21023) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* fix default_replica_path and default_replica_name values are useless on Replicated(*)MergeTree engine when the engine needs specify other parameters. [#21060](https://github.com/ClickHouse/ClickHouse/pull/21060) ([mxzlxy](https://github.com/mxzlxy)).
* Fix type mismatch issue when using LowCardinality keys in joinGet. This fixes [#21114](https://github.com/ClickHouse/ClickHouse/issues/21114). [#21117](https://github.com/ClickHouse/ClickHouse/pull/21117) ([Amos Bird](https://github.com/amosbird)).
* Fix the metadata leak when the Replicated*MergeTree with custom (non default) ZooKeeper cluster is dropped. [#21119](https://github.com/ClickHouse/ClickHouse/pull/21119) ([fastio](https://github.com/fastio)).
* fix bug related to cast tuple to map. Closes [#21029](https://github.com/ClickHouse/ClickHouse/issues/21029). [#21120](https://github.com/ClickHouse/ClickHouse/pull/21120) ([hexiaoting](https://github.com/hexiaoting)).
* Fix `input_format_null_as_default` take effective when types are nullable. This fixes [#21116](https://github.com/ClickHouse/ClickHouse/issues/21116) . [#21121](https://github.com/ClickHouse/ClickHouse/pull/21121) ([Amos Bird](https://github.com/amosbird)).
* Fixes [#21112](https://github.com/ClickHouse/ClickHouse/issues/21112). Fixed bug that could cause duplicates with insert query (if one of the callbacks came a little too late). [#21138](https://github.com/ClickHouse/ClickHouse/pull/21138) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Now mutations allowed only for table engines that support them (MergeTree family, Memory, MaterializedView). Other engines will report a more clear error. Fixes [#21168](https://github.com/ClickHouse/ClickHouse/issues/21168). [#21183](https://github.com/ClickHouse/ClickHouse/pull/21183) ([alesapin](https://github.com/alesapin)).
* Fix crash in `EXPLAIN` for query with `UNION`. Fixes [#20876](https://github.com/ClickHouse/ClickHouse/issues/20876), [#21170](https://github.com/ClickHouse/ClickHouse/issues/21170). [#21246](https://github.com/ClickHouse/ClickHouse/pull/21246) ([flynn](https://github.com/ucasfl)).
* Fix bug with `join_use_nulls` and joining `TOTALS` from subqueries. This closes [#19362](https://github.com/ClickHouse/ClickHouse/issues/19362) and [#21137](https://github.com/ClickHouse/ClickHouse/issues/21137). [#21248](https://github.com/ClickHouse/ClickHouse/pull/21248) ([Vladimir C](https://github.com/vdimir)).
* Fix redundant reconnects to ZooKeeper and the possibility of two active sessions for a single clickhouse server. Both problems introduced in [#14678](https://github.com/ClickHouse/ClickHouse/issues/14678). [#21264](https://github.com/ClickHouse/ClickHouse/pull/21264) ([alesapin](https://github.com/alesapin)).
* Now `ALTER MODIFY COLUMN` queries will correctly affect changes in partition key, skip indices, TTLs, and so on. Fixes [#13675](https://github.com/ClickHouse/ClickHouse/issues/13675). [#21334](https://github.com/ClickHouse/ClickHouse/pull/21334) ([alesapin](https://github.com/alesapin)).
* Fix error `Bad cast from type ... to DB::ColumnLowCardinality` while inserting into table with `LowCardinality` column from `Values` format. Fixes [#21140](https://github.com/ClickHouse/ClickHouse/issues/21140). [#21357](https://github.com/ClickHouse/ClickHouse/pull/21357) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix SIGSEGV for distributed queries on failures. [#21434](https://github.com/ClickHouse/ClickHouse/pull/21434) ([Azat Khuzhin](https://github.com/azat)).
* Fix a deadlock in `ALTER DELETE` mutations for non replicated MergeTree table engines when the predicate contains the table itself. Fixes [#20558](https://github.com/ClickHouse/ClickHouse/issues/20558). [#21477](https://github.com/ClickHouse/ClickHouse/pull/21477) ([alesapin](https://github.com/alesapin)).

#### Build/Testing/Packaging Improvement
* Fixed port clash from test_storage_kerberized_hdfs test. [#19974](https://github.com/ClickHouse/ClickHouse/pull/19974) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix some of the issues found by Coverity. See [#19964](https://github.com/ClickHouse/ClickHouse/issues/19964). [#20010](https://github.com/ClickHouse/ClickHouse/pull/20010) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to build ClickHouse with AVX-2 enabled globally. It gives slight performance benefits on modern CPUs. Not recommended for production and will not be supported as official build for now. [#20180](https://github.com/ClickHouse/ClickHouse/pull/20180) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add some checks in order by fix the bug https://clickhouse-test-reports.s3.yandex.net/20472/5bdc57004682a5e0236ec630546d20ad752c2fde/stress_test_(thread)/stderr.log. [#20516](https://github.com/ClickHouse/ClickHouse/pull/20516) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Print `stdout` and `stderr` to log when failed to start docker in integration tests. Before this PR there was a very short error message in this case which didn't help to investigate the problems:. [#20631](https://github.com/ClickHouse/ClickHouse/pull/20631) ([Vitaly Baranov](https://github.com/vitlibar)).
* Remove most of `sleep` commands from kafka integration tests, waiting for log events instead. Add test for different compression methods. [#21111](https://github.com/ClickHouse/ClickHouse/pull/21111) ([filimonov](https://github.com/filimonov)).
* Allow to start up with modified binary under gdb. In previous version if you set up breakpoint in gdb before start, server will refuse to start up due to failed integrity check. [#21258](https://github.com/ClickHouse/ClickHouse/pull/21258) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Experimental feature

* Introduce experimental support for window functions, enabled with `allow_experimental_functions = 1`. This is a preliminary, alpha-quality implementation that is not suitable for production use and will change in backward-incompatible ways in future releases. Please see [the documentation](https://github.com/ClickHouse/ClickHouse/blob/master/docs/en/sql-reference/window-functions/index.md#experimental-window-functions) for the list of supported features. [#20337](https://github.com/ClickHouse/ClickHouse/pull/20337) ([Alexander Kuzmenkov](https://github.com/akuzm)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Fix access control manager destruction order"'. [#20394](https://github.com/ClickHouse/ClickHouse/pull/20394) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Update argmax.md '. [#20625](https://github.com/ClickHouse/ClickHouse/pull/20625) ([Marvin Taschenberger](https://github.com/Taschenbergerm)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Update Pytest check [#18972](https://github.com/ClickHouse/ClickHouse/pull/18972) ([Ivan](https://github.com/abyss7)).
* [wip] support RANGE frame for window functions [#19299](https://github.com/ClickHouse/ClickHouse/pull/19299) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* In memory coordination inside ClickHouse [#19580](https://github.com/ClickHouse/ClickHouse/pull/19580) ([alesapin](https://github.com/alesapin)).
* client: more suggestions [#19584](https://github.com/ClickHouse/ClickHouse/pull/19584) ([Azat Khuzhin](https://github.com/azat)).
* Allow to run all style checks in one file [#19726](https://github.com/ClickHouse/ClickHouse/pull/19726) ([Anton Popov](https://github.com/CurtizJ)).
* Fix [#19371](https://github.com/ClickHouse/ClickHouse/issues/19371) [#19765](https://github.com/ClickHouse/ClickHouse/pull/19765) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Minor code improvements around ThreadStatus [#19771](https://github.com/ClickHouse/ClickHouse/pull/19771) ([Alexander Tokmakov](https://github.com/tavplubix)).
* continue of [#19487](https://github.com/ClickHouse/ClickHouse/issues/19487) [#19801](https://github.com/ClickHouse/ClickHouse/pull/19801) ([flynn](https://github.com/ucasfl)).
* Fix UBSan report in intDiv [#19876](https://github.com/ClickHouse/ClickHouse/pull/19876) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow writing partial buffer [#19886](https://github.com/ClickHouse/ClickHouse/pull/19886) ([Azat Khuzhin](https://github.com/azat)).
* Remove an always-false condition from query parser [#19919](https://github.com/ClickHouse/ClickHouse/pull/19919) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* UNBOUNDED FOLLOWING frame end [#19921](https://github.com/ClickHouse/ClickHouse/pull/19921) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix logical error in INSERT VALUES [#19925](https://github.com/ClickHouse/ClickHouse/pull/19925) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix test keeper integration tests [#19942](https://github.com/ClickHouse/ClickHouse/pull/19942) ([alesapin](https://github.com/alesapin)).
* Fix build [#19948](https://github.com/ClickHouse/ClickHouse/pull/19948) ([Kruglov Pavel](https://github.com/Avogar)).
* CURRENT ROW and offset for start of ROWS frame [#19951](https://github.com/ClickHouse/ClickHouse/pull/19951) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix UBSan report in geoHashesInBox [#19956](https://github.com/ClickHouse/ClickHouse/pull/19956) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add MSan annotation for system.stack_trace [#19957](https://github.com/ClickHouse/ClickHouse/pull/19957) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky integration tests [#19971](https://github.com/ClickHouse/ClickHouse/pull/19971) ([Azat Khuzhin](https://github.com/azat)).
* Do not use inputs which values are known constants in ActionsDAG. [#19991](https://github.com/ClickHouse/ClickHouse/pull/19991) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* update perf tests [#20000](https://github.com/ClickHouse/ClickHouse/pull/20000) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* UBsan fixes [#20011](https://github.com/ClickHouse/ClickHouse/pull/20011) ([Azat Khuzhin](https://github.com/azat)).
* Remove useless code [#20029](https://github.com/ClickHouse/ClickHouse/pull/20029) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* update changelog [#20033](https://github.com/ClickHouse/ClickHouse/pull/20033) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Close input ports in DelayedPortsProcessor as soon as all outputs are finished [#20035](https://github.com/ClickHouse/ClickHouse/pull/20035) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* ReadBuffer: check for unread data on next() [#20037](https://github.com/ClickHouse/ClickHouse/pull/20037) ([Ivan](https://github.com/abyss7)).
* ReadBuffer: check that buffer position is not set beyond end [#20039](https://github.com/ClickHouse/ClickHouse/pull/20039) ([Ivan](https://github.com/abyss7)).
* CURRENT ROW frame start for RANGE frame [#20041](https://github.com/ClickHouse/ClickHouse/pull/20041) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix log message with elapsed time while pushing to views [#20047](https://github.com/ClickHouse/ClickHouse/pull/20047) ([Azat Khuzhin](https://github.com/azat)).
* Avoid UBSan report in pointInPolygon [#20049](https://github.com/ClickHouse/ClickHouse/pull/20049) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix tests *.reference files [#20050](https://github.com/ClickHouse/ClickHouse/pull/20050) ([Azat Khuzhin](https://github.com/azat)).
* ROWS OFFSET frame end [#20060](https://github.com/ClickHouse/ClickHouse/pull/20060) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Add more tests for modulo of division of negative number [#20063](https://github.com/ClickHouse/ClickHouse/pull/20063) ([hexiaoting](https://github.com/hexiaoting)).
* detect unmarked long tests in flaky check [#20068](https://github.com/ClickHouse/ClickHouse/pull/20068) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix removing of filter column when split filter actions. [#20073](https://github.com/ClickHouse/ClickHouse/pull/20073) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove AddingConstColumn step and transform. [#20077](https://github.com/ClickHouse/ClickHouse/pull/20077) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* LimitReadBuffer: check that position always advances [#20078](https://github.com/ClickHouse/ClickHouse/pull/20078) ([Ivan](https://github.com/abyss7)).
* Add fuzzer for ColumnsDescription [#20094](https://github.com/ClickHouse/ClickHouse/pull/20094) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Build actions dag to evaluate missing defaults. [#20097](https://github.com/ClickHouse/ClickHouse/pull/20097) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove never existing insert_in_memory_parts_timeout [#20099](https://github.com/ClickHouse/ClickHouse/pull/20099) ([Azat Khuzhin](https://github.com/azat)).
* RANGE OFFSET window frame [#20111](https://github.com/ClickHouse/ClickHouse/pull/20111) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Allow to drop readonly tables [#20114](https://github.com/ClickHouse/ClickHouse/pull/20114) ([nvartolomei](https://github.com/nvartolomei)).
* Add logging if Poco cannot allocate thread in tcp server [#20120](https://github.com/ClickHouse/ClickHouse/pull/20120) ([alesapin](https://github.com/alesapin)).
* Use fixed version of confluent-kafka library in integration tests [#20124](https://github.com/ClickHouse/ClickHouse/pull/20124) ([alesapin](https://github.com/alesapin)).
* Useless changes [#20150](https://github.com/ClickHouse/ClickHouse/pull/20150) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* remove some useless code [#20152](https://github.com/ClickHouse/ClickHouse/pull/20152) ([flynn](https://github.com/ucasfl)).
* Allow using MergeTreeWhereOptimizer not only with MergeTree-based storages [#20153](https://github.com/ClickHouse/ClickHouse/pull/20153) ([Max Akhmedov](https://github.com/zlobober)).
* Fix build of utils [#20155](https://github.com/ClickHouse/ClickHouse/pull/20155) ([Ivan](https://github.com/abyss7)).
* Fix UBSan report in arrayCumSum [#20160](https://github.com/ClickHouse/ClickHouse/pull/20160) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add changelog for 21.2 [#20185](https://github.com/ClickHouse/ClickHouse/pull/20185) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix ubsan error [#20204](https://github.com/ClickHouse/ClickHouse/pull/20204) ([Amos Bird](https://github.com/amosbird)).
* Suppress signed overflow in AggregateFunctionGroupArrayMoving [#20206](https://github.com/ClickHouse/ClickHouse/pull/20206) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove dead code [#20212](https://github.com/ClickHouse/ClickHouse/pull/20212) ([nvartolomei](https://github.com/nvartolomei)).
* Handle syntax error for ARRAY JOIN with no args [#20223](https://github.com/ClickHouse/ClickHouse/pull/20223) ([Vladimir C](https://github.com/vdimir)).
* Fix benign race in system.parts [#20226](https://github.com/ClickHouse/ClickHouse/pull/20226) ([alesapin](https://github.com/alesapin)).
* Add final to some classes [#20228](https://github.com/ClickHouse/ClickHouse/pull/20228) ([alesapin](https://github.com/alesapin)).
* refine code in MergeTreeData::loadDataParts to avoid parsing WAL file as data part [#20231](https://github.com/ClickHouse/ClickHouse/pull/20231) ([Fuwang Hu](https://github.com/fuwhu)).
* fix a problem in ArithmeticOperationsInAgrFuncOptimize [#20246](https://github.com/ClickHouse/ClickHouse/pull/20246) ([flynn](https://github.com/ucasfl)).
* Add retries to test_access_control_on_cluster [#20247](https://github.com/ClickHouse/ClickHouse/pull/20247) ([Ilya Yatsishin](https://github.com/qoega)).
* Stable sort for test cases in test_dictionaries_all_layouts_separate_sources [#20248](https://github.com/ClickHouse/ClickHouse/pull/20248) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix not closed ports in DelayedPortsProcessor [#20251](https://github.com/ClickHouse/ClickHouse/pull/20251) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* print changed settings in fuzzer when the server dies [#20281](https://github.com/ClickHouse/ClickHouse/pull/20281) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Put windows in such an order that we can sort less [#20284](https://github.com/ClickHouse/ClickHouse/pull/20284) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Aggregate function deltaSum use restrict keyword [#20287](https://github.com/ClickHouse/ClickHouse/pull/20287) ([Maksim Kita](https://github.com/kitaisreal)).
* make window functions faster [#20293](https://github.com/ClickHouse/ClickHouse/pull/20293) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Accept arbitrary numeric types for numbers() arguments (for scientific notation) [#20301](https://github.com/ClickHouse/ClickHouse/pull/20301) ([Azat Khuzhin](https://github.com/azat)).
* Fix 00738_lock_for_inner_table flakiness [#20305](https://github.com/ClickHouse/ClickHouse/pull/20305) ([Azat Khuzhin](https://github.com/azat)).
* Filter push down [#20341](https://github.com/ClickHouse/ClickHouse/pull/20341) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Common types template instantiations [#20348](https://github.com/ClickHouse/ClickHouse/pull/20348) ([Maksim Kita](https://github.com/kitaisreal)).
* Add test for sign column drop [#20398](https://github.com/ClickHouse/ClickHouse/pull/20398) ([alesapin](https://github.com/alesapin)).
* Merging [#19204](https://github.com/ClickHouse/ClickHouse/issues/19204) [#20399](https://github.com/ClickHouse/ClickHouse/pull/20399) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix 01700_system_zookeeper_path_in [#20449](https://github.com/ClickHouse/ClickHouse/pull/20449) ([alesapin](https://github.com/alesapin)).
* Print stack trace on SIGTRAP [#20453](https://github.com/ClickHouse/ClickHouse/pull/20453) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in arrayDifference [#20458](https://github.com/ClickHouse/ClickHouse/pull/20458) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Suppress UBSan report in Decimal comparison [#20459](https://github.com/ClickHouse/ClickHouse/pull/20459) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve backtrace catching on server failures in CI for stress tests [#20462](https://github.com/ClickHouse/ClickHouse/pull/20462) ([Azat Khuzhin](https://github.com/azat)).
* Fix abnormal server terminations due to write failures [#20465](https://github.com/ClickHouse/ClickHouse/pull/20465) ([Azat Khuzhin](https://github.com/azat)).
* Improve logging during reading from MergeTree [#20466](https://github.com/ClickHouse/ClickHouse/pull/20466) ([Azat Khuzhin](https://github.com/azat)).
* Fix UBSan report in intDiv [#20475](https://github.com/ClickHouse/ClickHouse/pull/20475) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* (unrealistic case, never possible in prod) HashTable fix potential bug during resize with nonstandard grower [#20489](https://github.com/ClickHouse/ClickHouse/pull/20489) ([Maksim Kita](https://github.com/kitaisreal)).
* Add a test for [#8654](https://github.com/ClickHouse/ClickHouse/issues/8654) [#20492](https://github.com/ClickHouse/ClickHouse/pull/20492) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#10893](https://github.com/ClickHouse/ClickHouse/issues/10893) [#20493](https://github.com/ClickHouse/ClickHouse/pull/20493) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Disable testkeeper snapshots for tests [#20496](https://github.com/ClickHouse/ClickHouse/pull/20496) ([alesapin](https://github.com/alesapin)).
* Fix non-zero session reconnect in integration test [#20501](https://github.com/ClickHouse/ClickHouse/pull/20501) ([alesapin](https://github.com/alesapin)).
* Reduce test scale [#20511](https://github.com/ClickHouse/ClickHouse/pull/20511) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Quick build fix [#20513](https://github.com/ClickHouse/ClickHouse/pull/20513) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Replace null fields in tuple during parsing with default values [#20541](https://github.com/ClickHouse/ClickHouse/pull/20541) ([Maksim Kita](https://github.com/kitaisreal)).
* rabbitmq: add missing format factory settings [#20545](https://github.com/ClickHouse/ClickHouse/pull/20545) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Persistent coordination log storage [#20585](https://github.com/ClickHouse/ClickHouse/pull/20585) ([alesapin](https://github.com/alesapin)).
* Add hung check to stress test [#20588](https://github.com/ClickHouse/ClickHouse/pull/20588) ([Alexander Tokmakov](https://github.com/tavplubix)).
* ignore data store files [#20598](https://github.com/ClickHouse/ClickHouse/pull/20598) ([tison](https://github.com/tisonkun)).
* Dictionary create source with functions crash fix [#20623](https://github.com/ClickHouse/ClickHouse/pull/20623) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix fasttest retry for failed tests [#20627](https://github.com/ClickHouse/ClickHouse/pull/20627) ([alesapin](https://github.com/alesapin)).
* Don't backport base commit of branch in the same branch [#20628](https://github.com/ClickHouse/ClickHouse/pull/20628) ([Ivan](https://github.com/abyss7)).
* Add test for already fixed odbc Postgres date type conversion [#20712](https://github.com/ClickHouse/ClickHouse/pull/20712) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Improve backtrace catching on server failures in CI for fast-tests [#20864](https://github.com/ClickHouse/ClickHouse/pull/20864) ([Azat Khuzhin](https://github.com/azat)).
* Better postgres db engine numeric conversion  [#20874](https://github.com/ClickHouse/ClickHouse/pull/20874) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix undefined-behavior in ReservoirSamplerDeterministic.h [#20879](https://github.com/ClickHouse/ClickHouse/pull/20879) ([Vitaly Baranov](https://github.com/vitlibar)).
* ccache 4.2+ does not requires any quirks for SOURCE_DATE_EPOCH [#20883](https://github.com/ClickHouse/ClickHouse/pull/20883) ([Azat Khuzhin](https://github.com/azat)).
* Check for EINTR in epoll_wait [#20958](https://github.com/ClickHouse/ClickHouse/pull/20958) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix push to dockerhub [#20960](https://github.com/ClickHouse/ClickHouse/pull/20960) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Better tests for protobuf format. [#20968](https://github.com/ClickHouse/ClickHouse/pull/20968) ([Vitaly Baranov](https://github.com/vitlibar)).
* Function sumMap decimal fix [#20970](https://github.com/ClickHouse/ClickHouse/pull/20970) ([Maksim Kita](https://github.com/kitaisreal)).
* test for decimal ( p , s) in dictionaries [#20980](https://github.com/ClickHouse/ClickHouse/pull/20980) ([Denny Crane](https://github.com/den-crane)).
* Fix uncaught exception when HTTP client goes away [#20981](https://github.com/ClickHouse/ClickHouse/pull/20981) ([Azat Khuzhin](https://github.com/azat)).
* Increase buffer for uncaught exception / std::terminate [#20989](https://github.com/ClickHouse/ClickHouse/pull/20989) ([Azat Khuzhin](https://github.com/azat)).
* Constraints complex types support [#20990](https://github.com/ClickHouse/ClickHouse/pull/20990) ([Maksim Kita](https://github.com/kitaisreal)).
* Suppress signed overflow in AggregateFunctionGroupArrayMoving 2 [#20995](https://github.com/ClickHouse/ClickHouse/pull/20995) ([Amos Bird](https://github.com/amosbird)).
* Add log message when stacktrace cannot be obtained for thread [#20996](https://github.com/ClickHouse/ClickHouse/pull/20996) ([Azat Khuzhin](https://github.com/azat)).
* Preserve mysql logs in test_materialize_mysql_database [#21016](https://github.com/ClickHouse/ClickHouse/pull/21016) ([Azat Khuzhin](https://github.com/azat)).
* Minor changes in Decimal [#21017](https://github.com/ClickHouse/ClickHouse/pull/21017) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* yamllint style check [#21019](https://github.com/ClickHouse/ClickHouse/pull/21019) ([Azat Khuzhin](https://github.com/azat)).
* Fix buffer size for trace collection [#21020](https://github.com/ClickHouse/ClickHouse/pull/21020) ([Azat Khuzhin](https://github.com/azat)).
* Try fix MaterializeMySQL integration test [#21021](https://github.com/ClickHouse/ClickHouse/pull/21021) ([Winter Zhang](https://github.com/zhang2014)).
* Fix performance tests (by avoid sharing status file for right and left server) [#21022](https://github.com/ClickHouse/ClickHouse/pull/21022) ([Azat Khuzhin](https://github.com/azat)).
* Revert "optimize aggfunc column data copy ([#19407](https://github.com/ClickHouse/ClickHouse/issues/19407))" [#21024](https://github.com/ClickHouse/ClickHouse/pull/21024) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in Decimal arithmetic [#21025](https://github.com/ClickHouse/ClickHouse/pull/21025) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update lowcardinality.md [#21033](https://github.com/ClickHouse/ClickHouse/pull/21033) ([Michael Monashev](https://github.com/MichaelMonashev)).
* Fix DateTime64 from Float [#21050](https://github.com/ClickHouse/ClickHouse/pull/21050) ([Azat Khuzhin](https://github.com/azat)).
* Add test for [#19376](https://github.com/ClickHouse/ClickHouse/issues/19376) [#21051](https://github.com/ClickHouse/ClickHouse/pull/21051) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Merging [#20620](https://github.com/ClickHouse/ClickHouse/issues/20620) [#21052](https://github.com/ClickHouse/ClickHouse/pull/21052) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#9781](https://github.com/ClickHouse/ClickHouse/issues/9781) [#21074](https://github.com/ClickHouse/ClickHouse/pull/21074) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix various issues in DDLWorker (SIGSEGV and others) [#21079](https://github.com/ClickHouse/ClickHouse/pull/21079) ([Azat Khuzhin](https://github.com/azat)).
* Documentation low cardinality fix [#21086](https://github.com/ClickHouse/ClickHouse/pull/21086) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix __has_feature macros under gcc [#21088](https://github.com/ClickHouse/ClickHouse/pull/21088) ([Azat Khuzhin](https://github.com/azat)).
* test for window functions [#21094](https://github.com/ClickHouse/ClickHouse/pull/21094) ([Denny Crane](https://github.com/den-crane)).
* Fix replace[All] functions so that they don't generate garbage to stderr [#21098](https://github.com/ClickHouse/ClickHouse/pull/21098) ([Amos Bird](https://github.com/amosbird)).
* Better tests for protobuf format #2. [#21148](https://github.com/ClickHouse/ClickHouse/pull/21148) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix ccache 4.2+ usage (RULE_LAUNCH_COMPILE/RULE_LAUNCH_LINK was not set) [#21158](https://github.com/ClickHouse/ClickHouse/pull/21158) ([Azat Khuzhin](https://github.com/azat)).
* Bump zookeeper version to 3.6.2 in tests [#21171](https://github.com/ClickHouse/ClickHouse/pull/21171) ([Azat Khuzhin](https://github.com/azat)).
* StorageRabbitMQ added UVLoop [#21193](https://github.com/ClickHouse/ClickHouse/pull/21193) ([Maksim Kita](https://github.com/kitaisreal)).
* Trying to make nukeeper better in single server mode [#21207](https://github.com/ClickHouse/ClickHouse/pull/21207) ([alesapin](https://github.com/alesapin)).
* A followup correction to [#19998](https://github.com/ClickHouse/ClickHouse/issues/19998) [#21221](https://github.com/ClickHouse/ClickHouse/pull/21221) ([Alexander Kazakov](https://github.com/Akazz)).
* Add tests for zstd and zlib http compression [#21279](https://github.com/ClickHouse/ClickHouse/pull/21279) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CheckConstraintsBlockOutputStream optimize nullable column case [#21285](https://github.com/ClickHouse/ClickHouse/pull/21285) ([Maksim Kita](https://github.com/kitaisreal)).
* Rewrite extractTextFromHTML function [#21292](https://github.com/ClickHouse/ClickHouse/pull/21292) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix abnormal server termination for nested writers [#21305](https://github.com/ClickHouse/ClickHouse/pull/21305) ([Azat Khuzhin](https://github.com/azat)).
* [RFC] Remove unused writers [#21306](https://github.com/ClickHouse/ClickHouse/pull/21306) ([Azat Khuzhin](https://github.com/azat)).
* remove unused code in MergeTreeWriteAheadLog::restore [#21308](https://github.com/ClickHouse/ClickHouse/pull/21308) ([Fuwang Hu](https://github.com/fuwhu)).
* IColunm::hasEqualValues() [#21327](https://github.com/ClickHouse/ClickHouse/pull/21327) ([Amos Bird](https://github.com/amosbird)).
* AggregateFunctionSumMap better comment message [#21353](https://github.com/ClickHouse/ClickHouse/pull/21353) ([Maksim Kita](https://github.com/kitaisreal)).
* clickhouse stop: wait for the server to be killed (process exited) [#21365](https://github.com/ClickHouse/ClickHouse/pull/21365) ([Azat Khuzhin](https://github.com/azat)).
* [ClickHouse][LOG]correct shutdown timeout log [#21366](https://github.com/ClickHouse/ClickHouse/pull/21366) ([jasong](https://github.com/songenjie)).
* fix a rare false negative in perf tests [#21381](https://github.com/ClickHouse/ClickHouse/pull/21381) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* test for issue[#21369](https://github.com/ClickHouse/ClickHouse/issues/21369) [#21387](https://github.com/ClickHouse/ClickHouse/pull/21387) ([Denny Crane](https://github.com/den-crane)).
* Add a test for [#14740](https://github.com/ClickHouse/ClickHouse/issues/14740) [#21392](https://github.com/ClickHouse/ClickHouse/pull/21392) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#15469](https://github.com/ClickHouse/ClickHouse/issues/15469) [#21393](https://github.com/ClickHouse/ClickHouse/pull/21393) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix typo in setting name [#21418](https://github.com/ClickHouse/ClickHouse/pull/21418) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix flaky tests with distributed queries [#21432](https://github.com/ClickHouse/ClickHouse/pull/21432) ([Azat Khuzhin](https://github.com/azat)).
* Fix ParsingException::displayText() [#21433](https://github.com/ClickHouse/ClickHouse/pull/21433) ([Azat Khuzhin](https://github.com/azat)).
* Use path as default prefix for coordination logs [#21439](https://github.com/ClickHouse/ClickHouse/pull/21439) ([alesapin](https://github.com/alesapin)).
* Try fix perftests. [#21447](https://github.com/ClickHouse/ClickHouse/pull/21447) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* avoid race in librdkafka [#21452](https://github.com/ClickHouse/ClickHouse/pull/21452) ([filimonov](https://github.com/filimonov)).
* test for [#21413](https://github.com/ClickHouse/ClickHouse/issues/21413) [#21455](https://github.com/ClickHouse/ClickHouse/pull/21455) ([Denny Crane](https://github.com/den-crane)).
* Tiny fix [#21458](https://github.com/ClickHouse/ClickHouse/pull/21458) ([Amos Bird](https://github.com/amosbird)).
* Just another fix for DDLWorker [#21461](https://github.com/ClickHouse/ClickHouse/pull/21461) ([Alexander Tokmakov](https://github.com/tavplubix)).
