---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.2.1.5869-prestable FIXME as compared to v21.1.1.5646-prestable

#### Backward Incompatible Change
* - Fix memory tracking for `OPTIMIZE TABLE`/merges - Account query memory limits and sampling for `OPTIMIZE TABLE`/merges. [#18772](https://github.com/ClickHouse/ClickHouse/pull/18772) ([Azat Khuzhin](https://github.com/azat)).
* Forbid `lcm`/`gcd` for floats. [#19532](https://github.com/ClickHouse/ClickHouse/pull/19532) ([Azat Khuzhin](https://github.com/azat)).
* Bitwise functions (`bitAnd`, `bitOr`, etc) are forbidden for floating point arguments. Now you have to do explicit cast to integer. [#19853](https://github.com/ClickHouse/ClickHouse/pull/19853) ([Azat Khuzhin](https://github.com/azat)).

#### New Feature
* add support for zstd long option for better compression of string columns to save space. [#17184](https://github.com/ClickHouse/ClickHouse/pull/17184) ([ygrek](https://github.com/ygrek)).
* - Added support of mapping LDAP group names, and attribute values in general, to local roles for users from ldap user directories. [#17211](https://github.com/ClickHouse/ClickHouse/pull/17211) ([Denis Glazachev](https://github.com/traceon)).
* Data type `Nested` now supports arbitrary levels of nesting. Introduced subcolumns of complex types, such as `size0` in `Array`, `null` in `Nullable`, names of `Tuple` elements, which can be read without reading of whole column. [#17310](https://github.com/ClickHouse/ClickHouse/pull/17310) ([Anton Popov](https://github.com/CurtizJ)).
* Add support of tuple argument to `argMin` and `argMax` functions. [#17359](https://github.com/ClickHouse/ClickHouse/pull/17359) ([Ildus Kurbangaliev](https://github.com/ildus)).
* Added `Nullable` support for `FlatDictionary`, `HashedDictionary`, `ComplexKeyHashedDictionary`, `DirectDictionary`, `ComplexKeyDirectDictionary`, `RangeHashedDictionary`. [#18236](https://github.com/ClickHouse/ClickHouse/pull/18236) ([Maksim Kita](https://github.com/kitaisreal)).
* Disallow floating point column as partition key related to : [#18421](https://github.com/ClickHouse/ClickHouse/issues/18421)#event-4147046255. [#18464](https://github.com/ClickHouse/ClickHouse/pull/18464) ([hexiaoting](https://github.com/hexiaoting)).
* Add function decodeXMLComponent to decode characters for XML. ``` SELECT decodeXMLComponent('Hello,&quot;world&quot;!'); ``` [#17659](https://github.com/ClickHouse/ClickHouse/issues/17659). [#18542](https://github.com/ClickHouse/ClickHouse/pull/18542) ([nauta](https://github.com/nautaa)).
* Added PostgreSQL table engine (both select/insert, with support for multidimensional arrays), also as table function. Added PostgreSQL dictionary source. Added PostgreSQL database engine. [#18554](https://github.com/ClickHouse/ClickHouse/pull/18554) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `SELECT ALL` syntax. closes [#18706](https://github.com/ClickHouse/ClickHouse/issues/18706). [#18723](https://github.com/ClickHouse/ClickHouse/pull/18723) ([flynn](https://github.com/ucasfl)).
* Add three functions for map data type: 1. mapContains(map, key) to check weather map.keys include the second parameter key. 2. mapKeys(map) return all the keys in Array format 3. mapValues(map) return all the values in Array format. [#18788](https://github.com/ClickHouse/ClickHouse/pull/18788) ([hexiaoting](https://github.com/hexiaoting)).
* Support MetaKey+Enter hotkey binding in play ui. [#19012](https://github.com/ClickHouse/ClickHouse/pull/19012) ([sundyli](https://github.com/sundy-li)).
* Function formatDateTime support the %Q modification to format date to quarter. ... [#19224](https://github.com/ClickHouse/ClickHouse/pull/19224) ([Jianmei Zhang](https://github.com/zhangjmruc)).
* ... [#19261](https://github.com/ClickHouse/ClickHouse/pull/19261) ([RegulusZ](https://github.com/RegulusZ)).
* Add factories' objects names, created during query, into system.query_log. Closes [#18495](https://github.com/ClickHouse/ClickHouse/issues/18495). [#19371](https://github.com/ClickHouse/ClickHouse/pull/19371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `sign` math function. [#19527](https://github.com/ClickHouse/ClickHouse/pull/19527) ([flynn](https://github.com/ucasfl)).
* Added functions `parseDateTimeBestEffortUSOrZero`, `parseDateTimeBestEffortUSOrNull`. [#19712](https://github.com/ClickHouse/ClickHouse/pull/19712) ([Maksim Kita](https://github.com/kitaisreal)).
* ... [#19764](https://github.com/ClickHouse/ClickHouse/pull/19764) ([emhlbmc](https://github.com/emhlbmc)).

#### Performance Improvement
* Use a connection pool for S3 connections, controlled by the `s3_max_connections` settings. [#13405](https://github.com/ClickHouse/ClickHouse/pull/13405) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Rewrite `sumIf()` and `sum(if())` function to `countIf()` function when logically equivalent. [#17041](https://github.com/ClickHouse/ClickHouse/pull/17041) ([flynn](https://github.com/ucasfl)).
* Update libcxx and use unstable ABI to provide better performance. [#18914](https://github.com/ClickHouse/ClickHouse/pull/18914) ([Daniel Kutenin](https://github.com/danlark1)).
* Faster parts removal by lowering the number of `stat` syscalls. This returns the optimization that existed while ago. More safe interface of `IDisk`. This closes [#19065](https://github.com/ClickHouse/ClickHouse/issues/19065). [#19086](https://github.com/ClickHouse/ClickHouse/pull/19086) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Speed up aggregate function `sum`. Improvement only visible on synthetic benchmarks and not very practical. [#19216](https://github.com/ClickHouse/ClickHouse/pull/19216) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support splitting `Filter` step of query plan into `Expression + Filter` pair. Together with `Expression + Expression` merging optimization ([#17458](https://github.com/ClickHouse/ClickHouse/issues/17458)) it may delay execution for some expressions after `Filter` step. [#19253](https://github.com/ClickHouse/ClickHouse/pull/19253) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Reduce lock contention for multiple layers of the Buffer engine. [#19379](https://github.com/ClickHouse/ClickHouse/pull/19379) ([Azat Khuzhin](https://github.com/azat)).
* Slightly improve server latency by removing access to configuration on every connection. [#19863](https://github.com/ClickHouse/ClickHouse/pull/19863) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Added support for `WITH ... [AND] [PERIODIC] REFRESH [interval_in_sec]` clause when creating `LIVE VIEW` tables. [#14822](https://github.com/ClickHouse/ClickHouse/pull/14822) ([vzakaznikov](https://github.com/vzakaznikov)).
* - Add optimize_alias_column_prediction (on by default), that will: * Respect aliased columns in WHERE during partition pruning and skipping data using secondary indexes * Respect aliased columns in WHERE for trivial count queries for optimize_trivial_count * Respect aliased columns in GROUP BY/ORDER BY for optimize_aggregation_in_order/optimize_read_in_order. [#16995](https://github.com/ClickHouse/ClickHouse/pull/16995) ([sundyli](https://github.com/sundy-li)).
* Updated AWS C++ SDK in order to utilize global regions in S3. [#17870](https://github.com/ClickHouse/ClickHouse/pull/17870) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Support insert into table function `cluster`, and for both table functions `remote` and `cluster`, support distributing data across nodes by specify sharding key. Close [#16752](https://github.com/ClickHouse/ClickHouse/issues/16752). [#18264](https://github.com/ClickHouse/ClickHouse/pull/18264) ([flynn](https://github.com/ucasfl)).
* Support `EXISTS VIEW` syntax. [#18552](https://github.com/ClickHouse/ClickHouse/pull/18552) ([Du Chuan](https://github.com/spongedu)).
* Update librdkafka to v1.6.0-RC2. Fixes [#18668](https://github.com/ClickHouse/ClickHouse/issues/18668). [#18671](https://github.com/ClickHouse/ClickHouse/pull/18671) ([filimonov](https://github.com/filimonov)).
* Allow CTE to be further aliased. Propagate CSE to subqueries in the same level when `enable_global_with_statement = 1`. This fixes [#17378](https://github.com/ClickHouse/ClickHouse/issues/17378) . This fixes https://github.com/ClickHouse/ClickHouse/pull/16575#issuecomment-753416235 . [#18684](https://github.com/ClickHouse/ClickHouse/pull/18684) ([Amos Bird](https://github.com/amosbird)).
* Add [UInt8, UInt16, UInt32, UInt64] arguments types support for bitmapTransform, bitmapSubsetInRange, bitmapSubsetLimit, bitmapContains functions. This closes [#18713](https://github.com/ClickHouse/ClickHouse/issues/18713). [#18791](https://github.com/ClickHouse/ClickHouse/pull/18791) ([sundyli](https://github.com/sundy-li)).
* Added prefix-based S3 endpoint settings. [#18812](https://github.com/ClickHouse/ClickHouse/pull/18812) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix issues with RIGHT and FULL JOIN of tables with aggregate function states. In previous versions exception about `cloneResized` method was thrown. [#18818](https://github.com/ClickHouse/ClickHouse/pull/18818) ([templarzq](https://github.com/templarzq)).
* - Check per-block checksum of the distributed batch on the sender before sending (without reading the file twice, the checksums will be verified while reading), this will avoid stuck of the INSERT on the receiver (on truncated .bin file on the sender) - Avoid reading .bin files twice for batched INSERT (it was required to calculate rows/bytes to take squashing into account, now this information included into the header, backward compatible is preserved). [#18853](https://github.com/ClickHouse/ClickHouse/pull/18853) ([Azat Khuzhin](https://github.com/azat)).
* Add `normalizeQueryKeepNames` and `normalizedQueryHashKeepNames` to normalize queries without masking long names with `?`. This helps better analyze complex query logs. [#18910](https://github.com/ClickHouse/ClickHouse/pull/18910) ([Amos Bird](https://github.com/amosbird)).
* Docker image: several improvements for clickhouse-server entrypoint. [#18954](https://github.com/ClickHouse/ClickHouse/pull/18954) ([filimonov](https://github.com/filimonov)).
* Fixed `PeekableReadBuffer: Memory limit exceed` error when inserting data with huge strings. Fixes [#18690](https://github.com/ClickHouse/ClickHouse/issues/18690). [#18979](https://github.com/ClickHouse/ClickHouse/pull/18979) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Explicitly set uid / gid of clickhouse user & group to the fixed values (101) in clickhouse-server images. [#19096](https://github.com/ClickHouse/ClickHouse/pull/19096) ([filimonov](https://github.com/filimonov)).
* The exception when function `bar` is called with certain NaN argument may be slightly misleading in previous versions. This fixes [#19088](https://github.com/ClickHouse/ClickHouse/issues/19088). [#19107](https://github.com/ClickHouse/ClickHouse/pull/19107) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow change `max_server_memory_usage` without restart. This closes [#18154](https://github.com/ClickHouse/ClickHouse/issues/18154). [#19186](https://github.com/ClickHouse/ClickHouse/pull/19186) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix wrong alignment of values of `IPv4` data type in Pretty formats. They were aligned to the right, not to the left. This closes [#19184](https://github.com/ClickHouse/ClickHouse/issues/19184). [#19339](https://github.com/ClickHouse/ClickHouse/pull/19339) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow docker to be executed with arbitrary uid. [#19374](https://github.com/ClickHouse/ClickHouse/pull/19374) ([filimonov](https://github.com/filimonov)).
* Add metrics for MergeTree parts (Wide/Compact/InMemory) types. [#19381](https://github.com/ClickHouse/ClickHouse/pull/19381) ([Azat Khuzhin](https://github.com/azat)).
* Improve MySQL compatibility. [#19387](https://github.com/ClickHouse/ClickHouse/pull/19387) ([Daniil Kondratyev](https://github.com/dankondr)).
* Add `http_referer` field to `system.query_log`, `system.processes`, etc. This closes [#19389](https://github.com/ClickHouse/ClickHouse/issues/19389). [#19390](https://github.com/ClickHouse/ClickHouse/pull/19390) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `toIPv6` function parses `IPv4` addresses. [#19518](https://github.com/ClickHouse/ClickHouse/pull/19518) ([Bharat Nallan](https://github.com/bharatnc)).
* Support using the new location of `.debug` file. This fixes [#19348](https://github.com/ClickHouse/ClickHouse/issues/19348). [#19520](https://github.com/ClickHouse/ClickHouse/pull/19520) ([Amos Bird](https://github.com/amosbird)).
* Enable function length/empty/notEmpty for datatype map, which returns keys number in map. [#19530](https://github.com/ClickHouse/ClickHouse/pull/19530) ([李扬](https://github.com/taiyang-li)).
* Support constant result in function `multiIf`. [#19533](https://github.com/ClickHouse/ClickHouse/pull/19533) ([Maksim Kita](https://github.com/kitaisreal)).
* Add an option to disable validation of checksums on reading. Should never be used in production. Please do not expect any benefits in disabling it. It may only be used for experiments and benchmarks. The setting only applicable for tables of MergeTree family. Checksums are always validated for other table engines and when receiving data over network. In my observations there is no performance difference or it is less than 0.5%. [#19588](https://github.com/ClickHouse/ClickHouse/pull/19588) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dictionary better error message during attribute parsing. [#19678](https://github.com/ClickHouse/ClickHouse/pull/19678) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix rare `max_number_of_merges_with_ttl_in_pool` limit overrun (more merges with TTL can be assigned) for non-replicated MergeTree. [#19708](https://github.com/ClickHouse/ClickHouse/pull/19708) ([alesapin](https://github.com/alesapin)).
* Insuffiient arguments check in `positionCaseInsensitiveUTF8` function triggered address sanitizer. [#19720](https://github.com/ClickHouse/ClickHouse/pull/19720) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add separate pool for message brokers (RabbitMQ and Kafka). [#19722](https://github.com/ClickHouse/ClickHouse/pull/19722) ([Azat Khuzhin](https://github.com/azat)).
* In distributed queries if the setting `async_socket_for_remote` is enabled, it was possible to get stack overflow at least in debug build configuration if very deeply nested data type is used in table (e.g. `Array(Array(Array(...more...)))`). This fixes [#19108](https://github.com/ClickHouse/ClickHouse/issues/19108). This change introduces minor backward incompatibility: excessive parenthesis in type definitions no longer supported, example: `Array((UInt8))`. [#19736](https://github.com/ClickHouse/ClickHouse/pull/19736) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Table function `S3` will use global region if the region can't be determined exactly. This closes [#10998](https://github.com/ClickHouse/ClickHouse/issues/10998). [#19750](https://github.com/ClickHouse/ClickHouse/pull/19750) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Clickhouse client query param CTE added test. [#19762](https://github.com/ClickHouse/ClickHouse/pull/19762) ([Maksim Kita](https://github.com/kitaisreal)).
* Correctly output infinite arguments for `formatReadableTimeDelta` function. In previous versions, there was implicit conversion to implementation specific integer value. [#19791](https://github.com/ClickHouse/ClickHouse/pull/19791) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `S3` table function now supports `auto` compression mode (autodetect). This closes [#18754](https://github.com/ClickHouse/ClickHouse/issues/18754). [#19793](https://github.com/ClickHouse/ClickHouse/pull/19793) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Set charset to utf8mb4 when interacting with remote MySQL servers. Fixes [#19795](https://github.com/ClickHouse/ClickHouse/issues/19795). [#19800](https://github.com/ClickHouse/ClickHouse/pull/19800) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add `--reconnect` option to `clickhouse-benchmark`. When this option is specified, it will reconnect before every request. This is needed for testing. [#19872](https://github.com/ClickHouse/ClickHouse/pull/19872) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Bug Fix
* fix data type convert issue for mysql engine ... [#18124](https://github.com/ClickHouse/ClickHouse/pull/18124) ([bo zeng](https://github.com/mis98zb)).
* `SELECT count() FROM table` now can be executed if only one any column can be selected from the `table`. This PR fixes [#10639](https://github.com/ClickHouse/ClickHouse/issues/10639). [#18233](https://github.com/ClickHouse/ClickHouse/pull/18233) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix index analysis of binary functions with constant argument which leads to wrong query results. This fixes [#18364](https://github.com/ClickHouse/ClickHouse/issues/18364). [#18373](https://github.com/ClickHouse/ClickHouse/pull/18373) ([Amos Bird](https://github.com/amosbird)).
* Disable constant folding for subqueries on the analysis stage, when the result cannot be calculated. [#18446](https://github.com/ClickHouse/ClickHouse/pull/18446) ([Azat Khuzhin](https://github.com/azat)).
* Attach partition should reset the mutation. [#18804](https://github.com/ClickHouse/ClickHouse/issues/18804). [#18935](https://github.com/ClickHouse/ClickHouse/pull/18935) ([fastio](https://github.com/fastio)).
* Fix bug when mutation with some escaped text (like `ALTER ... UPDATE e = CAST('foo', 'Enum8(\'foo\' = 1')` serialized incorrectly. Fixes [#18878](https://github.com/ClickHouse/ClickHouse/issues/18878). [#18944](https://github.com/ClickHouse/ClickHouse/pull/18944) ([alesapin](https://github.com/alesapin)).
* Fix error `Task was not found in task queue` (possible only for remote queries, with `async_socket_for_remote = 1`). [#18964](https://github.com/ClickHouse/ClickHouse/pull/18964) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* to fix [#18894](https://github.com/ClickHouse/ClickHouse/issues/18894) Add a check to avoid exception when long column alias('table.column' style, usually auto-generated by BI tools like Looker) equals to long table name. [#18968](https://github.com/ClickHouse/ClickHouse/pull/18968) ([Daniel Qin](https://github.com/mathfool)).
* Fix incorrect behavior when `ALTER TABLE ... DROP PART 'part_name'` query removes all deduplication blocks for the whole partition. Fixes [#18874](https://github.com/ClickHouse/ClickHouse/issues/18874). [#18969](https://github.com/ClickHouse/ClickHouse/pull/18969) ([alesapin](https://github.com/alesapin)).
* Fixed rare crashes when server run out of memory. [#18976](https://github.com/ClickHouse/ClickHouse/pull/18976) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed very rare deadlock at shutdown. [#18977](https://github.com/ClickHouse/ClickHouse/pull/18977) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix possible exception `QueryPipeline stream: different number of columns` caused by merging of query plan's `Expression` steps. Fixes [#18190](https://github.com/ClickHouse/ClickHouse/issues/18190). [#18980](https://github.com/ClickHouse/ClickHouse/pull/18980) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Disable `optimize_move_functions_out_of_any` because optimization is not always correct. This closes [#18051](https://github.com/ClickHouse/ClickHouse/issues/18051). This closes [#18973](https://github.com/ClickHouse/ClickHouse/issues/18973). [#18981](https://github.com/ClickHouse/ClickHouse/pull/18981) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Join tries to materialize const columns, but our code waits for them in other places. [#18982](https://github.com/ClickHouse/ClickHouse/pull/18982) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix inserting of `LowCardinality` column to table with `TinyLog` engine. Fixes [#18629](https://github.com/ClickHouse/ClickHouse/issues/18629). [#19010](https://github.com/ClickHouse/ClickHouse/pull/19010) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible error `Expected single dictionary argument for function` if use function `ignore` with `LowCardinality` argument. Fixes [#14275](https://github.com/ClickHouse/ClickHouse/issues/14275). [#19016](https://github.com/ClickHouse/ClickHouse/pull/19016) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Make sure `groupUniqArray` returns correct type for argument of Enum type. This closes [#17875](https://github.com/ClickHouse/ClickHouse/issues/17875). [#19019](https://github.com/ClickHouse/ClickHouse/pull/19019) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Restrict `MODIFY TTL` queries for `MergeTree` tables created in old syntax. Previously the query succeeded, but actually it had no effect. [#19064](https://github.com/ClickHouse/ClickHouse/pull/19064) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed `There is no checkpoint` error when inserting data through http interface using `Template` or `CustomSeparated` format. Fixes [#19021](https://github.com/ClickHouse/ClickHouse/issues/19021). [#19072](https://github.com/ClickHouse/ClickHouse/pull/19072) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Simplify the implementation of `tupleHammingDistance`. Support for tuples of any equal length. Fixes [#19029](https://github.com/ClickHouse/ClickHouse/issues/19029). [#19084](https://github.com/ClickHouse/ClickHouse/pull/19084) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix startup bug when clickhouse was not able to read compression codec from `LowCardinality(Nullable(...))` and throws exception `Attempt to read after EOF`. Fixes [#18340](https://github.com/ClickHouse/ClickHouse/issues/18340). [#19101](https://github.com/ClickHouse/ClickHouse/pull/19101) ([alesapin](https://github.com/alesapin)).
* Fix bug in merge tree data writer which can lead to marks with bigger size than fixed granularity size. Fixes [#18913](https://github.com/ClickHouse/ClickHouse/issues/18913). [#19123](https://github.com/ClickHouse/ClickHouse/pull/19123) ([alesapin](https://github.com/alesapin)).
* Fix infinite reading from file in `ORC` format (was introduced in [#10580](https://github.com/ClickHouse/ClickHouse/issues/10580)). Fixes [#19095](https://github.com/ClickHouse/ClickHouse/issues/19095). [#19134](https://github.com/ClickHouse/ClickHouse/pull/19134) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* - Split RemoteQueryExecutorReadContext into module part - Fix leaking of pipe fd for `async_socket_for_remote`. [#19153](https://github.com/ClickHouse/ClickHouse/pull/19153) ([Azat Khuzhin](https://github.com/azat)).
* Fix bug when concurrent `ALTER` and `DROP` queries may hang while processing ReplicatedMergeTree table. [#19237](https://github.com/ClickHouse/ClickHouse/pull/19237) ([alesapin](https://github.com/alesapin)).
* Do not mark file for distributed send as broken on EOF. [#19290](https://github.com/ClickHouse/ClickHouse/pull/19290) ([Azat Khuzhin](https://github.com/azat)).
* Fix error `Cannot convert column now64() because it is constant but values of constants are different in source and result`. Continuation of [#7156](https://github.com/ClickHouse/ClickHouse/issues/7156). [#19316](https://github.com/ClickHouse/ClickHouse/pull/19316) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed possible wrong result or segfault on aggregation when Materialized View and its target table have different structure. Fixes [#18063](https://github.com/ClickHouse/ClickHouse/issues/18063). [#19322](https://github.com/ClickHouse/ClickHouse/pull/19322) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix system.parts _state column (LOGICAL_ERROR when querying this column, due to incorrect order). [#19346](https://github.com/ClickHouse/ClickHouse/pull/19346) ([Azat Khuzhin](https://github.com/azat)).
* Added `cast`, `accurateCast`, `accurateCastOrNull` performance tests. [#19354](https://github.com/ClickHouse/ClickHouse/pull/19354) ([Maksim Kita](https://github.com/kitaisreal)).
* - Fix default value in join types with non-zero default (e.g. some Enums). Closes [#18197](https://github.com/ClickHouse/ClickHouse/issues/18197). [#19360](https://github.com/ClickHouse/ClickHouse/pull/19360) ([Vladimir C](https://github.com/vdimir)).
* Fix possible buffer overflow in Uber H3 library. See https://github.com/uber/h3/issues/392. This closes [#19219](https://github.com/ClickHouse/ClickHouse/issues/19219). [#19383](https://github.com/ClickHouse/ClickHouse/pull/19383) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Uninitialized memory read was possible in encrypt/decrypt functions if empty string was passed as IV. This closes [#19391](https://github.com/ClickHouse/ClickHouse/issues/19391). [#19397](https://github.com/ClickHouse/ClickHouse/pull/19397) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix possible error `Extremes transform was already added to pipeline`. Fixes [#14100](https://github.com/ClickHouse/ClickHouse/issues/14100). [#19430](https://github.com/ClickHouse/ClickHouse/pull/19430) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed very rare bug that might cause mutation to hang after `DROP/DETACH/REPLACE/MOVE PARTITION`. It was partially fixed by [#15537](https://github.com/ClickHouse/ClickHouse/issues/15537) for the most cases. [#19443](https://github.com/ClickHouse/ClickHouse/pull/19443) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Mark distributed batch as broken in case of empty data block in one of files. [#19449](https://github.com/ClickHouse/ClickHouse/pull/19449) ([Azat Khuzhin](https://github.com/azat)).
* Buffer overflow (on memory read) was possible if `addMonth` function was called with specifically crafted arguments. This fixes [#19441](https://github.com/ClickHouse/ClickHouse/issues/19441). This fixes [#19413](https://github.com/ClickHouse/ClickHouse/issues/19413). [#19472](https://github.com/ClickHouse/ClickHouse/pull/19472) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix wrong deserialization of columns description. It makes INSERT into a table with a column named `\` impossible. [#19479](https://github.com/ClickHouse/ClickHouse/pull/19479) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix SIGSEGV with merge_tree_min_rows_for_concurrent_read/merge_tree_min_bytes_for_concurrent_read=0/UINT64_MAX. [#19528](https://github.com/ClickHouse/ClickHouse/pull/19528) ([Azat Khuzhin](https://github.com/azat)).
* Query CREATE DICTIONARY id expression fix. [#19571](https://github.com/ClickHouse/ClickHouse/pull/19571) ([Maksim Kita](https://github.com/kitaisreal)).
* `DROP/DETACH TABLE table ON CLUSTER cluster SYNC` query might hang, it's fixed. Fixes [#19568](https://github.com/ClickHouse/ClickHouse/issues/19568). [#19572](https://github.com/ClickHouse/ClickHouse/pull/19572) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix use-after-free of the CompressedWriteBuffer in Connection after disconnect. [#19599](https://github.com/ClickHouse/ClickHouse/pull/19599) ([Azat Khuzhin](https://github.com/azat)).
* Fix wrong result of function `neighbor` for `LowCardinality` argument. Fixes [#10333](https://github.com/ClickHouse/ClickHouse/issues/10333). [#19617](https://github.com/ClickHouse/ClickHouse/pull/19617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Some functions with big integers may cause segfault. Big integers is experimental feature. This closes [#19667](https://github.com/ClickHouse/ClickHouse/issues/19667). [#19672](https://github.com/ClickHouse/ClickHouse/pull/19672) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix rare bug when some replicated operations (like mutation) cannot process some parts after data corruption. Fixes [#19593](https://github.com/ClickHouse/ClickHouse/issues/19593). [#19702](https://github.com/ClickHouse/ClickHouse/pull/19702) ([alesapin](https://github.com/alesapin)).
* Fix a segmentation fault in `bitmapAndnot` function. Fixes [#19668](https://github.com/ClickHouse/ClickHouse/issues/19668). [#19713](https://github.com/ClickHouse/ClickHouse/pull/19713) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix crash when nested column name was used in `WHERE` or `PREWHERE`. Fixes [#19755](https://github.com/ClickHouse/ClickHouse/issues/19755). [#19763](https://github.com/ClickHouse/ClickHouse/pull/19763) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed stack overflow when using accurate comparison of arithmetic type with string type. [#19773](https://github.com/ClickHouse/ClickHouse/pull/19773) ([Alexander Tokmakov](https://github.com/tavplubix)).
* In previous versions, unusual arguments for function arrayEnumerateUniq may cause crash or infinite loop. This closes [#19787](https://github.com/ClickHouse/ClickHouse/issues/19787). [#19788](https://github.com/ClickHouse/ClickHouse/pull/19788) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The function `greatCircleAngle` returned inaccurate results in previous versions. This closes [#19769](https://github.com/ClickHouse/ClickHouse/issues/19769). [#19789](https://github.com/ClickHouse/ClickHouse/pull/19789) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix filtering by UInt8 greater than 127. [#19799](https://github.com/ClickHouse/ClickHouse/pull/19799) ([Anton Popov](https://github.com/CurtizJ)).
* Fix crash when pushing down predicates to union distinct subquery. This fixes [#19855](https://github.com/ClickHouse/ClickHouse/issues/19855). [#19861](https://github.com/ClickHouse/ClickHouse/pull/19861) ([Amos Bird](https://github.com/amosbird)).
* Fix argMin/argMax crash when combining with -If. This fixes https://clickhouse-test-reports.s3.yandex.net/19800/7b8589dbde5bc621d1bcfd68a713e4684183f593/fuzzer_ubsan/report.html#fail1. [#19868](https://github.com/ClickHouse/ClickHouse/pull/19868) ([Amos Bird](https://github.com/amosbird)).

#### Build/Testing/Packaging Improvement
* Restore Kafka input in FreeBSD builds. [#18924](https://github.com/ClickHouse/ClickHouse/pull/18924) ([Alexandre Snarskii](https://github.com/snar)).
* Add integration tests run with memory sanitizer. [#18974](https://github.com/ClickHouse/ClickHouse/pull/18974) ([alesapin](https://github.com/alesapin)).
* Add SQLancer test docker image to run check in CI. [#19006](https://github.com/ClickHouse/ClickHouse/pull/19006) ([Ilya Yatsishin](https://github.com/qoega)).
* Added tests for defaults in URL and File engine. This closes [#5666](https://github.com/ClickHouse/ClickHouse/issues/5666). [#19015](https://github.com/ClickHouse/ClickHouse/pull/19015) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* - Enabling RBAC tests - Tests for SYSTEM privileges - Requirements name changes. [#19017](https://github.com/ClickHouse/ClickHouse/pull/19017) ([MyroTk](https://github.com/MyroTk)).
* Query Fuzzer will fuzz newly added tests more extensively. This closes [#18916](https://github.com/ClickHouse/ClickHouse/issues/18916). [#19185](https://github.com/ClickHouse/ClickHouse/pull/19185) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow building librdkafka without ssl. [#19337](https://github.com/ClickHouse/ClickHouse/pull/19337) ([filimonov](https://github.com/filimonov)).
* Avoid UBSan reports in `arrayElement` function, `substring` and `arraySum`. Fixes [#19305](https://github.com/ClickHouse/ClickHouse/issues/19305). Fixes [#19287](https://github.com/ClickHouse/ClickHouse/issues/19287). This closes [#19336](https://github.com/ClickHouse/ClickHouse/issues/19336). [#19347](https://github.com/ClickHouse/ClickHouse/pull/19347) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix potential nullptr dereference in table function `VALUES`. [#19357](https://github.com/ClickHouse/ClickHouse/pull/19357) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow building ClickHouse with Kafka support on arm64. [#19369](https://github.com/ClickHouse/ClickHouse/pull/19369) ([filimonov](https://github.com/filimonov)).
* Integrate with [Big List of Naughty Strings](https://github.com/minimaxir/big-list-of-naughty-strings/) for better fuzzing. [#19480](https://github.com/ClickHouse/ClickHouse/pull/19480) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to explicitly enable or disable watchdog via environment variable `CLICKHOUSE_WATCHDOG_ENABLE`. By default it is enabled if server is not attached to terminal. [#19522](https://github.com/ClickHouse/ClickHouse/pull/19522) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Updating TestFlows AES encryption tests to support changes to the encrypt plaintext parameter. [#19674](https://github.com/ClickHouse/ClickHouse/pull/19674) ([vzakaznikov](https://github.com/vzakaznikov)).
* Made generation of macros.xml easier for integration tests. No more excessive logging from dicttoxml. dicttoxml project is not active for 5+ years. [#19697](https://github.com/ClickHouse/ClickHouse/pull/19697) ([Ilya Yatsishin](https://github.com/qoega)).
* Remove --project-directory for docker-compose in integration test. Fix logs formatting from docker container. [#19706](https://github.com/ClickHouse/ClickHouse/pull/19706) ([Ilya Yatsishin](https://github.com/qoega)).
* Fixed MemorySanitizer errors in cyrus-sasl and musl. [#19821](https://github.com/ClickHouse/ClickHouse/pull/19821) ([Ilya Yatsishin](https://github.com/qoega)).
* Add test for throwing an exception on inserting incorrect data in CollapsingMergeTree. [#19851](https://github.com/ClickHouse/ClickHouse/pull/19851) ([Kruglov Pavel](https://github.com/Avogar)).
* Adding retries for docker-compose start, stop and restart in TestFlows tests. [#19852](https://github.com/ClickHouse/ClickHouse/pull/19852) ([vzakaznikov](https://github.com/vzakaznikov)).

#### NO CL ENTRY

* NO CL ENTRY:  'Remove useless codes'. [#19293](https://github.com/ClickHouse/ClickHouse/pull/19293) ([sundyli](https://github.com/sundy-li)).
* NO CL ENTRY:  'Merging [#19387](https://github.com/ClickHouse/ClickHouse/issues/19387)'. [#19683](https://github.com/ClickHouse/ClickHouse/pull/19683) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Add ANTLR tests check [#18624](https://github.com/ClickHouse/ClickHouse/pull/18624) ([Ivan](https://github.com/abyss7)).
* Add more debug info to PollingQueue exception. [#18922](https://github.com/ClickHouse/ClickHouse/pull/18922) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* More checks in merge tree writer wide [#18928](https://github.com/ClickHouse/ClickHouse/pull/18928) ([alesapin](https://github.com/alesapin)).
* Try to remove ActionsDAG::removeColumn [#18953](https://github.com/ClickHouse/ClickHouse/pull/18953) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix rarely flaky test 01459_manual_write_to_replicas_quorum [#18970](https://github.com/ClickHouse/ClickHouse/pull/18970) ([alesapin](https://github.com/alesapin)).
* fix some wrong words in comment [#18998](https://github.com/ClickHouse/ClickHouse/pull/18998) ([flynn](https://github.com/ucasfl)).
* Add tests from [#15889](https://github.com/ClickHouse/ClickHouse/issues/15889) [#19007](https://github.com/ClickHouse/ClickHouse/pull/19007) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix manipulators for common string types [#19011](https://github.com/ClickHouse/ClickHouse/pull/19011) ([alesapin](https://github.com/alesapin)).
* Fix misleading error message while inserting in a table function  [#19013](https://github.com/ClickHouse/ClickHouse/pull/19013) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix duplicate UUIDs of LiveView on server startup [#19020](https://github.com/ClickHouse/ClickHouse/pull/19020) ([Alexander Tokmakov](https://github.com/tavplubix)).
* [wip] WINDOW clause [#19022](https://github.com/ClickHouse/ClickHouse/pull/19022) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Avoid redundant exception while dropping part [#19040](https://github.com/ClickHouse/ClickHouse/pull/19040) ([alesapin](https://github.com/alesapin)).
* More debug for stateless tests writer [#19055](https://github.com/ClickHouse/ClickHouse/pull/19055) ([alesapin](https://github.com/alesapin)).
* Update test containers [#19058](https://github.com/ClickHouse/ClickHouse/pull/19058) ([filimonov](https://github.com/filimonov)).
* Support operations with views in ANTLR parser [#19063](https://github.com/ClickHouse/ClickHouse/pull/19063) ([Anton Popov](https://github.com/CurtizJ)).
* Run more tests in SQLancer [#19077](https://github.com/ClickHouse/ClickHouse/pull/19077) ([Ilya Yatsishin](https://github.com/qoega)).
* Update Cassandra driver library [#19091](https://github.com/ClickHouse/ClickHouse/pull/19091) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add metrics for part number in MergeTree in ClickHouse [#19122](https://github.com/ClickHouse/ClickHouse/pull/19122) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless code [#19136](https://github.com/ClickHouse/ClickHouse/pull/19136) ([Amos Bird](https://github.com/amosbird)).
* [ANTLR] Print errors through LOG_ERROR [#19137](https://github.com/ClickHouse/ClickHouse/pull/19137) ([Ivan](https://github.com/abyss7)).
* MemoryTracker: Do not ignore server memory limits during blocking by default [#19146](https://github.com/ClickHouse/ClickHouse/pull/19146) ([Azat Khuzhin](https://github.com/azat)).
* speed up some perf tests (for other machines) [#19154](https://github.com/ClickHouse/ClickHouse/pull/19154) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Cover distributed send with different headers [#19155](https://github.com/ClickHouse/ClickHouse/pull/19155) ([Azat Khuzhin](https://github.com/azat)).
* Add missing type check in dictHas for COMPLEX_KEY_SSD_CACHE layout [#19164](https://github.com/ClickHouse/ClickHouse/pull/19164) ([Azat Khuzhin](https://github.com/azat)).
* test for [#18839](https://github.com/ClickHouse/ClickHouse/issues/18839) Expand_macros_for_fetchPartition [#19200](https://github.com/ClickHouse/ClickHouse/pull/19200) ([Denny Crane](https://github.com/den-crane)).
* add MySQL Var check [#19205](https://github.com/ClickHouse/ClickHouse/pull/19205) ([TCeason](https://github.com/TCeason)).
* Tiny changes in DistributedBlockOutputStream [#19206](https://github.com/ClickHouse/ClickHouse/pull/19206) ([Azat Khuzhin](https://github.com/azat)).
* curl dependency tiny fixes [#19210](https://github.com/ClickHouse/ClickHouse/pull/19210) ([Azat Khuzhin](https://github.com/azat)).
* Fix MSan error in rocksdb [#19213](https://github.com/ClickHouse/ClickHouse/issues/19213) [#19214](https://github.com/ClickHouse/ClickHouse/pull/19214) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix MSan report in Kerberos library [#19215](https://github.com/ClickHouse/ClickHouse/pull/19215) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update Dragonbox [#19218](https://github.com/ClickHouse/ClickHouse/pull/19218) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make symbolizers available in fuzzer Docker image [#19220](https://github.com/ClickHouse/ClickHouse/pull/19220) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add redundant test for Yandex banner system [#19235](https://github.com/ClickHouse/ClickHouse/pull/19235) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `-- { echo }` hint preserve leading comments [#19236](https://github.com/ClickHouse/ClickHouse/pull/19236) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Disable msan for epoll array in libuv [#19244](https://github.com/ClickHouse/ClickHouse/pull/19244) ([alesapin](https://github.com/alesapin)).
* Remove tsan supression [#19250](https://github.com/ClickHouse/ClickHouse/pull/19250) ([alesapin](https://github.com/alesapin)).
* Consolidate the test hint handling [#19254](https://github.com/ClickHouse/ClickHouse/pull/19254) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Support 'keys' and 'values' subcolumns in type Map [#19273](https://github.com/ClickHouse/ClickHouse/pull/19273) ([Anton Popov](https://github.com/CurtizJ)).
* Split TestKeeperStorage and processing thread [#19284](https://github.com/ClickHouse/ClickHouse/pull/19284) ([alesapin](https://github.com/alesapin)).
* move ctr from private to delete [#19285](https://github.com/ClickHouse/ClickHouse/pull/19285) ([flynn](https://github.com/ucasfl)).
* Avoid mixing output from parallel test runs [#19298](https://github.com/ClickHouse/ClickHouse/pull/19298) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fixed race between copy-constructor and addQueryAccessInfo [#19313](https://github.com/ClickHouse/ClickHouse/pull/19313) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add Sanitizer report issue template [#19318](https://github.com/ClickHouse/ClickHouse/pull/19318) ([Ilya Yatsishin](https://github.com/qoega)).
* fix sleep with infinite input [#19343](https://github.com/ClickHouse/ClickHouse/pull/19343) ([flynn](https://github.com/ucasfl)).
* ISSUES-18684 fix MaterializeMySQL integration test failure [#19344](https://github.com/ClickHouse/ClickHouse/pull/19344) ([Winter Zhang](https://github.com/zhang2014)).
* Fix race condition in TestKeeperHandler on session finish [#19355](https://github.com/ClickHouse/ClickHouse/pull/19355) ([alesapin](https://github.com/alesapin)).
* Fix several cases, while reading subcolumns [#19358](https://github.com/ClickHouse/ClickHouse/pull/19358) ([Anton Popov](https://github.com/CurtizJ)).
* Reconnect after client errors [#19361](https://github.com/ClickHouse/ClickHouse/pull/19361) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* SQLancer binary changed its name [#19363](https://github.com/ClickHouse/ClickHouse/pull/19363) ([Ilya Yatsishin](https://github.com/qoega)).
* Better logging in MySQLHandler [#19365](https://github.com/ClickHouse/ClickHouse/pull/19365) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix IDisk::open parameters to match posix open [#19372](https://github.com/ClickHouse/ClickHouse/pull/19372) ([Alexander Gololobov](https://github.com/davenger)).
* MacOS fixed build issues [#19377](https://github.com/ClickHouse/ClickHouse/pull/19377) ([Maksim Kita](https://github.com/kitaisreal)).
* Add log message with elapsed time while pushing to view [#19378](https://github.com/ClickHouse/ClickHouse/pull/19378) ([Azat Khuzhin](https://github.com/azat)).
* Avoid UBSan report in aggregate function sum [#19385](https://github.com/ClickHouse/ClickHouse/pull/19385) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fail fast in incorrect usage of extractAllGroups [#19393](https://github.com/ClickHouse/ClickHouse/pull/19393) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in quantileExactWeighted [#19394](https://github.com/ClickHouse/ClickHouse/pull/19394) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Limit max memory usage in fuzz testing [#19396](https://github.com/ClickHouse/ClickHouse/pull/19396) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Check literal types in RewriteSumIfFunctionMatcher [#19406](https://github.com/ClickHouse/ClickHouse/pull/19406) ([Vladimir C](https://github.com/vdimir)).
* mirror changes in code and comment [#19410](https://github.com/ClickHouse/ClickHouse/pull/19410) ([flynn](https://github.com/ucasfl)).
* Fix one more race in TestKeeper [#19412](https://github.com/ClickHouse/ClickHouse/pull/19412) ([alesapin](https://github.com/alesapin)).
* Continue fix for Block structure mismatch in PipelineExecuting stream [#19414](https://github.com/ClickHouse/ClickHouse/pull/19414) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Integration tests: print stderr of failed subprocess [#19431](https://github.com/ClickHouse/ClickHouse/pull/19431) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Don't dwell on the past in query fuzzer [#19442](https://github.com/ClickHouse/ClickHouse/pull/19442) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Remove outdated suppressions [#19444](https://github.com/ClickHouse/ClickHouse/pull/19444) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build with unbundled poco [#19450](https://github.com/ClickHouse/ClickHouse/pull/19450) ([Azat Khuzhin](https://github.com/azat)).
* Fix UBSan report in arraySlice and substring [#19459](https://github.com/ClickHouse/ClickHouse/pull/19459) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in runningDifference [#19460](https://github.com/ClickHouse/ClickHouse/pull/19460) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid UBSan report in greatCircleDistance [#19461](https://github.com/ClickHouse/ClickHouse/pull/19461) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* UBsan report fixes (arraySlice, addMinutes/addHours/addWeeks/addDays, sumWithOverflow(Decimal)) [#19466](https://github.com/ClickHouse/ClickHouse/pull/19466) ([Azat Khuzhin](https://github.com/azat)).
* Remove complications from FunctionsAES [#19467](https://github.com/ClickHouse/ClickHouse/pull/19467) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix insufficient args check in AES functions [#19474](https://github.com/ClickHouse/ClickHouse/pull/19474) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in avgWeighted [#19475](https://github.com/ClickHouse/ClickHouse/pull/19475) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* remove part of misleading exception message [#19487](https://github.com/ClickHouse/ClickHouse/pull/19487) ([flynn](https://github.com/ucasfl)).
* Bug fix : support const column processing in mapContains, mapKeys, mapValues functions [#19515](https://github.com/ClickHouse/ClickHouse/pull/19515) ([hexiaoting](https://github.com/hexiaoting)).
* More diagnostics in fuzzer [#19524](https://github.com/ClickHouse/ClickHouse/pull/19524) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix 01459_manual_write_to_replicas flaky test [#19551](https://github.com/ClickHouse/ClickHouse/pull/19551) ([alesapin](https://github.com/alesapin)).
* Check for hung queries or server hung in fast test [#19558](https://github.com/ClickHouse/ClickHouse/pull/19558) ([alesapin](https://github.com/alesapin)).
* DateLUTImpl::addYears(...): suppress UBSan [#19566](https://github.com/ClickHouse/ClickHouse/pull/19566) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Merging [#18549](https://github.com/ClickHouse/ClickHouse/issues/18549) [#19583](https://github.com/ClickHouse/ClickHouse/pull/19583) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update Cassandra submodule with patch by @leshikus [#19590](https://github.com/ClickHouse/ClickHouse/pull/19590) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove unused include header [#19598](https://github.com/ClickHouse/ClickHouse/pull/19598) ([BohuTANG](https://github.com/BohuTANG)).
* Fix merge join constants [#19648](https://github.com/ClickHouse/ClickHouse/pull/19648) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Better abstractions in disk interface [#19660](https://github.com/ClickHouse/ClickHouse/pull/19660) ([Anton Popov](https://github.com/CurtizJ)).
* Fix deadlock in testkeeper [#19661](https://github.com/ClickHouse/ClickHouse/pull/19661) ([alesapin](https://github.com/alesapin)).
* fix special build on clang11 [#19663](https://github.com/ClickHouse/ClickHouse/pull/19663) ([flynn](https://github.com/ucasfl)).
* Require current_database filter for tests with query_log/query_thread_log [#19675](https://github.com/ClickHouse/ClickHouse/pull/19675) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test tiny cleanup [#19676](https://github.com/ClickHouse/ClickHouse/pull/19676) ([Azat Khuzhin](https://github.com/azat)).
* Fix crash after merging ActionsDAG. [#19704](https://github.com/ClickHouse/ClickHouse/pull/19704) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix flaky test concat_nary_const_with_nonconst_segfault [#19711](https://github.com/ClickHouse/ClickHouse/pull/19711) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Run tests in parallel in flaky check [#19715](https://github.com/ClickHouse/ClickHouse/pull/19715) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Fix 01115_join_with_dictionary flakiness [#19723](https://github.com/ClickHouse/ClickHouse/pull/19723) ([Azat Khuzhin](https://github.com/azat)).
* add empty line after error messages in client [#19724](https://github.com/ClickHouse/ClickHouse/pull/19724) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* Update QueryPlan tree optimization traverse. [#19725](https://github.com/ClickHouse/ClickHouse/pull/19725) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add missing lsof for fasttest docker image [#19751](https://github.com/ClickHouse/ClickHouse/pull/19751) ([Azat Khuzhin](https://github.com/azat)).
* Make Fuzzer more reliable [#19752](https://github.com/ClickHouse/ClickHouse/pull/19752) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor code improvement in JOIN [#19758](https://github.com/ClickHouse/ClickHouse/pull/19758) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make integration odbc tests idempotent [#19759](https://github.com/ClickHouse/ClickHouse/pull/19759) ([alesapin](https://github.com/alesapin)).
* Small fixes for fasttest [#19760](https://github.com/ClickHouse/ClickHouse/pull/19760) ([alesapin](https://github.com/alesapin)).
* LowCardinality UUID fix [#19767](https://github.com/ClickHouse/ClickHouse/pull/19767) ([Maksim Kita](https://github.com/kitaisreal)).
* Add log comment when running .sh tests [#19774](https://github.com/ClickHouse/ClickHouse/pull/19774) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in "round" [#19786](https://github.com/ClickHouse/ClickHouse/pull/19786) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test script for [#19794](https://github.com/ClickHouse/ClickHouse/issues/19794) [#19798](https://github.com/ClickHouse/ClickHouse/pull/19798) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix dependency on ODBC for Yandex internal build [#19804](https://github.com/ClickHouse/ClickHouse/pull/19804) ([Alexander Gololobov](https://github.com/davenger)).
* Don't run all stateless tests in parallel [#19806](https://github.com/ClickHouse/ClickHouse/pull/19806) ([alesapin](https://github.com/alesapin)).
* Avoid losing exception messages in logs under high memory pressure [#19824](https://github.com/ClickHouse/ClickHouse/pull/19824) ([Azat Khuzhin](https://github.com/azat)).
* Try to make test_dir.tar smaller [#19833](https://github.com/ClickHouse/ClickHouse/pull/19833) ([filimonov](https://github.com/filimonov)).
* style-check tiny fixes [#19834](https://github.com/ClickHouse/ClickHouse/pull/19834) ([Azat Khuzhin](https://github.com/azat)).
* Fix UBSan report in DateTimeAddInterval [#19859](https://github.com/ClickHouse/ClickHouse/pull/19859) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix debug assertion in Hyperscan [#19860](https://github.com/ClickHouse/ClickHouse/pull/19860) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix UBSan report in GatherUtils [#19862](https://github.com/ClickHouse/ClickHouse/pull/19862) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
