---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.12.1.9017-prestable FIXME as compared to v21.11.1.8636-prestable

#### Backward Incompatible Change
* Add custom null representation support for TSV/CSV input formats. Fix deserialing Nullable(String) in TSV/CSV/JSONCompactStringsEachRow/JSONStringsEachRow input formats. Rename `output_format_csv_null_representation` and `output_format_tsv_null_representation` to `format_csv_null_representation` and `format_tsv_null_representation` accordingly. [#30497](https://github.com/ClickHouse/ClickHouse/pull/30497) ([Kruglov Pavel](https://github.com/Avogar)).
* Return unquoted string in JSON_VALUE. Closes [#27965](https://github.com/ClickHouse/ClickHouse/issues/27965). [#31008](https://github.com/ClickHouse/ClickHouse/pull/31008) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Do not allow direct select for Kafka/RabbitMQ/FileLog. Can be enables by setting `stream_like_engine_allow_direct_select`. Direct select will be not allowed even if enabled by setting in case there is attached materialized view. For Kafka and RabbitMQ direct select if allowed, will not commit massages by default. To enable commits with direct select user must use storage level setting `kafka{rabbitmq}_commit_on_select=1` (default `0`). cc @filimonov. [#31053](https://github.com/ClickHouse/ClickHouse/pull/31053) ([Kseniia Sumarokova](https://github.com/kssenii)).
* A "leader election" mechanism is removed from `ReplicatedMergeTree`, because multiple leaders are supported since 20.6. If you are upgrading from older version and some replica with old version is a leader, then server will fail to start after upgrade. Stop replicas with old version to make new version start. After that it will not be possible to downgrade to version older than 20.6. [#32140](https://github.com/ClickHouse/ClickHouse/pull/32140) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### New Feature
* Support for Stream Processing. [#8331](https://github.com/ClickHouse/ClickHouse/pull/8331) ([vxider](https://github.com/Vxider)).
* - Added CONSTRAINT ... ASSUME ... (without checking during INSERT) - Added query transformation to CNF (https://github.com/ClickHouse/ClickHouse/issues/11749) for more convenient optimization - Added simple query rewriting using constraints (only simple matching now, will be improved to support <,=,>... later) - Added ability to replace heavy columns with light - Added ability to use the index in queries. [#18787](https://github.com/ClickHouse/ClickHouse/pull/18787) ([Nikita Vasilev](https://github.com/nikvas0)).
* * Add Map combinator for `Map` type. * Rename old `sum-, min-, max- Map` for mapped arrays to `sum-, min-, max- MappedArrays`. [#24539](https://github.com/ClickHouse/ClickHouse/pull/24539) ([Ildus Kurbangaliev](https://github.com/ildus)).
* Support `JOIN ON 1 = 1` that have CROSS JOIN semantic, close [#25578](https://github.com/ClickHouse/ClickHouse/issues/25578). [#25894](https://github.com/ClickHouse/ClickHouse/pull/25894) ([Vladimir C](https://github.com/vdimir)).
* Adding function `getFuzzerData()` to easily fuzz particular functions. This closes [#23227](https://github.com/ClickHouse/ClickHouse/issues/23227). [#27526](https://github.com/ClickHouse/ClickHouse/pull/27526) ([Alexey Boykov](https://github.com/mathalex)).
* This closes [#28774](https://github.com/ClickHouse/ClickHouse/issues/28774). [#28965](https://github.com/ClickHouse/ClickHouse/pull/28965) ([小路](https://github.com/nicelulu)).
* We need to implement similar commands in clickhouse-keeper: https://zookeeper.apache.org/doc/r3.4.8/zookeeperAdmin.html#sc_zkCommands. [#28981](https://github.com/ClickHouse/ClickHouse/pull/28981) ([JackyWoo](https://github.com/JackyWoo)).
* Add option to compress logs before writing them to a file using LZ4. Closes [#23860](https://github.com/ClickHouse/ClickHouse/issues/23860). [#29219](https://github.com/ClickHouse/ClickHouse/pull/29219) ([Nikolay Degterinsky](https://github.com/evillique)).
* Introduced window functions: - `exponentialTimeDecayedSum` - `exponentialTimeDecayedMax` - `exponentialTimeDecayedCount` - `exponentialTimeDecayedAvg` which are more effective than `exponentialMovingAverage` for bigger windows. Also more use-cases were covered. [#29799](https://github.com/ClickHouse/ClickHouse/pull/29799) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Support for PARTITION BY in File, URL, HDFS storages and with INSERT INTO table function. Closes [#30273](https://github.com/ClickHouse/ClickHouse/issues/30273). [#30690](https://github.com/ClickHouse/ClickHouse/pull/30690) ([Kseniia Sumarokova](https://github.com/kssenii)).
* support bool data type. [#31072](https://github.com/ClickHouse/ClickHouse/pull/31072) ([kevin wan](https://github.com/MaxWk)).
* Exposes all GlobalThreadPool configurations to the configuration files. [#31285](https://github.com/ClickHouse/ClickHouse/pull/31285) ([Tomáš Hromada](https://github.com/gyfis)).
* Aliyun OSS Storage support. [#31286](https://github.com/ClickHouse/ClickHouse/pull/31286) ([cfcz48](https://github.com/cfcz48)).
* Allow to print/parse names and types of colums in CustomSeparated input/output format. Add formats CustomSeparatedWithNames/WithNamesAndTypes similar to TSVWithNames/WithNamesAndTypes. [#31434](https://github.com/ClickHouse/ClickHouse/pull/31434) ([Kruglov Pavel](https://github.com/Avogar)).
* - Basic access authentication for http/url functions. [#31648](https://github.com/ClickHouse/ClickHouse/pull/31648) ([Peng Liu](https://github.com/michael1589)).

#### Performance Improvement
* ... Allow to split GraphiteMergeTree rollup rules for plain/tagged metrics (optional rule_type field). [#25122](https://github.com/ClickHouse/ClickHouse/pull/25122) ([Michail Safronov](https://github.com/msaf1980)).
* Fixing query performance issue in `LiveView` tables. Fixes [#30831](https://github.com/ClickHouse/ClickHouse/issues/30831). [#31006](https://github.com/ClickHouse/ClickHouse/pull/31006) ([vzakaznikov](https://github.com/vzakaznikov)).
* Improve performance of syncing data to block device. This closes [#31181](https://github.com/ClickHouse/ClickHouse/issues/31181). [#31229](https://github.com/ClickHouse/ClickHouse/pull/31229) ([zhanglistar](https://github.com/zhanglistar)).
* Support parallel formatting for all text formats, except `JSONEachRowWithProgress` and `PrettyCompactMonoBlock`. [#31489](https://github.com/ClickHouse/ClickHouse/pull/31489) ([Kruglov Pavel](https://github.com/Avogar)).
* Improve performance of JSON and XML output formats. [#31673](https://github.com/ClickHouse/ClickHouse/pull/31673) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Speedup avg and sumCount aggregate functions. [#31694](https://github.com/ClickHouse/ClickHouse/pull/31694) ([Raúl Marín](https://github.com/Algunenano)).
* Speed up count over nullable columns. [#31806](https://github.com/ClickHouse/ClickHouse/pull/31806) ([Raúl Marín](https://github.com/Algunenano)).
* Speedup query parsing. [#31949](https://github.com/ClickHouse/ClickHouse/pull/31949) ([Raúl Marín](https://github.com/Algunenano)).

#### Improvement
* Enable clang `-fstrict-vtable-pointers`, `-fwhole-program-vtables` compile options. [#20151](https://github.com/ClickHouse/ClickHouse/pull/20151) ([Maksim Kita](https://github.com/kitaisreal)).
* Skipping mutations of different partitions in `StorageMergeTree`. [#21326](https://github.com/ClickHouse/ClickHouse/pull/21326) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Closes [#12552](https://github.com/ClickHouse/ClickHouse/issues/12552). Allow versioning of aggregate function states. [#24820](https://github.com/ClickHouse/ClickHouse/pull/24820) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add optimizations for constant conditions in JOIN ON, ref [#26928](https://github.com/ClickHouse/ClickHouse/issues/26928). [#27021](https://github.com/ClickHouse/ClickHouse/pull/27021) ([Vladimir C](https://github.com/vdimir)).
* Add support for `Identifier` table and database query parameters. Closes [#27226](https://github.com/ClickHouse/ClickHouse/issues/27226). [#28668](https://github.com/ClickHouse/ClickHouse/pull/28668) ([Nikolay Degterinsky](https://github.com/evillique)).
* Allow to specify one or any number of PostgreSQL schemas for one MaterializedPostgreSQL database. Closes [#28901](https://github.com/ClickHouse/ClickHouse/issues/28901). Closes [#29324](https://github.com/ClickHouse/ClickHouse/issues/29324). [#28933](https://github.com/ClickHouse/ClickHouse/pull/28933) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make reading from HTTP retriable. Closes [#29696](https://github.com/ClickHouse/ClickHouse/issues/29696). [#29894](https://github.com/ClickHouse/ClickHouse/pull/29894) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add support for parallel reading from multiple files and support globs in `FROM INFILE` clause. [#30135](https://github.com/ClickHouse/ClickHouse/pull/30135) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* - Refactor formats TSV, TSVRaw, CSV and JSONCompactEachRow, JSONCompactStringsEachRow, remove code duplication, add base interface for formats with -WithNames and -WithNamesAndTypes suffixes. - Add formats CSVWithNamesAndTypes, TSVRawWithNames, TSVRawWithNamesAndTypes, JSONCompactEachRowWIthNames, JSONCompactStringsEachRowWIthNames, RowBinaryWithNames - Support parallel parsing for formats TSVWithNamesAndTypes, TSVRaw(WithNames/WIthNamesAndTypes), CSVWithNamesAndTypes, JSONCompactEachRow(WithNames/WIthNamesAndTypes), JSONCompactStringsEachRow(WithNames/WIthNamesAndTypes). - Support columns mapping and types checking for RowBinaryWithNamesAndTypes format. - Add setting `input_format_with_types_use_header` which specify if we should check that types written in <format_name>WIthNamesAndTypes format matches with table structure. - Add setting `input_format_csv_empty_as_default` and use it in CSV format instead of `input_format_defaults_for_omitted_fields` (because this setting should't control `csv_empty_as_default`). - Fix usage of setting `input_format_defaults_for_omitted_fields` (it was used only as `csv_empty_as_default`, but it should control calculation of default expressions for omitted fields) - Fix Nullable input/output in TSVRaw format, make this format fully compatible with inserting into TSV. - Fix inserting NULLs in LowCardinality(Nullable) when `input_format_null_as_default` is enabled (previously default values was inserted instead of actual NULLs). - Fix strings deserialization in JSONStringsEachRow/JSONCompactStringsEachRow formats (strings were parsed just until first '\n' or '\t') - Add ability to use `Raw` escaping rule in Template input format. - Add diagnostic info for JSONCompactEachRow(WithNames/WIthNamesAndTypes) input format. - Fix bug with parallel parsing of -WithNames formats in case when setting min_chunk_bytes_for_parallel_parsing is less than bytes in a single row. [#30178](https://github.com/ClickHouse/ClickHouse/pull/30178) ([Kruglov Pavel](https://github.com/Avogar)).
* Avro format works against Kafka. Setting `output_format_avro_rows_in_file` added. [#30351](https://github.com/ClickHouse/ClickHouse/pull/30351) ([Ilya Golshtein](https://github.com/ilejn)).
* Implement the commands BACKUP and RESTORE for the Log family. [#30688](https://github.com/ClickHouse/ClickHouse/pull/30688) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix possible "The local set of parts of X doesn't look like the set of parts in ZooKeeper" error (if DROP fails during removing znodes from zookeeper). [#30826](https://github.com/ClickHouse/ClickHouse/pull/30826) ([Azat Khuzhin](https://github.com/azat)).
* For clickhouse-local or clickhouse-client if there is --interactive option with --query or --queries-file, then first execute them like in non-interactive and then start interactive mode. [#30851](https://github.com/ClickHouse/ClickHouse/pull/30851) ([Kseniia Sumarokova](https://github.com/kssenii)).
* added \l, \d, \c aliases like in MySQL. [#30876](https://github.com/ClickHouse/ClickHouse/pull/30876) ([Pavel Medvedev](https://github.com/pmed)).
* Fix `--verbose` option in clickhouse-local interactive mode and allow logging into file. [#30881](https://github.com/ClickHouse/ClickHouse/pull/30881) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support `INTERVAL` type in `STEP` clause for `WITH FILL` modifier. [#30927](https://github.com/ClickHouse/ClickHouse/pull/30927) ([Anton Popov](https://github.com/CurtizJ)).
* Reduce memory usage when reading with `s3` / `url` / `hdfs` formats `Parquet`, `ORC`, `Arrow` (controlled by setting `input_format_allow_seeks`, enabled by default). Also add setting `remote_read_min_bytes_for_seek` to control seeks. Closes [#10461](https://github.com/ClickHouse/ClickHouse/issues/10461). Closes [#16857](https://github.com/ClickHouse/ClickHouse/issues/16857). [#30936](https://github.com/ClickHouse/ClickHouse/pull/30936) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add settings `merge_tree_min_rows_for_concurrent_read_for_remote_filesystem` and `merge_tree_min_bytes_for_concurrent_read_for_remote_filesystem`. [#30970](https://github.com/ClickHouse/ClickHouse/pull/30970) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Do not allow to drop a table or dictionary if some tables or dictionaries depend on it. [#30977](https://github.com/ClickHouse/ClickHouse/pull/30977) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Only grab AlterLock when we do alter command. Let's see if the assumption is correct. [#31010](https://github.com/ClickHouse/ClickHouse/pull/31010) ([Amos Bird](https://github.com/amosbird)).
* The local session inside a Clickhouse dictionary source won't send its events to the session log anymore. This fixes a possible deadlock (tsan alert) on shutdown. Also this PR fixes flaky `test_dictionaries_dependency_xml/`. [#31013](https://github.com/ClickHouse/ClickHouse/pull/31013) ([Vitaly Baranov](https://github.com/vitlibar)).
* Cancel vertical merges when partition is dropped. This is a follow-up of https://github.com/ClickHouse/ClickHouse/pull/25684 and https://github.com/ClickHouse/ClickHouse/pull/30996. [#31057](https://github.com/ClickHouse/ClickHouse/pull/31057) ([Amos Bird](https://github.com/amosbird)).
* Support `IF EXISTS` modifier for `RENAME DATABASE`/`TABLE`/`DICTIONARY` query, If this directive is used, one will not get an error if the DATABASE/TABLE/DICTIONARY to be renamed doesn't exist. [#31081](https://github.com/ClickHouse/ClickHouse/pull/31081) ([victorgao](https://github.com/kafka1991)).
* Function name normalization for ALTER queries. This helps avoid metadata mismatch between creating table with indices/projections and adding indices/projections via alter commands. This is a follow-up PR of https://github.com/ClickHouse/ClickHouse/pull/20174. Mark as improvements as there are no bug reports and the senario is somehow rare. [#31095](https://github.com/ClickHouse/ClickHouse/pull/31095) ([Amos Bird](https://github.com/amosbird)).
* Enable multiline editing in clickhouse-client by default. This addresses [#31121](https://github.com/ClickHouse/ClickHouse/issues/31121) . [#31123](https://github.com/ClickHouse/ClickHouse/pull/31123) ([Amos Bird](https://github.com/amosbird)).
* Use DiskPtr instead of OS's file system API in class IDiskRemote in order to get more extendiability. Closes [#31117](https://github.com/ClickHouse/ClickHouse/issues/31117). [#31136](https://github.com/ClickHouse/ClickHouse/pull/31136) ([Yangkuan Liu](https://github.com/LiuYangkuan)).
* Now every replica will send to client only incremental information about profile events counters. [#31155](https://github.com/ClickHouse/ClickHouse/pull/31155) ([Dmitry Novik](https://github.com/novikd)).
* - Syntax changed so now backup engine should be set explicitly: `BACKUP ... TO Disk('backups', 'path\')` - Changed the format of backup's metadata, now it's in XML - Backup of a whole database now works. [#31178](https://github.com/ClickHouse/ClickHouse/pull/31178) ([Vitaly Baranov](https://github.com/vitlibar)).
* Improved backoff for background cleanup tasks in `MergeTree`. Settings `merge_tree_clear_old_temporary_directories_interval_seconds` and `merge_tree_clear_old_parts_interval_seconds` moved form users settings to merge tree settings. [#31180](https://github.com/ClickHouse/ClickHouse/pull/31180) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Optimize function `mapContains` to reading of subcolumn `key` with enabled settings `optimize_functions_to_subcolumns`. [#31218](https://github.com/ClickHouse/ClickHouse/pull/31218) ([Anton Popov](https://github.com/CurtizJ)).
* If some obsolete setting is changed show warning in `system.warnings`. [#31252](https://github.com/ClickHouse/ClickHouse/pull/31252) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Optimize function `tupleElement` to reading of subcolumn with enabled setting `optimize_functions_to_subcolumns`. [#31261](https://github.com/ClickHouse/ClickHouse/pull/31261) ([Anton Popov](https://github.com/CurtizJ)).
* Initial user's roles are used now to find row policies, see [#31080](https://github.com/ClickHouse/ClickHouse/issues/31080). [#31262](https://github.com/ClickHouse/ClickHouse/pull/31262) ([Vitaly Baranov](https://github.com/vitlibar)).
* Previously progress was shown only for `numbers` table function, not for `numbers_mt`. Now for `numbers_mt` it is also shown. [#31318](https://github.com/ClickHouse/ClickHouse/pull/31318) ([Kseniia Sumarokova](https://github.com/kssenii)).
* return fake create query when executing `show create table` on system's tables. [#31391](https://github.com/ClickHouse/ClickHouse/pull/31391) ([SuperDJY](https://github.com/cmsxbc)).
* MaterializedMySQL now handles `CREATE TABLE ... LIKE ...` DDL queries. [#31410](https://github.com/ClickHouse/ClickHouse/pull/31410) ([Stig Bakken](https://github.com/stigsb)).
* Default value of `http_send_timeout` and `http_receive_timeout` settings changed from 1800 (30 minutes) to 180 (3 minutes). [#31450](https://github.com/ClickHouse/ClickHouse/pull/31450) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Throw an exception if there is some garbage after field in JSONCompactStrings(EachRow) format. [#31455](https://github.com/ClickHouse/ClickHouse/pull/31455) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix waiting of the editor during interactive query edition (`waitpid()` returns -1 on `SIGWINCH` and `EDITOR` and `clickhouse-local`/`clickhouse-client` works concurrently). [#31456](https://github.com/ClickHouse/ClickHouse/pull/31456) ([Azat Khuzhin](https://github.com/azat)).
* Add `--pager` support for `clickhouse-local`. [#31457](https://github.com/ClickHouse/ClickHouse/pull/31457) ([Azat Khuzhin](https://github.com/azat)).
* Better analysis for `min/max/count` projection. Now, with enabled `allow_experimental_projection_optimization`, virtual `min/max/count` projection can be used together with columns from partition key. [#31474](https://github.com/ClickHouse/ClickHouse/pull/31474) ([Amos Bird](https://github.com/amosbird)).
* Use shard and replica name from `Replicated` database arguments when expanding macros in `ReplicatedMergeTree` arguments if these macros are not defined in config. Closes [#31471](https://github.com/ClickHouse/ClickHouse/issues/31471). [#31488](https://github.com/ClickHouse/ClickHouse/pull/31488) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Better exception message when `users.xml` cannot be loaded due to bad password hash. This closes [#24126](https://github.com/ClickHouse/ClickHouse/issues/24126). [#31557](https://github.com/ClickHouse/ClickHouse/pull/31557) ([Vitaly Baranov](https://github.com/vitlibar)).
* Improve the `max_execution_time` checks. Fixed some cases when timeout checks do not happen and query could run too long. [#31636](https://github.com/ClickHouse/ClickHouse/pull/31636) ([Raúl Marín](https://github.com/Algunenano)).
* Add bindings for navigating through history (instead of lines/history). [#31641](https://github.com/ClickHouse/ClickHouse/pull/31641) ([Azat Khuzhin](https://github.com/azat)).
* Always re-render prompt while navigating history in clickhouse-client. This will improve usability of manipulating very long queries that don't fit on screen. [#31675](https://github.com/ClickHouse/ClickHouse/pull/31675) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Allow to use named collections configuration for kafka and rabbitmq engines (the same way as for other intgration table engines). [#31691](https://github.com/ClickHouse/ClickHouse/pull/31691) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ClickHouse dictionary source support named connections. Closes [#31705](https://github.com/ClickHouse/ClickHouse/issues/31705). [#31749](https://github.com/ClickHouse/ClickHouse/pull/31749) ([Kseniia Sumarokova](https://github.com/kssenii)).
* MaterializedMySQL: Fix issue with table named 'table'. [#31781](https://github.com/ClickHouse/ClickHouse/pull/31781) ([Håvard Kvålen](https://github.com/havardk)).
* Recreate system.*_log tables in case of different engine/partition_by. [#31824](https://github.com/ClickHouse/ClickHouse/pull/31824) ([Azat Khuzhin](https://github.com/azat)).
* Fix the issue that `LowCardinality` of `Int256` cannot be created. [#31832](https://github.com/ClickHouse/ClickHouse/pull/31832) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support PostgreSQL style ALTER MODIFY COLUMN. [#32003](https://github.com/ClickHouse/ClickHouse/pull/32003) ([SuperDJY](https://github.com/cmsxbc)).
* Remove excessive `DESC TABLE` requests for `remote()` (in case of `remote('127.1', system.one)` (i.e. identifier as the db.table instead of string) there was excessive `DESC TABLE` request). [#32019](https://github.com/ClickHouse/ClickHouse/pull/32019) ([Azat Khuzhin](https://github.com/azat)).
* - Fix a bug that opentelemetry span log duration is zero at the query level if there's query exception. [#32038](https://github.com/ClickHouse/ClickHouse/pull/32038) ([Frank Chen](https://github.com/FrankChen021)).
* Added ClickHouse `exception` and `exception_code` fields to opentelemetry span log. [#32040](https://github.com/ClickHouse/ClickHouse/pull/32040) ([Frank Chen](https://github.com/FrankChen021)).
* Allow a user configured `hdfs_replication` parameter for DiskHdfs and StorageHdfs. Closes [#32039](https://github.com/ClickHouse/ClickHouse/issues/32039). [#32049](https://github.com/ClickHouse/ClickHouse/pull/32049) ([leosunli](https://github.com/leosunli)).
* Allow to write `+` before Float32/Float64 values. [#32079](https://github.com/ClickHouse/ClickHouse/pull/32079) ([Kruglov Pavel](https://github.com/Avogar)).
* - returns Content-Type as 'application/json' for `JSONEachRow` format if `output_format_json_array_of_rows` is enabled. [#32112](https://github.com/ClickHouse/ClickHouse/pull/32112) ([Frank Chen](https://github.com/FrankChen021)).
* - Set Content-Type in HTTP packets issued from URL engine. [#32113](https://github.com/ClickHouse/ClickHouse/pull/32113) ([Frank Chen](https://github.com/FrankChen021)).
* Now `clickhouse-keeper` refuse to start or apply configuration changes when they contain duplicated IDs or endpoints. Fixes [#31339](https://github.com/ClickHouse/ClickHouse/issues/31339). [#32121](https://github.com/ClickHouse/ClickHouse/pull/32121) ([alesapin](https://github.com/alesapin)).
* Added `update_field` support for `RangeHashedDictionary`, `ComplexKeyRangeHashedDictionary`. [#32185](https://github.com/ClickHouse/ClickHouse/pull/32185) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve skiping unknown fields with Quoted escaping rule in Template/CustomSeparated formats. Previously we could skip only quoted strings, now we can skip values with any type. [#32204](https://github.com/ClickHouse/ClickHouse/pull/32204) ([Kruglov Pavel](https://github.com/Avogar)).
* Use `Content-Type: application/x-ndjson` (http://ndjson.org/) for output format `JSONEachRow`. [#32223](https://github.com/ClickHouse/ClickHouse/pull/32223) ([Dmitriy Dorofeev](https://github.com/deem0n)).
* - Improve the operation name of an opentelemetry span. [#32234](https://github.com/ClickHouse/ClickHouse/pull/32234) ([Frank Chen](https://github.com/FrankChen021)).
* Support default expression for storage hdfs and optimize fetching when source is column oriented. [#32256](https://github.com/ClickHouse/ClickHouse/pull/32256) ([李扬](https://github.com/taiyang-li)).

#### Bug Fix
* Memory amount was incorrectly estimated when ClickHouse is run in containers with cgroup limits. [#31157](https://github.com/ClickHouse/ClickHouse/pull/31157) ([Pavel Medvedev](https://github.com/pmed)).
* Fix SHOW GRANTS when partial revokes are used. This PR fixes [#31138](https://github.com/ClickHouse/ClickHouse/issues/31138). [#31249](https://github.com/ClickHouse/ClickHouse/pull/31249) ([Vitaly Baranov](https://github.com/vitlibar)).
* Quota limit was not reached, but the limit was exceeded. This PR fixes [#31174](https://github.com/ClickHouse/ClickHouse/issues/31174). [#31337](https://github.com/ClickHouse/ClickHouse/pull/31337) ([sunny](https://github.com/sunny19930321)).
* Fix skipping columns while writing protobuf. This PR fixes [#31160](https://github.com/ClickHouse/ClickHouse/issues/31160), see the comment [#31160](https://github.com/ClickHouse/ClickHouse/issues/31160)#issuecomment-980595318. [#31988](https://github.com/ClickHouse/ClickHouse/pull/31988) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix bug when remove unneeded columns in subquery. If there is an aggregation function in query without group by, do not remove if it is unneeded. [#32289](https://github.com/ClickHouse/ClickHouse/pull/32289) ([dongyifeng](https://github.com/dyf6372)).

#### Build/Testing/Packaging Improvement
* Hermetic builds: use fixed version of libc and make sure that no source or binary files from the host OS are using during build. This closes [#27133](https://github.com/ClickHouse/ClickHouse/issues/27133). This closes [#21435](https://github.com/ClickHouse/ClickHouse/issues/21435). This closes [#30462](https://github.com/ClickHouse/ClickHouse/issues/30462). [#30011](https://github.com/ClickHouse/ClickHouse/pull/30011) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Use our own CMakeLists for `zlib-ng`, `cassandra`, `mariadb-connector-c` and `xz`, `re2`, `sentry`, `gsasl`, `arrow`, `protobuf`. This is needed for [#20151](https://github.com/ClickHouse/ClickHouse/issues/20151). Part of [#9226](https://github.com/ClickHouse/ClickHouse/issues/9226). A small step towards removal of annoying trash from the build system. [#30599](https://github.com/ClickHouse/ClickHouse/pull/30599) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build snappy error in [#30790](https://github.com/ClickHouse/ClickHouse/issues/30790) Update of contrib/snappy is in https://github.com/google/snappy/pull/145/files. [#30796](https://github.com/ClickHouse/ClickHouse/pull/30796) ([李扬](https://github.com/taiyang-li)).
* Drop support for using Ordinary databases with MaterializedMySQL. [#31292](https://github.com/ClickHouse/ClickHouse/pull/31292) ([Stig Bakken](https://github.com/stigsb)).
* Initial support for risc-v. See development/build-cross-riscv for quirks and build command that was tested. [#31309](https://github.com/ClickHouse/ClickHouse/pull/31309) ([Vladimir Smirnov](https://github.com/Civil)).
* Remove hardcoded repository name from CI scripts. [#31536](https://github.com/ClickHouse/ClickHouse/pull/31536) ([Constantine Peresypkin](https://github.com/pkit)).
* Avoid downloading toolchain tarballs for cross-compiling for FreeBSD. [#31672](https://github.com/ClickHouse/ClickHouse/pull/31672) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The script for uploading packages to the artifactory is added. [#31748](https://github.com/ClickHouse/ClickHouse/pull/31748) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Replaced default ports for clickhouse-keeper internal communication from 44444 to 9234. Fixes [#30879](https://github.com/ClickHouse/ClickHouse/issues/30879). [#31799](https://github.com/ClickHouse/ClickHouse/pull/31799) ([alesapin](https://github.com/alesapin)).
* More correct setting up capabilities inside Docker. [#31802](https://github.com/ClickHouse/ClickHouse/pull/31802) ([Constantine Peresypkin](https://github.com/pkit)).
* Revert changes from [#28016](https://github.com/ClickHouse/ClickHouse/issues/28016): archive.ubuntu.com should be faster in general than RU mirror. [#31822](https://github.com/ClickHouse/ClickHouse/pull/31822) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Remove filesystem path to the build directory from binaries to enable reproducible builds. This needed for [#22113](https://github.com/ClickHouse/ClickHouse/issues/22113). [#31838](https://github.com/ClickHouse/ClickHouse/pull/31838) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make ClickHouse build fully reproducible (byte identical on different machines). This closes [#22113](https://github.com/ClickHouse/ClickHouse/issues/22113). [#31899](https://github.com/ClickHouse/ClickHouse/pull/31899) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* - Adjust artifactory pusher to a new bucket paths - Use only version or pull request number in bucket, no `0` - Create a function to read github event data. [#31952](https://github.com/ClickHouse/ClickHouse/pull/31952) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Build rpm and tgz packages in master and release branches workfolw. [#32048](https://github.com/ClickHouse/ClickHouse/pull/32048) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix broken symlink for sysroot/linux-riscv64/usr/lib. [#32071](https://github.com/ClickHouse/ClickHouse/pull/32071) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* Fix some corner cases with intersect/except. Closes [#30803](https://github.com/ClickHouse/ClickHouse/issues/30803). [#30965](https://github.com/ClickHouse/ClickHouse/pull/30965) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Skip max_partition_size_to_drop check in case of ATTACH PARTITION ... FROM and MOVE PARTITION ... [#30995](https://github.com/ClickHouse/ClickHouse/pull/30995) ([Amr Alaa](https://github.com/amralaa-MSFT)).
* Fix bug which broke select queries if they happened after dropping materialized view. Found in [#30691](https://github.com/ClickHouse/ClickHouse/issues/30691). [#30997](https://github.com/ClickHouse/ClickHouse/pull/30997) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Using `formatRow` function with not row formats led to segfault. Don't allow to use this function with such formats (because it doesn't make sense). [#31001](https://github.com/ClickHouse/ClickHouse/pull/31001) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix JSONValue/Query with quoted identifiers. This allows to have spaces in json path. Closes [#30971](https://github.com/ClickHouse/ClickHouse/issues/30971). [#31003](https://github.com/ClickHouse/ClickHouse/pull/31003) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible assert in `hdfs` table function/engine, add test. [#31036](https://github.com/ClickHouse/ClickHouse/pull/31036) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix abort in debug server and `DB::Exception: std::out_of_range: basic_string` error in release server in case of bad hdfs url by adding additional check of hdfs url structure. [#31042](https://github.com/ClickHouse/ClickHouse/pull/31042) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix StorageMerge with aliases and where (it did not work before at all). Closes [#28802](https://github.com/ClickHouse/ClickHouse/issues/28802). [#31044](https://github.com/ClickHouse/ClickHouse/pull/31044) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Rewrite right distributed table in local join. solves [#25809](https://github.com/ClickHouse/ClickHouse/issues/25809). [#31105](https://github.com/ClickHouse/ClickHouse/pull/31105) ([abel-cheng](https://github.com/abel-cheng)).
* Fix bug in Keeper which can lead to inability to start when some coordination logs was lost and we have more fresh snapshot than our latest log. [#31150](https://github.com/ClickHouse/ClickHouse/pull/31150) ([alesapin](https://github.com/alesapin)).
* Remove not like function into RPNElement. [#31169](https://github.com/ClickHouse/ClickHouse/pull/31169) ([sundyli](https://github.com/sundy-li)).
* Resolve `nullptr` in STS credentials provider for S3. [#31409](https://github.com/ClickHouse/ClickHouse/pull/31409) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix bug with group by and positional arguments. Closes [#31280](https://github.com/ClickHouse/ClickHouse/issues/31280)#issuecomment-968696186. [#31420](https://github.com/ClickHouse/ClickHouse/pull/31420) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix progress for short INSERT SELECT queries. [#31510](https://github.com/ClickHouse/ClickHouse/pull/31510) ([Azat Khuzhin](https://github.com/azat)).
* * Disable `partial_merge_join_left_table_buffer_bytes` before bug in this optimization is fixed. See [#31009](https://github.com/ClickHouse/ClickHouse/issues/31009)). * Remove redundant option `partial_merge_join_optimizations`. [#31528](https://github.com/ClickHouse/ClickHouse/pull/31528) ([Vladimir C](https://github.com/vdimir)).
* Fix invalid generated JSON when only column names contain invalid UTF-8 sequences. [#31534](https://github.com/ClickHouse/ClickHouse/pull/31534) ([Kevin Michel](https://github.com/kmichel-aiven)).
* All non-x86 builds were broken, because we don't have tests for them. This closes [#31417](https://github.com/ClickHouse/ClickHouse/issues/31417). This closes [#31524](https://github.com/ClickHouse/ClickHouse/issues/31524). [#31574](https://github.com/ClickHouse/ClickHouse/pull/31574) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix sparkbars are not aligned, see: [#26175](https://github.com/ClickHouse/ClickHouse/issues/26175)#issuecomment-960353867, [comment](https://github.com/ClickHouse/ClickHouse/issues/26175#issuecomment-961155065). [#31624](https://github.com/ClickHouse/ClickHouse/pull/31624) ([小路](https://github.com/nicelulu)).
* `RENAME TABLE` query worked incorrectly on attempt to rename an DDL dictionary in `Ordinary` database, it's fixed. [#31638](https://github.com/ClickHouse/ClickHouse/pull/31638) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed null pointer exception in `MATERIALIZE COLUMN`. [#31679](https://github.com/ClickHouse/ClickHouse/pull/31679) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Settings `input_format_allow_errors_num` and `input_format_allow_errors_ratio` did not work for parsing of domain types, such as `IPv4`, it's fixed. Fixes [#31686](https://github.com/ClickHouse/ClickHouse/issues/31686). [#31697](https://github.com/ClickHouse/ClickHouse/pull/31697) ([Alexander Tokmakov](https://github.com/tavplubix)).
* * Fixed function ngrams when string contains utf8 characters. [#31706](https://github.com/ClickHouse/ClickHouse/pull/31706) ([yandd](https://github.com/yandd)).
* Fix exception on some of the applications of `decrypt` function on Nullable columns. This closes [#31662](https://github.com/ClickHouse/ClickHouse/issues/31662). This closes [#31426](https://github.com/ClickHouse/ClickHouse/issues/31426). [#31707](https://github.com/ClickHouse/ClickHouse/pull/31707) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fixed `there are no such cluster here` error on execution of `ON CLUSTER` query if specified cluster name is name of `Replicated` database. [#31723](https://github.com/ClickHouse/ClickHouse/pull/31723) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix race in JSONEachRowWithProgress output format when data and lines with progress are mixed in output. [#31736](https://github.com/ClickHouse/ClickHouse/pull/31736) ([Kruglov Pavel](https://github.com/Avogar)).
* Fixed rare segfault on concurrent `ATTACH PARTITION` queries. [#31738](https://github.com/ClickHouse/ClickHouse/pull/31738) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix disabling query profiler (In case of `query_profiler_real_time_period_ns>0`/`query_profiler_cpu_time_period_ns>0` query profiler can stayed enabled even after query finished). [#31740](https://github.com/ClickHouse/ClickHouse/pull/31740) ([Azat Khuzhin](https://github.com/azat)).
* Fix group by / order by / limit by aliases with positional arguments enabled. Closes [#31173](https://github.com/ClickHouse/ClickHouse/issues/31173). [#31741](https://github.com/ClickHouse/ClickHouse/pull/31741) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix usage of `Buffer` table engine with type `Map`. Fixes [#30546](https://github.com/ClickHouse/ClickHouse/issues/30546). [#31742](https://github.com/ClickHouse/ClickHouse/pull/31742) ([Anton Popov](https://github.com/CurtizJ)).
* Fix crash with empty result on odbc query. Closes [#31465](https://github.com/ClickHouse/ClickHouse/issues/31465). [#31766](https://github.com/ClickHouse/ClickHouse/pull/31766) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix crash when function `dictGet` with type is used for dictionary attribute when type is `Nullable`. Fixes [#30980](https://github.com/ClickHouse/ClickHouse/issues/30980). [#31800](https://github.com/ClickHouse/ClickHouse/pull/31800) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix possible assertion `../src/IO/ReadBuffer.h:58: bool DB::ReadBuffer::next(): Assertion '!hasPendingData()' failed.` in TSKV format. [#31804](https://github.com/ClickHouse/ClickHouse/pull/31804) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix recursive user defined functions crash. Closes [#30856](https://github.com/ClickHouse/ClickHouse/issues/30856). [#31820](https://github.com/ClickHouse/ClickHouse/pull/31820) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix invalid cast of nullable type when nullable primary key is used. This fixes [#31075](https://github.com/ClickHouse/ClickHouse/issues/31075). [#31823](https://github.com/ClickHouse/ClickHouse/pull/31823) ([Amos Bird](https://github.com/amosbird)).
* Fix reading from `MergeTree` tables with enabled `use_uncompressed_cache`. [#31826](https://github.com/ClickHouse/ClickHouse/pull/31826) ([Anton Popov](https://github.com/CurtizJ)).
* Fix a bug about function transform with decimal args. [#31839](https://github.com/ClickHouse/ClickHouse/pull/31839) ([Shuai li](https://github.com/loneylee)).
* - Change configuration path from `keeper_server.session_timeout_ms` to `keeper_server.coordination_settings.session_timeout_ms` when constructing a `KeeperTCPHandler` - Same with `operation_timeout`. [#31859](https://github.com/ClickHouse/ClickHouse/pull/31859) ([JackyWoo](https://github.com/JackyWoo)).
* Fix functions `empty` and `notEmpty` with arguments of `UUID` type. Fixes [#31819](https://github.com/ClickHouse/ClickHouse/issues/31819). [#31883](https://github.com/ClickHouse/ClickHouse/pull/31883) ([Anton Popov](https://github.com/CurtizJ)).
* Some `GET_PART` entry might hang in replication queue if part is lost on all replicas and there are no other parts in the same partition. It's fixed in cases when partition key contains only columns of integer types or `Date[Time]`. Fixes [#31485](https://github.com/ClickHouse/ClickHouse/issues/31485). [#31887](https://github.com/ClickHouse/ClickHouse/pull/31887) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix FileLog engine unnesessary create meta data directory when create table failed. Fix [#31962](https://github.com/ClickHouse/ClickHouse/issues/31962). [#31967](https://github.com/ClickHouse/ClickHouse/pull/31967) ([flynn](https://github.com/ucasfl)).
* MaterializedMySQL: Fix rare corruption of DECIMAL data. [#31990](https://github.com/ClickHouse/ClickHouse/pull/31990) ([Håvard Kvålen](https://github.com/havardk)).
* Fixed `Directory ... already exists and is not empty` error when detaching part. [#32063](https://github.com/ClickHouse/ClickHouse/pull/32063) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix CREATE TABLE of Join Storage with multiply settings contains persistency. Close [#31680](https://github.com/ClickHouse/ClickHouse/issues/31680). [#32066](https://github.com/ClickHouse/ClickHouse/pull/32066) ([SuperDJY](https://github.com/cmsxbc)).
* Fix `CAST` from `Nullable` with `cast_keep_nullable` (`PARAMETER_OUT_OF_BOUND` error before for i.e. `toUInt32OrDefault(toNullable(toUInt32(1)))`). [#32080](https://github.com/ClickHouse/ClickHouse/pull/32080) ([Azat Khuzhin](https://github.com/azat)).
* Dictionaries fix cases when `{condition}` does not work for custom database queries. [#32117](https://github.com/ClickHouse/ClickHouse/pull/32117) ([Maksim Kita](https://github.com/kitaisreal)).
* Number of active replicas might be determined incorrectly when inserting with quorum if setting `replicated_can_become_leader` is disabled on some replicas. It's fixed. [#32157](https://github.com/ClickHouse/ClickHouse/pull/32157) ([Alexander Tokmakov](https://github.com/tavplubix)).
* XML dictionaries identifiers, used in table create query, can be qualified to `default_database` during upgrade to newer version. Closes [#31963](https://github.com/ClickHouse/ClickHouse/issues/31963). [#32187](https://github.com/ClickHouse/ClickHouse/pull/32187) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix parsing error while NaN deserializing for `Nullable(Float)` for `Quoted` escaping rule. [#32190](https://github.com/ClickHouse/ClickHouse/pull/32190) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix window view parser. [#32232](https://github.com/ClickHouse/ClickHouse/pull/32232) ([vxider](https://github.com/Vxider)).
* Server might fail to start with `Cannot attach 1 tables due to cyclic dependencies` error if `Dictionary` table looks at XML-dictionary with the same name, it's fixed. Fixes [#31315](https://github.com/ClickHouse/ClickHouse/issues/31315). [#32288](https://github.com/ClickHouse/ClickHouse/pull/32288) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed crash with SIGFPE in aggregate function `avgWeighted` with `Decimal` argument. Fixes [#32053](https://github.com/ClickHouse/ClickHouse/issues/32053). [#32303](https://github.com/ClickHouse/ClickHouse/pull/32303) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix `ALTER ... MATERIALIZE COLUMN ...` queries in case when data type of default expression is not equal to the data type of column. [#32348](https://github.com/ClickHouse/ClickHouse/pull/32348) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed the behavior when mutations that have nothing to do are stuck (with enabled setting `empty_result_for_aggregation_by_empty_set`). [#32358](https://github.com/ClickHouse/ClickHouse/pull/32358) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### Build

* support compile in arm machine with parameter "-DENABLE_TESTS=OFF". [#31007](https://github.com/ClickHouse/ClickHouse/pull/31007) ([zhanghuajie](https://github.com/zhanghuajieHIT)).

#### Improvement (changelog entry is not required)

* Make remote_filesystem_read_method=threadpool by default. [#31291](https://github.com/ClickHouse/ClickHouse/pull/31291) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Imrovement (changelog entry is not required)

* Rename setting value `read_threadpool` to `threadpool` for setting `remote_filesystem_read_method`. [#31224](https://github.com/ClickHouse/ClickHouse/pull/31224) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### NO CL ENTRY

* NO CL ENTRY:  'Update permissions-for-queries.md of cn'. [#30902](https://github.com/ClickHouse/ClickHouse/pull/30902) ([Laurie Li](https://github.com/laurieliyang)).
* NO CL ENTRY:  'Make use of untuple alias for untupled columns names prefix'. [#30984](https://github.com/ClickHouse/ClickHouse/pull/30984) ([qieqieplus](https://github.com/qieqieplus)).
* NO CL ENTRY:  'Add banner block for index,company,careers pages'. [#31647](https://github.com/ClickHouse/ClickHouse/pull/31647) ([Tom Risse](https://github.com/flickerbox-tom)).
* NO CL ENTRY:  'Revert "Fixed null pointer exception in `MATERIALIZE COLUMN`"'. [#31692](https://github.com/ClickHouse/ClickHouse/pull/31692) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Check time limit sending data for global in.'. [#31805](https://github.com/ClickHouse/ClickHouse/pull/31805) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Fix syntax error: drop comma'. [#32095](https://github.com/ClickHouse/ClickHouse/pull/32095) ([Federico Ceratto](https://github.com/FedericoCeratto)).
* NO CL ENTRY:  'Revert "Add a test with 20000 mutations in one query"'. [#32326](https://github.com/ClickHouse/ClickHouse/pull/32326) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Revert "Revert "Add a test with 20000 mutations in one query""'. [#32327](https://github.com/ClickHouse/ClickHouse/pull/32327) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Refactor pipeline executor [#19587](https://github.com/ClickHouse/ClickHouse/pull/19587) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Support NULLS FIRST in KeyCondition [#29528](https://github.com/ClickHouse/ClickHouse/pull/29528) ([DimasKovas](https://github.com/DimasKovas)).
* Integration test improvements [#29806](https://github.com/ClickHouse/ClickHouse/pull/29806) ([Ilya Yatsishin](https://github.com/qoega)).
* Do not allow zero-length reads [#30190](https://github.com/ClickHouse/ClickHouse/pull/30190) ([Azat Khuzhin](https://github.com/azat)).
* Fix test_backward_compatibility [#30950](https://github.com/ClickHouse/ClickHouse/pull/30950) ([Ilya Yatsishin](https://github.com/qoega)).
* Add stress test to github actions [#30952](https://github.com/ClickHouse/ClickHouse/pull/30952) ([alesapin](https://github.com/alesapin)).
* Try smaller blacklist of non parallel integration tests  [#30963](https://github.com/ClickHouse/ClickHouse/pull/30963) ([Ilya Yatsishin](https://github.com/qoega)).
* Fix flaky test [#30967](https://github.com/ClickHouse/ClickHouse/pull/30967) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Move access-rights source code [#30973](https://github.com/ClickHouse/ClickHouse/pull/30973) ([Vitaly Baranov](https://github.com/vitlibar)).
* Set output_format_avro_rows_in_file default to 1 [#30990](https://github.com/ClickHouse/ClickHouse/pull/30990) ([Kruglov Pavel](https://github.com/Avogar)).
* Remove remaining usages of Y_IGNORE [#30993](https://github.com/ClickHouse/ClickHouse/pull/30993) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Return back accidentally removed code [#30996](https://github.com/ClickHouse/ClickHouse/pull/30996) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Rename AccessControlManager [#30998](https://github.com/ClickHouse/ClickHouse/pull/30998) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add fuzzer check to actions [#31002](https://github.com/ClickHouse/ClickHouse/pull/31002) ([alesapin](https://github.com/alesapin)).
* Small refactoring in formats [#31004](https://github.com/ClickHouse/ClickHouse/pull/31004) ([Kruglov Pavel](https://github.com/Avogar)).
* Changelog for version 21.11 [#31014](https://github.com/ClickHouse/ClickHouse/pull/31014) ([Rich Raposa](https://github.com/rfraposa)).
* perf: add missing DROP TABLE queries [#31028](https://github.com/ClickHouse/ClickHouse/pull/31028) ([Azat Khuzhin](https://github.com/azat)).
* Tune perf tests configs/scripts [#31029](https://github.com/ClickHouse/ClickHouse/pull/31029) ([Azat Khuzhin](https://github.com/azat)).
* Remove metric_log/part_log overrides in tests (enabled by default) [#31030](https://github.com/ClickHouse/ClickHouse/pull/31030) ([Azat Khuzhin](https://github.com/azat)).
* improve error message while using OFFSET FETCH clause without ORDER BY [#31031](https://github.com/ClickHouse/ClickHouse/pull/31031) ([SuperDJY](https://github.com/cmsxbc)).
* Log size of remapped memory (remap_executable) [#31033](https://github.com/ClickHouse/ClickHouse/pull/31033) ([Azat Khuzhin](https://github.com/azat)).
* Separate option for enabling fuse syntax for sum, avg, count [#31035](https://github.com/ClickHouse/ClickHouse/pull/31035) ([Vladimir C](https://github.com/vdimir)).
* Add integration test on top of github actions [#31045](https://github.com/ClickHouse/ClickHouse/pull/31045) ([alesapin](https://github.com/alesapin)).
* Fix intersecting parts in `parts_to_do` 2 [#31060](https://github.com/ClickHouse/ClickHouse/pull/31060) ([Alexander Tokmakov](https://github.com/tavplubix)).
* perf: switch *_log tables to Memory engine (attempt to reduce cache misses) [#31063](https://github.com/ClickHouse/ClickHouse/pull/31063) ([Azat Khuzhin](https://github.com/azat)).
* Add new employee photos to team [#31084](https://github.com/ClickHouse/ClickHouse/pull/31084) ([Cody Baker](https://github.com/codyrobert)).
* Update button widths for responsive sizing [#31085](https://github.com/ClickHouse/ClickHouse/pull/31085) ([Cody Baker](https://github.com/codyrobert)).
* Add overflow to benchmark tables [#31086](https://github.com/ClickHouse/ClickHouse/pull/31086) ([Cody Baker](https://github.com/codyrobert)).
* Remove padding below greenhouse iframe [#31087](https://github.com/ClickHouse/ClickHouse/pull/31087) ([Cody Baker](https://github.com/codyrobert)).
* Crb update case study cards [#31088](https://github.com/ClickHouse/ClickHouse/pull/31088) ([Cody Baker](https://github.com/codyrobert)).
* Fix threadpool read for remote disks [#31112](https://github.com/ClickHouse/ClickHouse/pull/31112) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Doc build: remove single.md [#31118](https://github.com/ClickHouse/ClickHouse/pull/31118) ([lehasm](https://github.com/lehasm)).
* remove unnecessary assert in StorageFileLog [#31119](https://github.com/ClickHouse/ClickHouse/pull/31119) ([nauta](https://github.com/nautaa)).
* Add lambda  for approve [#31139](https://github.com/ClickHouse/ClickHouse/pull/31139) ([alesapin](https://github.com/alesapin)).
* Do not include unnecessary experimental/type_traits [#31147](https://github.com/ClickHouse/ClickHouse/pull/31147) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Disable optimize_syntax_fuse_functions by default [#31149](https://github.com/ClickHouse/ClickHouse/pull/31149) ([Vladimir C](https://github.com/vdimir)).
* Add pvs studio to actions [#31156](https://github.com/ClickHouse/ClickHouse/pull/31156) ([alesapin](https://github.com/alesapin)).
* Add cherry-pick on github actions [#31158](https://github.com/ClickHouse/ClickHouse/pull/31158) ([alesapin](https://github.com/alesapin)).
* correct disk space calculations [#31159](https://github.com/ClickHouse/ClickHouse/pull/31159) ([Alexandre Snarskii](https://github.com/snar)).
* Fix typo [#31164](https://github.com/ClickHouse/ClickHouse/pull/31164) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update text on thank you page [#31166](https://github.com/ClickHouse/ClickHouse/pull/31166) ([Cody Baker](https://github.com/codyrobert)).
* Add unit tests to CI [#31175](https://github.com/ClickHouse/ClickHouse/pull/31175) ([alesapin](https://github.com/alesapin)).
* Debug cherry-pick CI [#31177](https://github.com/ClickHouse/ClickHouse/pull/31177) ([alesapin](https://github.com/alesapin)).
* Update docker_compose_postgres.yml [#31179](https://github.com/ClickHouse/ClickHouse/pull/31179) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix integration tests [#31223](https://github.com/ClickHouse/ClickHouse/pull/31223) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Relax test 02026_storage_filelog_largefile.sh  [#31225](https://github.com/ClickHouse/ClickHouse/pull/31225) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix typo in USE_MYSQL check [#31226](https://github.com/ClickHouse/ClickHouse/pull/31226) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Download ccache if not exists in builds [#31227](https://github.com/ClickHouse/ClickHouse/pull/31227) ([alesapin](https://github.com/alesapin)).
* Disable fuzzer builds in CI [#31244](https://github.com/ClickHouse/ClickHouse/pull/31244) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add flaky check to new CI [#31248](https://github.com/ClickHouse/ClickHouse/pull/31248) ([alesapin](https://github.com/alesapin)).
* Fix test [#31250](https://github.com/ClickHouse/ClickHouse/pull/31250) ([Kseniia Sumarokova](https://github.com/kssenii)).
* move InputCreatorFunc to InputCreator [#31258](https://github.com/ClickHouse/ClickHouse/pull/31258) ([Alex Cao](https://github.com/cccgp)).
* Print warning during old directories cleanup in MergeTree only if it is old [#31259](https://github.com/ClickHouse/ClickHouse/pull/31259) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup extern ProfileEvents/CurrentMetrics and add a style check [#31260](https://github.com/ClickHouse/ClickHouse/pull/31260) ([Azat Khuzhin](https://github.com/azat)).
* Fix and refactor WriteBiffer-s a little [#31265](https://github.com/ClickHouse/ClickHouse/pull/31265) ([Kruglov Pavel](https://github.com/Avogar)).
* Followup to ccache build [#31287](https://github.com/ClickHouse/ClickHouse/pull/31287) ([alesapin](https://github.com/alesapin)).
* Add compatibility check [#31294](https://github.com/ClickHouse/ClickHouse/pull/31294) ([alesapin](https://github.com/alesapin)).
* Add assertions to ZooKeeperLock [#31295](https://github.com/ClickHouse/ClickHouse/pull/31295) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add split build check [#31299](https://github.com/ClickHouse/ClickHouse/pull/31299) ([alesapin](https://github.com/alesapin)).
* Remove strange code from mutations [#31300](https://github.com/ClickHouse/ClickHouse/pull/31300) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Disable integration tests in new CI [#31301](https://github.com/ClickHouse/ClickHouse/pull/31301) ([alesapin](https://github.com/alesapin)).
* Merging [#31081](https://github.com/ClickHouse/ClickHouse/issues/31081) [#31305](https://github.com/ClickHouse/ClickHouse/pull/31305) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Debug rabbitmq tests [#31316](https://github.com/ClickHouse/ClickHouse/pull/31316) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible data-race in case of query cancellation with async_socket_for_remote [#31317](https://github.com/ClickHouse/ClickHouse/pull/31317) ([Azat Khuzhin](https://github.com/azat)).
* Improve fuzzer report in case of fuzzer killed [#31324](https://github.com/ClickHouse/ClickHouse/pull/31324) ([Azat Khuzhin](https://github.com/azat)).
* Fix check in async buffer [#31325](https://github.com/ClickHouse/ClickHouse/pull/31325) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add Blog Post for 21.11 Release Update [#31326](https://github.com/ClickHouse/ClickHouse/pull/31326) ([Cody Baker](https://github.com/codyrobert)).
* Add blog post for Moscow meetup [#31327](https://github.com/ClickHouse/ClickHouse/pull/31327) ([Cody Baker](https://github.com/codyrobert)).
* Do not try to resolve temporary tables from global context [#31333](https://github.com/ClickHouse/ClickHouse/pull/31333) ([Azat Khuzhin](https://github.com/azat)).
* BloomFilter index check fix [#31334](https://github.com/ClickHouse/ClickHouse/pull/31334) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove some copypaste from CI [#31340](https://github.com/ClickHouse/ClickHouse/pull/31340) ([alesapin](https://github.com/alesapin)).
* Fix test_kafka_insert_avro by pinning avro version [#31387](https://github.com/ClickHouse/ClickHouse/pull/31387) ([Azat Khuzhin](https://github.com/azat)).
* Fix QueryScope in MaterializedMySQLSyncThread [#31392](https://github.com/ClickHouse/ClickHouse/pull/31392) ([Azat Khuzhin](https://github.com/azat)).
* Check stderr is writable before reopining it (to avoid losing errors) [#31393](https://github.com/ClickHouse/ClickHouse/pull/31393) ([Azat Khuzhin](https://github.com/azat)).
* Remove thread_local std::string [#31400](https://github.com/ClickHouse/ClickHouse/pull/31400) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix client [#31403](https://github.com/ClickHouse/ClickHouse/pull/31403) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove excessive debug info from the log message in DDLWorker [#31406](https://github.com/ClickHouse/ClickHouse/pull/31406) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Turn on more CI checks [#31413](https://github.com/ClickHouse/ClickHouse/pull/31413) ([alesapin](https://github.com/alesapin)).
* Update description for webinar calendar links [#31433](https://github.com/ClickHouse/ClickHouse/pull/31433) ([Cody Baker](https://github.com/codyrobert)).
* Trying to debug integration tests [#31443](https://github.com/ClickHouse/ClickHouse/pull/31443) ([alesapin](https://github.com/alesapin)).
* Try increase `snapshot_distance` for functional tests [#31448](https://github.com/ClickHouse/ClickHouse/pull/31448) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Minor improvement for test_replicated_fetches_bandwidth [#31451](https://github.com/ClickHouse/ClickHouse/pull/31451) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Merging [#18787](https://github.com/ClickHouse/ClickHouse/issues/18787) (Constraints) [#31476](https://github.com/ClickHouse/ClickHouse/pull/31476) ([Anton Popov](https://github.com/CurtizJ)).
* Crb support page [#31490](https://github.com/ClickHouse/ClickHouse/pull/31490) ([Cody Baker](https://github.com/codyrobert)).
* Add new team members to company page [#31491](https://github.com/ClickHouse/ClickHouse/pull/31491) ([Cody Baker](https://github.com/codyrobert)).
* [ci] whitelist codyrobert [#31492](https://github.com/ClickHouse/ClickHouse/pull/31492) ([Ivan Blinkov](https://github.com/blinkov)).
* Reapply style changes to hardware page [#31506](https://github.com/ClickHouse/ClickHouse/pull/31506) ([Cody Baker](https://github.com/codyrobert)).
* Split row policy and quota headers [#31509](https://github.com/ClickHouse/ClickHouse/pull/31509) ([Vitaly Baranov](https://github.com/vitlibar)).
* Do not clean iptables rules in session-scope fixture [#31527](https://github.com/ClickHouse/ClickHouse/pull/31527) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Push tests results to CI database [#31540](https://github.com/ClickHouse/ClickHouse/pull/31540) ([alesapin](https://github.com/alesapin)).
* Remove strange multimap for mutations in StorageMergeTree [#31542](https://github.com/ClickHouse/ClickHouse/pull/31542) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove duplicated not compressed logs from CI (actions) [#31544](https://github.com/ClickHouse/ClickHouse/pull/31544) ([Azat Khuzhin](https://github.com/azat)).
* Fix 02010_lc_native flakiness (Query with id = 123456 is already running) [#31556](https://github.com/ClickHouse/ClickHouse/pull/31556) ([Azat Khuzhin](https://github.com/azat)).
* Make 01114_database_atomic more stable in debug builds [#31564](https://github.com/ClickHouse/ClickHouse/pull/31564) ([Azat Khuzhin](https://github.com/azat)).
* Fix MySQLWire format (this will also fix performance tests) [#31565](https://github.com/ClickHouse/ClickHouse/pull/31565) ([Azat Khuzhin](https://github.com/azat)).
* get Build ID via Section headers first [#31566](https://github.com/ClickHouse/ClickHouse/pull/31566) ([Ilya Golshtein](https://github.com/ilejn)).
* Try to debug expired sessions [#31584](https://github.com/ClickHouse/ClickHouse/pull/31584) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix cleanup in integration tests [#31605](https://github.com/ClickHouse/ClickHouse/pull/31605) ([Vitaly Baranov](https://github.com/vitlibar)).
* Stop all periodic reloading of all the configuration files on shutdown earlier [#31607](https://github.com/ClickHouse/ClickHouse/pull/31607) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix build requirements for unit tests [#31617](https://github.com/ClickHouse/ClickHouse/pull/31617) ([alesapin](https://github.com/alesapin)).
* Add workflow run for release branches [#31618](https://github.com/ClickHouse/ClickHouse/pull/31618) ([alesapin](https://github.com/alesapin)).
* Other event for release PR [#31619](https://github.com/ClickHouse/ClickHouse/pull/31619) ([alesapin](https://github.com/alesapin)).
* Trying push event again [#31623](https://github.com/ClickHouse/ClickHouse/pull/31623) ([alesapin](https://github.com/alesapin)).
* Add github actions for master [#31629](https://github.com/ClickHouse/ClickHouse/pull/31629) ([alesapin](https://github.com/alesapin)).
* Fix master yml [#31630](https://github.com/ClickHouse/ClickHouse/pull/31630) ([alesapin](https://github.com/alesapin)).
* fix kerberized_hadoop image [#31637](https://github.com/ClickHouse/ClickHouse/pull/31637) ([Constantine Peresypkin](https://github.com/pkit)).
* [ci] add flickerbox-tom to whitelist [#31651](https://github.com/ClickHouse/ClickHouse/pull/31651) ([Ivan Blinkov](https://github.com/blinkov)).
* Try to fix possible data race in RemoteQueryExecutorReadContext [#31652](https://github.com/ClickHouse/ClickHouse/pull/31652) ([Kruglov Pavel](https://github.com/Avogar)).
* Integration tests flaky check and small fixes [#31654](https://github.com/ClickHouse/ClickHouse/pull/31654) ([alesapin](https://github.com/alesapin)).
* Update base64 library [#31677](https://github.com/ClickHouse/ClickHouse/pull/31677) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* fix typo [#31678](https://github.com/ClickHouse/ClickHouse/pull/31678) ([flynn](https://github.com/ucasfl)).
* Try fix OOMs with TSAN [#31685](https://github.com/ClickHouse/ClickHouse/pull/31685) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix workflow in master [#31688](https://github.com/ClickHouse/ClickHouse/pull/31688) ([alesapin](https://github.com/alesapin)).
* Add perf test for writing valid UTF8 [#31695](https://github.com/ClickHouse/ClickHouse/pull/31695) ([Kruglov Pavel](https://github.com/Avogar)).
* hdfs disable stderr logging [#31703](https://github.com/ClickHouse/ClickHouse/pull/31703) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible Logical error: Cannot write to finalized buffer [#31712](https://github.com/ClickHouse/ClickHouse/pull/31712) ([Kruglov Pavel](https://github.com/Avogar)).
* 02050: Use CLICKHOUSE_TMP and delete files when finished [#31713](https://github.com/ClickHouse/ClickHouse/pull/31713) ([Raúl Marín](https://github.com/Algunenano)).
* Make 02112_with_fill_interval independent of the server timezone [#31714](https://github.com/ClickHouse/ClickHouse/pull/31714) ([Raúl Marín](https://github.com/Algunenano)).
* 02010_lc_native: Generate a new id for each query [#31720](https://github.com/ClickHouse/ClickHouse/pull/31720) ([Raúl Marín](https://github.com/Algunenano)).
* 00623_replicated_truncate_table_zookeeper_long: Wait for truncate in replicas [#31721](https://github.com/ClickHouse/ClickHouse/pull/31721) ([Raúl Marín](https://github.com/Algunenano)).
* Try to push data into another ci database. [#31724](https://github.com/ClickHouse/ClickHouse/pull/31724) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove OpenCL completely [#31744](https://github.com/ClickHouse/ClickHouse/pull/31744) ([Timur Magomedov](https://github.com/tmagomedov)).
* Fix diff for backports. [#31765](https://github.com/ClickHouse/ClickHouse/pull/31765) ([alesapin](https://github.com/alesapin)).
* Fail fasttest, builds and functional checks if some tests was not successful [#31767](https://github.com/ClickHouse/ClickHouse/pull/31767) ([alesapin](https://github.com/alesapin)).
* Improve how queries are output in the performance dashboard [#31780](https://github.com/ClickHouse/ClickHouse/pull/31780) ([Raúl Marín](https://github.com/Algunenano)).
* Use version from git describe in builds [#31782](https://github.com/ClickHouse/ClickHouse/pull/31782) ([alesapin](https://github.com/alesapin)).
* Fix stylecheck for tests/ci/push_to_artifactory.py [#31798](https://github.com/ClickHouse/ClickHouse/pull/31798) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Shorter stress and fuzzer tests [#31803](https://github.com/ClickHouse/ClickHouse/pull/31803) ([alesapin](https://github.com/alesapin)).
* Fix oss-fuzz build [#31818](https://github.com/ClickHouse/ClickHouse/pull/31818) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix check in approve lambda [#31821](https://github.com/ClickHouse/ClickHouse/pull/31821) ([alesapin](https://github.com/alesapin)).
* Cover query_views_log [#31825](https://github.com/ClickHouse/ClickHouse/pull/31825) ([Azat Khuzhin](https://github.com/azat)).
* Forbid files that differ only by character case [#31834](https://github.com/ClickHouse/ClickHouse/pull/31834) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added ubsan suppression for libprotobuf-mutator [#31835](https://github.com/ClickHouse/ClickHouse/pull/31835) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Update 01155_rename_move_materialized_view.sql [#31849](https://github.com/ClickHouse/ClickHouse/pull/31849) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix style. [#31850](https://github.com/ClickHouse/ClickHouse/pull/31850) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Minor improvements to DUMP macro [#31858](https://github.com/ClickHouse/ClickHouse/pull/31858) ([Vasily Nemkov](https://github.com/Enmk)).
* Get rid of build numbers and simplify builds paths in S3 [#31861](https://github.com/ClickHouse/ClickHouse/pull/31861) ([alesapin](https://github.com/alesapin)).
* Support toUInt8/toInt8 for if constant condition optimization. [#31866](https://github.com/ClickHouse/ClickHouse/pull/31866) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Added -no-sanitize=unsigned-integer-overflow build flag [#31881](https://github.com/ClickHouse/ClickHouse/pull/31881) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix typos [#31886](https://github.com/ClickHouse/ClickHouse/pull/31886) ([Anton Popov](https://github.com/CurtizJ)).
* Try to fix flaky test. [#31889](https://github.com/ClickHouse/ClickHouse/pull/31889) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Reduce the files that depend on parser headers [#31896](https://github.com/ClickHouse/ClickHouse/pull/31896) ([Raúl Marín](https://github.com/Algunenano)).
* Fix magic_enum for debug helpers (fixes build w/ USE_DEBUG_HELPERS) [#31922](https://github.com/ClickHouse/ClickHouse/pull/31922) ([Azat Khuzhin](https://github.com/azat)).
* Remove some trash from build [#31923](https://github.com/ClickHouse/ClickHouse/pull/31923) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add json type to changes in documentation [#31926](https://github.com/ClickHouse/ClickHouse/pull/31926) ([alesapin](https://github.com/alesapin)).
* fix some broken links [#31948](https://github.com/ClickHouse/ClickHouse/pull/31948) ([Ramazan Polat](https://github.com/ramazanpolat)).
* Kill container in integration tests if it's already running [#31950](https://github.com/ClickHouse/ClickHouse/pull/31950) ([alesapin](https://github.com/alesapin)).
* Drop libc-headers [#31951](https://github.com/ClickHouse/ClickHouse/pull/31951) ([Raúl Marín](https://github.com/Algunenano)).
* Give some love to macOS platform [#31957](https://github.com/ClickHouse/ClickHouse/pull/31957) ([Denis Glazachev](https://github.com/traceon)).
* Fix segfault in MaterializedMySQL [#31960](https://github.com/ClickHouse/ClickHouse/pull/31960) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix docs check [#31980](https://github.com/ClickHouse/ClickHouse/pull/31980) ([alesapin](https://github.com/alesapin)).
* Make stress tests slightly more stable [#31985](https://github.com/ClickHouse/ClickHouse/pull/31985) ([alesapin](https://github.com/alesapin)).
* Add rest functional tests to CI [#31987](https://github.com/ClickHouse/ClickHouse/pull/31987) ([alesapin](https://github.com/alesapin)).
* Add special builds to CI [#31991](https://github.com/ClickHouse/ClickHouse/pull/31991) ([alesapin](https://github.com/alesapin)).
* Run less tests for backport branches [#31992](https://github.com/ClickHouse/ClickHouse/pull/31992) ([alesapin](https://github.com/alesapin)).
* Fix race in ParallelFormattingOutputFormat constructor [#32004](https://github.com/ClickHouse/ClickHouse/pull/32004) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix build on master [#32009](https://github.com/ClickHouse/ClickHouse/pull/32009) ([alesapin](https://github.com/alesapin)).
* Fix style-check for ProfileEvents checking [#32033](https://github.com/ClickHouse/ClickHouse/pull/32033) ([Azat Khuzhin](https://github.com/azat)).
* Provide clickhouse binary w/o debug symbols (stripped) in fasttest [#32036](https://github.com/ClickHouse/ClickHouse/pull/32036) ([Azat Khuzhin](https://github.com/azat)).
* Minor fixes for `StorageMergeTree` [#32037](https://github.com/ClickHouse/ClickHouse/pull/32037) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Remove most of old checks [#32041](https://github.com/ClickHouse/ClickHouse/pull/32041) ([alesapin](https://github.com/alesapin)).
* Remove fast test from master [#32042](https://github.com/ClickHouse/ClickHouse/pull/32042) ([alesapin](https://github.com/alesapin)).
* Better scripts for runners [#32043](https://github.com/ClickHouse/ClickHouse/pull/32043) ([alesapin](https://github.com/alesapin)).
* Fix force tests label [#32044](https://github.com/ClickHouse/ClickHouse/pull/32044) ([alesapin](https://github.com/alesapin)).
* Don't run checks for label event [#32046](https://github.com/ClickHouse/ClickHouse/pull/32046) ([alesapin](https://github.com/alesapin)).
* Fix flaky test 00925 [#32050](https://github.com/ClickHouse/ClickHouse/pull/32050) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Cancel redundant checks with lambda [#32051](https://github.com/ClickHouse/ClickHouse/pull/32051) ([alesapin](https://github.com/alesapin)).
* Fix flaky integration test for MaterializedMySQL CREATE TABLE LIKE [#32052](https://github.com/ClickHouse/ClickHouse/pull/32052) ([Stig Bakken](https://github.com/stigsb)).
* Use functional test group for tests with thread sanitizer [#32062](https://github.com/ClickHouse/ClickHouse/pull/32062) ([alesapin](https://github.com/alesapin)).
* Add ability for lightweight checks rerun [#32064](https://github.com/ClickHouse/ClickHouse/pull/32064) ([alesapin](https://github.com/alesapin)).
* Increase length of random database in clickhouse-test [#32094](https://github.com/ClickHouse/ClickHouse/pull/32094) ([Azat Khuzhin](https://github.com/azat)).
* make looping in H3 funcs uniform [#32110](https://github.com/ClickHouse/ClickHouse/pull/32110) ([Bharat Nallan](https://github.com/bharatnc)).
* Remove PVS check from master [#32114](https://github.com/ClickHouse/ClickHouse/pull/32114) ([alesapin](https://github.com/alesapin)).
* Fix flaky keeper whitelist test [#32115](https://github.com/ClickHouse/ClickHouse/pull/32115) ([alesapin](https://github.com/alesapin)).
* Fix flaky test test_executable_storage_input [#32118](https://github.com/ClickHouse/ClickHouse/pull/32118) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix data race in `removePartAndEnqueueFetch(...)` [#32119](https://github.com/ClickHouse/ClickHouse/pull/32119) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Move fuzzers and unit tests to another group [#32120](https://github.com/ClickHouse/ClickHouse/pull/32120) ([alesapin](https://github.com/alesapin)).
* Add a test with 20000 mutations in one query [#32122](https://github.com/ClickHouse/ClickHouse/pull/32122) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Change test 02117_custom_separated_with_names_and_types [#32123](https://github.com/ClickHouse/ClickHouse/pull/32123) ([Kruglov Pavel](https://github.com/Avogar)).
* Use seq_cst semantic for MergeTreeBackgroundExecutor mertic. [#32125](https://github.com/ClickHouse/ClickHouse/pull/32125) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove 02116_global_in_time_limit. [#32126](https://github.com/ClickHouse/ClickHouse/pull/32126) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* fixing postgres tests [#32129](https://github.com/ClickHouse/ClickHouse/pull/32129) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Small improvements in lambda code [#32155](https://github.com/ClickHouse/ClickHouse/pull/32155) ([alesapin](https://github.com/alesapin)).
* Update featured image for 21.11 release blog post [#32156](https://github.com/ClickHouse/ClickHouse/pull/32156) ([Cody Baker](https://github.com/codyrobert)).
* Fix CI [#32159](https://github.com/ClickHouse/ClickHouse/pull/32159) ([alesapin](https://github.com/alesapin)).
* tests/ci: do not compress logs twice [#32162](https://github.com/ClickHouse/ClickHouse/pull/32162) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test: do not use random generator with shared state [#32163](https://github.com/ClickHouse/ClickHouse/pull/32163) ([Azat Khuzhin](https://github.com/azat)).
* Fix stress tests [#32164](https://github.com/ClickHouse/ClickHouse/pull/32164) ([Azat Khuzhin](https://github.com/azat)).
* Fix QueryProfiler (query_profiler_{cpu,real}_time_period_ns) reset [#32165](https://github.com/ClickHouse/ClickHouse/pull/32165) ([Azat Khuzhin](https://github.com/azat)).
* MaterializedMySQL support VARBINARY type [#32173](https://github.com/ClickHouse/ClickHouse/pull/32173) ([zzsmdfj](https://github.com/zzsmdfj)).
* perf: fix waiting of the server after running tests [#32174](https://github.com/ClickHouse/ClickHouse/pull/32174) ([Azat Khuzhin](https://github.com/azat)).
* Better output for some actions [#32175](https://github.com/ClickHouse/ClickHouse/pull/32175) ([alesapin](https://github.com/alesapin)).
* Use ccache in fast test [#32177](https://github.com/ClickHouse/ClickHouse/pull/32177) ([alesapin](https://github.com/alesapin)).
* Fix window view tests [#32178](https://github.com/ClickHouse/ClickHouse/pull/32178) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Function accurateCastOrDefault remove separate branch [#32184](https://github.com/ClickHouse/ClickHouse/pull/32184) ([Maksim Kita](https://github.com/kitaisreal)).
* Add test for [#32186](https://github.com/ClickHouse/ClickHouse/issues/32186) [#32203](https://github.com/ClickHouse/ClickHouse/pull/32203) ([Raúl Marín](https://github.com/Algunenano)).
* Fix uncaught exception in DatabaseLazy [#32206](https://github.com/ClickHouse/ClickHouse/pull/32206) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Update ASTCreateQuery.cpp [#32208](https://github.com/ClickHouse/ClickHouse/pull/32208) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix flaky fileLog test (probably) [#32209](https://github.com/ClickHouse/ClickHouse/pull/32209) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix jemalloc under osx [#32219](https://github.com/ClickHouse/ClickHouse/pull/32219) ([Azat Khuzhin](https://github.com/azat)).
* Add missing timezones to some tests [#32222](https://github.com/ClickHouse/ClickHouse/pull/32222) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix versioning of aggregate functions (fixes performance tests) [#32236](https://github.com/ClickHouse/ClickHouse/pull/32236) ([Azat Khuzhin](https://github.com/azat)).
* Disable window view tests temporarily because still flaky [#32257](https://github.com/ClickHouse/ClickHouse/pull/32257) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix typo in tupleToNameValuePairs doc [#32262](https://github.com/ClickHouse/ClickHouse/pull/32262) ([Vladimir C](https://github.com/vdimir)).
* Fix possible Pipeline stuck in case of StrictResize processor. [#32270](https://github.com/ClickHouse/ClickHouse/pull/32270) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible crash in DataTypeAggregateFunction [#32287](https://github.com/ClickHouse/ClickHouse/pull/32287) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Update backport.py [#32323](https://github.com/ClickHouse/ClickHouse/pull/32323) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix graphite-bench build [#32351](https://github.com/ClickHouse/ClickHouse/pull/32351) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Revert "graphite: split tagged/plain rollup rules (for merges perfoma... [#32376](https://github.com/ClickHouse/ClickHouse/pull/32376) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Another attempt to fix unit test Executor::RemoveTasksStress [#32390](https://github.com/ClickHouse/ClickHouse/pull/32390) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
