---
sidebar_position: 1
sidebar_label: 2022
---

# 2022 Changelog

### ClickHouse release v21.11.1.8636-prestable FIXME as compared to v21.10.1.8013-prestable

#### Backward Incompatible Change
* Now ClickHouse Keeper snapshots compressed with `ZSTD` codec by default instead of custom ClickHouse LZ4 block compression. This behavior can be turned off with `compress_snapshots_with_zstd_format` coordination setting (must be equal on all quorum replicas). Backward incompatibility is quite rare and may happen only when new node will send snapshot (happens in case of recovery) to the old node which is unable to read snapshots in ZSTD format. [#29417](https://github.com/ClickHouse/ClickHouse/pull/29417) ([alesapin](https://github.com/alesapin)).
* Function `bayesAB` is removed. This closes [#26233](https://github.com/ClickHouse/ClickHouse/issues/26233). [#29934](https://github.com/ClickHouse/ClickHouse/pull/29934) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove MergeTree table setting `write_final_mark`. It will be always `true`. [#30455](https://github.com/ClickHouse/ClickHouse/pull/30455) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Change order of json_path and json in sql json function (to be correct). Closes [#30449](https://github.com/ClickHouse/ClickHouse/issues/30449). [#30474](https://github.com/ClickHouse/ClickHouse/pull/30474) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove setting odbc_max_field_size because it is not used anymore. Closes [#30413](https://github.com/ClickHouse/ClickHouse/issues/30413). [#30778](https://github.com/ClickHouse/ClickHouse/pull/30778) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### New Feature
* Add CapnProto output format, refactor CapnProto input format. [#29291](https://github.com/ClickHouse/ClickHouse/pull/29291) ([Kruglov Pavel](https://github.com/Avogar)).
* clickhouse-format support option `--query`. [#29325](https://github.com/ClickHouse/ClickHouse/pull/29325) ([凌涛](https://github.com/lingtaolf)).
* Users now can set comments to database in `CREATE DATABASE` statement ... [#29429](https://github.com/ClickHouse/ClickHouse/pull/29429) ([Vasily Nemkov](https://github.com/Enmk)).
* New function` mapContainsKeyLike` to get the map that key matches a simple regular expression. [#29471](https://github.com/ClickHouse/ClickHouse/pull/29471) ([凌涛](https://github.com/lingtaolf)).
* Huawei OBS Storage support. Closes [#24294](https://github.com/ClickHouse/ClickHouse/issues/24294). [#29511](https://github.com/ClickHouse/ClickHouse/pull/29511) ([kevin wan](https://github.com/MaxWk)).
* Clickhouse HTTP Server can enable HSTS by set `hsts_max_age` in config.xml with a positive number. [#29516](https://github.com/ClickHouse/ClickHouse/pull/29516) ([凌涛](https://github.com/lingtaolf)).
* - Added MD4 and SHA384 functions. [#29602](https://github.com/ClickHouse/ClickHouse/pull/29602) ([Nikita Tikhomirov](https://github.com/NSTikhomirov)).
* Support EXISTS(subquery). Closes [#6852](https://github.com/ClickHouse/ClickHouse/issues/6852). [#29731](https://github.com/ClickHouse/ClickHouse/pull/29731) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added function `ngram`. Closes [#29699](https://github.com/ClickHouse/ClickHouse/issues/29699). [#29738](https://github.com/ClickHouse/ClickHouse/pull/29738) ([Maksim Kita](https://github.com/kitaisreal)).
* Returns String with OS Kernel version. [#29755](https://github.com/ClickHouse/ClickHouse/pull/29755) ([Memo](https://github.com/Joeywzr)).
* Predefined configuration for table function remote. Closes [#29756](https://github.com/ClickHouse/ClickHouse/issues/29756). [#29774](https://github.com/ClickHouse/ClickHouse/pull/29774) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add `table` alias to system.tables and `database` alias to system.databases [#29677](https://github.com/ClickHouse/ClickHouse/issues/29677). [#29882](https://github.com/ClickHouse/ClickHouse/pull/29882) ([kevin wan](https://github.com/MaxWk)).
* Added columns `data_compressed_bytes`, `data_uncompressed_bytes`, `marks_bytes` into `system.data_skipping_indices`. Added columns `secondary_indices_compressed_bytes`, `secondary_indices_uncompressed_bytes`, `secondary_indices_marks_bytes` into `system.parts`. Closes [#29697](https://github.com/ClickHouse/ClickHouse/issues/29697). [#29896](https://github.com/ClickHouse/ClickHouse/pull/29896) ([Maksim Kita](https://github.com/kitaisreal)).
* User can now create dictionaries with comments: `CREATE DICTIONARY ... COMMENT 'vaue'` ... [#29899](https://github.com/ClickHouse/ClickHouse/pull/29899) ([Vasily Nemkov](https://github.com/Enmk)).
* Add support for FreeBSD aarch64. [#29952](https://github.com/ClickHouse/ClickHouse/pull/29952) ([MikaelUrankar](https://github.com/MikaelUrankar)).
* Added function `tokens`. That allow to split string into tokens using non-alpha numeric ASCII characters as separators. [#29981](https://github.com/ClickHouse/ClickHouse/pull/29981) ([Maksim Kita](https://github.com/kitaisreal)).
* Added new JSONExtractKeys function ... [#30056](https://github.com/ClickHouse/ClickHouse/pull/30056) ([Vitaly Orlov](https://github.com/orloffv)).
* Added `HashedArray` dictionary type. Closes [#30236](https://github.com/ClickHouse/ClickHouse/issues/30236). [#30242](https://github.com/ClickHouse/ClickHouse/pull/30242) ([Maksim Kita](https://github.com/kitaisreal)).
* Add ability to change nodes configuration (in `.xml` file) for ClickHouse Keeper. [#30372](https://github.com/ClickHouse/ClickHouse/pull/30372) ([alesapin](https://github.com/alesapin)).
* CompiledExpressionCache limit elements size using `compiled_expression_cache_elements_size` setting. [#30667](https://github.com/ClickHouse/ClickHouse/pull/30667) ([Maksim Kita](https://github.com/kitaisreal)).
* New function `mapExtractKeyLike` to get the map only kept elements matched specified pattern. [#30793](https://github.com/ClickHouse/ClickHouse/pull/30793) ([凌涛](https://github.com/lingtaolf)).
* Support `ALTER TABLE` for tables in `Memory` databases. [#30866](https://github.com/ClickHouse/ClickHouse/pull/30866) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### Performance Improvement
* * Remove branchy code in filter operation with a better implementation with popcnt/ctz which have better performance. [#29881](https://github.com/ClickHouse/ClickHouse/pull/29881) ([Jun Jin](https://github.com/vesslanjin)).
* - To take advantage of X86_64 feature, Use AVX2/AVX512 instructions to accelerate filter operation. [#30014](https://github.com/ClickHouse/ClickHouse/pull/30014) ([jasperzhu](https://github.com/jinjunzh)).
* Improve performance of aggregation in order of primary key (with enabled setting `optimize_aggregation_in_order`). [#30266](https://github.com/ClickHouse/ClickHouse/pull/30266) ([Anton Popov](https://github.com/CurtizJ)).
* ColumnDecimal improve performance for filter operation. [#30431](https://github.com/ClickHouse/ClickHouse/pull/30431) ([Jun Jin](https://github.com/vesslanjin)).
* Dictionaries support read from multiple threads. [#30500](https://github.com/ClickHouse/ClickHouse/pull/30500) ([Maksim Kita](https://github.com/kitaisreal)).
* - Improve filter bitmask generator function all in one with sse/avx2/avx512 instructions. [#30670](https://github.com/ClickHouse/ClickHouse/pull/30670) ([jasperzhu](https://github.com/jinjunzh)).
* Queries with `INTO OUTFILE` in `clickhouse-client` will use multiple threads. Fix the issue with flickering progress-bar when using `INTO OUTFILE`. This closes [#30873](https://github.com/ClickHouse/ClickHouse/issues/30873). This closes [#30872](https://github.com/ClickHouse/ClickHouse/issues/30872). [#30886](https://github.com/ClickHouse/ClickHouse/pull/30886) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* Allow to write number in query as binary literal. Example `SELECT 0b001;`. [#29304](https://github.com/ClickHouse/ClickHouse/pull/29304) ([Maksim Kita](https://github.com/kitaisreal)).
* Pass through initial query_id for clickhouse-benchmark (previously if you run remote query via `clickhouse-benchmark`, queries on shards will not be linked to the initial query via `initial_query_id`). [#29364](https://github.com/ClickHouse/ClickHouse/pull/29364) ([Azat Khuzhin](https://github.com/azat)).
* fix lost in memory part when freeze. [#29376](https://github.com/ClickHouse/ClickHouse/pull/29376) ([Mo Xuan](https://github.com/mo-avatar)).
* Added setting `use_skip_indexes`. [#29405](https://github.com/ClickHouse/ClickHouse/pull/29405) ([Maksim Kita](https://github.com/kitaisreal)).
* Apply config changes to `max_concurrent_queries` during runtime (no need to restart). [#29414](https://github.com/ClickHouse/ClickHouse/pull/29414) ([Raúl Marín](https://github.com/Algunenano)).
* Transform `isNull`/`isNotNull` to `IS NULL`/`IS NOT NULL` (for external dbs, i.e. MySQL). [#29446](https://github.com/ClickHouse/ClickHouse/pull/29446) ([Azat Khuzhin](https://github.com/azat)).
* Enable per-query memory profiler (set to memory_profiler_step=4MiB) globally. [#29455](https://github.com/ClickHouse/ClickHouse/pull/29455) ([Azat Khuzhin](https://github.com/azat)).
* Add support for `IS NULL`/`IS NOT NULL` for external dbs (i.e. MySQL). [#29463](https://github.com/ClickHouse/ClickHouse/pull/29463) ([Azat Khuzhin](https://github.com/azat)).
* Fixed `There is no query or query context has expired` error in mutations with nested subqueries. Do not allow subqueries in mutation if table is replicated and `allow_nondeterministic_mutations` setting is disabled. [#29495](https://github.com/ClickHouse/ClickHouse/pull/29495) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Get rid of pointless restriction on projection name. Now projection name can start with `tmp_`. [#29520](https://github.com/ClickHouse/ClickHouse/pull/29520) ([Amos Bird](https://github.com/amosbird)).
* Reload dictionaries, models, user defined executable functions if servers config `dictionaries_config`, `models_config`, `user_defined_executable_functions_config` changes. Closes [#28142](https://github.com/ClickHouse/ClickHouse/issues/28142). [#29529](https://github.com/ClickHouse/ClickHouse/pull/29529) ([Maksim Kita](https://github.com/kitaisreal)).
* Allow user to change log levels without restart. [#29586](https://github.com/ClickHouse/ClickHouse/pull/29586) ([Nikolay Degterinsky](https://github.com/evillique)).
* Increase `listen_backlog` by default (to match default in newer linux kernel). [#29643](https://github.com/ClickHouse/ClickHouse/pull/29643) ([Azat Khuzhin](https://github.com/azat)).
* Fix incorrect nullable processing of JSONFunctions. This fixes [#29615](https://github.com/ClickHouse/ClickHouse/issues/29615) . Mark as improvement because https://github.com/ClickHouse/ClickHouse/pull/28012 is not released. [#29659](https://github.com/ClickHouse/ClickHouse/pull/29659) ([Amos Bird](https://github.com/amosbird)).
* Fixed the issue: `clickhouse-format --obfuscate` cannot process queries with embedded dictionaries (functions `regionTo...`). [#29667](https://github.com/ClickHouse/ClickHouse/pull/29667) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Query obfuscator `clickhouse-format --obfuscate` now works with more types of queries. [#29672](https://github.com/ClickHouse/ClickHouse/pull/29672) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `url` table function to process multiple URLs in parallel. This closes [#29670](https://github.com/ClickHouse/ClickHouse/issues/29670) and closes [#29671](https://github.com/ClickHouse/ClickHouse/issues/29671). [#29673](https://github.com/ClickHouse/ClickHouse/pull/29673) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add ClickHouse logo to Play UI. [#29674](https://github.com/ClickHouse/ClickHouse/pull/29674) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Apply `max_untracked_memory`/`memory_profiler_step`/`memory_profiler_sample_probability` during mutate/merge. [#29681](https://github.com/ClickHouse/ClickHouse/pull/29681) ([Azat Khuzhin](https://github.com/azat)).
* Remove some redundant `seek` calls while reading compressed blocks in MergeTree table engines family. [#29766](https://github.com/ClickHouse/ClickHouse/pull/29766) ([alesapin](https://github.com/alesapin)).
* Web UI: render bars in table cells. [#29792](https://github.com/ClickHouse/ClickHouse/pull/29792) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added partitioned table prefix 'p' for the query for fetching replica identity index. [#29828](https://github.com/ClickHouse/ClickHouse/pull/29828) ([Shoh Jahon](https://github.com/Shohjahon)).
* Add ability to trace peak memory usage (with new trace_type - MemoryPeak). [#29858](https://github.com/ClickHouse/ClickHouse/pull/29858) ([Azat Khuzhin](https://github.com/azat)).
* Remove unused variable in s3cluster. [#29912](https://github.com/ClickHouse/ClickHouse/pull/29912) ([李扬](https://github.com/taiyang-li)).
* Add `shutdown_wait_unfinished_queries` server setting to allowing waiting for running queries up to `shutdown_wait_unfinished` time. This is for [#24451](https://github.com/ClickHouse/ClickHouse/issues/24451) . [#29914](https://github.com/ClickHouse/ClickHouse/pull/29914) ([Amos Bird](https://github.com/amosbird)).
* Now min-max aggregation over the first expression of primary key is optimized by projection. This is for https://github.com/ClickHouse/ClickHouse/issues/329. [#29918](https://github.com/ClickHouse/ClickHouse/pull/29918) ([Amos Bird](https://github.com/amosbird)).
* Add ability to configure retries and delays between them for `clickhouse-copier`. [#29921](https://github.com/ClickHouse/ClickHouse/pull/29921) ([Azat Khuzhin](https://github.com/azat)).
* Update zoneinfo files to 2021c. [#29925](https://github.com/ClickHouse/ClickHouse/pull/29925) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better exception message while reading column from Arrow-supported formats like `Arrow`, `ArrowStream`, `Parquet` and `ORC`. This closes [#29926](https://github.com/ClickHouse/ClickHouse/issues/29926). [#29927](https://github.com/ClickHouse/ClickHouse/pull/29927) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix lock-order-inversion between periodic dictionary reload and config reload. [#29928](https://github.com/ClickHouse/ClickHouse/pull/29928) ([Azat Khuzhin](https://github.com/azat)).
* Fix `lock-order-inversion` between `DROP TABLE` for `DatabaseMemory` and `LiveView`. [#29929](https://github.com/ClickHouse/ClickHouse/pull/29929) ([Azat Khuzhin](https://github.com/azat)).
* Fix data-race between flush() and startup() in StorageBuffer. [#29930](https://github.com/ClickHouse/ClickHouse/pull/29930) ([Azat Khuzhin](https://github.com/azat)).
* Now clickhouse use DNS cache while communicating with external S3. [#29999](https://github.com/ClickHouse/ClickHouse/pull/29999) ([alesapin](https://github.com/alesapin)).
* ProfileEvents::Counters snapshot doesn't store data in std::atomic anymore. [#30000](https://github.com/ClickHouse/ClickHouse/pull/30000) ([Dmitry Novik](https://github.com/novikd)).
* Add ability to print raw profile events to `clickhouse-client` (This can be useful for debugging and for testing). [#30064](https://github.com/ClickHouse/ClickHouse/pull/30064) ([Azat Khuzhin](https://github.com/azat)).
* Improve solution https://github.com/ClickHouse/ClickHouse/pull/28853 See also https://github.com/ClickHouse/ClickHouse/pull/29928. [#30084](https://github.com/ClickHouse/ClickHouse/pull/30084) ([Vitaly Baranov](https://github.com/vitlibar)).
* Reduce amount of redundant compressed data read from disk for some types `SELECT` queries (only for MergeTree engines family). [#30111](https://github.com/ClickHouse/ClickHouse/pull/30111) ([alesapin](https://github.com/alesapin)).
* PolygonDictionary added support for read method if setting `store_polygon_key_column` = true. Closes [#30090](https://github.com/ClickHouse/ClickHouse/issues/30090). [#30142](https://github.com/ClickHouse/ClickHouse/pull/30142) ([Maksim Kita](https://github.com/kitaisreal)).
* Now clickhouse-client supports native multi-line editing. [#30143](https://github.com/ClickHouse/ClickHouse/pull/30143) ([Amos Bird](https://github.com/amosbird)).
* Now `Keeper` (as part of `clickhouse-server`) will start asynchronously if it can connect to some other node. [#30170](https://github.com/ClickHouse/ClickHouse/pull/30170) ([alesapin](https://github.com/alesapin)).
* Support SQL user defined functions for clickhouse-local. [#30179](https://github.com/ClickHouse/ClickHouse/pull/30179) ([Maksim Kita](https://github.com/kitaisreal)).
* Allow to remove `SAMPLE BY` expression from `MergeTree` tables (`ALTER TABLE <table> REMOVE SAMPLE BY`). [#30180](https://github.com/ClickHouse/ClickHouse/pull/30180) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed comparison of Date32 with Date, DateTime, DateTime64, String. [#30219](https://github.com/ClickHouse/ClickHouse/pull/30219) ([liang.huang](https://github.com/lhuang09287750)).
* Allow symlinks to files in user_files directory for file table function. [#30309](https://github.com/ClickHouse/ClickHouse/pull/30309) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Minor improvements in replica cloning and enqueuing fetch for broken parts, that should avoid extremely rare hanging of `GET_PART` entries in replication queue. [#30346](https://github.com/ClickHouse/ClickHouse/pull/30346) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Added an ability to use FINAL clause in SELECT queries from GraphiteMergeTree. [#30360](https://github.com/ClickHouse/ClickHouse/pull/30360) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Allow extract non-string element as string using JSONExtractString. This is for https://github.com/ClickHouse/ClickHouse/pull/25452#issuecomment-927123287. [#30426](https://github.com/ClickHouse/ClickHouse/pull/30426) ([Amos Bird](https://github.com/amosbird)).
* More full support of positional arguments. [#30433](https://github.com/ClickHouse/ClickHouse/pull/30433) ([Kseniia Sumarokova](https://github.com/kssenii)).
* SQLUserDefinedFunctions support lambdas. Example `CREATE FUNCTION lambda_function AS x -> arrayMap(element -> element * 2, x);`. [#30435](https://github.com/ClickHouse/ClickHouse/pull/30435) ([Maksim Kita](https://github.com/kitaisreal)).
* SQLUserDefinedFunctions added DROP IF EXISTS support. Example `DROP FUNCTION IF EXISTS test_function`. [#30437](https://github.com/ClickHouse/ClickHouse/pull/30437) ([Maksim Kita](https://github.com/kitaisreal)).
* SQLUserDefinedFunctions support `CREATE OR REPLACE`, `CREATE IF NOT EXISTS` syntaxes. [#30454](https://github.com/ClickHouse/ClickHouse/pull/30454) ([Maksim Kita](https://github.com/kitaisreal)).
* Make query, which fetched table structure for PostgreSQL database because, more reliable. [#30477](https://github.com/ClickHouse/ClickHouse/pull/30477) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Get memory amount with Docker/cgroups limitations. See [#25662](https://github.com/ClickHouse/ClickHouse/issues/25662). [#30574](https://github.com/ClickHouse/ClickHouse/pull/30574) ([Pavel Medvedev](https://github.com/pmed)).
* SQLUserDefinedFunctions support ON CLUSTER. Example `CREATE FUNCTION test_function ON CLUSTER 'cluster' AS x -> x + 1;`. Closes [#30666](https://github.com/ClickHouse/ClickHouse/issues/30666). [#30734](https://github.com/ClickHouse/ClickHouse/pull/30734) ([Maksim Kita](https://github.com/kitaisreal)).
* Arrays of all serializable types are now supported by arrayStringConcat. [#30840](https://github.com/ClickHouse/ClickHouse/pull/30840) ([Nikita Taranov](https://github.com/nickitat)).
* Allow to parse values of `Date` data type in text formats as `YYYYMMDD` in addition to `YYYY-MM-DD`. This closes [#30870](https://github.com/ClickHouse/ClickHouse/issues/30870). [#30871](https://github.com/ClickHouse/ClickHouse/pull/30871) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Rename the columns of SessionLog: `session_id` -> `auth_id`, `session_name` -> `session_id`, `changed_settings` -> `settings`. [#30882](https://github.com/ClickHouse/ClickHouse/pull/30882) ([Vitaly Baranov](https://github.com/vitlibar)).

#### Bug Fix
* Fix shutdown of `AccessControlManager`. Now there can't be reloading of the configuration after AccessControlManager has been destroyed. This PR fixes the flaky test [test_user_directories/test.py::test_relative_path](https://clickhouse-test-reports.s3.yandex.net/0/f0e3122507ed8bea3f177495531c7d56bcb32466/integration_tests_(thread).html). [#29951](https://github.com/ClickHouse/ClickHouse/pull/29951) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix releasing query ID and session ID at the end of query processing while handing gRPC call. This PR fixes flaky test [test_grpc_protocol/test.py::test_session](https://clickhouse-test-reports.s3.yandex.net/0/1ac03811a2df9717fa7c633d1af03def821d24b6/integration_tests_(memory).html). [#29954](https://github.com/ClickHouse/ClickHouse/pull/29954) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix reading from empty file on encrypted disk. [#30494](https://github.com/ClickHouse/ClickHouse/pull/30494) ([Vitaly Baranov](https://github.com/vitlibar)).

#### Build/Testing/Packaging Improvement
* N/A Detailed description / Documentation draft:. [#29367](https://github.com/ClickHouse/ClickHouse/pull/29367) ([kevin wan](https://github.com/MaxWk)).
* Add ability to compile using newer version fo glibc w/o using new symbols. [#29594](https://github.com/ClickHouse/ClickHouse/pull/29594) ([Azat Khuzhin](https://github.com/azat)).
* Turning on experimental constexpr expressions evaluator for clang to speed up template code compilation. [#29668](https://github.com/ClickHouse/ClickHouse/pull/29668) ([Mike Kot](https://github.com/myrrc)).
* Fix an build error because of [Rename "common" to "base"](https://github.com/ClickHouse/ClickHouse/commit/fe6b7c77c7d6bd2a45a20f3b6bb4eb91da6177ff). [#29688](https://github.com/ClickHouse/ClickHouse/pull/29688) ([Sergei Semin](https://github.com/syominsergey)).
* Leave only required files in cross-compile toolchains. Include them as submodules (earlier they were downloaded as tarballs). [#29974](https://github.com/ClickHouse/ClickHouse/pull/29974) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add cross-build for PowerPC (powerpc64le). This closes [#9589](https://github.com/ClickHouse/ClickHouse/issues/9589). Enable support for interaction with MySQL for AArch64 and PowerPC. This closes [#26301](https://github.com/ClickHouse/ClickHouse/issues/26301). [#30010](https://github.com/ClickHouse/ClickHouse/pull/30010) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable Protobuf, Arrow, ORC, Parquet for AArch64 and Darwin builds. This closes [#29248](https://github.com/ClickHouse/ClickHouse/issues/29248). This closes [#28018](https://github.com/ClickHouse/ClickHouse/issues/28018). [#30015](https://github.com/ClickHouse/ClickHouse/pull/30015) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add tests for encrypted disk & encryption codec and ReplicatedMergeTree. [#30172](https://github.com/ClickHouse/ClickHouse/pull/30172) ([Vitaly Baranov](https://github.com/vitlibar)).
* ClickHouse can be statically built with Musl. This is added as experiment, it does not support building `odbc-bridge`, `library-bridge`, integration with CatBoost and some libraries. [#30248](https://github.com/ClickHouse/ClickHouse/pull/30248) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Recursive submodules are no longer needed for ClickHouse. [#30315](https://github.com/ClickHouse/ClickHouse/pull/30315) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added docker image to build docs. [#30499](https://github.com/ClickHouse/ClickHouse/pull/30499) ([Ilya Yatsishin](https://github.com/qoega)).

#### Bug Fix (user-visible misbehaviour in official stable release

* Fix `ORDER BY ... WITH FILL` with set `TO` and `FROM` and no rows in result set. [#30888](https://github.com/ClickHouse/ClickHouse/pull/30888) ([Anton Popov](https://github.com/CurtizJ)).

#### Bug Fix (user-visible misbehaviour in official stable release)

* Fix hanging DDL queries on Replicated database while adding a new replica. [#29328](https://github.com/ClickHouse/ClickHouse/pull/29328) ([Kevin Michel](https://github.com/kmichel-aiven)).
* Fix vertical merges of projection parts. This fixes [#29253](https://github.com/ClickHouse/ClickHouse/issues/29253) . This PR also fixes several projection merge/mutation issues introduced in https://github.com/ClickHouse/ClickHouse/pull/25165. [#29337](https://github.com/ClickHouse/ClickHouse/pull/29337) ([Amos Bird](https://github.com/amosbird)).
* Remove window function `nth_value` as it is not memory-safe. This closes [#29347](https://github.com/ClickHouse/ClickHouse/issues/29347). [#29348](https://github.com/ClickHouse/ClickHouse/pull/29348) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix replicated access storage not shutting down cleanly when misconfigured. [#29388](https://github.com/ClickHouse/ClickHouse/pull/29388) ([Kevin Michel](https://github.com/kmichel-aiven)).
* rocksdb: fix race condition during multiple DB opening (and get back some tests that triggers the problem on CI). [#29393](https://github.com/ClickHouse/ClickHouse/pull/29393) ([Azat Khuzhin](https://github.com/azat)).
* Fix Logical error `Cannot capture columns` in functions greatest/least. Closes [#29334](https://github.com/ClickHouse/ClickHouse/issues/29334). [#29454](https://github.com/ClickHouse/ClickHouse/pull/29454) ([Kruglov Pavel](https://github.com/Avogar)).
* Fix possible `Block structure mismatch` for subqueries with pushed-down `HAVING` predicate. Fixes [#29010](https://github.com/ClickHouse/ClickHouse/issues/29010). [#29475](https://github.com/ClickHouse/ClickHouse/pull/29475) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed incorrect table name parsing on loading of `Lazy` database. Fixes [#29456](https://github.com/ClickHouse/ClickHouse/issues/29456). [#29476](https://github.com/ClickHouse/ClickHouse/pull/29476) ([Alexander Tokmakov](https://github.com/tavplubix)).
* In ODBC bridge add retries for error Invalid cursor state. It is a retriable error. Closes [#29473](https://github.com/ClickHouse/ClickHouse/issues/29473). [#29518](https://github.com/ClickHouse/ClickHouse/pull/29518) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix bug in check `pathStartsWith` becuase there was bug with the usage of `std::mismatch`: ` The behavior is undefined if the second range is shorter than the first range.`. [#29531](https://github.com/ClickHouse/ClickHouse/pull/29531) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Avoid deadlocks when reading and writting on JOIN Engine tables at the same time. [#29544](https://github.com/ClickHouse/ClickHouse/pull/29544) ([Raúl Marín](https://github.com/Algunenano)).
* Fix null deference for `GROUP BY WITH TOTALS HAVING` (when the column from `HAVING` wasn't selected). [#29553](https://github.com/ClickHouse/ClickHouse/pull/29553) ([Azat Khuzhin](https://github.com/azat)).
* Fix rare segfault in `ALTER MODIFY` query when using incorrect table identifier in `DEFAULT` expression like `x.y.z...` Fixes [#29184](https://github.com/ClickHouse/ClickHouse/issues/29184). [#29573](https://github.com/ClickHouse/ClickHouse/pull/29573) ([alesapin](https://github.com/alesapin)).
* Fix JIT expression compilation with aliases and short-circuit expression evaluation. Closes [#29403](https://github.com/ClickHouse/ClickHouse/issues/29403). [#29574](https://github.com/ClickHouse/ClickHouse/pull/29574) ([Maksim Kita](https://github.com/kitaisreal)).
* Condition in filter predicate could be lost after push-down optimisation. [#29625](https://github.com/ClickHouse/ClickHouse/pull/29625) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed incorrect behaviour of setting `materialized_postgresql_tables_list` at server restart. Found in [#28529](https://github.com/ClickHouse/ClickHouse/issues/28529). [#29686](https://github.com/ClickHouse/ClickHouse/pull/29686) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix incorrect `GROUP BY` (multiple rows with the same keys in result) in case of distributed query when shards had mixed versions `<= 21.3` and `>= 21.4`, `GROUP BY` key had several columns all with fixed size, and two-level aggregation was activated (see `group_by_two_level_threshold` and `group_by_two_level_threshold_bytes`). Fixes [#29580](https://github.com/ClickHouse/ClickHouse/issues/29580). [#29735](https://github.com/ClickHouse/ClickHouse/pull/29735) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix concurrent access to `LowCardinality` during `GROUP BY` (leads to SIGSEGV). [#29782](https://github.com/ClickHouse/ClickHouse/pull/29782) ([Azat Khuzhin](https://github.com/azat)).
* Fix bad cast in `ATTACH TABLE ... FROM 'path'` query when non-string literal is used instead of path. It may lead to reading of uninitialized memory. [#29790](https://github.com/ClickHouse/ClickHouse/pull/29790) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Avoid `Timeout exceeded: elapsed 18446744073.709553 seconds` error that might happen in extremely rare cases, presumably due to some bug in kernel. Fixes [#29154](https://github.com/ClickHouse/ClickHouse/issues/29154). [#29811](https://github.com/ClickHouse/ClickHouse/pull/29811) ([Alexander Tokmakov](https://github.com/tavplubix)).
* MaterializedMySQL: Fix an issue where if the connection to MySQL was lost, only parts of a transaction could be processed. [#29837](https://github.com/ClickHouse/ClickHouse/pull/29837) ([Håvard Kvålen](https://github.com/havardk)).
* Fix system tables recreation check (fails to detect changes in enum values). [#29857](https://github.com/ClickHouse/ClickHouse/pull/29857) ([Azat Khuzhin](https://github.com/azat)).
* Fix potential resource leak of the concurrent query limit of merge tree tables introduced in https://github.com/ClickHouse/ClickHouse/pull/19544 . [#29879](https://github.com/ClickHouse/ClickHouse/pull/29879) ([Amos Bird](https://github.com/amosbird)).
* Fix data-race between `LogSink::writeMarks()` and `LogSource` in `StorageLog`. [#29946](https://github.com/ClickHouse/ClickHouse/pull/29946) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible data-race between `FileChecker` and `StorageLog`/`StorageStripeLog`. [#29959](https://github.com/ClickHouse/ClickHouse/pull/29959) ([Azat Khuzhin](https://github.com/azat)).
* try to close issue: [#29965](https://github.com/ClickHouse/ClickHouse/issues/29965). [#29976](https://github.com/ClickHouse/ClickHouse/pull/29976) ([hexiaoting](https://github.com/hexiaoting)).
* Fix crash of sample by `tuple()`, closes [#30004](https://github.com/ClickHouse/ClickHouse/issues/30004). [#30016](https://github.com/ClickHouse/ClickHouse/pull/30016) ([flynn](https://github.com/ucasfl)).
* Dropped `Memory` database might reappear after server restart, it's fixed ([#29795](https://github.com/ClickHouse/ClickHouse/issues/29795)). Also added `force_remove_data_recursively_on_drop` setting as a workaround for `Directory not empty` error when dropping `Ordinary` database (because it's not possible to remove data leftovers manually in cloud environment). [#30054](https://github.com/ClickHouse/ClickHouse/pull/30054) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix race between MOVE PARTITION and merges/mutations for MergeTree. [#30074](https://github.com/ClickHouse/ClickHouse/pull/30074) ([Azat Khuzhin](https://github.com/azat)).
* Fix error `Port is already connected` for queries with `GLOBAL IN` and `WITH TOTALS`. Only for 21.9 and 21.10. [#30086](https://github.com/ClickHouse/ClickHouse/pull/30086) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Support nullable arguments in function `initializeAggregation`. [#30177](https://github.com/ClickHouse/ClickHouse/pull/30177) ([Anton Popov](https://github.com/CurtizJ)).
* Fix INSERT SELECT incorrectly fills MATERIALIZED column based of Nullable column. [#30189](https://github.com/ClickHouse/ClickHouse/pull/30189) ([Azat Khuzhin](https://github.com/azat)).
* Fix `pread_fake_async`/`pread_threadpool` with `min_bytes_to_use_direct_io`. [#30191](https://github.com/ClickHouse/ClickHouse/pull/30191) ([Azat Khuzhin](https://github.com/azat)).
* Fix reading from `MergeTree` with `max_read_buffer_size=0` (can lead to `Can't adjust last granule` `LOGICAL_ERROR`, or even data loss). [#30192](https://github.com/ClickHouse/ClickHouse/pull/30192) ([Azat Khuzhin](https://github.com/azat)).
* * Allow identifiers staring with numbers in multiple joins. [#30230](https://github.com/ClickHouse/ClickHouse/pull/30230) ([Vladimir C](https://github.com/vdimir)).
* FlatDictionary, HashedDictionary fix bytes_allocated calculation for nullable attributes. [#30238](https://github.com/ClickHouse/ClickHouse/pull/30238) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix crash with shortcircuit and lowcardinality in multiIf. [#30243](https://github.com/ClickHouse/ClickHouse/pull/30243) ([Raúl Marín](https://github.com/Algunenano)).
* Fix `[I]LIKE` function. Closes [#28661](https://github.com/ClickHouse/ClickHouse/issues/28661). [#30244](https://github.com/ClickHouse/ClickHouse/pull/30244) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix ComplexKeyHashedDictionary, ComplexKeySparseHashedDictionary parsing `preallocate` option from layout config. [#30246](https://github.com/ClickHouse/ClickHouse/pull/30246) ([Maksim Kita](https://github.com/kitaisreal)).
* fix replaceRegexpAll bug. [#30292](https://github.com/ClickHouse/ClickHouse/pull/30292) ([Memo](https://github.com/Joeywzr)).
* Fix column alias resolution of JOIN queries when projection is enabled. This fixes [#30146](https://github.com/ClickHouse/ClickHouse/issues/30146). [#30293](https://github.com/ClickHouse/ClickHouse/pull/30293) ([Amos Bird](https://github.com/amosbird)).
* Queries with condition like `IN (subquery)` could return incorrect result in case if aggregate projection applied. Fixed creation of sets for projections. [#30310](https://github.com/ClickHouse/ClickHouse/pull/30310) ([Amos Bird](https://github.com/amosbird)).
* Makes [#30162](https://github.com/ClickHouse/ClickHouse/issues/30162) less possible ... [#30370](https://github.com/ClickHouse/ClickHouse/pull/30370) ([Vasily Nemkov](https://github.com/Enmk)).
* Fixed segfault which might happen if session expired during execution of REPLACE PARTITION. [#30432](https://github.com/ClickHouse/ClickHouse/pull/30432) ([Alexander Tokmakov](https://github.com/tavplubix)).
* * Fix deadlock on ALTER with scalar subquery to the same table, close [#30461](https://github.com/ClickHouse/ClickHouse/issues/30461). [#30492](https://github.com/ClickHouse/ClickHouse/pull/30492) ([Vladimir C](https://github.com/vdimir)).
* Add missing parenthesis for `isNotNull`/`isNull` rewrites to `IS [NOT] NULL` (fixes queries that has something like `isNotNull(1)+isNotNull(2)`). [#30520](https://github.com/ClickHouse/ClickHouse/pull/30520) ([Azat Khuzhin](https://github.com/azat)).
* Limit push down optimization could cause a error `Cannot find column`. Fixes [#30438](https://github.com/ClickHouse/ClickHouse/issues/30438). [#30562](https://github.com/ClickHouse/ClickHouse/pull/30562) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update aws-sdk submodule for throttling in Yandex.S3. [#30646](https://github.com/ClickHouse/ClickHouse/pull/30646) ([ianton-ru](https://github.com/ianton-ru)).
* Functions for case-insensitive search in UTF8 strings like `positionCaseInsensitiveUTF8` and `countSubstringsCaseInsensitiveUTF8` might find substrings that actually does not match, it's fixed. [#30663](https://github.com/ClickHouse/ClickHouse/pull/30663) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix PREWHERE with WHERE in case of always true PREWHERE. [#30668](https://github.com/ClickHouse/ClickHouse/pull/30668) ([Azat Khuzhin](https://github.com/azat)).
* Fixed a race condition between `REPLACE/MOVE PARTITION` and background merge in non-replicated `MergeTree` that might cause a part of moved/replaced data to remain in partition. Fixes [#29327](https://github.com/ClickHouse/ClickHouse/issues/29327). [#30717](https://github.com/ClickHouse/ClickHouse/pull/30717) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Clean temporary directory when localBackup failed by some reason. [#30797](https://github.com/ClickHouse/ClickHouse/pull/30797) ([ianton-ru](https://github.com/ianton-ru)).
* Fixed ambiguity when extracting auxiliary ZooKeeper name from ZooKeeper path in `ReplicatedMergeTree`. Previously server might fail to start with `Unknown auxiliary ZooKeeper name` if ZooKeeper path contains a colon. Fixes [#29052](https://github.com/ClickHouse/ClickHouse/issues/29052). Also it was allowed to specify ZooKeeper path that does not start with slash, but now it's deprecated and creation of new tables with such path is not allowed. Slashes and colons in auxiliary ZooKeeper names are not allowed too. [#30822](https://github.com/ClickHouse/ClickHouse/pull/30822) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix crash when projection with hashing function is materialized. This fixes [#30861](https://github.com/ClickHouse/ClickHouse/issues/30861) . The issue is similar to https://github.com/ClickHouse/ClickHouse/pull/28560 which is a lack of proper understanding of the invariant of header's emptyness. [#30877](https://github.com/ClickHouse/ClickHouse/pull/30877) ([Amos Bird](https://github.com/amosbird)).
* Fix set index not used in AND/OR expressions when there are more than two operands. This fixes [#30416](https://github.com/ClickHouse/ClickHouse/issues/30416) . [#30887](https://github.com/ClickHouse/ClickHouse/pull/30887) ([Amos Bird](https://github.com/amosbird)).

#### NO CL ENTRY

* NO CL ENTRY:  'Generate test_results.tsv for fasttest'. [#29319](https://github.com/ClickHouse/ClickHouse/pull/29319) ([Dmitry Novik](https://github.com/novikd)).
* NO CL ENTRY:  'Revert "Add coroutines example."'. [#29829](https://github.com/ClickHouse/ClickHouse/pull/29829) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Link FAQ from Debian installation'. [#29836](https://github.com/ClickHouse/ClickHouse/pull/29836) ([Federico Ceratto](https://github.com/FedericoCeratto)).
* NO CL ENTRY:  'add support of window function in antlr grammar'. [#30181](https://github.com/ClickHouse/ClickHouse/pull/30181) ([PHaroZ](https://github.com/PHaroZ)).
* NO CL ENTRY:  'Revert "Fix style regressions on benchmark page"'. [#30652](https://github.com/ClickHouse/ClickHouse/pull/30652) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "Improve usability of `remote_url_allow_hosts`"'. [#30707](https://github.com/ClickHouse/ClickHouse/pull/30707) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Revert "Revert "Improve usability of `remote_url_allow_hosts`""'. [#30708](https://github.com/ClickHouse/ClickHouse/pull/30708) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'remove some unneeded header files'. [#30722](https://github.com/ClickHouse/ClickHouse/pull/30722) ([flynn](https://github.com/ucasfl)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Fix race in StorageSystemRocksDB [#29289](https://github.com/ClickHouse/ClickHouse/pull/29289) ([Vladimir C](https://github.com/vdimir)).
* Fixed logging level for message in `S3Common.cpp` [#29308](https://github.com/ClickHouse/ClickHouse/pull/29308) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Revert parse number binary literal [#29309](https://github.com/ClickHouse/ClickHouse/pull/29309) ([Maksim Kita](https://github.com/kitaisreal)).
* Parser number binary literal update [#29310](https://github.com/ClickHouse/ClickHouse/pull/29310) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix assertion in DDLDependencyVisitor [#29323](https://github.com/ClickHouse/ClickHouse/pull/29323) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Function h3GetFaces optimization [#29335](https://github.com/ClickHouse/ClickHouse/pull/29335) ([Maksim Kita](https://github.com/kitaisreal)).
* Less sleeps in integration tests. [#29338](https://github.com/ClickHouse/ClickHouse/pull/29338) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix trivial mistake in DiskWebServer [#29340](https://github.com/ClickHouse/ClickHouse/pull/29340) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix integration test for RocksDB [#29341](https://github.com/ClickHouse/ClickHouse/pull/29341) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix typo in comment [#29342](https://github.com/ClickHouse/ClickHouse/pull/29342) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add lld into Build-Depends for debian package [#29343](https://github.com/ClickHouse/ClickHouse/pull/29343) ([Azat Khuzhin](https://github.com/azat)).
* Apply a patch from Azat [#29344](https://github.com/ClickHouse/ClickHouse/pull/29344) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update libhdfs3 [#29345](https://github.com/ClickHouse/ClickHouse/pull/29345) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove ya.make [#29346](https://github.com/ClickHouse/ClickHouse/pull/29346) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix assert in table function `merge` with database regexp [#29355](https://github.com/ClickHouse/ClickHouse/pull/29355) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove useless files related to pytest [#29361](https://github.com/ClickHouse/ClickHouse/pull/29361) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove obsolete non-automated tests [#29362](https://github.com/ClickHouse/ClickHouse/pull/29362) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix integration test [#29365](https://github.com/ClickHouse/ClickHouse/pull/29365) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix H3 function name (h3ResIsClassIII to h3IsResClassIII) [#29368](https://github.com/ClickHouse/ClickHouse/pull/29368) ([Bharat Nallan](https://github.com/bharatnc)).
* RFC: tests: purge unused configs [#29375](https://github.com/ClickHouse/ClickHouse/pull/29375) ([Azat Khuzhin](https://github.com/azat)).
* Fix ugly typo [#29379](https://github.com/ClickHouse/ClickHouse/pull/29379) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix comments in AggregateFunctionFactory [#29380](https://github.com/ClickHouse/ClickHouse/pull/29380) ([Bharat Nallan](https://github.com/bharatnc)).
* Add GraphCDN in adopter list [#29387](https://github.com/ClickHouse/ClickHouse/pull/29387) ([Mohamad Fadhil](https://github.com/sdil)).
* Fix 02015_async_inserts_2 flakiness [#29390](https://github.com/ClickHouse/ClickHouse/pull/29390) ([Azat Khuzhin](https://github.com/azat)).
* test for [#23634](https://github.com/ClickHouse/ClickHouse/issues/23634) ( nullable PK and negate cond ) [#29392](https://github.com/ClickHouse/ClickHouse/pull/29392) ([Denny Crane](https://github.com/den-crane)).
* Merge EmbeddedRocksDBBlockInputStream and EmbeddedRocksDBSource  [#29428](https://github.com/ClickHouse/ClickHouse/pull/29428) ([Vladimir C](https://github.com/vdimir)).
* Map bloom filter index mapValues equals function support [#29431](https://github.com/ClickHouse/ClickHouse/pull/29431) ([Maksim Kita](https://github.com/kitaisreal)).
* Dictionary Array nested Map added test [#29432](https://github.com/ClickHouse/ClickHouse/pull/29432) ([Maksim Kita](https://github.com/kitaisreal)).
* Dictionary view different database added test [#29443](https://github.com/ClickHouse/ClickHouse/pull/29443) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix deadlock in concurrent async inserts and truncates [#29444](https://github.com/ClickHouse/ClickHouse/pull/29444) ([Anton Popov](https://github.com/CurtizJ)).
* Fix flaky test 01158_zookeeper_log_long [#29445](https://github.com/ClickHouse/ClickHouse/pull/29445) ([Alexander Tokmakov](https://github.com/tavplubix)).
* clickhouse-test: fix long tag check for flaky check (--test-runs > 1) [#29449](https://github.com/ClickHouse/ClickHouse/pull/29449) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test: fix shared list object (by fixing manager lifetime) [#29452](https://github.com/ClickHouse/ClickHouse/pull/29452) ([Azat Khuzhin](https://github.com/azat)).
* Enable memory profiler on CI [#29453](https://github.com/ClickHouse/ClickHouse/pull/29453) ([Azat Khuzhin](https://github.com/azat)).
* test for [#23634](https://github.com/ClickHouse/ClickHouse/issues/23634) added tests for tuples [#29460](https://github.com/ClickHouse/ClickHouse/pull/29460) ([Denny Crane](https://github.com/den-crane)).
* Fix 2024_merge_regexp_assert [#29461](https://github.com/ClickHouse/ClickHouse/pull/29461) ([Azat Khuzhin](https://github.com/azat)).
* Add std::cerr/std::cout style check [#29464](https://github.com/ClickHouse/ClickHouse/pull/29464) ([Azat Khuzhin](https://github.com/azat)).
* [github] we're switching to CLA based on Apache CLA [#29466](https://github.com/ClickHouse/ClickHouse/pull/29466) ([ClickHouse Admin](https://github.com/clickhouse-admin)).
* Bloom filter indexes updated tests [#29474](https://github.com/ClickHouse/ClickHouse/pull/29474) ([Maksim Kita](https://github.com/kitaisreal)).
* Remove more data streams [#29491](https://github.com/ClickHouse/ClickHouse/pull/29491) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix possible hang in PushingAsyncPipelineExecutor. [#29494](https://github.com/ClickHouse/ClickHouse/pull/29494) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Use `max_parse_depth` in fuzzers [#29497](https://github.com/ClickHouse/ClickHouse/pull/29497) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Introducing Fn concept for function signature checking, simplifying SimpleCache [#29500](https://github.com/ClickHouse/ClickHouse/pull/29500) ([Mike Kot](https://github.com/myrrc)).
* Fix LOGICAL_ERROR for INSERT with concurrent ALTER [#29502](https://github.com/ClickHouse/ClickHouse/pull/29502) ([Azat Khuzhin](https://github.com/azat)).
* Log queries to external databases (since they may be rewritten) [#29503](https://github.com/ClickHouse/ClickHouse/pull/29503) ([Azat Khuzhin](https://github.com/azat)).
* Fix server pid (hence exit code and attaching with gdb) in fuzzer tests [#29513](https://github.com/ClickHouse/ClickHouse/pull/29513) ([Azat Khuzhin](https://github.com/azat)).
* Bump cmake minimum required version to 3.14 [#29515](https://github.com/ClickHouse/ClickHouse/pull/29515) ([Azat Khuzhin](https://github.com/azat)).
* Changelog heredoc added backward incompatible change [#29530](https://github.com/ClickHouse/ClickHouse/pull/29530) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix test names [#29539](https://github.com/ClickHouse/ClickHouse/pull/29539) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Making Monotonicity an aggregate to use with designated initializers [#29540](https://github.com/ClickHouse/ClickHouse/pull/29540) ([Mike Kot](https://github.com/myrrc)).
* Generalize code in IColumn::permute [#29545](https://github.com/ClickHouse/ClickHouse/pull/29545) ([Anton Popov](https://github.com/CurtizJ)).
* Add error for multiple keys without current_key_id [#29546](https://github.com/ClickHouse/ClickHouse/pull/29546) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* support conversion between date32 and datetime64 [#29552](https://github.com/ClickHouse/ClickHouse/pull/29552) ([kevin wan](https://github.com/MaxWk)).
* Fixed test with dictGet without database name as column default value [#29568](https://github.com/ClickHouse/ClickHouse/pull/29568) ([Maksim Kita](https://github.com/kitaisreal)).
* Add FAIL message to test_results.tsv [#29583](https://github.com/ClickHouse/ClickHouse/pull/29583) ([Dmitry Novik](https://github.com/novikd)).
* Generalize code in `IColumn::updatePermutation` [#29595](https://github.com/ClickHouse/ClickHouse/pull/29595) ([Anton Popov](https://github.com/CurtizJ)).
* Add fuzzer for `executeQuery` function [#29596](https://github.com/ClickHouse/ClickHouse/pull/29596) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix docker/test/util declaration [#29597](https://github.com/ClickHouse/ClickHouse/pull/29597) ([Dmitry Novik](https://github.com/novikd)).
* Skip test for executable table function under MSan [#29600](https://github.com/ClickHouse/ClickHouse/pull/29600) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve some more integration tests [#29603](https://github.com/ClickHouse/ClickHouse/pull/29603) ([Ilya Yatsishin](https://github.com/qoega)).
* Improve CompressedReadBuffer [#29605](https://github.com/ClickHouse/ClickHouse/pull/29605) ([Ilya Yatsishin](https://github.com/qoega)).
* Do not send many signals at server restart (integration tests). [#29608](https://github.com/ClickHouse/ClickHouse/pull/29608) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix race between MergeTask and storage destruction [#29614](https://github.com/ClickHouse/ClickHouse/pull/29614) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* BloomFilter indexes map data type support fix unsafe identifier cast [#29623](https://github.com/ClickHouse/ClickHouse/pull/29623) ([Maksim Kita](https://github.com/kitaisreal)).
* Follow-up for [#26231](https://github.com/ClickHouse/ClickHouse/issues/26231) [#29626](https://github.com/ClickHouse/ClickHouse/pull/29626) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Map get non const key added test [#29636](https://github.com/ClickHouse/ClickHouse/pull/29636) ([Maksim Kita](https://github.com/kitaisreal)).
* Add columns in columns.sql for INFORMATION_SCHEMA [#29637](https://github.com/ClickHouse/ClickHouse/pull/29637) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Merging [#29376](https://github.com/ClickHouse/ClickHouse/issues/29376) [#29649](https://github.com/ClickHouse/ClickHouse/pull/29649) ([Anton Popov](https://github.com/CurtizJ)).
* AddDefaultDatabaseVisitor support dictGet [#29650](https://github.com/ClickHouse/ClickHouse/pull/29650) ([Maksim Kita](https://github.com/kitaisreal)).
* Do not try to fuzz `USE`/`SET` queries and print stacktrace [#29660](https://github.com/ClickHouse/ClickHouse/pull/29660) ([Azat Khuzhin](https://github.com/azat)).
* Rename `common` to `base` [#29661](https://github.com/ClickHouse/ClickHouse/pull/29661) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Move modelEvaluate function to its own file [#29662](https://github.com/ClickHouse/ClickHouse/pull/29662) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Perf fixes [#29663](https://github.com/ClickHouse/ClickHouse/pull/29663) ([Azat Khuzhin](https://github.com/azat)).
* UserDefinedExecutableFunctions added implicit cast [#29666](https://github.com/ClickHouse/ClickHouse/pull/29666) ([Maksim Kita](https://github.com/kitaisreal)).
* Cleanup common defines [#29680](https://github.com/ClickHouse/ClickHouse/pull/29680) ([Azat Khuzhin](https://github.com/azat)).
* Fix Xcode 13 build [#29682](https://github.com/ClickHouse/ClickHouse/pull/29682) ([Denis Glazachev](https://github.com/traceon)).
* Non-recursive implementation for type list and its functions [#29683](https://github.com/ClickHouse/ClickHouse/pull/29683) ([Mike Kot](https://github.com/myrrc)).
* Reorganize contrib/ IDE folders [#29684](https://github.com/ClickHouse/ClickHouse/pull/29684) ([Denis Glazachev](https://github.com/traceon)).
* Cleanup unbundled image [#29689](https://github.com/ClickHouse/ClickHouse/pull/29689) ([Azat Khuzhin](https://github.com/azat)).
* Fix memory tracking for merges and mutations [#29691](https://github.com/ClickHouse/ClickHouse/pull/29691) ([Azat Khuzhin](https://github.com/azat)).
* Fix data-race in WriteIndirectBuffer (used in DiskMemory) [#29692](https://github.com/ClickHouse/ClickHouse/pull/29692) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky test [#29706](https://github.com/ClickHouse/ClickHouse/pull/29706) ([Kseniia Sumarokova](https://github.com/kssenii)).
* BorrowedObjectPool condition variable notify fix [#29722](https://github.com/ClickHouse/ClickHouse/pull/29722) ([Maksim Kita](https://github.com/kitaisreal)).
* Better exception message for local interactive [#29737](https://github.com/ClickHouse/ClickHouse/pull/29737) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix --stage for clickhouse-local [#29745](https://github.com/ClickHouse/ClickHouse/pull/29745) ([Azat Khuzhin](https://github.com/azat)).
* Forbid Nullable for JSONExtract* (JSONExtract() still supports Nullable), leads to SIGSEGV before [#29746](https://github.com/ClickHouse/ClickHouse/pull/29746) ([Azat Khuzhin](https://github.com/azat)).
* TableFunctionDictionary fix comment [#29747](https://github.com/ClickHouse/ClickHouse/pull/29747) ([Maksim Kita](https://github.com/kitaisreal)).
* May be fix s3 tests [#29762](https://github.com/ClickHouse/ClickHouse/pull/29762) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove some merging streams [#29768](https://github.com/ClickHouse/ClickHouse/pull/29768) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Parse query from metadata exception throw fix [#29779](https://github.com/ClickHouse/ClickHouse/pull/29779) ([Maksim Kita](https://github.com/kitaisreal)).
* Simplify obtaining of server pid in fuzzer tests [#29781](https://github.com/ClickHouse/ClickHouse/pull/29781) ([Azat Khuzhin](https://github.com/azat)).
* Fix data-race between fatal error handler and progress packets [#29783](https://github.com/ClickHouse/ClickHouse/pull/29783) ([Azat Khuzhin](https://github.com/azat)).
* Fix parallel_view_processing [#29786](https://github.com/ClickHouse/ClickHouse/pull/29786) ([Azat Khuzhin](https://github.com/azat)).
* Function reinterpretAs improve readability [#29796](https://github.com/ClickHouse/ClickHouse/pull/29796) ([Maksim Kita](https://github.com/kitaisreal)).
* Refactor ConcurrentBoundedQueue [#29801](https://github.com/ClickHouse/ClickHouse/pull/29801) ([Maksim Kita](https://github.com/kitaisreal)).
* Improve usability of error messages when error is caused by sophisticated interventions [#29803](https://github.com/ClickHouse/ClickHouse/pull/29803) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improvement for [#28373](https://github.com/ClickHouse/ClickHouse/issues/28373) [#29804](https://github.com/ClickHouse/ClickHouse/pull/29804) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Better diagnostic for OPTIMIZE [#29812](https://github.com/ClickHouse/ClickHouse/pull/29812) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add listen_backlog to documentation [#29813](https://github.com/ClickHouse/ClickHouse/pull/29813) ([Azat Khuzhin](https://github.com/azat)).
* Dictionary attributes updated documentation [#29816](https://github.com/ClickHouse/ClickHouse/pull/29816) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix compilation with glibc 2.34 (MINSIGSTKSZ defined as sysconf(_SC_SIGSTKSZ)) [#29820](https://github.com/ClickHouse/ClickHouse/pull/29820) ([Azat Khuzhin](https://github.com/azat)).
* Make memory_profiler_step API cleaner [#29825](https://github.com/ClickHouse/ClickHouse/pull/29825) ([Azat Khuzhin](https://github.com/azat)).
* Add coroutines example. [#29827](https://github.com/ClickHouse/ClickHouse/pull/29827) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add coroutines example. [#29841](https://github.com/ClickHouse/ClickHouse/pull/29841) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Update changelog to include caveats about Nullable types in data skipping indexes [#29855](https://github.com/ClickHouse/ClickHouse/pull/29855) ([Azat Khuzhin](https://github.com/azat)).
* Rewrite clickhouse-test to use python clickhouse_driver [#29856](https://github.com/ClickHouse/ClickHouse/pull/29856) ([Azat Khuzhin](https://github.com/azat)).
* Fix client [#29864](https://github.com/ClickHouse/ClickHouse/pull/29864) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove some more streams. [#29898](https://github.com/ClickHouse/ClickHouse/pull/29898) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add logging in ZooKeeper client [#29901](https://github.com/ClickHouse/ClickHouse/pull/29901) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix some flaky tests [#29902](https://github.com/ClickHouse/ClickHouse/pull/29902) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Grep server log even if it contains binary data [#29903](https://github.com/ClickHouse/ClickHouse/pull/29903) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Cosmetic refactoring of server constants. [#29913](https://github.com/ClickHouse/ClickHouse/pull/29913) ([Amos Bird](https://github.com/amosbird)).
* Format improvement of AlterQuery [#29916](https://github.com/ClickHouse/ClickHouse/pull/29916) ([flynn](https://github.com/ucasfl)).
* Fix flaky integration tests (test_backup_restore/test_input_format_parallel_parsing_memory_tracking) [#29919](https://github.com/ClickHouse/ClickHouse/pull/29919) ([Azat Khuzhin](https://github.com/azat)).
* Fix some flaky tests [#29923](https://github.com/ClickHouse/ClickHouse/pull/29923) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix build due to conflicts in serverConstants [#29931](https://github.com/ClickHouse/ClickHouse/pull/29931) ([Azat Khuzhin](https://github.com/azat)).
* Minor changes [#29932](https://github.com/ClickHouse/ClickHouse/pull/29932) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove trash from SentryWriter [#29933](https://github.com/ClickHouse/ClickHouse/pull/29933) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove `printf` function usage. [#29935](https://github.com/ClickHouse/ClickHouse/pull/29935) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Stateless flaky tests fixes [#29947](https://github.com/ClickHouse/ClickHouse/pull/29947) ([Azat Khuzhin](https://github.com/azat)).
* Fix filtering by tuple (some conditions was lost during analyzing) [#29956](https://github.com/ClickHouse/ClickHouse/pull/29956) ([Azat Khuzhin](https://github.com/azat)).
* Allow memory profiler under sanitizers (ASan/UBsan/MSan only) [#29979](https://github.com/ClickHouse/ClickHouse/pull/29979) ([Azat Khuzhin](https://github.com/azat)).
* Tests naming fix [#29982](https://github.com/ClickHouse/ClickHouse/pull/29982) ([Maksim Kita](https://github.com/kitaisreal)).
* More timeouts in test scripts [#29992](https://github.com/ClickHouse/ClickHouse/pull/29992) ([alesapin](https://github.com/alesapin)).
* Update BoringSSL [#29998](https://github.com/ClickHouse/ClickHouse/pull/29998) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Remove streams from formats. [#30001](https://github.com/ClickHouse/ClickHouse/pull/30001) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Follow-up to [#29901](https://github.com/ClickHouse/ClickHouse/issues/29901) [#30003](https://github.com/ClickHouse/ClickHouse/pull/30003) ([Alexander Tokmakov](https://github.com/tavplubix)).
* More strict check for intersecting parts [#30005](https://github.com/ClickHouse/ClickHouse/pull/30005) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Ignore parallel removing warning in 00992_system_parts_race_condition_zookeeper_long [#30007](https://github.com/ClickHouse/ClickHouse/pull/30007) ([Azat Khuzhin](https://github.com/azat)).
* Try remove excessive logging [#30008](https://github.com/ClickHouse/ClickHouse/pull/30008) ([Alexander Tokmakov](https://github.com/tavplubix)).
* remove redundant dot in exception message [#30017](https://github.com/ClickHouse/ClickHouse/pull/30017) ([flynn](https://github.com/ucasfl)).
* Fix build [#30028](https://github.com/ClickHouse/ClickHouse/pull/30028) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Attach trace_log to stateless tests report as is [#30030](https://github.com/ClickHouse/ClickHouse/pull/30030) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Remove unused headers and handle exception 'unrecognised option' in clickhouse-local [#30053](https://github.com/ClickHouse/ClickHouse/pull/30053) ([Kruglov Pavel](https://github.com/Avogar)).
* clickhouse-test: replace clickhouse-driver with http interface (via http.client) [#30065](https://github.com/ClickHouse/ClickHouse/pull/30065) ([Azat Khuzhin](https://github.com/azat)).
* Fix hardware utilization info printing in client [#30072](https://github.com/ClickHouse/ClickHouse/pull/30072) ([Dmitry Novik](https://github.com/novikd)).
* cmake generator: unlink before creating a link [#30073](https://github.com/ClickHouse/ClickHouse/pull/30073) ([lehasm](https://github.com/lehasm)).
* SQL user defined functions fix alias [#30075](https://github.com/ClickHouse/ClickHouse/pull/30075) ([Maksim Kita](https://github.com/kitaisreal)).
* Add Greenhouse careers page to website [#30077](https://github.com/ClickHouse/ClickHouse/pull/30077) ([Cody Baker](https://github.com/codyrobert)).
* Update team photos on website [#30078](https://github.com/ClickHouse/ClickHouse/pull/30078) ([Cody Baker](https://github.com/codyrobert)).
* Add webinar signup promo to website homepage [#30079](https://github.com/ClickHouse/ClickHouse/pull/30079) ([Cody Baker](https://github.com/codyrobert)).
* test for rename atomic hanging [#30080](https://github.com/ClickHouse/ClickHouse/pull/30080) ([Denny Crane](https://github.com/den-crane)).
* Modify ConnectionPoolWithFailover get_priority ROUND_ROBIN comments [#30092](https://github.com/ClickHouse/ClickHouse/pull/30092) ([小路](https://github.com/nicelulu)).
* Fix flaky test 01939_network_send_bytes_metrics [#30134](https://github.com/ClickHouse/ClickHouse/pull/30134) ([Dmitry Novik](https://github.com/novikd)).
* System data skipping indices size fix test names [#30141](https://github.com/ClickHouse/ClickHouse/pull/30141) ([Maksim Kita](https://github.com/kitaisreal)).
* FunctionsJSON avoid copying object element during iteration [#30145](https://github.com/ClickHouse/ClickHouse/pull/30145) ([Maksim Kita](https://github.com/kitaisreal)).
* Disable fsync_metadata on CI [#30149](https://github.com/ClickHouse/ClickHouse/pull/30149) ([Azat Khuzhin](https://github.com/azat)).
* Make test_MemoryTracking::test_http not flaky [#30150](https://github.com/ClickHouse/ClickHouse/pull/30150) ([Azat Khuzhin](https://github.com/azat)).
* Add careers menu item to navigation [#30151](https://github.com/ClickHouse/ClickHouse/pull/30151) ([Cody Baker](https://github.com/codyrobert)).
* Update yandex logo on homepage [#30152](https://github.com/ClickHouse/ClickHouse/pull/30152) ([Cody Baker](https://github.com/codyrobert)).
* Remove stream interfaces [#30171](https://github.com/ClickHouse/ClickHouse/pull/30171) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Better interfaces for `IDataType` and `ISerialization` [#30174](https://github.com/ClickHouse/ClickHouse/pull/30174) ([Anton Popov](https://github.com/CurtizJ)).
* Add blog post for v21.10 release [#30186](https://github.com/ClickHouse/ClickHouse/pull/30186) ([Cody Baker](https://github.com/codyrobert)).
* Smaller smoothing window in throttler. [#30193](https://github.com/ClickHouse/ClickHouse/pull/30193) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix clang-tidy warnings in FunctionsJSON code [#30217](https://github.com/ClickHouse/ClickHouse/pull/30217) ([Azat Khuzhin](https://github.com/azat)).
* Fix --hung-check in clickhouse-test [#30218](https://github.com/ClickHouse/ClickHouse/pull/30218) ([Azat Khuzhin](https://github.com/azat)).
* FunctionsJSON updated [#30228](https://github.com/ClickHouse/ClickHouse/pull/30228) ([Maksim Kita](https://github.com/kitaisreal)).
* PolygonDictionary fix bytes_allocated [#30239](https://github.com/ClickHouse/ClickHouse/pull/30239) ([Maksim Kita](https://github.com/kitaisreal)).
* ComplexKeyHashedDictionary fix keys copy [#30241](https://github.com/ClickHouse/ClickHouse/pull/30241) ([Maksim Kita](https://github.com/kitaisreal)).
* Removing data streams folder [#30247](https://github.com/ClickHouse/ClickHouse/pull/30247) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* --stage for clickhouse-local [#30275](https://github.com/ClickHouse/ClickHouse/pull/30275) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Use forward declaration for Buffer<> in generic headers [#30276](https://github.com/ClickHouse/ClickHouse/pull/30276) ([Azat Khuzhin](https://github.com/azat)).
* Less threads in clickhouse-local, fix Ok. printing [#30282](https://github.com/ClickHouse/ClickHouse/pull/30282) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Adjust resource heavy tests [#30284](https://github.com/ClickHouse/ClickHouse/pull/30284) ([Raúl Marín](https://github.com/Algunenano)).
* Fix printing stacktraces for clickhouse-local [#30285](https://github.com/ClickHouse/ClickHouse/pull/30285) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix throwing syntax exception in clickhouse-local [#30288](https://github.com/ClickHouse/ClickHouse/pull/30288) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Various fixes to install procedure [#30295](https://github.com/ClickHouse/ClickHouse/pull/30295) ([Denis Glazachev](https://github.com/traceon)).
* Fix clickhouse-local break on timeout [#30297](https://github.com/ClickHouse/ClickHouse/pull/30297) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add RISC-V build [#30298](https://github.com/ClickHouse/ClickHouse/pull/30298) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Move SquashingTransform to Interpreters (to fix split build) [#30318](https://github.com/ClickHouse/ClickHouse/pull/30318) ([Azat Khuzhin](https://github.com/azat)).
* Increase default wait of the server start in clickhouse-test [#30320](https://github.com/ClickHouse/ClickHouse/pull/30320) ([Azat Khuzhin](https://github.com/azat)).
* Update memory optimisation for MergingSorted. [#30322](https://github.com/ClickHouse/ClickHouse/pull/30322) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Single sorting step [#30335](https://github.com/ClickHouse/ClickHouse/pull/30335) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Send table columns in clickhouse-local [#30336](https://github.com/ClickHouse/ClickHouse/pull/30336) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix consumed memory indication in clickhouse-client  [#30337](https://github.com/ClickHouse/ClickHouse/pull/30337) ([Dmitry Novik](https://github.com/novikd)).
* Fix fuzzer build [#30344](https://github.com/ClickHouse/ClickHouse/pull/30344) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* ExecutablePool dictionary source fix borrow timeout milliseconds [#30345](https://github.com/ClickHouse/ClickHouse/pull/30345) ([Maksim Kita](https://github.com/kitaisreal)).
* StorageExecutable fix small issues [#30352](https://github.com/ClickHouse/ClickHouse/pull/30352) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix ca-bundle.crt in kerberized_hadoop/Dockerfile [#30358](https://github.com/ClickHouse/ClickHouse/pull/30358) ([Vladimir C](https://github.com/vdimir)).
* Update obsolete comments. [#30359](https://github.com/ClickHouse/ClickHouse/pull/30359) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Rename readWkt* functions to readWKT*, added an alias SVG for svg function [#30361](https://github.com/ClickHouse/ClickHouse/pull/30361) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Fix crash when minmax_count projection is used with primary key in partition expr [#30384](https://github.com/ClickHouse/ClickHouse/pull/30384) ([Amos Bird](https://github.com/amosbird)).
* Follow-up for [#30282](https://github.com/ClickHouse/ClickHouse/issues/30282) [#30412](https://github.com/ClickHouse/ClickHouse/pull/30412) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ExecutableUDF example [#30436](https://github.com/ClickHouse/ClickHouse/pull/30436) ([Maksim Kita](https://github.com/kitaisreal)).
* Use robot token in actions for statuses [#30439](https://github.com/ClickHouse/ClickHouse/pull/30439) ([alesapin](https://github.com/alesapin)).
* Remove statuses from actions [#30444](https://github.com/ClickHouse/ClickHouse/pull/30444) ([alesapin](https://github.com/alesapin)).
* Fix s3 for github actions [#30447](https://github.com/ClickHouse/ClickHouse/pull/30447) ([alesapin](https://github.com/alesapin)).
* ExecutableUDF example fix style check [#30451](https://github.com/ClickHouse/ClickHouse/pull/30451) ([Maksim Kita](https://github.com/kitaisreal)).
* Support VALUES format in async inserts [#30456](https://github.com/ClickHouse/ClickHouse/pull/30456) ([Anton Popov](https://github.com/CurtizJ)).
* Update release date and add training link [#30475](https://github.com/ClickHouse/ClickHouse/pull/30475) ([Cody Baker](https://github.com/codyrobert)).
* Fix horizontal scroll bar [#30476](https://github.com/ClickHouse/ClickHouse/pull/30476) ([Cody Baker](https://github.com/codyrobert)).
* SQLUserDefinedFunctions composition fix [#30483](https://github.com/ClickHouse/ClickHouse/pull/30483) ([Maksim Kita](https://github.com/kitaisreal)).
* Trying builds on github actions [#30493](https://github.com/ClickHouse/ClickHouse/pull/30493) ([alesapin](https://github.com/alesapin)).
* HashedArrayDictionary optimize read multiple attributes [#30501](https://github.com/ClickHouse/ClickHouse/pull/30501) ([Maksim Kita](https://github.com/kitaisreal)).
* StorageDictionary fix potential configuration race [#30502](https://github.com/ClickHouse/ClickHouse/pull/30502) ([Maksim Kita](https://github.com/kitaisreal)).
* Fix style regressions on benchmark page [#30506](https://github.com/ClickHouse/ClickHouse/pull/30506) ([Cody Baker](https://github.com/codyrobert)).
* Change link in nav from community -> learn [#30508](https://github.com/ClickHouse/ClickHouse/pull/30508) ([Cody Baker](https://github.com/codyrobert)).
* Add placeholder to play.html inputs [#30509](https://github.com/ClickHouse/ClickHouse/pull/30509) ([Vitaly Orlov](https://github.com/orloffv)).
* Add bytes to stats and human readable rows to play.html [#30511](https://github.com/ClickHouse/ClickHouse/pull/30511) ([Vitaly Orlov](https://github.com/orloffv)).
* clickhouse-local: fix block lost in interactive mode [#30521](https://github.com/ClickHouse/ClickHouse/pull/30521) ([Azat Khuzhin](https://github.com/azat)).
* Remove check_columns argument from MergeTree code (false was never passed) [#30522](https://github.com/ClickHouse/ClickHouse/pull/30522) ([Azat Khuzhin](https://github.com/azat)).
* Fix typo and update NuRaft [#30550](https://github.com/ClickHouse/ClickHouse/pull/30550) ([alesapin](https://github.com/alesapin)).
* Refactoring in codec encrypted [#30564](https://github.com/ClickHouse/ClickHouse/pull/30564) ([Filatenkov Artur](https://github.com/FArthur-cmd)).
* Try to fix [#30397](https://github.com/ClickHouse/ClickHouse/issues/30397) [#30565](https://github.com/ClickHouse/ClickHouse/pull/30565) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Support Nullable(String) type in arrayStringConcat [#30566](https://github.com/ClickHouse/ClickHouse/pull/30566) ([Nikita Taranov](https://github.com/nickitat)).
* Function ngrams fixed tests [#30567](https://github.com/ClickHouse/ClickHouse/pull/30567) ([Maksim Kita](https://github.com/kitaisreal)).
* Test clickhouse local columns description fix number [#30568](https://github.com/ClickHouse/ClickHouse/pull/30568) ([Maksim Kita](https://github.com/kitaisreal)).
* Update documentation for distributed_push_down_limit [#30577](https://github.com/ClickHouse/ClickHouse/pull/30577) ([Azat Khuzhin](https://github.com/azat)).
* Fix tests that relies on checking stack size under TSan [#30579](https://github.com/ClickHouse/ClickHouse/pull/30579) ([Azat Khuzhin](https://github.com/azat)).
* Add metadata for *_log into tests artifacts [#30589](https://github.com/ClickHouse/ClickHouse/pull/30589) ([Azat Khuzhin](https://github.com/azat)).
* Fix LOGICAL_ERROR on connection draining in case of ECONNRESET [#30594](https://github.com/ClickHouse/ClickHouse/pull/30594) ([Azat Khuzhin](https://github.com/azat)).
* Adjust perf test for simdjson [#30596](https://github.com/ClickHouse/ClickHouse/pull/30596) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update minimum allowed compiler versions [#30597](https://github.com/ClickHouse/ClickHouse/pull/30597) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Replace estimated_size with optional<size> for readFile/createReadBufferFromFileBase [#30611](https://github.com/ClickHouse/ClickHouse/pull/30611) ([Azat Khuzhin](https://github.com/azat)).
* RFC: Relax minimal clang version (set it to 12, was 13) [#30613](https://github.com/ClickHouse/ClickHouse/pull/30613) ([Azat Khuzhin](https://github.com/azat)).
* clickhouse-test: increase delay for initial SELECT 1 check [#30619](https://github.com/ClickHouse/ClickHouse/pull/30619) ([Azat Khuzhin](https://github.com/azat)).
* Update Client.cpp [#30636](https://github.com/ClickHouse/ClickHouse/pull/30636) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update LocalServer.cpp [#30637](https://github.com/ClickHouse/ClickHouse/pull/30637) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Typo fix in play.html [#30638](https://github.com/ClickHouse/ClickHouse/pull/30638) ([Vitaly Orlov](https://github.com/orloffv)).
* Fix argument types for now and now64 [#30639](https://github.com/ClickHouse/ClickHouse/pull/30639) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix intersecting parts in `parts_to_do` [#30651](https://github.com/ClickHouse/ClickHouse/pull/30651) ([Alexander Tokmakov](https://github.com/tavplubix)).
* HashedDictionaries added read performance tests [#30653](https://github.com/ClickHouse/ClickHouse/pull/30653) ([Maksim Kita](https://github.com/kitaisreal)).
* Change `alter_lock` from `RWLock` to `std::timed_mutex` [#30658](https://github.com/ClickHouse/ClickHouse/pull/30658) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Initialize custom TLDs in clickhouse-local [#30660](https://github.com/ClickHouse/ClickHouse/pull/30660) ([Azat Khuzhin](https://github.com/azat)).
* Add QueryProfilerRuns profile event [#30661](https://github.com/ClickHouse/ClickHouse/pull/30661) ([Azat Khuzhin](https://github.com/azat)).
* Switch everything left from `<yandex>` to `<clickhouse>` [#30662](https://github.com/ClickHouse/ClickHouse/pull/30662) ([Azat Khuzhin](https://github.com/azat)).
* Improve usability of `remote_url_allow_hosts` [#30673](https://github.com/ClickHouse/ClickHouse/pull/30673) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix indecency [#30337](https://github.com/ClickHouse/ClickHouse/issues/30337) [#30674](https://github.com/ClickHouse/ClickHouse/pull/30674) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better wait for server start in integration tests [#30677](https://github.com/ClickHouse/ClickHouse/pull/30677) ([alesapin](https://github.com/alesapin)).
* Fix keeper zookeeper converter test [#30678](https://github.com/ClickHouse/ClickHouse/pull/30678) ([alesapin](https://github.com/alesapin)).
* Don't run build checks for documentation [#30681](https://github.com/ClickHouse/ClickHouse/pull/30681) ([alesapin](https://github.com/alesapin)).
* Refactoring of Log family [#30689](https://github.com/ClickHouse/ClickHouse/pull/30689) ([Vitaly Baranov](https://github.com/vitlibar)).
* Update hardware page colors [#30719](https://github.com/ClickHouse/ClickHouse/pull/30719) ([Cody Baker](https://github.com/codyrobert)).
* Fix test_part_uuid::test_part_uuid_wal [#30723](https://github.com/ClickHouse/ClickHouse/pull/30723) ([Azat Khuzhin](https://github.com/azat)).
* Fix gtest_disk_encrypted (for new readFile/createReadBufferFromFileBase() interfaces) [#30725](https://github.com/ClickHouse/ClickHouse/pull/30725) ([Azat Khuzhin](https://github.com/azat)).
* tests/ci/docker_images_check: add missing time import [#30727](https://github.com/ClickHouse/ClickHouse/pull/30727) ([Azat Khuzhin](https://github.com/azat)).
* Add functional tests to github actions [#30729](https://github.com/ClickHouse/ClickHouse/pull/30729) ([alesapin](https://github.com/alesapin)).
* Run pylint over python scripts for github actions [#30733](https://github.com/ClickHouse/ClickHouse/pull/30733) ([Azat Khuzhin](https://github.com/azat)).
* DictionarySource unknown column name in dictionary fix [#30736](https://github.com/ClickHouse/ClickHouse/pull/30736) ([Maksim Kita](https://github.com/kitaisreal)).
* Update 01083_expressions_in_engine_arguments.sql [#30741](https://github.com/ClickHouse/ClickHouse/pull/30741) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Performance tests tuning [#30773](https://github.com/ClickHouse/ClickHouse/pull/30773) ([Azat Khuzhin](https://github.com/azat)).
* Remove cruft [#30780](https://github.com/ClickHouse/ClickHouse/pull/30780) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test 02022 [#30786](https://github.com/ClickHouse/ClickHouse/pull/30786) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Trying to make fuzzer check less hardcoded [#30795](https://github.com/ClickHouse/ClickHouse/pull/30795) ([alesapin](https://github.com/alesapin)).
* DictionarySource unknown column name fix [#30800](https://github.com/ClickHouse/ClickHouse/pull/30800) ([Maksim Kita](https://github.com/kitaisreal)).
* Add funding press release [#30806](https://github.com/ClickHouse/ClickHouse/pull/30806) ([Cody Baker](https://github.com/codyrobert)).
* Update installation success message [#30672](https://github.com/ClickHouse/ClickHouse/issues/30672) [#30830](https://github.com/ClickHouse/ClickHouse/pull/30830) ([Teja](https://github.com/tejasrivastav)).
* filelog engine tests improve [#30832](https://github.com/ClickHouse/ClickHouse/pull/30832) ([flynn](https://github.com/ucasfl)).
* Remove redundant from http buffer [#30837](https://github.com/ClickHouse/ClickHouse/pull/30837) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Docs check on github actions [#30839](https://github.com/ClickHouse/ClickHouse/pull/30839) ([alesapin](https://github.com/alesapin)).
* Fix fuzzer on master [#30841](https://github.com/ClickHouse/ClickHouse/pull/30841) ([alesapin](https://github.com/alesapin)).
* Disable check for ZooKeeper session uptime by default [#30847](https://github.com/ClickHouse/ClickHouse/pull/30847) ([Alexander Tokmakov](https://github.com/tavplubix)).
* enable modify table comment of rest table engine [#30852](https://github.com/ClickHouse/ClickHouse/pull/30852) ([flynn](https://github.com/ucasfl)).
* Fix typo [#30853](https://github.com/ClickHouse/ClickHouse/pull/30853) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixed `--disable-net-host` in `runner` [#30863](https://github.com/ClickHouse/ClickHouse/pull/30863) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Fix protocol revision. [#30864](https://github.com/ClickHouse/ClickHouse/pull/30864) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add docker cleanup after actions [#30868](https://github.com/ClickHouse/ClickHouse/pull/30868) ([alesapin](https://github.com/alesapin)).
* Fix error message in Keeper handler [#30880](https://github.com/ClickHouse/ClickHouse/pull/30880) ([alesapin](https://github.com/alesapin)).
* Better handling of `xtables.lock` in `runner` [#30892](https://github.com/ClickHouse/ClickHouse/pull/30892) ([Vladimir Chebotarev](https://github.com/excitoon)).
* Reimplement [#28639](https://github.com/ClickHouse/ClickHouse/issues/28639) [#30903](https://github.com/ClickHouse/ClickHouse/pull/30903) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Miscellaneous [#30917](https://github.com/ClickHouse/ClickHouse/pull/30917) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix yml in docs release [#30928](https://github.com/ClickHouse/ClickHouse/pull/30928) ([alesapin](https://github.com/alesapin)).
* Debug github event [#30929](https://github.com/ClickHouse/ClickHouse/pull/30929) ([alesapin](https://github.com/alesapin)).
* Fix docs release [#30933](https://github.com/ClickHouse/ClickHouse/pull/30933) ([alesapin](https://github.com/alesapin)).
* Fix style check [#30937](https://github.com/ClickHouse/ClickHouse/pull/30937) ([alesapin](https://github.com/alesapin)).
* Fix file progress for clickhouse-local [#30938](https://github.com/ClickHouse/ClickHouse/pull/30938) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix flaky test [#30940](https://github.com/ClickHouse/ClickHouse/pull/30940) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix reading from TinyLog [#30941](https://github.com/ClickHouse/ClickHouse/pull/30941) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add github to known hosts in docs release [#30947](https://github.com/ClickHouse/ClickHouse/pull/30947) ([alesapin](https://github.com/alesapin)).
* Parse json from response in ci checks [#30948](https://github.com/ClickHouse/ClickHouse/pull/30948) ([alesapin](https://github.com/alesapin)).

#### Testing Improvement

* Implemented structure-aware fuzzing approach in ClickHouse for select statement parser. [#30012](https://github.com/ClickHouse/ClickHouse/pull/30012) ([Paul](https://github.com/PaulCher)).
