#!/usr/bin/env bash
set -ueo pipefail

# A script to generate README.sh close to as it done in https://github.com/docker-library/docs

WORKDIR=$(dirname "$0")
SCRIPT_NAME=$(basename "$0")
CONTENT=README.src/content.md
LICENSE=README.src/license.md
cd "$WORKDIR"

R=README.md

cat > "$R" <<EOD
<!---
The $R is generated by $SCRIPT_NAME from the following sources:
- $CONTENT
- $LICENSE

If you want to change it, edit these files
-->

EOD

cat "$CONTENT" >> "$R"

cat >> "$R" <<EOD

## License

$(cat $LICENSE)
EOD

# Remove %%LOGO%% from the file with one line below
sed -i '/^%%LOGO%%/,+1d' "$R"

# Replace each %%IMAGE%% with our `clickhouse/clickhouse-server`
sed -i '/%%IMAGE%%/s:%%IMAGE%%:clickhouse/clickhouse-server:g' $R
