package Monitoring::GLPlugin::SNMP::MibsAndOids::OSPFV3MIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'OSPFV3-MIB'} = {
  url => 'https://tools.ietf.org/html/rfc5643',
  name => 'OSPFV3-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'OSPFV3-MIB'} =
    '1.3.6.1.2.1.191';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'OSPFV3-MIB'} = {
  ospfv3MIB => '1.3.6.1.2.1.191',
  ospfv3Notifications => '1.3.6.1.2.1.191.0',
  ospfv3Objects => '1.3.6.1.2.1.191.1',
  ospfv3GeneralGroup => '1.3.6.1.2.1.191.1.1',
  ospfv3RouterId => '1.3.6.1.2.1.191.1.1.1',
  ospfv3AdminStatus => '1.3.6.1.2.1.191.1.1.2',
  ospfv3VersionNumber => '1.3.6.1.2.1.191.1.1.3',
  ospfv3VersionNumberDefinition => 'OSPFV3-MIB::ospfv3VersionNumber',
  ospfv3AreaBdrRtrStatus => '1.3.6.1.2.1.191.1.1.4',
  ospfv3ASBdrRtrStatus => '1.3.6.1.2.1.191.1.1.5',
  ospfv3AsScopeLsaCount => '1.3.6.1.2.1.191.1.1.6',
  ospfv3AsScopeLsaCksumSum => '1.3.6.1.2.1.191.1.1.7',
  ospfv3OriginateNewLsas => '1.3.6.1.2.1.191.1.1.8',
  ospfv3RxNewLsas => '1.3.6.1.2.1.191.1.1.9',
  ospfv3ExtLsaCount => '1.3.6.1.2.1.191.1.1.10',
  ospfv3ExtAreaLsdbLimit => '1.3.6.1.2.1.191.1.1.11',
  ospfv3ExitOverflowInterval => '1.3.6.1.2.1.191.1.1.12',
  ospfv3DemandExtensions => '1.3.6.1.2.1.191.1.1.13',
  ospfv3ReferenceBandwidth => '1.3.6.1.2.1.191.1.1.14',
  ospfv3RestartSupport => '1.3.6.1.2.1.191.1.1.15',
  ospfv3RestartSupportDefinition => 'OSPFV3-MIB::ospfv3RestartSupport',
  ospfv3RestartInterval => '1.3.6.1.2.1.191.1.1.16',
  ospfv3RestartStrictLsaChecking => '1.3.6.1.2.1.191.1.1.17',
  ospfv3RestartStatus => '1.3.6.1.2.1.191.1.1.18',
  ospfv3RestartStatusDefinition => 'OSPFV3-MIB::ospfv3RestartStatus',
  ospfv3RestartAge => '1.3.6.1.2.1.191.1.1.19',
  ospfv3RestartExitReason => '1.3.6.1.2.1.191.1.1.20',
  ospfv3RestartExitReasonDefinition => 'OSPFV3-MIB::ospfv3RestartExitReason',
  ospfv3NotificationEnable => '1.3.6.1.2.1.191.1.1.21',
  ospfv3StubRouterSupport => '1.3.6.1.2.1.191.1.1.22',
  ospfv3StubRouterAdvertisement => '1.3.6.1.2.1.191.1.1.23',
  ospfv3StubRouterAdvertisementDefinition => 'OSPFV3-MIB::ospfv3StubRouterAdvertisement',
  ospfv3DiscontinuityTime => '1.3.6.1.2.1.191.1.1.24',
  ospfv3RestartTime => '1.3.6.1.2.1.191.1.1.25',
  ospfv3AreaTable => '1.3.6.1.2.1.191.1.2',
  ospfv3AreaEntry => '1.3.6.1.2.1.191.1.2.1',
  ospfv3AreaId => '1.3.6.1.2.1.191.1.2.1.1',
  ospfv3AreaImportAsExtern => '1.3.6.1.2.1.191.1.2.1.2',
  ospfv3AreaImportAsExternDefinition => 'OSPFV3-MIB::ospfv3AreaImportAsExtern',
  ospfv3AreaSpfRuns => '1.3.6.1.2.1.191.1.2.1.3',
  ospfv3AreaBdrRtrCount => '1.3.6.1.2.1.191.1.2.1.4',
  ospfv3AreaAsBdrRtrCount => '1.3.6.1.2.1.191.1.2.1.5',
  ospfv3AreaScopeLsaCount => '1.3.6.1.2.1.191.1.2.1.6',
  ospfv3AreaScopeLsaCksumSum => '1.3.6.1.2.1.191.1.2.1.7',
  ospfv3AreaSummary => '1.3.6.1.2.1.191.1.2.1.8',
  ospfv3AreaSummaryDefinition => 'OSPFV3-MIB::ospfv3AreaSummary',
  ospfv3AreaRowStatus => '1.3.6.1.2.1.191.1.2.1.9',
  ospfv3AreaStubMetric => '1.3.6.1.2.1.191.1.2.1.10',
  ospfv3AreaNssaTranslatorRole => '1.3.6.1.2.1.191.1.2.1.11',
  ospfv3AreaNssaTranslatorRoleDefinition => 'OSPFV3-MIB::ospfv3AreaNssaTranslatorRole',
  ospfv3AreaNssaTranslatorState => '1.3.6.1.2.1.191.1.2.1.12',
  ospfv3AreaNssaTranslatorStateDefinition => 'OSPFV3-MIB::ospfv3AreaNssaTranslatorState',
  ospfv3AreaNssaTranslatorStabInterval => '1.3.6.1.2.1.191.1.2.1.13',
  ospfv3AreaNssaTranslatorEvents => '1.3.6.1.2.1.191.1.2.1.14',
  ospfv3AreaStubMetricType => '1.3.6.1.2.1.191.1.2.1.15',
  ospfv3AreaStubMetricTypeDefinition => 'OSPFV3-MIB::ospfv3AreaStubMetricType',
  ospfv3AreaTEEnabled => '1.3.6.1.2.1.191.1.2.1.16',
  ospfv3AsLsdbTable => '1.3.6.1.2.1.191.1.3',
  ospfv3AsLsdbEntry => '1.3.6.1.2.1.191.1.3.1',
  ospfv3AsLsdbType => '1.3.6.1.2.1.191.1.3.1.1',
  ospfv3AsLsdbRouterId => '1.3.6.1.2.1.191.1.3.1.2',
  ospfv3AsLsdbLsid => '1.3.6.1.2.1.191.1.3.1.3',
  ospfv3AsLsdbSequence => '1.3.6.1.2.1.191.1.3.1.4',
  ospfv3AsLsdbAge => '1.3.6.1.2.1.191.1.3.1.5',
  ospfv3AsLsdbChecksum => '1.3.6.1.2.1.191.1.3.1.6',
  ospfv3AsLsdbAdvertisement => '1.3.6.1.2.1.191.1.3.1.7',
  ospfv3AsLsdbTypeKnown => '1.3.6.1.2.1.191.1.3.1.8',
  ospfv3AreaLsdbTable => '1.3.6.1.2.1.191.1.4',
  ospfv3AreaLsdbEntry => '1.3.6.1.2.1.191.1.4.1',
  ospfv3AreaLsdbAreaId => '1.3.6.1.2.1.191.1.4.1.1',
  ospfv3AreaLsdbType => '1.3.6.1.2.1.191.1.4.1.2',
  ospfv3AreaLsdbRouterId => '1.3.6.1.2.1.191.1.4.1.3',
  ospfv3AreaLsdbLsid => '1.3.6.1.2.1.191.1.4.1.4',
  ospfv3AreaLsdbSequence => '1.3.6.1.2.1.191.1.4.1.5',
  ospfv3AreaLsdbAge => '1.3.6.1.2.1.191.1.4.1.6',
  ospfv3AreaLsdbChecksum => '1.3.6.1.2.1.191.1.4.1.7',
  ospfv3AreaLsdbAdvertisement => '1.3.6.1.2.1.191.1.4.1.8',
  ospfv3AreaLsdbTypeKnown => '1.3.6.1.2.1.191.1.4.1.9',
  ospfv3LinkLsdbTable => '1.3.6.1.2.1.191.1.5',
  ospfv3LinkLsdbEntry => '1.3.6.1.2.1.191.1.5.1',
  ospfv3LinkLsdbIfIndex => '1.3.6.1.2.1.191.1.5.1.1',
  ospfv3LinkLsdbIfInstId => '1.3.6.1.2.1.191.1.5.1.2',
  ospfv3LinkLsdbType => '1.3.6.1.2.1.191.1.5.1.3',
  ospfv3LinkLsdbRouterId => '1.3.6.1.2.1.191.1.5.1.4',
  ospfv3LinkLsdbLsid => '1.3.6.1.2.1.191.1.5.1.5',
  ospfv3LinkLsdbSequence => '1.3.6.1.2.1.191.1.5.1.6',
  ospfv3LinkLsdbAge => '1.3.6.1.2.1.191.1.5.1.7',
  ospfv3LinkLsdbChecksum => '1.3.6.1.2.1.191.1.5.1.8',
  ospfv3LinkLsdbAdvertisement => '1.3.6.1.2.1.191.1.5.1.9',
  ospfv3LinkLsdbTypeKnown => '1.3.6.1.2.1.191.1.5.1.10',
  ospfv3HostTable => '1.3.6.1.2.1.191.1.6',
  ospfv3HostEntry => '1.3.6.1.2.1.191.1.6.1',
  ospfv3HostAddressType => '1.3.6.1.2.1.191.1.6.1.1',
  ospfv3HostAddress => '1.3.6.1.2.1.191.1.6.1.2',
  ospfv3HostMetric => '1.3.6.1.2.1.191.1.6.1.3',
  ospfv3HostRowStatus => '1.3.6.1.2.1.191.1.6.1.4',
  ospfv3HostAreaID => '1.3.6.1.2.1.191.1.6.1.5',
  ospfv3IfTable => '1.3.6.1.2.1.191.1.7',
  ospfv3IfEntry => '1.3.6.1.2.1.191.1.7.1',
  ospfv3IfIndex => '1.3.6.1.2.1.191.1.7.1.1',
  ospfv3IfInstId => '1.3.6.1.2.1.191.1.7.1.2',
  ospfv3IfAreaId => '1.3.6.1.2.1.191.1.7.1.3',
  ospfv3IfType => '1.3.6.1.2.1.191.1.7.1.4',
  ospfv3IfTypeDefinition => 'OSPFV3-MIB::ospfv3IfType',
  ospfv3IfAdminStatus => '1.3.6.1.2.1.191.1.7.1.5',
  ospfv3IfRtrPriority => '1.3.6.1.2.1.191.1.7.1.6',
  ospfv3IfTransitDelay => '1.3.6.1.2.1.191.1.7.1.7',
  ospfv3IfRetransInterval => '1.3.6.1.2.1.191.1.7.1.8',
  ospfv3IfHelloInterval => '1.3.6.1.2.1.191.1.7.1.9',
  ospfv3IfRtrDeadInterval => '1.3.6.1.2.1.191.1.7.1.10',
  ospfv3IfPollInterval => '1.3.6.1.2.1.191.1.7.1.11',
  ospfv3IfState => '1.3.6.1.2.1.191.1.7.1.12',
  ospfv3IfStateDefinition => 'OSPFV3-MIB::ospfv3IfState',
  ospfv3IfDesignatedRouter => '1.3.6.1.2.1.191.1.7.1.13',
  ospfv3IfBackupDesignatedRouter => '1.3.6.1.2.1.191.1.7.1.14',
  ospfv3IfEvents => '1.3.6.1.2.1.191.1.7.1.15',
  ospfv3IfRowStatus => '1.3.6.1.2.1.191.1.7.1.16',
  ospfv3IfDemand => '1.3.6.1.2.1.191.1.7.1.17',
  ospfv3IfMetricValue => '1.3.6.1.2.1.191.1.7.1.18',
  ospfv3IfLinkScopeLsaCount => '1.3.6.1.2.1.191.1.7.1.19',
  ospfv3IfLinkLsaCksumSum => '1.3.6.1.2.1.191.1.7.1.20',
  ospfv3IfDemandNbrProbe => '1.3.6.1.2.1.191.1.7.1.21',
  ospfv3IfDemandNbrProbeRetransLimit => '1.3.6.1.2.1.191.1.7.1.22',
  ospfv3IfDemandNbrProbeInterval => '1.3.6.1.2.1.191.1.7.1.23',
  ospfv3IfTEDisabled => '1.3.6.1.2.1.191.1.7.1.24',
  ospfv3IfLinkLSASuppression => '1.3.6.1.2.1.191.1.7.1.25',
  ospfv3VirtIfTable => '1.3.6.1.2.1.191.1.8',
  ospfv3VirtIfEntry => '1.3.6.1.2.1.191.1.8.1',
  ospfv3VirtIfAreaId => '1.3.6.1.2.1.191.1.8.1.1',
  ospfv3VirtIfNeighbor => '1.3.6.1.2.1.191.1.8.1.2',
  ospfv3VirtIfIndex => '1.3.6.1.2.1.191.1.8.1.3',
  ospfv3VirtIfInstId => '1.3.6.1.2.1.191.1.8.1.4',
  ospfv3VirtIfTransitDelay => '1.3.6.1.2.1.191.1.8.1.5',
  ospfv3VirtIfRetransInterval => '1.3.6.1.2.1.191.1.8.1.6',
  ospfv3VirtIfHelloInterval => '1.3.6.1.2.1.191.1.8.1.7',
  ospfv3VirtIfRtrDeadInterval => '1.3.6.1.2.1.191.1.8.1.8',
  ospfv3VirtIfState => '1.3.6.1.2.1.191.1.8.1.9',
  ospfv3VirtIfStateDefinition => 'OSPFV3-MIB::ospfv3VirtIfState',
  ospfv3VirtIfEvents => '1.3.6.1.2.1.191.1.8.1.10',
  ospfv3VirtIfRowStatus => '1.3.6.1.2.1.191.1.8.1.11',
  ospfv3VirtIfLinkScopeLsaCount => '1.3.6.1.2.1.191.1.8.1.12',
  ospfv3VirtIfLinkLsaCksumSum => '1.3.6.1.2.1.191.1.8.1.13',
  ospfv3NbrTable => '1.3.6.1.2.1.191.1.9',
  ospfv3NbrEntry => '1.3.6.1.2.1.191.1.9.1',
  ospfv3NbrIfIndex => '1.3.6.1.2.1.191.1.9.1.1',
  ospfv3NbrIfInstId => '1.3.6.1.2.1.191.1.9.1.2',
  ospfv3NbrRtrId => '1.3.6.1.2.1.191.1.9.1.3',
  ospfv3NbrAddressType => '1.3.6.1.2.1.191.1.9.1.4',
  ospfv3NbrAddressTypeDefinition => 'INET-ADDRESS-MIB::InetAddressType',
  ospfv3NbrAddress => '1.3.6.1.2.1.191.1.9.1.5',
  ospfv3NbrAddressDefinition => 'INET-ADDRESS-MIB::InetAddress(ospfv3NbrAddressType)',
  ospfv3NbrOptions => '1.3.6.1.2.1.191.1.9.1.6',
  ospfv3NbrPriority => '1.3.6.1.2.1.191.1.9.1.7',
  ospfv3NbrState => '1.3.6.1.2.1.191.1.9.1.8',
  ospfv3NbrStateDefinition => 'OSPFV3-MIB::ospfv3NbrState',
  ospfv3NbrEvents => '1.3.6.1.2.1.191.1.9.1.9',
  ospfv3NbrLsRetransQLen => '1.3.6.1.2.1.191.1.9.1.10',
  ospfv3NbrHelloSuppressed => '1.3.6.1.2.1.191.1.9.1.11',
  ospfv3NbrIfId => '1.3.6.1.2.1.191.1.9.1.12',
  ospfv3NbrRestartHelperStatus => '1.3.6.1.2.1.191.1.9.1.13',
  ospfv3NbrRestartHelperStatusDefinition => 'OSPFV3-MIB::ospfv3NbrRestartHelperStatus',
  ospfv3NbrRestartHelperAge => '1.3.6.1.2.1.191.1.9.1.14',
  ospfv3NbrRestartHelperExitReason => '1.3.6.1.2.1.191.1.9.1.15',
  ospfv3NbrRestartHelperExitReasonDefinition => 'OSPFV3-MIB::ospfv3NbrRestartHelperExitReason',
  ospfv3CfgNbrTable => '1.3.6.1.2.1.191.1.10',
  ospfv3CfgNbrEntry => '1.3.6.1.2.1.191.1.10.1',
  ospfv3CfgNbrIfIndex => '1.3.6.1.2.1.191.1.10.1.1',
  ospfv3CfgNbrIfInstId => '1.3.6.1.2.1.191.1.10.1.2',
  ospfv3CfgNbrAddressType => '1.3.6.1.2.1.191.1.10.1.3',
  ospfv3CfgNbrAddress => '1.3.6.1.2.1.191.1.10.1.4',
  ospfv3CfgNbrPriority => '1.3.6.1.2.1.191.1.10.1.5',
  ospfv3CfgNbrRowStatus => '1.3.6.1.2.1.191.1.10.1.6',
  ospfv3VirtNbrTable => '1.3.6.1.2.1.191.1.11',
  ospfv3VirtNbrEntry => '1.3.6.1.2.1.191.1.11.1',
  ospfv3VirtNbrArea => '1.3.6.1.2.1.191.1.11.1.1',
  ospfv3VirtNbrRtrId => '1.3.6.1.2.1.191.1.11.1.2',
  ospfv3VirtNbrIfIndex => '1.3.6.1.2.1.191.1.11.1.3',
  ospfv3VirtNbrIfInstId => '1.3.6.1.2.1.191.1.11.1.4',
  ospfv3VirtNbrAddressType => '1.3.6.1.2.1.191.1.11.1.5',
  ospfv3VirtNbrAddress => '1.3.6.1.2.1.191.1.11.1.6',
  ospfv3VirtNbrOptions => '1.3.6.1.2.1.191.1.11.1.7',
  ospfv3VirtNbrState => '1.3.6.1.2.1.191.1.11.1.8',
  ospfv3VirtNbrStateDefinition => 'OSPFV3-MIB::ospfv3VirtNbrState',
  ospfv3VirtNbrEvents => '1.3.6.1.2.1.191.1.11.1.9',
  ospfv3VirtNbrLsRetransQLen => '1.3.6.1.2.1.191.1.11.1.10',
  ospfv3VirtNbrHelloSuppressed => '1.3.6.1.2.1.191.1.11.1.11',
  ospfv3VirtNbrIfId => '1.3.6.1.2.1.191.1.11.1.12',
  ospfv3VirtNbrRestartHelperStatus => '1.3.6.1.2.1.191.1.11.1.13',
  ospfv3VirtNbrRestartHelperStatusDefinition => 'OSPFV3-MIB::ospfv3VirtNbrRestartHelperStatus',
  ospfv3VirtNbrRestartHelperAge => '1.3.6.1.2.1.191.1.11.1.14',
  ospfv3VirtNbrRestartHelperExitReason => '1.3.6.1.2.1.191.1.11.1.15',
  ospfv3VirtNbrRestartHelperExitReasonDefinition => 'OSPFV3-MIB::ospfv3VirtNbrRestartHelperExitReason',
  ospfv3AreaAggregateTable => '1.3.6.1.2.1.191.1.12',
  ospfv3AreaAggregateEntry => '1.3.6.1.2.1.191.1.12.1',
  ospfv3AreaAggregateAreaID => '1.3.6.1.2.1.191.1.12.1.1',
  ospfv3AreaAggregateAreaLsdbType => '1.3.6.1.2.1.191.1.12.1.2',
  ospfv3AreaAggregateAreaLsdbTypeDefinition => 'OSPFV3-MIB::ospfv3AreaAggregateAreaLsdbType',
  ospfv3AreaAggregatePrefixType => '1.3.6.1.2.1.191.1.12.1.3',
  ospfv3AreaAggregatePrefix => '1.3.6.1.2.1.191.1.12.1.4',
  ospfv3AreaAggregatePrefixLength => '1.3.6.1.2.1.191.1.12.1.5',
  ospfv3AreaAggregateRowStatus => '1.3.6.1.2.1.191.1.12.1.6',
  ospfv3AreaAggregateEffect => '1.3.6.1.2.1.191.1.12.1.7',
  ospfv3AreaAggregateEffectDefinition => 'OSPFV3-MIB::ospfv3AreaAggregateEffect',
  ospfv3AreaAggregateRouteTag => '1.3.6.1.2.1.191.1.12.1.8',
  ospfv3VirtLinkLsdbTable => '1.3.6.1.2.1.191.1.13',
  ospfv3VirtLinkLsdbEntry => '1.3.6.1.2.1.191.1.13.1',
  ospfv3VirtLinkLsdbIfAreaId => '1.3.6.1.2.1.191.1.13.1.1',
  ospfv3VirtLinkLsdbIfNeighbor => '1.3.6.1.2.1.191.1.13.1.2',
  ospfv3VirtLinkLsdbType => '1.3.6.1.2.1.191.1.13.1.3',
  ospfv3VirtLinkLsdbRouterId => '1.3.6.1.2.1.191.1.13.1.4',
  ospfv3VirtLinkLsdbLsid => '1.3.6.1.2.1.191.1.13.1.5',
  ospfv3VirtLinkLsdbSequence => '1.3.6.1.2.1.191.1.13.1.6',
  ospfv3VirtLinkLsdbAge => '1.3.6.1.2.1.191.1.13.1.7',
  ospfv3VirtLinkLsdbChecksum => '1.3.6.1.2.1.191.1.13.1.8',
  ospfv3VirtLinkLsdbAdvertisement => '1.3.6.1.2.1.191.1.13.1.9',
  ospfv3VirtLinkLsdbTypeKnown => '1.3.6.1.2.1.191.1.13.1.10',
  ospfv3NotificationEntry => '1.3.6.1.2.1.191.1.14',
  ospfv3ConfigErrorType => '1.3.6.1.2.1.191.1.14.1',
  ospfv3ConfigErrorTypeDefinition => 'OSPFV3-MIB::ospfv3ConfigErrorType',
  ospfv3PacketType => '1.3.6.1.2.1.191.1.14.2',
  ospfv3PacketTypeDefinition => 'OSPFV3-MIB::ospfv3PacketType',
  ospfv3PacketSrc => '1.3.6.1.2.1.191.1.14.3',
  ospfv3Conformance => '1.3.6.1.2.1.191.2',
  ospfv3Groups => '1.3.6.1.2.1.191.2.1',
  ospfv3Compliances => '1.3.6.1.2.1.191.2.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'OSPFV3-MIB'} = {
  ospfv3AreaStubMetricType => {
    '1' => 'ospfv3Metric',
    '2' => 'comparableCost',
    '3' => 'nonComparable',
  },
  ospfv3RestartSupport => {
    '1' => 'none',
    '2' => 'plannedOnly',
    '3' => 'plannedAndUnplanned',
  },
  ospfv3VirtNbrState => {
    '1' => 'down',
    '2' => 'attempt',
    '3' => 'init',
    '4' => 'twoWay',
    '5' => 'exchangeStart',
    '6' => 'exchange',
    '7' => 'loading',
    '8' => 'full',
  },
  ospfv3IfType => {
    '1' => 'broadcast',
    '2' => 'nbma',
    '3' => 'pointToPoint',
    '5' => 'pointToMultipoint',
  },
  ospfv3RestartExitReason => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  ospfv3AreaSummary => {
    '1' => 'noAreaSummary',
    '2' => 'sendAreaSummary',
  },
  ospfv3ConfigErrorType => {
    '1' => 'badVersion',
    '2' => 'areaMismatch',
    '3' => 'unknownNbmaNbr',
    '4' => 'unknownVirtualNbr',
    '5' => 'helloIntervalMismatch',
    '6' => 'deadIntervalMismatch',
    '7' => 'optionMismatch',
    '8' => 'mtuMismatch',
    '9' => 'duplicateRouterId',
    '10' => 'noError',
  },
  ospfv3VirtNbrRestartHelperExitReason => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  ospfv3AreaImportAsExtern => {
    '1' => 'importExternal',
    '2' => 'importNoExternal',
    '3' => 'importNssa',
  },
  ospfv3VirtIfState => {
    '1' => 'down',
    '4' => 'pointToPoint',
  },
  ospfv3VirtNbrRestartHelperStatus => {
    '1' => 'notHelping',
    '2' => 'helping',
  },
  ospfv3IfState => {
    '1' => 'down',
    '2' => 'loopback',
    '3' => 'waiting',
    '4' => 'pointToPoint',
    '5' => 'designatedRouter',
    '6' => 'backupDesignatedRouter',
    '7' => 'otherDesignatedRouter',
    '8' => 'standby',
  },
  ospfv3NbrRestartHelperStatus => {
    '1' => 'notHelping',
    '2' => 'helping',
  },
  ospfv3NbrState => {
    '1' => 'down',
    '2' => 'attempt',
    '3' => 'init',
    '4' => 'twoWay',
    '5' => 'exchangeStart',
    '6' => 'exchange',
    '7' => 'loading',
    '8' => 'full',
  },
  ospfv3RestartStatus => {
    '1' => 'notRestarting',
    '2' => 'plannedRestart',
    '3' => 'unplannedRestart',
  },
  ospfv3AreaAggregateEffect => {
    '1' => 'advertiseMatching',
    '2' => 'doNotAdvertiseMatching',
  },
  ospfv3PacketType => {
    '1' => 'hello',
    '2' => 'dbDescript',
    '3' => 'lsReq',
    '4' => 'lsUpdate',
    '5' => 'lsAck',
    '6' => 'nullPacket',
  },
  ospfv3StubRouterAdvertisement => {
    '1' => 'doNotAdvertise',
    '2' => 'advertise',
  },
  ospfv3AreaNssaTranslatorState => {
    '1' => 'enabled',
    '2' => 'elected',
    '3' => 'disabled',
  },
  ospfv3NbrRestartHelperExitReason => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  ospfv3VersionNumber => {
    '3' => 'version3',
  },
  ospfv3AreaAggregateAreaLsdbType => {
    '8195' => 'interAreaPrefixLsa',
    '8199' => 'nssaExternalLsa',
  },
  ospfv3AreaNssaTranslatorRole => {
    '1' => 'always',
    '2' => 'candidate',
  },
};
