package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOUNIFIEDCOMPUTINGTCMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-UNIFIED-COMPUTING-TC-MIB'} = {
  url => '',
  name => 'CISCO-UNIFIED-COMPUTING-TC-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-UNIFIED-COMPUTING-TC-MIB'} =
  '1.3.6.1.4.1.9.9.719.4';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-UNIFIED-COMPUTING-TC-MIB'} = {
  'cucsTextualConventionsObjects' => '1.3.6.1.4.1.9.9.719.4',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-UNIFIED-COMPUTING-TC-MIB'} = {
  'CucsFabricFcEstcEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsHostimgDistribution' => {
    '0' => 'unknown',
    '1' => 'fedora',
  },
  'CucsFirmwareDistributableFsmCurrentFsm' => {
    '0' => 'nop',
    '594' => 'delete',
  },
  'CucsMoSrcDme' => {
    '0' => 'unknown',
    '1' => 'serviceReg',
    '2' => 'mgmtController',
    '3' => 'policyMgr',
    '4' => 'resourceMgr',
    '5' => 'identifierMgr',
    '6' => 'operationMgr',
    '7' => 'statsMgr',
    '8' => 'centralMgr',
    '9' => 'serverMgr',
  },
  'CucsPoolElementOwner' => {
    '0' => 'endPoint',
    '1' => 'pool',
  },
  'CucsMgmtBackupTriggerFsmCurrentFsm' => {
    '0' => 'nop',
    '399' => 'trigger',
  },
  'CucsDcxOperState' => {
    '0' => 'unknown',
    '1' => 'adminDown',
    '2' => 'linkDown',
    '3' => 'error',
    '4' => 'active',
    '5' => 'passive',
  },
  'CucsSysfileMutationFsmStageName' => {
    '0' => 'nop',
    '209' => 'singleBegin',
    '210' => 'singleExecute',
    '211' => 'globalBegin',
    '212' => 'globalLocal',
    '213' => 'globalPeer',
    '450' => 'globalFail',
    '451' => 'globalSuccess',
    '452' => 'singleFail',
    '453' => 'singleSuccess',
  },
  'CucsConditionRule' => {
    '0' => 'generic',
    '5' => 'sysdebugCoreCoreFile',
    '33' => 'mgmtImportItemImportxmlerror',
    '156' => 'fabricComputeSlotEpMisplacedInChassisSlot',
    '157' => 'fabricComputeSlotEpServerIdentificationProblem',
    '169' => 'vnicEtherConfigFailed',
    '170' => 'vnicFcConfigFailed',
    '174' => 'processorUnitInoperable',
    '175' => 'processorUnitThermalNonCritical',
    '176' => 'processorUnitThermalThresholdCritical',
    '177' => 'processorUnitThermalThresholdNonRecoverable',
    '178' => 'processorUnitVoltageThresholdNonCritical',
    '179' => 'processorUnitVoltageThresholdCritical',
    '180' => 'processorUnitVoltageThresholdNonRecoverable',
    '181' => 'storageLocalDiskInoperable',
    '182' => 'storageItemCapacityExceeded',
    '183' => 'storageItemCapacityWarning',
    '184' => 'memoryUnitDegraded',
    '185' => 'memoryUnitInoperable',
    '186' => 'memoryUnitThermalThresholdNonCritical',
    '187' => 'memoryUnitThermalThresholdCritical',
    '188' => 'memoryUnitThermalThresholdNonRecoverable',
    '189' => 'memoryArrayVoltageThresholdNonCritical',
    '190' => 'memoryArrayVoltageThresholdCritical',
    '191' => 'memoryArrayVoltageThresholdNonRecoverable',
    '193' => 'extpolRegistryServiceRegistryVersionMismatch',
    '194' => 'extpolProviderProviderVersionMismatch',
    '195' => 'extpolControllerControllerVersionMismatch',
    '196' => 'extpolClientClientVersionMismatch',
    '200' => 'adaptorUnitUnidentifiableFru',
    '203' => 'adaptorUnitMissing',
    '206' => 'adaptorUnitAdaptorReachability',
    '207' => 'adaptorHostIfLinkDown',
    '208' => 'identpoolElementDuplicatedAssigned',
    '209' => 'identpoolElementDuplicatedDefined',
    '241' => 'firmwareSourceRemoteDownloadFailure',
    '242' => 'firmwareDownloadPolicyError',
    '261' => 'computeGroupMembershipGroupMembershipStateFault',
    '262' => 'computeGroupMembershipGroupMembershipGroupFault',
    '263' => 'orgDomainGroupPolicyUcsGroupingPolicyFault',
    '276' => 'portPioLinkDown',
    '277' => 'portPioFailed',
    '278' => 'portPioHardwareFailure',
    '279' => 'portPioSfpNotPresent',
    '282' => 'fabricExternalPcDown',
    '283' => 'dcxVcDown',
    '291' => 'networkElementInoperable',
    '293' => 'mgmtEntityDegraded',
    '294' => 'mgmtEntityDown',
    '304' => 'dcxNsFailed',
    '305' => 'computePhysicalInsufficientlyEquipped',
    '306' => 'computePhysicalIdentityUnestablishable',
    '310' => 'computeBoardPowerError',
    '311' => 'computePhysicalPowerProblem',
    '312' => 'computePhysicalThermalProblem',
    '313' => 'computePhysicalBiosPostTimeout',
    '314' => 'computePhysicalDiscoveryFailed',
    '315' => 'computePhysicalAssociationFailed',
    '317' => 'computePhysicalInoperable',
    '318' => 'computePhysicalUnassignedMissing',
    '319' => 'computePhysicalAssignedMissing',
    '320' => 'computePhysicalUnidentified',
    '321' => 'computePhysicalUnassignedInaccessible',
    '322' => 'computePhysicalAssignedInaccessible',
    '324' => 'lsServerFailed',
    '326' => 'lsServerDiscoveryFailed',
    '327' => 'lsServerConfigFailure',
    '329' => 'lsServerMaintenanceFailed',
    '330' => 'lsServerRemoved',
    '331' => 'lsServerInaccessible',
    '332' => 'lsServerAssociationFailed',
    '334' => 'lsServerUnassociated',
    '336' => 'storageItemSpeedLowsd',
    '337' => 'storageItemSpeedDegradedsd',
    '338' => 'storageItemSpeedWarningsd',
    '367' => 'etherSwitchIntfioSatelliteConnectionAbsent',
    '368' => 'etherSwitchIntfioSatelliteWiringProblem',
    '369' => 'equipmentPsuPowerSupplyProblem',
    '371' => 'equipmentFanDegraded',
    '373' => 'equipmentFanInoperable',
    '374' => 'equipmentPsuInoperable',
    '376' => 'equipmentIocardRemoved',
    '377' => 'equipmentFanModuleMissing',
    '378' => 'equipmentPsuMissing',
    '379' => 'equipmentIocardThermalProblem',
    '380' => 'equipmentFanModuleThermalThresholdNonCritical',
    '381' => 'equipmentPsuThermalThresholdNonCritical',
    '382' => 'equipmentFanModuleThermalThresholdCritical',
    '383' => 'equipmentPsuThermalThresholdCritical',
    '384' => 'equipmentFanModuleThermalThresholdNonRecoverable',
    '385' => 'equipmentPsuThermalThresholdNonRecoverable',
    '387' => 'equipmentPsuVoltageThresholdNonCritical',
    '388' => 'vnicFcIfVsanUnresolvable',
    '389' => 'equipmentPsuVoltageThresholdCritical',
    '391' => 'vnicEtherIfVlanSyncFault',
    '392' => 'vnicFcIfVsanSyncFault',
    '393' => 'vnicEtherUnassociatedVnicIfFault',
    '394' => 'vnicFcUnassociatedVnicIfFault',
    '395' => 'equipmentFanPerfThresholdNonCritical',
    '396' => 'lsSpmetaUngroupedDomain',
    '397' => 'equipmentFanPerfThresholdNonRecoverable',
    '398' => 'equipmentIocardFirmwareUpgrade',
    '399' => 'equipmentChassisUnsupportedConnectivity',
    '400' => 'equipmentChassisUnacknowledged',
    '401' => 'equipmentIocardUnsupportedConnectivity',
    '402' => 'equipmentIocardUnacknowledged',
    '403' => 'equipmentIocardPeerDisconnected',
    '404' => 'equipmentChassisIdentity',
    '405' => 'equipmentIocardIdentity',
    '406' => 'equipmentFanModuleIdentity',
    '407' => 'equipmentPsuIdentity',
    '408' => 'equipmentChassisPowerProblem',
    '409' => 'equipmentChassisThermalThresholdCritical',
    '410' => 'equipmentChassisThermalThresholdNonCritical',
    '411' => 'equipmentChassisThermalThresholdNonRecoverable',
    '424' => 'computeBoardCmosVoltageThresholdCritical',
    '425' => 'computeBoardCmosVoltageThresholdNonRecoverable',
    '428' => 'mgmtEntityElectionFailure',
    '429' => 'mgmtEntityHaNotReady',
    '430' => 'mgmtEntityVersionIncompatible',
    '434' => 'equipmentFanMissing',
    '435' => 'equipmentIocardAutoUpgradingFirmware',
    '436' => 'firmwarePackItemImageMissing',
    '440' => 'etherSwitchIntfioSatelliteWiringNumbersUnexpected',
    '451' => 'mgmtEntityManagementServicesFailure',
    '452' => 'mgmtEntityManagementServicesUnresponsive',
    '453' => 'mgmtEntityDevice1SharedStorageError',
    '454' => 'mgmtEntityDevice2SharedStorageError',
    '455' => 'mgmtEntityDevice3SharedStorageError',
    '456' => 'equipmentChassisInoperable',
    '458' => 'etherServerIntfioHardwareFailure',
    '459' => 'dcxVcMgmtVifDown',
    '460' => 'sysdebugMepLogMEpLogLog',
    '461' => 'sysdebugMepLogMEpLogVeryLow',
    '462' => 'sysdebugMepLogMEpLogFull',
    '463' => 'computePoolEmpty',
    '464' => 'uuidpoolPoolEmpty',
    '465' => 'ippoolPoolEmpty',
    '466' => 'macpoolPoolEmpty',
    '470' => 'firmwareUpdatableImageUnusable',
    '471' => 'firmwareBootUnitCantBoot',
    '476' => 'fcpoolInitiatorsEmpty',
    '478' => 'equipmentIocardInaccessible',
    '479' => 'dcxVifLinkState',
    '480' => 'equipmentFanModuleDegraded',
    '481' => 'equipmentIocardPostFailure',
    '484' => 'equipmentFanPerfThresholdLowerNonRecoverable',
    '502' => 'memoryUnitIdentityUnestablishable',
    '517' => 'computePhysicalPostFailure',
    '528' => 'equipmentPsuOffline',
    '530' => 'sysdebugMepLogTransferError',
    '536' => 'configDbConfigStatsDbError',
    '558' => 'computeAoperationRemoteOperationFail',
    '560' => 'storageRaidBatteryInoperable',
    '561' => 'computeRtcBatteryInoperable',
    '571' => 'lsIssuesConfigFailure',
    '572' => 'vnicFaultVlanSyncFault',
    '573' => 'vnicMgmtIfVlanUnresolvable',
    '574' => 'vnicMgmtIfVlanAccessFault',
    '575' => 'vnicMgmtIfVlanSyncFault',
    '576' => 'vnicMgmtUnassociatedVnicIfFault',
    '577' => 'memoryBufferUnitThermalThresholdNonCritical',
    '578' => 'memoryBufferUnitThermalThresholdCritical',
    '579' => 'memoryBufferUnitThermalThresholdNonRecoverable',
    '582' => 'computeIohubThermalNonCritical',
    '583' => 'computeIohubThermalThresholdCritical',
    '584' => 'computeIohubThermalThresholdNonRecoverable',
    '587' => 'equipmentChassisIdentityUnestablishable',
    '591' => 'licenseInstanceGracePeriodWarning1',
    '592' => 'licenseInstanceGracePeriodWarning2',
    '593' => 'queryUsageContextTimeout',
    '594' => 'queryUsageContextFailed',
    '595' => 'queryDependencyContextTimeout',
    '596' => 'queryDependencyContextFailed',
    '597' => 'queryImportContextTimeout',
    '598' => 'queryImportContextFailed',
    '599' => 'licenseFileFileNotDeleted',
    '616' => 'configBackupUngroupedDomain',
    '621' => 'fabricLanPinGroupEmpty',
    '622' => 'fabricSanPinGroupEmpty',
    '625' => 'adaptorExtEthIfMisConnect',
    '634' => 'computeRemoteOpStatusRemoteOpFailed',
    '635' => 'swVlanPortNsResourceStatus',
    '644' => 'extpolClientClientNotReachable',
    '645' => 'mgmtExportPolicyNoSchedulerExists',
    '646' => 'fabricVlanPrimaryVlanMissingIsolated',
    '654' => 'mgmtIfMisConnect',
    '656' => 'storageMetaGlobalArrayStorageArrayNotOpted',
    '657' => 'storageMetaDomainGroupMissing',
    '658' => 'storageMetaMissingArrayAutoConfigRef',
    '659' => 'storageMetaStorageBladeNotInDiscoveryMode',
    '660' => 'storageMetaMissingArrayAutoConfigPolicy',
    '661' => 'storageMetaMissingQualifier',
    '662' => 'storageMetaMatchingQualifierError',
    '663' => 'storageMetaStorageBladeAlreadyInUse',
    '669' => 'equipmentFexPostFailure',
    '670' => 'equipmentFexIdentity',
    '688' => 'powerBudgetPowerBudgetCmcProblem',
    '689' => 'lsComputeBindingAssignmentRequirementsNotMet',
    '690' => 'powerBudgetPowerBudgetBmcProblem',
    '693' => 'powerBudgetPowerBudgetDiscFail',
    '695' => 'powerGroupPowerGroupInsufficientBudget',
    '696' => 'powerGroupPowerGroupBudgetIncorrect',
    '708' => 'adaptorHostEthIfMissing',
    '710' => 'portPioInvalidSfp',
    '714' => 'mgmtIfMissing',
    '727' => 'fabricEthLanPcEpDown',
    '728' => 'fabricFcSanPcEpDown',
    '729' => 'equipmentIocardThermalThresholdNonCritical',
    '730' => 'equipmentIocardThermalThresholdCritical',
    '731' => 'equipmentIocardThermalThresholdNonRecoverable',
    '733' => 'equipmentChassisSeepromInoperable',
    '734' => 'fabricFcSanPcEpIncompatibleSpeed',
    '735' => 'fabricFcSanPcIncompatibleSpeed',
    '736' => 'extmgmtIfMgmtifdown',
    '740' => 'powerChassisMemberPowerGroupCapInsufficient',
    '741' => 'powerChassisMemberChassisFirmwareProblem',
    '742' => 'powerChassisMemberChassisPsuInsufficient',
    '743' => 'powerChassisMemberChassisPsuRedundanceFailure',
    '744' => 'powerBudgetPowerCapReachedCommit',
    '747' => 'sysdebugAutoCoreFileExportTargetAutoCoreTransferFailure',
    '750' => 'smartlicenseEntitlementEnforcementModeFault',
    '757' => 'fabricMonSpanConfigFail',
    '764' => 'powerBudgetChassisPsuInsufficient',
    '765' => 'powerBudgetTstateTransition',
    '766' => 'powerPolicyPowerPolicyApplicationFail',
    '772' => 'mgmtIfNew',
    '775' => 'adaptorExtEthIfMissing',
    '776' => 'storageLocalDiskSlotEpUnusable',
    '777' => 'fabricEthEstcPcEpDown',
    '778' => 'equipmentFexIdentityUnestablishable',
    '791' => 'mgmtEntityDevice1SeepromError',
    '792' => 'mgmtEntityDevice2SeepromError',
    '793' => 'vnicEtherIfPrimaryVlanMissingForIsolated',
    '794' => 'vnicEtherIfPrimaryVlanMissingForCommunity',
    '795' => 'vnicMgmtIfPrimaryVlanMissingForIsolated',
    '796' => 'vnicMgmtIfPrimaryVlanMissingForCommunity',
    '797' => 'vnicEtherIfPrimaryVlanAccessFaultForIsolated',
    '798' => 'vnicEtherIfPrimaryVlanAccessFaultForCommunity',
    '799' => 'vnicMgmtIfPrimaryVlanAccessFaultIsolated',
    '800' => 'vnicMgmtIfPrimaryVlanAccessFaultForCommunity',
    '801' => 'processorUnitIdentityUnestablishable',
    '807' => 'firmwareBootUnitActivateStatusFailed',
    '826' => 'fabricDceSwSrvPcEpDown',
    '829' => 'fabricInternalPcDown',
    '837' => 'fabricEpMgrEpTransModeFail',
    '846' => 'mgmtPmonEntryUcsmProcessFailure',
    '855' => 'processorUnitDisabled',
    '857' => 'computeABoardThermalProblem',
    '859' => 'equipmentPsuPowerSupplyShutdown',
    '861' => 'iqnpoolPoolEmpty',
    '862' => 'fabricVlanMisconfigured',
    '865' => 'swEthLanEpMissingPrimaryVlan',
    '866' => 'swEthLanPcMissingPrimaryVlan',
    '867' => 'memoryUnitDisabled',
    '869' => 'computeAboardThermalProblem',
    '872' => 'vmVifLinkState',
    '874' => 'mgmtEntityHaSshKeysMismatched',
    '875' => 'vnicEtherPinningMismatch',
    '876' => 'vnicEtherPinningMisconfig',
    '877' => 'storageLocalLunInoperable',
    '878' => 'equipmentPsuPowerThreshold',
    '879' => 'equipmentPsuInputError',
    '880' => 'fabricPioEpErrorMisconfigured',
    '885' => 'networkElementInventoryFailed',
    '887' => 'computeBoardPowerFail',
    '890' => 'equipmentSwitchCardPowerOff',
    '900' => 'adaptorUnitExtnUnidentifiableFru',
    '901' => 'adaptorUnitExtnMissing',
    '902' => 'equipmentFexFexUnsupported',
    '903' => 'vnicIscsiConfigFailed',
    '909' => 'pkiKeyRingStatus',
    '910' => 'pkiTpStatus',
    '915' => 'computePhysicalDisassociationFailed',
    '916' => 'computePhysicalNetworkMisconfigured',
    '917' => 'vnicProfileProfileConfigIncorrect',
    '918' => 'computeAboardMotherBoardVoltageThresholdUpperNonRecoverable',
    '919' => 'computeAboardMotherBoardVoltageThresholdLowerNonRecoverable',
    '920' => 'computeAboardMotherBoardVoltageUpperThresholdCritical',
    '921' => 'computeAboardMotherBoardVoltageLowerThresholdCritical',
    '928' => 'networkElementThermalThresholdCritical',
    '943' => 'aaaProviderGroupProvidergroup',
    '944' => 'aaaConfigServergroup',
    '945' => 'aaaRoleRoleNotDeployed',
    '946' => 'aaaLocaleLocaleNotDeployed',
    '947' => 'aaaUserRoleUserRoleNotDeployed',
    '948' => 'aaaUserLocaleUserLocaleNotDeployed',
    '949' => 'pkiKeyRingKeyRingNotDeployed',
    '950' => 'commSnmpSyscontactEmpty',
    '951' => 'commDateTimeCommTimeZoneInvalid',
    '952' => 'aaaUserLocalUserNotDeployed',
    '953' => 'commSnmpUserSnmpUserNotDeployed',
    '954' => 'commSvcEpCommSvcNotDeployed',
    '957' => 'mgmtConnectionDisabled',
    '958' => 'mgmtConnectionUnused',
    '959' => 'mgmtConnectionUnsupportedConnectivity',
    '967' => 'capabilityCatalogueLoadErrors',
    '968' => 'storageLocalDiskDegraded',
    '969' => 'storageRaidBatteryDegraded',
    '970' => 'storageRaidBatteryRelearnAborted',
    '971' => 'storageRaidBatteryRelearnFailed',
    '972' => 'storageAdefConfigurationError',
    '973' => 'storageInitiatorConfigurationError',
    '974' => 'storageVsanRefVsanUnresolvable',
    '975' => 'storageControllerPatrolReadFailed',
    '976' => 'storageControllerInoperable',
    '977' => 'storageLocalDiskRebuildFailed',
    '978' => 'storageLocalDiskCopybackFailed',
    '979' => 'storageVirtualDriveInoperable',
    '980' => 'storageVirtualDriveDegraded',
    '981' => 'storageVirtualDriveReconstructionFailed',
    '982' => 'storageVirtualDriveConsistencyCheckFailed',
    '1010' => 'extpolClientClientLostConnectivity',
    '1017' => 'policyControlEpSuspendModeActive',
    '1023' => 'lsIdentityInfoForward990',
    '1037' => 'extmgmtArpTargetsArpTargetsNotValid',
    '1040' => 'computeAboardPowerUsageProblem',
    '1046' => 'fabricFcoeSanPcEpDown',
    '1047' => 'fabricFcoeSanEpDown',
    '1048' => 'fabricFcoeSanEpUnsupported',
    '1049' => 'fabricFcoeSanPcDown',
    '1050' => 'fabricFcoeSanPcUnsupported',
    '1051' => 'fabricFcoeEstcEpDown',
    '1052' => 'fabricPinTargetDown',
    '1053' => 'fabricExternalEpFcZoningEnable',
    '1054' => 'fabricEthLanEpOverlappingVlan',
    '1055' => 'fabricEthLanPcOverlappingVlan',
    '1056' => 'fabricFcEstcEpFcStoragePortInvalid',
    '1057' => 'fabricFcoeEstcEpFcoeStoragePortInvalid',
    '1058' => 'fabricFcSanPcFcPortchannelMembersInvalid',
    '1097' => 'computeABoardPowerUsageProblem',
    '1101' => 'vnicEtherIfVlanAccessFault',
    '1102' => 'vnicEtherIfVlanUnresolvable',
    '1103' => 'vnicEtherIfInvalidVlan',
    '1104' => 'fabricVlanVlanConflictPermit',
    '1105' => 'fabricVlanReqVlanPermitUnresolved',
    '1106' => 'fabricVlanGroupReqVlanGroupPermitUnresolved',
    '1124' => 'policyConfigErrorPolicyConfigError',
    '1202' => 'swVlanPortNsVlancompNotSupport',
    '1204' => 'fabricVlanMisconfiguredMcastPolicy',
    '1206' => 'fabricVsanMembershipDown',
    '1207' => 'callhomeEpNoSnmpPolicyForCallhome',
    '1209' => 'aaaOrgLocaleOrgNotPresent',
    '1216' => 'vnicFcPinningMisconfig',
    '1219' => 'equipmentHealthLedCriticalError',
    '1220' => 'equipmentHealthLedMinorError',
    '1221' => 'networkOperLevelExtraprimaryvlans',
    '1222' => 'pkiKeyRingModulus',
    '1223' => 'extpolClientGracePeriodWarning2',
    '1224' => 'extpolClientGracePeriodWarning3',
    '1225' => 'extpolClientGracePeriodWarning4',
    '1226' => 'extpolClientGracePeriodWarning5',
    '1227' => 'extpolClientGracePeriodWarning6',
    '1228' => 'extpolClientGracePeriodWarning7',
    '1229' => 'extpolClientGracePeriodWarning1',
    '1232' => 'storageInitiatorDuplicateFcZone',
    '1233' => 'storageIniGroupSwitchModeDisabled',
    '1237' => 'storageItemFilesystemIssues',
    '1258' => 'aaaProviderGroupProvidergroupsize',
    '1280' => 'firmwareAutoSyncPolicyDefaultHostPackageMissing',
    '1281' => 'firmwareAutoSyncPolicyDefaultHostPackageMissingVersions',
    '1284' => 'fabricNetflowMonSessionFlowMonConfigFail',
    '1285' => 'fabricNetflowMonSessionNetflowSessionConfigFail',
    '1286' => 'fabricPooledVlanNamedVlanUnresolved',
    '1306' => 'vnicEtherIfRemoteVlanUnresolvable',
    '1307' => 'vnicFcIfRemoteVsanUnresolvable',
    '1308' => 'vnicEtherVirtualizationConflict',
    '1309' => 'lsIssuesIscsiConfigFailed',
    '1317' => 'firmwareBootUnitPowerCycleRequired',
    '1324' => 'mgmtControllerUnsupportedDimmBlacklisting',
    '1325' => 'mgmtInterfaceInbandVlanFailure',
    '1327' => 'extmgmtNdiscTargetsNdiscTargetsNotValid',
    '1330' => 'storageLocalDiskMissing',
    '1331' => 'storageFlexFlashControllerInoperable',
    '1332' => 'storageFlexFlashCardInoperable',
    '1333' => 'storageFlexFlashCardMissing',
    '1334' => 'storageFlexFlashVirtualDriveDegraded',
    '1335' => 'storageFlexFlashVirtualDriveInoperable',
    '1336' => 'storageFlexFlashControllerUnhealthy',
    '1337' => 'extvmmVmndrefVmNetworkReferenceIncorrect',
    '1356' => 'mgmtInterfaceInbandCapIsNotAvailable',
    '1357' => 'mgmtInterfaceUnsupportedFirmwareVersion',
    '1358' => 'fabricEthLanEpUdldLinkDown',
    '1359' => 'fabricEthLanPcEpUdldLinkDown',
    '1360' => 'fabricFcoeSanEpUdldLinkDown',
    '1361' => 'fabricFcoeSanPcEpUdldLinkDown',
    '1366' => 'cimcvmediaActualMountEntryVmediaMountFailed',
    '1367' => 'firmwareStatusCimcFirmwareMismatch',
    '1368' => 'firmwareStatusPldFirmwareMismatch',
    '1380' => 'vnicEtherVirtualizationNetflowConflict',
    '1382' => 'storageMezzFlashLifeInoperable',
    '1383' => 'lsIssuesKvmPolicyUnsupported',
    '1385' => 'fabricVlanPrimaryVlanMissingForIsolated',
    '1386' => 'fabricVlanPrimaryVlanMissingForCommunity',
    '1388' => 'fabricVlanErrorAssocPrimary',
    '1389' => 'fabricVlanMismatchA',
    '1390' => 'fabricVlanMismatchB',
    '1391' => 'mgmtBackupPolicyConfigConfigurationBackupOutdated',
    '1396' => 'lsServerSvnicNotPresent',
    '1397' => 'networkOperLevelExtrasecondaryvlans',
    '1398' => 'swVlanExtrasecondaryvlansperprimary',
    '1402' => 'sysdebugLogExportStatusLogExportFailure',
    '1419' => 'mgmtInterfaceNamedInbandVlanUnresolved',
    '1420' => 'mgmtInterfaceInbandUnsupportedServer',
    '1421' => 'mgmtInterfaceInbandUnsupportedFirmware',
    '1428' => 'storageMezzFlashLifeConfigurationError',
    '1429' => 'storageMezzFlashLifeDegraded',
    '1430' => 'storageFlexFlashControllerMismatch',
    '1431' => 'storageFlexFlashDriveUnhealthy',
    '1432' => 'storageFlexFlashCardUnhealthy',
    '1433' => 'poolElementDuplicatedAssigned',
    '1434' => 'computePhysicalAdapterMismatch',
    '1437' => 'equipmentTpmSlaveTpm',
    '1438' => 'swVlanPortNsResourceStatusWarning',
    '1439' => 'networkElementMemoryerror',
    '1472' => 'memoryNvDimmControllerInoperable',
    '1473' => 'memoryNvDimmControllerDegraded',
    '1474' => 'memoryNvDimmBatteryThermalIssueCritical',
    '1475' => 'memoryNvDimmBatteryThermalIssueNonRecoverable',
    '1476' => 'memoryNvDimmBatteryInsufficientCharge',
    '1477' => 'memoryNvDimmBatteryHealthDegraded',
    '1478' => 'memoryNvDimmBatteryHealthInoperable',
    '1480' => 'lstorageArrayAssociationFailed',
    '1481' => 'lstorageArrayControllerProfileCount',
    '1482' => 'lstorageProcessorConfigFailure',
    '1483' => 'lstorageBackstorePoolEmpty',
    '1493' => 'networkElementRemoved',
    '1498' => 'powerBudgetChassisPsuMixedMode',
    '1499' => 'powerBudgetPowerBudgetUnavailable',
    '1501' => 'storageVolumeSmallVolumeSpace',
    '1502' => 'storageVolumeNoVolumeSpace',
    '1503' => 'storageEnclosureDrawerOpen',
    '1504' => 'storageDiskGroupOffline',
    '1505' => 'storageDiskGroupDegraded',
    '1506' => 'storageDiskGroupRebuilding',
    '1507' => 'storageDiskGroupBad',
    '1508' => 'storageScsiLunInstRefOffline',
    '1509' => 'storageProcessorComputeInoperable',
    '1510' => 'storageProcessorComputeDegraded',
    '1511' => 'storageProcessorCimcBackupTriggerNotEnabled',
    '1512' => 'storageProcessorCimcHeartbeatTimedOut',
    '1513' => 'storageProcessorMgmtInaccessible',
    '1514' => 'storageProcessorStorageNotReady',
    '1515' => 'storageProcessorElectionFailure',
    '1516' => 'storageProcessorHaDegraded',
    '1517' => 'storageDiskEnvStatsDiskWearNonCriticalThreshold',
    '1518' => 'storageDiskEnvStatsDiskWearCriticalThreshold',
    '1519' => 'storageLocalDiskInaccessible',
    '1520' => 'storageScsiLunDeploymentFailure',
    '1521' => 'storageLunReplicaDeploymentFailure',
    '1522' => 'storageLunSnapshotDeploymentFailure',
    '1523' => 'storageLunMaskGroupDeploymentFailure',
    '1558' => 'equipmentChassisInvalidFru',
    '1559' => 'equipmentSwitchiocardRemoved',
    '1560' => 'equipmentSwitchiocardThermalProblem',
    '1561' => 'equipmentSwitchiocardThermalThresholdNonCritical',
    '1562' => 'equipmentSwitchiocardThermalThresholdCritical',
    '1563' => 'equipmentSwitchiocardThermalThresholdNonRecoverable',
    '1564' => 'equipmentSwitchiocardPeerDisconnected',
    '1565' => 'equipmentSwitchiocardIdentity',
    '1566' => 'equipmentSwitchiocardCpuThermalThresholdCritical',
    '1604' => 'storageLocalDiskThermalIssueCritical',
    '1605' => 'storageLocalDiskThermalIssueNonRecoverable',
    '1606' => 'storageLocalDiskNotSupported',
    '1616' => 'fabricComputemslotEpMisplacedInChassisSlot',
    '1617' => 'fabricComputemslotEpServerIdentificationProblem',
    '1618' => 'fabricCartridgeSlotEpMisplacedInChassisSlot',
    '1620' => 'storageControllerNotSupported',
    '1621' => 'storageVirtualDriveDeploymentFailure',
    '1622' => 'storageVirtualDriveMissing',
    '1623' => 'storageVirtualDriveMismatch',
    '1624' => 'storageVdmemberEpMismatch',
    '1627' => 'firmwareBootUnitFirmwareBootFailed',
    '1634' => 'equipmentChassisMajorError',
    '1635' => 'equipmentFexMajorError',
    '1654' => 'computeRackUnitMajorError',
    '1668' => 'aaaDefaultAuthDefaultAuthNotDeployed',
    '1669' => 'aaaDomainDomainNotDeployed',
    '1671' => 'lsServerFault',
    '1672' => 'mgmtBackupLocalInternalBackupFailed',
    '1675' => 'lsIssuesForward327',
    '1676' => 'lsIdentityInfoForward1671',
    '1680' => 'vnicEtherCdnConfigNotApplied',
    '1681' => 'computePhysicalConnectivityDown',
    '1685' => 'storageSasExpanderInoperable',
    '1686' => 'storageSasExpanderAccessibilityProblem',
    '1687' => 'storageSasExpanderDegraded',
    '1688' => 'storageLocalDiskLinkDegraded',
    '1694' => 'fabricFcSanNumOfVsanExceedLimit',
    '1700' => 'swVlanPortNsCompressedSetsExhaustedWarning',
    '1701' => 'networkElementKernelMemCricitalThreshold',
    '1702' => 'flowctrlItemFlowctrlconfig',
    '1703' => 'networkElementSystemshutdown',
    '1704' => 'mgmtHealthStatusHealthWarningIssue',
    '1705' => 'mgmtHealthStatusHealthMinorIssue',
    '1706' => 'mgmtHealthStatusHealthMajorIssue',
    '1707' => 'mgmtHealthStatusHealthCriticalIssue',
    '1708' => 'computePhysicalDeprecated',
    '1709' => 'computePhysicalAdapterFirmwareNeedsUpdate',
    '1710' => 'computePhysicalIdentityUnestablishableOrDeprecated',
    '1713' => 'equipmentIocardDeprecated',
    '1719' => 'fabricSwChPhEpUncleanConfiguration',
    '1720' => 'fabricComputeSlotEpNotSupportedInChassisSlot',
    '1721' => 'fabricDceSwSrvEpDown',
    '1731' => 'storageLocalDiskThermalIssueNonCritical',
    '1732' => 'storageLocalDiskFailed',
    '1744' => 'equipmentSystemiocontrollerRemoved',
    '1745' => 'computeRackUnitFanSpeedConfigurationFailed',
    '1748' => 'fabricEthLanNumOfvlancompGrpExceedLimit',
    '1749' => 'fabricMulticastPolicySameOrEmptyPeerQuerierIp',
    '1753' => 'adaptorUnitDeprecated',
    '1754' => 'mgmtInterfaceInbandPinningInvalid',
    '1755' => 'etherPioInvalidSfp',
    '1756' => 'networkOperLevelExtravif',
    '1757' => 'networkElementDeprecated',
    '1758' => 'fabricNetGroupNativeVlanNotFound',
    '1761' => 'equipmentChassisChassislimitExceeded',
    '1764' => 'swSystemStatsForward1701',
    '1766' => 'mgmtEntityDevice1SharedStorageConnectError',
    '1767' => 'mgmtEntityDevice2SharedStorageConnectError',
    '1768' => 'mgmtEntityDevice3SharedStorageConnectError',
    '1769' => 'mgmtMgmtDbStateMgmtDbCorruptionDetected',
    '1778' => 'swEthLanBorderVlanLimitExceeded',
    '1781' => 'mgmtEntityMgmtDbVersionMismatch',
    '1784' => 'equipmentTpmTpmMismatch',
    '1792' => 'equipmentSharediomoduleInaccessible',
    '1793' => 'equipmentChassisInaccessibleB',
    '1794' => 'equipmentChassisInaccessibleA',
    '1795' => 'equipmentSystemiocontrollerThermalProblem',
    '1796' => 'equipmentSystemiocontrollerUnacknowledged',
    '1797' => 'equipmentIocardBackPlanePortProblem',
    '1798' => 'equipmentSwitchiocardBackPlanePortProblem',
    '1799' => 'equipmentFexBackPlanePortProblem',
    '1825' => 'fabricFcZoneProfileSwitchModeDisabled',
    '1826' => 'fabricFcUserZoneConfigFailure',
    '1831' => 'storageEnclosureThermalIssueNonCritical',
    '1832' => 'storageEnclosureThermalIssueCritical',
    '1833' => 'storageEnclosureThermalIssueNonRecoverable',
    '1834' => 'storageControllerDegraded',
    '1835' => 'storageSasExpanderLinkMisconnect',
    '1836' => 'storageSasExpanderLinkDegraded',
    '1837' => 'storageEnclosureMissing',
    '1838' => 'storageEnclosureFruEmpty',
    '1839' => 'storageEnclosureDiskSlotEpMissing',
    '1840' => 'storageEnclosureDiskSlotEpEquipmentInoperable',
    '1841' => 'storageEnclosureDiskSlotEpChassisSpare',
    '1842' => 'storageEnclosureDiskSlotEpHotspareUnsupported',
    '1843' => 'storageEnclosureDiskSlotEpSharingUnsupported',
    '1844' => 'storageEnclosureDiskSlotEpIoeOwnershipUnassigned',
    '1845' => 'storageEnclosureDiskSlotEpHddslotServer2OwnershipUnassigned',
    '1846' => 'equipmentChassisProfileFailed',
    '1847' => 'equipmentChassisProfileDiscoveryFailed',
    '1848' => 'equipmentChassisProfileConfigFailure',
    '1849' => 'equipmentChassisProfileRemoved',
    '1850' => 'equipmentChassisProfileInaccessible',
    '1851' => 'equipmentChassisProfileAssociationFailed',
    '1852' => 'equipmentChassisProfileUnassociated',
    '1864' => 'equipmentChassisIssuesForward1848',
    '1873' => 'fabricNetGroupRefNetSanGroupUnresolvable',
    '1889' => 'etherPioUnknownServerDevice',
    '1890' => 'etherPioMisconfigureForServerDevice',
    '1891' => 'etherPioInterfaceMismatch',
    '1892' => 'adaptorUnitPciConfigIssue',
    '1893' => 'networkElementEvacuationon',
    '1894' => 'networkLimitUnicastMac',
    '1895' => 'networkLimitMulticastMac',
    '1896' => 'networkLimitPvlifvlanmbr',
    '1897' => 'networkLimitPvsystem',
    '1898' => 'networkLimitIgmpgroup',
    '1899' => 'mgmtDbStateDbCorruptionDetected',
    '1900' => 'mgmtDbStateHighDbCorruptionDetected',
    '1901' => 'equipmentInventoryStatusHardwareMismatch',
    '1902' => 'equipmentChassisPhysicalSecurity',
    '1903' => 'equipmentComputeConnConfigProblem',
    '1907' => 'vnicEtherPrimaryVlanMissing',
    '1908' => 'vnicEtherNetSanGroupMisconfigured',
    '1912' => 'computePhysicalKmipFault',
    '1913' => 'computePhysicalHardwareInventoryMismatch',
    '1914' => 'computePhysicalPciConfigMismatch',
    '1915' => 'storageEnclosureDiskSlotEpSecondControllerAbsent',
    '1916' => 'computePhysicalExtensionForward1913',
    '1917' => 'computePhysicalExtensionForward1914',
    '1926' => 'adaptorUnitUnConnectedAdaptorReachability',
    '1927' => 'mgmtHealthStatusHealthInfoIssue',
    '1932' => 'computeRackUnitPhysicalSecurity',
    '1933' => 'biosUnitFd0FailedSecurityVerification',
    '1934' => 'computeBoardFailedSecureFuseValidation',
    '16392' => 'fsmSamDmeSysdebugLogControlEpPersistence',
    '16394' => 'fsmSamDmeMgmtRegistryInfoConfigure',
    '16395' => 'fsmSamDmeOrgOrgConfigure',
    '16400' => 'fsmSamDmeTopSystemHostName',
    '16405' => 'fsmSamDmeEquipmentiocardFePresence',
    '16406' => 'fsmSamDmeEquipmentiocardFeConn',
    '16407' => 'fsmSamDmeEquipmentChassisRemoveChassis',
    '16408' => 'fsmSetLocatorLed',
    '16415' => 'fsmSamDmeMgmtDataExporterExportData',
    '16416' => 'fsmSamDmeMgmtDataImporterImportData',
    '16424' => 'fsmUpdateElement',
    '16441' => 'fsmSamDmeTestingServiceProfileResolvePolicyFsm',
    '16442' => 'fsmSamDmeTestingServiceProfileResolveManyPolicyFsm',
    '16504' => 'fsmSamDmeCertRepairEpRepairCert',
    '16511' => 'fsmResolveResourceFsm',
    '16512' => 'fsmResolvevmfsm',
    '16513' => 'fsmResolveControllerFsm',
    '16518' => 'fsmSamDmeMgmtControllerExtMgmtIfConfig',
    '16519' => 'fsmSamDmeFabricComputeSlotEpIdentify',
    '16520' => 'fsmSamDmeComputeBladeDiscover',
    '16532' => 'fsmReleasePolicyFsm',
    '16533' => 'fsmSamDmeEquipmentChassisPsuPolicyConfig',
    '16534' => 'fsmSamDmeAdaptorHostFcIfResetFcPersBinding',
    '16535' => 'fsmSamDmeComputeBladeDiag',
    '16536' => 'fsmResolveManyOperationFsm',
    '16537' => 'fsmResolveManyStorageFsm',
    '16538' => 'fsmReleaseManyPolicyFsm',
    '16539' => 'fsmSwitchMode',
    '16540' => 'fsmReleaseManyStorageFsm',
    '16541' => 'fsmResolveAllPolicyFsm',
    '16542' => 'fsmResolveAllOperationFsm',
    '16543' => 'fsmResolveAllStorageFsm',
    '16544' => 'fsmReleaseAllPolicyFsm',
    '16545' => 'fsmReleaseAllOperationFsm',
    '16546' => 'fsmReleaseAllStorageFsm',
    '16550' => 'fsmSamDmeVnicProfileSetDeploy',
    '16576' => 'fsmUpdateSvcEp',
    '16577' => 'fsmSamDmeCommSvcEpRestartWebSvc',
    '16579' => 'fsmUpdateEp',
    '16580' => 'fsmUpdateRealm',
    '16581' => 'fsmUpdateUserEp',
    '16582' => 'fsmSamDmePkiEpUpdateEp',
    '16600' => 'fsmSingle',
    '16601' => 'fsmSamDmeSysfileMutationGlobal',
    '16602' => 'fsmSamDmeConfigBackupDelete',
    '16604' => 'fsmSamDmeSysdebugManualCoreFileExportTargetExport',
    '16605' => 'fsmSamDmeSysdebugAutoCoreFileExportTargetConfigure',
    '16606' => 'fsmSamDmeSysdebugLogControlEpLogControlPersist',
    '16607' => 'fsmSamDmeConsumerInstRenameCfgDir',
    '16608' => 'fsmSamDmeNfsClientDefAddConfig',
    '16609' => 'fsmSamDmeNfsClientDefDeleteConfig',
    '16634' => 'fsmSamDmeSwAccessDomainDeploy',
    '16635' => 'fsmSamDmeSwEthLanBorderDeploy',
    '16636' => 'fsmSamDmeSwFcSanBorderDeploy',
    '16637' => 'fsmSamDmeSwUtilityDomainDeploy',
    '16639' => 'fsmSamDmeComputeSystemRegister',
    '16641' => 'fsmSamDmeSyntheticFsObjCreate',
    '16643' => 'fsmUpdateContextFsm',
    '16650' => 'fsmSamDmeFirmwareDownloaderDownload',
    '16651' => 'fsmSamDmeFirmwareImageDelete',
    '16653' => 'fsmUpdateSwitch',
    '16654' => 'fsmUpdateiom',
    '16655' => 'fsmSamDmeMgmtControllerActivateiom',
    '16656' => 'fsmUpdatebmc',
    '16657' => 'fsmSamDmeMgmtControllerActivatebmc',
    '16670' => 'fsmSamDmeCallhomeEpConfigCallhome',
    '16673' => 'fsmSwMgmtOobIfConfig',
    '16674' => 'fsmSwMgmtInbandIfConfig',
    '16679' => 'fsmVirtualIfConfig',
    '16680' => 'fsmSamDmeMgmtIfEnableVip',
    '16681' => 'fsmSamDmeMgmtIfDisableVip',
    '16682' => 'fsmSamDmeMgmtIfEnableha',
    '16683' => 'fsmSamDmeMgmtBackupBackup',
    '16684' => 'fsmSamDmeMgmtImporterImport',
    '16728' => 'fsmSamDmeOrgOrgConfigurePeer',
    '16729' => 'fsmSamDmeTopSystemPeerHostName',
    '16742' => 'fsmSamDmeStatsCollectionPolicyUpdateEp',
    '16745' => 'fsmSamDmeQosclassDefinitionConfigGlobalQos',
    '16749' => 'fsmSamDmeEpqosDefinitionDeploy',
    '16750' => 'fsmSamDmeEpqosDefinitionDelTaskRemove',
    '16764' => 'fsmSamDmeControllerEpQuiesce',
    '16769' => 'fsmSamDmeConfigConsumerCatalogueCreate',
    '16770' => 'fsmSamDmeNfsExportDefImageSync',
    '16771' => 'fsmSamDmeNfsExportDefAddRepo',
    '16793' => 'fsmUpdateIdent',
    '16794' => 'fsmSync',
    '16800' => 'fsmSyncVnetEpucs',
    '16803' => 'fsmSamDmeEquipmentiocardResetCmc',
    '16808' => 'fsmSyncChangeucs',
    '16815' => 'fsmUpdateucsmanager',
    '16823' => 'fsmSysConfig',
    '16852' => 'fsmSamDmeAdaptorExtEthIfPathReset',
    '16857' => 'fsmSamDmeAdaptorHostEthIfCircuitReset',
    '16858' => 'fsmSamDmeAdaptorHostFcIfCircuitReset',
    '16879' => 'fsmSamDmeExtvmmProviderConfig',
    '16880' => 'fsmSamDmeExtvmmKeyStoreCertInstall',
    '16881' => 'fsmSamDmeExtvmmSwitchDelTaskRemoveProvider',
    '16898' => 'fsmSamDmeExtvmmMasterExtKeyConfig',
    '16904' => 'fsmUpdater',
    '16906' => 'fsmSamDmeFirmwareDistributableDelete',
    '16920' => 'fsmDiscover',
    '16921' => 'fsmAssociate',
    '16922' => 'fsmDisassociate',
    '16924' => 'fsmDecommission',
    '16925' => 'fsmSoftShutdown',
    '16926' => 'fsmHardShutdown',
    '16927' => 'fsmTurnup',
    '16928' => 'fsmPowercycle',
    '16929' => 'fsmHardreset',
    '16930' => 'fsmSoftreset',
    '16931' => 'fsmSwConnUpd',
    '16932' => 'fsmBiosRecovery',
    '16934' => 'fsmCmosReset',
    '16935' => 'fsmResetBmc',
    '16938' => 'fsmUpdateExtUsers',
    '16939' => 'fsmUpdateAdaptor',
    '16940' => 'fsmActivateAdaptor',
    '16941' => 'fsmConfigSol',
    '16942' => 'fsmUnconfigSol',
    '16943' => 'fsmSetFeLocatorLed',
    '16944' => 'fsmSamDmeEquipmentChassisPowerCap',
    '16945' => 'fsmSamDmeEquipmentiocardMuxOffline',
    '16950' => 'fsmPowerCap',
    '16964' => 'fsmUpdateBoardController',
    '16965' => 'fsmDeployCatalogue',
    '16973' => 'fsmSamDmeComputePhysicalAssociate',
    '16974' => 'fsmSamDmeComputePhysicalDisassociate',
    '16975' => 'fsmSamDmeComputePhysicalPowerCap',
    '16976' => 'fsmSamDmeComputePhysicalDecommission',
    '16977' => 'fsmSamDmeComputePhysicalSoftShutdown',
    '16978' => 'fsmSamDmeComputePhysicalHardShutdown',
    '16979' => 'fsmSamDmeComputePhysicalTurnup',
    '16980' => 'fsmSamDmeComputePhysicalPowercycle',
    '16981' => 'fsmSamDmeComputePhysicalHardreset',
    '16982' => 'fsmSamDmeComputePhysicalSoftreset',
    '16983' => 'fsmSamDmeComputePhysicalSwConnUpd',
    '16984' => 'fsmSamDmeComputePhysicalBiosRecovery',
    '16986' => 'fsmSamDmeComputePhysicalCmosReset',
    '16987' => 'fsmSamDmeComputePhysicalResetBmc',
    '16988' => 'fsmSamDmeEquipmentiocardResetIom',
    '16991' => 'fsmInstall',
    '16992' => 'fsmClear',
    '16993' => 'fsmUpdateFlexlm',
    '16994' => 'fsmSamDmeComputeRackUnitDiscover',
    '16995' => 'fsmSamDmeLsServerConfigure',
    '17000' => 'fsmSamDmeSwEthMonDeploy',
    '17001' => 'fsmSamDmeSwFcMonDeploy',
    '17002' => 'fsmSamDmeFabricSanCloudSwitchMode',
    '17007' => 'fsmRemoveFex',
    '17008' => 'fsmSamDmeComputePhysicalUpdateExtUsers',
    '17012' => 'fsmSamDmeSysdebugTechSupportInitiate',
    '17013' => 'fsmSamDmeSysdebugTechSupportDeleteTechSupFile',
    '17014' => 'fsmSamDmeSysdebugTechSupportDownload',
    '17017' => 'fsmActivateCatalog',
    '17018' => 'fsmActivateMgmtExt',
    '17032' => 'fsmSamDmeDupeChangeTrackerEpConfigure',
    '17035' => 'fsmTrigger',
    '17043' => 'fsmSamDmeComputePhysicalUpdateAdaptor',
    '17044' => 'fsmSamDmeComputePhysicalActivateAdaptor',
    '17045' => 'fsmSamDmeCapabilityCatalogueActivateCatalog',
    '17046' => 'fsmSamDmeCapabilityMgmtExtensionActivateMgmtExt',
    '17050' => 'fsmSamDmeLicenseDownloaderDownload',
    '17051' => 'fsmSamDmeLicenseFileInstall',
    '17052' => 'fsmSamDmeLicenseFileClear',
    '17053' => 'fsmSamDmeLicenseInstanceUpdateFlexlm',
    '17060' => 'fsmConfigure',
    '17061' => 'fsmMuxOffline',
    '17083' => 'fsmSamDmeComputePhysicalConfigSol',
    '17084' => 'fsmSamDmeComputePhysicalUnconfigSol',
    '17089' => 'fsmSamDmePortpioInCompatSfpPresence',
    '17116' => 'fsmSamDmeComputePhysicalDiagnosticInterrupt',
    '17133' => 'fsmSamDmeSysdebugCoreDownload',
    '17134' => 'fsmSamDmeEquipmentChassisDynamicReallocation',
    '17151' => 'fsmSamDmeCallhomeHolderConfigure',
    '17152' => 'fsmSamDmeCallhomeHolderInventory',
    '17163' => 'fsmSamDmeComputePhysicalResetKvm',
    '17164' => 'fsmSamDmeSmartlicenseAgentConfigure',
    '17165' => 'fsmSamDmeSmartlicenseTestConfigure',
    '17166' => 'fsmSamDmeSmartlicenseEntitlementEpConfigure',
    '17167' => 'fsmSamDmeSmartlicenseHolderConfigure',
    '17169' => 'fsmSamDmeMgmtControllerOnline',
    '17170' => 'fsmSamDmeComputeRackUnitOffline',
    '17187' => 'fsmSamDmeEquipmentLocatorLedSetFiLocatorLed',
    '17190' => 'fsmConfPhysical',
    '17192' => 'fsmClusterRole',
    '17195' => 'fsmIlluminate',
    '17196' => 'fsmSetFiLocatorLed',
    '17207' => 'fsmDeployAlias',
    '17214' => 'fsmSamDmeFabricEpMgrConfigure',
    '17223' => 'fsmSamDmeVnicProfileSetDeployAlias',
    '17239' => 'fsmSamDmeSwPhysConfPhysical',
    '17254' => 'fsmSamDmeExtvmmEpClusterRole',
    '17259' => 'fsmSamDmeVmLifeCyclePolicyConfig',
    '17261' => 'fsmUpdateState',
    '17262' => 'fsmSamDmeEquipmentBeaconLedIlluminate',
    '17271' => 'fsmSamDmeEtherServerIntfioConfigSpeed',
    '17281' => 'fsmUpdatebios',
    '17282' => 'fsmSamDmeComputePhysicalActivatebios',
    '17312' => 'fsmSamDmeCommDateTimeTimezone',
    '17325' => 'fsmSamDmeFirmwareSystemDeploy',
    '17326' => 'fsmSamDmeFirmwareSystemApplyCatalogPack',
    '17339' => 'fsmSamDmeMgmtExportPolicyReportConfigCopy',
    '17340' => 'fsmSamDmeMgmtImporterReportConfigImport',
    '17348' => 'fsmSamDmeNfsMountInstMount',
    '17349' => 'fsmSamDmeNfsMountInstUnmount',
    '17350' => 'fsmSamDmeNfsMountDefReportNfsMountSuspend',
    '17367' => 'fsmSamDmeStorageSystemSync',
    '17371' => 'fsmSamDmePolicyControlEpOpRemoteDomainReg',
    '17372' => 'fsmSamDmePolicyControlEpOpRemoteDomainUnReg',
    '17373' => 'fsmSamDmeEquipmentChassisProfileConfigure',
    '17381' => 'fsmSamDmeSwFcSanBorderActivateZoneSet',
    '17382' => 'fsmSamDmeExtpolEpRegisterFsm',
    '17383' => 'fsmSamDmeExtpolRegistryCrossDomainConfig',
    '17384' => 'fsmSamDmeExtpolRegistryCrossDomainDelete',
    '17399' => 'fsmSamDmeExtpolEpRepairCert',
    '17400' => 'fsmSamDmePolicyControlEpOperate',
    '17402' => 'fsmSamDmePolicyPolicyScopeReleasePolicyFsm',
    '17403' => 'fsmSamDmePolicyPolicyScopeReleaseOperationFsm',
    '17404' => 'fsmSamDmePolicyPolicyScopeReleaseStorageFsm',
    '17405' => 'fsmSamDmePolicyPolicyScopeResolveManyPolicyFsm',
    '17406' => 'fsmSamDmePolicyPolicyScopeResolveManyOperationFsm',
    '17407' => 'fsmSamDmePolicyPolicyScopeResolveManyStorageFsm',
    '17408' => 'fsmSamDmePolicyPolicyScopeReleaseManyPolicyFsm',
    '17409' => 'fsmSamDmePolicyPolicyScopeReleaseManyOperationFsm',
    '17410' => 'fsmSamDmePolicyPolicyScopeReleaseManyStorageFsm',
    '17411' => 'fsmSamDmePolicyPolicyScopeResolveAllPolicyFsm',
    '17412' => 'fsmSamDmePolicyPolicyScopeResolveAllOperationFsm',
    '17413' => 'fsmSamDmePolicyPolicyScopeResolveAllStorageFsm',
    '17414' => 'fsmSamDmePolicyPolicyScopeReleaseAllPolicyFsm',
    '17415' => 'fsmSamDmePolicyPolicyScopeReleaseAllOperationFsm',
    '17416' => 'fsmSamDmePolicyPolicyScopeReleaseAllStorageFsm',
    '17418' => 'fsmSamDmeIdentIdentRequestUpdateIdent',
    '17419' => 'fsmSamDmeIdentMetaSystemSync',
    '17420' => 'fsmSamDmeMgmtControllerRegistryConfig',
    '17421' => 'fsmSamDmeGlRequestEvaluate',
    '17422' => 'fsmSamDmeGlRequestCreateGlobalIdPool',
    '17423' => 'fsmSamDmeGlRequestCreateGlobalPolicy',
    '17424' => 'fsmSamDmeGlRequestGlobalize',
    '17425' => 'fsmSamDmeObserveObservedResolvePolicyFsm',
    '17426' => 'fsmSamDmeObserveObservedResolveResourceFsm',
    '17427' => 'fsmSamDmeObserveObservedResolvevmfsm',
    '17428' => 'fsmSamDmeObserveObservedResolveControllerFsm',
    '17444' => 'fsmSamDmeDiagSrvCtrlOperationConfigure',
    '17445' => 'fsmSamDmePortpioInCompatSfpReplaced',
    '17451' => 'fsmSamDmeFdPhysicalConfigure',
    '17473' => 'fsmSamDmeVnicOutbandMgmtEpConfigureOutband',
    '17474' => 'fsmSamDmeDomainProfileConfigure',
    '17476' => 'fsmSamDmeComputePhysicalResetIpmi',
    '17477' => 'fsmSamDmeComputePhysicalFwUpgrade',
    '17478' => 'fsmSamDmeComputeRackUnitAdapterReset',
    '17479' => 'fsmSamDmeFabricFcZoneProfileConfigure',
    '17483' => 'fsmSamDmeComputeServerDiscPolicyResolveScrubPolicy',
    '17485' => 'fsmSamDmeExtpolProviderReportConfigImport',
    '17599' => 'fsmSamDmeFabricVnetEpSyncEpPushVnetEpDeletion',
    '17601' => 'fsmSamDmeGmetaHolderInventory',
    '17602' => 'fsmSamDmeComputePhysicalCimcSessionDelete',
    '17612' => 'fsmSamDmePolicyControlledTypeOperate',
    '17660' => 'fsmSamDmeMgmtControllerExtMgmtInterfaceConfig',
    '17661' => 'fsmSamDmeComputeRackUnitCreateDhcpEntry',
    '17662' => 'fsmSamDmeComputePhysicalServiceInfraDeploy',
    '17663' => 'fsmSamDmeComputePhysicalServiceInfraWithdraw',
    '17667' => 'fsmSamDmeComputePhysicalUpdateBoardController',
    '17702' => 'fsmSamDmeComputePhysicalConfigBoard',
    '17703' => 'fsmSamDmeComputePhysicalResetMemoryErrors',
    '17707' => 'fsmSamDmeMgmtipv6IfAddrSwMgmtOobIpv6IfConfig',
    '17713' => 'fsmSamDmeSwEthLanFlowMonDeploy',
    '17733' => 'fsmSamDmeExtvmmNetworkSetsDeploy',
    '17762' => 'fsmSamDmeComputePhysicalFlashController',
    '17788' => 'fsmSamDmeSysdebugLogExportPolicyConfigure',
    '17791' => 'fsmSamDmeStorageFlexFlashControllermopsReset',
    '17792' => 'fsmSamDmeStorageFlexFlashControllermopsFormat',
    '17793' => 'fsmSamDmeStorageFlexFlashControllermopsPair',
    '17806' => 'fsmSamDmeComputePhysicalEnableCimcSecureBoot',
    '17824' => 'fsmSamDmeIdentMetaSystemUcscUnivSync',
    '17921' => 'fsmSamDmeStoragePartitionDeployStorage',
    '17922' => 'fsmSamDmeStorageProcessorDiscoverSystem',
    '17923' => 'fsmSamDmeStorageProcessorEnterMaintenance',
    '17924' => 'fsmSamDmeStorageProcessorExitMaintenance',
    '17925' => 'fsmSamDmeStorageProcessorDeploySystem',
    '17926' => 'fsmSamDmeStorageProcessorUndeploySystem',
    '17927' => 'fsmSamDmeStorageProcessorHaTakeOver',
    '17928' => 'fsmSamDmeStoragePartitionScrubraidgroup',
    '17933' => 'fsmSamDmeMgmtControllerLockConfig',
    '17934' => 'fsmSamDmeMgmtControllerPowerBudgetReclaimConfig',
    '17935' => 'fsmSamDmeComputePhysicalOobStorageAdminConfig',
    '17940' => 'fsmSamDmeEquipmentiocardBaseFePresence',
    '17941' => 'fsmSamDmeEquipmentiocardBaseFeConn',
    '17954' => 'fsmSamDmeEquipmentLocatorLedSetDiskLocatorLed',
    '17978' => 'fsmSamDmeLstorageProcessorConfigure',
    '17984' => 'fsmSamDmeOsControllerDeployos',
    '17987' => 'fsmSamDmeEquipmentPsuUpdatepsu',
    '18012' => 'fsmSamDmeMgmtControllerUpdatecmc',
    '18013' => 'fsmSamDmeMgmtControllerActivatecmc',
    '18014' => 'fsmSamDmeMgmtControllerUpdateAdaptor',
    '18015' => 'fsmSamDmeMgmtControllerActivateAdaptor',
    '18016' => 'fsmSamDmeMgmtControllerUpdateRaidController',
    '18017' => 'fsmSamDmeMgmtControllerUpdateBoardController',
    '18024' => 'fsmSamDmeFabricCartridgeSlotEpIdentify',
    '18025' => 'fsmSamDmeFabricComputemslotEpIdentify',
    '18026' => 'fsmSamDmeEquipmentChassisOobStorageAdminCfg',
    '18032' => 'fsmSamDmeComputeServerUnitDiscover',
    '18033' => 'fsmSamDmeMgmtIfFaPresence',
    '18034' => 'fsmSamDmeMgmtIfFaConn',
    '18045' => 'fsmSamDmeEquipmentiocardEvacuate',
    '18046' => 'fsmSamDmeEquipmentiocardResetEvacuate',
    '18051' => 'fsmSamDmeComputePhysicalCleartpm',
    '18102' => 'fsmSamDmeEquipmentiocardResetPeerCmc',
    '18124' => 'fsmSamDmeSwExtUtilityConfPortBreakout',
    '18146' => 'fsmSamDmeEquipmentSwitchiocardEvacuate',
    '18147' => 'fsmSamDmeEquipmentSwitchiocardResetEvacuate',
    '18161' => 'fsmSamDmeMorefImportRootApplyMoRefs',
    '18169' => 'fsmSamDmeStorageEnclosureRemoveEnclosure',
    '18184' => 'fsmSamDmeMgmtControllerPowerCap',
    '18185' => 'fsmSamDmeEquipmentSystemiocontrollerResetCmc',
    '18186' => 'fsmSamDmeComputePhysicalDiskZoningInventory',
    '18207' => 'fsmSamDmeEquipmentChassisAssociate',
    '18208' => 'fsmSamDmeEquipmentChassisDisassociate',
    '18237' => 'fsmSamDmeEtherServerIntfioConfig',
    '18239' => 'fsmSamDmeMgmtControllerEnableSecureBoot',
    '18240' => 'fsmSamDmeMgmtControllerUpdateColusacmc',
    '18241' => 'fsmSamDmeMgmtControllerActivateColusacmc',
    '18242' => 'fsmSamDmeEquipmentChassisChassisUpgrade',
    '18243' => 'fsmSamDmeMgmtControllerUpdateColusaBoardController',
    '18244' => 'fsmSamDmeMgmtControllerUpdateSasExpander',
    '18245' => 'fsmSamDmeMgmtControllerActivateSasExpander',
    '18246' => 'fsmSamDmeMgmtControllerActivateLocalDisk',
    '18247' => 'fsmSamDmeStorageLocalDiskUpdateLocalDisk',
    '18259' => 'fsmSamDmeMgmtControllerUpdateucsmanagersp',
    '18260' => 'fsmSamDmeComputePhysicalDiag',
    '18261' => 'fsmSamDmeComputePhysicalCimcSecurityConfig',
    '18290' => 'fsmSamDmeSwPortDiscoverDeploy',
    '18293' => 'fsmSamDmePolicyPolicyScopeContReportPolicyFailFsm',
    '18294' => 'fsmSamDmePolicyRequestorResolveFromCentral',
    '33142' => 'tcaProcessorRuntimeLoad',
    '33144' => 'tcaProcessorRuntimeLoadMin',
    '33145' => 'tcaProcessorRuntimeLoadMax',
    '33146' => 'tcaProcessorRuntimeLoadAvg',
    '33167' => 'tcaFcStatsBytesRxDelta',
    '33168' => 'tcaFcStatsBytesRxDeltaMin',
    '33169' => 'tcaFcStatsBytesRxDeltaMax',
    '33170' => 'tcaFcStatsBytesRxDeltaAvg',
    '33177' => 'tcaFcStatsPacketsRxDelta',
    '33178' => 'tcaFcStatsPacketsRxDeltaMin',
    '33179' => 'tcaFcStatsPacketsRxDeltaMax',
    '33180' => 'tcaFcStatsPacketsRxDeltaAvg',
    '33187' => 'tcaFcStatsBytesTxDelta',
    '33188' => 'tcaFcStatsBytesTxDeltaMin',
    '33189' => 'tcaFcStatsBytesTxDeltaMax',
    '33190' => 'tcaFcStatsBytesTxDeltaAvg',
    '33197' => 'tcaFcStatsPacketsTxDelta',
    '33198' => 'tcaFcStatsPacketsTxDeltaMin',
    '33199' => 'tcaFcStatsPacketsTxDeltaMax',
    '33200' => 'tcaFcStatsPacketsTxDeltaAvg',
    '33211' => 'tcaFcErrStatsCrcRxDelta',
    '33212' => 'tcaFcErrStatsCrcRxDeltaMin',
    '33213' => 'tcaFcErrStatsCrcRxDeltaMax',
    '33214' => 'tcaFcErrStatsCrcRxDeltaAvg',
    '33221' => 'tcaFcErrStatsDiscardRxDelta',
    '33222' => 'tcaFcErrStatsDiscardRxDeltaMin',
    '33223' => 'tcaFcErrStatsDiscardRxDeltaMax',
    '33224' => 'tcaFcErrStatsDiscardRxDeltaAvg',
    '33231' => 'tcaFcErrStatsTooLongRxDelta',
    '33232' => 'tcaFcErrStatsTooLongRxDeltaMin',
    '33233' => 'tcaFcErrStatsTooLongRxDeltaMax',
    '33234' => 'tcaFcErrStatsTooLongRxDeltaAvg',
    '33241' => 'tcaFcErrStatsTooShortRxDelta',
    '33242' => 'tcaFcErrStatsTooShortRxDeltaMin',
    '33243' => 'tcaFcErrStatsTooShortRxDeltaMax',
    '33244' => 'tcaFcErrStatsTooShortRxDeltaAvg',
    '33251' => 'tcaFcErrStatsRxDelta',
    '33252' => 'tcaFcErrStatsRxDeltaMin',
    '33253' => 'tcaFcErrStatsRxDeltaMax',
    '33254' => 'tcaFcErrStatsRxDeltaAvg',
    '33261' => 'tcaFcErrStatsDiscardTxDelta',
    '33262' => 'tcaFcErrStatsDiscardTxDeltaMin',
    '33263' => 'tcaFcErrStatsDiscardTxDeltaMax',
    '33264' => 'tcaFcErrStatsDiscardTxDeltaAvg',
    '33271' => 'tcaFcErrStatsTxDelta',
    '33272' => 'tcaFcErrStatsTxDeltaMin',
    '33273' => 'tcaFcErrStatsTxDeltaMax',
    '33274' => 'tcaFcErrStatsTxDeltaAvg',
    '33281' => 'tcaFcErrStatsLinkFailuresDelta',
    '33282' => 'tcaFcErrStatsLinkFailuresDeltaMin',
    '33283' => 'tcaFcErrStatsLinkFailuresDeltaMax',
    '33284' => 'tcaFcErrStatsLinkFailuresDeltaAvg',
    '33291' => 'tcaFcErrStatsSyncLossesDelta',
    '33292' => 'tcaFcErrStatsSyncLossesDeltaMin',
    '33293' => 'tcaFcErrStatsSyncLossesDeltaMax',
    '33294' => 'tcaFcErrStatsSyncLossesDeltaAvg',
    '33301' => 'tcaFcErrStatsSignalLossesDelta',
    '33302' => 'tcaFcErrStatsSignalLossesDeltaMin',
    '33303' => 'tcaFcErrStatsSignalLossesDeltaMax',
    '33304' => 'tcaFcErrStatsSignalLossesDeltaAvg',
    '33483' => 'tcaMemoryRuntimeTotal',
    '33485' => 'tcaMemoryRuntimeTotalMin',
    '33486' => 'tcaMemoryRuntimeTotalMax',
    '33487' => 'tcaMemoryRuntimeTotalAvg',
    '33491' => 'tcaMemoryRuntimeAvailable',
    '33493' => 'tcaMemoryRuntimeAvailableMin',
    '33494' => 'tcaMemoryRuntimeAvailableMax',
    '33495' => 'tcaMemoryRuntimeAvailableAvg',
    '33499' => 'tcaMemoryRuntimeCached',
    '33501' => 'tcaMemoryRuntimeCachedMin',
    '33502' => 'tcaMemoryRuntimeCachedMax',
    '33503' => 'tcaMemoryRuntimeCachedAvg',
    '33720' => 'tcaAdaptorEthPortStatsTotalPacketsDelta',
    '33721' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaMin',
    '33722' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaMax',
    '33723' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaAvg',
    '33730' => 'tcaAdaptorEthPortStatsGoodPacketsDelta',
    '33731' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaMin',
    '33732' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaMax',
    '33733' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaAvg',
    '33740' => 'tcaAdaptorEthPortStatsVlanPacketsDelta',
    '33741' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaMin',
    '33742' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaMax',
    '33743' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaAvg',
    '33750' => 'tcaAdaptorEthPortStatsPausePacketsDelta',
    '33751' => 'tcaAdaptorEthPortStatsPausePacketsDeltaMin',
    '33752' => 'tcaAdaptorEthPortStatsPausePacketsDeltaMax',
    '33753' => 'tcaAdaptorEthPortStatsPausePacketsDeltaAvg',
    '33760' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDelta',
    '33761' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaMin',
    '33762' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaMax',
    '33763' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaAvg',
    '33770' => 'tcaAdaptorEthPortStatsPppPacketsDelta',
    '33771' => 'tcaAdaptorEthPortStatsPppPacketsDeltaMin',
    '33772' => 'tcaAdaptorEthPortStatsPppPacketsDeltaMax',
    '33773' => 'tcaAdaptorEthPortStatsPppPacketsDeltaAvg',
    '33810' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64Delta',
    '33811' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaMin',
    '33812' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaMax',
    '33813' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaAvg',
    '33820' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64Delta',
    '33821' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaMin',
    '33822' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaMax',
    '33823' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaAvg',
    '33830' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128Delta',
    '33831' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaMin',
    '33832' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaMax',
    '33833' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaAvg',
    '33840' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256Delta',
    '33841' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaMin',
    '33842' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaMax',
    '33843' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaAvg',
    '33850' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512Delta',
    '33851' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaMin',
    '33852' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaMax',
    '33853' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaAvg',
    '33860' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024Delta',
    '33861' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaMin',
    '33862' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaMax',
    '33863' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaAvg',
    '33875' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518Delta',
    '33876' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaMin',
    '33877' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaMax',
    '33878' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaAvg',
    '33885' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048Delta',
    '33886' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaMin',
    '33887' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaMax',
    '33888' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaAvg',
    '33895' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096Delta',
    '33896' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaMin',
    '33897' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaMax',
    '33898' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaAvg',
    '33905' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192Delta',
    '33906' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaMin',
    '33907' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaMax',
    '33908' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaAvg',
    '33915' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216Delta',
    '33916' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaMin',
    '33917' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaMax',
    '33918' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaAvg',
    '33925' => 'tcaAdaptorEthPortBySizeLargeStatsGreaterThanOrEqualTo9216Delta',
    '33926' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaMin',
    '33927' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaMax',
    '33928' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaAvg',
    '33940' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDelta',
    '33941' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaMin',
    '33942' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaMax',
    '33943' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaAvg',
    '33950' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDelta',
    '33951' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaMin',
    '33952' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaMax',
    '33953' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaAvg',
    '33960' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDelta',
    '33961' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaMin',
    '33962' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaMax',
    '33963' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaAvg',
    '33970' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDelta',
    '33971' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaMin',
    '33972' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaMax',
    '33973' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaAvg',
    '33980' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDelta',
    '33981' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaMin',
    '33982' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaMax',
    '33983' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaAvg',
    '33995' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDelta',
    '33996' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaMin',
    '33997' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaMax',
    '33998' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaAvg',
    '34005' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDelta',
    '34006' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaMin',
    '34007' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaMax',
    '34008' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaAvg',
    '34015' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDelta',
    '34016' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaMin',
    '34017' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaMax',
    '34018' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaAvg',
    '34030' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDelta',
    '34031' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaMin',
    '34032' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaMax',
    '34033' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaAvg',
    '34040' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDelta',
    '34041' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaMin',
    '34042' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaMax',
    '34043' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaAvg',
    '34050' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDelta',
    '34051' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaMin',
    '34052' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaMax',
    '34053' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaAvg',
    '34064' => 'tcaAdaptorFcPortStatsRxFramesDelta',
    '34065' => 'tcaAdaptorFcPortStatsRxFramesDeltaMin',
    '34066' => 'tcaAdaptorFcPortStatsRxFramesDeltaMax',
    '34067' => 'tcaAdaptorFcPortStatsRxFramesDeltaAvg',
    '34074' => 'tcaAdaptorFcPortStatsTxFramesDelta',
    '34075' => 'tcaAdaptorFcPortStatsTxFramesDeltaMin',
    '34076' => 'tcaAdaptorFcPortStatsTxFramesDeltaMax',
    '34077' => 'tcaAdaptorFcPortStatsTxFramesDeltaAvg',
    '34084' => 'tcaAdaptorFcPortStatsRxBadFramesDelta',
    '34085' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaMin',
    '34086' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaMax',
    '34087' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaAvg',
    '34094' => 'tcaAdaptorFcPortStatsTxBadFramesDelta',
    '34095' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaMin',
    '34096' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaMax',
    '34097' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaAvg',
    '34108' => 'tcaAdaptorVnicStatsPacketsTxDelta',
    '34109' => 'tcaAdaptorVnicStatsPacketsTxDeltaMin',
    '34110' => 'tcaAdaptorVnicStatsPacketsTxDeltaMax',
    '34111' => 'tcaAdaptorVnicStatsPacketsTxDeltaAvg',
    '34118' => 'tcaAdaptorVnicStatsPacketsRxDelta',
    '34119' => 'tcaAdaptorVnicStatsPacketsRxDeltaMin',
    '34120' => 'tcaAdaptorVnicStatsPacketsRxDeltaMax',
    '34121' => 'tcaAdaptorVnicStatsPacketsRxDeltaAvg',
    '34128' => 'tcaAdaptorVnicStatsBytesTxDelta',
    '34129' => 'tcaAdaptorVnicStatsBytesTxDeltaMin',
    '34130' => 'tcaAdaptorVnicStatsBytesTxDeltaMax',
    '34131' => 'tcaAdaptorVnicStatsBytesTxDeltaAvg',
    '34138' => 'tcaAdaptorVnicStatsBytesRxDelta',
    '34139' => 'tcaAdaptorVnicStatsBytesRxDeltaMin',
    '34140' => 'tcaAdaptorVnicStatsBytesRxDeltaMax',
    '34141' => 'tcaAdaptorVnicStatsBytesRxDeltaAvg',
    '34148' => 'tcaAdaptorVnicStatsErrorsTxDelta',
    '34149' => 'tcaAdaptorVnicStatsErrorsTxDeltaMin',
    '34150' => 'tcaAdaptorVnicStatsErrorsTxDeltaMax',
    '34151' => 'tcaAdaptorVnicStatsErrorsTxDeltaAvg',
    '34158' => 'tcaAdaptorVnicStatsErrorsRxDelta',
    '34159' => 'tcaAdaptorVnicStatsErrorsRxDeltaMin',
    '34160' => 'tcaAdaptorVnicStatsErrorsRxDeltaMax',
    '34161' => 'tcaAdaptorVnicStatsErrorsRxDeltaAvg',
    '34168' => 'tcaAdaptorVnicStatsDroppedTxDelta',
    '34169' => 'tcaAdaptorVnicStatsDroppedTxDeltaMin',
    '34170' => 'tcaAdaptorVnicStatsDroppedTxDeltaMax',
    '34171' => 'tcaAdaptorVnicStatsDroppedTxDeltaAvg',
    '34178' => 'tcaAdaptorVnicStatsDroppedRxDelta',
    '34179' => 'tcaAdaptorVnicStatsDroppedRxDeltaMin',
    '34180' => 'tcaAdaptorVnicStatsDroppedRxDeltaMax',
    '34181' => 'tcaAdaptorVnicStatsDroppedRxDeltaAvg',
    '34192' => 'tcaAdaptorFcIffc4StatsInputRequestsDelta',
    '34193' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaMin',
    '34194' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaMax',
    '34195' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaAvg',
    '34202' => 'tcaAdaptorFcIffc4StatsOutputRequestsDelta',
    '34203' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaMin',
    '34204' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaMax',
    '34205' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaAvg',
    '34212' => 'tcaAdaptorFcIffc4StatsControlRequestsDelta',
    '34213' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaMin',
    '34214' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaMax',
    '34215' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaAvg',
    '34222' => 'tcaAdaptorFcIffc4StatsInputMegabytesDelta',
    '34223' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaMin',
    '34224' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaMax',
    '34225' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaAvg',
    '34232' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDelta',
    '34233' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaMin',
    '34234' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaMax',
    '34235' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaAvg',
    '34246' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDelta',
    '34247' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaMin',
    '34248' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaMax',
    '34249' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaAvg',
    '34256' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDelta',
    '34257' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaMin',
    '34258' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaMax',
    '34259' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaAvg',
    '34271' => 'tcaAdaptorMenloMcpuStatsDropAclDelta',
    '34272' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaMin',
    '34273' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaMax',
    '34274' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaAvg',
    '34281' => 'tcaAdaptorMenloMcpuStatsDropOverrunDelta',
    '34282' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaMin',
    '34283' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaMax',
    '34284' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaAvg',
    '34291' => 'tcaAdaptorMenloMcpuStatsDropRuntDelta',
    '34292' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaMin',
    '34293' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaMax',
    '34294' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaAvg',
    '34301' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDelta',
    '34302' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaMin',
    '34303' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaMax',
    '34304' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaAvg',
    '34316' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDelta',
    '34317' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaMin',
    '34318' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaMax',
    '34319' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaAvg',
    '34326' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDelta',
    '34327' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaMin',
    '34328' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaMax',
    '34329' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaAvg',
    '34336' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDelta',
    '34337' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaMin',
    '34338' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaMax',
    '34339' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaAvg',
    '34346' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDelta',
    '34347' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaMin',
    '34348' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaMax',
    '34349' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaAvg',
    '34361' => 'tcaAdaptorMenloEthStatsDropOverrunDelta',
    '34362' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaMin',
    '34363' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaMax',
    '34364' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaAvg',
    '34371' => 'tcaAdaptorMenloEthStatsDropRuntDelta',
    '34372' => 'tcaAdaptorMenloEthStatsDropRuntDeltaMin',
    '34373' => 'tcaAdaptorMenloEthStatsDropRuntDeltaMax',
    '34374' => 'tcaAdaptorMenloEthStatsDropRuntDeltaAvg',
    '34381' => 'tcaAdaptorMenloEthStatsTruncateOverrunDelta',
    '34382' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaMin',
    '34383' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaMax',
    '34384' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaAvg',
    '34396' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDelta',
    '34397' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaMin',
    '34398' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaMax',
    '34399' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaAvg',
    '34406' => 'tcaAdaptorMenloEthErrorStatsDropAclDelta',
    '34407' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaMin',
    '34408' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaMax',
    '34409' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaAvg',
    '34416' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDelta',
    '34417' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaMin',
    '34418' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaMax',
    '34419' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaAvg',
    '34426' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDelta',
    '34427' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaMin',
    '34428' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaMax',
    '34429' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaAvg',
    '34436' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDelta',
    '34437' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaMin',
    '34438' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaMax',
    '34439' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaAvg',
    '34451' => 'tcaAdaptorMenloFcStatsDropAclDelta',
    '34452' => 'tcaAdaptorMenloFcStatsDropAclDeltaMin',
    '34453' => 'tcaAdaptorMenloFcStatsDropAclDeltaMax',
    '34454' => 'tcaAdaptorMenloFcStatsDropAclDeltaAvg',
    '34461' => 'tcaAdaptorMenloFcStatsDropOverrunDelta',
    '34462' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaMin',
    '34463' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaMax',
    '34464' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaAvg',
    '34471' => 'tcaAdaptorMenloFcStatsDropRuntDelta',
    '34472' => 'tcaAdaptorMenloFcStatsDropRuntDeltaMin',
    '34473' => 'tcaAdaptorMenloFcStatsDropRuntDeltaMax',
    '34474' => 'tcaAdaptorMenloFcStatsDropRuntDeltaAvg',
    '34481' => 'tcaAdaptorMenloFcStatsTruncateOverrunDelta',
    '34482' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaMin',
    '34483' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaMax',
    '34484' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaAvg',
    '34496' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDelta',
    '34497' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaMin',
    '34498' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaMax',
    '34499' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaAvg',
    '34506' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDelta',
    '34507' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaMin',
    '34508' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaMax',
    '34509' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaAvg',
    '34516' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDelta',
    '34517' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaMin',
    '34518' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaMax',
    '34519' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaAvg',
    '34526' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDelta',
    '34527' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaMin',
    '34528' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaMax',
    '34529' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaAvg',
    '34542' => 'tcaAdaptorMenloqstatsDropOverrunN0Delta',
    '34543' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaMin',
    '34544' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaMax',
    '34545' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaAvg',
    '34552' => 'tcaAdaptorMenloqstatsDropOverrunN1Delta',
    '34553' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaMin',
    '34554' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaMax',
    '34555' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaAvg',
    '34562' => 'tcaAdaptorMenloqstatsTruncateOverrunN0Delta',
    '34563' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaMin',
    '34564' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaMax',
    '34565' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaAvg',
    '34572' => 'tcaAdaptorMenloqstatsTruncateOverrunN1Delta',
    '34573' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaMin',
    '34574' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaMax',
    '34575' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaAvg',
    '34588' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDelta',
    '34589' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaMin',
    '34590' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaMax',
    '34591' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaAvg',
    '34598' => 'tcaAdaptorMenloqerrorStatsPopErrorsDelta',
    '34599' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaMin',
    '34600' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaMax',
    '34601' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaAvg',
    '34608' => 'tcaAdaptorMenloqerrorStatsPushErrorsDelta',
    '34609' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaMin',
    '34610' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaMax',
    '34611' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaAvg',
    '34618' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDelta',
    '34619' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaMin',
    '34620' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaMax',
    '34621' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaAvg',
    '34633' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDelta',
    '34634' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaMin',
    '34635' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaMax',
    '34636' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaAvg',
    '34643' => 'tcaAdaptorMenloNetEgStatsDropCmdDelta',
    '34644' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaMin',
    '34645' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaMax',
    '34646' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaAvg',
    '34653' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDelta',
    '34654' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaMin',
    '34655' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaMax',
    '34656' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaAvg',
    '34663' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDelta',
    '34664' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaMin',
    '34665' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaMax',
    '34666' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaAvg',
    '34673' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDelta',
    '34674' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaMin',
    '34675' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaMax',
    '34676' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaAvg',
    '34688' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDelta',
    '34689' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaMin',
    '34690' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaMax',
    '34691' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaAvg',
    '34698' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDelta',
    '34699' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaMin',
    '34700' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaMax',
    '34701' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaAvg',
    '34708' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDelta',
    '34709' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaMin',
    '34710' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaMax',
    '34711' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaAvg',
    '34718' => 'tcaAdaptorMenloNetInStatsDropNullPifDelta',
    '34719' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaMin',
    '34720' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaMax',
    '34721' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaAvg',
    '34733' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdelta',
    '34734' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaMin',
    '34735' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaMax',
    '34736' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaAvg',
    '34743' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdelta',
    '34744' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaMin',
    '34745' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaMax',
    '34746' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaAvg',
    '34753' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdelta',
    '34754' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaMin',
    '34755' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaMax',
    '34756' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaAvg',
    '34763' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdelta',
    '34764' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaMin',
    '34765' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaMax',
    '34766' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaAvg',
    '34778' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdelta',
    '34779' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaMin',
    '34780' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaMax',
    '34781' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaAvg',
    '34788' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdelta',
    '34789' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaMin',
    '34790' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaMax',
    '34791' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaAvg',
    '34798' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdelta',
    '34799' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaMin',
    '34800' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaMax',
    '34801' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaAvg',
    '34808' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdelta',
    '34809' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaMin',
    '34810' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaMax',
    '34811' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaAvg',
    '34822' => 'tcaAdaptorEtherIfStatsTxBytesDelta',
    '34823' => 'tcaAdaptorEtherIfStatsTxBytesDeltaMin',
    '34824' => 'tcaAdaptorEtherIfStatsTxBytesDeltaMax',
    '34825' => 'tcaAdaptorEtherIfStatsTxBytesDeltaAvg',
    '34832' => 'tcaAdaptorEtherIfStatsTxPacketsDelta',
    '34833' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaMin',
    '34834' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaMax',
    '34835' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaAvg',
    '34842' => 'tcaAdaptorEtherIfStatsTxErrorsDelta',
    '34843' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaMin',
    '34844' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaMax',
    '34845' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaAvg',
    '34852' => 'tcaAdaptorEtherIfStatsTxDroppedDelta',
    '34853' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaMin',
    '34854' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaMax',
    '34855' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaAvg',
    '34862' => 'tcaAdaptorEtherIfStatsRxBytesDelta',
    '34863' => 'tcaAdaptorEtherIfStatsRxBytesDeltaMin',
    '34864' => 'tcaAdaptorEtherIfStatsRxBytesDeltaMax',
    '34865' => 'tcaAdaptorEtherIfStatsRxBytesDeltaAvg',
    '34872' => 'tcaAdaptorEtherIfStatsRxPacketsDelta',
    '34873' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaMin',
    '34874' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaMax',
    '34875' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaAvg',
    '34882' => 'tcaAdaptorEtherIfStatsRxErrorsDelta',
    '34883' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaMin',
    '34884' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaMax',
    '34885' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaAvg',
    '34892' => 'tcaAdaptorEtherIfStatsRxDroppedDelta',
    '34893' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaMin',
    '34894' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaMax',
    '34895' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaAvg',
    '34906' => 'tcaAdaptorFcIfFrameStatsTxFramesDelta',
    '34907' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaMin',
    '34908' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaMax',
    '34909' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaAvg',
    '34916' => 'tcaAdaptorFcIfFrameStatsRxFramesDelta',
    '34917' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaMin',
    '34918' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaMax',
    '34919' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaAvg',
    '34926' => 'tcaAdaptorFcIfFrameStatsErrorFramesDelta',
    '34927' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaMin',
    '34928' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaMax',
    '34929' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaAvg',
    '34936' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDelta',
    '34937' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaMin',
    '34938' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaMax',
    '34939' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaAvg',
    '34950' => 'tcaAdaptorFcIfEventStatsLipCountDelta',
    '34951' => 'tcaAdaptorFcIfEventStatsLipCountDeltaMin',
    '34952' => 'tcaAdaptorFcIfEventStatsLipCountDeltaMax',
    '34953' => 'tcaAdaptorFcIfEventStatsLipCountDeltaAvg',
    '34960' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDelta',
    '34961' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaMin',
    '34962' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaMax',
    '34963' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaAvg',
    '34970' => 'tcaAdaptorFcIfEventStatsNoscountDelta',
    '34971' => 'tcaAdaptorFcIfEventStatsNoscountDeltaMin',
    '34972' => 'tcaAdaptorFcIfEventStatsNoscountDeltaMax',
    '34973' => 'tcaAdaptorFcIfEventStatsNoscountDeltaAvg',
    '34980' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDelta',
    '34981' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaMin',
    '34982' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaMax',
    '34983' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaAvg',
    '34990' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDelta',
    '34991' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaMin',
    '34992' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaMax',
    '34993' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaAvg',
    '35000' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDelta',
    '35001' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaMin',
    '35002' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaMax',
    '35003' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaAvg',
    '35010' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDelta',
    '35011' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaMin',
    '35012' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaMax',
    '35013' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaAvg',
    '35020' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDelta',
    '35021' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaMin',
    '35022' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaMax',
    '35023' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaAvg',
    '35163' => 'tcaMemoryErrorStatsEccMultibitErrorsMin',
    '35164' => 'tcaMemoryErrorStatsEccMultibitErrorsMax',
    '35165' => 'tcaMemoryErrorStatsEccMultibitErrorsAvg',
    '35166' => 'tcaSwEnvStatsMainBoardOutlet1',
    '35168' => 'tcaSwEnvStatsMainBoardOutlet1Min',
    '35169' => 'tcaSwEnvStatsMainBoardOutlet1Max',
    '35170' => 'tcaSwEnvStatsMainBoardOutlet1Avg',
    '35173' => 'tcaMemoryErrorStatsEccSinglebitErrorsMin',
    '35174' => 'tcaSwEnvStatsMainBoardOutlet2',
    '35175' => 'tcaMemoryErrorStatsEccSinglebitErrorsAvg',
    '35176' => 'tcaSwEnvStatsMainBoardOutlet2Min',
    '35177' => 'tcaSwEnvStatsMainBoardOutlet2Max',
    '35178' => 'tcaSwEnvStatsMainBoardOutlet2Avg',
    '35183' => 'tcaMemoryErrorStatsAddressParityErrorsMin',
    '35184' => 'tcaMemoryErrorStatsAddressParityErrorsMax',
    '35185' => 'tcaMemoryErrorStatsAddressParityErrorsAvg',
    '35186' => 'tcaMemoryErrorStatsAddressParityErrorsRunning',
    '35193' => 'tcaMemoryErrorStatsMismatchErrorsMin',
    '35194' => 'tcaMemoryErrorStatsMismatchErrorsMax',
    '35195' => 'tcaMemoryErrorStatsMismatchErrorsAvg',
    '35196' => 'tcaMemoryErrorStatsMismatchErrorsRunning',
    '35198' => 'tcaSwEnvStatsFanCtrlrInlet1',
    '35200' => 'tcaSwEnvStatsFanCtrlrInlet1Min',
    '35201' => 'tcaSwEnvStatsFanCtrlrInlet1Max',
    '35202' => 'tcaSwEnvStatsFanCtrlrInlet1Avg',
    '35206' => 'tcaSwEnvStatsFanCtrlrInlet2',
    '35208' => 'tcaSwEnvStatsFanCtrlrInlet2Min',
    '35209' => 'tcaSwEnvStatsFanCtrlrInlet2Max',
    '35210' => 'tcaSwEnvStatsFanCtrlrInlet2Avg',
    '35214' => 'tcaSwEnvStatsFanCtrlrInlet3',
    '35216' => 'tcaSwEnvStatsFanCtrlrInlet3Min',
    '35217' => 'tcaSwEnvStatsFanCtrlrInlet3Max',
    '35218' => 'tcaSwEnvStatsFanCtrlrInlet3Avg',
    '35222' => 'tcaSwEnvStatsFanCtrlrInlet4',
    '35224' => 'tcaSwEnvStatsFanCtrlrInlet4Min',
    '35225' => 'tcaSwEnvStatsFanCtrlrInlet4Max',
    '35226' => 'tcaSwEnvStatsFanCtrlrInlet4Avg',
    '35234' => 'tcaSwSystemStatsMemAvailable',
    '35236' => 'tcaSwSystemStatsMemAvailableMin',
    '35237' => 'tcaSwSystemStatsMemAvailableMax',
    '35238' => 'tcaSwSystemStatsMemAvailableAvg',
    '35242' => 'tcaSwSystemStatsMemCached',
    '35244' => 'tcaSwSystemStatsMemCachedMin',
    '35245' => 'tcaSwSystemStatsMemCachedMax',
    '35246' => 'tcaSwSystemStatsMemCachedAvg',
    '35250' => 'tcaSwSystemStatsLoad',
    '35252' => 'tcaSwSystemStatsLoadMin',
    '35253' => 'tcaSwSystemStatsLoadMax',
    '35254' => 'tcaSwSystemStatsLoadAvg',
    '35275' => 'tcaEtherTxStatsTotalBytesDelta',
    '35276' => 'tcaEtherTxStatsTotalBytesDeltaMin',
    '35277' => 'tcaEtherTxStatsTotalBytesDeltaMax',
    '35278' => 'tcaEtherTxStatsTotalBytesDeltaAvg',
    '35285' => 'tcaEtherTxStatsTotalPacketsDelta',
    '35286' => 'tcaEtherTxStatsTotalPacketsDeltaMin',
    '35287' => 'tcaEtherTxStatsTotalPacketsDeltaMax',
    '35288' => 'tcaEtherTxStatsTotalPacketsDeltaAvg',
    '35295' => 'tcaEtherTxStatsMulticastPacketsDelta',
    '35296' => 'tcaEtherTxStatsMulticastPacketsDeltaMin',
    '35297' => 'tcaEtherTxStatsMulticastPacketsDeltaMax',
    '35298' => 'tcaEtherTxStatsMulticastPacketsDeltaAvg',
    '35305' => 'tcaEtherTxStatsBroadcastPacketsDelta',
    '35306' => 'tcaEtherTxStatsBroadcastPacketsDeltaMin',
    '35307' => 'tcaEtherTxStatsBroadcastPacketsDeltaMax',
    '35308' => 'tcaEtherTxStatsBroadcastPacketsDeltaAvg',
    '35315' => 'tcaEtherTxStatsJumboPacketsDelta',
    '35316' => 'tcaEtherTxStatsJumboPacketsDeltaMin',
    '35317' => 'tcaEtherTxStatsJumboPacketsDeltaMax',
    '35318' => 'tcaEtherTxStatsJumboPacketsDeltaAvg',
    '35329' => 'tcaEtherRxStatsTotalBytesDelta',
    '35330' => 'tcaEtherRxStatsTotalBytesDeltaMin',
    '35331' => 'tcaEtherRxStatsTotalBytesDeltaMax',
    '35332' => 'tcaEtherRxStatsTotalBytesDeltaAvg',
    '35339' => 'tcaEtherRxStatsTotalPacketsDelta',
    '35340' => 'tcaEtherRxStatsTotalPacketsDeltaMin',
    '35341' => 'tcaEtherRxStatsTotalPacketsDeltaMax',
    '35342' => 'tcaEtherRxStatsTotalPacketsDeltaAvg',
    '35349' => 'tcaEtherRxStatsUnicastPacketsDelta',
    '35350' => 'tcaEtherRxStatsUnicastPacketsDeltaMin',
    '35351' => 'tcaEtherRxStatsUnicastPacketsDeltaMax',
    '35352' => 'tcaEtherRxStatsUnicastPacketsDeltaAvg',
    '35359' => 'tcaEtherRxStatsMulticastPacketsDelta',
    '35360' => 'tcaEtherRxStatsMulticastPacketsDeltaMin',
    '35361' => 'tcaEtherRxStatsMulticastPacketsDeltaMax',
    '35362' => 'tcaEtherRxStatsMulticastPacketsDeltaAvg',
    '35369' => 'tcaEtherRxStatsBroadcastPacketsDelta',
    '35370' => 'tcaEtherRxStatsBroadcastPacketsDeltaMin',
    '35371' => 'tcaEtherRxStatsBroadcastPacketsDeltaMax',
    '35372' => 'tcaEtherRxStatsBroadcastPacketsDeltaAvg',
    '35379' => 'tcaEtherRxStatsJumboPacketsDelta',
    '35380' => 'tcaEtherRxStatsJumboPacketsDeltaMin',
    '35381' => 'tcaEtherRxStatsJumboPacketsDeltaMax',
    '35382' => 'tcaEtherRxStatsJumboPacketsDeltaAvg',
    '35962' => 'tcaComputeMbPowerStatsConsumedPower',
    '35964' => 'tcaComputeMbPowerStatsConsumedPowerMin',
    '35965' => 'tcaComputeMbPowerStatsConsumedPowerMax',
    '35966' => 'tcaComputeMbPowerStatsConsumedPowerAvg',
    '35974' => 'tcaComputeMbTempStatsFmTempSenIo',
    '35976' => 'tcaComputeMbTempStatsFmTempSenIoMin',
    '35977' => 'tcaComputeMbTempStatsFmTempSenIoMax',
    '35978' => 'tcaComputeMbTempStatsFmTempSenIoAvg',
    '36234' => 'tcaEquipmentChassisStatsInputPower',
    '36236' => 'tcaEquipmentChassisStatsInputPowerMin',
    '36237' => 'tcaEquipmentChassisStatsInputPowerMax',
    '36238' => 'tcaEquipmentChassisStatsInputPowerAvg',
    '36242' => 'tcaEquipmentChassisStatsOutputPower',
    '36244' => 'tcaEquipmentChassisStatsOutputPowerMin',
    '36245' => 'tcaEquipmentChassisStatsOutputPowerMax',
    '36246' => 'tcaEquipmentChassisStatsOutputPowerAvg',
    '36266' => 'tcaEquipmentPsuStatsAmbientTemp',
    '36268' => 'tcaEquipmentPsuStatsAmbientTempMin',
    '36269' => 'tcaEquipmentPsuStatsAmbientTempMax',
    '36270' => 'tcaEquipmentPsuStatsAmbientTempAvg',
    '36274' => 'tcaEquipmentPsuStatsOutputCurrent',
    '36276' => 'tcaEquipmentPsuStatsOutputCurrentMin',
    '36277' => 'tcaEquipmentPsuStatsOutputCurrentMax',
    '36278' => 'tcaEquipmentPsuStatsOutputCurrentAvg',
    '36282' => 'tcaEquipmentPsuStatsOutputPower',
    '36284' => 'tcaEquipmentPsuStatsOutputPowerMin',
    '36285' => 'tcaEquipmentPsuStatsOutputPowerMax',
    '36286' => 'tcaEquipmentPsuStatsOutputPowerAvg',
    '36294' => 'tcaEquipmentPsuInputStatsCurrent',
    '36296' => 'tcaEquipmentPsuInputStatsCurrentMin',
    '36297' => 'tcaEquipmentPsuInputStatsCurrentMax',
    '36298' => 'tcaEquipmentPsuInputStatsCurrentAvg',
    '36302' => 'tcaEquipmentPsuInputStatsVoltage',
    '36304' => 'tcaEquipmentPsuInputStatsVoltageMin',
    '36305' => 'tcaEquipmentPsuInputStatsVoltageMax',
    '36306' => 'tcaEquipmentPsuInputStatsVoltageAvg',
    '36310' => 'tcaEquipmentPsuInputStatsPower',
    '36312' => 'tcaEquipmentPsuInputStatsPowerMin',
    '36313' => 'tcaEquipmentPsuInputStatsPowerMax',
    '36314' => 'tcaEquipmentPsuInputStatsPowerAvg',
    '36323' => 'tcaEquipmentFanModuleStatsAmbientTemp',
    '36325' => 'tcaEquipmentFanModuleStatsAmbientTempMin',
    '36326' => 'tcaEquipmentFanModuleStatsAmbientTempMax',
    '36327' => 'tcaEquipmentFanModuleStatsAmbientTempAvg',
    '36335' => 'tcaEquipmentFanStatsSpeed',
    '36337' => 'tcaEquipmentFanStatsSpeedMin',
    '36338' => 'tcaEquipmentFanStatsSpeedMax',
    '36339' => 'tcaEquipmentFanStatsSpeedAvg',
    '37154' => 'tcaEquipmentPsuStatsOutput12v',
    '37156' => 'tcaEquipmentPsuStatsOutput12vMin',
    '37157' => 'tcaEquipmentPsuStatsOutput12vMax',
    '37158' => 'tcaEquipmentPsuStatsOutput12vAvg',
    '37162' => 'tcaEquipmentPsuStatsOutput3v3',
    '37164' => 'tcaEquipmentPsuStatsOutput3v3Min',
    '37165' => 'tcaEquipmentPsuStatsOutput3v3Max',
    '37166' => 'tcaEquipmentPsuStatsOutput3v3Avg',
    '37170' => 'tcaEquipmentPsuStatsInput210v',
    '37172' => 'tcaEquipmentPsuStatsInput210vMin',
    '37173' => 'tcaEquipmentPsuStatsInput210vMax',
    '37174' => 'tcaEquipmentPsuStatsInput210vAvg',
    '37269' => 'tcaEquipmentIocardStatsAmbientTemp',
    '37271' => 'tcaEquipmentIocardStatsAmbientTempMin',
    '37272' => 'tcaEquipmentIocardStatsAmbientTempMax',
    '37273' => 'tcaEquipmentIocardStatsAmbientTempAvg',
    '37313' => 'tcaEtherErrStatsAlignDelta',
    '37314' => 'tcaEtherErrStatsAlignDeltaMin',
    '37315' => 'tcaEtherErrStatsAlignDeltaMax',
    '37316' => 'tcaEtherErrStatsAlignDeltaAvg',
    '37323' => 'tcaEtherErrStatsFcsDelta',
    '37324' => 'tcaEtherErrStatsFcsDeltaMin',
    '37325' => 'tcaEtherErrStatsFcsDeltaMax',
    '37326' => 'tcaEtherErrStatsFcsDeltaAvg',
    '37333' => 'tcaEtherErrStatsXmitDelta',
    '37334' => 'tcaEtherErrStatsXmitDeltaMin',
    '37335' => 'tcaEtherErrStatsXmitDeltaMax',
    '37336' => 'tcaEtherErrStatsXmitDeltaAvg',
    '37343' => 'tcaEtherErrStatsRcvDelta',
    '37344' => 'tcaEtherErrStatsRcvDeltaMin',
    '37345' => 'tcaEtherErrStatsRcvDeltaMax',
    '37346' => 'tcaEtherErrStatsRcvDeltaAvg',
    '37353' => 'tcaEtherErrStatsUnderSizeDelta',
    '37354' => 'tcaEtherErrStatsUnderSizeDeltaMin',
    '37355' => 'tcaEtherErrStatsUnderSizeDeltaMax',
    '37356' => 'tcaEtherErrStatsUnderSizeDeltaAvg',
    '37363' => 'tcaEtherErrStatsOutDiscardDelta',
    '37364' => 'tcaEtherErrStatsOutDiscardDeltaMin',
    '37365' => 'tcaEtherErrStatsOutDiscardDeltaMax',
    '37366' => 'tcaEtherErrStatsOutDiscardDeltaAvg',
    '37383' => 'tcaEtherErrStatsIntMacTxDelta',
    '37384' => 'tcaEtherErrStatsIntMacTxDeltaMin',
    '37385' => 'tcaEtherErrStatsIntMacTxDeltaMax',
    '37386' => 'tcaEtherErrStatsIntMacTxDeltaAvg',
    '37393' => 'tcaEtherErrStatsIntMacRxDelta',
    '37394' => 'tcaEtherErrStatsIntMacRxDeltaMin',
    '37395' => 'tcaEtherErrStatsIntMacRxDeltaMax',
    '37396' => 'tcaEtherErrStatsIntMacRxDeltaAvg',
    '37403' => 'tcaEtherLossStatsSingleCollisionDelta',
    '37404' => 'tcaEtherLossStatsSingleCollisionDeltaMin',
    '37405' => 'tcaEtherLossStatsSingleCollisionDeltaMax',
    '37406' => 'tcaEtherLossStatsSingleCollisionDeltaAvg',
    '37413' => 'tcaEtherLossStatsMultiCollisionDelta',
    '37414' => 'tcaEtherLossStatsMultiCollisionDeltaMin',
    '37415' => 'tcaEtherLossStatsMultiCollisionDeltaMax',
    '37416' => 'tcaEtherLossStatsMultiCollisionDeltaAvg',
    '37423' => 'tcaEtherLossStatsLateCollisionDelta',
    '37424' => 'tcaEtherLossStatsLateCollisionDeltaMin',
    '37425' => 'tcaEtherLossStatsLateCollisionDeltaMax',
    '37426' => 'tcaEtherLossStatsLateCollisionDeltaAvg',
    '37443' => 'tcaEtherLossStatsCarrierSenseDelta',
    '37444' => 'tcaEtherLossStatsCarrierSenseDeltaMin',
    '37445' => 'tcaEtherLossStatsCarrierSenseDeltaMax',
    '37446' => 'tcaEtherLossStatsCarrierSenseDeltaAvg',
    '37451' => 'tcaProcessorErrorStatsMirroringIntraSockErrorsMin',
    '37452' => 'tcaProcessorErrorStatsMirroringIntraSockErrorsMax',
    '37453' => 'tcaProcessorErrorStatsMirroringIntraSockErrorsAvg',
    '37454' => 'tcaProcessorErrorStatsMirroringIntraSockErrorsRunning',
    '37455' => 'tcaEtherLossStatsGiantsDeltaMax',
    '37456' => 'tcaEtherLossStatsGiantsDeltaAvg',
    '37461' => 'tcaProcessorErrorStatsMirroringInterSockErrorsMin',
    '37462' => 'tcaProcessorErrorStatsMirroringInterSockErrorsMax',
    '37463' => 'tcaProcessorErrorStatsMirroringInterSockErrorsAvg',
    '37464' => 'tcaProcessorErrorStatsMirroringInterSockErrorsRunning',
    '37465' => 'tcaEtherLossStatsSymbolDeltaMax',
    '37466' => 'tcaEtherLossStatsSymbolDeltaAvg',
    '37471' => 'tcaProcessorErrorStatsSparingErrorsMin',
    '37472' => 'tcaProcessorErrorStatsSparingErrorsMax',
    '37473' => 'tcaProcessorErrorStatsSparingErrorsAvg',
    '37474' => 'tcaProcessorErrorStatsSparingErrorsRunning',
    '37475' => 'tcaEtherLossStatsSqetestDeltaMax',
    '37476' => 'tcaEtherLossStatsSqetestDeltaAvg',
    '37481' => 'tcaProcessorErrorStatsSmiLinkCorrErrorsMin',
    '37482' => 'tcaProcessorErrorStatsSmiLinkCorrErrorsMax',
    '37483' => 'tcaProcessorErrorStatsSmiLinkCorrErrorsAvg',
    '37484' => 'tcaProcessorErrorStatsSmiLinkCorrErrorsRunning',
    '37485' => 'tcaEtherPauseStatsRecvPauseDelta',
    '37486' => 'tcaEtherPauseStatsRecvPauseDeltaMin',
    '37487' => 'tcaEtherPauseStatsRecvPauseDeltaMax',
    '37488' => 'tcaEtherPauseStatsRecvPauseDeltaAvg',
    '37491' => 'tcaProcessorErrorStatsSmiLinkUncorrErrorsMin',
    '37492' => 'tcaProcessorErrorStatsSmiLinkUncorrErrorsMax',
    '37493' => 'tcaProcessorErrorStatsSmiLinkUncorrErrorsAvg',
    '37494' => 'tcaProcessorErrorStatsSmiLinkUncorrErrorsRunning',
    '37495' => 'tcaEtherPauseStatsXmitPauseDelta',
    '37496' => 'tcaEtherPauseStatsXmitPauseDeltaMin',
    '37497' => 'tcaEtherPauseStatsXmitPauseDeltaMax',
    '37498' => 'tcaEtherPauseStatsXmitPauseDeltaAvg',
    '37505' => 'tcaEtherPauseStatsResetsDelta',
    '37506' => 'tcaEtherPauseStatsResetsDeltaMin',
    '37507' => 'tcaEtherPauseStatsResetsDeltaMax',
    '37508' => 'tcaEtherPauseStatsResetsDeltaAvg',
    '37532' => 'tcaEtherLossStatsExcessCollisionDelta',
    '37533' => 'tcaEtherLossStatsExcessCollisionDeltaMin',
    '37534' => 'tcaEtherLossStatsExcessCollisionDeltaMax',
    '37535' => 'tcaEtherLossStatsExcessCollisionDeltaAvg',
    '37543' => 'tcaEtherTxStatsUnicastPacketsDelta',
    '37544' => 'tcaEtherTxStatsUnicastPacketsDeltaMin',
    '37545' => 'tcaEtherTxStatsUnicastPacketsDeltaMax',
    '37546' => 'tcaEtherTxStatsUnicastPacketsDeltaAvg',
    '37553' => 'tcaEtherErrStatsDeferredTxDelta',
    '37554' => 'tcaEtherErrStatsDeferredTxDeltaMin',
    '37555' => 'tcaEtherErrStatsDeferredTxDeltaMax',
    '37556' => 'tcaEtherErrStatsDeferredTxDeltaAvg',
    '37564' => 'tcaComputeMbPowerStatsInputVoltage',
    '37566' => 'tcaComputeMbPowerStatsInputVoltageMin',
    '37567' => 'tcaComputeMbPowerStatsInputVoltageMax',
    '37568' => 'tcaComputeMbPowerStatsInputVoltageAvg',
    '37572' => 'tcaComputeMbPowerStatsInputCurrent',
    '37574' => 'tcaComputeMbPowerStatsInputCurrentMin',
    '37575' => 'tcaComputeMbPowerStatsInputCurrentMax',
    '37576' => 'tcaComputeMbPowerStatsInputCurrentAvg',
    '37580' => 'tcaComputeMbTempStatsFmTempSenRear',
    '37582' => 'tcaComputeMbTempStatsFmTempSenRearMin',
    '37583' => 'tcaComputeMbTempStatsFmTempSenRearMax',
    '37584' => 'tcaComputeMbTempStatsFmTempSenRearAvg',
    '37600' => 'tcaMemoryUnitEnvStatsTemperature',
    '37602' => 'tcaMemoryUnitEnvStatsTemperatureMin',
    '37603' => 'tcaMemoryUnitEnvStatsTemperatureMax',
    '37604' => 'tcaMemoryUnitEnvStatsTemperatureAvg',
    '37610' => 'tcaProcessorEnvStatsTemperature',
    '37612' => 'tcaProcessorEnvStatsTemperatureMin',
    '37613' => 'tcaProcessorEnvStatsTemperatureMax',
    '37614' => 'tcaProcessorEnvStatsTemperatureAvg',
    '37615' => 'tcaComputePcieFatalProtocolStatsFlowControlErrorsMin',
    '37616' => 'tcaComputePcieFatalProtocolStatsFlowControlErrorsMax',
    '37617' => 'tcaComputePcieFatalProtocolStatsFlowControlErrorsAvg',
    '37618' => 'tcaComputePcieFatalProtocolStatsFlowControlErrorsRunning',
    '37625' => 'tcaComputePcieFatalProtocolStatsDllpErrorsMin',
    '37626' => 'tcaComputePcieFatalProtocolStatsDllpErrorsMax',
    '37627' => 'tcaComputePcieFatalProtocolStatsDllpErrorsAvg',
    '37628' => 'tcaComputePcieFatalProtocolStatsDllpErrorsRunning',
    '37637' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrorsMin',
    '37638' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrorsMax',
    '37639' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrorsAvg',
    '37640' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrorsRunning',
    '37647' => 'tcaComputePcieFatalReceiveStatsErrFatalErrorsMin',
    '37648' => 'tcaComputePcieFatalReceiveStatsErrFatalErrorsMax',
    '37649' => 'tcaComputePcieFatalReceiveStatsErrFatalErrorsAvg',
    '37650' => 'tcaComputePcieFatalReceiveStatsErrFatalErrorsRunning',
    '37657' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrorsMin',
    '37658' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrorsMax',
    '37659' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrorsAvg',
    '37660' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrorsRunning',
    '37667' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrorsMin',
    '37668' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrorsMax',
    '37669' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrorsAvg',
    '37670' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrorsRunning',
    '37679' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrorsMin',
    '37680' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrorsMax',
    '37681' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrorsAvg',
    '37682' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrorsRunning',
    '37689' => 'tcaComputePcieFatalCompletionStatsTimeoutErrorsMin',
    '37690' => 'tcaComputePcieFatalCompletionStatsTimeoutErrorsMax',
    '37691' => 'tcaComputePcieFatalCompletionStatsTimeoutErrorsAvg',
    '37692' => 'tcaComputePcieFatalCompletionStatsTimeoutErrorsRunning',
    '37699' => 'tcaComputePcieFatalCompletionStatsAbortErrorsMin',
    '37700' => 'tcaComputePcieFatalCompletionStatsAbortErrorsMax',
    '37701' => 'tcaComputePcieFatalCompletionStatsAbortErrorsAvg',
    '37702' => 'tcaComputePcieFatalCompletionStatsAbortErrorsRunning',
    '37711' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrorsMin',
    '37712' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrorsMax',
    '37713' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrorsAvg',
    '37714' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrorsRunning',
    '37721' => 'tcaComputePcieFatalStatsPoisonedtlperrorsMin',
    '37722' => 'tcaComputePcieFatalStatsPoisonedtlperrorsMax',
    '37723' => 'tcaComputePcieFatalStatsPoisonedtlperrorsAvg',
    '37724' => 'tcaComputePcieFatalStatsPoisonedtlperrorsRunning',
    '37731' => 'tcaComputePcieFatalStatsAcsViolationErrorsMin',
    '37732' => 'tcaComputePcieFatalStatsAcsViolationErrorsMax',
    '37733' => 'tcaComputePcieFatalStatsAcsViolationErrorsAvg',
    '37734' => 'tcaComputePcieFatalStatsAcsViolationErrorsRunning',
    '37741' => 'tcaComputePcieFatalStatsMalformedtlperrorsMin',
    '37742' => 'tcaComputePcieFatalStatsMalformedtlperrorsMax',
    '37743' => 'tcaComputePcieFatalStatsMalformedtlperrorsAvg',
    '37744' => 'tcaComputePcieFatalStatsMalformedtlperrorsRunning',
    '37771' => 'tcaSwEnvStatsPsuCtrlrInlet1',
    '37773' => 'tcaSwEnvStatsPsuCtrlrInlet1Min',
    '37774' => 'tcaSwEnvStatsPsuCtrlrInlet1Max',
    '37775' => 'tcaSwEnvStatsPsuCtrlrInlet1Avg',
    '37779' => 'tcaSwEnvStatsPsuCtrlrInlet2',
    '37781' => 'tcaSwEnvStatsPsuCtrlrInlet2Min',
    '37782' => 'tcaSwEnvStatsPsuCtrlrInlet2Max',
    '37783' => 'tcaSwEnvStatsPsuCtrlrInlet2Avg',
    '38022' => 'tcaComputePcieFatalProtocolStatsDllpErrors',
    '38032' => 'tcaComputePcieFatalProtocolStatsFlowControlErrors',
    '38044' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrors',
    '38054' => 'tcaComputePcieFatalReceiveStatsErrFatalErrors',
    '38064' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrors',
    '38086' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrors',
    '38096' => 'tcaComputePcieFatalCompletionStatsTimeoutErrors',
    '38106' => 'tcaComputePcieFatalCompletionStatsAbortErrors',
    '38128' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrors',
    '38138' => 'tcaComputePcieFatalStatsPoisonedtlperrors',
    '38148' => 'tcaComputePcieFatalStatsAcsViolationErrors',
    '38158' => 'tcaComputePcieFatalStatsMalformedtlperrors',
    '38311' => 'tcaEquipmentIocardStatsTemp',
    '38313' => 'tcaEquipmentIocardStatsTempMin',
    '38314' => 'tcaEquipmentIocardStatsTempMax',
    '38315' => 'tcaEquipmentIocardStatsTempAvg',
    '38349' => 'tcaProcessorEnvStatsInputCurrent',
    '38351' => 'tcaProcessorEnvStatsInputCurrentMin',
    '38352' => 'tcaProcessorEnvStatsInputCurrentMax',
    '38353' => 'tcaProcessorEnvStatsInputCurrentAvg',
    '38357' => 'tcaMemoryArrayEnvStatsInputCurrent',
    '38359' => 'tcaMemoryArrayEnvStatsInputCurrentMin',
    '38360' => 'tcaMemoryArrayEnvStatsInputCurrentMax',
    '38361' => 'tcaMemoryArrayEnvStatsInputCurrentAvg',
    '38470' => 'tcaAdaptorEthPortBySizeLargeStatsNoBreakdownGreaterThan1518Delta',
    '38471' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaMin',
    '38472' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaMax',
    '38473' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaAvg',
    '38557' => 'tcaPowerGroupStatsPower',
    '38559' => 'tcaPowerGroupStatsPowerMin',
    '38560' => 'tcaPowerGroupStatsPowerMax',
    '38561' => 'tcaPowerGroupStatsPowerAvg',
    '38624' => 'tcaMemoryBufferUnitEnvStatsTemperature',
    '38626' => 'tcaMemoryBufferUnitEnvStatsTemperatureMin',
    '38627' => 'tcaMemoryBufferUnitEnvStatsTemperatureMax',
    '38628' => 'tcaMemoryBufferUnitEnvStatsTemperatureAvg',
    '38678' => 'tcaComputeIohubEnvStatsTemperature',
    '38680' => 'tcaComputeIohubEnvStatsTemperatureMin',
    '38681' => 'tcaComputeIohubEnvStatsTemperatureMax',
    '38682' => 'tcaComputeIohubEnvStatsTemperatureAvg',
    '39082' => 'tcaComputeMbTempStatsFmTempSenRearl',
    '39084' => 'tcaComputeMbTempStatsFmTempSenRearlmin',
    '39085' => 'tcaComputeMbTempStatsFmTempSenRearlmax',
    '39086' => 'tcaComputeMbTempStatsFmTempSenRearlavg',
    '39090' => 'tcaComputeMbTempStatsFmTempSenRearr',
    '39092' => 'tcaComputeMbTempStatsFmTempSenRearrmin',
    '39093' => 'tcaComputeMbTempStatsFmTempSenRearrmax',
    '39094' => 'tcaComputeMbTempStatsFmTempSenRearravg',
    '39107' => 'tcaEquipmentFexEnvStatsOutlet1',
    '39109' => 'tcaEquipmentFexEnvStatsOutlet1Min',
    '39110' => 'tcaEquipmentFexEnvStatsOutlet1Max',
    '39111' => 'tcaEquipmentFexEnvStatsOutlet1Avg',
    '39115' => 'tcaEquipmentFexEnvStatsOutlet2',
    '39117' => 'tcaEquipmentFexEnvStatsOutlet2Min',
    '39118' => 'tcaEquipmentFexEnvStatsOutlet2Max',
    '39119' => 'tcaEquipmentFexEnvStatsOutlet2Avg',
    '39123' => 'tcaEquipmentFexEnvStatsInlet',
    '39125' => 'tcaEquipmentFexEnvStatsInletMin',
    '39126' => 'tcaEquipmentFexEnvStatsInletMax',
    '39127' => 'tcaEquipmentFexEnvStatsInletAvg',
    '39131' => 'tcaEquipmentFexEnvStatsInlet1',
    '39133' => 'tcaEquipmentFexEnvStatsInlet1Min',
    '39134' => 'tcaEquipmentFexEnvStatsInlet1Max',
    '39135' => 'tcaEquipmentFexEnvStatsInlet1Avg',
    '39139' => 'tcaEquipmentFexEnvStatsDie1',
    '39141' => 'tcaEquipmentFexEnvStatsDie1Min',
    '39142' => 'tcaEquipmentFexEnvStatsDie1Max',
    '39143' => 'tcaEquipmentFexEnvStatsDie1Avg',
    '39166' => 'tcaEquipmentFexPowerSummaryTotalPower',
    '39168' => 'tcaEquipmentFexPowerSummaryTotalPowerMin',
    '39169' => 'tcaEquipmentFexPowerSummaryTotalPowerMax',
    '39170' => 'tcaEquipmentFexPowerSummaryTotalPowerAvg',
    '39174' => 'tcaEquipmentFexPowerSummaryReservedPower',
    '39176' => 'tcaEquipmentFexPowerSummaryReservedPowerMin',
    '39177' => 'tcaEquipmentFexPowerSummaryReservedPowerMax',
    '39178' => 'tcaEquipmentFexPowerSummaryReservedPowerAvg',
    '39182' => 'tcaEquipmentFexPowerSummaryModulePower',
    '39184' => 'tcaEquipmentFexPowerSummaryModulePowerMin',
    '39185' => 'tcaEquipmentFexPowerSummaryModulePowerMax',
    '39186' => 'tcaEquipmentFexPowerSummaryModulePowerAvg',
    '39190' => 'tcaEquipmentFexPowerSummaryAvailablePower',
    '39192' => 'tcaEquipmentFexPowerSummaryAvailablePowerMin',
    '39193' => 'tcaEquipmentFexPowerSummaryAvailablePowerMax',
    '39194' => 'tcaEquipmentFexPowerSummaryAvailablePowerAvg',
    '39200' => 'tcaEquipmentFexPsuInputStatsCurrent',
    '39202' => 'tcaEquipmentFexPsuInputStatsCurrentMin',
    '39203' => 'tcaEquipmentFexPsuInputStatsCurrentMax',
    '39204' => 'tcaEquipmentFexPsuInputStatsCurrentAvg',
    '39208' => 'tcaEquipmentFexPsuInputStatsVoltage',
    '39210' => 'tcaEquipmentFexPsuInputStatsVoltageMin',
    '39211' => 'tcaEquipmentFexPsuInputStatsVoltageMax',
    '39212' => 'tcaEquipmentFexPsuInputStatsVoltageAvg',
    '39216' => 'tcaEquipmentFexPsuInputStatsPower',
    '39218' => 'tcaEquipmentFexPsuInputStatsPowerMin',
    '39219' => 'tcaEquipmentFexPsuInputStatsPowerMax',
    '39220' => 'tcaEquipmentFexPsuInputStatsPowerAvg',
    '39227' => 'tcaEquipmentRackUnitPsuStatsAmbientTemp',
    '39229' => 'tcaEquipmentRackUnitPsuStatsAmbientTempMin',
    '39230' => 'tcaEquipmentRackUnitPsuStatsAmbientTempMax',
    '39231' => 'tcaEquipmentRackUnitPsuStatsAmbientTempAvg',
    '39235' => 'tcaEquipmentRackUnitPsuStatsOutputCurrent',
    '39237' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentMin',
    '39238' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentMax',
    '39239' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentAvg',
    '39243' => 'tcaEquipmentRackUnitPsuStatsOutputPower',
    '39245' => 'tcaEquipmentRackUnitPsuStatsOutputPowerMin',
    '39246' => 'tcaEquipmentRackUnitPsuStatsOutputPowerMax',
    '39247' => 'tcaEquipmentRackUnitPsuStatsOutputPowerAvg',
    '39251' => 'tcaEquipmentRackUnitPsuStatsInputPower',
    '39253' => 'tcaEquipmentRackUnitPsuStatsInputPowerMin',
    '39254' => 'tcaEquipmentRackUnitPsuStatsInputPowerMax',
    '39255' => 'tcaEquipmentRackUnitPsuStatsInputPowerAvg',
    '39259' => 'tcaEquipmentRackUnitPsuStatsOutputVoltage',
    '39261' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageMin',
    '39262' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageMax',
    '39263' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageAvg',
    '39267' => 'tcaEquipmentRackUnitPsuStatsInputVoltage',
    '39269' => 'tcaEquipmentRackUnitPsuStatsInputVoltageMin',
    '39270' => 'tcaEquipmentRackUnitPsuStatsInputVoltageMax',
    '39271' => 'tcaEquipmentRackUnitPsuStatsInputVoltageAvg',
    '39392' => 'tcaAdaptorHbavnicStatsPacketsTxDelta',
    '39393' => 'tcaAdaptorHbavnicStatsPacketsTxDeltaMin',
    '39394' => 'tcaAdaptorHbavnicStatsPacketsTxDeltaMax',
    '39395' => 'tcaAdaptorHbavnicStatsPacketsTxDeltaAvg',
    '39402' => 'tcaAdaptorHbavnicStatsPacketsRxDelta',
    '39403' => 'tcaAdaptorHbavnicStatsPacketsRxDeltaMin',
    '39404' => 'tcaAdaptorHbavnicStatsPacketsRxDeltaMax',
    '39405' => 'tcaAdaptorHbavnicStatsPacketsRxDeltaAvg',
    '39412' => 'tcaAdaptorHbavnicStatsBytesTxDelta',
    '39413' => 'tcaAdaptorHbavnicStatsBytesTxDeltaMin',
    '39414' => 'tcaAdaptorHbavnicStatsBytesTxDeltaMax',
    '39415' => 'tcaAdaptorHbavnicStatsBytesTxDeltaAvg',
    '39422' => 'tcaAdaptorHbavnicStatsBytesRxDelta',
    '39423' => 'tcaAdaptorHbavnicStatsBytesRxDeltaMin',
    '39424' => 'tcaAdaptorHbavnicStatsBytesRxDeltaMax',
    '39425' => 'tcaAdaptorHbavnicStatsBytesRxDeltaAvg',
    '39432' => 'tcaAdaptorHbavnicStatsErrorsTxDelta',
    '39433' => 'tcaAdaptorHbavnicStatsErrorsTxDeltaMin',
    '39434' => 'tcaAdaptorHbavnicStatsErrorsTxDeltaMax',
    '39435' => 'tcaAdaptorHbavnicStatsErrorsTxDeltaAvg',
    '39442' => 'tcaAdaptorHbavnicStatsErrorsRxDelta',
    '39443' => 'tcaAdaptorHbavnicStatsErrorsRxDeltaMin',
    '39444' => 'tcaAdaptorHbavnicStatsErrorsRxDeltaMax',
    '39445' => 'tcaAdaptorHbavnicStatsErrorsRxDeltaAvg',
    '39452' => 'tcaAdaptorHbavnicStatsDroppedTxDelta',
    '39453' => 'tcaAdaptorHbavnicStatsDroppedTxDeltaMin',
    '39454' => 'tcaAdaptorHbavnicStatsDroppedTxDeltaMax',
    '39455' => 'tcaAdaptorHbavnicStatsDroppedTxDeltaAvg',
    '39462' => 'tcaAdaptorHbavnicStatsDroppedRxDelta',
    '39463' => 'tcaAdaptorHbavnicStatsDroppedRxDeltaMin',
    '39464' => 'tcaAdaptorHbavnicStatsDroppedRxDeltaMax',
    '39465' => 'tcaAdaptorHbavnicStatsDroppedRxDeltaAvg',
    '39474' => 'tcaAdaptorNicvnicStatsPacketsTxDelta',
    '39475' => 'tcaAdaptorNicvnicStatsPacketsTxDeltaMin',
    '39476' => 'tcaAdaptorNicvnicStatsPacketsTxDeltaMax',
    '39477' => 'tcaAdaptorNicvnicStatsPacketsTxDeltaAvg',
    '39484' => 'tcaAdaptorNicvnicStatsPacketsRxDelta',
    '39485' => 'tcaAdaptorNicvnicStatsPacketsRxDeltaMin',
    '39486' => 'tcaAdaptorNicvnicStatsPacketsRxDeltaMax',
    '39487' => 'tcaAdaptorNicvnicStatsPacketsRxDeltaAvg',
    '39494' => 'tcaAdaptorNicvnicStatsBytesTxDelta',
    '39495' => 'tcaAdaptorNicvnicStatsBytesTxDeltaMin',
    '39496' => 'tcaAdaptorNicvnicStatsBytesTxDeltaMax',
    '39497' => 'tcaAdaptorNicvnicStatsBytesTxDeltaAvg',
    '39504' => 'tcaAdaptorNicvnicStatsBytesRxDelta',
    '39505' => 'tcaAdaptorNicvnicStatsBytesRxDeltaMin',
    '39506' => 'tcaAdaptorNicvnicStatsBytesRxDeltaMax',
    '39507' => 'tcaAdaptorNicvnicStatsBytesRxDeltaAvg',
    '39514' => 'tcaAdaptorNicvnicStatsErrorsTxDelta',
    '39515' => 'tcaAdaptorNicvnicStatsErrorsTxDeltaMin',
    '39516' => 'tcaAdaptorNicvnicStatsErrorsTxDeltaMax',
    '39517' => 'tcaAdaptorNicvnicStatsErrorsTxDeltaAvg',
    '39524' => 'tcaAdaptorNicvnicStatsErrorsRxDelta',
    '39525' => 'tcaAdaptorNicvnicStatsErrorsRxDeltaMin',
    '39526' => 'tcaAdaptorNicvnicStatsErrorsRxDeltaMax',
    '39527' => 'tcaAdaptorNicvnicStatsErrorsRxDeltaAvg',
    '39534' => 'tcaAdaptorNicvnicStatsDroppedTxDelta',
    '39535' => 'tcaAdaptorNicvnicStatsDroppedTxDeltaMin',
    '39536' => 'tcaAdaptorNicvnicStatsDroppedTxDeltaMax',
    '39537' => 'tcaAdaptorNicvnicStatsDroppedTxDeltaAvg',
    '39544' => 'tcaAdaptorNicvnicStatsDroppedRxDelta',
    '39545' => 'tcaAdaptorNicvnicStatsDroppedRxDeltaMin',
    '39546' => 'tcaAdaptorNicvnicStatsDroppedRxDeltaMax',
    '39547' => 'tcaAdaptorNicvnicStatsDroppedRxDeltaAvg',
    '39583' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrors',
    '39649' => 'tcaProcessorErrorStatsMirroringIntraSockErrors',
    '39658' => 'tcaProcessorErrorStatsMirroringInterSockErrors',
    '39667' => 'tcaProcessorErrorStatsSparingErrors',
    '39676' => 'tcaProcessorErrorStatsSmiLinkCorrErrors',
    '39685' => 'tcaProcessorErrorStatsSmiLinkUncorrErrors',
    '39702' => 'tcaMemoryErrorStatsEccMultibitErrors',
    '39711' => 'tcaMemoryErrorStatsEccSinglebitErrors',
    '39720' => 'tcaMemoryErrorStatsAddressParityErrors',
    '39729' => 'tcaMemoryErrorStatsMismatchErrors',
    '39794' => 'tcaEquipmentRackUnitFanStatsSpeed',
    '39796' => 'tcaEquipmentRackUnitFanStatsSpeedMin',
    '39797' => 'tcaEquipmentRackUnitFanStatsSpeedMax',
    '39798' => 'tcaEquipmentRackUnitFanStatsSpeedAvg',
    '40092' => 'tcaComputeRackUnitMbTempStatsFrontTemp',
    '40094' => 'tcaComputeRackUnitMbTempStatsFrontTempMin',
    '40095' => 'tcaComputeRackUnitMbTempStatsFrontTempMax',
    '40096' => 'tcaComputeRackUnitMbTempStatsFrontTempAvg',
    '40100' => 'tcaComputeRackUnitMbTempStatsRearTemp',
    '40102' => 'tcaComputeRackUnitMbTempStatsRearTempMin',
    '40103' => 'tcaComputeRackUnitMbTempStatsRearTempMax',
    '40104' => 'tcaComputeRackUnitMbTempStatsRearTempAvg',
    '40108' => 'tcaComputeRackUnitMbTempStatsAmbientTemp',
    '40110' => 'tcaComputeRackUnitMbTempStatsAmbientTempMin',
    '40111' => 'tcaComputeRackUnitMbTempStatsAmbientTempMax',
    '40112' => 'tcaComputeRackUnitMbTempStatsAmbientTempAvg',
    '40116' => 'tcaComputeRackUnitMbTempStatsIoh1Temp',
    '40118' => 'tcaComputeRackUnitMbTempStatsIoh1TempMin',
    '40119' => 'tcaComputeRackUnitMbTempStatsIoh1TempMax',
    '40120' => 'tcaComputeRackUnitMbTempStatsIoh1TempAvg',
    '40124' => 'tcaComputeRackUnitMbTempStatsIoh2Temp',
    '40126' => 'tcaComputeRackUnitMbTempStatsIoh2TempMin',
    '40127' => 'tcaComputeRackUnitMbTempStatsIoh2TempMax',
    '40128' => 'tcaComputeRackUnitMbTempStatsIoh2TempAvg',
    '40441' => 'tcaEquipmentPsuOutputStatsCurrent',
    '40443' => 'tcaEquipmentPsuOutputStatsCurrentMin',
    '40444' => 'tcaEquipmentPsuOutputStatsCurrentMax',
    '40445' => 'tcaEquipmentPsuOutputStatsCurrentAvg',
    '40449' => 'tcaEquipmentPsuOutputStatsVoltage',
    '40451' => 'tcaEquipmentPsuOutputStatsVoltageMin',
    '40452' => 'tcaEquipmentPsuOutputStatsVoltageMax',
    '40453' => 'tcaEquipmentPsuOutputStatsVoltageAvg',
    '40457' => 'tcaEquipmentPsuOutputStatsPower',
    '40459' => 'tcaEquipmentPsuOutputStatsPowerMin',
    '40460' => 'tcaEquipmentPsuOutputStatsPowerMax',
    '40461' => 'tcaEquipmentPsuOutputStatsPowerAvg',
    '40583' => 'tcaEquipmentNetworkElementFanStatsSpeed',
    '40585' => 'tcaEquipmentNetworkElementFanStatsSpeedMin',
    '40586' => 'tcaEquipmentNetworkElementFanStatsSpeedMax',
    '40587' => 'tcaEquipmentNetworkElementFanStatsSpeedAvg',
    '40591' => 'tcaEquipmentNetworkElementFanStatsDrivePercentage',
    '40593' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageMin',
    '40594' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageMax',
    '40595' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageAvg',
    '41016' => 'tcaSwCardEnvStatsSlotOutlet1',
    '41018' => 'tcaSwCardEnvStatsSlotOutlet1Min',
    '41019' => 'tcaSwCardEnvStatsSlotOutlet1Max',
    '41020' => 'tcaSwCardEnvStatsSlotOutlet1Avg',
    '41024' => 'tcaSwCardEnvStatsSlotOutlet2',
    '41026' => 'tcaSwCardEnvStatsSlotOutlet2Min',
    '41027' => 'tcaSwCardEnvStatsSlotOutlet2Max',
    '41028' => 'tcaSwCardEnvStatsSlotOutlet2Avg',
    '41032' => 'tcaSwCardEnvStatsSlotOutlet3',
    '41034' => 'tcaSwCardEnvStatsSlotOutlet3Min',
    '41035' => 'tcaSwCardEnvStatsSlotOutlet3Max',
    '41036' => 'tcaSwCardEnvStatsSlotOutlet3Avg',
    '41049' => 'tcaEtherFcoeInterfaceStatsPacketsTxDelta',
    '41050' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaMin',
    '41051' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaMax',
    '41052' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaAvg',
    '41059' => 'tcaEtherFcoeInterfaceStatsPacketsRxDelta',
    '41060' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaMin',
    '41061' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaMax',
    '41062' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaAvg',
    '41069' => 'tcaEtherFcoeInterfaceStatsBytesTxDelta',
    '41070' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaMin',
    '41071' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaMax',
    '41072' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaAvg',
    '41079' => 'tcaEtherFcoeInterfaceStatsBytesRxDelta',
    '41080' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaMin',
    '41081' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaMax',
    '41082' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaAvg',
    '41089' => 'tcaEtherFcoeInterfaceStatsErrorsTxDelta',
    '41090' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaMin',
    '41091' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaMax',
    '41092' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaAvg',
    '41099' => 'tcaEtherFcoeInterfaceStatsErrorsRxDelta',
    '41100' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaMin',
    '41101' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaMax',
    '41102' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaAvg',
    '41109' => 'tcaEtherFcoeInterfaceStatsDroppedTxDelta',
    '41110' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaMin',
    '41111' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaMax',
    '41112' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaAvg',
    '41119' => 'tcaEtherFcoeInterfaceStatsDroppedRxDelta',
    '41120' => 'tcaEtherFcoeInterfaceStatsDroppedRxDeltaMin',
    '41121' => 'tcaEtherFcoeInterfaceStatsDroppedRxDeltaMax',
    '41122' => 'tcaEtherFcoeInterfaceStatsDroppedRxDeltaAvg',
    '43132' => 'tcaEtherNiErrStatsFrameTxDelta',
    '43133' => 'tcaEtherNiErrStatsFrameTxDeltaMin',
    '43134' => 'tcaEtherNiErrStatsFrameTxDeltaMax',
    '43135' => 'tcaEtherNiErrStatsFrameTxDeltaAvg',
    '43142' => 'tcaEtherNiErrStatsTooLongDelta',
    '43143' => 'tcaEtherNiErrStatsTooLongDeltaMin',
    '43144' => 'tcaEtherNiErrStatsTooLongDeltaMax',
    '43145' => 'tcaEtherNiErrStatsTooLongDeltaAvg',
    '43152' => 'tcaEtherNiErrStatsTooShortDelta',
    '43153' => 'tcaEtherNiErrStatsTooShortDeltaMin',
    '43154' => 'tcaEtherNiErrStatsTooShortDeltaMax',
    '43155' => 'tcaEtherNiErrStatsTooShortDeltaAvg',
    '43162' => 'tcaEtherNiErrStatsCrcDelta',
    '43163' => 'tcaEtherNiErrStatsCrcDeltaMin',
    '43164' => 'tcaEtherNiErrStatsCrcDeltaMax',
    '43165' => 'tcaEtherNiErrStatsCrcDeltaAvg',
    '43172' => 'tcaEtherNiErrStatsInRangeDelta',
    '43173' => 'tcaEtherNiErrStatsInRangeDeltaMin',
    '43174' => 'tcaEtherNiErrStatsInRangeDeltaMax',
    '43175' => 'tcaEtherNiErrStatsInRangeDeltaAvg',
    '43209' => 'tcaStorageHddMotherBoardTempStatsRightInletTemp',
    '43211' => 'tcaStorageHddMotherBoardTempStatsRightInletTempMin',
    '43212' => 'tcaStorageHddMotherBoardTempStatsRightInletTempMax',
    '43213' => 'tcaStorageHddMotherBoardTempStatsRightInletTempAvg',
    '43217' => 'tcaStorageHddMotherBoardTempStatsLeftInletTemp',
    '43219' => 'tcaStorageHddMotherBoardTempStatsLeftInletTempMin',
    '43220' => 'tcaStorageHddMotherBoardTempStatsLeftInletTempMax',
    '43221' => 'tcaStorageHddMotherBoardTempStatsLeftInletTempAvg',
    '43225' => 'tcaStorageHddMotherBoardTempStatsRightOutletTemp',
    '43227' => 'tcaStorageHddMotherBoardTempStatsRightOutletTempMin',
    '43228' => 'tcaStorageHddMotherBoardTempStatsRightOutletTempMax',
    '43229' => 'tcaStorageHddMotherBoardTempStatsRightOutletTempAvg',
    '43233' => 'tcaStorageHddMotherBoardTempStatsLeftOutletTemp',
    '43235' => 'tcaStorageHddMotherBoardTempStatsLeftOutletTempMin',
    '43236' => 'tcaStorageHddMotherBoardTempStatsLeftOutletTempMax',
    '43237' => 'tcaStorageHddMotherBoardTempStatsLeftOutletTempAvg',
    '43549' => 'tcaStorageCtrlStorageStatsCpuLoad',
    '43551' => 'tcaStorageCtrlStorageStatsCpuLoadMin',
    '43552' => 'tcaStorageCtrlStorageStatsCpuLoadMax',
    '43553' => 'tcaStorageCtrlStorageStatsCpuLoadAvg',
    '43557' => 'tcaStorageCtrlStorageStatsMemoryUsage',
    '43559' => 'tcaStorageCtrlStorageStatsMemoryUsageMin',
    '43560' => 'tcaStorageCtrlStorageStatsMemoryUsageMax',
    '43561' => 'tcaStorageCtrlStorageStatsMemoryUsageAvg',
    '43567' => 'tcaStorageStorageStatsIops',
    '43569' => 'tcaStorageStorageStatsIopsMin',
    '43570' => 'tcaStorageStorageStatsIopsMax',
    '43571' => 'tcaStorageStorageStatsIopsAvg',
    '43575' => 'tcaStorageStorageStatsLatency',
    '43577' => 'tcaStorageStorageStatsLatencyMin',
    '43578' => 'tcaStorageStorageStatsLatencyMax',
    '43579' => 'tcaStorageStorageStatsLatencyAvg',
    '43583' => 'tcaStorageStorageStatsMbps',
    '43585' => 'tcaStorageStorageStatsMbpsMin',
    '43586' => 'tcaStorageStorageStatsMbpsMax',
    '43587' => 'tcaStorageStorageStatsMbpsAvg',
    '43591' => 'tcaStorageStorageStatsReadIops',
    '43593' => 'tcaStorageStorageStatsReadIopsMin',
    '43594' => 'tcaStorageStorageStatsReadIopsMax',
    '43595' => 'tcaStorageStorageStatsReadIopsAvg',
    '43599' => 'tcaStorageStorageStatsWriteIops',
    '43601' => 'tcaStorageStorageStatsWriteIopsMin',
    '43602' => 'tcaStorageStorageStatsWriteIopsMax',
    '43603' => 'tcaStorageStorageStatsWriteIopsAvg',
    '43607' => 'tcaStorageStorageStatsReadMbps',
    '43609' => 'tcaStorageStorageStatsReadMbpsMin',
    '43610' => 'tcaStorageStorageStatsReadMbpsMax',
    '43611' => 'tcaStorageStorageStatsReadMbpsAvg',
    '43615' => 'tcaStorageStorageStatsWriteMbps',
    '43617' => 'tcaStorageStorageStatsWriteMbpsMin',
    '43618' => 'tcaStorageStorageStatsWriteMbpsMax',
    '43619' => 'tcaStorageStorageStatsWriteMbpsAvg',
    '43714' => 'tcaEquipmentSiocTempStatsRearTemp',
    '43716' => 'tcaEquipmentSiocTempStatsRearTempMin',
    '43717' => 'tcaEquipmentSiocTempStatsRearTempMax',
    '43718' => 'tcaEquipmentSiocTempStatsRearTempAvg',
    '43722' => 'tcaEquipmentSiocTempStatsFrontTemp',
    '43724' => 'tcaEquipmentSiocTempStatsFrontTempMin',
    '43725' => 'tcaEquipmentSiocTempStatsFrontTempMax',
    '43726' => 'tcaEquipmentSiocTempStatsFrontTempAvg',
    '43730' => 'tcaEquipmentSiocTempStatsMidTemp',
    '43732' => 'tcaEquipmentSiocTempStatsMidTempMin',
    '43733' => 'tcaEquipmentSiocTempStatsMidTempMax',
    '43734' => 'tcaEquipmentSiocTempStatsMidTempAvg',
    '43738' => 'tcaEquipmentSiocTempStatsCmcTemp',
    '43740' => 'tcaEquipmentSiocTempStatsCmcTempMin',
    '43741' => 'tcaEquipmentSiocTempStatsCmcTempMax',
    '43742' => 'tcaEquipmentSiocTempStatsCmcTempAvg',
    '43746' => 'tcaEquipmentSiocTempStatsVicTemp',
    '43748' => 'tcaEquipmentSiocTempStatsVicTempMin',
    '43749' => 'tcaEquipmentSiocTempStatsVicTempMax',
    '43750' => 'tcaEquipmentSiocTempStatsVicTempAvg',
    '43935' => 'tcaMemoryNvDimmEnvStatsTemperature',
    '43937' => 'tcaMemoryNvDimmEnvStatsTemperatureMin',
    '43938' => 'tcaMemoryNvDimmEnvStatsTemperatureMax',
    '43939' => 'tcaMemoryNvDimmEnvStatsTemperatureAvg',
    '43943' => 'tcaMemoryNvDimmEnvStatsVoltage',
    '43945' => 'tcaMemoryNvDimmEnvStatsVoltageMin',
    '43946' => 'tcaMemoryNvDimmEnvStatsVoltageMax',
    '43947' => 'tcaMemoryNvDimmEnvStatsVoltageAvg',
    '44035' => 'tcaComputeStorageBladeMbTempStatsFrontTemp',
    '44037' => 'tcaComputeStorageBladeMbTempStatsFrontTempMin',
    '44038' => 'tcaComputeStorageBladeMbTempStatsFrontTempMax',
    '44039' => 'tcaComputeStorageBladeMbTempStatsFrontTempAvg',
    '44043' => 'tcaComputeStorageBladeMbTempStatsLeftRearTemp',
    '44045' => 'tcaComputeStorageBladeMbTempStatsLeftRearTempMin',
    '44046' => 'tcaComputeStorageBladeMbTempStatsLeftRearTempMax',
    '44047' => 'tcaComputeStorageBladeMbTempStatsLeftRearTempAvg',
    '44051' => 'tcaComputeStorageBladeMbTempStatsRightRearTemp',
    '44053' => 'tcaComputeStorageBladeMbTempStatsRightRearTempMin',
    '44054' => 'tcaComputeStorageBladeMbTempStatsRightRearTempMax',
    '44055' => 'tcaComputeStorageBladeMbTempStatsRightRearTempAvg',
    '44131' => 'tcaEquipmentIocardStatsProcTemp',
    '44133' => 'tcaEquipmentIocardStatsProcTempMin',
    '44134' => 'tcaEquipmentIocardStatsProcTempMax',
    '44135' => 'tcaEquipmentIocardStatsProcTempAvg',
    '44139' => 'tcaEquipmentIocardStatsDimmTemp',
    '44141' => 'tcaEquipmentIocardStatsDimmTempMin',
    '44142' => 'tcaEquipmentIocardStatsDimmTempMax',
    '44143' => 'tcaEquipmentIocardStatsDimmTempAvg',
    '44217' => 'tcaStorageDiskEnvStatsTemperature',
    '44219' => 'tcaStorageDiskEnvStatsTemperatureMin',
    '44220' => 'tcaStorageDiskEnvStatsTemperatureMax',
    '44221' => 'tcaStorageDiskEnvStatsTemperatureAvg',
    '44225' => 'tcaStorageDiskEnvStatsWearPercentage',
    '44227' => 'tcaStorageDiskEnvStatsWearPercentageMin',
    '44228' => 'tcaStorageDiskEnvStatsWearPercentageMax',
    '44229' => 'tcaStorageDiskEnvStatsWearPercentageAvg',
    '44564' => 'tcaEquipmentPsuStatsInputPower',
    '44566' => 'tcaEquipmentPsuStatsInputPowerMin',
    '44567' => 'tcaEquipmentPsuStatsInputPowerMax',
    '44568' => 'tcaEquipmentPsuStatsInputPowerAvg',
    '44728' => 'tcaEquipmentChassisStatsChassisI2cerrors',
    '44730' => 'tcaEquipmentChassisStatsChassisI2cerrorsDelta',
    '44731' => 'tcaEquipmentChassisStatsChassisI2cerrorsDeltaMin',
    '44732' => 'tcaEquipmentChassisStatsChassisI2cerrorsDeltaMax',
    '44733' => 'tcaEquipmentChassisStatsChassisI2cerrorsDeltaAvg',
    '44738' => 'tcaEquipmentIocardStatsIomI2cerrors',
    '44740' => 'tcaEquipmentIocardStatsIomI2cerrorsDelta',
    '44741' => 'tcaEquipmentIocardStatsIomI2cerrorsDeltaMin',
    '44742' => 'tcaEquipmentIocardStatsIomI2cerrorsDeltaMax',
    '44743' => 'tcaEquipmentIocardStatsIomI2cerrorsDeltaAvg',
    '44748' => 'tcaEquipmentPsuStatsPsuI2cerrors',
    '44750' => 'tcaEquipmentPsuStatsPsuI2cerrorsDelta',
    '44751' => 'tcaEquipmentPsuStatsPsuI2cerrorsDeltaMin',
    '44752' => 'tcaEquipmentPsuStatsPsuI2cerrorsDeltaMax',
    '44753' => 'tcaEquipmentPsuStatsPsuI2cerrorsDeltaAvg',
    '44760' => 'tcaEquipmentFanStatsFanI2cerrorsDelta',
    '44761' => 'tcaEquipmentFanStatsFanI2cerrorsDeltaMin',
    '44762' => 'tcaEquipmentFanStatsFanI2cerrorsDeltaMax',
    '44763' => 'tcaEquipmentFanStatsFanI2cerrorsDeltaAvg',
    '45019' => 'tcaSwEnvStatsDonner',
    '45021' => 'tcaSwEnvStatsDonnerMin',
    '45022' => 'tcaSwEnvStatsDonnerMax',
    '45023' => 'tcaSwEnvStatsDonnerAvg',
    '45027' => 'tcaSwEnvStatsTd2',
    '45029' => 'tcaSwEnvStatsTd2Min',
    '45030' => 'tcaSwEnvStatsTd2Max',
    '45031' => 'tcaSwEnvStatsTd2Avg',
    '45035' => 'tcaSwEnvStatsTiburon',
    '45037' => 'tcaSwEnvStatsTiburonMin',
    '45038' => 'tcaSwEnvStatsTiburonMax',
    '45039' => 'tcaSwEnvStatsTiburonAvg',
    '45043' => 'tcaSwSystemStatsKernelMemTotal',
    '45045' => 'tcaSwSystemStatsKernelMemTotalMin',
    '45046' => 'tcaSwSystemStatsKernelMemTotalMax',
    '45047' => 'tcaSwSystemStatsKernelMemTotalAvg',
    '45051' => 'tcaSwSystemStatsKernelMemFree',
    '45053' => 'tcaSwSystemStatsKernelMemFreeMin',
    '45054' => 'tcaSwSystemStatsKernelMemFreeMax',
    '45055' => 'tcaSwSystemStatsKernelMemFreeAvg',
    '45154' => 'tcaEquipmentFexSystemStatsMemAvailable',
    '45156' => 'tcaEquipmentFexSystemStatsMemAvailableMin',
    '45157' => 'tcaEquipmentFexSystemStatsMemAvailableMax',
    '45158' => 'tcaEquipmentFexSystemStatsMemAvailableAvg',
    '45162' => 'tcaEquipmentFexSystemStatsMemCached',
    '45164' => 'tcaEquipmentFexSystemStatsMemCachedMin',
    '45165' => 'tcaEquipmentFexSystemStatsMemCachedMax',
    '45166' => 'tcaEquipmentFexSystemStatsMemCachedAvg',
    '45170' => 'tcaEquipmentFexSystemStatsLoad',
    '45172' => 'tcaEquipmentFexSystemStatsLoadMin',
    '45173' => 'tcaEquipmentFexSystemStatsLoadMax',
    '45174' => 'tcaEquipmentFexSystemStatsLoadAvg',
    '45178' => 'tcaEquipmentFexSystemStatsKernelMemTotal',
    '45180' => 'tcaEquipmentFexSystemStatsKernelMemTotalMin',
    '45181' => 'tcaEquipmentFexSystemStatsKernelMemTotalMax',
    '45182' => 'tcaEquipmentFexSystemStatsKernelMemTotalAvg',
    '45186' => 'tcaEquipmentFexSystemStatsKernelMemFree',
    '45188' => 'tcaEquipmentFexSystemStatsKernelMemFreeMin',
    '45189' => 'tcaEquipmentFexSystemStatsKernelMemFreeMax',
    '45190' => 'tcaEquipmentFexSystemStatsKernelMemFreeAvg',
    '45211' => 'tcaSwSystemStatsCorrectableParityError',
    '45213' => 'tcaSwSystemStatsCorrectableParityErrorMin',
    '45214' => 'tcaSwSystemStatsCorrectableParityErrorMax',
    '45215' => 'tcaSwSystemStatsCorrectableParityErrorAvg',
    '45266' => 'tcaEquipmentChassisStatsChassisI2cerrorsMin',
    '45267' => 'tcaEquipmentChassisStatsChassisI2cerrorsMax',
    '45268' => 'tcaEquipmentChassisStatsChassisI2cerrorsAvg',
    '45272' => 'tcaEquipmentIocardStatsIomI2cerrorsMin',
    '45273' => 'tcaEquipmentIocardStatsIomI2cerrorsMax',
    '45274' => 'tcaEquipmentIocardStatsIomI2cerrorsAvg',
    '45278' => 'tcaEquipmentPsuStatsPsuI2cerrorsMin',
    '45279' => 'tcaEquipmentPsuStatsPsuI2cerrorsMax',
    '45280' => 'tcaEquipmentPsuStatsPsuI2cerrorsAvg',
    '45284' => 'tcaEquipmentFanModuleStatsFanModuleI2cerrors',
    '45286' => 'tcaEquipmentFanModuleStatsFanModuleI2cerrorsMin',
    '45287' => 'tcaEquipmentFanModuleStatsFanModuleI2cerrorsMax',
    '45288' => 'tcaEquipmentFanModuleStatsFanModuleI2cerrorsAvg',
    '45647' => 'tcaStorageNvmeStatsTemperature',
    '45649' => 'tcaStorageNvmeStatsTemperatureMin',
    '45650' => 'tcaStorageNvmeStatsTemperatureMax',
    '45651' => 'tcaStorageNvmeStatsTemperatureAvg',
    '45655' => 'tcaStorageNvmeStatsDriveLifeUsedPercentage',
    '45657' => 'tcaStorageNvmeStatsDriveLifeUsedPercentageMin',
    '45658' => 'tcaStorageNvmeStatsDriveLifeUsedPercentageMax',
    '45659' => 'tcaStorageNvmeStatsDriveLifeUsedPercentageAvg',
    '46020' => 'tcaStorageSsdHealthStatsPowerOnHours',
    '46022' => 'tcaStorageSsdHealthStatsPowerOnHoursMin',
    '46023' => 'tcaStorageSsdHealthStatsPowerOnHoursMax',
    '46024' => 'tcaStorageSsdHealthStatsPowerOnHoursAvg',
    '46028' => 'tcaStorageSsdHealthStatsWearStatusInDays',
    '46030' => 'tcaStorageSsdHealthStatsWearStatusInDaysMin',
    '46031' => 'tcaStorageSsdHealthStatsWearStatusInDaysMax',
    '46032' => 'tcaStorageSsdHealthStatsWearStatusInDaysAvg',
    '46036' => 'tcaStorageSsdHealthStatsPowerCycleCount',
    '46038' => 'tcaStorageSsdHealthStatsPowerCycleCountMin',
    '46039' => 'tcaStorageSsdHealthStatsPowerCycleCountMax',
    '46040' => 'tcaStorageSsdHealthStatsPowerCycleCountAvg',
    '46044' => 'tcaStorageSsdHealthStatsPercentageLifeLeft',
    '46046' => 'tcaStorageSsdHealthStatsPercentageLifeLeftMin',
    '46047' => 'tcaStorageSsdHealthStatsPercentageLifeLeftMax',
    '46048' => 'tcaStorageSsdHealthStatsPercentageLifeLeftAvg',
    '77832' => 'fsmSamDmeSysdebugLogControlEpPersistenceRemoteInv',
    '77834' => 'fsmSamDmeMgmtRegistryInfoConfigureRemoteInv',
    '77835' => 'fsmSamDmeOrgOrgConfigureRemoteInv',
    '77840' => 'fsmSamDmeTopSystemHostNameRemoteInv',
    '77845' => 'fsmSamDmeEquipmentiocardFePresenceRemoteInv',
    '77846' => 'fsmSamDmeEquipmentiocardFeConnRemoteInv',
    '77847' => 'fsmSamDmeEquipmentChassisRemoveChassisRemoteInv',
    '77848' => 'fsmSetLocatorLedRemoteInv',
    '77855' => 'fsmSamDmeMgmtDataExporterExportDataRemoteInv',
    '77856' => 'fsmSamDmeMgmtDataImporterImportDataRemoteInv',
    '77864' => 'fsmUpdateElementRemoteInv',
    '77881' => 'fsmSamDmeTestingServiceProfileResolvePolicyFsmRemoteInv',
    '77882' => 'fsmSamDmeTestingServiceProfileResolveManyPolicyFsmRemoteInv',
    '77944' => 'fsmSamDmeCertRepairEpRepairCertRemoteInv',
    '77951' => 'fsmResolveResourceFsmRemoteInv',
    '77952' => 'fsmResolvevmfsmRemoteInv',
    '77953' => 'fsmResolveControllerFsmRemoteInv',
    '77958' => 'fsmSamDmeMgmtControllerExtMgmtIfConfigRemoteInv',
    '77959' => 'fsmSamDmeFabricComputeSlotEpIdentifyRemoteInv',
    '77960' => 'fsmSamDmeComputeBladeDiscoverRemoteInv',
    '77972' => 'fsmReleasePolicyFsmRemoteInv',
    '77973' => 'fsmSamDmeEquipmentChassisPsuPolicyConfigRemoteInv',
    '77974' => 'fsmSamDmeAdaptorHostFcIfResetFcPersBindingRemoteInv',
    '77975' => 'fsmSamDmeComputeBladeDiagRemoteInv',
    '77976' => 'fsmResolveManyOperationFsmRemoteInv',
    '77977' => 'fsmResolveManyStorageFsmRemoteInv',
    '77978' => 'fsmReleaseManyPolicyFsmRemoteInv',
    '77979' => 'fsmSwitchModeRemoteInv',
    '77980' => 'fsmReleaseManyStorageFsmRemoteInv',
    '77981' => 'fsmResolveAllPolicyFsmRemoteInv',
    '77982' => 'fsmResolveAllOperationFsmRemoteInv',
    '77983' => 'fsmResolveAllStorageFsmRemoteInv',
    '77984' => 'fsmReleaseAllPolicyFsmRemoteInv',
    '77985' => 'fsmReleaseAllOperationFsmRemoteInv',
    '77986' => 'fsmReleaseAllStorageFsmRemoteInv',
    '77990' => 'fsmSamDmeVnicProfileSetDeployRemoteInv',
    '78016' => 'fsmUpdateSvcEpRemoteInv',
    '78017' => 'fsmSamDmeCommSvcEpRestartWebSvcRemoteInv',
    '78019' => 'fsmUpdateEpRemoteInv',
    '78020' => 'fsmUpdateRealmRemoteInv',
    '78021' => 'fsmUpdateUserEpRemoteInv',
    '78022' => 'fsmSamDmePkiEpUpdateEpRemoteInv',
    '78040' => 'fsmSingleRemoteInv',
    '78041' => 'fsmSamDmeSysfileMutationGlobalRemoteInv',
    '78042' => 'fsmSamDmeConfigBackupDeleteRemoteInv',
    '78044' => 'fsmSamDmeSysdebugManualCoreFileExportTargetExportRemoteInv',
    '78045' => 'fsmSamDmeSysdebugAutoCoreFileExportTargetConfigureRemoteInv',
    '78046' => 'fsmSamDmeSysdebugLogControlEpLogControlPersistRemoteInv',
    '78047' => 'fsmSamDmeConsumerInstRenameCfgDirRemoteInv',
    '78048' => 'fsmSamDmeNfsClientDefAddConfigRemoteInv',
    '78049' => 'fsmSamDmeNfsClientDefDeleteConfigRemoteInv',
    '78074' => 'fsmSamDmeSwAccessDomainDeployRemoteInv',
    '78075' => 'fsmSamDmeSwEthLanBorderDeployRemoteInv',
    '78076' => 'fsmSamDmeSwFcSanBorderDeployRemoteInv',
    '78077' => 'fsmSamDmeSwUtilityDomainDeployRemoteInv',
    '78079' => 'fsmSamDmeComputeSystemRegisterRemoteInv',
    '78081' => 'fsmSamDmeSyntheticFsObjCreateRemoteInv',
    '78083' => 'fsmUpdateContextFsmRemoteInv',
    '78090' => 'fsmSamDmeFirmwareDownloaderDownloadRemoteInv',
    '78091' => 'fsmSamDmeFirmwareImageDeleteRemoteInv',
    '78093' => 'fsmUpdateSwitchRemoteInv',
    '78094' => 'fsmUpdateiomRemoteInv',
    '78095' => 'fsmSamDmeMgmtControllerActivateiomRemoteInv',
    '78096' => 'fsmUpdatebmcRemoteInv',
    '78097' => 'fsmSamDmeMgmtControllerActivatebmcRemoteInv',
    '78110' => 'fsmSamDmeCallhomeEpConfigCallhomeRemoteInv',
    '78113' => 'fsmSwMgmtOobIfConfigRemoteInv',
    '78114' => 'fsmSwMgmtInbandIfConfigRemoteInv',
    '78119' => 'fsmVirtualIfConfigRemoteInv',
    '78120' => 'fsmSamDmeMgmtIfEnableVipRemoteInv',
    '78121' => 'fsmSamDmeMgmtIfDisableVipRemoteInv',
    '78122' => 'fsmSamDmeMgmtIfEnablehaRemoteInv',
    '78123' => 'fsmSamDmeMgmtBackupBackupRemoteInv',
    '78124' => 'fsmSamDmeMgmtImporterImportRemoteInv',
    '78168' => 'fsmSamDmeOrgOrgConfigurePeerRemoteInv',
    '78169' => 'fsmSamDmeTopSystemPeerHostNameRemoteInv',
    '78182' => 'fsmSamDmeStatsCollectionPolicyUpdateEpRemoteInv',
    '78185' => 'fsmSamDmeQosclassDefinitionConfigGlobalQoSremoteInv',
    '78189' => 'fsmSamDmeEpqosDefinitionDeployRemoteInv',
    '78190' => 'fsmSamDmeEpqosDefinitionDelTaskRemoveRemoteInv',
    '78204' => 'fsmSamDmeControllerEpQuiesceRemoteInv',
    '78209' => 'fsmSamDmeConfigConsumerCatalogueCreateRemoteInv',
    '78210' => 'fsmSamDmeNfsExportDefImageSyncRemoteInv',
    '78211' => 'fsmSamDmeNfsExportDefAddRepoRemoteInv',
    '78233' => 'fsmUpdateIdentRemoteInv',
    '78234' => 'fsmSyncRemoteInv',
    '78240' => 'fsmSyncVnetEpucsRemoteInv',
    '78243' => 'fsmSamDmeEquipmentiocardResetCmcRemoteInv',
    '78248' => 'fsmSyncChangeucsRemoteInv',
    '78255' => 'fsmUpdateucsmanagerRemoteInv',
    '78263' => 'fsmSysConfigRemoteInv',
    '78292' => 'fsmSamDmeAdaptorExtEthIfPathResetRemoteInv',
    '78297' => 'fsmSamDmeAdaptorHostEthIfCircuitResetRemoteInv',
    '78298' => 'fsmSamDmeAdaptorHostFcIfCircuitResetRemoteInv',
    '78319' => 'fsmSamDmeExtvmmProviderConfigRemoteInv',
    '78320' => 'fsmSamDmeExtvmmKeyStoreCertInstallRemoteInv',
    '78321' => 'fsmSamDmeExtvmmSwitchDelTaskRemoveProviderRemoteInv',
    '78338' => 'fsmSamDmeExtvmmMasterExtKeyConfigRemoteInv',
    '78344' => 'fsmUpdaterRemoteInv',
    '78346' => 'fsmSamDmeFirmwareDistributableDeleteRemoteInv',
    '78360' => 'fsmDiscoverRemoteInv',
    '78361' => 'fsmAssociateRemoteInv',
    '78362' => 'fsmDisassociateRemoteInv',
    '78364' => 'fsmDecommissionRemoteInv',
    '78365' => 'fsmSoftShutdownRemoteInv',
    '78366' => 'fsmHardShutdownRemoteInv',
    '78367' => 'fsmTurnupRemoteInv',
    '78368' => 'fsmPowercycleRemoteInv',
    '78369' => 'fsmHardresetRemoteInv',
    '78370' => 'fsmSoftresetRemoteInv',
    '78371' => 'fsmSwConnUpdRemoteInv',
    '78372' => 'fsmBiosRecoveryRemoteInv',
    '78374' => 'fsmCmosResetRemoteInv',
    '78375' => 'fsmResetBmcRemoteInv',
    '78378' => 'fsmUpdateExtUsersRemoteInv',
    '78379' => 'fsmUpdateAdaptorRemoteInv',
    '78380' => 'fsmActivateAdaptorRemoteInv',
    '78381' => 'fsmConfigSoLremoteInv',
    '78382' => 'fsmUnconfigSoLremoteInv',
    '78383' => 'fsmSetFeLocatorLedRemoteInv',
    '78384' => 'fsmSamDmeEquipmentChassisPowerCapRemoteInv',
    '78385' => 'fsmSamDmeEquipmentiocardMuxOfflineRemoteInv',
    '78390' => 'fsmPowerCapRemoteInv',
    '78404' => 'fsmUpdateBoardControllerRemoteInv',
    '78405' => 'fsmDeployCatalogueRemoteInv',
    '78413' => 'fsmSamDmeComputePhysicalAssociateRemoteInv',
    '78414' => 'fsmSamDmeComputePhysicalDisassociateRemoteInv',
    '78415' => 'fsmSamDmeComputePhysicalPowerCapRemoteInv',
    '78416' => 'fsmSamDmeComputePhysicalDecommissionRemoteInv',
    '78417' => 'fsmSamDmeComputePhysicalSoftShutdownRemoteInv',
    '78418' => 'fsmSamDmeComputePhysicalHardShutdownRemoteInv',
    '78419' => 'fsmSamDmeComputePhysicalTurnupRemoteInv',
    '78420' => 'fsmSamDmeComputePhysicalPowercycleRemoteInv',
    '78421' => 'fsmSamDmeComputePhysicalHardresetRemoteInv',
    '78422' => 'fsmSamDmeComputePhysicalSoftresetRemoteInv',
    '78423' => 'fsmSamDmeComputePhysicalSwConnUpdRemoteInv',
    '78424' => 'fsmSamDmeComputePhysicalBiosRecoveryRemoteInv',
    '78426' => 'fsmSamDmeComputePhysicalCmosResetRemoteInv',
    '78427' => 'fsmSamDmeComputePhysicalResetBmcRemoteInv',
    '78428' => 'fsmSamDmeEquipmentiocardResetIomRemoteInv',
    '78431' => 'fsmInstallRemoteInv',
    '78432' => 'fsmClearRemoteInv',
    '78433' => 'fsmUpdateFlexlmRemoteInv',
    '78434' => 'fsmSamDmeComputeRackUnitDiscoverRemoteInv',
    '78435' => 'fsmSamDmeLsServerConfigureRemoteInv',
    '78440' => 'fsmSamDmeSwEthMonDeployRemoteInv',
    '78441' => 'fsmSamDmeSwFcMonDeployRemoteInv',
    '78442' => 'fsmSamDmeFabricSanCloudSwitchModeRemoteInv',
    '78447' => 'fsmRemoveFexRemoteInv',
    '78448' => 'fsmSamDmeComputePhysicalUpdateExtUsersRemoteInv',
    '78452' => 'fsmSamDmeSysdebugTechSupportInitiateRemoteInv',
    '78453' => 'fsmSamDmeSysdebugTechSupportDeleteTechSupFileRemoteInv',
    '78454' => 'fsmSamDmeSysdebugTechSupportDownloadRemoteInv',
    '78457' => 'fsmActivateCatalogRemoteInv',
    '78458' => 'fsmActivateMgmtExtRemoteInv',
    '78472' => 'fsmSamDmeDupeChangeTrackerEpConfigureRemoteInv',
    '78475' => 'fsmTriggerRemoteInv',
    '78483' => 'fsmSamDmeComputePhysicalUpdateAdaptorRemoteInv',
    '78484' => 'fsmSamDmeComputePhysicalActivateAdaptorRemoteInv',
    '78485' => 'fsmSamDmeCapabilityCatalogueActivateCatalogRemoteInv',
    '78486' => 'fsmSamDmeCapabilityMgmtExtensionActivateMgmtExtRemoteInv',
    '78490' => 'fsmSamDmeLicenseDownloaderDownloadRemoteInv',
    '78491' => 'fsmSamDmeLicenseFileInstallRemoteInv',
    '78492' => 'fsmSamDmeLicenseFileClearRemoteInv',
    '78493' => 'fsmSamDmeLicenseInstanceUpdateFlexlmRemoteInv',
    '78500' => 'fsmConfigureRemoteInv',
    '78501' => 'fsmMuxOfflineRemoteInv',
    '78523' => 'fsmSamDmeComputePhysicalConfigSoLremoteInv',
    '78524' => 'fsmSamDmeComputePhysicalUnconfigSoLremoteInv',
    '78529' => 'fsmSamDmePortpioInCompatSfpPresenceRemoteInv',
    '78556' => 'fsmSamDmeComputePhysicalDiagnosticInterruptRemoteInv',
    '78573' => 'fsmSamDmeSysdebugCoreDownloadRemoteInv',
    '78574' => 'fsmSamDmeEquipmentChassisDynamicReallocationRemoteInv',
    '78591' => 'fsmSamDmeCallhomeHolderConfigureRemoteInv',
    '78592' => 'fsmSamDmeCallhomeHolderInventoryRemoteInv',
    '78603' => 'fsmSamDmeComputePhysicalResetKvmRemoteInv',
    '78604' => 'fsmSamDmeSmartlicenseAgentConfigureRemoteInv',
    '78605' => 'fsmSamDmeSmartlicenseTestConfigureRemoteInv',
    '78606' => 'fsmSamDmeSmartlicenseEntitlementEpConfigureRemoteInv',
    '78607' => 'fsmSamDmeSmartlicenseHolderConfigureRemoteInv',
    '78609' => 'fsmSamDmeMgmtControllerOnlineRemoteInv',
    '78610' => 'fsmSamDmeComputeRackUnitOfflineRemoteInv',
    '78627' => 'fsmSamDmeEquipmentLocatorLedSetFiLocatorLedRemoteInv',
    '78630' => 'fsmConfPhysicalRemoteInv',
    '78632' => 'fsmClusterRoleRemoteInv',
    '78635' => 'fsmIlluminateRemoteInv',
    '78636' => 'fsmSetFiLocatorLedRemoteInv',
    '78647' => 'fsmDeployAliasRemoteInv',
    '78654' => 'fsmSamDmeFabricEpMgrConfigureRemoteInv',
    '78663' => 'fsmSamDmeVnicProfileSetDeployAliasRemoteInv',
    '78679' => 'fsmSamDmeSwPhysConfPhysicalRemoteInv',
    '78694' => 'fsmSamDmeExtvmmEpClusterRoleRemoteInv',
    '78699' => 'fsmSamDmeVmLifeCyclePolicyConfigRemoteInv',
    '78701' => 'fsmUpdateStateRemoteInv',
    '78702' => 'fsmSamDmeEquipmentBeaconLedIlluminateRemoteInv',
    '78711' => 'fsmSamDmeEtherServerIntfioConfigSpeedRemoteInv',
    '78721' => 'fsmUpdatebiosRemoteInv',
    '78722' => 'fsmSamDmeComputePhysicalActivatebiosRemoteInv',
    '78752' => 'fsmSamDmeCommDateTimeTimezoneRemoteInv',
    '78765' => 'fsmSamDmeFirmwareSystemDeployRemoteInv',
    '78766' => 'fsmSamDmeFirmwareSystemApplyCatalogPackRemoteInv',
    '78779' => 'fsmSamDmeMgmtExportPolicyReportConfigCopyRemoteInv',
    '78780' => 'fsmSamDmeMgmtImporterReportConfigImportRemoteInv',
    '78788' => 'fsmSamDmeNfsMountInstMountRemoteInv',
    '78789' => 'fsmSamDmeNfsMountInstUnmountRemoteInv',
    '78790' => 'fsmSamDmeNfsMountDefReportNfsMountSuspendRemoteInv',
    '78807' => 'fsmSamDmeStorageSystemSyncRemoteInv',
    '78811' => 'fsmSamDmePolicyControlEpOpRemoteDomainRegRemoteInv',
    '78812' => 'fsmSamDmePolicyControlEpOpRemoteDomainUnRegRemoteInv',
    '78813' => 'fsmSamDmeEquipmentChassisProfileConfigureRemoteInv',
    '78821' => 'fsmSamDmeSwFcSanBorderActivateZoneSetRemoteInv',
    '78822' => 'fsmSamDmeExtpolEpRegisterFsmRemoteInv',
    '78823' => 'fsmSamDmeExtpolRegistryCrossDomainConfigRemoteInv',
    '78824' => 'fsmSamDmeExtpolRegistryCrossDomainDeleteRemoteInv',
    '78839' => 'fsmSamDmeExtpolEpRepairCertRemoteInv',
    '78840' => 'fsmSamDmePolicyControlEpOperateRemoteInv',
    '78842' => 'fsmSamDmePolicyPolicyScopeReleasePolicyFsmRemoteInv',
    '78843' => 'fsmSamDmePolicyPolicyScopeReleaseOperationFsmRemoteInv',
    '78844' => 'fsmSamDmePolicyPolicyScopeReleaseStorageFsmRemoteInv',
    '78845' => 'fsmSamDmePolicyPolicyScopeResolveManyPolicyFsmRemoteInv',
    '78846' => 'fsmSamDmePolicyPolicyScopeResolveManyOperationFsmRemoteInv',
    '78847' => 'fsmSamDmePolicyPolicyScopeResolveManyStorageFsmRemoteInv',
    '78848' => 'fsmSamDmePolicyPolicyScopeReleaseManyPolicyFsmRemoteInv',
    '78849' => 'fsmSamDmePolicyPolicyScopeReleaseManyOperationFsmRemoteInv',
    '78850' => 'fsmSamDmePolicyPolicyScopeReleaseManyStorageFsmRemoteInv',
    '78851' => 'fsmSamDmePolicyPolicyScopeResolveAllPolicyFsmRemoteInv',
    '78852' => 'fsmSamDmePolicyPolicyScopeResolveAllOperationFsmRemoteInv',
    '78853' => 'fsmSamDmePolicyPolicyScopeResolveAllStorageFsmRemoteInv',
    '78854' => 'fsmSamDmePolicyPolicyScopeReleaseAllPolicyFsmRemoteInv',
    '78855' => 'fsmSamDmePolicyPolicyScopeReleaseAllOperationFsmRemoteInv',
    '78856' => 'fsmSamDmePolicyPolicyScopeReleaseAllStorageFsmRemoteInv',
    '78858' => 'fsmSamDmeIdentIdentRequestUpdateIdentRemoteInv',
    '78859' => 'fsmSamDmeIdentMetaSystemSyncRemoteInv',
    '78860' => 'fsmSamDmeMgmtControllerRegistryConfigRemoteInv',
    '78861' => 'fsmSamDmeGlRequestEvaluateRemoteInv',
    '78862' => 'fsmSamDmeGlRequestCreateGlobalIdPoolRemoteInv',
    '78863' => 'fsmSamDmeGlRequestCreateGlobalPolicyRemoteInv',
    '78864' => 'fsmSamDmeGlRequestGlobalizeRemoteInv',
    '78865' => 'fsmSamDmeObserveObservedResolvePolicyFsmRemoteInv',
    '78866' => 'fsmSamDmeObserveObservedResolveResourceFsmRemoteInv',
    '78867' => 'fsmSamDmeObserveObservedResolvevmfsmRemoteInv',
    '78868' => 'fsmSamDmeObserveObservedResolveControllerFsmRemoteInv',
    '78884' => 'fsmSamDmeDiagSrvCtrlOperationConfigureRemoteInv',
    '78885' => 'fsmSamDmePortpioInCompatSfpReplacedRemoteInv',
    '78891' => 'fsmSamDmeFdPhysicalConfigureRemoteInv',
    '78913' => 'fsmSamDmeVnicOutbandMgmtEpConfigureOutbandRemoteInv',
    '78914' => 'fsmSamDmeDomainProfileConfigureRemoteInv',
    '78916' => 'fsmSamDmeComputePhysicalResetIpmiRemoteInv',
    '78917' => 'fsmSamDmeComputePhysicalFwUpgradeRemoteInv',
    '78918' => 'fsmSamDmeComputeRackUnitAdapterResetRemoteInv',
    '78919' => 'fsmSamDmeFabricFcZoneProfileConfigureRemoteInv',
    '78923' => 'fsmSamDmeComputeServerDiscPolicyResolveScrubPolicyRemoteInv',
    '78925' => 'fsmSamDmeExtpolProviderReportConfigImportRemoteInv',
    '79039' => 'fsmSamDmeFabricVnetEpSyncEpPushVnetEpDeletionRemoteInv',
    '79041' => 'fsmSamDmeGmetaHolderInventoryRemoteInv',
    '79042' => 'fsmSamDmeComputePhysicalCimcSessionDeleteRemoteInv',
    '79052' => 'fsmSamDmePolicyControlledTypeOperateRemoteInv',
    '79100' => 'fsmSamDmeMgmtControllerExtMgmtInterfaceConfigRemoteInv',
    '79101' => 'fsmSamDmeComputeRackUnitCreateDhcpEntryRemoteInv',
    '79102' => 'fsmSamDmeComputePhysicalServiceInfraDeployRemoteInv',
    '79103' => 'fsmSamDmeComputePhysicalServiceInfraWithdrawRemoteInv',
    '79107' => 'fsmSamDmeComputePhysicalUpdateBoardControllerRemoteInv',
    '79142' => 'fsmSamDmeComputePhysicalConfigBoardRemoteInv',
    '79143' => 'fsmSamDmeComputePhysicalResetMemoryErrorsRemoteInv',
    '79147' => 'fsmSamDmeMgmtipv6IfAddrSwMgmtOobIpv6IfConfigRemoteInv',
    '79153' => 'fsmSamDmeSwEthLanFlowMonDeployRemoteInv',
    '79173' => 'fsmSamDmeExtvmmNetworkSetsDeployRemoteInv',
    '79202' => 'fsmSamDmeComputePhysicalFlashControllerRemoteInv',
    '79228' => 'fsmSamDmeSysdebugLogExportPolicyConfigureRemoteInv',
    '79231' => 'fsmSamDmeStorageFlexFlashControllermopsResetRemoteInv',
    '79232' => 'fsmSamDmeStorageFlexFlashControllermopsFormatRemoteInv',
    '79233' => 'fsmSamDmeStorageFlexFlashControllermopsPairRemoteInv',
    '79246' => 'fsmSamDmeComputePhysicalEnableCimcSecureBootRemoteInv',
    '79264' => 'fsmSamDmeIdentMetaSystemUcscUnivSyncRemoteInv',
    '79361' => 'fsmSamDmeStoragePartitionDeployStorageRemoteInv',
    '79362' => 'fsmSamDmeStorageProcessorDiscoverSystemRemoteInv',
    '79363' => 'fsmSamDmeStorageProcessorEnterMaintenanceRemoteInv',
    '79364' => 'fsmSamDmeStorageProcessorExitMaintenanceRemoteInv',
    '79365' => 'fsmSamDmeStorageProcessorDeploySystemRemoteInv',
    '79366' => 'fsmSamDmeStorageProcessorUndeploySystemRemoteInv',
    '79367' => 'fsmSamDmeStorageProcessorHaTakeOverRemoteInv',
    '79368' => 'fsmSamDmeStoragePartitionScrubraidgroupRemoteInv',
    '79373' => 'fsmSamDmeMgmtControllerLockConfigRemoteInv',
    '79374' => 'fsmSamDmeMgmtControllerPowerBudgetReclaimConfigRemoteInv',
    '79375' => 'fsmSamDmeComputePhysicalOobStorageAdminConfigRemoteInv',
    '79380' => 'fsmSamDmeEquipmentiocardBaseFePresenceRemoteInv',
    '79381' => 'fsmSamDmeEquipmentiocardBaseFeConnRemoteInv',
    '79394' => 'fsmSamDmeEquipmentLocatorLedSetDiskLocatorLedRemoteInv',
    '79418' => 'fsmSamDmeLstorageProcessorConfigureRemoteInv',
    '79424' => 'fsmSamDmeOsControllerDeployosRemoteInv',
    '79427' => 'fsmSamDmeEquipmentPsuUpdatepsuRemoteInv',
    '79452' => 'fsmSamDmeMgmtControllerUpdatecmcRemoteInv',
    '79453' => 'fsmSamDmeMgmtControllerActivatecmcRemoteInv',
    '79454' => 'fsmSamDmeMgmtControllerUpdateAdaptorRemoteInv',
    '79455' => 'fsmSamDmeMgmtControllerActivateAdaptorRemoteInv',
    '79456' => 'fsmSamDmeMgmtControllerUpdateRaidControllerRemoteInv',
    '79457' => 'fsmSamDmeMgmtControllerUpdateBoardControllerRemoteInv',
    '79464' => 'fsmSamDmeFabricCartridgeSlotEpIdentifyRemoteInv',
    '79465' => 'fsmSamDmeFabricComputemslotEpIdentifyRemoteInv',
    '79466' => 'fsmSamDmeEquipmentChassisOobStorageAdminCfgRemoteInv',
    '79472' => 'fsmSamDmeComputeServerUnitDiscoverRemoteInv',
    '79473' => 'fsmSamDmeMgmtIfFaPresenceRemoteInv',
    '79474' => 'fsmSamDmeMgmtIfFaConnRemoteInv',
    '79485' => 'fsmSamDmeEquipmentiocardEvacuateRemoteInv',
    '79486' => 'fsmSamDmeEquipmentiocardResetEvacuateRemoteInv',
    '79491' => 'fsmSamDmeComputePhysicalCleartpmRemoteInv',
    '79542' => 'fsmSamDmeEquipmentiocardResetPeerCmcRemoteInv',
    '79564' => 'fsmSamDmeSwExtUtilityConfPortBreakoutRemoteInv',
    '79586' => 'fsmSamDmeEquipmentSwitchiocardEvacuateRemoteInv',
    '79587' => 'fsmSamDmeEquipmentSwitchiocardResetEvacuateRemoteInv',
    '79601' => 'fsmSamDmeMorefImportRootApplyMoRefsRemoteInv',
    '79609' => 'fsmSamDmeStorageEnclosureRemoveEnclosureRemoteInv',
    '79624' => 'fsmSamDmeMgmtControllerPowerCapRemoteInv',
    '79625' => 'fsmSamDmeEquipmentSystemiocontrollerResetCmcRemoteInv',
    '79626' => 'fsmSamDmeComputePhysicalDiskZoningInventoryRemoteInv',
    '79647' => 'fsmSamDmeEquipmentChassisAssociateRemoteInv',
    '79648' => 'fsmSamDmeEquipmentChassisDisassociateRemoteInv',
    '79677' => 'fsmSamDmeEtherServerIntfioConfigRemoteInv',
    '79679' => 'fsmSamDmeMgmtControllerEnableSecureBootRemoteInv',
    '79680' => 'fsmSamDmeMgmtControllerUpdateColusacmcRemoteInv',
    '79681' => 'fsmSamDmeMgmtControllerActivateColusacmcRemoteInv',
    '79682' => 'fsmSamDmeEquipmentChassisChassisUpgradeRemoteInv',
    '79683' => 'fsmSamDmeMgmtControllerUpdateColusaBoardControllerRemoteInv',
    '79684' => 'fsmSamDmeMgmtControllerUpdateSasExpanderRemoteInv',
    '79685' => 'fsmSamDmeMgmtControllerActivateSasExpanderRemoteInv',
    '79686' => 'fsmSamDmeMgmtControllerActivateLocalDiskRemoteInv',
    '79687' => 'fsmSamDmeStorageLocalDiskUpdateLocalDiskRemoteInv',
    '79699' => 'fsmSamDmeMgmtControllerUpdateucsmanagerspRemoteInv',
    '79700' => 'fsmSamDmeComputePhysicalDiagRemoteInv',
    '79701' => 'fsmSamDmeComputePhysicalCimcSecurityConfigRemoteInv',
    '79730' => 'fsmSamDmeSwPortDiscoverDeployRemoteInv',
    '79733' => 'fsmSamDmePolicyPolicyScopeContReportPolicyFailFsmRemoteInv',
    '79734' => 'fsmSamDmePolicyRequestorResolveFromCentralRemoteInv',
    '999432' => 'fsmSamDmeSysdebugLogControlEpPersistenceFsmFail',
    '999434' => 'fsmSamDmeMgmtRegistryInfoConfigureFsmFail',
    '999435' => 'fsmSamDmeOrgOrgConfigureFsmFail',
    '999440' => 'fsmSamDmeTopSystemHostNameFsmFail',
    '999445' => 'fsmSamDmeEquipmentiocardFePresenceFsmFail',
    '999446' => 'fsmSamDmeEquipmentiocardFeConnFsmFail',
    '999447' => 'fsmSamDmeEquipmentChassisRemoveChassisFsmFail',
    '999448' => 'fsmSetLocatorLedFsmFail',
    '999455' => 'fsmSamDmeMgmtDataExporterExportDataFsmFail',
    '999456' => 'fsmSamDmeMgmtDataImporterImportDataFsmFail',
    '999464' => 'fsmUpdateElementFsmFail',
    '999481' => 'fsmSamDmeTestingServiceProfileResolvePolicyFsmFsmFail',
    '999482' => 'fsmSamDmeTestingServiceProfileResolveManyPolicyFsmFsmFail',
    '999544' => 'fsmSamDmeCertRepairEpRepairCertFsmFail',
    '999551' => 'fsmResolveResourceFsmFsmFail',
    '999552' => 'fsmResolvevmfsmFsmFail',
    '999553' => 'fsmResolveControllerFsmFsmFail',
    '999558' => 'fsmSamDmeMgmtControllerExtMgmtIfConfigFsmFail',
    '999559' => 'fsmSamDmeFabricComputeSlotEpIdentifyFsmFail',
    '999560' => 'fsmSamDmeComputeBladeDiscoverFsmFail',
    '999572' => 'fsmReleasePolicyFsmFsmFail',
    '999573' => 'fsmSamDmeEquipmentChassisPsuPolicyConfigFsmFail',
    '999574' => 'fsmSamDmeAdaptorHostFcIfResetFcPersBindingFsmFail',
    '999575' => 'fsmSamDmeComputeBladeDiagFsmFail',
    '999576' => 'fsmResolveManyOperationFsmFsmFail',
    '999577' => 'fsmResolveManyStorageFsmFsmFail',
    '999578' => 'fsmReleaseManyPolicyFsmFsmFail',
    '999579' => 'fsmSwitchModeFsmFail',
    '999580' => 'fsmReleaseManyStorageFsmFsmFail',
    '999581' => 'fsmResolveAllPolicyFsmFsmFail',
    '999582' => 'fsmResolveAllOperationFsmFsmFail',
    '999583' => 'fsmResolveAllStorageFsmFsmFail',
    '999584' => 'fsmReleaseAllPolicyFsmFsmFail',
    '999585' => 'fsmReleaseAllOperationFsmFsmFail',
    '999586' => 'fsmReleaseAllStorageFsmFsmFail',
    '999590' => 'fsmSamDmeVnicProfileSetDeployFsmFail',
    '999616' => 'fsmUpdateSvcEpFsmFail',
    '999617' => 'fsmSamDmeCommSvcEpRestartWebSvcFsmFail',
    '999619' => 'fsmUpdateEpFsmFail',
    '999620' => 'fsmUpdateRealmFsmFail',
    '999621' => 'fsmUpdateUserEpFsmFail',
    '999622' => 'fsmSamDmePkiEpUpdateEpFsmFail',
    '999640' => 'fsmSingleFsmFail',
    '999641' => 'fsmSamDmeSysfileMutationGlobalFsmFail',
    '999642' => 'fsmSamDmeConfigBackupDeleteFsmFail',
    '999644' => 'fsmSamDmeSysdebugManualCoreFileExportTargetExportFsmFail',
    '999645' => 'fsmSamDmeSysdebugAutoCoreFileExportTargetConfigureFsmFail',
    '999646' => 'fsmSamDmeSysdebugLogControlEpLogControlPersistFsmFail',
    '999647' => 'fsmSamDmeConsumerInstRenameCfgDirFsmFail',
    '999648' => 'fsmSamDmeNfsClientDefAddConfigFsmFail',
    '999649' => 'fsmSamDmeNfsClientDefDeleteConfigFsmFail',
    '999674' => 'fsmSamDmeSwAccessDomainDeployFsmFail',
    '999675' => 'fsmSamDmeSwEthLanBorderDeployFsmFail',
    '999676' => 'fsmSamDmeSwFcSanBorderDeployFsmFail',
    '999677' => 'fsmSamDmeSwUtilityDomainDeployFsmFail',
    '999679' => 'fsmSamDmeComputeSystemRegisterFsmFail',
    '999681' => 'fsmSamDmeSyntheticFsObjCreateFsmFail',
    '999683' => 'fsmUpdateContextFsmFsmFail',
    '999690' => 'fsmSamDmeFirmwareDownloaderDownloadFsmFail',
    '999691' => 'fsmSamDmeFirmwareImageDeleteFsmFail',
    '999693' => 'fsmUpdateSwitchFsmFail',
    '999694' => 'fsmUpdateiomFsmFail',
    '999695' => 'fsmSamDmeMgmtControllerActivateiomFsmFail',
    '999696' => 'fsmUpdatebmcFsmFail',
    '999697' => 'fsmSamDmeMgmtControllerActivatebmcFsmFail',
    '999710' => 'fsmSamDmeCallhomeEpConfigCallhomeFsmFail',
    '999713' => 'fsmSwMgmtOobIfConfigFsmFail',
    '999714' => 'fsmSwMgmtInbandIfConfigFsmFail',
    '999719' => 'fsmVirtualIfConfigFsmFail',
    '999720' => 'fsmSamDmeMgmtIfEnableVipFsmFail',
    '999721' => 'fsmSamDmeMgmtIfDisableVipFsmFail',
    '999722' => 'fsmSamDmeMgmtIfEnablehaFsmFail',
    '999723' => 'fsmSamDmeMgmtBackupBackupFsmFail',
    '999724' => 'fsmSamDmeMgmtImporterImportFsmFail',
    '999768' => 'fsmSamDmeOrgOrgConfigurePeerFsmFail',
    '999769' => 'fsmSamDmeTopSystemPeerHostNameFsmFail',
    '999782' => 'fsmSamDmeStatsCollectionPolicyUpdateEpFsmFail',
    '999785' => 'fsmSamDmeQosclassDefinitionConfigGlobalQoSfsmFail',
    '999789' => 'fsmSamDmeEpqosDefinitionDeployFsmFail',
    '999790' => 'fsmSamDmeEpqosDefinitionDelTaskRemoveFsmFail',
    '999804' => 'fsmSamDmeControllerEpQuiesceFsmFail',
    '999809' => 'fsmSamDmeConfigConsumerCatalogueCreateFsmFail',
    '999810' => 'fsmSamDmeNfsExportDefImageSyncFsmFail',
    '999811' => 'fsmSamDmeNfsExportDefAddRepoFsmFail',
    '999833' => 'fsmUpdateIdentFsmFail',
    '999834' => 'fsmSyncFsmFail',
    '999840' => 'fsmSyncVnetEpucsFsmFail',
    '999843' => 'fsmSamDmeEquipmentiocardResetCmcFsmFail',
    '999848' => 'fsmSyncChangeucsFsmFail',
    '999855' => 'fsmUpdateucsmanagerFsmFail',
    '999863' => 'fsmSysConfigFsmFail',
    '999892' => 'fsmSamDmeAdaptorExtEthIfPathResetFsmFail',
    '999897' => 'fsmSamDmeAdaptorHostEthIfCircuitResetFsmFail',
    '999898' => 'fsmSamDmeAdaptorHostFcIfCircuitResetFsmFail',
    '999919' => 'fsmSamDmeExtvmmProviderConfigFsmFail',
    '999920' => 'fsmSamDmeExtvmmKeyStoreCertInstallFsmFail',
    '999921' => 'fsmSamDmeExtvmmSwitchDelTaskRemoveProviderFsmFail',
    '999938' => 'fsmSamDmeExtvmmMasterExtKeyConfigFsmFail',
    '999944' => 'fsmUpdaterFsmFail',
    '999946' => 'fsmSamDmeFirmwareDistributableDeleteFsmFail',
    '999960' => 'fsmDiscoverFsmFail',
    '999961' => 'fsmAssociateFsmFail',
    '999962' => 'fsmDisassociateFsmFail',
    '999964' => 'fsmDecommissionFsmFail',
    '999965' => 'fsmSoftShutdownFsmFail',
    '999966' => 'fsmHardShutdownFsmFail',
    '999967' => 'fsmTurnupFsmFail',
    '999968' => 'fsmPowercycleFsmFail',
    '999969' => 'fsmHardresetFsmFail',
    '999970' => 'fsmSoftresetFsmFail',
    '999971' => 'fsmSwConnUpdFsmFail',
    '999972' => 'fsmBiosRecoveryFsmFail',
    '999974' => 'fsmCmosResetFsmFail',
    '999975' => 'fsmResetBmcFsmFail',
    '999978' => 'fsmUpdateExtUsersFsmFail',
    '999979' => 'fsmUpdateAdaptorFsmFail',
    '999980' => 'fsmActivateAdaptorFsmFail',
    '999981' => 'fsmConfigSoLfsmFail',
    '999982' => 'fsmUnconfigSoLfsmFail',
    '999983' => 'fsmSetFeLocatorLedFsmFail',
    '999984' => 'fsmSamDmeEquipmentChassisPowerCapFsmFail',
    '999985' => 'fsmSamDmeEquipmentiocardMuxOfflineFsmFail',
    '999990' => 'fsmPowerCapFsmFail',
    '1000004' => 'fsmUpdateBoardControllerFsmFail',
    '1000005' => 'fsmDeployCatalogueFsmFail',
    '1000013' => 'fsmSamDmeComputePhysicalAssociateFsmFail',
    '1000014' => 'fsmSamDmeComputePhysicalDisassociateFsmFail',
    '1000015' => 'fsmSamDmeComputePhysicalPowerCapFsmFail',
    '1000016' => 'fsmSamDmeComputePhysicalDecommissionFsmFail',
    '1000017' => 'fsmSamDmeComputePhysicalSoftShutdownFsmFail',
    '1000018' => 'fsmSamDmeComputePhysicalHardShutdownFsmFail',
    '1000019' => 'fsmSamDmeComputePhysicalTurnupFsmFail',
    '1000020' => 'fsmSamDmeComputePhysicalPowercycleFsmFail',
    '1000021' => 'fsmSamDmeComputePhysicalHardresetFsmFail',
    '1000022' => 'fsmSamDmeComputePhysicalSoftresetFsmFail',
    '1000023' => 'fsmSamDmeComputePhysicalSwConnUpdFsmFail',
    '1000024' => 'fsmSamDmeComputePhysicalBiosRecoveryFsmFail',
    '1000026' => 'fsmSamDmeComputePhysicalCmosResetFsmFail',
    '1000027' => 'fsmSamDmeComputePhysicalResetBmcFsmFail',
    '1000028' => 'fsmSamDmeEquipmentiocardResetIomFsmFail',
    '1000031' => 'fsmInstallFsmFail',
    '1000032' => 'fsmClearFsmFail',
    '1000033' => 'fsmUpdateFlexlmFsmFail',
    '1000034' => 'fsmSamDmeComputeRackUnitDiscoverFsmFail',
    '1000035' => 'fsmSamDmeLsServerConfigureFsmFail',
    '1000040' => 'fsmSamDmeSwEthMonDeployFsmFail',
    '1000041' => 'fsmSamDmeSwFcMonDeployFsmFail',
    '1000042' => 'fsmSamDmeFabricSanCloudSwitchModeFsmFail',
    '1000047' => 'fsmRemoveFexFsmFail',
    '1000048' => 'fsmSamDmeComputePhysicalUpdateExtUsersFsmFail',
    '1000052' => 'fsmSamDmeSysdebugTechSupportInitiateFsmFail',
    '1000053' => 'fsmSamDmeSysdebugTechSupportDeleteTechSupFileFsmFail',
    '1000054' => 'fsmSamDmeSysdebugTechSupportDownloadFsmFail',
    '1000057' => 'fsmActivateCatalogFsmFail',
    '1000058' => 'fsmActivateMgmtExtFsmFail',
    '1000072' => 'fsmSamDmeDupeChangeTrackerEpConfigureFsmFail',
    '1000075' => 'fsmTriggerFsmFail',
    '1000083' => 'fsmSamDmeComputePhysicalUpdateAdaptorFsmFail',
    '1000084' => 'fsmSamDmeComputePhysicalActivateAdaptorFsmFail',
    '1000085' => 'fsmSamDmeCapabilityCatalogueActivateCatalogFsmFail',
    '1000086' => 'fsmSamDmeCapabilityMgmtExtensionActivateMgmtExtFsmFail',
    '1000090' => 'fsmSamDmeLicenseDownloaderDownloadFsmFail',
    '1000091' => 'fsmSamDmeLicenseFileInstallFsmFail',
    '1000092' => 'fsmSamDmeLicenseFileClearFsmFail',
    '1000093' => 'fsmSamDmeLicenseInstanceUpdateFlexlmFsmFail',
    '1000100' => 'fsmConfigureFsmFail',
    '1000101' => 'fsmMuxOfflineFsmFail',
    '1000123' => 'fsmSamDmeComputePhysicalConfigSoLfsmFail',
    '1000124' => 'fsmSamDmeComputePhysicalUnconfigSoLfsmFail',
    '1000129' => 'fsmSamDmePortpioInCompatSfpPresenceFsmFail',
    '1000156' => 'fsmSamDmeComputePhysicalDiagnosticInterruptFsmFail',
    '1000173' => 'fsmSamDmeSysdebugCoreDownloadFsmFail',
    '1000174' => 'fsmSamDmeEquipmentChassisDynamicReallocationFsmFail',
    '1000191' => 'fsmSamDmeCallhomeHolderConfigureFsmFail',
    '1000192' => 'fsmSamDmeCallhomeHolderInventoryFsmFail',
    '1000203' => 'fsmSamDmeComputePhysicalResetKvmFsmFail',
    '1000204' => 'fsmSamDmeSmartlicenseAgentConfigureFsmFail',
    '1000205' => 'fsmSamDmeSmartlicenseTestConfigureFsmFail',
    '1000206' => 'fsmSamDmeSmartlicenseEntitlementEpConfigureFsmFail',
    '1000207' => 'fsmSamDmeSmartlicenseHolderConfigureFsmFail',
    '1000209' => 'fsmSamDmeMgmtControllerOnlineFsmFail',
    '1000210' => 'fsmSamDmeComputeRackUnitOfflineFsmFail',
    '1000227' => 'fsmSamDmeEquipmentLocatorLedSetFiLocatorLedFsmFail',
    '1000230' => 'fsmConfPhysicalFsmFail',
    '1000232' => 'fsmClusterRoleFsmFail',
    '1000235' => 'fsmIlluminateFsmFail',
    '1000236' => 'fsmSetFiLocatorLedFsmFail',
    '1000247' => 'fsmDeployAliasFsmFail',
    '1000254' => 'fsmSamDmeFabricEpMgrConfigureFsmFail',
    '1000263' => 'fsmSamDmeVnicProfileSetDeployAliasFsmFail',
    '1000279' => 'fsmSamDmeSwPhysConfPhysicalFsmFail',
    '1000294' => 'fsmSamDmeExtvmmEpClusterRoleFsmFail',
    '1000299' => 'fsmSamDmeVmLifeCyclePolicyConfigFsmFail',
    '1000301' => 'fsmUpdateStateFsmFail',
    '1000302' => 'fsmSamDmeEquipmentBeaconLedIlluminateFsmFail',
    '1000311' => 'fsmSamDmeEtherServerIntfioConfigSpeedFsmFail',
    '1000321' => 'fsmUpdatebiosFsmFail',
    '1000322' => 'fsmSamDmeComputePhysicalActivatebiosFsmFail',
    '1000352' => 'fsmSamDmeCommDateTimeTimezoneFsmFail',
    '1000365' => 'fsmSamDmeFirmwareSystemDeployFsmFail',
    '1000366' => 'fsmSamDmeFirmwareSystemApplyCatalogPackFsmFail',
    '1000379' => 'fsmSamDmeMgmtExportPolicyReportConfigCopyFsmFail',
    '1000380' => 'fsmSamDmeMgmtImporterReportConfigImportFsmFail',
    '1000388' => 'fsmSamDmeNfsMountInstMountFsmFail',
    '1000389' => 'fsmSamDmeNfsMountInstUnmountFsmFail',
    '1000390' => 'fsmSamDmeNfsMountDefReportNfsMountSuspendFsmFail',
    '1000407' => 'fsmSamDmeStorageSystemSyncFsmFail',
    '1000411' => 'fsmSamDmePolicyControlEpOpRemoteDomainRegFsmFail',
    '1000412' => 'fsmSamDmePolicyControlEpOpRemoteDomainUnRegFsmFail',
    '1000413' => 'fsmSamDmeEquipmentChassisProfileConfigureFsmFail',
    '1000421' => 'fsmSamDmeSwFcSanBorderActivateZoneSetFsmFail',
    '1000422' => 'fsmSamDmeExtpolEpRegisterFsmFsmFail',
    '1000423' => 'fsmSamDmeExtpolRegistryCrossDomainConfigFsmFail',
    '1000424' => 'fsmSamDmeExtpolRegistryCrossDomainDeleteFsmFail',
    '1000439' => 'fsmSamDmeExtpolEpRepairCertFsmFail',
    '1000440' => 'fsmSamDmePolicyControlEpOperateFsmFail',
    '1000442' => 'fsmSamDmePolicyPolicyScopeReleasePolicyFsmFsmFail',
    '1000443' => 'fsmSamDmePolicyPolicyScopeReleaseOperationFsmFsmFail',
    '1000444' => 'fsmSamDmePolicyPolicyScopeReleaseStorageFsmFsmFail',
    '1000445' => 'fsmSamDmePolicyPolicyScopeResolveManyPolicyFsmFsmFail',
    '1000446' => 'fsmSamDmePolicyPolicyScopeResolveManyOperationFsmFsmFail',
    '1000447' => 'fsmSamDmePolicyPolicyScopeResolveManyStorageFsmFsmFail',
    '1000448' => 'fsmSamDmePolicyPolicyScopeReleaseManyPolicyFsmFsmFail',
    '1000449' => 'fsmSamDmePolicyPolicyScopeReleaseManyOperationFsmFsmFail',
    '1000450' => 'fsmSamDmePolicyPolicyScopeReleaseManyStorageFsmFsmFail',
    '1000451' => 'fsmSamDmePolicyPolicyScopeResolveAllPolicyFsmFsmFail',
    '1000452' => 'fsmSamDmePolicyPolicyScopeResolveAllOperationFsmFsmFail',
    '1000453' => 'fsmSamDmePolicyPolicyScopeResolveAllStorageFsmFsmFail',
    '1000454' => 'fsmSamDmePolicyPolicyScopeReleaseAllPolicyFsmFsmFail',
    '1000455' => 'fsmSamDmePolicyPolicyScopeReleaseAllOperationFsmFsmFail',
    '1000456' => 'fsmSamDmePolicyPolicyScopeReleaseAllStorageFsmFsmFail',
    '1000458' => 'fsmSamDmeIdentIdentRequestUpdateIdentFsmFail',
    '1000459' => 'fsmSamDmeIdentMetaSystemSyncFsmFail',
    '1000460' => 'fsmSamDmeMgmtControllerRegistryConfigFsmFail',
    '1000461' => 'fsmSamDmeGlRequestEvaluateFsmFail',
    '1000462' => 'fsmSamDmeGlRequestCreateGlobalIdPoolFsmFail',
    '1000463' => 'fsmSamDmeGlRequestCreateGlobalPolicyFsmFail',
    '1000464' => 'fsmSamDmeGlRequestGlobalizeFsmFail',
    '1000465' => 'fsmSamDmeObserveObservedResolvePolicyFsmFsmFail',
    '1000466' => 'fsmSamDmeObserveObservedResolveResourceFsmFsmFail',
    '1000467' => 'fsmSamDmeObserveObservedResolvevmfsmFsmFail',
    '1000468' => 'fsmSamDmeObserveObservedResolveControllerFsmFsmFail',
    '1000484' => 'fsmSamDmeDiagSrvCtrlOperationConfigureFsmFail',
    '1000485' => 'fsmSamDmePortpioInCompatSfpReplacedFsmFail',
    '1000491' => 'fsmSamDmeFdPhysicalConfigureFsmFail',
    '1000513' => 'fsmSamDmeVnicOutbandMgmtEpConfigureOutbandFsmFail',
    '1000514' => 'fsmSamDmeDomainProfileConfigureFsmFail',
    '1000516' => 'fsmSamDmeComputePhysicalResetIpmiFsmFail',
    '1000517' => 'fsmSamDmeComputePhysicalFwUpgradeFsmFail',
    '1000518' => 'fsmSamDmeComputeRackUnitAdapterResetFsmFail',
    '1000519' => 'fsmSamDmeFabricFcZoneProfileConfigureFsmFail',
    '1000523' => 'fsmSamDmeComputeServerDiscPolicyResolveScrubPolicyFsmFail',
    '1000525' => 'fsmSamDmeExtpolProviderReportConfigImportFsmFail',
    '1000639' => 'fsmSamDmeFabricVnetEpSyncEpPushVnetEpDeletionFsmFail',
    '1000641' => 'fsmSamDmeGmetaHolderInventoryFsmFail',
    '1000642' => 'fsmSamDmeComputePhysicalCimcSessionDeleteFsmFail',
    '1000652' => 'fsmSamDmePolicyControlledTypeOperateFsmFail',
    '1000700' => 'fsmSamDmeMgmtControllerExtMgmtInterfaceConfigFsmFail',
    '1000701' => 'fsmSamDmeComputeRackUnitCreateDhcpEntryFsmFail',
    '1000702' => 'fsmSamDmeComputePhysicalServiceInfraDeployFsmFail',
    '1000703' => 'fsmSamDmeComputePhysicalServiceInfraWithdrawFsmFail',
    '1000707' => 'fsmSamDmeComputePhysicalUpdateBoardControllerFsmFail',
    '1000742' => 'fsmSamDmeComputePhysicalConfigBoardFsmFail',
    '1000743' => 'fsmSamDmeComputePhysicalResetMemoryErrorsFsmFail',
    '1000747' => 'fsmSamDmeMgmtipv6IfAddrSwMgmtOobIpv6IfConfigFsmFail',
    '1000753' => 'fsmSamDmeSwEthLanFlowMonDeployFsmFail',
    '1000773' => 'fsmSamDmeExtvmmNetworkSetsDeployFsmFail',
    '1000802' => 'fsmSamDmeComputePhysicalFlashControllerFsmFail',
    '1000828' => 'fsmSamDmeSysdebugLogExportPolicyConfigureFsmFail',
    '1000831' => 'fsmSamDmeStorageFlexFlashControllermopsResetFsmFail',
    '1000832' => 'fsmSamDmeStorageFlexFlashControllermopsFormatFsmFail',
    '1000833' => 'fsmSamDmeStorageFlexFlashControllermopsPairFsmFail',
    '1000846' => 'fsmSamDmeComputePhysicalEnableCimcSecureBootFsmFail',
    '1000864' => 'fsmSamDmeIdentMetaSystemUcscUnivSyncFsmFail',
    '1000961' => 'fsmSamDmeStoragePartitionDeployStorageFsmFail',
    '1000962' => 'fsmSamDmeStorageProcessorDiscoverSystemFsmFail',
    '1000963' => 'fsmSamDmeStorageProcessorEnterMaintenanceFsmFail',
    '1000964' => 'fsmSamDmeStorageProcessorExitMaintenanceFsmFail',
    '1000965' => 'fsmSamDmeStorageProcessorDeploySystemFsmFail',
    '1000966' => 'fsmSamDmeStorageProcessorUndeploySystemFsmFail',
    '1000967' => 'fsmSamDmeStorageProcessorHaTakeOverFsmFail',
    '1000968' => 'fsmSamDmeStoragePartitionScrubraidgroupFsmFail',
    '1000973' => 'fsmSamDmeMgmtControllerLockConfigFsmFail',
    '1000974' => 'fsmSamDmeMgmtControllerPowerBudgetReclaimConfigFsmFail',
    '1000975' => 'fsmSamDmeComputePhysicalOobStorageAdminConfigFsmFail',
    '1000980' => 'fsmSamDmeEquipmentiocardBaseFePresenceFsmFail',
    '1000981' => 'fsmSamDmeEquipmentiocardBaseFeConnFsmFail',
    '1000994' => 'fsmSamDmeEquipmentLocatorLedSetDiskLocatorLedFsmFail',
    '1001018' => 'fsmSamDmeLstorageProcessorConfigureFsmFail',
    '1001024' => 'fsmSamDmeOsControllerDeployosFsmFail',
    '1001027' => 'fsmSamDmeEquipmentPsuUpdatepsuFsmFail',
    '1001052' => 'fsmSamDmeMgmtControllerUpdatecmcFsmFail',
    '1001053' => 'fsmSamDmeMgmtControllerActivatecmcFsmFail',
    '1001054' => 'fsmSamDmeMgmtControllerUpdateAdaptorFsmFail',
    '1001055' => 'fsmSamDmeMgmtControllerActivateAdaptorFsmFail',
    '1001056' => 'fsmSamDmeMgmtControllerUpdateRaidControllerFsmFail',
    '1001057' => 'fsmSamDmeMgmtControllerUpdateBoardControllerFsmFail',
    '1001064' => 'fsmSamDmeFabricCartridgeSlotEpIdentifyFsmFail',
    '1001065' => 'fsmSamDmeFabricComputemslotEpIdentifyFsmFail',
    '1001066' => 'fsmSamDmeEquipmentChassisOobStorageAdminCfgFsmFail',
    '1001072' => 'fsmSamDmeComputeServerUnitDiscoverFsmFail',
    '1001073' => 'fsmSamDmeMgmtIfFaPresenceFsmFail',
    '1001074' => 'fsmSamDmeMgmtIfFaConnFsmFail',
    '1001085' => 'fsmSamDmeEquipmentiocardEvacuateFsmFail',
    '1001086' => 'fsmSamDmeEquipmentiocardResetEvacuateFsmFail',
    '1001091' => 'fsmSamDmeComputePhysicalCleartpmFsmFail',
    '1001142' => 'fsmSamDmeEquipmentiocardResetPeerCmcFsmFail',
    '1001164' => 'fsmSamDmeSwExtUtilityConfPortBreakoutFsmFail',
    '1001186' => 'fsmSamDmeEquipmentSwitchiocardEvacuateFsmFail',
    '1001187' => 'fsmSamDmeEquipmentSwitchiocardResetEvacuateFsmFail',
    '1001201' => 'fsmSamDmeMorefImportRootApplyMoRefsFsmFail',
    '1001209' => 'fsmSamDmeStorageEnclosureRemoveEnclosureFsmFail',
    '1001224' => 'fsmSamDmeMgmtControllerPowerCapFsmFail',
    '1001225' => 'fsmSamDmeEquipmentSystemiocontrollerResetCmcFsmFail',
    '1001226' => 'fsmSamDmeComputePhysicalDiskZoningInventoryFsmFail',
    '1001247' => 'fsmSamDmeEquipmentChassisAssociateFsmFail',
    '1001248' => 'fsmSamDmeEquipmentChassisDisassociateFsmFail',
    '1001277' => 'fsmSamDmeEtherServerIntfioConfigFsmFail',
    '1001279' => 'fsmSamDmeMgmtControllerEnableSecureBootFsmFail',
    '1001280' => 'fsmSamDmeMgmtControllerUpdateColusacmcFsmFail',
    '1001281' => 'fsmSamDmeMgmtControllerActivateColusacmcFsmFail',
    '1001282' => 'fsmSamDmeEquipmentChassisChassisUpgradeFsmFail',
    '1001283' => 'fsmSamDmeMgmtControllerUpdateColusaBoardControllerFsmFail',
    '1001284' => 'fsmSamDmeMgmtControllerUpdateSasExpanderFsmFail',
    '1001285' => 'fsmSamDmeMgmtControllerActivateSasExpanderFsmFail',
    '1001286' => 'fsmSamDmeMgmtControllerActivateLocalDiskFsmFail',
    '1001287' => 'fsmSamDmeStorageLocalDiskUpdateLocalDiskFsmFail',
    '1001299' => 'fsmSamDmeMgmtControllerUpdateucsmanagerspFsmFail',
    '1001300' => 'fsmSamDmeComputePhysicalDiagFsmFail',
    '1001301' => 'fsmSamDmeComputePhysicalCimcSecurityConfigFsmFail',
    '1001330' => 'fsmSamDmeSwPortDiscoverDeployFsmFail',
    '1001333' => 'fsmSamDmePolicyPolicyScopeContReportPolicyFailFsmFsmFail',
    '1001334' => 'fsmSamDmePolicyRequestorResolveFromCentralFsmFail',
    '4522530' => 'unrVnicTemplStatsPolicyName',
    '4522532' => 'unrVnicSanConnTemplQosPolicyName',
    '4522544' => 'unrVnicIpV4PooledAddrName',
    '4522556' => 'unrVnicVnicPinToGroupName',
    '4522561' => 'unrVnicVnicStatsPolicyName',
    '4522588' => 'unrVnicProfileQosPolicyName',
    '4522603' => 'unrVnicFcNodeIdentPoolName',
    '4525234' => 'unrLsServerSrcTemplName',
    '4525239' => 'unrLsServerIdentPoolName',
    '4525240' => 'unrLsServerBootPolicyName',
    '4525241' => 'unrLsServerLocalDiskPolicyName',
    '4525247' => 'unrLsServerScrubPolicyName',
    '4525248' => 'unrLsServerDynamicConPolicyName',
    '4525250' => 'unrLsServerHostFwPolicyName',
    '4525251' => 'unrLsServerMgmtFwPolicyName',
    '4525252' => 'unrLsServerMgmtAccessPolicyName',
    '4525253' => 'unrLsServerSolPolicyName',
    '4525254' => 'unrLsServerStatsPolicyName',
    '4526517' => 'unrVnicEtherBaseQosPolicyName',
    '4526850' => 'unrVnicEtherBaseNwCtrlPolicyName',
    '4526851' => 'unrVnicProfileNwCtrlPolicyName',
    '4526901' => 'unrLsServerVconProfileName',
    '4526902' => 'unrLsServerBiosProfileName',
    '4527601' => 'unrLsRequirementName',
    '4528591' => 'unrLsServerPowerPolicyName',
    '4528596' => 'unrLsServerMaintPolicyName',
    '4528609' => 'unrVnicSanConnTemplIdentPoolName',
    '4528611' => 'unrVnicLanConnTemplNwCtrlPolicyName',
    '4528613' => 'unrVnicLanConnTemplIdentPoolName',
    '4528616' => 'unrVnicFcBaseAdaptorProfileName',
    '4528618' => 'unrVnicFcBaseIdentPoolName',
    '4528620' => 'unrVnicFcBaseNwTemplName',
    '4528623' => 'unrVnicEtherBaseAdaptorProfileName',
    '4528625' => 'unrVnicEtherBaseIdentPoolName',
    '4528627' => 'unrVnicEtherBaseNwTemplName',
    '4528680' => 'unrVnicLanConnTemplQosPolicyName',
    '4528682' => 'unrVnicFcBaseQosPolicyName',
    '4528842' => 'unrTrigTriggerableScheduler',
    '4529259' => 'unrPolicySystemProfileDeviceProfileRef',
    '4529444' => 'unrFabricEthEstcEpNwCtrlPolicyName',
    '4529447' => 'unrFabricEthEstcPcNwCtrlPolicyName',
    '4529479' => 'unrFabricEthLanEpOperationEthLinkProfileName',
    '4529601' => 'unrVnicIscsiIdentPoolName',
    '4529604' => 'unrVnicIscsiAuthProfileName',
    '4529606' => 'unrVnicIscsiConfProfileName',
    '4529615' => 'unrVnicIscsiStaticTargetIfAuthProfileName',
    '4529838' => 'unrVnicIpv4PooledIscsiAddrIdentPoolName',
    '4529847' => 'unrVnicIscsiIqnIdentPoolName',
    '4529849' => 'unrVnicIscsiAdaptorProfileName',
    '4529971' => 'unrVnicFcBasePinToGroupName',
    '4529973' => 'unrVnicEtherBasePinToGroupName',
    '4530050' => 'unrFaultSuppressTaskSuppressPolicyName',
    '4530085' => 'unrVnicFcGroupTemplStorageConnPolicyName',
    '4530100' => 'unrVnicAgroupStatsPolicyName',
    '4530109' => 'unrVnicFcGroupDefStorageConnPolicyName',
    '4530112' => 'unrVnicIscsiBaseIdentPoolName',
    '4530114' => 'unrVnicIscsiBaseAdaptorProfileName',
    '4530117' => 'unrVnicDynamicConPolicyRefConPolicyName',
    '4530119' => 'unrVnicConnDefLanConnPolicyName',
    '4530121' => 'unrVnicConnDefSanConnPolicyName',
    '4530139' => 'unrFabricVlanMcastPolicyName',
    '4530389' => 'unrVnicIscsiBootVnicIqnIdentPoolName',
    '4530391' => 'unrVnicIscsiBootVnicAuthProfileName',
    '4530407' => 'unrLsServerExtippoolName',
    '4531275' => 'unrVnicIscsiNodeIqnIdentPoolName',
    '4531414' => 'unrFabricFcoeSanPcOperationLacpPolicyName',
    '4531419' => 'unrFabricFcoeSanPcEpOperationEthLinkProfileName',
    '4531446' => 'unrFabricEthLinkProfileUdldLinkPolicyName',
    '4531448' => 'unrFabricEthLinkProfileCdpLinkPolicyName',
    '4531455' => 'unrFabricFcoeSanEpOperationEthLinkProfileName',
    '4531458' => 'unrFabricFcoeSanEpEthLinkProfileName',
    '4531468' => 'unrVnicVmqConPolicyRefConPolicyName',
    '4531479' => 'unrVnicIpV4MgmtPooledAddrName',
    '4531484' => 'unrVnicIpV6MgmtPooledAddrName',
    '4531488' => 'unrVnicUsnicConPolicyRefConPolicyName',
    '4531519' => 'unrFabricEthEstcEpOperationNwCtrlPolicyName',
    '4531529' => 'unrFabricEthEstcPcOperationLacpPolicyName',
    '4531541' => 'unrFabricEthLanPcOperationLacpPolicyName',
    '4531560' => 'unrFabricEthLanPcEpOperationEthLinkProfileName',
    '4531567' => 'unrFabricEthLanEpEthLinkProfileName',
    '4531570' => 'unrFabricEthLanPcEpEthLinkProfileName',
    '4531624' => 'unrFabricFlowMonitorFlowMonRecordDef',
    '4531626' => 'unrFabricFlowMonitorFlowTimeoutPolicy',
    '4531631' => 'unrFabricNetflowMonitorRefNfMonitorName',
    '4531652' => 'unrFabricFlowMonExporterFlowExpProfile',
    '4531666' => 'unrFabricNetflowMonExporterRefNfMonExporterName',
    '4531672' => 'unrFabricFcoeSanPcEpEthLinkProfileName',
    '4531907' => 'unrExtvmmVmnetworkDefinitionExtIpPoolName',
    '4531914' => 'unrExtvmmVmnetworkFabricNetworkName',
    '4531918' => 'unrExtvmmVmndrefVmNetworkDefName',
    '4531923' => 'unrExtvmmFndreferenceFnDefName',
    '4532135' => 'unrLsServerVmediaPolicyName',
    '4532137' => 'unrLsServerKvmMgmtPolicyName',
    '4532169' => 'unrFabricEthLanPcLacpPolicyName',
    '4532171' => 'unrFabricFcoeSanPcLacpPolicyName',
    '4532175' => 'unrFabricEthEstcPcLacpPolicyName',
    '4532517' => 'unrEquipmentChassisProfileSrcTemplName',
    '4532527' => 'unrEquipmentChassisProfileChassisFwPolicyName',
    '4532531' => 'unrEquipmentChassisProfileMaintPolicyName',
    '4532533' => 'unrEquipmentChassisProfileDiskZoningPolicyName',
    '4532550' => 'unrEquipmentRequirementName',
    '4532685' => 'unrStorageAscsiLunVolumeName',
    '4532844' => 'unrStorageIpV4PooledAddrIdentPoolName',
    '4532850' => 'unrVnicEthConfigNwCtrlPolicyName',
    '4532852' => 'unrVnicEthConfigStatsPolicyName',
    '4532854' => 'unrVnicEthConfigMacPoolName',
    '4532856' => 'unrVnicEthConfigAdaptorProfileName',
    '4532859' => 'unrVnicIscsiConfigIpPoolName',
    '4532861' => 'unrVnicIscsiConfigIpPoolNameFabricb',
    '4532863' => 'unrVnicIscsiConfigIqnPoolName',
    '4532865' => 'unrVnicIscsiConfigAdaptorProfileName',
    '4532871' => 'unrVnicIscsiNodeInitiatorPolicyName',
    '4532898' => 'unrLstorageArrayAutoconfigPolicySrcTemplName',
    '4532900' => 'unrLstorageArrayAutoconfigPolicyQualifier',
    '4532906' => 'unrLstorageArraySrcTemplName',
    '4532915' => 'unrLstorageArrayHostFwPolicyName',
    '4532917' => 'unrLstorageArrayStorageFwPolicyName',
    '4532919' => 'unrLstorageArrayStatsPolicyName',
    '4532921' => 'unrLstorageArrayMaintPolicyName',
    '4532925' => 'unrLstorageProcessorSvcPolicyName',
    '4532935' => 'unrLstorageProcessorExtippoolName',
    '4532954' => 'unrLstorageQualifiedPolicyQualifier',
    '4532969' => 'unrLstorageLunSnapshotPolicyScheduleName',
    '4532988' => 'unrLstorageProfileBindingBaseStorageProfileName',
    '4533006' => 'unrLstorageSanScsiLunReplicationPolicyName',
    '4533008' => 'unrLstorageSanScsiLunSnapshotPolicyName',
    '4533010' => 'unrLstorageDasScsiLunLocalDiskPolicyName',
    '4533059' => 'unrLstorageBackstoreRequirementName',
    '4533061' => 'unrLstorageBackstoreRequirementQualifier',
    '4533226' => 'unrVnicStorageEthLifVlanName',
    '4533245' => 'unrComputeAutoconfigPolicyQualifier',
    '4533247' => 'unrComputeBladeInheritPolicyQualifier',
    '4533371' => 'unrDomainProfileSrcTemplName',
    '4533374' => 'unrDomainProfilePortDiscPolicyName',
    '4533376' => 'unrDomainProfileHwChangeDiscPolicyName',
    '4533378' => 'unrDomainProfileInbandPolicyName',
    '4533380' => 'unrDomainProfileKmipCertificatePolicyName',
    '4533382' => 'unrDomainProfileQosclassDefinitionName',
    '4533589' => 'unrFdPhysicalKmipCertificatePolicyName',
    '4534475' => 'unrVnicSanConnTemplPeerRedundancyTemplName',
    '4534477' => 'unrVnicLanConnTemplPeerRedundancyTemplName',
    '4534557' => 'unrLsServerPowerSyncPolicyName',
    '4534831' => 'unrEquipmentAutoconfigPolicyQualifier',
    '4534833' => 'unrEquipmentChassisInheritPolicyQualifier',
    '4535084' => 'unrFabricNetGroupRefName',
    '4535086' => 'unrFabricSanGroupRefName',
    '4535111' => 'unrLsServerGraphicsCardPolicyName',
    '4535173' => 'unrEquipmentChassisProfileComputeConnPolicyName',
    '4535189' => 'unrMoIpAddrKvPoolName',
  },
  'CucsStatsReportingInterval' => {
    '120' => 'n2minutes',
    '900' => 'n15minutes',
    '1800' => 'n30minutes',
    '3600' => 'n60minutes',
    '7200' => 'n2hours',
    '14400' => 'n4hours',
    '28800' => 'n8hours',
  },
  'CucsComputePortDiscPolicyEthSvrAutoDiscovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsLstorageRemoteCtrlServiceFailOverState' => {
    '0' => 'triggered',
    '1' => 'trigger',
    '2' => 'forceTrigger',
    '3' => 'remoteTrigger',
  },
  'CucsFabricVConSelectPref' => {
    '1' => 'assignedOnly',
    '2' => 'unassignedOnly',
    '3' => 'excludeDynamic',
    '4' => 'dynamicOnly',
    '5' => 'excludeUnassigned',
    '7' => 'excludeUsnic',
    '8' => 'usnicOnly',
  },
  'CucsEquipmentRemovalConditions' => {
    '0' => 'unknown',
    '2' => 'notApplicable',
    '3' => 'removableWhenOff',
    '4' => 'removableWhenOnOrOff',
  },
  'CucsExtmgmtIfMonPolicyMonitorMechanism' => {
    '0' => 'miiStatus',
    '1' => 'arpTargetPing',
    '2' => 'gatewayPing',
  },
  'CucsTopSystemFsmStageName' => {
    '0' => 'nop',
    '15' => 'hostNameBegin',
    '16' => 'hostNameConfig',
    '179' => 'hostNameFail',
    '180' => 'hostNameSuccess',
    '293' => 'peerHostNameBegin',
    '294' => 'peerHostNameConfig',
    '303' => 'peerHostNameFail',
    '304' => 'peerHostNameSuccess',
    '394' => 'hostNameConfigPeer',
  },
  'CucsSysdebugTechSupportFsmCurrentFsm' => {
    '0' => 'nop',
    '881' => 'initiate',
    '883' => 'deleteTechSupFile',
    '886' => 'download',
  },
  'CucsBiosVfVGAPriorityVpVGAPriority' => {
    '0' => 'platformRecommended',
    '417' => 'onboard',
    '418' => 'offboard',
    '419' => 'onboardVgaDisabled',
  },
  'CucsPkiCertStatus' => {
    '0' => 'valid',
    '1' => 'expired',
    '2' => 'revoked',
    '3' => 'notYetValid',
    '4' => 'emptyCert',
    '5' => 'unknown',
    '6' => 'failedToVerifyWithTp',
    '7' => 'failedToVerifyWithPrivateKey',
    '8' => 'certChainTooLong',
    '9' => 'selfSignedCertificate',
  },
  'CucsStoragePartitionFsmTaskItem' => {
    '0' => 'nop',
    '1630' => 'deployStorage',
    '1677' => 'scrubRAIDGroup',
  },
  'CucsEquipmentBiosUpdateMethod' => {
    '0' => 'unknown',
    '1' => 'managementController',
    '2' => 'pnuos',
  },
  'CucsNfsMountDefFsmTaskItem' => {
    '0' => 'nop',
    '1241' => 'reportNfsMountSuspend',
  },
  'CucsStorageControllerStatus' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'failed',
    '3' => 'unresponsive',
    '4' => 'degraded',
    '5' => 'unsupportedFwForOob',
  },
  'CucsAaaRealmFsmCurrentFsm' => {
    '0' => 'nop',
    '200' => 'updateRealm',
  },
  'CucsCallhomeEpFsmCurrentFsm' => {
    '0' => 'nop',
    '274' => 'configCallhome',
  },
  'CucsEquipmentAvailability' => {
    '0' => 'unavailable',
    '1' => 'available',
  },
  'CucsEquipmentConfigIssues' => {
    '0' => 'notApplicable',
    '1' => 'uncleanConfiguration',
  },
  'CucsStorageFFDriveState' => {
    '0' => 'nonraid',
    '1' => 'raid',
  },
  'CucsStatsWeeklyRecords' => {
    '0' => 'none',
    '2' => 'n2weeks',
    '26' => 'n6months',
    '53' => 'n1year',
  },
  'CucsSysdebugTechSupportOperState' => {
    '0' => 'unavailable',
    '1' => 'available',
    '2' => 'availableOnSubordinate',
    '3' => 'inProgress',
    '4' => 'failed',
  },
  'CucsPolicyControlSource' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
    '3' => 'unspecified',
  },
  'CucsFabricNetflowMonSrcRefProtocol' => {
    '1' => 'netflow',
  },
  'CucsAdaptorExtEthIfFsmCurrentFsm' => {
    '0' => 'nop',
    '499' => 'pathReset',
  },
  'CucsEquipmentHostMgmtControllerCapCommMethod' => {
    '0' => 'unknown',
    '1' => 'serial',
    '2' => 'usbNic',
  },
  'CucsAdaptorAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CucsEtherSwitchIntFIoIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsComputeDomainPortDiscPolicyEthSvrAutoDiscovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricFIPortOperationFsmTaskItem' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsStorageLocalDiskConfigFlexFlashRAIDReportingState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsFabricSwChPhEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsConfigImpactAnalyzerContext' => {
    '0' => 'dme',
    '1' => 'import',
  },
  'CucsMgmtExportPolicyFsmTaskItem' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopy',
  },
  'CucsPoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsEquipmentLocatorLedFsmCurrentFsm' => {
    '0' => 'nop',
    '15' => 'setLocatorLed',
    '641' => 'setFeLocatorLed',
    '1090' => 'setFiLocatorLed',
    '1744' => 'setDiskLocatorLed',
  },
  'CucsEquipmentHxCapIsSedSupported' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsFabricFcMonDestEpOperationAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n2gbps',
    '3' => 'n4gbps',
    '4' => 'n8gbps',
    '5' => 'auto',
    '6' => 'n16gbps',
  },
  'CucsBiosVfOnboardSATAControllerVpSATAMode' => {
    '0' => 'platformRecommended',
    '40' => 'enhanced',
    '41' => 'compatibility',
    '42' => 'ahci',
    '186' => 'swRaid',
  },
  'CucsFabricEthEstcPcOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsStatsThresholdDirection' => {
    '1' => 'aboveNormal',
    '2' => 'belowNormal',
  },
  'CucsPolicyIdResolvePolicyType' => {
    '0' => 'noDuplicateCheck',
    '1' => 'looseDuplicateCheck',
    '2' => 'strictDuplicateCheck',
  },
  'CucsFabricOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CucsStatsCollectionDomain' => {
    '0' => 'unknown',
    '2' => 'chassis',
    '4' => 'port',
    '5' => 'host',
    '6' => 'adapter',
    '7' => 'server',
    '8' => 'fex',
  },
  'CucsSysfileExporterPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsAdaptorMgmtCapMode' => {
    '1' => 'full',
    '2' => 'partial',
  },
  'CucsIdentIdentType' => {
    '1' => 'mac',
    '2' => 'wwnn',
    '3' => 'wwpn',
    '4' => 'uuid',
    '5' => 'vlan',
    '6' => 'ipV4',
    '7' => 'ipV6',
    '8' => 'iqn',
  },
  'CucsPortPIoFsmTaskItem' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresence',
    '1334' => 'inCompatSfpReplaced',
  },
  'CucsFabricFIPortOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsEquipmentConfigState' => {
    '0' => 'notApplied',
    '1' => 'applying',
    '2' => 'applied',
    '3' => 'applyFailed',
  },
  'CucsVnicIPv4DnsPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CucsStorageReplicationPeerStatus' => {
    '0' => 'idle',
    '1' => 'replicationInProgress',
    '2' => 'restoreInProgress',
  },
  'CucsBiosVfQPILinkFrequencySelectVpQPILinkFrequencySelect' => {
    '0' => 'platformRecommended',
    '436' => 'n6400',
    '437' => 'n7200',
    '438' => 'n8000',
    '439' => 'n64',
    '440' => 'n72',
    '441' => 'n80',
    '442' => 'auto',
    '494' => 'n9600',
  },
  'CucsAdaptorFcErrorRecoveryProfileFcpErrorRecovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsTestingServiceProfileFsmCurrentFsm' => {
    '0' => 'nop',
    '46' => 'resolvePolicyFsm',
    '48' => 'resolveManyPolicyFsm',
  },
  'CucsStorageLunObjType' => {
    '0' => 'regular',
    '1' => 'snapshot',
    '2' => 'replica',
  },
  'CucsCommCimxmlAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsInitiatorIScsiInitiatorEpProt' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsFabricNFExporterVersion' => {
    '1' => 'v9',
    '2' => 'ipfix',
  },
  'CucsEquipmentPOSTRecoverability' => {
    '0' => 'unknown',
    '1' => 'recoverable',
    '2' => 'nonRecoverable',
  },
  'CucsCommSnmpConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpPCIeSlotN2OptionROM' => {
    '0' => 'platformRecommended',
    '471' => 'disabled',
    '472' => 'enabled',
    '473' => 'uefiOnly',
    '474' => 'legacyOnly',
  },
  'CucsEquipmentFabricEpType' => {
    '0' => 'unknown',
    '1' => 'chassis',
    '2' => 'fex',
    '3' => 'blade',
    '4' => 'rackUnit',
    '5' => 'cartridge',
    '6' => 'serverUnit',
  },
  'CucsEquipmentInternalFanType' => {
    '0' => 'chassis',
    '1' => 'switch',
    '2' => 'fex',
  },
  'CucsEquipmentBiosTokenType' => {
    '0' => 'none',
    '1' => 'optionRom',
    '2' => 'memoryMappedAbove4gb',
    '3' => 'biosVftpm',
  },
  'CucsStorageFFRaidSyncSupport' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsStorageSasUpLinkControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
    '5' => 'pt',
    '6' => 'pch',
    '7' => 'external',
    '8' => 'nvme',
    '9' => 'hba',
    '10' => 'm2',
  },
  'CucsVmHvType' => {
    '0' => 'unspecified',
    '1' => 'esx',
    '2' => 'kvm',
    '3' => 'hyperv',
    '4' => 'xen',
  },
  'CucsFabricLanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsMgmtBackupIssue' => {
    '0' => 'none',
    '1' => 'outdated',
  },
  'CucsSwPortDiscoverFsmCurrentFsm' => {
    '0' => 'nop',
    '2249' => 'deploy',
  },
  'CucsFabricLanCloudFsmTaskItem' => {
    '0' => 'nop',
    '184' => 'switchMode',
  },
  'CucsSmartlicenseHolderFsmStageName' => {
    '0' => 'nop',
    '487' => 'configureBegin',
    '488' => 'configureEnableSmartLicense',
    '489' => 'configureDisableSmartLicense',
    '490' => 'configureRegisterDevice',
    '491' => 'configureRetryRegisterDevice',
    '492' => 'configureUnregisterDevice',
    '493' => 'configureRetryUnregisterDevice',
    '520' => 'configureFail',
    '521' => 'configureSuccess',
    '530' => 'updateStateBegin',
    '531' => 'updateStateRefreshState',
    '534' => 'updateStateFail',
    '535' => 'updateStateSuccess',
  },
  'CucsStatsDailyRecords' => {
    '0' => 'none',
    '14' => 'n2weeks',
    '90' => 'n3months',
    '180' => 'n6months',
    '365' => 'n1year',
  },
  'CucsMemoryAdminState' => {
    '1' => 'policy',
    '2' => 'resetErrors',
  },
  'CucsStorageBbuStatus' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'learnCycleActive',
    '3' => 'learnCycleNeeded',
    '4' => 'failurePredicted',
    '5' => 'premiumFeatureReqd',
    '6' => 'microcodeUpdateReqd',
    '7' => 'replacementNeeded',
    '8' => 'noFlashSpace',
    '9' => 'notSupported',
    '10' => 'notPresent',
  },
  'CucsGlAbsIdentCtxOpPurpose' => {
    '0' => 'nodeAndPortWwnAssignment',
    '1' => 'portWwnAssignment',
    '2' => 'nodeWwnAssignment',
    '3' => 'default',
  },
  'CucsVmMgmtPlane' => {
    '0' => 'unmanaged',
    '1' => 'vcenter',
    '2' => 'rhevM',
    '3' => 'scvmm',
  },
  'CucsEquipmentLocatorLedFsmTaskItem' => {
    '0' => 'nop',
    '15' => 'setLocatorLed',
    '641' => 'setFeLocatorLed',
    '1119' => 'setFiLocatorLed',
    '1744' => 'setDiskLocatorLed',
  },
  'CucsMgmtAbsImporterProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsAdaptorHostEthIfHostPort' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CucsPowerPsuState' => {
    '0' => 'ok',
    '1' => 'insufficient',
  },
  'CucsEquipmentOwner' => {
    '1' => 'management',
    '2' => 'policy',
    '4' => 'tier',
  },
  'CucsBiosVfProcessorEnergyConfigurationVpPowerTechnology' => {
    '0' => 'platformRecommended',
    '422' => 'disabled',
    '423' => 'energyEfficient',
    '424' => 'performance',
    '425' => 'custom',
  },
  'CucsStorageEpLinkState' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'subOptimal',
    '3' => 'misconnect',
  },
  'CucsGmetaVersion' => {
    '0' => 'unknown',
    '2' => 'nextgen',
  },
  'CucsAdaptorEthArfsProfileAccelaratedRFS' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsConfigProfileType' => {
    '0' => 'all',
    '1' => 'local',
    '2' => 'global',
  },
  'CucsEquipmentPortAttribute' => {
    '0' => 'none',
    '1' => 'scalability',
  },
  'CucsCommWsmanAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsAdaptorIpV4RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsAdaptorLinkState' => {
    '0' => 'unknown',
    '1' => 'adminDown',
    '2' => 'down',
    '3' => 'error',
    '4' => 'up',
    '5' => 'unallocated',
    '6' => 'unavailable',
    '7' => 'offline',
  },
  'CucsConfigBackupFsmStageName' => {
    '0' => 'nop',
    '183' => 'deleteBegin',
    '184' => 'deleteLocal',
    '198' => 'deleteFail',
    '199' => 'deleteSuccess',
  },
  'CucsEquipmentIOCardBaseFsmStageName' => {
    '0' => 'nop',
    '1732' => 'fePresenceBegin',
    '1733' => 'fePresenceCheckLicense',
    '1734' => 'fePresenceIdentify',
    '1735' => 'fePresenceConfigChassisId',
    '1736' => 'feConnBegin',
    '1737' => 'feConnConfigureSwMgmtEndPoint',
    '1738' => 'feConnConfigureVifNs',
    '1739' => 'feConnConfigureEndPoint',
    '1740' => 'feConnDiscoverChassis',
    '1741' => 'feConnEnableChassis',
    '1815' => 'feConnFail',
    '1816' => 'feConnSuccess',
    '1817' => 'fePresenceFail',
    '1818' => 'fePresenceSuccess',
  },
  'CucsCallhomeEpFsmTaskItem' => {
    '0' => 'nop',
    '274' => 'configCallhome',
  },
  'CucsComputeCartridgeDiscovery' => {
    '0' => 'undiscovered',
    '1' => 'inProgress',
    '2' => 'malformedFruInfo',
    '3' => 'fruNotReady',
    '4' => 'insufficientlyEquipped',
    '5' => 'invalidAdaptorIocard',
    '8' => 'failed',
    '16' => 'complete',
    '32' => 'retry',
    '64' => 'throttled',
    '128' => 'illegalFru',
    '129' => 'fruIdentityIndeterminate',
    '130' => 'fruStateIndeterminate',
    '131' => 'diagnosticsInProgress',
    '132' => 'efidiagnosticsInProgress',
    '133' => 'diagnosticsFailed',
    '134' => 'diagnosticsComplete',
    '135' => 'waitingForUserAck',
    '136' => 'userAcknowledged',
    '137' => 'waitingForMgmtAck',
  },
  'CucsStorageDisklessAction' => {
    '0' => 'unspecified',
    '1' => 'yes',
    '2' => 'no',
  },
  'CucsQosclassDefinitionFsmTaskItem' => {
    '0' => 'nop',
    '313' => 'configGlobalQoS',
  },
  'CucsLsAgentMode' => {
    '1' => 'noAgent',
    '2' => 'readOnly',
    '4' => 'full',
  },
  'CucsBiosVfOnboardGraphicsVpOnboardGraphics' => {
    '0' => 'platformRecommended',
    '407' => 'disabled',
    '408' => 'enabled',
  },
  'CucsFabricFlowMonKeyType' => {
    '0' => 'l2keys',
    '1' => 'ipv4keys',
    '2' => 'ipv6keys',
  },
  'CucsStorageRemoteVirtualDriveAdminActionTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'online',
    '2' => 'offline',
    '3' => 'delete',
    '4' => 'restore',
    '5' => 'degraded',
    '6' => 'transportReady',
    '7' => 'clearTransportReady',
    '8' => 'hide',
    '9' => 'unhide',
    '10' => 'secureDriveGroup',
  },
  'CucsMgmtImporterFsmTaskItem' => {
    '0' => 'nop',
    '293' => 'import',
    '1189' => 'reportConfigImport',
  },
  'CucsExtpolConnType' => {
    '5' => 'ape',
    '19' => 'serverMgr',
    '27' => 'serviceReg',
    '28' => 'identifierMgr',
    '29' => 'operationMgr',
    '30' => 'resourceMgr',
    '31' => 'virtualSwitchingMgr',
    '32' => 'policyMgr',
    '33' => 'bootMgr',
    '34' => 'vmMgr',
    '35' => 'managedEndpoint',
    '36' => 'mgmtController',
    '37' => 'storageBroker',
    '38' => 'resourceAggr',
    '39' => 'statsMgr',
    '40' => 'centralMgr',
  },
  'CucsMgmtEntityLeadership' => {
    '0' => 'unknown',
    '1' => 'primary',
    '2' => 'subordinate',
    '3' => 'inapplicable',
    '4' => 'electionInProgress',
    '5' => 'electionFailed',
  },
  'CucsGmetaPollInterval' => {
    '0' => 'never',
    '1' => 'n1min',
    '2' => 'n2min',
    '5' => 'n5min',
    '10' => 'n10min',
    '15' => 'n15min',
    '30' => 'n30min',
  },
  'CucsMgmtDataExporterFsmTaskItem' => {
    '0' => 'nop',
    '24' => 'exportData',
  },
  'CucsLsbootSanAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot7LinkSpeed' => {
    '0' => 'platformRecommended',
    '351' => 'gen1',
    '352' => 'gen2',
    '353' => 'gen3',
    '354' => 'auto',
    '355' => 'disabled',
  },
  'CucsQosclassEthBEAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsGlAdminState' => {
    '0' => 'evaluate',
    '1' => 'globalize',
    '3' => 'reevaluate',
    '4' => 'terminate',
  },
  'CucsLsAgentLoadCatalog' => {
    '0' => 'unknown',
    '1' => 'noLoad',
    '2' => 'load',
  },
  'CucsFabricPcConfigStatus' => {
    '1' => 'applied',
    '2' => 'incompatibleSpeed',
  },
  'CucsStorageLocalDiskFsmStageName' => {
    '0' => 'nop',
    '2156' => 'updateLocalDiskBegin',
    '2157' => 'updateLocalDiskPowerOffServers',
    '2158' => 'updateLocalDiskServersPowerOffCompletion',
    '2159' => 'updateLocalDiskUpdate',
    '2160' => 'updateLocalDiskPollUpdateStatus',
    '2193' => 'updateLocalDiskFail',
    '2194' => 'updateLocalDiskSuccess',
  },
  'CucsFabricLacpRate' => {
    '0' => 'normal',
    '1' => 'fast',
  },
  'CucsEquipmentPictureType' => {
    '0' => 'unknown',
    '1' => 'front',
    '2' => 'back',
    '3' => 'top',
    '4' => 'bottom',
    '5' => 'left',
    '6' => 'right',
    '7' => 'topScaled',
    '8' => 'frontTopScaled',
    '9' => 'frontBottomScaled',
  },
  'CucsFirmwareImpactType' => {
    '0' => 'activate',
    '1' => 'noimpact',
    '2' => 'reset',
    '3' => 'update',
  },
  'CucsLicensePeerStatus' => {
    '0' => 'noPeer',
    '1' => 'unknown',
    '2' => 'lacks',
    '3' => 'matching',
  },
  'CucsBiosVpIntelVirtualizationTechnology' => {
    '0' => 'platformRecommended',
    '12' => 'disabled',
    '13' => 'enabled',
  },
  'CucsGlRequestFsmTaskItem' => {
    '0' => 'nop',
    '583' => 'evaluate',
    '587' => 'createGlobalIdPool',
    '589' => 'createGlobalPolicy',
    '591' => 'globalize',
  },
  'CucsFirmwareDependencySensitivity' => {
    '0' => 'global',
    '1' => 'fabric',
    '2' => 'path',
  },
  'CucsFabricVnetEpSyncEpFsmCurrentFsm' => {
    '0' => 'nop',
    '367' => 'syncVnetEpUCS',
    '1474' => 'pushVnetEpDeletion',
  },
  'CucsBiosVfPCHSATAModeVpSATAMode' => {
    '0' => 'platformRecommended',
    '532' => 'ahci',
    '533' => 'disabled',
    '534' => 'lsiSwRaid',
  },
  'CucsBiosVfPCILOMPortsConfigurationVpPCIe10GLOM2Link' => {
    '0' => 'platformRecommended',
    '528' => 'enabled',
    '529' => 'disabled',
  },
  'CucsMgmtAccess' => {
    '0' => 'unspecified',
    '1' => 'inBand',
    '2' => 'outOfBand',
    '4' => 'internal',
    '8' => 'virtual',
  },
  'CucsPolicyRegistrationStateType' => {
    '0' => 'registering',
    '1' => 'registered',
    '2' => 'failed',
    '3' => 'lostVisibility',
    '4' => 'unregistered',
  },
  'CucsNfsClientDefFsmTaskItem' => {
    '0' => 'nop',
    '187' => 'addConfig',
    '190' => 'deleteConfig',
  },
  'CucsLsIdentityInfoWriteMode' => {
    '0' => 'unsync',
    '1' => 'sync',
  },
  'CucsVnicDefBehType' => {
    '1' => 'vnic',
    '2' => 'vhba',
  },
  'CucsFabricNetflowMonSrcEpProtocol' => {
    '1' => 'netflow',
  },
  'CucsBiosVfUSBBootConfigVpMakeDeviceNonBootable' => {
    '0' => 'platformRecommended',
    '106' => 'disabled',
    '107' => 'enabled',
  },
  'CucsStorageFileSystemStatus' => {
    '0' => 'unknown',
    '1' => 'clean',
    '2' => 'notClean',
    '3' => 'mounted',
    '4' => 'unmounted',
  },
  'CucsComputeEquipmentConstraintType' => {
    '0' => 'unknown',
    '1' => 'localDisk',
    '2' => 'adaptor',
    '3' => 'dimm',
  },
  'CucsNfsExportOperState' => {
    '0' => 'unregistered',
    '1' => 'syncing',
    '2' => 'synced',
    '3' => 'failed',
  },
  'CucsExtpolProviderFsmTaskItem' => {
    '0' => 'nop',
    '1374' => 'reportConfigImport',
  },
  'CucsStorageFFRAIDState' => {
    '0' => 'ffrStateDisabled',
    '1' => 'ffrStateEnabledNotPaired',
    '2' => 'ffrStateEnabledPairedInvalidSecondary',
    '3' => 'ffrStateEnabledPairedInvalidPrimary',
    '4' => 'ffrStateEnabledPairedInvalidBoth',
    '5' => 'ffrStateEnabledPaired',
    '6' => 'ffrStateRaidMirroringDisabled',
  },
  'CucsFabricEthEstcEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsAaaAuthRealmFsmStageName' => {
    '0' => 'nop',
    '200' => 'updateRealmBegin',
    '201' => 'updateRealmSetRealmLocal',
    '202' => 'updateRealmSetRealmPeer',
    '324' => 'updateRealmFail',
    '325' => 'updateRealmSuccess',
    '385' => 'updateRealmSetRealm',
  },
  'CucsFaultPolicyClearAction' => {
    '0' => 'retain',
    '1' => 'delete',
  },
  'CucsMgmtIfFsmCurrentFsm' => {
    '0' => 'nop',
    '277' => 'swMgmtOobIfConfig',
    '279' => 'swMgmtInbandIfConfig',
    '281' => 'virtualIfConfig',
    '284' => 'enableVip',
    '286' => 'disableVip',
    '288' => 'enableHA',
    '1907' => 'faPresence',
    '1910' => 'faConn',
  },
  'CucsTrigTokenOperState' => {
    '0' => 'valid',
    '1' => 'expired',
  },
  'CucsDiagAdminState' => {
    '0' => 'ready',
    '1' => 'trigger',
    '2' => 'cancel',
  },
  'CucsFabricEthEstcEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsFabricNetflowMonitorFlowMonProtocol' => {
    '1' => 'netflow',
  },
  'CucsDpsecForgedTransmit' => {
    '0' => 'allow',
    '1' => 'deny',
  },
  'CucsLsbootEmbeddedLocalDiskImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsStorageFFDriveRemovable' => {
    '0' => 'na',
    '1' => 'yes',
    '2' => 'no',
  },
  'CucsFabricAFcoeEstcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsCommDateTimeFsmCurrentFsm' => {
    '0' => 'nop',
    '536' => 'timezone',
  },
  'CucsTrigReqAdminState' => {
    '0' => 'autoSched',
    '1' => 'schedAck',
    '2' => 'forceAck',
  },
  'CucsDupeChangeTrackerEpFsmCurrentFsm' => {
    '0' => 'nop',
    '395' => 'configure',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortKVM' => {
    '0' => 'platformRecommended',
    '399' => 'disabled',
    '400' => 'enabled',
  },
  'CucsSysdebugBackupFormat' => {
    '1' => 'ascii',
    '2' => 'binary',
  },
  'CucsMoIpV4AddrKvType' => {
    '0' => 'keyValue',
    '1' => 'ipv4Addr',
    '2' => 'ipv6Addr',
    '3' => 'vlan',
    '4' => 'vnic',
  },
  'CucsFabricEthEstcPcOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsBiosVfOptionROMEnableVpState' => {
    '0' => 'platformRecommended',
    '208' => 'disabled',
    '209' => 'enabled',
    '443' => 'uefiOnly',
    '444' => 'legacyOnly',
  },
  'CucsComputeStorageInitType' => {
    '0' => 'unknown',
    '1' => 'noInit',
    '2' => 'createInitialVolumes',
  },
  'CucsStorageEnclosureDiskSlotEpOwnership' => {
    '0' => 'unknown',
    '1' => 'unassigned',
    '2' => 'dedicated',
    '3' => 'shared',
    '4' => 'chassisSpare',
    '5' => 'chassisDedicatedSpare',
  },
  'CucsFdBladeFsmCurrentFsm' => {
    '0' => 'nop',
    '616' => 'configure',
  },
  'CucsCallhomeFormat' => {
    '1' => 'xml',
    '2' => 'fullTxt',
    '4' => 'shortTxt',
  },
  'CucsBiosVfUSBBootConfigVpLegacyUSBSupport' => {
    '0' => 'platformRecommended',
    '249' => 'disabled',
    '250' => 'enabled',
    '251' => 'auto',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot8LinkSpeed' => {
    '0' => 'platformRecommended',
    '356' => 'gen1',
    '357' => 'gen2',
    '358' => 'gen3',
    '359' => 'auto',
    '360' => 'disabled',
  },
  'CucsConfigDisruptionType' => {
    '0' => 'host',
    '1' => 'fabricInterconnect',
    '2' => 'firmwareInfra',
  },
  'CucsFabricLanCloudFsmCurrentFsm' => {
    '0' => 'nop',
    '184' => 'switchMode',
  },
  'CucsMgmtRegistryInfoFsmTaskItem' => {
    '0' => 'nop',
    '3' => 'configure',
  },
  'CucsBiosVfProcessorCMCIVpProcessorCMCI' => {
    '0' => 'platformRecommended',
    '555' => 'enabled',
    '556' => 'disabled',
  },
  'CucsGlVnetOperState' => {
    '0' => 'notEvaluated',
    '1' => 'notConflict',
    '2' => 'conflict',
    '3' => 'conflictResolved',
    '4' => 'globalizing',
    '5' => 'globalized',
    '6' => 'failedToGlobalize',
  },
  'CucsBiosVfUCSMBootOrderRuleControlVpUCSMBootOrderRule' => {
    '0' => 'platformRecommended',
    '198' => 'strict',
    '199' => 'loose',
  },
  'CucsQosclassFcAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsMgmtRegistryInfoFsmCurrentFsm' => {
    '0' => 'nop',
    '3' => 'configure',
  },
  'CucsLstorageOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CucsFabricAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsOrgOrgFsmCurrentFsm' => {
    '0' => 'nop',
    '5' => 'configure',
    '291' => 'configurePeer',
  },
  'CucsAaaSshStr' => {
    '0' => 'none',
    '1' => 'key',
  },
  'CucsEquipmentSystemIOControllerFsmTaskItem' => {
    '0' => 'nop',
    '2035' => 'resetCmc',
  },
  'CucsStorageAccessType' => {
    '0' => 'unknown',
    '1' => 'readWrite',
    '2' => 'readOnly',
    '3' => 'blocked',
    '4' => 'transportReady',
    '5' => 'hidden',
  },
  'CucsCallhomeAlertMessageType' => {
    '0' => 'inventory',
    '1' => 'syslog',
    '2' => 'test',
    '3' => 'diag',
    '4' => 'env',
    '5' => 'conf',
    '6' => 'telemetry',
    '100' => 'unknown',
  },
  'CucsStorageFcZoningType' => {
    '0' => 'none',
    '1' => 'sist',
    '2' => 'simt',
  },
  'CucsEquipmentSwitchIOCardFsmStageName' => {
    '0' => 'nop',
    '1732' => 'fePresenceBegin',
    '1733' => 'fePresenceCheckLicense',
    '1734' => 'fePresenceIdentify',
    '1735' => 'fePresenceConfigChassisId',
    '1736' => 'feConnBegin',
    '1737' => 'feConnConfigureSwMgmtEndPoint',
    '1738' => 'feConnConfigureVifNs',
    '1739' => 'feConnConfigureEndPoint',
    '1740' => 'feConnDiscoverChassis',
    '1741' => 'feConnEnableChassis',
    '1815' => 'feConnFail',
    '1816' => 'feConnSuccess',
    '1817' => 'fePresenceFail',
    '1818' => 'fePresenceSuccess',
    '2002' => 'evacuateBegin',
    '2003' => 'evacuateExecute',
    '2004' => 'resetEvacuateBegin',
    '2005' => 'resetEvacuateExecute',
    '2006' => 'evacuateFail',
    '2007' => 'evacuateSuccess',
    '2008' => 'resetEvacuateFail',
    '2009' => 'resetEvacuateSuccess',
  },
  'CucsNfsExportDefFsmCurrentFsm' => {
    '0' => 'nop',
    '338' => 'imageSync',
    '340' => 'addRepo',
  },
  'CucsStorageControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
    '5' => 'pt',
    '6' => 'pch',
    '7' => 'external',
    '8' => 'nvme',
    '9' => 'hba',
    '10' => 'm2',
  },
  'CucsFirmwareInfraProfileStatus' => {
    '0' => 'pending',
    '1' => 'triggeredActive',
    '2' => 'triggered',
    '3' => 'failedToTrigger',
  },
  'CucsComputeAdminTrigger' => {
    '0' => 'undiscovered',
    '1' => 'rediscover',
    '2' => 'resetToFactory',
    '3' => 'discovered',
    '4' => 'remove',
    '5' => 'migrate',
    '6' => 'decommission',
    '7' => 'upgradeFirmware',
  },
  'CucsComputeRackUnitFsmStageName' => {
    '0' => 'nop',
    '665' => 'associateBegin',
    '668' => 'associateUpdateIBMCFw',
    '669' => 'associateWaitForIBMCFwUpdate',
    '670' => 'associateActivateIBMCFw',
    '671' => 'associateResetIBMC',
    '672' => 'associatePreSanitize',
    '673' => 'associateSanitize',
    '674' => 'associateConfigUserAccess',
    '675' => 'associateBladePowerOff',
    '676' => 'associateUpdateBoardCtrlRequest',
    '677' => 'associatePollBoardCtrlUpdateStatus',
    '678' => 'associatePowerOn',
    '679' => 'associateBmcPreconfigPnuOSLocal',
    '680' => 'associateBmcPreconfigPnuOSPeer',
    '681' => 'associateBmcConfigPnuOS',
    '682' => 'associateSwConfigPnuOSLocal',
    '683' => 'associateSwConfigPnuOSPeer',
    '684' => 'associateUpdateAdaptorNwFwLocal',
    '685' => 'associateUpdateAdaptorNwFwPeer',
    '686' => 'associateWaitForAdaptorNwFwUpdateLocal',
    '687' => 'associateWaitForAdaptorNwFwUpdatePeer',
    '688' => 'associateActivateAdaptorNwFwLocal',
    '689' => 'associateActivateAdaptorNwFwPeer',
    '690' => 'associateNicConfigPnuOSLocal',
    '691' => 'associateNicConfigPnuOSPeer',
    '692' => 'associateBootPnuos',
    '693' => 'associateBootWait',
    '694' => 'associateBiosPostCompletion',
    '695' => 'associateHagPnuOSConnect',
    '696' => 'associatePnuOSIdent',
    '697' => 'associatePnuOSPolicy',
    '698' => 'associatePnuOSValidate',
    '699' => 'associatePnuOSSelfTest',
    '700' => 'associateBiosImgUpdate',
    '701' => 'associateStorageCtlrImgUpdate',
    '702' => 'associateHbaImgUpdate',
    '703' => 'associateNicImgUpdate',
    '704' => 'associatePnuOSInventory',
    '705' => 'associatePnuOSConfig',
    '706' => 'associatePnuOSLocalDiskConfig',
    '707' => 'associatePnuOSUnloadDrivers',
    '708' => 'associateBmcUnconfigPnuOS',
    '709' => 'associateNicUnconfigPnuOSLocal',
    '710' => 'associateNicUnconfigPnuOSPeer',
    '711' => 'associateSwUnconfigPnuOSLocal',
    '712' => 'associateSwUnconfigPnuOSPeer',
    '713' => 'associateSwConfigHostOSLocal',
    '714' => 'associateSwConfigHostOSPeer',
    '715' => 'associateNicConfigHostOSLocal',
    '716' => 'associateNicConfigHostOSPeer',
    '717' => 'associateHagPnuOSDisconnect',
    '718' => 'associateConfigSoL',
    '719' => 'associatePrepareForBoot',
    '720' => 'associateConfigUuid',
    '721' => 'associateBootHost',
    '722' => 'associateHagHostOSConnect',
    '723' => 'associateHostOSIdent',
    '724' => 'associateHostOSPolicy',
    '725' => 'associateHostOSValidate',
    '726' => 'associateHostOSConfig',
    '727' => 'disassociateBegin',
    '730' => 'disassociateConfigUserAccess',
    '731' => 'disassociatePowerOn',
    '732' => 'disassociatePreSanitize',
    '733' => 'disassociateSanitize',
    '734' => 'disassociateNicUnconfigHostOSLocal',
    '735' => 'disassociateNicUnconfigHostOSPeer',
    '736' => 'disassociateSwUnconfigHostOSLocal',
    '737' => 'disassociateSwUnconfigHostOSPeer',
    '738' => 'disassociateBmcPreconfigPnuOSLocal',
    '739' => 'disassociateBmcPreconfigPnuOSPeer',
    '740' => 'disassociateBmcConfigPnuOS',
    '741' => 'disassociateSwConfigPnuOSLocal',
    '742' => 'disassociateSwConfigPnuOSPeer',
    '743' => 'disassociateNicConfigPnuOSLocal',
    '744' => 'disassociateNicConfigPnuOSPeer',
    '745' => 'disassociateConfigBios',
    '746' => 'disassociateBootPnuos',
    '747' => 'disassociateBootWait',
    '748' => 'disassociateBiosPostCompletion',
    '749' => 'disassociateHagPnuOSConnect',
    '750' => 'disassociatePnuOSIdent',
    '751' => 'disassociatePnuOSPolicy',
    '752' => 'disassociatePnuOSValidate',
    '753' => 'disassociatePnuOSUnconfig',
    '754' => 'disassociatePnuOSScrub',
    '755' => 'disassociatePnuOSSelfTest',
    '756' => 'disassociateBmcUnconfigPnuOS',
    '757' => 'disassociateNicUnconfigPnuOSLocal',
    '758' => 'disassociateNicUnconfigPnuOSPeer',
    '759' => 'disassociateHagPnuOSDisconnect',
    '760' => 'disassociateUnconfigUuid',
    '761' => 'disassociateShutdown',
    '762' => 'disassociateUnconfigBios',
    '763' => 'disassociateSwUnconfigPnuOSLocal',
    '764' => 'disassociateSwUnconfigPnuOSPeer',
    '765' => 'disassociateUnconfigSoL',
    '766' => 'disassociateHandlePooling',
    '767' => 'powerCapBegin',
    '768' => 'powerCapConfig',
    '769' => 'decommissionBegin',
    '770' => 'decommissionExecute',
    '771' => 'softShutdownBegin',
    '772' => 'softShutdownExecute',
    '773' => 'hardShutdownBegin',
    '774' => 'hardShutdownExecute',
    '775' => 'turnupBegin',
    '776' => 'turnupExecute',
    '777' => 'powercycleBegin',
    '778' => 'powercyclePreSanitize',
    '779' => 'powercycleSanitize',
    '780' => 'powercycleExecute',
    '781' => 'hardresetBegin',
    '782' => 'hardresetPreSanitize',
    '783' => 'hardresetSanitize',
    '784' => 'hardresetExecute',
    '785' => 'softresetBegin',
    '786' => 'softresetPreSanitize',
    '787' => 'softresetSanitize',
    '788' => 'softresetExecute',
    '789' => 'swConnUpdBegin',
    '790' => 'swConnUpdA',
    '791' => 'swConnUpdB',
    '792' => 'biosRecoveryBegin',
    '793' => 'biosRecoveryShutdown',
    '794' => 'biosRecoveryPreSanitize',
    '795' => 'biosRecoverySanitize',
    '796' => 'biosRecoverySetupVmediaLocal',
    '797' => 'biosRecoverySetupVmediaPeer',
    '798' => 'biosRecoveryStart',
    '799' => 'biosRecoveryWait',
    '800' => 'biosRecoveryCleanup',
    '801' => 'biosRecoveryReset',
    '802' => 'biosRecoveryTeardownVmediaLocal',
    '803' => 'biosRecoveryTeardownVmediaPeer',
    '806' => 'cmosResetBegin',
    '807' => 'cmosResetPreSanitize',
    '808' => 'cmosResetSanitize',
    '809' => 'cmosResetExecute',
    '810' => 'cmosResetReconfigBios',
    '811' => 'cmosResetReconfigUuid',
    '812' => 'cmosResetBladePowerOn',
    '815' => 'resetBmcBegin',
    '816' => 'resetBmcExecute',
    '819' => 'discoverBegin',
    '820' => 'discoverBmcConfigureConnLocal',
    '821' => 'discoverSwConfigureConnLocal',
    '822' => 'discoverBmcConfigureConnPeer',
    '823' => 'discoverSwConfigureConnPeer',
    '826' => 'discoverBmcPresence',
    '827' => 'discoverBmcInventory',
    '828' => 'discoverPreSanitize',
    '829' => 'discoverSanitize',
    '830' => 'discoverConfigUserAccess',
    '831' => 'discoverSwConfigPnuOSLocal',
    '832' => 'discoverSwConfigPnuOSPeer',
    '833' => 'discoverBmcPreconfigPnuOSLocal',
    '834' => 'discoverBmcPreconfigPnuOSPeer',
    '835' => 'discoverBmcConfigPnuOS',
    '836' => 'discoverBootPnuos',
    '837' => 'discoverBootWait',
    '838' => 'discoverBiosPostCompletion',
    '839' => 'discoverReadSmbios',
    '841' => 'discoverHagConnect',
    '842' => 'discoverPnuOSIdent',
    '843' => 'discoverPnuOSPolicy',
    '844' => 'discoverPnuOSInventory',
    '845' => 'discoverPnuOSScrub',
    '846' => 'discoverPnuOSConnectivity',
    '847' => 'discoverPnuOSConnStatus',
    '848' => 'discoverSwPnuOSConnectivityLocal',
    '849' => 'discoverSwPnuOSConnectivityPeer',
    '850' => 'discoverPnuOSSelfTest',
    '851' => 'discoverBmcUnconfigPnuOS',
    '852' => 'discoverHagDisconnect',
    '853' => 'discoverBmcShutdownDiscovered',
    '854' => 'discoverHandlePooling',
    '855' => 'discoverSuccess',
    '856' => 'discoverFail',
    '879' => 'updateExtUsersBegin',
    '880' => 'updateExtUsersDeploy',
    '891' => 'updateAdaptorBegin',
    '892' => 'updateAdaptorPowerOn',
    '893' => 'updateAdaptorUpdateRequestLocal',
    '894' => 'updateAdaptorUpdateRequestPeer',
    '895' => 'updateAdaptorPollUpdateStatusLocal',
    '896' => 'updateAdaptorPollUpdateStatusPeer',
    '897' => 'updateAdaptorPowerOff',
    '898' => 'activateAdaptorBegin',
    '899' => 'activateAdaptorPowerOn',
    '900' => 'activateAdaptorActivateLocal',
    '901' => 'activateAdaptorActivatePeer',
    '902' => 'activateAdaptorReset',
    '932' => 'configSoLBegin',
    '933' => 'configSoLExecute',
    '934' => 'unconfigSoLBegin',
    '935' => 'unconfigSoLExecute',
    '940' => 'activateAdaptorFail',
    '941' => 'activateAdaptorSuccess',
    '942' => 'associateFail',
    '943' => 'associateSuccess',
    '946' => 'biosRecoveryFail',
    '947' => 'biosRecoverySuccess',
    '948' => 'cmosResetFail',
    '949' => 'cmosResetSuccess',
    '950' => 'configSoLFail',
    '951' => 'configSoLSuccess',
    '952' => 'decommissionFail',
    '953' => 'decommissionSuccess',
    '954' => 'disassociateFail',
    '955' => 'disassociateSuccess',
    '956' => 'hardShutdownFail',
    '957' => 'hardShutdownSuccess',
    '958' => 'hardresetFail',
    '959' => 'hardresetSuccess',
    '960' => 'powerCapFail',
    '961' => 'powerCapSuccess',
    '962' => 'powercycleFail',
    '963' => 'powercycleSuccess',
    '964' => 'resetBmcFail',
    '965' => 'resetBmcSuccess',
    '966' => 'softShutdownFail',
    '967' => 'softShutdownSuccess',
    '968' => 'softresetFail',
    '969' => 'softresetSuccess',
    '970' => 'swConnUpdFail',
    '971' => 'swConnUpdSuccess',
    '972' => 'turnupFail',
    '973' => 'turnupSuccess',
    '974' => 'unconfigSoLFail',
    '975' => 'unconfigSoLSuccess',
    '976' => 'updateAdaptorFail',
    '977' => 'updateAdaptorSuccess',
    '978' => 'updateExtUsersFail',
    '979' => 'updateExtUsersSuccess',
    '1019' => 'decommissionStopVMediaLocal',
    '1020' => 'decommissionStopVMediaPeer',
    '1021' => 'biosRecoveryStopVMediaLocal',
    '1022' => 'biosRecoveryStopVMediaPeer',
    '1023' => 'discoverConfigDiscoveryMode',
    '1024' => 'discoverSwUnconfigPortNivLocal',
    '1025' => 'discoverSwUnconfigPortNivPeer',
    '1027' => 'discoverSwConfigPortNivLocal',
    '1028' => 'discoverSwConfigPortNivPeer',
    '1029' => 'discoverNicInventoryLocal',
    '1030' => 'discoverNicInventoryPeer',
    '1031' => 'discoverConfigNivMode',
    '1036' => 'diagnosticInterruptBegin',
    '1037' => 'diagnosticInterruptExecute',
    '1038' => 'diagnosticInterruptFail',
    '1039' => 'diagnosticInterruptSuccess',
    '1040' => 'associateLocalDiskFwUpdate',
    '1050' => 'discoverWaitForConnReady',
    '1055' => 'resetKvmBegin',
    '1056' => 'resetKvmExecute',
    '1057' => 'resetKvmFail',
    '1058' => 'resetKvmSuccess',
    '1064' => 'offlineBegin',
    '1065' => 'offlineCleanupLocal',
    '1066' => 'offlineCleanupPeer',
    '1067' => 'offlineSwUnconfigureLocal',
    '1068' => 'offlineSwUnconfigurePeer',
    '1069' => 'associateSwConfigPortNivLocal',
    '1070' => 'associateSwConfigPortNivPeer',
    '1071' => 'disassociateSwConfigPortNivLocal',
    '1072' => 'disassociateSwConfigPortNivPeer',
    '1073' => 'offlineFail',
    '1074' => 'offlineSuccess',
    '1092' => 'discoverSolRedirectEnable',
    '1093' => 'discoverSerialDebugConnect',
    '1094' => 'discoverSerialDebugDisconnect',
    '1095' => 'discoverSolRedirectDisable',
    '1104' => 'associateSolRedirectEnable',
    '1105' => 'associateSerialDebugPnuOSConnect',
    '1106' => 'associateSerialDebugPnuOSDisconnect',
    '1107' => 'associateSolRedirectDisable',
    '1108' => 'disassociateSolRedirectEnable',
    '1109' => 'disassociateSerialDebugPnuOSConnect',
    '1110' => 'disassociateSerialDebugPnuOSDisconnect',
    '1111' => 'disassociateSolRedirectDisable',
    '1112' => 'decommissionCleanupCIMC',
    '1152' => 'updateBIOSBegin',
    '1153' => 'updateBIOSClear',
    '1154' => 'updateBIOSPollClearStatus',
    '1155' => 'updateBIOSUpdateRequest',
    '1156' => 'updateBIOSPollUpdateStatus',
    '1157' => 'activateBIOSBegin',
    '1158' => 'activateBIOSPowerOff',
    '1159' => 'activateBIOSClear',
    '1160' => 'activateBIOSPollClearStatus',
    '1161' => 'activateBIOSActivate',
    '1162' => 'activateBIOSPollActivateStatus',
    '1163' => 'activateBIOSUpdateTokens',
    '1164' => 'activateBIOSPowerOn',
    '1169' => 'associateClearBiosUpdate',
    '1170' => 'associatePollClearBiosUpdateStatus',
    '1171' => 'associateUpdateBiosRequest',
    '1172' => 'associatePollBiosUpdateStatus',
    '1173' => 'associateActivateBios',
    '1174' => 'associatePollBiosActivateStatus',
    '1175' => 'associatePnuOSCatalog',
    '1176' => 'disassociatePnuOSCatalog',
    '1177' => 'discoverPnuOSCatalog',
    '1178' => 'activateBIOSFail',
    '1179' => 'activateBIOSSuccess',
    '1180' => 'updateBIOSFail',
    '1181' => 'updateBIOSSuccess',
    '1243' => 'discoverBladePowerOff',
    '1244' => 'discoverNicConfigPnuOSLocal',
    '1245' => 'discoverNicConfigPnuOSPeer',
    '1247' => 'associateMarkAdapterForReboot',
    '1248' => 'associateDeassertResetBypass',
    '1249' => 'associateVerifyFcZoneConfig',
    '1250' => 'disassociateDeassertResetBypass',
    '1251' => 'disassociateVerifyFcZoneConfig',
    '1252' => 'decommissionCleanupPortConfigLocal',
    '1253' => 'decommissionCleanupPortConfigPeer',
    '1254' => 'resetIpmiBegin',
    '1255' => 'resetIpmiExecute',
    '1256' => 'fwUpgradeBegin',
    '1257' => 'fwUpgradeUpdateIBMCFw',
    '1258' => 'fwUpgradeWaitForIBMCFwUpdate',
    '1259' => 'fwUpgradeActivateIBMCFw',
    '1260' => 'fwUpgradeResetIBMC',
    '1261' => 'fwUpgradePreSanitize',
    '1262' => 'fwUpgradeSanitize',
    '1263' => 'fwUpgradeBladePowerOff',
    '1264' => 'fwUpgradeUpdateBoardCtrlRequest',
    '1265' => 'fwUpgradePollBoardCtrlUpdateStatus',
    '1266' => 'fwUpgradeClearBiosUpdate',
    '1267' => 'fwUpgradePollClearBiosUpdateStatus',
    '1268' => 'fwUpgradeUpdateBiosRequest',
    '1269' => 'fwUpgradePollBiosUpdateStatus',
    '1270' => 'fwUpgradeActivateBios',
    '1271' => 'fwUpgradePollBiosActivateStatus',
    '1272' => 'fwUpgradePowerOn',
    '1273' => 'fwUpgradeBmcPreconfigPnuOSLocal',
    '1274' => 'fwUpgradeBmcPreconfigPnuOSPeer',
    '1275' => 'fwUpgradeSwConfigPortNivLocal',
    '1276' => 'fwUpgradeSwConfigPortNivPeer',
    '1277' => 'fwUpgradeSwConfigPnuOSLocal',
    '1278' => 'fwUpgradeSwConfigPnuOSPeer',
    '1279' => 'fwUpgradeUpdateAdaptorNwFwLocal',
    '1280' => 'fwUpgradeUpdateAdaptorNwFwPeer',
    '1281' => 'fwUpgradeWaitForAdaptorNwFwUpdateLocal',
    '1282' => 'fwUpgradeWaitForAdaptorNwFwUpdatePeer',
    '1283' => 'fwUpgradeActivateAdaptorNwFwLocal',
    '1284' => 'fwUpgradeActivateAdaptorNwFwPeer',
    '1285' => 'fwUpgradeNicConfigPnuOSLocal',
    '1286' => 'fwUpgradeNicConfigPnuOSPeer',
    '1287' => 'fwUpgradeBmcConfigPnuOS',
    '1288' => 'fwUpgradeSolRedirectEnable',
    '1289' => 'fwUpgradeSerialDebugPnuOSConnect',
    '1290' => 'fwUpgradeBootPnuos',
    '1291' => 'fwUpgradeBootWait',
    '1292' => 'fwUpgradeBiosPostCompletion',
    '1293' => 'fwUpgradeHagPnuOSConnect',
    '1294' => 'fwUpgradePnuOSIdent',
    '1295' => 'fwUpgradePnuOSPolicy',
    '1296' => 'fwUpgradePnuOSCatalog',
    '1297' => 'fwUpgradePnuOSValidate',
    '1298' => 'fwUpgradePnuOSSelfTest',
    '1299' => 'fwUpgradeStorageCtlrImgUpdate',
    '1300' => 'fwUpgradeHbaImgUpdate',
    '1301' => 'fwUpgradeNicImgUpdate',
    '1302' => 'fwUpgradeLocalDiskFwUpdate',
    '1303' => 'fwUpgradePnuOSConfig',
    '1304' => 'fwUpgradePnuOSInventory',
    '1305' => 'fwUpgradeBiosImgUpdate',
    '1306' => 'fwUpgradePnuOSUnloadDrivers',
    '1307' => 'fwUpgradeBmcUnconfigPnuOS',
    '1308' => 'fwUpgradeNicUnconfigPnuOSLocal',
    '1309' => 'fwUpgradeNicUnconfigPnuOSPeer',
    '1310' => 'fwUpgradeSwUnconfigPnuOSLocal',
    '1311' => 'fwUpgradeSwUnconfigPnuOSPeer',
    '1312' => 'fwUpgradeHagPnuOSDisconnect',
    '1313' => 'fwUpgradeSerialDebugPnuOSDisconnect',
    '1314' => 'fwUpgradeSolRedirectDisable',
    '1315' => 'fwUpgradeShutdown',
    '1316' => 'adapterResetBegin',
    '1317' => 'adapterResetPreSanitize',
    '1318' => 'adapterResetSanitize',
    '1319' => 'adapterResetDeassertResetBypass',
    '1320' => 'adapterResetPowerCycle',
    '1361' => 'activateAdaptorDeassertResetBypass',
    '1363' => 'fwUpgradeDeassertResetBypass',
    '1385' => 'fwUpgradeFail',
    '1386' => 'fwUpgradeSuccess',
    '1387' => 'resetIpmiFail',
    '1388' => 'resetIpmiSuccess',
    '1389' => 'adapterResetFail',
    '1390' => 'adapterResetSuccess',
    '1471' => 'associateConfigFlexFlash',
    '1472' => 'associateSyncPowerState',
    '1473' => 'disassociateUnconfigFlexFlash',
    '1478' => 'cimcSessionDeleteBegin',
    '1479' => 'cimcSessionDeleteExecute',
    '1480' => 'cimcSessionDeleteFail',
    '1481' => 'cimcSessionDeleteSuccess',
    '1501' => 'associatePowerOnPreConfig',
    '1502' => 'associateOobStorageInventory',
    '1503' => 'associateSwConfigServiceInfraLocal',
    '1504' => 'associateSwConfigServiceInfraPeer',
    '1505' => 'associateNicConfigServiceInfraLocal',
    '1506' => 'associateNicConfigServiceInfraPeer',
    '1507' => 'disassociateNicUnconfigServiceInfraLocal',
    '1508' => 'disassociateNicUnconfigServiceInfraPeer',
    '1509' => 'disassociateConfigFlexFlashScrub',
    '1510' => 'createDhcpEntryBegin',
    '1511' => 'createDhcpEntryExecuteLocal',
    '1512' => 'createDhcpEntryExecutePeer',
    '1513' => 'serviceInfraDeployBegin',
    '1514' => 'serviceInfraDeploySwConfigLocal',
    '1515' => 'serviceInfraDeploySwConfigPeer',
    '1516' => 'serviceInfraDeployNicConfigLocal',
    '1517' => 'serviceInfraDeployNicConfigPeer',
    '1518' => 'serviceInfraWithdrawBegin',
    '1519' => 'serviceInfraWithdrawSwUnConfigLocal',
    '1520' => 'serviceInfraWithdrawSwUnConfigPeer',
    '1521' => 'serviceInfraWithdrawNicUnConfigLocal',
    '1522' => 'serviceInfraWithdrawNicUnConfigPeer',
    '1523' => 'discoverOobStorageInventory',
    '1524' => 'discoverConfigFlexFlashScrub',
    '1525' => 'updateBoardControllerBegin',
    '1526' => 'updateBoardControllerPrepareForUpdate',
    '1527' => 'updateBoardControllerServerPowerOff',
    '1528' => 'updateBoardControllerUpdateRequest',
    '1529' => 'updateBoardControllerPollUpdateStatus',
    '1530' => 'updateBoardControllerServerPowerOn',
    '1531' => 'configBoardBegin',
    '1532' => 'configBoardConfigMemoryPolicy',
    '1533' => 'resetMemoryErrorsBegin',
    '1534' => 'resetMemoryErrorsExecute',
    '1542' => 'configBoardFail',
    '1543' => 'configBoardSuccess',
    '1544' => 'resetMemoryErrorsFail',
    '1545' => 'resetMemoryErrorsSuccess',
    '1546' => 'serviceInfraDeployFail',
    '1547' => 'serviceInfraDeploySuccess',
    '1548' => 'serviceInfraWithdrawFail',
    '1549' => 'serviceInfraWithdrawSuccess',
    '1550' => 'updateBoardControllerFail',
    '1551' => 'updateBoardControllerSuccess',
    '1552' => 'createDhcpEntryFail',
    '1553' => 'createDhcpEntrySuccess',
    '1561' => 'disassociateResetSecureBootConfig',
    '1563' => 'discoverUnconfigExtMgmtRules',
    '1564' => 'discoverUnconfigExtMgmtGw',
    '1565' => 'discoverUnconfigCimcVMedia',
    '1569' => 'associateUnconfigExtMgmtRules',
    '1570' => 'associateUnconfigExtMgmtGw',
    '1571' => 'associateUnconfigCimcVMedia',
    '1572' => 'associateConfigExtMgmtRules',
    '1573' => 'associateConfigExtMgmtGw',
    '1574' => 'associateConfigCimcVMedia',
    '1575' => 'associateGraphicsImageUpdate',
    '1576' => 'disassociateConfigKvmMgmtDefaultSetting',
    '1577' => 'disassociateUnconfigExtMgmtRules',
    '1578' => 'disassociateUnconfigExtMgmtGw',
    '1579' => 'disassociateUnconfigCimcVMedia',
    '1580' => 'decommissionUnconfigExtMgmtRules',
    '1581' => 'decommissionUnconfigExtMgmtGw',
    '1582' => 'fwUpgradeUnconfigExtMgmtRules',
    '1583' => 'fwUpgradeUnconfigExtMgmtGw',
    '1584' => 'fwUpgradeUnconfigCimcVMedia',
    '1585' => 'fwUpgradeGraphicsImageUpdate',
    '1588' => 'associateDownloadImages',
    '1589' => 'associateCopyRemote',
    '1590' => 'fwUpgradeDownloadImages',
    '1591' => 'fwUpgradeCopyRemote',
    '1592' => 'flashControllerBegin',
    '1593' => 'flashControllerUpdateFlashLife',
    '1595' => 'flashControllerFail',
    '1596' => 'flashControllerSuccess',
    '1598' => 'associateDeleteCurlDownloadedImages',
    '1599' => 'fwUpgradeDeleteCurlDownloadedImages',
    '1611' => 'enableCimcSecureBootBegin',
    '1612' => 'enableCimcSecureBootUpdateRequest',
    '1613' => 'enableCimcSecureBootPollUpdateStatus',
    '1614' => 'enableCimcSecureBootActivate',
    '1615' => 'enableCimcSecureBootReset',
    '1620' => 'enableCimcSecureBootFail',
    '1621' => 'enableCimcSecureBootSuccess',
    '1698' => 'associateCheckPowerAvailability',
    '1699' => 'associatePowerDeployWait',
    '1700' => 'associateOobStorageConfig',
    '1701' => 'associateVerifyRemoteStorageConfig',
    '1702' => 'associateNicConfigParamsHostOSLocal',
    '1703' => 'associateNicConfigParamsHostOSPeer',
    '1704' => 'associateBmcUpdateHostPreBoot',
    '1705' => 'disassociateWaitForUnConfigAppliances',
    '1706' => 'disassociateCheckPowerAvailability',
    '1707' => 'disassociatePowerDeployWait',
    '1708' => 'turnupCheckPowerAvailability',
    '1709' => 'turnupPowerDeployWait',
    '1710' => 'powercycleCheckPowerAvailability',
    '1711' => 'powercyclePowerDeployWait',
    '1712' => 'hardresetCheckPowerAvailability',
    '1713' => 'hardresetPowerDeployWait',
    '1714' => 'softresetCheckPowerAvailability',
    '1715' => 'softresetPowerDeployWait',
    '1716' => 'biosRecoveryCheckPowerAvailability',
    '1717' => 'biosRecoveryPowerDeployWait',
    '1718' => 'cmosResetCheckPowerAvailability',
    '1719' => 'cmosResetPowerDeployWait',
    '1720' => 'fwUpgradeCheckPowerAvailability',
    '1721' => 'fwUpgradePowerDeployWait',
    '1722' => 'oobStorageAdminConfigBegin',
    '1723' => 'oobStorageAdminConfigPreSanitize',
    '1724' => 'oobStorageAdminConfigSanitize',
    '1725' => 'oobStorageAdminConfigTearDownVMediaLocal',
    '1726' => 'oobStorageAdminConfigTearDownVMediaPeer',
    '1727' => 'oobStorageAdminConfigBootHost',
    '1728' => 'oobStorageAdminConfigBootWait',
    '1729' => 'oobStorageAdminConfigOobStorageConfig',
    '1730' => 'oobStorageAdminConfigOobStorageInventory',
    '1731' => 'oobStorageAdminConfigShutdown',
    '1800' => 'activateBIOSCheckPowerAvailability',
    '1801' => 'activateBIOSPowerDeployWait',
    '1802' => 'updateAdaptorCheckPowerAvailability',
    '1803' => 'updateAdaptorPowerDeployWait',
    '1804' => 'activateAdaptorCheckPowerAvailability',
    '1805' => 'activateAdaptorPowerDeployWait',
    '1806' => 'updateBoardControllerCheckPowerAvailability',
    '1807' => 'updateBoardControllerPowerDeployWait',
    '1813' => 'oobStorageAdminConfigFail',
    '1814' => 'oobStorageAdminConfigSuccess',
    '1880' => 'associateDeleteImagesRemote',
    '1881' => 'disassociateOobDiskScrub',
    '1882' => 'fwUpgradeDeleteImagesRemote',
    '1943' => 'associateUnlockFirmwareImage',
    '1944' => 'decommissionPrecleanupPortConfig',
    '1945' => 'clearTPMBegin',
    '1946' => 'clearTPMPreSanitize',
    '1947' => 'clearTPMSanitize',
    '1948' => 'clearTPMClear',
    '1949' => 'clearTPMBootHost',
    '1950' => 'clearTPMBiosPostCompletion',
    '1951' => 'clearTPMReadSmBios',
    '1952' => 'clearTPMBladePowerOff',
    '1953' => 'clearTPMReconfigBios',
    '1954' => 'clearTPMBladePowerOn',
    '1955' => 'fwUpgradeUnlockFirmwareImage',
    '1957' => 'clearTPMFail',
    '1958' => 'clearTPMSuccess',
    '1964' => 'clearTPMStopVMediaLocal',
    '1965' => 'clearTPMStopVMediaPeer',
    '1966' => 'clearTPMSetupVmedia',
    '1967' => 'clearTPMUnconfigVmedia',
    '1968' => 'updateBoardControllerPowerCycleBoard',
    '1969' => 'updateBoardControllerPollBoardCtrlPowerCycle',
    '1970' => 'associatePowerCycleBoard',
    '1971' => 'associatePollBoardCtrlPowerCycle',
    '1972' => 'fwUpgradePowerCycleBoard',
    '1973' => 'fwUpgradePollBoardCtrlPowerCycle',
    '1978' => 'associateCalculateVlanGroupForHostOSLocal',
    '1979' => 'associateCalculateVlanGroupForHostOSPeer',
    '1998' => 'associateConfigFanSpeed',
    '1999' => 'associateSasExpanderImgUpdate',
    '2000' => 'fwUpgradeSasExpanderImgUpdate',
    '2001' => 'fwUpgradeOobStorageInventory',
    '2010' => 'discoverBmcFactoryReset',
    '2026' => 'discoverCheckPowerAvailability',
    '2027' => 'discoverPowerDeployWait',
    '2030' => 'associateOobSasExpanderImgUpdate',
    '2031' => 'associateOobPollSasExpanderUpdateStatus',
    '2032' => 'associateOobSasExpanderImgActivate',
    '2033' => 'associateOobPollSasExpanderActivateStatus',
    '2034' => 'associateCiscoOSOpenGate',
    '2037' => 'fwUpgradeOobSasExpanderImgUpdate',
    '2038' => 'fwUpgradeOobPollSasExpanderUpdateStatus',
    '2039' => 'fwUpgradeOobSasExpanderImgActivate',
    '2040' => 'fwUpgradeOobPollSasExpanderActivateStatus',
    '2041' => 'fwUpgradeCiscoOSOpenGate',
    '2043' => 'oobStorageAdminConfigCheckPowerAvailability',
    '2044' => 'oobStorageAdminConfigPowerDeployWait',
    '2045' => 'diskZoningInventoryBegin',
    '2046' => 'diskZoningInventoryPreSanitize',
    '2047' => 'diskZoningInventorySanitize',
    '2048' => 'diskZoningInventoryBootHost',
    '2049' => 'diskZoningInventoryBootWait',
    '2050' => 'diskZoningInventoryStorageInventory',
    '2051' => 'diskZoningInventoryShutdown',
    '2161' => 'diskZoningInventoryFail',
    '2162' => 'diskZoningInventorySuccess',
    '2200' => 'activateAdaptorAssertBypassWait',
    '2209' => 'diagBegin',
    '2210' => 'diagPreSanitize',
    '2211' => 'diagSanitize',
    '2212' => 'diagCheckPowerAvailability',
    '2213' => 'diagDisableScriptableVMedia',
    '2214' => 'diagPreconfigVmediaLocal',
    '2215' => 'diagPreconfigVmediaPeer',
    '2216' => 'diagSetupVmediaLocal',
    '2217' => 'diagSetupVmediaPeer',
    '2218' => 'diagSetupBootEnvironment',
    '2219' => 'diagSerialDebugConnect',
    '2220' => 'diagPowerOn',
    '2221' => 'diagPowerOnWait',
    '2222' => 'diagBiosPostCompletion',
    '2223' => 'diagHagConnect',
    '2224' => 'diagPnuOSIdent',
    '2225' => 'diagRunTests',
    '2226' => 'diagLogTransfer',
    '2227' => 'diagWaitForDebug',
    '2228' => 'diagTeardownVmediaLocal',
    '2229' => 'diagTeardownVmediaPeer',
    '2230' => 'diagHagDisconnect',
    '2231' => 'diagSerialDebugDisconnect',
    '2232' => 'diagTearDownBootEnvironment',
    '2233' => 'diagShutdown',
    '2234' => 'associatePnuOSPeripheralComponentConfig',
    '2235' => 'associateConfigMgmtIpRules',
    '2236' => 'associateAssertBypassWait',
    '2237' => 'associateHostOSConnect',
    '2238' => 'associateConfigHostOsAnnotations',
    '2239' => 'associateConfigServerIdentity',
    '2240' => 'disassociateUnconfigServerIdentity',
    '2241' => 'fwUpgradeAssertBypassWait',
    '2242' => 'cimcSecurityConfigBegin',
    '2243' => 'cimcSecurityConfigKmipCertConfig',
    '2244' => 'cimcSecurityConfigKmipSaveCert',
    '2257' => 'cimcSecurityConfigFail',
    '2258' => 'cimcSecurityConfigSuccess',
    '2259' => 'diagFail',
    '2260' => 'diagSuccess',
    '2270' => 'discoverOobStorageConfig',
    '2271' => 'associateRestoreVdStatus',
  },
  'CucsPolicyControlEpOpFsmStageName' => {
    '0' => 'nop',
    '560' => 'remoteDomainRegBegin',
    '561' => 'remoteDomainRegRegistration',
    '562' => 'remoteDomainRegPushSharedSecret',
    '563' => 'remoteDomainRegCheckStatus',
    '564' => 'remoteDomainUnRegBegin',
    '565' => 'remoteDomainUnRegUnRegistration',
    '577' => 'remoteDomainRegFail',
    '578' => 'remoteDomainRegSuccess',
    '579' => 'remoteDomainUnRegFail',
    '580' => 'remoteDomainUnRegSuccess',
  },
  'CucsStorageVDriveState' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'cacheDegraded',
    '3' => 'partiallyDegraded',
    '4' => 'degraded',
    '5' => 'offline',
    '6' => 'rebuilding',
  },
  'CucsStatsThrFloatValuePropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CucsLicenseAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricDceSwSrvPcOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsFabricCartridgeSlotEpFsmTaskItem' => {
    '0' => 'nop',
    '1874' => 'identify',
  },
  'CucsLsSPMetaSpRefresh' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot9LinkSpeed' => {
    '0' => 'platformRecommended',
    '361' => 'gen1',
    '362' => 'gen2',
    '363' => 'gen3',
    '364' => 'auto',
    '365' => 'disabled',
  },
  'CucsComputeBoardPower' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'test',
    '3' => 'off',
    '4' => 'online',
    '5' => 'offline',
    '6' => 'offduty',
    '7' => 'degraded',
    '8' => 'powerSave',
    '9' => 'error',
    '10' => 'ok',
    '11' => 'failed',
    '100' => 'notSupported',
  },
  'CucsExtpolClientFsmStageName' => {
    '0' => 'nop',
    '214' => 'updateContextFsmBegin',
    '215' => 'updateContextFsmExecute',
    '218' => 'updateContextFsmFail',
    '219' => 'updateContextFsmSuccess',
  },
  'CucsMgmtImporterPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsFirmwareInstallSpState' => {
    '0' => 'notInstalled',
    '1' => 'ready',
    '2' => 'transient',
    '3' => 'unknownInstallerBusy',
    '4' => 'active',
    '5' => 'activeCommitted',
    '6' => 'activeOnReload',
    '7' => 'activeCommittedOnReload',
    '8' => 'failed',
    '9' => 'inactive',
    '10' => 'inactiveCommitted',
    '11' => 'inactiveOnReload',
    '12' => 'inactiveCommittedOnReload',
    '100' => 'unknown',
  },
  'CucsEquipmentIOCardFsmCurrentFsm' => {
    '0' => 'nop',
    '1' => 'fePresence',
    '3' => 'feConn',
    '461' => 'resetCmc',
    '645' => 'muxOffline',
    '817' => 'resetIom',
    '1939' => 'evacuate',
    '1941' => 'resetEvacuate',
    '1980' => 'resetPeerCmc',
  },
  'CucsAaaEpFsmTaskItem' => {
    '0' => 'nop',
    '197' => 'updateEp',
  },
  'CucsSwFcUserZoneLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsStorageLocalDiskMode' => {
    '1' => 'noLocalStorage',
    '2' => 'singleDisk',
    '3' => 'dualDisk',
    '4' => 'raidStriped',
    '5' => 'raidMirrored',
    '6' => 'bestEffortMirrored',
    '7' => 'bestEffortStriped',
    '8' => 'anyConfiguration',
    '9' => 'noRaid',
    '10' => 'raidStripedParity',
    '11' => 'raidStripedDualParity',
    '12' => 'raidMirroredStriped',
    '13' => 'bestEffortStripedParity',
    '14' => 'bestEffortStripedDualParity',
    '15' => 'bestEffortMirroredStriped',
    '16' => 'raidStripedParityStriped',
    '17' => 'raidStripedDualParityStriped',
  },
  'CucsFabricFlowMonDefType' => {
    '1' => 'systemDefined',
    '2' => 'userDefined',
  },
  'CucsComputeBladeFsmStageName' => {
    '0' => 'nop',
    '23' => 'discoverBegin',
    '24' => 'discoverBmcPresence',
    '25' => 'discoverBmcInventory',
    '26' => 'discoverConfigFeLocal',
    '27' => 'discoverConfigFePeer',
    '28' => 'discoverConfigUserAccess',
    '29' => 'discoverBladePowerOn',
    '33' => 'discoverSwConfigPnuOSLocal',
    '34' => 'discoverSwConfigPnuOSPeer',
    '35' => 'discoverBladeBootPnuos',
    '36' => 'discoverBladeReadSmbios',
    '37' => 'discoverHagConnect',
    '38' => 'discoverPnuOSIdent',
    '39' => 'discoverPnuOSPolicy',
    '40' => 'discoverPnuOSInventory',
    '41' => 'discoverPnuOSSelfTest',
    '43' => 'discoverSwUnconfigPnuOSLocal',
    '44' => 'discoverSwUnconfigPnuOSPeer',
    '45' => 'discoverHagDisconnect',
    '46' => 'discoverBmcShutdownDiscovered',
    '47' => 'discoverHandlePooling',
    '48' => 'discoverSuccess',
    '49' => 'discoverFail',
    '144' => 'diagBegin',
    '145' => 'diagBmcPresence',
    '146' => 'diagBmcInventory',
    '147' => 'diagConfigFeLocal',
    '148' => 'diagConfigFePeer',
    '149' => 'diagBladePowerOn',
    '152' => 'diagDeriveConfig',
    '153' => 'diagConfigUserAccess',
    '155' => 'diagSwConfigLocal',
    '156' => 'diagSwConfigPeer',
    '158' => 'diagSetupVMediaLocal',
    '159' => 'diagSetupVMediaPeer',
    '160' => 'diagBladeBoot',
    '161' => 'diagBladeReadSmbios',
    '162' => 'diagHostConnect',
    '165' => 'diagHostIdent',
    '166' => 'diagHostPolicy',
    '167' => 'diagSetDiagUser',
    '168' => 'diagHostInventory',
    '171' => 'diagGenerateReport',
    '172' => 'diagRemoveConfig',
    '173' => 'diagRemoveVMediaLocal',
    '174' => 'diagRemoveVMediaPeer',
    '176' => 'diagSwUnconfigLocal',
    '177' => 'diagSwUnconfigPeer',
    '178' => 'diagUnconfigUserAccess',
    '180' => 'diagHostDisconnect',
    '181' => 'diagBmcShutdownDiagCompleted',
    '182' => 'diagSuccess',
    '183' => 'diagFail',
    '458' => 'discoverPnuOSScrub',
    '479' => 'diagHostServerDiag',
    '480' => 'diagHostServerDiagStatus',
    '481' => 'diagDisableServerConnSwB',
    '482' => 'diagStartFabricATrafficTest',
    '483' => 'diagFabricATrafficTestStatus',
    '484' => 'diagEnableServerConnSwB',
    '485' => 'diagDisableServerConnSwA',
    '486' => 'diagStartFabricBTrafficTest',
    '487' => 'diagFabricBTrafficTestStatus',
    '488' => 'diagEnableServerConnSwA',
    '504' => 'discoverBladeBootWait',
    '519' => 'diagBladeBootWait',
    '520' => 'diagBiosPostCompletion',
    '521' => 'discoverBiosPostCompletion',
    '526' => 'diagRestoreConfigFeLocal',
    '527' => 'diagRestoreConfigFePeer',
    '528' => 'discoverSetupVmediaLocal',
    '529' => 'discoverSetupVmediaPeer',
    '530' => 'discoverTeardownVmediaLocal',
    '531' => 'discoverTeardownVmediaPeer',
    '533' => 'diagGenerateLogWait',
    '534' => 'diagStopVMediaLocal',
    '535' => 'diagStopVMediaPeer',
    '545' => 'discoverSanitize',
    '567' => 'discoverPreSanitize',
    '591' => 'diagDebugWait',
    '599' => 'diagEvaluateStatus',
    '604' => 'updateBoardControllerBegin',
    '605' => 'updateBoardControllerBladePowerOff',
    '606' => 'updateBoardControllerUpdateRequest',
    '607' => 'updateBoardControllerPollUpdateStatus',
    '608' => 'updateBoardControllerBladePowerOn',
    '621' => 'updateBoardControllerFail',
    '622' => 'updateBoardControllerSuccess',
    '629' => 'updateBoardControllerPrepareForUpdate',
    '647' => 'diagNicPresenceLocal',
    '648' => 'diagNicPresencePeer',
    '649' => 'diagNicInventoryLocal',
    '650' => 'diagNicInventoryPeer',
    '651' => 'diagNicConfigLocal',
    '652' => 'diagNicConfigPeer',
    '653' => 'diagNicUnconfigLocal',
    '654' => 'diagNicUnconfigPeer',
    '657' => 'discoverNicPresenceLocal',
    '658' => 'discoverNicPresencePeer',
    '659' => 'discoverNicConfigPnuOSLocal',
    '660' => 'discoverNicConfigPnuOSPeer',
    '663' => 'discoverNicUnconfigPnuOSLocal',
    '664' => 'discoverNicUnconfigPnuOSPeer',
    '665' => 'associateBegin',
    '668' => 'associateUpdateIBMCFw',
    '669' => 'associateWaitForIBMCFwUpdate',
    '670' => 'associateActivateIBMCFw',
    '671' => 'associateResetIBMC',
    '672' => 'associatePreSanitize',
    '673' => 'associateSanitize',
    '674' => 'associateConfigUserAccess',
    '675' => 'associateBladePowerOff',
    '676' => 'associateUpdateBoardCtrlRequest',
    '677' => 'associatePollBoardCtrlUpdateStatus',
    '678' => 'associatePowerOn',
    '679' => 'associateBmcPreconfigPnuOSLocal',
    '680' => 'associateBmcPreconfigPnuOSPeer',
    '681' => 'associateBmcConfigPnuOS',
    '682' => 'associateSwConfigPnuOSLocal',
    '683' => 'associateSwConfigPnuOSPeer',
    '684' => 'associateUpdateAdaptorNwFwLocal',
    '685' => 'associateUpdateAdaptorNwFwPeer',
    '686' => 'associateWaitForAdaptorNwFwUpdateLocal',
    '687' => 'associateWaitForAdaptorNwFwUpdatePeer',
    '688' => 'associateActivateAdaptorNwFwLocal',
    '689' => 'associateActivateAdaptorNwFwPeer',
    '690' => 'associateNicConfigPnuOSLocal',
    '691' => 'associateNicConfigPnuOSPeer',
    '692' => 'associateBootPnuos',
    '693' => 'associateBootWait',
    '694' => 'associateBiosPostCompletion',
    '695' => 'associateHagPnuOSConnect',
    '696' => 'associatePnuOSIdent',
    '697' => 'associatePnuOSPolicy',
    '698' => 'associatePnuOSValidate',
    '699' => 'associatePnuOSSelfTest',
    '700' => 'associateBiosImgUpdate',
    '701' => 'associateStorageCtlrImgUpdate',
    '702' => 'associateHbaImgUpdate',
    '703' => 'associateNicImgUpdate',
    '704' => 'associatePnuOSInventory',
    '705' => 'associatePnuOSConfig',
    '706' => 'associatePnuOSLocalDiskConfig',
    '707' => 'associatePnuOSUnloadDrivers',
    '708' => 'associateBmcUnconfigPnuOS',
    '709' => 'associateNicUnconfigPnuOSLocal',
    '710' => 'associateNicUnconfigPnuOSPeer',
    '711' => 'associateSwUnconfigPnuOSLocal',
    '712' => 'associateSwUnconfigPnuOSPeer',
    '713' => 'associateSwConfigHostOSLocal',
    '714' => 'associateSwConfigHostOSPeer',
    '715' => 'associateNicConfigHostOSLocal',
    '716' => 'associateNicConfigHostOSPeer',
    '717' => 'associateHagPnuOSDisconnect',
    '718' => 'associateConfigSoL',
    '719' => 'associatePrepareForBoot',
    '720' => 'associateConfigUuid',
    '721' => 'associateBootHost',
    '722' => 'associateHagHostOSConnect',
    '723' => 'associateHostOSIdent',
    '724' => 'associateHostOSPolicy',
    '725' => 'associateHostOSValidate',
    '726' => 'associateHostOSConfig',
    '727' => 'disassociateBegin',
    '730' => 'disassociateConfigUserAccess',
    '731' => 'disassociatePowerOn',
    '732' => 'disassociatePreSanitize',
    '733' => 'disassociateSanitize',
    '734' => 'disassociateNicUnconfigHostOSLocal',
    '735' => 'disassociateNicUnconfigHostOSPeer',
    '736' => 'disassociateSwUnconfigHostOSLocal',
    '737' => 'disassociateSwUnconfigHostOSPeer',
    '738' => 'disassociateBmcPreconfigPnuOSLocal',
    '739' => 'disassociateBmcPreconfigPnuOSPeer',
    '740' => 'disassociateBmcConfigPnuOS',
    '741' => 'disassociateSwConfigPnuOSLocal',
    '742' => 'disassociateSwConfigPnuOSPeer',
    '743' => 'disassociateNicConfigPnuOSLocal',
    '744' => 'disassociateNicConfigPnuOSPeer',
    '745' => 'disassociateConfigBios',
    '746' => 'disassociateBootPnuos',
    '747' => 'disassociateBootWait',
    '748' => 'disassociateBiosPostCompletion',
    '749' => 'disassociateHagPnuOSConnect',
    '750' => 'disassociatePnuOSIdent',
    '751' => 'disassociatePnuOSPolicy',
    '752' => 'disassociatePnuOSValidate',
    '753' => 'disassociatePnuOSUnconfig',
    '754' => 'disassociatePnuOSScrub',
    '755' => 'disassociatePnuOSSelfTest',
    '756' => 'disassociateBmcUnconfigPnuOS',
    '757' => 'disassociateNicUnconfigPnuOSLocal',
    '758' => 'disassociateNicUnconfigPnuOSPeer',
    '759' => 'disassociateHagPnuOSDisconnect',
    '760' => 'disassociateUnconfigUuid',
    '761' => 'disassociateShutdown',
    '762' => 'disassociateUnconfigBios',
    '763' => 'disassociateSwUnconfigPnuOSLocal',
    '764' => 'disassociateSwUnconfigPnuOSPeer',
    '765' => 'disassociateUnconfigSoL',
    '766' => 'disassociateHandlePooling',
    '767' => 'powerCapBegin',
    '768' => 'powerCapConfig',
    '769' => 'decommissionBegin',
    '770' => 'decommissionExecute',
    '771' => 'softShutdownBegin',
    '772' => 'softShutdownExecute',
    '773' => 'hardShutdownBegin',
    '774' => 'hardShutdownExecute',
    '775' => 'turnupBegin',
    '776' => 'turnupExecute',
    '777' => 'powercycleBegin',
    '778' => 'powercyclePreSanitize',
    '779' => 'powercycleSanitize',
    '780' => 'powercycleExecute',
    '781' => 'hardresetBegin',
    '782' => 'hardresetPreSanitize',
    '783' => 'hardresetSanitize',
    '784' => 'hardresetExecute',
    '785' => 'softresetBegin',
    '786' => 'softresetPreSanitize',
    '787' => 'softresetSanitize',
    '788' => 'softresetExecute',
    '789' => 'swConnUpdBegin',
    '790' => 'swConnUpdA',
    '791' => 'swConnUpdB',
    '792' => 'biosRecoveryBegin',
    '793' => 'biosRecoveryShutdown',
    '794' => 'biosRecoveryPreSanitize',
    '795' => 'biosRecoverySanitize',
    '796' => 'biosRecoverySetupVmediaLocal',
    '797' => 'biosRecoverySetupVmediaPeer',
    '798' => 'biosRecoveryStart',
    '799' => 'biosRecoveryWait',
    '800' => 'biosRecoveryCleanup',
    '801' => 'biosRecoveryReset',
    '802' => 'biosRecoveryTeardownVmediaLocal',
    '803' => 'biosRecoveryTeardownVmediaPeer',
    '806' => 'cmosResetBegin',
    '807' => 'cmosResetPreSanitize',
    '808' => 'cmosResetSanitize',
    '809' => 'cmosResetExecute',
    '810' => 'cmosResetReconfigBios',
    '811' => 'cmosResetReconfigUuid',
    '812' => 'cmosResetBladePowerOn',
    '815' => 'resetBmcBegin',
    '816' => 'resetBmcExecute',
    '879' => 'updateExtUsersBegin',
    '880' => 'updateExtUsersDeploy',
    '891' => 'updateAdaptorBegin',
    '892' => 'updateAdaptorPowerOn',
    '893' => 'updateAdaptorUpdateRequestLocal',
    '894' => 'updateAdaptorUpdateRequestPeer',
    '895' => 'updateAdaptorPollUpdateStatusLocal',
    '896' => 'updateAdaptorPollUpdateStatusPeer',
    '897' => 'updateAdaptorPowerOff',
    '898' => 'activateAdaptorBegin',
    '899' => 'activateAdaptorPowerOn',
    '900' => 'activateAdaptorActivateLocal',
    '901' => 'activateAdaptorActivatePeer',
    '902' => 'activateAdaptorReset',
    '932' => 'configSoLBegin',
    '933' => 'configSoLExecute',
    '934' => 'unconfigSoLBegin',
    '935' => 'unconfigSoLExecute',
    '940' => 'activateAdaptorFail',
    '941' => 'activateAdaptorSuccess',
    '942' => 'associateFail',
    '943' => 'associateSuccess',
    '946' => 'biosRecoveryFail',
    '947' => 'biosRecoverySuccess',
    '948' => 'cmosResetFail',
    '949' => 'cmosResetSuccess',
    '950' => 'configSoLFail',
    '951' => 'configSoLSuccess',
    '952' => 'decommissionFail',
    '953' => 'decommissionSuccess',
    '954' => 'disassociateFail',
    '955' => 'disassociateSuccess',
    '956' => 'hardShutdownFail',
    '957' => 'hardShutdownSuccess',
    '958' => 'hardresetFail',
    '959' => 'hardresetSuccess',
    '960' => 'powerCapFail',
    '961' => 'powerCapSuccess',
    '962' => 'powercycleFail',
    '963' => 'powercycleSuccess',
    '964' => 'resetBmcFail',
    '965' => 'resetBmcSuccess',
    '966' => 'softShutdownFail',
    '967' => 'softShutdownSuccess',
    '968' => 'softresetFail',
    '969' => 'softresetSuccess',
    '970' => 'swConnUpdFail',
    '971' => 'swConnUpdSuccess',
    '972' => 'turnupFail',
    '973' => 'turnupSuccess',
    '974' => 'unconfigSoLFail',
    '975' => 'unconfigSoLSuccess',
    '976' => 'updateAdaptorFail',
    '977' => 'updateAdaptorSuccess',
    '978' => 'updateExtUsersFail',
    '979' => 'updateExtUsersSuccess',
    '1019' => 'decommissionStopVMediaLocal',
    '1020' => 'decommissionStopVMediaPeer',
    '1021' => 'biosRecoveryStopVMediaLocal',
    '1022' => 'biosRecoveryStopVMediaPeer',
    '1032' => 'diagCleanupServerConnSwA',
    '1033' => 'diagCleanupServerConnSwB',
    '1036' => 'diagnosticInterruptBegin',
    '1037' => 'diagnosticInterruptExecute',
    '1038' => 'diagnosticInterruptFail',
    '1039' => 'diagnosticInterruptSuccess',
    '1040' => 'associateLocalDiskFwUpdate',
    '1055' => 'resetKvmBegin',
    '1056' => 'resetKvmExecute',
    '1057' => 'resetKvmFail',
    '1058' => 'resetKvmSuccess',
    '1069' => 'associateSwConfigPortNivLocal',
    '1070' => 'associateSwConfigPortNivPeer',
    '1071' => 'disassociateSwConfigPortNivLocal',
    '1072' => 'disassociateSwConfigPortNivPeer',
    '1078' => 'discoverBmcPreConfigPnuOSLocal',
    '1079' => 'discoverBmcPreConfigPnuOSPeer',
    '1080' => 'discoverBmcConfigPnuOS',
    '1089' => 'diagBmcConfigPnuOS',
    '1096' => 'diagSolRedirectEnable',
    '1097' => 'diagSerialDebugConnect',
    '1098' => 'diagSerialDebugDisconnect',
    '1099' => 'diagSolRedirectDisable',
    '1100' => 'discoverSolRedirectEnable',
    '1101' => 'discoverSerialDebugConnect',
    '1102' => 'discoverSerialDebugDisconnect',
    '1103' => 'discoverSolRedirectDisable',
    '1104' => 'associateSolRedirectEnable',
    '1105' => 'associateSerialDebugPnuOSConnect',
    '1106' => 'associateSerialDebugPnuOSDisconnect',
    '1107' => 'associateSolRedirectDisable',
    '1108' => 'disassociateSolRedirectEnable',
    '1109' => 'disassociateSerialDebugPnuOSConnect',
    '1110' => 'disassociateSerialDebugPnuOSDisconnect',
    '1111' => 'disassociateSolRedirectDisable',
    '1112' => 'decommissionCleanupCIMC',
    '1152' => 'updateBIOSBegin',
    '1153' => 'updateBIOSClear',
    '1154' => 'updateBIOSPollClearStatus',
    '1155' => 'updateBIOSUpdateRequest',
    '1156' => 'updateBIOSPollUpdateStatus',
    '1157' => 'activateBIOSBegin',
    '1158' => 'activateBIOSPowerOff',
    '1159' => 'activateBIOSClear',
    '1160' => 'activateBIOSPollClearStatus',
    '1161' => 'activateBIOSActivate',
    '1162' => 'activateBIOSPollActivateStatus',
    '1163' => 'activateBIOSUpdateTokens',
    '1164' => 'activateBIOSPowerOn',
    '1167' => 'diagHostCatalog',
    '1168' => 'discoverPnuOSCatalog',
    '1169' => 'associateClearBiosUpdate',
    '1170' => 'associatePollClearBiosUpdateStatus',
    '1171' => 'associateUpdateBiosRequest',
    '1172' => 'associatePollBiosUpdateStatus',
    '1173' => 'associateActivateBios',
    '1174' => 'associatePollBiosActivateStatus',
    '1175' => 'associatePnuOSCatalog',
    '1176' => 'disassociatePnuOSCatalog',
    '1178' => 'activateBIOSFail',
    '1179' => 'activateBIOSSuccess',
    '1180' => 'updateBIOSFail',
    '1181' => 'updateBIOSSuccess',
    '1246' => 'discoverCheckPowerAvailability',
    '1247' => 'associateMarkAdapterForReboot',
    '1248' => 'associateDeassertResetBypass',
    '1249' => 'associateVerifyFcZoneConfig',
    '1250' => 'disassociateDeassertResetBypass',
    '1251' => 'disassociateVerifyFcZoneConfig',
    '1252' => 'decommissionCleanupPortConfigLocal',
    '1253' => 'decommissionCleanupPortConfigPeer',
    '1254' => 'resetIpmiBegin',
    '1255' => 'resetIpmiExecute',
    '1256' => 'fwUpgradeBegin',
    '1257' => 'fwUpgradeUpdateIBMCFw',
    '1258' => 'fwUpgradeWaitForIBMCFwUpdate',
    '1259' => 'fwUpgradeActivateIBMCFw',
    '1260' => 'fwUpgradeResetIBMC',
    '1261' => 'fwUpgradePreSanitize',
    '1262' => 'fwUpgradeSanitize',
    '1263' => 'fwUpgradeBladePowerOff',
    '1264' => 'fwUpgradeUpdateBoardCtrlRequest',
    '1265' => 'fwUpgradePollBoardCtrlUpdateStatus',
    '1266' => 'fwUpgradeClearBiosUpdate',
    '1267' => 'fwUpgradePollClearBiosUpdateStatus',
    '1268' => 'fwUpgradeUpdateBiosRequest',
    '1269' => 'fwUpgradePollBiosUpdateStatus',
    '1270' => 'fwUpgradeActivateBios',
    '1271' => 'fwUpgradePollBiosActivateStatus',
    '1272' => 'fwUpgradePowerOn',
    '1273' => 'fwUpgradeBmcPreconfigPnuOSLocal',
    '1274' => 'fwUpgradeBmcPreconfigPnuOSPeer',
    '1275' => 'fwUpgradeSwConfigPortNivLocal',
    '1276' => 'fwUpgradeSwConfigPortNivPeer',
    '1277' => 'fwUpgradeSwConfigPnuOSLocal',
    '1278' => 'fwUpgradeSwConfigPnuOSPeer',
    '1279' => 'fwUpgradeUpdateAdaptorNwFwLocal',
    '1280' => 'fwUpgradeUpdateAdaptorNwFwPeer',
    '1281' => 'fwUpgradeWaitForAdaptorNwFwUpdateLocal',
    '1282' => 'fwUpgradeWaitForAdaptorNwFwUpdatePeer',
    '1283' => 'fwUpgradeActivateAdaptorNwFwLocal',
    '1284' => 'fwUpgradeActivateAdaptorNwFwPeer',
    '1285' => 'fwUpgradeNicConfigPnuOSLocal',
    '1286' => 'fwUpgradeNicConfigPnuOSPeer',
    '1287' => 'fwUpgradeBmcConfigPnuOS',
    '1288' => 'fwUpgradeSolRedirectEnable',
    '1289' => 'fwUpgradeSerialDebugPnuOSConnect',
    '1290' => 'fwUpgradeBootPnuos',
    '1291' => 'fwUpgradeBootWait',
    '1292' => 'fwUpgradeBiosPostCompletion',
    '1293' => 'fwUpgradeHagPnuOSConnect',
    '1294' => 'fwUpgradePnuOSIdent',
    '1295' => 'fwUpgradePnuOSPolicy',
    '1296' => 'fwUpgradePnuOSCatalog',
    '1297' => 'fwUpgradePnuOSValidate',
    '1298' => 'fwUpgradePnuOSSelfTest',
    '1299' => 'fwUpgradeStorageCtlrImgUpdate',
    '1300' => 'fwUpgradeHbaImgUpdate',
    '1301' => 'fwUpgradeNicImgUpdate',
    '1302' => 'fwUpgradeLocalDiskFwUpdate',
    '1303' => 'fwUpgradePnuOSConfig',
    '1304' => 'fwUpgradePnuOSInventory',
    '1305' => 'fwUpgradeBiosImgUpdate',
    '1306' => 'fwUpgradePnuOSUnloadDrivers',
    '1307' => 'fwUpgradeBmcUnconfigPnuOS',
    '1308' => 'fwUpgradeNicUnconfigPnuOSLocal',
    '1309' => 'fwUpgradeNicUnconfigPnuOSPeer',
    '1310' => 'fwUpgradeSwUnconfigPnuOSLocal',
    '1311' => 'fwUpgradeSwUnconfigPnuOSPeer',
    '1312' => 'fwUpgradeHagPnuOSDisconnect',
    '1313' => 'fwUpgradeSerialDebugPnuOSDisconnect',
    '1314' => 'fwUpgradeSolRedirectDisable',
    '1315' => 'fwUpgradeShutdown',
    '1361' => 'activateAdaptorDeassertResetBypass',
    '1363' => 'fwUpgradeDeassertResetBypass',
    '1385' => 'fwUpgradeFail',
    '1386' => 'fwUpgradeSuccess',
    '1387' => 'resetIpmiFail',
    '1388' => 'resetIpmiSuccess',
    '1471' => 'associateConfigFlexFlash',
    '1472' => 'associateSyncPowerState',
    '1473' => 'disassociateUnconfigFlexFlash',
    '1478' => 'cimcSessionDeleteBegin',
    '1479' => 'cimcSessionDeleteExecute',
    '1480' => 'cimcSessionDeleteFail',
    '1481' => 'cimcSessionDeleteSuccess',
    '1499' => 'discoverOobStorageInventory',
    '1500' => 'discoverConfigFlexFlashScrub',
    '1501' => 'associatePowerOnPreConfig',
    '1502' => 'associateOobStorageInventory',
    '1503' => 'associateSwConfigServiceInfraLocal',
    '1504' => 'associateSwConfigServiceInfraPeer',
    '1505' => 'associateNicConfigServiceInfraLocal',
    '1506' => 'associateNicConfigServiceInfraPeer',
    '1507' => 'disassociateNicUnconfigServiceInfraLocal',
    '1508' => 'disassociateNicUnconfigServiceInfraPeer',
    '1509' => 'disassociateConfigFlexFlashScrub',
    '1513' => 'serviceInfraDeployBegin',
    '1514' => 'serviceInfraDeploySwConfigLocal',
    '1515' => 'serviceInfraDeploySwConfigPeer',
    '1516' => 'serviceInfraDeployNicConfigLocal',
    '1517' => 'serviceInfraDeployNicConfigPeer',
    '1518' => 'serviceInfraWithdrawBegin',
    '1519' => 'serviceInfraWithdrawSwUnConfigLocal',
    '1520' => 'serviceInfraWithdrawSwUnConfigPeer',
    '1521' => 'serviceInfraWithdrawNicUnConfigLocal',
    '1522' => 'serviceInfraWithdrawNicUnConfigPeer',
    '1527' => 'updateBoardControllerServerPowerOff',
    '1530' => 'updateBoardControllerServerPowerOn',
    '1531' => 'configBoardBegin',
    '1532' => 'configBoardConfigMemoryPolicy',
    '1533' => 'resetMemoryErrorsBegin',
    '1534' => 'resetMemoryErrorsExecute',
    '1542' => 'configBoardFail',
    '1543' => 'configBoardSuccess',
    '1544' => 'resetMemoryErrorsFail',
    '1545' => 'resetMemoryErrorsSuccess',
    '1546' => 'serviceInfraDeployFail',
    '1547' => 'serviceInfraDeploySuccess',
    '1548' => 'serviceInfraWithdrawFail',
    '1549' => 'serviceInfraWithdrawSuccess',
    '1561' => 'disassociateResetSecureBootConfig',
    '1566' => 'discoverUnconfigExtMgmtRules',
    '1567' => 'discoverUnconfigExtMgmtGw',
    '1568' => 'discoverUnconfigCimcVMedia',
    '1569' => 'associateUnconfigExtMgmtRules',
    '1570' => 'associateUnconfigExtMgmtGw',
    '1571' => 'associateUnconfigCimcVMedia',
    '1572' => 'associateConfigExtMgmtRules',
    '1573' => 'associateConfigExtMgmtGw',
    '1574' => 'associateConfigCimcVMedia',
    '1575' => 'associateGraphicsImageUpdate',
    '1576' => 'disassociateConfigKvmMgmtDefaultSetting',
    '1577' => 'disassociateUnconfigExtMgmtRules',
    '1578' => 'disassociateUnconfigExtMgmtGw',
    '1579' => 'disassociateUnconfigCimcVMedia',
    '1580' => 'decommissionUnconfigExtMgmtRules',
    '1581' => 'decommissionUnconfigExtMgmtGw',
    '1582' => 'fwUpgradeUnconfigExtMgmtRules',
    '1583' => 'fwUpgradeUnconfigExtMgmtGw',
    '1584' => 'fwUpgradeUnconfigCimcVMedia',
    '1585' => 'fwUpgradeGraphicsImageUpdate',
    '1588' => 'associateDownloadImages',
    '1589' => 'associateCopyRemote',
    '1590' => 'fwUpgradeDownloadImages',
    '1591' => 'fwUpgradeCopyRemote',
    '1592' => 'flashControllerBegin',
    '1593' => 'flashControllerUpdateFlashLife',
    '1595' => 'flashControllerFail',
    '1596' => 'flashControllerSuccess',
    '1598' => 'associateDeleteCurlDownloadedImages',
    '1599' => 'fwUpgradeDeleteCurlDownloadedImages',
    '1611' => 'enableCimcSecureBootBegin',
    '1612' => 'enableCimcSecureBootUpdateRequest',
    '1613' => 'enableCimcSecureBootPollUpdateStatus',
    '1614' => 'enableCimcSecureBootActivate',
    '1615' => 'enableCimcSecureBootReset',
    '1620' => 'enableCimcSecureBootFail',
    '1621' => 'enableCimcSecureBootSuccess',
    '1692' => 'discoverConfigBMCPowerParams',
    '1694' => 'discoverPowerDeployWait',
    '1695' => 'discoverPnuOSPowerProfiling',
    '1696' => 'discoverSendBmcProfilingInit',
    '1697' => 'discoverSendBmcProfilingDone',
    '1698' => 'associateCheckPowerAvailability',
    '1699' => 'associatePowerDeployWait',
    '1700' => 'associateOobStorageConfig',
    '1701' => 'associateVerifyRemoteStorageConfig',
    '1702' => 'associateNicConfigParamsHostOSLocal',
    '1703' => 'associateNicConfigParamsHostOSPeer',
    '1704' => 'associateBmcUpdateHostPreBoot',
    '1705' => 'disassociateWaitForUnConfigAppliances',
    '1706' => 'disassociateCheckPowerAvailability',
    '1707' => 'disassociatePowerDeployWait',
    '1708' => 'turnupCheckPowerAvailability',
    '1709' => 'turnupPowerDeployWait',
    '1710' => 'powercycleCheckPowerAvailability',
    '1711' => 'powercyclePowerDeployWait',
    '1712' => 'hardresetCheckPowerAvailability',
    '1713' => 'hardresetPowerDeployWait',
    '1714' => 'softresetCheckPowerAvailability',
    '1715' => 'softresetPowerDeployWait',
    '1716' => 'biosRecoveryCheckPowerAvailability',
    '1717' => 'biosRecoveryPowerDeployWait',
    '1718' => 'cmosResetCheckPowerAvailability',
    '1719' => 'cmosResetPowerDeployWait',
    '1720' => 'fwUpgradeCheckPowerAvailability',
    '1721' => 'fwUpgradePowerDeployWait',
    '1722' => 'oobStorageAdminConfigBegin',
    '1723' => 'oobStorageAdminConfigPreSanitize',
    '1724' => 'oobStorageAdminConfigSanitize',
    '1725' => 'oobStorageAdminConfigTearDownVMediaLocal',
    '1726' => 'oobStorageAdminConfigTearDownVMediaPeer',
    '1727' => 'oobStorageAdminConfigBootHost',
    '1728' => 'oobStorageAdminConfigBootWait',
    '1729' => 'oobStorageAdminConfigOobStorageConfig',
    '1730' => 'oobStorageAdminConfigOobStorageInventory',
    '1731' => 'oobStorageAdminConfigShutdown',
    '1800' => 'activateBIOSCheckPowerAvailability',
    '1801' => 'activateBIOSPowerDeployWait',
    '1802' => 'updateAdaptorCheckPowerAvailability',
    '1803' => 'updateAdaptorPowerDeployWait',
    '1804' => 'activateAdaptorCheckPowerAvailability',
    '1805' => 'activateAdaptorPowerDeployWait',
    '1806' => 'updateBoardControllerCheckPowerAvailability',
    '1807' => 'updateBoardControllerPowerDeployWait',
    '1813' => 'oobStorageAdminConfigFail',
    '1814' => 'oobStorageAdminConfigSuccess',
    '1880' => 'associateDeleteImagesRemote',
    '1881' => 'disassociateOobDiskScrub',
    '1882' => 'fwUpgradeDeleteImagesRemote',
    '1943' => 'associateUnlockFirmwareImage',
    '1944' => 'decommissionPrecleanupPortConfig',
    '1945' => 'clearTPMBegin',
    '1946' => 'clearTPMPreSanitize',
    '1947' => 'clearTPMSanitize',
    '1948' => 'clearTPMClear',
    '1949' => 'clearTPMBootHost',
    '1950' => 'clearTPMBiosPostCompletion',
    '1951' => 'clearTPMReadSmBios',
    '1952' => 'clearTPMBladePowerOff',
    '1953' => 'clearTPMReconfigBios',
    '1954' => 'clearTPMBladePowerOn',
    '1955' => 'fwUpgradeUnlockFirmwareImage',
    '1957' => 'clearTPMFail',
    '1958' => 'clearTPMSuccess',
    '1964' => 'clearTPMStopVMediaLocal',
    '1965' => 'clearTPMStopVMediaPeer',
    '1966' => 'clearTPMSetupVmedia',
    '1967' => 'clearTPMUnconfigVmedia',
    '1968' => 'updateBoardControllerPowerCycleBoard',
    '1969' => 'updateBoardControllerPollBoardCtrlPowerCycle',
    '1970' => 'associatePowerCycleBoard',
    '1971' => 'associatePollBoardCtrlPowerCycle',
    '1972' => 'fwUpgradePowerCycleBoard',
    '1973' => 'fwUpgradePollBoardCtrlPowerCycle',
    '1977' => 'discoverCheckAdaptorFw40GCap',
    '1978' => 'associateCalculateVlanGroupForHostOSLocal',
    '1979' => 'associateCalculateVlanGroupForHostOSPeer',
    '1998' => 'associateConfigFanSpeed',
    '1999' => 'associateSasExpanderImgUpdate',
    '2000' => 'fwUpgradeSasExpanderImgUpdate',
    '2001' => 'fwUpgradeOobStorageInventory',
    '2011' => 'discoverBmcFactoryReset',
    '2029' => 'discoverPostScrubOobStorageInventory',
    '2030' => 'associateOobSasExpanderImgUpdate',
    '2031' => 'associateOobPollSasExpanderUpdateStatus',
    '2032' => 'associateOobSasExpanderImgActivate',
    '2033' => 'associateOobPollSasExpanderActivateStatus',
    '2034' => 'associateCiscoOSOpenGate',
    '2037' => 'fwUpgradeOobSasExpanderImgUpdate',
    '2038' => 'fwUpgradeOobPollSasExpanderUpdateStatus',
    '2039' => 'fwUpgradeOobSasExpanderImgActivate',
    '2040' => 'fwUpgradeOobPollSasExpanderActivateStatus',
    '2041' => 'fwUpgradeCiscoOSOpenGate',
    '2043' => 'oobStorageAdminConfigCheckPowerAvailability',
    '2044' => 'oobStorageAdminConfigPowerDeployWait',
    '2045' => 'diskZoningInventoryBegin',
    '2046' => 'diskZoningInventoryPreSanitize',
    '2047' => 'diskZoningInventorySanitize',
    '2048' => 'diskZoningInventoryBootHost',
    '2049' => 'diskZoningInventoryBootWait',
    '2050' => 'diskZoningInventoryStorageInventory',
    '2051' => 'diskZoningInventoryShutdown',
    '2161' => 'diskZoningInventoryFail',
    '2162' => 'diskZoningInventorySuccess',
    '2200' => 'activateAdaptorAssertBypassWait',
    '2210' => 'diagPreSanitize',
    '2211' => 'diagSanitize',
    '2212' => 'diagCheckPowerAvailability',
    '2213' => 'diagDisableScriptableVMedia',
    '2214' => 'diagPreconfigVmediaLocal',
    '2215' => 'diagPreconfigVmediaPeer',
    '2216' => 'diagSetupVmediaLocal',
    '2217' => 'diagSetupVmediaPeer',
    '2218' => 'diagSetupBootEnvironment',
    '2220' => 'diagPowerOn',
    '2221' => 'diagPowerOnWait',
    '2223' => 'diagHagConnect',
    '2224' => 'diagPnuOSIdent',
    '2225' => 'diagRunTests',
    '2226' => 'diagLogTransfer',
    '2227' => 'diagWaitForDebug',
    '2228' => 'diagTeardownVmediaLocal',
    '2229' => 'diagTeardownVmediaPeer',
    '2230' => 'diagHagDisconnect',
    '2232' => 'diagTearDownBootEnvironment',
    '2233' => 'diagShutdown',
    '2234' => 'associatePnuOSPeripheralComponentConfig',
    '2235' => 'associateConfigMgmtIpRules',
    '2236' => 'associateAssertBypassWait',
    '2237' => 'associateHostOSConnect',
    '2238' => 'associateConfigHostOsAnnotations',
    '2239' => 'associateConfigServerIdentity',
    '2240' => 'disassociateUnconfigServerIdentity',
    '2241' => 'fwUpgradeAssertBypassWait',
    '2242' => 'cimcSecurityConfigBegin',
    '2243' => 'cimcSecurityConfigKmipCertConfig',
    '2244' => 'cimcSecurityConfigKmipSaveCert',
    '2257' => 'cimcSecurityConfigFail',
    '2258' => 'cimcSecurityConfigSuccess',
    '2271' => 'associateRestoreVdStatus',
  },
  'CucsEquipmentBeaconLedState' => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'blinking',
    '4' => 'eth',
    '5' => 'fc',
  },
  'CucsBiosVfInterleaveConfigurationVpChannelInterleaving' => {
    '0' => 'platformRecommended',
    '301' => 'auto',
    '302' => 'n1Way',
    '303' => 'n2Way',
    '304' => 'n3Way',
    '305' => 'n4Way',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot6State' => {
    '0' => 'platformRecommended',
    '266' => 'disabled',
    '267' => 'enabled',
    '455' => 'uefiOnly',
    '456' => 'legacyOnly',
  },
  'CucsGlDomainOperState' => {
    '0' => 'notEvaluated',
    '1' => 'fetchingVnets',
    '2' => 'fetchingVnetsDone',
    '3' => 'fetchingDependencies',
    '4' => 'fetchingDependenciesDone',
    '5' => 'completed',
  },
  'CucsLicenseScope' => {
    '1' => 'a',
    '2' => 'b',
    '3' => 'server',
    '4' => 'unknown',
  },
  'CucsDiagBladeTestType' => {
    '0' => 'disk',
    '1' => 'processor',
    '2' => 'memory',
    '3' => 'memtest',
    '4' => 'stress',
    '5' => 'pci',
  },
  'CucsBiosVfEnhancedPowerCappingSupportVpEnhancedPowerCapping' => {
    '0' => 'platformRecommended',
    '495' => 'disabled',
    '496' => 'enabled',
  },
  'CucsVnicTemplateType' => {
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CucsComputeChassisDiscPolicyMulticastHwHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsVnicVnicBehPolicyType' => {
    '1' => 'vnic',
    '2' => 'vhba',
  },
  'CucsIpIpV4StaticAddrPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CucsFabricFcZoneSharingMode' => {
    '0' => 'coalesce',
    '1' => 'clearUnmanagedZoneActive',
    '2' => 'clearUnmanagedZoneAll',
  },
  'CucsStorageFFCardSizeMismatch' => {
    '0' => 'na',
    '1' => 'mismatch',
    '2' => 'match',
  },
  'CucsStatsThermalEndpoint' => {
    '0' => 'servers',
  },
  'CucsTopInfoSyncPolicyState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsOsEthBondModeActiveBackupType' => {
    '0' => 'activePassive',
    '1' => 'activeActive',
  },
  'CucsCommSnmpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfIOEMezz1OptionROMVpIOEMezz1OptionROM' => {
    '0' => 'platformRecommended',
    '588' => 'disabled',
    '589' => 'enabled',
    '590' => 'uefiOnly',
    '591' => 'legacyOnly',
  },
  'CucsTopInfoPolicyState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsIppoolNetBIOSMode' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsBiosVfIntelEntrySASRAIDModuleVpSASRAID' => {
    '0' => 'platformRecommended',
    '154' => 'disabled',
    '155' => 'enabled',
  },
  'CucsHostagEvent' => {
    '0' => 'none',
  },
  'CucsLsbootLocalDiskImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsMemoryNvDimmHealth' => {
    '0' => 'unknown',
    '1' => 'notPresent',
    '2' => 'healthy',
    '3' => 'hardwareFault',
    '4' => 'softwareFault',
    '5' => 'batteryFault',
  },
  'CucsNetworkElementFsmCurrentFsm' => {
    '0' => 'nop',
    '35' => 'updateElement',
  },
  'CucsPowerBudgetFanSpeed' => {
    '0' => 'lowPower',
    '1' => 'balanced',
    '2' => 'performance',
    '3' => 'highPower',
    '4' => 'maxPower',
    '5' => 'na',
    '6' => 'err',
    '7' => 'noUpdate',
    '8' => 'notSupported',
    '9' => 'any',
  },
  'CucsFirmwareTriggerState' => {
    '0' => 'triggered',
    '1' => 'trigger',
    '2' => 'forceTrigger',
  },
  'CucsFabricSnoopingType' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CucsFabricExternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricCdpLinkPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFirmwareActivityServersPowerState' => {
    '0' => 'none',
    '1' => 'on',
    '2' => 'off',
    '3' => 'offNowait',
  },
  'CucsSwFcServerZoneGroupLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsMessageSeverity' => {
    '0' => 'emergency',
    '1' => 'alert',
    '2' => 'critical',
    '3' => 'error',
    '4' => 'warning',
    '5' => 'notification',
    '6' => 'information',
    '7' => 'debugging',
  },
  'CucsBiosVfDDR3VoltageSelectionVpDDR3VoltageSelection' => {
    '0' => 'platformRecommended',
    '511' => 'ddr31500mv',
    '512' => 'ddr31350mv',
  },
  'CucsFirmwareSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '1362' => 'deploy',
    '1378' => 'applyCatalogPack',
  },
  'CucsSwEthLanFlowMonFsmTaskItem' => {
    '0' => 'nop',
    '1537' => 'deploy',
  },
  'CucsEquipmentBeaconLedFsmCurrentFsm' => {
    '0' => 'nop',
    '1135' => 'illuminate',
  },
  'CucsFabricFcSanUplinkTrunking' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsSysdebugTechSupportAdminState' => {
    '0' => 'init',
    '1' => 'start',
    '2' => 'created',
    '3' => 'prepareDownload',
    '4' => 'delete',
  },
  'CucsQosclassEthBEDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CucsSwFcSanBorderFsmTaskItem' => {
    '0' => 'nop',
    '226' => 'deploy',
    '1185' => 'activateZoneSet',
  },
  'CucsOrgOrgFsmTaskItem' => {
    '0' => 'nop',
    '5' => 'configure',
    '291' => 'configurePeer',
  },
  'CucsNetworkLimitType' => {
    '0' => 'unicastMac',
    '1' => 'multicastMac',
    '2' => 'pvLifVlanMbr',
    '3' => 'pvSystem',
    '4' => 'igmpGroup',
  },
  'CucsVnicPortProfileType' => {
    '0' => 'regular',
    '1' => 'slaOnly',
  },
  'CucsGmetaCategory' => {
    '0' => 'unknown',
    '1' => 'inventory',
  },
  'CucsConfigNetRefType' => {
    '0' => 'all',
    '1' => 'classic',
    '2' => 'aci',
  },
  'CucsBiosVfExecuteDisableBitVpExecuteDisableBit' => {
    '0' => 'platformRecommended',
    '10' => 'disabled',
    '11' => 'enabled',
  },
  'CucsOsEthBondModeBroadcastType' => {
    '0' => 'activePassive',
    '1' => 'activeActive',
  },
  'CucsPortEthAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CucsCommTelnetAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsLstorageDiskSlotOwnership' => {
    '0' => 'unknown',
    '1' => 'unassigned',
    '2' => 'dedicated',
    '3' => 'shared',
    '4' => 'chassisGlobalSpare',
    '5' => 'chassisDedicatedSpare',
  },
  'CucsPolicyControlEpFsmCurrentFsm' => {
    '0' => 'nop',
    '1199' => 'operate',
  },
  'CucsComputeScrubAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsVmLifeCyclePolicyFsmStageName' => {
    '0' => 'nop',
    '1132' => 'configBegin',
    '1133' => 'configLocal',
    '1134' => 'configPeer',
    '1146' => 'configFail',
    '1147' => 'configSuccess',
  },
  'CucsCommSyslogSourceAudits' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricFcSanPcOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsVnicConnectionLcCtrlState' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsStorageProcessorFsmCurrentFsm' => {
    '0' => 'nop',
    '1636' => 'discoverSystem',
    '1644' => 'enterMaintenance',
    '1649' => 'exitMaintenance',
    '1654' => 'deploySystem',
    '1663' => 'undeploySystem',
    '1675' => 'haTakeOver',
  },
  'CucsBiosVfQPISnoopModeVpQPISnoopMode' => {
    '0' => 'platformRecommended',
    '487' => 'homeSnoop',
    '488' => 'clusterOnDie',
    '489' => 'earlySnoop',
    '548' => 'auto',
    '549' => 'homeDirectorySnoop',
    '550' => 'homeDirectorySnoopWithOsb',
  },
  'CucsMgmtBackupPolicyFsmStageName' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopyBegin',
    '1188' => 'reportConfigCopyReport',
    '1411' => 'reportConfigCopyFail',
    '1412' => 'reportConfigCopySuccess',
  },
  'CucsFabricFcMonOperationOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'error',
  },
  'CucsFabricFcMonDestEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsCommCoreFileProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsComputeStorageScrubType' => {
    '0' => 'unknown',
    '1' => 'noScrub',
    '2' => 'scrub',
  },
  'CucsStorageEpAccess' => {
    '1' => 'readonly',
    '2' => 'admin',
  },
  'CucsVmSwitchAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsStorageRemoteVirtualDriveRefAdminActionTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'online',
    '4' => 'undeployed',
  },
  'CucsEquipmentSlotArrayOrientation' => {
    '0' => 'unknown',
    '1' => 'vertical',
    '2' => 'horizontal',
  },
  'CucsLsbootLocalHddImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsStorageControllerPinnedCacheStatus' => {
    '0' => 'unknown',
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfMaximumMemoryBelow4GBVpMaximumMemoryBelow4GB' => {
    '0' => 'platformRecommended',
    '54' => 'disabled',
    '55' => 'enabled',
  },
  'CucsBiosVfIOENVMe1OptionROMVpIOENVMe1OptionROM' => {
    '0' => 'platformRecommended',
    '596' => 'disabled',
    '597' => 'enabled',
    '598' => 'uefiOnly',
    '599' => 'legacyOnly',
  },
  'CucsPoolPoolableOwner' => {
    '0' => 'endPoint',
    '1' => 'pool',
  },
  'CucsMgmtIfFsmTaskItem' => {
    '0' => 'nop',
    '277' => 'swMgmtOobIfConfig',
    '279' => 'swMgmtInbandIfConfig',
    '281' => 'virtualIfConfig',
    '284' => 'enableVip',
    '286' => 'disableVip',
    '288' => 'enableHA',
    '1907' => 'faPresence',
    '1910' => 'faConn',
  },
  'CucsDupeChangeTrackerEpFsmTaskItem' => {
    '0' => 'nop',
    '395' => 'configure',
  },
  'CucsCapabilityCatalogueFsmTaskItem' => {
    '0' => 'nop',
    '839' => 'deployCatalogue',
    '893' => 'activateCatalog',
  },
  'CucsLstorageConfigState' => {
    '0' => 'ok',
    '1' => 'applied',
    '2' => 'failedToApply',
    '3' => 'applying',
  },
  'CucsStorageLocalDiskFsmCurrentFsm' => {
    '0' => 'nop',
    '2156' => 'updateLocalDisk',
  },
  'CucsVnicOrderScheme' => {
    '0' => 'zeroFuncAll',
    '1' => 'multiFuncAll',
    '2' => 'staticZeroFunc',
  },
  'CucsDomainType' => {
    '0' => 'instance',
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CucsLsServerFsmTaskItem' => {
    '0' => 'nop',
    '965' => 'configure',
  },
  'CucsFabricBHVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CucsEquipmentServiceState' => {
    '1' => 'inService',
    '2' => 'outOfService',
    '3' => 'inMaintenance',
  },
  'CucsComputeServerUnitFsmTaskItem' => {
    '0' => 'nop',
    '1885' => 'discover',
  },
  'CucsLsServerFsmStageName' => {
    '0' => 'nop',
    '350' => 'configureResolveStaticIdentifiers',
    '351' => 'configureApplyThrottle',
    '358' => 'configureConsumerVxanDeployment',
    '359' => 'configureWaitForConsumerReceivingVxan',
    '381' => 'configureDeleteIdConsumerMap',
    '382' => 'configureProcessIdConsumerMap',
    '392' => 'configureApplyRename',
    '415' => 'configureThrottleWait',
    '416' => 'configureEvaluateServerAssign',
    '418' => 'configureReplaceIdAcquirer',
    '627' => 'configureResolveDomainGroupPolicies',
    '628' => 'configureWaitForDomainGroupPolicies',
    '857' => 'configureBegin',
    '858' => 'configureApplyTemplate',
    '859' => 'configureApplyIdentifiers',
    '860' => 'configureApplyPolicies',
    '861' => 'configureResolveBootConfig',
    '862' => 'configureEvaluateAssociation',
    '863' => 'configureAnalyzeImpact',
    '864' => 'configureWaitForMaintPermission',
    '865' => 'configureWaitForMaintWindow',
    '866' => 'configureApplyConfig',
    '1002' => 'configureFail',
    '1003' => 'configureSuccess',
    '1321' => 'configureResolveIdentifiers',
    '1322' => 'configureApplyDefaultIdentifiers',
    '1323' => 'configureResolveDefaultIdentifiers',
    '1324' => 'configureResolvePolicies',
    '1325' => 'configureResolveDistributableNames',
    '1326' => 'configureResolveDistributable',
    '1327' => 'configureResolveImages',
    '1328' => 'configureResolveSchedule',
    '1329' => 'configureProvisionStorage',
    '1330' => 'configureWaitForStorageProvision',
    '1331' => 'configureCommitStorage',
    '1332' => 'configureWaitForCommitStorage',
    '1333' => 'configureWaitForAssocCompletion',
    '1468' => 'configureResolveNetworkPolicies',
    '1469' => 'configureResolveNetworkTemplates',
    '1470' => 'configureValidatePolicyOwnership',
    '1616' => 'configureCheckAssignedIdentifiersForDup',
    '1617' => 'configureCheckAssignedDefaultIdentifiersForDup',
    '1742' => 'configureResolveStorageSchedule',
    '1743' => 'configureResolveVolumes',
    '1982' => 'configureApplyMaintConfig',
    '2245' => 'configureEstimateApplyConfig',
  },
  'CucsNetworkPhysEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsFabricEthPortOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsEquipmentChassisPowerOperState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'failed',
    '3' => 'inputFailed',
    '4' => 'inputDegraded',
    '5' => 'outputFailed',
    '6' => 'outputDegraded',
    '7' => 'redundancyFailed',
    '8' => 'redundancyDegraded',
  },
  'CucsStorageEthLifSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsFabricFcoeSanEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsBiosVfOnboardStorageVpOnboardSCUStorageSupport' => {
    '0' => 'platformRecommended',
    '252' => 'disabled',
    '253' => 'enabled',
  },
  'CucsStorageFlexFlashControllerFsmCurrentFsm' => {
    '0' => 'nop',
    '1605' => 'mopsReset',
    '1607' => 'mopsFormat',
    '1609' => 'mopsPair',
  },
  'CucsSwConfigStatus' => {
    '1' => 'none',
    '2' => 'noVlanComp',
  },
  'CucsStorageFFDriveType' => {
    '0' => 'unknown',
    '1' => 'scu',
    '2' => 'huu',
    '3' => 'hv',
    '4' => 'drivers',
  },
  'CucsAdaptorHostIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CucsFabricLanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsCommSyslogConsoleAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsEquipmentChassisProfileConfigState' => {
    '0' => 'notApplied',
    '1' => 'applying',
    '2' => 'failedToApply',
    '3' => 'applied',
  },
  'CucsLsbootEFIShellType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsPortPIoFsmStageName' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresenceBegin',
    '1015' => 'inCompatSfpPresenceShutdown',
    '1034' => 'inCompatSfpPresenceFail',
    '1035' => 'inCompatSfpPresenceSuccess',
    '1334' => 'inCompatSfpReplacedBegin',
    '1335' => 'inCompatSfpReplacedEnablePort',
    '1461' => 'inCompatSfpReplacedFail',
    '1462' => 'inCompatSfpReplacedSuccess',
  },
  'CucsBiosVfLvDIMMSupportVpLvDDRMode' => {
    '0' => 'platformRecommended',
    '138' => 'powerSavingMode',
    '139' => 'performanceMode',
    '443' => 'auto',
  },
  'CucsPortGroupType' => {
    '1' => 'switchEther',
    '4' => 'switchFc',
    '8' => 'host',
    '16' => 'fabric',
    '32' => 'fabricPc',
    '64' => 'hostPc',
    '128' => 'adaptorExt',
    '256' => 'adaptorPc',
    '512' => 'serverPc',
  },
  'CucsFabricFcSanEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsMoIpV6AddrKvType' => {
    '0' => 'keyValue',
    '1' => 'ipv4Addr',
    '2' => 'ipv6Addr',
    '3' => 'vlan',
    '4' => 'vnic',
  },
  'CucsAdaptorCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsNetworkElementFsmTaskItem' => {
    '0' => 'nop',
    '35' => 'updateElement',
  },
  'CucsSmartlicenseHolderFsmTaskItem' => {
    '0' => 'nop',
    '487' => 'configure',
    '530' => 'updateState',
  },
  'CucsPowerOperState' => {
    '0' => 'notCapped',
    '3' => 'discoveryRetry',
    '6' => 'nonCompliant',
    '7' => 'firmwareMismatch',
    '8' => 'discoveryBudgeted',
    '9' => 'unbudgeted',
    '10' => 'budgeting',
    '11' => 'budgeted',
    '12' => 'deploying',
    '13' => 'deployed',
  },
  'CucsSysdebugExportStatus' => {
    '1' => 'success',
    '2' => 'failure',
  },
  'CucsIdentMetaSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '1338' => 'sync',
    '1618' => 'ucscUnivSync',
  },
  'CucsExtpolConnectorNwState' => {
    '0' => 'connected',
    '1' => 'lostConnectivity',
  },
  'CucsPowerChThrAction' => {
    '0' => 'nothing',
    '1' => 'throttleBladeDisc',
    '2' => 'stopBladeDisc',
  },
  'CucsEtherSwitchIntFIoPcMulticastHwHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsVmLifeCyclePolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1132' => 'config',
  },
  'CucsBiosVfUSBConfigurationVpXHCIMode' => {
    '0' => 'platformRecommended',
    '477' => 'disabled',
    '478' => 'enabled',
  },
  'CucsExtpolConnectorOperState' => {
    '0' => 'unregistered',
    '1' => 'lostVisibility',
    '2' => 'registering',
    '3' => 'synchronizing',
    '4' => 'registered',
    '5' => 'versionMismatch',
    '6' => 'registryNotReachable',
  },
  'CucsVnicVlanGroupUpdate' => {
    '0' => 'na',
    '1' => 'vlanGroupUpdate',
  },
  'CucsFabricFlowMonitoringCategoryAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsSwFcZoneMemberLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsLsConfigState' => {
    '0' => 'notApplied',
    '1' => 'applying',
    '2' => 'failedToApply',
    '3' => 'applied',
  },
  'CucsEquipmentActiveStatus' => {
    '0' => 'unknown',
    '1' => 'activated',
    '2' => 'deactivated',
  },
  'CucsSysdebugLogExportPolicyFsmTaskItem' => {
    '0' => 'nop',
    '1600' => 'configure',
  },
  'CucsAaaTacacsPlusEpFsmStageName' => {
    '0' => 'nop',
    '197' => 'updateEpBegin',
    '198' => 'updateEpSetEpLocal',
    '199' => 'updateEpSetEpPeer',
    '322' => 'updateEpFail',
    '323' => 'updateEpSuccess',
  },
  'CucsComputePowerSyncOption' => {
    '0' => 'default',
    '1' => 'alwaysSync',
    '2' => 'neverSync',
  },
  'CucsCimcvmediaMountConfigRetryOnMountFail' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsEquipmentSwitchIOCardFsmCurrentFsm' => {
    '0' => 'nop',
    '1732' => 'fePresence',
    '1736' => 'feConn',
    '2002' => 'evacuate',
    '2004' => 'resetEvacuate',
  },
  'CucsAaaEpAccess' => {
    '1' => 'readonly',
    '2' => 'admin',
  },
  'CucsEquipmentAsicType' => {
    '0' => 'unknown',
    '1' => 'gatos',
    '2' => 'carmel',
    '3' => 'trident2',
  },
  'CucsComputePciCapOrder' => {
    '0' => 'ascending',
    '1' => 'descending',
    '2' => 'ascendingDual',
    '3' => 'ascendingSeq',
    '4' => 'ascendingExtended',
  },
  'CucsTestingServiceProfileFsmTaskItem' => {
    '0' => 'nop',
    '46' => 'resolvePolicyFsm',
    '48' => 'resolveManyPolicyFsm',
  },
  'CucsExtvmmNetworkSetsFsmCurrentFsm' => {
    '0' => 'nop',
    '1539' => 'deploy',
  },
  'CucsVmLifeCyclePolicyFsmTaskItem' => {
    '0' => 'nop',
    '1142' => 'config',
  },
  'CucsQosclassDefinitionFsmStageName' => {
    '0' => 'nop',
    '313' => 'configGlobalQoSBegin',
    '314' => 'configGlobalQoSSetLocal',
    '315' => 'configGlobalQoSSetPeer',
    '430' => 'configGlobalQoSFail',
    '431' => 'configGlobalQoSSuccess',
    '2256' => 'configGlobalQoSWaitForUserAck',
  },
  'CucsSmartlicenseConfigState' => {
    '0' => 'disabled',
    '1' => 'enabled',
    '2' => 'registering',
    '3' => 'registered',
    '4' => 'registerfailed',
  },
  'CucsSysdebugLogControlDomainEnum' => {
    '0' => 'sysmgmt',
  },
  'CucsEquipmentXcvrType' => {
    '0' => 'unknown',
    '1' => 'h10gcu1m',
    '2' => 'h10gcu3m',
    '3' => 'h10gcu5m',
    '4' => 'h10gcu7m',
    '5' => 'h10gusr',
    '6' => 'h10glrmsm',
    '7' => 'cwdm1471',
    '8' => 'cwdm1531',
    '9' => 'cwdm1551',
    '10' => 'fet',
    '11' => 'sfp',
    '12' => 'x2',
    '13' => 'n10gbasesr',
    '14' => 'n10gbaselr',
    '15' => 'n10gbaselrm',
    '16' => 'n10gbaseer',
    '17' => 'h10gacu1m',
    '18' => 'h10gacu3m',
    '19' => 'h10gacu5m',
    '20' => 'h10gacu7m',
    '21' => 'h10gacu10m',
    '22' => 'h10gacu15m',
    '23' => 'qsfp40gsr4',
    '24' => 'qsfph40gcu1m',
    '25' => 'qsfph40gcu2m',
    '26' => 'qsfph40gcu3m',
    '27' => 'qsfph40gcu5m',
    '28' => 'qsfp40gcr4',
    '29' => 'qsfp40glr4',
    '30' => 'qsfp4sfp10gcu1m',
    '31' => 'qsfp4sfp10gcu3m',
    '32' => 'qsfp4sfp10gcu5m',
    '33' => 'qsfp4x10gac1m',
    '34' => 'qsfp4x10gac3m',
    '35' => 'qsfp4x10gac5m',
    '36' => 'qsfp4x10gac7m',
    '37' => 'qsfp4x10gac10m',
    '38' => 'qsfploop',
    '39' => 'qsfph40gacu1m',
    '40' => 'qsfph40gacu3m',
    '41' => 'qsfph40gacu5m',
    '42' => 'qsfph40gacu7m',
    '43' => 'qsfph40gacu10m',
    '44' => 'qsfp4x10glr',
    '45' => 'qsfp40gcsr4',
    '46' => 'qsfpqsa',
    '47' => 'qsfp4sfp10gcu2m',
    '48' => 'qsfp40gfet',
    '49' => 'qsfp40gsrbd',
    '50' => 'qsfph40gaoc1m',
    '51' => 'qsfph40gaoc2m',
    '52' => 'qsfph40gaoc3m',
    '53' => 'qsfph40gaoc5m',
    '54' => 'qsfph40gaoc7m',
    '55' => 'qsfph40gaoc10m',
    '56' => 'qsfph40gaocunknown',
    '57' => 'qsfp4x10ga0c1m',
    '58' => 'qsfp4x10ga0c2m',
    '59' => 'qsfp4x10ga0c3m',
    '60' => 'qsfp4x10ga0c5m',
    '61' => 'qsfp4x10ga0c7m',
    '62' => 'qsfp4x10ga0c10m',
    '63' => 'qsfp4x10ga0cunknown',
    '64' => 'qsfpunknown',
    '65' => 'qsfph40gaoc15m',
    '66' => 'n1000basesx',
    '67' => 'n1000baselx',
    '68' => 'n1000baselh',
    '69' => 'n1000basevx',
    '70' => 'n1000basezx',
    '71' => 'n1000basecx',
    '72' => 'n1000basex',
    '73' => 'n1000baset',
    '74' => 'n1000baseunknown',
    '192' => 'h10gacuaoc1m',
    '193' => 'h10gacuaoc2m',
    '194' => 'h10gacuaoc3m',
    '195' => 'h10gacuaoc5m',
    '196' => 'h10gacuaoc7m',
    '197' => 'h10gacuaoc10m',
    '198' => 'h10gacuaoc15m',
    '199' => 'h10gaoc1m',
    '200' => 'h10gaoc2m',
    '201' => 'h10gaoc3m',
    '202' => 'h10gaoc5m',
    '203' => 'h10gaoc7m',
    '204' => 'h10gaoc10m',
    '205' => 'h10gcu2m',
    '206' => 'h10gcu10m',
    '207' => 'n10gbasezr',
    '208' => 'dwdmsfp',
  },
  'CucsAdaptorMenloStatsIndex' => {
    '0' => 'unknown',
    '1' => 'n0',
    '2' => 'n1',
    '3' => 'n0A',
    '4' => 'n0B',
    '5' => 'n1A',
    '6' => 'n1B',
  },
  'CucsConsumerInstFsmStageName' => {
    '0' => 'nop',
    '185' => 'renameCfgDirBegin',
    '202' => 'renameCfgDirFail',
    '203' => 'renameCfgDirSuccess',
    '334' => 'renameCfgDirMoveCfgDirsToTmpLocation',
    '335' => 'renameCfgDirMoveCfgDirsFromTmpLocation',
  },
  'CucsBiosDefaultAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsStoragePartitionFsmStageName' => {
    '0' => 'nop',
    '1630' => 'deployStorageBegin',
    '1631' => 'deployStorageConfigDisk',
    '1632' => 'deployStorageConfigLun',
    '1633' => 'deployStorageVerifyConfig',
    '1634' => 'deployStorageVerifySnapshotConfig',
    '1635' => 'deployStorageVerifyReplicationConfig',
    '1677' => 'scrubRAIDGroupBegin',
    '1678' => 'scrubRAIDGroupPerformErase',
    '1679' => 'scrubRAIDGroupWaitForEraseCompletion',
    '1829' => 'deployStorageFail',
    '1830' => 'deployStorageSuccess',
    '1831' => 'scrubRAIDGroupFail',
    '1832' => 'scrubRAIDGroupSuccess',
  },
  'CucsBiosBootDevOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
    '6' => 'n6',
    '7' => 'n7',
  },
  'CucsHcAdminState' => {
    '0' => 'enable',
    '1' => 'disable',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot10State' => {
    '0' => 'platformRecommended',
    '290' => 'disabled',
    '291' => 'enabled',
    '292' => 'uefiOnly',
    '293' => 'legacyOnly',
  },
  'CucsHcDownloadPolicyType' => {
    '0' => 'cisco',
    '1' => 'local',
  },
  'CucsBiosVfBootOptionRetryVpBootOptionRetry' => {
    '0' => 'platformRecommended',
    '96' => 'disabled',
    '97' => 'enabled',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot1LinkSpeed' => {
    '0' => 'platformRecommended',
    '321' => 'gen1',
    '322' => 'gen2',
    '323' => 'gen3',
    '324' => 'auto',
    '325' => 'disabled',
  },
  'CucsLstorageAdminState' => {
    '1' => 'online',
    '2' => 'offline',
    '4' => 'undeployed',
  },
  'CucsFabricAVlanSharing' => {
    '0' => 'none',
    '1' => 'primary',
    '2' => 'isolated',
    '3' => 'community',
  },
  'CucsComputeOpType' => {
    '0' => 'unknown',
    '1' => 'backup',
  },
  'CucsComputeRackUnitFsmCurrentFsm' => {
    '0' => 'nop',
    '665' => 'associate',
    '727' => 'disassociate',
    '767' => 'powerCap',
    '769' => 'decommission',
    '771' => 'softShutdown',
    '773' => 'hardShutdown',
    '775' => 'turnup',
    '777' => 'powercycle',
    '781' => 'hardreset',
    '785' => 'softreset',
    '789' => 'swConnUpd',
    '792' => 'biosRecovery',
    '806' => 'cmosReset',
    '815' => 'resetBmc',
    '819' => 'discover',
    '879' => 'updateExtUsers',
    '891' => 'updateAdaptor',
    '898' => 'activateAdaptor',
    '932' => 'configSoL',
    '934' => 'unconfigSoL',
    '1036' => 'diagnosticInterrupt',
    '1055' => 'resetKvm',
    '1064' => 'offline',
    '1152' => 'updateBIOS',
    '1157' => 'activateBIOS',
    '1254' => 'resetIpmi',
    '1256' => 'fwUpgrade',
    '1316' => 'adapterReset',
    '1478' => 'cimcSessionDelete',
    '1510' => 'createDhcpEntry',
    '1513' => 'serviceInfraDeploy',
    '1518' => 'serviceInfraWithdraw',
    '1525' => 'updateBoardController',
    '1531' => 'configBoard',
    '1533' => 'resetMemoryErrors',
    '1592' => 'flashController',
    '1611' => 'enableCimcSecureBoot',
    '1722' => 'oobStorageAdminConfig',
    '1945' => 'clearTPM',
    '2045' => 'diskZoningInventory',
    '2209' => 'diag',
    '2242' => 'cimcSecurityConfig',
  },
  'CucsAaaSessionState' => {
    '0' => 'active',
    '1' => 'inactive',
  },
  'CucsEquipmentLedOperState' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'off',
    '3' => 'blinking',
    '4' => 'eth',
    '5' => 'fc',
    '6' => 'unsupported',
  },
  'CucsGlEvaluationState' => {
    '0' => 'notEvaluated',
    '1' => 'evaluating',
    '2' => 'evaluated',
  },
  'CucsConfigConsumerCatalogueFsmStageName' => {
    '0' => 'nop',
    '181' => 'deleteBegin',
    '182' => 'deleteLocal',
    '200' => 'deleteFail',
    '201' => 'deleteSuccess',
    '332' => 'createBegin',
    '333' => 'createMakeCfgDirs',
    '342' => 'createFail',
    '343' => 'createSuccess',
  },
  'CucsVnicAScsiIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsChangeEpFsmCurrentFsm' => {
    '0' => 'nop',
    '369' => 'syncChangeUCS',
  },
  'CucsCallhomeInventoryStatus' => {
    '0' => 'invDefault',
    '1' => 'invEnable',
    '2' => 'invInProgress',
    '3' => 'invThrottled',
  },
  'CucsFsmFsmStageStatus' => {
    '0' => 'fail',
    '1' => 'success',
    '2' => 'skip',
    '3' => 'pending',
    '4' => 'inProgress',
    '5' => 'throttled',
    '255' => 'nop',
  },
  'CucsComputeHwChangeDiscPolicyAction' => {
    '0' => 'userAcknowledged',
    '1' => 'autoAcknowledged',
  },
  'CucsFeatureSupportabilityType' => {
    '0' => 'supported',
    '1' => 'notSupported',
    '2' => 'deprecated',
  },
  'CucsLsbootStorageAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsCommSyslogSourceFaults' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricCartridgeSlotEpFsmStageName' => {
    '0' => 'nop',
    '1874' => 'identifyBegin',
    '1875' => 'identifyExecuteLocal',
    '1876' => 'identifyExecutePeer',
    '1917' => 'identifyFail',
    '1918' => 'identifySuccess',
  },
  'CucsEtherUserRecoveryOperation' => {
    '0' => 'none',
    '1' => 'reset',
  },
  'CucsFabricUdldLinkPolicyMode' => {
    '0' => 'normal',
    '1' => 'aggressive',
  },
  'CucsAaaUserEpFsmStageName' => {
    '0' => 'nop',
    '203' => 'updateUserEpBegin',
    '204' => 'updateUserEpSetUserLocal',
    '205' => 'updateUserEpSetUserPeer',
    '326' => 'updateUserEpFail',
    '327' => 'updateUserEpSuccess',
  },
  'CucsBiosVfScrubPoliciesVpDemandScrub' => {
    '0' => 'platformRecommended',
    '415' => 'disabled',
    '416' => 'enabled',
  },
  'CucsFabricFcSourceType' => {
    '1' => 'vhba',
    '2' => 'uplinkPort',
    '3' => 'vsan',
    '4' => 'storage',
    '5' => 'portChannel',
  },
  'CucsLsServerFsmCurrentFsm' => {
    '0' => 'nop',
    '857' => 'configure',
  },
  'CucsStorageReplicationCtxLunCfgAction' => {
    '0' => 'triggered',
    '1' => 'delete',
    '2' => 'online',
    '3' => 'offline',
    '10' => 'restore',
  },
  'CucsAdaptorAdapterStatsTrafficDir' => {
    '0' => 'unknown',
    '1' => 'tx',
    '2' => 'rx',
  },
  'CucsNetworkIfStatus' => {
    '0' => 'unknown',
    '1' => 'down',
    '2' => 'up',
  },
  'CucsVnicIfOperState' => {
    '0' => 'indeterminate',
    '1' => 'up',
    '2' => 'down',
    '4' => 'failed',
  },
  'CucsIdentIdentRequestFsmCurrentFsm' => {
    '0' => 'nop',
    '1336' => 'updateIdent',
  },
  'CucsStorageOperatingModeType' => {
    '0' => 'unknown',
    '1' => 'mirror',
    '2' => 'util',
  },
  'CucsEquipmentDeviceType' => {
    '0' => 'unknown',
    '1' => 'broadcom57712Nic',
    '2' => 'broadcomNic',
    '3' => 'emulexNic',
    '4' => 'intelNic',
    '5' => 'pciEverestNic',
    '6' => 'pciIntelX520Nic',
    '7' => 'pciMPCiscoNic',
    '8' => 'pciNianticNic',
    '9' => 'qlogicNic',
    '10' => 'menloEmulexHba',
    '11' => 'menloQlogicFcHba',
    '12' => 'mezzDublinQlogicFcHba',
    '13' => 'mezzSchulzQlogicFcHba',
    '14' => 'mezzTigerSharkHba',
    '15' => 'pciDublinQlogicFcHba',
    '16' => 'pciQlogic8362FcHba',
    '17' => 'pciSchulzQlogicFcHba',
    '18' => 'pciTigerSharkHba',
    '19' => 'fusionHba',
    '20' => 'intelICH10RHba',
    '21' => 'lsi1064EHba',
    '22' => 'lsi1068EHba',
    '23' => 'lsiExternalMegaRaidHba',
    '24' => 'lsimegaRaid3008',
    '25' => 'lsiMegaRaidHba',
    '26' => 'lsiWalnutCreekHba',
    '27' => 'lodiHba',
    '28' => 'sataHba',
    '29' => 'nvmeHba',
    '30' => 'wellsburgHba',
    '31' => 'nvmeMezz',
    '32' => 'qlogicFC',
    '33' => 'emulexFC',
    '34' => 'pciIntelX550Nic',
    '35' => 'lagunaBeach',
    '36' => 'lagunaBeachPlus',
    '37' => 'lagunaRock',
    '38' => 'lagunaRockPlus',
    '39' => 'lewisburgPSata',
    '40' => 'lewisburgSSataSwRaid',
    '41' => 'talladega',
    '42' => 'pciIntelX710Nic',
    '43' => 'pciQlogicBigBear',
  },
  'CucsBiosVfOnboardSATAControllerVpOnboardSATAController' => {
    '0' => 'platformRecommended',
    '38' => 'disabled',
    '39' => 'enabled',
  },
  'CucsStorageProcessorFsmTaskItem' => {
    '0' => 'nop',
    '1636' => 'discoverSystem',
    '1644' => 'enterMaintenance',
    '1649' => 'exitMaintenance',
    '1654' => 'deploySystem',
    '1663' => 'undeploySystem',
    '1675' => 'haTakeOver',
  },
  'CucsNetworkOperLevelNumPrimaryVlansStatus' => {
    '0' => 'withinLimit',
    '1' => 'aboveLimit',
  },
  'CucsCallhomeAlertGroup' => {
    '0' => 'diagnostic',
    '1' => 'environmental',
    '100' => 'unknown',
  },
  'CucsCallhomeAlertThrottlingAdminState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsBiosVfConsistentDeviceNameControlVpCDNControl' => {
    '0' => 'platformRecommended',
    '530' => 'disabled',
    '531' => 'enabled',
  },
  'CucsComputeAdminPowerState' => {
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
    '4' => 'hardResetImmediate',
    '5' => 'hardResetWait',
    '12' => 'cmosResetImmediate',
    '13' => 'bmcResetImmediate',
    '14' => 'bmcResetWait',
    '15' => 'diagnosticInterrupt',
    '16' => 'kvmReset',
    '30' => 'policy',
    '31' => 'adminUp',
    '32' => 'adminDown',
    '33' => 'ipmiReset',
  },
  'CucsFabricDceSwSrvPcOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsVnicHostNwIOPerfPref' => {
    '0' => 'none',
    '1' => 'highPerfReqd',
  },
  'CucsNfsExportDefFsmTaskItem' => {
    '0' => 'nop',
    '338' => 'imageSync',
    '340' => 'addRepo',
  },
  'CucsStorageSnapshotAdminState' => {
    '0' => 'undefined',
    '1' => 'create',
    '2' => 'createLunReplica',
    '3' => 'setReplicationOnline',
    '4' => 'setReplicationOffline',
    '5' => 'replicationRestore',
    '6' => 'abortReplication',
  },
  'CucsSysdebugManualCoreFileExportTargetFsmCurrentFsm' => {
    '0' => 'nop',
    '214' => 'export',
  },
  'CucsFlowctrlPriorityPause' => {
    '0' => 'auto',
    '1' => 'on',
  },
  'CucsBiosVfAssertNMIOnSERRVpAssertNMIOnSERR' => {
    '0' => 'platformRecommended',
    '66' => 'disabled',
    '67' => 'enabled',
  },
  'CucsFabricEstcPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsGlPolicyGlAction' => {
    '0' => 'noAction',
    '1' => 'changeDefaultToGlobalDefault',
    '2' => 'policyConflict',
  },
  'CucsMoVnicKvType' => {
    '0' => 'keyValue',
    '1' => 'ipv4Addr',
    '2' => 'ipv6Addr',
    '3' => 'vlan',
    '4' => 'vnic',
  },
  'CucsBiosSupportedAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsMgmtDataImporterFsmTaskItem' => {
    '0' => 'nop',
    '27' => 'importData',
  },
  'CucsPolicyResumeAckState' => {
    '0' => 'noAck',
    '1' => 'acked',
    '2' => 'remoteTrigger',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpPCIeSlotHBAOptionROM' => {
    '0' => 'platformRecommended',
    '463' => 'disabled',
    '464' => 'enabled',
    '465' => 'uefiOnly',
    '466' => 'legacyOnly',
  },
  'CucsFirmwareUpgradeStatus' => {
    '0' => 'unknown',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'success',
    '4' => 'warnings',
    '5' => 'skipped',
  },
  'CucsAdaptorOffloadMethod' => {
    '0' => 'virtual',
    '1' => 'physical',
    '2' => 'none',
  },
  'CucsFabricNetGroupSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsFabricSubGroupConfigState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsHcGenerationStatus' => {
    '0' => 'notStarted',
    '1' => 'inProgress',
    '2' => 'success',
    '3' => 'failed',
  },
  'CucsVnicRedundancyPairType' => {
    '1' => 'none',
    '2' => 'primary',
    '3' => 'secondary',
  },
  'CucsLstorageBootDevice' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFcpoolInitiatorEpPurpose' => {
    '0' => 'portWwn',
    '1' => 'nodeWwn',
  },
  'CucsObserveObservedFsmCurrentFsm' => {
    '0' => 'nop',
    '1341' => 'resolvePolicyFsm',
    '1343' => 'resolveResourceFsm',
    '1345' => 'resolveVMFsm',
    '1347' => 'resolveControllerFsm',
  },
  'CucsEquipmentFexFsmTaskItem' => {
    '0' => 'nop',
    '887' => 'removeFex',
  },
  'CucsStatsThr32DefinitionPropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CucsIqnpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsLstorageUpgradeState' => {
    '0' => 'unknown',
    '1' => 'partnerUpgrading',
    '2' => 'configureVmedia',
    '3' => 'bootingController',
    '4' => 'packageInstallation',
    '5' => 'unconfigureVmedia',
    '6' => 'ready',
  },
  'CucsAdaptorExtIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivity',
  },
  'CucsEquipmentAdminActionType' => {
    '0' => 'unspecified',
    '1' => 'clearConfig',
  },
  'CucsBiosVfEnergyPerformanceTuningVpPwrPerfTuning' => {
    '0' => 'platformRecommended',
    '568' => 'os',
    '569' => 'bios',
  },
  'CucsSwFcoeSanEpUdldMode' => {
    '0' => 'normal',
    '1' => 'aggressive',
  },
  'CucsMgmtImporterProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsFabricEthMonOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsSwAccessDomainFsmTaskItem' => {
    '0' => 'nop',
    '222' => 'deploy',
  },
  'CucsNfsPurpose' => {
    '0' => 'image',
    '1' => 'backup',
  },
  'CucsExtvmmOwnership' => {
    '1' => 'discovered',
    '2' => 'managed',
  },
  'CucsCallhomePolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsMgmtBackupFsmCurrentFsm' => {
    '0' => 'nop',
    '290' => 'backup',
  },
  'CucsFabricDceSwSrvPcAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsVmComputeEpClInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CucsMgmtCfgExportPolicyFsmStageName' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopyBegin',
    '1188' => 'reportConfigCopyReport',
    '1411' => 'reportConfigCopyFail',
    '1412' => 'reportConfigCopySuccess',
  },
  'CucsMgmtEntityHaReadiness' => {
    '0' => 'unknown',
    '1' => 'ready',
    '2' => 'downgraded',
    '3' => 'notReady',
  },
  'CucsCommSnmpProtocol' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsTestingServiceProfileFsmStageName' => {
    '0' => 'nop',
    '46' => 'resolvePolicyFsmBegin',
    '47' => 'resolvePolicyFsmResolve',
    '48' => 'resolveManyPolicyFsmBegin',
    '49' => 'resolveManyPolicyFsmResolveMany',
    '175' => 'resolveManyPolicyFsmFail',
    '176' => 'resolveManyPolicyFsmSuccess',
    '177' => 'resolvePolicyFsmFail',
    '178' => 'resolvePolicyFsmSuccess',
  },
  'CucsEquipmentApply' => {
    '1' => 'onAssociation',
    '2' => 'runTime',
  },
  'CucsExtpolEpFsmCurrentFsm' => {
    '0' => 'nop',
    '1193' => 'repairCert',
    '1349' => 'registerFsm',
  },
  'CucsVnicAIpcIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsDiagSrvCtrlType' => {
    '1' => 'full',
    '33' => 'efi',
  },
  'CucsSysdebugTSCmdOptMajorType' => {
    '0' => 'chassis',
    '1' => 'fex',
    '2' => 'server',
    '3' => 'ucsm',
    '4' => 'ucsmMgmt',
    '5' => 'serverMemory',
  },
  'CucsFcpoolInitiatorsMaxPortsPerNode' => {
    '3' => 'upto3',
    '7' => 'upto7',
    '15' => 'upto15',
    '31' => 'upto31',
    '63' => 'upto63',
  },
  'CucsConditionCallHomeCause' => {
    '0' => 'unspecified',
    '1' => 'equipmentInoperable',
    '2' => 'thermalProblem',
    '3' => 'connectivityProblem',
    '4' => 'licenseGraceperiodExpired',
    '5' => 'mgmtifDown',
    '6' => 'linkDown',
    '7' => 'electionFailure',
    '8' => 'managementServicesFailure',
    '9' => 'managementServicesUnresponsive',
    '10' => 'versionIncompatible',
    '11' => 'identityUnestablishable',
    '12' => 'equipmentInaccessible',
    '13' => 'configurationFailure',
    '14' => 'associationFailed',
    '15' => 'powerProblem',
    '16' => 'equipmentProblem',
    '17' => 'voltageProblem',
    '18' => 'fruProblem',
    '19' => 'equipmentDisabled',
    '20' => 'limitReached',
    '21' => 'equipmentOffline',
    '22' => 'inventoryFailed',
    '23' => 'portFailed',
    '24' => 'vifIdsMismatch',
    '25' => 'arpTargetsConfigError',
    '26' => 'equipmentDegraded',
    '27' => 'ndiscTargetsConfigError',
    '28' => 'adaptorMismatch',
    '29' => 'healthLedAmberBlinking',
    '30' => 'healthLedAmber',
    '31' => 'nearMaxLimit',
    '32' => 'memoryError',
    '33' => 'capacityProblem',
    '34' => 'healthProblem',
    '35' => 'invalidControllerProfileCount',
    '36' => 'equipmentRemoved',
    '37' => 'psuInsufficient',
    '38' => 'psuMixedMode',
    '39' => 'smallVolumeSpace',
    '40' => 'noVolumeSpace',
    '41' => 'raidgroupOffline',
    '42' => 'raidgroupDegraded',
    '43' => 'raidgroupRebuilding',
    '44' => 'raidgroupBad',
    '45' => 'adminStateOffline',
    '46' => 'cimcBackupTriggerNotEnabled',
    '47' => 'cimcHeartbeatTimedOut',
    '48' => 'notSupported',
    '49' => 'equipmentMissing',
    '50' => 'configurationMismatch',
    '51' => 'kernelMemCriticalThreshold',
    '52' => 'fanRemoval',
    '53' => 'healthCritical',
    '58' => 'healthMajor',
    '59' => 'equipmentDeprecated',
    '60' => 'equipmentUnhealthy',
    '61' => 'imageUnusable',
    '62' => 'equipmentUnacknowledged',
    '63' => 'backplanePortProblem',
    '64' => 'pciConfigIssue',
    '65' => 'fabricEvacuated',
    '66' => 'mgmtDbCorruption',
    '67' => 'hardwareMismatch',
    '68' => 'chassisIntrusion',
    '69' => 'configProblem',
    '70' => 'hardwareInventoryMismatch',
    '71' => 'pciConfigMismatch',
  },
  'CucsFabricFcSanEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsEquipmentChassisProfileFsmCurrentFsm' => {
    '0' => 'nop',
    '566' => 'configure',
  },
  'CucsComputePollReadinessState' => {
    '1' => 'initializing',
    '2' => 'timedout',
    '3' => 'ready',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot3LinkSpeed' => {
    '0' => 'platformRecommended',
    '331' => 'gen1',
    '332' => 'gen2',
    '333' => 'gen3',
    '334' => 'auto',
    '335' => 'disabled',
  },
  'CucsLicenseDownloaderFsmStageName' => {
    '0' => 'nop',
    '916' => 'downloadBegin',
    '917' => 'downloadLocal',
    '918' => 'downloadValidateLocal',
    '919' => 'downloadCopyRemote',
    '920' => 'downloadDeleteLocal',
    '921' => 'downloadValidateRemote',
    '922' => 'downloadDeleteRemote',
    '994' => 'downloadFail',
    '995' => 'downloadSuccess',
  },
  'CucsPolicyCleanupMode' => {
    '0' => 'localizeGlobal',
    '1' => 'deepRemoveGlobal',
  },
  'CucsSwCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsLsbootIScsiImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsDupeChangeTrackerEpFsmStageName' => {
    '0' => 'nop',
    '395' => 'configureBegin',
    '396' => 'configureSendChange',
    '397' => 'configureFail',
    '398' => 'configureSuccess',
  },
  'CucsFirmwareDownloadStatus' => {
    '0' => 'idle',
    '1' => 'inprogress',
    '3' => 'failed',
  },
  'CucsHostimgType' => {
    '0' => 'complete',
    '1' => 'kernel',
    '2' => 'fileSystem',
    '3' => 'module',
    '4' => 'gpxeScript',
  },
  'CucsConfigImpactResponseState' => {
    '0' => 'notStarted',
    '1' => 'waiting',
    '2' => 'complete',
    '3' => 'timedOut',
    '4' => 'suspend',
    '5' => 'lostVisibility',
  },
  'CucsPolicyPolicyResolveType' => {
    '0' => 'name',
    '1' => 'rn',
  },
  'CucsTrigDay' => {
    '1' => 'monday',
    '2' => 'tuesday',
    '3' => 'wednesday',
    '4' => 'thursday',
    '5' => 'friday',
    '6' => 'saturday',
    '7' => 'sunday',
    '8' => 'oddDay',
    '9' => 'evenDay',
    '10' => 'everyDay',
  },
  'CucsCommClientAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricDceSwSrvPcEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsPortEncap' => {
    '0' => 'unknown',
    '1' => 'dot1q',
    '2' => 'isl',
    '3' => 'negotiate',
    '4' => 'proprietary',
  },
  'CucsExtvmmMasterExtKeyFsmTaskItem' => {
    '0' => 'nop',
    '575' => 'config',
  },
  'CucsBiosVfConsoleRedirectionVpTerminalType' => {
    '0' => 'platformRecommended',
    '86' => 'pcAnsi',
    '87' => 'vt100',
    '88' => 'vt100Plus',
    '89' => 'vtUtf8',
  },
  'CucsGlRequestVnetEpFsmTaskItem' => {
    '0' => 'nop',
    '601' => 'evalReq',
  },
  'CucsSwExtUtilityFsmTaskItem' => {
    '0' => 'nop',
    '1985' => 'confPortBreakout',
  },
  'CucsTrigAckOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CucsGlRequestSessionState' => {
    '0' => 'active',
    '1' => 'terminated',
  },
  'CucsEquipmentLocalDiskControllerDefOobControllerClassIdentifier' => {
    '0' => 'none',
    '1' => 'nvme',
    '2' => 'avilaRock',
  },
  'CucsFabricFcoeSanPcEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsEquipmentBootDeviceType' => {
    '0' => 'localLunAny',
    '1' => 'localStorageAny',
  },
  'CucsMgmtConnectionState' => {
    '0' => 'unInitialized',
    '1' => 'acknowledged',
    '2' => 'unsupportedConnectivity',
  },
  'CucsTrigStorageAckMode' => {
    '0' => 'immediate',
    '1' => 'userAck',
  },
  'CucsMemoryBackupStatus' => {
    '0' => 'unknown',
    '1' => 'noBackup',
    '2' => 'valid',
  },
  'CucsNwctrlAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsIdentIdentReqIntent' => {
    '0' => 'sync',
    '1' => 'requisition',
    '2' => 'assign',
    '3' => 'unassign',
    '4' => 'addPooled',
    '5' => 'deletePooled',
    '6' => 'checkDuplicateId',
    '7' => 'reEvaluate',
    '8' => 'validate',
    '9' => 'unassignOnBehalfOfUcsm',
  },
  'CucsQosclassEthBEPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsNetworkPortOperState' => {
    '0' => 'indeterminate',
    '1' => 'up',
    '2' => 'adminDown',
    '3' => 'linkDown',
    '4' => 'failed',
    '5' => 'noLicense',
    '6' => 'linkUp',
    '7' => 'hardwareFailure',
    '8' => 'softwareFailure',
    '9' => 'errorDisabled',
    '10' => 'sfpNotPresent',
    '11' => 'udldAggrDown',
    '12' => 'down',
  },
  'CucsEpqosDefinitionDelTaskFsmCurrentFsm' => {
    '0' => 'nop',
    '319' => 'remove',
  },
  'CucsCommSyslogRestrictedSeverity' => {
    '0' => 'emergencies',
    '1' => 'alerts',
    '2' => 'critical',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot2LinkSpeed' => {
    '0' => 'platformRecommended',
    '326' => 'gen1',
    '327' => 'gen2',
    '328' => 'gen3',
    '329' => 'auto',
    '330' => 'disabled',
  },
  'CucsStorageControllerForm' => {
    '0' => 'none',
    '1' => 'onBoard',
    '2' => 'mezzanine',
    '3' => 'pci',
    '4' => 'embedded',
  },
  'CucsStorageBootableType' => {
    '0' => 'unknown',
    '1' => 'true',
    '2' => 'false',
  },
  'CucsSolSpeed' => {
    '6' => 'n9600',
    '7' => 'n19200',
    '8' => 'n38400',
    '9' => 'n57600',
    '10' => 'n115200',
    '9600' => 'defaultValue',
  },
  'CucsFirmwareTypeInstallPath' => {
    '0' => 'default',
    '1' => 'oob',
    '2' => 'ib',
  },
  'CucsComputeBlackListing' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsBiosVfConsoleRedirectionVpFlowControl' => {
    '0' => 'platformRecommended',
    '79' => 'none',
    '80' => 'rtsCts',
  },
  'CucsVnicLstorageIScsiSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '10' => 'ab',
  },
  'CucsBiosVfMirroringModeVpMirroringMode' => {
    '0' => 'platformRecommended',
    '142' => 'interSocket',
    '143' => 'intraSocket',
  },
  'CucsMgmtSource' => {
    '0' => 'unspecified',
    '1' => 'sharedLom',
    '2' => 'sideband',
  },
  'CucsFabricSwSrvEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsPolicyDomainSrcAddrFmt' => {
    '0' => 'ipv4',
    '1' => 'ipv6',
    '2' => 'hostname',
  },
  'CucsConfigComponentType' => {
    '0' => 'adaptors',
    '1' => 'cartridges',
    '2' => 'cpus',
    '3' => 'controllers',
    '4' => 'cryptoCards',
    '5' => 'fans',
    '6' => 'graphicsCards',
    '7' => 'ioms',
    '8' => 'localDisks',
    '9' => 'luns',
    '10' => 'ports',
    '11' => 'psus',
    '12' => 'memory',
    '13' => 'motherboards',
  },
  'CucsCallhomeHolderFsmStageName' => {
    '0' => 'nop',
    '421' => 'configureBegin',
    '422' => 'configureEnableSmartCallhome',
    '423' => 'configureDisableSmartCallhome',
    '424' => 'inventoryBegin',
    '425' => 'inventorySendInventory',
    '494' => 'configureFail',
    '495' => 'configureSuccess',
    '496' => 'inventoryFail',
    '497' => 'inventorySuccess',
  },
  'CucsStatsThresholdDefinitionAutoRecovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsDcxVIfProtRole' => {
    '0' => 'unprotected',
    '1' => 'primary',
    '2' => 'backup',
  },
  'CucsEquipmentDiscoveryState' => {
    '0' => 'unknown',
    '1' => 'online',
    '2' => 'offline',
    '3' => 'discovered',
    '4' => 'unsupportedConnectivity',
    '5' => 'autoUpgrading',
    '6' => 'pinglost',
  },
  'CucsAaaRadiusService' => {
    '0' => 'all',
    '1' => 'defaultValue',
    '2' => 'accounting',
  },
  'CucsFlowctrlConfig' => {
    '0' => 'ok',
    '1' => 'notSupported',
  },
  'CucsFirmwareUpgradeSeverity' => {
    '0' => 'unknown',
    '1' => 'fatal',
    '2' => 'error',
    '3' => 'warn',
    '4' => 'info',
  },
  'CucsEtherCloudType' => {
    '1' => 'unclassified',
    '2' => 'lan',
    '3' => 'san',
  },
  'CucsMgmtRemoteKmipAdminTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'configCaCert',
  },
  'CucsNetworkVlanCountStatus' => {
    '0' => 'withinLimit',
    '1' => 'aboveLimit',
  },
  'CucsFdPhysicalFsmCurrentFsm' => {
    '0' => 'nop',
    '616' => 'configure',
  },
  'CucsSmartlicenseAgentEnforceMode' => {
    '0' => 'invalid',
    '1' => 'init',
    '2' => 'waiting',
    '3' => 'compliance',
    '4' => 'outOfCompliance',
    '5' => 'overage',
    '6' => 'eval',
    '7' => 'expired',
    '8' => 'gracePeriod',
    '9' => 'authorizationExpired',
    '10' => 'gracePeriodExpired',
    '11' => 'disabled',
    '12' => 'invalidTag',
    '13' => 'max',
  },
  'CucsConfigEstimateImpactState' => {
    '0' => 'notStarted',
    '1' => 'wating',
    '2' => 'complete',
    '3' => 'timedOut',
  },
  'CucsSysdebugCoreFsmTaskItem' => {
    '0' => 'nop',
    '1041' => 'download',
  },
  'CucsComputeBladeFsmTaskItem' => {
    '0' => 'nop',
    '23' => 'discover',
    '144' => 'diag',
    '834' => 'updateBoardController',
  },
  'CucsComputeSubscribeStatus' => {
    '0' => 'ok',
    '1' => 'pending',
  },
  'CucsConfigConfigSyncState' => {
    '1' => 'unsynched',
    '2' => 'synched',
  },
  'CucsAdaptorSanCapHostNvram' => {
    '1' => 'none',
    '2' => 'full',
  },
  'CucsLsbootLanAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsFirmwareDistributableFsmStageName' => {
    '0' => 'nop',
    '594' => 'deleteBegin',
    '595' => 'deleteLocal',
    '596' => 'deleteRemote',
    '597' => 'deleteFail',
    '598' => 'deleteSuccess',
  },
  'CucsBiosVfFRB2TimerVpFRB2Timer' => {
    '0' => 'platformRecommended',
    '420' => 'disabled',
    '421' => 'enabled',
  },
  'CucsGlRequestVnetEpDomainEpFsmTaskItem' => {
    '0' => 'nop',
    '609' => 'evalData',
  },
  'CucsEquipmentChassisConfigState' => {
    '0' => 'unInitialized',
    '1' => 'unAcknowledged',
    '2' => 'unsupportedConnectivity',
    '3' => 'ok',
    '4' => 'removing',
    '6' => 'ackInProgress',
    '7' => 'evaluation',
    '8' => 'acknowledged',
    '9' => 'autoAck',
  },
  'CucsExtvmmNetworkSetsFsmTaskItem' => {
    '0' => 'nop',
    '1539' => 'deploy',
  },
  'CucsVnicDynamicConReqProtection' => {
    '0' => 'none',
    '1' => 'protectedPrefA',
    '2' => 'protectedPrefB',
    '3' => 'protected',
  },
  'CucsVnicEtherType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsStorageLinkSpeed' => {
    '0' => 'unknown',
    '1' => 'n15Gbps',
    '2' => 'n3Gbps',
    '3' => 'n6Gbps',
    '4' => 'n12Gbps',
    '5' => 'down',
    '6' => 'hostPowerOff',
    '7' => 'unsupportedDevice',
    '8' => 'disabled',
  },
  'CucsBiosVfProcessorC1EVpProcessorC1E' => {
    '0' => 'platformRecommended',
    '202' => 'disabled',
    '203' => 'enabled',
  },
  'CucsVnicOutbandMgmtEpFsmStageName' => {
    '0' => 'nop',
    '629' => 'configureOutbandBegin',
    '630' => 'configureOutbandResolveOutbandPool',
    '631' => 'configureOutbandCollectIdContexts',
    '632' => 'configureOutbandResolveIdentifiers',
    '633' => 'configureOutbandValidate',
    '634' => 'configureOutbandApplyConfig',
    '678' => 'configureOutbandFail',
    '679' => 'configureOutbandSuccess',
  },
  'CucsSysdebugLogExportPolicyProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsPolicyAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsMgmtMgmtAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsExtpolProviderFsmCurrentFsm' => {
    '0' => 'nop',
    '1374' => 'reportConfigImport',
  },
  'CucsTrigSchedType' => {
    '0' => 'default',
    '1' => 'storage',
  },
  'CucsOsCarrierQueryMethod' => {
    '0' => 'netif',
    '1' => 'ethtool',
  },
  'CucsAdaptorHostEthIfFsmStageName' => {
    '0' => 'nop',
    '505' => 'circuitResetBegin',
    '506' => 'circuitResetDisableA',
    '507' => 'circuitResetEnableA',
    '508' => 'circuitResetDisableB',
    '509' => 'circuitResetEnableB',
    '515' => 'circuitResetFail',
    '516' => 'circuitResetSuccess',
  },
  'CucsAdaptorEthInterruptScalingProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricEthCdpPolicyProtocol' => {
    '0' => 'unknown',
    '1' => 'udld',
    '2' => 'cdp',
  },
  'CucsStorageTargetType' => {
    '0' => 'unspecified',
    '1' => 'unmanaged',
    '2' => 'managed',
  },
  'CucsComputeOpStatus' => {
    '0' => 'nop',
    '1' => 'success',
    '2' => 'fail',
  },
  'CucsStorageLunType' => {
    '0' => 'unspecified',
    '1' => 'simple',
    '2' => 'mirror',
    '3' => 'stripe',
    '4' => 'raid',
    '5' => 'stripeParity',
    '6' => 'stripeDualParity',
    '7' => 'mirrorStripe',
    '8' => 'stripeParityStripe',
    '9' => 'stripeDualParityStripe',
  },
  'CucsPoolScope' => {
    '0' => 'public',
    '1' => 'private',
  },
  'CucsLsScopeType' => {
    '0' => 'all',
    '1' => 'global',
    '2' => 'local',
  },
  'CucsFabricComputeMSlotEpFsmTaskItem' => {
    '0' => 'nop',
    '1877' => 'identify',
  },
  'CucsFabricSanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsAdaptorHostFcIfRemoteAdminState' => {
    '0' => 'enabled',
    '1' => 'remoteTrigger',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CucsBiosVfCPUHardwarePowerManagementVpCPUHardwarePowerManagement' => {
    '0' => 'platformRecommended',
    '409' => 'disabled',
    '410' => 'hwpmNativeMode',
    '411' => 'hwpmOobMode',
  },
  'CucsPolicyUniverseType' => {
    '0' => 'server',
    '1' => 'client',
  },
  'CucsLicenseFeatureType' => {
    '0' => 'counted',
    '1' => 'boolean',
  },
  'CucsQosclassEthClassifiedAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsBmcSELCntEqptClassId' => {
    '0' => 'unspecified',
    '142' => 'processorUnit',
    '247' => 'memoryUnit',
    '605' => 'computeBoard',
  },
  'CucsSysdebugDiagLogOperState' => {
    '0' => 'unknown',
    '1' => 'allocated',
    '2' => 'created',
  },
  'CucsBiosVfProcessorEnergyConfigurationVpEnergyPerformance' => {
    '0' => 'platformRecommended',
    '426' => 'performance',
    '427' => 'balancedPerformance',
    '428' => 'balancedEnergy',
    '429' => 'energyEfficient',
  },
  'CucsFirmwareBootUnitMode' => {
    '0' => 'install',
    '1' => 'upgrade',
  },
  'CucsCimcvmediaDeviceType' => {
    '0' => 'unknown',
    '1' => 'cdd',
    '2' => 'hdd',
  },
  'CucsEquipmentRemoteAdminPowerState' => {
    '0' => 'remoteAdminPowerTrigger',
    '1' => 'policy',
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
  },
  'CucsEquipmentPasswordState' => {
    '0' => 'unknown',
    '1' => 'set',
    '2' => 'notSet',
  },
  'CucsAdaptorHostFcIfFsmTaskItem' => {
    '0' => 'nop',
    '142' => 'resetFcPersBinding',
    '510' => 'circuitReset',
  },
  'CucsFirmwarePlatformType' => {
    '0' => 'ucs',
    '1' => 'ucsMini',
    '2' => 'ucs6300',
  },
  'CucsFirmwareSourceType' => {
    '0' => 'cisco',
    '1' => 'local',
  },
  'CucsConditionAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricVConPlacementPref' => {
    '1' => 'physical',
    '2' => 'auto',
  },
  'CucsAaaTabRestoreMode' => {
    '0' => 'autoRestore',
    '1' => 'promptUser',
    '2' => 'doNotRestore',
  },
  'CucsStorageUnitOperState' => {
    '0' => 'undefined',
    '1' => 'online',
    '2' => 'offline',
    '4' => 'computeInoperable',
    '5' => 'computeDegraded',
    '6' => 'clusterDegraded',
  },
  'CucsLicenseFileFsmCurrentFsm' => {
    '0' => 'nop',
    '923' => 'install',
    '926' => 'clear',
  },
  'CucsFirmwareSystemFsmStageName' => {
    '0' => 'nop',
    '1362' => 'deployBegin',
    '1363' => 'deployWaitForDeploy',
    '1364' => 'deployResolveDistributableNames',
    '1365' => 'deployResolveDistributable',
    '1366' => 'deployResolveImages',
    '1367' => 'deployActivateUCSM',
    '1368' => 'deployPollActivateOfUCSM',
    '1369' => 'deployUpdateIOM',
    '1370' => 'deployPollUpdateOfIOM',
    '1371' => 'deployActivateIOM',
    '1372' => 'deployPollActivateOfIOM',
    '1373' => 'deployActivateRemoteFI',
    '1374' => 'deployPollActivateOfRemoteFI',
    '1375' => 'deployWaitForUserAck',
    '1376' => 'deployActivateLocalFI',
    '1377' => 'deployPollActivateOfLocalFI',
    '1378' => 'applyCatalogPackBegin',
    '1379' => 'applyCatalogPackResolveDistributableNames',
    '1380' => 'applyCatalogPackResolveDistributable',
    '1381' => 'applyCatalogPackResolveImages',
    '1382' => 'applyCatalogPackActivateCatalog',
    '1401' => 'applyCatalogPackFail',
    '1402' => 'applyCatalogPackSuccess',
    '1403' => 'deployFail',
    '1404' => 'deploySuccess',
    '1937' => 'deployInternalBackup',
    '1938' => 'deployPollInternalBackup',
    '1963' => 'deployPollWaitForUserAck',
    '1995' => 'deployDownloadImages',
    '1996' => 'deployCopyAllImagesToPeer',
    '2201' => 'deployFabEvacOnRemoteFI',
    '2202' => 'deployPollFabEvacOnRemoteFI',
    '2203' => 'deployFabEvacOffRemoteFI',
    '2204' => 'deployPollFabEvacOffRemoteFI',
    '2205' => 'deployFailOverToRemoteFI',
    '2206' => 'deployPollFailOverToRemoteFI',
    '2207' => 'deployActivateUCSMServicePack',
    '2208' => 'deployPollActivateOfUCSMServicePack',
  },
  'CucsAdaptorExtEthIfFsmStageName' => {
    '0' => 'nop',
    '499' => 'pathResetBegin',
    '500' => 'pathResetDisable',
    '501' => 'pathResetEnable',
    '502' => 'pathResetFail',
    '503' => 'pathResetSuccess',
  },
  'CucsEquipmentAssociation' => {
    '0' => 'none',
    '1' => 'establishing',
    '2' => 'associated',
    '3' => 'removing',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CucsFirmwareAdminDnldStatus' => {
    '0' => 'idle',
    '1' => 'restart',
  },
  'CucsFabricFcMonDestEpAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n2gbps',
    '3' => 'n4gbps',
    '4' => 'n8gbps',
    '5' => 'auto',
    '6' => 'n16gbps',
  },
  'CucsAdaptorPurpose' => {
    '0' => 'unused',
    '1' => 'general',
    '2' => 'management',
    '3' => 'utility',
    '4' => 'crosslink',
    '5' => 'overlay',
  },
  'CucsStorageKeyType' => {
    '1' => 'initiator',
    '2' => 'target',
  },
  'CucsSwFlowMonitorAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsDomainFunctionalState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CucsFirmwareImageError' => {
    '0' => 'none',
    '1' => 'checksumFailure',
    '2' => 'filesystemError',
    '3' => 'mgmtConnectError',
    '4' => 'bootConfMissing',
    '5' => 'crcFailure',
    '6' => 'unknownError',
    '7' => 'rebuilding',
  },
  'CucsFabricEthLanEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsDupeStatus' => {
    '0' => 'failure',
    '1' => 'success',
  },
  'CucsSwEthMonFsmStageName' => {
    '0' => 'nop',
    '867' => 'deployBegin',
    '868' => 'deployUpdateEthMon',
    '1004' => 'deployFail',
    '1005' => 'deploySuccess',
  },
  'CucsFabricEthLanPcOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsComputeDomainPortDiscPolicyEthBreakoutAutoDiscovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsSwEthMonFsmTaskItem' => {
    '0' => 'nop',
    '953' => 'deploy',
  },
  'CucsCommWebProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsMgmtRemoteBackupType' => {
    '1' => 'fullState',
    '2' => 'configAll',
    '3' => 'configSystem',
    '4' => 'configLogical',
  },
  'CucsExtpolSuspendState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsPowerLockState' => {
    '0' => 'unknown',
    '1' => 'locked',
    '2' => 'unlocked',
  },
  'CucsEquipmentSystemIOControllerFsmStageName' => {
    '0' => 'nop',
    '2035' => 'resetCmcBegin',
    '2036' => 'resetCmcExecute',
    '2171' => 'resetCmcFail',
    '2172' => 'resetCmcSuccess',
  },
  'CucsAaaEpFsmCurrentFsm' => {
    '0' => 'nop',
    '197' => 'updateEp',
  },
  'CucsStorageExpanderState' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'unreachable',
    '4' => 'degraded',
    '5' => 'notReady',
    '6' => 'resourceUnavailable',
  },
  'CucsBmcSELCntStatsClassId' => {
    '0' => 'unspecified',
    '882' => 'computePCIeFatalProtocolStats',
    '884' => 'computePCIeFatalReceiveStats',
    '886' => 'computePCIeFatalCompletionStats',
    '888' => 'computePCIeFatalStats',
    '935' => 'processorErrorStats',
    '940' => 'memoryErrorStats',
  },
  'CucsExtvmmNetworkSetsFsmStageName' => {
    '0' => 'nop',
    '1539' => 'deployBegin',
    '1540' => 'deployLocal',
    '1541' => 'deployPeer',
    '1554' => 'deployFail',
    '1555' => 'deploySuccess',
  },
  'CucsEquipmentHwType' => {
    '0' => 'storageController',
    '1' => 'localDisk',
  },
  'CucsComputeBackplaneSpeed' => {
    '0' => 'n40G',
    '1' => 'n4x10G',
  },
  'CucsStatsPowerEndpoint' => {
    '0' => 'blades',
    '1' => 'racks',
    '2' => 'chassis',
  },
  'CucsBiosVfScrubPoliciesVpPatrolScrub' => {
    '0' => 'platformRecommended',
    '413' => 'disabled',
    '414' => 'enabled',
  },
  'CucsMgmtEntityUmbilicalState' => {
    '0' => 'unknown',
    '1' => 'degraded',
    '2' => 'full',
    '3' => 'failed',
  },
  'CucsMgmtAbsImporterPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsStorageFFControllerState' => {
    '0' => 'ffcUninitalized',
    '1' => 'ffcSoftwareErr',
    '2' => 'ffcInit',
    '3' => 'ffcConfig',
    '4' => 'ffcWaitUser',
    '5' => 'ffcUsbDisconnecting',
    '6' => 'ffcUsbDisconnected',
    '7' => 'ffcUsbConnecting',
    '8' => 'ffcUsbConnected',
    '9' => 'ffcRebuilding',
    '10' => 'ffcFailed',
  },
  'CucsStorageOperationRequestType' => {
    '0' => 'unknown',
    '1' => 'format',
    '2' => 'reset',
    '3' => 'pair',
    '4' => 'unpair',
  },
  'CucsMemoryOperationStatus' => {
    '0' => 'unknown',
    '1' => 'idle',
    '2' => 'backup',
    '3' => 'restore',
    '4' => 'erase',
    '5' => 'backupFailed',
    '6' => 'restoreFailed',
    '7' => 'eraseFailed',
  },
  'CucsPolicyRequestorFsmStageName' => {
    '0' => 'nop',
    '2253' => 'resolveFromCentralBegin',
    '2254' => 'resolveFromCentralResolveFromPolicyMgr',
    '2255' => 'resolveFromCentralResolveFromOpsMgr',
    '2265' => 'resolveFromCentralFail',
    '2266' => 'resolveFromCentralSuccess',
  },
  'CucsGlGlobalizeOperation' => {
    '0' => 'default',
    '1' => 'unbindTemplate',
    '2' => 'resolveConflict',
    '3' => 'createGlobalPolicy',
    '4' => 'createGlobalIdPool',
    '5' => 'createGlobalServiceProfile',
    '6' => 'globalizeLsp',
    '7' => 'applyRule',
  },
  'CucsBiosVfIntelHyperThreadingTechVpIntelHyperThreadingTech' => {
    '0' => 'platformRecommended',
    '5' => 'disabled',
    '6' => 'enabled',
  },
  'CucsSwAutoNegMode' => {
    '0' => 'none',
    '1' => 'auto',
    '2' => 'unset',
  },
  'CucsStorageFFControllerHealth' => {
    '0' => 'ffchOk',
    '1' => 'ffchMetadataFailure',
    '2' => 'ffchErrorCardsAccessError',
    '3' => 'ffchErrorOldFirmwareRunning',
    '4' => 'ffchErrorMediaWriteProtected',
    '5' => 'ffchErrorInvalidSize',
    '6' => 'ffchErrorCardSizeMismatch',
    '7' => 'ffchInconsistentMetadata',
    '8' => 'ffchErrorSecondaryUnhealthyCard',
    '9' => 'ffchErrorSdCardNotConfigured',
    '10' => 'ffchErrorInconsistantMetadataIgnored',
    '11' => 'ffchErrorSd253WithUnOrSd247',
    '12' => 'ffchErrorRebootedDuringRebuild',
    '13' => 'ffchErrorSd247CardDetected',
    '14' => 'ffchFlexdErrorSdCardOpModeMismatch',
    '15' => 'ffchFlexdErrorSdOpModeMismatchWithUn',
    '16' => 'ffchFlexdErrorImSdUnhealthySdUnIgnored',
    '17' => 'ffchFlexdErrorImSdHealthySdUnIgnored',
    '18' => 'ffchFlexdErrorImSdCardsOpModeMismatch',
    '19' => 'ffchFlexdErrorSdCard0UnhealthyOpModeMismatch',
    '20' => 'ffchFlexdErrorSdCard0HealthyOpModeMismatch',
    '21' => 'ffchFlexdErrorSdCard1UnhealthyOpModeMismatch',
    '22' => 'ffchFlexdErrorSdCard1HealthyOpModeMismatch',
    '23' => 'ffchFlexdErrorImSd0IgnoredSd1',
    '24' => 'ffchFlexdErrorImSd0Sd1Ignored',
  },
  'CucsHostimgComposition' => {
    '0' => 'complete',
    '1' => 'componentized',
  },
  'CucsCallhomeAlertMessageSubtype' => {
    '0' => 'nosubtype',
    '1' => 'test',
    '2' => 'full',
    '3' => 'delta',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'goldnormal',
    '7' => 'goldminor',
    '8' => 'goldmajor',
    '100' => 'unknown',
  },
  'CucsExtvmmFabricNetworkType' => {
    '0' => 'notConnected',
    '1' => 'notConnectedPvlans',
    '2' => 'connected',
  },
  'CucsFabricComputeEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsCommProtocol' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsNfsDefAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
    '2' => 'suspended',
  },
  'CucsAdaptorExtEthIfFsmTaskItem' => {
    '0' => 'nop',
    '499' => 'pathReset',
  },
  'CucsMgmtPmonEntryState' => {
    '0' => 'unknown',
    '1' => 'idle',
    '2' => 'running',
    '3' => 'pending',
    '4' => 'failed',
    '5' => 'error',
    '6' => 'exitPending',
    '7' => 'terminated',
    '8' => 'killed',
  },
  'CucsAdaptorCapDefFwVersionOpr' => {
    '0' => 'none',
    '1' => 'gt',
    '2' => 'lt',
  },
  'CucsLsSPOperationType' => {
    '0' => 'noOp',
    '1' => 'rename',
    '2' => 'associate',
    '3' => 'disassociate',
    '4' => 'deletion',
    '5' => 'globalization',
  },
  'CucsComputeTriggerStatus' => {
    '0' => 'unknown',
    '1' => 'triggerAcked',
    '2' => 'triggerFailed',
    '3' => 'triggered',
  },
  'CucsSysdebugLogControlLevel' => {
    '0' => 'debug0',
    '1' => 'debug1',
    '2' => 'debug2',
    '3' => 'debug3',
    '4' => 'debug4',
    '5' => 'info',
    '6' => 'warn',
    '7' => 'minor',
    '8' => 'major',
    '9' => 'crit',
  },
  'CucsComputeAdminState' => {
    '1' => 'inService',
    '2' => 'outOfService',
    '3' => 'inMaintenance',
  },
  'CucsFabricFcoeSanPcOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsLicenseDownloadActivity' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CucsEquipmentAirflowDirection' => {
    '0' => 'unknown',
    '1' => 'frontToBack',
    '2' => 'backToFront',
  },
  'CucsAdaptorPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsSwFcMonFsmStageName' => {
    '0' => 'nop',
    '869' => 'deployBegin',
    '870' => 'deployUpdateFcMon',
    '1006' => 'deployFail',
    '1007' => 'deploySuccess',
  },
  'CucsInitiatorGroupType' => {
    '1' => 'dedicated',
    '2' => 'shared',
    '3' => 'policy',
  },
  'CucsComputeDomainHwChangeDiscPolicyAction' => {
    '0' => 'userAcknowledged',
    '1' => 'autoAcknowledged',
  },
  'CucsBiosVfProcessorPrefetchConfigVpDCUStreamerPrefetch' => {
    '0' => 'platformRecommended',
    '409' => 'disabled',
    '410' => 'enabled',
  },
  'CucsLsFcZoneState' => {
    '0' => 'notApplied',
    '1' => 'applied',
    '2' => 'applying',
    '3' => 'applyPending',
    '4' => 'notActive',
    '5' => 'active',
    '6' => 'created',
    '7' => 'createFailed',
    '8' => 'deleted',
    '9' => 'zoneMergeFailure',
  },
  'CucsTopSystemFsmTaskItem' => {
    '0' => 'nop',
    '15' => 'hostName',
    '293' => 'peerHostName',
  },
  'CucsCapabilityMgmtExtensionFsmCurrentFsm' => {
    '0' => 'nop',
    '910' => 'activateMgmtExt',
  },
  'CucsFirmwareChassisType' => {
    '0' => 'unspecified',
    '8' => 'storageController',
    '14' => 'localDisk',
    '27' => 'iocard',
    '28' => 'sasExpander',
    '29' => 'chassisBoardController',
    '30' => 'cmc',
  },
  'CucsAdaptorEthInterruptProfileCoalescingType' => {
    '0' => 'min',
    '1' => 'idle',
  },
  'CucsBiosVfSparingModeVpSparingMode' => {
    '0' => 'platformRecommended',
    '126' => 'dimmSparing',
    '127' => 'rankSparing',
  },
  'CucsMgmtOperationStatus' => {
    '1' => 'notStarted',
    '2' => 'workInProgress',
    '3' => 'allSuccess',
    '4' => 'partialFailed',
    '5' => 'failed',
    '6' => 'domainSuspended',
  },
  'CucsFirmwareBladeType' => {
    '0' => 'unspecified',
    '4' => 'bladeController',
    '6' => 'bladeBios',
    '7' => 'adaptor',
    '8' => 'storageController',
    '9' => 'hostNic',
    '10' => 'hostHba',
    '11' => 'hostHbaOptionrom',
    '12' => 'hostNicOptionrom',
    '13' => 'boardController',
    '14' => 'localDisk',
    '20' => 'flexflashController',
    '21' => 'storageControllerOnboardDevice',
    '22' => 'storageDevBridge',
    '23' => 'storageControllerOnboardDeviceCpld',
    '25' => 'graphicsCard',
    '26' => 'psu',
    '28' => 'sasExpander',
    '31' => 'sasExpRegFw',
  },
  'CucsCallhomeHolderFsmCurrentFsm' => {
    '0' => 'nop',
    '421' => 'configure',
    '424' => 'inventory',
  },
  'CucsFabricMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsCallhomeLevel' => {
    '0' => 'debug',
    '1' => 'normal',
    '2' => 'notification',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
    '7' => 'fatal',
    '8' => 'disaster',
  },
  'CucsEquipmentOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'degraded',
    '4' => 'poweredOff',
    '5' => 'powerProblem',
    '6' => 'removed',
    '7' => 'voltageProblem',
    '8' => 'thermalProblem',
    '9' => 'performanceProblem',
    '10' => 'accessibilityProblem',
    '11' => 'identityUnestablishable',
    '12' => 'biosPostTimeout',
    '13' => 'disabled',
    '14' => 'malformedFru',
    '15' => 'backplanePortProblem',
    '16' => 'chassisIntrusion',
    '51' => 'fabricConnProblem',
    '52' => 'fabricUnsupportedConn',
    '81' => 'config',
    '82' => 'equipmentProblem',
    '83' => 'decomissioning',
    '84' => 'chassisLimitExceeded',
    '100' => 'notSupported',
    '101' => 'discovery',
    '102' => 'discoveryFailed',
    '103' => 'identify',
    '104' => 'postFailure',
    '105' => 'upgradeProblem',
    '106' => 'peerCommProblem',
    '107' => 'autoUpgrade',
    '108' => 'linkActivateBlocked',
  },
  'CucsLstorageResolveFromRemoteServer' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsLstorageReplicationSourceAccessType' => {
    '1' => 'allowAll',
    '2' => 'allowNone',
    '3' => 'allowOnly',
  },
  'CucsSwVlanCompType' => {
    '1' => 'included',
    '2' => 'excluded',
  },
  'CucsSwUtilityDomainFsmStageName' => {
    '0' => 'nop',
    '228' => 'deployBegin',
    '229' => 'deployUpdateConnectivity',
    '440' => 'deployFail',
    '441' => 'deploySuccess',
  },
  'CucsAdaptorCapSpecType' => {
    '1' => 'virtualizedEthIf',
    '2' => 'virtualizedFcIf',
    '3' => 'virtualizedScsiIf',
    '4' => 'nonVirtualizedEthIf',
    '5' => 'nonVirtualizedFcIf',
    '6' => 'fcoe',
    '7' => 'protectedEthIf',
    '8' => 'protectedFcIf',
    '9' => 'protectedFcoe',
    '10' => 'pathEncapVirtual',
    '11' => 'pathEncapConsolidated',
    '12' => 'uplinkAggregation',
    '13' => 'virtualizedEthSriov',
    '14' => 'virtualizedFcSriov',
    '15' => 'virtualizedEthSriovUsnic',
    '16' => 'virtualizedEthVmq',
    '17' => 'ethFlowMonitoringNetflow',
    '18' => 'ethRoce',
    '19' => 'ethVxlan',
    '20' => 'ethNvgre',
    '21' => 'virtualizedCeEthIf',
    '22' => 'pathEncapVirtualCe',
    '23' => 'pxebootConfigSupport',
    '25' => 'oracleRacSupport',
  },
  'CucsFirmwareAutoSyncState' => {
    '0' => 'autoAcknowledge',
    '1' => 'userAcknowledge',
    '2' => 'noActions',
  },
  'CucsStorageIScsiInitiatorEpProt' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsCapabilityUpdaterFsmCurrentFsm' => {
    '0' => 'nop',
    '582' => 'updater',
  },
  'CucsMgmtBackupJobStatus' => {
    '0' => 'none',
    '1' => 'inProgress',
    '2' => 'success',
    '3' => 'fail',
  },
  'CucsNetworkElementOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'removed',
    '4' => 'deprecated',
  },
  'CucsStorageFFCardHealth' => {
    '0' => 'ffPhyHealthNa',
    '1' => 'ffPhyHealthOk',
    '2' => 'ffPhyUnhealthyRaid',
    '3' => 'ffPhyUnhealthyOther',
    '4' => 'ffPhyRaidSyncInProgress',
    '5' => 'ffPhyRaidOutOfSync',
  },
  'CucsConditionSeverity' => {
    '0' => 'cleared',
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
  },
  'CucsAdaptorRssProfileReceiveSideScaling' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsEtherServerIntFIoAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricUdldOperState' => {
    '0' => 'unknown',
    '1' => 'unidirectional',
    '2' => 'bidirectional',
    '3' => 'txRxLoop',
    '4' => 'mismatch',
    '5' => 'echoEmpty',
    '6' => 'adminDisabled',
  },
  'CucsEtherCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsVnicVnicOperHostPort' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CucsFabricStatus' => {
    '0' => 'modified',
    '1' => 'created',
    '2' => 'deleted',
    '3' => 'intentDeletion',
  },
  'CucsComputePsuClusterState' => {
    '0' => 'unknown',
    '1' => 'slot1Master',
    '2' => 'slot2Master',
    '3' => 'notClustered',
    '4' => 'nA',
  },
  'CucsLsbootLanBootProt' => {
    '0' => 'pxe',
    '1' => 'gpxe',
    '2' => 'iSCSI',
  },
  'CucsSwEthLanFlowMonFsmCurrentFsm' => {
    '0' => 'nop',
    '1537' => 'deploy',
  },
  'CucsEquipmentCPOperationType' => {
    '0' => 'noOp',
    '1' => 'rename',
    '2' => 'associate',
    '3' => 'disassociate',
    '4' => 'deletion',
  },
  'CucsPolicyLogProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsCimcvmediaTransport' => {
    '0' => 'unknown',
    '1' => 'nfs',
    '2' => 'cifs',
    '3' => 'http',
    '4' => 'https',
  },
  'CucsStorageReadType' => {
    '0' => 'unknown',
    '1' => 'readAhead',
    '2' => 'normal',
  },
  'CucsComputeOperAdminLinkAggregation' => {
    '0' => 'none',
    '1' => 'portChannel',
    '2' => 'global',
    '255' => 'unspecified',
  },
  'CucsConfigSorterDirection' => {
    '0' => 'ascending',
    '1' => 'descending',
  },
  'CucsTrigAckMode' => {
    '0' => 'immediate',
    '1' => 'userAck',
    '2' => 'timerAutomatic',
  },
  'CucsCallhomeAnonymousReportingAdminState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsEtherSwitchIntFIoPcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsNfsMountDefFsmStageName' => {
    '0' => 'nop',
    '1241' => 'reportNfsMountSuspendBegin',
    '1242' => 'reportNfsMountSuspendReport',
    '1415' => 'reportNfsMountSuspendFail',
    '1416' => 'reportNfsMountSuspendSuccess',
  },
  'CucsFabricDceSwSrvPcOperationIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsPortSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n2gbps',
    '3' => 'n4gbps',
    '4' => 'n8gbps',
    '5' => 'auto',
    '6' => 'n16gbps',
  },
  'CucsNfsClientAdminState' => {
    '0' => 'none',
    '1' => 'add',
    '2' => 'remove',
  },
  'CucsLsbootDefaultLocalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsMgmtBackupFsmStageName' => {
    '0' => 'nop',
    '290' => 'backupBegin',
    '291' => 'backupBackupLocal',
    '292' => 'backupUpload',
    '398' => 'backupFail',
    '399' => 'backupSuccess',
  },
  'CucsSwLanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsFabricRemoteSlotAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'acknowledged',
    '3' => 'reacknowledge',
  },
  'CucsLsbootVirtualMediaAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
  },
  'CucsCimcvmediaMountStatus' => {
    '0' => 'unknown',
    '1' => 'mounting',
    '2' => 'mounted',
    '3' => 'unmounting',
    '4' => 'notMounted',
    '5' => 'mountFailed',
    '6' => 'unmountFailed',
    '7' => 'mountEjectedByOs',
  },
  'CucsHcErrorCode' => {
    '0' => 'none',
    '1' => 'noMatchingServersFound',
    '3' => 'dnNotSpecified',
    '4' => 'invalidInput',
    '5' => 'osNotTagged',
    '6' => 'retry',
    '7' => 'dnNotSupported',
    '8' => 'ucsFwVersionNotFound',
    '9' => 'targetFwVersionInvalid',
    '10' => 'missingDataInCatalog',
    '11' => 'adapterNotTagged',
    '12' => 'targetFwVersionNotSpecified',
    '13' => 'adapterFwVersionNotFound',
  },
  'CucsMgmtDiskZoningState' => {
    '0' => 'unknown',
    '1' => 'processing',
    '2' => 'deployed',
    '3' => 'inventoryStart',
    '4' => 'inventoryEnd',
    '5' => 'failed',
  },
  'CucsFabricDceSwSrvPcOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsCpmaintChangeMode' => {
    '0' => 'noChange',
    '1' => 'unconfig',
    '2' => 'forceUnconfig',
    '4' => 'rediscover',
    '8' => 'config',
    '16' => 'diagConfig',
    '32' => 'diagUnconfig',
    '64' => 'removeConfig',
    '128' => 'diag',
  },
  'CucsDiagPattern' => {
    '0' => 'prbsKiller',
    '1' => 'butterfly',
    '2' => 'prbs',
    '3' => 'killer',
    '4' => 'prbsAddr',
  },
  'CucsMorefImportRootFsmTaskItem' => {
    '0' => 'nop',
    '2012' => 'applyMoRefs',
  },
  'CucsCapabilityCatalogueFsmCurrentFsm' => {
    '0' => 'nop',
    '609' => 'deployCatalogue',
    '904' => 'activateCatalog',
  },
  'CucsSwNFConfigStatus' => {
    '1' => 'ok',
    '2' => 'incomplete',
  },
  'CucsAdaptorMgmtCapRebootActionOnDestructive' => {
    '0' => 'none',
    '1' => 'host',
    '2' => 'adaptor',
  },
  'CucsSmartlicenseAgentState' => {
    '0' => 'unconfigured',
    '1' => 'unidentified',
    '2' => 'registered',
    '3' => 'authorized',
    '4' => 'outofcompliance',
    '5' => 'expired',
  },
  'CucsAaaEpFsmStageName' => {
    '0' => 'nop',
    '197' => 'updateEpBegin',
    '198' => 'updateEpSetEpLocal',
    '199' => 'updateEpSetEpPeer',
    '322' => 'updateEpFail',
    '323' => 'updateEpSuccess',
  },
  'CucsProcessorQualArch' => {
    '0' => 'any',
    '1' => 'intelP4C',
    '132' => 'opteron',
    '134' => 'turion64',
    '135' => 'dualCoreOpteron',
    '178' => 'pentium4',
    '179' => 'xeon',
    '181' => 'xeonMP',
  },
  'CucsComputeAvailability' => {
    '0' => 'unavailable',
    '1' => 'available',
  },
  'CucsBiosVfTPMPendingOperationVpTPMPendingOperation' => {
    '0' => 'platformRecommended',
    '517' => 'none',
    '518' => 'tpmppioowneron',
    '519' => 'tpmppioowneroff',
    '520' => 'tpmclear',
  },
  'CucsTrigAdminState' => {
    '0' => 'triggerImmediate',
    '1' => 'triggered',
    '2' => 'untriggered',
    '4' => 'userAck',
    '5' => 'userDiscard',
  },
  'CucsBiosVfCoreMultiProcessingVpCoreMultiProcessing' => {
    '0' => 'platformRecommended',
    '170' => 'all',
    '178' => 'n1',
    '179' => 'n2',
    '180' => 'n3',
    '181' => 'n4',
    '182' => 'n5',
    '183' => 'n6',
    '184' => 'n7',
    '185' => 'n8',
    '190' => 'n9',
    '191' => 'n10',
    '274' => 'n11',
    '275' => 'n12',
    '294' => 'n13',
    '295' => 'n14',
    '296' => 'n15',
    '440' => 'n16',
    '441' => 'n17',
    '442' => 'n18',
    '551' => 'n19',
    '552' => 'n20',
    '553' => 'n21',
    '554' => 'n22',
    '557' => 'n23',
    '558' => 'n24',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpPCIeSlotMLOMOptionROM' => {
    '0' => 'platformRecommended',
    '459' => 'disabled',
    '460' => 'enabled',
    '461' => 'uefiOnly',
    '462' => 'legacyOnly',
  },
  'CucsPolicyDeferenceAction' => {
    '0' => 'delete',
    '1' => 'noAction',
    '2' => 'localize',
  },
  'CucsSysdebugLogControlEpFsmTaskItem' => {
    '0' => 'nop',
    '1' => 'persistence',
    '219' => 'logControlPersist',
  },
  'CucsConsumerOperState' => {
    '1' => 'ok',
    '2' => 'resetting',
    '3' => 'provisioning',
  },
  'CucsCommSmashCLPProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsFirmwareRepositoryType' => {
    '0' => 'cisco',
    '1' => 'local',
  },
  'CucsGlAppendType' => {
    '0' => 'number',
  },
  'CucsComputeMemoryUnitConstraintType' => {
    '0' => 'unknown',
    '1' => 'kit',
  },
  'CucsBiosVfIntelVTForDirectedIOVpIntelVTDATSSupport' => {
    '0' => 'platformRecommended',
    '20' => 'disabled',
    '21' => 'enabled',
  },
  'CucsSwVlanConfigStatusType' => {
    '1' => 'applied',
    '2' => 'unApplied',
  },
  'CucsMgmtDataExporterType' => {
    '1' => 'fullState',
    '2' => 'configAll',
    '3' => 'configSystem',
    '4' => 'configLogical',
  },
  'CucsFabricPathEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsDcxProtState' => {
    '0' => 'noProtection',
    '1' => 'active',
    '2' => 'passive',
  },
  'CucsMgmtIfFsmStageName' => {
    '0' => 'nop',
    '277' => 'swMgmtOobIfConfigBegin',
    '278' => 'swMgmtOobIfConfigSwitch',
    '279' => 'swMgmtInbandIfConfigBegin',
    '280' => 'swMgmtInbandIfConfigSwitch',
    '281' => 'virtualIfConfigBegin',
    '282' => 'virtualIfConfigLocal',
    '283' => 'virtualIfConfigRemote',
    '284' => 'enableVipBegin',
    '285' => 'enableVipLocal',
    '286' => 'disableVipBegin',
    '287' => 'disableVipPeer',
    '288' => 'enableHABegin',
    '289' => 'enableHALocal',
    '290' => 'disableVipLocal',
    '414' => 'disableVipFail',
    '415' => 'disableVipSuccess',
    '416' => 'enableHAFail',
    '417' => 'enableHASuccess',
    '418' => 'enableVipFail',
    '419' => 'enableVipSuccess',
    '420' => 'swMgmtInbandIfConfigFail',
    '421' => 'swMgmtInbandIfConfigSuccess',
    '422' => 'swMgmtOobIfConfigFail',
    '423' => 'swMgmtOobIfConfigSuccess',
    '424' => 'virtualIfConfigFail',
    '425' => 'virtualIfConfigSuccess',
    '1907' => 'faPresenceBegin',
    '1908' => 'faPresenceCheckLicense',
    '1909' => 'faPresenceIdentify',
    '1910' => 'faConnBegin',
    '1911' => 'faConnConfigureVifNs',
    '1912' => 'faConnSharedIOModuleInventory',
    '1913' => 'faConnDiscoverChassis',
    '1914' => 'faConnOobStorageInventory',
    '1933' => 'faConnFail',
    '1934' => 'faConnSuccess',
    '1935' => 'faPresenceFail',
    '1936' => 'faPresenceSuccess',
    '1974' => 'faConnDiscoverSasExpander',
  },
  'CucsFabricConfigState' => {
    '1' => 'applied',
    '2' => 'inconsistent',
  },
  'CucsComputeAdminLinkAggregation' => {
    '0' => 'none',
    '1' => 'portChannel',
    '2' => 'global',
  },
  'CucsLsSPMetaGlobalizationState' => {
    '0' => 'noOp',
    '1' => 'globalizing',
    '2' => 'globalized',
  },
  'CucsFabricZoningState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricEthVlanPortEpVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CucsFabricVsanOperState' => {
    '1' => 'ok',
    '2' => 'errorMisconfigured',
    '3' => 'errorReserved',
  },
  'CucsTrigTriggeredState' => {
    '0' => 'pending',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'triggered',
  },
  'CucsCallhomeHolderFsmTaskItem' => {
    '0' => 'nop',
    '421' => 'configure',
    '424' => 'inventory',
  },
  'CucsStorageProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsAaaUserEpFsmTaskItem' => {
    '0' => 'nop',
    '203' => 'updateUserEp',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot2State' => {
    '0' => 'platformRecommended',
    '212' => 'disabled',
    '213' => 'enabled',
    '447' => 'uefiOnly',
    '448' => 'legacyOnly',
  },
  'CucsFabricConfState' => {
    '0' => 'ok',
    '1' => 'logicalConfigInvalid',
  },
  'CucsComputePollingInterval' => {
    '5' => 'n5Min',
    '10' => 'n10Min',
    '15' => 'n15Min',
    '20' => 'n20Min',
    '30' => 'n30Min',
    '45' => 'n45Min',
    '60' => 'n60Min',
  },
  'CucsFabricSwChEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsMgmtImportAction' => {
    '0' => 'merge',
    '1' => 'replace',
  },
  'CucsStorageCtrlLeadership' => {
    '0' => 'unknown',
    '1' => 'active',
    '2' => 'passive',
  },
  'CucsLsbootUsbInternalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsVnicProfileSetFsmStageName' => {
    '0' => 'nop',
    '187' => 'deployBegin',
    '188' => 'deployLocal',
    '189' => 'deployPeer',
    '456' => 'deployFail',
    '457' => 'deploySuccess',
    '1118' => 'deployAliasBegin',
    '1119' => 'deployAliasLocal',
    '1120' => 'deployAliasPeer',
    '1148' => 'deployAliasFail',
    '1149' => 'deployAliasSuccess',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot4LinkSpeed' => {
    '0' => 'platformRecommended',
    '336' => 'gen1',
    '337' => 'gen2',
    '338' => 'gen3',
    '339' => 'auto',
    '340' => 'disabled',
  },
  'CucsNfsClientConfigState' => {
    '0' => 'unregistered',
    '1' => 'registered',
    '2' => 'configured',
    '3' => 'failed',
  },
  'CucsEtherSwitchIntFIoAck' => {
    '0' => 'unInitialized',
    '1' => 'unAcknowledged',
    '2' => 'unsupportedConnectivity',
    '3' => 'ok',
    '4' => 'removing',
    '6' => 'ackInProgress',
    '7' => 'evaluation',
    '8' => 'acknowledged',
    '9' => 'autoAck',
  },
  'CucsSmartlicenseEntitlementEpFsmTaskItem' => {
    '0' => 'nop',
    '484' => 'configure',
  },
  'CucsSysdebugBackupBehaviorProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsMgmtDataExporterFsmStageName' => {
    '0' => 'nop',
    '24' => 'exportDataBegin',
    '25' => 'exportDataDmeDataExport',
    '26' => 'exportDataUpload',
    '111' => 'exportDataFail',
    '112' => 'exportDataSuccess',
  },
  'CucsEquipmentLedLocatorState' => {
    '0' => 'inactive',
    '1' => 'off',
    '2' => 'on',
  },
  'CucsStorageAdminCtrlActionType' => {
    '0' => 'unspecified',
    '1' => 'importForeignConfiguration',
    '2' => 'unpinCacheAll',
    '4' => 'skipInitialConfig',
    '5' => 'clearBootConfiguration',
    '6' => 'unlockDisk',
    '7' => 'disableSecurity',
    '8' => 'modifyKey',
    '9' => 'enableSecurity',
    '10' => 'testKmipConnectivity',
    '11' => 'cleanHxState',
    '12' => 'secureHxDrives',
    '13' => 'rescanHxInventory',
  },
  'CucsCertRepairEpFsmCurrentFsm' => {
    '0' => 'nop',
    '50' => 'repairCert',
  },
  'CucsFirmwareDownloaderFsmStageName' => {
    '0' => 'nop',
    '233' => 'downloadBegin',
    '234' => 'downloadLocal',
    '235' => 'downloadUnpackLocal',
    '236' => 'downloadCopyRemote',
    '239' => 'downloadDeleteLocal',
    '394' => 'downloadFail',
    '395' => 'downloadSuccess',
  },
  'CucsStorageControllerJBODMode' => {
    '0' => 'unknown',
    '1' => 'disabled',
    '2' => 'enabled',
  },
  'CucsOsPrimaryReselection' => {
    '0' => 'always',
    '1' => 'better',
    '2' => 'failure',
  },
  'CucsSysdebugTechSupportFsmStageName' => {
    '0' => 'nop',
    '881' => 'initiateBegin',
    '882' => 'initiateLocal',
    '883' => 'deleteTechSupFileBegin',
    '884' => 'deleteTechSupFileLocal',
    '885' => 'deleteTechSupFilePeer',
    '886' => 'downloadBegin',
    '887' => 'downloadCopySub',
    '888' => 'downloadCopyPrimary',
    '889' => 'downloadDeleteSub',
    '890' => 'downloadDeletePrimary',
    '1008' => 'deleteTechSupFileFail',
    '1009' => 'deleteTechSupFileSuccess',
    '1010' => 'downloadFail',
    '1011' => 'downloadSuccess',
    '1012' => 'initiateFail',
    '1013' => 'initiateSuccess',
  },
  'CucsOrgOrgFsmStageName' => {
    '0' => 'nop',
    '5' => 'configureBegin',
    '6' => 'configureConfig',
    '129' => 'configureFail',
    '130' => 'configureSuccess',
    '291' => 'configurePeerBegin',
    '292' => 'configurePeerConfig',
    '301' => 'configurePeerFail',
    '302' => 'configurePeerSuccess',
  },
  'CucsExtmgmtIfMonPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfWorkloadConfigurationVpWorkloadConfiguration' => {
    '0' => 'platformRecommended',
    '608' => 'balanced',
    '609' => 'ioSensitive',
  },
  'CucsCommSyslogClientEnum' => {
    '1' => 'primary',
    '2' => 'secondary',
    '3' => 'tertiary',
  },
  'CucsStorageTechnology' => {
    '0' => 'unspecified',
    '1' => 'hdd',
    '2' => 'ssd',
    '3' => 'nvme',
  },
  'CucsFabricVnetEpSyncEpFsmTaskItem' => {
    '0' => 'nop',
    '367' => 'syncVnetEpUCS',
    '1474' => 'pushVnetEpDeletion',
  },
  'CucsQosclassEthClassifiedPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsConfigBackupAdminState' => {
    '0' => 'active',
    '1' => 'delete',
  },
  'CucsOsLBType' => {
    '0' => 'xmitOnly',
    '1' => 'receiveXmit',
  },
  'CucsStorageEnclosureFsmStageName' => {
    '0' => 'nop',
    '2019' => 'removeEnclosureBegin',
    '2020' => 'removeEnclosureValidateRemoval',
    '2021' => 'removeEnclosureUpdateStorageInvCMC',
    '2022' => 'removeEnclosureUpdateStorageInvCIMC',
    '2023' => 'removeEnclosurePollUpdateStorageInvCIMC',
    '2191' => 'removeEnclosureFail',
    '2192' => 'removeEnclosureSuccess',
  },
  'CucsFabricComputePhEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsCommNtpProviderAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsExtpolProviderFsmStageName' => {
    '0' => 'nop',
    '1374' => 'reportConfigImportBegin',
    '1375' => 'reportConfigImportReport',
    '1398' => 'reportConfigImportFail',
    '1399' => 'reportConfigImportSuccess',
  },
  'CucsSysfileMutationFsmCurrentFsm' => {
    '0' => 'nop',
    '209' => 'single',
    '211' => 'global',
  },
  'CucsEquipmentSlotStatus' => {
    '0' => 'unknown',
    '1' => 'empty',
    '10' => 'equipped',
    '11' => 'missing',
    '12' => 'mismatch',
    '13' => 'equippedNotPrimary',
    '14' => 'equippedSlave',
    '15' => 'mismatchSlave',
    '16' => 'missingSlave',
    '20' => 'equippedIdentityUnestablishable',
    '21' => 'mismatchIdentityUnestablishable',
    '22' => 'equippedWithMalformedFru',
    '30' => 'inaccessible',
    '40' => 'unauthorized',
    '101' => 'equippedUnsupported',
    '102' => 'equippedDeprecated',
  },
  'CucsFabricEthMonOperationOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'error',
  },
  'CucsSwNetflowExporterProtocol' => {
    '1' => 'netflow',
  },
  'CucsFabricFcSanPcEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricEthLanEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsBiosVfNUMAOptimizedVpNUMAOptimized' => {
    '0' => 'platformRecommended',
    '32' => 'disabled',
    '33' => 'enabled',
  },
  'CucsFabricFcZoneProfileFsmCurrentFsm' => {
    '0' => 'nop',
    '642' => 'configure',
  },
  'CucsStorageOnBoardMemoryPresent' => {
    '0' => 'unknown',
    '1' => 'yes',
    '2' => 'no',
  },
  'CucsIdentMetaSystemFsmStageName' => {
    '0' => 'nop',
    '1338' => 'syncBegin',
    '1339' => 'syncPing',
    '1340' => 'syncExecute',
    '1407' => 'syncFail',
    '1408' => 'syncSuccess',
    '1618' => 'ucscUnivSyncBegin',
    '1619' => 'ucscUnivSyncExecute',
    '1622' => 'ucscUnivSyncFail',
    '1623' => 'ucscUnivSyncSuccess',
  },
  'CucsEtherServerIntFIoPcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsAdaptorIScsiCapBootOrderType' => {
    '0' => 'systemBootOrder',
    '1' => 'fddOrder',
    '2' => 'hddOrder',
    '3' => 'cdOrder',
    '6' => 'networkDeviceOrder',
    '16' => 'internalEfiShell',
    '99' => 'unknownDeviceOrder',
    '100' => 'localStorageAnyDeviceOrder',
    '101' => 'sanDeviceOrder',
    '102' => 'sanAnyDeviceOrder',
    '103' => 'internalUsbDeviceOrder',
    '104' => 'externalUsbDeviceOrder',
    '105' => 'sdcardDeviceOrder',
    '106' => 'lanAnyDeviceOrder',
    '107' => 'uefiTargetDeviceOrder',
    '108' => 'iscsiDeviceOrder',
    '109' => 'iscsiAnyDeviceOrder',
    '110' => 'cimcVmediaCddDeviceOrder',
    '111' => 'cimcVmediaHddDeviceOrder',
    '112' => 'cimcVmediaFddDeviceOrder',
    '113' => 'kvmVmediaCddDeviceOrder',
    '114' => 'kvmVmediaHddDeviceOrder',
    '115' => 'kvmVmediaFddDeviceOrder',
    '116' => 'uefiShellDeviceOrder',
    '117' => 'nvmeDeviceOrder',
    '118' => 'nvmeDiskSsdDeviceOrder',
    '119' => 'nvmePciSsdDeviceOrder',
    '128' => 'bevOrder',
  },
  'CucsAaaSession' => {
    '0' => 'local',
    '1' => 'remote',
    '2' => 'ipmi',
  },
  'CucsSwSanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsFabricLifeCycle' => {
    '1' => 'inService',
    '2' => 'outOfService',
    '3' => 'outOfServiceSlave',
  },
  'CucsStorageDiskRole' => {
    '0' => 'normal',
    '1' => 'dedHotSpare',
    '2' => 'globHotSpare',
    '3' => 'unknown',
  },
  'CucsEtherServerIntFIoFsmStageName' => {
    '0' => 'nop',
    '1150' => 'configSpeedBegin',
    '1151' => 'configSpeedConfigure',
    '1182' => 'configSpeedFail',
    '1183' => 'configSpeedSuccess',
    '2101' => 'configBegin',
    '2102' => 'configConfigure',
    '2173' => 'configFail',
    '2174' => 'configSuccess',
  },
  'CucsStorageEnclosureDiskSlotEpAutoZoneCause' => {
    '0' => 'none',
    '1' => 'sharingUnsupported',
    '2' => 'hddslotUnassigned',
    '3' => 'hotspareUnsupported',
    '4' => 'hddTrayInLieuOfServer2',
    '5' => 'mezzControllerInIoexpander',
    '6' => 'secondControllerAbsent',
  },
  'CucsAaaLdapVendor' => {
    '0' => 'openLdap',
    '1' => 'msAd',
  },
  'CucsStorageBatteryType' => {
    '0' => 'unknown',
    '1' => 'battery',
    '2' => 'supercap',
  },
  'CucsNetworkSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsEquipmentTpmType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'virtual',
  },
  'CucsFabricFcoeSanEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsCommDnsProviderAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsConfigAbsDbConfigType' => {
    '0' => 'unknown',
    '1' => 'postgres',
    '2' => 'oracle',
    '3' => 'mssql',
  },
  'CucsBiosVfLOMPortsConfigurationVpLOMPort1OptionROM' => {
    '0' => 'platformRecommended',
    '377' => 'disabled',
    '378' => 'enabled',
    '379' => 'uefiOnly',
    '380' => 'legacyOnly',
  },
  'CucsStorageLearnMode' => {
    '0' => 'unknown',
    '1' => 'auto',
    '2' => 'disabled',
    '3' => 'warn',
  },
  'CucsBiosVfDramRefreshRateVpDramRefreshRate' => {
    '0' => 'platformRecommended',
    '262' => 'n1x',
    '263' => 'n2x',
    '264' => 'n3x',
    '265' => 'n4x',
    '270' => 'auto',
  },
  'CucsSwUtilityDomainFsmCurrentFsm' => {
    '0' => 'nop',
    '228' => 'deploy',
  },
  'CucsBiosVfUEFIOSUseLegacyVideoVpUEFIOSUseLegacyVideo' => {
    '0' => 'platformRecommended',
    '160' => 'disabled',
    '161' => 'enabled',
  },
  'CucsStorageFFRWType' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
  },
  'CucsPkiModulus' => {
    '0' => 'modinvalid',
    '512' => 'mod512',
    '1024' => 'mod1024',
    '1536' => 'mod1536',
    '2048' => 'mod2048',
    '2560' => 'mod2560',
    '3072' => 'mod3072',
    '3584' => 'mod3584',
    '4096' => 'mod4096',
  },
  'CucsGlReqOperState' => {
    '0' => 'notEvaluated',
    '1' => 'fetchingDataFromDomain',
    '2' => 'fetchingDependencies',
    '3' => 'evaluating',
    '4' => 'evaluatedWithError',
    '5' => 'evaluatedWithSuccess',
    '6' => 'createDependencies',
    '7' => 'globalizing',
    '8' => 'globalizedWithError',
    '9' => 'globalizedWithSuccess',
  },
  'CucsStorageLocalDiskDiscoveredPath' => {
    '0' => 'default',
    '1' => 'oob',
    '2' => 'ib',
  },
  'CucsStatsDefaultView' => {
    '0' => 'chart',
    '1' => 'table',
  },
  'CucsCallhomeHolderConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CucsVnicMezzMappingScheme' => {
    '1' => 'physicalCapFirst',
    '2' => 'capLoadDistribute',
  },
  'CucsCommChannel' => {
    '0' => 'fullssl',
    '1' => 'noencssl',
    '2' => 'plain',
  },
  'CucsEpqosDefinitionFsmTaskItem' => {
    '0' => 'nop',
    '316' => 'deploy',
  },
  'CucsMoAnnotationOperState' => {
    '0' => 'ok',
    '1' => 'notSupported',
    '2' => 'configFailure',
  },
  'CucsLstorageVirtualDriveDefWriteCachePolicy' => {
    '0' => 'unknown',
    '1' => 'writeThrough',
    '2' => 'writeBackGoodBbu',
    '3' => 'alwaysWriteBack',
  },
  'CucsMacpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsNfsMntAdminState' => {
    '0' => 'none',
    '1' => 'unmount',
    '2' => 'mount',
    '3' => 'remount',
  },
  'CucsBiosVfIntelTrustedExecutionTechnologyVpIntelTstdExecTechSup' => {
    '0' => 'platformRecommended',
    '515' => 'disabled',
    '516' => 'enabled',
  },
  'CucsConfigInstType' => {
    '0' => 'unknow',
    '1' => 'sp',
    '2' => 'cp',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot6LinkSpeed' => {
    '0' => 'platformRecommended',
    '346' => 'gen1',
    '347' => 'gen2',
    '348' => 'gen3',
    '349' => 'auto',
    '350' => 'disabled',
  },
  'CucsStorageRemoteStorageAdminTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'rediscover',
    '2' => 'resetToFactory',
    '3' => 'discovered',
    '4' => 'remove',
    '5' => 'migrate',
    '6' => 'decommission',
  },
  'CucsSysdebugLogExportPolicyFsmStageName' => {
    '0' => 'nop',
    '1600' => 'configureBegin',
    '1601' => 'configureLocal',
    '1602' => 'configurePeer',
    '1605' => 'configureFail',
    '1606' => 'configureSuccess',
  },
  'CucsFabricTargetStatus' => {
    '0' => 'valid',
    '1' => 'invalid',
  },
  'CucsGlConflict' => {
    '0' => 'noConflict',
    '1' => 'hasConflict',
  },
  'CucsQueryresultOrgCategory' => {
    '0' => 'unspecified',
    '1' => 'orgOrg',
    '2' => 'domainOrg',
  },
  'CucsFabricAEthEstcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsLsbootSanImageType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsSwFcoeSanEpUdldAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsLstorageRemoteCtrlServiceAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'inService',
    '3' => 'inMaintenance',
  },
  'CucsEquipmentServerSiocConnState' => {
    '0' => 'singleServerSingleSioc',
    '1' => 'singleServerDualSioc',
  },
  'CucsBiosVfPSTATECoordinationVpPSTATECoordination' => {
    '0' => 'platformRecommended',
    '432' => 'hwAll',
    '433' => 'swAll',
    '434' => 'swAny',
  },
  'CucsFabricSanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsEquipmentPsuFsmStageName' => {
    '0' => 'nop',
    '1808' => 'updatePSUBegin',
    '1809' => 'updatePSUUpdateRequest',
    '1810' => 'updatePSUPollUpdateStatus',
    '1811' => 'updatePSUActivatePsu',
    '1812' => 'updatePSUPollActivateStatus',
    '1821' => 'updatePSUFail',
    '1822' => 'updatePSUSuccess',
  },
  'CucsMoMoClassId' => {
    '0' => 'unspecified',
    '1' => 'moTopProps',
    '2' => 'topRoot',
    '3' => 'topSystem',
    '4' => 'fsmTask',
    '5' => 'namingNamedObject',
    '6' => 'namingNamedIdentifiedObject',
    '7' => 'conditionInfo',
    '8' => 'namingObject',
    '9' => 'namingDefinition',
    '10' => 'namingHolder',
    '11' => 'namingBinding',
    '12' => 'conditionPolicy',
    '13' => 'conditionLog',
    '14' => 'policyTracker',
    '15' => 'policyTracked',
    '16' => 'aaaUserAction',
    '17' => 'aaaModLR',
    '18' => 'aaaSessionLR',
    '19' => 'eventEpCtrl',
    '20' => 'eventLog',
    '21' => 'eventRecord',
    '22' => 'eventHolder',
    '23' => 'eventInst',
    '24' => 'eventPolicy',
    '25' => 'faultHolder',
    '26' => 'faultInst',
    '27' => 'faultPolicy',
    '28' => 'statsItem',
    '29' => 'statsCurr',
    '30' => 'statsHist',
    '31' => 'statsHolder',
    '32' => 'statsCollectionPolicy',
    '33' => 'statsThresholdPolicy',
    '34' => 'statsThresholdClass',
    '35' => 'statsThresholdDefinition',
    '36' => 'statsThr32Definition',
    '37' => 'statsThr64Definition',
    '38' => 'statsThrFloatDefinition',
    '39' => 'statsThresholdValue',
    '40' => 'statsThr32Value',
    '41' => 'statsThr64Value',
    '42' => 'statsThrFloatValue',
    '43' => 'equipmentPOSTCodeReporter',
    '44' => 'equipmentPOSTCodeData',
    '45' => 'equipmentPOSTCode',
    '46' => 'equipmentPOST',
    '47' => 'swatInjection',
    '48' => 'swatTrigger',
    '49' => 'swatCondition',
    '50' => 'swatTarget',
    '51' => 'swatAction',
    '52' => 'swatResultstats',
    '53' => 'apeControllerManager',
    '54' => 'apeControllerChassis',
    '55' => 'apeControllerEeprom',
    '56' => 'apeNicAgManager',
    '57' => 'apeAdapter',
    '58' => 'apeMenlo',
    '59' => 'apePalo',
    '60' => 'apeAdapterVnic',
    '61' => 'apeMenloVnic',
    '62' => 'apeMenloVnicStats',
    '63' => 'apeManager',
    '64' => 'apeMc',
    '65' => 'apeMcTable',
    '66' => 'apeFru',
    '67' => 'apeSdr',
    '68' => 'apeReading',
    '69' => 'apeParam',
    '70' => 'apeBootMethod',
    '71' => 'firmwareStoragePack',
    '72' => 'apeSANBoot',
    '73' => 'apeLocalDiskBoot',
    '74' => 'apeVirtualMediaBoot',
    '75' => 'apeHostAgent',
    '76' => 'clitestTypeTest',
    '77' => 'clitestTypeTestParent',
    '78' => 'clitestTypeTestChild',
    '79' => 'clitestTypeTest2',
    '80' => 'fabricInternalDceSrv',
    '81' => 'fabricDceSrv',
    '82' => 'mgmtAbsDataItem',
    '83' => 'mgmtDataItem',
    '84' => 'mgmtImportItem',
    '85' => 'fabricDceSwSrvEp',
    '86' => 'fabricSan',
    '87' => 'fabricFcSan',
    '88' => 'mgmtEp',
    '89' => 'mgmtSvc',
    '90' => 'fabricFcSanEp',
    '91' => 'fabricFcSanPcEp',
    '92' => 'fabricSanPc',
    '93' => 'fabricFcSanPc',
    '94' => 'fabricFcVsanPortEp',
    '95' => 'fabricSanPinGroup',
    '96' => 'fabricSanPinTarget',
    '97' => 'fabricEp',
    '98' => 'fabricCloud',
    '99' => 'testingServiceProfile',
    '100' => 'testingSnmpPolicy',
    '101' => 'testingCliPolicy',
    '102' => 'testingSnmpSupport',
    '103' => 'testingSnmpCommunity',
    '104' => 'testingSnmpTrap',
    '105' => 'fabricExternalEp',
    '106' => 'fabricInternalEp',
    '107' => 'fabricCIoEp',
    '108' => 'fabricExternalPc',
    '109' => 'fabricInternalPc',
    '110' => 'fabricPinGroup',
    '111' => 'fabricPinTarget',
    '112' => 'fabricLan',
    '113' => 'fabricEthLan',
    '114' => 'licenseLicense',
    '115' => 'fabricAEthLanEp',
    '116' => 'fabricEthLanEp',
    '117' => 'fabricEthLanPcEp',
    '118' => 'fabricLanPc',
    '119' => 'fabricEthLanPc',
    '120' => 'fabricLanPinGroup',
    '121' => 'fabricLanPinTarget',
    '122' => 'fabricLocale',
    '123' => 'fabricPath',
    '124' => 'orgAOrg',
    '125' => 'fabricPathConn',
    '126' => 'fabricVnetEp',
    '127' => 'networkCACert',
    '128' => 'networkSystemCACert',
    '129' => 'fabricAVsan',
    '130' => 'fabricEpVsan',
    '131' => 'fabricVsan',
    '132' => 'fabricVsanEp',
    '133' => 'fabricVlan',
    '134' => 'fabricSwChEp',
    '135' => 'fabricSwChPhEp',
    '136' => 'fabricComputeEp',
    '137' => 'fabricChassisEp',
    '138' => 'fabricComputeSlotEp',
    '139' => 'fabricIf',
    '140' => 'fabricComputePhEp',
    '141' => 'fabricLastAckedSlot',
    '142' => 'processorUnit',
    '143' => 'trigServerToken',
    '144' => 'trigTokenRequestor',
    '145' => 'processorThread',
    '146' => 'processorRuntime',
    '147' => 'processorRuntimeHist',
    '148' => 'processorQual',
    '149' => 'fcPIo',
    '150' => 'fcConfig',
    '151' => 'fcIfConfig',
    '152' => 'fcSwIfConfig',
    '153' => 'fcNicIfConfig',
    '154' => 'fcStats',
    '155' => 'fcStatsHist',
    '156' => 'fcErrStats',
    '157' => 'fcErrStatsHist',
    '158' => 'poolAsnmt',
    '159' => 'vnicTempl',
    '160' => 'vnicSanConnTempl',
    '161' => 'vnicLanConnTempl',
    '162' => 'vnicL3If',
    '163' => 'vnicIPIf',
    '164' => 'vnicIPv4If',
    '165' => 'vnicIpAddr',
    '166' => 'vnicIpV4Addr',
    '167' => 'vnicIpV4StaticAddr',
    '168' => 'vnicIpV4PooledAddr',
    '169' => 'vnicIPv4Dhcp',
    '170' => 'vnicIPv4Dns',
    '171' => 'vnicIPv4StaticRoute',
    '172' => 'vnicConnection',
    '173' => 'vnicNicConn',
    '174' => 'vnicVnic',
    '175' => 'vnicIf',
    '176' => 'vnicL2Lif',
    '177' => 'vnicEthLif',
    '178' => 'vnicFcLif',
    '179' => 'vnicLifVlan',
    '180' => 'vnicLifVsan',
    '181' => 'vnicL2If',
    '182' => 'vnicAFcIf',
    '183' => 'vnicEtherBaseIf',
    '184' => 'vnicAEtherIf',
    '185' => 'vnicAIpcIf',
    '186' => 'vnicAScsiIf',
    '187' => 'vnicFcOEIf',
    '188' => 'vnicFcIf',
    '189' => 'vnicEtherIf',
    '190' => 'vnicIpcIf',
    '191' => 'vnicScsiIf',
    '192' => 'vnicProfileSet',
    '193' => 'vnicProfile',
    '194' => 'vnicProfileAlias',
    '195' => 'vnicDynamicConReq',
    '196' => 'vnicDynamicConPolicy',
    '197' => 'vnicDynamicCon',
    '198' => 'vnicDynamicIdUniverse',
    '199' => 'vnicDynamicProvider',
    '200' => 'vnicDynamicProviderEp',
    '201' => 'vnicFcNode',
    '202' => 'vnicFcBase',
    '203' => 'vnicFc',
    '204' => 'vnicEtherBase',
    '205' => 'vnicEther',
    '206' => 'vnicIpc',
    '207' => 'vnicScsi',
    '208' => 'vnicBootTarget',
    '209' => 'lsbootItem',
    '210' => 'lsbootADef',
    '211' => 'lsbootPolicy',
    '212' => 'lsbootDef',
    '213' => 'lsbootCategory',
    '214' => 'lsbootStorage',
    '215' => 'lsbootLan',
    '216' => 'lsbootVirtualMedia',
    '217' => 'lsbootImage',
    '218' => 'lsbootRemoteImage',
    '219' => 'lsbootSanImage',
    '220' => 'lsbootLocalImage',
    '221' => 'lsbootLocalStorage',
    '222' => 'lsbootImagePath',
    '223' => 'lsbootLanImagePath',
    '224' => 'lsbootSanImagePath',
    '225' => 'procManager',
    '226' => 'procProcCounts',
    '227' => 'procTxCounts',
    '228' => 'procStimulusCounts',
    '229' => 'procPrtCounts',
    '230' => 'procProcs',
    '231' => 'procPrt',
    '232' => 'procDoer',
    '233' => 'storageController',
    '234' => 'storageUnit',
    '235' => 'storagePhysical',
    '236' => 'storageLogical',
    '237' => 'storageLocalLun',
    '238' => 'storageLocalDisk',
    '239' => 'storageLunDisk',
    '240' => 'storageQual',
    '241' => 'storageItem',
    '242' => 'storageLocalDiskConfig',
    '243' => 'storageLocalDiskConfigPolicy',
    '244' => 'storageLocalDiskConfigDef',
    '245' => 'storageLocalDiskPartition',
    '246' => 'memoryArray',
    '247' => 'memoryUnit',
    '248' => 'orgDomainGroup',
    '249' => 'memoryRuntimeHist',
    '250' => 'memoryQual',
    '251' => 'aaaRealm',
    '252' => 'aaaAuthRealm',
    '253' => 'aaaEp',
    '254' => 'aaaRadiusEp',
    '255' => 'aaaLdapEp',
    '256' => 'eventApplication',
    '257' => 'guiGuiCont',
    '258' => 'guiGuiComponent',
    '259' => 'aaaLdapProvider',
    '260' => 'aaaTacacsPlusProvider',
    '261' => 'pkiEp',
    '262' => 'pkiItem',
    '263' => 'pkiCertReq',
    '264' => 'pkiKeyRing',
    '265' => 'pkiTP',
    '266' => 'aaaDefinition',
    '267' => 'commDefinition',
    '268' => 'pkiDefinition',
    '269' => 'commSvcEp',
    '270' => 'commSvcChannel',
    '271' => 'commWebChannel',
    '272' => 'commEvtChannel',
    '273' => 'commSvc',
    '274' => 'commWeb',
    '275' => 'commHttp',
    '276' => 'versionProduct',
    '277' => 'commWsman',
    '278' => 'commCimxml',
    '279' => 'commShell',
    '280' => 'commTelnet',
    '281' => 'policyLogProfile',
    '282' => 'policyDeviceProfile',
    '283' => 'commSnmp',
    '284' => 'commDateTime',
    '285' => 'commSnmpTrap',
    '286' => 'commDns',
    '287' => 'commClient',
    '288' => 'commNtpProvider',
    '289' => 'mgmtAbsBackup',
    '290' => 'commSyslog',
    '291' => 'mgmtAbsImporter',
    '292' => 'commSyslogMonitor',
    '293' => 'mgmtDataExporter',
    '294' => 'mgmtDataImporter',
    '295' => 'mgmtRegistryInfo',
    '296' => 'aaaSystemUser',
    '297' => 'aaaEpAuthProfile',
    '298' => 'aaaUserLogin',
    '299' => 'aaaShellLogin',
    '300' => 'aaaWebLogin',
    '301' => 'aaaEpLogin',
    '302' => 'aaaRemoteUser',
    '303' => 'aaaEpUser',
    '304' => 'aaaUser',
    '305' => 'aaaSshAuth',
    '306' => 'aaaUserRole',
    '307' => 'aaaRole',
    '308' => 'aaaUserLocale',
    '309' => 'aaaLocale',
    '310' => 'aaaOrg',
    '311' => 'aaaSession',
    '312' => 'dcxVifEp',
    '313' => 'dcxVc',
    '314' => 'dcxVIf',
    '315' => 'dcxUniverse',
    '316' => 'dcxNs',
    '317' => 'adaptorFruCapProvider',
    '318' => 'adaptorFwCapProvider',
    '319' => 'adaptorCapDef',
    '320' => 'adaptorCapQual',
    '321' => 'mgmtDataExporterFsmTask',
    '322' => 'mgmtDataImporterFsmTask',
    '323' => 'adaptorBehCap',
    '324' => 'mgmtRegistryInfoFsmTask',
    '325' => 'networkElementFsmTask',
    '326' => 'adaptorNwMgmtCap',
    '327' => 'orgOrgFsmTask',
    '328' => 'adaptorUnit',
    '329' => 'adaptorHostIf',
    '330' => 'adaptorHostEthIf',
    '331' => 'adaptorHostFcIf',
    '332' => 'adaptorExtIf',
    '333' => 'adaptorExtEthIf',
    '334' => 'testingServiceProfileFsmTask',
    '335' => 'topSystemFsmTask',
    '336' => 'versionMatrix',
    '337' => 'versionFilter',
    '338' => 'adaptorEthPortStatsHist',
    '341' => 'adaptorEthPortBySizeSmallStats',
    '342' => 'adaptorEthPortBySizeSmallStatsHist',
    '343' => 'adaptorEthPortBySizeLargeStats',
    '344' => 'adaptorEthPortBySizeLargeStatsHist',
    '345' => 'adaptorEthPortOutsizedStats',
    '346' => 'adaptorEthPortOutsizedStatsHist',
    '347' => 'adaptorEthPortMcastStats',
    '348' => 'adaptorEthPortMcastStatsHist',
    '349' => 'adaptorEthPortErrStats',
    '350' => 'adaptorEthPortErrStatsHist',
    '351' => 'adaptorFcPortStats',
    '352' => 'adaptorFcPortStatsHist',
    '353' => 'adaptorVnicStats',
    '354' => 'identpoolMetaVerse',
    '355' => 'identpoolMetaSystem',
    '356' => 'identpoolUniverse',
    '357' => 'identpoolElement',
    '358' => 'identpoolPoolable',
    '359' => 'identpoolConsumed',
    '360' => 'adaptorMenloMcpuStatsHist',
    '361' => 'adaptorMenloMcpuErrorStats',
    '362' => 'adaptorMenloMcpuErrorStatsHist',
    '363' => 'adaptorMenloEthStats',
    '364' => 'adaptorMenloEthStatsHist',
    '365' => 'adaptorMenloEthErrorStats',
    '366' => 'adaptorMenloEthErrorStatsHist',
    '367' => 'adaptorMenloFcStats',
    '368' => 'adaptorMenloFcStatsHist',
    '369' => 'adaptorMenloFcErrorStats',
    '370' => 'adaptorMenloFcErrorStatsHist',
    '371' => 'adaptorMenloQStats',
    '372' => 'adaptorMenloQStatsHist',
    '373' => 'adaptorMenloQErrorStats',
    '374' => 'adaptorMenloQErrorStatsHist',
    '375' => 'identpoolPool',
    '376' => 'adaptorMenloNetEgStatsHist',
    '377' => 'adaptorMenloNetInStats',
    '378' => 'firmwareDownloadPolicy',
    '379' => 'adaptorMenloHostPortStats',
    '380' => 'adaptorMenloHostPortStatsHist',
    '381' => 'adaptorMenloDcePortStats',
    '382' => 'adaptorMenloDcePortStatsHist',
    '383' => 'adaptorEtherIfStats',
    '384' => 'adaptorEtherIfStatsHist',
    '385' => 'adaptorFcIfFrameStats',
    '386' => 'adaptorFcIfFrameStatsHist',
    '387' => 'orgDomainGroupPolicy',
    '388' => 'computeSystemQual',
    '389' => 'adaptorHostIfProfile',
    '390' => 'computeSystemAddrQual',
    '391' => 'computeSiteQual',
    '392' => 'computeOwnerQual',
    '393' => 'adaptorQueueProfile',
    '394' => 'configCatalogue',
    '395' => 'configConsumerCatalogue',
    '396' => 'configBackup',
    '397' => 'adaptorEthWorkQueueProfile',
    '398' => 'nfsExportDef',
    '399' => 'nfsClientDef',
    '400' => 'adaptorEthInterruptProfile',
    '401' => 'consumerUniverse',
    '402' => 'consumerInst',
    '403' => 'adaptorTcpIpRssHashProfile',
    '404' => 'adaptorIpV4RssHashProfile',
    '405' => 'adaptorIpV6RssHashProfile',
    '406' => 'adaptorExtIpV6RssHashProfile',
    '407' => 'firmwareRemoteCatalogue',
    '408' => 'adaptorEthFailoverProfile',
    '409' => 'adaptorFcRecvQueueProfile',
    '410' => 'firmwareSource',
    '411' => 'configBackupFsmTask',
    '412' => 'configConsumerCatalogueFsmTask',
    '413' => 'consumerInstFsmTask',
    '414' => 'adaptorFcPortProfile',
    '415' => 'adaptorFcErrorRecoveryProfile',
    '416' => 'sysfileEp',
    '417' => 'sysfileRepository',
    '418' => 'sysfileExporter',
    '419' => 'sysfileImporter',
    '420' => 'sysfileMutation',
    '421' => 'sysfileInstance',
    '422' => 'sysdebugEp',
    '423' => 'sysdebugRepository',
    '424' => 'sysdebugCoreFileRepository',
    '425' => 'sysdebugExporter',
    '426' => 'sysdebugCoreFileExportTarget',
    '427' => 'sysdebugAutoCoreFileExportTarget',
    '428' => 'sysdebugManualCoreFileExportTarget',
    '429' => 'sysdebugFile',
    '430' => 'sysdebugCore',
    '431' => 'sysdebugLogControlEp',
    '432' => 'sysdebugLogControlDomain',
    '433' => 'sysdebugLogControlModule',
    '434' => 'sysdebugLogControlDestinationFile',
    '435' => 'sysdebugLogControlDestinationSyslog',
    '436' => 'ruleDefinition',
    '437' => 'ruleItem',
    '438' => 'ruleRequirement',
    '439' => 'ruleSizeRequirement',
    '440' => 'swDomain',
    '441' => 'swPIoEp',
    '442' => 'swCIoEp',
    '443' => 'swBorderDomain',
    '444' => 'swBorderEp',
    '445' => 'swBorderPc',
    '446' => 'swLanBorder',
    '447' => 'swLanEp',
    '448' => 'swLanPc',
    '449' => 'swEthLanBorder',
    '450' => 'swEthLanEp',
    '451' => 'swEthLanPc',
    '452' => 'swVlan',
    '453' => 'swUlan',
    '454' => 'swAccessDomain',
    '455' => 'swAccessEp',
    '456' => 'swUtilityDomain',
    '457' => 'swSanBorder',
    '458' => 'swSanEp',
    '459' => 'swFcSanBorder',
    '460' => 'swFcSanEp',
    '461' => 'swVsan',
    '462' => 'swEnvStats',
    '463' => 'swEnvStatsHist',
    '464' => 'swSystemStats',
    '465' => 'swSystemStatsHist',
    '466' => 'networkruleDefinition',
    '467' => 'networkruleItem',
    '468' => 'networkruleRequirement',
    '469' => 'etherPIo',
    '470' => 'etherServerIntFIo',
    '471' => 'etherSwitchIntFIo',
    '472' => 'etherConfig',
    '473' => 'etherIfConfig',
    '474' => 'etherSwIfConfig',
    '475' => 'etherNicIfConfig',
    '476' => 'etherTxStats',
    '477' => 'etherTxStatsHist',
    '478' => 'etherRxStats',
    '479' => 'etherRxStatsHist',
    '480' => 'etherErrStats',
    '481' => 'etherErrStatsHist',
    '482' => 'etherLossStats',
    '483' => 'etherLossStatsHist',
    '484' => 'syntheticDirectory',
    '485' => 'syntheticFile',
    '486' => 'syntheticFsObj',
    '487' => 'syntheticTime',
    '488' => 'syntheticFileSystem',
    '489' => 'firmwareCapProvider',
    '490' => 'firmwareCatalogue',
    '491' => 'firmwareUnit',
    '492' => 'firmwareRunning',
    '493' => 'firmwareUpdatable',
    '494' => 'firmwareBootUnit',
    '495' => 'firmwareBootDefinition',
    '496' => 'firmwareImage',
    '497' => 'firmwareInstallable',
    '498' => 'firmwareDistImage',
    '499' => 'firmwareDistributable',
    '500' => 'firmwareDownloader',
    '501' => 'firmwareCompItem',
    '502' => 'firmwareCompSource',
    '503' => 'firmwareCompTarget',
    '504' => 'firmwarePack',
    '505' => 'firmwarePackItem',
    '506' => 'firmwareComputePack',
    '507' => 'firmwareComputeHostPack',
    '508' => 'firmwareComputeMgmtPack',
    '509' => 'firmwareType',
    '510' => 'firmwareDependency',
    '511' => 'osInstance',
    '512' => 'osAgent',
    '513' => 'capabilityCatalogue',
    '514' => 'capabilityProvider',
    '515' => 'capabilityDef',
    '516' => 'capabilityItem',
    '517' => 'portGroup',
    '518' => 'portPhysSwitchIo',
    '519' => 'portPIo',
    '520' => 'portIntFIo',
    '521' => 'portServerIntFIo',
    '522' => 'portSwitchIntFIo',
    '523' => 'portDomainEp',
    '524' => 'policyObject',
    '525' => 'policyHolder',
    '526' => 'policyBinding',
    '527' => 'policyDefinition',
    '528' => 'orgOrg',
    '529' => 'callhomeEp',
    '530' => 'callhomeSource',
    '531' => 'callhomeSmtp',
    '532' => 'callhomePeriodicSystemInventory',
    '533' => 'callhomeProfile',
    '534' => 'callhomeDest',
    '535' => 'callhomePolicy',
    '536' => 'callhomeTestAlert',
    '537' => 'networkEp',
    '538' => 'networkIfEp',
    '539' => 'networkPhysEp',
    '540' => 'networkPIoEp',
    '541' => 'networkCIoEp',
    '542' => 'networkVnetEp',
    '543' => 'networkDomainEp',
    '544' => 'networkElement',
    '545' => 'networkConn',
    '546' => 'networkIfStats',
    '547' => 'uuidpoolPool',
    '548' => 'uuidpoolPooled',
    '549' => 'uuidpoolBlock',
    '550' => 'uuidpoolAddr',
    '551' => 'uuidpoolFormat',
    '552' => 'uuidpoolPoolable',
    '553' => 'uuidpoolUniverse',
    '554' => 'mgmtEntity',
    '555' => 'mgmtBackup',
    '556' => 'mgmtImporter',
    '557' => 'mgmtAccessPolicy',
    '558' => 'mgmtAccessPolicyItem',
    '559' => 'mgmtAccessPort',
    '560' => 'mgmtIntAuthPolicy',
    '561' => 'mgmtController',
    '562' => 'mgmtIf',
    '563' => 'ippoolPool',
    '564' => 'ippoolPooled',
    '565' => 'ippoolBlock',
    '566' => 'ippoolAddr',
    '567' => 'ippoolPoolable',
    '568' => 'ippoolUniverse',
    '569' => 'poolUniverse',
    '570' => 'poolElement',
    '571' => 'poolPoolable',
    '572' => 'poolPoolMember',
    '573' => 'poolPool',
    '574' => 'computeConfigPolicy',
    '575' => 'computeInitConfigPolicy',
    '576' => 'computeAutoconfigPolicy',
    '577' => 'computeBladeInheritPolicy',
    '578' => 'computeScrubPolicy',
    '579' => 'computeDiscPolicy',
    '580' => 'computeBladeDiscPolicy',
    '581' => 'computeChassisDiscPolicy',
    '582' => 'computePsuDef',
    '583' => 'computePsuPolicy',
    '584' => 'computePsuControl',
    '585' => 'computePool',
    '586' => 'computePoolable',
    '587' => 'computePooled',
    '588' => 'computePooledPhysical',
    '589' => 'computePooledSlot',
    '590' => 'computePoolingPolicy',
    '591' => 'computeQual',
    '592' => 'nfsRepositorySpecPolicy',
    '593' => 'computeBladePosQual',
    '594' => 'computeChassisQual',
    '595' => 'computeSlotQual',
    '596' => 'computeQualifiedPolicy',
    '597' => 'computeContainer',
    '598' => 'computeItem',
    '599' => 'computePhysical',
    '600' => 'computeLogical',
    '601' => 'computeVirtualContainer',
    '602' => 'computeVirtual',
    '603' => 'computePartition',
    '604' => 'memoryErrorStatsHist',
    '605' => 'computeBoard',
    '606' => 'computeMbPowerStats',
    '607' => 'computeMbPowerStatsHist',
    '608' => 'computeMbTempStats',
    '609' => 'computeMbTempStatsHist',
    '614' => 'lsTier',
    '615' => 'lsServer',
    '616' => 'lsPower',
    '617' => 'lsComputeBinding',
    '618' => 'lsBinding',
    '619' => 'lsRequirement',
    '620' => 'lsAgentPolicy',
    '621' => 'vmEp',
    '622' => 'vmInstance',
    '623' => 'vmAdaptor',
    '624' => 'vmNic',
    '625' => 'vmHba',
    '626' => 'vmVlan',
    '627' => 'vmVsan',
    '628' => 'extvmmEp',
    '629' => 'extvmmProvider',
    '632' => 'fcpoolInitiators',
    '633' => 'fcpoolInitiator',
    '634' => 'fcpoolBlock',
    '635' => 'fcpoolFormat',
    '636' => 'fcpoolAddr',
    '637' => 'fcpoolPoolable',
    '638' => 'fcpoolUniverse',
    '639' => 'fcpoolBootTarget',
    '640' => 'macpoolPool',
    '641' => 'macpoolPooled',
    '642' => 'macpoolFormat',
    '643' => 'macpoolBlock',
    '644' => 'macpoolAddr',
    '645' => 'macpoolPoolable',
    '646' => 'macpoolUniverse',
    '647' => 'solDef',
    '648' => 'solConfig',
    '649' => 'solPolicy',
    '650' => 'solIf',
    '651' => 'dpsecMac',
    '652' => 'qosclassDefinition',
    '653' => 'qosclassItem',
    '654' => 'qosclassFc',
    '655' => 'qosclassEth',
    '656' => 'qosclassEthBE',
    '658' => 'qosclassEthClassified',
    '659' => 'qosDefinition',
    '660' => 'qosItem',
    '661' => 'epqosDefinition',
    '662' => 'epqosDefinitionDelTask',
    '663' => 'epqosItem',
    '664' => 'epqosEgress',
    '665' => 'equipmentHwCapProvider',
    '666' => 'equipmentBehCap',
    '667' => 'equipmentFruCapProvider',
    '668' => 'equipmentIntegratedComponentCapProvider',
    '669' => 'equipmentHolderCapProvider',
    '670' => 'equipmentSwitchCapProvider',
    '671' => 'equipmentMgmtCapProvider',
    '672' => 'equipmentChassisCapProvider',
    '673' => 'equipmentBladeCapProvider',
    '674' => 'equipmentBaseBoardCapProvider',
    '675' => 'equipmentBladeBiosCapProvider',
    '676' => 'equipmentLocalDiskCapProvider',
    '677' => 'equipmentLocalDiskControllerCapProvider',
    '678' => 'equipmentHostIfCapProvider',
    '679' => 'equipmentProcessorUnitCapProvider',
    '680' => 'equipmentMemoryUnitCapProvider',
    '681' => 'equipmentIOCardCapProvider',
    '682' => 'equipmentPsuCapProvider',
    '683' => 'equipmentFanModuleCapProvider',
    '684' => 'equipmentGemCapProvider',
    '685' => 'equipmentManufacturingDef',
    '686' => 'equipmentPhysicalDef',
    '687' => 'equipmentServiceDef',
    '688' => 'equipmentAdaptorDef',
    '689' => 'equipmentProcessorUnitDef',
    '690' => 'equipmentSlotArrayRef',
    '691' => 'equipmentSlotArray',
    '692' => 'equipmentItem',
    '693' => 'equipmentStateful',
    '694' => 'equipmentHolder',
    '695' => 'equipmentStatefulChComp',
    '696' => 'equipmentStatefulBladeComp',
    '697' => 'equipmentPsu',
    '698' => 'equipmentFanModule',
    '699' => 'equipmentFan',
    '700' => 'equipmentEnvSensor',
    '701' => 'equipmentCard',
    '702' => 'equipmentSwitchCard',
    '703' => 'equipmentChassis',
    '704' => 'equipmentIOCard',
    '705' => 'equipmentLed',
    '706' => 'processorErrorStatsHist',
    '707' => 'equipmentLocatorLed',
    '708' => 'equipmentChassisStats',
    '709' => 'equipmentChassisStatsHist',
    '712' => 'equipmentPsuStats',
    '713' => 'equipmentPsuStatsHist',
    '714' => 'equipmentPsuInputStats',
    '715' => 'equipmentPsuInputStatsHist',
    '716' => 'equipmentFanModuleStats',
    '717' => 'equipmentFanModuleStatsHist',
    '718' => 'equipmentFanStats',
    '719' => 'equipmentFanStatsHist',
    '720' => 'flowctrlDefinition',
    '721' => 'flowctrlItem',
    '722' => 'computePCIeFatalStatsHist',
    '723' => 'aaaRealmFsmTask',
    '724' => 'orgOrgSource',
    '725' => 'adaptorHostFcIfFsmTask',
    '726' => 'extpolDomain',
    '727' => 'commSvcEpFsmTask',
    '728' => 'computeBladeFsmTask',
    '729' => 'epqosDefinitionDelTaskFsmTask',
    '730' => 'epqosDefinitionFsmTask',
    '731' => 'equipmentChassisFsmTask',
    '732' => 'equipmentIOCardFsmTask',
    '733' => 'equipmentLocatorLedFsmTask',
    '734' => 'extvmmEpFsmTask',
    '736' => 'configAppImpactResponse',
    '737' => 'fabricComputeSlotEpFsmTask',
    '738' => 'fabricLanCloudFsmTask',
    '739' => 'firmwareDownloaderFsmTask',
    '740' => 'firmwareImageFsmTask',
    '741' => 'mgmtBackupFsmTask',
    '742' => 'mgmtControllerFsmTask',
    '743' => 'mgmtIfFsmTask',
    '744' => 'mgmtImporterFsmTask',
    '745' => 'pkiEpFsmTask',
    '746' => 'qosclassDefinitionFsmTask',
    '747' => 'statsCollectionPolicyFsmTask',
    '748' => 'swAccessDomainFsmTask',
    '749' => 'swEthLanBorderFsmTask',
    '750' => 'swFcSanBorderFsmTask',
    '751' => 'swUtilityDomainFsmTask',
    '752' => 'syntheticFsObjFsmTask',
    '753' => 'sysdebugAutoCoreFileExportTargetFsmTask',
    '754' => 'sysdebugLogControlEpFsmTask',
    '755' => 'sysdebugManualCoreFileExportTargetFsmTask',
    '756' => 'sysfileMutationFsmTask',
    '757' => 'vnicProfileSetFsmTask',
    '758' => 'vnicDefBeh',
    '759' => 'equipmentLocalDiskDef',
    '762' => 'sysdebugMEpLog',
    '763' => 'identpoolBlockQual',
    '764' => 'identpoolQualItem',
    '765' => 'identpoolIPQual',
    '766' => 'identpoolDomainGroupQual',
    '767' => 'nfsExportDefFsmTask',
    '768' => 'biosBOT',
    '769' => 'biosBootDevGrp',
    '770' => 'biosBootDev',
    '771' => 'etherPauseStats',
    '772' => 'etherPauseStatsHist',
    '773' => 'adaptorSanCap',
    '774' => 'memoryArrayEnvStats',
    '775' => 'memoryArrayEnvStatsHist',
    '776' => 'memoryUnitEnvStats',
    '777' => 'memoryUnitEnvStatsHist',
    '778' => 'processorEnvStats',
    '779' => 'processorEnvStatsHist',
    '780' => 'aaaExtMgmtCutThruTkn',
    '781' => 'nwctrlDefinition',
    '786' => 'lsSPMeta',
    '789' => 'fabricVCon',
    '790' => 'fabricVConProfile',
    '793' => 'vmCont',
    '794' => 'vmDirCont',
    '795' => 'vmDCOrg',
    '796' => 'vmDC',
    '797' => 'vmOrg',
    '798' => 'vmSwitch',
    '799' => 'vmVnicProfInst',
    '800' => 'vmVnicProfCl',
    '801' => 'vmVirtual',
    '802' => 'vmHv',
    '803' => 'extvmmMasterExtKey',
    '804' => 'extvmmKeyInst',
    '805' => 'extvmmKeyStore',
    '806' => 'extvmmKeyRing',
    '807' => 'extvmmSwitchDelTask',
    '808' => 'biosVfIntelTurboBoostTech',
    '809' => 'biosVfEnhancedIntelSpeedStepTech',
    '810' => 'biosVfIntelHyperThreadingTech',
    '811' => 'biosVfCoreMultiProcessing',
    '812' => 'biosVfExecuteDisableBit',
    '813' => 'biosVfIntelVirtualizationTechnology',
    '814' => 'biosVfIntelVTForDirectedIO',
    '817' => 'biosVfDirectCacheAccess',
    '818' => 'biosVfSelectMemoryRASConfiguration',
    '819' => 'biosVfNUMAOptimized',
    '820' => 'biosVfIntelEntrySASRAIDModule',
    '822' => 'biosVfOnboardSATAController',
    '823' => 'biosVfSerialPortAEnable',
    '825' => 'fabricEtherRef',
    '826' => 'biosVfMemoryMappedIOAbove4GB',
    '828' => 'biosVfFrontPanelLockout',
    '829' => 'changeEp',
    '830' => 'biosVfAssertNMIOnSERR',
    '831' => 'biosVfAssertNMIOnPERR',
    '832' => 'biosVfResumeOnACPowerLoss',
    '835' => 'biosVfConsoleRedirection',
    '838' => 'policyUniverse',
    '839' => 'policyCluster',
    '840' => 'policySource',
    '841' => 'biosVfPOSTErrorPause',
    '842' => 'biosVProfile',
    '843' => 'biosVFeat',
    '845' => 'powerAGroup',
    '848' => 'powerABudget',
    '849' => 'powerGroup',
    '850' => 'powerBudget',
    '851' => 'sysdebugMEpLogDef',
    '852' => 'sysdebugMEpLogPolicy',
    '853' => 'sysdebugLogBehavior',
    '854' => 'sysdebugBackupBehavior',
    '857' => 'bmcSELCounter',
    '860' => 'computeBehCap',
    '861' => 'computePciCap',
    '862' => 'extvmmKeyStoreFsmTask',
    '863' => 'fabricConsumer',
    '864' => 'extvmmSwitchDelTaskFsmTask',
    '869' => 'biosVfUSBBootConfig',
    '870' => 'biosVfProcessorC3Report',
    '871' => 'biosVfProcessorC6Report',
    '873' => 'biosVfOSBootWatchdogTimer',
    '874' => 'biosVfOSBootWatchdogTimerPolicy',
    '876' => 'biosVfACPI10Support',
    '879' => 'computeMemoryUnitConstraintDef',
    '882' => 'computePCIeFatalProtocolStats',
    '884' => 'computePCIeFatalReceiveStats',
    '885' => 'computeResourceSetManager',
    '886' => 'computeResourceSet',
    '887' => 'computeResourceSetMember',
    '888' => 'computePCIeFatalStats',
    '892' => 'vmLifeCyclePolicy',
    '893' => 'diagSrvCapProvider',
    '894' => 'diagCtrl',
    '895' => 'diagRslt',
    '896' => 'diagSrvCtrl',
    '897' => 'equipmentSwitchCap',
    '898' => 'equipmentMemoryUnitDiscoveryModifierDef',
    '899' => 'extvmmMasterExtKeyFsmTask',
    '900' => 'adaptorFcInterruptProfile',
    '901' => 'capabilityEp',
    '902' => 'capabilityUpdater',
    '903' => 'capabilityUpdate',
    '904' => 'equipmentCatalogCapProvider',
    '905' => 'capabilityUpdaterFsmTask',
    '906' => 'firmwareDistributableFsmTask',
    '907' => 'topMetaInf',
    '908' => 'storageRaidBattery',
    '909' => 'computeRtcBattery',
    '910' => 'vmVif',
    '912' => 'memoryBufferUnit',
    '913' => 'memoryBufferUnitEnvStats',
    '914' => 'memoryBufferUnitEnvStatsHist',
    '915' => 'computeIOHub',
    '916' => 'computeBoardController',
    '917' => 'computeIOHubEnvStats',
    '918' => 'computeIOHubEnvStatsHist',
    '919' => 'diagRunPolicy',
    '920' => 'diagTest',
    '921' => 'diagBladeTest',
    '922' => 'diagNetworkTest',
    '926' => 'biosSettings',
    '931' => 'computeDefaults',
    '932' => 'computePlatform',
    '933' => 'capabilityCatalogueFsmTask',
    '934' => 'swVlanPortNs',
    '935' => 'processorErrorStats',
    '936' => 'biosVfSparingMode',
    '937' => 'biosVfMirroringMode',
    '938' => 'biosVfLvDIMMSupport',
    '940' => 'memoryErrorStats',
    '941' => 'commXmlClConnPolicy',
    '942' => 'computePhysicalQual',
    '943' => 'procSvc',
    '944' => 'apeDcosAgManager',
    '945' => 'apeSwitchFirmwareInv',
    '946' => 'equipmentLocalDiskControllerDef',
    '947' => 'equipmentBoardControllerDef',
    '948' => 'biosARef',
    '949' => 'biosRef',
    '950' => 'biosFeatureRef',
    '951' => 'biosParameterRef',
    '952' => 'biosSettingRef',
    '953' => 'adaptorDiagCap',
    '954' => 'equipmentPOSTCodeContainer',
    '955' => 'equipmentPOSTCodeTemplate',
    '956' => 'fabricFcVsanPc',
    '957' => 'fabricLanMonCloud',
    '958' => 'fabricSanMonCloud',
    '959' => 'fabricEthMonLan',
    '960' => 'fabricFcMonSan',
    '961' => 'fabricMon',
    '962' => 'fabricEthMon',
    '963' => 'fabricFcMon',
    '964' => 'fabricMonDestEp',
    '965' => 'fabricEthMonDestEp',
    '966' => 'fabricFcMonDestEp',
    '967' => 'fabricMonSrcEp',
    '968' => 'fabricEthMonSrcEp',
    '969' => 'fabricFcMonSrcEp',
    '970' => 'fabricMonSrcRef',
    '971' => 'fabricEthMonSrcRef',
    '972' => 'fabricFcMonSrcRef',
    '973' => 'fabricMonSrcFiltEp',
    '974' => 'fabricEthMonFiltEp',
    '975' => 'fabricFcMonFiltEp',
    '976' => 'fabricMonFiltRef',
    '977' => 'fabricEthMonFiltRef',
    '978' => 'fabricFcMonFiltRef',
    '979' => 'fabricFcEstcCloud',
    '980' => 'fabricEthEstcCloud',
    '981' => 'fabricEthVlanPortEp',
    '982' => 'fabricVlanEp',
    '983' => 'fabricExternalEstc',
    '984' => 'fabricFcEstc',
    '985' => 'fabricEthEstc',
    '986' => 'fabricEstcEp',
    '987' => 'fabricAFcEstcEp',
    '988' => 'fabricFcEstcEp',
    '989' => 'fabricAFcoeEstcEp',
    '990' => 'fabricFcoeEstcEp',
    '991' => 'fabricEthEstcEp',
    '992' => 'fabricTargetEp',
    '993' => 'fabricEthTargetEp',
    '994' => 'processorUnitAssocCtx',
    '998' => 'biosVfUEFIOSUseLegacyVideo',
    '999' => 'vnicIpV4AddrConf',
    '1000' => 'vnicIpV4AddrExplConf',
    '1001' => 'vnicIpV4ProfDerivedAddr',
    '1002' => 'storageDevice',
    '1003' => 'storageDrive',
    '1004' => 'aaaConfig',
    '1005' => 'aaaAuthMethod',
    '1006' => 'aaaDefaultAuth',
    '1007' => 'aaaConsoleAuth',
    '1008' => 'aaaDomainAuth',
    '1009' => 'aaaDomain',
    '1010' => 'aaaLdapGroupRule',
    '1011' => 'aaaUserGroup',
    '1012' => 'aaaLdapGroup',
    '1013' => 'aaaProviderGroup',
    '1014' => 'aaaProviderRef',
    '1015' => 'adaptorHwAddrCap',
    '1016' => 'adaptorUplinkHwAddrCap',
    '1017' => 'adaptorHostethHwAddrCap',
    '1018' => 'adaptorHostfcHwAddrCap',
    '1019' => 'adaptorUnitAssocCtx',
    '1020' => 'sysdebugTechSupFileRepository',
    '1021' => 'sysdebugTechSupport',
    '1022' => 'sysdebugTechSupportCmdOpt',
    '1023' => 'powerEp',
    '1024' => 'powerPrioWght',
    '1025' => 'powerPolicy',
    '1026' => 'powerPlacement',
    '1027' => 'powerGroupAdditionPolicy',
    '1028' => 'powerGroupMember',
    '1029' => 'powerChassisMember',
    '1030' => 'powerRackUnitMember',
    '1031' => 'powerGroupQual',
    '1032' => 'powerMgmtPolicy',
    '1033' => 'powerGroupStats',
    '1034' => 'powerGroupStatsHist',
    '1035' => 'swMonSrcEp',
    '1036' => 'swEthMonSrcEp',
    '1037' => 'swFcMonSrcEp',
    '1038' => 'swEstcEp',
    '1039' => 'swFcEstcEp',
    '1040' => 'swEthEstcEp',
    '1041' => 'swTargetEp',
    '1042' => 'swEthTargetEp',
    '1043' => 'swFcoeEstcEp',
    '1044' => 'swMonDomain',
    '1045' => 'swLanMon',
    '1046' => 'swSanMon',
    '1047' => 'swEthLanMon',
    '1048' => 'swFcSanMon',
    '1049' => 'swMon',
    '1050' => 'swEthMon',
    '1051' => 'swFcMon',
    '1052' => 'swMonDestEp',
    '1053' => 'swEthMonDestEp',
    '1054' => 'swFcMonDestEp',
    '1055' => 'swSanPc',
    '1056' => 'swFcSanPc',
    '1057' => 'capabilityMgmtExtension',
    '1058' => 'pciCard',
    '1059' => 'pciUnit',
    '1060' => 'licenseEp',
    '1061' => 'licenseFeature',
    '1062' => 'licenseServerHostId',
    '1063' => 'licenseFile',
    '1064' => 'licenseSource',
    '1065' => 'licenseContents',
    '1066' => 'licenseFeatureLine',
    '1067' => 'licenseInstance',
    '1068' => 'licenseSourceFile',
    '1069' => 'licenseProp',
    '1070' => 'licenseDownloader',
    '1071' => 'licenseCapProvider',
    '1072' => 'licenseFeatureCapProvider',
    '1073' => 'portTrustMode',
    '1074' => 'computePoolPolicyRef',
    '1075' => 'computePooledRackUnit',
    '1076' => 'computePhysicalAssocCtx',
    '1077' => 'computeComputeDiscPolicy',
    '1078' => 'computeServerDiscPolicy',
    '1079' => 'computeRackUnit',
    '1080' => 'lsServerAssocCtx',
    '1081' => 'lsmaintMaintPolicy',
    '1082' => 'lsmaintAck',
    '1083' => 'equipmentPicture',
    '1084' => 'equipmentMgmtExtCapProvider',
    '1085' => 'equipmentRackUnitCapProvider',
    '1086' => 'equipmentBladeAGLibrary',
    '1087' => 'equipmentFexCapProvider',
    '1088' => 'equipmentPciDef',
    '1089' => 'equipmentRaidDef',
    '1090' => 'equipmentPortGroupDef',
    '1091' => 'equipmentAssocCtx',
    '1092' => 'equipmentFexEnvStats',
    '1093' => 'equipmentFexEnvStatsHist',
    '1094' => 'equipmentFexPowerSummary',
    '1095' => 'equipmentFexPowerSummaryHist',
    '1096' => 'equipmentFexPsuInputStats',
    '1097' => 'equipmentFexPsuInputStatsHist',
    '1098' => 'equipmentRackUnitPsuStats',
    '1099' => 'equipmentRackUnitPsuStatsHist',
    '1100' => 'equipmentRackUnitFanStats',
    '1101' => 'equipmentRackUnitFanStatsHist',
    '1102' => 'equipmentFex',
    '1103' => 'dhcpInst',
    '1104' => 'dhcpLease',
    '1105' => 'dhcpAcquired',
    '1106' => 'trigInst',
    '1107' => 'trigWindow',
    '1108' => 'trigSched',
    '1109' => 'trigSchedWindow',
    '1110' => 'trigAbsWindow',
    '1111' => 'trigRecurrWindow',
    '1112' => 'trigMeta',
    '1113' => 'trigTriggered',
    '1114' => 'trigTriggerable',
    '1115' => 'trigTest',
    '1116' => 'trigAck',
    '1117' => 'trigConfAck',
    '1118' => 'trigResAck',
    '1119' => 'capabilityMgmtExtensionFsmTask',
    '1120' => 'computePhysicalFsmTask',
    '1121' => 'computeRackUnitFsmTask',
    '1122' => 'equipmentFexFsmTask',
    '1124' => 'fabricSanCloudFsmTask',
    '1125' => 'licenseDownloaderFsmTask',
    '1126' => 'licenseFileFsmTask',
    '1127' => 'licenseInstanceFsmTask',
    '1128' => 'lsServerFsmTask',
    '1129' => 'swEthMonFsmTask',
    '1130' => 'swFcMonFsmTask',
    '1131' => 'sysdebugTechSupportFsmTask',
    '1132' => 'statsPasadenaCollectionPolicy',
    '1133' => 'statsDbMigrationStatus',
    '1134' => 'statsCustomEp',
    '1135' => 'statsStandardEp',
    '1136' => 'statsChartContainer',
    '1137' => 'statsChart',
    '1138' => 'statsCustomChart',
    '1139' => 'statsStandardChart',
    '1140' => 'adaptorHBAVnicStats',
    '1141' => 'adaptorHBAVnicStatsHist',
    '1142' => 'adaptorNICVnicStats',
    '1143' => 'equipmentGemPortCap',
    '1144' => 'equipmentXcvr',
    '1145' => 'portPIoFsmTask',
    '1146' => 'vnicBootIpPolicy',
    '1147' => 'adaptorLldpCap',
    '1148' => 'lldpAcquired',
    '1149' => 'extmgmtIf',
    '1150' => 'extmgmtIfMonPolicy',
    '1151' => 'extmgmtMiiStatus',
    '1152' => 'extmgmtGatewayPing',
    '1153' => 'extmgmtArpTargets',
    '1154' => 'biosVfOptionROMLoad',
    '1155' => 'firmwareBundleTypeCapProvider',
    '1156' => 'firmwareBundleType',
    '1157' => 'storageEnclosure',
    '1158' => 'sysdebugCoreFsmTask',
    '1159' => 'fabricAEthEstcEp',
    '1160' => 'fabricEstcPc',
    '1161' => 'fabricEthEstcPc',
    '1162' => 'fabricEthEstcPcEp',
    '1163' => 'fabricEthVlanPc',
    '1164' => 'swEthEstcPc',
    '1165' => 'commSyslogSource',
    '1166' => 'firmwareSpec',
    '1167' => 'computeRackUnitMbTempStats',
    '1168' => 'computeRackUnitMbTempStatsHist',
    '1169' => 'storageLocalDiskSlotEp',
    '1170' => 'computeRackPosQual',
    '1171' => 'computeRackQual',
    '1172' => 'biosVfCPUPerformance',
    '1173' => 'fabricFcoeVsanPortEp',
    '1174' => 'pciEquipSlot',
    '1175' => 'equipmentDbgPluginCapProvider',
    '1176' => 'commSvcLimits',
    '1177' => 'commShellSvcLimits',
    '1178' => 'commWebSvcLimits',
    '1179' => 'adaptorFruCapRef',
    '1180' => 'biosVfMaxVariableMTRRSetting',
    '1181' => 'biosVfUSBSystemIdlePowerOptimizingSetting',
    '1182' => 'biosVfUSBFrontPanelAccessLock',
    '1183' => 'biosVfUCSMBootOrderRuleControl',
    '1184' => 'equipmentLocalDiskControllerCapRef',
    '1185' => 'equipmentDiscoveryCap',
    '1186' => 'topSysDefaults',
    '1187' => 'iqnpoolPool',
    '1188' => 'iqnpoolPooled',
    '1189' => 'iqnpoolBlock',
    '1190' => 'iqnpoolAddr',
    '1191' => 'iqnpoolFormat',
    '1192' => 'iqnpoolPoolable',
    '1193' => 'iqnpoolUniverse',
    '1194' => 'fabricSwSrvPc',
    '1195' => 'fabricDceSwSrvPc',
    '1196' => 'fabricDceSwSrvPcEp',
    '1197' => 'fabricEpMgr',
    '1198' => 'biosVfProcessorCState',
    '1199' => 'biosVfProcessorC1E',
    '1200' => 'biosVIdentityParams',
    '1201' => 'vnicIPv4IscsiAddr',
    '1202' => 'vnicIPv4PooledIscsiAddr',
    '1203' => 'vnicVProfileAlias',
    '1204' => 'vnicOProfileAlias',
    '1205' => 'vnicInternalProfile',
    '1206' => 'vnicVlan',
    '1207' => 'vnicIScsiNode',
    '1208' => 'vnicIScsi',
    '1209' => 'vnicIScsiTargetIf',
    '1210' => 'vnicIScsiStaticTargetIf',
    '1211' => 'vnicLun',
    '1212' => 'vnicIScsiAutoTargetIf',
    '1213' => 'lsbootIScsi',
    '1214' => 'lsbootIScsiImagePath',
    '1215' => 'aaaBanner',
    '1216' => 'featureCatalogEp',
    '1217' => 'aaaPwdProfile',
    '1218' => 'featureServerDef',
    '1219' => 'featureStorageDef',
    '1220' => 'featureNetworkDef',
    '1221' => 'featureEnvDef',
    '1222' => 'domainEp',
    '1223' => 'domainFeatureCatalog',
    '1224' => 'adaptorExtIfPc',
    '1225' => 'adaptorExtEthIfPc',
    '1226' => 'adaptorPIoEp',
    '1227' => 'sysdebugTechSupportOperation',
    '1228' => 'lsServerOperation',
    '1229' => 'fabricComputeSlotEpOperation',
    '1230' => 'fabricComputePhEpOperation',
    '1231' => 'fabricSwChPhEpOperation',
    '1232' => 'computeAOperation',
    '1233' => 'computePhysicalOperation',
    '1234' => 'swPhys',
    '1235' => 'swPhysEtherEp',
    '1236' => 'swPhysFcEp',
    '1237' => 'swVlanPortNsOverride',
    '1238' => 'etherPortChanIdElem',
    '1239' => 'etherPortChanIdUniverse',
    '1240' => 'etherCIoEp',
    '1241' => 'etherPc',
    '1242' => 'etherInternalPc',
    '1243' => 'vnicMgmtBase',
    '1244' => 'vnicMgmt',
    '1245' => 'vnicMgmtIf',
    '1246' => 'vnicFault',
    '1247' => 'etherExternalEp',
    '1248' => 'etherIntFIoEp',
    '1249' => 'etherServerIntFIoPcEp',
    '1250' => 'identDomainSyncEp',
    '1251' => 'mgmtPmonEntry',
    '1252' => 'iscsiAuthProfile',
    '1253' => 'iscsiProtocolProfile',
    '1254' => 'configSearchResult',
    '1255' => 'queryEp',
    '1256' => 'vmClientContainer',
    '1257' => 'vmComputeEp',
    '1258' => 'queryDependencyContext',
    '1259' => 'queryImportContext',
    '1260' => 'queryDependencyRef',
    '1261' => 'queryresultDestOrgEp',
    '1262' => 'queryresultDomainGroupEp',
    '1263' => 'queryresultOrgEp',
    '1264' => 'equipmentPortGroupAggregationDef',
    '1265' => 'equipmentPortGroupSwComplexDef',
    '1266' => 'equipmentPortSwComplexRef',
    '1267' => 'equipmentBeaconLed',
    '1268' => 'identpoolDomain',
    '1269' => 'equipmentPsuOutputStatsHist',
    '1270' => 'equipmentNetworkElementFanStats',
    '1271' => 'policySystemProfile',
    '1272' => 'equipmentBeaconLedFsmTask',
    '1273' => 'firmwareInfraPolicy',
    '1274' => 'swPhysFsmTask',
    '1275' => 'vmLifeCyclePolicyFsmTask',
    '1276' => 'firmwareUpgradeConstraint',
    '1277' => 'adaptorFamilyTypeDef',
    '1278' => 'adaptorUnitExtn',
    '1279' => 'extpolRegistryCapability',
    '1280' => 'orgExtension',
    '1281' => 'domainFamilyCapProvider',
    '1282' => 'trigPendingAckCount',
    '1287' => 'lsVersionBeh',
    '1288' => 'equipmentBiosDef',
    '1289' => 'equipmentDimmMapping',
    '1290' => 'equipmentDimmEntry',
    '1291' => 'equipmentBladeConnDef',
    '1292' => 'equipmentAdaptorConnDef',
    '1293' => 'equipmentIOCardTypeDef',
    '1294' => 'computePnuOSImage',
    '1295' => 'etherServerIntFIoFsmTask',
    '1296' => 'equipmentServerFeatureCap',
    '1297' => 'equipmentBladeIOMConnDef',
    '1298' => 'lsbootUpgradeStatus',
    '1299' => 'biosVfOSBootWatchdogTimerTimeout',
    '1300' => 'fsmFsm',
    '1301' => 'fsmStage',
    '1302' => 'faultBaseHolder',
    '1303' => 'faultLocalTypedHolder',
    '1304' => 'faultBasePolicy',
    '1305' => 'policyControlEpOperation',
    '1306' => 'faultSuppressPolicy',
    '1307' => 'faultSuppressPolicyItem',
    '1308' => 'faultSuppressTask',
    '1309' => 'faultAffectedClass',
    '1310' => 'fabricDceSwSrvEpOperation',
    '1311' => 'apeVnicStats',
    '1312' => 'apePaloVnicStats',
    '1313' => 'vnicFcGroupTempl',
    '1314' => 'vnicSanConnPolicy',
    '1315' => 'vnicLanConnPolicy',
    '1316' => 'vnicAGroup',
    '1317' => 'vnicFcGroupDef',
    '1318' => 'vnicIScsiBase',
    '1319' => 'vnicIScsiLCP',
    '1320' => 'vnicDynamicConPolicyRef',
    '1321' => 'vnicConnDef',
    '1322' => 'vnicABeh',
    '1323' => 'vnicVnicBehPolicy',
    '1324' => 'vnicVhbaBehPolicy',
    '1325' => 'biosVfSriovConfig',
    '1326' => 'fabricVnetPermit',
    '1327' => 'statsInventoryMeta',
    '1328' => 'fabricMulticastPolicy',
    '1329' => 'storageIniGroup',
    '1330' => 'storageInitiator',
    '1331' => 'storageADef',
    '1332' => 'storageConnectionPolicy',
    '1333' => 'policyItem',
    '1334' => 'fsmStatus',
    '1335' => 'swVlanGroup',
    '1336' => 'swVlanRef',
    '1337' => 'swFcoeSanEp',
    '1338' => 'swFcoeSanPc',
    '1339' => 'swFcZoneSet',
    '1340' => 'swFcServerZoneGroup',
    '1341' => 'swZoneInitiatorMember',
    '1342' => 'swFcZone',
    '1343' => 'swFcZoneMember',
    '1344' => 'swZoneTargetMember',
    '1345' => 'swFabricZoneNs',
    '1346' => 'swFabricZoneNsOverride',
    '1347' => 'swCardEnvStats',
    '1348' => 'swCardEnvStatsHist',
    '1349' => 'etherPIoEndPoint',
    '1350' => 'etherFcoeInterfaceStats',
    '1351' => 'etherFcoeInterfaceStatsHist',
    '1352' => 'mgmtExportPolicy',
    '1353' => 'mgmtCfgExportPolicy',
    '1354' => 'mgmtBackupPolicy',
    '1355' => 'mgmtConnection',
    '1356' => 'commClientItem',
    '1357' => 'aaaItem',
    '1358' => 'commItem',
    '1359' => 'vnicRackServerDiscoveryProfile',
    '1360' => 'vnicIScsiBootParams',
    '1361' => 'vnicIScsiBootVnic',
    '1362' => 'sysfileDigest',
    '1363' => 'versionEp',
    '1364' => 'versionVersion',
    '1365' => 'versionApplication',
    '1366' => 'fcpoolInitiatorEp',
    '1367' => 'lsFcLocale',
    '1368' => 'lsFcZoneGroup',
    '1369' => 'lsZoneInitiatorMember',
    '1370' => 'lsFcZone',
    '1371' => 'lsFcZoneMember',
    '1372' => 'vnicLstorageIScsi',
    '1373' => 'lsVConAssign',
    '1374' => 'storageMeta',
    '1375' => 'vnicIScsiTargetParams',
    '1376' => 'vnicIScsiInitiatorParams',
    '1377' => 'policyPolicyScope',
    '1378' => 'policyPolicyRequestor',
    '1379' => 'policyDigest',
    '1380' => 'policyControlEp',
    '1381' => 'policyControl',
    '1382' => 'policyDateTime',
    '1383' => 'policyCommunication',
    '1384' => 'policyDns',
    '1385' => 'policySecurity',
    '1386' => 'policyMonitoring',
    '1387' => 'policyFault',
    '1388' => 'policyInfraFirmware',
    '1389' => 'policyConfigBackup',
    '1390' => 'policyMEp',
    '1391' => 'policyDiscovery',
    '1392' => 'policyPowerMgmt',
    '1393' => 'policyPsu',
    '1394' => 'policyControlled',
    '1395' => 'policyControlledInstance',
    '1396' => 'policyControlledType',
    '1397' => 'orgFirmwareVersionCount',
    '1398' => 'nfsEp',
    '1399' => 'nfsMountDef',
    '1400' => 'nfsMountInst',
    '1401' => 'trigToken',
    '1402' => 'trigClientToken',
    '1403' => 'trigBaseSched',
    '1404' => 'trigLocalSched',
    '1405' => 'trigBaseAbsWindow',
    '1406' => 'trigLocalAbsWindow',
    '1407' => 'capabilityFeatureLimits',
    '1408' => 'capabilitySystemLimits',
    '1409' => 'capabilityNetworkLimits',
    '1410' => 'capabilityStorageLimits',
    '1411' => 'identIdentCtx',
    '1412' => 'identSysInfo',
    '1413' => 'identMetaVerse',
    '1414' => 'identMetaSystem',
    '1415' => 'identIdentRequest',
    '1416' => 'identRequestEp',
    '1417' => 'fabricLanAccessMgr',
    '1418' => 'fabricZoneIdUniverse',
    '1419' => 'fabricAFcoeSanEp',
    '1420' => 'fabricFcoeSanEp',
    '1421' => 'fabricFcoeSanPcEp',
    '1422' => 'fabricFcoeSanPc',
    '1423' => 'fabricFcoeVsanPc',
    '1424' => 'fabricNetGroup',
    '1425' => 'fabricPooledVlan',
    '1426' => 'fabricPoolableVlan',
    '1427' => 'fabricVsanMembership',
    '1428' => 'fabricVnetReq',
    '1429' => 'fabricVlanReq',
    '1430' => 'fabricVnetGroupReq',
    '1431' => 'fabricVlanGroupReq',
    '1432' => 'fabricOrgVlanPolicy',
    '1433' => 'observeObservedCont',
    '1434' => 'observeObserved',
    '1435' => 'observeFilter',
    '1436' => 'configSorter',
    '1437' => 'extpolConnectorContainer',
    '1438' => 'extpolEp',
    '1439' => 'extpolConnector',
    '1440' => 'extpolSvc',
    '1441' => 'extpolRegistry',
    '1442' => 'faultDomainInst',
    '1443' => 'faultSummaryInst',
    '1444' => 'faultDomainEp',
    '1445' => 'extpolController',
    '1446' => 'extpolClientCont',
    '1447' => 'extpolClient',
    '1448' => 'extpolSystemContext',
    '1449' => 'callhomeItem',
    '1450' => 'firmwareBundleInfo',
    '1451' => 'firmwareInfraPack',
    '1452' => 'firmwareCatalogPack',
    '1453' => 'firmwareSystem',
    '1454' => 'firmwareInfra',
    '1455' => 'firmwareHost',
    '1456' => 'firmwareBlade',
    '1457' => 'firmwareRack',
    '1458' => 'firmwareStatus',
    '1459' => 'firmwareSystemCompCheckResult',
    '1460' => 'firmwareInstallImpact',
    '1461' => 'firmwareHostPackModImpact',
    '1462' => 'firmwareAck',
    '1463' => 'firmwareUpgradeInfo',
    '1464' => 'firmwareUpgradeDetail',
    '1465' => 'firmwareBundleInfoDigest',
    '1466' => 'storageDomainEp',
    '1467' => 'storageVirtualDrive',
    '1468' => 'storageConnectionDef',
    '1469' => 'storageTarget',
    '1470' => 'storageFcTargetEp',
    '1471' => 'storageVsanRef',
    '1472' => 'initiatorEp',
    '1473' => 'initiatorRequestorEp',
    '1474' => 'initiatorGroupEp',
    '1475' => 'initiatorInitiatorEp',
    '1476' => 'initiatorIScsiInitiatorEp',
    '1477' => 'initiatorFcInitiatorEp',
    '1478' => 'initiatorStoreEp',
    '1479' => 'initiatorUnitEp',
    '1480' => 'initiatorLunEp',
    '1481' => 'initiatorRequestorGrpEp',
    '1482' => 'initiatorMemberEp',
    '1483' => 'storageEp',
    '1484' => 'storageNodeEp',
    '1485' => 'storageEpUser',
    '1486' => 'storageAuthKey',
    '1487' => 'storageTransportIf',
    '1488' => 'storageTargetIf',
    '1489' => 'storageIScsiTargetIf',
    '1490' => 'storageFcTargetIf',
    '1491' => 'storageL2If',
    '1492' => 'storageFcIf',
    '1493' => 'storageEtherIf',
    '1494' => 'storageSystem',
    '1495' => 'ipIpV4Addr',
    '1496' => 'ipIPv4Dns',
    '1497' => 'ipServiceIf',
    '1498' => 'ipIpV4StaticAddr',
    '1499' => 'fabricCartridgeSlotEpOperation',
    '1500' => 'extpolEpFsmTask',
    '1501' => 'extpolRegistryFsmTask',
    '1502' => 'firmwareSystemFsmTask',
    '1503' => 'identIdentRequestFsmTask',
    '1504' => 'identMetaSystemFsmTask',
    '1505' => 'mgmtExportPolicyFsmTask',
    '1506' => 'nfsMountDefFsmTask',
    '1507' => 'nfsMountInstFsmTask',
    '1508' => 'observeObservedFsmTask',
    '1509' => 'policyControlEpFsmTask',
    '1510' => 'policyPolicyScopeFsmTask',
    '1511' => 'storageSystemFsmTask',
    '1512' => 'aaaEpFsm',
    '1513' => 'storageLocalDiskOperation',
    '1514' => 'aaaLdapEpFsm',
    '1515' => 'storageVirtualDriveOperation',
    '1516' => 'aaaRadiusEpFsm',
    '1517' => 'storageVirtualDriveRefOperation',
    '1518' => 'aaaTacacsPlusEpFsm',
    '1519' => 'storageControllerOperation',
    '1520' => 'aaaRealmFsm',
    '1521' => 'storageComputeBladeOperation',
    '1522' => 'aaaAuthRealmFsm',
    '1523' => 'aaaAuthRealmFsmStage',
    '1524' => 'aaaUserEpFsm',
    '1525' => 'mgmtBackupOperation',
    '1526' => 'adaptorExtEthIfFsm',
    '1527' => 'adaptorExtEthIfFsmStage',
    '1528' => 'adaptorHostEthIfFsm',
    '1529' => 'adaptorHostEthIfFsmStage',
    '1530' => 'adaptorHostFcIfFsm',
    '1531' => 'adaptorHostFcIfFsmStage',
    '1532' => 'callhomeEpFsm',
    '1533' => 'callhomeEpFsmStage',
    '1534' => 'capabilityCatalogueFsm',
    '1535' => 'capabilityCatalogueFsmStage',
    '1536' => 'capabilityMgmtExtensionFsm',
    '1537' => 'capabilityMgmtExtensionFsmStage',
    '1538' => 'capabilityUpdaterFsm',
    '1539' => 'capabilityUpdaterFsmStage',
    '1540' => 'commSvcEpFsm',
    '1541' => 'commSvcEpFsmStage',
    '1542' => 'computeBladeFsm',
    '1543' => 'computeBladeFsmStage',
    '1544' => 'computePhysicalFsm',
    '1545' => 'computePhysicalFsmStage',
    '1546' => 'computeRackUnitFsm',
    '1547' => 'computeRackUnitFsmStage',
    '1548' => 'computeServerDiscPolicyFsm',
    '1549' => 'computeServerDiscPolicyFsmStage',
    '1550' => 'epqosDefinitionDelTaskFsm',
    '1551' => 'epqosDefinitionDelTaskFsmStage',
    '1552' => 'epqosDefinitionFsm',
    '1553' => 'epqosDefinitionFsmStage',
    '1554' => 'equipmentBeaconLedFsm',
    '1555' => 'equipmentBeaconLedFsmStage',
    '1556' => 'equipmentChassisFsm',
    '1557' => 'equipmentChassisFsmStage',
    '1558' => 'equipmentFexFsm',
    '1559' => 'equipmentFexFsmStage',
    '1560' => 'equipmentIOCardFsm',
    '1561' => 'equipmentIOCardFsmStage',
    '1562' => 'equipmentLocatorLedFsm',
    '1563' => 'equipmentLocatorLedFsmStage',
    '1564' => 'etherServerIntFIoFsm',
    '1565' => 'etherServerIntFIoFsmStage',
    '1566' => 'extpolEpFsm',
    '1567' => 'extpolEpFsmStage',
    '1568' => 'extpolRegistryFsm',
    '1569' => 'extpolRegistryFsmStage',
    '1570' => 'extvmmEpFsm',
    '1571' => 'extvmmEpFsmStage',
    '1572' => 'extvmmKeyStoreFsm',
    '1573' => 'extvmmKeyStoreFsmStage',
    '1574' => 'extvmmMasterExtKeyFsm',
    '1575' => 'extvmmMasterExtKeyFsmStage',
    '1576' => 'extvmmProviderFsm',
    '1577' => 'extvmmProviderFsmStage',
    '1578' => 'extvmmSwitchDelTaskFsm',
    '1579' => 'extvmmSwitchDelTaskFsmStage',
    '1580' => 'fabricComputeSlotEpFsm',
    '1581' => 'fabricComputeSlotEpFsmStage',
    '1582' => 'fabricEpMgrFsm',
    '1583' => 'fabricEpMgrFsmStage',
    '1584' => 'fabricLanCloudFsm',
    '1585' => 'fabricLanCloudFsmStage',
    '1586' => 'fabricSanCloudFsm',
    '1587' => 'fabricSanCloudFsmStage',
    '1588' => 'firmwareDistributableFsm',
    '1589' => 'firmwareDistributableFsmStage',
    '1590' => 'firmwareDownloaderFsm',
    '1591' => 'firmwareDownloaderFsmStage',
    '1592' => 'firmwareImageFsm',
    '1593' => 'firmwareImageFsmStage',
    '1594' => 'firmwareSystemFsm',
    '1595' => 'firmwareSystemFsmStage',
    '1596' => 'identIdentRequestFsm',
    '1597' => 'identIdentRequestFsmStage',
    '1598' => 'identMetaSystemFsm',
    '1599' => 'policyProxyMo',
    '1600' => 'licenseDownloaderFsm',
    '1601' => 'licenseDownloaderFsmStage',
    '1602' => 'licenseFileFsm',
    '1603' => 'licenseFileFsmStage',
    '1604' => 'licenseInstanceFsm',
    '1605' => 'licenseInstanceFsmStage',
    '1606' => 'lsServerFsm',
    '1607' => 'lsServerFsmStage',
    '1608' => 'mgmtBackupFsm',
    '1609' => 'policyEquipment',
    '1610' => 'mgmtControllerFsm',
    '1611' => 'mgmtControllerFsmStage',
    '1612' => 'mgmtExportPolicyFsm',
    '1613' => 'mgmtExportPolicyFsmStage',
    '1614' => 'mgmtBackupPolicyFsm',
    '1615' => 'mgmtBackupPolicyFsmStage',
    '1616' => 'mgmtCfgExportPolicyFsm',
    '1617' => 'mgmtCfgExportPolicyFsmStage',
    '1618' => 'mgmtIfFsm',
    '1619' => 'mgmtIfFsmStage',
    '1620' => 'mgmtImporterFsm',
    '1621' => 'mgmtImporterFsmStage',
    '1622' => 'nfsMountDefFsm',
    '1623' => 'smartcallhomeProfile',
    '1624' => 'smartcallhomeSource',
    '1625' => 'smartcallhomePolicy',
    '1626' => 'smartcallhomePeriodicSystemInventory',
    '1627' => 'smartcallhomeHttpProxy',
    '1628' => 'smartcallhomeTransportGateway',
    '1629' => 'pkiEpFsmStage',
    '1630' => 'policyControlEpFsm',
    '1631' => 'storageAScsiLunCtx',
    '1632' => 'storageScsiLunCtx',
    '1633' => 'policyPolicyScopeFsmStage',
    '1634' => 'storageASnapReplicaLunCtx',
    '1635' => 'storageSnapshotCtx',
    '1636' => 'storageReplicationCtx',
    '1637' => 'etherPIoFsmStage',
    '1638' => 'fcPIoFsm',
    '1639' => 'fcPIoFsmStage',
    '1640' => 'qosclassDefinitionFsm',
    '1641' => 'qosclassDefinitionFsmStage',
    '1642' => 'vnicIniGrpFcBase',
    '1643' => 'vnicIniGrpFc',
    '1644' => 'vnicIniGrpFcIf',
    '1645' => 'storageSystemFsmStage',
    '1646' => 'swAccessDomainFsm',
    '1647' => 'swAccessDomainFsmStage',
    '1648' => 'swEthLanBorderFsm',
    '1649' => 'swEthLanBorderFsmStage',
    '1650' => 'swEthMonFsm',
    '1651' => 'swEthMonFsmStage',
    '1652' => 'swFcMonFsm',
    '1653' => 'swFcMonFsmStage',
    '1654' => 'swFcSanBorderFsm',
    '1655' => 'swFcSanBorderFsmStage',
    '1656' => 'swPhysFsm',
    '1657' => 'swPhysFsmStage',
    '1658' => 'swUtilityDomainFsm',
    '1659' => 'swUtilityDomainFsmStage',
    '1660' => 'syntheticFsObjFsm',
    '1661' => 'syntheticFsObjFsmStage',
    '1662' => 'sysdebugAutoCoreFileExportTargetFsm',
    '1663' => 'sysdebugAutoCoreFileExportTargetFsmStage',
    '1664' => 'sysdebugCoreFsm',
    '1665' => 'sysdebugCoreFsmStage',
    '1666' => 'sysdebugLogControlEpFsm',
    '1667' => 'sysdebugLogControlEpFsmStage',
    '1668' => 'sysdebugManualCoreFileExportTargetFsm',
    '1669' => 'sysdebugManualCoreFileExportTargetFsmStage',
    '1670' => 'sysdebugTechSupportFsm',
    '1671' => 'sysdebugTechSupportFsmStage',
    '1672' => 'sysfileMutationFsm',
    '1673' => 'sysfileMutationFsmStage',
    '1674' => 'vmLifeCyclePolicyFsm',
    '1675' => 'vmLifeCyclePolicyFsmStage',
    '1676' => 'vnicProfileSetFsm',
    '1677' => 'vnicProfileSetFsmStage',
    '1678' => 'configMotherboardItem',
    '1681' => 'gmetaEp',
    '1682' => 'gmetaHolder',
    '1683' => 'gmetaClass',
    '1684' => 'gmetaProp',
    '1685' => 'gmetaPolicyMapHolder',
    '1686' => 'fabricSanPinTargetOperation',
    '1687' => 'fabricSanPinGroupOperation',
    '1688' => 'changeChangedObjectRef',
    '1689' => 'aaaCimcSession',
    '1690' => 'lsServerExtension',
    '1691' => 'fabricFcoeSanPcEpOperation',
    '1692' => 'fabricVnetEpSyncEp',
    '1693' => 'vnicMacHistory',
    '1694' => 'vnicWwpnHistory',
    '1695' => 'vnicWwnnHistory',
    '1696' => 'vnicIqnHistory',
    '1697' => 'vnicIpV4History',
    '1698' => 'fabricFcEstcEpOperation',
    '1699' => 'fabricFcoeEstcEpOperation',
    '1700' => 'equipmentRackFanModuleDef',
    '1701' => 'equipmentFirmwareConstraint',
    '1702' => 'equipmentVersionConstraint',
    '1703' => 'networkOperLevel',
    '1704' => 'orgSourceMask',
    '1705' => 'storageTransportableFlashModule',
    '1706' => 'policyLocalMap',
    '1707' => 'policyElement',
    '1708' => 'policyRefReq',
    '1709' => 'fabricVnetEpSyncEpFsmTask',
    '1710' => 'gmetaHolderFsmTask',
    '1711' => 'fabricVnetEpSyncEpFsm',
    '1712' => 'fabricVnetEpSyncEpFsmStage',
    '1713' => 'gmetaHolderFsm',
    '1714' => 'gmetaHolderFsmStage',
    '1715' => 'lsUuidHistory',
    '1716' => 'fabricEthEstcEpOperation',
    '1717' => 'fabricEthEstcPcOperation',
    '1718' => 'policyControlledTypeFsmTask',
    '1719' => 'fabricEthEstcPcEpOperation',
    '1720' => 'fabricEthLanPcEpOperation',
    '1721' => 'fabricLanPinGroupOperation',
    '1722' => 'fabricLanPinTargetOperation',
    '1723' => 'policyControlledTypeFsm',
    '1724' => 'policyControlledTypeFsmStage',
    '1725' => 'graphicsCard',
    '1726' => 'graphicsController',
    '1727' => 'domainFeature',
    '1728' => 'fabricFcMap',
    '1729' => 'equipmentGraphicsCardCapProvider',
    '1730' => 'equipmentGraphicsCardCapRef',
    '1731' => 'equipmentDowngradeConstraint',
    '1732' => 'domainEnvironmentFeature',
    '1733' => 'smartlicenseHolder',
    '1734' => 'smartlicenseAgent',
    '1735' => 'lstorageControllerDef',
    '1736' => 'lstorageControllerModeConfig',
    '1737' => 'smartlicenseTest',
    '1738' => 'queryresultUsage',
    '1739' => 'smartlicenseEntitlementEp',
    '1740' => 'smartlicenseEntitlement',
    '1741' => 'securityUnit',
    '1742' => 'lsbootSanCatSanImage',
    '1743' => 'lsbootLocalMediaItem',
    '1744' => 'lsbootDefaultLocalImage',
    '1745' => 'lsbootUsbFlashStorageImage',
    '1746' => 'lsbootLocalHddImage',
    '1747' => 'lsbootUsbInternalImage',
    '1748' => 'lsbootUsbExternalImage',
    '1749' => 'lsbootSanCatSanImagePath',
    '1750' => 'fabricUdldPolicy',
    '1751' => 'fabricEthLinkProfile',
    '1752' => 'smartlicenseAgentFsmTask',
    '1753' => 'smartlicenseEntitlementEpFsmTask',
    '1754' => 'smartlicenseHolderFsmTask',
    '1755' => 'smartlicenseTestFsmTask',
    '1756' => 'fabricCdpLinkPolicy',
    '1757' => 'fabricLinkPolicy',
    '1758' => 'commCimcWebService',
    '1759' => 'certRepairEpFsmStage',
    '1760' => 'changeEpFsm',
    '1761' => 'vnicVmqConReq',
    '1762' => 'vnicVmqConPolicy',
    '1763' => 'vnicVmqConPolicyRef',
    '1764' => 'vnicConReq',
    '1765' => 'vnicConPolicyRef',
    '1766' => 'vnicIpV6Addr',
    '1767' => 'vnicIpV6AddrConf',
    '1768' => 'vnicIpV6AddrExplConf',
    '1769' => 'vnicIpV6StaticAddr',
    '1770' => 'vnicIpV4MgmtPooledAddr',
    '1771' => 'vnicIpV6MgmtPooledAddr',
    '1772' => 'vnicUsnicConReq',
    '1773' => 'vnicUsnicConPolicy',
    '1774' => 'vnicUsnicConPolicyRef',
    '1775' => 'fabricEthEstcPcOperationFsmStage',
    '1776' => 'fabricEthLanEpOperationFsm',
    '1777' => 'storageControllerBase',
    '1778' => 'storageFlexFlashController',
    '1779' => 'storageLocalDiskBase',
    '1780' => 'storageFlexFlashCard',
    '1781' => 'storageFlexFlashDrive',
    '1782' => 'storageFlexFlashVirtualDrive',
    '1783' => 'lsIssues',
    '1784' => 'firmwareAutoSyncPolicy',
    '1785' => 'ipIpV4StaticTargetAddr',
    '1786' => 'fabricNetflowIPv4Addr',
    '1787' => 'fabricFlowMon',
    '1788' => 'fabricLanFlowMon',
    '1789' => 'fabricFcoeSanEpOperationFsmStage',
    '1790' => 'fabricNetflowMonSession',
    '1791' => 'fabricFlowMonSrcEp',
    '1792' => 'fabricLanFlowMonSrcEp',
    '1793' => 'fabricEthLanFlowMonSrcEp',
    '1794' => 'fabricNetflowMonSrcEp',
    '1795' => 'fabricFlowMonSrcRef',
    '1796' => 'fabricEthFlowMonSrcRef',
    '1797' => 'fabricNetflowMonSrcRef',
    '1798' => 'fabricFlowMonExporterProfile',
    '1799' => 'fabricFlowMonDefinition',
    '1800' => 'fabricFlowMonItem',
    '1801' => 'fabricFlowMonitoringCategory',
    '1802' => 'fabricEthLanFlowMonitoring',
    '1803' => 'fabricEthFlowMonLan',
    '1804' => 'smartlicenseAgentFsm',
    '1805' => 'smartlicenseAgentFsmStage',
    '1806' => 'smartlicenseEntitlementEpFsm',
    '1807' => 'smartlicenseEntitlementEpFsmStage',
    '1808' => 'smartlicenseHolderFsm',
    '1809' => 'smartlicenseHolderFsmStage',
    '1810' => 'smartlicenseTestFsm',
    '1811' => 'smartlicenseTestFsmStage',
    '1812' => 'policyPortConfig',
    '1813' => 'fabricFlowMonExporter',
    '1814' => 'fabricLanFlowMonExporter',
    '1815' => 'fabricFcPortOperation',
    '1816' => 'fabricNetflowMonExporter',
    '1817' => 'fabricNetflowMonExporterRef',
    '1818' => 'fabricNetflowTimeoutPolicy',
    '1819' => 'fabricFIPortOperationFsmTask',
    '1820' => 'fabricFIPortOperationFsm',
    '1821' => 'vnicProfileRef',
    '1822' => 'fabricEthPortOperationFsm',
    '1823' => 'fabricEthPortOperationFsmStage',
    '1824' => 'fabricFcPortOperationFsm',
    '1825' => 'fabricFcPortOperationFsmStage',
    '1826' => 'fabricFcoeSanPcOperationFsm',
    '1827' => 'fabricFcoeSanPcOperationFsmStage',
    '1830' => 'equipmentSecureController',
    '1831' => 'equipmentTpm',
    '1833' => 'mgmtIPv6IfConfig',
    '1834' => 'mgmtIPv6Addr',
    '1835' => 'mgmtIPv6IfAddr',
    '1836' => 'mgmtCimcInterface',
    '1837' => 'mgmtInbandProfile',
    '1838' => 'mgmtInterface',
    '1839' => 'mgmtProfDerivedInterface',
    '1840' => 'mgmtVnet',
    '1841' => 'extmgmtNdiscTargets',
    '1842' => 'swEthLanFlowMon',
    '1843' => 'swFlowMonitor',
    '1844' => 'swEthLanFlowMonitor',
    '1845' => 'swNetflowMonitor',
    '1846' => 'swNetflowMonitorRef',
    '1847' => 'swFlowRecordDef',
    '1848' => 'swEthLanFlowRecordDef',
    '1849' => 'swNetflowRecordDef',
    '1850' => 'swFlowMonExporter',
    '1851' => 'swEthLanFlowMonExporter',
    '1852' => 'swNetflowExporter',
    '1853' => 'swEthFlowMonSession',
    '1854' => 'swNetflowMonSession',
    '1855' => 'swNFExporterRef',
    '1856' => 'swIpRoute',
    '1857' => 'swVirtL3Intf',
    '1858' => 'swCmclan',
    '1859' => 'ippoolIpV6Pooled',
    '1860' => 'ippoolIpV6Block',
    '1861' => 'testingServiceProfileFsm',
    '1862' => 'testingServiceProfileFsmStage',
    '1863' => 'topSystemFsm',
    '1864' => 'topSystemFsmStage',
    '1865' => 'extvmmNetworkSets',
    '1866' => 'extvmmVMNetworkSets',
    '1867' => 'extvmmFabricNetwork',
    '1868' => 'extvmmFabricNetworkDefinition',
    '1869' => 'extvmmVMNetworkDefinition',
    '1870' => 'extvmmVMNetwork',
    '1871' => 'extvmmVMNDRef',
    '1872' => 'extvmmUpLinkPP',
    '1873' => 'extvmmFNDReference',
    '1874' => 'extvmmNetworkSetsFsmTask',
    '1875' => 'mgmtIPv6IfAddrFsmTask',
    '1876' => 'swEthLanFlowMonFsmTask',
    '1877' => 'extvmmNetworkSetsFsm',
    '1878' => 'extvmmNetworkSetsFsmStage',
    '1879' => 'mgmtIPv6IfAddrFsm',
    '1880' => 'mgmtIPv6IfAddrFsmStage',
    '1881' => 'topInfoSyncPolicy',
    '1882' => 'swEthLanFlowMonFsmStage',
    '1883' => 'vnicIpV6History',
    '1884' => 'equipmentInbandMgmtCap',
    '1885' => 'domainServerFeatureCont',
    '1886' => 'domainNetworkFeatureCont',
    '1887' => 'domainStorageFeatureCont',
    '1888' => 'domainEnvironmentFeatureCont',
    '1889' => 'configBackupFsmStage',
    '1890' => 'configConsumerCatalogueFsm',
    '1891' => 'configConsumerCatalogueFsmStage',
    '1892' => 'consumerInstFsm',
    '1893' => 'consumerInstFsmStage',
    '1894' => 'controllerEpFsm',
    '1895' => 'controllerEpFsmStage',
    '1896' => 'cimcvmediaActualMountList',
    '1897' => 'cimcvmediaActualMountEntry',
    '1898' => 'cimcvmediaExtMgmtRuleEntry',
    '1899' => 'cimcvmediaConfigMountEntry',
    '1900' => 'computeABoard',
    '1901' => 'computeExtBoard',
    '1902' => 'computeBoardConnector',
    '1903' => 'adaptorEthArfsProfile',
    '1904' => 'equipmentBladeAggregationCapRef',
    '1905' => 'equipmentPhysDevicesPerBoard',
    '1906' => 'mgmtBackupTriggerFsm',
    '1907' => 'mgmtBackupTriggerFsmStage',
    '1908' => 'mgmtDataExporterFsm',
    '1909' => 'mgmtDataExporterFsmStage',
    '1910' => 'mgmtDataImporterFsm',
    '1911' => 'mgmtDataImporterFsmStage',
    '1912' => 'fabricLacpPolicy',
    '1913' => 'storageMezzFlashLife',
    '1914' => 'nfsClientDefFsm',
    '1915' => 'nfsClientDefFsmStage',
    '1916' => 'nfsExportDefFsm',
    '1917' => 'nfsExportDefFsmStage',
    '1918' => 'firmwareAExcludeComponent',
    '1919' => 'firmwareExcludeChassisComponent',
    '1920' => 'firmwareDomainInfraProfile',
    '1921' => 'firmwareInfraPackConfig',
    '1922' => 'firmwareCatalogPackConfig',
    '1923' => 'firmwareDomainInfo',
    '1924' => 'mgmtASecureBoot',
    '1925' => 'mgmtCmcSecureBoot',
    '1926' => 'hcDownloadPolicy',
    '1927' => 'firmwareConnectionPolicy',
    '1928' => 'tagADef',
    '1929' => 'tagAInstance',
    '1930' => 'tagDefEp',
    '1931' => 'tagInstanceEp',
    '1932' => 'tagDef',
    '1933' => 'tagItem',
    '1934' => 'tagInstance',
    '1935' => 'tagSoftwareInst',
    '1936' => 'tagDriver',
    '1937' => 'topInfoPolicy',
    '1938' => 'sysdebugLogExportPolicyFsm',
    '1939' => 'sysdebugLogExportPolicyFsmStage',
    '1940' => 'configFilterGroup',
    '1941' => 'configFilterItem',
    '1942' => 'configPolicyUsageItem',
    '1943' => 'commDateTimeFsmTask',
    '1944' => 'mgmtCimcSecureBoot',
    '1945' => 'licenseTarget',
    '1946' => 'adaptorHostPort',
    '1947' => 'adaptorHostPortCap',
    '1948' => 'callhomeAnonymousReporting',
    '1949' => 'policyIdResolvePolicy',
    '1950' => 'firmwareConstraints',
    '1951' => 'firmwareConstraint',
    '1952' => 'fabricFcUserZone',
    '1953' => 'etherNiErrStatsHist',
    '1954' => 'equipmentUuidFeatureCap',
    '1955' => 'networkLanNeighbors',
    '1956' => 'networkANeighborEntry',
    '1957' => 'networkLanNeighborEntry',
    '1958' => 'networkSanNeighbors',
    '1959' => 'networkSanNeighborEntry',
    '1960' => 'storageFlexFlashControllerFsmTask',
    '1961' => 'storageFlexFlashControllerFsm',
    '1962' => 'storageFlexFlashControllerFsmStage',
    '1963' => 'lstorageDiskZoningConfig',
    '1964' => 'lstorageDiskZoningPolicy',
    '1965' => 'lstorageDiskZoningConfigDef',
    '1966' => 'lstorageDiskSlot',
    '1967' => 'lstorageASlot',
    '1968' => 'lstorageControllerRef',
    '1969' => 'storageArray',
    '1970' => 'storagePartition',
    '1971' => 'storageClusterIdUniverse',
    '1972' => 'storageAppliance',
    '1973' => 'storageContainer',
    '1974' => 'storageProcessor',
    '1975' => 'storageProcessorRuntime',
    '1976' => 'storageProcessorEp',
    '1977' => 'storageDiskGroup',
    '1978' => 'storageBackstore',
    '1979' => 'storageAVolume',
    '1980' => 'storageVolume',
    '1981' => 'storageALun',
    '1982' => 'storageAScsiLun',
    '1983' => 'storageScsiLun',
    '1984' => 'storageScsiDeviceDescriptor',
    '1985' => 'storageScsiLunRef',
    '1986' => 'storageVirtualDriveContainer',
    '1987' => 'storageControllerEp',
    '1988' => 'storageVirtualDriveEp',
    '1989' => 'storageVirtualDriveRef',
    '1990' => 'storageLunResourceSelectionLog',
    '1991' => 'storageDiskEp',
    '1992' => 'storageLunMaskGroup',
    '1993' => 'storageScsiLunMask',
    '1994' => 'storageIScsiInitiatorEp',
    '1995' => 'storageUsageCounters',
    '1996' => 'storageLunCounters',
    '1997' => 'storageSnapshot',
    '1998' => 'storageLunSnapshot',
    '1999' => 'storageLunReplica',
    '2000' => 'storageCloud',
    '2001' => 'storageCtrlStorageStats',
    '2002' => 'storageCtrlStorageStatsHist',
    '2003' => 'storageStorageStats',
    '2004' => 'storageStorageStatsHist',
    '2005' => 'storageEthLif',
    '2006' => 'storageIpV4StaticAddr',
    '2007' => 'storageIpV4PooledAddr',
    '2008' => 'vnicInitiatorAutoConfigPolicy',
    '2009' => 'vnicIScsiInitAutoConfigPolicy',
    '2010' => 'vnicEthConfig',
    '2011' => 'vnicIScsiConfig',
    '2012' => 'vnicIfRole',
    '2013' => 'vnicIPv6If',
    '2014' => 'vnicStorageLif',
    '2015' => 'hcAdmin',
    '2016' => 'hcReport',
    '2017' => 'hcAComponent',
    '2018' => 'policySystemEp',
    '2019' => 'policyStorageAutoConfig',
    '2020' => 'hcAStatusItem',
    '2021' => 'hcItemNote',
    '2022' => 'hcAdapterItem',
    '2023' => 'trigBaseRecurrWindow',
    '2024' => 'hcOsItem',
    '2025' => 'hcDriverItem',
    '2026' => 'lstorageArrayAutoconfigPolicy',
    '2027' => 'lstorageLogical',
    '2028' => 'lstorageArray',
    '2029' => 'lstorageProcessor',
    '2030' => 'lstorageCtrlService',
    '2031' => 'lstoragePhysicalBindingBase',
    '2032' => 'lstorageArrayBinding',
    '2033' => 'lstorageProcessorBinding',
    '2034' => 'lstorageIssues',
    '2035' => 'lstorageTargetIdentity',
    '2036' => 'lstorageBackstoreQual',
    '2037' => 'lstorageQualItem',
    '2038' => 'lstorageQualifiedPolicy',
    '2039' => 'lstorageBackstorePoolingPolicy',
    '2040' => 'lstorageRecurrWindow',
    '2041' => 'lstorageReplicationPolicy',
    '2042' => 'lstorageSnapshotPolicy',
    '2043' => 'lstorageLunReplicationPeerEp',
    '2044' => 'lstorageAbsReplicationExt',
    '2045' => 'lstorageInvictaReplicationExt',
    '2046' => 'lstorageLunReplicationPolicy',
    '2047' => 'lstorageLunSnapshotPolicy',
    '2048' => 'lstorageSvcWindow',
    '2049' => 'sysdebugTechSupportOp',
    '2050' => 'lstorageSvcSched',
    '2051' => 'lstorageReplicationConnect',
    '2052' => 'mgmtCmcSecureBootOperation',
    '2053' => 'lstorageReplicationService',
    '2054' => 'lstorageLunReplicationService',
    '2055' => 'lstorageCredentialBase',
    '2056' => 'lstorageSharedCredential',
    '2057' => 'lstorageReplicationSources',
    '2058' => 'lstorageReplicationSourceEp',
    '2059' => 'lstorageProfileBase',
    '2060' => 'lstorageProfile',
    '2061' => 'lstorageProfileDef',
    '2062' => 'lstorageProfileBindingBase',
    '2063' => 'lstorageProfileBinding',
    '2064' => 'lstorageItem',
    '2065' => 'lstorageScsiLun',
    '2066' => 'lstorageSanScsiLun',
    '2067' => 'lstorageDasScsiLun',
    '2068' => 'lstorageDiskGroupConfig',
    '2069' => 'lstorageDiskGroupConfigPolicy',
    '2070' => 'lstorageDiskGroupConfigDef',
    '2071' => 'lstorageDiskGroupQualifier',
    '2072' => 'lstorageLocalDiskRef',
    '2073' => 'lstorageLocalDiskConfigRef',
    '2074' => 'lstorageVirtualDriveDef',
    '2075' => 'lstorageMaintPolicy',
    '2076' => 'lstorageAck',
    '2077' => 'lstorageRequestCtx',
    '2078' => 'policyControlEpOp',
    '2079' => 'policyControlOp',
    '2080' => 'policyDateTimeOp',
    '2081' => 'policyCommunicationOp',
    '2082' => 'policyDnsOp',
    '2083' => 'policySecurityOp',
    '2084' => 'policyMonitoringOp',
    '2085' => 'policyFaultOp',
    '2086' => 'policyInfraFirmwareOp',
    '2087' => 'policyConfigBackupOp',
    '2088' => 'policyMEpOp',
    '2089' => 'policyDiscoveryOp',
    '2090' => 'policyPowerMgmtOp',
    '2091' => 'policyPsuOp',
    '2092' => 'policyEquipmentOp',
    '2093' => 'storageEnclosureDiskSlotEp',
    '2094' => 'storageVDMemberEp',
    '2095' => 'storageLocalDiskEp',
    '2096' => 'storageBlade',
    '2097' => 'storageDeviceBridge',
    '2098' => 'storageSasExpander',
    '2099' => 'swSubGroup',
    '2100' => 'memoryController',
    '2101' => 'vnicMonSesFcBase',
    '2102' => 'vnicMonSesFc',
    '2103' => 'vnicMonSesFcIf',
    '2104' => 'memoryNvDimmEnvStats',
    '2105' => 'policyControlEpOpFsmTask',
    '2106' => 'pkiLocale',
    '2107' => 'powerProfiledPower',
    '2108' => 'storageSvcItem',
    '2109' => 'storageSnapshotProfile',
    '2110' => 'storageReplicationProfile',
    '2111' => 'storageReplicaRestoreProfile',
    '2112' => 'storageTargetIdentity',
    '2113' => 'storageTargetNode',
    '2114' => 'vnicStorageEthLif',
    '2115' => 'dupeScope',
    '2116' => 'dupeScopeResult',
    '2117' => 'firmwareAInfraPack',
    '2118' => 'fabricDceSwSrvPcOperation',
    '2119' => 'featureChassisDef',
    '2120' => 'fabricDceSwSrvPcOperationFsm',
    '2121' => 'fabricDceSwSrvPcOperationFsmStage',
    '2122' => 'equipmentSwitchIOCard',
    '2123' => 'inventoryEp',
    '2124' => 'inventoryHolder',
    '2125' => 'inventoryInventoryEp',
    '2126' => 'inventoryGlobalEp',
    '2127' => 'inventoryDomainEp',
    '2128' => 'inventoryInventoryMoMeta',
    '2129' => 'featureFruCapProviderInstance',
    '2130' => 'featureContextEp',
    '2131' => 'featureProviderInstance',
    '2132' => 'equipmentSwitchIOCardCapProvider',
    '2133' => 'equipmentPortCap',
    '2134' => 'equipmentSystemFruCapProvider',
    '2135' => 'equipmentPowerCapDef',
    '2136' => 'equipmentImpliedStorageEnclosureDef',
    '2137' => 'equipmentStorageControllerSlotDef',
    '2138' => 'fabricAGroupReq',
    '2139' => 'equipmentSwitchTypeDef',
    '2140' => 'fabricNetGroupReq',
    '2141' => 'equipmentStorageProviderDriverLibrary',
    '2142' => 'portSubGroup',
    '2143' => 'fabricSubGroup',
    '2144' => 'fabricSwSubGroup',
    '2145' => 'fabricBaseSlotEp',
    '2146' => 'fabricBasePhEp',
    '2147' => 'fabricEnclosureSlotEp',
    '2148' => 'fabricEnclosurePhEp',
    '2149' => 'lstorageProcessorBase',
    '2150' => 'lstoragePooledBackstore',
    '2151' => 'lstoragePooledArrayVolume',
    '2152' => 'lstorageExtension',
    '2153' => 'adaptorHostVnicHwAddrCap',
    '2154' => 'adaptorNwStatsMgmtCap',
    '2155' => 'adaptorDynamicConfigCap',
    '2156' => 'osController',
    '2157' => 'osImageDefinition',
    '2158' => 'osEthBondModeActiveBackup',
    '2159' => 'osEthBondModeBalancedRR',
    '2160' => 'osEthBondModeLB',
    '2161' => 'osEthBondModeBalancedTLB',
    '2162' => 'osEthBondModeBroadcast',
    '2163' => 'osEthBondModeBalancedXOR',
    '2164' => 'osEthBondModeBalancedALB',
    '2165' => 'osMiiLinkMonitoringPolicy',
    '2166' => 'osARPLinkMonitoringPolicy',
    '2167' => 'osARPTarget',
    '2168' => 'firmwareFileUnit',
    '2169' => 'firmwareStoragePackModImpact',
    '2170' => 'firmwareABundleTypeCapProvider',
    '2171' => 'firmwarePlatformBundleTypeCapProvider',
    '2172' => 'storageDiskEnvStats',
    '2173' => 'storageDiskEnvStatsHist',
    '2174' => 'equipmentIOCardBaseFsmTask',
    '2175' => 'equipmentPsuFsmTask',
    '2176' => 'lstorageProcessorFsmTask',
    '2177' => 'osControllerFsmTask',
    '2178' => 'storagePartitionFsmTask',
    '2179' => 'storageProcessorFsmTask',
    '2180' => 'equipmentIOCardBaseFsm',
    '2181' => 'mgmtAKmipCertPolicy',
    '2182' => 'equipmentSwitchIOCardFsm',
    '2183' => 'mgmtNamedKmipCertPolicy',
    '2184' => 'equipmentPsuFsm',
    '2185' => 'equipmentPsuFsmStage',
    '2186' => 'netNetGroupPermit',
    '2187' => 'lstorageProcessorFsmStage',
    '2188' => 'osControllerFsm',
    '2189' => 'osControllerFsmStage',
    '2190' => 'storagePartitionFsm',
    '2191' => 'storagePartitionFsmStage',
    '2192' => 'storageProcessorFsm',
    '2193' => 'storageProcessorFsmStage',
    '2194' => 'fabricEquipmentEp',
    '2195' => 'fabricCartridgeSlotEp',
    '2196' => 'fabricComputeMSlotEp',
    '2197' => 'fabricCartridgePhEp',
    '2198' => 'biosVfASPMSupport',
    '2199' => 'biosVfDDR3VoltageSelection',
    '2200' => 'computePooledEnclosureComputeSlot',
    '2201' => 'computeInstanceIdQual',
    '2202' => 'apeAttribute',
    '2203' => 'firmwareActivity',
    '2204' => 'equipmentCartridgeCapProvider',
    '2205' => 'equipmentServerUnitCapProvider',
    '2206' => 'equipmentStorageLimitCap',
    '2207' => 'equipmentSharedIOModule',
    '2208' => 'adaptorUplinkPortStats',
    '2209' => 'adaptorHostScsiIf',
    '2210' => 'adaptorHostScsiLunRef',
    '2211' => 'computeSlotEntity',
    '2212' => 'computeCartridge',
    '2213' => 'inbandPolicy',
    '2214' => 'computeServerUnitFsmTask',
    '2215' => 'fabricCartridgeSlotEpFsmTask',
    '2216' => 'glDomainEp',
    '2217' => 'glAbsEp',
    '2218' => 'glIdable',
    '2219' => 'glEp',
    '2220' => 'glAbsRequest',
    '2221' => 'glRequest',
    '2222' => 'glPolicyResolutionEp',
    '2223' => 'lsbootUEFIBootParam',
    '2224' => 'glLsp',
    '2225' => 'glVnicTemplateEp',
    '2226' => 'glVnicTemplate',
    '2227' => 'glOperationEp',
    '2228' => 'glPoolEp',
    '2229' => 'glAbsResEp',
    '2230' => 'glPolicyEp',
    '2231' => 'glVxanEp',
    '2232' => 'glGlobalDefaultPolicyEp',
    '2233' => 'glSpDefEp',
    '2234' => 'glIdentCtxEp',
    '2235' => 'glTemplateEp',
    '2236' => 'glAbsOperation',
    '2237' => 'lsIdentityInfo',
    '2238' => 'networkALanNeighborEntry',
    '2239' => 'networkLldpNeighbors',
    '2240' => 'networkLldpNeighborEntry',
    '2241' => 'glIdentCtxOp',
    '2242' => 'glIdentCtxResOp',
    '2243' => 'glByMo',
    '2244' => 'glAbsPolicyOp',
    '2245' => 'glPolicyAlgorithmedOp',
    '2246' => 'glPolicyResOp',
    '2247' => 'storageADiskEp',
    '2248' => 'storageSasPhyLink',
    '2249' => 'storageSasUpLink',
    '2250' => 'storageASlot',
    '2251' => 'storageControllerRef',
    '2252' => 'storageSasPort',
    '2253' => 'sesEnclosure',
    '2254' => 'sesDiskSlotEp',
    '2255' => 'storageSasLinkDescriptor',
    '2256' => 'storageSasPortDescriptor',
    '2257' => 'storageEnclosureCap',
    '2258' => 'storageADiskSlotEp',
    '2259' => 'glRequestorEp',
    '2260' => 'glRequestor',
    '2261' => 'glRefsEp',
    '2262' => 'glBlockEp',
    '2263' => 'glBlockOp',
    '2264' => 'glInventoryEp',
    '2265' => 'glSPInvEp',
    '2266' => 'glPoolInvEp',
    '2267' => 'glPolicyInvEp',
    '2268' => 'glAbsInv',
    '2269' => 'glAbsPolicyInv',
    '2270' => 'glServiceProfile',
    '2271' => 'glPolicy',
    '2272' => 'glUsageEp',
    '2273' => 'glUsage',
    '2274' => 'glPool',
    '2275' => 'glMcastPolicy',
    '2276' => 'glAbsVnetInv',
    '2277' => 'glVlan',
    '2278' => 'glVsan',
    '2279' => 'glVnetInvHolder',
    '2280' => 'mgmtHealthAttr',
    '2281' => 'mgmtHealthStatus',
    '2282' => 'glAbsRule',
    '2283' => 'glAbsPolicyRule',
    '2284' => 'glAppendRule',
    '2285' => 'glRequestVnetEpHolder',
    '2286' => 'swPortBreakout',
    '2287' => 'swExtUtility',
    '2288' => 'swVIFRef',
    '2289' => 'swExtUtilityFsmTask',
    '2290' => 'swExtUtilityFsm',
    '2291' => 'swExtUtilityFsmStage',
    '2292' => 'networkElementOperation',
    '2293' => 'adaptorHostEthIfOperation',
    '2294' => 'adaptorHostFcIfOperation',
    '2295' => 'adaptorHostIscsiIfOperation',
    '2296' => 'adaptorExtEthIfOperation',
    '2297' => 'fdChassis',
    '2298' => 'fdPhysical',
    '2299' => 'fdRackUnit',
    '2300' => 'fdBlade',
    '2301' => 'fdOperable',
    '2302' => 'storageVsanRefIvt',
    '2303' => 'equipmentStorageSasExpanderCapRef',
    '2304' => 'vnicOutbandMgmtEp',
    '2305' => 'firmwareVicSlotConstraint',
    '2306' => 'firmwarePCHStorageConfigConstraint',
    '2307' => 'equipmentSwitchIOCardFsmTask',
    '2308' => 'adaptorHostIfConfig',
    '2309' => 'lsbootEFIShell',
    '2310' => 'storageOnboardDevice',
    '2311' => 'fabricNetGroupEp',
    '2312' => 'mgmtMgmtDbState',
    '2313' => 'equipmentServerCorrectUuidBehavior',
    '2314' => 'fabricFcZoneProfileIvt',
    '2315' => 'fabricFcUserZoneIvt',
    '2316' => 'equipmentOnboardDeviceDef',
    '2317' => 'morefImportRoot',
    '2318' => 'morefRef',
    '2319' => 'morefProp',
    '2320' => 'morefFruRef',
    '2321' => 'glRequestFsmTask',
    '2322' => 'glRequestVnetEpDomainEpFsmTask',
    '2323' => 'morefImportRootFsmTask',
    '2324' => 'morefImportRootFsm',
    '2325' => 'morefImportRootFsmStage',
    '2326' => 'vnicOutbandMgmtEpFsmTask',
    '2327' => 'equipmentHwRevisionModifier',
    '2328' => 'diagSrvCtrlOperationFsmStage',
    '2329' => 'domainProfileFsm',
    '2330' => 'domainProfileFsmStage',
    '2332' => 'equipmentInitConfigPolicy',
    '2333' => 'fabricFcZoneProfileFsm',
    '2334' => 'fabricFcZoneProfileFsmStage',
    '2335' => 'fdPhysicalFsm',
    '2336' => 'fdPhysicalFsmStage',
    '2337' => 'fdBladeFsm',
    '2338' => 'fdBladeFsmStage',
    '2339' => 'fdRackUnitFsm',
    '2340' => 'fdRackUnitFsmStage',
    '2341' => 'glIdentCtxResOpFsm',
    '2342' => 'glIdentCtxResOpFsmStage',
    '2343' => 'glRequestFsm',
    '2344' => 'glRequestFsmStage',
    '2345' => 'glRequestVnetEpDomainEpFsm',
    '2346' => 'glRequestVnetEpDomainEpFsmStage',
    '2347' => 'glRequestVnetEpFsm',
    '2348' => 'glRequestVnetEpFsmStage',
    '2353' => 'vnicOutbandMgmtEpFsm',
    '2354' => 'vnicOutbandMgmtEpFsmStage',
    '2355' => 'vnicIniGrpFcB',
    '2356' => 'vnicIniGrpFcBIf',
    '2357' => 'biosVfRedirectionAfterBIOSPOST',
    '2358' => 'vnicNetGroup',
    '2359' => 'vnicNetGroupRef',
    '2360' => 'biosVfSIOC1OptionROM',
    '2361' => 'biosVfSIOC2OptionROM',
    '2362' => 'biosVfSBMezz1OptionROM',
    '2363' => 'biosVfIOESlot1OptionROM',
    '2364' => 'biosVfIOEMezz1OptionROM',
    '2365' => 'biosVfIOESlot2OptionROM',
    '2366' => 'biosVfIOENVMe1OptionROM',
    '2367' => 'biosVfIOENVMe2OptionROM',
    '2368' => 'biosVfSBNVMe1OptionROM',
    '2369' => 'biosVfWorkloadConfiguration',
    '2371' => 'computeFabricEthMonSrcEpCont',
    '2372' => 'computeFabricFcMonSrcEpCont',
    '2373' => 'computeFabricMonSrcEp',
    '2374' => 'computeFabricEthMonSrcEp',
    '2375' => 'computeFabricFcMonSrcEp',
    '2376' => 'equipmentStorageEncCapProvider',
    '2377' => 'equipmentIOExpanderCapProvider',
    '2378' => 'equipmentCiscoOsOpenGate',
    '2379' => 'equipmentBootDeviceConstraints',
    '2380' => 'equipmentFruVariant',
    '2381' => 'equipmentStorageSasExpanderDef',
    '2382' => 'equipmentEmbeddedStorageDef',
    '2383' => 'equipmentPciSlotIdMapping',
    '2384' => 'equipmentPciSlotIdEntry',
    '2385' => 'equipmentPciSlotSubOEMIdEntry',
    '2387' => 'equipmentIOExpander',
    '2395' => 'equipmentAutoconfigPolicy',
    '2396' => 'equipmentChassisInheritPolicy',
    '2397' => 'apeMcStats',
    '2398' => 'fabricFcZoneProfile',
    '2400' => 'fabricFcEndpoint',
    '2401' => 'storageNvmeStats',
    '2402' => 'storageNvmeStatsHist',
    '2403' => 'aaaLocalMgmtCmdLog',
    '2404' => 'powerFIMember',
    '2405' => 'powerFexMember',
    '2406' => 'swFcUserZoneGroup',
    '2407' => 'swFcUserZone',
    '2408' => 'swFcEndpoint',
    '2414' => 'firmwareRackPowerCapConstraint',
    '2415' => 'firmwareActivityTrigger',
    '2416' => 'controllerHaController',
    '2417' => 'controllerPreferedVersionHolder',
    '2418' => 'controllerOperationalVersionHolder',
    '2422' => 'equipmentSystemIOControllerFsmTask',
    '2423' => 'storageEnclosureFsmTask',
    '2424' => 'storageLocalDiskFsmTask',
    '2427' => 'equipmentSystemIOControllerFsm',
    '2428' => 'equipmentSystemIOControllerFsmStage',
    '2429' => 'storageEnclosureFsm',
    '2430' => 'storageEnclosureFsmStage',
    '2431' => 'storageLocalDiskFsm',
    '2432' => 'storageLocalDiskFsmStage',
    '2433' => 'equipmentDriveSecCap',
    '2434' => 'policySourceApp',
    '2435' => 'policyContext',
    '2436' => 'policyScope',
    '2437' => 'policyPolicyDestClass',
    '2438' => 'policyRequestor',
    '2439' => 'policyADestEp',
    '2440' => 'policyDestEp',
    '2441' => 'policyDestClass',
    '2442' => 'policyChildClass',
    '2443' => 'lstorageSecurity',
    '2444' => 'lstorageDriveSecurity',
    '2445' => 'lstorageLocalConfig',
    '2446' => 'lstorageLocal',
    '2447' => 'lstorageLocalDef',
    '2448' => 'lstorageRemoteConfig',
    '2449' => 'lstorageRemote',
    '2450' => 'lstorageRemoteDef',
    '2451' => 'lstorageLogin',
    '2452' => 'diagMemoryTest',
    '2453' => 'diagLogEp',
    '2454' => 'equipmentInventoryStatus',
    '2455' => 'fabricBaseNetGroup',
    '2456' => 'fabricANetGroup',
    '2457' => 'fabricASanGroup',
    '2458' => 'fabricSanGroup',
    '2459' => 'fabricANetGroupRef',
    '2460' => 'fabricNetGroupRef',
    '2461' => 'fabricSanGroupRef',
    '2462' => 'domainChassisFeature',
    '2463' => 'domainChassisParam',
    '2464' => 'computePhysicalExtension',
    '2465' => 'computePortDiscPolicy',
    '2466' => 'storageNvmeStorage',
    '2467' => 'firmwareServicePack',
    '2468' => 'firmwareModule',
    '2469' => 'firmwareAChassisConstraint',
    '2470' => 'firmwareDualVicChassisConstraint',
    '2471' => 'firmwareSecondControllerChassisConstraint',
    '2472' => 'firmwareSecondControllerServerConstraint',
    '2473' => 'firmwareDualVicServerConstraint',
    '2474' => 'firmwareDriveSecurityConstraint',
    '2475' => 'networkLimit',
    '2476' => 'mgmtKmipCertPolicy',
    '2477' => 'mgmtDbState',
    '2478' => 'mgmtSecurity',
    '2479' => 'mgmtKmip',
    '2480' => 'equipmentComputeConnPolicy',
    '2481' => 'equipmentComputeConn',
    '2482' => 'equipmentBiosTokenOverride',
    '2483' => 'equipmentHxCap',
    '2484' => 'equipmentMgmtControllerCap',
    '2485' => 'equipmentHostMgmtControllerCap',
    '2486' => 'fabricVnetGroupPermit',
    '2487' => 'fabricVlanGroupPermit',
    '2488' => 'moKvCfgHolder',
    '2489' => 'moKvInvHolder',
    '2490' => 'moAbstractKv',
    '2491' => 'moAbstractCfgKv',
    '2492' => 'moAbstractInvKv',
    '2493' => 'moInvKv',
    '2494' => 'moKv',
    '2495' => 'moIpAddrKv',
    '2496' => 'moIpV4AddrKv',
    '2497' => 'moIpV6AddrKv',
    '2498' => 'moVnicKv',
    '2499' => 'swPortDiscover',
    '2500' => 'swEtherPort',
    '2501' => 'controllerMgmtDbCheckPol',
    '2502' => 'policyConfigError',
    '2503' => 'sysdebugDiagnosticLogRepository',
    '2504' => 'sysdebugDiagnosticLog',
    '2505' => 'computeRebootLog',
    '2506' => 'computeGraphicsCardPolicy',
    '2507' => 'computeHwChangeDiscPolicy',
    '2508' => 'domainChassisFeatureCont',
    '2509' => 'storageSsdHealthStats',
    '2510' => 'storageSsdHealthStatsHist',
    '2511' => 'policyPolicyScopeContFsmTask',
    '2512' => 'policyRequestorFsmTask',
    '2513' => 'swPortDiscoverFsmTask',
    '2514' => 'policyPolicyScopeContFsm',
    '2515' => 'policyPolicyScopeContFsmStage',
    '2516' => 'policyRequestorFsm',
    '2517' => 'policyRequestorFsmStage',
    '2518' => 'swPortDiscoverFsm',
    '2519' => 'swPortDiscoverFsmStage',
    '2520' => 'biosTokenFeatureGroup',
    '2521' => 'biosTokenParam',
    '2522' => 'biosTokenSettings',
    '2523' => 'lsbootNvme',
    '2524' => 'lsbootNvmeDevice',
    '2525' => 'lsbootNvmeDiskSsd',
    '2526' => 'lsbootNvmePciSsd',
    '2527' => 'storageMiniStorage',
    '2528' => 'storageControllerReference',
    '2529' => 'equipmentMiniStorageCapProvider',
    '2530' => 'equipmentNvmeDef',
  },
  'CucsFabricComputeSlotEpFsmCurrentFsm' => {
    '0' => 'nop',
    '20' => 'identify',
  },
  'CucsConditionActionIndicator' => {
    '0' => 'creation',
    '1' => 'modification',
    '2' => 'deletion',
    '3' => 'stateTransition',
    '4' => 'special',
    '5' => 'failure',
  },
  'CucsMgmtSecureBootOperState' => {
    '0' => 'disabled',
    '1' => 'enabled',
    '2' => 'unsupported',
    '3' => 'enabling',
  },
  'CucsMgmtAbsBackupPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsSwEthLanBorderFsmCurrentFsm' => {
    '0' => 'nop',
    '224' => 'deploy',
  },
  'CucsStorageMembershipStatus' => {
    '0' => 'unknown',
    '1' => 'down',
    '2' => 'up',
    '3' => 'hotStandby',
  },
  'CucsMgmtControllerFsmCurrentFsm' => {
    '0' => 'nop',
    '17' => 'extMgmtIfConfig',
    '248' => 'updateSwitch',
    '253' => 'updateIOM',
    '256' => 'activateIOM',
    '259' => 'updateBMC',
    '262' => 'activateBMC',
    '467' => 'updateUCSManager',
    '474' => 'sysConfig',
    '1059' => 'online',
    '1191' => 'registryConfig',
    '1493' => 'extMgmtInterfaceConfig',
    '1686' => 'lockConfig',
    '1688' => 'powerBudgetReclaimConfig',
    '1845' => 'updateCMC',
    '1848' => 'activateCMC',
    '1852' => 'updateAdaptor',
    '1855' => 'activateAdaptor',
    '1861' => 'updateRaidController',
    '1868' => 'updateBoardController',
    '2024' => 'powerCap',
    '2103' => 'enableSecureBoot',
    '2108' => 'updateColusaCMC',
    '2111' => 'activateColusaCMC',
    '2138' => 'updateColusaBoardController',
    '2146' => 'updateSasExpander',
    '2149' => 'activateSasExpander',
    '2153' => 'activateLocalDisk',
    '2195' => 'updateUCSManagerSP',
  },
  'CucsNetworkPortType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsStatsCollectionPolicyFsmStageName' => {
    '0' => 'nop',
    '310' => 'updateEpBegin',
    '311' => 'updateEpSetEpA',
    '312' => 'updateEpSetEpB',
    '432' => 'updateEpFail',
    '433' => 'updateEpSuccess',
  },
  'CucsComputeSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '212' => 'register',
  },
  'CucsPolicyControlledTypeFsmTaskItem' => {
    '0' => 'nop',
    '1479' => 'operate',
  },
  'CucsPortMode' => {
    '0' => 'unknown',
    '1' => 'access',
    '2' => 'trunk',
    '3' => 'fabric',
    '4' => 'nProxy',
    '5' => 'f',
    '6' => 'e',
    '7' => 'sd',
    '8' => 'vntag',
    '9' => 'promiscuousTrunk',
  },
  'CucsBiosVfFrontPanelLockoutVpFrontPanelLockout' => {
    '0' => 'platformRecommended',
    '60' => 'disabled',
    '61' => 'enabled',
  },
  'CucsLstorageAvailability' => {
    '0' => 'unavailable',
    '1' => 'available',
  },
  'CucsVnicIpcType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsFirmwareTransport' => {
    '0' => 'ftp',
    '1' => 'tftp',
    '2' => 'scp',
    '3' => 'sftp',
    '4' => 'local',
    '5' => 'usbA',
    '6' => 'usbB',
  },
  'CucsHostagAction' => {
    '0' => 'none',
  },
  'CucsMgmtCmcSecureBootOperationAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsStatsHourlyRecords' => {
    '0' => 'none',
    '168' => 'n1week',
    '336' => 'n2weeks',
    '672' => 'n4weeks',
    '1344' => 'n8weeks',
  },
  'CucsFabricVlanOperState' => {
    '1' => 'ok',
    '2' => 'errorMisconfigured',
  },
  'CucsBiosVfUSBConfigurationVpLegacyUSBSupport' => {
    '0' => 'platformRecommended',
    '479' => 'disabled',
    '480' => 'enabled',
    '481' => 'auto',
  },
  'CucsVnicExternalMgmtIPMode' => {
    '1' => 'none',
    '2' => 'static',
    '3' => 'pooled',
  },
  'CucsStorageOperationStateType' => {
    '0' => 'partitionNonMirrored',
    '1' => 'partitionMirrored',
    '2' => 'partitionMirroredSyncing',
    '3' => 'partitionMirroredErasing',
    '4' => 'partitionMirroredUpdating',
    '5' => 'partitionNonMirroredUpdating',
    '6' => 'partitionNonMirroredErasing',
    '7' => 'partitionMirroredSyncingFail',
    '8' => 'partitionMirroredErasingFail',
    '9' => 'partitionMirroredUpdatingFail',
    '10' => 'partitionNonMirroredUpdatingFail',
    '11' => 'partitionNonMirroredErasingFail',
    '12' => 'partitionMirroredSyncingSuccess',
    '13' => 'partitionMirroredErasingSuccess',
    '14' => 'partitionMirroredUpdatingSuccess',
    '15' => 'partitionNonMirroredUpdatingSuccess',
    '16' => 'partitionNonMirroredErasingSuccess',
    '17' => 'unknown',
  },
  'CucsEquipmentSlotArrayLocation' => {
    '0' => 'unknown',
    '1' => 'front',
    '2' => 'back',
    '3' => 'top',
    '4' => 'bottom',
    '5' => 'left',
    '6' => 'right',
  },
  'CucsDiagMemChunkSize' => {
    '0' => 'bigChunk',
    '1' => 'n5mbChunk',
  },
  'CucsBiosBootDevErrorCode' => {
    '0' => 'success',
    '1' => 'failure',
  },
  'CucsConfigConsumerCatalogueFsmCurrentFsm' => {
    '0' => 'nop',
    '181' => 'delete',
    '332' => 'create',
  },
  'CucsVnicProfileSetFsmCurrentFsm' => {
    '0' => 'nop',
    '187' => 'deploy',
    '1118' => 'deployAlias',
  },
  'CucsFabricEthLanPcVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CucsFirmwareDownloaderFsmTaskItem' => {
    '0' => 'nop',
    '233' => 'download',
  },
  'CucsSmartcallhomeFormat' => {
    '1' => 'xml',
    '2' => 'fullTxt',
    '4' => 'shortTxt',
  },
  'CucsLicenseType' => {
    '0' => 'increment',
    '1' => 'upgrade',
    '2' => 'feature',
  },
  'CucsSwEthLanFlowMonFsmStageName' => {
    '0' => 'nop',
    '1537' => 'deployBegin',
    '1538' => 'deployUpdateEthFlowMon',
    '1560' => 'deployFail',
    '1561' => 'deploySuccess',
  },
  'CucsEquipmentChassisFsmTaskItem' => {
    '0' => 'nop',
    '9' => 'removeChassis',
    '140' => 'psuPolicyConfig',
    '829' => 'powerCap',
    '1048' => 'dynamicReallocation',
    '1883' => 'oobStorageAdminCfg',
    '2067' => 'associate',
    '2098' => 'disassociate',
    '2115' => 'chassisUpgrade',
  },
  'CucsLsUUIDIdentityState' => {
    '0' => 'consistent',
    '1' => 'mismatch',
  },
  'CucsLsbootVirtualMediaOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CucsSwExtUtilityFsmStageName' => {
    '0' => 'nop',
    '1985' => 'confPortBreakoutBegin',
    '1986' => 'confPortBreakoutPortInventorySwA',
    '1987' => 'confPortBreakoutPortInventorySwB',
    '1988' => 'confPortBreakoutConfigSwA',
    '1989' => 'confPortBreakoutConfigSwB',
    '1990' => 'confPortBreakoutVerifyBreakoutConfig',
    '1991' => 'confPortBreakoutSuccess',
    '1992' => 'confPortBreakoutFail',
  },
  'CucsSmartlicenseAgentFsmCurrentFsm' => {
    '0' => 'nop',
    '480' => 'configure',
  },
  'CucsExtvmmEpFsmTaskItem' => {
    '0' => 'nop',
    '1086' => 'clusterRole',
  },
  'CucsStatsThrFloatDefinitionPropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CucsFirmwarePolicyAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsPolicyState' => {
    '0' => 'ok',
    '1' => 'outOfSync',
  },
  'CucsExtvmmEpFsmStageName' => {
    '0' => 'nop',
    '1129' => 'clusterRoleBegin',
    '1130' => 'clusterRoleSetPeer',
    '1131' => 'clusterRoleSetLocal',
    '1142' => 'clusterRoleFail',
    '1143' => 'clusterRoleSuccess',
  },
  'CucsBiosVfProcessorCStateVpProcessorCState' => {
    '0' => 'platformRecommended',
    '200' => 'disabled',
    '201' => 'enabled',
  },
  'CucsMgmtIPv6IfAddrFsmCurrentFsm' => {
    '0' => 'nop',
    '1535' => 'swMgmtOobIpv6IfConfig',
  },
  'CucsLsbootUsbExternalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsEquipmentChassisProfileBindingOperState' => {
    '0' => 'unused',
    '1' => 'used',
    '2' => 'failedToApply',
  },
  'CucsAaaDomainAuthRealm' => {
    '0' => 'local',
    '1' => 'radius',
    '2' => 'tacacs',
    '3' => 'ldap',
    '4' => 'none',
  },
  'CucsFabricEthLanPcOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsPolicySharedSecretPushStateType' => {
    '0' => 'unknown',
    '1' => 'fail',
    '2' => 'ok',
  },
  'CucsVnicAFcIfSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsLsmaintMaintPolicyUptimeDisr' => {
    '0' => 'immediate',
    '1' => 'userAck',
    '2' => 'timerAutomatic',
  },
  'CucsEquipmentDiscovery' => {
    '0' => 'undiscovered',
    '1' => 'inProgress',
    '2' => 'malformedFruInfo',
    '3' => 'fruNotReady',
    '4' => 'insufficientlyEquipped',
    '5' => 'invalidAdaptorIocard',
    '8' => 'failed',
    '16' => 'complete',
    '32' => 'retry',
    '64' => 'throttled',
    '128' => 'illegalFru',
    '129' => 'fruIdentityIndeterminate',
    '130' => 'fruStateIndeterminate',
  },
  'CucsDiagNetworkTestType' => {
    '0' => 'eth',
    '1' => 'fc',
  },
  'CucsFabricRecoveryAction' => {
    '0' => 'none',
    '1' => 'reset',
  },
  'CucsPolicyPolicyScopeContFsmTaskItem' => {
    '0' => 'nop',
    '2251' => 'reportPolicyFailFsm',
  },
  'CucsLsResolveFromRemoteServer' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsFabricFcoeEstcEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsSwFcSanBorderFsmStageName' => {
    '0' => 'nop',
    '226' => 'deployBegin',
    '227' => 'deployUpdateConnectivity',
    '438' => 'deployFail',
    '439' => 'deploySuccess',
    '1185' => 'activateZoneSetBegin',
    '1186' => 'activateZoneSetUpdateZones',
    '1465' => 'activateZoneSetFail',
    '1466' => 'activateZoneSetSuccess',
    '2100' => 'activateZoneSetVerifyUserZoneConfig',
  },
  'CucsBiosVfSIOC2OptionROMVpSIOC2OptionROM' => {
    '0' => 'platformRecommended',
    '576' => 'disabled',
    '577' => 'enabled',
    '578' => 'uefiOnly',
    '579' => 'legacyOnly',
  },
  'CucsFabricDirection' => {
    '1' => 'receive',
    '2' => 'transmit',
  },
  'CucsSysdebugTechSupportFsmTaskItem' => {
    '0' => 'nop',
    '881' => 'initiate',
    '883' => 'deleteTechSupFile',
    '886' => 'download',
  },
  'CucsPolicyPolicyScopeFsmTaskItem' => {
    '0' => 'nop',
    '1201' => 'releasePolicyFsm',
    '1203' => 'releaseOperationFsm',
    '1205' => 'releaseStorageFsm',
    '1207' => 'resolveManyPolicyFsm',
    '1209' => 'resolveManyOperationFsm',
    '1211' => 'resolveManyStorageFsm',
    '1213' => 'releaseManyPolicyFsm',
    '1215' => 'releaseManyOperationFsm',
    '1217' => 'releaseManyStorageFsm',
    '1219' => 'resolveAllPolicyFsm',
    '1221' => 'resolveAllOperationFsm',
    '1223' => 'resolveAllStorageFsm',
    '1225' => 'releaseAllPolicyFsm',
    '1227' => 'releaseAllOperationFsm',
    '1229' => 'releaseAllStorageFsm',
  },
  'CucsLsbootIScsiAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsConditionCode' => {
    '0' => 'generic',
    '156' => 'f0156',
    '157' => 'f0157',
    '169' => 'f0169',
    '170' => 'f0170',
    '174' => 'f0174',
    '175' => 'f0175',
    '176' => 'f0176',
    '177' => 'f0177',
    '178' => 'f0178',
    '179' => 'f0179',
    '180' => 'f0180',
    '181' => 'f0181',
    '182' => 'f0182',
    '183' => 'f0183',
    '184' => 'f0184',
    '185' => 'f0185',
    '186' => 'f0186',
    '187' => 'f0187',
    '188' => 'f0188',
    '189' => 'f0189',
    '190' => 'f0190',
    '191' => 'f0191',
    '200' => 'f0200',
    '203' => 'f0203',
    '206' => 'f0206',
    '207' => 'f0207',
    '209' => 'f0209',
    '276' => 'f0276',
    '277' => 'f0277',
    '278' => 'f0278',
    '279' => 'f0279',
    '282' => 'f0282',
    '283' => 'f0283',
    '291' => 'f0291',
    '293' => 'f0293',
    '294' => 'f0294',
    '304' => 'f0304',
    '305' => 'f0305',
    '306' => 'f0306',
    '310' => 'f0310',
    '311' => 'f0311',
    '312' => 'f0312',
    '313' => 'f0313',
    '314' => 'f0314',
    '315' => 'f0315',
    '317' => 'f0317',
    '318' => 'f0318',
    '319' => 'f0319',
    '320' => 'f0320',
    '321' => 'f0321',
    '322' => 'f0322',
    '324' => 'f0324',
    '326' => 'f0326',
    '327' => 'f0327',
    '329' => 'f0329',
    '330' => 'f0330',
    '331' => 'f0331',
    '332' => 'f0332',
    '334' => 'f0334',
    '337' => 'f0337',
    '367' => 'f0367',
    '368' => 'f0368',
    '369' => 'f0369',
    '371' => 'f0371',
    '373' => 'f0373',
    '374' => 'f0374',
    '376' => 'f0376',
    '377' => 'f0377',
    '378' => 'f0378',
    '379' => 'f0379',
    '380' => 'f0380',
    '381' => 'f0381',
    '382' => 'f0382',
    '383' => 'f0383',
    '384' => 'f0384',
    '385' => 'f0385',
    '387' => 'f0387',
    '389' => 'f0389',
    '391' => 'f0391',
    '392' => 'f0392',
    '393' => 'f0393',
    '394' => 'f0394',
    '395' => 'f0395',
    '396' => 'f0396',
    '397' => 'f0397',
    '398' => 'f0398',
    '399' => 'f0399',
    '400' => 'f0400',
    '401' => 'f0401',
    '402' => 'f0402',
    '403' => 'f0403',
    '404' => 'f0404',
    '405' => 'f0405',
    '406' => 'f0406',
    '407' => 'f0407',
    '408' => 'f0408',
    '409' => 'f0409',
    '410' => 'f0410',
    '411' => 'f0411',
    '424' => 'f0424',
    '425' => 'f0425',
    '428' => 'f0428',
    '429' => 'f0429',
    '430' => 'f0430',
    '434' => 'f0434',
    '435' => 'f0435',
    '436' => 'f0436',
    '440' => 'f0440',
    '451' => 'f0451',
    '452' => 'f0452',
    '453' => 'f0453',
    '454' => 'f0454',
    '455' => 'f0455',
    '456' => 'f0456',
    '458' => 'f0458',
    '459' => 'f0459',
    '460' => 'f0460',
    '461' => 'f0461',
    '462' => 'f0462',
    '463' => 'f0463',
    '464' => 'f0464',
    '465' => 'f0465',
    '466' => 'f0466',
    '470' => 'f0470',
    '471' => 'f0471',
    '476' => 'f0476',
    '478' => 'f0478',
    '479' => 'f0479',
    '480' => 'f0480',
    '481' => 'f0481',
    '484' => 'f0484',
    '502' => 'f0502',
    '517' => 'f0517',
    '528' => 'f0528',
    '531' => 'f0531',
    '532' => 'f0532',
    '533' => 'f0533',
    '535' => 'f0535',
    '536' => 'f0536',
    '537' => 'f0537',
    '538' => 'f0538',
    '539' => 'f0539',
    '540' => 'f0540',
    '543' => 'f0543',
    '549' => 'f0549',
    '620' => 'f0620',
    '621' => 'f0621',
    '622' => 'f0622',
    '625' => 'f0625',
    '626' => 'f0626',
    '635' => 'f0635',
    '637' => 'f0637',
    '640' => 'f0640',
    '642' => 'f0642',
    '643' => 'f0643',
    '670' => 'f0670',
    '671' => 'f0671',
    '672' => 'f0672',
    '673' => 'f0673',
    '674' => 'f0674',
    '675' => 'f0675',
    '676' => 'f0676',
    '677' => 'f0677',
    '678' => 'f0678',
    '688' => 'f0688',
    '689' => 'f0689',
    '702' => 'f0702',
    '703' => 'f0703',
    '708' => 'f0708',
    '713' => 'f0713',
    '717' => 'f0717',
    '727' => 'f0727',
    '728' => 'f0728',
    '729' => 'f0729',
    '730' => 'f0730',
    '731' => 'f0731',
    '733' => 'f0733',
    '734' => 'f0734',
    '735' => 'f0735',
    '736' => 'f0736',
    '740' => 'f0740',
    '741' => 'f0741',
    '742' => 'f0742',
    '743' => 'f0743',
    '744' => 'f0744',
    '747' => 'f0747',
    '757' => 'f0757',
    '764' => 'f0764',
    '765' => 'f0765',
    '766' => 'f0766',
    '772' => 'f0772',
    '775' => 'f0775',
    '776' => 'f0776',
    '777' => 'f0777',
    '778' => 'f0778',
    '791' => 'f0791',
    '792' => 'f0792',
    '793' => 'f0793',
    '794' => 'f0794',
    '795' => 'f0795',
    '796' => 'f0796',
    '797' => 'f0797',
    '798' => 'f0798',
    '801' => 'f0801',
    '807' => 'f0807',
    '821' => 'f0821',
    '826' => 'f0826',
    '829' => 'f0829',
    '831' => 'f0831',
    '832' => 'f0832',
    '833' => 'f0833',
    '834' => 'f0834',
    '835' => 'f0835',
    '836' => 'f0836',
    '837' => 'f0837',
    '838' => 'f0838',
    '840' => 'f0840',
    '841' => 'f0841',
    '842' => 'f0842',
    '843' => 'f0843',
    '844' => 'f0844',
    '846' => 'f0846',
    '855' => 'f0855',
    '856' => 'f0856',
    '857' => 'f0857',
    '858' => 'f0858',
    '859' => 'f0859',
    '861' => 'f0861',
    '862' => 'f0862',
    '863' => 'f0863',
    '864' => 'f0864',
    '865' => 'f0865',
    '866' => 'f0866',
    '867' => 'f0867',
    '868' => 'f0868',
    '869' => 'f0869',
    '872' => 'f0872',
    '874' => 'f0874',
    '875' => 'f0875',
    '876' => 'f0876',
    '877' => 'f0877',
    '878' => 'f0878',
    '879' => 'f0879',
    '880' => 'f0880',
    '881' => 'f0881',
    '882' => 'f0882',
    '883' => 'f0883',
    '884' => 'f0884',
    '885' => 'f0885',
    '887' => 'f0887',
    '890' => 'f0890',
    '900' => 'f0900',
    '901' => 'f0901',
    '902' => 'f0902',
    '903' => 'f0903',
    '909' => 'f0909',
    '910' => 'f0910',
    '915' => 'f0915',
    '916' => 'f0916',
    '917' => 'f0917',
    '918' => 'f0918',
    '919' => 'f0919',
    '920' => 'f0920',
    '921' => 'f0921',
    '928' => 'f0928',
    '932' => 'f0932',
    '933' => 'f0933',
    '934' => 'f0934',
    '935' => 'f0935',
    '936' => 'f0936',
    '937' => 'f0937',
    '943' => 'f0943',
    '944' => 'f0944',
    '945' => 'f0945',
    '946' => 'f0946',
    '947' => 'f0947',
    '948' => 'f0948',
    '949' => 'f0949',
    '950' => 'f0950',
    '951' => 'f0951',
    '952' => 'f0952',
    '953' => 'f0953',
    '954' => 'f0954',
    '957' => 'f0957',
    '958' => 'f0958',
    '959' => 'f0959',
    '967' => 'f0967',
    '968' => 'f0968',
    '969' => 'f0969',
    '970' => 'f0970',
    '971' => 'f0971',
    '972' => 'f0972',
    '973' => 'f0973',
    '974' => 'f0974',
    '975' => 'f0975',
    '976' => 'f0976',
    '977' => 'f0977',
    '978' => 'f0978',
    '979' => 'f0979',
    '980' => 'f0980',
    '981' => 'f0981',
    '982' => 'f0982',
    '988' => 'f0988',
    '996' => 'f0996',
    '997' => 'f0997',
    '998' => 'f0998',
    '999' => 'f0999',
    '1000' => 'f1000',
    '1001' => 'f1001',
    '1002' => 'f1002',
    '1003' => 'f1003',
    '1004' => 'f1004',
    '1005' => 'f1005',
    '1006' => 'f1006',
    '1007' => 'f1007',
    '1008' => 'f1008',
    '1009' => 'f1009',
    '1010' => 'f1010',
    '1017' => 'f1017',
    '1026' => 'f1026',
    '1027' => 'f1027',
    '1028' => 'f1028',
    '1029' => 'f1029',
    '1030' => 'f1030',
    '1031' => 'f1031',
    '1032' => 'f1032',
    '1033' => 'f1033',
    '1034' => 'f1034',
    '1035' => 'f1035',
    '1036' => 'f1036',
    '1037' => 'f1037',
    '1040' => 'f1040',
    '1046' => 'f1046',
    '1047' => 'f1047',
    '1048' => 'f1048',
    '1049' => 'f1049',
    '1050' => 'f1050',
    '1051' => 'f1051',
    '1052' => 'f1052',
    '1053' => 'f1053',
    '1054' => 'f1054',
    '1055' => 'f1055',
    '1056' => 'f1056',
    '1057' => 'f1057',
    '1058' => 'f1058',
    '1080' => 'f1080',
    '1081' => 'f1081',
    '1082' => 'f1082',
    '1083' => 'f1083',
    '1084' => 'f1084',
    '1085' => 'f1085',
    '1086' => 'f1086',
    '1087' => 'f1087',
    '1088' => 'f1088',
    '1089' => 'f1089',
    '1090' => 'f1090',
    '1091' => 'f1091',
    '1092' => 'f1092',
    '1093' => 'f1093',
    '1094' => 'f1094',
    '1095' => 'f1095',
    '1097' => 'f1097',
    '1098' => 'f1098',
    '1099' => 'f1099',
    '1101' => 'f1101',
    '1102' => 'f1102',
    '1103' => 'f1103',
    '1104' => 'f1104',
    '1105' => 'f1105',
    '1106' => 'f1106',
    '1114' => 'f1114',
    '1202' => 'f1202',
    '1204' => 'f1204',
    '1205' => 'f1205',
    '1206' => 'f1206',
    '1207' => 'f1207',
    '1208' => 'f1208',
    '1209' => 'f1209',
    '1211' => 'f1211',
    '1212' => 'f1212',
    '1213' => 'f1213',
    '1214' => 'f1214',
    '1215' => 'f1215',
    '1216' => 'f1216',
    '1217' => 'f1217',
    '1218' => 'f1218',
    '1219' => 'f1219',
    '1220' => 'f1220',
    '1221' => 'f1221',
    '1222' => 'f1222',
    '1223' => 'f1223',
    '1224' => 'f1224',
    '1225' => 'f1225',
    '1226' => 'f1226',
    '1227' => 'f1227',
    '1228' => 'f1228',
    '1229' => 'f1229',
    '1232' => 'f1232',
    '1233' => 'f1233',
    '1236' => 'f1236',
    '1237' => 'f1237',
    '1249' => 'f1249',
    '1250' => 'f1250',
    '1251' => 'f1251',
    '1252' => 'f1252',
    '1256' => 'f1256',
    '1257' => 'f1257',
    '1258' => 'f1258',
    '1259' => 'f1259',
    '1260' => 'f1260',
    '1261' => 'f1261',
    '1262' => 'f1262',
    '1279' => 'f1279',
    '1284' => 'f1284',
    '1285' => 'f1285',
    '1304' => 'f1304',
    '1305' => 'f1305',
    '1306' => 'f1306',
    '1320' => 'f1320',
    '1321' => 'f1321',
    '1325' => 'f1325',
    '1328' => 'f1328',
    '1329' => 'f1329',
    '1358' => 'f1358',
    '1359' => 'f1359',
    '1360' => 'f1360',
    '1361' => 'f1361',
    '1362' => 'f1362',
    '1363' => 'f1363',
    '1365' => 'f1365',
    '1366' => 'f1366',
    '1367' => 'f1367',
    '1368' => 'f1368',
    '1369' => 'f1369',
    '1380' => 'f1380',
    '1382' => 'f1382',
    '1383' => 'f1383',
    '1384' => 'f1384',
    '1385' => 'f1385',
    '1386' => 'f1386',
    '1388' => 'f1388',
    '1389' => 'f1389',
    '1390' => 'f1390',
    '1391' => 'f1391',
    '1392' => 'f1392',
    '1396' => 'f1396',
    '1397' => 'f1397',
    '1398' => 'f1398',
    '1399' => 'f1399',
    '1400' => 'f1400',
    '1402' => 'f1402',
    '1404' => 'f1404',
    '1419' => 'f1419',
    '1420' => 'f1420',
    '1421' => 'f1421',
    '1428' => 'f1428',
    '1429' => 'f1429',
    '1430' => 'f1430',
    '1431' => 'f1431',
    '1432' => 'f1432',
    '1433' => 'f1433',
    '1434' => 'f1434',
    '1437' => 'f1437',
    '1438' => 'f1438',
    '1439' => 'f1439',
    '1448' => 'f1448',
    '1449' => 'f1449',
    '1450' => 'f1450',
    '1451' => 'f1451',
    '1452' => 'f1452',
    '1453' => 'f1453',
    '1454' => 'f1454',
    '1455' => 'f1455',
    '1456' => 'f1456',
    '1464' => 'f1464',
    '1465' => 'f1465',
    '1467' => 'f1467',
    '1472' => 'f1472',
    '1473' => 'f1473',
    '1474' => 'f1474',
    '1475' => 'f1475',
    '1476' => 'f1476',
    '1477' => 'f1477',
    '1478' => 'f1478',
    '1480' => 'f1480',
    '1481' => 'f1481',
    '1482' => 'f1482',
    '1483' => 'f1483',
    '1493' => 'f1493',
    '1498' => 'f1498',
    '1499' => 'f1499',
    '1501' => 'f1501',
    '1502' => 'f1502',
    '1503' => 'f1503',
    '1504' => 'f1504',
    '1505' => 'f1505',
    '1506' => 'f1506',
    '1507' => 'f1507',
    '1508' => 'f1508',
    '1509' => 'f1509',
    '1510' => 'f1510',
    '1511' => 'f1511',
    '1512' => 'f1512',
    '1513' => 'f1513',
    '1514' => 'f1514',
    '1515' => 'f1515',
    '1516' => 'f1516',
    '1517' => 'f1517',
    '1518' => 'f1518',
    '1519' => 'f1519',
    '1520' => 'f1520',
    '1521' => 'f1521',
    '1522' => 'f1522',
    '1523' => 'f1523',
    '1558' => 'f1558',
    '1559' => 'f1559',
    '1560' => 'f1560',
    '1561' => 'f1561',
    '1562' => 'f1562',
    '1563' => 'f1563',
    '1564' => 'f1564',
    '1565' => 'f1565',
    '1566' => 'f1566',
    '1604' => 'f1604',
    '1605' => 'f1605',
    '1606' => 'f1606',
    '1616' => 'f1616',
    '1617' => 'f1617',
    '1618' => 'f1618',
    '1620' => 'f1620',
    '1621' => 'f1621',
    '1622' => 'f1622',
    '1623' => 'f1623',
    '1624' => 'f1624',
    '1627' => 'f1627',
    '1634' => 'f1634',
    '1635' => 'f1635',
    '1654' => 'f1654',
    '1668' => 'f1668',
    '1669' => 'f1669',
    '1671' => 'f1671',
    '1672' => 'f1672',
    '1675' => 'f1675',
    '1676' => 'f1676',
    '1680' => 'f1680',
    '1681' => 'f1681',
    '1685' => 'f1685',
    '1686' => 'f1686',
    '1687' => 'f1687',
    '1688' => 'f1688',
    '1694' => 'f1694',
    '1700' => 'f1700',
    '1701' => 'f1701',
    '1702' => 'f1702',
    '1703' => 'f1703',
    '1704' => 'f1704',
    '1705' => 'f1705',
    '1706' => 'f1706',
    '1707' => 'f1707',
    '1708' => 'f1708',
    '1709' => 'f1709',
    '1710' => 'f1710',
    '1713' => 'f1713',
    '1719' => 'f1719',
    '1720' => 'f1720',
    '1721' => 'f1721',
    '1731' => 'f1731',
    '1732' => 'f1732',
    '1744' => 'f1744',
    '1745' => 'f1745',
    '1748' => 'f1748',
    '1749' => 'f1749',
    '1753' => 'f1753',
    '1754' => 'f1754',
    '1755' => 'f1755',
    '1756' => 'f1756',
    '1757' => 'f1757',
    '1758' => 'f1758',
    '1761' => 'f1761',
    '1764' => 'f1764',
    '1766' => 'f1766',
    '1767' => 'f1767',
    '1768' => 'f1768',
    '1769' => 'f1769',
    '1778' => 'f1778',
    '1781' => 'f1781',
    '1784' => 'f1784',
    '1792' => 'f1792',
    '1793' => 'f1793',
    '1794' => 'f1794',
    '1795' => 'f1795',
    '1796' => 'f1796',
    '1797' => 'f1797',
    '1798' => 'f1798',
    '1799' => 'f1799',
    '1825' => 'f1825',
    '1826' => 'f1826',
    '1831' => 'f1831',
    '1832' => 'f1832',
    '1833' => 'f1833',
    '1834' => 'f1834',
    '1835' => 'f1835',
    '1836' => 'f1836',
    '1837' => 'f1837',
    '1838' => 'f1838',
    '1839' => 'f1839',
    '1840' => 'f1840',
    '1841' => 'f1841',
    '1842' => 'f1842',
    '1843' => 'f1843',
    '1844' => 'f1844',
    '1845' => 'f1845',
    '1846' => 'f1846',
    '1847' => 'f1847',
    '1848' => 'f1848',
    '1849' => 'f1849',
    '1850' => 'f1850',
    '1851' => 'f1851',
    '1852' => 'f1852',
    '1864' => 'f1864',
    '1873' => 'f1873',
    '1889' => 'f1889',
    '1890' => 'f1890',
    '1891' => 'f1891',
    '1892' => 'f1892',
    '1893' => 'f1893',
    '1894' => 'f1894',
    '1895' => 'f1895',
    '1896' => 'f1896',
    '1897' => 'f1897',
    '1898' => 'f1898',
    '1899' => 'f1899',
    '1900' => 'f1900',
    '1901' => 'f1901',
    '1902' => 'f1902',
    '1903' => 'f1903',
    '1907' => 'f1907',
    '1908' => 'f1908',
    '1912' => 'f1912',
    '1913' => 'f1913',
    '1914' => 'f1914',
    '1915' => 'f1915',
    '1916' => 'f1916',
    '1917' => 'f1917',
    '1926' => 'f1926',
    '1927' => 'f1927',
    '1932' => 'f1932',
    '1933' => 'f1933',
    '1934' => 'f1934',
    '16405' => 'f16405',
    '16406' => 'f16406',
    '16407' => 'f16407',
    '16408' => 'f16408',
    '16518' => 'f16518',
    '16519' => 'f16519',
    '16520' => 'f16520',
    '16533' => 'f16533',
    '16534' => 'f16534',
    '16535' => 'f16535',
    '16539' => 'f16539',
    '16550' => 'f16550',
    '16576' => 'f16576',
    '16577' => 'f16577',
    '16579' => 'f16579',
    '16580' => 'f16580',
    '16581' => 'f16581',
    '16582' => 'f16582',
    '16600' => 'f16600',
    '16601' => 'f16601',
    '16604' => 'f16604',
    '16605' => 'f16605',
    '16606' => 'f16606',
    '16634' => 'f16634',
    '16635' => 'f16635',
    '16636' => 'f16636',
    '16637' => 'f16637',
    '16641' => 'f16641',
    '16650' => 'f16650',
    '16651' => 'f16651',
    '16653' => 'f16653',
    '16654' => 'f16654',
    '16655' => 'f16655',
    '16656' => 'f16656',
    '16657' => 'f16657',
    '16670' => 'f16670',
    '16673' => 'f16673',
    '16674' => 'f16674',
    '16679' => 'f16679',
    '16680' => 'f16680',
    '16681' => 'f16681',
    '16682' => 'f16682',
    '16683' => 'f16683',
    '16684' => 'f16684',
    '16742' => 'f16742',
    '16745' => 'f16745',
    '16749' => 'f16749',
    '16750' => 'f16750',
    '16803' => 'f16803',
    '16815' => 'f16815',
    '16823' => 'f16823',
    '16852' => 'f16852',
    '16857' => 'f16857',
    '16858' => 'f16858',
    '16879' => 'f16879',
    '16880' => 'f16880',
    '16881' => 'f16881',
    '16898' => 'f16898',
    '16904' => 'f16904',
    '16906' => 'f16906',
    '16930' => 'f16930',
    '16931' => 'f16931',
    '16942' => 'f16942',
    '16943' => 'f16943',
    '16944' => 'f16944',
    '16945' => 'f16945',
    '16973' => 'f16973',
    '16974' => 'f16974',
    '16975' => 'f16975',
    '16976' => 'f16976',
    '16977' => 'f16977',
    '16978' => 'f16978',
    '16979' => 'f16979',
    '16980' => 'f16980',
    '16981' => 'f16981',
    '16982' => 'f16982',
    '16983' => 'f16983',
    '16984' => 'f16984',
    '16986' => 'f16986',
    '16987' => 'f16987',
    '16988' => 'f16988',
    '16994' => 'f16994',
    '16995' => 'f16995',
    '17000' => 'f17000',
    '17001' => 'f17001',
    '17002' => 'f17002',
    '17008' => 'f17008',
    '17012' => 'f17012',
    '17013' => 'f17013',
    '17014' => 'f17014',
    '17043' => 'f17043',
    '17044' => 'f17044',
    '17045' => 'f17045',
    '17046' => 'f17046',
    '17050' => 'f17050',
    '17051' => 'f17051',
    '17052' => 'f17052',
    '17053' => 'f17053',
    '17083' => 'f17083',
    '17084' => 'f17084',
    '17089' => 'f17089',
    '17116' => 'f17116',
    '17133' => 'f17133',
    '17134' => 'f17134',
    '17163' => 'f17163',
    '17169' => 'f17169',
    '17170' => 'f17170',
    '17187' => 'f17187',
    '17188' => 'f17188',
    '17190' => 'f17190',
    '17192' => 'f17192',
    '17195' => 'f17195',
    '17196' => 'f17196',
    '17207' => 'f17207',
    '17214' => 'f17214',
    '17223' => 'f17223',
    '17232' => 'f17232',
    '17239' => 'f17239',
    '17254' => 'f17254',
    '17259' => 'f17259',
    '17262' => 'f17262',
    '17271' => 'f17271',
    '17281' => 'f17281',
    '17282' => 'f17282',
    '17312' => 'f17312',
    '17313' => 'f17313',
    '17325' => 'f17325',
    '17326' => 'f17326',
    '17327' => 'f17327',
    '17328' => 'f17328',
    '17339' => 'f17339',
    '17340' => 'f17340',
    '17348' => 'f17348',
    '17349' => 'f17349',
    '17350' => 'f17350',
    '17358' => 'f17358',
    '17359' => 'f17359',
    '17360' => 'f17360',
    '17361' => 'f17361',
    '17367' => 'f17367',
    '17377' => 'f17377',
    '17378' => 'f17378',
    '17379' => 'f17379',
    '17381' => 'f17381',
    '17382' => 'f17382',
    '17383' => 'f17383',
    '17384' => 'f17384',
    '17395' => 'f17395',
    '17399' => 'f17399',
    '17400' => 'f17400',
    '17402' => 'f17402',
    '17403' => 'f17403',
    '17404' => 'f17404',
    '17405' => 'f17405',
    '17406' => 'f17406',
    '17407' => 'f17407',
    '17408' => 'f17408',
    '17409' => 'f17409',
    '17410' => 'f17410',
    '17411' => 'f17411',
    '17412' => 'f17412',
    '17413' => 'f17413',
    '17414' => 'f17414',
    '17415' => 'f17415',
    '17416' => 'f17416',
    '17418' => 'f17418',
    '17419' => 'f17419',
    '17420' => 'f17420',
    '17425' => 'f17425',
    '17426' => 'f17426',
    '17427' => 'f17427',
    '17428' => 'f17428',
    '17439' => 'f17439',
    '17445' => 'f17445',
    '17446' => 'f17446',
    '17447' => 'f17447',
    '17448' => 'f17448',
    '17449' => 'f17449',
    '17450' => 'f17450',
    '17451' => 'f17451',
    '17452' => 'f17452',
    '17453' => 'f17453',
    '17454' => 'f17454',
    '17455' => 'f17455',
    '17456' => 'f17456',
    '17457' => 'f17457',
    '17458' => 'f17458',
    '17459' => 'f17459',
    '17460' => 'f17460',
    '17461' => 'f17461',
    '17462' => 'f17462',
    '17476' => 'f17476',
    '17477' => 'f17477',
    '17478' => 'f17478',
    '17483' => 'f17483',
    '17484' => 'f17484',
    '17485' => 'f17485',
    '17491' => 'f17491',
    '17492' => 'f17492',
    '17493' => 'f17493',
    '17494' => 'f17494',
    '17499' => 'f17499',
    '17599' => 'f17599',
    '17601' => 'f17601',
    '17602' => 'f17602',
    '17608' => 'f17608',
    '17609' => 'f17609',
    '17612' => 'f17612',
    '17619' => 'f17619',
    '17639' => 'f17639',
    '17665' => 'f17665',
    '17667' => 'f17667',
    '17703' => 'f17703',
    '17707' => 'f17707',
    '17708' => 'f17708',
    '17714' => 'f17714',
    '17715' => 'f17715',
    '17716' => 'f17716',
    '17717' => 'f17717',
    '17755' => 'f17755',
    '17757' => 'f17757',
    '17762' => 'f17762',
    '17788' => 'f17788',
    '17791' => 'f17791',
    '17792' => 'f17792',
    '17793' => 'f17793',
    '17806' => 'f17806',
    '17818' => 'f17818',
    '17819' => 'f17819',
    '17820' => 'f17820',
    '17824' => 'f17824',
    '17826' => 'f17826',
    '17850' => 'f17850',
    '17921' => 'f17921',
    '17922' => 'f17922',
    '17923' => 'f17923',
    '17924' => 'f17924',
    '17925' => 'f17925',
    '17926' => 'f17926',
    '17927' => 'f17927',
    '17928' => 'f17928',
    '17933' => 'f17933',
    '17934' => 'f17934',
    '17935' => 'f17935',
    '17940' => 'f17940',
    '17941' => 'f17941',
    '17954' => 'f17954',
    '17978' => 'f17978',
    '17984' => 'f17984',
    '17987' => 'f17987',
    '18012' => 'f18012',
    '18013' => 'f18013',
    '18014' => 'f18014',
    '18015' => 'f18015',
    '18016' => 'f18016',
    '18017' => 'f18017',
    '18024' => 'f18024',
    '18025' => 'f18025',
    '18026' => 'f18026',
    '18032' => 'f18032',
    '18033' => 'f18033',
    '18034' => 'f18034',
    '18045' => 'f18045',
    '18046' => 'f18046',
    '18051' => 'f18051',
    '18102' => 'f18102',
    '18124' => 'f18124',
    '18146' => 'f18146',
    '18147' => 'f18147',
    '18161' => 'f18161',
    '18169' => 'f18169',
    '18184' => 'f18184',
    '18185' => 'f18185',
    '18186' => 'f18186',
    '18206' => 'f18206',
    '18207' => 'f18207',
    '18208' => 'f18208',
    '18237' => 'f18237',
    '18239' => 'f18239',
    '18240' => 'f18240',
    '18241' => 'f18241',
    '18242' => 'f18242',
    '18243' => 'f18243',
    '18244' => 'f18244',
    '18245' => 'f18245',
    '18246' => 'f18246',
    '18247' => 'f18247',
    '18259' => 'f18259',
    '18260' => 'f18260',
    '18261' => 'f18261',
    '18290' => 'f18290',
    '18293' => 'f18293',
    '18294' => 'f18294',
    '33142' => 'f33142',
    '33144' => 'f33144',
    '33145' => 'f33145',
    '33146' => 'f33146',
    '33167' => 'f33167',
    '33168' => 'f33168',
    '33169' => 'f33169',
    '33170' => 'f33170',
    '33177' => 'f33177',
    '33178' => 'f33178',
    '33179' => 'f33179',
    '33180' => 'f33180',
    '33187' => 'f33187',
    '33188' => 'f33188',
    '33189' => 'f33189',
    '33190' => 'f33190',
    '33197' => 'f33197',
    '33198' => 'f33198',
    '33199' => 'f33199',
    '33200' => 'f33200',
    '33211' => 'f33211',
    '33212' => 'f33212',
    '33213' => 'f33213',
    '33214' => 'f33214',
    '33221' => 'f33221',
    '33222' => 'f33222',
    '33223' => 'f33223',
    '33224' => 'f33224',
    '33231' => 'f33231',
    '33232' => 'f33232',
    '33233' => 'f33233',
    '33234' => 'f33234',
    '33241' => 'f33241',
    '33242' => 'f33242',
    '33243' => 'f33243',
    '33244' => 'f33244',
    '33251' => 'f33251',
    '33252' => 'f33252',
    '33253' => 'f33253',
    '33254' => 'f33254',
    '33261' => 'f33261',
    '33262' => 'f33262',
    '33263' => 'f33263',
    '33264' => 'f33264',
    '33271' => 'f33271',
    '33272' => 'f33272',
    '33273' => 'f33273',
    '33274' => 'f33274',
    '33281' => 'f33281',
    '33282' => 'f33282',
    '33283' => 'f33283',
    '33284' => 'f33284',
    '33291' => 'f33291',
    '33292' => 'f33292',
    '33293' => 'f33293',
    '33294' => 'f33294',
    '33301' => 'f33301',
    '33302' => 'f33302',
    '33303' => 'f33303',
    '33304' => 'f33304',
    '33483' => 'f33483',
    '33485' => 'f33485',
    '33486' => 'f33486',
    '33487' => 'f33487',
    '33491' => 'f33491',
    '33493' => 'f33493',
    '33494' => 'f33494',
    '33495' => 'f33495',
    '33499' => 'f33499',
    '33501' => 'f33501',
    '33502' => 'f33502',
    '33503' => 'f33503',
    '33720' => 'f33720',
    '33721' => 'f33721',
    '33722' => 'f33722',
    '33723' => 'f33723',
    '33730' => 'f33730',
    '33731' => 'f33731',
    '33732' => 'f33732',
    '33733' => 'f33733',
    '33740' => 'f33740',
    '33741' => 'f33741',
    '33742' => 'f33742',
    '33743' => 'f33743',
    '33750' => 'f33750',
    '33751' => 'f33751',
    '33752' => 'f33752',
    '33753' => 'f33753',
    '33760' => 'f33760',
    '33761' => 'f33761',
    '33762' => 'f33762',
    '33763' => 'f33763',
    '33770' => 'f33770',
    '33771' => 'f33771',
    '33772' => 'f33772',
    '33773' => 'f33773',
    '33810' => 'f33810',
    '33811' => 'f33811',
    '33812' => 'f33812',
    '33813' => 'f33813',
    '33820' => 'f33820',
    '33821' => 'f33821',
    '33822' => 'f33822',
    '33823' => 'f33823',
    '33830' => 'f33830',
    '33831' => 'f33831',
    '33832' => 'f33832',
    '33833' => 'f33833',
    '33840' => 'f33840',
    '33841' => 'f33841',
    '33842' => 'f33842',
    '33843' => 'f33843',
    '33850' => 'f33850',
    '33851' => 'f33851',
    '33852' => 'f33852',
    '33853' => 'f33853',
    '33860' => 'f33860',
    '33861' => 'f33861',
    '33862' => 'f33862',
    '33863' => 'f33863',
    '33875' => 'f33875',
    '33876' => 'f33876',
    '33877' => 'f33877',
    '33878' => 'f33878',
    '33885' => 'f33885',
    '33886' => 'f33886',
    '33887' => 'f33887',
    '33888' => 'f33888',
    '33895' => 'f33895',
    '33896' => 'f33896',
    '33897' => 'f33897',
    '33898' => 'f33898',
    '33905' => 'f33905',
    '33906' => 'f33906',
    '33907' => 'f33907',
    '33908' => 'f33908',
    '33915' => 'f33915',
    '33916' => 'f33916',
    '33917' => 'f33917',
    '33918' => 'f33918',
    '33925' => 'f33925',
    '33926' => 'f33926',
    '33927' => 'f33927',
    '33928' => 'f33928',
    '33940' => 'f33940',
    '33941' => 'f33941',
    '33942' => 'f33942',
    '33943' => 'f33943',
    '33950' => 'f33950',
    '33951' => 'f33951',
    '33952' => 'f33952',
    '33953' => 'f33953',
    '33960' => 'f33960',
    '33961' => 'f33961',
    '33962' => 'f33962',
    '33963' => 'f33963',
    '33970' => 'f33970',
    '33971' => 'f33971',
    '33972' => 'f33972',
    '33973' => 'f33973',
    '33980' => 'f33980',
    '33981' => 'f33981',
    '33982' => 'f33982',
    '33983' => 'f33983',
    '33995' => 'f33995',
    '33996' => 'f33996',
    '33997' => 'f33997',
    '33998' => 'f33998',
    '34005' => 'f34005',
    '34006' => 'f34006',
    '34007' => 'f34007',
    '34008' => 'f34008',
    '34015' => 'f34015',
    '34016' => 'f34016',
    '34017' => 'f34017',
    '34018' => 'f34018',
    '34030' => 'f34030',
    '34031' => 'f34031',
    '34032' => 'f34032',
    '34033' => 'f34033',
    '34040' => 'f34040',
    '34041' => 'f34041',
    '34042' => 'f34042',
    '34043' => 'f34043',
    '34050' => 'f34050',
    '34051' => 'f34051',
    '34052' => 'f34052',
    '34053' => 'f34053',
    '34064' => 'f34064',
    '34065' => 'f34065',
    '34066' => 'f34066',
    '34067' => 'f34067',
    '34074' => 'f34074',
    '34075' => 'f34075',
    '34076' => 'f34076',
    '34077' => 'f34077',
    '34084' => 'f34084',
    '34085' => 'f34085',
    '34086' => 'f34086',
    '34087' => 'f34087',
    '34094' => 'f34094',
    '34095' => 'f34095',
    '34096' => 'f34096',
    '34097' => 'f34097',
    '34108' => 'f34108',
    '34109' => 'f34109',
    '34110' => 'f34110',
    '34111' => 'f34111',
    '34118' => 'f34118',
    '34119' => 'f34119',
    '34120' => 'f34120',
    '34121' => 'f34121',
    '34128' => 'f34128',
    '34129' => 'f34129',
    '34130' => 'f34130',
    '34131' => 'f34131',
    '34138' => 'f34138',
    '34139' => 'f34139',
    '34140' => 'f34140',
    '34141' => 'f34141',
    '34148' => 'f34148',
    '34149' => 'f34149',
    '34150' => 'f34150',
    '34151' => 'f34151',
    '34158' => 'f34158',
    '34159' => 'f34159',
    '34160' => 'f34160',
    '34161' => 'f34161',
    '34168' => 'f34168',
    '34169' => 'f34169',
    '34170' => 'f34170',
    '34171' => 'f34171',
    '34178' => 'f34178',
    '34179' => 'f34179',
    '34180' => 'f34180',
    '34181' => 'f34181',
    '34192' => 'f34192',
    '34193' => 'f34193',
    '34194' => 'f34194',
    '34195' => 'f34195',
    '34202' => 'f34202',
    '34203' => 'f34203',
    '34204' => 'f34204',
    '34205' => 'f34205',
    '34212' => 'f34212',
    '34213' => 'f34213',
    '34214' => 'f34214',
    '34215' => 'f34215',
    '34222' => 'f34222',
    '34223' => 'f34223',
    '34224' => 'f34224',
    '34225' => 'f34225',
    '34232' => 'f34232',
    '34233' => 'f34233',
    '34234' => 'f34234',
    '34235' => 'f34235',
    '34246' => 'f34246',
    '34247' => 'f34247',
    '34248' => 'f34248',
    '34249' => 'f34249',
    '34256' => 'f34256',
    '34257' => 'f34257',
    '34258' => 'f34258',
    '34259' => 'f34259',
    '34271' => 'f34271',
    '34272' => 'f34272',
    '34273' => 'f34273',
    '34274' => 'f34274',
    '34281' => 'f34281',
    '34282' => 'f34282',
    '34283' => 'f34283',
    '34284' => 'f34284',
    '34291' => 'f34291',
    '34292' => 'f34292',
    '34293' => 'f34293',
    '34294' => 'f34294',
    '34301' => 'f34301',
    '34302' => 'f34302',
    '34303' => 'f34303',
    '34304' => 'f34304',
    '34316' => 'f34316',
    '34317' => 'f34317',
    '34318' => 'f34318',
    '34319' => 'f34319',
    '34326' => 'f34326',
    '34327' => 'f34327',
    '34328' => 'f34328',
    '34329' => 'f34329',
    '34336' => 'f34336',
    '34337' => 'f34337',
    '34338' => 'f34338',
    '34339' => 'f34339',
    '34346' => 'f34346',
    '34347' => 'f34347',
    '34348' => 'f34348',
    '34349' => 'f34349',
    '34361' => 'f34361',
    '34362' => 'f34362',
    '34363' => 'f34363',
    '34364' => 'f34364',
    '34371' => 'f34371',
    '34372' => 'f34372',
    '34373' => 'f34373',
    '34374' => 'f34374',
    '34381' => 'f34381',
    '34382' => 'f34382',
    '34383' => 'f34383',
    '34384' => 'f34384',
    '34396' => 'f34396',
    '34397' => 'f34397',
    '34398' => 'f34398',
    '34399' => 'f34399',
    '34406' => 'f34406',
    '34407' => 'f34407',
    '34408' => 'f34408',
    '34409' => 'f34409',
    '34416' => 'f34416',
    '34417' => 'f34417',
    '34418' => 'f34418',
    '34419' => 'f34419',
    '34426' => 'f34426',
    '34427' => 'f34427',
    '34428' => 'f34428',
    '34429' => 'f34429',
    '34436' => 'f34436',
    '34437' => 'f34437',
    '34438' => 'f34438',
    '34439' => 'f34439',
    '34451' => 'f34451',
    '34452' => 'f34452',
    '34453' => 'f34453',
    '34454' => 'f34454',
    '34461' => 'f34461',
    '34462' => 'f34462',
    '34463' => 'f34463',
    '34464' => 'f34464',
    '34471' => 'f34471',
    '34472' => 'f34472',
    '34473' => 'f34473',
    '34474' => 'f34474',
    '34481' => 'f34481',
    '34482' => 'f34482',
    '34483' => 'f34483',
    '34484' => 'f34484',
    '34496' => 'f34496',
    '34497' => 'f34497',
    '34498' => 'f34498',
    '34499' => 'f34499',
    '34506' => 'f34506',
    '34507' => 'f34507',
    '34508' => 'f34508',
    '34509' => 'f34509',
    '34516' => 'f34516',
    '34517' => 'f34517',
    '34518' => 'f34518',
    '34519' => 'f34519',
    '34526' => 'f34526',
    '34527' => 'f34527',
    '34528' => 'f34528',
    '34529' => 'f34529',
    '34542' => 'f34542',
    '34543' => 'f34543',
    '34544' => 'f34544',
    '34545' => 'f34545',
    '34552' => 'f34552',
    '34553' => 'f34553',
    '34554' => 'f34554',
    '34555' => 'f34555',
    '34562' => 'f34562',
    '34563' => 'f34563',
    '34564' => 'f34564',
    '34565' => 'f34565',
    '34572' => 'f34572',
    '34573' => 'f34573',
    '34574' => 'f34574',
    '34575' => 'f34575',
    '34588' => 'f34588',
    '34589' => 'f34589',
    '34590' => 'f34590',
    '34591' => 'f34591',
    '34598' => 'f34598',
    '34599' => 'f34599',
    '34600' => 'f34600',
    '34601' => 'f34601',
    '34608' => 'f34608',
    '34609' => 'f34609',
    '34610' => 'f34610',
    '34611' => 'f34611',
    '34618' => 'f34618',
    '34619' => 'f34619',
    '34620' => 'f34620',
    '34621' => 'f34621',
    '34633' => 'f34633',
    '34634' => 'f34634',
    '34635' => 'f34635',
    '34636' => 'f34636',
    '34643' => 'f34643',
    '34644' => 'f34644',
    '34645' => 'f34645',
    '34646' => 'f34646',
    '34653' => 'f34653',
    '34654' => 'f34654',
    '34655' => 'f34655',
    '34656' => 'f34656',
    '34663' => 'f34663',
    '34664' => 'f34664',
    '34665' => 'f34665',
    '34666' => 'f34666',
    '34673' => 'f34673',
    '34674' => 'f34674',
    '34675' => 'f34675',
    '34676' => 'f34676',
    '34688' => 'f34688',
    '34689' => 'f34689',
    '34690' => 'f34690',
    '34691' => 'f34691',
    '34698' => 'f34698',
    '34699' => 'f34699',
    '34700' => 'f34700',
    '34701' => 'f34701',
    '34708' => 'f34708',
    '34709' => 'f34709',
    '34710' => 'f34710',
    '34711' => 'f34711',
    '34718' => 'f34718',
    '34719' => 'f34719',
    '34720' => 'f34720',
    '34721' => 'f34721',
    '34733' => 'f34733',
    '34734' => 'f34734',
    '34735' => 'f34735',
    '34736' => 'f34736',
    '34743' => 'f34743',
    '34744' => 'f34744',
    '34745' => 'f34745',
    '34746' => 'f34746',
    '34753' => 'f34753',
    '34754' => 'f34754',
    '34755' => 'f34755',
    '34756' => 'f34756',
    '34763' => 'f34763',
    '34764' => 'f34764',
    '34765' => 'f34765',
    '34766' => 'f34766',
    '34778' => 'f34778',
    '34779' => 'f34779',
    '34780' => 'f34780',
    '34781' => 'f34781',
    '34788' => 'f34788',
    '34789' => 'f34789',
    '34790' => 'f34790',
    '34791' => 'f34791',
    '34798' => 'f34798',
    '34799' => 'f34799',
    '34800' => 'f34800',
    '34801' => 'f34801',
    '34808' => 'f34808',
    '34809' => 'f34809',
    '34810' => 'f34810',
    '34811' => 'f34811',
    '34822' => 'f34822',
    '34823' => 'f34823',
    '34824' => 'f34824',
    '34825' => 'f34825',
    '34832' => 'f34832',
    '34833' => 'f34833',
    '34834' => 'f34834',
    '34835' => 'f34835',
    '34842' => 'f34842',
    '34843' => 'f34843',
    '34844' => 'f34844',
    '34845' => 'f34845',
    '34852' => 'f34852',
    '34853' => 'f34853',
    '34854' => 'f34854',
    '34855' => 'f34855',
    '34862' => 'f34862',
    '34863' => 'f34863',
    '34864' => 'f34864',
    '34865' => 'f34865',
    '34872' => 'f34872',
    '34873' => 'f34873',
    '34874' => 'f34874',
    '34875' => 'f34875',
    '34882' => 'f34882',
    '34883' => 'f34883',
    '34884' => 'f34884',
    '34885' => 'f34885',
    '34892' => 'f34892',
    '34893' => 'f34893',
    '34894' => 'f34894',
    '34895' => 'f34895',
    '34906' => 'f34906',
    '34907' => 'f34907',
    '34908' => 'f34908',
    '34909' => 'f34909',
    '34916' => 'f34916',
    '34917' => 'f34917',
    '34918' => 'f34918',
    '34919' => 'f34919',
    '34926' => 'f34926',
    '34927' => 'f34927',
    '34928' => 'f34928',
    '34929' => 'f34929',
    '34936' => 'f34936',
    '34937' => 'f34937',
    '34938' => 'f34938',
    '34939' => 'f34939',
    '34950' => 'f34950',
    '34951' => 'f34951',
    '34952' => 'f34952',
    '34953' => 'f34953',
    '34960' => 'f34960',
    '34961' => 'f34961',
    '34962' => 'f34962',
    '34963' => 'f34963',
    '34970' => 'f34970',
    '34971' => 'f34971',
    '34972' => 'f34972',
    '34973' => 'f34973',
    '34980' => 'f34980',
    '34981' => 'f34981',
    '34982' => 'f34982',
    '34983' => 'f34983',
    '34990' => 'f34990',
    '34991' => 'f34991',
    '34992' => 'f34992',
    '34993' => 'f34993',
    '35000' => 'f35000',
    '35001' => 'f35001',
    '35002' => 'f35002',
    '35003' => 'f35003',
    '35010' => 'f35010',
    '35011' => 'f35011',
    '35012' => 'f35012',
    '35013' => 'f35013',
    '35020' => 'f35020',
    '35021' => 'f35021',
    '35022' => 'f35022',
    '35023' => 'f35023',
    '35166' => 'f35166',
    '35168' => 'f35168',
    '35169' => 'f35169',
    '35170' => 'f35170',
    '35174' => 'f35174',
    '35176' => 'f35176',
    '35177' => 'f35177',
    '35178' => 'f35178',
    '35198' => 'f35198',
    '35200' => 'f35200',
    '35201' => 'f35201',
    '35202' => 'f35202',
    '35206' => 'f35206',
    '35208' => 'f35208',
    '35209' => 'f35209',
    '35210' => 'f35210',
    '35214' => 'f35214',
    '35216' => 'f35216',
    '35217' => 'f35217',
    '35218' => 'f35218',
    '35222' => 'f35222',
    '35224' => 'f35224',
    '35225' => 'f35225',
    '35226' => 'f35226',
    '35234' => 'f35234',
    '35236' => 'f35236',
    '35237' => 'f35237',
    '35238' => 'f35238',
    '35242' => 'f35242',
    '35244' => 'f35244',
    '35245' => 'f35245',
    '35246' => 'f35246',
    '35250' => 'f35250',
    '35252' => 'f35252',
    '35253' => 'f35253',
    '35254' => 'f35254',
    '35275' => 'f35275',
    '35276' => 'f35276',
    '35277' => 'f35277',
    '35278' => 'f35278',
    '35285' => 'f35285',
    '35286' => 'f35286',
    '35287' => 'f35287',
    '35288' => 'f35288',
    '35295' => 'f35295',
    '35296' => 'f35296',
    '35297' => 'f35297',
    '35298' => 'f35298',
    '35305' => 'f35305',
    '35306' => 'f35306',
    '35307' => 'f35307',
    '35308' => 'f35308',
    '35315' => 'f35315',
    '35316' => 'f35316',
    '35317' => 'f35317',
    '35318' => 'f35318',
    '35329' => 'f35329',
    '35330' => 'f35330',
    '35331' => 'f35331',
    '35332' => 'f35332',
    '35339' => 'f35339',
    '35340' => 'f35340',
    '35341' => 'f35341',
    '35342' => 'f35342',
    '35349' => 'f35349',
    '35350' => 'f35350',
    '35351' => 'f35351',
    '35352' => 'f35352',
    '35359' => 'f35359',
    '35360' => 'f35360',
    '35361' => 'f35361',
    '35362' => 'f35362',
    '35369' => 'f35369',
    '35370' => 'f35370',
    '35371' => 'f35371',
    '35372' => 'f35372',
    '35379' => 'f35379',
    '35380' => 'f35380',
    '35381' => 'f35381',
    '35382' => 'f35382',
    '35962' => 'f35962',
    '35964' => 'f35964',
    '35965' => 'f35965',
    '35966' => 'f35966',
    '35974' => 'f35974',
    '35976' => 'f35976',
    '35977' => 'f35977',
    '35978' => 'f35978',
    '36234' => 'f36234',
    '36236' => 'f36236',
    '36237' => 'f36237',
    '36238' => 'f36238',
    '36242' => 'f36242',
    '36244' => 'f36244',
    '36245' => 'f36245',
    '36246' => 'f36246',
    '36266' => 'f36266',
    '36268' => 'f36268',
    '36269' => 'f36269',
    '36270' => 'f36270',
    '36274' => 'f36274',
    '36276' => 'f36276',
    '36277' => 'f36277',
    '36278' => 'f36278',
    '36282' => 'f36282',
    '36284' => 'f36284',
    '36285' => 'f36285',
    '36286' => 'f36286',
    '36294' => 'f36294',
    '36296' => 'f36296',
    '36297' => 'f36297',
    '36298' => 'f36298',
    '36302' => 'f36302',
    '36304' => 'f36304',
    '36305' => 'f36305',
    '36306' => 'f36306',
    '36310' => 'f36310',
    '36312' => 'f36312',
    '36313' => 'f36313',
    '36314' => 'f36314',
    '36323' => 'f36323',
    '36325' => 'f36325',
    '36326' => 'f36326',
    '36327' => 'f36327',
    '36335' => 'f36335',
    '36337' => 'f36337',
    '36338' => 'f36338',
    '36339' => 'f36339',
    '37154' => 'f37154',
    '37156' => 'f37156',
    '37157' => 'f37157',
    '37158' => 'f37158',
    '37162' => 'f37162',
    '37164' => 'f37164',
    '37165' => 'f37165',
    '37166' => 'f37166',
    '37170' => 'f37170',
    '37172' => 'f37172',
    '37173' => 'f37173',
    '37174' => 'f37174',
    '37269' => 'f37269',
    '37271' => 'f37271',
    '37272' => 'f37272',
    '37273' => 'f37273',
    '37313' => 'f37313',
    '37314' => 'f37314',
    '37315' => 'f37315',
    '37316' => 'f37316',
    '37323' => 'f37323',
    '37324' => 'f37324',
    '37325' => 'f37325',
    '37326' => 'f37326',
    '37333' => 'f37333',
    '37334' => 'f37334',
    '37335' => 'f37335',
    '37336' => 'f37336',
    '37343' => 'f37343',
    '37344' => 'f37344',
    '37345' => 'f37345',
    '37346' => 'f37346',
    '37353' => 'f37353',
    '37354' => 'f37354',
    '37355' => 'f37355',
    '37356' => 'f37356',
    '37363' => 'f37363',
    '37364' => 'f37364',
    '37365' => 'f37365',
    '37366' => 'f37366',
    '37383' => 'f37383',
    '37384' => 'f37384',
    '37385' => 'f37385',
    '37386' => 'f37386',
    '37393' => 'f37393',
    '37394' => 'f37394',
    '37395' => 'f37395',
    '37396' => 'f37396',
    '37403' => 'f37403',
    '37404' => 'f37404',
    '37405' => 'f37405',
    '37406' => 'f37406',
    '37413' => 'f37413',
    '37414' => 'f37414',
    '37415' => 'f37415',
    '37416' => 'f37416',
    '37423' => 'f37423',
    '37424' => 'f37424',
    '37425' => 'f37425',
    '37426' => 'f37426',
    '37443' => 'f37443',
    '37444' => 'f37444',
    '37445' => 'f37445',
    '37446' => 'f37446',
    '37453' => 'f37453',
    '37454' => 'f37454',
    '37455' => 'f37455',
    '37456' => 'f37456',
    '37463' => 'f37463',
    '37464' => 'f37464',
    '37465' => 'f37465',
    '37466' => 'f37466',
    '37473' => 'f37473',
    '37474' => 'f37474',
    '37475' => 'f37475',
    '37476' => 'f37476',
    '37485' => 'f37485',
    '37486' => 'f37486',
    '37487' => 'f37487',
    '37488' => 'f37488',
    '37495' => 'f37495',
    '37496' => 'f37496',
    '37497' => 'f37497',
    '37498' => 'f37498',
    '37505' => 'f37505',
    '37506' => 'f37506',
    '37507' => 'f37507',
    '37508' => 'f37508',
    '37532' => 'f37532',
    '37533' => 'f37533',
    '37534' => 'f37534',
    '37535' => 'f37535',
    '37543' => 'f37543',
    '37544' => 'f37544',
    '37545' => 'f37545',
    '37546' => 'f37546',
    '37553' => 'f37553',
    '37554' => 'f37554',
    '37555' => 'f37555',
    '37556' => 'f37556',
    '37564' => 'f37564',
    '37566' => 'f37566',
    '37567' => 'f37567',
    '37568' => 'f37568',
    '37572' => 'f37572',
    '37574' => 'f37574',
    '37575' => 'f37575',
    '37576' => 'f37576',
    '37580' => 'f37580',
    '37582' => 'f37582',
    '37583' => 'f37583',
    '37584' => 'f37584',
    '37600' => 'f37600',
    '37602' => 'f37602',
    '37603' => 'f37603',
    '37604' => 'f37604',
    '37610' => 'f37610',
    '37612' => 'f37612',
    '37613' => 'f37613',
    '37614' => 'f37614',
    '37771' => 'f37771',
    '37773' => 'f37773',
    '37774' => 'f37774',
    '37775' => 'f37775',
    '37779' => 'f37779',
    '37781' => 'f37781',
    '37782' => 'f37782',
    '37783' => 'f37783',
    '38022' => 'f38022',
    '38032' => 'f38032',
    '38044' => 'f38044',
    '38054' => 'f38054',
    '38064' => 'f38064',
    '38086' => 'f38086',
    '38096' => 'f38096',
    '38106' => 'f38106',
    '38128' => 'f38128',
    '38138' => 'f38138',
    '38148' => 'f38148',
    '38158' => 'f38158',
    '38311' => 'f38311',
    '38313' => 'f38313',
    '38314' => 'f38314',
    '38315' => 'f38315',
    '38349' => 'f38349',
    '38351' => 'f38351',
    '38352' => 'f38352',
    '38353' => 'f38353',
    '38357' => 'f38357',
    '38359' => 'f38359',
    '38360' => 'f38360',
    '38361' => 'f38361',
    '38408' => 'f38408',
    '38409' => 'f38409',
    '38410' => 'f38410',
    '38411' => 'f38411',
    '38438' => 'f38438',
    '38440' => 'f38440',
    '38441' => 'f38441',
    '38442' => 'f38442',
    '38451' => 'f38451',
    '38453' => 'f38453',
    '38454' => 'f38454',
    '38455' => 'f38455',
    '38779' => 'f38779',
    '38788' => 'f38788',
    '38797' => 'f38797',
    '38806' => 'f38806',
    '38815' => 'f38815',
    '38829' => 'f38829',
    '38838' => 'f38838',
    '38847' => 'f38847',
    '38856' => 'f38856',
    '38909' => 'f38909',
    '39032' => 'f39032',
    '39034' => 'f39034',
    '39035' => 'f39035',
    '39036' => 'f39036',
    '39040' => 'f39040',
    '39042' => 'f39042',
    '39043' => 'f39043',
    '39044' => 'f39044',
    '39240' => 'f39240',
    '39242' => 'f39242',
    '39243' => 'f39243',
    '39244' => 'f39244',
    '39421' => 'f39421',
    '39423' => 'f39423',
    '39424' => 'f39424',
    '39425' => 'f39425',
    '39429' => 'f39429',
    '39431' => 'f39431',
    '39432' => 'f39432',
    '39433' => 'f39433',
    '39437' => 'f39437',
    '39439' => 'f39439',
    '39440' => 'f39440',
    '39441' => 'f39441',
    '39445' => 'f39445',
    '39447' => 'f39447',
    '39448' => 'f39448',
    '39449' => 'f39449',
    '39453' => 'f39453',
    '39455' => 'f39455',
    '39456' => 'f39456',
    '39457' => 'f39457',
    '39464' => 'f39464',
    '39466' => 'f39466',
    '39467' => 'f39467',
    '39468' => 'f39468',
    '39472' => 'f39472',
    '39474' => 'f39474',
    '39475' => 'f39475',
    '39476' => 'f39476',
    '39480' => 'f39480',
    '39482' => 'f39482',
    '39483' => 'f39483',
    '39484' => 'f39484',
    '39488' => 'f39488',
    '39490' => 'f39490',
    '39491' => 'f39491',
    '39492' => 'f39492',
    '39498' => 'f39498',
    '39500' => 'f39500',
    '39501' => 'f39501',
    '39502' => 'f39502',
    '39506' => 'f39506',
    '39508' => 'f39508',
    '39509' => 'f39509',
    '39510' => 'f39510',
    '39514' => 'f39514',
    '39516' => 'f39516',
    '39517' => 'f39517',
    '39518' => 'f39518',
    '39525' => 'f39525',
    '39527' => 'f39527',
    '39528' => 'f39528',
    '39529' => 'f39529',
    '39533' => 'f39533',
    '39535' => 'f39535',
    '39536' => 'f39536',
    '39537' => 'f39537',
    '39541' => 'f39541',
    '39543' => 'f39543',
    '39544' => 'f39544',
    '39545' => 'f39545',
    '39549' => 'f39549',
    '39551' => 'f39551',
    '39552' => 'f39552',
    '39553' => 'f39553',
    '39557' => 'f39557',
    '39559' => 'f39559',
    '39560' => 'f39560',
    '39561' => 'f39561',
    '39565' => 'f39565',
    '39567' => 'f39567',
    '39568' => 'f39568',
    '39569' => 'f39569',
    '39575' => 'f39575',
    '39577' => 'f39577',
    '39578' => 'f39578',
    '39579' => 'f39579',
    '40092' => 'f40092',
    '40094' => 'f40094',
    '40095' => 'f40095',
    '40096' => 'f40096',
    '40100' => 'f40100',
    '40102' => 'f40102',
    '40103' => 'f40103',
    '40104' => 'f40104',
    '40108' => 'f40108',
    '40110' => 'f40110',
    '40111' => 'f40111',
    '40112' => 'f40112',
    '40116' => 'f40116',
    '40118' => 'f40118',
    '40119' => 'f40119',
    '40120' => 'f40120',
    '40124' => 'f40124',
    '40126' => 'f40126',
    '40127' => 'f40127',
    '40128' => 'f40128',
    '40441' => 'f40441',
    '40443' => 'f40443',
    '40444' => 'f40444',
    '40445' => 'f40445',
    '40449' => 'f40449',
    '40451' => 'f40451',
    '40452' => 'f40452',
    '40453' => 'f40453',
    '40457' => 'f40457',
    '40459' => 'f40459',
    '40460' => 'f40460',
    '40461' => 'f40461',
    '40547' => 'f40547',
    '40549' => 'f40549',
    '40550' => 'f40550',
    '40551' => 'f40551',
    '40555' => 'f40555',
    '40557' => 'f40557',
    '40558' => 'f40558',
    '40559' => 'f40559',
    '40563' => 'f40563',
    '40565' => 'f40565',
    '40566' => 'f40566',
    '40567' => 'f40567',
    '40574' => 'f40574',
    '40576' => 'f40576',
    '40577' => 'f40577',
    '40578' => 'f40578',
    '40582' => 'f40582',
    '40583' => 'f40583',
    '40584' => 'f40584',
    '40585' => 'f40585',
    '40586' => 'f40586',
    '40587' => 'f40587',
    '40591' => 'f40591',
    '40593' => 'f40593',
    '40594' => 'f40594',
    '40595' => 'f40595',
    '40967' => 'f40967',
    '40969' => 'f40969',
    '40970' => 'f40970',
    '40971' => 'f40971',
    '40975' => 'f40975',
    '40978' => 'f40978',
    '40979' => 'f40979',
    '40980' => 'f40980',
    '40984' => 'f40984',
    '40986' => 'f40986',
    '40987' => 'f40987',
    '40988' => 'f40988',
    '41016' => 'f41016',
    '41018' => 'f41018',
    '41019' => 'f41019',
    '41020' => 'f41020',
    '41024' => 'f41024',
    '41026' => 'f41026',
    '41027' => 'f41027',
    '41028' => 'f41028',
    '41032' => 'f41032',
    '41034' => 'f41034',
    '41035' => 'f41035',
    '41036' => 'f41036',
    '41049' => 'f41049',
    '41050' => 'f41050',
    '41051' => 'f41051',
    '41052' => 'f41052',
    '41059' => 'f41059',
    '41060' => 'f41060',
    '41061' => 'f41061',
    '41062' => 'f41062',
    '41069' => 'f41069',
    '41070' => 'f41070',
    '41071' => 'f41071',
    '41072' => 'f41072',
    '41079' => 'f41079',
    '41080' => 'f41080',
    '41081' => 'f41081',
    '41082' => 'f41082',
    '41089' => 'f41089',
    '41090' => 'f41090',
    '41091' => 'f41091',
    '41092' => 'f41092',
    '41099' => 'f41099',
    '41100' => 'f41100',
    '41101' => 'f41101',
    '41102' => 'f41102',
    '41109' => 'f41109',
    '41110' => 'f41110',
    '41111' => 'f41111',
    '41112' => 'f41112',
    '41119' => 'f41119',
    '41120' => 'f41120',
    '41121' => 'f41121',
    '41122' => 'f41122',
    '41199' => 'f41199',
    '41201' => 'f41201',
    '41202' => 'f41202',
    '41203' => 'f41203',
    '41207' => 'f41207',
    '41209' => 'f41209',
    '41210' => 'f41210',
    '41211' => 'f41211',
    '41215' => 'f41215',
    '41217' => 'f41217',
    '41218' => 'f41218',
    '41219' => 'f41219',
    '41289' => 'f41289',
    '41290' => 'f41290',
    '41291' => 'f41291',
    '41292' => 'f41292',
    '41299' => 'f41299',
    '41300' => 'f41300',
    '41301' => 'f41301',
    '41302' => 'f41302',
    '41309' => 'f41309',
    '41310' => 'f41310',
    '41311' => 'f41311',
    '41312' => 'f41312',
    '41319' => 'f41319',
    '41320' => 'f41320',
    '41321' => 'f41321',
    '41322' => 'f41322',
    '41329' => 'f41329',
    '41330' => 'f41330',
    '41331' => 'f41331',
    '41332' => 'f41332',
    '41339' => 'f41339',
    '41340' => 'f41340',
    '41341' => 'f41341',
    '41342' => 'f41342',
    '41349' => 'f41349',
    '41350' => 'f41350',
    '41351' => 'f41351',
    '41352' => 'f41352',
    '41359' => 'f41359',
    '41360' => 'f41360',
    '41361' => 'f41361',
    '41362' => 'f41362',
    '41443' => 'f41443',
    '41444' => 'f41444',
    '41445' => 'f41445',
    '41446' => 'f41446',
    '41453' => 'f41453',
    '41454' => 'f41454',
    '41455' => 'f41455',
    '41456' => 'f41456',
    '41463' => 'f41463',
    '41464' => 'f41464',
    '41465' => 'f41465',
    '41466' => 'f41466',
    '41473' => 'f41473',
    '41474' => 'f41474',
    '41475' => 'f41475',
    '41476' => 'f41476',
    '41483' => 'f41483',
    '41484' => 'f41484',
    '41485' => 'f41485',
    '41486' => 'f41486',
    '41493' => 'f41493',
    '41494' => 'f41494',
    '41495' => 'f41495',
    '41496' => 'f41496',
    '41503' => 'f41503',
    '41504' => 'f41504',
    '41505' => 'f41505',
    '41506' => 'f41506',
    '41513' => 'f41513',
    '41514' => 'f41514',
    '41515' => 'f41515',
    '41516' => 'f41516',
    '43132' => 'f43132',
    '43133' => 'f43133',
    '43134' => 'f43134',
    '43135' => 'f43135',
    '43142' => 'f43142',
    '43143' => 'f43143',
    '43144' => 'f43144',
    '43145' => 'f43145',
    '43152' => 'f43152',
    '43153' => 'f43153',
    '43154' => 'f43154',
    '43155' => 'f43155',
    '43162' => 'f43162',
    '43163' => 'f43163',
    '43164' => 'f43164',
    '43165' => 'f43165',
    '43172' => 'f43172',
    '43173' => 'f43173',
    '43174' => 'f43174',
    '43175' => 'f43175',
    '43294' => 'f43294',
    '43295' => 'f43295',
    '43296' => 'f43296',
    '43297' => 'f43297',
    '43304' => 'f43304',
    '43305' => 'f43305',
    '43306' => 'f43306',
    '43307' => 'f43307',
    '43314' => 'f43314',
    '43315' => 'f43315',
    '43316' => 'f43316',
    '43317' => 'f43317',
    '43324' => 'f43324',
    '43325' => 'f43325',
    '43326' => 'f43326',
    '43327' => 'f43327',
    '43334' => 'f43334',
    '43335' => 'f43335',
    '43336' => 'f43336',
    '43337' => 'f43337',
    '43549' => 'f43549',
    '43551' => 'f43551',
    '43552' => 'f43552',
    '43553' => 'f43553',
    '43557' => 'f43557',
    '43559' => 'f43559',
    '43560' => 'f43560',
    '43561' => 'f43561',
    '43567' => 'f43567',
    '43569' => 'f43569',
    '43570' => 'f43570',
    '43571' => 'f43571',
    '43575' => 'f43575',
    '43577' => 'f43577',
    '43578' => 'f43578',
    '43579' => 'f43579',
    '43583' => 'f43583',
    '43585' => 'f43585',
    '43586' => 'f43586',
    '43587' => 'f43587',
    '43591' => 'f43591',
    '43593' => 'f43593',
    '43594' => 'f43594',
    '43595' => 'f43595',
    '43599' => 'f43599',
    '43601' => 'f43601',
    '43602' => 'f43602',
    '43603' => 'f43603',
    '43607' => 'f43607',
    '43609' => 'f43609',
    '43610' => 'f43610',
    '43611' => 'f43611',
    '43615' => 'f43615',
    '43617' => 'f43617',
    '43618' => 'f43618',
    '43619' => 'f43619',
    '43935' => 'f43935',
    '43937' => 'f43937',
    '43938' => 'f43938',
    '43939' => 'f43939',
    '43943' => 'f43943',
    '43945' => 'f43945',
    '43946' => 'f43946',
    '43947' => 'f43947',
    '44035' => 'f44035',
    '44037' => 'f44037',
    '44038' => 'f44038',
    '44039' => 'f44039',
    '44043' => 'f44043',
    '44045' => 'f44045',
    '44046' => 'f44046',
    '44047' => 'f44047',
    '44051' => 'f44051',
    '44053' => 'f44053',
    '44054' => 'f44054',
    '44055' => 'f44055',
    '44131' => 'f44131',
    '44133' => 'f44133',
    '44134' => 'f44134',
    '44135' => 'f44135',
    '44139' => 'f44139',
    '44141' => 'f44141',
    '44142' => 'f44142',
    '44143' => 'f44143',
    '44217' => 'f44217',
    '44219' => 'f44219',
    '44220' => 'f44220',
    '44221' => 'f44221',
    '44225' => 'f44225',
    '44227' => 'f44227',
    '44228' => 'f44228',
    '44229' => 'f44229',
    '44564' => 'f44564',
    '44566' => 'f44566',
    '44567' => 'f44567',
    '44568' => 'f44568',
    '44728' => 'f44728',
    '44730' => 'f44730',
    '44731' => 'f44731',
    '44732' => 'f44732',
    '44733' => 'f44733',
    '44738' => 'f44738',
    '44740' => 'f44740',
    '44741' => 'f44741',
    '44742' => 'f44742',
    '44743' => 'f44743',
    '44748' => 'f44748',
    '44750' => 'f44750',
    '44751' => 'f44751',
    '44752' => 'f44752',
    '44753' => 'f44753',
    '44760' => 'f44760',
    '44761' => 'f44761',
    '44762' => 'f44762',
    '44763' => 'f44763',
    '45019' => 'f45019',
    '45021' => 'f45021',
    '45022' => 'f45022',
    '45023' => 'f45023',
    '45027' => 'f45027',
    '45029' => 'f45029',
    '45030' => 'f45030',
    '45031' => 'f45031',
    '45035' => 'f45035',
    '45037' => 'f45037',
    '45038' => 'f45038',
    '45039' => 'f45039',
    '45043' => 'f45043',
    '45045' => 'f45045',
    '45046' => 'f45046',
    '45047' => 'f45047',
    '45051' => 'f45051',
    '45053' => 'f45053',
    '45054' => 'f45054',
    '45055' => 'f45055',
    '45154' => 'f45154',
    '45156' => 'f45156',
    '45157' => 'f45157',
    '45158' => 'f45158',
    '45162' => 'f45162',
    '45164' => 'f45164',
    '45165' => 'f45165',
    '45166' => 'f45166',
    '45170' => 'f45170',
    '45172' => 'f45172',
    '45173' => 'f45173',
    '45174' => 'f45174',
    '45178' => 'f45178',
    '45180' => 'f45180',
    '45181' => 'f45181',
    '45182' => 'f45182',
    '45186' => 'f45186',
    '45188' => 'f45188',
    '45189' => 'f45189',
    '45190' => 'f45190',
    '45211' => 'f45211',
    '45213' => 'f45213',
    '45214' => 'f45214',
    '45215' => 'f45215',
    '45266' => 'f45266',
    '45267' => 'f45267',
    '45268' => 'f45268',
    '45272' => 'f45272',
    '45273' => 'f45273',
    '45274' => 'f45274',
    '45278' => 'f45278',
    '45279' => 'f45279',
    '45280' => 'f45280',
    '45284' => 'f45284',
    '45286' => 'f45286',
    '45287' => 'f45287',
    '45288' => 'f45288',
    '45374' => 'f45374',
    '45376' => 'f45376',
    '45377' => 'f45377',
    '45378' => 'f45378',
    '45382' => 'f45382',
    '45384' => 'f45384',
    '45385' => 'f45385',
    '45386' => 'f45386',
    '45390' => 'f45390',
    '45392' => 'f45392',
    '45393' => 'f45393',
    '45394' => 'f45394',
    '45398' => 'f45398',
    '45400' => 'f45400',
    '45401' => 'f45401',
    '45402' => 'f45402',
    '45506' => 'f45506',
    '45508' => 'f45508',
    '45509' => 'f45509',
    '45510' => 'f45510',
    '45514' => 'f45514',
    '45516' => 'f45516',
    '45517' => 'f45517',
    '45518' => 'f45518',
    '45522' => 'f45522',
    '45524' => 'f45524',
    '45525' => 'f45525',
    '45526' => 'f45526',
    '45530' => 'f45530',
    '45532' => 'f45532',
    '45533' => 'f45533',
    '45534' => 'f45534',
    '45538' => 'f45538',
    '45540' => 'f45540',
    '45541' => 'f45541',
    '45542' => 'f45542',
    '45647' => 'f45647',
    '45649' => 'f45649',
    '45650' => 'f45650',
    '45651' => 'f45651',
    '45655' => 'f45655',
    '45657' => 'f45657',
    '45658' => 'f45658',
    '45659' => 'f45659',
    '46020' => 'f46020',
    '46022' => 'f46022',
    '46023' => 'f46023',
    '46024' => 'f46024',
    '46028' => 'f46028',
    '46030' => 'f46030',
    '46031' => 'f46031',
    '46032' => 'f46032',
    '46036' => 'f46036',
    '46038' => 'f46038',
    '46039' => 'f46039',
    '46040' => 'f46040',
    '46044' => 'f46044',
    '46046' => 'f46046',
    '46047' => 'f46047',
    '46048' => 'f46048',
    '77845' => 'f77845',
    '77846' => 'f77846',
    '77847' => 'f77847',
    '77848' => 'f77848',
    '77958' => 'f77958',
    '77959' => 'f77959',
    '77960' => 'f77960',
    '77973' => 'f77973',
    '77974' => 'f77974',
    '77975' => 'f77975',
    '77979' => 'f77979',
    '77990' => 'f77990',
    '78016' => 'f78016',
    '78017' => 'f78017',
    '78019' => 'f78019',
    '78020' => 'f78020',
    '78021' => 'f78021',
    '78022' => 'f78022',
    '78040' => 'f78040',
    '78041' => 'f78041',
    '78044' => 'f78044',
    '78045' => 'f78045',
    '78046' => 'f78046',
    '78074' => 'f78074',
    '78075' => 'f78075',
    '78076' => 'f78076',
    '78077' => 'f78077',
    '78081' => 'f78081',
    '78090' => 'f78090',
    '78091' => 'f78091',
    '78093' => 'f78093',
    '78094' => 'f78094',
    '78095' => 'f78095',
    '78096' => 'f78096',
    '78097' => 'f78097',
    '78110' => 'f78110',
    '78113' => 'f78113',
    '78114' => 'f78114',
    '78119' => 'f78119',
    '78120' => 'f78120',
    '78121' => 'f78121',
    '78122' => 'f78122',
    '78123' => 'f78123',
    '78124' => 'f78124',
    '78182' => 'f78182',
    '78185' => 'f78185',
    '78189' => 'f78189',
    '78190' => 'f78190',
    '78243' => 'f78243',
    '78255' => 'f78255',
    '78263' => 'f78263',
    '78292' => 'f78292',
    '78297' => 'f78297',
    '78298' => 'f78298',
    '78319' => 'f78319',
    '78320' => 'f78320',
    '78321' => 'f78321',
    '78338' => 'f78338',
    '78344' => 'f78344',
    '78346' => 'f78346',
    '78370' => 'f78370',
    '78371' => 'f78371',
    '78382' => 'f78382',
    '78383' => 'f78383',
    '78384' => 'f78384',
    '78385' => 'f78385',
    '78413' => 'f78413',
    '78414' => 'f78414',
    '78415' => 'f78415',
    '78416' => 'f78416',
    '78417' => 'f78417',
    '78418' => 'f78418',
    '78419' => 'f78419',
    '78420' => 'f78420',
    '78421' => 'f78421',
    '78422' => 'f78422',
    '78423' => 'f78423',
    '78424' => 'f78424',
    '78426' => 'f78426',
    '78427' => 'f78427',
    '78428' => 'f78428',
    '78434' => 'f78434',
    '78435' => 'f78435',
    '78440' => 'f78440',
    '78441' => 'f78441',
    '78442' => 'f78442',
    '78448' => 'f78448',
    '78452' => 'f78452',
    '78453' => 'f78453',
    '78454' => 'f78454',
    '78483' => 'f78483',
    '78484' => 'f78484',
    '78485' => 'f78485',
    '78486' => 'f78486',
    '78490' => 'f78490',
    '78491' => 'f78491',
    '78492' => 'f78492',
    '78493' => 'f78493',
    '78523' => 'f78523',
    '78524' => 'f78524',
    '78529' => 'f78529',
    '78556' => 'f78556',
    '78573' => 'f78573',
    '78574' => 'f78574',
    '78603' => 'f78603',
    '78609' => 'f78609',
    '78610' => 'f78610',
    '78627' => 'f78627',
    '78628' => 'f78628',
    '78630' => 'f78630',
    '78632' => 'f78632',
    '78635' => 'f78635',
    '78636' => 'f78636',
    '78647' => 'f78647',
    '78654' => 'f78654',
    '78663' => 'f78663',
    '78672' => 'f78672',
    '78679' => 'f78679',
    '78694' => 'f78694',
    '78699' => 'f78699',
    '78702' => 'f78702',
    '78711' => 'f78711',
    '78721' => 'f78721',
    '78722' => 'f78722',
    '78752' => 'f78752',
    '78753' => 'f78753',
    '78765' => 'f78765',
    '78766' => 'f78766',
    '78767' => 'f78767',
    '78768' => 'f78768',
    '78779' => 'f78779',
    '78780' => 'f78780',
    '78788' => 'f78788',
    '78789' => 'f78789',
    '78790' => 'f78790',
    '78798' => 'f78798',
    '78799' => 'f78799',
    '78800' => 'f78800',
    '78801' => 'f78801',
    '78807' => 'f78807',
    '78817' => 'f78817',
    '78818' => 'f78818',
    '78819' => 'f78819',
    '78821' => 'f78821',
    '78822' => 'f78822',
    '78823' => 'f78823',
    '78824' => 'f78824',
    '78835' => 'f78835',
    '78839' => 'f78839',
    '78840' => 'f78840',
    '78842' => 'f78842',
    '78843' => 'f78843',
    '78844' => 'f78844',
    '78845' => 'f78845',
    '78846' => 'f78846',
    '78847' => 'f78847',
    '78848' => 'f78848',
    '78849' => 'f78849',
    '78850' => 'f78850',
    '78851' => 'f78851',
    '78852' => 'f78852',
    '78853' => 'f78853',
    '78854' => 'f78854',
    '78855' => 'f78855',
    '78856' => 'f78856',
    '78858' => 'f78858',
    '78859' => 'f78859',
    '78860' => 'f78860',
    '78865' => 'f78865',
    '78866' => 'f78866',
    '78867' => 'f78867',
    '78868' => 'f78868',
    '78879' => 'f78879',
    '78885' => 'f78885',
    '78886' => 'f78886',
    '78887' => 'f78887',
    '78888' => 'f78888',
    '78889' => 'f78889',
    '78890' => 'f78890',
    '78891' => 'f78891',
    '78892' => 'f78892',
    '78893' => 'f78893',
    '78894' => 'f78894',
    '78895' => 'f78895',
    '78896' => 'f78896',
    '78897' => 'f78897',
    '78898' => 'f78898',
    '78899' => 'f78899',
    '78900' => 'f78900',
    '78901' => 'f78901',
    '78902' => 'f78902',
    '78916' => 'f78916',
    '78917' => 'f78917',
    '78918' => 'f78918',
    '78923' => 'f78923',
    '78924' => 'f78924',
    '78925' => 'f78925',
    '78931' => 'f78931',
    '78932' => 'f78932',
    '78933' => 'f78933',
    '78934' => 'f78934',
    '78939' => 'f78939',
    '79039' => 'f79039',
    '79041' => 'f79041',
    '79042' => 'f79042',
    '79048' => 'f79048',
    '79049' => 'f79049',
    '79052' => 'f79052',
    '79059' => 'f79059',
    '79079' => 'f79079',
    '79100' => 'f79100',
    '79101' => 'f79101',
    '79102' => 'f79102',
    '79103' => 'f79103',
    '79105' => 'f79105',
    '79107' => 'f79107',
    '79142' => 'f79142',
    '79143' => 'f79143',
    '79147' => 'f79147',
    '79148' => 'f79148',
    '79154' => 'f79154',
    '79155' => 'f79155',
    '79156' => 'f79156',
    '79157' => 'f79157',
    '79195' => 'f79195',
    '79197' => 'f79197',
    '79202' => 'f79202',
    '79228' => 'f79228',
    '79231' => 'f79231',
    '79232' => 'f79232',
    '79233' => 'f79233',
    '79246' => 'f79246',
    '79258' => 'f79258',
    '79259' => 'f79259',
    '79260' => 'f79260',
    '79264' => 'f79264',
    '79266' => 'f79266',
    '79290' => 'f79290',
    '79361' => 'f79361',
    '79362' => 'f79362',
    '79363' => 'f79363',
    '79364' => 'f79364',
    '79365' => 'f79365',
    '79366' => 'f79366',
    '79367' => 'f79367',
    '79368' => 'f79368',
    '79373' => 'f79373',
    '79374' => 'f79374',
    '79375' => 'f79375',
    '79380' => 'f79380',
    '79381' => 'f79381',
    '79394' => 'f79394',
    '79418' => 'f79418',
    '79424' => 'f79424',
    '79427' => 'f79427',
    '79452' => 'f79452',
    '79453' => 'f79453',
    '79454' => 'f79454',
    '79455' => 'f79455',
    '79456' => 'f79456',
    '79457' => 'f79457',
    '79464' => 'f79464',
    '79465' => 'f79465',
    '79466' => 'f79466',
    '79472' => 'f79472',
    '79473' => 'f79473',
    '79474' => 'f79474',
    '79485' => 'f79485',
    '79486' => 'f79486',
    '79491' => 'f79491',
    '79542' => 'f79542',
    '79564' => 'f79564',
    '79586' => 'f79586',
    '79587' => 'f79587',
    '79601' => 'f79601',
    '79609' => 'f79609',
    '79624' => 'f79624',
    '79625' => 'f79625',
    '79626' => 'f79626',
    '79646' => 'f79646',
    '79647' => 'f79647',
    '79648' => 'f79648',
    '79677' => 'f79677',
    '79679' => 'f79679',
    '79680' => 'f79680',
    '79681' => 'f79681',
    '79682' => 'f79682',
    '79683' => 'f79683',
    '79684' => 'f79684',
    '79685' => 'f79685',
    '79686' => 'f79686',
    '79687' => 'f79687',
    '79699' => 'f79699',
    '79700' => 'f79700',
    '79701' => 'f79701',
    '79730' => 'f79730',
    '79733' => 'f79733',
    '79734' => 'f79734',
    '999445' => 'f999445',
    '999446' => 'f999446',
    '999447' => 'f999447',
    '999448' => 'f999448',
    '999558' => 'f999558',
    '999559' => 'f999559',
    '999560' => 'f999560',
    '999573' => 'f999573',
    '999574' => 'f999574',
    '999575' => 'f999575',
    '999579' => 'f999579',
    '999590' => 'f999590',
    '999616' => 'f999616',
    '999617' => 'f999617',
    '999619' => 'f999619',
    '999620' => 'f999620',
    '999621' => 'f999621',
    '999622' => 'f999622',
    '999640' => 'f999640',
    '999641' => 'f999641',
    '999644' => 'f999644',
    '999645' => 'f999645',
    '999646' => 'f999646',
    '999674' => 'f999674',
    '999675' => 'f999675',
    '999676' => 'f999676',
    '999677' => 'f999677',
    '999681' => 'f999681',
    '999690' => 'f999690',
    '999691' => 'f999691',
    '999693' => 'f999693',
    '999694' => 'f999694',
    '999695' => 'f999695',
    '999696' => 'f999696',
    '999697' => 'f999697',
    '999710' => 'f999710',
    '999713' => 'f999713',
    '999714' => 'f999714',
    '999719' => 'f999719',
    '999720' => 'f999720',
    '999721' => 'f999721',
    '999722' => 'f999722',
    '999723' => 'f999723',
    '999724' => 'f999724',
    '999782' => 'f999782',
    '999785' => 'f999785',
    '999789' => 'f999789',
    '999790' => 'f999790',
    '999843' => 'f999843',
    '999855' => 'f999855',
    '999863' => 'f999863',
    '999892' => 'f999892',
    '999897' => 'f999897',
    '999898' => 'f999898',
    '999919' => 'f999919',
    '999920' => 'f999920',
    '999921' => 'f999921',
    '999938' => 'f999938',
    '999944' => 'f999944',
    '999946' => 'f999946',
    '999970' => 'f999970',
    '999971' => 'f999971',
    '999982' => 'f999982',
    '999983' => 'f999983',
    '999984' => 'f999984',
    '999985' => 'f999985',
    '1000013' => 'f1000013',
    '1000014' => 'f1000014',
    '1000015' => 'f1000015',
    '1000016' => 'f1000016',
    '1000017' => 'f1000017',
    '1000018' => 'f1000018',
    '1000019' => 'f1000019',
    '1000020' => 'f1000020',
    '1000021' => 'f1000021',
    '1000022' => 'f1000022',
    '1000023' => 'f1000023',
    '1000024' => 'f1000024',
    '1000026' => 'f1000026',
    '1000027' => 'f1000027',
    '1000028' => 'f1000028',
    '1000034' => 'f1000034',
    '1000035' => 'f1000035',
    '1000040' => 'f1000040',
    '1000041' => 'f1000041',
    '1000042' => 'f1000042',
    '1000048' => 'f1000048',
    '1000052' => 'f1000052',
    '1000053' => 'f1000053',
    '1000054' => 'f1000054',
    '1000083' => 'f1000083',
    '1000084' => 'f1000084',
    '1000085' => 'f1000085',
    '1000086' => 'f1000086',
    '1000090' => 'f1000090',
    '1000091' => 'f1000091',
    '1000092' => 'f1000092',
    '1000093' => 'f1000093',
    '1000123' => 'f1000123',
    '1000124' => 'f1000124',
    '1000129' => 'f1000129',
    '1000156' => 'f1000156',
    '1000173' => 'f1000173',
    '1000174' => 'f1000174',
    '1000203' => 'f1000203',
    '1000209' => 'f1000209',
    '1000210' => 'f1000210',
    '1000227' => 'f1000227',
    '1000228' => 'f1000228',
    '1000230' => 'f1000230',
    '1000232' => 'f1000232',
    '1000235' => 'f1000235',
    '1000236' => 'f1000236',
    '1000247' => 'f1000247',
    '1000254' => 'f1000254',
    '1000263' => 'f1000263',
    '1000272' => 'f1000272',
    '1000279' => 'f1000279',
    '1000294' => 'f1000294',
    '1000299' => 'f1000299',
    '1000302' => 'f1000302',
    '1000311' => 'f1000311',
    '1000321' => 'f1000321',
    '1000322' => 'f1000322',
    '1000352' => 'f1000352',
    '1000353' => 'f1000353',
    '1000365' => 'f1000365',
    '1000366' => 'f1000366',
    '1000367' => 'f1000367',
    '1000368' => 'f1000368',
    '1000379' => 'f1000379',
    '1000380' => 'f1000380',
    '1000388' => 'f1000388',
    '1000389' => 'f1000389',
    '1000390' => 'f1000390',
    '1000398' => 'f1000398',
    '1000399' => 'f1000399',
    '1000400' => 'f1000400',
    '1000401' => 'f1000401',
    '1000407' => 'f1000407',
    '1000417' => 'f1000417',
    '1000418' => 'f1000418',
    '1000419' => 'f1000419',
    '1000421' => 'f1000421',
    '1000422' => 'f1000422',
    '1000423' => 'f1000423',
    '1000424' => 'f1000424',
    '1000435' => 'f1000435',
    '1000439' => 'f1000439',
    '1000440' => 'f1000440',
    '1000442' => 'f1000442',
    '1000443' => 'f1000443',
    '1000444' => 'f1000444',
    '1000445' => 'f1000445',
    '1000446' => 'f1000446',
    '1000447' => 'f1000447',
    '1000448' => 'f1000448',
    '1000449' => 'f1000449',
    '1000450' => 'f1000450',
    '1000451' => 'f1000451',
    '1000452' => 'f1000452',
    '1000453' => 'f1000453',
    '1000454' => 'f1000454',
    '1000455' => 'f1000455',
    '1000456' => 'f1000456',
    '1000458' => 'f1000458',
    '1000459' => 'f1000459',
    '1000460' => 'f1000460',
    '1000465' => 'f1000465',
    '1000466' => 'f1000466',
    '1000467' => 'f1000467',
    '1000468' => 'f1000468',
    '1000479' => 'f1000479',
    '1000485' => 'f1000485',
    '1000486' => 'f1000486',
    '1000487' => 'f1000487',
    '1000488' => 'f1000488',
    '1000489' => 'f1000489',
    '1000490' => 'f1000490',
    '1000491' => 'f1000491',
    '1000492' => 'f1000492',
    '1000493' => 'f1000493',
    '1000494' => 'f1000494',
    '1000495' => 'f1000495',
    '1000496' => 'f1000496',
    '1000497' => 'f1000497',
    '1000498' => 'f1000498',
    '1000499' => 'f1000499',
    '1000500' => 'f1000500',
    '1000501' => 'f1000501',
    '1000502' => 'f1000502',
    '1000516' => 'f1000516',
    '1000517' => 'f1000517',
    '1000518' => 'f1000518',
    '1000523' => 'f1000523',
    '1000524' => 'f1000524',
    '1000525' => 'f1000525',
    '1000531' => 'f1000531',
    '1000532' => 'f1000532',
    '1000533' => 'f1000533',
    '1000534' => 'f1000534',
    '1000539' => 'f1000539',
    '1000639' => 'f1000639',
    '1000641' => 'f1000641',
    '1000642' => 'f1000642',
    '1000648' => 'f1000648',
    '1000649' => 'f1000649',
    '1000652' => 'f1000652',
    '1000659' => 'f1000659',
    '1000679' => 'f1000679',
    '1000705' => 'f1000705',
    '1000707' => 'f1000707',
    '1000743' => 'f1000743',
    '1000747' => 'f1000747',
    '1000748' => 'f1000748',
    '1000754' => 'f1000754',
    '1000755' => 'f1000755',
    '1000756' => 'f1000756',
    '1000757' => 'f1000757',
    '1000795' => 'f1000795',
    '1000797' => 'f1000797',
    '1000802' => 'f1000802',
    '1000828' => 'f1000828',
    '1000831' => 'f1000831',
    '1000832' => 'f1000832',
    '1000833' => 'f1000833',
    '1000846' => 'f1000846',
    '1000858' => 'f1000858',
    '1000859' => 'f1000859',
    '1000860' => 'f1000860',
    '1000864' => 'f1000864',
    '1000866' => 'f1000866',
    '1000890' => 'f1000890',
    '1000961' => 'f1000961',
    '1000962' => 'f1000962',
    '1000963' => 'f1000963',
    '1000964' => 'f1000964',
    '1000965' => 'f1000965',
    '1000966' => 'f1000966',
    '1000967' => 'f1000967',
    '1000968' => 'f1000968',
    '1000973' => 'f1000973',
    '1000974' => 'f1000974',
    '1000975' => 'f1000975',
    '1000980' => 'f1000980',
    '1000981' => 'f1000981',
    '1000994' => 'f1000994',
    '1001018' => 'f1001018',
    '1001024' => 'f1001024',
    '1001027' => 'f1001027',
    '1001052' => 'f1001052',
    '1001053' => 'f1001053',
    '1001054' => 'f1001054',
    '1001055' => 'f1001055',
    '1001056' => 'f1001056',
    '1001057' => 'f1001057',
    '1001064' => 'f1001064',
    '1001065' => 'f1001065',
    '1001066' => 'f1001066',
    '1001072' => 'f1001072',
    '1001073' => 'f1001073',
    '1001074' => 'f1001074',
    '1001085' => 'f1001085',
    '1001086' => 'f1001086',
    '1001091' => 'f1001091',
    '1001142' => 'f1001142',
    '1001164' => 'f1001164',
    '1001186' => 'f1001186',
    '1001187' => 'f1001187',
    '1001201' => 'f1001201',
    '1001209' => 'f1001209',
    '1001224' => 'f1001224',
    '1001225' => 'f1001225',
    '1001226' => 'f1001226',
    '1001246' => 'f1001246',
    '1001247' => 'f1001247',
    '1001248' => 'f1001248',
    '1001277' => 'f1001277',
    '1001279' => 'f1001279',
    '1001280' => 'f1001280',
    '1001281' => 'f1001281',
    '1001282' => 'f1001282',
    '1001283' => 'f1001283',
    '1001284' => 'f1001284',
    '1001285' => 'f1001285',
    '1001286' => 'f1001286',
    '1001287' => 'f1001287',
    '1001299' => 'f1001299',
    '1001300' => 'f1001300',
    '1001301' => 'f1001301',
    '1001330' => 'f1001330',
    '1001333' => 'f1001333',
    '1001334' => 'f1001334',
    '4194528' => 'e4194528',
    '4194529' => 'e4194529',
    '4194530' => 'e4194530',
    '4194531' => 'e4194531',
    '4194532' => 'e4194532',
    '4194533' => 'e4194533',
    '4194534' => 'e4194534',
    '4194535' => 'e4194535',
    '4194536' => 'e4194536',
    '4194537' => 'e4194537',
    '4194538' => 'e4194538',
    '4194539' => 'e4194539',
    '4194540' => 'e4194540',
    '4194541' => 'e4194541',
    '4194542' => 'e4194542',
    '4194543' => 'e4194543',
    '4194544' => 'e4194544',
    '4194545' => 'e4194545',
    '4194546' => 'e4194546',
    '4194547' => 'e4194547',
    '4194548' => 'e4194548',
    '4194549' => 'e4194549',
    '4194550' => 'e4194550',
    '4194551' => 'e4194551',
    '4194552' => 'e4194552',
    '4194553' => 'e4194553',
    '4194554' => 'e4194554',
    '4194555' => 'e4194555',
    '4194556' => 'e4194556',
    '4194557' => 'e4194557',
    '4194558' => 'e4194558',
    '4194559' => 'e4194559',
    '4194560' => 'e4194560',
    '4194561' => 'e4194561',
    '4194562' => 'e4194562',
    '4194563' => 'e4194563',
    '4194564' => 'e4194564',
    '4194565' => 'e4194565',
    '4194566' => 'e4194566',
    '4194567' => 'e4194567',
    '4194568' => 'e4194568',
    '4194569' => 'e4194569',
    '4194570' => 'e4194570',
    '4194571' => 'e4194571',
    '4194572' => 'e4194572',
    '4194573' => 'e4194573',
    '4194574' => 'e4194574',
    '4194575' => 'e4194575',
    '4194576' => 'e4194576',
    '4194577' => 'e4194577',
    '4194578' => 'e4194578',
    '4194579' => 'e4194579',
    '4194580' => 'e4194580',
    '4194581' => 'e4194581',
    '4194582' => 'e4194582',
    '4194583' => 'e4194583',
    '4194584' => 'e4194584',
    '4194585' => 'e4194585',
    '4194586' => 'e4194586',
    '4194587' => 'e4194587',
    '4194591' => 'e4194591',
    '4194592' => 'e4194592',
    '4194593' => 'e4194593',
    '4194594' => 'e4194594',
    '4194595' => 'e4194595',
    '4194596' => 'e4194596',
    '4194597' => 'e4194597',
    '4194598' => 'e4194598',
    '4194599' => 'e4194599',
    '4194600' => 'e4194600',
    '4194601' => 'e4194601',
    '4194602' => 'e4194602',
    '4194603' => 'e4194603',
    '4194604' => 'e4194604',
    '4194605' => 'e4194605',
    '4194607' => 'e4194607',
    '4194608' => 'e4194608',
    '4194609' => 'e4194609',
    '4194610' => 'e4194610',
    '4194611' => 'e4194611',
    '4194612' => 'e4194612',
    '4194613' => 'e4194613',
    '4194614' => 'e4194614',
    '4194615' => 'e4194615',
    '4194616' => 'e4194616',
    '4194617' => 'e4194617',
    '4194620' => 'e4194620',
    '4194621' => 'e4194621',
    '4194622' => 'e4194622',
    '4194623' => 'e4194623',
    '4194624' => 'e4194624',
    '4194626' => 'e4194626',
    '4194627' => 'e4194627',
    '4194628' => 'e4194628',
    '4194629' => 'e4194629',
    '4194630' => 'e4194630',
    '4194631' => 'e4194631',
    '4194632' => 'e4194632',
    '4194652' => 'e4194652',
    '4194654' => 'e4194654',
    '4194655' => 'e4194655',
    '4194656' => 'e4194656',
    '4194657' => 'e4194657',
    '4194658' => 'e4194658',
    '4194659' => 'e4194659',
    '4194660' => 'e4194660',
    '4194661' => 'e4194661',
    '4194662' => 'e4194662',
    '4194663' => 'e4194663',
    '4194664' => 'e4194664',
    '4194665' => 'e4194665',
    '4194671' => 'e4194671',
    '4194672' => 'e4194672',
    '4194673' => 'e4194673',
    '4194674' => 'e4194674',
    '4194675' => 'e4194675',
    '4194676' => 'e4194676',
    '4194683' => 'e4194683',
    '4194684' => 'e4194684',
    '4194685' => 'e4194685',
    '4194686' => 'e4194686',
    '4194687' => 'e4194687',
    '4194688' => 'e4194688',
    '4194689' => 'e4194689',
    '4194693' => 'e4194693',
    '4194694' => 'e4194694',
    '4194695' => 'e4194695',
    '4194697' => 'e4194697',
    '4194698' => 'e4194698',
    '4194699' => 'e4194699',
    '4194700' => 'e4194700',
    '4194701' => 'e4194701',
    '4194702' => 'e4194702',
    '4194703' => 'e4194703',
    '4194704' => 'e4194704',
    '4194705' => 'e4194705',
    '4194706' => 'e4194706',
    '4194714' => 'e4194714',
    '4194715' => 'e4194715',
    '4194717' => 'e4194717',
    '4194718' => 'e4194718',
    '4194719' => 'e4194719',
    '4194720' => 'e4194720',
    '4194721' => 'e4194721',
    '4194722' => 'e4194722',
    '4194723' => 'e4194723',
    '4194724' => 'e4194724',
    '4194725' => 'e4194725',
    '4194726' => 'e4194726',
    '4194727' => 'e4194727',
    '4194728' => 'e4194728',
    '4194729' => 'e4194729',
    '4194730' => 'e4194730',
    '4194734' => 'e4194734',
    '4194736' => 'e4194736',
    '4194737' => 'e4194737',
    '4194738' => 'e4194738',
    '4194739' => 'e4194739',
    '4194740' => 'e4194740',
    '4194741' => 'e4194741',
    '4194744' => 'e4194744',
    '4194745' => 'e4194745',
    '4194746' => 'e4194746',
    '4194747' => 'e4194747',
    '4194748' => 'e4194748',
    '4194749' => 'e4194749',
    '4194750' => 'e4194750',
    '4194751' => 'e4194751',
    '4194752' => 'e4194752',
    '4194753' => 'e4194753',
    '4194754' => 'e4194754',
    '4194755' => 'e4194755',
    '4194763' => 'e4194763',
    '4194764' => 'e4194764',
    '4194765' => 'e4194765',
    '4194766' => 'e4194766',
    '4194767' => 'e4194767',
    '4194768' => 'e4194768',
    '4194769' => 'e4194769',
    '4194770' => 'e4194770',
    '4194771' => 'e4194771',
    '4194773' => 'e4194773',
    '4194774' => 'e4194774',
    '4194775' => 'e4194775',
    '4194776' => 'e4194776',
    '4194777' => 'e4194777',
    '4194778' => 'e4194778',
    '4194787' => 'e4194787',
    '4194788' => 'e4194788',
    '4194789' => 'e4194789',
    '4194790' => 'e4194790',
    '4194791' => 'e4194791',
    '4194792' => 'e4194792',
    '4194793' => 'e4194793',
    '4194794' => 'e4194794',
    '4194795' => 'e4194795',
    '4194796' => 'e4194796',
    '4194797' => 'e4194797',
    '4194798' => 'e4194798',
    '4194799' => 'e4194799',
    '4194800' => 'e4194800',
    '4194801' => 'e4194801',
    '4194802' => 'e4194802',
    '4194803' => 'e4194803',
    '4194804' => 'e4194804',
    '4194805' => 'e4194805',
    '4194806' => 'e4194806',
    '4194807' => 'e4194807',
    '4194812' => 'e4194812',
    '4194828' => 'e4194828',
    '4194830' => 'e4194830',
    '4194831' => 'e4194831',
    '4194832' => 'e4194832',
    '4194833' => 'e4194833',
    '4194834' => 'e4194834',
    '4194835' => 'e4194835',
    '4194836' => 'e4194836',
    '4194839' => 'e4194839',
    '4194840' => 'e4194840',
    '4194841' => 'e4194841',
    '4194842' => 'e4194842',
    '4194843' => 'e4194843',
    '4194844' => 'e4194844',
    '4194847' => 'e4194847',
    '4194848' => 'e4194848',
    '4194849' => 'e4194849',
    '4194855' => 'e4194855',
    '4194856' => 'e4194856',
    '4194859' => 'e4194859',
    '4194860' => 'e4194860',
    '4194861' => 'e4194861',
    '4194862' => 'e4194862',
    '4194863' => 'e4194863',
    '4194864' => 'e4194864',
    '4194865' => 'e4194865',
    '4194866' => 'e4194866',
    '4194867' => 'e4194867',
    '4194868' => 'e4194868',
    '4194869' => 'e4194869',
    '4194871' => 'e4194871',
    '4194876' => 'e4194876',
    '4194878' => 'e4194878',
    '4194879' => 'e4194879',
    '4194880' => 'e4194880',
    '4194881' => 'e4194881',
    '4194883' => 'e4194883',
    '4194884' => 'e4194884',
    '4194885' => 'e4194885',
    '4194886' => 'e4194886',
    '4194887' => 'e4194887',
    '4194888' => 'e4194888',
    '4194889' => 'e4194889',
    '4194890' => 'e4194890',
    '4194891' => 'e4194891',
    '4194892' => 'e4194892',
    '4194894' => 'e4194894',
    '4194895' => 'e4194895',
    '4194896' => 'e4194896',
    '4194897' => 'e4194897',
    '4194899' => 'e4194899',
    '4194900' => 'e4194900',
    '4194901' => 'e4194901',
    '4194902' => 'e4194902',
    '4194903' => 'e4194903',
    '4194904' => 'e4194904',
    '4194905' => 'e4194905',
    '4194906' => 'e4194906',
    '4194907' => 'e4194907',
    '4194908' => 'e4194908',
    '4194909' => 'e4194909',
    '4194910' => 'e4194910',
    '4194911' => 'e4194911',
    '4194918' => 'e4194918',
    '4194919' => 'e4194919',
    '4194920' => 'e4194920',
    '4194921' => 'e4194921',
    '4194922' => 'e4194922',
    '4194923' => 'e4194923',
    '4194924' => 'e4194924',
    '4194925' => 'e4194925',
    '4194926' => 'e4194926',
    '4194927' => 'e4194927',
    '4194928' => 'e4194928',
    '4194929' => 'e4194929',
    '4194930' => 'e4194930',
    '4194931' => 'e4194931',
    '4194932' => 'e4194932',
    '4194933' => 'e4194933',
    '4194934' => 'e4194934',
    '4194935' => 'e4194935',
    '4194936' => 'e4194936',
    '4194937' => 'e4194937',
    '4194938' => 'e4194938',
    '4194939' => 'e4194939',
    '4194940' => 'e4194940',
    '4194941' => 'e4194941',
    '4194942' => 'e4194942',
    '4194943' => 'e4194943',
    '4194944' => 'e4194944',
    '4194945' => 'e4194945',
    '4194946' => 'e4194946',
    '4194947' => 'e4194947',
    '4194948' => 'e4194948',
    '4194949' => 'e4194949',
    '4194950' => 'e4194950',
    '4194951' => 'e4194951',
    '4194952' => 'e4194952',
    '4194953' => 'e4194953',
    '4194954' => 'e4194954',
    '4194955' => 'e4194955',
    '4194956' => 'e4194956',
    '4194957' => 'e4194957',
    '4194958' => 'e4194958',
    '4194959' => 'e4194959',
    '4194960' => 'e4194960',
    '4194961' => 'e4194961',
    '4194962' => 'e4194962',
    '4194963' => 'e4194963',
    '4194964' => 'e4194964',
    '4194965' => 'e4194965',
    '4194966' => 'e4194966',
    '4194967' => 'e4194967',
    '4194968' => 'e4194968',
    '4194969' => 'e4194969',
    '4194970' => 'e4194970',
    '4194971' => 'e4194971',
    '4194972' => 'e4194972',
    '4194973' => 'e4194973',
    '4194974' => 'e4194974',
    '4194975' => 'e4194975',
    '4194976' => 'e4194976',
    '4194977' => 'e4194977',
    '4194978' => 'e4194978',
    '4194979' => 'e4194979',
    '4194980' => 'e4194980',
    '4194981' => 'e4194981',
    '4194982' => 'e4194982',
    '4194983' => 'e4194983',
    '4194984' => 'e4194984',
    '4194985' => 'e4194985',
    '4194986' => 'e4194986',
    '4194987' => 'e4194987',
    '4194988' => 'e4194988',
    '4194989' => 'e4194989',
    '4194990' => 'e4194990',
    '4194991' => 'e4194991',
    '4194992' => 'e4194992',
    '4194993' => 'e4194993',
    '4194994' => 'e4194994',
    '4194995' => 'e4194995',
    '4194996' => 'e4194996',
    '4194997' => 'e4194997',
    '4195000' => 'e4195000',
    '4195001' => 'e4195001',
    '4195002' => 'e4195002',
    '4195003' => 'e4195003',
    '4195004' => 'e4195004',
    '4195006' => 'e4195006',
    '4195007' => 'e4195007',
    '4195008' => 'e4195008',
    '4195009' => 'e4195009',
    '4195010' => 'e4195010',
    '4195011' => 'e4195011',
    '4195012' => 'e4195012',
    '4195013' => 'e4195013',
    '4195014' => 'e4195014',
    '4195015' => 'e4195015',
    '4195016' => 'e4195016',
    '4195017' => 'e4195017',
    '4195018' => 'e4195018',
    '4195019' => 'e4195019',
    '4195020' => 'e4195020',
    '4195021' => 'e4195021',
    '4195022' => 'e4195022',
    '4195023' => 'e4195023',
    '4195024' => 'e4195024',
    '4195025' => 'e4195025',
    '4195026' => 'e4195026',
    '4195027' => 'e4195027',
    '4195028' => 'e4195028',
    '4195029' => 'e4195029',
    '4195030' => 'e4195030',
    '4195031' => 'e4195031',
    '4195032' => 'e4195032',
    '4195033' => 'e4195033',
    '4195034' => 'e4195034',
    '4195036' => 'e4195036',
    '4195037' => 'e4195037',
    '4195038' => 'e4195038',
    '4195039' => 'e4195039',
    '4195040' => 'e4195040',
    '4195041' => 'e4195041',
    '4195042' => 'e4195042',
    '4195043' => 'e4195043',
    '4195044' => 'e4195044',
    '4195045' => 'e4195045',
    '4195046' => 'e4195046',
    '4195047' => 'e4195047',
    '4195048' => 'e4195048',
    '4195049' => 'e4195049',
    '4195050' => 'e4195050',
    '4195051' => 'e4195051',
    '4195052' => 'e4195052',
    '4195053' => 'e4195053',
    '4195054' => 'e4195054',
    '4195055' => 'e4195055',
    '4195056' => 'e4195056',
    '4195057' => 'e4195057',
    '4195058' => 'e4195058',
    '4195059' => 'e4195059',
    '4195060' => 'e4195060',
    '4195061' => 'e4195061',
    '4195064' => 'e4195064',
    '4195065' => 'e4195065',
    '4195066' => 'e4195066',
    '4195067' => 'e4195067',
    '4195068' => 'e4195068',
    '4195069' => 'e4195069',
    '4195071' => 'e4195071',
    '4195072' => 'e4195072',
    '4195073' => 'e4195073',
    '4195074' => 'e4195074',
    '4195075' => 'e4195075',
    '4195076' => 'e4195076',
    '4195077' => 'e4195077',
    '4195078' => 'e4195078',
    '4195080' => 'e4195080',
    '4195081' => 'e4195081',
    '4195082' => 'e4195082',
    '4195083' => 'e4195083',
    '4195084' => 'e4195084',
    '4195085' => 'e4195085',
    '4195086' => 'e4195086',
    '4195087' => 'e4195087',
    '4195088' => 'e4195088',
    '4195207' => 'e4195207',
    '4195208' => 'e4195208',
    '4195209' => 'e4195209',
    '4195213' => 'e4195213',
    '4195214' => 'e4195214',
    '4195215' => 'e4195215',
    '4195216' => 'e4195216',
    '4195217' => 'e4195217',
    '4195218' => 'e4195218',
    '4195220' => 'e4195220',
    '4195221' => 'e4195221',
    '4195222' => 'e4195222',
    '4195223' => 'e4195223',
    '4195224' => 'e4195224',
    '4195225' => 'e4195225',
    '4195226' => 'e4195226',
    '4195227' => 'e4195227',
    '4195228' => 'e4195228',
    '4195229' => 'e4195229',
    '4195230' => 'e4195230',
    '4195231' => 'e4195231',
    '4195232' => 'e4195232',
    '4195233' => 'e4195233',
    '4195234' => 'e4195234',
    '4195235' => 'e4195235',
    '4195236' => 'e4195236',
    '4195237' => 'e4195237',
    '4195238' => 'e4195238',
    '4195239' => 'e4195239',
    '4195242' => 'e4195242',
    '4195243' => 'e4195243',
    '4195244' => 'e4195244',
    '4195245' => 'e4195245',
    '4195246' => 'e4195246',
    '4195247' => 'e4195247',
    '4195248' => 'e4195248',
    '4195249' => 'e4195249',
    '4195250' => 'e4195250',
    '4195251' => 'e4195251',
    '4195252' => 'e4195252',
    '4195253' => 'e4195253',
    '4195254' => 'e4195254',
    '4195255' => 'e4195255',
    '4195256' => 'e4195256',
    '4195257' => 'e4195257',
    '4195258' => 'e4195258',
    '4195259' => 'e4195259',
    '4195260' => 'e4195260',
    '4195261' => 'e4195261',
    '4195262' => 'e4195262',
    '4195263' => 'e4195263',
    '4195264' => 'e4195264',
    '4195265' => 'e4195265',
    '4195266' => 'e4195266',
    '4195267' => 'e4195267',
    '4195268' => 'e4195268',
    '4195269' => 'e4195269',
    '4195270' => 'e4195270',
    '4195271' => 'e4195271',
    '4195272' => 'e4195272',
    '4195273' => 'e4195273',
    '4195274' => 'e4195274',
    '4195275' => 'e4195275',
    '4195276' => 'e4195276',
    '4195277' => 'e4195277',
    '4195278' => 'e4195278',
    '4195279' => 'e4195279',
    '4195281' => 'e4195281',
    '4195282' => 'e4195282',
    '4195283' => 'e4195283',
    '4195284' => 'e4195284',
    '4195285' => 'e4195285',
    '4195286' => 'e4195286',
    '4195287' => 'e4195287',
    '4195288' => 'e4195288',
    '4195289' => 'e4195289',
    '4195290' => 'e4195290',
    '4195291' => 'e4195291',
    '4195292' => 'e4195292',
    '4195293' => 'e4195293',
    '4195294' => 'e4195294',
    '4195295' => 'e4195295',
    '4195296' => 'e4195296',
    '4195297' => 'e4195297',
    '4195298' => 'e4195298',
    '4195299' => 'e4195299',
    '4195300' => 'e4195300',
    '4195301' => 'e4195301',
    '4195302' => 'e4195302',
    '4195303' => 'e4195303',
    '4195304' => 'e4195304',
    '4195305' => 'e4195305',
    '4195306' => 'e4195306',
    '4195307' => 'e4195307',
    '4195308' => 'e4195308',
    '4195309' => 'e4195309',
    '4195310' => 'e4195310',
    '4195311' => 'e4195311',
    '4195312' => 'e4195312',
    '4195313' => 'e4195313',
    '4195314' => 'e4195314',
    '4195315' => 'e4195315',
    '4195316' => 'e4195316',
    '4195317' => 'e4195317',
    '4195318' => 'e4195318',
    '4195319' => 'e4195319',
    '4195320' => 'e4195320',
    '4195321' => 'e4195321',
    '4195331' => 'e4195331',
    '4195332' => 'e4195332',
    '4195333' => 'e4195333',
    '4195334' => 'e4195334',
    '4195335' => 'e4195335',
    '4195336' => 'e4195336',
    '4195337' => 'e4195337',
    '4195338' => 'e4195338',
    '4195339' => 'e4195339',
    '4195340' => 'e4195340',
    '4195341' => 'e4195341',
    '4195342' => 'e4195342',
    '4195343' => 'e4195343',
    '4195344' => 'e4195344',
    '4195345' => 'e4195345',
    '4195346' => 'e4195346',
    '4195347' => 'e4195347',
    '4195348' => 'e4195348',
    '4195349' => 'e4195349',
    '4195350' => 'e4195350',
    '4195351' => 'e4195351',
    '4195352' => 'e4195352',
    '4195353' => 'e4195353',
    '4195354' => 'e4195354',
    '4195355' => 'e4195355',
    '4195356' => 'e4195356',
    '4195357' => 'e4195357',
    '4195358' => 'e4195358',
    '4195359' => 'e4195359',
    '4195360' => 'e4195360',
    '4195361' => 'e4195361',
    '4195362' => 'e4195362',
    '4195363' => 'e4195363',
    '4195364' => 'e4195364',
    '4195365' => 'e4195365',
    '4195366' => 'e4195366',
    '4195367' => 'e4195367',
    '4195368' => 'e4195368',
    '4195369' => 'e4195369',
    '4195370' => 'e4195370',
    '4195371' => 'e4195371',
    '4195372' => 'e4195372',
    '4195373' => 'e4195373',
    '4195374' => 'e4195374',
    '4195375' => 'e4195375',
    '4195376' => 'e4195376',
    '4195377' => 'e4195377',
    '4195378' => 'e4195378',
    '4195379' => 'e4195379',
    '4195380' => 'e4195380',
    '4195381' => 'e4195381',
    '4195382' => 'e4195382',
    '4195387' => 'e4195387',
    '4195388' => 'e4195388',
    '4195389' => 'e4195389',
    '4195390' => 'e4195390',
    '4195391' => 'e4195391',
    '4195392' => 'e4195392',
    '4195393' => 'e4195393',
    '4195394' => 'e4195394',
    '4195395' => 'e4195395',
    '4195396' => 'e4195396',
    '4195397' => 'e4195397',
    '4195398' => 'e4195398',
    '4195399' => 'e4195399',
    '4195400' => 'e4195400',
    '4195401' => 'e4195401',
    '4195402' => 'e4195402',
    '4195403' => 'e4195403',
    '4195404' => 'e4195404',
    '4195405' => 'e4195405',
    '4195406' => 'e4195406',
    '4195407' => 'e4195407',
    '4195408' => 'e4195408',
    '4195409' => 'e4195409',
    '4195410' => 'e4195410',
    '4195411' => 'e4195411',
    '4195412' => 'e4195412',
    '4195413' => 'e4195413',
    '4195414' => 'e4195414',
    '4195415' => 'e4195415',
    '4195416' => 'e4195416',
    '4195417' => 'e4195417',
    '4195418' => 'e4195418',
    '4195419' => 'e4195419',
    '4195460' => 'e4195460',
    '4195461' => 'e4195461',
    '4195462' => 'e4195462',
    '4195463' => 'e4195463',
    '4195464' => 'e4195464',
    '4195465' => 'e4195465',
    '4195466' => 'e4195466',
    '4195467' => 'e4195467',
    '4195468' => 'e4195468',
    '4195469' => 'e4195469',
    '4195470' => 'e4195470',
    '4195471' => 'e4195471',
    '4195472' => 'e4195472',
    '4195473' => 'e4195473',
    '4195474' => 'e4195474',
    '4195475' => 'e4195475',
    '4195476' => 'e4195476',
    '4195477' => 'e4195477',
    '4195478' => 'e4195478',
    '4195479' => 'e4195479',
    '4195480' => 'e4195480',
    '4195481' => 'e4195481',
    '4195482' => 'e4195482',
    '4195483' => 'e4195483',
    '4195484' => 'e4195484',
    '4195485' => 'e4195485',
    '4195486' => 'e4195486',
    '4195487' => 'e4195487',
    '4195488' => 'e4195488',
    '4195489' => 'e4195489',
    '4195490' => 'e4195490',
    '4195491' => 'e4195491',
    '4195492' => 'e4195492',
    '4195493' => 'e4195493',
    '4195494' => 'e4195494',
    '4195495' => 'e4195495',
    '4195496' => 'e4195496',
    '4195497' => 'e4195497',
    '4195498' => 'e4195498',
    '4195499' => 'e4195499',
    '4195500' => 'e4195500',
    '4195501' => 'e4195501',
    '4195502' => 'e4195502',
    '4195503' => 'e4195503',
    '4195504' => 'e4195504',
    '4195505' => 'e4195505',
    '4195506' => 'e4195506',
    '4195507' => 'e4195507',
    '4195508' => 'e4195508',
    '4195509' => 'e4195509',
    '4195510' => 'e4195510',
    '4195511' => 'e4195511',
    '4195512' => 'e4195512',
    '4195513' => 'e4195513',
    '4195514' => 'e4195514',
    '4195515' => 'e4195515',
    '4195516' => 'e4195516',
    '4195517' => 'e4195517',
    '4195518' => 'e4195518',
    '4195519' => 'e4195519',
    '4195520' => 'e4195520',
    '4195521' => 'e4195521',
    '4195522' => 'e4195522',
    '4195523' => 'e4195523',
    '4195524' => 'e4195524',
    '4195525' => 'e4195525',
    '4195526' => 'e4195526',
    '4195527' => 'e4195527',
    '4195528' => 'e4195528',
    '4195529' => 'e4195529',
    '4195530' => 'e4195530',
    '4195531' => 'e4195531',
    '4195532' => 'e4195532',
    '4195533' => 'e4195533',
    '4195534' => 'e4195534',
    '4195535' => 'e4195535',
    '4195536' => 'e4195536',
    '4195537' => 'e4195537',
    '4195538' => 'e4195538',
    '4195539' => 'e4195539',
    '4195540' => 'e4195540',
    '4195541' => 'e4195541',
    '4195542' => 'e4195542',
    '4195543' => 'e4195543',
    '4195544' => 'e4195544',
    '4195545' => 'e4195545',
    '4195546' => 'e4195546',
    '4195547' => 'e4195547',
    '4195548' => 'e4195548',
    '4195549' => 'e4195549',
    '4195550' => 'e4195550',
    '4195551' => 'e4195551',
    '4195552' => 'e4195552',
    '4195553' => 'e4195553',
    '4195554' => 'e4195554',
    '4195555' => 'e4195555',
    '4195556' => 'e4195556',
    '4195557' => 'e4195557',
    '4195558' => 'e4195558',
    '4195559' => 'e4195559',
    '4195560' => 'e4195560',
    '4195561' => 'e4195561',
    '4195562' => 'e4195562',
    '4195563' => 'e4195563',
    '4195564' => 'e4195564',
    '4195565' => 'e4195565',
    '4195566' => 'e4195566',
    '4195567' => 'e4195567',
    '4195568' => 'e4195568',
    '4195571' => 'e4195571',
    '4195572' => 'e4195572',
    '4195573' => 'e4195573',
    '4195574' => 'e4195574',
    '4195575' => 'e4195575',
    '4195576' => 'e4195576',
    '4195577' => 'e4195577',
    '4195578' => 'e4195578',
    '4195579' => 'e4195579',
    '4195580' => 'e4195580',
    '4195581' => 'e4195581',
    '4195582' => 'e4195582',
    '4195583' => 'e4195583',
    '4195584' => 'e4195584',
    '4195585' => 'e4195585',
    '4195586' => 'e4195586',
    '4195587' => 'e4195587',
    '4195588' => 'e4195588',
    '4195592' => 'e4195592',
    '4195593' => 'e4195593',
    '4195594' => 'e4195594',
    '4195595' => 'e4195595',
    '4195596' => 'e4195596',
    '4195597' => 'e4195597',
    '4195598' => 'e4195598',
    '4195599' => 'e4195599',
    '4195601' => 'e4195601',
    '4195602' => 'e4195602',
    '4195603' => 'e4195603',
    '4195604' => 'e4195604',
    '4195605' => 'e4195605',
    '4195606' => 'e4195606',
    '4195607' => 'e4195607',
    '4195615' => 'e4195615',
    '4195616' => 'e4195616',
    '4195617' => 'e4195617',
    '4195655' => 'e4195655',
    '4195656' => 'e4195656',
    '4195660' => 'e4195660',
    '4195661' => 'e4195661',
    '4195662' => 'e4195662',
    '4195663' => 'e4195663',
    '4195664' => 'e4195664',
    '4195665' => 'e4195665',
    '4195666' => 'e4195666',
    '4195667' => 'e4195667',
    '4195669' => 'e4195669',
    '4195670' => 'e4195670',
    '4195671' => 'e4195671',
    '4195672' => 'e4195672',
    '4195673' => 'e4195673',
    '4195674' => 'e4195674',
    '4195698' => 'e4195698',
    '4195699' => 'e4195699',
    '4195700' => 'e4195700',
    '4195701' => 'e4195701',
    '4195702' => 'e4195702',
    '4195703' => 'e4195703',
    '4195704' => 'e4195704',
    '4195705' => 'e4195705',
    '4195706' => 'e4195706',
    '4195707' => 'e4195707',
    '4195708' => 'e4195708',
    '4195709' => 'e4195709',
    '4195710' => 'e4195710',
    '4195711' => 'e4195711',
    '4195712' => 'e4195712',
    '4195713' => 'e4195713',
    '4195714' => 'e4195714',
    '4195715' => 'e4195715',
    '4195716' => 'e4195716',
    '4195718' => 'e4195718',
    '4195721' => 'e4195721',
    '4195730' => 'e4195730',
    '4195731' => 'e4195731',
    '4195732' => 'e4195732',
    '4195733' => 'e4195733',
    '4195734' => 'e4195734',
    '4195735' => 'e4195735',
    '4195736' => 'e4195736',
    '4195737' => 'e4195737',
    '4195738' => 'e4195738',
    '4195739' => 'e4195739',
    '4195740' => 'e4195740',
    '4195741' => 'e4195741',
    '4195742' => 'e4195742',
    '4195743' => 'e4195743',
    '4195744' => 'e4195744',
    '4195745' => 'e4195745',
    '4195746' => 'e4195746',
    '4195747' => 'e4195747',
    '4195748' => 'e4195748',
    '4195749' => 'e4195749',
    '4195750' => 'e4195750',
    '4195751' => 'e4195751',
    '4195752' => 'e4195752',
    '4195753' => 'e4195753',
    '4195754' => 'e4195754',
    '4195755' => 'e4195755',
    '4195756' => 'e4195756',
    '4195757' => 'e4195757',
    '4195758' => 'e4195758',
    '4195759' => 'e4195759',
    '4195760' => 'e4195760',
    '4195761' => 'e4195761',
    '4195762' => 'e4195762',
    '4195763' => 'e4195763',
    '4195764' => 'e4195764',
    '4195765' => 'e4195765',
    '4195766' => 'e4195766',
    '4195767' => 'e4195767',
    '4195768' => 'e4195768',
    '4195769' => 'e4195769',
    '4195770' => 'e4195770',
    '4195771' => 'e4195771',
    '4195772' => 'e4195772',
    '4195773' => 'e4195773',
    '4195774' => 'e4195774',
    '4195775' => 'e4195775',
    '4195776' => 'e4195776',
    '4195777' => 'e4195777',
    '4195778' => 'e4195778',
    '4195779' => 'e4195779',
    '4195786' => 'e4195786',
    '4195787' => 'e4195787',
    '4195788' => 'e4195788',
    '4195789' => 'e4195789',
    '4195790' => 'e4195790',
    '4195791' => 'e4195791',
    '4195792' => 'e4195792',
    '4195793' => 'e4195793',
    '4195794' => 'e4195794',
    '4195795' => 'e4195795',
    '4195796' => 'e4195796',
    '4195797' => 'e4195797',
    '4195798' => 'e4195798',
    '4195799' => 'e4195799',
    '4195800' => 'e4195800',
    '4195801' => 'e4195801',
    '4195802' => 'e4195802',
    '4195803' => 'e4195803',
    '4195804' => 'e4195804',
    '4195807' => 'e4195807',
    '4195808' => 'e4195808',
    '4195809' => 'e4195809',
    '4195810' => 'e4195810',
    '4195811' => 'e4195811',
    '4195812' => 'e4195812',
    '4195813' => 'e4195813',
    '4195814' => 'e4195814',
    '4195815' => 'e4195815',
    '4195818' => 'e4195818',
    '4195819' => 'e4195819',
    '4195820' => 'e4195820',
    '4195821' => 'e4195821',
    '4195822' => 'e4195822',
    '4195823' => 'e4195823',
    '4195824' => 'e4195824',
    '4195825' => 'e4195825',
    '4195826' => 'e4195826',
    '4195827' => 'e4195827',
    '4195828' => 'e4195828',
    '4195829' => 'e4195829',
    '4195830' => 'e4195830',
    '4195831' => 'e4195831',
    '4195832' => 'e4195832',
    '4195833' => 'e4195833',
    '4195834' => 'e4195834',
    '4195835' => 'e4195835',
    '4195836' => 'e4195836',
    '4195837' => 'e4195837',
    '4195838' => 'e4195838',
    '4195839' => 'e4195839',
    '4195840' => 'e4195840',
    '4195841' => 'e4195841',
    '4195842' => 'e4195842',
    '4195843' => 'e4195843',
    '4195844' => 'e4195844',
    '4195845' => 'e4195845',
    '4195846' => 'e4195846',
    '4195847' => 'e4195847',
    '4195848' => 'e4195848',
    '4195849' => 'e4195849',
    '4195850' => 'e4195850',
    '4195851' => 'e4195851',
    '4195852' => 'e4195852',
    '4195853' => 'e4195853',
    '4195854' => 'e4195854',
    '4195855' => 'e4195855',
    '4195856' => 'e4195856',
    '4195857' => 'e4195857',
    '4195858' => 'e4195858',
    '4195859' => 'e4195859',
    '4195860' => 'e4195860',
    '4195861' => 'e4195861',
    '4195862' => 'e4195862',
    '4195863' => 'e4195863',
    '4195864' => 'e4195864',
    '4195865' => 'e4195865',
    '4195866' => 'e4195866',
    '4195867' => 'e4195867',
    '4195868' => 'e4195868',
    '4195869' => 'e4195869',
    '4195870' => 'e4195870',
    '4195871' => 'e4195871',
    '4195872' => 'e4195872',
    '4195873' => 'e4195873',
    '4195874' => 'e4195874',
    '4195875' => 'e4195875',
    '4195876' => 'e4195876',
    '4195877' => 'e4195877',
    '4195880' => 'e4195880',
    '4195881' => 'e4195881',
    '4195882' => 'e4195882',
    '4195883' => 'e4195883',
    '4195884' => 'e4195884',
    '4195885' => 'e4195885',
    '4195886' => 'e4195886',
    '4195887' => 'e4195887',
    '4195888' => 'e4195888',
    '4195889' => 'e4195889',
    '4195890' => 'e4195890',
    '4195891' => 'e4195891',
    '4195892' => 'e4195892',
    '4195893' => 'e4195893',
    '4195894' => 'e4195894',
    '4195895' => 'e4195895',
    '4195896' => 'e4195896',
    '4195897' => 'e4195897',
    '4195898' => 'e4195898',
    '4195899' => 'e4195899',
    '4195900' => 'e4195900',
    '4195901' => 'e4195901',
    '4195902' => 'e4195902',
    '4195903' => 'e4195903',
    '4195904' => 'e4195904',
    '4195905' => 'e4195905',
    '4195906' => 'e4195906',
    '4195907' => 'e4195907',
    '4195908' => 'e4195908',
    '4195909' => 'e4195909',
    '4195910' => 'e4195910',
    '4195911' => 'e4195911',
    '4195912' => 'e4195912',
    '4195913' => 'e4195913',
    '4195914' => 'e4195914',
    '4195915' => 'e4195915',
    '4195916' => 'e4195916',
    '4195917' => 'e4195917',
    '4195918' => 'e4195918',
    '4195919' => 'e4195919',
    '4195920' => 'e4195920',
    '4195921' => 'e4195921',
    '4195922' => 'e4195922',
    '4195923' => 'e4195923',
    '4195924' => 'e4195924',
    '4195925' => 'e4195925',
    '4195926' => 'e4195926',
    '4195927' => 'e4195927',
    '4195928' => 'e4195928',
    '4195929' => 'e4195929',
    '4195930' => 'e4195930',
    '4195931' => 'e4195931',
    '4195932' => 'e4195932',
    '4195933' => 'e4195933',
    '4195934' => 'e4195934',
    '4195935' => 'e4195935',
    '4195936' => 'e4195936',
    '4195937' => 'e4195937',
    '4195938' => 'e4195938',
    '4195939' => 'e4195939',
    '4195940' => 'e4195940',
    '4195941' => 'e4195941',
    '4195942' => 'e4195942',
    '4195943' => 'e4195943',
    '4195944' => 'e4195944',
    '4195945' => 'e4195945',
    '4195946' => 'e4195946',
    '4195947' => 'e4195947',
    '4195948' => 'e4195948',
    '4195949' => 'e4195949',
    '4195950' => 'e4195950',
    '4195951' => 'e4195951',
    '4195952' => 'e4195952',
    '4195953' => 'e4195953',
    '4195956' => 'e4195956',
    '4195957' => 'e4195957',
    '4195958' => 'e4195958',
    '4195959' => 'e4195959',
    '4195960' => 'e4195960',
    '4195961' => 'e4195961',
    '4195962' => 'e4195962',
    '4195963' => 'e4195963',
    '4195964' => 'e4195964',
    '4195965' => 'e4195965',
    '4195966' => 'e4195966',
    '4195967' => 'e4195967',
    '4195968' => 'e4195968',
    '4195969' => 'e4195969',
    '4195970' => 'e4195970',
    '4195971' => 'e4195971',
    '4195972' => 'e4195972',
    '4195973' => 'e4195973',
    '4195976' => 'e4195976',
    '4195977' => 'e4195977',
    '4195978' => 'e4195978',
    '4195979' => 'e4195979',
    '4195980' => 'e4195980',
    '4195981' => 'e4195981',
    '4195982' => 'e4195982',
    '4195983' => 'e4195983',
    '4195984' => 'e4195984',
    '4195985' => 'e4195985',
    '4195986' => 'e4195986',
    '4195987' => 'e4195987',
    '4195988' => 'e4195988',
    '4195989' => 'e4195989',
    '4195991' => 'e4195991',
    '4195992' => 'e4195992',
    '4195993' => 'e4195993',
    '4195994' => 'e4195994',
    '4195995' => 'e4195995',
    '4195996' => 'e4195996',
    '4195997' => 'e4195997',
    '4195998' => 'e4195998',
    '4195999' => 'e4195999',
    '4196000' => 'e4196000',
    '4196001' => 'e4196001',
    '4196002' => 'e4196002',
    '4196003' => 'e4196003',
    '4196004' => 'e4196004',
    '4196005' => 'e4196005',
    '4196006' => 'e4196006',
    '4196007' => 'e4196007',
    '4196008' => 'e4196008',
    '4196009' => 'e4196009',
    '4196010' => 'e4196010',
    '4196011' => 'e4196011',
    '4196012' => 'e4196012',
    '4196013' => 'e4196013',
    '4196014' => 'e4196014',
    '4196015' => 'e4196015',
    '4196016' => 'e4196016',
    '4196017' => 'e4196017',
    '4196018' => 'e4196018',
    '4196019' => 'e4196019',
    '4196020' => 'e4196020',
    '4196021' => 'e4196021',
    '4196022' => 'e4196022',
    '4196023' => 'e4196023',
    '4196024' => 'e4196024',
    '4196025' => 'e4196025',
    '4196026' => 'e4196026',
    '4196027' => 'e4196027',
    '4196028' => 'e4196028',
    '4196029' => 'e4196029',
    '4196030' => 'e4196030',
    '4196031' => 'e4196031',
    '4196032' => 'e4196032',
    '4196033' => 'e4196033',
    '4196034' => 'e4196034',
    '4196035' => 'e4196035',
    '4196036' => 'e4196036',
    '4196041' => 'e4196041',
    '4196042' => 'e4196042',
    '4196045' => 'e4196045',
    '4196047' => 'e4196047',
    '4196048' => 'e4196048',
    '4196049' => 'e4196049',
    '4196051' => 'e4196051',
    '4196052' => 'e4196052',
    '4196055' => 'e4196055',
    '4196056' => 'e4196056',
    '4196060' => 'e4196060',
    '4196061' => 'e4196061',
    '4196062' => 'e4196062',
    '4196063' => 'e4196063',
    '4196065' => 'e4196065',
    '4196066' => 'e4196066',
    '4196067' => 'e4196067',
    '4196068' => 'e4196068',
    '4196069' => 'e4196069',
    '4196070' => 'e4196070',
    '4196071' => 'e4196071',
    '4196072' => 'e4196072',
    '4196073' => 'e4196073',
    '4196074' => 'e4196074',
    '4196075' => 'e4196075',
    '4196076' => 'e4196076',
    '4196077' => 'e4196077',
    '4196078' => 'e4196078',
    '4196079' => 'e4196079',
    '4196080' => 'e4196080',
    '4196081' => 'e4196081',
    '4196082' => 'e4196082',
    '4196083' => 'e4196083',
    '4196084' => 'e4196084',
    '4196085' => 'e4196085',
    '4196086' => 'e4196086',
    '4196087' => 'e4196087',
    '4196088' => 'e4196088',
    '4196089' => 'e4196089',
    '4196090' => 'e4196090',
    '4196091' => 'e4196091',
    '4196092' => 'e4196092',
    '4196093' => 'e4196093',
    '4196094' => 'e4196094',
    '4196095' => 'e4196095',
    '4196096' => 'e4196096',
    '4196097' => 'e4196097',
    '4196098' => 'e4196098',
    '4196099' => 'e4196099',
    '4196100' => 'e4196100',
    '4196101' => 'e4196101',
    '4196102' => 'e4196102',
    '4196103' => 'e4196103',
    '4196104' => 'e4196104',
    '4196105' => 'e4196105',
    '4196106' => 'e4196106',
    '4196107' => 'e4196107',
    '4196108' => 'e4196108',
    '4196109' => 'e4196109',
    '4196110' => 'e4196110',
    '4196111' => 'e4196111',
    '4196112' => 'e4196112',
    '4196113' => 'e4196113',
    '4196114' => 'e4196114',
    '4196115' => 'e4196115',
    '4196116' => 'e4196116',
    '4196117' => 'e4196117',
    '4196118' => 'e4196118',
    '4196119' => 'e4196119',
    '4196120' => 'e4196120',
    '4196121' => 'e4196121',
    '4196122' => 'e4196122',
    '4196123' => 'e4196123',
    '4196124' => 'e4196124',
    '4196125' => 'e4196125',
    '4196126' => 'e4196126',
    '4196127' => 'e4196127',
    '4196128' => 'e4196128',
    '4196129' => 'e4196129',
    '4196130' => 'e4196130',
    '4196131' => 'e4196131',
    '4196132' => 'e4196132',
    '4196133' => 'e4196133',
    '4196134' => 'e4196134',
    '4196135' => 'e4196135',
    '4196136' => 'e4196136',
    '4196137' => 'e4196137',
    '4196138' => 'e4196138',
    '4196139' => 'e4196139',
    '4196140' => 'e4196140',
    '4196141' => 'e4196141',
    '4196142' => 'e4196142',
    '4196143' => 'e4196143',
    '4196144' => 'e4196144',
    '4196145' => 'e4196145',
    '4196146' => 'e4196146',
    '4196147' => 'e4196147',
    '4196149' => 'e4196149',
    '4196150' => 'e4196150',
    '4196151' => 'e4196151',
    '4196152' => 'e4196152',
    '4196153' => 'e4196153',
    '4196154' => 'e4196154',
    '4196155' => 'e4196155',
    '4196156' => 'e4196156',
    '4196157' => 'e4196157',
    '4196158' => 'e4196158',
    '4196159' => 'e4196159',
    '4196160' => 'e4196160',
    '4196161' => 'e4196161',
    '4196162' => 'e4196162',
    '4196163' => 'e4196163',
    '4196164' => 'e4196164',
    '4196165' => 'e4196165',
    '4196168' => 'e4196168',
    '4196169' => 'e4196169',
    '4196170' => 'e4196170',
    '4196171' => 'e4196171',
    '4196172' => 'e4196172',
    '4196173' => 'e4196173',
    '4196174' => 'e4196174',
    '4196175' => 'e4196175',
    '4196176' => 'e4196176',
    '4196177' => 'e4196177',
    '4196178' => 'e4196178',
    '4196179' => 'e4196179',
    '4196180' => 'e4196180',
    '4196181' => 'e4196181',
    '4196182' => 'e4196182',
    '4196183' => 'e4196183',
    '4196184' => 'e4196184',
    '4196185' => 'e4196185',
    '4196186' => 'e4196186',
    '4196187' => 'e4196187',
    '4196188' => 'e4196188',
    '4196189' => 'e4196189',
    '4196190' => 'e4196190',
    '4196191' => 'e4196191',
    '4196192' => 'e4196192',
    '4196193' => 'e4196193',
    '4196194' => 'e4196194',
    '4196195' => 'e4196195',
    '4196196' => 'e4196196',
    '4196197' => 'e4196197',
    '4196198' => 'e4196198',
    '4196199' => 'e4196199',
    '4196200' => 'e4196200',
    '4196201' => 'e4196201',
    '4196202' => 'e4196202',
    '4196203' => 'e4196203',
    '4196204' => 'e4196204',
    '4196205' => 'e4196205',
    '4196206' => 'e4196206',
    '4196207' => 'e4196207',
    '4196208' => 'e4196208',
    '4196209' => 'e4196209',
    '4196210' => 'e4196210',
    '4196211' => 'e4196211',
    '4196214' => 'e4196214',
    '4196215' => 'e4196215',
    '4196216' => 'e4196216',
    '4196217' => 'e4196217',
    '4196218' => 'e4196218',
    '4196219' => 'e4196219',
    '4196220' => 'e4196220',
    '4196221' => 'e4196221',
    '4196222' => 'e4196222',
    '4196223' => 'e4196223',
    '4196224' => 'e4196224',
    '4196225' => 'e4196225',
    '4196226' => 'e4196226',
    '4196227' => 'e4196227',
    '4196228' => 'e4196228',
    '4196229' => 'e4196229',
    '4196230' => 'e4196230',
    '4196231' => 'e4196231',
    '4196232' => 'e4196232',
    '4196233' => 'e4196233',
    '4196234' => 'e4196234',
    '4196235' => 'e4196235',
    '4196236' => 'e4196236',
    '4196237' => 'e4196237',
    '4196241' => 'e4196241',
    '4196242' => 'e4196242',
    '4196243' => 'e4196243',
    '4196244' => 'e4196244',
    '4196245' => 'e4196245',
    '4196246' => 'e4196246',
    '4196247' => 'e4196247',
    '4196249' => 'e4196249',
    '4196250' => 'e4196250',
    '4196251' => 'e4196251',
    '4196252' => 'e4196252',
    '4196253' => 'e4196253',
    '4196254' => 'e4196254',
    '4196255' => 'e4196255',
    '4196256' => 'e4196256',
    '4196257' => 'e4196257',
    '4196258' => 'e4196258',
    '4196259' => 'e4196259',
    '4196260' => 'e4196260',
    '4196261' => 'e4196261',
    '4196262' => 'e4196262',
    '4196263' => 'e4196263',
    '4196264' => 'e4196264',
    '4196265' => 'e4196265',
    '4196266' => 'e4196266',
    '4196267' => 'e4196267',
    '4196268' => 'e4196268',
    '4196269' => 'e4196269',
    '4196270' => 'e4196270',
    '4196271' => 'e4196271',
    '4196272' => 'e4196272',
    '4196273' => 'e4196273',
    '4196274' => 'e4196274',
    '4196275' => 'e4196275',
    '4196276' => 'e4196276',
    '4196277' => 'e4196277',
    '4196278' => 'e4196278',
    '4196279' => 'e4196279',
    '4196280' => 'e4196280',
    '4196281' => 'e4196281',
    '4196282' => 'e4196282',
    '4196283' => 'e4196283',
    '4196284' => 'e4196284',
    '4196285' => 'e4196285',
    '4196286' => 'e4196286',
    '4196287' => 'e4196287',
    '4196288' => 'e4196288',
    '4196289' => 'e4196289',
    '4196290' => 'e4196290',
    '4196291' => 'e4196291',
    '4196292' => 'e4196292',
    '4196293' => 'e4196293',
    '4196294' => 'e4196294',
    '4196295' => 'e4196295',
    '4196296' => 'e4196296',
    '4196297' => 'e4196297',
    '4196298' => 'e4196298',
    '4196299' => 'e4196299',
    '4196300' => 'e4196300',
    '4196301' => 'e4196301',
    '4196302' => 'e4196302',
    '4196303' => 'e4196303',
    '4196304' => 'e4196304',
    '4196305' => 'e4196305',
    '4196306' => 'e4196306',
    '4196307' => 'e4196307',
    '4196308' => 'e4196308',
    '4196309' => 'e4196309',
    '4196310' => 'e4196310',
    '4196317' => 'e4196317',
    '4196318' => 'e4196318',
    '4196319' => 'e4196319',
    '4196320' => 'e4196320',
    '4196321' => 'e4196321',
    '4196322' => 'e4196322',
    '4196323' => 'e4196323',
    '4196324' => 'e4196324',
    '4196325' => 'e4196325',
    '4196326' => 'e4196326',
    '4196327' => 'e4196327',
    '4196328' => 'e4196328',
    '4196329' => 'e4196329',
    '4196330' => 'e4196330',
    '4196331' => 'e4196331',
    '4196332' => 'e4196332',
    '4196333' => 'e4196333',
    '4196334' => 'e4196334',
    '4196335' => 'e4196335',
    '4196336' => 'e4196336',
    '4196337' => 'e4196337',
    '4196338' => 'e4196338',
    '4196339' => 'e4196339',
    '4196340' => 'e4196340',
    '4196341' => 'e4196341',
    '4196342' => 'e4196342',
    '4196343' => 'e4196343',
    '4196344' => 'e4196344',
    '4196345' => 'e4196345',
    '4196346' => 'e4196346',
    '4196347' => 'e4196347',
    '4196348' => 'e4196348',
    '4196349' => 'e4196349',
    '4196350' => 'e4196350',
    '4196354' => 'e4196354',
    '4196355' => 'e4196355',
    '4196356' => 'e4196356',
    '4196357' => 'e4196357',
    '4196358' => 'e4196358',
    '4196359' => 'e4196359',
    '4196360' => 'e4196360',
    '4196361' => 'e4196361',
    '4196362' => 'e4196362',
    '4196363' => 'e4196363',
    '4196364' => 'e4196364',
    '4196365' => 'e4196365',
    '4196366' => 'e4196366',
    '4196367' => 'e4196367',
    '4196368' => 'e4196368',
    '4196369' => 'e4196369',
    '4196370' => 'e4196370',
    '4196371' => 'e4196371',
    '4196372' => 'e4196372',
    '4196373' => 'e4196373',
    '4196374' => 'e4196374',
    '4196375' => 'e4196375',
    '4196376' => 'e4196376',
    '4196377' => 'e4196377',
    '4196378' => 'e4196378',
    '4196379' => 'e4196379',
    '4196380' => 'e4196380',
    '4196381' => 'e4196381',
    '4196382' => 'e4196382',
    '4196383' => 'e4196383',
    '4196384' => 'e4196384',
    '4196385' => 'e4196385',
    '4196386' => 'e4196386',
    '4196387' => 'e4196387',
    '4196388' => 'e4196388',
    '4196389' => 'e4196389',
    '4196390' => 'e4196390',
    '4196391' => 'e4196391',
    '4196392' => 'e4196392',
    '4196393' => 'e4196393',
    '4196394' => 'e4196394',
    '4196395' => 'e4196395',
    '4196396' => 'e4196396',
    '4196397' => 'e4196397',
    '4196398' => 'e4196398',
    '4196399' => 'e4196399',
    '4196400' => 'e4196400',
    '4196401' => 'e4196401',
    '4196402' => 'e4196402',
    '4196403' => 'e4196403',
    '4196404' => 'e4196404',
    '4196405' => 'e4196405',
    '4196406' => 'e4196406',
    '4196407' => 'e4196407',
    '4196408' => 'e4196408',
    '4196409' => 'e4196409',
    '4196410' => 'e4196410',
    '4196411' => 'e4196411',
    '4196412' => 'e4196412',
    '4196413' => 'e4196413',
    '4196414' => 'e4196414',
    '4196415' => 'e4196415',
    '4196416' => 'e4196416',
    '4196417' => 'e4196417',
    '4196418' => 'e4196418',
    '4196419' => 'e4196419',
    '4196420' => 'e4196420',
    '4196421' => 'e4196421',
    '4196422' => 'e4196422',
    '4196423' => 'e4196423',
    '4196424' => 'e4196424',
    '4196425' => 'e4196425',
    '4196426' => 'e4196426',
    '4196427' => 'e4196427',
    '4196428' => 'e4196428',
    '4196429' => 'e4196429',
    '4196430' => 'e4196430',
    '4196431' => 'e4196431',
    '4196432' => 'e4196432',
    '4196433' => 'e4196433',
    '4196434' => 'e4196434',
    '4196435' => 'e4196435',
    '4196436' => 'e4196436',
    '4196437' => 'e4196437',
    '4196438' => 'e4196438',
    '4196439' => 'e4196439',
    '4196440' => 'e4196440',
    '4196441' => 'e4196441',
    '4196442' => 'e4196442',
    '4196443' => 'e4196443',
    '4196444' => 'e4196444',
    '4196445' => 'e4196445',
    '4196446' => 'e4196446',
    '4196447' => 'e4196447',
    '4196448' => 'e4196448',
    '4196449' => 'e4196449',
    '4196450' => 'e4196450',
    '4196451' => 'e4196451',
    '4196452' => 'e4196452',
    '4196453' => 'e4196453',
    '4196454' => 'e4196454',
    '4196455' => 'e4196455',
    '4196456' => 'e4196456',
    '4196457' => 'e4196457',
    '4196458' => 'e4196458',
    '4196459' => 'e4196459',
    '4196460' => 'e4196460',
    '4196461' => 'e4196461',
    '4196462' => 'e4196462',
    '4196463' => 'e4196463',
    '4196464' => 'e4196464',
    '4196465' => 'e4196465',
    '4196466' => 'e4196466',
    '4196467' => 'e4196467',
    '4196468' => 'e4196468',
    '4196469' => 'e4196469',
    '4196470' => 'e4196470',
    '4196471' => 'e4196471',
    '4196472' => 'e4196472',
    '4196474' => 'e4196474',
    '4196475' => 'e4196475',
    '4196477' => 'e4196477',
    '4196478' => 'e4196478',
    '4196480' => 'e4196480',
    '4196481' => 'e4196481',
    '4196483' => 'e4196483',
    '4196484' => 'e4196484',
    '4196485' => 'e4196485',
    '4196486' => 'e4196486',
    '4196487' => 'e4196487',
    '4196488' => 'e4196488',
    '4196489' => 'e4196489',
    '4196490' => 'e4196490',
    '4196491' => 'e4196491',
    '4196492' => 'e4196492',
    '4196493' => 'e4196493',
    '4196494' => 'e4196494',
    '4196495' => 'e4196495',
    '4196496' => 'e4196496',
    '4196497' => 'e4196497',
    '4196498' => 'e4196498',
    '4196499' => 'e4196499',
    '4196500' => 'e4196500',
    '4196501' => 'e4196501',
    '4196502' => 'e4196502',
    '4196503' => 'e4196503',
    '4196504' => 'e4196504',
    '4196505' => 'e4196505',
    '4196506' => 'e4196506',
    '4196507' => 'e4196507',
    '4196508' => 'e4196508',
    '4196509' => 'e4196509',
    '4196510' => 'e4196510',
    '4196511' => 'e4196511',
    '4196512' => 'e4196512',
    '4196513' => 'e4196513',
    '4196514' => 'e4196514',
    '4196515' => 'e4196515',
    '4196516' => 'e4196516',
    '4196517' => 'e4196517',
    '4196518' => 'e4196518',
    '4196519' => 'e4196519',
    '4196520' => 'e4196520',
    '4196521' => 'e4196521',
    '4196522' => 'e4196522',
    '4196523' => 'e4196523',
    '4196524' => 'e4196524',
    '4196525' => 'e4196525',
    '4196526' => 'e4196526',
    '4196527' => 'e4196527',
    '4196528' => 'e4196528',
    '4196529' => 'e4196529',
    '4196530' => 'e4196530',
    '4196531' => 'e4196531',
    '4196532' => 'e4196532',
    '4196533' => 'e4196533',
    '4196534' => 'e4196534',
    '4196535' => 'e4196535',
    '4196536' => 'e4196536',
    '4196537' => 'e4196537',
    '4196538' => 'e4196538',
    '4196539' => 'e4196539',
    '4196540' => 'e4196540',
    '4196541' => 'e4196541',
    '4196542' => 'e4196542',
    '4196543' => 'e4196543',
    '4196544' => 'e4196544',
    '4196545' => 'e4196545',
    '4196546' => 'e4196546',
    '4196555' => 'e4196555',
    '4196556' => 'e4196556',
    '4196557' => 'e4196557',
    '4196558' => 'e4196558',
    '4196559' => 'e4196559',
    '4196560' => 'e4196560',
    '4196561' => 'e4196561',
    '4196562' => 'e4196562',
    '4196563' => 'e4196563',
    '4196564' => 'e4196564',
    '4196565' => 'e4196565',
    '4196566' => 'e4196566',
    '4196567' => 'e4196567',
    '4196568' => 'e4196568',
    '4196569' => 'e4196569',
    '4196570' => 'e4196570',
    '4196571' => 'e4196571',
    '4196572' => 'e4196572',
    '4196573' => 'e4196573',
    '4196574' => 'e4196574',
    '4196575' => 'e4196575',
    '4196576' => 'e4196576',
    '4196577' => 'e4196577',
    '4196578' => 'e4196578',
    '4196579' => 'e4196579',
    '4196580' => 'e4196580',
    '4196581' => 'e4196581',
    '4196582' => 'e4196582',
    '4196583' => 'e4196583',
    '4196584' => 'e4196584',
    '4196585' => 'e4196585',
    '4196586' => 'e4196586',
    '4196587' => 'e4196587',
    '4196588' => 'e4196588',
    '4196589' => 'e4196589',
    '4196590' => 'e4196590',
    '4196591' => 'e4196591',
    '4196592' => 'e4196592',
    '4196593' => 'e4196593',
    '4196594' => 'e4196594',
    '4196595' => 'e4196595',
    '4196596' => 'e4196596',
    '4196597' => 'e4196597',
    '4196598' => 'e4196598',
    '4196599' => 'e4196599',
    '4196600' => 'e4196600',
    '4196601' => 'e4196601',
    '4196602' => 'e4196602',
    '4196603' => 'e4196603',
    '4196604' => 'e4196604',
    '4196605' => 'e4196605',
    '4196606' => 'e4196606',
    '4196607' => 'e4196607',
    '4196608' => 'e4196608',
    '4196609' => 'e4196609',
    '4196610' => 'e4196610',
    '4196611' => 'e4196611',
    '4196612' => 'e4196612',
    '4196613' => 'e4196613',
    '4196614' => 'e4196614',
    '4196619' => 'e4196619',
    '4196620' => 'e4196620',
    '4196621' => 'e4196621',
    '4196622' => 'e4196622',
    '4196623' => 'e4196623',
    '4196624' => 'e4196624',
    '4196625' => 'e4196625',
    '4196626' => 'e4196626',
    '4196627' => 'e4196627',
    '4196628' => 'e4196628',
    '4196629' => 'e4196629',
    '4196630' => 'e4196630',
    '4196631' => 'e4196631',
    '4196632' => 'e4196632',
    '4196633' => 'e4196633',
    '4196634' => 'e4196634',
    '4196635' => 'e4196635',
    '4196636' => 'e4196636',
    '4196637' => 'e4196637',
    '4196638' => 'e4196638',
    '4196639' => 'e4196639',
    '4196640' => 'e4196640',
    '4196641' => 'e4196641',
    '4196642' => 'e4196642',
    '4196643' => 'e4196643',
    '4196644' => 'e4196644',
    '4196645' => 'e4196645',
    '4196646' => 'e4196646',
    '4196647' => 'e4196647',
    '4196648' => 'e4196648',
    '4196649' => 'e4196649',
    '4196650' => 'e4196650',
    '4196651' => 'e4196651',
    '4196652' => 'e4196652',
    '4196653' => 'e4196653',
    '4196654' => 'e4196654',
    '4196655' => 'e4196655',
    '4196656' => 'e4196656',
    '4196657' => 'e4196657',
    '4196658' => 'e4196658',
    '4196659' => 'e4196659',
    '4196660' => 'e4196660',
    '4196661' => 'e4196661',
    '4196662' => 'e4196662',
    '4196663' => 'e4196663',
    '4196664' => 'e4196664',
    '4196665' => 'e4196665',
    '4196666' => 'e4196666',
    '4196667' => 'e4196667',
    '4196668' => 'e4196668',
    '4196669' => 'e4196669',
    '4196670' => 'e4196670',
    '4196671' => 'e4196671',
    '4196672' => 'e4196672',
    '4196673' => 'e4196673',
    '4196674' => 'e4196674',
    '4196675' => 'e4196675',
    '4196676' => 'e4196676',
    '4196677' => 'e4196677',
    '4196678' => 'e4196678',
    '4196679' => 'e4196679',
    '4196680' => 'e4196680',
    '4196681' => 'e4196681',
    '4196682' => 'e4196682',
    '4196683' => 'e4196683',
    '4196684' => 'e4196684',
    '4196685' => 'e4196685',
    '4196686' => 'e4196686',
    '4196687' => 'e4196687',
    '4196688' => 'e4196688',
    '4196689' => 'e4196689',
    '4196690' => 'e4196690',
    '4196691' => 'e4196691',
    '4196692' => 'e4196692',
    '4196693' => 'e4196693',
    '4196694' => 'e4196694',
    '4196695' => 'e4196695',
    '4196696' => 'e4196696',
    '4196697' => 'e4196697',
    '4196698' => 'e4196698',
    '4196699' => 'e4196699',
    '4196700' => 'e4196700',
    '4196701' => 'e4196701',
    '4196702' => 'e4196702',
    '4196703' => 'e4196703',
    '4196704' => 'e4196704',
    '4196705' => 'e4196705',
    '4196706' => 'e4196706',
    '4196707' => 'e4196707',
    '4196708' => 'e4196708',
    '4196709' => 'e4196709',
    '4196710' => 'e4196710',
    '4196711' => 'e4196711',
    '4196712' => 'e4196712',
    '4196713' => 'e4196713',
    '4196714' => 'e4196714',
    '4196715' => 'e4196715',
    '4196716' => 'e4196716',
    '4196717' => 'e4196717',
    '4196718' => 'e4196718',
    '4196719' => 'e4196719',
    '4196720' => 'e4196720',
    '4196721' => 'e4196721',
    '4196722' => 'e4196722',
    '4196723' => 'e4196723',
    '4196724' => 'e4196724',
    '4196725' => 'e4196725',
    '4196726' => 'e4196726',
    '4196727' => 'e4196727',
    '4196728' => 'e4196728',
    '4196729' => 'e4196729',
    '4196730' => 'e4196730',
    '4196731' => 'e4196731',
    '4196732' => 'e4196732',
    '4196733' => 'e4196733',
    '4196734' => 'e4196734',
    '4196735' => 'e4196735',
    '4196736' => 'e4196736',
    '4196737' => 'e4196737',
    '4196738' => 'e4196738',
    '4196739' => 'e4196739',
    '4196740' => 'e4196740',
    '4196741' => 'e4196741',
    '4196742' => 'e4196742',
    '4196743' => 'e4196743',
    '4196744' => 'e4196744',
    '4196745' => 'e4196745',
    '4196746' => 'e4196746',
    '4196747' => 'e4196747',
    '4196748' => 'e4196748',
    '4196749' => 'e4196749',
    '4196750' => 'e4196750',
    '4196751' => 'e4196751',
    '4196752' => 'e4196752',
    '4196753' => 'e4196753',
    '4196754' => 'e4196754',
    '4196755' => 'e4196755',
    '4196756' => 'e4196756',
    '4196757' => 'e4196757',
    '4196758' => 'e4196758',
    '4196759' => 'e4196759',
    '4196760' => 'e4196760',
    '4196761' => 'e4196761',
    '4196762' => 'e4196762',
    '4196763' => 'e4196763',
    '4196764' => 'e4196764',
    '4196765' => 'e4196765',
    '4196766' => 'e4196766',
    '4196767' => 'e4196767',
    '4196768' => 'e4196768',
    '4196769' => 'e4196769',
    '4196770' => 'e4196770',
    '4196771' => 'e4196771',
    '4196772' => 'e4196772',
    '4196773' => 'e4196773',
    '4196774' => 'e4196774',
    '4196775' => 'e4196775',
    '4196776' => 'e4196776',
    '4196777' => 'e4196777',
    '4196778' => 'e4196778',
    '4196779' => 'e4196779',
    '4196780' => 'e4196780',
    '4196781' => 'e4196781',
    '4196785' => 'e4196785',
    '4196787' => 'e4196787',
    '4196788' => 'e4196788',
    '4196789' => 'e4196789',
    '4196790' => 'e4196790',
    '4196791' => 'e4196791',
    '4196792' => 'e4196792',
    '4196793' => 'e4196793',
    '4196794' => 'e4196794',
    '4196795' => 'e4196795',
    '4196796' => 'e4196796',
    '4196797' => 'e4196797',
    '4196798' => 'e4196798',
    '4196799' => 'e4196799',
    '4196800' => 'e4196800',
    '4196801' => 'e4196801',
    '4196802' => 'e4196802',
    '4196803' => 'e4196803',
    '4196804' => 'e4196804',
    '4196805' => 'e4196805',
    '4196806' => 'e4196806',
    '4196807' => 'e4196807',
    '4196808' => 'e4196808',
    '4196809' => 'e4196809',
    '4196810' => 'e4196810',
    '4196811' => 'e4196811',
    '4196812' => 'e4196812',
    '4196813' => 'e4196813',
    '4196814' => 'e4196814',
    '4196815' => 'e4196815',
    '4196816' => 'e4196816',
    '4196817' => 'e4196817',
    '4196818' => 'e4196818',
    '4196819' => 'e4196819',
    '4196820' => 'e4196820',
    '4196821' => 'e4196821',
    '4196822' => 'e4196822',
    '4196823' => 'e4196823',
    '4196824' => 'e4196824',
    '4196825' => 'e4196825',
    '4196826' => 'e4196826',
    '4196827' => 'e4196827',
    '4196828' => 'e4196828',
    '4196829' => 'e4196829',
    '4196830' => 'e4196830',
    '4196831' => 'e4196831',
    '4196832' => 'e4196832',
    '4196833' => 'e4196833',
    '4196834' => 'e4196834',
    '4196835' => 'e4196835',
    '4196836' => 'e4196836',
    '4196837' => 'e4196837',
    '4196838' => 'e4196838',
    '4196839' => 'e4196839',
    '4196840' => 'e4196840',
    '4196841' => 'e4196841',
    '4196842' => 'e4196842',
    '4196843' => 'e4196843',
    '4196844' => 'e4196844',
    '4196845' => 'e4196845',
    '4196846' => 'e4196846',
    '4196847' => 'e4196847',
    '4196848' => 'e4196848',
    '4196849' => 'e4196849',
    '4196850' => 'e4196850',
    '4196851' => 'e4196851',
    '4196852' => 'e4196852',
    '4196853' => 'e4196853',
    '4196854' => 'e4196854',
    '4196855' => 'e4196855',
    '4196856' => 'e4196856',
    '4196857' => 'e4196857',
    '4196858' => 'e4196858',
    '4196859' => 'e4196859',
    '4196860' => 'e4196860',
    '4196861' => 'e4196861',
    '4196862' => 'e4196862',
    '4196863' => 'e4196863',
    '4196864' => 'e4196864',
    '4196865' => 'e4196865',
    '4196866' => 'e4196866',
    '4196867' => 'e4196867',
    '4196868' => 'e4196868',
    '4196869' => 'e4196869',
    '4196870' => 'e4196870',
    '4196871' => 'e4196871',
    '4196872' => 'e4196872',
    '4196873' => 'e4196873',
    '4196874' => 'e4196874',
    '4196875' => 'e4196875',
    '4196876' => 'e4196876',
    '4196877' => 'e4196877',
    '4196878' => 'e4196878',
    '4196879' => 'e4196879',
    '4196880' => 'e4196880',
    '4196881' => 'e4196881',
    '4196882' => 'e4196882',
    '4196883' => 'e4196883',
    '4196884' => 'e4196884',
    '4196885' => 'e4196885',
    '4196886' => 'e4196886',
    '4196887' => 'e4196887',
    '4196888' => 'e4196888',
    '4196889' => 'e4196889',
    '4196890' => 'e4196890',
    '4196891' => 'e4196891',
    '4196892' => 'e4196892',
    '4196893' => 'e4196893',
    '4196894' => 'e4196894',
    '4196895' => 'e4196895',
    '4196896' => 'e4196896',
    '4196897' => 'e4196897',
    '4196898' => 'e4196898',
    '4196899' => 'e4196899',
    '4196900' => 'e4196900',
    '4196901' => 'e4196901',
    '4196902' => 'e4196902',
    '4196903' => 'e4196903',
    '4196904' => 'e4196904',
    '4196905' => 'e4196905',
    '4196906' => 'e4196906',
    '4196907' => 'e4196907',
    '4196908' => 'e4196908',
    '4196909' => 'e4196909',
    '4196910' => 'e4196910',
    '4196911' => 'e4196911',
    '4196912' => 'e4196912',
    '4196913' => 'e4196913',
    '4196914' => 'e4196914',
    '4196915' => 'e4196915',
    '4196916' => 'e4196916',
    '4196917' => 'e4196917',
    '4196918' => 'e4196918',
    '4196919' => 'e4196919',
    '4196920' => 'e4196920',
    '4196921' => 'e4196921',
    '4196922' => 'e4196922',
    '4196923' => 'e4196923',
    '4196924' => 'e4196924',
    '4196925' => 'e4196925',
    '4196926' => 'e4196926',
    '4196927' => 'e4196927',
    '4196928' => 'e4196928',
    '4196929' => 'e4196929',
    '4196930' => 'e4196930',
    '4196931' => 'e4196931',
    '4196932' => 'e4196932',
    '4196933' => 'e4196933',
    '4196934' => 'e4196934',
    '4196935' => 'e4196935',
    '4196936' => 'e4196936',
    '4196937' => 'e4196937',
    '4196938' => 'e4196938',
    '4196939' => 'e4196939',
    '4196940' => 'e4196940',
    '4196941' => 'e4196941',
    '4196942' => 'e4196942',
    '4196943' => 'e4196943',
    '4196944' => 'e4196944',
    '4196945' => 'e4196945',
    '4196946' => 'e4196946',
    '4196947' => 'e4196947',
    '4196948' => 'e4196948',
    '4196949' => 'e4196949',
    '4196950' => 'e4196950',
    '4196951' => 'e4196951',
    '4196952' => 'e4196952',
    '4196953' => 'e4196953',
    '4196954' => 'e4196954',
    '4196955' => 'e4196955',
    '4196956' => 'e4196956',
    '4196957' => 'e4196957',
    '4196958' => 'e4196958',
    '4196959' => 'e4196959',
    '4196960' => 'e4196960',
    '4196961' => 'e4196961',
    '4196962' => 'e4196962',
    '4196963' => 'e4196963',
    '4196964' => 'e4196964',
    '4196965' => 'e4196965',
    '4196966' => 'e4196966',
    '4196967' => 'e4196967',
    '4196968' => 'e4196968',
    '4196969' => 'e4196969',
    '4196970' => 'e4196970',
    '4196971' => 'e4196971',
    '4196972' => 'e4196972',
    '4196973' => 'e4196973',
    '4196974' => 'e4196974',
    '4196975' => 'e4196975',
    '4196976' => 'e4196976',
    '4196977' => 'e4196977',
    '4196978' => 'e4196978',
    '4196979' => 'e4196979',
    '4196980' => 'e4196980',
    '4196981' => 'e4196981',
    '4196982' => 'e4196982',
    '4196983' => 'e4196983',
    '4196984' => 'e4196984',
    '4196985' => 'e4196985',
    '4196986' => 'e4196986',
    '4196987' => 'e4196987',
    '4196988' => 'e4196988',
    '4196989' => 'e4196989',
    '4196990' => 'e4196990',
    '4196991' => 'e4196991',
    '4196992' => 'e4196992',
    '4196993' => 'e4196993',
    '4196994' => 'e4196994',
    '4196995' => 'e4196995',
    '4196996' => 'e4196996',
    '4196997' => 'e4196997',
    '4196998' => 'e4196998',
    '4196999' => 'e4196999',
    '4197000' => 'e4197000',
    '4197001' => 'e4197001',
    '4197002' => 'e4197002',
    '4197003' => 'e4197003',
    '4197004' => 'e4197004',
    '4197005' => 'e4197005',
    '4197006' => 'e4197006',
    '4197007' => 'e4197007',
    '4197008' => 'e4197008',
    '4197009' => 'e4197009',
    '4197010' => 'e4197010',
    '4197011' => 'e4197011',
    '4197012' => 'e4197012',
    '4197013' => 'e4197013',
    '4197014' => 'e4197014',
    '4197015' => 'e4197015',
    '4197016' => 'e4197016',
    '4197017' => 'e4197017',
    '4197018' => 'e4197018',
    '4197019' => 'e4197019',
    '4197020' => 'e4197020',
    '4197021' => 'e4197021',
    '4197022' => 'e4197022',
    '4197023' => 'e4197023',
    '4197024' => 'e4197024',
    '4197025' => 'e4197025',
    '4197026' => 'e4197026',
    '4197027' => 'e4197027',
    '4197028' => 'e4197028',
    '4197029' => 'e4197029',
    '4197030' => 'e4197030',
    '4197031' => 'e4197031',
    '4197032' => 'e4197032',
    '4197033' => 'e4197033',
    '4197034' => 'e4197034',
    '4197035' => 'e4197035',
    '4197036' => 'e4197036',
    '4197037' => 'e4197037',
    '4197038' => 'e4197038',
    '4197039' => 'e4197039',
    '4197040' => 'e4197040',
    '4197041' => 'e4197041',
    '4197042' => 'e4197042',
    '4197043' => 'e4197043',
    '4197044' => 'e4197044',
    '4197045' => 'e4197045',
    '4197046' => 'e4197046',
    '4197047' => 'e4197047',
    '4197048' => 'e4197048',
    '4197049' => 'e4197049',
    '4197050' => 'e4197050',
    '4197051' => 'e4197051',
    '4197052' => 'e4197052',
    '4197053' => 'e4197053',
    '4197054' => 'e4197054',
    '4197055' => 'e4197055',
    '4197056' => 'e4197056',
    '4197057' => 'e4197057',
    '4197058' => 'e4197058',
    '4197059' => 'e4197059',
    '4197060' => 'e4197060',
    '4197061' => 'e4197061',
    '4197062' => 'e4197062',
    '4197063' => 'e4197063',
    '4197064' => 'e4197064',
    '4197065' => 'e4197065',
    '4197066' => 'e4197066',
    '4197067' => 'e4197067',
    '4197068' => 'e4197068',
    '4197069' => 'e4197069',
    '4197070' => 'e4197070',
    '4197071' => 'e4197071',
    '4197072' => 'e4197072',
    '4197073' => 'e4197073',
    '4197074' => 'e4197074',
    '4197075' => 'e4197075',
    '4197076' => 'e4197076',
    '4197077' => 'e4197077',
    '4197078' => 'e4197078',
    '4197079' => 'e4197079',
    '4197080' => 'e4197080',
    '4197081' => 'e4197081',
    '4197082' => 'e4197082',
    '4197083' => 'e4197083',
    '4197084' => 'e4197084',
    '4197085' => 'e4197085',
    '4197086' => 'e4197086',
    '4197087' => 'e4197087',
    '4197088' => 'e4197088',
    '4197089' => 'e4197089',
    '4197090' => 'e4197090',
    '4197091' => 'e4197091',
    '4197092' => 'e4197092',
    '4197093' => 'e4197093',
    '4197094' => 'e4197094',
    '4197095' => 'e4197095',
    '4197096' => 'e4197096',
    '4197097' => 'e4197097',
    '4197098' => 'e4197098',
    '4197099' => 'e4197099',
    '4197100' => 'e4197100',
    '4197101' => 'e4197101',
    '4197102' => 'e4197102',
    '4197103' => 'e4197103',
    '4197104' => 'e4197104',
    '4197105' => 'e4197105',
    '4197106' => 'e4197106',
    '4197107' => 'e4197107',
    '4197108' => 'e4197108',
    '4197109' => 'e4197109',
    '4197110' => 'e4197110',
    '4197111' => 'e4197111',
    '4197112' => 'e4197112',
    '4197113' => 'e4197113',
    '4197114' => 'e4197114',
    '4197115' => 'e4197115',
    '4197116' => 'e4197116',
    '4197117' => 'e4197117',
    '4197118' => 'e4197118',
    '4197119' => 'e4197119',
    '4197120' => 'e4197120',
    '4197121' => 'e4197121',
    '4197122' => 'e4197122',
    '4197123' => 'e4197123',
    '4197124' => 'e4197124',
    '4197125' => 'e4197125',
    '4197126' => 'e4197126',
    '4197127' => 'e4197127',
    '4197128' => 'e4197128',
    '4197129' => 'e4197129',
    '4197130' => 'e4197130',
    '4197131' => 'e4197131',
    '4197132' => 'e4197132',
    '4197133' => 'e4197133',
    '4197134' => 'e4197134',
    '4197135' => 'e4197135',
    '4197136' => 'e4197136',
    '4197137' => 'e4197137',
    '4197138' => 'e4197138',
    '4197139' => 'e4197139',
    '4197140' => 'e4197140',
    '4197141' => 'e4197141',
    '4197142' => 'e4197142',
    '4197143' => 'e4197143',
    '4197144' => 'e4197144',
    '4197145' => 'e4197145',
    '4197146' => 'e4197146',
    '4197147' => 'e4197147',
    '4197148' => 'e4197148',
    '4197149' => 'e4197149',
    '4197150' => 'e4197150',
    '4197151' => 'e4197151',
    '4197152' => 'e4197152',
    '4197153' => 'e4197153',
    '4197154' => 'e4197154',
    '4197155' => 'e4197155',
    '4197156' => 'e4197156',
    '4197157' => 'e4197157',
    '4197158' => 'e4197158',
    '4197159' => 'e4197159',
    '4197160' => 'e4197160',
    '4197161' => 'e4197161',
    '4197162' => 'e4197162',
    '4197163' => 'e4197163',
    '4197164' => 'e4197164',
    '4197165' => 'e4197165',
    '4197166' => 'e4197166',
    '4197167' => 'e4197167',
    '4197168' => 'e4197168',
    '4197169' => 'e4197169',
    '4197170' => 'e4197170',
    '4197171' => 'e4197171',
    '4197172' => 'e4197172',
    '4197173' => 'e4197173',
    '4197174' => 'e4197174',
    '4197175' => 'e4197175',
    '4197176' => 'e4197176',
    '4197177' => 'e4197177',
    '4197178' => 'e4197178',
    '4197179' => 'e4197179',
    '4197180' => 'e4197180',
    '4197181' => 'e4197181',
    '4197182' => 'e4197182',
    '4197183' => 'e4197183',
    '4197184' => 'e4197184',
    '4197185' => 'e4197185',
    '4197186' => 'e4197186',
    '4197187' => 'e4197187',
    '4197188' => 'e4197188',
    '4197189' => 'e4197189',
    '4197190' => 'e4197190',
    '4197191' => 'e4197191',
    '4197192' => 'e4197192',
    '4197193' => 'e4197193',
    '4197194' => 'e4197194',
    '4197195' => 'e4197195',
    '4197196' => 'e4197196',
    '4197197' => 'e4197197',
    '4197198' => 'e4197198',
    '4197199' => 'e4197199',
    '4197200' => 'e4197200',
    '4197201' => 'e4197201',
    '4197202' => 'e4197202',
    '4197203' => 'e4197203',
    '4197204' => 'e4197204',
    '4197205' => 'e4197205',
    '4197206' => 'e4197206',
    '4197207' => 'e4197207',
    '4197208' => 'e4197208',
    '4197209' => 'e4197209',
    '4197210' => 'e4197210',
    '4197211' => 'e4197211',
    '4197212' => 'e4197212',
    '4197213' => 'e4197213',
    '4197214' => 'e4197214',
    '4197215' => 'e4197215',
    '4197216' => 'e4197216',
    '4197217' => 'e4197217',
    '4197218' => 'e4197218',
    '4197219' => 'e4197219',
    '4197220' => 'e4197220',
    '4197221' => 'e4197221',
    '4197222' => 'e4197222',
    '4197223' => 'e4197223',
    '4197224' => 'e4197224',
    '4197225' => 'e4197225',
    '4197226' => 'e4197226',
    '4197227' => 'e4197227',
    '4197228' => 'e4197228',
    '4197229' => 'e4197229',
    '4197230' => 'e4197230',
    '4197231' => 'e4197231',
    '4197232' => 'e4197232',
    '4197233' => 'e4197233',
    '4197234' => 'e4197234',
    '4197235' => 'e4197235',
    '4197236' => 'e4197236',
    '4197237' => 'e4197237',
    '4197238' => 'e4197238',
    '4197239' => 'e4197239',
    '4197240' => 'e4197240',
    '4197241' => 'e4197241',
    '4197242' => 'e4197242',
    '4197243' => 'e4197243',
    '4197244' => 'e4197244',
    '4197245' => 'e4197245',
    '4197246' => 'e4197246',
    '4197247' => 'e4197247',
    '4197248' => 'e4197248',
    '4197249' => 'e4197249',
    '4197250' => 'e4197250',
    '4197251' => 'e4197251',
    '4197252' => 'e4197252',
    '4197253' => 'e4197253',
    '4197254' => 'e4197254',
    '4197255' => 'e4197255',
    '4197256' => 'e4197256',
    '4197257' => 'e4197257',
    '4197258' => 'e4197258',
    '4197259' => 'e4197259',
    '4197260' => 'e4197260',
    '4197261' => 'e4197261',
    '4197262' => 'e4197262',
    '4197263' => 'e4197263',
    '4197264' => 'e4197264',
    '4197265' => 'e4197265',
    '4197266' => 'e4197266',
    '4197267' => 'e4197267',
    '4197268' => 'e4197268',
    '4197269' => 'e4197269',
    '4197270' => 'e4197270',
    '4197271' => 'e4197271',
    '4197272' => 'e4197272',
    '4197273' => 'e4197273',
    '4197274' => 'e4197274',
    '4197275' => 'e4197275',
    '4197276' => 'e4197276',
    '4197277' => 'e4197277',
    '4197278' => 'e4197278',
    '4197279' => 'e4197279',
    '4197280' => 'e4197280',
    '4197281' => 'e4197281',
    '4197282' => 'e4197282',
    '4197283' => 'e4197283',
    '4197284' => 'e4197284',
    '4197285' => 'e4197285',
    '4197286' => 'e4197286',
    '4197287' => 'e4197287',
    '4197288' => 'e4197288',
    '4197289' => 'e4197289',
    '4197290' => 'e4197290',
    '4197291' => 'e4197291',
    '4197292' => 'e4197292',
    '4197293' => 'e4197293',
    '4197294' => 'e4197294',
    '4197295' => 'e4197295',
    '4197296' => 'e4197296',
    '4197297' => 'e4197297',
    '4197298' => 'e4197298',
    '4197299' => 'e4197299',
    '4197300' => 'e4197300',
    '4197301' => 'e4197301',
    '4197302' => 'e4197302',
    '4197303' => 'e4197303',
    '4197304' => 'e4197304',
    '4197305' => 'e4197305',
    '4197306' => 'e4197306',
    '4197307' => 'e4197307',
    '4197308' => 'e4197308',
    '4197309' => 'e4197309',
    '4197310' => 'e4197310',
    '4197311' => 'e4197311',
    '4197312' => 'e4197312',
    '4197313' => 'e4197313',
    '4197314' => 'e4197314',
    '4197315' => 'e4197315',
    '4197316' => 'e4197316',
    '4197317' => 'e4197317',
    '4197318' => 'e4197318',
    '4197319' => 'e4197319',
    '4197320' => 'e4197320',
    '4197321' => 'e4197321',
    '4197322' => 'e4197322',
    '4197323' => 'e4197323',
    '4197324' => 'e4197324',
    '4197325' => 'e4197325',
    '4197326' => 'e4197326',
    '4197327' => 'e4197327',
    '4197328' => 'e4197328',
    '4197329' => 'e4197329',
    '4197330' => 'e4197330',
    '4197331' => 'e4197331',
    '4197332' => 'e4197332',
    '4197333' => 'e4197333',
    '4197334' => 'e4197334',
    '4197335' => 'e4197335',
    '4197336' => 'e4197336',
    '4197337' => 'e4197337',
    '4197338' => 'e4197338',
    '4197339' => 'e4197339',
    '4197340' => 'e4197340',
    '4197341' => 'e4197341',
    '4197342' => 'e4197342',
    '4197343' => 'e4197343',
    '4197344' => 'e4197344',
    '4197345' => 'e4197345',
    '4197346' => 'e4197346',
    '4197347' => 'e4197347',
    '4197348' => 'e4197348',
    '4197349' => 'e4197349',
    '4197350' => 'e4197350',
    '4197351' => 'e4197351',
    '4197352' => 'e4197352',
    '4197353' => 'e4197353',
    '4197354' => 'e4197354',
    '4197355' => 'e4197355',
    '4197356' => 'e4197356',
    '4197357' => 'e4197357',
    '4197358' => 'e4197358',
    '4197359' => 'e4197359',
    '4197360' => 'e4197360',
    '4197361' => 'e4197361',
    '4197362' => 'e4197362',
    '4197363' => 'e4197363',
    '4197364' => 'e4197364',
    '4197365' => 'e4197365',
    '4197366' => 'e4197366',
    '4197367' => 'e4197367',
    '4197368' => 'e4197368',
    '4197369' => 'e4197369',
    '4197370' => 'e4197370',
    '4197371' => 'e4197371',
    '4197422' => 'e4197422',
    '4197423' => 'e4197423',
    '4197424' => 'e4197424',
    '4197425' => 'e4197425',
    '4197426' => 'e4197426',
    '4197427' => 'e4197427',
    '4197428' => 'e4197428',
    '4197429' => 'e4197429',
    '4197430' => 'e4197430',
    '4197431' => 'e4197431',
    '4197432' => 'e4197432',
    '4197433' => 'e4197433',
    '4197434' => 'e4197434',
    '4197435' => 'e4197435',
    '4197436' => 'e4197436',
    '4197437' => 'e4197437',
    '4197438' => 'e4197438',
    '4197439' => 'e4197439',
    '4197440' => 'e4197440',
    '4197441' => 'e4197441',
    '4197442' => 'e4197442',
    '4197443' => 'e4197443',
    '4197444' => 'e4197444',
    '4197445' => 'e4197445',
    '4197446' => 'e4197446',
    '4197447' => 'e4197447',
    '4197448' => 'e4197448',
    '4197449' => 'e4197449',
    '4197450' => 'e4197450',
    '4197451' => 'e4197451',
    '4197452' => 'e4197452',
    '4197453' => 'e4197453',
    '4197454' => 'e4197454',
    '4197455' => 'e4197455',
    '4197456' => 'e4197456',
    '4197457' => 'e4197457',
    '4197458' => 'e4197458',
    '4197459' => 'e4197459',
    '4197460' => 'e4197460',
    '4197461' => 'e4197461',
    '4197462' => 'e4197462',
    '4197463' => 'e4197463',
    '4197464' => 'e4197464',
    '4197465' => 'e4197465',
    '4197466' => 'e4197466',
    '4197467' => 'e4197467',
    '4197468' => 'e4197468',
    '4197469' => 'e4197469',
    '4197470' => 'e4197470',
    '4197471' => 'e4197471',
    '4197472' => 'e4197472',
    '4197473' => 'e4197473',
    '4197474' => 'e4197474',
    '4197475' => 'e4197475',
    '4197476' => 'e4197476',
    '4197477' => 'e4197477',
    '4197478' => 'e4197478',
    '4197479' => 'e4197479',
    '4197480' => 'e4197480',
    '4197481' => 'e4197481',
    '4197482' => 'e4197482',
    '4197483' => 'e4197483',
    '4197484' => 'e4197484',
    '4197485' => 'e4197485',
    '4197486' => 'e4197486',
    '4197487' => 'e4197487',
    '4197488' => 'e4197488',
    '4197489' => 'e4197489',
    '4197490' => 'e4197490',
    '4197491' => 'e4197491',
    '4197492' => 'e4197492',
    '4197493' => 'e4197493',
    '4197494' => 'e4197494',
    '4197495' => 'e4197495',
    '4197496' => 'e4197496',
    '4197497' => 'e4197497',
    '4197498' => 'e4197498',
    '4197499' => 'e4197499',
    '4197500' => 'e4197500',
    '4197501' => 'e4197501',
    '4197502' => 'e4197502',
    '4197503' => 'e4197503',
    '4197504' => 'e4197504',
    '4197505' => 'e4197505',
    '4197506' => 'e4197506',
    '4197507' => 'e4197507',
    '4197508' => 'e4197508',
    '4197509' => 'e4197509',
    '4197510' => 'e4197510',
    '4197511' => 'e4197511',
    '4197512' => 'e4197512',
    '4197513' => 'e4197513',
    '4197514' => 'e4197514',
    '4197515' => 'e4197515',
    '4197516' => 'e4197516',
    '4197517' => 'e4197517',
    '4197518' => 'e4197518',
    '4197519' => 'e4197519',
    '4197520' => 'e4197520',
    '4197521' => 'e4197521',
    '4197522' => 'e4197522',
    '4197523' => 'e4197523',
    '4197524' => 'e4197524',
    '4197525' => 'e4197525',
    '4197526' => 'e4197526',
    '4197527' => 'e4197527',
    '4197528' => 'e4197528',
    '4197529' => 'e4197529',
    '4197530' => 'e4197530',
    '4197531' => 'e4197531',
    '4197532' => 'e4197532',
    '4197533' => 'e4197533',
    '4197534' => 'e4197534',
    '4197535' => 'e4197535',
    '4197536' => 'e4197536',
    '4197537' => 'e4197537',
    '4197538' => 'e4197538',
    '4197539' => 'e4197539',
    '4197540' => 'e4197540',
    '4197541' => 'e4197541',
    '4197542' => 'e4197542',
    '4197543' => 'e4197543',
    '4197544' => 'e4197544',
    '4197545' => 'e4197545',
    '4197546' => 'e4197546',
    '4197547' => 'e4197547',
    '4197548' => 'e4197548',
    '4197549' => 'e4197549',
    '4197550' => 'e4197550',
    '4197551' => 'e4197551',
    '4197552' => 'e4197552',
    '4197553' => 'e4197553',
    '4197554' => 'e4197554',
    '4197555' => 'e4197555',
    '4197556' => 'e4197556',
    '4197557' => 'e4197557',
    '4197558' => 'e4197558',
    '4197559' => 'e4197559',
    '4197560' => 'e4197560',
    '4197561' => 'e4197561',
    '4197562' => 'e4197562',
    '4197563' => 'e4197563',
    '4197564' => 'e4197564',
    '4197565' => 'e4197565',
    '4197566' => 'e4197566',
    '4197567' => 'e4197567',
    '4197568' => 'e4197568',
    '4197569' => 'e4197569',
    '4197570' => 'e4197570',
    '4197571' => 'e4197571',
    '4197572' => 'e4197572',
    '4197573' => 'e4197573',
    '4197574' => 'e4197574',
    '4197575' => 'e4197575',
    '4197576' => 'e4197576',
    '4197577' => 'e4197577',
    '4197578' => 'e4197578',
    '4197579' => 'e4197579',
    '4197580' => 'e4197580',
    '4197581' => 'e4197581',
    '4197582' => 'e4197582',
    '4197583' => 'e4197583',
    '4197584' => 'e4197584',
    '4197585' => 'e4197585',
    '4197586' => 'e4197586',
    '4197587' => 'e4197587',
    '4197588' => 'e4197588',
    '4197589' => 'e4197589',
    '4197590' => 'e4197590',
    '4197591' => 'e4197591',
    '4197592' => 'e4197592',
    '4197593' => 'e4197593',
    '4197594' => 'e4197594',
    '4197595' => 'e4197595',
    '4197596' => 'e4197596',
    '4197597' => 'e4197597',
    '4197598' => 'e4197598',
    '4197599' => 'e4197599',
    '4197600' => 'e4197600',
    '4197601' => 'e4197601',
    '4197602' => 'e4197602',
    '4197603' => 'e4197603',
    '4197604' => 'e4197604',
    '4197605' => 'e4197605',
    '4197606' => 'e4197606',
    '4197607' => 'e4197607',
    '4197608' => 'e4197608',
    '4197609' => 'e4197609',
    '4197610' => 'e4197610',
    '4197611' => 'e4197611',
    '4197612' => 'e4197612',
    '4197613' => 'e4197613',
    '4197614' => 'e4197614',
    '4197615' => 'e4197615',
    '4197616' => 'e4197616',
    '4197617' => 'e4197617',
    '4197618' => 'e4197618',
    '4197619' => 'e4197619',
    '4197620' => 'e4197620',
    '4197621' => 'e4197621',
    '4197622' => 'e4197622',
    '4197623' => 'e4197623',
    '4197624' => 'e4197624',
    '4197625' => 'e4197625',
    '4197626' => 'e4197626',
    '4197627' => 'e4197627',
    '4197628' => 'e4197628',
    '4197629' => 'e4197629',
    '4197630' => 'e4197630',
    '4197631' => 'e4197631',
    '4197632' => 'e4197632',
    '4197633' => 'e4197633',
    '4197634' => 'e4197634',
    '4197635' => 'e4197635',
    '4197636' => 'e4197636',
    '4197637' => 'e4197637',
    '4197638' => 'e4197638',
    '4197639' => 'e4197639',
    '4197640' => 'e4197640',
    '4197641' => 'e4197641',
    '4197642' => 'e4197642',
    '4197643' => 'e4197643',
    '4197644' => 'e4197644',
    '4197645' => 'e4197645',
    '4197646' => 'e4197646',
    '4197647' => 'e4197647',
    '4197648' => 'e4197648',
    '4197649' => 'e4197649',
    '4197650' => 'e4197650',
    '4197651' => 'e4197651',
    '4197652' => 'e4197652',
    '4197653' => 'e4197653',
    '4197654' => 'e4197654',
    '4197655' => 'e4197655',
    '4197656' => 'e4197656',
    '4197657' => 'e4197657',
    '4197658' => 'e4197658',
    '4197659' => 'e4197659',
    '4197660' => 'e4197660',
    '4197661' => 'e4197661',
    '4197662' => 'e4197662',
    '4197663' => 'e4197663',
    '4197664' => 'e4197664',
    '4197665' => 'e4197665',
    '4197666' => 'e4197666',
    '4197667' => 'e4197667',
    '4197668' => 'e4197668',
    '4197669' => 'e4197669',
    '4197670' => 'e4197670',
    '4197671' => 'e4197671',
    '4197672' => 'e4197672',
    '4197673' => 'e4197673',
    '4197674' => 'e4197674',
    '4197675' => 'e4197675',
    '4197676' => 'e4197676',
    '4197677' => 'e4197677',
    '4197678' => 'e4197678',
    '4197679' => 'e4197679',
    '4197680' => 'e4197680',
    '4197681' => 'e4197681',
    '4197682' => 'e4197682',
    '4197683' => 'e4197683',
    '4197684' => 'e4197684',
    '4197685' => 'e4197685',
    '4197686' => 'e4197686',
    '4197687' => 'e4197687',
    '4197688' => 'e4197688',
    '4197689' => 'e4197689',
    '4197690' => 'e4197690',
    '4197691' => 'e4197691',
    '4197692' => 'e4197692',
    '4197693' => 'e4197693',
    '4197694' => 'e4197694',
    '4197695' => 'e4197695',
    '4197696' => 'e4197696',
    '4197697' => 'e4197697',
    '4197698' => 'e4197698',
    '4197699' => 'e4197699',
    '4197700' => 'e4197700',
    '4197701' => 'e4197701',
    '4197702' => 'e4197702',
    '4197703' => 'e4197703',
    '4197704' => 'e4197704',
    '4197705' => 'e4197705',
    '4197706' => 'e4197706',
    '4197707' => 'e4197707',
    '4197708' => 'e4197708',
    '4197709' => 'e4197709',
    '4197710' => 'e4197710',
    '4197711' => 'e4197711',
    '4197712' => 'e4197712',
    '4197713' => 'e4197713',
    '4197714' => 'e4197714',
    '4197715' => 'e4197715',
    '4197716' => 'e4197716',
    '4197717' => 'e4197717',
    '4197718' => 'e4197718',
    '4197719' => 'e4197719',
    '4197720' => 'e4197720',
    '4197721' => 'e4197721',
    '4197722' => 'e4197722',
    '4197723' => 'e4197723',
    '4197724' => 'e4197724',
    '4197725' => 'e4197725',
    '4197726' => 'e4197726',
    '4197727' => 'e4197727',
    '4197728' => 'e4197728',
    '4197729' => 'e4197729',
    '4197730' => 'e4197730',
    '4197731' => 'e4197731',
    '4197732' => 'e4197732',
    '4197733' => 'e4197733',
    '4197734' => 'e4197734',
    '4197735' => 'e4197735',
    '4197736' => 'e4197736',
    '4197737' => 'e4197737',
    '4197738' => 'e4197738',
    '4197739' => 'e4197739',
    '4197740' => 'e4197740',
    '4197741' => 'e4197741',
    '4197742' => 'e4197742',
    '4197743' => 'e4197743',
    '4197744' => 'e4197744',
    '4197745' => 'e4197745',
    '4197746' => 'e4197746',
    '4197747' => 'e4197747',
    '4197748' => 'e4197748',
    '4197749' => 'e4197749',
    '4197750' => 'e4197750',
    '4197751' => 'e4197751',
    '4197752' => 'e4197752',
    '4197753' => 'e4197753',
    '4197754' => 'e4197754',
    '4197755' => 'e4197755',
    '4197756' => 'e4197756',
    '4197757' => 'e4197757',
    '4197758' => 'e4197758',
    '4197759' => 'e4197759',
    '4197760' => 'e4197760',
    '4197761' => 'e4197761',
    '4197762' => 'e4197762',
    '4197763' => 'e4197763',
    '4197764' => 'e4197764',
    '4197765' => 'e4197765',
    '4197766' => 'e4197766',
    '4197767' => 'e4197767',
    '4197768' => 'e4197768',
    '4197769' => 'e4197769',
    '4197770' => 'e4197770',
    '4197771' => 'e4197771',
    '4197772' => 'e4197772',
    '4197773' => 'e4197773',
    '4197774' => 'e4197774',
    '4197775' => 'e4197775',
    '4197776' => 'e4197776',
    '4197777' => 'e4197777',
    '4197778' => 'e4197778',
    '4197779' => 'e4197779',
    '4197780' => 'e4197780',
    '4197781' => 'e4197781',
    '4197782' => 'e4197782',
    '4197783' => 'e4197783',
    '4197784' => 'e4197784',
    '4197785' => 'e4197785',
    '4197786' => 'e4197786',
    '4197787' => 'e4197787',
    '4197788' => 'e4197788',
    '4197789' => 'e4197789',
    '4197790' => 'e4197790',
    '4197791' => 'e4197791',
    '4197792' => 'e4197792',
    '4197793' => 'e4197793',
    '4197794' => 'e4197794',
    '4197795' => 'e4197795',
    '4197796' => 'e4197796',
    '4197797' => 'e4197797',
    '4197798' => 'e4197798',
    '4197799' => 'e4197799',
    '4197800' => 'e4197800',
    '4197801' => 'e4197801',
    '4197802' => 'e4197802',
    '4197803' => 'e4197803',
    '4197804' => 'e4197804',
    '4197805' => 'e4197805',
    '4197806' => 'e4197806',
    '4197807' => 'e4197807',
    '4197808' => 'e4197808',
    '4197809' => 'e4197809',
    '4197810' => 'e4197810',
    '4197811' => 'e4197811',
    '4197812' => 'e4197812',
    '4197813' => 'e4197813',
    '4197814' => 'e4197814',
    '4197815' => 'e4197815',
    '4197816' => 'e4197816',
    '4197817' => 'e4197817',
    '4197818' => 'e4197818',
    '4197819' => 'e4197819',
    '4197820' => 'e4197820',
    '4197821' => 'e4197821',
    '4197822' => 'e4197822',
    '4197823' => 'e4197823',
    '4197824' => 'e4197824',
    '4197825' => 'e4197825',
    '4197826' => 'e4197826',
    '4197827' => 'e4197827',
    '4197828' => 'e4197828',
    '4197829' => 'e4197829',
    '4197830' => 'e4197830',
    '4197831' => 'e4197831',
    '4197832' => 'e4197832',
    '4197833' => 'e4197833',
    '4197834' => 'e4197834',
    '4197835' => 'e4197835',
    '4197836' => 'e4197836',
    '4197837' => 'e4197837',
    '4197838' => 'e4197838',
    '4197839' => 'e4197839',
    '4197840' => 'e4197840',
    '4197841' => 'e4197841',
    '4197842' => 'e4197842',
    '4197843' => 'e4197843',
    '4197844' => 'e4197844',
    '4197845' => 'e4197845',
    '4197846' => 'e4197846',
    '4197847' => 'e4197847',
    '4197848' => 'e4197848',
    '4197849' => 'e4197849',
    '4197850' => 'e4197850',
    '4197851' => 'e4197851',
    '4197852' => 'e4197852',
    '4197853' => 'e4197853',
    '4197854' => 'e4197854',
    '4197855' => 'e4197855',
    '4197856' => 'e4197856',
    '4197857' => 'e4197857',
    '4197858' => 'e4197858',
    '4197859' => 'e4197859',
    '4197860' => 'e4197860',
    '4197861' => 'e4197861',
    '4197862' => 'e4197862',
    '4197863' => 'e4197863',
    '4197864' => 'e4197864',
    '4197865' => 'e4197865',
    '4197866' => 'e4197866',
    '4197867' => 'e4197867',
    '4197868' => 'e4197868',
    '4197869' => 'e4197869',
    '4197870' => 'e4197870',
    '4197871' => 'e4197871',
    '4197872' => 'e4197872',
    '4197873' => 'e4197873',
    '4197874' => 'e4197874',
    '4197875' => 'e4197875',
    '4197876' => 'e4197876',
    '4197877' => 'e4197877',
    '4197878' => 'e4197878',
    '4197879' => 'e4197879',
    '4197880' => 'e4197880',
    '4197881' => 'e4197881',
    '4197882' => 'e4197882',
    '4197883' => 'e4197883',
    '4197884' => 'e4197884',
    '4197885' => 'e4197885',
    '4197886' => 'e4197886',
    '4197887' => 'e4197887',
    '4197888' => 'e4197888',
    '4197889' => 'e4197889',
    '4197890' => 'e4197890',
    '4197891' => 'e4197891',
    '4197892' => 'e4197892',
    '4197893' => 'e4197893',
    '4197894' => 'e4197894',
    '4197895' => 'e4197895',
    '4197896' => 'e4197896',
    '4197897' => 'e4197897',
    '4197898' => 'e4197898',
    '4197899' => 'e4197899',
    '4197900' => 'e4197900',
    '4197901' => 'e4197901',
    '4197902' => 'e4197902',
    '4197903' => 'e4197903',
    '4197904' => 'e4197904',
    '4197905' => 'e4197905',
    '4197906' => 'e4197906',
    '4197907' => 'e4197907',
    '4197908' => 'e4197908',
    '4197909' => 'e4197909',
    '4197910' => 'e4197910',
    '4197911' => 'e4197911',
    '4197912' => 'e4197912',
    '4197913' => 'e4197913',
    '4197914' => 'e4197914',
    '4197915' => 'e4197915',
    '4197916' => 'e4197916',
    '4197917' => 'e4197917',
    '4197918' => 'e4197918',
    '4197919' => 'e4197919',
    '4197920' => 'e4197920',
    '4197921' => 'e4197921',
    '4197922' => 'e4197922',
    '4197923' => 'e4197923',
    '4197924' => 'e4197924',
    '4197925' => 'e4197925',
    '4197926' => 'e4197926',
    '4197927' => 'e4197927',
    '4197928' => 'e4197928',
    '4197929' => 'e4197929',
    '4197930' => 'e4197930',
    '4197931' => 'e4197931',
    '4197932' => 'e4197932',
    '4197933' => 'e4197933',
    '4197934' => 'e4197934',
    '4197935' => 'e4197935',
    '4197936' => 'e4197936',
    '4197937' => 'e4197937',
    '4197938' => 'e4197938',
    '4197939' => 'e4197939',
    '4197940' => 'e4197940',
    '4197941' => 'e4197941',
    '4197942' => 'e4197942',
    '4197943' => 'e4197943',
    '4197944' => 'e4197944',
    '4197945' => 'e4197945',
    '4197946' => 'e4197946',
    '4197947' => 'e4197947',
    '4197948' => 'e4197948',
    '4197949' => 'e4197949',
    '4197950' => 'e4197950',
    '4197951' => 'e4197951',
    '4197952' => 'e4197952',
    '4197953' => 'e4197953',
    '4197954' => 'e4197954',
    '4197955' => 'e4197955',
    '4197956' => 'e4197956',
    '4197957' => 'e4197957',
    '4197958' => 'e4197958',
    '4197959' => 'e4197959',
    '4197960' => 'e4197960',
    '4197961' => 'e4197961',
    '4197962' => 'e4197962',
    '4197963' => 'e4197963',
    '4197964' => 'e4197964',
    '4197965' => 'e4197965',
    '4197966' => 'e4197966',
    '4197967' => 'e4197967',
    '4197968' => 'e4197968',
    '4197969' => 'e4197969',
    '4197970' => 'e4197970',
    '4197971' => 'e4197971',
    '4197972' => 'e4197972',
    '4197973' => 'e4197973',
    '4197974' => 'e4197974',
    '4197975' => 'e4197975',
    '4197976' => 'e4197976',
    '4197977' => 'e4197977',
    '4197978' => 'e4197978',
    '4197979' => 'e4197979',
    '4197980' => 'e4197980',
    '4197981' => 'e4197981',
    '4197982' => 'e4197982',
    '4197983' => 'e4197983',
    '4197984' => 'e4197984',
    '4197985' => 'e4197985',
    '4197986' => 'e4197986',
    '4197987' => 'e4197987',
    '4197988' => 'e4197988',
    '4197989' => 'e4197989',
    '4197990' => 'e4197990',
    '4197991' => 'e4197991',
    '4197992' => 'e4197992',
    '4197993' => 'e4197993',
    '4197994' => 'e4197994',
    '4197995' => 'e4197995',
    '4197996' => 'e4197996',
    '4197997' => 'e4197997',
    '4197998' => 'e4197998',
    '4197999' => 'e4197999',
    '4198000' => 'e4198000',
    '4198001' => 'e4198001',
    '4198002' => 'e4198002',
    '4198003' => 'e4198003',
    '4198004' => 'e4198004',
    '4198005' => 'e4198005',
    '4198006' => 'e4198006',
    '4198007' => 'e4198007',
    '4198008' => 'e4198008',
    '4198009' => 'e4198009',
    '4198010' => 'e4198010',
    '4198011' => 'e4198011',
    '4198012' => 'e4198012',
    '4198013' => 'e4198013',
    '4198014' => 'e4198014',
    '4198015' => 'e4198015',
    '4198016' => 'e4198016',
    '4198017' => 'e4198017',
    '4198018' => 'e4198018',
    '4198019' => 'e4198019',
    '4198020' => 'e4198020',
    '4198021' => 'e4198021',
    '4198022' => 'e4198022',
    '4198023' => 'e4198023',
    '4198024' => 'e4198024',
    '4198025' => 'e4198025',
    '4198026' => 'e4198026',
    '4198027' => 'e4198027',
    '4198028' => 'e4198028',
    '4198029' => 'e4198029',
    '4198030' => 'e4198030',
    '4198031' => 'e4198031',
    '4198032' => 'e4198032',
    '4198033' => 'e4198033',
    '4198034' => 'e4198034',
    '4198035' => 'e4198035',
    '4198036' => 'e4198036',
    '4198037' => 'e4198037',
    '4198038' => 'e4198038',
    '4198039' => 'e4198039',
    '4198040' => 'e4198040',
    '4198041' => 'e4198041',
    '4198042' => 'e4198042',
    '4198043' => 'e4198043',
    '4198044' => 'e4198044',
    '4198045' => 'e4198045',
    '4198046' => 'e4198046',
    '4198047' => 'e4198047',
    '4198048' => 'e4198048',
    '4198049' => 'e4198049',
    '4198050' => 'e4198050',
    '4198051' => 'e4198051',
    '4198052' => 'e4198052',
    '4198053' => 'e4198053',
    '4198054' => 'e4198054',
    '4198055' => 'e4198055',
    '4198056' => 'e4198056',
    '4198057' => 'e4198057',
    '4198058' => 'e4198058',
    '4198059' => 'e4198059',
    '4198060' => 'e4198060',
    '4198061' => 'e4198061',
    '4198062' => 'e4198062',
    '4198063' => 'e4198063',
    '4198064' => 'e4198064',
    '4198065' => 'e4198065',
    '4198066' => 'e4198066',
    '4198067' => 'e4198067',
    '4198068' => 'e4198068',
    '4198069' => 'e4198069',
    '4198070' => 'e4198070',
    '4198071' => 'e4198071',
    '4198072' => 'e4198072',
    '4198073' => 'e4198073',
    '4198074' => 'e4198074',
    '4198075' => 'e4198075',
    '4198076' => 'e4198076',
    '4198077' => 'e4198077',
    '4198078' => 'e4198078',
    '4198079' => 'e4198079',
    '4198080' => 'e4198080',
    '4198081' => 'e4198081',
    '4198082' => 'e4198082',
    '4198083' => 'e4198083',
    '4198084' => 'e4198084',
    '4198085' => 'e4198085',
    '4198086' => 'e4198086',
    '4198087' => 'e4198087',
    '4198088' => 'e4198088',
    '4198089' => 'e4198089',
    '4198090' => 'e4198090',
    '4198091' => 'e4198091',
    '4198092' => 'e4198092',
    '4198093' => 'e4198093',
    '4198094' => 'e4198094',
    '4198095' => 'e4198095',
    '4198096' => 'e4198096',
    '4198097' => 'e4198097',
    '4198098' => 'e4198098',
    '4198099' => 'e4198099',
    '4198100' => 'e4198100',
    '4198101' => 'e4198101',
    '4198102' => 'e4198102',
    '4198103' => 'e4198103',
    '4198104' => 'e4198104',
    '4198105' => 'e4198105',
    '4198106' => 'e4198106',
    '4198107' => 'e4198107',
    '4198108' => 'e4198108',
    '4198109' => 'e4198109',
    '4198110' => 'e4198110',
    '4198111' => 'e4198111',
    '4198112' => 'e4198112',
    '4198113' => 'e4198113',
    '4198114' => 'e4198114',
    '4198115' => 'e4198115',
    '4198116' => 'e4198116',
    '4198117' => 'e4198117',
    '4198118' => 'e4198118',
    '4198119' => 'e4198119',
    '4198120' => 'e4198120',
    '4198121' => 'e4198121',
    '4198122' => 'e4198122',
    '4198123' => 'e4198123',
    '4198124' => 'e4198124',
    '4198125' => 'e4198125',
    '4198126' => 'e4198126',
    '4198127' => 'e4198127',
    '4198128' => 'e4198128',
    '4198129' => 'e4198129',
    '4198130' => 'e4198130',
    '4198131' => 'e4198131',
    '4198132' => 'e4198132',
    '4198133' => 'e4198133',
    '4198134' => 'e4198134',
    '4198135' => 'e4198135',
    '4198136' => 'e4198136',
    '4198137' => 'e4198137',
    '4198138' => 'e4198138',
    '4198139' => 'e4198139',
    '4198140' => 'e4198140',
    '4198141' => 'e4198141',
    '4198142' => 'e4198142',
    '4198143' => 'e4198143',
    '4198144' => 'e4198144',
    '4198145' => 'e4198145',
    '4198146' => 'e4198146',
    '4198147' => 'e4198147',
    '4198148' => 'e4198148',
    '4198149' => 'e4198149',
    '4198150' => 'e4198150',
    '4198151' => 'e4198151',
    '4198152' => 'e4198152',
    '4198153' => 'e4198153',
    '4198154' => 'e4198154',
    '4198155' => 'e4198155',
    '4198156' => 'e4198156',
    '4198157' => 'e4198157',
    '4198158' => 'e4198158',
    '4198159' => 'e4198159',
    '4198160' => 'e4198160',
    '4198161' => 'e4198161',
    '4198162' => 'e4198162',
    '4198163' => 'e4198163',
    '4198164' => 'e4198164',
    '4198165' => 'e4198165',
    '4198166' => 'e4198166',
    '4198167' => 'e4198167',
    '4198168' => 'e4198168',
    '4198169' => 'e4198169',
    '4198170' => 'e4198170',
    '4198171' => 'e4198171',
    '4198172' => 'e4198172',
    '4198173' => 'e4198173',
    '4198174' => 'e4198174',
    '4198175' => 'e4198175',
    '4198176' => 'e4198176',
    '4198177' => 'e4198177',
    '4198178' => 'e4198178',
    '4198179' => 'e4198179',
    '4198180' => 'e4198180',
    '4198181' => 'e4198181',
    '4198182' => 'e4198182',
    '4198183' => 'e4198183',
    '4198184' => 'e4198184',
    '4198185' => 'e4198185',
    '4198186' => 'e4198186',
    '4198187' => 'e4198187',
    '4198188' => 'e4198188',
    '4198189' => 'e4198189',
    '4198190' => 'e4198190',
    '4198191' => 'e4198191',
    '4198192' => 'e4198192',
    '4198193' => 'e4198193',
    '4198194' => 'e4198194',
    '4198195' => 'e4198195',
    '4198196' => 'e4198196',
    '4198197' => 'e4198197',
    '4198198' => 'e4198198',
    '4198199' => 'e4198199',
    '4198200' => 'e4198200',
    '4198201' => 'e4198201',
    '4198202' => 'e4198202',
    '4198203' => 'e4198203',
    '4198204' => 'e4198204',
    '4198205' => 'e4198205',
    '4198206' => 'e4198206',
    '4198207' => 'e4198207',
    '4198208' => 'e4198208',
    '4198209' => 'e4198209',
    '4198210' => 'e4198210',
    '4198211' => 'e4198211',
    '4198212' => 'e4198212',
    '4198213' => 'e4198213',
    '4198214' => 'e4198214',
    '4198215' => 'e4198215',
    '4198216' => 'e4198216',
    '4198217' => 'e4198217',
    '4198218' => 'e4198218',
    '4198219' => 'e4198219',
    '4198220' => 'e4198220',
    '4198221' => 'e4198221',
    '4198222' => 'e4198222',
    '4198223' => 'e4198223',
    '4198224' => 'e4198224',
    '4198225' => 'e4198225',
    '4198226' => 'e4198226',
    '4198227' => 'e4198227',
    '4198228' => 'e4198228',
    '4198229' => 'e4198229',
    '4198230' => 'e4198230',
    '4198231' => 'e4198231',
    '4198232' => 'e4198232',
    '4198233' => 'e4198233',
    '4198234' => 'e4198234',
    '4198235' => 'e4198235',
    '4198236' => 'e4198236',
    '4198237' => 'e4198237',
    '4198238' => 'e4198238',
    '4198239' => 'e4198239',
    '4198240' => 'e4198240',
    '4198241' => 'e4198241',
    '4198242' => 'e4198242',
    '4198243' => 'e4198243',
    '4198244' => 'e4198244',
    '4198245' => 'e4198245',
    '4198246' => 'e4198246',
    '4198247' => 'e4198247',
    '4198248' => 'e4198248',
    '4198249' => 'e4198249',
    '4198250' => 'e4198250',
    '4198251' => 'e4198251',
    '4198252' => 'e4198252',
    '4198253' => 'e4198253',
    '4198254' => 'e4198254',
    '4198255' => 'e4198255',
    '4198256' => 'e4198256',
    '4198257' => 'e4198257',
    '4198258' => 'e4198258',
    '4198259' => 'e4198259',
    '4198260' => 'e4198260',
    '4198261' => 'e4198261',
    '4198262' => 'e4198262',
    '4198263' => 'e4198263',
    '4198264' => 'e4198264',
    '4198265' => 'e4198265',
    '4198266' => 'e4198266',
    '4198267' => 'e4198267',
    '4198268' => 'e4198268',
    '4198269' => 'e4198269',
    '4198270' => 'e4198270',
    '4198271' => 'e4198271',
    '4198272' => 'e4198272',
    '4198273' => 'e4198273',
    '4198274' => 'e4198274',
    '4198275' => 'e4198275',
    '4198276' => 'e4198276',
    '4198277' => 'e4198277',
    '4198278' => 'e4198278',
    '4198279' => 'e4198279',
    '4198280' => 'e4198280',
    '4198281' => 'e4198281',
    '4198282' => 'e4198282',
    '4198283' => 'e4198283',
    '4198284' => 'e4198284',
    '4198285' => 'e4198285',
    '4198286' => 'e4198286',
    '4198287' => 'e4198287',
    '4198288' => 'e4198288',
    '4198289' => 'e4198289',
    '4198290' => 'e4198290',
    '4198291' => 'e4198291',
    '4198292' => 'e4198292',
    '4198293' => 'e4198293',
    '4198294' => 'e4198294',
    '4198295' => 'e4198295',
    '4198296' => 'e4198296',
    '4198297' => 'e4198297',
    '4198298' => 'e4198298',
    '4198299' => 'e4198299',
    '4198300' => 'e4198300',
    '4198301' => 'e4198301',
    '4198302' => 'e4198302',
    '4198303' => 'e4198303',
    '4198304' => 'e4198304',
    '4198305' => 'e4198305',
    '4198306' => 'e4198306',
    '4198307' => 'e4198307',
    '4198308' => 'e4198308',
    '4198309' => 'e4198309',
    '4198310' => 'e4198310',
    '4198311' => 'e4198311',
    '4198312' => 'e4198312',
    '4198313' => 'e4198313',
    '4198314' => 'e4198314',
    '4198315' => 'e4198315',
    '4198316' => 'e4198316',
    '4198317' => 'e4198317',
    '4198318' => 'e4198318',
    '4198319' => 'e4198319',
    '4198320' => 'e4198320',
    '4198321' => 'e4198321',
    '4198322' => 'e4198322',
    '4198323' => 'e4198323',
    '4198324' => 'e4198324',
    '4198325' => 'e4198325',
    '4198326' => 'e4198326',
    '4198327' => 'e4198327',
    '4198328' => 'e4198328',
    '4198329' => 'e4198329',
    '4198330' => 'e4198330',
    '4198331' => 'e4198331',
    '4198332' => 'e4198332',
    '4198333' => 'e4198333',
    '4198334' => 'e4198334',
    '4198335' => 'e4198335',
    '4198336' => 'e4198336',
    '4198337' => 'e4198337',
    '4198338' => 'e4198338',
    '4198339' => 'e4198339',
    '4198340' => 'e4198340',
    '4198341' => 'e4198341',
    '4198342' => 'e4198342',
    '4198343' => 'e4198343',
    '4198344' => 'e4198344',
    '4198345' => 'e4198345',
    '4198346' => 'e4198346',
    '4198347' => 'e4198347',
    '4198348' => 'e4198348',
    '4198349' => 'e4198349',
    '4198350' => 'e4198350',
    '4198351' => 'e4198351',
    '4198352' => 'e4198352',
    '4198353' => 'e4198353',
    '4198354' => 'e4198354',
    '4198355' => 'e4198355',
    '4198356' => 'e4198356',
    '4198357' => 'e4198357',
    '4198358' => 'e4198358',
    '4198359' => 'e4198359',
    '4198360' => 'e4198360',
    '4198361' => 'e4198361',
    '4198362' => 'e4198362',
    '4198363' => 'e4198363',
    '4198364' => 'e4198364',
    '4198365' => 'e4198365',
    '4198366' => 'e4198366',
    '4198367' => 'e4198367',
    '4198368' => 'e4198368',
    '4198369' => 'e4198369',
    '4198370' => 'e4198370',
    '4198371' => 'e4198371',
    '4198372' => 'e4198372',
    '4198373' => 'e4198373',
    '4198374' => 'e4198374',
    '4198375' => 'e4198375',
    '4198376' => 'e4198376',
    '4198377' => 'e4198377',
    '4198378' => 'e4198378',
    '4198379' => 'e4198379',
    '4198380' => 'e4198380',
    '4198381' => 'e4198381',
    '4198382' => 'e4198382',
    '4198383' => 'e4198383',
    '4198384' => 'e4198384',
    '4198385' => 'e4198385',
    '4198386' => 'e4198386',
    '4198387' => 'e4198387',
    '4198388' => 'e4198388',
    '4198389' => 'e4198389',
    '4198390' => 'e4198390',
    '4198391' => 'e4198391',
    '4198392' => 'e4198392',
    '4198393' => 'e4198393',
    '4198394' => 'e4198394',
    '4198395' => 'e4198395',
    '4198396' => 'e4198396',
    '4198397' => 'e4198397',
    '4198398' => 'e4198398',
    '4198399' => 'e4198399',
    '4198400' => 'e4198400',
    '4198401' => 'e4198401',
    '4198402' => 'e4198402',
    '4198403' => 'e4198403',
    '4198404' => 'e4198404',
    '4198405' => 'e4198405',
    '4198406' => 'e4198406',
    '4198407' => 'e4198407',
    '4198408' => 'e4198408',
    '4198409' => 'e4198409',
    '4198410' => 'e4198410',
    '4198411' => 'e4198411',
    '4198412' => 'e4198412',
    '4198413' => 'e4198413',
    '4198414' => 'e4198414',
    '4198415' => 'e4198415',
    '4198416' => 'e4198416',
    '4198417' => 'e4198417',
    '4198418' => 'e4198418',
    '4198419' => 'e4198419',
    '4522530' => 'f4522530',
    '4522532' => 'f4522532',
    '4522544' => 'f4522544',
    '4522556' => 'f4522556',
    '4522561' => 'f4522561',
    '4522588' => 'f4522588',
    '4522603' => 'f4522603',
    '4525234' => 'f4525234',
    '4525239' => 'f4525239',
    '4525240' => 'f4525240',
    '4525241' => 'f4525241',
    '4525247' => 'f4525247',
    '4525248' => 'f4525248',
    '4525250' => 'f4525250',
    '4525251' => 'f4525251',
    '4525252' => 'f4525252',
    '4525253' => 'f4525253',
    '4525254' => 'f4525254',
    '4526517' => 'f4526517',
    '4526850' => 'f4526850',
    '4526851' => 'f4526851',
    '4526901' => 'f4526901',
    '4526902' => 'f4526902',
    '4527601' => 'f4527601',
    '4528207' => 'f4528207',
    '4528209' => 'f4528209',
    '4528211' => 'f4528211',
    '4528216' => 'f4528216',
    '4528218' => 'f4528218',
    '4528220' => 'f4528220',
    '4528223' => 'f4528223',
    '4528225' => 'f4528225',
    '4528227' => 'f4528227',
    '4528268' => 'f4528268',
    '4528270' => 'f4528270',
    '4528591' => 'f4528591',
    '4528596' => 'f4528596',
    '4528842' => 'f4528842',
    '4529444' => 'f4529444',
    '4529447' => 'f4529447',
    '4529495' => 'f4529495',
    '4529514' => 'f4529514',
    '4529517' => 'f4529517',
    '4529520' => 'f4529520',
    '4529522' => 'f4529522',
    '4529524' => 'f4529524',
    '4529533' => 'f4529533',
    '4529601' => 'f4529601',
    '4529604' => 'f4529604',
    '4529606' => 'f4529606',
    '4529615' => 'f4529615',
    '4529722' => 'f4529722',
    '4529725' => 'f4529725',
    '4529838' => 'f4529838',
    '4529847' => 'f4529847',
    '4529849' => 'f4529849',
    '4529971' => 'f4529971',
    '4529973' => 'f4529973',
    '4530046' => 'f4530046',
    '4530050' => 'f4530050',
    '4530080' => 'f4530080',
    '4530082' => 'f4530082',
    '4530083' => 'f4530083',
    '4530085' => 'f4530085',
    '4530092' => 'f4530092',
    '4530095' => 'f4530095',
    '4530097' => 'f4530097',
    '4530098' => 'f4530098',
    '4530100' => 'f4530100',
    '4530106' => 'f4530106',
    '4530109' => 'f4530109',
    '4530111' => 'f4530111',
    '4530112' => 'f4530112',
    '4530113' => 'f4530113',
    '4530114' => 'f4530114',
    '4530115' => 'f4530115',
    '4530117' => 'f4530117',
    '4530119' => 'f4530119',
    '4530121' => 'f4530121',
    '4530122' => 'f4530122',
    '4530123' => 'f4530123',
    '4530125' => 'f4530125',
    '4530127' => 'f4530127',
    '4530139' => 'f4530139',
    '4530143' => 'f4530143',
    '4530166' => 'f4530166',
    '4530204' => 'f4530204',
    '4530206' => 'f4530206',
    '4530389' => 'f4530389',
    '4530391' => 'f4530391',
    '4530407' => 'f4530407',
    '4530451' => 'f4530451',
    '4530727' => 'f4530727',
    '4531222' => 'f4531222',
    '4531275' => 'f4531275',
    '4531400' => 'f4531400',
    '4531404' => 'f4531404',
    '4531414' => 'f4531414',
    '4531419' => 'f4531419',
    '4531518' => 'f4531518',
    '4531578' => 'f4531578',
    '4531580' => 'f4531580',
    '4531707' => 'f4531707',
    '4531711' => 'f4531711',
    '4531714' => 'f4531714',
    '4531768' => 'f4531768',
    '4531770' => 'f4531770',
    '4531775' => 'f4531775',
    '4531796' => 'f4531796',
    '4531810' => 'f4531810',
    '4531828' => 'f4531828',
    '4531835' => 'f4531835',
    '4531839' => 'f4531839',
    '4531844' => 'f4531844',
    '4532089' => 'f4532089',
    '4532091' => 'f4532091',
    '4532099' => 'f4532099',
    '4532135' => 'f4532135',
    '4532137' => 'f4532137',
    '4532169' => 'f4532169',
    '4532171' => 'f4532171',
    '4532175' => 'f4532175',
    '4532236' => 'f4532236',
    '4532238' => 'f4532238',
    '4532685' => 'f4532685',
    '4532844' => 'f4532844',
    '4532850' => 'f4532850',
    '4532852' => 'f4532852',
    '4532854' => 'f4532854',
    '4532856' => 'f4532856',
    '4532859' => 'f4532859',
    '4532861' => 'f4532861',
    '4532863' => 'f4532863',
    '4532865' => 'f4532865',
    '4532871' => 'f4532871',
    '4532898' => 'f4532898',
    '4532900' => 'f4532900',
    '4532906' => 'f4532906',
    '4532915' => 'f4532915',
    '4532917' => 'f4532917',
    '4532919' => 'f4532919',
    '4532921' => 'f4532921',
    '4532925' => 'f4532925',
    '4532935' => 'f4532935',
    '4532954' => 'f4532954',
    '4532969' => 'f4532969',
    '4532988' => 'f4532988',
    '4533006' => 'f4533006',
    '4533008' => 'f4533008',
    '4533010' => 'f4533010',
    '4533059' => 'f4533059',
    '4533061' => 'f4533061',
    '4533226' => 'f4533226',
    '4533245' => 'f4533245',
    '4533247' => 'f4533247',
    '4534475' => 'f4534475',
    '4534477' => 'f4534477',
    '4534557' => 'f4534557',
    '4534797' => 'f4534797',
    '4534807' => 'f4534807',
    '4534811' => 'f4534811',
    '4534813' => 'f4534813',
    '4534826' => 'f4534826',
    '4534831' => 'f4534831',
    '4534833' => 'f4534833',
    '4535084' => 'f4535084',
    '4535086' => 'f4535086',
    '4535111' => 'f4535111',
    '4535173' => 'f4535173',
    '4535189' => 'f4535189',
    '10000005' => 'f10000005',
    '10000033' => 'f10000033',
    '10000034' => 'f10000034',
    '10000035' => 'f10000035',
    '10000190' => 'f10000190',
    '10000191' => 'f10000191',
    '10000192' => 'f10000192',
    '10000193' => 'f10000193',
    '10000194' => 'f10000194',
    '10000195' => 'f10000195',
    '10000196' => 'f10000196',
    '10000198' => 'f10000198',
    '10000200' => 'f10000200',
    '10000207' => 'f10000207',
    '10000208' => 'f10000208',
    '10000209' => 'f10000209',
    '10000210' => 'f10000210',
    '10000212' => 'f10000212',
    '10000241' => 'f10000241',
    '10000242' => 'f10000242',
    '10000261' => 'f10000261',
    '10000262' => 'f10000262',
    '10000263' => 'f10000263',
    '10000336' => 'f10000336',
    '10000337' => 'f10000337',
    '10000338' => 'f10000338',
    '10000339' => 'f10000339',
    '10000362' => 'f10000362',
    '10000363' => 'f10000363',
    '10000364' => 'f10000364',
    '10000365' => 'f10000365',
    '10000366' => 'f10000366',
    '10000367' => 'f10000367',
    '10000368' => 'f10000368',
    '10000369' => 'f10000369',
    '10000370' => 'f10000370',
    '10000372' => 'f10000372',
    '10000373' => 'f10000373',
    '10000374' => 'f10000374',
    '10000375' => 'f10000375',
    '10000376' => 'f10000376',
    '10000377' => 'f10000377',
    '10000378' => 'f10000378',
    '10000379' => 'f10000379',
    '10000388' => 'f10000388',
    '10000389' => 'f10000389',
    '10000390' => 'f10000390',
    '10000391' => 'f10000391',
    '10000392' => 'f10000392',
    '10000393' => 'f10000393',
    '10000394' => 'f10000394',
    '10000396' => 'f10000396',
    '10000397' => 'f10000397',
    '10000398' => 'f10000398',
    '10000399' => 'f10000399',
    '10000400' => 'f10000400',
    '10000401' => 'f10000401',
    '10000402' => 'f10000402',
    '10000403' => 'f10000403',
    '10000404' => 'f10000404',
    '10000405' => 'f10000405',
    '10000406' => 'f10000406',
    '10000407' => 'f10000407',
    '10000536' => 'f10000536',
    '10000557' => 'f10000557',
    '10000558' => 'f10000558',
    '10000571' => 'f10000571',
    '10000572' => 'f10000572',
    '10000573' => 'f10000573',
    '10000574' => 'f10000574',
    '10000575' => 'f10000575',
    '10000576' => 'f10000576',
    '10000591' => 'f10000591',
    '10000592' => 'f10000592',
    '10000593' => 'f10000593',
    '10000594' => 'f10000594',
    '10000595' => 'f10000595',
    '10000596' => 'f10000596',
    '10000597' => 'f10000597',
    '10000598' => 'f10000598',
    '10000616' => 'f10000616',
    '10000634' => 'f10000634',
    '10000644' => 'f10000644',
    '10000645' => 'f10000645',
    '10000656' => 'f10000656',
    '10000657' => 'f10000657',
    '10000658' => 'f10000658',
    '10000659' => 'f10000659',
    '10000660' => 'f10000660',
    '10000661' => 'f10000661',
    '10000662' => 'f10000662',
    '10000663' => 'f10000663',
    '10000689' => 'f10000689',
    '10000690' => 'f10000690',
    '10000750' => 'f10000750',
    '10000793' => 'f10000793',
    '10000794' => 'f10000794',
    '10000795' => 'f10000795',
    '10000796' => 'f10000796',
    '10000797' => 'f10000797',
    '10000798' => 'f10000798',
    '10000799' => 'f10000799',
    '10000800' => 'f10000800',
    '10000842' => 'f10000842',
    '10000843' => 'f10000843',
    '10000844' => 'f10000844',
    '10000845' => 'f10000845',
    '10000846' => 'f10000846',
    '10000878' => 'f10000878',
    '10000990' => 'f10000990',
    '10001023' => 'f10001023',
    '10001124' => 'f10001124',
    '10016392' => 'f10016392',
    '10016394' => 'f10016394',
    '10016395' => 'f10016395',
    '10016396' => 'f10016396',
    '10016397' => 'f10016397',
    '10016398' => 'f10016398',
    '10016399' => 'f10016399',
    '10016400' => 'f10016400',
    '10016411' => 'f10016411',
    '10016412' => 'f10016412',
    '10016415' => 'f10016415',
    '10016416' => 'f10016416',
    '10016421' => 'f10016421',
    '10016422' => 'f10016422',
    '10016424' => 'f10016424',
    '10016426' => 'f10016426',
    '10016427' => 'f10016427',
    '10016441' => 'f10016441',
    '10016442' => 'f10016442',
    '10016504' => 'f10016504',
    '10016510' => 'f10016510',
    '10016511' => 'f10016511',
    '10016512' => 'f10016512',
    '10016513' => 'f10016513',
    '10016515' => 'f10016515',
    '10016518' => 'f10016518',
    '10016532' => 'f10016532',
    '10016533' => 'f10016533',
    '10016534' => 'f10016534',
    '10016535' => 'f10016535',
    '10016536' => 'f10016536',
    '10016537' => 'f10016537',
    '10016538' => 'f10016538',
    '10016539' => 'f10016539',
    '10016540' => 'f10016540',
    '10016541' => 'f10016541',
    '10016542' => 'f10016542',
    '10016543' => 'f10016543',
    '10016544' => 'f10016544',
    '10016545' => 'f10016545',
    '10016546' => 'f10016546',
    '10016601' => 'f10016601',
    '10016602' => 'f10016602',
    '10016607' => 'f10016607',
    '10016608' => 'f10016608',
    '10016609' => 'f10016609',
    '10016623' => 'f10016623',
    '10016624' => 'f10016624',
    '10016639' => 'f10016639',
    '10016643' => 'f10016643',
    '10016725' => 'f10016725',
    '10016726' => 'f10016726',
    '10016727' => 'f10016727',
    '10016728' => 'f10016728',
    '10016729' => 'f10016729',
    '10016742' => 'f10016742',
    '10016743' => 'f10016743',
    '10016744' => 'f10016744',
    '10016745' => 'f10016745',
    '10016764' => 'f10016764',
    '10016769' => 'f10016769',
    '10016770' => 'f10016770',
    '10016771' => 'f10016771',
    '10016779' => 'f10016779',
    '10016793' => 'f10016793',
    '10016794' => 'f10016794',
    '10016800' => 'f10016800',
    '10016808' => 'f10016808',
    '10016998' => 'f10016998',
    '10017011' => 'f10017011',
    '10017032' => 'f10017032',
    '10017035' => 'f10017035',
    '10017151' => 'f10017151',
    '10017152' => 'f10017152',
    '10017164' => 'f10017164',
    '10017165' => 'f10017165',
    '10017166' => 'f10017166',
    '10017167' => 'f10017167',
    '10017259' => 'f10017259',
    '10017261' => 'f10017261',
    '10017312' => 'f10017312',
    '10017371' => 'f10017371',
    '10017372' => 'f10017372',
    '10017373' => 'f10017373',
    '10017420' => 'f10017420',
    '10017421' => 'f10017421',
    '10017422' => 'f10017422',
    '10017423' => 'f10017423',
    '10017424' => 'f10017424',
    '10017425' => 'f10017425',
    '10017426' => 'f10017426',
    '10017444' => 'f10017444',
    '10017451' => 'f10017451',
    '10017473' => 'f10017473',
    '10017474' => 'f10017474',
    '10017479' => 'f10017479',
    '10034971' => 'f10034971',
    '10034973' => 'f10034973',
    '10034974' => 'f10034974',
    '10034975' => 'f10034975',
    '10034979' => 'f10034979',
    '10034981' => 'f10034981',
    '10034982' => 'f10034982',
    '10034983' => 'f10034983',
    '10034987' => 'f10034987',
    '10034989' => 'f10034989',
    '10034990' => 'f10034990',
    '10034991' => 'f10034991',
    '10034995' => 'f10034995',
    '10034997' => 'f10034997',
    '10034998' => 'f10034998',
    '10034999' => 'f10034999',
    '10035003' => 'f10035003',
    '10035005' => 'f10035005',
    '10035006' => 'f10035006',
    '10035007' => 'f10035007',
    '10035011' => 'f10035011',
    '10035013' => 'f10035013',
    '10035014' => 'f10035014',
    '10035015' => 'f10035015',
    '10035019' => 'f10035019',
    '10035021' => 'f10035021',
    '10035022' => 'f10035022',
    '10035023' => 'f10035023',
    '10035027' => 'f10035027',
    '10035029' => 'f10035029',
    '10035030' => 'f10035030',
    '10035031' => 'f10035031',
    '10035037' => 'f10035037',
    '10035039' => 'f10035039',
    '10035040' => 'f10035040',
    '10035041' => 'f10035041',
    '10035045' => 'f10035045',
    '10035047' => 'f10035047',
    '10035048' => 'f10035048',
    '10035049' => 'f10035049',
    '10035053' => 'f10035053',
    '10035055' => 'f10035055',
    '10035056' => 'f10035056',
    '10035057' => 'f10035057',
    '10035063' => 'f10035063',
    '10035065' => 'f10035065',
    '10035066' => 'f10035066',
    '10035067' => 'f10035067',
    '10035071' => 'f10035071',
    '10035073' => 'f10035073',
    '10035079' => 'f10035079',
    '10035080' => 'f10035080',
    '10035084' => 'f10035084',
    '10035086' => 'f10035086',
    '10035087' => 'f10035087',
    '10035088' => 'f10035088',
    '10035094' => 'f10035094',
    '10035096' => 'f10035096',
    '10035097' => 'f10035097',
    '10035098' => 'f10035098',
    '10035105' => 'f10035105',
    '10035107' => 'f10035107',
    '10035108' => 'f10035108',
    '10035109' => 'f10035109',
    '10035113' => 'f10035113',
    '10035115' => 'f10035115',
    '10035116' => 'f10035116',
    '10035117' => 'f10035117',
    '10035121' => 'f10035121',
    '10035123' => 'f10035123',
    '10035124' => 'f10035124',
    '10035125' => 'f10035125',
    '10035131' => 'f10035131',
    '10035133' => 'f10035133',
    '10035134' => 'f10035134',
    '10035135' => 'f10035135',
    '10035141' => 'f10035141',
    '10035143' => 'f10035143',
    '10035144' => 'f10035144',
    '10035145' => 'f10035145',
    '10035151' => 'f10035151',
    '10035153' => 'f10035153',
    '10035154' => 'f10035154',
    '10035155' => 'f10035155',
    '10035161' => 'f10035161',
    '10035163' => 'f10035163',
    '10035164' => 'f10035164',
    '10035165' => 'f10035165',
    '10035166' => 'f10035166',
    '10035171' => 'f10035171',
    '10035173' => 'f10035173',
    '10035174' => 'f10035174',
    '10035175' => 'f10035175',
    '10035176' => 'f10035176',
    '10035181' => 'f10035181',
    '10035183' => 'f10035183',
    '10035184' => 'f10035184',
    '10035185' => 'f10035185',
    '10035186' => 'f10035186',
    '10035191' => 'f10035191',
    '10035193' => 'f10035193',
    '10035194' => 'f10035194',
    '10035195' => 'f10035195',
    '10035196' => 'f10035196',
    '10035216' => 'f10035216',
    '10035217' => 'f10035217',
    '10035218' => 'f10035218',
    '10035219' => 'f10035219',
    '10035226' => 'f10035226',
    '10035227' => 'f10035227',
    '10035228' => 'f10035228',
    '10035229' => 'f10035229',
    '10035236' => 'f10035236',
    '10035237' => 'f10035237',
    '10035238' => 'f10035238',
    '10035239' => 'f10035239',
    '10035246' => 'f10035246',
    '10035247' => 'f10035247',
    '10035248' => 'f10035248',
    '10035249' => 'f10035249',
    '10035256' => 'f10035256',
    '10035257' => 'f10035257',
    '10035258' => 'f10035258',
    '10035259' => 'f10035259',
    '10035266' => 'f10035266',
    '10035267' => 'f10035267',
    '10035268' => 'f10035268',
    '10035269' => 'f10035269',
    '10035279' => 'f10035279',
    '10035280' => 'f10035280',
    '10035281' => 'f10035281',
    '10035282' => 'f10035282',
    '10035289' => 'f10035289',
    '10035290' => 'f10035290',
    '10035291' => 'f10035291',
    '10035292' => 'f10035292',
    '10035299' => 'f10035299',
    '10035300' => 'f10035300',
    '10035301' => 'f10035301',
    '10035302' => 'f10035302',
    '10035309' => 'f10035309',
    '10035310' => 'f10035310',
    '10035311' => 'f10035311',
    '10035312' => 'f10035312',
    '10035319' => 'f10035319',
    '10035320' => 'f10035320',
    '10035321' => 'f10035321',
    '10035322' => 'f10035322',
    '10035329' => 'f10035329',
    '10035330' => 'f10035330',
    '10035331' => 'f10035331',
    '10035332' => 'f10035332',
    '10035342' => 'f10035342',
    '10035343' => 'f10035343',
    '10035344' => 'f10035344',
    '10035345' => 'f10035345',
    '10035352' => 'f10035352',
    '10035353' => 'f10035353',
    '10035354' => 'f10035354',
    '10035355' => 'f10035355',
    '10035362' => 'f10035362',
    '10035363' => 'f10035363',
    '10035364' => 'f10035364',
    '10035365' => 'f10035365',
    '10035372' => 'f10035372',
    '10035373' => 'f10035373',
    '10035374' => 'f10035374',
    '10035375' => 'f10035375',
    '10035382' => 'f10035382',
    '10035383' => 'f10035383',
    '10035384' => 'f10035384',
    '10035385' => 'f10035385',
    '10035392' => 'f10035392',
    '10035393' => 'f10035393',
    '10035394' => 'f10035394',
    '10035395' => 'f10035395',
    '10035402' => 'f10035402',
    '10035403' => 'f10035403',
    '10035404' => 'f10035404',
    '10035405' => 'f10035405',
    '10035419' => 'f10035419',
    '10035420' => 'f10035420',
    '10035421' => 'f10035421',
    '10035422' => 'f10035422',
    '10035429' => 'f10035429',
    '10035430' => 'f10035430',
    '10035431' => 'f10035431',
    '10035432' => 'f10035432',
    '10035439' => 'f10035439',
    '10035440' => 'f10035440',
    '10035441' => 'f10035441',
    '10035442' => 'f10035442',
    '10035449' => 'f10035449',
    '10035450' => 'f10035450',
    '10035451' => 'f10035451',
    '10035452' => 'f10035452',
    '10035459' => 'f10035459',
    '10035460' => 'f10035460',
    '10035461' => 'f10035461',
    '10035462' => 'f10035462',
    '10035472' => 'f10035472',
    '10035473' => 'f10035473',
    '10035474' => 'f10035474',
    '10035475' => 'f10035475',
    '10035482' => 'f10035482',
    '10035483' => 'f10035483',
    '10035484' => 'f10035484',
    '10035485' => 'f10035485',
    '10035492' => 'f10035492',
    '10035493' => 'f10035493',
    '10035494' => 'f10035494',
    '10035495' => 'f10035495',
    '10035505' => 'f10035505',
    '10035506' => 'f10035506',
    '10035507' => 'f10035507',
    '10035508' => 'f10035508',
    '10035515' => 'f10035515',
    '10035516' => 'f10035516',
    '10035517' => 'f10035517',
    '10035518' => 'f10035518',
    '10035525' => 'f10035525',
    '10035526' => 'f10035526',
    '10035527' => 'f10035527',
    '10035528' => 'f10035528',
    '10035537' => 'f10035537',
    '10035538' => 'f10035538',
    '10035539' => 'f10035539',
    '10035540' => 'f10035540',
    '10035547' => 'f10035547',
    '10035548' => 'f10035548',
    '10035549' => 'f10035549',
    '10035550' => 'f10035550',
    '10035557' => 'f10035557',
    '10035558' => 'f10035558',
    '10035559' => 'f10035559',
    '10035560' => 'f10035560',
    '10035567' => 'f10035567',
    '10035568' => 'f10035568',
    '10035569' => 'f10035569',
    '10035570' => 'f10035570',
    '10035579' => 'f10035579',
    '10035580' => 'f10035580',
    '10035581' => 'f10035581',
    '10035582' => 'f10035582',
    '10035589' => 'f10035589',
    '10035590' => 'f10035590',
    '10035591' => 'f10035591',
    '10035592' => 'f10035592',
    '10035599' => 'f10035599',
    '10035600' => 'f10035600',
    '10035601' => 'f10035601',
    '10035602' => 'f10035602',
    '10035609' => 'f10035609',
    '10035610' => 'f10035610',
    '10035611' => 'f10035611',
    '10035612' => 'f10035612',
    '10035619' => 'f10035619',
    '10035620' => 'f10035620',
    '10035621' => 'f10035621',
    '10035622' => 'f10035622',
    '10035629' => 'f10035629',
    '10035630' => 'f10035630',
    '10035631' => 'f10035631',
    '10035632' => 'f10035632',
    '10035639' => 'f10035639',
    '10035640' => 'f10035640',
    '10035641' => 'f10035641',
    '10035642' => 'f10035642',
    '10035649' => 'f10035649',
    '10035650' => 'f10035650',
    '10035651' => 'f10035651',
    '10035652' => 'f10035652',
    '10035664' => 'f10035664',
    '10035666' => 'f10035666',
    '10035667' => 'f10035667',
    '10035669' => 'f10035669',
    '10035678' => 'f10035678',
    '10035679' => 'f10035679',
    '10035680' => 'f10035680',
    '10035681' => 'f10035681',
    '10035691' => 'f10035691',
    '10035693' => 'f10035693',
    '10035694' => 'f10035694',
    '10035695' => 'f10035695',
    '10035703' => 'f10035703',
    '10035704' => 'f10035704',
    '10035705' => 'f10035705',
    '10035706' => 'f10035706',
    '10035713' => 'f10035713',
    '10035714' => 'f10035714',
    '10035715' => 'f10035715',
    '10035716' => 'f10035716',
    '10035725' => 'f10035725',
    '10035726' => 'f10035726',
    '10035727' => 'f10035727',
    '10035728' => 'f10035728',
    '10035737' => 'f10035737',
    '10035739' => 'f10035739',
    '10035740' => 'f10035740',
    '10035742' => 'f10035742',
    '10035759' => 'f10035759',
    '10035760' => 'f10035760',
    '10035761' => 'f10035761',
    '10035762' => 'f10035762',
    '10035769' => 'f10035769',
    '10035770' => 'f10035770',
    '10035771' => 'f10035771',
    '10035772' => 'f10035772',
    '10035779' => 'f10035779',
    '10035780' => 'f10035780',
    '10035781' => 'f10035781',
    '10035782' => 'f10035782',
    '10035789' => 'f10035789',
    '10035790' => 'f10035790',
    '10035791' => 'f10035791',
    '10035792' => 'f10035792',
    '10035802' => 'f10035802',
    '10035803' => 'f10035803',
    '10035804' => 'f10035804',
    '10035805' => 'f10035805',
    '10035812' => 'f10035812',
    '10035813' => 'f10035813',
    '10035814' => 'f10035814',
    '10035815' => 'f10035815',
    '10035822' => 'f10035822',
    '10035823' => 'f10035823',
    '10035824' => 'f10035824',
    '10035825' => 'f10035825',
    '10035832' => 'f10035832',
    '10035833' => 'f10035833',
    '10035834' => 'f10035834',
    '10035835' => 'f10035835',
    '10035845' => 'f10035845',
    '10035846' => 'f10035846',
    '10035847' => 'f10035847',
    '10035848' => 'f10035848',
    '10035855' => 'f10035855',
    '10035856' => 'f10035856',
    '10035857' => 'f10035857',
    '10035858' => 'f10035858',
    '10035865' => 'f10035865',
    '10035866' => 'f10035866',
    '10035867' => 'f10035867',
    '10035868' => 'f10035868',
    '10035878' => 'f10035878',
    '10035879' => 'f10035879',
    '10035880' => 'f10035880',
    '10035881' => 'f10035881',
    '10035888' => 'f10035888',
    '10035889' => 'f10035889',
    '10035890' => 'f10035890',
    '10035891' => 'f10035891',
    '10035898' => 'f10035898',
    '10035899' => 'f10035899',
    '10035900' => 'f10035900',
    '10035901' => 'f10035901',
    '10035908' => 'f10035908',
    '10035909' => 'f10035909',
    '10035910' => 'f10035910',
    '10035911' => 'f10035911',
    '10035918' => 'f10035918',
    '10035919' => 'f10035919',
    '10035920' => 'f10035920',
    '10035921' => 'f10035921',
    '10035931' => 'f10035931',
    '10035932' => 'f10035932',
    '10035933' => 'f10035933',
    '10035934' => 'f10035934',
    '10035941' => 'f10035941',
    '10035942' => 'f10035942',
    '10035943' => 'f10035943',
    '10035944' => 'f10035944',
    '10035951' => 'f10035951',
    '10035952' => 'f10035952',
    '10035953' => 'f10035953',
    '10035954' => 'f10035954',
    '10035961' => 'f10035961',
    '10035962' => 'f10035962',
    '10035963' => 'f10035963',
    '10035964' => 'f10035964',
    '10035974' => 'f10035974',
    '10035975' => 'f10035975',
    '10035976' => 'f10035976',
    '10035977' => 'f10035977',
    '10035984' => 'f10035984',
    '10035985' => 'f10035985',
    '10035986' => 'f10035986',
    '10035987' => 'f10035987',
    '10035994' => 'f10035994',
    '10035995' => 'f10035995',
    '10035996' => 'f10035996',
    '10035997' => 'f10035997',
    '10036004' => 'f10036004',
    '10036005' => 'f10036005',
    '10036006' => 'f10036006',
    '10036007' => 'f10036007',
    '10036018' => 'f10036018',
    '10036019' => 'f10036019',
    '10036020' => 'f10036020',
    '10036021' => 'f10036021',
    '10036028' => 'f10036028',
    '10036029' => 'f10036029',
    '10036030' => 'f10036030',
    '10036031' => 'f10036031',
    '10036038' => 'f10036038',
    '10036039' => 'f10036039',
    '10036040' => 'f10036040',
    '10036041' => 'f10036041',
    '10036048' => 'f10036048',
    '10036049' => 'f10036049',
    '10036050' => 'f10036050',
    '10036051' => 'f10036051',
    '10036062' => 'f10036062',
    '10036063' => 'f10036063',
    '10036064' => 'f10036064',
    '10036065' => 'f10036065',
    '10036072' => 'f10036072',
    '10036073' => 'f10036073',
    '10036074' => 'f10036074',
    '10036075' => 'f10036075',
    '10036082' => 'f10036082',
    '10036083' => 'f10036083',
    '10036084' => 'f10036084',
    '10036085' => 'f10036085',
    '10036092' => 'f10036092',
    '10036093' => 'f10036093',
    '10036094' => 'f10036094',
    '10036095' => 'f10036095',
    '10036105' => 'f10036105',
    '10036106' => 'f10036106',
    '10036107' => 'f10036107',
    '10036108' => 'f10036108',
    '10036115' => 'f10036115',
    '10036116' => 'f10036116',
    '10036117' => 'f10036117',
    '10036118' => 'f10036118',
    '10036125' => 'f10036125',
    '10036126' => 'f10036126',
    '10036127' => 'f10036127',
    '10036128' => 'f10036128',
    '10036135' => 'f10036135',
    '10036136' => 'f10036136',
    '10036137' => 'f10036137',
    '10036138' => 'f10036138',
    '10036145' => 'f10036145',
    '10036146' => 'f10036146',
    '10036147' => 'f10036147',
    '10036148' => 'f10036148',
    '10036158' => 'f10036158',
    '10036159' => 'f10036159',
    '10036160' => 'f10036160',
    '10036161' => 'f10036161',
    '10036168' => 'f10036168',
    '10036169' => 'f10036169',
    '10036170' => 'f10036170',
    '10036171' => 'f10036171',
    '10036178' => 'f10036178',
    '10036179' => 'f10036179',
    '10036180' => 'f10036180',
    '10036181' => 'f10036181',
    '10036188' => 'f10036188',
    '10036189' => 'f10036189',
    '10036190' => 'f10036190',
    '10036191' => 'f10036191',
    '10036201' => 'f10036201',
    '10036202' => 'f10036202',
    '10036203' => 'f10036203',
    '10036204' => 'f10036204',
    '10036211' => 'f10036211',
    '10036212' => 'f10036212',
    '10036213' => 'f10036213',
    '10036214' => 'f10036214',
    '10036221' => 'f10036221',
    '10036222' => 'f10036222',
    '10036223' => 'f10036223',
    '10036224' => 'f10036224',
    '10036231' => 'f10036231',
    '10036232' => 'f10036232',
    '10036233' => 'f10036233',
    '10036234' => 'f10036234',
    '10036244' => 'f10036244',
    '10036245' => 'f10036245',
    '10036246' => 'f10036246',
    '10036247' => 'f10036247',
    '10036254' => 'f10036254',
    '10036255' => 'f10036255',
    '10036256' => 'f10036256',
    '10036257' => 'f10036257',
    '10036264' => 'f10036264',
    '10036265' => 'f10036265',
    '10036266' => 'f10036266',
    '10036267' => 'f10036267',
    '10036274' => 'f10036274',
    '10036275' => 'f10036275',
    '10036276' => 'f10036276',
    '10036277' => 'f10036277',
    '10036286' => 'f10036286',
    '10036287' => 'f10036287',
    '10036288' => 'f10036288',
    '10036289' => 'f10036289',
    '10036296' => 'f10036296',
    '10036297' => 'f10036297',
    '10036298' => 'f10036298',
    '10036299' => 'f10036299',
    '10036306' => 'f10036306',
    '10036307' => 'f10036307',
    '10036308' => 'f10036308',
    '10036309' => 'f10036309',
    '10036316' => 'f10036316',
    '10036317' => 'f10036317',
    '10036318' => 'f10036318',
    '10036319' => 'f10036319',
    '10036326' => 'f10036326',
    '10036327' => 'f10036327',
    '10036328' => 'f10036328',
    '10036329' => 'f10036329',
    '10036336' => 'f10036336',
    '10036337' => 'f10036337',
    '10036338' => 'f10036338',
    '10036339' => 'f10036339',
    '10036346' => 'f10036346',
    '10036347' => 'f10036347',
    '10036348' => 'f10036348',
    '10036349' => 'f10036349',
    '10036356' => 'f10036356',
    '10036357' => 'f10036357',
    '10036358' => 'f10036358',
    '10036359' => 'f10036359',
    '10036368' => 'f10036368',
    '10036369' => 'f10036369',
    '10036370' => 'f10036370',
    '10036371' => 'f10036371',
    '10036378' => 'f10036378',
    '10036379' => 'f10036379',
    '10036380' => 'f10036380',
    '10036381' => 'f10036381',
    '10036388' => 'f10036388',
    '10036389' => 'f10036389',
    '10036390' => 'f10036390',
    '10036391' => 'f10036391',
    '10036398' => 'f10036398',
    '10036399' => 'f10036399',
    '10036400' => 'f10036400',
    '10036401' => 'f10036401',
    '10036411' => 'f10036411',
    '10036412' => 'f10036412',
    '10036413' => 'f10036413',
    '10036414' => 'f10036414',
    '10036421' => 'f10036421',
    '10036422' => 'f10036422',
    '10036423' => 'f10036423',
    '10036424' => 'f10036424',
    '10036431' => 'f10036431',
    '10036432' => 'f10036432',
    '10036433' => 'f10036433',
    '10036434' => 'f10036434',
    '10036441' => 'f10036441',
    '10036442' => 'f10036442',
    '10036443' => 'f10036443',
    '10036444' => 'f10036444',
    '10036451' => 'f10036451',
    '10036452' => 'f10036452',
    '10036453' => 'f10036453',
    '10036454' => 'f10036454',
    '10036461' => 'f10036461',
    '10036462' => 'f10036462',
    '10036463' => 'f10036463',
    '10036464' => 'f10036464',
    '10036471' => 'f10036471',
    '10036472' => 'f10036472',
    '10036473' => 'f10036473',
    '10036474' => 'f10036474',
    '10036481' => 'f10036481',
    '10036482' => 'f10036482',
    '10036483' => 'f10036483',
    '10036484' => 'f10036484',
    '10036493' => 'f10036493',
    '10036494' => 'f10036494',
    '10036495' => 'f10036495',
    '10036496' => 'f10036496',
    '10036503' => 'f10036503',
    '10036504' => 'f10036504',
    '10036505' => 'f10036505',
    '10036506' => 'f10036506',
    '10036513' => 'f10036513',
    '10036514' => 'f10036514',
    '10036515' => 'f10036515',
    '10036516' => 'f10036516',
    '10036523' => 'f10036523',
    '10036524' => 'f10036524',
    '10036525' => 'f10036525',
    '10036526' => 'f10036526',
    '10036535' => 'f10036535',
    '10036536' => 'f10036536',
    '10036537' => 'f10036537',
    '10036538' => 'f10036538',
    '10036545' => 'f10036545',
    '10036546' => 'f10036546',
    '10036547' => 'f10036547',
    '10036548' => 'f10036548',
    '10036555' => 'f10036555',
    '10036556' => 'f10036556',
    '10036557' => 'f10036557',
    '10036558' => 'f10036558',
    '10036565' => 'f10036565',
    '10036566' => 'f10036566',
    '10036567' => 'f10036567',
    '10036568' => 'f10036568',
    '10036575' => 'f10036575',
    '10036576' => 'f10036576',
    '10036577' => 'f10036577',
    '10036578' => 'f10036578',
    '10036585' => 'f10036585',
    '10036586' => 'f10036586',
    '10036587' => 'f10036587',
    '10036588' => 'f10036588',
    '10036595' => 'f10036595',
    '10036596' => 'f10036596',
    '10036597' => 'f10036597',
    '10036598' => 'f10036598',
    '10036605' => 'f10036605',
    '10036606' => 'f10036606',
    '10036607' => 'f10036607',
    '10036608' => 'f10036608',
    '10036615' => 'f10036615',
    '10036616' => 'f10036616',
    '10036617' => 'f10036617',
    '10036618' => 'f10036618',
    '10036625' => 'f10036625',
    '10036626' => 'f10036626',
    '10036627' => 'f10036627',
    '10036628' => 'f10036628',
    '10036637' => 'f10036637',
    '10036638' => 'f10036638',
    '10036639' => 'f10036639',
    '10036640' => 'f10036640',
    '10036647' => 'f10036647',
    '10036648' => 'f10036648',
    '10036649' => 'f10036649',
    '10036650' => 'f10036650',
    '10036657' => 'f10036657',
    '10036658' => 'f10036658',
    '10036659' => 'f10036659',
    '10036660' => 'f10036660',
    '10036667' => 'f10036667',
    '10036668' => 'f10036668',
    '10036669' => 'f10036669',
    '10036671' => 'f10036671',
    '10036679' => 'f10036679',
    '10036680' => 'f10036680',
    '10036681' => 'f10036681',
    '10036682' => 'f10036682',
    '10036690' => 'f10036690',
    '10036691' => 'f10036691',
    '10036692' => 'f10036692',
    '10036693' => 'f10036693',
    '10036702' => 'f10036702',
    '10036703' => 'f10036703',
    '10036704' => 'f10036704',
    '10036705' => 'f10036705',
    '10036712' => 'f10036712',
    '10036713' => 'f10036713',
    '10036714' => 'f10036714',
    '10036715' => 'f10036715',
    '10036723' => 'f10036723',
    '10036724' => 'f10036724',
    '10036725' => 'f10036725',
    '10036726' => 'f10036726',
    '10036734' => 'f10036734',
    '10036735' => 'f10036735',
    '10036736' => 'f10036736',
    '10036737' => 'f10036737',
    '10036745' => 'f10036745',
    '10036746' => 'f10036746',
    '10036747' => 'f10036747',
    '10036748' => 'f10036748',
    '10036756' => 'f10036756',
    '10036757' => 'f10036757',
    '10036758' => 'f10036758',
    '10036759' => 'f10036759',
    '10036770' => 'f10036770',
    '10036772' => 'f10036772',
    '10036773' => 'f10036773',
    '10036774' => 'f10036774',
    '10036782' => 'f10036782',
    '10036783' => 'f10036783',
    '10036784' => 'f10036784',
    '10036785' => 'f10036785',
    '10036794' => 'f10036794',
    '10036795' => 'f10036795',
    '10036796' => 'f10036796',
    '10036797' => 'f10036797',
    '10036805' => 'f10036805',
    '10036806' => 'f10036806',
    '10036807' => 'f10036807',
    '10036808' => 'f10036808',
    '10036816' => 'f10036816',
    '10036817' => 'f10036817',
    '10036818' => 'f10036818',
    '10036819' => 'f10036819',
    '10036826' => 'f10036826',
    '10036827' => 'f10036827',
    '10036828' => 'f10036828',
    '10036829' => 'f10036829',
    '10036836' => 'f10036836',
    '10036837' => 'f10036837',
    '10036838' => 'f10036838',
    '10036839' => 'f10036839',
    '10036846' => 'f10036846',
    '10036847' => 'f10036847',
    '10036848' => 'f10036848',
    '10036849' => 'f10036849',
    '10036856' => 'f10036856',
    '10036857' => 'f10036857',
    '10036858' => 'f10036858',
    '10036859' => 'f10036859',
    '10036868' => 'f10036868',
    '10036869' => 'f10036869',
    '10036870' => 'f10036870',
    '10036871' => 'f10036871',
    '10036878' => 'f10036878',
    '10036879' => 'f10036879',
    '10036880' => 'f10036880',
    '10036881' => 'f10036881',
    '10036888' => 'f10036888',
    '10036889' => 'f10036889',
    '10036890' => 'f10036890',
    '10036891' => 'f10036891',
    '10036898' => 'f10036898',
    '10036899' => 'f10036899',
    '10036900' => 'f10036900',
    '10036901' => 'f10036901',
    '10036908' => 'f10036908',
    '10036909' => 'f10036909',
    '10036910' => 'f10036910',
    '10036911' => 'f10036911',
    '10036919' => 'f10036919',
    '10036920' => 'f10036920',
    '10036921' => 'f10036921',
    '10036922' => 'f10036922',
    '10036929' => 'f10036929',
    '10036930' => 'f10036930',
    '10036931' => 'f10036931',
    '10036932' => 'f10036932',
    '10036939' => 'f10036939',
    '10036940' => 'f10036940',
    '10036941' => 'f10036941',
    '10036942' => 'f10036942',
    '10036951' => 'f10036951',
    '10036952' => 'f10036952',
    '10036953' => 'f10036953',
    '10036954' => 'f10036954',
    '10036961' => 'f10036961',
    '10036962' => 'f10036962',
    '10036963' => 'f10036963',
    '10036964' => 'f10036964',
    '10036971' => 'f10036971',
    '10036972' => 'f10036972',
    '10036973' => 'f10036973',
    '10036974' => 'f10036974',
    '10036983' => 'f10036983',
    '10036984' => 'f10036984',
    '10036985' => 'f10036985',
    '10036986' => 'f10036986',
    '10036993' => 'f10036993',
    '10036994' => 'f10036994',
    '10036995' => 'f10036995',
    '10036996' => 'f10036996',
    '10037003' => 'f10037003',
    '10037004' => 'f10037004',
    '10037005' => 'f10037005',
    '10037006' => 'f10037006',
    '10037013' => 'f10037013',
    '10037014' => 'f10037014',
    '10037015' => 'f10037015',
    '10037016' => 'f10037016',
    '10037023' => 'f10037023',
    '10037024' => 'f10037024',
    '10037025' => 'f10037025',
    '10037026' => 'f10037026',
    '10037033' => 'f10037033',
    '10037034' => 'f10037034',
    '10037035' => 'f10037035',
    '10037036' => 'f10037036',
    '10037043' => 'f10037043',
    '10037044' => 'f10037044',
    '10037045' => 'f10037045',
    '10037046' => 'f10037046',
    '10037053' => 'f10037053',
    '10037054' => 'f10037054',
    '10037055' => 'f10037055',
    '10037056' => 'f10037056',
    '10037063' => 'f10037063',
    '10037065' => 'f10037065',
    '10037066' => 'f10037066',
    '10037067' => 'f10037067',
    '10037071' => 'f10037071',
    '10037073' => 'f10037073',
    '10037074' => 'f10037074',
    '10037075' => 'f10037075',
    '10037081' => 'f10037081',
    '10037083' => 'f10037083',
    '10037084' => 'f10037084',
    '10037085' => 'f10037085',
    '10037089' => 'f10037089',
    '10037091' => 'f10037091',
    '10037092' => 'f10037092',
    '10037093' => 'f10037093',
    '10037099' => 'f10037099',
    '10037101' => 'f10037101',
    '10037102' => 'f10037102',
    '10037103' => 'f10037103',
    '10037107' => 'f10037107',
    '10037109' => 'f10037109',
    '10037110' => 'f10037110',
    '10037111' => 'f10037111',
    '10037115' => 'f10037115',
    '10037117' => 'f10037117',
    '10037118' => 'f10037118',
    '10037119' => 'f10037119',
    '10037123' => 'f10037123',
    '10037125' => 'f10037125',
    '10037126' => 'f10037126',
    '10037127' => 'f10037127',
    '10037131' => 'f10037131',
    '10037133' => 'f10037133',
    '10037134' => 'f10037134',
    '10037135' => 'f10037135',
    '10037139' => 'f10037139',
    '10037141' => 'f10037141',
    '10037142' => 'f10037142',
    '10037143' => 'f10037143',
    '10037151' => 'f10037151',
    '10037153' => 'f10037153',
    '10037154' => 'f10037154',
    '10037155' => 'f10037155',
    '10037159' => 'f10037159',
    '10037161' => 'f10037161',
    '10037162' => 'f10037162',
    '10037163' => 'f10037163',
    '10037167' => 'f10037167',
    '10037169' => 'f10037169',
    '10037170' => 'f10037170',
    '10037171' => 'f10037171',
    '10037178' => 'f10037178',
    '10037180' => 'f10037180',
    '10037181' => 'f10037181',
    '10037182' => 'f10037182',
    '10037186' => 'f10037186',
    '10037188' => 'f10037188',
    '10037189' => 'f10037189',
    '10037190' => 'f10037190',
    '10037194' => 'f10037194',
    '10037196' => 'f10037196',
    '10037197' => 'f10037197',
    '10037198' => 'f10037198',
    '10037205' => 'f10037205',
    '10037207' => 'f10037207',
    '10037208' => 'f10037208',
    '10037209' => 'f10037209',
    '10037215' => 'f10037215',
    '10037217' => 'f10037217',
    '10037218' => 'f10037218',
    '10037219' => 'f10037219',
    '10037225' => 'f10037225',
    '10037227' => 'f10037227',
    '10037228' => 'f10037228',
    '10037229' => 'f10037229',
    '10037233' => 'f10037233',
    '10037235' => 'f10037235',
    '10037236' => 'f10037236',
    '10037237' => 'f10037237',
    '10037242' => 'f10037242',
    '10037244' => 'f10037244',
    '10037245' => 'f10037245',
    '10037246' => 'f10037246',
    '10037252' => 'f10037252',
    '10037255' => 'f10037255',
    '10037256' => 'f10037256',
    '10037257' => 'f10037257',
    '10037262' => 'f10037262',
    '10037264' => 'f10037264',
    '10037265' => 'f10037265',
    '10037266' => 'f10037266',
    '10037275' => 'f10037275',
    '10037278' => 'f10037278',
    '10037279' => 'f10037279',
    '10037280' => 'f10037280',
    '10037284' => 'f10037284',
    '10037286' => 'f10037286',
    '10037287' => 'f10037287',
    '10037288' => 'f10037288',
    '10037292' => 'f10037292',
    '10037294' => 'f10037294',
    '10037295' => 'f10037295',
    '10037296' => 'f10037296',
    '10037300' => 'f10037300',
    '10037302' => 'f10037302',
    '10037303' => 'f10037303',
    '10037304' => 'f10037304',
    '10037310' => 'f10037310',
    '10037312' => 'f10037312',
    '10037313' => 'f10037313',
    '10037314' => 'f10037314',
    '10037318' => 'f10037318',
    '10037320' => 'f10037320',
    '10037321' => 'f10037321',
    '10037322' => 'f10037322',
    '10037326' => 'f10037326',
    '10037328' => 'f10037328',
    '10037329' => 'f10037329',
    '10037330' => 'f10037330',
    '10037337' => 'f10037337',
    '10037339' => 'f10037339',
    '10037340' => 'f10037340',
    '10037341' => 'f10037341',
    '10037345' => 'f10037345',
    '10037347' => 'f10037347',
    '10037348' => 'f10037348',
    '10037349' => 'f10037349',
    '10037353' => 'f10037353',
    '10037355' => 'f10037355',
    '10037356' => 'f10037356',
    '10037357' => 'f10037357',
    '10037361' => 'f10037361',
    '10037363' => 'f10037363',
    '10037364' => 'f10037364',
    '10037365' => 'f10037365',
    '10037369' => 'f10037369',
    '10037371' => 'f10037371',
    '10037372' => 'f10037372',
    '10037373' => 'f10037373',
    '10037377' => 'f10037377',
    '10037379' => 'f10037379',
    '10037380' => 'f10037380',
    '10037381' => 'f10037381',
    '10037387' => 'f10037387',
    '10037389' => 'f10037389',
    '10037390' => 'f10037390',
    '10037391' => 'f10037391',
    '10037395' => 'f10037395',
    '10037397' => 'f10037397',
    '10037398' => 'f10037398',
    '10037399' => 'f10037399',
    '10037406' => 'f10037406',
    '10037408' => 'f10037408',
    '10037409' => 'f10037409',
    '10037410' => 'f10037410',
    '10037416' => 'f10037416',
    '10037418' => 'f10037418',
    '10037419' => 'f10037419',
    '10037420' => 'f10037420',
    '10037430' => 'f10037430',
    '10037433' => 'f10037433',
    '10037434' => 'f10037434',
    '10037435' => 'f10037435',
    '10037439' => 'f10037439',
    '10037441' => 'f10037441',
    '10037442' => 'f10037442',
    '10037443' => 'f10037443',
    '10037449' => 'f10037449',
    '10037451' => 'f10037451',
    '10037452' => 'f10037452',
    '10037453' => 'f10037453',
    '10037454' => 'f10037454',
    '10037459' => 'f10037459',
    '10037461' => 'f10037461',
    '10037462' => 'f10037462',
    '10037463' => 'f10037463',
    '10037464' => 'f10037464',
    '10037469' => 'f10037469',
    '10037471' => 'f10037471',
    '10037472' => 'f10037472',
    '10037473' => 'f10037473',
    '10037474' => 'f10037474',
    '10037479' => 'f10037479',
    '10037481' => 'f10037481',
    '10037482' => 'f10037482',
    '10037483' => 'f10037483',
    '10037484' => 'f10037484',
    '10037489' => 'f10037489',
    '10037491' => 'f10037491',
    '10037492' => 'f10037492',
    '10037493' => 'f10037493',
    '10037494' => 'f10037494',
    '10037501' => 'f10037501',
    '10037503' => 'f10037503',
    '10037504' => 'f10037504',
    '10037505' => 'f10037505',
    '10037509' => 'f10037509',
    '10037511' => 'f10037511',
    '10037512' => 'f10037512',
    '10037513' => 'f10037513',
    '10037517' => 'f10037517',
    '10037519' => 'f10037519',
    '10037520' => 'f10037520',
    '10037521' => 'f10037521',
    '10037527' => 'f10037527',
    '10037529' => 'f10037529',
    '10037530' => 'f10037530',
    '10037531' => 'f10037531',
    '10037535' => 'f10037535',
    '10037537' => 'f10037537',
    '10037538' => 'f10037538',
    '10037539' => 'f10037539',
    '10037543' => 'f10037543',
    '10037545' => 'f10037545',
    '10037546' => 'f10037546',
    '10037547' => 'f10037547',
    '10037551' => 'f10037551',
    '10037553' => 'f10037553',
    '10037554' => 'f10037554',
    '10037555' => 'f10037555',
    '10037561' => 'f10037561',
    '10037563' => 'f10037563',
    '10037564' => 'f10037564',
    '10037565' => 'f10037565',
    '10037569' => 'f10037569',
    '10037571' => 'f10037571',
    '10037572' => 'f10037572',
    '10037573' => 'f10037573',
    '10037577' => 'f10037577',
    '10037579' => 'f10037579',
    '10037580' => 'f10037580',
    '10037581' => 'f10037581',
    '10037585' => 'f10037585',
    '10037587' => 'f10037587',
    '10037588' => 'f10037588',
    '10037589' => 'f10037589',
    '10037593' => 'f10037593',
    '10037595' => 'f10037595',
    '10037596' => 'f10037596',
    '10037597' => 'f10037597',
    '10037603' => 'f10037603',
    '10037605' => 'f10037605',
    '10037606' => 'f10037606',
    '10037607' => 'f10037607',
    '10037613' => 'f10037613',
    '10037615' => 'f10037615',
    '10037616' => 'f10037616',
    '10037617' => 'f10037617',
    '10037618' => 'f10037618',
    '10037623' => 'f10037623',
    '10037625' => 'f10037625',
    '10037626' => 'f10037626',
    '10037627' => 'f10037627',
    '10037628' => 'f10037628',
    '10037635' => 'f10037635',
    '10037637' => 'f10037637',
    '10037638' => 'f10037638',
    '10037639' => 'f10037639',
    '10037640' => 'f10037640',
    '10037645' => 'f10037645',
    '10037647' => 'f10037647',
    '10037648' => 'f10037648',
    '10037649' => 'f10037649',
    '10037650' => 'f10037650',
    '10037655' => 'f10037655',
    '10037657' => 'f10037657',
    '10037658' => 'f10037658',
    '10037659' => 'f10037659',
    '10037660' => 'f10037660',
    '10037665' => 'f10037665',
    '10037667' => 'f10037667',
    '10037668' => 'f10037668',
    '10037669' => 'f10037669',
    '10037670' => 'f10037670',
    '10037677' => 'f10037677',
    '10037679' => 'f10037679',
    '10037680' => 'f10037680',
    '10037681' => 'f10037681',
    '10037682' => 'f10037682',
    '10037687' => 'f10037687',
    '10037689' => 'f10037689',
    '10037690' => 'f10037690',
    '10037691' => 'f10037691',
    '10037692' => 'f10037692',
    '10037697' => 'f10037697',
    '10037699' => 'f10037699',
    '10037700' => 'f10037700',
    '10037701' => 'f10037701',
    '10037702' => 'f10037702',
    '10037709' => 'f10037709',
    '10037711' => 'f10037711',
    '10037712' => 'f10037712',
    '10037713' => 'f10037713',
    '10037714' => 'f10037714',
    '10037719' => 'f10037719',
    '10037721' => 'f10037721',
    '10037722' => 'f10037722',
    '10037723' => 'f10037723',
    '10037724' => 'f10037724',
    '10037729' => 'f10037729',
    '10037731' => 'f10037731',
    '10037732' => 'f10037732',
    '10037733' => 'f10037733',
    '10037734' => 'f10037734',
    '10037739' => 'f10037739',
    '10037741' => 'f10037741',
    '10037742' => 'f10037742',
    '10037743' => 'f10037743',
    '10037744' => 'f10037744',
    '10039392' => 'f10039392',
    '10039393' => 'f10039393',
    '10039394' => 'f10039394',
    '10039395' => 'f10039395',
    '10039402' => 'f10039402',
    '10039403' => 'f10039403',
    '10039404' => 'f10039404',
    '10039405' => 'f10039405',
    '10039412' => 'f10039412',
    '10039413' => 'f10039413',
    '10039414' => 'f10039414',
    '10039415' => 'f10039415',
    '10039422' => 'f10039422',
    '10039423' => 'f10039423',
    '10039424' => 'f10039424',
    '10039425' => 'f10039425',
    '10039432' => 'f10039432',
    '10039433' => 'f10039433',
    '10039434' => 'f10039434',
    '10039435' => 'f10039435',
    '10039442' => 'f10039442',
    '10039443' => 'f10039443',
    '10039444' => 'f10039444',
    '10039445' => 'f10039445',
    '10039452' => 'f10039452',
    '10039453' => 'f10039453',
    '10039454' => 'f10039454',
    '10039455' => 'f10039455',
    '10039462' => 'f10039462',
    '10039463' => 'f10039463',
    '10039464' => 'f10039464',
    '10039465' => 'f10039465',
    '10039474' => 'f10039474',
    '10039475' => 'f10039475',
    '10039476' => 'f10039476',
    '10039477' => 'f10039477',
    '10039484' => 'f10039484',
    '10039485' => 'f10039485',
    '10039486' => 'f10039486',
    '10039487' => 'f10039487',
    '10039494' => 'f10039494',
    '10039495' => 'f10039495',
    '10039496' => 'f10039496',
    '10039497' => 'f10039497',
    '10039504' => 'f10039504',
    '10039505' => 'f10039505',
    '10039506' => 'f10039506',
    '10039507' => 'f10039507',
    '10039514' => 'f10039514',
    '10039515' => 'f10039515',
    '10039516' => 'f10039516',
    '10039517' => 'f10039517',
    '10039524' => 'f10039524',
    '10039525' => 'f10039525',
    '10039526' => 'f10039526',
    '10039527' => 'f10039527',
    '10039534' => 'f10039534',
    '10039535' => 'f10039535',
    '10039536' => 'f10039536',
    '10039537' => 'f10039537',
    '10039544' => 'f10039544',
    '10039545' => 'f10039545',
    '10039546' => 'f10039546',
    '10039547' => 'f10039547',
    '10041574' => 'f10041574',
    '10041576' => 'f10041576',
    '10041577' => 'f10041577',
    '10041578' => 'f10041578',
    '10041582' => 'f10041582',
    '10041584' => 'f10041584',
    '10041585' => 'f10041585',
    '10041586' => 'f10041586',
    '10041592' => 'f10041592',
    '10041594' => 'f10041594',
    '10041595' => 'f10041595',
    '10041596' => 'f10041596',
    '10041600' => 'f10041600',
    '10041602' => 'f10041602',
    '10041603' => 'f10041603',
    '10041604' => 'f10041604',
    '10041608' => 'f10041608',
    '10041610' => 'f10041610',
    '10041611' => 'f10041611',
    '10041612' => 'f10041612',
    '10041616' => 'f10041616',
    '10041618' => 'f10041618',
    '10041619' => 'f10041619',
    '10041620' => 'f10041620',
    '10041624' => 'f10041624',
    '10041626' => 'f10041626',
    '10041627' => 'f10041627',
    '10041628' => 'f10041628',
    '10041632' => 'f10041632',
    '10041634' => 'f10041634',
    '10041635' => 'f10041635',
    '10041636' => 'f10041636',
    '10041640' => 'f10041640',
    '10041642' => 'f10041642',
    '10041643' => 'f10041643',
    '10041644' => 'f10041644',
    '10043209' => 'f10043209',
    '10043211' => 'f10043211',
    '10043212' => 'f10043212',
    '10043213' => 'f10043213',
    '10043217' => 'f10043217',
    '10043219' => 'f10043219',
    '10043220' => 'f10043220',
    '10043221' => 'f10043221',
    '10043225' => 'f10043225',
    '10043227' => 'f10043227',
    '10043228' => 'f10043228',
    '10043229' => 'f10043229',
    '10043233' => 'f10043233',
    '10043235' => 'f10043235',
    '10043236' => 'f10043236',
    '10043237' => 'f10043237',
    '10043714' => 'f10043714',
    '10043716' => 'f10043716',
    '10043717' => 'f10043717',
    '10043718' => 'f10043718',
    '10043722' => 'f10043722',
    '10043724' => 'f10043724',
    '10043725' => 'f10043725',
    '10043726' => 'f10043726',
    '10043730' => 'f10043730',
    '10043732' => 'f10043732',
    '10043733' => 'f10043733',
    '10043734' => 'f10043734',
    '10043738' => 'f10043738',
    '10043740' => 'f10043740',
    '10043741' => 'f10043741',
    '10043742' => 'f10043742',
    '10043746' => 'f10043746',
    '10043748' => 'f10043748',
    '10043749' => 'f10043749',
    '10043750' => 'f10043750',
    '10044023' => 'f10044023',
    '10044025' => 'f10044025',
    '10044026' => 'f10044026',
    '10044027' => 'f10044027',
    '10044031' => 'f10044031',
    '10044033' => 'f10044033',
    '10044034' => 'f10044034',
    '10044035' => 'f10044035',
    '10044041' => 'f10044041',
    '10044043' => 'f10044043',
    '10044044' => 'f10044044',
    '10044045' => 'f10044045',
    '10044049' => 'f10044049',
    '10044051' => 'f10044051',
    '10044052' => 'f10044052',
    '10044053' => 'f10044053',
    '10044059' => 'f10044059',
    '10044061' => 'f10044061',
    '10044062' => 'f10044062',
    '10044063' => 'f10044063',
    '10044067' => 'f10044067',
    '10044069' => 'f10044069',
    '10044070' => 'f10044070',
    '10044071' => 'f10044071',
    '10044075' => 'f10044075',
    '10044077' => 'f10044077',
    '10044078' => 'f10044078',
    '10044079' => 'f10044079',
    '10044083' => 'f10044083',
    '10044085' => 'f10044085',
    '10044086' => 'f10044086',
    '10044087' => 'f10044087',
    '10077832' => 'f10077832',
    '10077834' => 'f10077834',
    '10077835' => 'f10077835',
    '10077836' => 'f10077836',
    '10077837' => 'f10077837',
    '10077838' => 'f10077838',
    '10077839' => 'f10077839',
    '10077840' => 'f10077840',
    '10077851' => 'f10077851',
    '10077852' => 'f10077852',
    '10077855' => 'f10077855',
    '10077856' => 'f10077856',
    '10077861' => 'f10077861',
    '10077862' => 'f10077862',
    '10077864' => 'f10077864',
    '10077866' => 'f10077866',
    '10077867' => 'f10077867',
    '10077881' => 'f10077881',
    '10077882' => 'f10077882',
    '10077944' => 'f10077944',
    '10077950' => 'f10077950',
    '10077951' => 'f10077951',
    '10077952' => 'f10077952',
    '10077953' => 'f10077953',
    '10077955' => 'f10077955',
    '10077958' => 'f10077958',
    '10077972' => 'f10077972',
    '10077973' => 'f10077973',
    '10077974' => 'f10077974',
    '10077975' => 'f10077975',
    '10077976' => 'f10077976',
    '10077977' => 'f10077977',
    '10077978' => 'f10077978',
    '10077979' => 'f10077979',
    '10077980' => 'f10077980',
    '10077981' => 'f10077981',
    '10077982' => 'f10077982',
    '10077983' => 'f10077983',
    '10077984' => 'f10077984',
    '10077985' => 'f10077985',
    '10077986' => 'f10077986',
    '10078041' => 'f10078041',
    '10078042' => 'f10078042',
    '10078047' => 'f10078047',
    '10078048' => 'f10078048',
    '10078049' => 'f10078049',
    '10078063' => 'f10078063',
    '10078064' => 'f10078064',
    '10078079' => 'f10078079',
    '10078083' => 'f10078083',
    '10078165' => 'f10078165',
    '10078166' => 'f10078166',
    '10078167' => 'f10078167',
    '10078168' => 'f10078168',
    '10078169' => 'f10078169',
    '10078182' => 'f10078182',
    '10078183' => 'f10078183',
    '10078184' => 'f10078184',
    '10078185' => 'f10078185',
    '10078204' => 'f10078204',
    '10078209' => 'f10078209',
    '10078210' => 'f10078210',
    '10078211' => 'f10078211',
    '10078219' => 'f10078219',
    '10078233' => 'f10078233',
    '10078234' => 'f10078234',
    '10078240' => 'f10078240',
    '10078248' => 'f10078248',
    '10078438' => 'f10078438',
    '10078451' => 'f10078451',
    '10078472' => 'f10078472',
    '10078475' => 'f10078475',
    '10078591' => 'f10078591',
    '10078592' => 'f10078592',
    '10078604' => 'f10078604',
    '10078605' => 'f10078605',
    '10078606' => 'f10078606',
    '10078607' => 'f10078607',
    '10078699' => 'f10078699',
    '10078701' => 'f10078701',
    '10078752' => 'f10078752',
    '10078811' => 'f10078811',
    '10078812' => 'f10078812',
    '10078813' => 'f10078813',
    '10078860' => 'f10078860',
    '10078861' => 'f10078861',
    '10078862' => 'f10078862',
    '10078863' => 'f10078863',
    '10078864' => 'f10078864',
    '10078865' => 'f10078865',
    '10078866' => 'f10078866',
    '10078884' => 'f10078884',
    '10078891' => 'f10078891',
    '10078913' => 'f10078913',
    '10078914' => 'f10078914',
    '10078919' => 'f10078919',
    '10999432' => 'f10999432',
    '10999434' => 'f10999434',
    '10999435' => 'f10999435',
    '10999436' => 'f10999436',
    '10999437' => 'f10999437',
    '10999438' => 'f10999438',
    '10999439' => 'f10999439',
    '10999440' => 'f10999440',
    '10999451' => 'f10999451',
    '10999452' => 'f10999452',
    '10999455' => 'f10999455',
    '10999456' => 'f10999456',
    '10999461' => 'f10999461',
    '10999462' => 'f10999462',
    '10999464' => 'f10999464',
    '10999466' => 'f10999466',
    '10999467' => 'f10999467',
    '10999481' => 'f10999481',
    '10999482' => 'f10999482',
    '10999544' => 'f10999544',
    '10999550' => 'f10999550',
    '10999551' => 'f10999551',
    '10999552' => 'f10999552',
    '10999553' => 'f10999553',
    '10999555' => 'f10999555',
    '10999558' => 'f10999558',
    '10999572' => 'f10999572',
    '10999573' => 'f10999573',
    '10999574' => 'f10999574',
    '10999575' => 'f10999575',
    '10999576' => 'f10999576',
    '10999577' => 'f10999577',
    '10999578' => 'f10999578',
    '10999579' => 'f10999579',
    '10999580' => 'f10999580',
    '10999581' => 'f10999581',
    '10999582' => 'f10999582',
    '10999583' => 'f10999583',
    '10999584' => 'f10999584',
    '10999585' => 'f10999585',
    '10999586' => 'f10999586',
    '10999641' => 'f10999641',
    '10999642' => 'f10999642',
    '10999647' => 'f10999647',
    '10999648' => 'f10999648',
    '10999649' => 'f10999649',
    '10999663' => 'f10999663',
    '10999664' => 'f10999664',
    '10999679' => 'f10999679',
    '10999683' => 'f10999683',
    '10999765' => 'f10999765',
    '10999766' => 'f10999766',
    '10999767' => 'f10999767',
    '10999768' => 'f10999768',
    '10999769' => 'f10999769',
    '10999782' => 'f10999782',
    '10999783' => 'f10999783',
    '10999784' => 'f10999784',
    '10999785' => 'f10999785',
    '10999804' => 'f10999804',
    '10999809' => 'f10999809',
    '10999810' => 'f10999810',
    '10999811' => 'f10999811',
    '10999819' => 'f10999819',
    '10999833' => 'f10999833',
    '10999834' => 'f10999834',
    '10999840' => 'f10999840',
    '10999848' => 'f10999848',
    '11000038' => 'f11000038',
    '11000051' => 'f11000051',
    '11000072' => 'f11000072',
    '11000075' => 'f11000075',
    '11000191' => 'f11000191',
    '11000192' => 'f11000192',
    '11000204' => 'f11000204',
    '11000205' => 'f11000205',
    '11000206' => 'f11000206',
    '11000207' => 'f11000207',
    '11000299' => 'f11000299',
    '11000301' => 'f11000301',
    '11000352' => 'f11000352',
    '11000411' => 'f11000411',
    '11000412' => 'f11000412',
    '11000413' => 'f11000413',
    '11000460' => 'f11000460',
    '11000461' => 'f11000461',
    '11000462' => 'f11000462',
    '11000463' => 'f11000463',
    '11000464' => 'f11000464',
    '11000465' => 'f11000465',
    '11000466' => 'f11000466',
    '11000484' => 'f11000484',
    '11000491' => 'f11000491',
    '11000513' => 'f11000513',
    '11000514' => 'f11000514',
    '11000519' => 'f11000519',
    '14194305' => 'e14194305',
    '14194309' => 'e14194309',
    '14194310' => 'e14194310',
    '14194311' => 'e14194311',
    '14194312' => 'e14194312',
    '14194313' => 'e14194313',
    '14194314' => 'e14194314',
    '14194315' => 'e14194315',
    '14194316' => 'e14194316',
    '14194317' => 'e14194317',
    '14194318' => 'e14194318',
    '14194319' => 'e14194319',
    '14194320' => 'e14194320',
    '14194321' => 'e14194321',
    '14194326' => 'e14194326',
    '14194327' => 'e14194327',
    '14194328' => 'e14194328',
    '14194329' => 'e14194329',
    '14194330' => 'e14194330',
    '14194331' => 'e14194331',
    '14194332' => 'e14194332',
    '14194333' => 'e14194333',
    '14194334' => 'e14194334',
    '14194335' => 'e14194335',
    '14194336' => 'e14194336',
    '14194337' => 'e14194337',
    '14194338' => 'e14194338',
    '14194339' => 'e14194339',
    '14194340' => 'e14194340',
    '14194341' => 'e14194341',
    '14194342' => 'e14194342',
    '14194343' => 'e14194343',
    '14194344' => 'e14194344',
    '14194345' => 'e14194345',
    '14194346' => 'e14194346',
    '14194347' => 'e14194347',
    '14194348' => 'e14194348',
    '14194349' => 'e14194349',
    '14194350' => 'e14194350',
    '14194351' => 'e14194351',
    '14194352' => 'e14194352',
    '14194353' => 'e14194353',
    '14194354' => 'e14194354',
    '14194355' => 'e14194355',
    '14194356' => 'e14194356',
    '14194357' => 'e14194357',
    '14194358' => 'e14194358',
    '14194359' => 'e14194359',
    '14194360' => 'e14194360',
    '14194361' => 'e14194361',
    '14194362' => 'e14194362',
    '14194363' => 'e14194363',
    '14194364' => 'e14194364',
    '14194365' => 'e14194365',
    '14194366' => 'e14194366',
    '14194367' => 'e14194367',
    '14194368' => 'e14194368',
    '14194369' => 'e14194369',
    '14194370' => 'e14194370',
    '14194371' => 'e14194371',
    '14194372' => 'e14194372',
    '14194373' => 'e14194373',
    '14194374' => 'e14194374',
    '14194380' => 'e14194380',
    '14194381' => 'e14194381',
    '14194382' => 'e14194382',
    '14194383' => 'e14194383',
    '14194384' => 'e14194384',
    '14194385' => 'e14194385',
    '14194386' => 'e14194386',
    '14194387' => 'e14194387',
    '14194388' => 'e14194388',
    '14194389' => 'e14194389',
    '14194390' => 'e14194390',
    '14194391' => 'e14194391',
    '14194392' => 'e14194392',
    '14194393' => 'e14194393',
    '14194394' => 'e14194394',
    '14194395' => 'e14194395',
    '14194396' => 'e14194396',
    '14194397' => 'e14194397',
    '14194398' => 'e14194398',
    '14194399' => 'e14194399',
    '14194400' => 'e14194400',
    '14194401' => 'e14194401',
    '14194402' => 'e14194402',
    '14194403' => 'e14194403',
    '14194404' => 'e14194404',
    '14194405' => 'e14194405',
    '14194406' => 'e14194406',
    '14194407' => 'e14194407',
    '14194408' => 'e14194408',
    '14194409' => 'e14194409',
    '14194410' => 'e14194410',
    '14194411' => 'e14194411',
    '14194412' => 'e14194412',
    '14194414' => 'e14194414',
    '14194415' => 'e14194415',
    '14194417' => 'e14194417',
    '14194418' => 'e14194418',
    '14194420' => 'e14194420',
    '14194421' => 'e14194421',
    '14194422' => 'e14194422',
    '14194423' => 'e14194423',
    '14194424' => 'e14194424',
    '14194425' => 'e14194425',
    '14194426' => 'e14194426',
    '14194427' => 'e14194427',
    '14194428' => 'e14194428',
    '14194429' => 'e14194429',
    '14194430' => 'e14194430',
    '14194431' => 'e14194431',
    '14194432' => 'e14194432',
    '14194445' => 'e14194445',
    '14194446' => 'e14194446',
    '14194447' => 'e14194447',
    '14194448' => 'e14194448',
    '14194449' => 'e14194449',
    '14194450' => 'e14194450',
    '14194451' => 'e14194451',
    '14194452' => 'e14194452',
    '14194453' => 'e14194453',
    '14194454' => 'e14194454',
    '14194455' => 'e14194455',
    '14194456' => 'e14194456',
    '14194457' => 'e14194457',
    '14194458' => 'e14194458',
    '14194459' => 'e14194459',
    '14194463' => 'e14194463',
    '14194464' => 'e14194464',
    '14194465' => 'e14194465',
    '14194466' => 'e14194466',
    '14194467' => 'e14194467',
    '14194468' => 'e14194468',
    '14194469' => 'e14194469',
    '14194473' => 'e14194473',
    '14194474' => 'e14194474',
    '14194475' => 'e14194475',
    '14194476' => 'e14194476',
    '14194477' => 'e14194477',
    '14194478' => 'e14194478',
    '14194479' => 'e14194479',
    '14194480' => 'e14194480',
    '14194481' => 'e14194481',
    '14194482' => 'e14194482',
    '14194483' => 'e14194483',
    '14194493' => 'e14194493',
    '14194495' => 'e14194495',
    '14194496' => 'e14194496',
    '14194497' => 'e14194497',
    '14194501' => 'e14194501',
    '14194502' => 'e14194502',
    '14194503' => 'e14194503',
    '14194504' => 'e14194504',
    '14194505' => 'e14194505',
    '14194506' => 'e14194506',
    '14194507' => 'e14194507',
    '14194508' => 'e14194508',
    '14194509' => 'e14194509',
    '14194510' => 'e14194510',
    '14194511' => 'e14194511',
    '14194512' => 'e14194512',
    '14194513' => 'e14194513',
    '14194516' => 'e14194516',
    '14194517' => 'e14194517',
    '14194518' => 'e14194518',
    '14194519' => 'e14194519',
    '14194520' => 'e14194520',
    '14194522' => 'e14194522',
    '14194523' => 'e14194523',
    '14194524' => 'e14194524',
    '14194525' => 'e14194525',
    '14194526' => 'e14194526',
    '14194527' => 'e14194527',
    '14194528' => 'e14194528',
    '14194529' => 'e14194529',
    '14194530' => 'e14194530',
    '14194531' => 'e14194531',
    '14194532' => 'e14194532',
    '14194533' => 'e14194533',
    '14194534' => 'e14194534',
    '14194535' => 'e14194535',
    '14194536' => 'e14194536',
    '14194537' => 'e14194537',
    '14194538' => 'e14194538',
    '14194539' => 'e14194539',
    '14194540' => 'e14194540',
    '14194541' => 'e14194541',
    '14194542' => 'e14194542',
    '14194543' => 'e14194543',
    '14194544' => 'e14194544',
    '14194545' => 'e14194545',
    '14194546' => 'e14194546',
    '14194547' => 'e14194547',
    '14194548' => 'e14194548',
    '14194549' => 'e14194549',
    '14194550' => 'e14194550',
    '14194551' => 'e14194551',
    '14194552' => 'e14194552',
    '14194553' => 'e14194553',
    '14194554' => 'e14194554',
    '14194555' => 'e14194555',
    '14194556' => 'e14194556',
    '14194557' => 'e14194557',
    '14194558' => 'e14194558',
    '14194559' => 'e14194559',
    '14194560' => 'e14194560',
    '14194561' => 'e14194561',
    '14194562' => 'e14194562',
    '14194563' => 'e14194563',
    '14194564' => 'e14194564',
    '14194565' => 'e14194565',
    '14194566' => 'e14194566',
    '14194567' => 'e14194567',
    '14194568' => 'e14194568',
    '14194569' => 'e14194569',
    '14194570' => 'e14194570',
    '14194571' => 'e14194571',
    '14194572' => 'e14194572',
    '14194573' => 'e14194573',
    '14194574' => 'e14194574',
    '14194575' => 'e14194575',
    '14194576' => 'e14194576',
    '14194577' => 'e14194577',
    '14194578' => 'e14194578',
    '14194579' => 'e14194579',
    '14194580' => 'e14194580',
    '14194581' => 'e14194581',
    '14194582' => 'e14194582',
    '14194583' => 'e14194583',
    '14194584' => 'e14194584',
    '14194585' => 'e14194585',
    '14194586' => 'e14194586',
    '14194587' => 'e14194587',
    '14194588' => 'e14194588',
    '14194589' => 'e14194589',
    '14194590' => 'e14194590',
    '14194591' => 'e14194591',
    '14194592' => 'e14194592',
    '14194597' => 'e14194597',
    '14194598' => 'e14194598',
    '14194599' => 'e14194599',
    '14194600' => 'e14194600',
    '14194601' => 'e14194601',
    '14194602' => 'e14194602',
    '14194603' => 'e14194603',
    '14194604' => 'e14194604',
    '14194605' => 'e14194605',
    '14194606' => 'e14194606',
    '14194607' => 'e14194607',
    '14194608' => 'e14194608',
    '14194609' => 'e14194609',
    '14194610' => 'e14194610',
    '14194611' => 'e14194611',
    '14194612' => 'e14194612',
    '14194613' => 'e14194613',
    '14194614' => 'e14194614',
    '14194615' => 'e14194615',
    '14194616' => 'e14194616',
    '14194617' => 'e14194617',
    '14194618' => 'e14194618',
    '14194619' => 'e14194619',
    '14194620' => 'e14194620',
    '14194621' => 'e14194621',
    '14194622' => 'e14194622',
    '14194623' => 'e14194623',
    '14194624' => 'e14194624',
    '14194625' => 'e14194625',
    '14194626' => 'e14194626',
    '14194627' => 'e14194627',
    '14194628' => 'e14194628',
    '14194629' => 'e14194629',
    '14194630' => 'e14194630',
    '14194631' => 'e14194631',
    '14194632' => 'e14194632',
    '14194633' => 'e14194633',
    '14194634' => 'e14194634',
    '14194635' => 'e14194635',
    '14194636' => 'e14194636',
    '14194637' => 'e14194637',
    '14194638' => 'e14194638',
    '14194639' => 'e14194639',
    '14194640' => 'e14194640',
    '14194641' => 'e14194641',
    '14194642' => 'e14194642',
    '14194643' => 'e14194643',
    '14194644' => 'e14194644',
    '14194645' => 'e14194645',
    '14194646' => 'e14194646',
    '14194647' => 'e14194647',
    '14194648' => 'e14194648',
    '14194649' => 'e14194649',
    '14194650' => 'e14194650',
    '14194651' => 'e14194651',
    '14194652' => 'e14194652',
    '14194653' => 'e14194653',
    '14194654' => 'e14194654',
    '14194655' => 'e14194655',
    '14194656' => 'e14194656',
    '14194657' => 'e14194657',
    '14194658' => 'e14194658',
    '14194659' => 'e14194659',
    '14194660' => 'e14194660',
    '14194661' => 'e14194661',
    '14194662' => 'e14194662',
    '14194663' => 'e14194663',
    '14194664' => 'e14194664',
    '14194665' => 'e14194665',
    '14194666' => 'e14194666',
    '14194667' => 'e14194667',
    '14194668' => 'e14194668',
    '14194669' => 'e14194669',
    '14194677' => 'e14194677',
    '14194678' => 'e14194678',
    '14194679' => 'e14194679',
    '14194680' => 'e14194680',
    '14194681' => 'e14194681',
    '14194682' => 'e14194682',
    '14194683' => 'e14194683',
    '14194684' => 'e14194684',
    '14194685' => 'e14194685',
    '14194686' => 'e14194686',
    '14194687' => 'e14194687',
    '14194688' => 'e14194688',
    '14194689' => 'e14194689',
    '14194690' => 'e14194690',
    '14194691' => 'e14194691',
    '14194692' => 'e14194692',
    '14194693' => 'e14194693',
    '14194694' => 'e14194694',
    '14194696' => 'e14194696',
    '14194697' => 'e14194697',
    '14194698' => 'e14194698',
    '14194699' => 'e14194699',
    '14194700' => 'e14194700',
    '14194701' => 'e14194701',
    '14194702' => 'e14194702',
    '14194703' => 'e14194703',
    '14194704' => 'e14194704',
    '14194705' => 'e14194705',
    '14194706' => 'e14194706',
    '14194707' => 'e14194707',
    '14194708' => 'e14194708',
    '14194709' => 'e14194709',
    '14194710' => 'e14194710',
    '14194711' => 'e14194711',
    '14194713' => 'e14194713',
    '14194715' => 'e14194715',
    '14194716' => 'e14194716',
    '14194717' => 'e14194717',
    '14194718' => 'e14194718',
    '14194719' => 'e14194719',
    '14194720' => 'e14194720',
    '14194721' => 'e14194721',
    '14194722' => 'e14194722',
    '14194723' => 'e14194723',
    '14194724' => 'e14194724',
    '14194725' => 'e14194725',
    '14194726' => 'e14194726',
    '14194727' => 'e14194727',
    '14194728' => 'e14194728',
    '14194729' => 'e14194729',
    '14194730' => 'e14194730',
    '14194731' => 'e14194731',
    '14194732' => 'e14194732',
    '14194733' => 'e14194733',
    '14194734' => 'e14194734',
    '14194735' => 'e14194735',
    '14194736' => 'e14194736',
    '14194737' => 'e14194737',
    '14194738' => 'e14194738',
    '14194739' => 'e14194739',
    '14194740' => 'e14194740',
    '14194741' => 'e14194741',
    '14194742' => 'e14194742',
    '14194743' => 'e14194743',
    '14194744' => 'e14194744',
    '14194745' => 'e14194745',
    '14194746' => 'e14194746',
    '14194747' => 'e14194747',
    '14194748' => 'e14194748',
    '14194749' => 'e14194749',
    '14194750' => 'e14194750',
    '14194751' => 'e14194751',
    '14194752' => 'e14194752',
    '14194753' => 'e14194753',
    '14194754' => 'e14194754',
    '14194755' => 'e14194755',
    '14194756' => 'e14194756',
    '14194757' => 'e14194757',
    '14194758' => 'e14194758',
    '14194759' => 'e14194759',
    '14194760' => 'e14194760',
    '14194761' => 'e14194761',
    '14194762' => 'e14194762',
    '14194763' => 'e14194763',
    '14194764' => 'e14194764',
    '14194765' => 'e14194765',
    '14194766' => 'e14194766',
    '14194767' => 'e14194767',
    '14194768' => 'e14194768',
    '14194769' => 'e14194769',
    '14194770' => 'e14194770',
    '14194771' => 'e14194771',
    '14194772' => 'e14194772',
    '14194773' => 'e14194773',
    '14194777' => 'e14194777',
    '14194778' => 'e14194778',
    '14194779' => 'e14194779',
    '14194780' => 'e14194780',
    '14194781' => 'e14194781',
    '14194782' => 'e14194782',
    '14194783' => 'e14194783',
    '14194784' => 'e14194784',
    '14194785' => 'e14194785',
    '14194786' => 'e14194786',
    '14194787' => 'e14194787',
    '14194788' => 'e14194788',
    '14194789' => 'e14194789',
    '14194790' => 'e14194790',
    '14194856' => 'e14194856',
    '14194857' => 'e14194857',
    '14194858' => 'e14194858',
    '14194859' => 'e14194859',
    '14194860' => 'e14194860',
    '14194861' => 'e14194861',
    '14194862' => 'e14194862',
    '14194863' => 'e14194863',
    '14194864' => 'e14194864',
    '14194865' => 'e14194865',
    '14194866' => 'e14194866',
    '14194867' => 'e14194867',
    '14194868' => 'e14194868',
    '14194869' => 'e14194869',
    '14194870' => 'e14194870',
    '14194871' => 'e14194871',
    '14194872' => 'e14194872',
    '14194873' => 'e14194873',
    '14194874' => 'e14194874',
    '14194875' => 'e14194875',
    '14194876' => 'e14194876',
    '14194877' => 'e14194877',
    '14194878' => 'e14194878',
    '14194879' => 'e14194879',
    '14194880' => 'e14194880',
    '14194881' => 'e14194881',
    '14194882' => 'e14194882',
    '14194883' => 'e14194883',
    '14194884' => 'e14194884',
    '14194885' => 'e14194885',
    '14194886' => 'e14194886',
    '14194887' => 'e14194887',
    '14194888' => 'e14194888',
    '14194889' => 'e14194889',
    '14194890' => 'e14194890',
    '14194891' => 'e14194891',
    '14194892' => 'e14194892',
    '14194893' => 'e14194893',
    '14194894' => 'e14194894',
    '14194895' => 'e14194895',
    '14194896' => 'e14194896',
    '14194897' => 'e14194897',
    '14194898' => 'e14194898',
    '14194899' => 'e14194899',
    '14194900' => 'e14194900',
    '14194901' => 'e14194901',
    '14194902' => 'e14194902',
    '14194903' => 'e14194903',
    '14194904' => 'e14194904',
    '14194905' => 'e14194905',
    '14194906' => 'e14194906',
    '14194907' => 'e14194907',
    '14194908' => 'e14194908',
    '14194909' => 'e14194909',
    '14194910' => 'e14194910',
    '14194911' => 'e14194911',
    '14194912' => 'e14194912',
    '14194913' => 'e14194913',
    '14194914' => 'e14194914',
    '14194915' => 'e14194915',
    '14194916' => 'e14194916',
    '14194917' => 'e14194917',
    '14194918' => 'e14194918',
    '14194919' => 'e14194919',
    '14194920' => 'e14194920',
    '14194921' => 'e14194921',
    '14194922' => 'e14194922',
    '14194923' => 'e14194923',
    '14194924' => 'e14194924',
    '14194925' => 'e14194925',
    '14194926' => 'e14194926',
    '14194927' => 'e14194927',
    '14194928' => 'e14194928',
    '14194929' => 'e14194929',
    '14194936' => 'e14194936',
    '14194937' => 'e14194937',
    '14194938' => 'e14194938',
    '14194939' => 'e14194939',
    '14194940' => 'e14194940',
    '14194941' => 'e14194941',
    '14194942' => 'e14194942',
    '14194943' => 'e14194943',
    '14194944' => 'e14194944',
    '14194945' => 'e14194945',
    '14194946' => 'e14194946',
    '14194947' => 'e14194947',
    '14194948' => 'e14194948',
    '14194949' => 'e14194949',
    '14194950' => 'e14194950',
    '14194951' => 'e14194951',
    '14194952' => 'e14194952',
    '14194953' => 'e14194953',
    '14194954' => 'e14194954',
    '14194955' => 'e14194955',
    '14194956' => 'e14194956',
    '14194957' => 'e14194957',
    '14194960' => 'e14194960',
    '14194961' => 'e14194961',
    '14194962' => 'e14194962',
    '14194963' => 'e14194963',
    '14194964' => 'e14194964',
    '14194965' => 'e14194965',
    '14194966' => 'e14194966',
    '14194967' => 'e14194967',
    '14194968' => 'e14194968',
    '14194969' => 'e14194969',
    '14194970' => 'e14194970',
    '14194971' => 'e14194971',
    '14194972' => 'e14194972',
    '14194973' => 'e14194973',
    '14194974' => 'e14194974',
    '14194975' => 'e14194975',
    '14194976' => 'e14194976',
    '14194986' => 'e14194986',
    '14194987' => 'e14194987',
    '14194988' => 'e14194988',
    '14194989' => 'e14194989',
    '14194990' => 'e14194990',
    '14194991' => 'e14194991',
    '14194992' => 'e14194992',
    '14194993' => 'e14194993',
    '14194994' => 'e14194994',
    '14194995' => 'e14194995',
    '14194996' => 'e14194996',
    '14194997' => 'e14194997',
    '14194998' => 'e14194998',
    '14194999' => 'e14194999',
    '14195000' => 'e14195000',
    '14195001' => 'e14195001',
    '14195002' => 'e14195002',
    '14195003' => 'e14195003',
    '14195004' => 'e14195004',
    '14195005' => 'e14195005',
    '14195006' => 'e14195006',
    '14195007' => 'e14195007',
    '14195008' => 'e14195008',
    '14195009' => 'e14195009',
    '14195010' => 'e14195010',
    '14195011' => 'e14195011',
    '14195012' => 'e14195012',
    '14195013' => 'e14195013',
    '14195014' => 'e14195014',
    '14195021' => 'e14195021',
    '14195022' => 'e14195022',
    '14195023' => 'e14195023',
    '14195024' => 'e14195024',
    '14195025' => 'e14195025',
    '14195026' => 'e14195026',
    '14195027' => 'e14195027',
    '14195028' => 'e14195028',
    '14195029' => 'e14195029',
    '14195030' => 'e14195030',
    '14195031' => 'e14195031',
    '14195032' => 'e14195032',
    '14195033' => 'e14195033',
    '14195034' => 'e14195034',
    '14195035' => 'e14195035',
    '14195036' => 'e14195036',
    '14195037' => 'e14195037',
    '14195038' => 'e14195038',
    '14195039' => 'e14195039',
    '14195040' => 'e14195040',
    '14195041' => 'e14195041',
    '14195042' => 'e14195042',
    '14195043' => 'e14195043',
    '14195044' => 'e14195044',
    '14195045' => 'e14195045',
    '14195046' => 'e14195046',
    '14195047' => 'e14195047',
    '14195048' => 'e14195048',
    '14195049' => 'e14195049',
    '14195050' => 'e14195050',
    '14195051' => 'e14195051',
    '14195052' => 'e14195052',
    '14195053' => 'e14195053',
    '14195054' => 'e14195054',
    '14195055' => 'e14195055',
    '14195056' => 'e14195056',
    '14195057' => 'e14195057',
    '14195058' => 'e14195058',
    '14195059' => 'e14195059',
    '14195060' => 'e14195060',
    '14195061' => 'e14195061',
    '14195062' => 'e14195062',
    '14195063' => 'e14195063',
    '14195067' => 'e14195067',
    '14195068' => 'e14195068',
    '14195069' => 'e14195069',
    '14195070' => 'e14195070',
    '14195071' => 'e14195071',
    '14195072' => 'e14195072',
    '14195073' => 'e14195073',
    '14195074' => 'e14195074',
    '14195075' => 'e14195075',
    '14195076' => 'e14195076',
    '14195077' => 'e14195077',
    '14195078' => 'e14195078',
    '14195079' => 'e14195079',
    '14195080' => 'e14195080',
    '14195081' => 'e14195081',
    '14195082' => 'e14195082',
    '14195083' => 'e14195083',
    '14195084' => 'e14195084',
    '14195085' => 'e14195085',
    '14195086' => 'e14195086',
    '14195087' => 'e14195087',
    '14195088' => 'e14195088',
    '14195089' => 'e14195089',
    '14195090' => 'e14195090',
    '14195091' => 'e14195091',
    '14195092' => 'e14195092',
    '14195093' => 'e14195093',
    '14195094' => 'e14195094',
    '14195095' => 'e14195095',
    '14195096' => 'e14195096',
    '14195097' => 'e14195097',
    '14195098' => 'e14195098',
    '14195099' => 'e14195099',
    '14195100' => 'e14195100',
    '14195101' => 'e14195101',
    '14195102' => 'e14195102',
    '14195103' => 'e14195103',
    '14195104' => 'e14195104',
    '14195105' => 'e14195105',
    '14195106' => 'e14195106',
    '14195107' => 'e14195107',
    '14195108' => 'e14195108',
    '14195109' => 'e14195109',
    '14195110' => 'e14195110',
    '14195111' => 'e14195111',
    '14195112' => 'e14195112',
    '14195113' => 'e14195113',
    '14195114' => 'e14195114',
    '14195115' => 'e14195115',
    '14195116' => 'e14195116',
    '14195117' => 'e14195117',
    '14195118' => 'e14195118',
    '14195119' => 'e14195119',
    '14195120' => 'e14195120',
    '14195121' => 'e14195121',
    '14195122' => 'e14195122',
    '14195123' => 'e14195123',
    '14195124' => 'e14195124',
    '14195125' => 'e14195125',
    '14195126' => 'e14195126',
    '14195127' => 'e14195127',
    '14195128' => 'e14195128',
    '14195129' => 'e14195129',
    '14195130' => 'e14195130',
    '14195131' => 'e14195131',
    '14195132' => 'e14195132',
    '14195133' => 'e14195133',
    '14195134' => 'e14195134',
    '14195135' => 'e14195135',
    '14195136' => 'e14195136',
    '14195137' => 'e14195137',
    '14195138' => 'e14195138',
    '14195139' => 'e14195139',
    '14195140' => 'e14195140',
    '14195141' => 'e14195141',
    '14195142' => 'e14195142',
    '14195143' => 'e14195143',
    '14195144' => 'e14195144',
    '14195145' => 'e14195145',
    '14195146' => 'e14195146',
    '14195147' => 'e14195147',
    '14195148' => 'e14195148',
    '14195149' => 'e14195149',
    '14195150' => 'e14195150',
    '14195151' => 'e14195151',
    '14195152' => 'e14195152',
    '14195153' => 'e14195153',
    '14195154' => 'e14195154',
    '14195155' => 'e14195155',
    '14195156' => 'e14195156',
    '14195157' => 'e14195157',
    '14195158' => 'e14195158',
    '14195159' => 'e14195159',
    '14195160' => 'e14195160',
    '14195161' => 'e14195161',
    '14195162' => 'e14195162',
    '14195164' => 'e14195164',
    '14195165' => 'e14195165',
    '14195166' => 'e14195166',
    '14195167' => 'e14195167',
    '14195168' => 'e14195168',
    '14195169' => 'e14195169',
    '14195170' => 'e14195170',
    '14195171' => 'e14195171',
    '14195172' => 'e14195172',
    '14195173' => 'e14195173',
    '14195174' => 'e14195174',
    '14195175' => 'e14195175',
    '14195176' => 'e14195176',
    '14195177' => 'e14195177',
    '14195178' => 'e14195178',
    '14195179' => 'e14195179',
    '14195180' => 'e14195180',
    '14195181' => 'e14195181',
    '14195182' => 'e14195182',
    '14195183' => 'e14195183',
    '14195184' => 'e14195184',
    '14195185' => 'e14195185',
    '14195186' => 'e14195186',
    '14195187' => 'e14195187',
    '14195188' => 'e14195188',
    '14195189' => 'e14195189',
    '14195190' => 'e14195190',
    '14195191' => 'e14195191',
    '14195192' => 'e14195192',
    '14195193' => 'e14195193',
    '14195194' => 'e14195194',
    '14195195' => 'e14195195',
    '14195196' => 'e14195196',
    '14195197' => 'e14195197',
    '14195198' => 'e14195198',
    '14195199' => 'e14195199',
    '14195200' => 'e14195200',
    '14195201' => 'e14195201',
    '14195202' => 'e14195202',
    '14195203' => 'e14195203',
    '14195204' => 'e14195204',
    '14195205' => 'e14195205',
    '14195206' => 'e14195206',
    '14195207' => 'e14195207',
    '14195208' => 'e14195208',
    '14195209' => 'e14195209',
    '14195210' => 'e14195210',
    '14195211' => 'e14195211',
    '14195212' => 'e14195212',
    '14195213' => 'e14195213',
    '14195214' => 'e14195214',
    '14195215' => 'e14195215',
    '14195216' => 'e14195216',
    '14195217' => 'e14195217',
    '14195218' => 'e14195218',
    '14195219' => 'e14195219',
    '14195220' => 'e14195220',
    '14195221' => 'e14195221',
    '14195222' => 'e14195222',
    '14195223' => 'e14195223',
    '14195224' => 'e14195224',
    '14195225' => 'e14195225',
    '14195226' => 'e14195226',
    '14195227' => 'e14195227',
    '14195228' => 'e14195228',
    '14195229' => 'e14195229',
    '14195230' => 'e14195230',
    '14195231' => 'e14195231',
    '14195232' => 'e14195232',
    '14195233' => 'e14195233',
    '14195234' => 'e14195234',
    '14195235' => 'e14195235',
    '14195236' => 'e14195236',
    '14195237' => 'e14195237',
    '14195238' => 'e14195238',
    '14195239' => 'e14195239',
    '14195240' => 'e14195240',
    '14195241' => 'e14195241',
    '14195242' => 'e14195242',
    '14195243' => 'e14195243',
    '14195244' => 'e14195244',
    '14195245' => 'e14195245',
    '14195246' => 'e14195246',
    '14195247' => 'e14195247',
    '14195248' => 'e14195248',
    '14195249' => 'e14195249',
    '14195250' => 'e14195250',
    '14195251' => 'e14195251',
    '14195252' => 'e14195252',
    '14195253' => 'e14195253',
    '14195254' => 'e14195254',
    '14195255' => 'e14195255',
    '14195256' => 'e14195256',
    '14195257' => 'e14195257',
    '14195258' => 'e14195258',
    '14195259' => 'e14195259',
    '14195260' => 'e14195260',
    '14195261' => 'e14195261',
    '14195262' => 'e14195262',
    '14195263' => 'e14195263',
    '14195264' => 'e14195264',
    '14195265' => 'e14195265',
    '14195266' => 'e14195266',
    '14195267' => 'e14195267',
    '14195268' => 'e14195268',
    '14195269' => 'e14195269',
    '14195270' => 'e14195270',
    '14195271' => 'e14195271',
    '14195272' => 'e14195272',
    '14195273' => 'e14195273',
    '14195274' => 'e14195274',
    '14195275' => 'e14195275',
    '14195276' => 'e14195276',
    '14195277' => 'e14195277',
    '14195278' => 'e14195278',
    '14195279' => 'e14195279',
    '14195280' => 'e14195280',
    '14195281' => 'e14195281',
    '14195282' => 'e14195282',
    '14195283' => 'e14195283',
    '14195284' => 'e14195284',
    '14195285' => 'e14195285',
    '14195286' => 'e14195286',
    '14195287' => 'e14195287',
    '14195288' => 'e14195288',
    '14195289' => 'e14195289',
    '14195290' => 'e14195290',
    '14195291' => 'e14195291',
    '14195292' => 'e14195292',
    '14195293' => 'e14195293',
    '14195294' => 'e14195294',
    '14195295' => 'e14195295',
    '14195296' => 'e14195296',
    '14195297' => 'e14195297',
    '14195298' => 'e14195298',
    '14195299' => 'e14195299',
    '14195300' => 'e14195300',
    '14195301' => 'e14195301',
    '14195302' => 'e14195302',
    '14195303' => 'e14195303',
    '14195304' => 'e14195304',
    '14195305' => 'e14195305',
    '14195306' => 'e14195306',
    '14195307' => 'e14195307',
    '14195308' => 'e14195308',
    '14195309' => 'e14195309',
    '14195310' => 'e14195310',
    '14195311' => 'e14195311',
    '14195312' => 'e14195312',
    '14195313' => 'e14195313',
    '14195314' => 'e14195314',
    '14195315' => 'e14195315',
    '14195316' => 'e14195316',
    '14195317' => 'e14195317',
    '14195318' => 'e14195318',
    '14195319' => 'e14195319',
    '14195320' => 'e14195320',
    '14195321' => 'e14195321',
    '14195322' => 'e14195322',
    '14195323' => 'e14195323',
    '14195324' => 'e14195324',
    '14195325' => 'e14195325',
    '14195326' => 'e14195326',
    '14195327' => 'e14195327',
    '14195328' => 'e14195328',
    '14195329' => 'e14195329',
    '14195330' => 'e14195330',
    '14195331' => 'e14195331',
    '14195332' => 'e14195332',
    '14195333' => 'e14195333',
    '14195334' => 'e14195334',
    '14195335' => 'e14195335',
    '14195336' => 'e14195336',
    '14195337' => 'e14195337',
    '14195338' => 'e14195338',
    '14195339' => 'e14195339',
    '14195340' => 'e14195340',
    '14195341' => 'e14195341',
    '14195342' => 'e14195342',
    '14195343' => 'e14195343',
    '14195344' => 'e14195344',
    '14195345' => 'e14195345',
    '14195346' => 'e14195346',
    '14195347' => 'e14195347',
    '14195348' => 'e14195348',
    '14195349' => 'e14195349',
    '14195350' => 'e14195350',
    '14195351' => 'e14195351',
    '14195352' => 'e14195352',
    '14195353' => 'e14195353',
    '14195355' => 'e14195355',
    '14195356' => 'e14195356',
    '14195357' => 'e14195357',
    '14195358' => 'e14195358',
    '14195359' => 'e14195359',
    '14195360' => 'e14195360',
    '14195361' => 'e14195361',
    '14195362' => 'e14195362',
    '14195363' => 'e14195363',
    '14195364' => 'e14195364',
    '14195365' => 'e14195365',
    '14195369' => 'e14195369',
    '14195370' => 'e14195370',
    '14195371' => 'e14195371',
    '14195372' => 'e14195372',
    '14195373' => 'e14195373',
    '14195374' => 'e14195374',
    '14195375' => 'e14195375',
    '14195376' => 'e14195376',
    '14195377' => 'e14195377',
    '14195378' => 'e14195378',
    '14195379' => 'e14195379',
    '14195380' => 'e14195380',
    '14195381' => 'e14195381',
    '14195382' => 'e14195382',
    '14195383' => 'e14195383',
    '14195384' => 'e14195384',
    '14195385' => 'e14195385',
    '14195386' => 'e14195386',
    '14195387' => 'e14195387',
    '14195388' => 'e14195388',
    '14195389' => 'e14195389',
    '14195390' => 'e14195390',
    '14195391' => 'e14195391',
    '14195392' => 'e14195392',
    '14195393' => 'e14195393',
    '14195394' => 'e14195394',
    '14195395' => 'e14195395',
    '14195396' => 'e14195396',
    '14195397' => 'e14195397',
    '14195398' => 'e14195398',
    '14195399' => 'e14195399',
    '14195400' => 'e14195400',
    '14195401' => 'e14195401',
    '14195402' => 'e14195402',
    '14195403' => 'e14195403',
    '14195404' => 'e14195404',
    '14195405' => 'e14195405',
    '14195406' => 'e14195406',
    '14195407' => 'e14195407',
    '14195408' => 'e14195408',
    '14195409' => 'e14195409',
    '14195410' => 'e14195410',
    '14195411' => 'e14195411',
    '14195412' => 'e14195412',
    '14195413' => 'e14195413',
    '14195414' => 'e14195414',
    '14195415' => 'e14195415',
    '14195416' => 'e14195416',
    '14195417' => 'e14195417',
    '14195418' => 'e14195418',
    '14195419' => 'e14195419',
    '14195420' => 'e14195420',
    '14195421' => 'e14195421',
    '14195422' => 'e14195422',
    '14195423' => 'e14195423',
    '14195424' => 'e14195424',
    '14195425' => 'e14195425',
    '14195426' => 'e14195426',
    '14195427' => 'e14195427',
    '14195428' => 'e14195428',
    '14195429' => 'e14195429',
    '14195430' => 'e14195430',
    '14195431' => 'e14195431',
    '14195432' => 'e14195432',
    '14195433' => 'e14195433',
    '14195434' => 'e14195434',
    '14195435' => 'e14195435',
    '14195436' => 'e14195436',
    '14195437' => 'e14195437',
    '14195438' => 'e14195438',
    '14195439' => 'e14195439',
    '14195440' => 'e14195440',
    '14195441' => 'e14195441',
    '14195442' => 'e14195442',
    '14195443' => 'e14195443',
    '14195444' => 'e14195444',
    '14195445' => 'e14195445',
    '14195446' => 'e14195446',
    '14195447' => 'e14195447',
    '14195448' => 'e14195448',
    '14195449' => 'e14195449',
    '14195450' => 'e14195450',
    '14195451' => 'e14195451',
    '14195452' => 'e14195452',
    '14195453' => 'e14195453',
    '14195454' => 'e14195454',
    '14195455' => 'e14195455',
    '14195456' => 'e14195456',
    '14195457' => 'e14195457',
    '14195458' => 'e14195458',
    '14195459' => 'e14195459',
    '14195460' => 'e14195460',
    '14195461' => 'e14195461',
    '14195462' => 'e14195462',
    '14195463' => 'e14195463',
    '14195464' => 'e14195464',
    '14195465' => 'e14195465',
    '14195466' => 'e14195466',
    '14195467' => 'e14195467',
    '14195468' => 'e14195468',
    '14195469' => 'e14195469',
    '14195470' => 'e14195470',
    '14195471' => 'e14195471',
    '14195472' => 'e14195472',
    '14195473' => 'e14195473',
    '14195474' => 'e14195474',
    '14195475' => 'e14195475',
    '14195476' => 'e14195476',
    '14195477' => 'e14195477',
    '14195478' => 'e14195478',
    '14195479' => 'e14195479',
    '14195480' => 'e14195480',
    '14195481' => 'e14195481',
    '14195482' => 'e14195482',
    '14195483' => 'e14195483',
    '14195484' => 'e14195484',
    '14195485' => 'e14195485',
    '14195486' => 'e14195486',
    '14195487' => 'e14195487',
    '14195488' => 'e14195488',
    '14195489' => 'e14195489',
    '14195490' => 'e14195490',
    '14195491' => 'e14195491',
    '14195492' => 'e14195492',
    '14195493' => 'e14195493',
    '14195494' => 'e14195494',
    '14195495' => 'e14195495',
    '14195496' => 'e14195496',
    '14195497' => 'e14195497',
    '14195498' => 'e14195498',
    '14195499' => 'e14195499',
    '14195500' => 'e14195500',
    '14195501' => 'e14195501',
    '14195502' => 'e14195502',
    '14195503' => 'e14195503',
    '14195504' => 'e14195504',
    '14195505' => 'e14195505',
    '14195506' => 'e14195506',
    '14195507' => 'e14195507',
    '14195508' => 'e14195508',
    '14195509' => 'e14195509',
    '14195510' => 'e14195510',
    '14195511' => 'e14195511',
    '14195512' => 'e14195512',
    '14195513' => 'e14195513',
    '14195514' => 'e14195514',
    '14195515' => 'e14195515',
    '14195516' => 'e14195516',
    '14195517' => 'e14195517',
    '14195518' => 'e14195518',
    '14195519' => 'e14195519',
    '14195520' => 'e14195520',
    '14195521' => 'e14195521',
    '14195522' => 'e14195522',
    '14195523' => 'e14195523',
    '14195524' => 'e14195524',
    '14195525' => 'e14195525',
    '14195526' => 'e14195526',
    '14195546' => 'e14195546',
    '14195547' => 'e14195547',
    '14195548' => 'e14195548',
    '14195550' => 'e14195550',
    '14195551' => 'e14195551',
    '14195552' => 'e14195552',
    '14195553' => 'e14195553',
    '14195563' => 'e14195563',
    '14195564' => 'e14195564',
    '14195565' => 'e14195565',
    '14195566' => 'e14195566',
    '14195567' => 'e14195567',
    '14195568' => 'e14195568',
    '14195569' => 'e14195569',
    '14195570' => 'e14195570',
    '14195571' => 'e14195571',
    '14195572' => 'e14195572',
    '14195573' => 'e14195573',
    '14195574' => 'e14195574',
    '14195575' => 'e14195575',
    '14195586' => 'e14195586',
    '14195587' => 'e14195587',
    '14195588' => 'e14195588',
    '14195589' => 'e14195589',
    '14195591' => 'e14195591',
    '14195592' => 'e14195592',
    '14195593' => 'e14195593',
    '14195594' => 'e14195594',
    '14195595' => 'e14195595',
    '14195596' => 'e14195596',
    '14195597' => 'e14195597',
    '14195598' => 'e14195598',
    '14195599' => 'e14195599',
    '14195600' => 'e14195600',
    '14195601' => 'e14195601',
    '14195602' => 'e14195602',
    '14195603' => 'e14195603',
    '14195623' => 'e14195623',
    '14195624' => 'e14195624',
    '14195625' => 'e14195625',
    '14195635' => 'e14195635',
    '14195636' => 'e14195636',
    '14195643' => 'e14195643',
    '14195644' => 'e14195644',
    '14195645' => 'e14195645',
    '14195646' => 'e14195646',
    '14195647' => 'e14195647',
    '14195648' => 'e14195648',
    '14195663' => 'e14195663',
    '14195664' => 'e14195664',
    '14195665' => 'e14195665',
    '14195666' => 'e14195666',
    '14195667' => 'e14195667',
    '14195668' => 'e14195668',
    '14195669' => 'e14195669',
    '14195670' => 'e14195670',
    '14195671' => 'e14195671',
    '14195672' => 'e14195672',
    '14195673' => 'e14195673',
    '14195674' => 'e14195674',
    '14195675' => 'e14195675',
    '14195676' => 'e14195676',
    '14195677' => 'e14195677',
    '14195678' => 'e14195678',
    '14195679' => 'e14195679',
    '14195680' => 'e14195680',
    '14195681' => 'e14195681',
    '14195682' => 'e14195682',
    '14195683' => 'e14195683',
    '14195684' => 'e14195684',
    '14195685' => 'e14195685',
    '14195686' => 'e14195686',
    '14195687' => 'e14195687',
    '14195688' => 'e14195688',
    '14195689' => 'e14195689',
    '14195690' => 'e14195690',
    '14195691' => 'e14195691',
    '14195692' => 'e14195692',
    '14195693' => 'e14195693',
    '14195694' => 'e14195694',
    '14195695' => 'e14195695',
    '14195696' => 'e14195696',
    '14195697' => 'e14195697',
    '14195698' => 'e14195698',
    '14195699' => 'e14195699',
    '14195700' => 'e14195700',
    '14195701' => 'e14195701',
    '14195702' => 'e14195702',
    '14195703' => 'e14195703',
    '14195704' => 'e14195704',
    '14195705' => 'e14195705',
    '14195706' => 'e14195706',
    '14195707' => 'e14195707',
    '14195708' => 'e14195708',
    '14195709' => 'e14195709',
    '14195710' => 'e14195710',
    '14195711' => 'e14195711',
    '14195712' => 'e14195712',
    '14195713' => 'e14195713',
    '14195714' => 'e14195714',
    '14195715' => 'e14195715',
    '14195716' => 'e14195716',
    '14195717' => 'e14195717',
    '14195718' => 'e14195718',
    '14195719' => 'e14195719',
    '14195723' => 'e14195723',
    '14195727' => 'e14195727',
    '14195731' => 'e14195731',
    '14195735' => 'e14195735',
    '14195739' => 'e14195739',
    '14195740' => 'e14195740',
    '14195741' => 'e14195741',
    '14195742' => 'e14195742',
    '14195743' => 'e14195743',
    '14195744' => 'e14195744',
    '14195745' => 'e14195745',
    '14195746' => 'e14195746',
    '14195747' => 'e14195747',
    '14195748' => 'e14195748',
    '14195749' => 'e14195749',
    '14195750' => 'e14195750',
    '14195751' => 'e14195751',
    '14195752' => 'e14195752',
    '14195753' => 'e14195753',
    '14195754' => 'e14195754',
    '14195755' => 'e14195755',
    '14195756' => 'e14195756',
    '14195757' => 'e14195757',
    '14195758' => 'e14195758',
    '14195759' => 'e14195759',
    '14195760' => 'e14195760',
    '14195761' => 'e14195761',
    '14195762' => 'e14195762',
    '14195763' => 'e14195763',
    '14195764' => 'e14195764',
    '14195765' => 'e14195765',
    '14195766' => 'e14195766',
    '14195767' => 'e14195767',
    '14195768' => 'e14195768',
    '14195769' => 'e14195769',
    '14195770' => 'e14195770',
    '14195771' => 'e14195771',
    '14195772' => 'e14195772',
    '14195773' => 'e14195773',
    '14195774' => 'e14195774',
    '14195775' => 'e14195775',
    '14195776' => 'e14195776',
    '14195777' => 'e14195777',
    '14195778' => 'e14195778',
    '14195779' => 'e14195779',
    '14195787' => 'e14195787',
    '14195818' => 'e14195818',
    '14195824' => 'e14195824',
    '14195827' => 'e14195827',
    '14195830' => 'e14195830',
    '14195832' => 'e14195832',
    '14195835' => 'e14195835',
    '14195841' => 'e14195841',
    '14195842' => 'e14195842',
    '14195843' => 'e14195843',
    '14195844' => 'e14195844',
    '14195845' => 'e14195845',
    '14195846' => 'e14195846',
    '14195847' => 'e14195847',
    '14195848' => 'e14195848',
    '14195849' => 'e14195849',
    '14195850' => 'e14195850',
    '14195851' => 'e14195851',
    '14195852' => 'e14195852',
    '14195853' => 'e14195853',
    '14195854' => 'e14195854',
    '14195855' => 'e14195855',
    '14195856' => 'e14195856',
    '14195857' => 'e14195857',
    '14195858' => 'e14195858',
    '14195859' => 'e14195859',
    '14195860' => 'e14195860',
    '14195861' => 'e14195861',
    '14195862' => 'e14195862',
    '14195863' => 'e14195863',
    '14195882' => 'e14195882',
    '14195883' => 'e14195883',
    '14195884' => 'e14195884',
    '14195885' => 'e14195885',
    '14195886' => 'e14195886',
    '14195887' => 'e14195887',
    '14195888' => 'e14195888',
    '14195889' => 'e14195889',
    '14195890' => 'e14195890',
    '14195891' => 'e14195891',
    '14195892' => 'e14195892',
    '14195893' => 'e14195893',
    '14195894' => 'e14195894',
    '14195895' => 'e14195895',
    '14195896' => 'e14195896',
    '14195897' => 'e14195897',
    '14195898' => 'e14195898',
    '14195899' => 'e14195899',
    '14195900' => 'e14195900',
    '14195901' => 'e14195901',
    '14195902' => 'e14195902',
    '14195903' => 'e14195903',
    '14195904' => 'e14195904',
    '14195905' => 'e14195905',
    '14195906' => 'e14195906',
    '14195907' => 'e14195907',
    '14195908' => 'e14195908',
    '14195909' => 'e14195909',
    '14195910' => 'e14195910',
    '14195911' => 'e14195911',
    '14195912' => 'e14195912',
    '14195913' => 'e14195913',
    '14195914' => 'e14195914',
    '14195915' => 'e14195915',
    '14195931' => 'e14195931',
    '14195932' => 'e14195932',
    '14195933' => 'e14195933',
    '14195934' => 'e14195934',
    '14195935' => 'e14195935',
    '14195936' => 'e14195936',
    '14195937' => 'e14195937',
    '14195938' => 'e14195938',
    '14195939' => 'e14195939',
    '14195940' => 'e14195940',
    '14195941' => 'e14195941',
    '14195942' => 'e14195942',
    '14195943' => 'e14195943',
    '14195944' => 'e14195944',
    '14195945' => 'e14195945',
    '14195946' => 'e14195946',
    '14195947' => 'e14195947',
    '14195948' => 'e14195948',
    '14195949' => 'e14195949',
    '14195950' => 'e14195950',
    '14195951' => 'e14195951',
    '14195952' => 'e14195952',
    '14195953' => 'e14195953',
    '14195954' => 'e14195954',
    '14195955' => 'e14195955',
    '14195956' => 'e14195956',
    '14195957' => 'e14195957',
    '14195958' => 'e14195958',
    '14195959' => 'e14195959',
    '14195960' => 'e14195960',
    '14195961' => 'e14195961',
    '14195962' => 'e14195962',
    '14195963' => 'e14195963',
    '14195964' => 'e14195964',
    '14195965' => 'e14195965',
    '14195966' => 'e14195966',
    '14195967' => 'e14195967',
    '14195968' => 'e14195968',
    '14195969' => 'e14195969',
    '14195970' => 'e14195970',
    '14195971' => 'e14195971',
    '14195972' => 'e14195972',
    '14195973' => 'e14195973',
    '14195974' => 'e14195974',
    '14195975' => 'e14195975',
    '14195976' => 'e14195976',
    '14195977' => 'e14195977',
    '14195978' => 'e14195978',
    '14195979' => 'e14195979',
    '14195980' => 'e14195980',
    '14195981' => 'e14195981',
    '14195982' => 'e14195982',
    '14195983' => 'e14195983',
    '14195984' => 'e14195984',
    '14195985' => 'e14195985',
    '14195986' => 'e14195986',
    '14195987' => 'e14195987',
    '14195988' => 'e14195988',
    '14195989' => 'e14195989',
    '14195990' => 'e14195990',
    '14195991' => 'e14195991',
    '14195992' => 'e14195992',
    '14195993' => 'e14195993',
    '14195994' => 'e14195994',
    '14195995' => 'e14195995',
    '14195996' => 'e14195996',
    '14195997' => 'e14195997',
    '14195998' => 'e14195998',
    '14195999' => 'e14195999',
    '14196000' => 'e14196000',
    '14196001' => 'e14196001',
    '14196002' => 'e14196002',
    '14196003' => 'e14196003',
    '14196004' => 'e14196004',
    '14196005' => 'e14196005',
    '14196006' => 'e14196006',
    '14196007' => 'e14196007',
    '14196008' => 'e14196008',
    '14196009' => 'e14196009',
    '14196010' => 'e14196010',
    '14196011' => 'e14196011',
    '14196012' => 'e14196012',
    '14196013' => 'e14196013',
    '14196014' => 'e14196014',
    '14196015' => 'e14196015',
    '14196016' => 'e14196016',
    '14196017' => 'e14196017',
    '14196018' => 'e14196018',
    '14196019' => 'e14196019',
    '14196020' => 'e14196020',
    '14196021' => 'e14196021',
    '14196022' => 'e14196022',
    '14196023' => 'e14196023',
    '14196024' => 'e14196024',
    '14196025' => 'e14196025',
    '14196026' => 'e14196026',
    '14196027' => 'e14196027',
    '14196028' => 'e14196028',
    '14196029' => 'e14196029',
    '14196030' => 'e14196030',
    '14196031' => 'e14196031',
    '14196032' => 'e14196032',
    '14196033' => 'e14196033',
    '14196034' => 'e14196034',
    '14196035' => 'e14196035',
    '14196036' => 'e14196036',
    '14196037' => 'e14196037',
    '14196038' => 'e14196038',
    '14196039' => 'e14196039',
    '14196040' => 'e14196040',
    '14196041' => 'e14196041',
    '14196042' => 'e14196042',
    '14196043' => 'e14196043',
    '14196044' => 'e14196044',
    '14196045' => 'e14196045',
    '14196046' => 'e14196046',
    '14196047' => 'e14196047',
    '14196048' => 'e14196048',
    '14196049' => 'e14196049',
    '14196050' => 'e14196050',
    '14196051' => 'e14196051',
    '14196052' => 'e14196052',
    '14196053' => 'e14196053',
    '14196054' => 'e14196054',
    '14196055' => 'e14196055',
    '14196056' => 'e14196056',
    '14196057' => 'e14196057',
    '14196058' => 'e14196058',
    '14196059' => 'e14196059',
    '14196060' => 'e14196060',
    '14196081' => 'e14196081',
    '14196082' => 'e14196082',
    '14196083' => 'e14196083',
    '14196084' => 'e14196084',
    '14196085' => 'e14196085',
    '14196086' => 'e14196086',
    '14196087' => 'e14196087',
    '14196088' => 'e14196088',
    '14196089' => 'e14196089',
    '14196090' => 'e14196090',
    '14196091' => 'e14196091',
    '14196092' => 'e14196092',
    '14196093' => 'e14196093',
    '14196094' => 'e14196094',
    '14196095' => 'e14196095',
    '14196096' => 'e14196096',
    '14196097' => 'e14196097',
    '14196098' => 'e14196098',
    '14196099' => 'e14196099',
    '14196100' => 'e14196100',
    '14196101' => 'e14196101',
    '14196102' => 'e14196102',
    '14196103' => 'e14196103',
    '14196104' => 'e14196104',
    '14196105' => 'e14196105',
    '14196106' => 'e14196106',
    '14196107' => 'e14196107',
    '14196108' => 'e14196108',
    '14196109' => 'e14196109',
    '14196110' => 'e14196110',
    '14196111' => 'e14196111',
    '14196112' => 'e14196112',
    '14196113' => 'e14196113',
    '14196114' => 'e14196114',
    '14196115' => 'e14196115',
    '14196116' => 'e14196116',
    '14196117' => 'e14196117',
    '14196118' => 'e14196118',
    '14196119' => 'e14196119',
    '14196120' => 'e14196120',
    '14196121' => 'e14196121',
    '14196122' => 'e14196122',
    '14196123' => 'e14196123',
    '14196124' => 'e14196124',
    '14196125' => 'e14196125',
    '14196126' => 'e14196126',
    '14196127' => 'e14196127',
    '14196128' => 'e14196128',
    '14196129' => 'e14196129',
    '14196130' => 'e14196130',
    '14196131' => 'e14196131',
    '14196132' => 'e14196132',
    '14196133' => 'e14196133',
    '14196134' => 'e14196134',
    '14196135' => 'e14196135',
    '14196136' => 'e14196136',
    '14196137' => 'e14196137',
    '14196138' => 'e14196138',
    '14196139' => 'e14196139',
    '14196140' => 'e14196140',
    '14196141' => 'e14196141',
    '14196142' => 'e14196142',
    '14196143' => 'e14196143',
    '14196144' => 'e14196144',
    '14196145' => 'e14196145',
    '14196146' => 'e14196146',
    '14196147' => 'e14196147',
    '14196148' => 'e14196148',
    '14196149' => 'e14196149',
    '14196150' => 'e14196150',
    '14196151' => 'e14196151',
    '14196152' => 'e14196152',
    '14196153' => 'e14196153',
    '14196154' => 'e14196154',
    '14196155' => 'e14196155',
    '14196156' => 'e14196156',
    '14196157' => 'e14196157',
    '14196158' => 'e14196158',
    '14196159' => 'e14196159',
    '14196160' => 'e14196160',
    '14196161' => 'e14196161',
    '14196162' => 'e14196162',
    '14196163' => 'e14196163',
    '14196164' => 'e14196164',
    '14196165' => 'e14196165',
    '14196166' => 'e14196166',
    '14196167' => 'e14196167',
    '14196168' => 'e14196168',
    '14196169' => 'e14196169',
    '14196170' => 'e14196170',
    '14196171' => 'e14196171',
    '14196172' => 'e14196172',
    '14196173' => 'e14196173',
    '14196174' => 'e14196174',
    '14196175' => 'e14196175',
    '14196176' => 'e14196176',
    '14196177' => 'e14196177',
    '14196178' => 'e14196178',
    '14196179' => 'e14196179',
    '14196180' => 'e14196180',
    '14196181' => 'e14196181',
    '14196182' => 'e14196182',
    '14196183' => 'e14196183',
    '14196184' => 'e14196184',
    '14196185' => 'e14196185',
    '14196186' => 'e14196186',
    '14196187' => 'e14196187',
    '14196188' => 'e14196188',
    '14196189' => 'e14196189',
    '14196190' => 'e14196190',
    '14196191' => 'e14196191',
    '14196192' => 'e14196192',
    '14196193' => 'e14196193',
    '14196194' => 'e14196194',
    '14196195' => 'e14196195',
    '14196196' => 'e14196196',
    '14196197' => 'e14196197',
    '14196198' => 'e14196198',
    '14196199' => 'e14196199',
    '14196200' => 'e14196200',
    '14196201' => 'e14196201',
    '14196202' => 'e14196202',
    '14196203' => 'e14196203',
    '14196204' => 'e14196204',
    '14196205' => 'e14196205',
    '14196206' => 'e14196206',
    '14196207' => 'e14196207',
    '14196208' => 'e14196208',
    '14196209' => 'e14196209',
    '14196210' => 'e14196210',
    '14196211' => 'e14196211',
    '14196212' => 'e14196212',
    '14196213' => 'e14196213',
    '14196214' => 'e14196214',
    '14196215' => 'e14196215',
    '14196216' => 'e14196216',
    '14196217' => 'e14196217',
    '14196218' => 'e14196218',
    '14196219' => 'e14196219',
    '14196220' => 'e14196220',
    '14196221' => 'e14196221',
    '14196222' => 'e14196222',
    '14196223' => 'e14196223',
    '14196224' => 'e14196224',
    '14196225' => 'e14196225',
    '14196226' => 'e14196226',
    '14196227' => 'e14196227',
    '14196228' => 'e14196228',
    '14196229' => 'e14196229',
    '14196230' => 'e14196230',
    '14196231' => 'e14196231',
    '14196232' => 'e14196232',
    '14196233' => 'e14196233',
    '14196234' => 'e14196234',
    '14196235' => 'e14196235',
    '14196236' => 'e14196236',
    '14196237' => 'e14196237',
    '14196238' => 'e14196238',
    '14196239' => 'e14196239',
    '14196240' => 'e14196240',
    '14196241' => 'e14196241',
    '14196242' => 'e14196242',
    '14196244' => 'e14196244',
    '14196245' => 'e14196245',
    '14196246' => 'e14196246',
    '14196247' => 'e14196247',
    '14196248' => 'e14196248',
    '14196249' => 'e14196249',
    '14196250' => 'e14196250',
    '14196251' => 'e14196251',
    '14196252' => 'e14196252',
    '14196253' => 'e14196253',
    '14196254' => 'e14196254',
    '14196255' => 'e14196255',
    '14196256' => 'e14196256',
    '14196257' => 'e14196257',
    '14196258' => 'e14196258',
    '14196259' => 'e14196259',
    '14196260' => 'e14196260',
    '14196261' => 'e14196261',
    '14196262' => 'e14196262',
    '14196263' => 'e14196263',
    '14196264' => 'e14196264',
    '14196265' => 'e14196265',
    '14196266' => 'e14196266',
    '14196267' => 'e14196267',
    '14196268' => 'e14196268',
    '14196269' => 'e14196269',
    '14196270' => 'e14196270',
    '14196271' => 'e14196271',
    '14196272' => 'e14196272',
    '14196273' => 'e14196273',
    '14196274' => 'e14196274',
    '14196275' => 'e14196275',
    '14196276' => 'e14196276',
    '14196277' => 'e14196277',
    '14196278' => 'e14196278',
    '14196279' => 'e14196279',
    '14196280' => 'e14196280',
    '14196281' => 'e14196281',
    '14196282' => 'e14196282',
    '14196283' => 'e14196283',
    '14196284' => 'e14196284',
    '14196285' => 'e14196285',
    '14196286' => 'e14196286',
    '14196287' => 'e14196287',
    '14196288' => 'e14196288',
    '14196289' => 'e14196289',
    '14196290' => 'e14196290',
    '14196291' => 'e14196291',
    '14196292' => 'e14196292',
    '14196293' => 'e14196293',
    '14196294' => 'e14196294',
    '14196295' => 'e14196295',
    '14196296' => 'e14196296',
    '14196297' => 'e14196297',
    '14196298' => 'e14196298',
    '14196299' => 'e14196299',
    '14196300' => 'e14196300',
    '14196301' => 'e14196301',
    '14196302' => 'e14196302',
    '14196303' => 'e14196303',
    '14196304' => 'e14196304',
    '14196305' => 'e14196305',
    '14196306' => 'e14196306',
    '14196307' => 'e14196307',
    '14196308' => 'e14196308',
    '14196309' => 'e14196309',
    '14196310' => 'e14196310',
    '14196311' => 'e14196311',
    '14196312' => 'e14196312',
    '14196313' => 'e14196313',
    '14196314' => 'e14196314',
    '14196315' => 'e14196315',
    '14196316' => 'e14196316',
    '14196317' => 'e14196317',
    '14196318' => 'e14196318',
    '14196319' => 'e14196319',
    '14196320' => 'e14196320',
    '14196321' => 'e14196321',
    '14196322' => 'e14196322',
    '14196323' => 'e14196323',
    '14196324' => 'e14196324',
    '14196325' => 'e14196325',
    '14196326' => 'e14196326',
    '14196327' => 'e14196327',
    '14196328' => 'e14196328',
    '14196329' => 'e14196329',
    '14196335' => 'e14196335',
    '14196336' => 'e14196336',
    '14196337' => 'e14196337',
    '14196338' => 'e14196338',
    '14196339' => 'e14196339',
    '14196340' => 'e14196340',
    '14196341' => 'e14196341',
    '14196342' => 'e14196342',
    '14196343' => 'e14196343',
    '14196344' => 'e14196344',
    '14196345' => 'e14196345',
    '14196346' => 'e14196346',
    '14196347' => 'e14196347',
    '14196348' => 'e14196348',
    '14196349' => 'e14196349',
    '14196350' => 'e14196350',
    '14196351' => 'e14196351',
    '14196352' => 'e14196352',
    '14196353' => 'e14196353',
    '14196354' => 'e14196354',
    '14196355' => 'e14196355',
    '14196356' => 'e14196356',
    '14196361' => 'e14196361',
    '14196362' => 'e14196362',
    '14196363' => 'e14196363',
    '14196364' => 'e14196364',
    '14196365' => 'e14196365',
    '14196366' => 'e14196366',
    '14196367' => 'e14196367',
    '14196368' => 'e14196368',
    '14196369' => 'e14196369',
    '14196370' => 'e14196370',
    '14196371' => 'e14196371',
    '14196372' => 'e14196372',
    '14196373' => 'e14196373',
    '14196374' => 'e14196374',
    '14196375' => 'e14196375',
    '14196376' => 'e14196376',
    '14196377' => 'e14196377',
    '14196378' => 'e14196378',
    '14196379' => 'e14196379',
    '14196380' => 'e14196380',
    '14196381' => 'e14196381',
    '14196382' => 'e14196382',
    '14196383' => 'e14196383',
    '14196384' => 'e14196384',
    '14196385' => 'e14196385',
    '14196386' => 'e14196386',
    '14196387' => 'e14196387',
    '14196388' => 'e14196388',
    '14196389' => 'e14196389',
    '14196390' => 'e14196390',
    '14196391' => 'e14196391',
    '14196392' => 'e14196392',
    '14196393' => 'e14196393',
    '14196394' => 'e14196394',
    '14196395' => 'e14196395',
    '14196396' => 'e14196396',
    '14196397' => 'e14196397',
    '14196398' => 'e14196398',
    '14196399' => 'e14196399',
    '14196400' => 'e14196400',
    '14196401' => 'e14196401',
    '14196402' => 'e14196402',
    '14196403' => 'e14196403',
    '14196404' => 'e14196404',
    '14196405' => 'e14196405',
    '14196406' => 'e14196406',
    '14196407' => 'e14196407',
    '14196408' => 'e14196408',
    '14196409' => 'e14196409',
    '14196410' => 'e14196410',
    '14196411' => 'e14196411',
    '14196412' => 'e14196412',
    '14196413' => 'e14196413',
    '14196414' => 'e14196414',
    '14196415' => 'e14196415',
    '14196416' => 'e14196416',
    '14196417' => 'e14196417',
    '14196418' => 'e14196418',
    '14196419' => 'e14196419',
    '14196420' => 'e14196420',
    '14196421' => 'e14196421',
    '14196422' => 'e14196422',
    '14196423' => 'e14196423',
    '14196424' => 'e14196424',
    '14196425' => 'e14196425',
    '14196426' => 'e14196426',
    '14196427' => 'e14196427',
    '14196428' => 'e14196428',
    '14196429' => 'e14196429',
    '14196430' => 'e14196430',
    '14196431' => 'e14196431',
    '14196432' => 'e14196432',
    '14196433' => 'e14196433',
    '14196434' => 'e14196434',
    '14196435' => 'e14196435',
    '14196436' => 'e14196436',
    '14196437' => 'e14196437',
    '14196438' => 'e14196438',
    '14196439' => 'e14196439',
    '14196440' => 'e14196440',
    '14196441' => 'e14196441',
    '14196442' => 'e14196442',
    '14196443' => 'e14196443',
    '14196444' => 'e14196444',
    '14196445' => 'e14196445',
    '14196446' => 'e14196446',
    '14196447' => 'e14196447',
    '14196448' => 'e14196448',
    '14196449' => 'e14196449',
    '14196450' => 'e14196450',
    '14196451' => 'e14196451',
    '14196452' => 'e14196452',
    '14196453' => 'e14196453',
    '14196454' => 'e14196454',
    '14196455' => 'e14196455',
    '14196456' => 'e14196456',
    '14196457' => 'e14196457',
    '14196458' => 'e14196458',
    '14196459' => 'e14196459',
    '14196460' => 'e14196460',
    '14196461' => 'e14196461',
    '14196462' => 'e14196462',
    '14196463' => 'e14196463',
    '14196464' => 'e14196464',
    '14196465' => 'e14196465',
    '14196470' => 'e14196470',
    '14196471' => 'e14196471',
    '14196472' => 'e14196472',
    '14522386' => 'f14522386',
    '14523652' => 'f14523652',
    '14523659' => 'f14523659',
    '14523660' => 'f14523660',
    '14523661' => 'f14523661',
    '14527296' => 'f14527296',
    '14527302' => 'f14527302',
    '14527312' => 'f14527312',
    '14527340' => 'f14527340',
    '14527344' => 'f14527344',
    '14527352' => 'f14527352',
    '14527357' => 'f14527357',
    '14527365' => 'f14527365',
    '14527367' => 'f14527367',
    '14527371' => 'f14527371',
    '14527380' => 'f14527380',
    '14527403' => 'f14527403',
    '14527405' => 'f14527405',
    '14527407' => 'f14527407',
    '14527409' => 'f14527409',
    '14527413' => 'f14527413',
    '14527415' => 'f14527415',
    '14527419' => 'f14527419',
    '14527420' => 'f14527420',
    '14527424' => 'f14527424',
    '14527440' => 'f14527440',
    '14527449' => 'f14527449',
    '14527457' => 'f14527457',
    '14527462' => 'f14527462',
    '14527474' => 'f14527474',
    '14527476' => 'f14527476',
    '14527481' => 'f14527481',
    '14527486' => 'f14527486',
    '14527500' => 'f14527500',
    '14527503' => 'f14527503',
    '14527518' => 'f14527518',
    '14527575' => 'f14527575',
    '14527577' => 'f14527577',
    '14527758' => 'f14527758',
    '14527787' => 'f14527787',
    '14527789' => 'f14527789',
    '14527797' => 'f14527797',
    '14527799' => 'f14527799',
    '14527802' => 'f14527802',
    '14527804' => 'f14527804',
    '14527806' => 'f14527806',
    '14527808' => 'f14527808',
    '14527810' => 'f14527810',
    '14527812' => 'f14527812',
    '14527975' => 'f14527975',
    '14528057' => 'f14528057',
    '14528819' => 'f14528819',
    '14528854' => 'f14528854',
    '14528856' => 'f14528856',
    '14528883' => 'f14528883',
    '14528888' => 'f14528888',
    '14528893' => 'f14528893',
    '14528897' => 'f14528897',
    '14529259' => 'f14529259',
    '14529310' => 'f14529310',
    '14529318' => 'f14529318',
    '14529327' => 'f14529327',
    '14529445' => 'f14529445',
    '14529459' => 'f14529459',
    '14529479' => 'f14529479',
    '14529671' => 'f14529671',
    '14530011' => 'f14530011',
    '14530050' => 'f14530050',
    '14530090' => 'f14530090',
    '14530445' => 'f14530445',
    '14530467' => 'f14530467',
    '14530919' => 'f14530919',
    '14530921' => 'f14530921',
    '14531402' => 'f14531402',
    '14531414' => 'f14531414',
    '14531419' => 'f14531419',
    '14531448' => 'f14531448',
    '14531455' => 'f14531455',
    '14531519' => 'f14531519',
    '14531529' => 'f14531529',
    '14531541' => 'f14531541',
    '14531560' => 'f14531560',
    '14532517' => 'f14532517',
    '14532527' => 'f14532527',
    '14532531' => 'f14532531',
    '14532533' => 'f14532533',
    '14532550' => 'f14532550',
    '14532563' => 'f14532563',
    '14532565' => 'f14532565',
    '14533159' => 'f14533159',
    '14533161' => 'f14533161',
    '14533342' => 'f14533342',
    '14533344' => 'f14533344',
    '14533349' => 'f14533349',
    '14533371' => 'f14533371',
    '14533374' => 'f14533374',
    '14533376' => 'f14533376',
    '14533378' => 'f14533378',
    '14533380' => 'f14533380',
    '14533382' => 'f14533382',
    '14533589' => 'f14533589',
  },
  'CucsAdaptorHostVisibility' => {
    '0' => 'no',
    '1' => 'yes',
    '2' => 'osDependent',
  },
  'CucsComputePhysicalLowVoltageMemory' => {
    '0' => 'unknown',
    '1' => 'yes',
    '2' => 'regularVoltage',
  },
  'CucsFabricNetGroupRefType' => {
    '0' => 'policyLocal',
    '1' => 'policyGlobal',
    '2' => 'policyExternal',
  },
  'CucsEquipmentSystemIOControllerFsmCurrentFsm' => {
    '0' => 'nop',
    '2035' => 'resetCmc',
  },
  'CucsComputePsuRedundancyOperState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'failed',
    '3' => 'degraded',
  },
  'CucsLsbootEmbeddedLocalLunImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsFabricFcoeEstcEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsFabricFcMonOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsQosclassFcPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsStatsCollectionPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '310' => 'updateEp',
  },
  'CucsEquipmentChassisProfileFsmTaskItem' => {
    '0' => 'nop',
    '566' => 'configure',
  },
  'CucsFlowctrlFlowControl' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsSwBreakoutType' => {
    '0' => 'unknown',
    '1' => 'n10g4x',
  },
  'CucsOsDeployState' => {
    '0' => 'undefined',
    '1' => 'inProgress',
    '2' => 'complete',
    '3' => 'retry',
    '4' => 'failed',
    '5' => 'throttled',
    '6' => 'undeployed',
  },
  'CucsAdaptorHostMgmtCapPreboot' => {
    '0' => 'none',
    '1' => 'pnuOS',
    '2' => 'efi',
  },
  'CucsIppoolDHCPMode' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsComputeConfigState' => {
    '1' => 'ok',
    '2' => 'notApplied',
  },
  'CucsEventEpCtrlLevel' => {
    '0' => 'cleared',
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
  },
  'CucsExtvmmMasterExtKeyFsmCurrentFsm' => {
    '0' => 'nop',
    '575' => 'config',
  },
  'CucsLstorageSharing' => {
    '0' => 'nonShared',
    '1' => 'shared',
  },
  'CucsQueryActivity' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CucsBiosVfUCSMBootModeControlVpUEFIBootMode' => {
    '0' => 'platformRecommended',
    '276' => 'disabled',
    '277' => 'enabled',
  },
  'CucsEquipmentDiscoveryCapOperPowerRequirement' => {
    '0' => 'none',
    '1' => 'standby',
    '2' => 'full',
  },
  'CucsMgmtCimcSecureBootAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsEquipmentCommStatus' => {
    '0' => 'unknown',
    '1' => 'connected',
    '2' => 'disconnected',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot5State' => {
    '0' => 'platformRecommended',
    '218' => 'disabled',
    '219' => 'enabled',
    '453' => 'uefiOnly',
    '454' => 'legacyOnly',
  },
  'CucsFabricFcPortOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsMgmtControllerFsmTaskItem' => {
    '0' => 'nop',
    '17' => 'extMgmtIfConfig',
    '248' => 'updateSwitch',
    '253' => 'updateIOM',
    '256' => 'activateIOM',
    '259' => 'updateBMC',
    '262' => 'activateBMC',
    '467' => 'updateUCSManager',
    '474' => 'sysConfig',
    '1059' => 'online',
    '1191' => 'registryConfig',
    '1493' => 'extMgmtInterfaceConfig',
    '1686' => 'lockConfig',
    '1688' => 'powerBudgetReclaimConfig',
    '1845' => 'updateCMC',
    '1848' => 'activateCMC',
    '1852' => 'updateAdaptor',
    '1855' => 'activateAdaptor',
    '1861' => 'updateRaidController',
    '1868' => 'updateBoardController',
    '2024' => 'powerCap',
    '2103' => 'enableSecureBoot',
    '2108' => 'updateColusaCMC',
    '2111' => 'activateColusaCMC',
    '2138' => 'updateColusaBoardController',
    '2146' => 'updateSasExpander',
    '2149' => 'activateSasExpander',
    '2153' => 'activateLocalDisk',
    '2195' => 'updateUCSManagerSP',
  },
  'CucsEquipmentChassisAdminState' => {
    '1' => 'acknowledged',
    '2' => 'reAcknowledge',
    '3' => 'decommission',
    '4' => 'remove',
    '5' => 'enablePortChannel',
    '6' => 'disablePortChannel',
    '7' => 'autoAcknowledge',
  },
  'CucsAdaptorAdminPowerState' => {
    '0' => 'none',
    '1' => 'resetPower',
  },
  'CucsStorageDeviceBridgeType' => {
    '0' => 'unknown',
    '1' => 'stsb',
  },
  'CucsCapabilityUpdaterFsmStageName' => {
    '0' => 'nop',
    '582' => 'updaterBegin',
    '583' => 'updaterLocal',
    '584' => 'updaterUnpackLocal',
    '585' => 'updaterDeleteLocal',
    '586' => 'updaterCopyRemote',
    '587' => 'updaterApply',
    '588' => 'updaterRescanImages',
    '589' => 'updaterFail',
    '590' => 'updaterSuccess',
    '903' => 'updaterEvaluateStatus',
  },
  'CucsFabricPermitStatus' => {
    '0' => 'available',
    '1' => 'inUse',
    '2' => 'assigned',
  },
  'CucsLsbootUsbFlashStorageImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsTrigOperState' => {
    '0' => 'pending',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'triggered',
    '4' => 'capReached',
    '5' => 'pendingAck',
  },
  'CucsExtvmmProviderVendorType' => {
    '0' => 'unknown',
    '1' => 'vmware',
    '2' => 'microsoft',
  },
  'CucsConsumerInstFsmCurrentFsm' => {
    '0' => 'nop',
    '185' => 'renameCfgDir',
  },
  'CucsFirmwareEquipmentType' => {
    '0' => 'unknown',
    '1' => 'system',
    '2' => 'switch',
    '3' => 'iocard',
    '4' => 'server',
    '5' => 'cimc',
    '6' => 'adaptor',
    '7' => 'storageController',
    '8' => 'boardController',
    '9' => 'bios',
    '10' => 'serviceProfile',
    '11' => 'graphicsCard',
    '12' => 'storageArrayProfile',
    '13' => 'storageBlade',
    '14' => 'sasExpander',
  },
  'CucsFirmwareTransferState' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'failed',
    '4' => 'eulaAcceptanceRequired',
  },
  'CucsStorageTechnologyConfig' => {
    '0' => 'unspecified',
    '1' => 'hdd',
    '2' => 'ssd',
  },
  'CucsMgmtBackupPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsConfigEquipmentType' => {
    '0' => 'chassis',
    '1' => 'fabricInterconnect',
    '2' => 'fex',
    '3' => 'server',
  },
  'CucsEquipmentStorageContainmentMethod' => {
    '0' => 'controller',
    '1' => 'computeEnclosure',
    '2' => 'chassisEnclosure',
    '3' => 'storageBlade',
  },
  'CucsIdentIdmTxnType' => {
    '0' => 'regular',
    '1' => 'confRename',
  },
  'CucsPoolPoolType' => {
    '0' => 'nonQualifer',
    '1' => 'qualifer',
  },
  'CucsOrgDeleteSource' => {
    '0' => 'notDeleting',
    '1' => 'resourceMgr',
    '2' => 'policyMgr',
  },
  'CucsStatsContextClass' => {
    '0' => 'computeSystem',
    '1' => 'equipmentChassis',
    '2' => 'computeBlade',
  },
  'CucsCommSyslogClientAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsNetworkVnetEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsIdentRetStatus' => {
    '0' => 'inTransit',
    '1' => 'succeeded',
    '2' => 'assignedByOther',
    '3' => 'outOfSync',
    '4' => 'failed',
    '5' => 'synced',
    '6' => 'valid',
    '7' => 'invalid',
  },
  'CucsAaaUserInterface' => {
    '0' => 'none',
    '1' => 'shell',
    '2' => 'web',
    '3' => 'ep',
    '4' => 'kvm',
    '5' => 'vmedia',
    '6' => 'sol',
  },
  'CucsEtherPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsComputeServerDiscPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1231' => 'resolveScrubPolicy',
  },
  'CucsStorageEnclosureAssociation' => {
    '0' => 'unknown',
    '1' => 'directAttached',
    '2' => 'expanderAttached',
  },
  'CucsAdaptorHostFcIfPersBind' => {
    '0' => 'disabled',
    '4' => 'enabled',
  },
  'CucsSwAccessDomainFsmStageName' => {
    '0' => 'nop',
    '222' => 'deployBegin',
    '223' => 'deployUpdateConnectivity',
    '434' => 'deployFail',
    '435' => 'deploySuccess',
  },
  'CucsFabricEthLanEpVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CucsQosclassEthClassifiedDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CucsTrigTrigState' => {
    '0' => 'none',
    '1' => 'waitingForNextBoot',
  },
  'CucsAdaptorHostFcIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CucsEquipmentChassisConfigProgressIndicator' => {
    '0' => 'ackNotInProgress',
    '1' => 'ackInProgress',
  },
  'CucsMgmtRemoteBackupOperType' => {
    '0' => 'backupNone',
    '1' => 'backupDelete',
  },
  'CucsEquipmentTpmConfigSupport' => {
    '0' => 'unsupported',
    '1' => 'supported',
  },
  'CucsLstorageInitiatorInterfaceType' => {
    '0' => 'unspecified',
    '1' => 'native',
    '2' => 'vdas',
  },
  'CucsStatsThr64ValuePropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CucsVnicOutbandMgmtEpFsmCurrentFsm' => {
    '0' => 'nop',
    '629' => 'configureOutband',
  },
  'CucsFabricEthEstcOperPortMode' => {
    '1' => 'regularTrunk',
    '2' => 'regularAccess',
    '3' => 'promiscuousTrunk',
    '4' => 'promiscuousAccess',
  },
  'CucsComputePortDiscPolicyEthBreakoutAutoDiscovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsExtvmmVcVersion' => {
    '0' => 'unknown',
    '1' => 'kl',
    '2' => 'klU1',
  },
  'CucsFabricEthMonDestEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsNfsMountInstFsmTaskItem' => {
    '0' => 'nop',
    '1233' => 'mount',
    '1238' => 'unmount',
  },
  'CucsEquipmentSecureBios' => {
    '0' => 'unknown',
    '1' => 'notSupported',
    '2' => 'supported',
  },
  'CucsGmetaHolderFsmStageName' => {
    '0' => 'nop',
    '1476' => 'inventoryBegin',
    '1477' => 'inventoryReportFullInventory',
    '1484' => 'inventoryFail',
    '1485' => 'inventorySuccess',
    '1486' => 'inventoryCheckInventoryStatus',
    '1680' => 'inventoryFullInventory',
    '1681' => 'inventoryBeginInventory',
    '1682' => 'inventoryReportPhysicalInventory',
    '1683' => 'inventoryReportOrgInventory',
    '1684' => 'inventoryReportStorageInventory',
    '1685' => 'inventoryEndInventory',
    '1956' => 'inventoryReportFaultInventory',
  },
  'CucsFabricEthMonOperationOperStateReason' => {
    '0' => 'active',
    '1' => 'noHardwareResource',
    '2' => 'noOperationalSrcDst',
    '3' => 'genericError',
    '4' => 'noSourcesConfigured',
    '5' => 'noDestinationConfigured',
    '6' => 'noSourceDestinationConfigured',
    '7' => 'sessionAdminShut',
    '8' => 'wrongDestinationMode',
    '9' => 'wrongSourceMode',
    '10' => 'tunnelMisconfDown',
    '11' => 'noFlowIdSpecified',
    '12' => 'unknown',
  },
  'CucsMgmtEntityState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
  },
  'CucsFabricComputeSlotEpFsmStageName' => {
    '0' => 'nop',
    '20' => 'identifyBegin',
    '21' => 'identifyExecuteLocal',
    '22' => 'identifyExecutePeer',
    '390' => 'identifyFail',
    '391' => 'identifySuccess',
    '1691' => 'identifyEvaluateIdentity',
  },
  'CucsCapabilityFeatureStatus' => {
    '0' => 'supported',
    '1' => 'unsupported',
  },
  'CucsSysdebugCoreFileAdminState' => {
    '0' => 'init',
    '1' => 'prepareDownload',
    '2' => 'downloaded',
  },
  'CucsPolicyPolicyScopeFsmCurrentFsm' => {
    '0' => 'nop',
    '1201' => 'releasePolicyFsm',
    '1203' => 'releaseOperationFsm',
    '1205' => 'releaseStorageFsm',
    '1207' => 'resolveManyPolicyFsm',
    '1209' => 'resolveManyOperationFsm',
    '1211' => 'resolveManyStorageFsm',
    '1213' => 'releaseManyPolicyFsm',
    '1215' => 'releaseManyOperationFsm',
    '1217' => 'releaseManyStorageFsm',
    '1219' => 'resolveAllPolicyFsm',
    '1221' => 'resolveAllOperationFsm',
    '1223' => 'resolveAllStorageFsm',
    '1225' => 'releaseAllPolicyFsm',
    '1227' => 'releaseAllOperationFsm',
    '1229' => 'releaseAllStorageFsm',
  },
  'CucsEquipmentContType' => {
    '0' => 'internal',
    '1' => 'external',
  },
  'CucsEquipmentAdminPowerState' => {
    '1' => 'policy',
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
  },
  'CucsLsbootLanOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CucsFirmwareItemType' => {
    '0' => 'unspecified',
    '1' => 'switchKernel',
    '2' => 'switchSoftware',
    '3' => 'system',
    '4' => 'bladeController',
    '5' => 'iocard',
    '6' => 'bladeBios',
    '7' => 'adaptor',
    '8' => 'storageController',
    '9' => 'hostNic',
    '10' => 'hostHba',
    '11' => 'hostHbaOptionrom',
    '12' => 'hostNicOptionrom',
    '13' => 'boardController',
    '14' => 'localDisk',
    '20' => 'flexflashController',
    '21' => 'storageNodeController',
    '22' => 'storageDevBridge',
    '23' => 'storageControllerOnboardDeviceCpld',
    '25' => 'graphicsCard',
    '26' => 'psu',
    '28' => 'sasExpander',
    '29' => 'chassisBoardController',
    '30' => 'cmc',
    '31' => 'sasExpRegFw',
    '40' => 'fiServicePack',
    '41' => 'mgmtServicePack',
  },
  'CucsExtpolScanCompletionStatus' => {
    '0' => 'inProgress',
    '1' => 'completed',
  },
  'CucsLsbootVirtualMediaType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsFirmwareBootUnitImage' => {
    '0' => 'running',
    '1' => 'backup',
  },
  'CucsFabricFcMonDestEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsPowerPrioritySharing' => {
    '0' => 'noPreference',
    '1' => 'highestPrioInChassis',
    '2' => 'highestPrioInPowerGroup',
  },
  'CucsBiosVfIntelVTForDirectedIOVpIntelVTDCoherencySupport' => {
    '0' => 'platformRecommended',
    '18' => 'disabled',
    '19' => 'enabled',
  },
  'CucsBiosVfCPUPowerManagementVpCPUPowerManagement' => {
    '0' => 'platformRecommended',
    '414' => 'performance',
    '491' => 'disabled',
    '492' => 'energyEfficient',
    '493' => 'custom',
  },
  'CucsLsAssocState' => {
    '0' => 'unassociated',
    '1' => 'associating',
    '2' => 'associated',
    '3' => 'disassociating',
    '4' => 'failed',
  },
  'CucsFabricEpMgrFsmCurrentFsm' => {
    '0' => 'nop',
    '1113' => 'configure',
  },
  'CucsStorageOperState' => {
    '0' => 'ok',
    '1' => 'misconfigured',
  },
  'CucsEquipmentPhysicalSecurityState' => {
    '1' => 'chassisClose',
    '2' => 'chassisOpen',
  },
  'CucsStorageProcessorFsmStageName' => {
    '0' => 'nop',
    '1636' => 'discoverSystemBegin',
    '1637' => 'discoverSystemInitiatePollBMCLocal',
    '1638' => 'discoverSystemInitiatePollBMCRemote',
    '1639' => 'discoverSystemWaitForOSStatus',
    '1640' => 'discoverSystemConnectSMELocal',
    '1641' => 'discoverSystemConnectSMERemote',
    '1642' => 'discoverSystemWaitForSMEConnection',
    '1643' => 'discoverSystemWaitForInventory',
    '1644' => 'enterMaintenanceBegin',
    '1645' => 'enterMaintenanceDisableStorageTarget',
    '1646' => 'enterMaintenanceWaitForServerShutdown',
    '1647' => 'enterMaintenancePowerOff',
    '1648' => 'enterMaintenanceSlotPowerCycle',
    '1649' => 'exitMaintenanceBegin',
    '1650' => 'exitMaintenanceWaitForHAQuorum',
    '1651' => 'exitMaintenanceWaitForServerPowerUp',
    '1652' => 'exitMaintenanceWaitForSMEConnection',
    '1653' => 'exitMaintenanceEnableStorageTarget',
    '1654' => 'deploySystemBegin',
    '1655' => 'deploySystemPowerOn',
    '1656' => 'deploySystemConnectSMELocal',
    '1657' => 'deploySystemConnectSMERemote',
    '1658' => 'deploySystemConfigHAState',
    '1659' => 'deploySystemConfigNetwork',
    '1660' => 'deploySystemConfigPlatform',
    '1661' => 'deploySystemConfigStorageTargetIdentity',
    '1662' => 'deploySystemConfigStorageReplicationService',
    '1663' => 'undeploySystemBegin',
    '1664' => 'undeploySystemDisableStorageTarget',
    '1665' => 'undeploySystemWaitForServerShutdown',
    '1666' => 'undeploySystemPowerOff',
    '1667' => 'undeploySystemSlotPowerCycle',
    '1668' => 'undeploySystemUndeployStorage',
    '1669' => 'undeploySystemWaitForUndeployStorage',
    '1670' => 'undeploySystemUndeployTargetIdentity',
    '1671' => 'undeploySystemUndeployPlatform',
    '1672' => 'undeploySystemUndeployNetwork',
    '1673' => 'undeploySystemDisassocStorageController',
    '1674' => 'undeploySystemWaitForDisassocCompletion',
    '1675' => 'haTakeOverBegin',
    '1676' => 'haTakeOverPerformHaTakeOver',
    '1833' => 'deploySystemFail',
    '1834' => 'deploySystemSuccess',
    '1835' => 'discoverSystemFail',
    '1836' => 'discoverSystemSuccess',
    '1837' => 'enterMaintenanceFail',
    '1838' => 'enterMaintenanceSuccess',
    '1839' => 'exitMaintenanceFail',
    '1840' => 'exitMaintenanceSuccess',
    '1841' => 'haTakeOverFail',
    '1842' => 'haTakeOverSuccess',
    '1843' => 'undeploySystemFail',
    '1844' => 'undeploySystemSuccess',
  },
  'CucsFabricVnetEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsCommSvcEpFsmTaskItem' => {
    '0' => 'nop',
    '190' => 'updateSvcEp',
    '193' => 'restartWebSvc',
  },
  'CucsBiosVfAssertNMIOnPERRVpAssertNMIOnPERR' => {
    '0' => 'platformRecommended',
    '68' => 'disabled',
    '69' => 'enabled',
  },
  'CucsPolicySystemDualStack' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsPolicyControlEpOpFsmTaskItem' => {
    '0' => 'nop',
    '560' => 'remoteDomainReg',
    '564' => 'remoteDomainUnReg',
  },
  'CucsFabricEthLanEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsFcpoolBootTargetType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsEquipmentChassisProfileOperState' => {
    '0' => 'indeterminate',
    '1' => 'unassociated',
    '5' => 'operable',
    '10' => 'ok',
    '11' => 'discovery',
    '12' => 'config',
    '13' => 'unconfig',
    '14' => 'powerOff',
    '15' => 'restart',
    '20' => 'maintenance',
    '21' => 'test',
    '29' => 'chassisMismatch',
    '30' => 'chassisFailed',
    '31' => 'degraded',
    '32' => 'discoveryFailed',
    '33' => 'configFailure',
    '34' => 'unconfigFailed',
    '35' => 'testFailed',
    '36' => 'maintenanceFailed',
    '40' => 'removed',
    '41' => 'disabled',
    '50' => 'inaccessible',
    '63' => 'inoperable',
    '101' => 'decomissioning',
    '203' => 'diagnostics',
    '204' => 'diagnosticsFailed',
    '210' => 'pendingReboot',
    '211' => 'pendingReassociation',
  },
  'CucsMgmtEntityLeadIdForAutoInstall' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsVnicCdnSource' => {
    '0' => 'vnicName',
    '1' => 'userDefined',
  },
  'CucsPortSubGroupConfigState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricFcMonOperationOperStateReason' => {
    '0' => 'active',
    '1' => 'noHardwareResource',
    '2' => 'noOperationalSrcDst',
    '3' => 'genericError',
    '4' => 'noSourcesConfigured',
    '5' => 'noDestinationConfigured',
    '6' => 'noSourceDestinationConfigured',
    '7' => 'sessionAdminShut',
    '8' => 'wrongDestinationMode',
    '9' => 'wrongSourceMode',
    '10' => 'tunnelMisconfDown',
    '11' => 'noFlowIdSpecified',
    '12' => 'unknown',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot1State' => {
    '0' => 'platformRecommended',
    '210' => 'disabled',
    '211' => 'enabled',
    '445' => 'uefiOnly',
    '446' => 'legacyOnly',
  },
  'CucsMemoryType' => {
    '0' => 'undiscovered',
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'dram',
    '4' => 'edram',
    '5' => 'vram',
    '6' => 'sram',
    '7' => 'ram',
    '8' => 'rom',
    '9' => 'flash',
    '10' => 'eeprom',
    '11' => 'feprom',
    '12' => 'eprom',
    '13' => 'cdram',
    '14' => 'n3DRAM',
    '15' => 'sdram',
    '16' => 'sgram',
    '17' => 'rdram',
    '18' => 'ddr',
    '19' => 'ddr2',
    '20' => 'ddr2FbDimm',
    '24' => 'ddr3',
    '25' => 'fbd2',
    '26' => 'ddr4',
  },
  'CucsVnicFcBaseType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsMgmtBackupTriggerFsmStageName' => {
    '0' => 'nop',
    '399' => 'triggerBegin',
    '400' => 'triggerStateDisable',
    '401' => 'triggerStateEnable',
    '402' => 'triggerFail',
    '403' => 'triggerSuccess',
  },
  'CucsEquipmentPowerCapDefProfileMethod' => {
    '0' => 'unknown',
    '1' => 'default',
    '2' => 'static',
    '3' => 'pnuos',
    '4' => 'nodemgr',
  },
  'CucsBiosVfLOMPortsConfigurationVpLOMPort3OptionROM' => {
    '0' => 'platformRecommended',
    '385' => 'disabled',
    '386' => 'enabled',
    '387' => 'uefiOnly',
    '388' => 'legacyOnly',
  },
  'CucsComputeServerUnitFsmCurrentFsm' => {
    '0' => 'nop',
    '665' => 'associate',
    '727' => 'disassociate',
    '767' => 'powerCap',
    '769' => 'decommission',
    '771' => 'softShutdown',
    '773' => 'hardShutdown',
    '775' => 'turnup',
    '777' => 'powercycle',
    '781' => 'hardreset',
    '785' => 'softreset',
    '789' => 'swConnUpd',
    '792' => 'biosRecovery',
    '806' => 'cmosReset',
    '815' => 'resetBmc',
    '879' => 'updateExtUsers',
    '891' => 'updateAdaptor',
    '898' => 'activateAdaptor',
    '932' => 'configSoL',
    '934' => 'unconfigSoL',
    '1036' => 'diagnosticInterrupt',
    '1055' => 'resetKvm',
    '1152' => 'updateBIOS',
    '1157' => 'activateBIOS',
    '1200' => 'resetIpmi',
    '1202' => 'fwUpgrade',
    '1477' => 'cimcSessionDelete',
    '1497' => 'updateBoardController',
    '1506' => 'configBoard',
    '1508' => 'resetMemoryErrors',
    '1531' => 'serviceInfraDeploy',
    '1536' => 'serviceInfraWithdraw',
    '1599' => 'flashController',
    '1613' => 'enableCimcSecureBoot',
    '1722' => 'oobStorageAdminConfig',
    '1885' => 'discover',
    '1945' => 'clearTPM',
    '2045' => 'diskZoningInventory',
    '2209' => 'diag',
    '2242' => 'cimcSecurityConfig',
  },
  'CucsPolicyPolicyOwner' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
    '3' => 'unspecified',
  },
  'CucsEquipmentPsuType' => {
    '1' => 'ac',
    '2' => 'dc',
  },
  'CucsFabricFcZoneProfileFsmStageName' => {
    '0' => 'nop',
    '642' => 'configureBegin',
    '643' => 'configureValidation',
    '644' => 'configureConsumerVsanDeployment',
    '645' => 'configureWaitForRecvVsan',
    '646' => 'configureApplyConfig',
    '656' => 'configureFail',
    '657' => 'configureSuccess',
  },
  'CucsSmartlicenseAgentDebugLevel' => {
    '0' => 'error',
    '1' => 'trace',
    '2' => 'debug',
    '3' => 'all',
  },
  'CucsFabricEthLanPcEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsStorageFFCardSync' => {
    '0' => 'na',
    '1' => 'manual',
    '2' => 'auto',
    '3' => 'unknown',
  },
  'CucsComputeServerMgmtDiscAction' => {
    '0' => 'autoAcknowledged',
    '1' => 'userAcknowledged',
  },
  'CucsPolicyDomainCleanupMode' => {
    '0' => 'localizeGlobal',
    '1' => 'deepRemoveGlobal',
  },
  'CucsFabricFcMonDestEpOperationIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsAdaptorExtIfEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortRear' => {
    '0' => 'platformRecommended',
    '393' => 'disabled',
    '394' => 'enabled',
  },
  'CucsSwConfMode' => {
    '0' => 'none',
    '1' => 'inProgress',
    '2' => 'verifying',
    '3' => 'failed',
  },
  'CucsMgmtEntityChassisDeviceIoState1' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'openError',
    '3' => 'readError',
    '4' => 'writeError',
  },
  'CucsEquipmentCPMetaOperationCodeClearance' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsAdaptorExtIpV6RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsCapabilityMgmtExtensionFsmTaskItem' => {
    '0' => 'nop',
    '899' => 'activateMgmtExt',
  },
  'CucsObserveObservedFsmTaskItem' => {
    '0' => 'nop',
    '1341' => 'resolvePolicyFsm',
    '1343' => 'resolveResourceFsm',
    '1345' => 'resolveVMFsm',
    '1347' => 'resolveControllerFsm',
  },
  'CucsSwFcMonFsmTaskItem' => {
    '0' => 'nop',
    '955' => 'deploy',
  },
  'CucsEquipmentFexFsmCurrentFsm' => {
    '0' => 'nop',
    '636' => 'removeFex',
  },
  'CucsFabricFcSanPcOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpPCIeSlotSASOptionROM' => {
    '0' => 'platformRecommended',
    '317' => 'disabled',
    '318' => 'enabled',
    '319' => 'uefiOnly',
    '320' => 'legacyOnly',
  },
  'CucsPowerPsuLineMode' => {
    '0' => 'unknown',
    '1' => 'undetermined',
    '2' => 'highLine',
    '3' => 'lowLine',
    '4' => 'mixedLine',
  },
  'CucsFsmCompletion' => {
    '0' => 'scheduled',
    '1' => 'processing',
    '2' => 'completed',
    '3' => 'cancelled',
  },
  'CucsFsmLifecycle' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsStorageFFType' => {
    '0' => 'unknown',
    '1' => 'astoria',
    '2' => 'fx3s',
  },
  'CucsBiosVfOutOfBandManagementVpComSpcrEnable' => {
    '0' => 'platformRecommended',
    '564' => 'disabled',
    '565' => 'enabled',
  },
  'CucsStatsCoolingEndpoint' => {
    '0' => 'chassisFans',
    '1' => 'fiFans',
    '2' => 'rackUnitFans',
  },
  'CucsFabricVlanSharingType' => {
    '0' => 'none',
    '1' => 'primary',
    '2' => 'isolated',
    '3' => 'community',
  },
  'CucsSwFabricZoneNsAllocStatus' => {
    '0' => 'available',
    '1' => 'full',
  },
  'CucsComputeServerDiscPolicyFsmStageName' => {
    '0' => 'nop',
    '1231' => 'resolveScrubPolicyBegin',
    '1232' => 'resolveScrubPolicyResolve',
    '1391' => 'resolveScrubPolicyFail',
    '1392' => 'resolveScrubPolicySuccess',
  },
  'CucsSwVlanPortNsAllocStatus' => {
    '0' => 'available',
    '1' => 'exceeded',
  },
  'CucsOsControllerFsmCurrentFsm' => {
    '0' => 'nop',
    '1772' => 'deployOS',
  },
  'CucsSwPeerStatus' => {
    '1' => 'existing',
    '2' => 'nonexisting',
  },
  'CucsDiagCpuFilter' => {
    '0' => 'p0P1Cpus',
    '1' => 'allCpus',
  },
  'CucsSwNetflowMonitorProtocol' => {
    '1' => 'netflow',
  },
  'CucsAaaPwdPolicy' => {
    '0' => 'enable',
    '1' => 'disable',
  },
  'CucsBiosVfProcessorC3ReportVpProcessorC3Report' => {
    '0' => 'platformRecommended',
    '108' => 'disabled',
    '109' => 'enabled',
    '136' => 'acpiC2',
    '137' => 'acpiC3',
  },
  'CucsAaaTacacsPlusEpFsmCurrentFsm' => {
    '0' => 'nop',
    '197' => 'updateEp',
  },
  'CucsSwVlanLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
    '4' => 'pending',
    '5' => 'provisioned',
  },
  'CucsSmartlicenseEntitlementEpFsmStageName' => {
    '0' => 'nop',
    '484' => 'configureBegin',
    '485' => 'configureReport',
    '486' => 'configureRetryReport',
    '518' => 'configureFail',
    '519' => 'configureSuccess',
  },
  'CucsEquipmentPresence' => {
    '0' => 'unknown',
    '1' => 'empty',
    '10' => 'equipped',
    '11' => 'missing',
    '12' => 'mismatch',
    '13' => 'equippedNotPrimary',
    '14' => 'equippedSlave',
    '15' => 'mismatchSlave',
    '16' => 'missingSlave',
    '20' => 'equippedIdentityUnestablishable',
    '21' => 'mismatchIdentityUnestablishable',
    '22' => 'equippedWithMalformedFru',
    '30' => 'inaccessible',
    '40' => 'unauthorized',
    '100' => 'notSupported',
    '101' => 'equippedUnsupported',
    '102' => 'equippedDiscNotStarted',
    '103' => 'equippedDiscInProgress',
    '104' => 'equippedDiscError',
    '105' => 'equippedDiscUnknown',
  },
  'CucsBiosVfPackageCStateLimitVpPackageCStateLimit' => {
    '0' => 'platformRecommended',
    '222' => 'noLimit',
    '223' => 'c0',
    '224' => 'c1',
    '225' => 'c3',
    '226' => 'c6',
    '504' => 'c2',
    '505' => 'c7',
    '506' => 'c7s',
    '507' => 'auto',
  },
  'CucsAdaptorInterruptMode' => {
    '1' => 'msiX',
    '2' => 'msi',
    '3' => 'intx',
  },
  'CucsQosHostControl' => {
    '0' => 'none',
    '1' => 'full',
    '2' => 'fullWithException',
  },
  'CucsLstorageLunMapType' => {
    '0' => 'nonShared',
    '1' => 'shared',
    '2' => 'unassigned',
  },
  'CucsAaaAccountStatus' => {
    '0' => 'active',
    '1' => 'inactive',
  },
  'CucsEquipmentLedColor' => {
    '0' => 'unknown',
    '1' => 'green',
    '2' => 'amber',
    '3' => 'red',
    '4' => 'blue',
  },
  'CucsLicenseTransferState' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'failed',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot8State' => {
    '0' => 'platformRecommended',
    '282' => 'disabled',
    '283' => 'enabled',
    '284' => 'uefiOnly',
    '285' => 'legacyOnly',
  },
  'CucsVnicOutbandMgmtEpFsmTaskItem' => {
    '0' => 'nop',
    '629' => 'configureOutband',
  },
  'CucsLstorageVirtualDriveDefReadPolicy' => {
    '0' => 'unknown',
    '1' => 'readAhead',
    '2' => 'normal',
  },
  'CucsGlRequestVnetEpDomainEpFsmCurrentFsm' => {
    '0' => 'nop',
    '609' => 'evalData',
  },
  'CucsBiosVfTrustedPlatformModuleVpTrustedPlatformModuleSupport' => {
    '0' => 'platformRecommended',
    '513' => 'disabled',
    '514' => 'enabled',
  },
  'CucsAdaptorComparisonOper' => {
    '0' => 'none',
    '1' => 'gt',
    '2' => 'lt',
  },
  'CucsLsmaintChangeMode' => {
    '0' => 'noChange',
    '1' => 'unconfig',
    '2' => 'forceUnconfig',
    '4' => 'rediscover',
    '8' => 'config',
    '16' => 'diagConfig',
    '32' => 'diagUnconfig',
    '64' => 'removeConfig',
    '128' => 'diag',
    '256' => 'configEvaluation',
  },
  'CucsPolicyRepairStateType' => {
    '0' => 'done',
    '1' => 'notDone',
  },
  'CucsComputeServerTypeCapType' => {
    '0' => 'generalPurpose',
    '1' => 'appliance',
    '2' => 'sharedIo',
  },
  'CucsFabricEthMonSrcEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsCommDateTimeFsmStageName' => {
    '0' => 'nop',
    '536' => 'timezoneBegin',
    '537' => 'timezoneChange',
    '538' => 'timezoneFail',
    '539' => 'timezoneSuccess',
  },
  'CucsEquipmentUuidFeatureCapUuidSupportMode' => {
    '0' => 'none',
    '1' => 'loose',
    '2' => 'strict',
  },
  'CucsFabricEthUdldPolicyProtocol' => {
    '0' => 'unknown',
    '1' => 'udld',
    '2' => 'cdp',
  },
  'CucsStorageLearnCycleRequested' => {
    '0' => 'unknown',
    '1' => 'true',
    '2' => 'false',
  },
  'CucsStorageAdminActionType' => {
    '0' => 'unspecified',
    '1' => 'jbod',
    '2' => 'unconfiguredGood',
    '3' => 'clearForeignConfiguration',
    '4' => 'prepareForRemoval',
    '5' => 'undoPrepareForRemoval',
    '6' => 'globalHotSpare',
    '7' => 'dedicatedHotSpare',
    '8' => 'removeHotSpare',
    '9' => 'ledOn',
    '10' => 'ledOff',
    '11' => 'enableSecurity',
    '12' => 'clearSecureDrive',
    '13' => 'clearSecureForeignConfigDrive',
    '14' => 'unlockForeignDrive',
  },
  'CucsFabricEthPcProtocol' => {
    '1' => 'static',
    '2' => 'lacp',
  },
  'CucsFabricFcSanEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsStorageFFCardMode' => {
    '0' => 'ffPhyDriveUnpairedPrimary',
    '1' => 'ffPhyDrivePrimary',
    '2' => 'ffPhyDriveSecondaryAct',
    '3' => 'ffPhyDriveSecondaryUnhealthy',
  },
  'CucsStorageAlarmType' => {
    '0' => 'minor',
    '1' => 'major',
  },
  'CucsStatsThr32ValuePropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CucsAaaLdapEpFsmStageName' => {
    '0' => 'nop',
    '197' => 'updateEpBegin',
    '198' => 'updateEpSetEpLocal',
    '199' => 'updateEpSetEpPeer',
    '322' => 'updateEpFail',
    '323' => 'updateEpSuccess',
  },
  'CucsAdaptorExtIfRemoteAdminState' => {
    '0' => 'enabled',
    '1' => 'remoteTrigger',
    '44' => 'resetConnectivity',
  },
  'CucsEquipmentPsuFsmTaskItem' => {
    '0' => 'nop',
    '1808' => 'updatePSU',
  },
  'CucsConfigImpactAnalyzerMode' => {
    '0' => 'straight',
    '1' => 'relay',
  },
  'CucsStoragePhysicalHolder' => {
    '0' => 'unknown',
    '1' => 'hddMotherBoard',
    '2' => 'hddExpansionTray',
    '3' => 'dedicatedRearSsdEnclosure',
    '4' => 'sbNvmeEnclosure',
    '5' => 'ioeNvmeEnclosure',
    '6' => 'serverFrontLoad',
    '7' => 'serverPch',
    '8' => 'serverNvme',
  },
  'CucsLsbootIScsiOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CucsFabricSwSrvPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsFabricNetflowMonExporterProtocol' => {
    '1' => 'netflow',
  },
  'CucsBiosVfIntelVTForDirectedIOVpIntelVTDPassThroughDMASupport' => {
    '0' => 'platformRecommended',
    '22' => 'disabled',
    '23' => 'enabled',
  },
  'CucsSwPIoEpLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
    '4' => 'pending',
  },
  'CucsNfsMountInstFsmStageName' => {
    '0' => 'nop',
    '1233' => 'mountBegin',
    '1234' => 'mountRegisterClient',
    '1235' => 'mountVerifyRegistration',
    '1236' => 'mountMountLocal',
    '1237' => 'mountMountPeer',
    '1238' => 'unmountBegin',
    '1239' => 'unmountUnmountLocal',
    '1240' => 'unmountUnmountPeer',
    '1417' => 'mountFail',
    '1418' => 'mountSuccess',
    '1419' => 'unmountFail',
    '1420' => 'unmountSuccess',
  },
  'CucsCommSyslogSourceEvents' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsEquipmentIOCardFsmTaskItem' => {
    '0' => 'nop',
    '1' => 'fePresence',
    '3' => 'feConn',
    '461' => 'resetCmc',
    '961' => 'resetIom',
    '978' => 'muxOffline',
    '1939' => 'evacuate',
    '1941' => 'resetEvacuate',
    '1980' => 'resetPeerCmc',
  },
  'CucsStorageVsanRefSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsExtvmmKeyStoreFsmCurrentFsm' => {
    '0' => 'nop',
    '539' => 'certInstall',
  },
  'CucsFabricAccessType' => {
    '0' => 'lan',
    '1' => 'san',
  },
  'CucsNetworkIfStatsType' => {
    '0' => 'generic',
    '1' => 'broadcast',
    '2' => 'multicast',
    '3' => 'unicast',
    '4' => 'total',
  },
  'CucsBiosVfSriovConfigVpSriov' => {
    '0' => 'platformRecommended',
    '258' => 'disabled',
    '259' => 'enabled',
  },
  'CucsStatsNetworkEndpoint' => {
    '0' => 'ethPorts',
    '1' => 'fcPorts',
    '2' => 'nics',
    '3' => 'hbas',
  },
  'CucsAaaLdapGroupRuleTraversal' => {
    '0' => 'nonRecursive',
    '1' => 'recursive',
  },
  'CucsDiagTestType' => {
    '0' => 'disk',
    '1' => 'processor',
    '2' => 'pmem2',
    '3' => 'memtest',
    '4' => 'stress',
    '5' => 'pci',
  },
  'CucsCommSslProtocol' => {
    '0' => 'all',
    '3' => 'tlsv12',
  },
  'CucsBiosVfResumeOnACPowerLossVpResumeOnACPowerLoss' => {
    '0' => 'platformRecommended',
    '70' => 'stayOff',
    '71' => 'lastState',
    '72' => 'reset',
  },
  'CucsStorageConfigState' => {
    '0' => 'notApplied',
    '1' => 'applying',
    '2' => 'applied',
    '3' => 'applyFailed',
    '4' => 'orphaned',
    '5' => 'notInUse',
    '6' => 'nA',
    '7' => 'unknown',
  },
  'CucsMgmtBackupOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfIntelEntrySASRAIDModuleVpSASRAIDModule' => {
    '0' => 'platformRecommended',
    '156' => 'itIrRaid',
    '157' => 'intelEsrtii',
  },
  'CucsExtvmmProviderFsmTaskItem' => {
    '0' => 'nop',
    '536' => 'config',
    '1130' => 'collectGarbage',
  },
  'CucsMgmtControllerHostagCommMethod' => {
    '0' => 'unknown',
    '1' => 'serial',
    '2' => 'usbNic',
  },
  'CucsLsbootLanType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsStorageIniGroupProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsPolicyControlEpFsmTaskItem' => {
    '0' => 'nop',
    '1199' => 'operate',
  },
  'CucsSwLanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsSwEthLanBorderFsmTaskItem' => {
    '0' => 'nop',
    '224' => 'deploy',
  },
  'CucsSysdebugManualCoreFileExportTargetProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsAdaptorDefaultAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsPolicyDomainActionEvent' => {
    '0' => 'unknown',
    '1' => 'register',
    '2' => 'unregister',
  },
  'CucsFabricEthEstcEpPrio' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsMoFileTxAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsFabricVConSharePref' => {
    '1' => 'exclusiveOnly',
    '2' => 'exclusivePreferred',
    '3' => 'sameTransport',
    '4' => 'differentTransport',
    '5' => 'shared',
  },
  'CucsBiosVfIntelTurboBoostTechVpIntelTurboBoostTech' => {
    '0' => 'platformRecommended',
    '1' => 'disabled',
    '2' => 'enabled',
  },
  'CucsComputePollingState' => {
    '1' => 'started',
    '2' => 'complete',
    '3' => 'pendingRebalance',
    '4' => 'rebalancing',
    '5' => 'systemInit',
    '6' => 'initDone',
  },
  'CucsFdRackUnitFsmStageName' => {
    '0' => 'nop',
    '616' => 'configureBegin',
    '617' => 'configureResolvePolicies',
    '618' => 'configureCollectIdContexts',
    '619' => 'configureApplyThrottle',
    '620' => 'configureThrottleWait',
    '621' => 'configureResolveIdentifiers',
    '622' => 'configureValidateNetworkDesign',
    '623' => 'configureConsumerVxanDeployment',
    '624' => 'configureWaitForConsumerReceivingVxan',
    '625' => 'configurePushPolicies',
    '626' => 'configureApplyConfig',
    '658' => 'configureFail',
    '659' => 'configureSuccess',
  },
  'CucsComputeSystemFsmStageName' => {
    '0' => 'nop',
    '212' => 'registerBegin',
    '213' => 'registerAuthenticate',
    '216' => 'registerFail',
    '217' => 'registerSuccess',
  },
  'CucsExtpolRegistryFsmCurrentFsm' => {
    '0' => 'nop',
    '1351' => 'crossDomainConfig',
    '1354' => 'crossDomainDelete',
  },
  'CucsInventoryTrigState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CucsStorageIniGroupOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '7' => 'initiatorPolicy',
    '8' => 'connPolicy',
  },
  'CucsEquipmentEvacState' => {
    '0' => 'drain',
    '1' => 'fill',
    '2' => 'unknown',
  },
  'CucsSwFcSanBorderUplinkTrunking' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsSysdebugMEpLogOperState' => {
    '0' => 'ok',
    '1' => 'permissionDeniedError',
    '2' => 'remoteCommunicationError',
    '3' => 'bmcCommunicationError',
    '4' => 'internalUcsmError',
  },
  'CucsFabricOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'errorMisconfigured',
    '4' => 'failed',
  },
  'CucsFirmwareAutoSyncConfigIssue' => {
    '0' => 'noIssues',
    '1' => 'defaultPackageMissing',
    '2' => 'versionsEmptyInDefaultPackage',
  },
  'CucsEquipmentIsSupported' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsStorageConfiguration' => {
    '0' => 'unknown',
    '1' => 'supported',
    '2' => 'notSupported',
  },
  'CucsLstorageLunDiskLayout' => {
    '4' => 'raidStriped',
    '5' => 'raidMirrored',
    '8' => 'anyConfiguration',
    '10' => 'raidStripedParity',
    '11' => 'raidStripedDualParity',
    '12' => 'raidMirroredStriped',
    '16' => 'raidStripedParityStriped',
    '17' => 'raidStripedDualParityStriped',
  },
  'CucsAdaptorHostServiceEthIfIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsEquipmentPsuVoltageType' => {
    '0' => 'unknown',
    '1' => 'ac',
    '2' => 'dc',
    '3' => 'dv',
    '4' => 'hvdc',
    '5' => 'nA',
  },
  'CucsOsControllerFsmStageName' => {
    '0' => 'nop',
    '1772' => 'deployOSBegin',
    '1773' => 'deployOSDownloadImages',
    '1774' => 'deployOSCopyRemote',
    '1775' => 'deployOSHostBootForUpgrade',
    '1776' => 'deployOSWaitForSMEConnection',
    '1777' => 'deployOSHostBmcPreConfigLocal',
    '1778' => 'deployOSHostBmcPreConfigPeer',
    '1779' => 'deployOSHostSetupVmediaLocal',
    '1780' => 'deployOSHostSetupVmediaPeer',
    '1781' => 'deployOSHostClearOsInstallStatus',
    '1782' => 'deployOSHostSolRedirectEnable',
    '1783' => 'deployOSHostSerialDebugConnect',
    '1784' => 'deployOSHostBoot',
    '1785' => 'deployOSHostBootWait',
    '1786' => 'deployOSHostBiosPostCompletion',
    '1787' => 'deployOSHostReadSmbios',
    '1788' => 'deployOSHostPreInstall',
    '1789' => 'deployOSHostPostInstall',
    '1790' => 'deployOSHostPreFirstBoot',
    '1791' => 'deployOSHostPostFirstBoot',
    '1792' => 'deployOSHostPostUpgrade',
    '1793' => 'deployOSHostTeardownVmediaLocal',
    '1794' => 'deployOSHostTeardownVmediaPeer',
    '1795' => 'deployOSHostSerialDebugDisconnect',
    '1796' => 'deployOSHostSolRedirectDisable',
    '1797' => 'deployOSDeleteCurlDownloadedImages',
    '1798' => 'deployOSSuccess',
    '1799' => 'deployOSFail',
  },
  'CucsFabricEthMonDestEpOperationAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CucsLstorageScsiTransportProtocol' => {
    '0' => 'unspecified',
    '1' => 'iscsi',
    '2' => 'fcp',
    '3' => 'sas',
    '4' => 'ssa',
    '5' => 'uas',
    '6' => 'scsiParallel',
  },
  'CucsConfigStorageType' => {
    '0' => 'cartridge',
    '1' => 'storageBlade',
  },
  'CucsLsbootNvmeDiskSsdType' => {
    '1' => 'diskSsd',
    '2' => 'pciSsd',
  },
  'CucsFabricLacpSuspend' => {
    '0' => 'false',
    '1' => 'true',
  },
  'CucsSwPortDiscoverFsmStageName' => {
    '0' => 'nop',
    '2249' => 'deployBegin',
    '2250' => 'deployEnablePort',
    '2267' => 'deployFail',
    '2268' => 'deploySuccess',
  },
  'CucsStorageLocalDiskPartitionType' => {
    '1' => 'none',
    '2' => 'swap',
    '3' => 'ext2',
    '4' => 'ext3',
    '5' => 'ntfs',
    '6' => 'fat32',
  },
  'CucsFabricUdldLinkPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsEquipmentControllerDefType' => {
    '0' => 'none',
    '1' => 'embedded',
    '2' => 'slotBased',
    '3' => 'nvme',
    '4' => 'nvmeHhhl',
    '5' => 'nvmeMezz',
    '6' => 'dual',
  },
  'CucsBiosVfOSBootWatchdogTimerTimeoutVpOSBootWatchdogTimerTimeout' => {
    '0' => 'platformRecommended',
    '254' => 'n5Minutes',
    '255' => 'n10Minutes',
    '256' => 'n15Minutes',
    '257' => 'n20Minutes',
  },
  'CucsFabricSanCloudFsmCurrentFsm' => {
    '0' => 'nop',
    '871' => 'switchMode',
  },
  'CucsStorageEnclosureFsmTaskItem' => {
    '0' => 'nop',
    '2019' => 'removeEnclosure',
  },
  'CucsFabricNetflowMonSessionAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsNfsClientDefFsmStageName' => {
    '0' => 'nop',
    '187' => 'addConfigBegin',
    '189' => 'addConfigInternalAdd',
    '190' => 'deleteConfigBegin',
    '191' => 'deleteConfigInternalDelete',
    '208' => 'addConfigFail',
    '209' => 'addConfigSuccess',
    '210' => 'deleteConfigFail',
    '211' => 'deleteConfigSuccess',
    '336' => 'addConfigPeerAdd',
    '337' => 'deleteConfigPeerDelete',
  },
  'CucsQueryOperation' => {
    '1' => 'estimate',
    '2' => 'import',
  },
  'CucsPkiEpFsmCurrentFsm' => {
    '0' => 'nop',
    '206' => 'updateEp',
  },
  'CucsConditionType' => {
    '0' => 'generic',
    '1' => 'policy',
    '2' => 'storage',
    '3' => 'equipment',
    '4' => 'network',
    '5' => 'server',
    '6' => 'configuration',
    '7' => 'environmental',
    '8' => 'connectivity',
    '9' => 'sysdebug',
    '10' => 'operational',
    '11' => 'snmpUserNotDeployed',
    '12' => 'profileConfigQualifier',
    '17' => 'callhome',
    '65535' => 'any',
  },
  'CucsConditionAckAction' => {
    '1' => 'deleteOnClear',
    '2' => 'initialSeverity',
  },
  'CucsSwPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsBiosVfEnhancedIntelSpeedStepTechVpEnhancedIntelSpeedStepTech' => {
    '0' => 'platformRecommended',
    '3' => 'disabled',
    '4' => 'enabled',
  },
  'CucsComputeResourceSetState' => {
    '1' => 'inventoryPending',
    '2' => 'inventoryInProgress',
    '3' => 'inventoryComplete',
  },
  'CucsStatsChartDomain' => {
    '0' => 'network',
    '1' => 'temp',
    '2' => 'power',
    '3' => 'cooling',
  },
  'CucsAdaptorEthOffloadProfileTcpSegment' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsLsComputeBindingOperState' => {
    '0' => 'unused',
    '1' => 'used',
    '2' => 'failedToApply',
  },
  'CucsLicenseInstanceFsmCurrentFsm' => {
    '0' => 'nop',
    '929' => 'updateFlexlm',
  },
  'CucsGlIdentCtxResOpFsmTaskItem' => {
    '0' => 'nop',
    '581' => 'validateId',
  },
  'CucsStorageFFCardWriteEnable' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsLsbootEFIShellAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsComputePsuRedundancy' => {
    '1' => 'nonRedundant',
    '2' => 'nPlus1',
    '3' => 'grid',
  },
  'CucsFabricEthEstcEpOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsSwExtUtilityFsmCurrentFsm' => {
    '0' => 'nop',
    '1985' => 'confPortBreakout',
  },
  'CucsComputeCheckPoint' => {
    '0' => 'unknown',
    '1' => 'removing',
    '2' => 'shallowCheckpoint',
    '3' => 'deepCheckpoint',
    '4' => 'discovered',
  },
  'CucsMgmtSchedStatus' => {
    '0' => 'unknown',
    '1' => 'notFound',
  },
  'CucsStorageEnclosureFsmCurrentFsm' => {
    '0' => 'nop',
    '2019' => 'removeEnclosure',
  },
  'CucsEtherSwitchIntFIoPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsBiosVfSBMezz1OptionROMVpSBMezz1OptionROM' => {
    '0' => 'platformRecommended',
    '580' => 'disabled',
    '581' => 'enabled',
    '582' => 'uefiOnly',
    '583' => 'legacyOnly',
  },
  'CucsLsbootNvmeType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsCommSnmpProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsSmartlicenseTestDevCertEnableType' => {
    '0' => 'none',
    '1' => 'enable',
    '2' => 'disable',
  },
  'CucsBiosVfOSBootWatchdogTimerVpOSBootWatchdogTimer' => {
    '0' => 'platformRecommended',
    '114' => 'disabled',
    '115' => 'enabled',
  },
  'CucsFabricBladeLifeCycle' => {
    '1' => 'inService',
    '2' => 'outOfService',
    '3' => 'outOfServiceSlave',
  },
  'CucsBiosVfACPI10SupportVpACPI10Support' => {
    '0' => 'platformRecommended',
    '122' => 'disabled',
    '123' => 'enabled',
  },
  'CucsComputeOperBackplaneSpeedChassisPref' => {
    '0' => 'n40G',
    '1' => 'n4x10G',
    '2' => 'global',
    '255' => 'unspecified',
  },
  'CucsFirmwareAdminState' => {
    '0' => 'active',
    '1' => 'deleted',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortFront' => {
    '0' => 'platformRecommended',
    '395' => 'disabled',
    '396' => 'enabled',
  },
  'CucsCimcvmediaImageNameVariable' => {
    '0' => 'none',
    '1' => 'serviceProfileName',
  },
  'CucsBiosVfLocalX2ApicVpLocalX2Apic' => {
    '0' => 'platformRecommended',
    '271' => 'xapic',
    '272' => 'x2apic',
    '273' => 'auto',
  },
  'CucsEquipmentUnifiedPortAlgorithm' => {
    '0' => 'none',
    '1' => 'slideRuleEthFirstDoubleRow',
    '2' => 'unrestricted',
    '3' => 'slideRuleEthFirstSingleRow',
    '4' => 'slideRuleFcFirstDoubleRow',
    '5' => 'slideRuleFcFirstSingleRow',
    '6' => 'slideRuleFcFirst3gfiRow',
  },
  'CucsComputeRackUnitFsmTaskItem' => {
    '0' => 'nop',
    '599' => 'discover',
    '1064' => 'offline',
    '1316' => 'adapterReset',
    '1510' => 'createDhcpEntry',
  },
  'CucsFirmwarePackMode' => {
    '0' => 'staged',
    '1' => 'oneShot',
  },
  'CucsGlIdentCtxResOpFsmStageName' => {
    '0' => 'nop',
    '581' => 'validateIdBegin',
    '582' => 'validateIdValidate',
    '660' => 'validateIdFail',
    '661' => 'validateIdSuccess',
  },
  'CucsMgmtExportPolicyFsmStageName' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopyBegin',
    '1188' => 'reportConfigCopyReport',
    '1411' => 'reportConfigCopyFail',
    '1412' => 'reportConfigCopySuccess',
  },
  'CucsAdaptorHostEthIfFsmCurrentFsm' => {
    '0' => 'nop',
    '505' => 'circuitReset',
  },
  'CucsBiosVfMemoryMappedIOAbove4GBVpMemoryMappedIOAbove4GB' => {
    '0' => 'platformRecommended',
    '56' => 'disabled',
    '57' => 'enabled',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlotMezzState' => {
    '0' => 'platformRecommended',
    '220' => 'disabled',
    '221' => 'enabled',
    '412' => 'uefiOnly',
    '413' => 'legacyOnly',
  },
  'CucsHostimgImgType' => {
    '0' => 'unknown',
    '1' => 'esxi',
    '2' => 'kvm',
    '3' => 'xen',
    '4' => 'linux',
    '5' => 'windows',
    '6' => 'gpxeScript',
  },
  'CucsFirmwareImageState' => {
    '0' => 'ready',
    '1' => 'scheduled',
    '2' => 'updating',
    '3' => 'activating',
    '4' => 'failed',
    '5' => 'setStartup',
    '6' => 'rebooting',
    '7' => 'pendingNextBoot',
    '8' => 'throttled',
    '9' => 'upgrading',
    '10' => 'autoUpdating',
    '11' => 'badImage',
    '12' => 'pendingPowerCycle',
    '14' => 'rebuilding',
    '15' => 'faultyState',
  },
  'CucsFabricEthFlowMonSourceType' => {
    '1' => 'vnic',
    '2' => 'portProfile',
  },
  'CucsLstorageCtrlAdminState' => {
    '1' => 'inService',
    '3' => 'inMaintenance',
  },
  'CucsLicenseDownloaderFsmTaskItem' => {
    '0' => 'nop',
    '853' => 'download',
  },
  'CucsLsAgentCapability' => {
    '1' => 'l2IfConfig',
    '2' => 'l3IfConfig',
    '4' => 'hostNameConfig',
    '8' => 'stats',
    '16' => 'states',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot4State' => {
    '0' => 'platformRecommended',
    '216' => 'disabled',
    '217' => 'enabled',
    '451' => 'uefiOnly',
    '452' => 'legacyOnly',
  },
  'CucsExtpolVersionHolderOperation' => {
    '0' => 'noOperation',
    '1' => 'add',
    '2' => 'delete',
  },
  'CucsAdaptorMgmtCapOperPowerRequirement' => {
    '0' => 'none',
    '1' => 'standby',
    '2' => 'full',
  },
  'CucsFabricVlanOverlapState' => {
    '0' => 'notActive',
    '1' => 'ok',
    '2' => 'sharingTypeMismatch',
    '3' => 'primaryIdMismatch',
    '4' => 'active',
  },
  'CucsFabricCIoEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsVnicEtherBaseIfSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsIppoolManagementMode' => {
    '0' => 'internal',
    '1' => 'external',
  },
  'CucsPolicyPolicyScopeFsmStageName' => {
    '0' => 'nop',
    '1201' => 'releasePolicyFsmBegin',
    '1202' => 'releasePolicyFsmRelease',
    '1203' => 'releaseOperationFsmBegin',
    '1204' => 'releaseOperationFsmRelease',
    '1205' => 'releaseStorageFsmBegin',
    '1206' => 'releaseStorageFsmRelease',
    '1207' => 'resolveManyPolicyFsmBegin',
    '1208' => 'resolveManyPolicyFsmResolveMany',
    '1209' => 'resolveManyOperationFsmBegin',
    '1210' => 'resolveManyOperationFsmResolveMany',
    '1211' => 'resolveManyStorageFsmBegin',
    '1212' => 'resolveManyStorageFsmResolveMany',
    '1213' => 'releaseManyPolicyFsmBegin',
    '1214' => 'releaseManyPolicyFsmReleaseMany',
    '1215' => 'releaseManyOperationFsmBegin',
    '1216' => 'releaseManyOperationFsmReleaseMany',
    '1217' => 'releaseManyStorageFsmBegin',
    '1218' => 'releaseManyStorageFsmReleaseMany',
    '1219' => 'resolveAllPolicyFsmBegin',
    '1220' => 'resolveAllPolicyFsmResolveAll',
    '1221' => 'resolveAllOperationFsmBegin',
    '1222' => 'resolveAllOperationFsmResolveAll',
    '1223' => 'resolveAllStorageFsmBegin',
    '1224' => 'resolveAllStorageFsmResolveAll',
    '1225' => 'releaseAllPolicyFsmBegin',
    '1226' => 'releaseAllPolicyFsmReleaseAll',
    '1227' => 'releaseAllOperationFsmBegin',
    '1228' => 'releaseAllOperationFsmReleaseAll',
    '1229' => 'releaseAllStorageFsmBegin',
    '1230' => 'releaseAllStorageFsmReleaseAll',
    '1431' => 'releaseAllOperationFsmFail',
    '1432' => 'releaseAllOperationFsmSuccess',
    '1433' => 'releaseAllPolicyFsmFail',
    '1434' => 'releaseAllPolicyFsmSuccess',
    '1435' => 'releaseAllStorageFsmFail',
    '1436' => 'releaseAllStorageFsmSuccess',
    '1437' => 'releaseManyOperationFsmFail',
    '1438' => 'releaseManyOperationFsmSuccess',
    '1439' => 'releaseManyPolicyFsmFail',
    '1440' => 'releaseManyPolicyFsmSuccess',
    '1441' => 'releaseManyStorageFsmFail',
    '1442' => 'releaseManyStorageFsmSuccess',
    '1443' => 'releaseOperationFsmFail',
    '1444' => 'releaseOperationFsmSuccess',
    '1445' => 'releasePolicyFsmFail',
    '1446' => 'releasePolicyFsmSuccess',
    '1447' => 'releaseStorageFsmFail',
    '1448' => 'releaseStorageFsmSuccess',
    '1449' => 'resolveAllOperationFsmFail',
    '1450' => 'resolveAllOperationFsmSuccess',
    '1451' => 'resolveAllPolicyFsmFail',
    '1452' => 'resolveAllPolicyFsmSuccess',
    '1453' => 'resolveAllStorageFsmFail',
    '1454' => 'resolveAllStorageFsmSuccess',
    '1455' => 'resolveManyOperationFsmFail',
    '1456' => 'resolveManyOperationFsmSuccess',
    '1457' => 'resolveManyPolicyFsmFail',
    '1458' => 'resolveManyPolicyFsmSuccess',
    '1459' => 'resolveManyStorageFsmFail',
    '1460' => 'resolveManyStorageFsmSuccess',
  },
  'CucsAaaRadiusEpFsmStageName' => {
    '0' => 'nop',
    '197' => 'updateEpBegin',
    '198' => 'updateEpSetEpLocal',
    '199' => 'updateEpSetEpPeer',
    '322' => 'updateEpFail',
    '323' => 'updateEpSuccess',
  },
  'CucsSysdebugAutoCoreFileExportTargetProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsComputeAssociation' => {
    '0' => 'none',
    '1' => 'establishing',
    '2' => 'associated',
    '3' => 'removing',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CucsLsAssignment' => {
    '0' => 'unassigned',
    '1' => 'assigned',
    '2' => 'failed',
  },
  'CucsEpqosDefinitionDelTaskFsmTaskItem' => {
    '0' => 'nop',
    '319' => 'remove',
  },
  'CucsLicenseDownloaderFsmCurrentFsm' => {
    '0' => 'nop',
    '916' => 'download',
  },
  'CucsFabricComputeSlotEpFsmTaskItem' => {
    '0' => 'nop',
    '20' => 'identify',
  },
  'CucsFirmwareDeployment' => {
    '0' => 'unspecified',
    '1' => 'kernel',
    '2' => 'bootLoader',
    '3' => 'system',
    '4' => 'backup',
    '5' => 'provider',
    '6' => 'servicePack',
  },
  'CucsConfigSearchType' => {
    '0' => 'contains',
    '1' => 'startsWith',
    '2' => 'exactMatch',
  },
  'CucsBiosVfDirectCacheAccessVpDirectCacheAccess' => {
    '0' => 'platformRecommended',
    '28' => 'disabled',
    '29' => 'enabled',
    '559' => 'auto',
  },
  'CucsComputeFactoryResetTrigger' => {
    '0' => 'idle',
    '1' => 'triggered',
    '2' => 'canceled',
  },
  'CucsFabricEthLanFlowMonitoringType' => {
    '0' => 'unknown',
    '1' => 'ethFlowMonitoring',
    '2' => 'span',
  },
  'CucsLicenseInitializationState' => {
    '0' => 'uninitialized',
    '1' => 'initialized',
  },
  'CucsFabricEpVlanVlanType' => {
    '0' => 'regular',
    '1' => 'default',
    '2' => 'native',
    '3' => 'fcoeuplinknative',
  },
  'CucsLicenseInstanceFsmTaskItem' => {
    '0' => 'nop',
    '864' => 'updateFlexlm',
  },
  'CucsSwVlanGroupType' => {
    '1' => 'compressed',
    '2' => 'uncompressed',
    '3' => 'vpCompressed',
  },
  'CucsStorageFFSlotENUM' => {
    '0' => 'na',
    '1' => 'n1',
    '2' => 'n2',
  },
  'CucsStatsPasadenaCollectionPolicyCollectionInterval' => {
    '0' => 'never',
    '1' => 'n1min',
    '2' => 'n2min',
    '5' => 'n5min',
    '10' => 'n10min',
    '15' => 'n15min',
    '30' => 'n30min',
  },
  'CucsFabricSlotAdminState' => {
    '1' => 'acknowledged',
    '3' => 'reacknowledge',
  },
  'CucsObserveObservedFsmStageName' => {
    '0' => 'nop',
    '1341' => 'resolvePolicyFsmBegin',
    '1342' => 'resolvePolicyFsmExecute',
    '1343' => 'resolveResourceFsmBegin',
    '1344' => 'resolveResourceFsmExecute',
    '1345' => 'resolveVMFsmBegin',
    '1346' => 'resolveVMFsmExecute',
    '1347' => 'resolveControllerFsmBegin',
    '1348' => 'resolveControllerFsmExecute',
    '1421' => 'resolveControllerFsmFail',
    '1422' => 'resolveControllerFsmSuccess',
    '1423' => 'resolvePolicyFsmFail',
    '1424' => 'resolvePolicyFsmSuccess',
    '1425' => 'resolveResourceFsmFail',
    '1426' => 'resolveResourceFsmSuccess',
    '1427' => 'resolveVMFsmFail',
    '1428' => 'resolveVMFsmSuccess',
  },
  'CucsLicenseFileFsmTaskItem' => {
    '0' => 'nop',
    '858' => 'install',
    '861' => 'clear',
  },
  'CucsSmartlicenseAgentFsmTaskItem' => {
    '0' => 'nop',
    '480' => 'configure',
  },
  'CucsFabricInternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFirmwareDownloaderFsmCurrentFsm' => {
    '0' => 'nop',
    '233' => 'download',
  },
  'CucsStorageCtrlAdminState' => {
    '1' => 'inService',
    '3' => 'inMaintenance',
    '4' => 'fullMaintenance',
  },
  'CucsDiagStatus' => {
    '0' => 'unknown',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'notRun',
    '4' => 'cancelled',
    '5' => 'scheduled',
  },
  'CucsMemoryBackupAbility' => {
    '0' => 'unknown',
    '1' => 'notReady',
    '2' => 'ready',
  },
  'CucsComputeInventoryStatus' => {
    '0' => 'ok',
    '1' => 'mismatch',
    '2' => 'throttled',
    '4' => 'removal',
    '8' => 'replacement',
    '16' => 'pciConfigMismatch',
  },
  'CucsGlRequestVnetEpFsmCurrentFsm' => {
    '0' => 'nop',
    '601' => 'evalReq',
  },
  'CucsAaaAuthRealmFsmCurrentFsm' => {
    '0' => 'nop',
    '200' => 'updateRealm',
  },
  'CucsFirmwareUpgradeCategory' => {
    '0' => 'other',
    '1' => 'dataLoad',
    '2' => 'catalog',
    '3' => 'config',
    '4' => 'serverReboot',
    '5' => 'faults',
  },
  'CucsLstorageControllerQualifierControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
    '5' => 'pt',
    '6' => 'pch',
    '7' => 'external',
    '8' => 'nvme',
    '9' => 'hba',
    '10' => 'm2',
  },
  'CucsFabricFcSanPcOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsPkiEpFsmStageName' => {
    '0' => 'nop',
    '206' => 'updateEpBegin',
    '207' => 'updateEpSetKeyRingLocal',
    '208' => 'updateEpSetKeyRingPeer',
    '389' => 'updateEpSetCertConfLocal',
    '428' => 'updateEpFail',
    '429' => 'updateEpSuccess',
    '1491' => 'updateEpPostSetKeyRingLocal',
    '1492' => 'updateEpPostSetKeyRingPeer',
  },
  'CucsEtherPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresence',
    '1334' => 'inCompatSfpReplaced',
  },
  'CucsFabricMembershipStatus' => {
    '1' => 'down',
    '2' => 'up',
    '3' => 'hotStandby',
    '4' => 'suspended',
    '5' => 'individual',
    '6' => 'moduleRemoved',
    '7' => 'incompatibleSpeed',
    '8' => 'unknown',
  },
  'CucsBiosVfPCHSATAModeVpPCHSATAMode' => {
    '0' => 'platformRecommended',
    '497' => 'ahci',
    '498' => 'disabled',
    '499' => 'lsiSwRaid',
  },
  'CucsPortTrust' => {
    '0' => 'trusted',
    '1' => 'untrusted',
  },
  'CucsFabricDefaultZoningState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsAdaptorUnitVisibility' => {
    '0' => 'visible',
    '1' => 'notVisible',
  },
  'CucsStorageIniGroupOperProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsStorageScsiLunCtxLunCfgAction' => {
    '0' => 'triggered',
    '1' => 'delete',
    '2' => 'online',
    '3' => 'offline',
    '4' => 'createSnapshot',
    '5' => 'createReplication',
    '6' => 'abortReplication',
    '7' => 'enableReplication',
    '8' => 'disableReplication',
    '10' => 'restore',
  },
  'CucsExtpolScanEnablementState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CucsExtvmmSwitchDelTaskFsmStageName' => {
    '0' => 'nop',
    '542' => 'removeProviderBegin',
    '543' => 'removeProviderRemoveLocal',
    '565' => 'removeProviderFail',
    '566' => 'removeProviderSuccess',
  },
  'CucsDiagSrvCtrlOperationFsmStageName' => {
    '0' => 'nop',
    '612' => 'configureBegin',
    '613' => 'configureRunPolicyResolve',
    '614' => 'configureWaitForRunPolicyResolved',
    '615' => 'configureTriggerOperation',
    '652' => 'configureFail',
    '653' => 'configureSuccess',
  },
  'CucsStorageEnclosureAdminState' => {
    '0' => 'acknowledged',
    '1' => 'remove',
    '2' => 'removing',
    '3' => 'removeFailed',
  },
  'CucsLsbootEmbeddedLocalDiskImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
    '6' => 'localJbod',
    '7' => 'embeddedLocalLun',
    '8' => 'embeddedLocalJbod',
    '9' => 'nvme',
  },
  'CucsVnicConnectionOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '7' => 'initiatorPolicy',
    '8' => 'connPolicy',
  },
  'CucsAaaNoRolePolicy' => {
    '0' => 'noLogin',
    '1' => 'assignDefaultRole',
  },
  'CucsGlBlockIssueType' => {
    '0' => 'default',
    '1' => 'vxan',
  },
  'CucsComputeServerDiscPolicyFsmTaskItem' => {
    '0' => 'nop',
    '1231' => 'resolveScrubPolicy',
  },
  'CucsLstorageOperMaintState' => {
    '0' => 'unknown',
    '1' => 'inService',
    '2' => 'inMaintenance',
    '3' => 'enteringMaintenance',
    '4' => 'exitingMaintenance',
    '5' => 'notApplicable',
  },
  'CucsDiagSrvCtrlOperationFsmTaskItem' => {
    '0' => 'nop',
    '612' => 'configure',
  },
  'CucsFcpoolInitiatorsPurpose' => {
    '0' => 'nodeAndPortWwnAssignment',
    '1' => 'portWwnAssignment',
    '2' => 'nodeWwnAssignment',
  },
  'CucsQosclassFcDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CucsFabricComputePhEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsCommSnmpEncryptionAlgoType' => {
    '1' => 'none',
    '2' => 'aes',
  },
  'CucsEquipmentFexCapProviderRole' => {
    '1' => 'mgmt',
    '2' => 'data',
    '3' => 'full',
  },
  'CucsComputeUpgradeStatus' => {
    '0' => 'notUpgraded',
    '1' => 'upgraded',
    '2' => 'notApplicable',
  },
  'CucsAaaConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CucsNfsExportDefFsmStageName' => {
    '0' => 'nop',
    '338' => 'imageSyncBegin',
    '339' => 'imageSyncLocal',
    '340' => 'addRepoBegin',
    '341' => 'addRepoLocal',
    '344' => 'addRepoFail',
    '345' => 'addRepoSuccess',
    '346' => 'imageSyncFail',
    '347' => 'imageSyncSuccess',
  },
  'CucsCimcvmediaErrorType' => {
    '0' => 'unknown',
    '1' => 'none',
    '2' => 'genericFailure',
    '3' => 'connectionTimeout',
    '4' => 'connectionRejected',
    '5' => 'authenticationFailed',
    '6' => 'badPath',
    '7' => 'badParam',
    '8' => 'invalidVdiskUsage',
    '9' => 'invalidVdiskType',
    '10' => 'alreadyMapped',
    '11' => 'imageStoreFull',
    '12' => 'fileNotFound',
    '13' => 'openRoFailed',
    '14' => 'openRwFailed',
    '15' => 'diskEjected',
    '16' => 'diskIoFailure',
    '17' => 'writeToReadonlyFile',
    '18' => 'mountInUse',
    '19' => 'invalidArgument',
    '20' => 'imgageDeleted',
    '21' => 'postmapError',
    '22' => 'httpServerNoContentLength',
    '23' => 'httpServerNoRangeSupport',
  },
  'CucsFabricComputeMSlotEpFsmCurrentFsm' => {
    '0' => 'nop',
    '1877' => 'identify',
  },
  'CucsHostagAgentType' => {
    '0' => 'indeterminate',
    '1' => 'pnuosAgent',
    '2' => 'hostAgent',
  },
  'CucsMgmtEntityMgmtServicesState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'unresponsive',
    '3' => 'down',
    '4' => 'switchoverInProgress',
  },
  'CucsEquipmentBoardConnectorType' => {
    '1' => 'connUnlinked',
    '2' => 'connLinked',
  },
  'CucsAaaIpmiOverLan' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsAaaExtMgmtAccess' => {
    '1' => 'kvm',
  },
  'CucsTrigChassisAckMode' => {
    '0' => 'userAck',
    '3' => 'unspecified',
  },
  'CucsMgmtASecureBootAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsAdaptorLanCapDefaultVlan' => {
    '1' => 'nativeVlan',
    '2' => 'defaultVlan',
  },
  'CucsPolicyPolicyScopeContFsmStageName' => {
    '0' => 'nop',
    '2251' => 'reportPolicyFailFsmBegin',
    '2252' => 'reportPolicyFailFsmReportError',
    '2263' => 'reportPolicyFailFsmFail',
    '2264' => 'reportPolicyFailFsmSuccess',
  },
  'CucsConfigSPType' => {
    '0' => 'all',
    '1' => 'local',
    '2' => 'global',
  },
  'CucsFirmwareInstallState' => {
    '0' => 'ready',
    '1' => 'scheduled',
    '2' => 'inProgress',
    '3' => 'failed',
    '4' => 'pendingUserAck',
    '5' => 'startPendingExtPermission',
  },
  'CucsEquipmentHealthLedState' => {
    '0' => 'normal',
    '1' => 'minor',
    '2' => 'critical',
  },
  'CucsComputePowerTransitionSrc' => {
    '0' => 'unknown',
    '1' => 'userUnknown',
    '2' => 'userFp',
    '3' => 'software',
    '4' => 'softwareMcserver',
  },
  'CucsStorageSasLinkDescriptorControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
    '5' => 'pt',
    '6' => 'pch',
    '7' => 'external',
    '8' => 'nvme',
    '9' => 'hba',
    '10' => 'm2',
  },
  'CucsPolicyControlOpSource' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
    '3' => 'unspecified',
  },
  'CucsStorageConnectionProtocol' => {
    '0' => 'unspecified',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'nvme',
  },
  'CucsFabricFcZoneConfigState' => {
    '0' => 'notApplied',
    '1' => 'applied',
    '2' => 'applying',
    '11' => 'failedToApply',
  },
  'CucsSysdebugManualCoreFileExportTargetFsmStageName' => {
    '0' => 'nop',
    '214' => 'exportBegin',
    '215' => 'exportExecute',
    '448' => 'exportFail',
    '449' => 'exportSuccess',
  },
  'CucsEtherServerIntFIoPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsMemoryErrorCorrection' => {
    '0' => 'undiscovered',
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'none',
    '4' => 'parity',
    '5' => 'singleBitECC',
    '6' => 'multiBitECC',
    '7' => 'crc',
  },
  'CucsStorageFFRAIDHealth' => {
    '0' => 'ffrHealthNa',
    '1' => 'ffrHealthOk',
    '2' => 'ffrHealthDegraded',
    '3' => 'ffrHealthNotReporting',
  },
  'CucsSwPhysFsmCurrentFsm' => {
    '0' => 'nop',
    '1121' => 'confPhysical',
  },
  'CucsLstorageVirtualDriveDefIoPolicy' => {
    '0' => 'unknown',
    '1' => 'direct',
    '2' => 'cached',
  },
  'CucsTrigSchedMode' => {
    '0' => 'advanced',
    '1' => 'simple',
  },
  'CucsComputeLinkAggregation' => {
    '0' => 'none',
    '1' => 'portChannel',
  },
  'CucsMemoryHeartbeatStatus' => {
    '0' => 'unknown',
    '1' => 'disabled',
    '2' => 'running',
    '3' => 'timedOut',
  },
  'CucsNfsExportConfigState' => {
    '0' => 'none',
    '1' => 'added',
    '2' => 'remove',
  },
  'CucsSmartlicenseAgentFsmStageName' => {
    '0' => 'nop',
    '480' => 'configureBegin',
    '481' => 'configureConfig',
    '516' => 'configureFail',
    '517' => 'configureSuccess',
  },
  'CucsControllerEpFsmCurrentFsm' => {
    '0' => 'nop',
    '315' => 'quiesce',
  },
  'CucsLicenseTransport' => {
    '0' => 'ftp',
    '1' => 'tftp',
    '2' => 'scp',
    '3' => 'sftp',
    '4' => 'local',
  },
  'CucsAaaRadiusEpFsmCurrentFsm' => {
    '0' => 'nop',
    '197' => 'updateEp',
  },
  'CucsCertRepairEpFsmStageName' => {
    '0' => 'nop',
    '50' => 'repairCertBegin',
    '51' => 'repairCertRequest',
    '52' => 'repairCertVerify',
    '99' => 'repairCertFail',
    '100' => 'repairCertSuccess',
  },
  'CucsFcPIoFsmStageName' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresenceBegin',
    '1015' => 'inCompatSfpPresenceShutdown',
    '1034' => 'inCompatSfpPresenceFail',
    '1035' => 'inCompatSfpPresenceSuccess',
    '1334' => 'inCompatSfpReplacedBegin',
    '1335' => 'inCompatSfpReplacedEnablePort',
    '1461' => 'inCompatSfpReplacedFail',
    '1462' => 'inCompatSfpReplacedSuccess',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot5LinkSpeed' => {
    '0' => 'platformRecommended',
    '341' => 'gen1',
    '342' => 'gen2',
    '343' => 'gen3',
    '344' => 'auto',
    '345' => 'disabled',
  },
  'CucsBiosVfASPMSupportVpASPMSupport' => {
    '0' => 'platformRecommended',
    '508' => 'disabled',
    '509' => 'auto',
    '510' => 'forcel0',
  },
  'CucsSysdebugCoreFsmCurrentFsm' => {
    '0' => 'nop',
    '1041' => 'download',
  },
  'CucsAdaptorMenloQueueStatsComponent' => {
    '0' => 'unknown',
    '1' => 'cpu',
    '2' => 'eth',
    '3' => 'fc',
    '4' => 'n',
  },
  'CucsStorageCtrlClusterState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'degraded',
  },
  'CucsVnicVnicBootDev' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortInternal' => {
    '0' => 'platformRecommended',
    '397' => 'disabled',
    '398' => 'enabled',
  },
  'CucsStorageOperationState' => {
    '0' => 'unknown',
    '1' => 'inProgress',
    '2' => 'completed',
    '3' => 'failed',
  },
  'CucsCommAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsVnicIScsiNodeOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '7' => 'initiatorPolicy',
    '8' => 'connPolicy',
  },
  'CucsFirmwareCatalogPackConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
    '2' => 'failed',
  },
  'CucsFabricDceSwSrvEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsFabricCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsPowerReqConflict' => {
    '0' => 'ignore',
    '1' => 'failPlacement',
  },
  'CucsIdentpoolConsType' => {
    '1' => 'vnic',
    '2' => 'vhba',
    '3' => 'server',
    '4' => 'chassis',
    '5' => 'vm',
    '6' => 'vmnic',
  },
  'CucsMgmtControllerFsmStageName' => {
    '0' => 'nop',
    '17' => 'extMgmtIfConfigBegin',
    '18' => 'extMgmtIfConfigPrimary',
    '19' => 'extMgmtIfConfigSecondary',
    '248' => 'updateSwitchBegin',
    '249' => 'updateSwitchUpdateLocal',
    '250' => 'updateSwitchResetLocal',
    '251' => 'updateSwitchUpdateRemote',
    '252' => 'updateSwitchResetRemote',
    '253' => 'updateIOMBegin',
    '254' => 'updateIOMUpdateRequest',
    '255' => 'updateIOMPollUpdateStatus',
    '256' => 'activateIOMBegin',
    '257' => 'activateIOMActivate',
    '258' => 'activateIOMReset',
    '259' => 'updateBMCBegin',
    '260' => 'updateBMCUpdateRequest',
    '261' => 'updateBMCPollUpdateStatus',
    '262' => 'activateBMCBegin',
    '263' => 'activateBMCActivate',
    '264' => 'activateBMCReset',
    '400' => 'activateBMCFail',
    '401' => 'activateBMCSuccess',
    '402' => 'activateIOMFail',
    '403' => 'activateIOMSuccess',
    '404' => 'extMgmtIfConfigFail',
    '405' => 'extMgmtIfConfigSuccess',
    '406' => 'updateBMCFail',
    '407' => 'updateBMCSuccess',
    '408' => 'updateIOMFail',
    '409' => 'updateIOMSuccess',
    '412' => 'updateSwitchFail',
    '413' => 'updateSwitchSuccess',
    '467' => 'updateUCSManagerBegin',
    '468' => 'updateUCSManagerExecute',
    '469' => 'updateUCSManagerFail',
    '470' => 'updateUCSManagerSuccess',
    '471' => 'updateUCSManagerStart',
    '472' => 'updateSwitchVerifyLocal',
    '473' => 'updateSwitchVerifyRemote',
    '474' => 'sysConfigBegin',
    '475' => 'sysConfigPrimary',
    '476' => 'sysConfigSecondary',
    '477' => 'sysConfigFail',
    '478' => 'sysConfigSuccess',
    '1059' => 'onlineBegin',
    '1060' => 'onlineBmcConfigureConnLocal',
    '1061' => 'onlineSwConfigureConnLocal',
    '1062' => 'onlineBmcConfigureConnPeer',
    '1063' => 'onlineSwConfigureConnPeer',
    '1075' => 'onlineFail',
    '1076' => 'onlineSuccess',
    '1191' => 'registryConfigBegin',
    '1192' => 'registryConfigRemove',
    '1357' => 'updateUCSManagerCopyExtToLocal',
    '1358' => 'updateUCSManagerCopyExtToPeer',
    '1359' => 'updateSwitchCopyToLocal',
    '1360' => 'updateSwitchCopyToPeer',
    '1409' => 'registryConfigFail',
    '1410' => 'registryConfigSuccess',
    '1493' => 'extMgmtInterfaceConfigBegin',
    '1494' => 'extMgmtInterfaceConfigCIMCVlanCfgLocal',
    '1495' => 'extMgmtInterfaceConfigCIMCVlanCfgPeer',
    '1496' => 'extMgmtInterfaceConfigCMCVlanCfg',
    '1497' => 'extMgmtInterfaceConfigCMCVlanCfgPeer',
    '1498' => 'extMgmtInterfaceConfigActive',
    '1556' => 'extMgmtInterfaceConfigFail',
    '1557' => 'extMgmtInterfaceConfigSuccess',
    '1594' => 'updateIOMCopyImgFromRep',
    '1597' => 'updateIOMCopyIOMImgToSub',
    '1686' => 'lockConfigBegin',
    '1687' => 'lockConfigPowerButtonLockConfig',
    '1688' => 'powerBudgetReclaimConfigBegin',
    '1689' => 'powerBudgetReclaimConfigPowerOffWait',
    '1690' => 'powerBudgetReclaimConfigPowerOffReclaim',
    '1825' => 'lockConfigFail',
    '1826' => 'lockConfigSuccess',
    '1827' => 'powerBudgetReclaimConfigFail',
    '1828' => 'powerBudgetReclaimConfigSuccess',
    '1845' => 'updateCMCBegin',
    '1846' => 'updateCMCUpdateRequest',
    '1847' => 'updateCMCPollUpdateStatus',
    '1848' => 'activateCMCBegin',
    '1849' => 'activateCMCActivate',
    '1850' => 'activateCMCReset',
    '1851' => 'activateCMCPollActivation',
    '1852' => 'updateAdaptorBegin',
    '1853' => 'updateAdaptorUpdateRequest',
    '1854' => 'updateAdaptorPollUpdateStatus',
    '1855' => 'activateAdaptorBegin',
    '1856' => 'activateAdaptorActivate',
    '1857' => 'activateAdaptorPowerOffServers',
    '1858' => 'activateAdaptorServersPowerOffCompletion',
    '1859' => 'activateAdaptorReset',
    '1860' => 'activateAdaptorPollActivateStatus',
    '1861' => 'updateRaidControllerBegin',
    '1862' => 'updateRaidControllerUpdateRequest',
    '1863' => 'updateRaidControllerPollUpdateStatus',
    '1864' => 'updateRaidControllerPowerOffServers',
    '1865' => 'updateRaidControllerServersPowerOffCompletion',
    '1866' => 'updateRaidControllerActivate',
    '1867' => 'updateRaidControllerPollActivation',
    '1868' => 'updateBoardControllerBegin',
    '1869' => 'updateBoardControllerPrepareForUpdate',
    '1870' => 'updateBoardControllerPowerOffServers',
    '1871' => 'updateBoardControllerServersPowerOffCompletion',
    '1872' => 'updateBoardControllerUpdateRequest',
    '1873' => 'updateBoardControllerPollUpdateStatus',
    '1921' => 'activateAdaptorFail',
    '1922' => 'activateAdaptorSuccess',
    '1923' => 'activateCMCFail',
    '1924' => 'activateCMCSuccess',
    '1925' => 'updateAdaptorFail',
    '1926' => 'updateAdaptorSuccess',
    '1927' => 'updateBoardControllerFail',
    '1928' => 'updateBoardControllerSuccess',
    '1929' => 'updateCMCFail',
    '1930' => 'updateCMCSuccess',
    '1931' => 'updateRaidControllerFail',
    '1932' => 'updateRaidControllerSuccess',
    '2024' => 'powerCapBegin',
    '2025' => 'powerCapConfig',
    '2028' => 'extMgmtInterfaceConfigStandbyCMCVlanCfg',
    '2103' => 'enableSecureBootBegin',
    '2104' => 'enableSecureBootUpdateRequest',
    '2105' => 'enableSecureBootPollUpdateStatus',
    '2106' => 'enableSecureBootReset',
    '2107' => 'enableSecureBootPollSecureBootStatus',
    '2108' => 'updateColusaCMCBegin',
    '2109' => 'updateColusaCMCUpdateRequest',
    '2110' => 'updateColusaCMCPollUpdateStatus',
    '2111' => 'activateColusaCMCBegin',
    '2112' => 'activateColusaCMCActivate',
    '2113' => 'activateColusaCMCReset',
    '2114' => 'activateColusaCMCPollActivation',
    '2134' => 'updateAdaptorUpdateRequestPeer',
    '2135' => 'activateAdaptorActivatePeer',
    '2136' => 'activateAdaptorPowerOnServers',
    '2137' => 'updateRaidControllerPowerOnServers',
    '2138' => 'updateColusaBoardControllerBegin',
    '2139' => 'updateColusaBoardControllerPrepareForUpdate',
    '2140' => 'updateColusaBoardControllerPowerOffServers',
    '2141' => 'updateColusaBoardControllerServersPowerOffCompletion',
    '2142' => 'updateColusaBoardControllerUpdateRequest',
    '2143' => 'updateColusaBoardControllerPollUpdateStatus',
    '2144' => 'updateColusaBoardControllerPowerOnServers',
    '2145' => 'updateBoardControllerPowerOnServers',
    '2146' => 'updateSasExpanderBegin',
    '2147' => 'updateSasExpanderUpdateRequest',
    '2148' => 'updateSasExpanderPollUpdateStatus',
    '2149' => 'activateSasExpanderBegin',
    '2150' => 'activateSasExpanderActivate',
    '2151' => 'activateSasExpanderWaitForActivation',
    '2152' => 'activateSasExpanderPollActivateStatus',
    '2153' => 'activateLocalDiskBegin',
    '2154' => 'activateLocalDiskActivate',
    '2155' => 'activateLocalDiskPollActivateStatus',
    '2175' => 'activateColusaCMCFail',
    '2176' => 'activateColusaCMCSuccess',
    '2177' => 'activateLocalDiskFail',
    '2178' => 'activateLocalDiskSuccess',
    '2179' => 'activateSasExpanderFail',
    '2180' => 'activateSasExpanderSuccess',
    '2181' => 'enableSecureBootFail',
    '2182' => 'enableSecureBootSuccess',
    '2183' => 'powerCapFail',
    '2184' => 'powerCapSuccess',
    '2185' => 'updateColusaBoardControllerFail',
    '2186' => 'updateColusaBoardControllerSuccess',
    '2187' => 'updateColusaCMCFail',
    '2188' => 'updateColusaCMCSuccess',
    '2189' => 'updateSasExpanderFail',
    '2190' => 'updateSasExpanderSuccess',
    '2195' => 'updateUCSManagerSPBegin',
    '2196' => 'updateUCSManagerSPStart',
    '2197' => 'updateUCSManagerSPExecute',
    '2198' => 'updateSwitchUpdateSpLocal',
    '2199' => 'updateSwitchUpdateSpRemote',
    '2261' => 'updateUCSManagerSPFail',
    '2262' => 'updateUCSManagerSPSuccess',
    '2269' => 'registryConfigRemovePeer',
  },
  'CucsStorageRemoteDiskAdminActionTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'jbod',
    '2' => 'unconfiguredGood',
    '4' => 'prepareForRemoval',
    '5' => 'undoPrepareForRemoval',
    '6' => 'globalHotSpare',
    '7' => 'dedicatedHotSpare',
    '8' => 'removeHotSpare',
    '9' => 'ledOn',
    '10' => 'ledOff',
    '11' => 'enableSecurity',
    '12' => 'clearSecureDrive',
    '13' => 'clearSecureForeignConfigDrive',
    '14' => 'unlockForeignDrive',
  },
  'CucsAdaptorNwMgmtCapApi' => {
    '0' => 'none',
    '1' => 'menlo',
    '2' => 'palo',
  },
  'CucsEquipmentSiocRole' => {
    '0' => 'unknown',
    '1' => 'active',
    '2' => 'standby',
  },
  'CucsMgmtMaintMode' => {
    '1' => 'normal',
    '2' => 'lpcReset',
  },
  'CucsFabricPIoEpOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'errorMisconfigured',
    '4' => 'failed',
    '5' => 'errorUnsupportedMiniServerPort',
  },
  'CucsExtvmmSwitchDelTaskFsmTaskItem' => {
    '0' => 'nop',
    '542' => 'removeProvider',
  },
  'CucsExtvmmVnicType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsOsControllerFsmTaskItem' => {
    '0' => 'nop',
    '1772' => 'deployOS',
  },
  'CucsFaultBasePolicySoakingSeverity' => {
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
  },
  'CucsOsOsType' => {
    '0' => 'unspecified',
    '1' => 'pnuOS',
    '2' => 'linux',
    '3' => 'windows',
    '4' => 'solaris',
    '5' => 'vmwareESX',
  },
  'CucsMgmtDataImporterFsmStageName' => {
    '0' => 'nop',
    '27' => 'importDataBegin',
    '28' => 'importDataDownload',
    '29' => 'importDataDmeImport',
    '30' => 'importDataReportResults',
    '113' => 'importDataFail',
    '114' => 'importDataSuccess',
  },
  'CucsIdentOperation' => {
    '0' => 'update',
    '1' => 'unassign',
    '2' => 'report',
  },
  'CucsComputeBackplaneSpeedChassisPref' => {
    '0' => 'n40G',
    '1' => 'n4x10G',
    '2' => 'global',
  },
  'CucsStorageFlexFlashControllerFsmStageName' => {
    '0' => 'nop',
    '1605' => 'mopsResetBegin',
    '1606' => 'mopsResetReset',
    '1607' => 'mopsFormatBegin',
    '1608' => 'mopsFormatFormat',
    '1609' => 'mopsPairBegin',
    '1610' => 'mopsPairPair',
    '1624' => 'mopsFormatFail',
    '1625' => 'mopsFormatSuccess',
    '1626' => 'mopsPairFail',
    '1627' => 'mopsPairSuccess',
    '1628' => 'mopsResetFail',
    '1629' => 'mopsResetSuccess',
  },
  'CucsPortEthSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CucsMorefAdminState' => {
    '1' => 'unapplied',
    '2' => 'applied',
    '3' => 'deleted',
  },
  'CucsCimcvmediaAuthProtocol' => {
    '0' => 'default',
    '1' => 'none',
    '4' => 'ntlm',
    '5' => 'ntlmi',
    '6' => 'ntlmv2',
    '7' => 'ntlmv2i',
    '8' => 'ntlmssp',
    '9' => 'ntlmsspi',
  },
  'CucsStorageReplicationPairState' => {
    '0' => 'online',
    '1' => 'offline',
  },
  'CucsProcessorArchitecture' => {
    '0' => 'any',
    '1' => 'intelP4C',
    '132' => 'opteron',
    '134' => 'turion64',
    '135' => 'dualCoreOpteron',
    '178' => 'pentium4',
    '179' => 'xeon',
    '181' => 'xeonMP',
  },
  'CucsFabricEthLanEpOperationAutoNegotiate' => {
    '0' => 'disabled',
    '1' => 'enabled',
    '2' => 'remoteAutoNeg',
  },
  'CucsAdaptorHostEthIfFsmTaskItem' => {
    '0' => 'nop',
    '505' => 'circuitReset',
  },
  'CucsFabricEthMonDestEpAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CucsChangeEpFsmStageName' => {
    '0' => 'nop',
    '369' => 'syncChangeUCSBegin',
    '370' => 'syncChangeUCSSync',
    '371' => 'syncChangeUCSFail',
    '372' => 'syncChangeUCSSuccess',
  },
  'CucsFabricTrafficDirection' => {
    '1' => 'rx',
    '2' => 'tx',
    '3' => 'both',
  },
  'CucsEquipmentIOCardFsmStageName' => {
    '0' => 'nop',
    '1' => 'fePresenceBegin',
    '2' => 'fePresenceIdentify',
    '3' => 'feConnBegin',
    '4' => 'feConnConfigureSwMgmtEndPoint',
    '5' => 'feConnConfigureVifNs',
    '6' => 'feConnConfigureEndPoint',
    '7' => 'feConnDiscoverChassis',
    '8' => 'feConnEnableChassis',
    '378' => 'feConnFail',
    '379' => 'feConnSuccess',
    '380' => 'fePresenceFail',
    '381' => 'fePresenceSuccess',
    '461' => 'resetCmcBegin',
    '462' => 'resetCmcExecute',
    '465' => 'resetCmcFail',
    '466' => 'resetCmcSuccess',
    '544' => 'fePresenceCheckLicense',
    '645' => 'muxOfflineBegin',
    '646' => 'muxOfflineCleanupEntries',
    '817' => 'resetIomBegin',
    '818' => 'resetIomExecute',
    '984' => 'muxOfflineFail',
    '985' => 'muxOfflineSuccess',
    '986' => 'resetIomFail',
    '987' => 'resetIomSuccess',
    '1735' => 'fePresenceConfigChassisId',
    '1939' => 'evacuateBegin',
    '1940' => 'evacuateExecute',
    '1941' => 'resetEvacuateBegin',
    '1942' => 'resetEvacuateExecute',
    '1959' => 'evacuateFail',
    '1960' => 'evacuateSuccess',
    '1961' => 'resetEvacuateFail',
    '1962' => 'resetEvacuateSuccess',
    '1980' => 'resetPeerCmcBegin',
    '1981' => 'resetPeerCmcExecute',
    '1993' => 'resetPeerCmcFail',
    '1994' => 'resetPeerCmcSuccess',
  },
  'CucsMgmtBackupInterval' => {
    '86400' => 'n1day',
    '604800' => 'n1week',
    '1209600' => 'n2week',
  },
  'CucsStoragePowerState' => {
    '0' => 'unknown',
    '1' => 'active',
    '2' => 'powersave',
    '3' => 'transitioning',
    '4' => 'off',
  },
  'CucsEpqosDefinitionDelTaskFsmStageName' => {
    '0' => 'nop',
    '319' => 'removeBegin',
    '320' => 'removeLocal',
    '321' => 'removePeer',
    '370' => 'removeFail',
    '371' => 'removeSuccess',
  },
  'CucsChangeEpFsmTaskItem' => {
    '0' => 'nop',
    '369' => 'syncChangeUCS',
  },
  'CucsCommTimeZoneConfigState' => {
    '0' => 'success',
    '1' => 'failure',
  },
  'CucsFabricFcMonOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsSmartlicenseTestFsmTaskItem' => {
    '0' => 'nop',
    '482' => 'configure',
  },
  'CucsInitiatorFcInitiatorEpProt' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CucsExtvmmRefOperState' => {
    '0' => 'up',
    '1' => 'invalidReference',
  },
  'CucsLsFcZoneGroupSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsImgsecKeyType' => {
    '0' => 'public',
    '1' => 'private',
    '2' => 'shared',
  },
  'CucsBiosVfAllUSBDevicesVpAllUSBDevices' => {
    '0' => 'platformRecommended',
    '389' => 'disabled',
    '390' => 'enabled',
  },
  'CucsCommSyslogAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsComputeChassisDiscAction' => {
    '0' => 'immediate',
    '1' => 'userAcknowledged',
    '2' => 'n1Link',
    '3' => 'n2Link',
    '4' => 'n4Link',
    '5' => 'n8Link',
    '6' => 'platformMax',
  },
  'CucsAdaptorEthOffloadProfileLargeReceive' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsConditionSmartCallHomeCause' => {
    '0' => 'unspecified',
    '1' => 'providerLostConnectivity',
    '2' => 'controllerLostConnectivity',
    '3' => 'clientLostConnectivity',
    '4' => 'dbConnectReadWriteError',
    '5' => 'capacityExceeded',
    '6' => 'invalidTrustpointCertChain',
    '7' => 'invalidKeyringCertificate',
    '8' => 'duplicatedAssigned',
    '9' => 'remoteFailed',
    '10' => 'notInCompliance',
    '11' => 'coreFileGenerated',
  },
  'CucsSwPhysFsmTaskItem' => {
    '0' => 'nop',
    '1082' => 'confPhysical',
  },
  'CucsEquipmentPsuFsmCurrentFsm' => {
    '0' => 'nop',
    '1808' => 'updatePSU',
  },
  'CucsCommSvcEpFsmCurrentFsm' => {
    '0' => 'nop',
    '190' => 'updateSvcEp',
    '193' => 'restartWebSvc',
  },
  'CucsTrigAckPrevOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CucsLicenseFileState' => {
    '0' => 'unknown',
    '1' => 'installPending',
    '2' => 'installing',
    '3' => 'stale',
    '4' => 'installed',
    '5' => 'installFailed',
    '6' => 'deletePending',
    '7' => 'deleting',
    '8' => 'deleted',
    '9' => 'deleteFailed',
    '10' => 'validated',
  },
  'CucsCommFilePathProtocol' => {
    '0' => 'none',
    '1' => 'workspace',
    '2' => 'volatile',
    '3' => 'ftp',
    '4' => 'tftp',
    '5' => 'scp',
    '6' => 'sftp',
    '7' => 'usbdrive',
    '8' => 'usbA',
    '9' => 'usbB',
  },
  'CucsExtvmmMasterExtKeyFsmStageName' => {
    '0' => 'nop',
    '575' => 'configBegin',
    '576' => 'configSetLocal',
    '577' => 'configSetPeer',
    '578' => 'configFail',
    '579' => 'configSuccess',
  },
  'CucsCapabilityAdminState' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CucsVmHbaType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot3State' => {
    '0' => 'platformRecommended',
    '214' => 'disabled',
    '215' => 'enabled',
    '449' => 'uefiOnly',
    '450' => 'legacyOnly',
  },
  'CucsLstorageVirtualDriveDefAccessPolicy' => {
    '0' => 'unknown',
    '1' => 'readWrite',
    '2' => 'readOnly',
    '3' => 'blocked',
    '4' => 'transportReady',
    '5' => 'hidden',
  },
  'CucsSysdebugEpLogCapacity' => {
    '0' => 'unknown',
    '1' => 'available',
    '2' => 'low',
    '3' => 'veryLow',
    '4' => 'full',
  },
  'CucsFabricVConMappingScheme' => {
    '2' => 'roundRobin',
    '3' => 'linearOrdered',
    '4' => 'roundRobinToLinearOrdered',
    '5' => 'linearOrderedToRoundRobin',
  },
  'CucsLsSPNeedIdReEvaluate' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsCertRepairStateType' => {
    '0' => 'done',
    '1' => 'notDone',
  },
  'CucsEquipmentChassisProfileFsmStageName' => {
    '0' => 'nop',
    '566' => 'configureBegin',
    '567' => 'configureApplyTemplate',
    '568' => 'configureApplyThrottle',
    '569' => 'configureThrottleWait',
    '570' => 'configureEvaluateAssociation',
    '571' => 'configureAnalyzeImpact',
    '572' => 'configureApplyRename',
    '573' => 'configureApplyConfig',
    '574' => 'configureWaitForAssocCompletion',
    '575' => 'configureFail',
    '576' => 'configureSuccess',
    '2055' => 'configureResolvePolicies',
    '2056' => 'configureResolveDistributableNames',
    '2057' => 'configureResolveDistributable',
    '2058' => 'configureResolveImages',
    '2059' => 'configureResolveSchedule',
    '2060' => 'configureValidatePolicyOwnership',
    '2061' => 'configureApplyPolicies',
    '2064' => 'configureWaitForMaintPermission',
  },
  'CucsFabricFIPortOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsCommSnmpNotificationType' => {
    '1' => 'traps',
    '2' => 'informs',
  },
  'CucsBiosVfCPUPerformanceVpCPUPerformance' => {
    '0' => 'platformRecommended',
    '175' => 'enterprise',
    '176' => 'highThroughput',
    '177' => 'hpc',
    '490' => 'custom',
  },
  'CucsVnicEtherBaseSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsNetworkElementFsmStageName' => {
    '0' => 'nop',
    '35' => 'updateElementBegin',
    '36' => 'updateElementUpdateAttr',
    '119' => 'updateElementFail',
    '120' => 'updateElementSuccess',
  },
  'CucsSwEthLanEpUdldAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfSIOC1OptionROMVpSIOC1OptionROM' => {
    '0' => 'platformRecommended',
    '572' => 'disabled',
    '573' => 'enabled',
    '574' => 'uefiOnly',
    '575' => 'legacyOnly',
  },
  'CucsFcpoolInitiatorPurpose' => {
    '0' => 'portWwn',
    '1' => 'nodeWwn',
    '2' => 'derived',
  },
  'CucsAdaptorIpV6RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsNfsMountInstFsmCurrentFsm' => {
    '0' => 'nop',
    '1233' => 'mount',
    '1238' => 'unmount',
  },
  'CucsProcStatAdminState' => {
    '1' => 'on',
    '2' => 'clearStats',
    '3' => 'logStats',
  },
  'CucsLicenseFileFsmStageName' => {
    '0' => 'nop',
    '923' => 'installBegin',
    '924' => 'installLocal',
    '925' => 'installRemote',
    '926' => 'clearBegin',
    '927' => 'clearLocal',
    '928' => 'clearRemote',
    '996' => 'clearFail',
    '997' => 'clearSuccess',
    '998' => 'installFail',
    '999' => 'installSuccess',
  },
  'CucsBiosVfAltitudeVpAltitude' => {
    '0' => 'platformRecommended',
    '482' => 'auto',
    '483' => 'n300M',
    '484' => 'n900M',
    '485' => 'n1500M',
    '486' => 'n3000M',
  },
  'CucsFabricFcoeSanEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsSwVlanLimitStatus' => {
    '1' => 'ok',
    '2' => 'exceeded',
  },
  'CucsEquipmentSystemFruType' => {
    '0' => 'unknown',
    '1' => 'storageBlade',
  },
  'CucsBiosVfIntelVTForDirectedIOVpIntelVTForDirectedIO' => {
    '0' => 'platformRecommended',
    '14' => 'disabled',
    '15' => 'enabled',
  },
  'CucsEtherServerIntFIoIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsVmHvClInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CucsOsEthBondModeBalancedRRType' => {
    '0' => 'activePassive',
    '1' => 'activeActive',
  },
  'CucsLsbootLocalLunImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsPolicyControlEpFsmStageName' => {
    '0' => 'nop',
    '1199' => 'operateBegin',
    '1200' => 'operateResolve',
    '1429' => 'operateFail',
    '1430' => 'operateSuccess',
  },
  'CucsAdaptorEthOffloadProfileTcpRxChecksum' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsCommSyslogProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsLsbootSanCatSanImageType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsPolicyDomainAuthStatus' => {
    '0' => 'unknown',
    '1' => 'fail',
    '2' => 'ok',
  },
  'CucsLstorageDay' => {
    '0' => 'everyDay',
    '1' => 'monday',
    '2' => 'tuesday',
    '3' => 'wednesday',
    '4' => 'thursday',
    '5' => 'friday',
    '6' => 'saturday',
    '7' => 'sunday',
    '8' => 'everyMonth',
    '9' => 'everyHour',
  },
  'CucsAdaptorLldpCapSupport' => {
    '1' => 'none',
    '2' => 'full',
  },
  'CucsFabricNetflowMonSessionProtocol' => {
    '1' => 'netflow',
  },
  'CucsCallhomeEpFsmStageName' => {
    '0' => 'nop',
    '274' => 'configCallhomeBegin',
    '275' => 'configCallhomeSetLocal',
    '276' => 'configCallhomeSetPeer',
    '330' => 'configCallhomeFail',
    '331' => 'configCallhomeSuccess',
  },
  'CucsEquipmentDriveSecCapIsSupported' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsSwSanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsLicenseInstanceFsmStageName' => {
    '0' => 'nop',
    '929' => 'updateFlexlmBegin',
    '930' => 'updateFlexlmLocal',
    '931' => 'updateFlexlmRemote',
    '1000' => 'updateFlexlmFail',
    '1001' => 'updateFlexlmSuccess',
  },
  'CucsCommSnmpVersion' => {
    '1' => 'v1',
    '2' => 'v2c',
    '3' => 'v3',
  },
  'CucsLsbootLocalDiskImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsFabricLanCloudPolicyVlanCompression' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsMgmtRegistryInfoFsmStageName' => {
    '0' => 'nop',
    '3' => 'configureBegin',
    '4' => 'configureConfig',
    '117' => 'configureFail',
    '118' => 'configureSuccess',
  },
  'CucsMemoryRuntimeType' => {
    '1' => 'swap',
    '2' => 'total',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortVMedia' => {
    '0' => 'platformRecommended',
    '401' => 'disabled',
    '402' => 'enabled',
  },
  'CucsSwMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsStoragePartitionFsmCurrentFsm' => {
    '0' => 'nop',
    '1630' => 'deployStorage',
    '1677' => 'scrubRAIDGroup',
  },
  'CucsAaaUserEpFsmCurrentFsm' => {
    '0' => 'nop',
    '203' => 'updateUserEp',
  },
  'CucsGlPolicyGlOperAction' => {
    '0' => 'noConflict',
    '1' => 'policyConflict',
  },
  'CucsCommCipherSuiteMode' => {
    '1' => 'highStrength',
    '2' => 'mediumStrength',
    '3' => 'lowStrength',
    '4' => 'custom',
  },
  'CucsStorageDrawerOpenState' => {
    '0' => 'notApplicable',
    '1' => 'open',
    '2' => 'closed',
  },
  'CucsStorageCacheType' => {
    '0' => 'unknown',
    '1' => 'noChange',
    '2' => 'enable',
    '3' => 'disable',
  },
  'CucsSwNetflowMonSessionProtocol' => {
    '1' => 'netflow',
  },
  'CucsVmOsHvVendor' => {
    '0' => 'unspecified',
    '1' => 'vmware',
    '2' => 'redhat',
    '3' => 'microsoft',
    '4' => 'novell',
    '5' => 'oracle',
    '6' => 'citrix',
  },
  'CucsSmartlicenseHolderFsmCurrentFsm' => {
    '0' => 'nop',
    '487' => 'configure',
    '530' => 'updateState',
  },
  'CucsFcPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresence',
    '1334' => 'inCompatSfpReplaced',
  },
  'CucsSwFcMonFsmCurrentFsm' => {
    '0' => 'nop',
    '869' => 'deploy',
  },
  'CucsFabricRemoteAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsStorageSystemFsmStageName' => {
    '0' => 'nop',
    '1383' => 'syncBegin',
    '1384' => 'syncExecute',
    '1463' => 'syncFail',
    '1464' => 'syncSuccess',
  },
  'CucsVmSwitchVendor' => {
    '0' => 'undetermined',
    '1' => 'vmware',
    '2' => 'microsoft',
  },
  'CucsCommXmlClConnPolicyClientType' => {
    '0' => 'javaUi',
    '1' => 'flexUi',
    '2' => 'extrenalApiClient',
  },
  'CucsFabricNFTransport' => {
    '1' => 'udp',
    '2' => 'sctp',
  },
  'CucsLsbootPurpose' => {
    '1' => 'utility',
    '2' => 'operational',
  },
  'CucsFabricFcZoneOperState' => {
    '4' => 'notActive',
    '5' => 'active',
    '6' => 'created',
    '7' => 'createFailed',
    '8' => 'deleted',
    '9' => 'zoneMergeFailure',
  },
  'CucsStorageOperationType' => {
    '0' => 'reconstruction',
    '1' => 'relearning',
    '2' => 'patrolRead',
    '3' => 'consistencyCheck',
    '4' => 'rebuild',
    '5' => 'initialization',
    '6' => 'copyback',
  },
  'CucsLstorageProcessorId' => {
    '1' => 'n1',
    '2' => 'n2',
  },
  'CucsVnicL2IfSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsMgmtExportPolicyProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsSwEthLanPcVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CucsEpqosDefinitionFsmCurrentFsm' => {
    '0' => 'nop',
    '316' => 'deploy',
  },
  'CucsSmartlicenseAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsBiosVfInterleaveConfigurationVpMemoryInterleaving' => {
    '0' => 'platformRecommended',
    '297' => 'numa1WayNodeInterleave',
    '298' => 'n2WayNodeInterleave',
    '299' => 'n4WayNodeInterleave',
    '300' => 'n8WayInterleavingInterSocket',
  },
  'CucsStorageControllerAdminActionTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'importForeignConfiguration',
    '2' => 'clearForeignConfiguration',
    '3' => 'unpinCacheAll',
    '4' => 'skipInitialConfig',
    '5' => 'clearBootConfiguration',
    '6' => 'unlockDisk',
    '7' => 'disableSecurity',
    '8' => 'modifyKey',
    '9' => 'enableSecurity',
  },
  'CucsBiosVfLOMPortsConfigurationVpLOMPort2OptionROM' => {
    '0' => 'platformRecommended',
    '381' => 'disabled',
    '382' => 'enabled',
    '383' => 'uefiOnly',
    '384' => 'legacyOnly',
  },
  'CucsAaaLdapEpFsmCurrentFsm' => {
    '0' => 'nop',
    '197' => 'updateEp',
  },
  'CucsStorageEtherIfVlanType' => {
    '0' => 'regular',
    '1' => 'default',
    '2' => 'native',
  },
  'CucsBiosVfPCISlotOptionROMEnableVpSlot7State' => {
    '0' => 'platformRecommended',
    '268' => 'disabled',
    '269' => 'enabled',
    '457' => 'uefiOnly',
    '458' => 'legacyOnly',
  },
  'CucsStorageAdminActionTrigger' => {
    '0' => 'idle',
    '1' => 'triggered',
    '2' => 'canceled',
  },
  'CucsSysfileMutationFsmTaskItem' => {
    '0' => 'nop',
    '209' => 'single',
    '211' => 'global',
  },
  'CucsFirmwareDistributableType' => {
    '0' => 'unknown',
    '1' => 'image',
    '2' => 'fullBundle',
    '3' => 'infrastructureBundle',
    '4' => 'bSeriesBundle',
    '5' => 'cSeriesBundle',
    '6' => 'catalog',
    '7' => 'sSeriesBundle',
    '8' => 'providerBundle',
    '10' => 'servicePackBundle',
  },
  'CucsVmNicType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsIdentIdentRequestFsmStageName' => {
    '0' => 'nop',
    '383' => 'updateIdentReportIdDomainMap',
    '1336' => 'updateIdentBegin',
    '1337' => 'updateIdentExecute',
    '1405' => 'updateIdentFail',
    '1406' => 'updateIdentSuccess',
  },
  'CucsFabricVlanAssocPrimaryVlanState' => {
    '1' => 'ok',
    '2' => 'isEmpty',
    '3' => 'doesNotExists',
    '4' => 'isNotPrimaryType',
    '5' => 'isInErrorState',
  },
  'CucsFirmwareOwner' => {
    '0' => 'management',
    '1' => 'policy',
  },
  'CucsVnicProfileConfigQualifier' => {
    '0' => 'normal',
    '1' => 'invalidName',
  },
  'CucsLstorageReplicationTargetType' => {
    '1' => 'cisco',
    '2' => 'linuxLVM',
    '3' => 'linuxRAW',
    '4' => 'windows',
  },
  'CucsMgmtExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopy',
  },
  'CucsFirmwareOperDnldStatus' => {
    '0' => 'notDownloaded',
    '1' => 'triggered',
    '2' => 'downloading',
    '3' => 'downloaded',
    '4' => 'failed',
    '5' => 'deleting',
    '6' => 'eulaAcceptanceRequired',
  },
  'CucsPowerPolicyFanSpeed' => {
    '0' => 'lowPower',
    '1' => 'balanced',
    '2' => 'performance',
    '3' => 'highPower',
    '4' => 'maxPower',
    '5' => 'na',
    '6' => 'err',
    '7' => 'noUpdate',
    '8' => 'notSupported',
    '9' => 'any',
  },
  'CucsBiosVfOptionROMLoadVpLoad' => {
    '0' => 'platformRecommended',
    '163' => 'enable',
    '164' => 'disable',
    '187' => 'enabled',
    '188' => 'disabled',
  },
  'CucsBiosVfPCIROMCLPVpPCIROMCLP' => {
    '0' => 'platformRecommended',
    '570' => 'disabled',
    '571' => 'enabled',
  },
  'CucsSysdebugManualCoreFileExportTargetFsmTaskItem' => {
    '0' => 'nop',
    '214' => 'export',
  },
  'CucsComputeConnectivityRebalancing' => {
    '0' => 'immediate',
    '1' => 'userAcknowledged',
  },
  'CucsFabricFcMonSrcEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsStorageAdminState' => {
    '0' => 'undefined',
    '1' => 'online',
    '2' => 'offline',
    '3' => 'delete',
    '4' => 'restore',
    '5' => 'degraded',
    '6' => 'transportReady',
    '7' => 'clearTransportReady',
    '8' => 'hide',
    '9' => 'unhide',
    '10' => 'secureDriveGroup',
  },
  'CucsPolicyPolicyOperStatus' => {
    '0' => 'ok',
    '1' => 'resolved',
    '2' => 'released',
  },
  'CucsMorefImportRootFsmStageName' => {
    '0' => 'nop',
    '2012' => 'applyMoRefsBegin',
    '2013' => 'applyMoRefsApplyMoProps',
    '2014' => 'applyMoRefsDeleteAllMoRefs',
    '2015' => 'applyMoRefsFail',
    '2016' => 'applyMoRefsSuccess',
  },
  'CucsConsumerInstFsmTaskItem' => {
    '0' => 'nop',
    '185' => 'renameCfgDir',
  },
  'CucsStorageScsiDesignatorType' => {
    '1' => 't10',
    '2' => 'eui64',
    '3' => 'naa',
    '7' => 'md5',
    '8' => 'scsiName',
  },
  'CucsLsbootAccessType' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CucsVnicAEtherIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsFabricVConInstType' => {
    '1' => 'auto',
    '2' => 'manual',
    '3' => 'policy',
  },
  'CucsFabricVnetEpLcCtrlState' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsFabricConfMode' => {
    '0' => 'none',
    '1' => 'logicalConfigInvalid',
    '2' => 'validatingConf',
    '3' => 'applyPhysTrans',
    '4' => 'confSwitch',
  },
  'CucsExtvmmProviderFsmCurrentFsm' => {
    '0' => 'nop',
    '536' => 'config',
  },
  'CucsStorageRaidBatteryOperabilityQualifier' => {
    '0' => 'unknown',
  },
  'CucsFabricFcEstcEpOperationAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsEquipmentControllerSubType' => {
    '0' => 'none',
    '1' => 'ssata',
    '2' => 'psata',
  },
  'CucsFirmwareDownloadInterval' => {
    '0' => 'onDemand',
    '86400' => 'n1day',
    '604800' => 'n1week',
    '1209600' => 'n2week',
  },
  'CucsSysdebugLogControlEpFsmCurrentFsm' => {
    '0' => 'nop',
    '1' => 'persistence',
    '219' => 'logControlPersist',
  },
  'CucsGmetaHolderFsmCurrentFsm' => {
    '0' => 'nop',
    '1476' => 'inventory',
  },
  'CucsFirmwareSystemFsmTaskItem' => {
    '0' => 'nop',
    '1362' => 'deploy',
    '1378' => 'applyCatalogPack',
  },
  'CucsSysdebugLogControlEpFsmStageName' => {
    '0' => 'nop',
    '1' => 'persistenceBegin',
    '2' => 'persistencePersist',
    '163' => 'persistenceFail',
    '164' => 'persistenceSuccess',
    '219' => 'logControlPersistBegin',
    '220' => 'logControlPersistLocal',
    '221' => 'logControlPersistPeer',
    '446' => 'logControlPersistFail',
    '447' => 'logControlPersistSuccess',
  },
  'CucsFabricEthEstcPcEpOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfDRAMClockThrottlingVpDRAMClockThrottling' => {
    '0' => 'platformRecommended',
    '435' => 'auto',
    '436' => 'balanced',
    '437' => 'performance',
    '438' => 'energyEfficient',
  },
  'CucsEquipmentHxCapIsUsbNicSupported' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsEquipmentStorageMethod' => {
    '0' => 'unknown',
    '1' => 'singleFlash',
    '2' => 'dualFlash',
  },
  'CucsSmartlicenseEntitlementEpFsmCurrentFsm' => {
    '0' => 'nop',
    '484' => 'configure',
  },
  'CucsLstorageVirtualDriveDefStripSize' => {
    '0' => 'unspecified',
    '1' => 'n8KB',
    '2' => 'n16KB',
    '3' => 'n32KB',
    '4' => 'n64KB',
    '5' => 'n128KB',
    '6' => 'n256KB',
    '7' => 'n512KB',
    '8' => 'n1024KB',
  },
  'CucsIdentIsUsingQualifiedPool' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsFabricEstcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsFabricAVlanAssocPrimaryVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsFabricSwitchingMode' => {
    '0' => 'endHost',
    '1' => 'switch',
  },
  'CucsStatsChartType' => {
    '0' => 'static',
    '1' => 'dynamic',
  },
  'CucsEquipmentCPMetaCpRefresh' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsMemoryVisibility' => {
    '0' => 'unknown',
    '1' => 'yes',
    '2' => 'no',
  },
  'CucsDomainFeatureType' => {
    '0' => 'major',
    '1' => 'minor',
  },
  'CucsComputeOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CucsStorageActualWriteType' => {
    '0' => 'unknown',
    '1' => 'writeThrough',
    '2' => 'writeBack',
  },
  'CucsComputeFactoryResetStatus' => {
    '0' => 'idle',
    '1' => 'running',
    '2' => 'cimcResetInProgress',
    '3' => 'cimcResetComplete',
    '4' => 'scrubStageComplete',
  },
  'CucsExtvmmKeyStoreFsmTaskItem' => {
    '0' => 'nop',
    '539' => 'certInstall',
  },
  'CucsDomainProfileFsmStageName' => {
    '0' => 'nop',
    '635' => 'configureBegin',
    '636' => 'configureConsumerVxanDeployment',
    '637' => 'configureWaitForConsumerReceivingVxan',
    '638' => 'configurePushPolicies',
    '639' => 'configureConfigure',
    '654' => 'configureFail',
    '655' => 'configureSuccess',
  },
  'CucsBiosVfIntegratedGraphicsApertureSizeVpIntgtGraphApertureSize' => {
    '0' => 'platformRecommended',
    '401' => 'n128mb',
    '402' => 'n256mb',
    '403' => 'n512mb',
    '404' => 'n1024mb',
    '405' => 'n2048mb',
    '406' => 'n4096mb',
  },
  'CucsStorageCtrlHaState' => {
    '0' => 'unknown',
    '1' => 'ready',
    '2' => 'notReady',
    '3' => 'degraded',
    '4' => 'failoverInProgress',
    '5' => 'electionFailed',
    '6' => 'offline',
  },
  'CucsFabricSanCloudFsmStageName' => {
    '0' => 'nop',
    '871' => 'switchModeBegin',
    '872' => 'switchModeSwConfigPeer',
    '873' => 'switchModeSwConfigLocal',
    '992' => 'switchModeFail',
    '993' => 'switchModeSuccess',
    '2248' => 'switchModeWaitForUserAck',
  },
  'CucsPowerCapAction' => {
    '0' => 'nothing',
    '1' => 'clockDown',
    '2' => 'throttled',
  },
  'CucsFabricBreakoutType' => {
    '0' => 'unknown',
    '1' => 'n10g4x',
  },
  'CucsComputePwrChangeSource' => {
    '0' => 'none',
    '1' => 'unknown',
    '2' => 'hostPwrTransition',
    '3' => 'software',
    '4' => 'userFrontPanel',
    '5' => 'ucsTurnup',
    '6' => 'ucsHardShutdown',
    '7' => 'ucsSoftShutdown',
    '8' => 'ucsPowercycle',
    '9' => 'ucsHardreset',
    '10' => 'ucsSoftreset',
    '11' => 'ucsBladeShutdown',
    '12' => 'ucsServerDiscover',
    '13' => 'ucsAssociate',
    '14' => 'ucsDisassociate',
    '15' => 'ucsFwUpgrade',
    '16' => 'ucsOobAdminConfig',
    '17' => 'ucsDiskZoningInventory',
    '18' => 'ucsUpdateBoardctrlFw',
    '19' => 'ucsUpdateAdaptorFw',
    '20' => 'ucsActivateAdaptorFw',
    '21' => 'ucsActivateBiosFw',
    '22' => 'ucsBiosRecovery',
    '23' => 'ucsCmosReset',
    '24' => 'ucsRackunitDiscover',
    '25' => 'ucsRackUnitAdapterReset',
    '26' => 'ucsClearTpm',
    '27' => 'ucsDiagnosticInterrupt',
    '28' => 'ucsServerunitDiscover',
    '29' => 'ucsDiag',
  },
  'CucsMgmtConfigState' => {
    '0' => 'incomplete',
    '1' => 'unsupportedVlan',
    '2' => 'unsupportedServer',
    '3' => 'unresolvedVlan',
    '4' => 'valid',
    '5' => 'invalidPinning',
  },
  'CucsVnicStorageEthLifType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsSwEthLanBorderFsmStageName' => {
    '0' => 'nop',
    '224' => 'deployBegin',
    '225' => 'deployUpdateConnectivity',
    '436' => 'deployFail',
    '437' => 'deploySuccess',
    '1184' => 'deployUpdateVlanGroups',
  },
  'CucsGlConflictAdminState' => {
    '0' => 'default',
    '1' => 'evaluate',
  },
  'CucsBiosVfTPMSupportVpTPMSupport' => {
    '0' => 'platformRecommended',
    '475' => 'disabled',
    '476' => 'enabled',
  },
  'CucsFirmwareImageFsmTaskItem' => {
    '0' => 'nop',
    '240' => 'delete',
  },
  'CucsFabricMemberStatus' => {
    '0' => 'up',
    '1' => 'down',
  },
  'CucsEtherExternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsCommSyslogSeverity' => {
    '0' => 'emergencies',
    '1' => 'alerts',
    '2' => 'critical',
    '3' => 'errors',
    '4' => 'warnings',
    '5' => 'notifications',
    '6' => 'information',
    '7' => 'debugging',
  },
  'CucsFabricFcMonOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsNwctrlRegistrationMode' => {
    '0' => 'onlyNativeVlan',
    '1' => 'allHostVlans',
  },
  'CucsTopMode' => {
    '0' => 'unspecified',
    '1' => 'standAlone',
    '2' => 'cluster',
  },
  'CucsVnicScsiType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsDiagSrvCtrlOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '612' => 'configure',
  },
  'CucsMgmtBackupTriggerFsmTaskItem' => {
    '0' => 'nop',
    '399' => 'trigger',
  },
  'CucsFabricLanCloudFsmStageName' => {
    '0' => 'nop',
    '184' => 'switchModeBegin',
    '185' => 'switchModeSwConfigPeer',
    '186' => 'switchModeSwConfigLocal',
    '392' => 'switchModeFail',
    '393' => 'switchModeSuccess',
    '2247' => 'switchModeWaitForUserAck',
  },
  'CucsExtvmmNetworkSetConfigQualifier' => {
    '0' => 'normal',
    '1' => 'duplicateVmndReference',
  },
  'CucsEquipmentResetOn' => {
    '0' => 'unknown',
    '1' => 'update',
    '2' => 'activate',
  },
  'CucsFabricLanCloudVlanCompression' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsAdaptorEthVxLANProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsSwUlanPurpose' => {
    '1' => 'management',
    '2' => 'boot',
    '3' => 'reserved1',
    '4' => 'reserved2',
    '5' => 'applianceManagement',
  },
  'CucsSysdebugCoreExportStatus' => {
    '1' => 'success',
    '2' => 'failure',
  },
  'CucsAaaLdapGroupRuleAuthorization' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsFabricFcoeSanPcOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsSwUtilityDomainFsmTaskItem' => {
    '0' => 'nop',
    '228' => 'deploy',
  },
  'CucsStatsMigrateStatus' => {
    '0' => 'fail',
    '1' => 'success',
    '2' => 'skip',
    '3' => 'pending',
    '4' => 'inProgress',
  },
  'CucsMgmtBackupProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsFabricEthMonDestEpOperationIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CucsBiosVfUSBSysIdlePowerOptimizingSettingVpUSBIdlePowerOptimize' => {
    '0' => 'platformRecommended',
    '194' => 'highPerformance',
    '195' => 'lowerIdlePower',
  },
  'CucsEtherExternalPcAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsComputeGroupMembershipOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CucsFirmwareCompleteness' => {
    '0' => 'partial',
    '1' => 'complete',
  },
  'CucsBiosVfLOMPortsConfigurationVpLOMPort0OptionROM' => {
    '0' => 'platformRecommended',
    '373' => 'disabled',
    '374' => 'enabled',
    '375' => 'uefiOnly',
    '376' => 'legacyOnly',
  },
  'CucsAdaptorHostIfRemoteAdminState' => {
    '0' => 'enabled',
    '1' => 'remoteTrigger',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CucsStorageSnapshotCtxLunCfgAction' => {
    '0' => 'triggered',
    '1' => 'delete',
    '2' => 'online',
    '3' => 'offline',
    '9' => 'restoreSnapshot',
  },
  'CucsCommSvcEpFsmStageName' => {
    '0' => 'nop',
    '62' => 'restartWebSvcRestart',
    '190' => 'updateSvcEpBegin',
    '191' => 'updateSvcEpSetEpLocal',
    '192' => 'updateSvcEpSetEpPeer',
    '193' => 'restartWebSvcBegin',
    '332' => 'restartWebSvcFail',
    '333' => 'restartWebSvcSuccess',
    '334' => 'updateSvcEpFail',
    '335' => 'updateSvcEpSuccess',
    '532' => 'updateSvcEpPropogateEpSettings',
    '592' => 'updateSvcEpPropogateEpTimeZoneSettingsLocal',
    '593' => 'updateSvcEpPropogateEpTimeZoneSettingsPeer',
    '877' => 'updateSvcEpPropogateEpTimeZoneSettingsToAdaptorsLocal',
    '878' => 'updateSvcEpPropogateEpTimeZoneSettingsToAdaptorsPeer',
    '1046' => 'updateSvcEpPropogateEpTimeZoneSettingsToFexIomLocal',
    '1047' => 'updateSvcEpPropogateEpTimeZoneSettingsToFexIomPeer',
    '1165' => 'restartWebSvcLocal',
    '1166' => 'restartWebSvcPeer',
    '2017' => 'updateSvcEpInitIptablesLocal',
    '2018' => 'updateSvcEpInitIptablesPeer',
  },
  'CucsPolicyControlledTypeFsmStageName' => {
    '0' => 'nop',
    '1479' => 'operateBegin',
    '1480' => 'operateResolveAll',
    '1489' => 'operateFail',
    '1490' => 'operateSuccess',
  },
  'CucsIdentIdDefinedInIdm' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsDcxNsAllocStatus' => {
    '0' => 'available',
    '1' => 'full',
    '2' => 'exceeded',
  },
  'CucsMoKvType' => {
    '0' => 'keyValue',
    '1' => 'ipv4Addr',
    '2' => 'ipv6Addr',
    '3' => 'vlan',
    '4' => 'vnic',
  },
  'CucsLstorageStorageClass' => {
    '1' => 'san',
    '2' => 'das',
  },
  'CucsSysdebugAutoCoreFileExportTargetFsmCurrentFsm' => {
    '0' => 'nop',
    '216' => 'configure',
  },
  'CucsLsbootSanCatSanImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsStorageReplicationActionType' => {
    '1' => 'policy',
    '2' => 'manual',
  },
  'CucsCommSnmpAuth' => {
    '1' => 'md5',
    '2' => 'sha',
  },
  'CucsLsbootSanType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsSwFcZoneSetLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsLsType' => {
    '0' => 'instance',
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CucsSwFabricZoneNsUserZoneAllocStatus' => {
    '0' => 'available',
    '1' => 'full',
  },
  'CucsHcReportMoType' => {
    '0' => 'unknown',
    '1' => 'profile',
    '2' => 'equipment',
    '3' => 'hostFirmwarePolicy',
    '4' => 'domain',
    '5' => 'domainGroup',
  },
  'CucsCapabilityOperStatus' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'applied',
    '4' => 'failed',
  },
  'CucsMgmtBackupPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopy',
  },
  'CucsSysdebugCoreFsmStageName' => {
    '0' => 'nop',
    '1041' => 'downloadBegin',
    '1042' => 'downloadCopySub',
    '1043' => 'downloadCopyPrimary',
    '1044' => 'downloadDeleteSub',
    '1045' => 'downloadDeletePrimary',
    '1053' => 'downloadFail',
    '1054' => 'downloadSuccess',
  },
  'CucsSysdebugCoreFileOperState' => {
    '0' => 'unavailable',
    '1' => 'available',
    '2' => 'availableOnSubordinate',
    '3' => 'inProgress',
    '4' => 'failed',
  },
  'CucsBiosVpSelectMemoryRASConfiguration' => {
    '0' => 'platformRecommended',
    '30' => 'maximumPerformance',
    '31' => 'mirroring',
    '124' => 'lockstep',
    '125' => 'sparing',
  },
  'CucsFabricEthEstcPcOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsVnicIpPoolType' => {
    '0' => 'target',
    '1' => 'specific',
  },
  'CucsIdentIdentRequestFsmTaskItem' => {
    '0' => 'nop',
    '1336' => 'updateIdent',
  },
  'CucsEquipmentType' => {
    '0' => 'instance',
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CucsCallhomeAlertLevel' => {
    '0' => 'debug',
    '1' => 'normal',
    '2' => 'notify',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
    '7' => 'fatal',
    '100' => 'unknown',
  },
  'CucsComputeDiscovery' => {
    '0' => 'undiscovered',
    '1' => 'inProgress',
    '2' => 'malformedFruInfo',
    '3' => 'fruNotReady',
    '4' => 'insufficientlyEquipped',
    '5' => 'invalidAdaptorIocard',
    '8' => 'failed',
    '16' => 'complete',
    '32' => 'retry',
    '64' => 'throttled',
    '128' => 'illegalFru',
    '129' => 'fruIdentityIndeterminate',
    '130' => 'fruStateIndeterminate',
    '131' => 'diagnosticsInProgress',
    '132' => 'efidiagnosticsInProgress',
    '133' => 'diagnosticsFailed',
    '134' => 'diagnosticsComplete',
    '135' => 'waitingForUserAck',
    '136' => 'userAcknowledged',
    '137' => 'waitingForMgmtAck',
  },
  'CucsEquipmentBatteryCapacity' => {
    '0' => 'unknown',
    '1' => 'ready',
    '2' => 'insufficientCharge',
    '3' => 'identify',
  },
  'CucsFabricFcEstcEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsLsOperState' => {
    '0' => 'indeterminate',
    '1' => 'unassociated',
    '10' => 'ok',
    '11' => 'discovery',
    '12' => 'config',
    '13' => 'unconfig',
    '14' => 'powerOff',
    '15' => 'restart',
    '20' => 'maintenance',
    '21' => 'test',
    '29' => 'computeMismatch',
    '30' => 'computeFailed',
    '31' => 'degraded',
    '32' => 'discoveryFailed',
    '33' => 'configFailure',
    '34' => 'unconfigFailed',
    '35' => 'testFailed',
    '36' => 'maintenanceFailed',
    '40' => 'removed',
    '41' => 'disabled',
    '50' => 'inaccessible',
    '60' => 'thermalProblem',
    '61' => 'powerProblem',
    '62' => 'voltageProblem',
    '63' => 'inoperable',
    '101' => 'decomissioning',
    '201' => 'biosRestore',
    '202' => 'cmosReset',
    '203' => 'diagnostics',
    '204' => 'diagnosticsFailed',
    '210' => 'pendingReboot',
    '211' => 'pendingReassociation',
    '212' => 'svnicNotPresent',
  },
  'CucsCommLogComponentSeverity' => {
    '0' => 'emergencies',
    '1' => 'alerts',
    '2' => 'critical',
    '3' => 'errors',
    '4' => 'warnings',
    '5' => 'notifications',
    '6' => 'information',
    '7' => 'debugging',
  },
  'CucsSysdebugEpLogType' => {
    '1' => 'sel',
    '2' => 'obfl',
    '3' => 'syslog',
  },
  'CucsStorageSelectionDecisionType' => {
    '0' => 'unspecified',
    '1' => 'selectLun',
    '2' => 'normalDisk',
    '3' => 'dedicatedHotSpare',
    '4' => 'globalHotSpare',
    '5' => 'useRemainingSpace',
    '6' => 'shareDiskGroup',
    '7' => 'useRemainingDisk',
    '8' => 'affinity',
    '9' => 'verifyResources',
    '10' => 'verifyVirtualDriveConfig',
    '11' => 'verifyDiskgroupConfig',
    '12' => 'verifyControllerConfig',
    '13' => 'verifyLunConfig',
    '14' => 'verifyDiskConfig',
    '15' => 'verifyRaidConfig',
    '16' => 'verifyStripSizeConfig',
  },
  'CucsPolicySuspendState' => {
    '0' => 'off',
    '1' => 'on',
    '2' => 'remoteTrigger',
  },
  'CucsEquipmentSlotSpanOrientation' => {
    '0' => 'unknown',
    '1' => 'inline',
    '2' => 'transverse',
  },
  'CucsIdentMetaSystemFsmTaskItem' => {
    '0' => 'nop',
    '1338' => 'sync',
    '1618' => 'ucscUnivSync',
  },
  'CucsFdRackUnitFsmCurrentFsm' => {
    '0' => 'nop',
    '616' => 'configure',
  },
  'CucsStorageDeployAction' => {
    '0' => 'noAction',
    '1' => 'create',
    '2' => 'delete',
    '3' => 'modify',
    '4' => 'restore',
    '5' => 'replace',
    '6' => 'setOnline',
    '7' => 'setOffline',
    '8' => 'abortReplication',
  },
  'CucsMgmtExportPolicyAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsCapabilityUpdaterFsmTaskItem' => {
    '0' => 'nop',
    '582' => 'updater',
  },
  'CucsCommSyslogMonitorAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsLsbootSanImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CucsUuidpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsFabricEpMgrFsmTaskItem' => {
    '0' => 'nop',
    '1078' => 'configure',
  },
  'CucsCallhomeUrgency' => {
    '0' => 'emergency',
    '1' => 'alert',
    '2' => 'critical',
    '3' => 'error',
    '4' => 'warning',
    '5' => 'notice',
    '6' => 'info',
    '7' => 'debug',
  },
  'CucsExtpolLossVisibilitySource' => {
    '0' => 'unknown',
    '1' => 'polling',
  },
  'CucsHcCondition' => {
    '0' => 'all',
    '1' => 'cannotDetermine',
    '2' => 'notSupported',
    '3' => 'ok',
  },
  'CucsEquipmentIOCardBaseFsmCurrentFsm' => {
    '0' => 'nop',
    '1732' => 'fePresence',
    '1736' => 'feConn',
  },
  'CucsControllerEpFsmTaskItem' => {
    '0' => 'nop',
    '315' => 'quiesce',
  },
  'CucsBiosVfIntegratedGraphicsVpIntegratedGraphics' => {
    '0' => 'platformRecommended',
    '399' => 'disabled',
    '400' => 'enabled',
  },
  'CucsPortapiPeerCapability' => {
    '0' => 'unknown',
    '1' => 'ethRackServerPort',
    '2' => 'ethFexServerPort',
    '3' => 'ethAppliantPort',
    '4' => 'ethUplinkPort',
  },
  'CucsFabricSwChPhEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CucsStorageVirtualDriveRefAdminState' => {
    '1' => 'online',
    '2' => 'offline',
    '4' => 'undeployed',
  },
  'CucsVnicVirtualizationPreferenceType' => {
    '0' => 'none',
    '2' => 'sriov',
    '3' => 'sriovVmfex',
    '4' => 'sriovUsnic',
    '5' => 'vmq',
  },
  'CucsFabricVlanCompType' => {
    '1' => 'included',
    '2' => 'excluded',
  },
  'CucsStorageLunStatusType' => {
    '0' => 'undefined',
    '1' => 'online',
    '2' => 'offline',
  },
  'CucsLstorageProcessorFsmTaskItem' => {
    '0' => 'nop',
    '1747' => 'configure',
  },
  'CucsFabricFlowMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricQosPriority' => {
    '0' => 'unknown',
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsComputePsuControlRedundancy' => {
    '0' => 'unknown',
    '1' => 'nonRedundant',
    '2' => 'nPlus1',
    '3' => 'grid',
  },
  'CucsStorageSystemFsmTaskItem' => {
    '0' => 'nop',
    '1383' => 'sync',
  },
  'CucsPortPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresence',
    '1334' => 'inCompatSfpReplaced',
  },
  'CucsIpIPv4DnsPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CucsCommCoreFileFileTransferProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsEquipmentControllerForm' => {
    '0' => 'none',
    '1' => 'onBoard',
    '2' => 'mezzanine',
    '3' => 'pci',
    '4' => 'embedded',
  },
  'CucsMgmtOperState' => {
    '0' => 'unknown',
    '1' => 'notDeployed',
    '2' => 'up',
    '3' => 'down',
  },
  'CucsEquipmentPowerState' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'test',
    '3' => 'off',
    '4' => 'online',
    '5' => 'offline',
    '6' => 'offduty',
    '7' => 'degraded',
    '8' => 'powerSave',
    '9' => 'error',
    '10' => 'ok',
    '11' => 'failed',
    '100' => 'notSupported',
  },
  'CucsCommShellProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CucsDomainProfileFsmTaskItem' => {
    '0' => 'nop',
    '635' => 'configure',
  },
  'CucsGlOperState' => {
    '0' => 'notEvaluated',
    '1' => 'evaluating',
    '2' => 'evaluatedWithError',
    '3' => 'evaluatedWithSuccess',
    '4' => 'globalizing',
    '5' => 'globalizedWithError',
    '6' => 'globalizedWithSuccess',
    '7' => 'applyingRuleAndEvaluating',
    '8' => 'fetchingDataFromDomain',
    '10' => 'evaluatedWithBlockingIssue',
    '11' => 'evaluatedWithConflict',
  },
  'CucsFabricVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsOsMacFailOverPolicy' => {
    '0' => 'none',
    '1' => 'active',
    '2' => 'follow',
  },
  'CucsAdaptorEthOffloadProfileTcpTxChecksum' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsStorageControllerSubType' => {
    '0' => 'na',
    '1' => 'nvmeFront',
    '2' => 'nvmeRear',
    '3' => 'nvmeHhhl',
    '4' => 'nvmeMezz',
    '5' => 'nvmeM2',
  },
  'CucsAdaptorHostFcIfHostPort' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CucsEquipmentChassisFsmCurrentFsm' => {
    '0' => 'nop',
    '9' => 'removeChassis',
    '140' => 'psuPolicyConfig',
    '643' => 'powerCap',
    '1048' => 'dynamicReallocation',
    '1883' => 'oobStorageAdminCfg',
    '2067' => 'associate',
    '2098' => 'disassociate',
    '2115' => 'chassisUpgrade',
  },
  'CucsIppoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsExtvmmSwitchDelTaskFsmCurrentFsm' => {
    '0' => 'nop',
    '542' => 'removeProvider',
  },
  'CucsStorageOptionRomBootStatus' => {
    '0' => 'unknown',
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsComputeABoardPower' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'test',
    '3' => 'off',
    '4' => 'online',
    '5' => 'offline',
    '6' => 'offduty',
    '7' => 'degraded',
    '8' => 'powerSave',
    '9' => 'error',
    '10' => 'ok',
    '11' => 'failed',
    '100' => 'notSupported',
  },
  'CucsLsPowerState' => {
    '0' => 'down',
    '1' => 'up',
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
    '4' => 'hardResetImmediate',
    '5' => 'hardResetWait',
    '6' => 'softShutDown',
    '7' => 'softShutDownOnly',
    '12' => 'cmosResetImmediate',
    '13' => 'bmcResetImmediate',
    '14' => 'bmcResetWait',
    '15' => 'diagnosticInterrupt',
    '16' => 'kvmReset',
    '31' => 'adminUp',
    '32' => 'adminDown',
    '33' => 'ipmiReset',
  },
  'CucsNetworkSide' => {
    '0' => 'left',
    '1' => 'right',
  },
  'CucsMemoryUnitOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'degraded',
    '4' => 'poweredOff',
    '5' => 'powerProblem',
    '6' => 'removed',
    '7' => 'voltageProblem',
    '8' => 'thermalProblem',
    '9' => 'performanceProblem',
    '10' => 'accessibilityProblem',
    '11' => 'identityUnestablishable',
    '12' => 'biosPostTimeout',
    '13' => 'disabled',
    '14' => 'malformedFru',
    '15' => 'backplanePortProblem',
    '16' => 'chassisIntrusion',
    '51' => 'fabricConnProblem',
    '52' => 'fabricUnsupportedConn',
    '81' => 'config',
    '82' => 'equipmentProblem',
    '83' => 'decomissioning',
    '84' => 'chassisLimitExceeded',
    '100' => 'notSupported',
    '101' => 'discovery',
    '102' => 'discoveryFailed',
    '103' => 'identify',
    '104' => 'postFailure',
    '105' => 'upgradeProblem',
    '106' => 'peerCommProblem',
    '107' => 'autoUpgrade',
    '108' => 'linkActivateBlocked',
  },
  'CucsVnicDefaultAction' => {
    '0' => 'none',
    '1' => 'hwInherit',
  },
  'CucsStorageProcessorOperState' => {
    '0' => 'undefined',
    '1' => 'online',
    '2' => 'offline',
    '3' => 'inMaintenance',
    '4' => 'fullMaintenance',
    '5' => 'computeDegraded',
    '6' => 'clusterDegraded',
  },
  'CucsBiosVfConsoleRedirectionVpPuttyKeyPad' => {
    '0' => 'platformRecommended',
    '311' => 'vt100',
    '312' => 'linux',
    '313' => 'xtermr6',
    '314' => 'sco',
    '315' => 'escn',
    '316' => 'vt400',
  },
  'CucsMgmtFileTransferProtocol' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CucsFabricFillPattern' => {
    '0' => 'idle',
    '1' => 'arbff',
  },
  'CucsCertRepairEpFsmTaskItem' => {
    '0' => 'nop',
    '50' => 'repairCert',
  },
  'CucsFabricEthPortOperationFsmStageName' => {
    '0' => 'nop',
    '524' => 'fiportBegin',
    '525' => 'fiportRoleConfig',
    '526' => 'fiportPushVxan',
    '527' => 'fiportWait',
    '528' => 'fiportVxanConfig',
    '529' => 'fiportCleanUp',
    '532' => 'fiportFail',
    '533' => 'fiportSuccess',
    '640' => 'fiportPushPolicies',
    '641' => 'fiportWaitForPolicies',
  },
  'CucsAdaptorIpV4RssHashProfileTcpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsPolicyRequestorFsmCurrentFsm' => {
    '0' => 'nop',
    '2253' => 'resolveFromCentral',
  },
  'CucsAdaptorHostFcIfFsmStageName' => {
    '0' => 'nop',
    '142' => 'resetFcPersBindingBegin',
    '328' => 'resetFcPersBindingFail',
    '329' => 'resetFcPersBindingSuccess',
    '510' => 'circuitResetBegin',
    '511' => 'circuitResetDisableA',
    '512' => 'circuitResetEnableA',
    '513' => 'circuitResetDisableB',
    '514' => 'circuitResetEnableB',
    '517' => 'circuitResetFail',
    '518' => 'circuitResetSuccess',
    '813' => 'resetFcPersBindingExecuteLocal',
    '814' => 'resetFcPersBindingExecutePeer',
  },
  'CucsControllerEpFsmStageName' => {
    '0' => 'nop',
    '315' => 'quiesceBegin',
    '316' => 'quiesceQuiesceMgmtController',
    '317' => 'quiesceQuiesceResMgr',
    '318' => 'quiesceQuiesceOpsMgr',
    '319' => 'quiesceQuiescePolicyMgr',
    '320' => 'quiesceQuiesceIDMgr',
    '321' => 'quiesceQuiesceStatsMgr',
    '322' => 'quiesceFail',
    '323' => 'quiesceSuccess',
  },
  'CucsMorefImportRootFsmCurrentFsm' => {
    '0' => 'nop',
    '2012' => 'applyMoRefs',
  },
  'CucsDupeOperation' => {
    '0' => 'create',
    '1' => 'delete',
  },
  'CucsStorageIOType' => {
    '0' => 'unknown',
    '1' => 'direct',
    '2' => 'cached',
  },
  'CucsVmInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CucsFabricVnetEpPolicyOwner' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
    '3' => 'unspecified',
  },
  'CucsEquipmentPsuStateQualifier' => {
    '0' => 'unknown',
    '1' => 'failure',
    '2' => 'overCurrent',
    '3' => 'overTemperature',
    '4' => 'inputLoss',
    '5' => 'fanFailure',
    '6' => 'inputCurrentWarning',
    '7' => 'inputVoltageWarning',
    '8' => 'ambientTemperatureWarning',
    '9' => 'outputCurrentWarning',
  },
  'CucsGlRequestVnetEpDomainEpFsmStageName' => {
    '0' => 'nop',
    '609' => 'evalDataBegin',
    '610' => 'evalDataFetchDomainData',
    '611' => 'evalDataFetchVnetDependencies',
    '670' => 'evalDataFail',
    '671' => 'evalDataSuccess',
  },
  'CucsMemoryBackupTriggerStatus' => {
    '0' => 'unknown',
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfConsoleRedirectionVpBaudRate' => {
    '0' => 'platformRecommended',
    '131' => 'n9600',
    '132' => 'n19200',
    '133' => 'n38400',
    '134' => 'n57600',
    '135' => 'n115200',
  },
  'CucsPolicyDomainRegistrationStateType' => {
    '0' => 'inprogress',
    '1' => 'registered',
    '2' => 'failed',
    '3' => 'lostVisibility',
    '4' => 'unregistered',
  },
  'CucsFabricEthLanPcOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsBiosVfProcessorC7ReportVpProcessorC7Report' => {
    '0' => 'platformRecommended',
    '206' => 'disabled',
    '207' => 'enabled',
    '502' => 'c7',
    '503' => 'c7s',
  },
  'CucsExtpolConnProtocol' => {
    '0' => 'ipv4',
    '1' => 'ipv6',
    '2' => 'unknown',
  },
  'CucsPowerProfilingMethod' => {
    '0' => 'unknown',
    '1' => 'default',
    '2' => 'static',
    '3' => 'pnuos',
    '4' => 'nodemgr',
  },
  'CucsTrigTrigOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CucsFabricFcZoneProfileFsmTaskItem' => {
    '0' => 'nop',
    '642' => 'configure',
  },
  'CucsPolicyPolicyScopeContFsmCurrentFsm' => {
    '0' => 'nop',
    '2251' => 'reportPolicyFailFsm',
  },
  'CucsComputeAlarmSeverity' => {
    '1' => 'minor',
    '2' => 'severe',
  },
  'CucsSolAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsAdaptorEthNVGREProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsBiosVfProcessorPrefetchConfigVpDCUIPPrefetcher' => {
    '0' => 'platformRecommended',
    '411' => 'disabled',
    '412' => 'enabled',
  },
  'CucsBiosBootDevGrpType' => {
    '0' => 'systemBootOrder',
    '1' => 'fddOrder',
    '2' => 'hddOrder',
    '3' => 'cdOrder',
    '6' => 'networkDeviceOrder',
    '16' => 'internalEfiShell',
    '99' => 'unknownDeviceOrder',
    '100' => 'localStorageAnyDeviceOrder',
    '101' => 'sanDeviceOrder',
    '102' => 'sanAnyDeviceOrder',
    '103' => 'internalUsbDeviceOrder',
    '104' => 'externalUsbDeviceOrder',
    '105' => 'sdcardDeviceOrder',
    '106' => 'lanAnyDeviceOrder',
    '107' => 'uefiTargetDeviceOrder',
    '108' => 'iscsiDeviceOrder',
    '109' => 'iscsiAnyDeviceOrder',
    '110' => 'cimcVmediaCddDeviceOrder',
    '111' => 'cimcVmediaHddDeviceOrder',
    '112' => 'cimcVmediaFddDeviceOrder',
    '113' => 'kvmVmediaCddDeviceOrder',
    '114' => 'kvmVmediaHddDeviceOrder',
    '115' => 'kvmVmediaFddDeviceOrder',
    '116' => 'uefiShellDeviceOrder',
    '117' => 'nvmeDeviceOrder',
    '118' => 'nvmeDiskSsdDeviceOrder',
    '119' => 'nvmePciSsdDeviceOrder',
    '128' => 'bevOrder',
  },
  'CucsSmartlicenseTestTransportMode' => {
    '0' => 'none',
    '1' => 'callhome',
    '2' => 'http',
  },
  'CucsFabricVnetConfigState' => {
    '1' => 'notDeployedYet',
    '2' => 'deploymentError',
  },
  'CucsStorageLocalDiskConfigFlexFlashState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsExtpolRegistryFsmStageName' => {
    '0' => 'nop',
    '1351' => 'crossDomainConfigBegin',
    '1352' => 'crossDomainConfigSetLocal',
    '1353' => 'crossDomainConfigSetPeer',
    '1354' => 'crossDomainDeleteBegin',
    '1355' => 'crossDomainDeleteSetLocal',
    '1356' => 'crossDomainDeleteSetPeer',
    '1397' => 'crossDomainConfigFail',
    '1398' => 'crossDomainConfigSuccess',
    '1399' => 'crossDomainDeleteFail',
    '1400' => 'crossDomainDeleteSuccess',
  },
  'CucsEquipmentRemoteChassisAdminState' => {
    '0' => 'remoteTrigger',
    '1' => 'acknowledged',
    '2' => 'reAcknowledge',
    '3' => 'decommission',
    '4' => 'remove',
    '5' => 'enablePortChannel',
    '6' => 'disablePortChannel',
    '7' => 'autoAcknowledge',
  },
  'CucsSwPhysFsmStageName' => {
    '0' => 'nop',
    '1121' => 'confPhysicalBegin',
    '1122' => 'confPhysicalPortInventorySwA',
    '1123' => 'confPhysicalPortInventorySwB',
    '1124' => 'confPhysicalConfigSwA',
    '1125' => 'confPhysicalConfigSwB',
    '1126' => 'confPhysicalVerifyPhysConfig',
    '1127' => 'confPhysicalSuccess',
    '1128' => 'confPhysicalFail',
  },
  'CucsComputePhysicalFsmStageName' => {
    '0' => 'nop',
    '665' => 'associateBegin',
    '668' => 'associateUpdateIBMCFw',
    '669' => 'associateWaitForIBMCFwUpdate',
    '670' => 'associateActivateIBMCFw',
    '671' => 'associateResetIBMC',
    '672' => 'associatePreSanitize',
    '673' => 'associateSanitize',
    '674' => 'associateConfigUserAccess',
    '675' => 'associateBladePowerOff',
    '676' => 'associateUpdateBoardCtrlRequest',
    '677' => 'associatePollBoardCtrlUpdateStatus',
    '678' => 'associatePowerOn',
    '679' => 'associateBmcPreconfigPnuOSLocal',
    '680' => 'associateBmcPreconfigPnuOSPeer',
    '681' => 'associateBmcConfigPnuOS',
    '682' => 'associateSwConfigPnuOSLocal',
    '683' => 'associateSwConfigPnuOSPeer',
    '684' => 'associateUpdateAdaptorNwFwLocal',
    '685' => 'associateUpdateAdaptorNwFwPeer',
    '686' => 'associateWaitForAdaptorNwFwUpdateLocal',
    '687' => 'associateWaitForAdaptorNwFwUpdatePeer',
    '688' => 'associateActivateAdaptorNwFwLocal',
    '689' => 'associateActivateAdaptorNwFwPeer',
    '690' => 'associateNicConfigPnuOSLocal',
    '691' => 'associateNicConfigPnuOSPeer',
    '692' => 'associateBootPnuos',
    '693' => 'associateBootWait',
    '694' => 'associateBiosPostCompletion',
    '695' => 'associateHagPnuOSConnect',
    '696' => 'associatePnuOSIdent',
    '697' => 'associatePnuOSPolicy',
    '698' => 'associatePnuOSValidate',
    '699' => 'associatePnuOSSelfTest',
    '700' => 'associateBiosImgUpdate',
    '701' => 'associateStorageCtlrImgUpdate',
    '702' => 'associateHbaImgUpdate',
    '703' => 'associateNicImgUpdate',
    '704' => 'associatePnuOSInventory',
    '705' => 'associatePnuOSConfig',
    '706' => 'associatePnuOSLocalDiskConfig',
    '707' => 'associatePnuOSUnloadDrivers',
    '708' => 'associateBmcUnconfigPnuOS',
    '709' => 'associateNicUnconfigPnuOSLocal',
    '710' => 'associateNicUnconfigPnuOSPeer',
    '711' => 'associateSwUnconfigPnuOSLocal',
    '712' => 'associateSwUnconfigPnuOSPeer',
    '713' => 'associateSwConfigHostOSLocal',
    '714' => 'associateSwConfigHostOSPeer',
    '715' => 'associateNicConfigHostOSLocal',
    '716' => 'associateNicConfigHostOSPeer',
    '717' => 'associateHagPnuOSDisconnect',
    '718' => 'associateConfigSoL',
    '719' => 'associatePrepareForBoot',
    '720' => 'associateConfigUuid',
    '721' => 'associateBootHost',
    '722' => 'associateHagHostOSConnect',
    '723' => 'associateHostOSIdent',
    '724' => 'associateHostOSPolicy',
    '725' => 'associateHostOSValidate',
    '726' => 'associateHostOSConfig',
    '727' => 'disassociateBegin',
    '730' => 'disassociateConfigUserAccess',
    '731' => 'disassociatePowerOn',
    '732' => 'disassociatePreSanitize',
    '733' => 'disassociateSanitize',
    '734' => 'disassociateNicUnconfigHostOSLocal',
    '735' => 'disassociateNicUnconfigHostOSPeer',
    '736' => 'disassociateSwUnconfigHostOSLocal',
    '737' => 'disassociateSwUnconfigHostOSPeer',
    '738' => 'disassociateBmcPreconfigPnuOSLocal',
    '739' => 'disassociateBmcPreconfigPnuOSPeer',
    '740' => 'disassociateBmcConfigPnuOS',
    '741' => 'disassociateSwConfigPnuOSLocal',
    '742' => 'disassociateSwConfigPnuOSPeer',
    '743' => 'disassociateNicConfigPnuOSLocal',
    '744' => 'disassociateNicConfigPnuOSPeer',
    '745' => 'disassociateConfigBios',
    '746' => 'disassociateBootPnuos',
    '747' => 'disassociateBootWait',
    '748' => 'disassociateBiosPostCompletion',
    '749' => 'disassociateHagPnuOSConnect',
    '750' => 'disassociatePnuOSIdent',
    '751' => 'disassociatePnuOSPolicy',
    '752' => 'disassociatePnuOSValidate',
    '753' => 'disassociatePnuOSUnconfig',
    '754' => 'disassociatePnuOSScrub',
    '755' => 'disassociatePnuOSSelfTest',
    '756' => 'disassociateBmcUnconfigPnuOS',
    '757' => 'disassociateNicUnconfigPnuOSLocal',
    '758' => 'disassociateNicUnconfigPnuOSPeer',
    '759' => 'disassociateHagPnuOSDisconnect',
    '760' => 'disassociateUnconfigUuid',
    '761' => 'disassociateShutdown',
    '762' => 'disassociateUnconfigBios',
    '763' => 'disassociateSwUnconfigPnuOSLocal',
    '764' => 'disassociateSwUnconfigPnuOSPeer',
    '765' => 'disassociateUnconfigSoL',
    '766' => 'disassociateHandlePooling',
    '767' => 'powerCapBegin',
    '768' => 'powerCapConfig',
    '769' => 'decommissionBegin',
    '770' => 'decommissionExecute',
    '771' => 'softShutdownBegin',
    '772' => 'softShutdownExecute',
    '773' => 'hardShutdownBegin',
    '774' => 'hardShutdownExecute',
    '775' => 'turnupBegin',
    '776' => 'turnupExecute',
    '777' => 'powercycleBegin',
    '778' => 'powercyclePreSanitize',
    '779' => 'powercycleSanitize',
    '780' => 'powercycleExecute',
    '781' => 'hardresetBegin',
    '782' => 'hardresetPreSanitize',
    '783' => 'hardresetSanitize',
    '784' => 'hardresetExecute',
    '785' => 'softresetBegin',
    '786' => 'softresetPreSanitize',
    '787' => 'softresetSanitize',
    '788' => 'softresetExecute',
    '789' => 'swConnUpdBegin',
    '790' => 'swConnUpdA',
    '791' => 'swConnUpdB',
    '792' => 'biosRecoveryBegin',
    '793' => 'biosRecoveryShutdown',
    '794' => 'biosRecoveryPreSanitize',
    '795' => 'biosRecoverySanitize',
    '796' => 'biosRecoverySetupVmediaLocal',
    '797' => 'biosRecoverySetupVmediaPeer',
    '798' => 'biosRecoveryStart',
    '799' => 'biosRecoveryWait',
    '800' => 'biosRecoveryCleanup',
    '801' => 'biosRecoveryReset',
    '802' => 'biosRecoveryTeardownVmediaLocal',
    '803' => 'biosRecoveryTeardownVmediaPeer',
    '806' => 'cmosResetBegin',
    '807' => 'cmosResetPreSanitize',
    '808' => 'cmosResetSanitize',
    '809' => 'cmosResetExecute',
    '810' => 'cmosResetReconfigBios',
    '811' => 'cmosResetReconfigUuid',
    '812' => 'cmosResetBladePowerOn',
    '815' => 'resetBmcBegin',
    '816' => 'resetBmcExecute',
    '879' => 'updateExtUsersBegin',
    '880' => 'updateExtUsersDeploy',
    '891' => 'updateAdaptorBegin',
    '892' => 'updateAdaptorPowerOn',
    '893' => 'updateAdaptorUpdateRequestLocal',
    '894' => 'updateAdaptorUpdateRequestPeer',
    '895' => 'updateAdaptorPollUpdateStatusLocal',
    '896' => 'updateAdaptorPollUpdateStatusPeer',
    '897' => 'updateAdaptorPowerOff',
    '898' => 'activateAdaptorBegin',
    '899' => 'activateAdaptorPowerOn',
    '900' => 'activateAdaptorActivateLocal',
    '901' => 'activateAdaptorActivatePeer',
    '902' => 'activateAdaptorReset',
    '932' => 'configSoLBegin',
    '933' => 'configSoLExecute',
    '934' => 'unconfigSoLBegin',
    '935' => 'unconfigSoLExecute',
    '940' => 'activateAdaptorFail',
    '941' => 'activateAdaptorSuccess',
    '942' => 'associateFail',
    '943' => 'associateSuccess',
    '946' => 'biosRecoveryFail',
    '947' => 'biosRecoverySuccess',
    '948' => 'cmosResetFail',
    '949' => 'cmosResetSuccess',
    '950' => 'configSoLFail',
    '951' => 'configSoLSuccess',
    '952' => 'decommissionFail',
    '953' => 'decommissionSuccess',
    '954' => 'disassociateFail',
    '955' => 'disassociateSuccess',
    '956' => 'hardShutdownFail',
    '957' => 'hardShutdownSuccess',
    '958' => 'hardresetFail',
    '959' => 'hardresetSuccess',
    '960' => 'powerCapFail',
    '961' => 'powerCapSuccess',
    '962' => 'powercycleFail',
    '963' => 'powercycleSuccess',
    '964' => 'resetBmcFail',
    '965' => 'resetBmcSuccess',
    '966' => 'softShutdownFail',
    '967' => 'softShutdownSuccess',
    '968' => 'softresetFail',
    '969' => 'softresetSuccess',
    '970' => 'swConnUpdFail',
    '971' => 'swConnUpdSuccess',
    '972' => 'turnupFail',
    '973' => 'turnupSuccess',
    '974' => 'unconfigSoLFail',
    '975' => 'unconfigSoLSuccess',
    '976' => 'updateAdaptorFail',
    '977' => 'updateAdaptorSuccess',
    '978' => 'updateExtUsersFail',
    '979' => 'updateExtUsersSuccess',
    '1019' => 'decommissionStopVMediaLocal',
    '1020' => 'decommissionStopVMediaPeer',
    '1021' => 'biosRecoveryStopVMediaLocal',
    '1022' => 'biosRecoveryStopVMediaPeer',
    '1036' => 'diagnosticInterruptBegin',
    '1037' => 'diagnosticInterruptExecute',
    '1038' => 'diagnosticInterruptFail',
    '1039' => 'diagnosticInterruptSuccess',
    '1040' => 'associateLocalDiskFwUpdate',
    '1055' => 'resetKvmBegin',
    '1056' => 'resetKvmExecute',
    '1057' => 'resetKvmFail',
    '1058' => 'resetKvmSuccess',
    '1069' => 'associateSwConfigPortNivLocal',
    '1070' => 'associateSwConfigPortNivPeer',
    '1071' => 'disassociateSwConfigPortNivLocal',
    '1072' => 'disassociateSwConfigPortNivPeer',
    '1104' => 'associateSolRedirectEnable',
    '1105' => 'associateSerialDebugPnuOSConnect',
    '1106' => 'associateSerialDebugPnuOSDisconnect',
    '1107' => 'associateSolRedirectDisable',
    '1108' => 'disassociateSolRedirectEnable',
    '1109' => 'disassociateSerialDebugPnuOSConnect',
    '1110' => 'disassociateSerialDebugPnuOSDisconnect',
    '1111' => 'disassociateSolRedirectDisable',
    '1112' => 'decommissionCleanupCIMC',
    '1152' => 'updateBIOSBegin',
    '1153' => 'updateBIOSClear',
    '1154' => 'updateBIOSPollClearStatus',
    '1155' => 'updateBIOSUpdateRequest',
    '1156' => 'updateBIOSPollUpdateStatus',
    '1157' => 'activateBIOSBegin',
    '1158' => 'activateBIOSPowerOff',
    '1159' => 'activateBIOSClear',
    '1160' => 'activateBIOSPollClearStatus',
    '1161' => 'activateBIOSActivate',
    '1162' => 'activateBIOSPollActivateStatus',
    '1163' => 'activateBIOSUpdateTokens',
    '1164' => 'activateBIOSPowerOn',
    '1169' => 'associateClearBiosUpdate',
    '1170' => 'associatePollClearBiosUpdateStatus',
    '1171' => 'associateUpdateBiosRequest',
    '1172' => 'associatePollBiosUpdateStatus',
    '1173' => 'associateActivateBios',
    '1174' => 'associatePollBiosActivateStatus',
    '1175' => 'associatePnuOSCatalog',
    '1176' => 'disassociatePnuOSCatalog',
    '1178' => 'activateBIOSFail',
    '1179' => 'activateBIOSSuccess',
    '1180' => 'updateBIOSFail',
    '1181' => 'updateBIOSSuccess',
    '1247' => 'associateMarkAdapterForReboot',
    '1248' => 'associateDeassertResetBypass',
    '1249' => 'associateVerifyFcZoneConfig',
    '1250' => 'disassociateDeassertResetBypass',
    '1251' => 'disassociateVerifyFcZoneConfig',
    '1252' => 'decommissionCleanupPortConfigLocal',
    '1253' => 'decommissionCleanupPortConfigPeer',
    '1254' => 'resetIpmiBegin',
    '1255' => 'resetIpmiExecute',
    '1256' => 'fwUpgradeBegin',
    '1257' => 'fwUpgradeUpdateIBMCFw',
    '1258' => 'fwUpgradeWaitForIBMCFwUpdate',
    '1259' => 'fwUpgradeActivateIBMCFw',
    '1260' => 'fwUpgradeResetIBMC',
    '1261' => 'fwUpgradePreSanitize',
    '1262' => 'fwUpgradeSanitize',
    '1263' => 'fwUpgradeBladePowerOff',
    '1264' => 'fwUpgradeUpdateBoardCtrlRequest',
    '1265' => 'fwUpgradePollBoardCtrlUpdateStatus',
    '1266' => 'fwUpgradeClearBiosUpdate',
    '1267' => 'fwUpgradePollClearBiosUpdateStatus',
    '1268' => 'fwUpgradeUpdateBiosRequest',
    '1269' => 'fwUpgradePollBiosUpdateStatus',
    '1270' => 'fwUpgradeActivateBios',
    '1271' => 'fwUpgradePollBiosActivateStatus',
    '1272' => 'fwUpgradePowerOn',
    '1273' => 'fwUpgradeBmcPreconfigPnuOSLocal',
    '1274' => 'fwUpgradeBmcPreconfigPnuOSPeer',
    '1275' => 'fwUpgradeSwConfigPortNivLocal',
    '1276' => 'fwUpgradeSwConfigPortNivPeer',
    '1277' => 'fwUpgradeSwConfigPnuOSLocal',
    '1278' => 'fwUpgradeSwConfigPnuOSPeer',
    '1279' => 'fwUpgradeUpdateAdaptorNwFwLocal',
    '1280' => 'fwUpgradeUpdateAdaptorNwFwPeer',
    '1281' => 'fwUpgradeWaitForAdaptorNwFwUpdateLocal',
    '1282' => 'fwUpgradeWaitForAdaptorNwFwUpdatePeer',
    '1283' => 'fwUpgradeActivateAdaptorNwFwLocal',
    '1284' => 'fwUpgradeActivateAdaptorNwFwPeer',
    '1285' => 'fwUpgradeNicConfigPnuOSLocal',
    '1286' => 'fwUpgradeNicConfigPnuOSPeer',
    '1287' => 'fwUpgradeBmcConfigPnuOS',
    '1288' => 'fwUpgradeSolRedirectEnable',
    '1289' => 'fwUpgradeSerialDebugPnuOSConnect',
    '1290' => 'fwUpgradeBootPnuos',
    '1291' => 'fwUpgradeBootWait',
    '1292' => 'fwUpgradeBiosPostCompletion',
    '1293' => 'fwUpgradeHagPnuOSConnect',
    '1294' => 'fwUpgradePnuOSIdent',
    '1295' => 'fwUpgradePnuOSPolicy',
    '1296' => 'fwUpgradePnuOSCatalog',
    '1297' => 'fwUpgradePnuOSValidate',
    '1298' => 'fwUpgradePnuOSSelfTest',
    '1299' => 'fwUpgradeStorageCtlrImgUpdate',
    '1300' => 'fwUpgradeHbaImgUpdate',
    '1301' => 'fwUpgradeNicImgUpdate',
    '1302' => 'fwUpgradeLocalDiskFwUpdate',
    '1303' => 'fwUpgradePnuOSConfig',
    '1304' => 'fwUpgradePnuOSInventory',
    '1305' => 'fwUpgradeBiosImgUpdate',
    '1306' => 'fwUpgradePnuOSUnloadDrivers',
    '1307' => 'fwUpgradeBmcUnconfigPnuOS',
    '1308' => 'fwUpgradeNicUnconfigPnuOSLocal',
    '1309' => 'fwUpgradeNicUnconfigPnuOSPeer',
    '1310' => 'fwUpgradeSwUnconfigPnuOSLocal',
    '1311' => 'fwUpgradeSwUnconfigPnuOSPeer',
    '1312' => 'fwUpgradeHagPnuOSDisconnect',
    '1313' => 'fwUpgradeSerialDebugPnuOSDisconnect',
    '1314' => 'fwUpgradeSolRedirectDisable',
    '1315' => 'fwUpgradeShutdown',
    '1361' => 'activateAdaptorDeassertResetBypass',
    '1363' => 'fwUpgradeDeassertResetBypass',
    '1385' => 'fwUpgradeFail',
    '1386' => 'fwUpgradeSuccess',
    '1387' => 'resetIpmiFail',
    '1388' => 'resetIpmiSuccess',
    '1471' => 'associateConfigFlexFlash',
    '1472' => 'associateSyncPowerState',
    '1473' => 'disassociateUnconfigFlexFlash',
    '1478' => 'cimcSessionDeleteBegin',
    '1479' => 'cimcSessionDeleteExecute',
    '1480' => 'cimcSessionDeleteFail',
    '1481' => 'cimcSessionDeleteSuccess',
    '1501' => 'associatePowerOnPreConfig',
    '1502' => 'associateOobStorageInventory',
    '1503' => 'associateSwConfigServiceInfraLocal',
    '1504' => 'associateSwConfigServiceInfraPeer',
    '1505' => 'associateNicConfigServiceInfraLocal',
    '1506' => 'associateNicConfigServiceInfraPeer',
    '1507' => 'disassociateNicUnconfigServiceInfraLocal',
    '1508' => 'disassociateNicUnconfigServiceInfraPeer',
    '1509' => 'disassociateConfigFlexFlashScrub',
    '1513' => 'serviceInfraDeployBegin',
    '1514' => 'serviceInfraDeploySwConfigLocal',
    '1515' => 'serviceInfraDeploySwConfigPeer',
    '1516' => 'serviceInfraDeployNicConfigLocal',
    '1517' => 'serviceInfraDeployNicConfigPeer',
    '1518' => 'serviceInfraWithdrawBegin',
    '1519' => 'serviceInfraWithdrawSwUnConfigLocal',
    '1520' => 'serviceInfraWithdrawSwUnConfigPeer',
    '1521' => 'serviceInfraWithdrawNicUnConfigLocal',
    '1522' => 'serviceInfraWithdrawNicUnConfigPeer',
    '1525' => 'updateBoardControllerBegin',
    '1526' => 'updateBoardControllerPrepareForUpdate',
    '1527' => 'updateBoardControllerServerPowerOff',
    '1528' => 'updateBoardControllerUpdateRequest',
    '1529' => 'updateBoardControllerPollUpdateStatus',
    '1530' => 'updateBoardControllerServerPowerOn',
    '1531' => 'configBoardBegin',
    '1532' => 'configBoardConfigMemoryPolicy',
    '1533' => 'resetMemoryErrorsBegin',
    '1534' => 'resetMemoryErrorsExecute',
    '1542' => 'configBoardFail',
    '1543' => 'configBoardSuccess',
    '1544' => 'resetMemoryErrorsFail',
    '1545' => 'resetMemoryErrorsSuccess',
    '1546' => 'serviceInfraDeployFail',
    '1547' => 'serviceInfraDeploySuccess',
    '1548' => 'serviceInfraWithdrawFail',
    '1549' => 'serviceInfraWithdrawSuccess',
    '1550' => 'updateBoardControllerFail',
    '1551' => 'updateBoardControllerSuccess',
    '1561' => 'disassociateResetSecureBootConfig',
    '1569' => 'associateUnconfigExtMgmtRules',
    '1570' => 'associateUnconfigExtMgmtGw',
    '1571' => 'associateUnconfigCimcVMedia',
    '1572' => 'associateConfigExtMgmtRules',
    '1573' => 'associateConfigExtMgmtGw',
    '1574' => 'associateConfigCimcVMedia',
    '1575' => 'associateGraphicsImageUpdate',
    '1576' => 'disassociateConfigKvmMgmtDefaultSetting',
    '1577' => 'disassociateUnconfigExtMgmtRules',
    '1578' => 'disassociateUnconfigExtMgmtGw',
    '1579' => 'disassociateUnconfigCimcVMedia',
    '1580' => 'decommissionUnconfigExtMgmtRules',
    '1581' => 'decommissionUnconfigExtMgmtGw',
    '1582' => 'fwUpgradeUnconfigExtMgmtRules',
    '1583' => 'fwUpgradeUnconfigExtMgmtGw',
    '1584' => 'fwUpgradeUnconfigCimcVMedia',
    '1585' => 'fwUpgradeGraphicsImageUpdate',
    '1588' => 'associateDownloadImages',
    '1589' => 'associateCopyRemote',
    '1590' => 'fwUpgradeDownloadImages',
    '1591' => 'fwUpgradeCopyRemote',
    '1592' => 'flashControllerBegin',
    '1593' => 'flashControllerUpdateFlashLife',
    '1595' => 'flashControllerFail',
    '1596' => 'flashControllerSuccess',
    '1598' => 'associateDeleteCurlDownloadedImages',
    '1599' => 'fwUpgradeDeleteCurlDownloadedImages',
    '1611' => 'enableCimcSecureBootBegin',
    '1612' => 'enableCimcSecureBootUpdateRequest',
    '1613' => 'enableCimcSecureBootPollUpdateStatus',
    '1614' => 'enableCimcSecureBootActivate',
    '1615' => 'enableCimcSecureBootReset',
    '1620' => 'enableCimcSecureBootFail',
    '1621' => 'enableCimcSecureBootSuccess',
    '1698' => 'associateCheckPowerAvailability',
    '1699' => 'associatePowerDeployWait',
    '1700' => 'associateOobStorageConfig',
    '1701' => 'associateVerifyRemoteStorageConfig',
    '1702' => 'associateNicConfigParamsHostOSLocal',
    '1703' => 'associateNicConfigParamsHostOSPeer',
    '1704' => 'associateBmcUpdateHostPreBoot',
    '1705' => 'disassociateWaitForUnConfigAppliances',
    '1706' => 'disassociateCheckPowerAvailability',
    '1707' => 'disassociatePowerDeployWait',
    '1708' => 'turnupCheckPowerAvailability',
    '1709' => 'turnupPowerDeployWait',
    '1710' => 'powercycleCheckPowerAvailability',
    '1711' => 'powercyclePowerDeployWait',
    '1712' => 'hardresetCheckPowerAvailability',
    '1713' => 'hardresetPowerDeployWait',
    '1714' => 'softresetCheckPowerAvailability',
    '1715' => 'softresetPowerDeployWait',
    '1716' => 'biosRecoveryCheckPowerAvailability',
    '1717' => 'biosRecoveryPowerDeployWait',
    '1718' => 'cmosResetCheckPowerAvailability',
    '1719' => 'cmosResetPowerDeployWait',
    '1720' => 'fwUpgradeCheckPowerAvailability',
    '1721' => 'fwUpgradePowerDeployWait',
    '1722' => 'oobStorageAdminConfigBegin',
    '1723' => 'oobStorageAdminConfigPreSanitize',
    '1724' => 'oobStorageAdminConfigSanitize',
    '1725' => 'oobStorageAdminConfigTearDownVMediaLocal',
    '1726' => 'oobStorageAdminConfigTearDownVMediaPeer',
    '1727' => 'oobStorageAdminConfigBootHost',
    '1728' => 'oobStorageAdminConfigBootWait',
    '1729' => 'oobStorageAdminConfigOobStorageConfig',
    '1730' => 'oobStorageAdminConfigOobStorageInventory',
    '1731' => 'oobStorageAdminConfigShutdown',
    '1800' => 'activateBIOSCheckPowerAvailability',
    '1801' => 'activateBIOSPowerDeployWait',
    '1802' => 'updateAdaptorCheckPowerAvailability',
    '1803' => 'updateAdaptorPowerDeployWait',
    '1804' => 'activateAdaptorCheckPowerAvailability',
    '1805' => 'activateAdaptorPowerDeployWait',
    '1806' => 'updateBoardControllerCheckPowerAvailability',
    '1807' => 'updateBoardControllerPowerDeployWait',
    '1813' => 'oobStorageAdminConfigFail',
    '1814' => 'oobStorageAdminConfigSuccess',
    '1880' => 'associateDeleteImagesRemote',
    '1881' => 'disassociateOobDiskScrub',
    '1882' => 'fwUpgradeDeleteImagesRemote',
    '1943' => 'associateUnlockFirmwareImage',
    '1944' => 'decommissionPrecleanupPortConfig',
    '1945' => 'clearTPMBegin',
    '1946' => 'clearTPMPreSanitize',
    '1947' => 'clearTPMSanitize',
    '1948' => 'clearTPMClear',
    '1949' => 'clearTPMBootHost',
    '1950' => 'clearTPMBiosPostCompletion',
    '1951' => 'clearTPMReadSmBios',
    '1952' => 'clearTPMBladePowerOff',
    '1953' => 'clearTPMReconfigBios',
    '1954' => 'clearTPMBladePowerOn',
    '1955' => 'fwUpgradeUnlockFirmwareImage',
    '1957' => 'clearTPMFail',
    '1958' => 'clearTPMSuccess',
    '1964' => 'clearTPMStopVMediaLocal',
    '1965' => 'clearTPMStopVMediaPeer',
    '1966' => 'clearTPMSetupVmedia',
    '1967' => 'clearTPMUnconfigVmedia',
    '1968' => 'updateBoardControllerPowerCycleBoard',
    '1969' => 'updateBoardControllerPollBoardCtrlPowerCycle',
    '1970' => 'associatePowerCycleBoard',
    '1971' => 'associatePollBoardCtrlPowerCycle',
    '1972' => 'fwUpgradePowerCycleBoard',
    '1973' => 'fwUpgradePollBoardCtrlPowerCycle',
    '1978' => 'associateCalculateVlanGroupForHostOSLocal',
    '1979' => 'associateCalculateVlanGroupForHostOSPeer',
    '1998' => 'associateConfigFanSpeed',
    '1999' => 'associateSasExpanderImgUpdate',
    '2000' => 'fwUpgradeSasExpanderImgUpdate',
    '2001' => 'fwUpgradeOobStorageInventory',
    '2030' => 'associateOobSasExpanderImgUpdate',
    '2031' => 'associateOobPollSasExpanderUpdateStatus',
    '2032' => 'associateOobSasExpanderImgActivate',
    '2033' => 'associateOobPollSasExpanderActivateStatus',
    '2034' => 'associateCiscoOSOpenGate',
    '2037' => 'fwUpgradeOobSasExpanderImgUpdate',
    '2038' => 'fwUpgradeOobPollSasExpanderUpdateStatus',
    '2039' => 'fwUpgradeOobSasExpanderImgActivate',
    '2040' => 'fwUpgradeOobPollSasExpanderActivateStatus',
    '2041' => 'fwUpgradeCiscoOSOpenGate',
    '2043' => 'oobStorageAdminConfigCheckPowerAvailability',
    '2044' => 'oobStorageAdminConfigPowerDeployWait',
    '2045' => 'diskZoningInventoryBegin',
    '2046' => 'diskZoningInventoryPreSanitize',
    '2047' => 'diskZoningInventorySanitize',
    '2048' => 'diskZoningInventoryBootHost',
    '2049' => 'diskZoningInventoryBootWait',
    '2050' => 'diskZoningInventoryStorageInventory',
    '2051' => 'diskZoningInventoryShutdown',
    '2161' => 'diskZoningInventoryFail',
    '2162' => 'diskZoningInventorySuccess',
    '2200' => 'activateAdaptorAssertBypassWait',
    '2209' => 'diagBegin',
    '2210' => 'diagPreSanitize',
    '2211' => 'diagSanitize',
    '2212' => 'diagCheckPowerAvailability',
    '2213' => 'diagDisableScriptableVMedia',
    '2214' => 'diagPreconfigVmediaLocal',
    '2215' => 'diagPreconfigVmediaPeer',
    '2216' => 'diagSetupVmediaLocal',
    '2217' => 'diagSetupVmediaPeer',
    '2218' => 'diagSetupBootEnvironment',
    '2219' => 'diagSerialDebugConnect',
    '2220' => 'diagPowerOn',
    '2221' => 'diagPowerOnWait',
    '2222' => 'diagBiosPostCompletion',
    '2223' => 'diagHagConnect',
    '2224' => 'diagPnuOSIdent',
    '2225' => 'diagRunTests',
    '2226' => 'diagLogTransfer',
    '2227' => 'diagWaitForDebug',
    '2228' => 'diagTeardownVmediaLocal',
    '2229' => 'diagTeardownVmediaPeer',
    '2230' => 'diagHagDisconnect',
    '2231' => 'diagSerialDebugDisconnect',
    '2232' => 'diagTearDownBootEnvironment',
    '2233' => 'diagShutdown',
    '2234' => 'associatePnuOSPeripheralComponentConfig',
    '2235' => 'associateConfigMgmtIpRules',
    '2236' => 'associateAssertBypassWait',
    '2237' => 'associateHostOSConnect',
    '2238' => 'associateConfigHostOsAnnotations',
    '2239' => 'associateConfigServerIdentity',
    '2240' => 'disassociateUnconfigServerIdentity',
    '2241' => 'fwUpgradeAssertBypassWait',
    '2242' => 'cimcSecurityConfigBegin',
    '2243' => 'cimcSecurityConfigKmipCertConfig',
    '2244' => 'cimcSecurityConfigKmipSaveCert',
    '2257' => 'cimcSecurityConfigFail',
    '2258' => 'cimcSecurityConfigSuccess',
    '2259' => 'diagFail',
    '2260' => 'diagSuccess',
    '2271' => 'associateRestoreVdStatus',
  },
  'CucsBiosVfSerialPortAEnableVpSerialPortAEnable' => {
    '0' => 'platformRecommended',
    '44' => 'disabled',
    '45' => 'enabled',
  },
  'CucsNetworkIfStatsUnits' => {
    '0' => 'raw',
    '1' => 'packets',
    '2' => 'octets',
  },
  'CucsMgmtIPv6IfAddrFsmTaskItem' => {
    '0' => 'nop',
    '1535' => 'swMgmtOobIpv6IfConfig',
  },
  'CucsProcessorUnitArch' => {
    '0' => 'any',
    '1' => 'intelP4C',
    '132' => 'opteron',
    '134' => 'turion64',
    '135' => 'dualCoreOpteron',
    '178' => 'pentium4',
    '179' => 'xeon',
    '181' => 'xeonMP',
  },
  'CucsDcxAdminState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CucsFabricEthSourceType' => {
    '1' => 'vnic',
    '2' => 'uplinkPort',
    '3' => 'vlan',
    '4' => 'serverPort',
    '5' => 'portChannel',
    '6' => 'hostPort',
    '7' => 'storage',
    '8' => 'nasPort',
    '9' => 'nasPortChannel',
    '10' => 'fcoeuplinkPortchannel',
    '11' => 'vmNic',
    '20' => 'vhba',
  },
  'CucsLstorageProcessorFsmStageName' => {
    '0' => 'nop',
    '1747' => 'configureBegin',
    '1748' => 'configureApplyTemplate',
    '1749' => 'configureApplyIdentifiers',
    '1750' => 'configureResolvePolicies',
    '1751' => 'configureResolveNetworkPolicies',
    '1752' => 'configureResolveIdentifiers',
    '1753' => 'configureApplyDefaultIdentifiers',
    '1754' => 'configureResolveDefaultIdentifiers',
    '1755' => 'configureResolveDistributableNames',
    '1756' => 'configureResolveDistributable',
    '1757' => 'configureResolveImages',
    '1758' => 'configureResolveSchedule',
    '1759' => 'configureValidatePolicyOwnership',
    '1760' => 'configureApplyPolicies',
    '1761' => 'configureResolveBootConfig',
    '1762' => 'configureEvaluateAssociation',
    '1763' => 'configureAnalyzeImpact',
    '1764' => 'configureWaitForMaintPermission',
    '1765' => 'configureWaitForMaintWindow',
    '1766' => 'configureWaitForHAQuorum',
    '1767' => 'configureApplyConfig',
    '1768' => 'configureWaitForServerAssoc',
    '1769' => 'configureWaitForPlatformBoot',
    '1770' => 'configureWaitForOSInstall',
    '1771' => 'configureWaitForPlatformConfig',
    '1823' => 'configureFail',
    '1824' => 'configureSuccess',
  },
  'CucsQosPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CucsLstorageDasScsiLunStorageClass' => {
    '1' => 'san',
    '2' => 'das',
  },
  'CucsMgmtBackupOperationPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsSysdebugManualCoreFileExportTargetAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsSmartlicenseAgentRegistrationStatus' => {
    '0' => 'notRegistered',
    '1' => 'registrationInProgress',
    '2' => 'registrationFailed',
    '3' => 'registrationRetryInProgress',
    '4' => 'registrationCompleted',
  },
  'CucsBiosVfProcessorC6ReportVpProcessorC6Report' => {
    '0' => 'platformRecommended',
    '110' => 'disabled',
    '111' => 'enabled',
  },
  'CucsBiosVfPCISlotLinkSpeedVpPCIeSlot10LinkSpeed' => {
    '0' => 'platformRecommended',
    '366' => 'gen1',
    '367' => 'gen2',
    '368' => 'gen3',
    '369' => 'auto',
    '370' => 'disabled',
  },
  'CucsBiosVfIOESlot2OptionROMVpIOESlot2OptionROM' => {
    '0' => 'platformRecommended',
    '592' => 'disabled',
    '593' => 'enabled',
    '594' => 'uefiOnly',
    '595' => 'legacyOnly',
  },
  'CucsConfigBackupFsmTaskItem' => {
    '0' => 'nop',
    '183' => 'delete',
  },
  'CucsVnicStorageEthLifSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsVnicFcNodeOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '7' => 'initiatorPolicy',
    '8' => 'connPolicy',
  },
  'CucsLstorageReplicationDeviceType' => {
    '1' => 'lun',
    '2' => 'nfs',
  },
  'CucsNetworkSensorThresholdStatus' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'upperNonRecoverable',
    '3' => 'upperCritical',
    '4' => 'upperNonCritical',
    '5' => 'lowerNonCritical',
    '6' => 'lowerCritical',
    '7' => 'lowerNonRecoverable',
    '100' => 'notSupported',
  },
  'CucsHcCatalogSourceType' => {
    '0' => 'cisco',
    '1' => 'local',
  },
  'CucsPolicyControlEpType' => {
    '0' => 'policy',
  },
  'CucsVmAdaptorOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '7' => 'initiatorPolicy',
    '8' => 'connPolicy',
  },
  'CucsBiosVfFrequencyFloorOverrideVpFrequencyFloorOverride' => {
    '0' => 'platformRecommended',
    '430' => 'disabled',
    '431' => 'enabled',
  },
  'CucsStorageFFCardState' => {
    '0' => 'undefined',
    '1' => 'configured',
    '2' => 'initializing',
    '3' => 'active',
    '4' => 'ignored',
    '5' => 'failed',
    '6' => 'unknown',
  },
  'CucsLsbootStorageType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsMoAnnotationType' => {
    '0' => 'keyValue',
    '1' => 'ipv4Addr',
    '2' => 'ipv6Addr',
    '3' => 'vlan',
    '4' => 'vnic',
  },
  'CucsMgmtStorageSubsystemState' => {
    '0' => 'unknown',
    '1' => 'uninitialized',
    '2' => 'initializing',
    '3' => 'initialized',
    '4' => 'unsupported',
    '5' => 'pendingReset',
  },
  'CucsConfigConsumerCatalogueFsmTaskItem' => {
    '0' => 'nop',
    '181' => 'delete',
    '332' => 'create',
  },
  'CucsEquipmentBoardAggregationRole' => {
    '0' => 'none',
    '1' => 'single',
    '2' => 'multiMaster',
    '3' => 'multiSlave',
  },
  'CucsComputeSystemFsmTaskItem' => {
    '0' => 'nop',
    '212' => 'register',
  },
  'CucsFabricPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
  },
  'CucsFabricQuerierType' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CucsVnicConnectionType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CucsPolicyDeviceProfileMigrateAdminSetting' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsStatsUcsDomain' => {
    '0' => 'unknown',
  },
  'CucsVnicPlacement' => {
    '0' => 'allVnic',
    '1' => 'staticAllFirst',
    '2' => 'dynamicAllLast',
  },
  'CucsCapabilityCatalogueFsmStageName' => {
    '0' => 'nop',
    '609' => 'deployCatalogueBegin',
    '610' => 'deployCatalogueSyncBladeAGLocal',
    '611' => 'deployCatalogueSyncBladeAGRemote',
    '612' => 'deployCatalogueSyncNicAGLocal',
    '613' => 'deployCatalogueSyncNicAGRemote',
    '614' => 'deployCatalogueSyncPortAGLocal',
    '615' => 'deployCatalogueSyncPortAGRemote',
    '616' => 'deployCatalogueSyncHostagentAGLocal',
    '617' => 'deployCatalogueSyncHostagentAGRemote',
    '618' => 'deployCatalogueFinalize',
    '619' => 'deployCatalogueFail',
    '620' => 'deployCatalogueSuccess',
    '904' => 'activateCatalogBegin',
    '905' => 'activateCatalogUnpackLocal',
    '906' => 'activateCatalogCopyRemote',
    '907' => 'activateCatalogApplyCatalog',
    '908' => 'activateCatalogRescanImages',
    '909' => 'activateCatalogEvaluateStatus',
    '936' => 'activateCatalogFail',
    '937' => 'activateCatalogSuccess',
    '1603' => 'activateCatalogCopyCatFromRep',
    '1604' => 'activateCatalogCopyExternalRepToRemote',
  },
  'CucsStorageAllocState' => {
    '0' => 'none',
    '1' => 'allocating',
    '2' => 'allocated',
    '3' => 'failed',
  },
  'CucsStorageTargetPath' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
  },
  'CucsFirmwareDistributableFsmTaskItem' => {
    '0' => 'nop',
    '594' => 'delete',
  },
  'CucsSmartlicenseTestFsmCurrentFsm' => {
    '0' => 'nop',
    '482' => 'configure',
  },
  'CucsComputeBladeFsmCurrentFsm' => {
    '0' => 'nop',
    '23' => 'discover',
    '144' => 'diag',
    '604' => 'updateBoardController',
    '665' => 'associate',
    '727' => 'disassociate',
    '767' => 'powerCap',
    '769' => 'decommission',
    '771' => 'softShutdown',
    '773' => 'hardShutdown',
    '775' => 'turnup',
    '777' => 'powercycle',
    '781' => 'hardreset',
    '785' => 'softreset',
    '789' => 'swConnUpd',
    '792' => 'biosRecovery',
    '806' => 'cmosReset',
    '815' => 'resetBmc',
    '879' => 'updateExtUsers',
    '891' => 'updateAdaptor',
    '898' => 'activateAdaptor',
    '932' => 'configSoL',
    '934' => 'unconfigSoL',
    '1036' => 'diagnosticInterrupt',
    '1055' => 'resetKvm',
    '1152' => 'updateBIOS',
    '1157' => 'activateBIOS',
    '1254' => 'resetIpmi',
    '1256' => 'fwUpgrade',
    '1478' => 'cimcSessionDelete',
    '1513' => 'serviceInfraDeploy',
    '1518' => 'serviceInfraWithdraw',
    '1531' => 'configBoard',
    '1533' => 'resetMemoryErrors',
    '1592' => 'flashController',
    '1611' => 'enableCimcSecureBoot',
    '1722' => 'oobStorageAdminConfig',
    '1945' => 'clearTPM',
    '2045' => 'diskZoningInventory',
    '2242' => 'cimcSecurityConfig',
  },
  'CucsNwctrlLinkFailAction' => {
    '0' => 'linkDown',
    '1' => 'warning',
  },
  'CucsFirmwarePackItemPresence' => {
    '0' => 'unknown',
    '1' => 'missing',
    '2' => 'present',
  },
  'CucsLsbootNvmePciSsdType' => {
    '1' => 'diskSsd',
    '2' => 'pciSsd',
  },
  'CucsPowerPowerAvailState' => {
    '0' => 'unknown',
    '1' => 'unavailable',
    '2' => 'available',
  },
  'CucsStorageFFDriveVisible' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CucsNetworkCountStatus' => {
    '0' => 'withinLimit',
    '1' => 'aboveLimit',
  },
  'CucsQosclassDefinitionFsmCurrentFsm' => {
    '0' => 'nop',
    '313' => 'configGlobalQoS',
  },
  'CucsEtherPIoFsmStageName' => {
    '0' => 'nop',
    '1014' => 'inCompatSfpPresenceBegin',
    '1015' => 'inCompatSfpPresenceShutdown',
    '1034' => 'inCompatSfpPresenceFail',
    '1035' => 'inCompatSfpPresenceSuccess',
    '1334' => 'inCompatSfpReplacedBegin',
    '1335' => 'inCompatSfpReplacedEnablePort',
    '1461' => 'inCompatSfpReplacedFail',
    '1462' => 'inCompatSfpReplacedSuccess',
  },
  'CucsBiosVfUSBPortConfigurationVpPort6064Emulation' => {
    '0' => 'platformRecommended',
    '391' => 'disabled',
    '392' => 'enabled',
  },
  'CucsPkiEpFsmTaskItem' => {
    '0' => 'nop',
    '206' => 'updateEp',
  },
  'CucsOrgLevel' => {
    '0' => 'root',
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CucsEquipmentSlotArraySelector' => {
    '0' => 'unknown',
    '1' => 'psu',
    '2' => 'fan',
    '3' => 'iocard',
    '5' => 'diskSlot',
    '6' => 'driveSlot',
    '7' => 'usbPort',
    '8' => 'ethernetPort',
    '9' => 'comPort',
    '10' => 'parPort',
    '11' => 'vgaPort',
    '12' => 'dviPort',
    '13' => 'keyboardPort',
    '14' => 'mousePort',
    '15' => 'gem',
    '16' => 'blade',
  },
  'CucsGlRequestFsmCurrentFsm' => {
    '0' => 'nop',
    '583' => 'evaluate',
    '587' => 'createGlobalIdPool',
    '589' => 'createGlobalPolicy',
    '591' => 'globalize',
  },
  'CucsFabricFcoeSanPcOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsFabricComputeMSlotEpFsmStageName' => {
    '0' => 'nop',
    '1877' => 'identifyBegin',
    '1878' => 'identifyExecuteLocal',
    '1879' => 'identifyExecutePeer',
    '1919' => 'identifyFail',
    '1920' => 'identifySuccess',
  },
  'CucsFabricEthMonOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsExtpolEpFsmTaskItem' => {
    '0' => 'nop',
    '1193' => 'repairCert',
    '1349' => 'registerFsm',
  },
  'CucsLsbootIScsiType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
    '6' => 'efiShell',
  },
  'CucsGlRequestFsmStageName' => {
    '0' => 'nop',
    '583' => 'evaluateBegin',
    '584' => 'evaluateValidate',
    '585' => 'evaluateFetchDomainData',
    '586' => 'evaluateEvaluate',
    '587' => 'createGlobalIdPoolBegin',
    '588' => 'createGlobalIdPoolCreatePolicies',
    '589' => 'createGlobalPolicyBegin',
    '590' => 'createGlobalPolicyCreatePolicies',
    '591' => 'globalizeBegin',
    '592' => 'globalizeCreateOrg',
    '593' => 'globalizeCreatePolicies',
    '594' => 'globalizeUpdateDomainMos',
    '595' => 'globalizeCreateVlanOrgPermission',
    '596' => 'globalizeCreateGSP',
    '597' => 'globalizeResolveGlobalPoolDn',
    '598' => 'globalizeAddIdToGlobalPool',
    '599' => 'globalizeAssignIds',
    '600' => 'globalizeUnassignIds',
    '662' => 'createGlobalIdPoolFail',
    '663' => 'createGlobalIdPoolSuccess',
    '664' => 'createGlobalPolicyFail',
    '665' => 'createGlobalPolicySuccess',
    '666' => 'evaluateFail',
    '667' => 'evaluateSuccess',
    '668' => 'globalizeFail',
    '669' => 'globalizeSuccess',
    '680' => 'globalizeCreateUpdatePolicyScope',
    '681' => 'globalizeReapplyGSP',
  },
  'CucsBiosVfUSBPortConfigurationVpUSBPortSDCard' => {
    '0' => 'platformRecommended',
    '403' => 'disabled',
    '404' => 'enabled',
  },
  'CucsExtpolEpFsmStageName' => {
    '0' => 'nop',
    '1193' => 'repairCertBegin',
    '1194' => 'repairCertVerifyGuid',
    '1195' => 'repairCertUnregister',
    '1196' => 'repairCertCleanOldData',
    '1197' => 'repairCertRequest',
    '1198' => 'repairCertVerify',
    '1349' => 'registerFsmBegin',
    '1350' => 'registerFsmExecute',
    '1393' => 'registerFsmFail',
    '1394' => 'registerFsmSuccess',
    '1395' => 'repairCertFail',
    '1396' => 'repairCertSuccess',
  },
  'CucsMemoryFormFactor' => {
    '0' => 'undiscovered',
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'simm',
    '9' => 'dimm',
    '10' => 'tsop',
    '12' => 'rimm',
    '13' => 'sodimm',
    '14' => 'srimm',
    '15' => 'fbDimm',
  },
  'CucsSysdebugAutoCoreFileExportTargetFsmStageName' => {
    '0' => 'nop',
    '216' => 'configureBegin',
    '217' => 'configureLocal',
    '218' => 'configurePeer',
    '444' => 'configureFail',
    '445' => 'configureSuccess',
  },
  'CucsFdPhysicalFsmStageName' => {
    '0' => 'nop',
    '616' => 'configureBegin',
    '617' => 'configureResolvePolicies',
    '618' => 'configureCollectIdContexts',
    '619' => 'configureApplyThrottle',
    '620' => 'configureThrottleWait',
    '621' => 'configureResolveIdentifiers',
    '622' => 'configureValidateNetworkDesign',
    '623' => 'configureConsumerVxanDeployment',
    '624' => 'configureWaitForConsumerReceivingVxan',
    '625' => 'configurePushPolicies',
    '626' => 'configureApplyConfig',
    '658' => 'configureFail',
    '659' => 'configureSuccess',
  },
  'CucsVnicInstantiation' => {
    '0' => 'manual',
    '1' => 'default',
    '2' => 'dynamic',
    '3' => 'dynamicVf',
  },
  'CucsConfigBackupFsmCurrentFsm' => {
    '0' => 'nop',
    '183' => 'delete',
  },
  'CucsFdPhysicalFsmTaskItem' => {
    '0' => 'nop',
    '616' => 'configure',
  },
  'CucsAdaptorCapDefType' => {
    '1' => 'virtualizedEthIf',
    '2' => 'virtualizedFcIf',
    '3' => 'virtualizedScsiIf',
    '4' => 'nonVirtualizedEthIf',
    '5' => 'nonVirtualizedFcIf',
    '6' => 'fcoe',
    '7' => 'protectedEthIf',
    '8' => 'protectedFcIf',
    '9' => 'protectedFcoe',
    '10' => 'pathEncapVirtual',
    '11' => 'pathEncapConsolidated',
    '12' => 'uplinkAggregation',
    '13' => 'virtualizedEthSriov',
    '14' => 'virtualizedFcSriov',
    '15' => 'virtualizedEthSriovUsnic',
    '16' => 'virtualizedEthVmq',
    '17' => 'ethFlowMonitoringNetflow',
    '18' => 'ethRoce',
    '19' => 'ethVxlan',
    '20' => 'ethNvgre',
    '21' => 'virtualizedCeEthIf',
    '22' => 'pathEncapVirtualCe',
    '23' => 'pxebootConfigSupport',
    '25' => 'oracleRacSupport',
  },
  'CucsStorageSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '1383' => 'sync',
  },
  'CucsVnicIScsiIfDefType' => {
    '0' => 'static',
    '1' => 'dynamicNw',
    '2' => 'option17',
    '4' => 'option43',
  },
  'CucsOsEthBondModeLBXmitHashType' => {
    '0' => 'layer2',
    '1' => 'layer2Plus3',
    '2' => 'layer3Plus4',
    '3' => 'encap2Plus3',
    '4' => 'encap3Plus4',
  },
  'CucsMgmtBackupType' => {
    '1' => 'fullState',
    '2' => 'configAll',
    '3' => 'configSystem',
    '4' => 'configLogical',
  },
  'CucsAaaRealmFsmStageName' => {
    '0' => 'nop',
    '200' => 'updateRealmBegin',
    '201' => 'updateRealmSetRealmLocal',
    '202' => 'updateRealmSetRealmPeer',
    '324' => 'updateRealmFail',
    '325' => 'updateRealmSuccess',
    '385' => 'updateRealmSetRealm',
  },
  'CucsEquipmentSwitchIOCardFsmTaskItem' => {
    '0' => 'nop',
    '2002' => 'evacuate',
    '2004' => 'resetEvacuate',
  },
  'CucsFaultBasePolicyClearAction' => {
    '0' => 'retain',
    '1' => 'delete',
  },
  'CucsAdaptorHostMgmtCapPresence' => {
    '0' => 'unspecified',
    '1' => 'host',
    '2' => 'cimc',
  },
  'CucsFabricEtherRefLcCtrlState' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CucsAaaRealmFsmTaskItem' => {
    '0' => 'nop',
    '200' => 'updateRealm',
  },
  'CucsPolicyDomainUnRegistrationStateType' => {
    '0' => 'unknown',
    '1' => 'fail',
    '2' => 'ok',
  },
  'CucsMgmtIntAuthPolicyMethod' => {
    '0' => 'none',
    '1' => 'password',
  },
  'CucsFcpoolInitiatorsAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CucsIpProtocol' => {
    '1' => 'tcp',
    '2' => 'udp',
  },
  'CucsVnicLanConnTemplSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'mgmt',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CucsComputeAdminMemoryState' => {
    '1' => 'policy',
    '2' => 'resetMemoryErrors',
    '3' => 'resetInProgress',
  },
  'CucsComputeServerUnitFsmStageName' => {
    '0' => 'nop',
    '665' => 'associateBegin',
    '668' => 'associateUpdateIBMCFw',
    '669' => 'associateWaitForIBMCFwUpdate',
    '670' => 'associateActivateIBMCFw',
    '671' => 'associateResetIBMC',
    '672' => 'associatePreSanitize',
    '673' => 'associateSanitize',
    '674' => 'associateConfigUserAccess',
    '675' => 'associateBladePowerOff',
    '676' => 'associateUpdateBoardCtrlRequest',
    '677' => 'associatePollBoardCtrlUpdateStatus',
    '678' => 'associatePowerOn',
    '679' => 'associateBmcPreconfigPnuOSLocal',
    '680' => 'associateBmcPreconfigPnuOSPeer',
    '681' => 'associateBmcConfigPnuOS',
    '682' => 'associateSwConfigPnuOSLocal',
    '683' => 'associateSwConfigPnuOSPeer',
    '684' => 'associateUpdateAdaptorNwFwLocal',
    '685' => 'associateUpdateAdaptorNwFwPeer',
    '686' => 'associateWaitForAdaptorNwFwUpdateLocal',
    '687' => 'associateWaitForAdaptorNwFwUpdatePeer',
    '688' => 'associateActivateAdaptorNwFwLocal',
    '689' => 'associateActivateAdaptorNwFwPeer',
    '690' => 'associateNicConfigPnuOSLocal',
    '691' => 'associateNicConfigPnuOSPeer',
    '692' => 'associateBootPnuos',
    '693' => 'associateBootWait',
    '694' => 'associateBiosPostCompletion',
    '695' => 'associateHagPnuOSConnect',
    '696' => 'associatePnuOSIdent',
    '697' => 'associatePnuOSPolicy',
    '698' => 'associatePnuOSValidate',
    '699' => 'associatePnuOSSelfTest',
    '700' => 'associateBiosImgUpdate',
    '701' => 'associateStorageCtlrImgUpdate',
    '702' => 'associateHbaImgUpdate',
    '703' => 'associateNicImgUpdate',
    '704' => 'associatePnuOSInventory',
    '705' => 'associatePnuOSConfig',
    '706' => 'associatePnuOSLocalDiskConfig',
    '707' => 'associatePnuOSUnloadDrivers',
    '708' => 'associateBmcUnconfigPnuOS',
    '709' => 'associateNicUnconfigPnuOSLocal',
    '710' => 'associateNicUnconfigPnuOSPeer',
    '711' => 'associateSwUnconfigPnuOSLocal',
    '712' => 'associateSwUnconfigPnuOSPeer',
    '713' => 'associateSwConfigHostOSLocal',
    '714' => 'associateSwConfigHostOSPeer',
    '715' => 'associateNicConfigHostOSLocal',
    '716' => 'associateNicConfigHostOSPeer',
    '717' => 'associateHagPnuOSDisconnect',
    '718' => 'associateConfigSoL',
    '719' => 'associatePrepareForBoot',
    '720' => 'associateConfigUuid',
    '721' => 'associateBootHost',
    '722' => 'associateHagHostOSConnect',
    '723' => 'associateHostOSIdent',
    '724' => 'associateHostOSPolicy',
    '725' => 'associateHostOSValidate',
    '726' => 'associateHostOSConfig',
    '727' => 'disassociateBegin',
    '730' => 'disassociateConfigUserAccess',
    '731' => 'disassociatePowerOn',
    '732' => 'disassociatePreSanitize',
    '733' => 'disassociateSanitize',
    '734' => 'disassociateNicUnconfigHostOSLocal',
    '735' => 'disassociateNicUnconfigHostOSPeer',
    '736' => 'disassociateSwUnconfigHostOSLocal',
    '737' => 'disassociateSwUnconfigHostOSPeer',
    '738' => 'disassociateBmcPreconfigPnuOSLocal',
    '739' => 'disassociateBmcPreconfigPnuOSPeer',
    '740' => 'disassociateBmcConfigPnuOS',
    '741' => 'disassociateSwConfigPnuOSLocal',
    '742' => 'disassociateSwConfigPnuOSPeer',
    '743' => 'disassociateNicConfigPnuOSLocal',
    '744' => 'disassociateNicConfigPnuOSPeer',
    '745' => 'disassociateConfigBios',
    '746' => 'disassociateBootPnuos',
    '747' => 'disassociateBootWait',
    '748' => 'disassociateBiosPostCompletion',
    '749' => 'disassociateHagPnuOSConnect',
    '750' => 'disassociatePnuOSIdent',
    '751' => 'disassociatePnuOSPolicy',
    '752' => 'disassociatePnuOSValidate',
    '753' => 'disassociatePnuOSUnconfig',
    '754' => 'disassociatePnuOSScrub',
    '755' => 'disassociatePnuOSSelfTest',
    '756' => 'disassociateBmcUnconfigPnuOS',
    '757' => 'disassociateNicUnconfigPnuOSLocal',
    '758' => 'disassociateNicUnconfigPnuOSPeer',
    '759' => 'disassociateHagPnuOSDisconnect',
    '760' => 'disassociateUnconfigUuid',
    '761' => 'disassociateShutdown',
    '762' => 'disassociateUnconfigBios',
    '763' => 'disassociateSwUnconfigPnuOSLocal',
    '764' => 'disassociateSwUnconfigPnuOSPeer',
    '765' => 'disassociateUnconfigSoL',
    '766' => 'disassociateHandlePooling',
    '767' => 'powerCapBegin',
    '768' => 'powerCapConfig',
    '769' => 'decommissionBegin',
    '770' => 'decommissionExecute',
    '771' => 'softShutdownBegin',
    '772' => 'softShutdownExecute',
    '773' => 'hardShutdownBegin',
    '774' => 'hardShutdownExecute',
    '775' => 'turnupBegin',
    '776' => 'turnupExecute',
    '777' => 'powercycleBegin',
    '778' => 'powercyclePreSanitize',
    '779' => 'powercycleSanitize',
    '780' => 'powercycleExecute',
    '781' => 'hardresetBegin',
    '782' => 'hardresetPreSanitize',
    '783' => 'hardresetSanitize',
    '784' => 'hardresetExecute',
    '785' => 'softresetBegin',
    '786' => 'softresetPreSanitize',
    '787' => 'softresetSanitize',
    '788' => 'softresetExecute',
    '789' => 'swConnUpdBegin',
    '790' => 'swConnUpdA',
    '791' => 'swConnUpdB',
    '792' => 'biosRecoveryBegin',
    '793' => 'biosRecoveryShutdown',
    '794' => 'biosRecoveryPreSanitize',
    '795' => 'biosRecoverySanitize',
    '796' => 'biosRecoverySetupVmediaLocal',
    '797' => 'biosRecoverySetupVmediaPeer',
    '798' => 'biosRecoveryStart',
    '799' => 'biosRecoveryWait',
    '800' => 'biosRecoveryCleanup',
    '801' => 'biosRecoveryReset',
    '802' => 'biosRecoveryTeardownVmediaLocal',
    '803' => 'biosRecoveryTeardownVmediaPeer',
    '806' => 'cmosResetBegin',
    '807' => 'cmosResetPreSanitize',
    '808' => 'cmosResetSanitize',
    '809' => 'cmosResetExecute',
    '810' => 'cmosResetReconfigBios',
    '811' => 'cmosResetReconfigUuid',
    '812' => 'cmosResetBladePowerOn',
    '815' => 'resetBmcBegin',
    '816' => 'resetBmcExecute',
    '879' => 'updateExtUsersBegin',
    '880' => 'updateExtUsersDeploy',
    '891' => 'updateAdaptorBegin',
    '892' => 'updateAdaptorPowerOn',
    '893' => 'updateAdaptorUpdateRequestLocal',
    '894' => 'updateAdaptorUpdateRequestPeer',
    '895' => 'updateAdaptorPollUpdateStatusLocal',
    '896' => 'updateAdaptorPollUpdateStatusPeer',
    '897' => 'updateAdaptorPowerOff',
    '898' => 'activateAdaptorBegin',
    '899' => 'activateAdaptorPowerOn',
    '900' => 'activateAdaptorActivateLocal',
    '901' => 'activateAdaptorActivatePeer',
    '902' => 'activateAdaptorReset',
    '932' => 'configSoLBegin',
    '933' => 'configSoLExecute',
    '934' => 'unconfigSoLBegin',
    '935' => 'unconfigSoLExecute',
    '940' => 'activateAdaptorFail',
    '941' => 'activateAdaptorSuccess',
    '942' => 'associateFail',
    '943' => 'associateSuccess',
    '946' => 'biosRecoveryFail',
    '947' => 'biosRecoverySuccess',
    '948' => 'cmosResetFail',
    '949' => 'cmosResetSuccess',
    '950' => 'configSoLFail',
    '951' => 'configSoLSuccess',
    '952' => 'decommissionFail',
    '953' => 'decommissionSuccess',
    '954' => 'disassociateFail',
    '955' => 'disassociateSuccess',
    '956' => 'hardShutdownFail',
    '957' => 'hardShutdownSuccess',
    '958' => 'hardresetFail',
    '959' => 'hardresetSuccess',
    '960' => 'powerCapFail',
    '961' => 'powerCapSuccess',
    '962' => 'powercycleFail',
    '963' => 'powercycleSuccess',
    '964' => 'resetBmcFail',
    '965' => 'resetBmcSuccess',
    '966' => 'softShutdownFail',
    '967' => 'softShutdownSuccess',
    '968' => 'softresetFail',
    '969' => 'softresetSuccess',
    '970' => 'swConnUpdFail',
    '971' => 'swConnUpdSuccess',
    '972' => 'turnupFail',
    '973' => 'turnupSuccess',
    '974' => 'unconfigSoLFail',
    '975' => 'unconfigSoLSuccess',
    '976' => 'updateAdaptorFail',
    '977' => 'updateAdaptorSuccess',
    '978' => 'updateExtUsersFail',
    '979' => 'updateExtUsersSuccess',
    '1019' => 'decommissionStopVMediaLocal',
    '1020' => 'decommissionStopVMediaPeer',
    '1021' => 'biosRecoveryStopVMediaLocal',
    '1022' => 'biosRecoveryStopVMediaPeer',
    '1036' => 'diagnosticInterruptBegin',
    '1037' => 'diagnosticInterruptExecute',
    '1038' => 'diagnosticInterruptFail',
    '1039' => 'diagnosticInterruptSuccess',
    '1040' => 'associateLocalDiskFwUpdate',
    '1055' => 'resetKvmBegin',
    '1056' => 'resetKvmExecute',
    '1057' => 'resetKvmFail',
    '1058' => 'resetKvmSuccess',
    '1069' => 'associateSwConfigPortNivLocal',
    '1070' => 'associateSwConfigPortNivPeer',
    '1071' => 'disassociateSwConfigPortNivLocal',
    '1072' => 'disassociateSwConfigPortNivPeer',
    '1104' => 'associateSolRedirectEnable',
    '1105' => 'associateSerialDebugPnuOSConnect',
    '1106' => 'associateSerialDebugPnuOSDisconnect',
    '1107' => 'associateSolRedirectDisable',
    '1108' => 'disassociateSolRedirectEnable',
    '1109' => 'disassociateSerialDebugPnuOSConnect',
    '1110' => 'disassociateSerialDebugPnuOSDisconnect',
    '1111' => 'disassociateSolRedirectDisable',
    '1112' => 'decommissionCleanupCIMC',
    '1152' => 'updateBIOSBegin',
    '1153' => 'updateBIOSClear',
    '1154' => 'updateBIOSPollClearStatus',
    '1155' => 'updateBIOSUpdateRequest',
    '1156' => 'updateBIOSPollUpdateStatus',
    '1157' => 'activateBIOSBegin',
    '1158' => 'activateBIOSPowerOff',
    '1159' => 'activateBIOSClear',
    '1160' => 'activateBIOSPollClearStatus',
    '1161' => 'activateBIOSActivate',
    '1162' => 'activateBIOSPollActivateStatus',
    '1163' => 'activateBIOSUpdateTokens',
    '1164' => 'activateBIOSPowerOn',
    '1169' => 'associateClearBiosUpdate',
    '1170' => 'associatePollClearBiosUpdateStatus',
    '1171' => 'associateUpdateBiosRequest',
    '1172' => 'associatePollBiosUpdateStatus',
    '1173' => 'associateActivateBios',
    '1174' => 'associatePollBiosActivateStatus',
    '1175' => 'associatePnuOSCatalog',
    '1176' => 'disassociatePnuOSCatalog',
    '1178' => 'activateBIOSFail',
    '1179' => 'activateBIOSSuccess',
    '1180' => 'updateBIOSFail',
    '1181' => 'updateBIOSSuccess',
    '1193' => 'associateMarkAdapterForReboot',
    '1194' => 'associateDeassertResetBypass',
    '1195' => 'associateVerifyFcZoneConfig',
    '1196' => 'disassociateDeassertResetBypass',
    '1197' => 'disassociateVerifyFcZoneConfig',
    '1198' => 'decommissionCleanupPortConfigLocal',
    '1199' => 'decommissionCleanupPortConfigPeer',
    '1200' => 'resetIpmiBegin',
    '1201' => 'resetIpmiExecute',
    '1202' => 'fwUpgradeBegin',
    '1203' => 'fwUpgradeUpdateIBMCFw',
    '1204' => 'fwUpgradeWaitForIBMCFwUpdate',
    '1205' => 'fwUpgradeActivateIBMCFw',
    '1206' => 'fwUpgradeResetIBMC',
    '1207' => 'fwUpgradePreSanitize',
    '1208' => 'fwUpgradeSanitize',
    '1209' => 'fwUpgradeBladePowerOff',
    '1210' => 'fwUpgradeUpdateBoardCtrlRequest',
    '1211' => 'fwUpgradePollBoardCtrlUpdateStatus',
    '1212' => 'fwUpgradeClearBiosUpdate',
    '1213' => 'fwUpgradePollClearBiosUpdateStatus',
    '1214' => 'fwUpgradeUpdateBiosRequest',
    '1215' => 'fwUpgradePollBiosUpdateStatus',
    '1216' => 'fwUpgradeActivateBios',
    '1217' => 'fwUpgradePollBiosActivateStatus',
    '1218' => 'fwUpgradePowerOn',
    '1219' => 'fwUpgradeBmcPreconfigPnuOSLocal',
    '1220' => 'fwUpgradeBmcPreconfigPnuOSPeer',
    '1221' => 'fwUpgradeSwConfigPortNivLocal',
    '1222' => 'fwUpgradeSwConfigPortNivPeer',
    '1223' => 'fwUpgradeSwConfigPnuOSLocal',
    '1224' => 'fwUpgradeSwConfigPnuOSPeer',
    '1225' => 'fwUpgradeUpdateAdaptorNwFwLocal',
    '1226' => 'fwUpgradeUpdateAdaptorNwFwPeer',
    '1227' => 'fwUpgradeWaitForAdaptorNwFwUpdateLocal',
    '1228' => 'fwUpgradeWaitForAdaptorNwFwUpdatePeer',
    '1229' => 'fwUpgradeActivateAdaptorNwFwLocal',
    '1230' => 'fwUpgradeActivateAdaptorNwFwPeer',
    '1231' => 'fwUpgradeNicConfigPnuOSLocal',
    '1232' => 'fwUpgradeNicConfigPnuOSPeer',
    '1233' => 'fwUpgradeBmcConfigPnuOS',
    '1234' => 'fwUpgradeSolRedirectEnable',
    '1235' => 'fwUpgradeSerialDebugPnuOSConnect',
    '1236' => 'fwUpgradeBootPnuos',
    '1237' => 'fwUpgradeBootWait',
    '1238' => 'fwUpgradeBiosPostCompletion',
    '1239' => 'fwUpgradeHagPnuOSConnect',
    '1240' => 'fwUpgradePnuOSIdent',
    '1241' => 'fwUpgradePnuOSPolicy',
    '1242' => 'fwUpgradePnuOSCatalog',
    '1243' => 'fwUpgradePnuOSValidate',
    '1244' => 'fwUpgradePnuOSSelfTest',
    '1245' => 'fwUpgradeStorageCtlrImgUpdate',
    '1246' => 'fwUpgradeHbaImgUpdate',
    '1247' => 'fwUpgradeNicImgUpdate',
    '1248' => 'fwUpgradeLocalDiskFwUpdate',
    '1249' => 'fwUpgradePnuOSConfig',
    '1250' => 'fwUpgradePnuOSInventory',
    '1251' => 'fwUpgradeBiosImgUpdate',
    '1252' => 'fwUpgradePnuOSUnloadDrivers',
    '1253' => 'fwUpgradeBmcUnconfigPnuOS',
    '1254' => 'fwUpgradeNicUnconfigPnuOSLocal',
    '1255' => 'fwUpgradeNicUnconfigPnuOSPeer',
    '1256' => 'fwUpgradeSwUnconfigPnuOSLocal',
    '1257' => 'fwUpgradeSwUnconfigPnuOSPeer',
    '1258' => 'fwUpgradeDeassertResetBypass',
    '1259' => 'fwUpgradeHagPnuOSDisconnect',
    '1260' => 'fwUpgradeSerialDebugPnuOSDisconnect',
    '1261' => 'fwUpgradeSolRedirectDisable',
    '1262' => 'fwUpgradeShutdown',
    '1307' => 'activateAdaptorDeassertResetBypass',
    '1386' => 'fwUpgradeFail',
    '1387' => 'fwUpgradeSuccess',
    '1388' => 'resetIpmiFail',
    '1389' => 'resetIpmiSuccess',
    '1468' => 'associateConfigFlexFlash',
    '1469' => 'associateSyncPowerState',
    '1470' => 'disassociateUnconfigFlexFlash',
    '1477' => 'cimcSessionDeleteBegin',
    '1478' => 'cimcSessionDeleteExecute',
    '1483' => 'cimcSessionDeleteFail',
    '1484' => 'cimcSessionDeleteSuccess',
    '1497' => 'updateBoardControllerBegin',
    '1498' => 'updateBoardControllerPrepareForUpdate',
    '1499' => 'updateBoardControllerServerPowerOff',
    '1500' => 'updateBoardControllerUpdateRequest',
    '1501' => 'updateBoardControllerPollUpdateStatus',
    '1502' => 'updateBoardControllerServerPowerOn',
    '1506' => 'configBoardBegin',
    '1507' => 'configBoardConfigMemoryPolicy',
    '1508' => 'resetMemoryErrorsBegin',
    '1509' => 'resetMemoryErrorsExecute',
    '1520' => 'associateOobStorageInventory',
    '1521' => 'associateSwConfigServiceInfraLocal',
    '1522' => 'associateSwConfigServiceInfraPeer',
    '1523' => 'associateNicConfigServiceInfraLocal',
    '1524' => 'associateNicConfigServiceInfraPeer',
    '1525' => 'disassociateNicUnconfigServiceInfraLocal',
    '1526' => 'disassociateNicUnconfigServiceInfraPeer',
    '1527' => 'disassociateConfigFlexFlashScrub',
    '1531' => 'serviceInfraDeployBegin',
    '1532' => 'serviceInfraDeploySwConfigLocal',
    '1533' => 'serviceInfraDeploySwConfigPeer',
    '1534' => 'serviceInfraDeployNicConfigLocal',
    '1535' => 'serviceInfraDeployNicConfigPeer',
    '1536' => 'serviceInfraWithdrawBegin',
    '1537' => 'serviceInfraWithdrawSwUnConfigLocal',
    '1538' => 'serviceInfraWithdrawSwUnConfigPeer',
    '1539' => 'serviceInfraWithdrawNicUnConfigLocal',
    '1540' => 'serviceInfraWithdrawNicUnConfigPeer',
    '1541' => 'configBoardFail',
    '1542' => 'configBoardSuccess',
    '1543' => 'resetMemoryErrorsFail',
    '1544' => 'resetMemoryErrorsSuccess',
    '1545' => 'serviceInfraDeployFail',
    '1546' => 'serviceInfraDeploySuccess',
    '1547' => 'serviceInfraWithdrawFail',
    '1548' => 'serviceInfraWithdrawSuccess',
    '1549' => 'updateBoardControllerFail',
    '1550' => 'updateBoardControllerSuccess',
    '1561' => 'associatePowerOnPreConfig',
    '1562' => 'disassociateResetSecureBootConfig',
    '1576' => 'associateDownloadImages',
    '1577' => 'associateCopyRemote',
    '1578' => 'associateUnconfigExtMgmtRules',
    '1579' => 'associateUnconfigExtMgmtGw',
    '1580' => 'associateUnconfigCimcVMedia',
    '1581' => 'associateGraphicsImageUpdate',
    '1582' => 'associateConfigExtMgmtRules',
    '1583' => 'associateConfigExtMgmtGw',
    '1584' => 'associateConfigCimcVMedia',
    '1585' => 'associateDeleteCurlDownloadedImages',
    '1586' => 'disassociateConfigKvmMgmtDefaultSetting',
    '1587' => 'disassociateUnconfigExtMgmtRules',
    '1588' => 'disassociateUnconfigExtMgmtGw',
    '1589' => 'disassociateUnconfigCimcVMedia',
    '1590' => 'decommissionUnconfigExtMgmtRules',
    '1591' => 'decommissionUnconfigExtMgmtGw',
    '1592' => 'fwUpgradeDownloadImages',
    '1593' => 'fwUpgradeCopyRemote',
    '1594' => 'fwUpgradeUnconfigExtMgmtRules',
    '1595' => 'fwUpgradeUnconfigExtMgmtGw',
    '1596' => 'fwUpgradeUnconfigCimcVMedia',
    '1597' => 'fwUpgradeGraphicsImageUpdate',
    '1598' => 'fwUpgradeDeleteCurlDownloadedImages',
    '1599' => 'flashControllerBegin',
    '1600' => 'flashControllerUpdateFlashLife',
    '1601' => 'flashControllerFail',
    '1602' => 'flashControllerSuccess',
    '1613' => 'enableCimcSecureBootBegin',
    '1614' => 'enableCimcSecureBootUpdateRequest',
    '1615' => 'enableCimcSecureBootPollUpdateStatus',
    '1616' => 'enableCimcSecureBootActivate',
    '1617' => 'enableCimcSecureBootReset',
    '1620' => 'enableCimcSecureBootFail',
    '1621' => 'enableCimcSecureBootSuccess',
    '1698' => 'associateCheckPowerAvailability',
    '1699' => 'associatePowerDeployWait',
    '1700' => 'associateOobStorageConfig',
    '1702' => 'associateNicConfigParamsHostOSLocal',
    '1703' => 'associateNicConfigParamsHostOSPeer',
    '1706' => 'disassociateCheckPowerAvailability',
    '1707' => 'disassociatePowerDeployWait',
    '1708' => 'turnupCheckPowerAvailability',
    '1709' => 'turnupPowerDeployWait',
    '1710' => 'powercycleCheckPowerAvailability',
    '1711' => 'powercyclePowerDeployWait',
    '1712' => 'hardresetCheckPowerAvailability',
    '1713' => 'hardresetPowerDeployWait',
    '1714' => 'softresetCheckPowerAvailability',
    '1715' => 'softresetPowerDeployWait',
    '1716' => 'biosRecoveryCheckPowerAvailability',
    '1717' => 'biosRecoveryPowerDeployWait',
    '1718' => 'cmosResetCheckPowerAvailability',
    '1719' => 'cmosResetPowerDeployWait',
    '1720' => 'fwUpgradeCheckPowerAvailability',
    '1721' => 'fwUpgradePowerDeployWait',
    '1722' => 'oobStorageAdminConfigBegin',
    '1723' => 'oobStorageAdminConfigPreSanitize',
    '1724' => 'oobStorageAdminConfigSanitize',
    '1725' => 'oobStorageAdminConfigTearDownVMediaLocal',
    '1726' => 'oobStorageAdminConfigTearDownVMediaPeer',
    '1727' => 'oobStorageAdminConfigBootHost',
    '1728' => 'oobStorageAdminConfigBootWait',
    '1729' => 'oobStorageAdminConfigOobStorageConfig',
    '1730' => 'oobStorageAdminConfigOobStorageInventory',
    '1731' => 'oobStorageAdminConfigShutdown',
    '1800' => 'activateBIOSCheckPowerAvailability',
    '1801' => 'activateBIOSPowerDeployWait',
    '1802' => 'updateAdaptorCheckPowerAvailability',
    '1803' => 'updateAdaptorPowerDeployWait',
    '1804' => 'activateAdaptorCheckPowerAvailability',
    '1805' => 'activateAdaptorPowerDeployWait',
    '1806' => 'updateBoardControllerCheckPowerAvailability',
    '1807' => 'updateBoardControllerPowerDeployWait',
    '1813' => 'oobStorageAdminConfigFail',
    '1814' => 'oobStorageAdminConfigSuccess',
    '1880' => 'associateDeleteImagesRemote',
    '1881' => 'disassociateOobDiskScrub',
    '1882' => 'fwUpgradeDeleteImagesRemote',
    '1885' => 'discoverBegin',
    '1886' => 'discoverCimcPresence',
    '1887' => 'discoverBmcInventory',
    '1888' => 'discoverPreSanitize',
    '1889' => 'discoverSanitize',
    '1890' => 'discoverConfigUserAccess',
    '1891' => 'discoverCleanupNicConfigLocal',
    '1892' => 'discoverCleanupNicConfigPeer',
    '1893' => 'discoverUnconfigExtMgmtRules',
    '1894' => 'discoverUnconfigExtMgmtGw',
    '1895' => 'discoverUnconfigCimcVMedia',
    '1896' => 'discoverBmcConfigPnuOS',
    '1897' => 'discoverBootPnuos',
    '1898' => 'discoverBladeBootWait',
    '1899' => 'discoverBiosPostCompletion',
    '1900' => 'discoverReadSmbios',
    '1901' => 'discoverBmcShutdownDiscovered',
    '1902' => 'discoverHandlePooling',
    '1903' => 'discoverSuccess',
    '1904' => 'discoverFail',
    '1943' => 'associateUnlockFirmwareImage',
    '1944' => 'decommissionPrecleanupPortConfig',
    '1945' => 'clearTPMBegin',
    '1946' => 'clearTPMPreSanitize',
    '1947' => 'clearTPMSanitize',
    '1948' => 'clearTPMClear',
    '1949' => 'clearTPMBootHost',
    '1950' => 'clearTPMBiosPostCompletion',
    '1951' => 'clearTPMReadSmBios',
    '1952' => 'clearTPMBladePowerOff',
    '1953' => 'clearTPMReconfigBios',
    '1954' => 'clearTPMBladePowerOn',
    '1955' => 'fwUpgradeUnlockFirmwareImage',
    '1957' => 'clearTPMFail',
    '1958' => 'clearTPMSuccess',
    '1964' => 'clearTPMStopVMediaLocal',
    '1965' => 'clearTPMStopVMediaPeer',
    '1966' => 'clearTPMSetupVmedia',
    '1967' => 'clearTPMUnconfigVmedia',
    '1968' => 'updateBoardControllerPowerCycleBoard',
    '1969' => 'updateBoardControllerPollBoardCtrlPowerCycle',
    '1970' => 'associatePowerCycleBoard',
    '1971' => 'associatePollBoardCtrlPowerCycle',
    '1972' => 'fwUpgradePowerCycleBoard',
    '1973' => 'fwUpgradePollBoardCtrlPowerCycle',
    '1978' => 'associateCalculateVlanGroupForHostOSLocal',
    '1979' => 'associateCalculateVlanGroupForHostOSPeer',
    '1998' => 'associateConfigFanSpeed',
    '1999' => 'associateSasExpanderImgUpdate',
    '2000' => 'fwUpgradeSasExpanderImgUpdate',
    '2001' => 'fwUpgradeOobStorageInventory',
    '2030' => 'associateOobSasExpanderImgUpdate',
    '2031' => 'associateOobPollSasExpanderUpdateStatus',
    '2032' => 'associateOobSasExpanderImgActivate',
    '2033' => 'associateOobPollSasExpanderActivateStatus',
    '2034' => 'associateCiscoOSOpenGate',
    '2037' => 'fwUpgradeOobSasExpanderImgUpdate',
    '2038' => 'fwUpgradeOobPollSasExpanderUpdateStatus',
    '2039' => 'fwUpgradeOobSasExpanderImgActivate',
    '2040' => 'fwUpgradeOobPollSasExpanderActivateStatus',
    '2041' => 'fwUpgradeCiscoOSOpenGate',
    '2043' => 'oobStorageAdminConfigCheckPowerAvailability',
    '2044' => 'oobStorageAdminConfigPowerDeployWait',
    '2045' => 'diskZoningInventoryBegin',
    '2046' => 'diskZoningInventoryPreSanitize',
    '2047' => 'diskZoningInventorySanitize',
    '2048' => 'diskZoningInventoryBootHost',
    '2049' => 'diskZoningInventoryBootWait',
    '2050' => 'diskZoningInventoryStorageInventory',
    '2051' => 'diskZoningInventoryShutdown',
    '2052' => 'discoverBmcFactoryReset',
    '2161' => 'diskZoningInventoryFail',
    '2162' => 'diskZoningInventorySuccess',
    '2200' => 'activateAdaptorAssertBypassWait',
    '2209' => 'diagBegin',
    '2210' => 'diagPreSanitize',
    '2211' => 'diagSanitize',
    '2212' => 'diagCheckPowerAvailability',
    '2213' => 'diagDisableScriptableVMedia',
    '2214' => 'diagPreconfigVmediaLocal',
    '2215' => 'diagPreconfigVmediaPeer',
    '2216' => 'diagSetupVmediaLocal',
    '2217' => 'diagSetupVmediaPeer',
    '2218' => 'diagSetupBootEnvironment',
    '2219' => 'diagSerialDebugConnect',
    '2220' => 'diagPowerOn',
    '2221' => 'diagPowerOnWait',
    '2222' => 'diagBiosPostCompletion',
    '2223' => 'diagHagConnect',
    '2224' => 'diagPnuOSIdent',
    '2225' => 'diagRunTests',
    '2226' => 'diagLogTransfer',
    '2227' => 'diagWaitForDebug',
    '2228' => 'diagTeardownVmediaLocal',
    '2229' => 'diagTeardownVmediaPeer',
    '2230' => 'diagHagDisconnect',
    '2231' => 'diagSerialDebugDisconnect',
    '2232' => 'diagTearDownBootEnvironment',
    '2233' => 'diagShutdown',
    '2234' => 'associatePnuOSPeripheralComponentConfig',
    '2235' => 'associateConfigMgmtIpRules',
    '2236' => 'associateAssertBypassWait',
    '2237' => 'associateHostOSConnect',
    '2238' => 'associateConfigHostOsAnnotations',
    '2239' => 'associateConfigServerIdentity',
    '2240' => 'disassociateUnconfigServerIdentity',
    '2241' => 'fwUpgradeAssertBypassWait',
    '2242' => 'cimcSecurityConfigBegin',
    '2243' => 'cimcSecurityConfigKmipCertConfig',
    '2244' => 'cimcSecurityConfigKmipSaveCert',
    '2257' => 'cimcSecurityConfigFail',
    '2258' => 'cimcSecurityConfigSuccess',
    '2259' => 'diagFail',
    '2260' => 'diagSuccess',
    '2271' => 'associateRestoreVdStatus',
  },
  'CucsInitiatorInitiatorEpPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CucsSmartlicenseTestFsmStageName' => {
    '0' => 'nop',
    '482' => 'configureBegin',
    '483' => 'configureExecuteTestCli',
    '522' => 'configureFail',
    '523' => 'configureSuccess',
  },
  'CucsFirmwareFwState' => {
    '0' => 'unknown',
    '1' => 'sameRelease',
    '2' => 'compatible',
    '3' => 'incompatible',
    '4' => 'multipleReleases',
  },
  'CucsLstorageControllerRefControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
    '5' => 'pt',
    '6' => 'pch',
    '7' => 'external',
    '8' => 'nvme',
    '9' => 'hba',
    '10' => 'm2',
  },
  'CucsBiosVfInterleaveConfigurationVpRankInterleaving' => {
    '0' => 'platformRecommended',
    '306' => 'auto',
    '307' => 'n1Way',
    '308' => 'n2Way',
    '309' => 'n4Way',
    '310' => 'n8Way',
  },
  'CucsBiosVfIOESlot1OptionROMVpIOESlot1OptionROM' => {
    '0' => 'platformRecommended',
    '584' => 'disabled',
    '585' => 'enabled',
    '586' => 'uefiOnly',
    '587' => 'legacyOnly',
  },
  'CucsAdaptorNwMgmtCapMgmtTransport' => {
    '0' => 'l2',
    '1' => 'l3',
  },
  'CucsEquipmentBeaconLedFsmStageName' => {
    '0' => 'nop',
    '1135' => 'illuminateBegin',
    '1136' => 'illuminateExecuteA',
    '1137' => 'illuminateExecuteB',
    '1138' => 'illuminateFail',
    '1139' => 'illuminateSuccess',
  },
  'CucsStorageConfiguredWriteType' => {
    '0' => 'unknown',
    '1' => 'writeThrough',
    '2' => 'writeBackGoodBbu',
    '3' => 'alwaysWriteBack',
  },
  'CucsAdaptorIpV6RssHashProfileTcpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsExtpolClientFsmCurrentFsm' => {
    '0' => 'nop',
    '214' => 'updateContextFsm',
  },
  'CucsFirmwareRunningDeployment' => {
    '0' => 'unspecified',
    '1' => 'kernel',
    '2' => 'bootLoader',
    '3' => 'system',
    '4' => 'servicePack',
  },
  'CucsAdaptorEthRoCEProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CucsComputePhysicalFsmCurrentFsm' => {
    '0' => 'nop',
    '665' => 'associate',
    '727' => 'disassociate',
    '767' => 'powerCap',
    '769' => 'decommission',
    '771' => 'softShutdown',
    '773' => 'hardShutdown',
    '775' => 'turnup',
    '777' => 'powercycle',
    '781' => 'hardreset',
    '785' => 'softreset',
    '789' => 'swConnUpd',
    '792' => 'biosRecovery',
    '806' => 'cmosReset',
    '815' => 'resetBmc',
    '879' => 'updateExtUsers',
    '891' => 'updateAdaptor',
    '898' => 'activateAdaptor',
    '932' => 'configSoL',
    '934' => 'unconfigSoL',
    '1036' => 'diagnosticInterrupt',
    '1055' => 'resetKvm',
    '1152' => 'updateBIOS',
    '1157' => 'activateBIOS',
    '1254' => 'resetIpmi',
    '1256' => 'fwUpgrade',
    '1478' => 'cimcSessionDelete',
    '1513' => 'serviceInfraDeploy',
    '1518' => 'serviceInfraWithdraw',
    '1525' => 'updateBoardController',
    '1531' => 'configBoard',
    '1533' => 'resetMemoryErrors',
    '1592' => 'flashController',
    '1611' => 'enableCimcSecureBoot',
    '1722' => 'oobStorageAdminConfig',
    '1945' => 'clearTPM',
    '2045' => 'diskZoningInventory',
    '2209' => 'diag',
    '2242' => 'cimcSecurityConfig',
  },
  'CucsGlPolicyUserAction' => {
    '0' => 'noAction',
    '1' => 'referenceGlobal',
    '2' => 'rename',
  },
  'CucsComputeRemoteAdminTrigger' => {
    '0' => 'remoteTrigger',
    '1' => 'rediscover',
    '2' => 'resetToFactory',
    '3' => 'discovered',
    '4' => 'remove',
    '5' => 'migrate',
    '6' => 'decommission',
  },
  'CucsBiosVfLOMPortsConfigurationVpAllOnboardLOMPorts' => {
    '0' => 'platformRecommended',
    '371' => 'disabled',
    '372' => 'enabled',
  },
  'CucsFabricEthMonOperationAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CucsStorageVdMemberConfigQualifierType' => {
    '0' => 'noAction',
    '1' => 'add',
    '2' => 'remove',
  },
  'CucsComputeMode' => {
    '0' => 'none',
    '1' => 'single',
    '2' => 'scaled',
  },
  'CucsLsOwner' => {
    '1' => 'management',
    '2' => 'physicalInherit',
    '4' => 'physicalDefaultConfig',
    '7' => 'policy',
    '8' => 'tier',
  },
  'CucsEtherServerIntFIoFsmTaskItem' => {
    '0' => 'nop',
    '1150' => 'configSpeed',
    '2101' => 'config',
  },
  'CucsPowerMgmtStyle' => {
    '0' => 'manualPerBlade',
    '1' => 'intelligentPolicyDriven',
  },
  'CucsGraphicsGpuMode' => {
    '0' => 'compute',
    '1' => 'graphics',
    '2' => 'na',
  },
  'CucsFirmwareDependencyRelationship' => {
    '0' => 'special',
    '1' => 'ancestor',
    '2' => 'descendent',
  },
  'CucsMgmtAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CucsFirmwareImageFsmCurrentFsm' => {
    '0' => 'nop',
    '240' => 'delete',
  },
  'CucsSysfileMutationAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CucsGlIdentCtxResOpFsmCurrentFsm' => {
    '0' => 'nop',
    '581' => 'validateId',
  },
  'CucsLsAdminActionTrigger' => {
    '0' => 'idle',
    '1' => 'triggered',
  },
  'CucsLstorageAutoDeploy' => {
    '0' => 'autoDeploy',
    '1' => 'noAutoDeploy',
  },
  'CucsMgmtCfgExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1187' => 'reportConfigCopy',
  },
  'CucsFabricFcPortOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsStorageReplicationPairErrorCode' => {
    '0' => 'none',
    '1' => 'success',
    '101' => 'tcpConnectionFailed',
    '102' => 'unsupportedAsyncrepProtocolVer',
    '103' => 'incorrectSharedSecretKey',
    '104' => 'notOnAllowList',
    '105' => 'failedToCreateTarget',
    '106' => 'failedToIncreaseSize',
    '107' => 'failedToReplicateMetadata',
    '108' => 'lostConnection',
    '109' => 'canceledByUser',
    '110' => 'internalError',
  },
  'CucsMgmtIPv6IfAddrFsmStageName' => {
    '0' => 'nop',
    '1535' => 'swMgmtOobIpv6IfConfigBegin',
    '1536' => 'swMgmtOobIpv6IfConfigSwitch',
    '1558' => 'swMgmtOobIpv6IfConfigFail',
    '1559' => 'swMgmtOobIpv6IfConfigSuccess',
  },
  'CucsExtvmmKeyStoreFsmStageName' => {
    '0' => 'nop',
    '539' => 'certInstallBegin',
    '540' => 'certInstallSetLocal',
    '541' => 'certInstallSetPeer',
    '561' => 'certInstallFail',
    '562' => 'certInstallSuccess',
  },
  'CucsLsbootStorageOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CucsConfigOperState' => {
    '0' => 'none',
    '1' => 'cleaning',
    '2' => 'provisioning',
    '3' => 'userCleaning',
  },
  'CucsCallhomeEpConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CucsFabricFcoeEstcEpOperationFsmCurrentFsm' => {
    '0' => 'nop',
    '524' => 'fiport',
  },
  'CucsPkiKeyringState' => {
    '1' => 'started',
    '2' => 'created',
    '3' => 'reqCreated',
    '4' => 'tpSet',
    '5' => 'completed',
  },
  'CucsFabricNetflowCollectorFlowProtocol' => {
    '1' => 'netflow',
  },
  'CucsDomainProductFamily' => {
    '0' => 'ucsClassic',
    '1' => 'ucsMini',
    '2' => 'ucsClassic3gen',
  },
  'CucsSysdebugLogExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1600' => 'configure',
  },
  'CucsFirmwareTriggerAdminState' => {
    '0' => 'none',
    '1' => 'triggerDownload',
    '2' => 'triggerDelete',
  },
  'CucsEquipmentPsuInputSrc' => {
    '0' => 'unknown',
    '1' => 'n210AC50380DC',
    '2' => 'n110AC',
    '3' => 'undetermined',
    '4' => 'nA',
  },
  'CucsLsSPOwnershipLC' => {
    '0' => 'globalControlled',
    '1' => 'disassocPending',
    '2' => 'deletePending',
    '3' => 'localized',
  },
  'CucsConditionCause' => {
    '0' => 'unknown',
    '1' => 'transition',
    '2' => 'beginFailed',
    '3' => 'fsmFailed',
    '4' => 'checkLicenseFailed',
    '5' => 'identifyFailed',
    '6' => 'configureSwMgmtEndPointFailed',
    '7' => 'configureVifNsFailed',
    '8' => 'configureEndPointFailed',
    '9' => 'discoverChassisFailed',
    '10' => 'enableChassisFailed',
    '11' => 'decomissionFailed',
    '12' => 'unIdentifyLocalFailed',
    '13' => 'cleanupEntriesFailed',
    '14' => 'waitFailed',
    '15' => 'disableEndPointFailed',
    '16' => 'unIdentifyPeerFailed',
    '17' => 'executeFailed',
    '18' => 'deployFailed',
    '20' => 'bmcConfigureConnLocalFailed',
    '21' => 'swConfigureConnLocalFailed',
    '22' => 'bmcConfigureConnPeerFailed',
    '23' => 'swConfigureConnPeerFailed',
    '24' => 'bmcPresenceFailed',
    '25' => 'bmcInventoryFailed',
    '26' => 'preSanitizeFailed',
    '27' => 'sanitizeFailed',
    '28' => 'configUserAccessFailed',
    '29' => 'swConfigPnuoslocalFailed',
    '30' => 'swConfigPnuospeerFailed',
    '31' => 'configDiscoveryModeFailed',
    '32' => 'swUnconfigPortNivLocalFailed',
    '33' => 'swUnconfigPortNivPeerFailed',
    '35' => 'bootPnuosFailed',
    '36' => 'bootWaitFailed',
    '37' => 'biosPostCompletionFailed',
    '38' => 'readSmbiosFailed',
    '39' => 'hagConnectFailed',
    '40' => 'pnuosidentFailed',
    '41' => 'pnuospolicyFailed',
    '42' => 'pnuosinventoryFailed',
    '43' => 'pnuosscrubFailed',
    '44' => 'pnuosconnectivityFailed',
    '45' => 'pnuosconnStatusFailed',
    '46' => 'swPnuosconnectivityLocalFailed',
    '47' => 'swPnuosconnectivityPeerFailed',
    '48' => 'pnuosselfTestFailed',
    '51' => 'hagDisconnectFailed',
    '52' => 'bmcShutdownDiscoveredFailed',
    '53' => 'handlePoolingFailed',
    '54' => 'successFailed',
    '55' => 'failFailed',
    '56' => 'configFeLocalFailed',
    '57' => 'swConfigPortNivLocalFailed',
    '58' => 'swConfigPortNivPeerFailed',
    '59' => 'nicPresenceLocalFailed',
    '60' => 'nicPresencePeerFailed',
    '61' => 'nicInventoryLocalFailed',
    '62' => 'nicInventoryPeerFailed',
    '63' => 'deriveConfigFailed',
    '64' => 'configSolFailed',
    '65' => 'swConfigLocalFailed',
    '66' => 'swConfigPeerFailed',
    '67' => 'nicConfigLocalFailed',
    '68' => 'nicConfigPeerFailed',
    '69' => 'stopvmediaLocalFailed',
    '70' => 'stopvmediaPeerFailed',
    '71' => 'setupvmediaLocalFailed',
    '72' => 'setupvmediaPeerFailed',
    '73' => 'bladeBootFailed',
    '74' => 'bladeBootWaitFailed',
    '75' => 'bladeReadSmbiosFailed',
    '76' => 'hostConnectFailed',
    '77' => 'startMemoryTestStatusFailed',
    '78' => 'pollMemoryTestStatusFailed',
    '79' => 'hostIdentFailed',
    '80' => 'hostPolicyFailed',
    '81' => 'setDiagUserFailed',
    '82' => 'hostInventoryFailed',
    '83' => 'hostServerDiagFailed',
    '84' => 'hostServerDiagStatusFailed',
    '85' => 'disableServerConnSwBfailed',
    '86' => 'startFabricatrafficTestFailed',
    '87' => 'fabricatrafficTestStatusFailed',
    '88' => 'enableServerConnSwBfailed',
    '89' => 'disableServerConnSwAfailed',
    '90' => 'startFabricbtrafficTestFailed',
    '91' => 'fabricbtrafficTestStatusFailed',
    '92' => 'enableServerConnSwAfailed',
    '93' => 'generateReportFailed',
    '94' => 'generateLogWaitFailed',
    '95' => 'debugWaitFailed',
    '96' => 'removevmediaLocalFailed',
    '97' => 'removevmediaPeerFailed',
    '98' => 'nicUnconfigLocalFailed',
    '99' => 'nicUnconfigPeerFailed',
    '100' => 'swUnconfigLocalFailed',
    '101' => 'swUnconfigPeerFailed',
    '102' => 'removeConfigFailed',
    '103' => 'restoreConfigFeLocalFailed',
    '104' => 'restoreConfigFePeerFailed',
    '105' => 'unconfigUserAccessFailed',
    '106' => 'unconfigSolFailed',
    '107' => 'hostDisconnectFailed',
    '108' => 'bmcShutdownDiagCompletedFailed',
    '109' => 'evaluateStatusFailed',
    '110' => 'primaryFailed',
    '111' => 'secondaryFailed',
    '112' => 'executeLocalFailed',
    '113' => 'executePeerFailed',
    '114' => 'nicConfigPnuoslocalFailed',
    '115' => 'nicConfigPnuospeerFailed',
    '116' => 'setupVmediaLocalFailed',
    '117' => 'setupVmediaPeerFailed',
    '118' => 'bladeBootPnuosFailed',
    '119' => 'nicUnconfigPnuoslocalFailed',
    '120' => 'nicUnconfigPnuospeerFailed',
    '121' => 'swUnconfigPnuoslocalFailed',
    '122' => 'swUnconfigPnuospeerFailed',
    '123' => 'teardownVmediaLocalFailed',
    '124' => 'teardownVmediaPeerFailed',
    '125' => 'updateibmcfwFailed',
    '126' => 'waitForibmcfwUpdateFailed',
    '127' => 'activateibmcfwFailed',
    '128' => 'resetibmcFailed',
    '129' => 'powerOnFailed',
    '130' => 'updateAdaptorNwFwLocalFailed',
    '131' => 'updateAdaptorNwFwPeerFailed',
    '132' => 'waitForAdaptorNwFwUpdateLocalFailed',
    '133' => 'waitForAdaptorNwFwUpdatePeerFailed',
    '134' => 'activateAdaptorNwFwLocalFailed',
    '135' => 'activateAdaptorNwFwPeerFailed',
    '136' => 'hagPnuosconnectFailed',
    '137' => 'pnuosvalidateFailed',
    '138' => 'biosImgUpdateFailed',
    '139' => 'storageCtlrImgUpdateFailed',
    '140' => 'hbaImgUpdateFailed',
    '141' => 'nicImgUpdateFailed',
    '142' => 'pnuosconfigFailed',
    '143' => 'pnuoslocalDiskConfigFailed',
    '144' => 'swConfigHostoslocalFailed',
    '145' => 'swConfigHostospeerFailed',
    '146' => 'nicConfigHostoslocalFailed',
    '147' => 'nicConfigHostospeerFailed',
    '148' => 'hagPnuosdisconnectFailed',
    '149' => 'pnuosunloadDriversFailed',
    '150' => 'prepareForBootFailed',
    '151' => 'configUuidFailed',
    '152' => 'bootHostFailed',
    '153' => 'waitForConnReadyFailed',
    '154' => 'hostosidentFailed',
    '155' => 'hostospolicyFailed',
    '156' => 'hostosvalidateFailed',
    '157' => 'hostosconfigFailed',
    '158' => 'nicUnconfigHostoslocalFailed',
    '159' => 'nicUnconfigHostospeerFailed',
    '160' => 'swUnconfigHostoslocalFailed',
    '161' => 'swUnconfigHostospeerFailed',
    '162' => 'pnuosunconfigFailed',
    '163' => 'unconfigUuidFailed',
    '164' => 'shutdownFailed',
    '165' => 'unconfigSoLfailed',
    '166' => 'configFailed',
    '167' => 'swUnconfigureLocalFailed',
    '168' => 'swUnconfigurePeerFailed',
    '169' => 'startFailed',
    '170' => 'cleanupFailed',
    '171' => 'resetFailed',
    '172' => 'unconfigBiosFailed',
    '173' => 'applyTemplateFailed',
    '174' => 'applyIdentifiersFailed',
    '175' => 'applyPoliciesFailed',
    '176' => 'resolveBootConfigFailed',
    '177' => 'evaluateAssociationFailed',
    '178' => 'analyzeImpactFailed',
    '179' => 'waitForMaintPermissionFailed',
    '180' => 'waitForMaintWindowFailed',
    '181' => 'reconfigUuidFailed',
    '182' => 'updateEthMonFailed',
    '183' => 'updateFcMonFailed',
    '186' => 'serverMoved',
    '187' => 'serverIdentificationProblem',
    '188' => 'primaryVlanMissingIsolated',
    '189' => 'namedPolicyUnresolved',
    '190' => 'localFailed',
    '191' => 'peerFailed',
    '192' => 'lin',
    '193' => 'equipmentInoperable',
    '194' => 'thermalProblem',
    '195' => 'voltageProblem',
    '196' => 'capacityExceeded',
    '197' => 'equipmentDegraded',
    '198' => 'identityUnestablishable',
    '199' => 'setEpLocalFailed',
    '200' => 'setEpPeerFailed',
    '201' => 'propogateEpSettingsFailed',
    '202' => 'propogateEpTimeZoneSettingsLocalFailed',
    '203' => 'propogateEpTimeZoneSettingsPeerFailed',
    '204' => 'restartFailed',
    '205' => 'setRealmLocalFailed',
    '206' => 'setRealmPeerFailed',
    '208' => 'setUserPeerFailed',
    '209' => 'setKeyRingLocalFailed',
    '210' => 'setKeyRingPeerFailed',
    '211' => 'unidentifiableFru',
    '212' => 'equipmentMissing',
    '213' => 'connectivityProblem',
    '214' => 'linkDown',
    '215' => 'linkMisconnected',
    '216' => 'disableFailed',
    '217' => 'enableFailed',
    '218' => 'disableAfailed',
    '219' => 'enableAfailed',
    '220' => 'propogateEpTimeZoneSettingsToAdaptorsLocalFailed',
    '221' => 'propogateEpTimeZoneSettingsToAdaptorsPeerFailed',
    '222' => 'vifDown',
    '223' => 'updateConnectivityFailed',
    '224' => 'createLocalFailed',
    '225' => 'createRemoteFailed',
    '226' => 'unpackLocalFailed',
    '227' => 'deleteLocalFailed',
    '228' => 'copyRemoteFailed',
    '229' => 'remoteFailed',
    '230' => 'updateLocalFailed',
    '231' => 'verifyLocalFailed',
    '232' => 'resetLocalFailed',
    '233' => 'updateRemoteFailed',
    '234' => 'verifyRemoteFailed',
    '235' => 'resetRemoteFailed',
    '236' => 'updateRequestFailed',
    '237' => 'pollUpdateStatusFailed',
    '238' => 'activateFailed',
    '239' => 'updateRequestLocalFailed',
    '240' => 'updateRequestPeerFailed',
    '241' => 'pollUpdateStatusLocalFailed',
    '242' => 'pollUpdateStatusPeerFailed',
    '243' => 'powerOffFailed',
    '244' => 'copyPrimaryFailed',
    '245' => 'imageDeleted',
    '246' => 'imageUnusable',
    '247' => 'imageCannotBoot',
    '248' => 'psuInsufficient',
    '249' => 'rescanImagesFailed',
    '250' => 'pollUpdateOfcimcFailed',
    '251' => 'syncBladeaglocalFailed',
    '252' => 'syncBladeagremoteFailed',
    '253' => 'syncNicaglocalFailed',
    '254' => 'syncNicagremoteFailed',
    '255' => 'syncPortaglocalFailed',
    '256' => 'syncPortagremoteFailed',
    '257' => 'syncHostagentaglocalFailed',
    '258' => 'syncHostagentagremoteFailed',
    '259' => 'finalizeFailed',
    '260' => 'validateLocalFailed',
    '261' => 'validateRemoteFailed',
    '262' => 'deleteRemoteFailed',
    '263' => 'licenseGraceperiodEntered',
    '264' => 'licenseGraceperiod10days',
    '265' => 'oldChassisComponentFirmware',
    '266' => 'licenseGraceperiod60days',
    '267' => 'psuFailure',
    '268' => 'psuRedundancyFail',
    '269' => 'licenseGraceperiodExpired',
    '270' => 'powerConsumptionHitLimit',
    '271' => 'noAckFromBios',
    '272' => 'portFailed',
    '273' => 'interfaceFailed',
    '274' => 'operationalStateDown',
    '275' => 'cmcVifDown',
    '276' => 'setLocalFailed',
    '277' => 'setPeerFailed',
    '278' => 'switchFailed',
    '279' => 'limitReached',
    '280' => 'emptyPool',
    '283' => 'decommissioned',
    '284' => 'uploadFailed',
    '285' => 'downloadLocalFailed',
    '286' => 'tftpServerError',
    '287' => 'electionFailure',
    '288' => 'managementServicesFailure',
    '289' => 'managementServicesUnresponsive',
    '290' => 'haNotReady',
    '291' => 'versionIncompatible',
    '293' => 'logCapacity',
    '294' => 'fileTransferFailed',
    '296' => 'insufficientResources',
    '297' => 'insufficientlyEquipped',
    '298' => 'powerProblem',
    '299' => 'discoveryFailed',
    '300' => 'associationFailed',
    '301' => 'unsupportedTransceiver',
    '302' => 'resolveHostpackPolicyFailed',
    '303' => 'discoveryInProgress',
    '304' => 'resolveMaintPolicyFailed',
    '305' => 'unconfigurationInProgress',
    '306' => 'poweredOff',
    '307' => 'inMaintenance',
    '308' => 'underTest',
    '309' => 'serverUnassociated',
    '310' => 'serverAssociating',
    '311' => 'unassociated',
    '312' => 'serverDeassociating',
    '313' => 'serverUnassigned',
    '314' => 'serverAssigned',
    '315' => 'configurationNotApplied',
    '316' => 'configurationApplying',
    '317' => 'propogateEpTimeZoneSettingsToFexIomLocalFailed',
    '318' => 'serverFailed',
    '319' => 'configurationFailure',
    '320' => 'maintenanceFailed',
    '321' => 'equipmentRemoved',
    '322' => 'serverInaccessible',
    '324' => 'getVersionFailed',
    '325' => 'removeLocalFailed',
    '326' => 'setEpAfailed',
    '327' => 'setEpBfailed',
    '328' => 'satelliteConnectionAbsent',
    '329' => 'satelliteConnectionInit',
    '330' => 'satelliteMisConnected',
    '331' => 'unexpectedNumberOfLinks',
    '332' => 'equipmentOffline',
    '333' => 'performanceProblem',
    '334' => 'firmwareUpgradeProblem',
    '335' => 'unsupportedConnectivityConfiguration',
    '336' => 'equipmentUnacknowledged',
    '337' => 'autoFirmwareUpgrade',
    '338' => 'equipmentDisconnected',
    '339' => 'fruProblem',
    '340' => 'thresholdCrossed',
    '345' => 'deviceSEEPROMIOError',
    '353' => 'assignmentFailed',
    '355' => 'deviceSeepromError',
    '360' => 'newLink',
    '361' => 'bmcPreconfigPnuoslocalFailed',
    '362' => 'bmcPreconfigPnuospeerFailed',
    '363' => 'bmcConfigPnuosFailed',
    '364' => 'solRedirectEnableFailed',
    '365' => 'serialDebugConnectFailed',
    '366' => 'bmcUnconfigPnuosFailed',
    '367' => 'serialDebugDisconnectFailed',
    '368' => 'solRedirectDisableFailed',
    '369' => 'configNivModeFailed',
    '370' => 'cleanupLocalFailed',
    '371' => 'cleanupPeerFailed',
    '372' => 'configFePeerFailed',
    '373' => 'bladePowerOnFailed',
    '374' => 'cleanupServerConnSwAfailed',
    '375' => 'cleanupServerConnSwBfailed',
    '376' => 'bmcPreConfigPnuoslocalFailed',
    '377' => 'bmcPreConfigPnuospeerFailed',
    '378' => 'bladePowerOffFailed',
    '379' => 'updateBoardCtrlRequestFailed',
    '380' => 'pollBoardCtrlUpdateStatusFailed',
    '381' => 'serialDebugPnuosconnectFailed',
    '382' => 'localDiskFwUpdateFailed',
    '383' => 'serialDebugPnuosdisconnectFailed',
    '384' => 'configSoLfailed',
    '385' => 'hagHostosconnectFailed',
    '386' => 'configBiosFailed',
    '387' => 'cleanupcimcFailed',
    '388' => 'aFailed',
    '389' => 'bFailed',
    '390' => 'reconfigBiosFailed',
    '391' => 'applyConfigFailed',
    '392' => 'mgmtifDown',
    '393' => 'validateConfigurationFailed',
    '394' => 'applyPhysicalFailed',
    '395' => 'waitOnPhysFailed',
    '396' => 'emptyPinGroup',
    '397' => 'membershipDown',
    '398' => 'vsanMisconfigured',
    '399' => 'incompatibleSpeed',
    '400' => 'configError',
    '401' => 'vlanMisconfigured',
    '402' => 'interfaceMisconfigured',
    '403' => 'missingPrimaryVlan',
    '404' => 'pinningMismatch',
    '405' => 'pinningMisconfig',
    '406' => 'equipmentDisabled',
    '407' => 'propogateEpTimeZoneSettingsToFexIomPeerFailed',
    '408' => 'setUserLocalFailed',
    '409' => 'linkMissing',
    '410' => 'updateAdaptorFailed',
    '411' => 'enableBfailed',
    '412' => 'copySubFailed',
    '413' => 'deleteSubFailed',
    '414' => 'deletePrimaryFailed',
    '415' => 'groupCapInsufficient',
    '416' => 'oldFirmware',
    '417' => 'powerCapFail',
    '418' => 'noCapFail',
    '419' => 'portInventorySwAfailed',
    '420' => 'portInventorySwBfailed',
    '421' => 'configSwAfailed',
    '422' => 'updatecimcFailed',
    '423' => 'verifyPhysConfigFailed',
    '424' => 'activateLocalFailed',
    '425' => 'activatePeerFailed',
    '426' => 'prepareForUpdateFailed',
    '427' => 'activationFailed',
    '428' => 'applyFailed',
    '430' => 'licenseGraceperiod30days',
    '432' => 'licenseGraceperiod90days',
    '433' => 'licenseGraceperiod119days',
    '434' => 'licenseFileUninstallable',
    '435' => 'licenseFileNotDeleted',
    '436' => 'backupLocalFailed',
    '437' => 'reportResultsFailed',
    '438' => 'deviceSharedStorageError',
    '439' => 'haSshKeysMismatched',
    '440' => 'ucsmProcessFailure',
    '441' => 'equipmentInaccessible',
    '442' => 'nonExistentScheduler',
    '443' => 'executeAfailed',
    '444' => 'waitForFirmwareApplyFailed',
    '445' => 'powerDown',
    '446' => 'leadershipChange',
    '447' => 'deviceSharedStorageIOError',
    '448' => 'serverAssociated',
    '449' => 'configurationApplied',
    '450' => 'pollPostDiskZoneStorageInvcimcFailed',
    '454' => 'inventoryFailed',
    '455' => 'configureFailed',
    '456' => 'clearFailed',
    '457' => 'pollClearStatusFailed',
    '458' => 'pollActivateStatusFailed',
    '459' => 'updateTokensFailed',
    '460' => 'hostCatalogFailed',
    '461' => 'pnuoscatalogFailed',
    '462' => 'clearBiosUpdateFailed',
    '463' => 'pollClearBiosUpdateStatusFailed',
    '464' => 'updateBiosRequestFailed',
    '465' => 'pollBiosUpdateStatusFailed',
    '466' => 'activateBiosFailed',
    '467' => 'pollBiosActivateStatusFailed',
    '468' => 'fexUnsupported',
    '469' => 'invalidKeyringCertificate',
    '470' => 'invalidTrustpointCertChain',
    '471' => 'disassociationFailed',
    '472' => 'vifIdsMismatch',
    '473' => 'profileConfigIncorrect',
    '474' => 'updateVlanGroupsFailed',
    '475' => 'updateZonesFailed',
    '476' => 'vlanCompNotSupport',
    '477' => 'anotherConnectionAlreadyEnabled',
    '478' => 'connectionUnused',
    '479' => 'unsupportedConnectivity',
    '480' => 'reportFailed',
    '481' => 'providerGroupAlreadyExists',
    '482' => 'noVlanOptimization',
    '483' => 'roleConfigError',
    '484' => 'localeConfigError',
    '485' => 'userRoleConfigError',
    '486' => 'userLocaleConfigError',
    '487' => 'keyringConfigError',
    '488' => 'snmpConfigError',
    '489' => 'timezoneFileNotExists',
    '490' => 'userConfigError',
    '491' => 'snmpUserConfigError',
    '492' => 'commSvcConfigError',
    '493' => 'inaccessibleVlanReferenced',
    '494' => 'referencedVlanUnresolvable',
    '495' => 'invalidVlanInTheAllowedVlanList',
    '496' => 'vlanConflictPermit',
    '497' => 'vlanPermitUnresolved',
    '498' => 'groupPermitUnresolved',
    '499' => 'removeFailed',
    '500' => 'arpTargetsConfigError',
    '501' => 'newVnicVconSchemeApplied',
    '502' => 'suspendModeEntered',
    '503' => 'verifyGuidFailed',
    '504' => 'unregisterFailed',
    '505' => 'cleanOldDataFailed',
    '506' => 'requestFailed',
    '507' => 'verifyFailed',
    '508' => 'resolveFailed',
    '509' => 'releaseFailed',
    '510' => 'resolveManyFailed',
    '511' => 'releaseManyFailed',
    '512' => 'resolveAllFailed',
    '513' => 'releaseAllFailed',
    '514' => 'registerClientFailed',
    '515' => 'verifyRegistrationFailed',
    '516' => 'mountLocalFailed',
    '517' => 'mountPeerFailed',
    '518' => 'unmountLocalFailed',
    '519' => 'unmountPeerFailed',
    '520' => 'checkPowerAvailabilityFailed',
    '521' => 'markAdapterForRebootFailed',
    '522' => 'deassertResetBypassFailed',
    '523' => 'verifyFcZoneConfigFailed',
    '524' => 'cleanupPortConfigLocalFailed',
    '525' => 'cleanupPortConfigPeerFailed',
    '526' => 'powerCycleFailed',
    '527' => 'resolveIdentifiersFailed',
    '528' => 'applyDefaultIdentifiersFailed',
    '529' => 'resolveDefaultIdentifiersFailed',
    '530' => 'resolvePoliciesFailed',
    '531' => 'resolveDistributableNamesFailed',
    '532' => 'resolveDistributableFailed',
    '533' => 'resolveImagesFailed',
    '534' => 'resolveScheduleFailed',
    '535' => 'provisionStorageFailed',
    '536' => 'waitForStorageProvisionFailed',
    '537' => 'commitStorageFailed',
    '538' => 'waitForCommitStorageFailed',
    '539' => 'waitForAssocCompletionFailed',
    '540' => 'enablePortFailed',
    '541' => 'loadCatalogFailed',
    '542' => 'pingFailed',
    '543' => 'suppressStatusChange',
    '544' => 'fcoeUplinkUnsupportedFiSettings',
    '545' => 'fcoeUplinkPortChannelUnsupportedFiSettings',
    '546' => 'invalidTarget',
    '547' => 'fcZoningEnabled',
    '548' => 'configurationError',
    '549' => 'fcStorageportNpvMode',
    '550' => 'fcoeStorageportNpvMode',
    '551' => 'fcPortchannelMembersInconsistentSpeed',
    '552' => 'vlanMcastPolicyMisconfigured',
    '553' => 'clientLostConnectivity',
    '554' => 'callhomeConfigError',
    '555' => 'copyExtToLocalFailed',
    '556' => 'copyExtToPeerFailed',
    '557' => 'copyToLocalFailed',
    '558' => 'copyToPeerFailed',
    '559' => 'waitForDeployFailed',
    '560' => 'activateucsmFailed',
    '561' => 'pollActivateOfucsmFailed',
    '562' => 'updateiomFailed',
    '563' => 'pollUpdateOfiomFailed',
    '564' => 'activateiomFailed',
    '565' => 'pollActivateOfiomFailed',
    '566' => 'activateRemotefiFailed',
    '567' => 'pollActivateOfRemotefiFailed',
    '568' => 'waitForUserAckFailed',
    '569' => 'activateLocalfiFailed',
    '570' => 'pollActivateOfLocalfiFailed',
    '571' => 'activateCatalogFailed',
    '572' => 'referencedVsanUnresolvable',
    '573' => 'operationFailed',
    '574' => 'localeOrgConfigError',
    '575' => 'resolveNetworkPoliciesFailed',
    '576' => 'resolveNetworkTemplatesFailed',
    '577' => 'validatePolicyOwnershipFailed',
    '578' => 'configFlexFlashFailed',
    '579' => 'syncPowerStateFailed',
    '580' => 'unconfigFlexFlashFailed',
    '581' => 'syncFailed',
    '582' => 'reportFullInventoryFailed',
    '583' => 'healthLedAmberBlinking',
    '584' => 'healthLedAmber',
    '585' => 'extraPrimaryVlans',
    '586' => 'licenseInsufficient',
    '587' => 'checkInventoryStatusFailed',
    '589' => 'providerGroupSizeEmpty',
    '590' => 'postSetKeyRingLocalFailed',
    '591' => 'postSetKeyRingPeerFailed',
    '592' => 'cimcvlanCfgLocalFailed',
    '593' => 'cimcvlanCfgPeerFailed',
    '594' => 'cmcvlanCfgFailed',
    '595' => 'cmcvlanCfgPeerFailed',
    '596' => 'activeFailed',
    '597' => 'oobStorageInventoryFailed',
    '598' => 'configFlexFlashScrubFailed',
    '599' => 'powerOnPreConfigFailed',
    '600' => 'swConfigServiceInfraLocalFailed',
    '601' => 'swConfigServiceInfraPeerFailed',
    '602' => 'nicConfigServiceInfraLocalFailed',
    '603' => 'nicConfigServiceInfraPeerFailed',
    '604' => 'nicUnconfigServiceInfraLocalFailed',
    '605' => 'nicUnconfigServiceInfraPeerFailed',
    '606' => 'swUnConfigLocalFailed',
    '607' => 'swUnConfigPeerFailed',
    '608' => 'nicUnConfigLocalFailed',
    '609' => 'nicUnConfigPeerFailed',
    '610' => 'defaultHostpackMissing',
    '611' => 'defaultHostpackMissingVersions',
    '612' => 'serverPowerOffFailed',
    '613' => 'serverPowerOnFailed',
    '614' => 'namedVlanUnresolved',
    '615' => 'referencedRemoteVlanUnresolvable',
    '616' => 'referencedRemoteVsanUnresolvable',
    '617' => 'multipleConnectionPolicies',
    '618' => 'boardCtrlUpgraded',
    '619' => 'configMemoryPolicyFailed',
    '620' => 'incompatibleServerFirmware',
    '621' => 'inbandVlanNameResolutionFailure',
    '622' => 'ndiscTargetsConfigError',
    '623' => 'updateEthFlowMonFailed',
    '624' => 'equipmentUnhealthy',
    '625' => 'vmNetworkReferenceIncorrect',
    '626' => 'serverDoesNotSupportInband',
    '627' => 'udldLinkDown',
    '630' => 'vmediaMountInaccessible',
    '631' => 'cimcFirmwareMismatch',
    '632' => 'pldFirmwareMismatch',
    '633' => 'unconfigExtMgmtRulesFailed',
    '634' => 'unconfigExtMgmtGwFailed',
    '635' => 'unconfigCimcvmediaFailed',
    '636' => 'configExtMgmtRulesFailed',
    '637' => 'configExtMgmtGwFailed',
    '638' => 'configCimcvmediaFailed',
    '639' => 'graphicsImageUpdateFailed',
    '640' => 'configKvmMgmtDefaultSettingFailed',
    '641' => 'downloadImagesFailed',
    '642' => 'configBackupOutdated',
    '643' => 'updateFlashLifeFailed',
    '644' => 'copyImgFromRepFailed',
    '646' => 'copyiomimgToSubFailed',
    '647' => 'unsupportedCimcFirmware',
    '648' => 'primaryVlanMissingForIsolated',
    '649' => 'primaryVlanMissingForCommunity',
    '650' => 'vlanMismatch',
    '651' => 'vlanErrorAssocPrimary',
    '652' => 'deleteCurlDownloadedImagesFailed',
    '653' => 'svnicNotPresent',
    '654' => 'extraSecondaryVlans',
    '655' => 'extraSecondaryVlansPerPrimary',
    '656' => 'serverError',
    '657' => 'copyCatFromRepFailed',
    '658' => 'formatFailed',
    '659' => 'pairFailed',
    '660' => 'namedInbandVlanUnresolved',
    '661' => 'inbandUnsupportedServer',
    '662' => 'checkAssignedIdentifiersForDupFailed',
    '663' => 'checkAssignedDefaultIdentifiersForDupFailed',
    '664' => 'duplicatedAssigned',
    '665' => 'adaptorMismatch',
    '666' => 'tpmOnSlaveBoard',
    '667' => 'nearMaxLimit',
    '668' => 'memoryError',
    '669' => 'capacityProblem',
    '670' => 'healthProblem',
    '671' => 'invalidControllerProfileCount',
    '673' => 'psuMixedMode',
    '674' => 'powerBudgetUnavailable',
    '675' => 'smallVolumeSpace',
    '676' => 'noVolumeSpace',
    '677' => 'raidgroupOffline',
    '678' => 'raidgroupDegraded',
    '679' => 'raidgroupRebuilding',
    '680' => 'raidgroupBad',
    '681' => 'adminStateOffline',
    '682' => 'cimcBackupTriggerNotEnabled',
    '683' => 'cimcHeartbeatTimedOut',
    '684' => 'diskWearNonCriticalThreshold',
    '685' => 'diskWearCriticalThreshold',
    '686' => 'configDiskFailed',
    '687' => 'configLunFailed',
    '688' => 'verifyConfigFailed',
    '689' => 'verifySnapshotConfigFailed',
    '690' => 'verifyReplicationConfigFailed',
    '691' => 'initiatePollbmclocalFailed',
    '692' => 'initiatePollbmcremoteFailed',
    '693' => 'waitForosstatusFailed',
    '694' => 'connectsmelocalFailed',
    '695' => 'connectsmeremoteFailed',
    '696' => 'waitForsmeconnectionFailed',
    '697' => 'waitForInventoryFailed',
    '698' => 'disableStorageTargetFailed',
    '699' => 'waitForServerShutdownFailed',
    '700' => 'slotPowerCycleFailed',
    '701' => 'waitForhaquorumFailed',
    '702' => 'waitForServerPowerUpFailed',
    '703' => 'enableStorageTargetFailed',
    '704' => 'confighastateFailed',
    '705' => 'configNetworkFailed',
    '706' => 'configPlatformFailed',
    '707' => 'configStorageTargetIdentityFailed',
    '708' => 'configStorageReplicationServiceFailed',
    '709' => 'undeployStorageFailed',
    '710' => 'waitForUndeployStorageFailed',
    '711' => 'undeployTargetIdentityFailed',
    '712' => 'undeployPlatformFailed',
    '713' => 'undeployNetworkFailed',
    '714' => 'disassocStorageControllerFailed',
    '715' => 'waitForDisassocCompletionFailed',
    '716' => 'performHaTakeOverFailed',
    '717' => 'performEraseFailed',
    '718' => 'waitForEraseCompletionFailed',
    '727' => 'fullInventoryFailed',
    '728' => 'beginInventoryFailed',
    '729' => 'reportPhysicalInventoryFailed',
    '730' => 'reportOrgInventoryFailed',
    '731' => 'reportStorageInventoryFailed',
    '732' => 'endInventoryFailed',
    '733' => 'powerButtonLockConfigFailed',
    '734' => 'powerOffWaitFailed',
    '735' => 'powerOffReclaimFailed',
    '742' => 'evaluateIdentityFailed',
    '743' => 'configbmcpowerParamsFailed',
    '744' => 'powerDeployWaitFailed',
    '745' => 'pnuospowerProfilingFailed',
    '746' => 'sendBmcProfilingInitFailed',
    '747' => 'sendBmcProfilingDoneFailed',
    '749' => 'oobStorageConfigFailed',
    '750' => 'verifyRemoteStorageConfigFailed',
    '751' => 'nicConfigParamsHostoslocalFailed',
    '752' => 'nicConfigParamsHostospeerFailed',
    '753' => 'bmcUpdateHostPreBootFailed',
    '754' => 'waitForUnConfigAppliancesFailed',
    '756' => 'tearDownvmediaLocalFailed',
    '757' => 'tearDownvmediaPeerFailed',
    '758' => 'configChassisIdFailed',
    '759' => 'resolveStorageScheduleFailed',
    '760' => 'resolveVolumesFailed',
    '764' => 'setLocatorLedLocalFailed',
    '765' => 'setLocatorLedPeerFailed',
    '768' => 'waitForServerAssocFailed',
    '769' => 'waitForPlatformBootFailed',
    '770' => 'waitForosinstallFailed',
    '771' => 'waitForPlatformConfigFailed',
    '772' => 'hostBootForUpgradeFailed',
    '773' => 'hostBmcPreConfigLocalFailed',
    '774' => 'hostBmcPreConfigPeerFailed',
    '775' => 'hostSetupVmediaLocalFailed',
    '776' => 'hostSetupVmediaPeerFailed',
    '777' => 'hostClearOsInstallStatusFailed',
    '778' => 'hostSolRedirectEnableFailed',
    '779' => 'hostSerialDebugConnectFailed',
    '780' => 'hostBootFailed',
    '781' => 'hostBootWaitFailed',
    '782' => 'hostBiosPostCompletionFailed',
    '783' => 'hostReadSmbiosFailed',
    '784' => 'hostPreInstallFailed',
    '785' => 'hostPostInstallFailed',
    '786' => 'hostPreFirstBootFailed',
    '787' => 'hostPostFirstBootFailed',
    '788' => 'hostPostUpgradeFailed',
    '789' => 'hostTeardownVmediaLocalFailed',
    '790' => 'hostTeardownVmediaPeerFailed',
    '791' => 'hostSerialDebugDisconnectFailed',
    '792' => 'hostSolRedirectDisableFailed',
    '794' => 'activatePsuFailed',
    '795' => 'notSupported',
    '796' => 'equipmentInventory',
    '798' => 'cartridgeMoved',
    '799' => 'configurationMismatch',
    '800' => 'pollActivationFailed',
    '801' => 'powerOffServersFailed',
    '802' => 'serversPowerOffCompletionFailed',
    '803' => 'unsupportedModel',
    '804' => 'deleteImagesRemoteFailed',
    '805' => 'oobDiskScrubFailed',
    '806' => 'cimcPresenceFailed',
    '807' => 'cleanupNicConfigLocalFailed',
    '808' => 'cleanupNicConfigPeerFailed',
    '809' => 'cleanupVnicsLocalFailed',
    '810' => 'cleanupVnicsPeerFailed',
    '811' => 'sharediomoduleInventoryFailed',
    '812' => 'internalBackupFailed',
    '813' => 'pollInternalBackupFailed',
    '814' => 'unlockFirmwareImageFailed',
    '815' => 'precleanupPortConfigFailed',
    '816' => 'readSmBiosFailed',
    '817' => 'defaultauthConfigError',
    '818' => 'domainConfigError',
    '819' => 'fault',
    '820' => 'localInternalBackupFailed',
    '821' => 'reportFaultInventoryFailed',
    '822' => 'conditionCauseConfigurationFailure',
    '823' => 'conditionCauseFault',
    '825' => 'configMissing',
    '826' => 'pollWaitForUserAckFailed',
    '827' => 'setupVmediaFailed',
    '828' => 'unconfigVmediaFailed',
    '829' => 'equipmentAccessibilityProblem',
    '830' => 'equipmentLinkDegraded',
    '831' => 'powerCycleBoardFailed',
    '832' => 'pollBoardCtrlPowerCycleFailed',
    '833' => 'discoverSasExpanderFailed',
    '834' => 'vsanExceedLimit',
    '836' => 'comprSetsExhausted',
    '837' => 'kernelMemCriticalThreshold',
    '838' => 'unsupportedPolicyConfig',
    '839' => 'fanRemoval',
    '840' => 'healthWarning',
    '841' => 'healthMinor',
    '842' => 'healthMajor',
    '843' => 'healthCritical',
    '845' => 'checkAdaptorFw40gcapFailed',
    '846' => 'calculateVlanGroupForHostoslocalFailed',
    '847' => 'calculateVlanGroupForHostospeerFailed',
    '848' => 'applyMaintConfigFailed',
    '849' => 'unsupportedConfig',
    '855' => 'equipmentFailed',
    '857' => 'verifyBreakoutConfigFailed',
    '860' => 'copyAllImagesToPeerFailed',
    '861' => 'cleanUpvifsFailed',
    '862' => 'vlanCompGrpCountExceedsLimit',
    '863' => 'fiBQuerierIpEmptyOrSameAsPrimary',
    '864' => 'deprecated',
    '865' => 'invalidPinning',
    '866' => 'extraVif',
    '867' => 'equipmentDeprecated',
    '868' => 'nativeVlanNotFound',
    '869' => 'vlanCompression',
    '870' => 'configFanSpeedFailed',
    '871' => 'sasExpanderImgUpdateFailed',
    '872' => 'chassisLimitExceeded',
    '873' => 'conditionCauseKernelMemCriticalThreshold',
    '874' => 'mgmtDbCorruption',
    '875' => 'bmcFactoryResetFailed',
    '876' => 'applyMoPropsFailed',
    '877' => 'deleteAllMoRefsFailed',
    '878' => 'maxVlanLimitExceeded',
    '879' => 'initIptablesLocalFailed',
    '880' => 'initIptablesPeerFailed',
    '881' => 'replicationFailure',
    '882' => 'tpmMismatch',
    '883' => 'validateRemovalFailed',
    '884' => 'updateStorageInvcmcFailed',
    '885' => 'updateStorageInvcimcFailed',
    '886' => 'pollUpdateStorageInvcimcFailed',
    '887' => 'backplanePortProblem',
    '888' => 'standbycmcvlanCfgFailed',
    '889' => 'postScrubOobStorageInventoryFailed',
    '890' => 'oobSasExpanderImgUpdateFailed',
    '891' => 'oobPollSasExpanderUpdateStatusFailed',
    '892' => 'oobSasExpanderImgActivateFailed',
    '893' => 'oobPollSasExpanderActivateStatusFailed',
    '894' => 'ciscoosopenGateFailed',
    '895' => 'storageInventoryFailed',
    '896' => 'waitBeforeInstallationFailed',
    '897' => 'updateCmcFailed',
    '898' => 'pollUpdateCmcFailed',
    '900' => 'pollUpdateAdaptorFailed',
    '901' => 'updateSasExpanderFailed',
    '902' => 'pollUpdateSasExpanderFailed',
    '903' => 'activateSasExpanderFailed',
    '904' => 'pollSasExpanderActivateFailed',
    '905' => 'activateCmcFailed',
    '906' => 'pollCmcActivationFailed',
    '907' => 'waitForPowerOffFailed',
    '908' => 'activateAdaptorFailed',
    '909' => 'pollAdaptorActivationFailed',
    '910' => 'activateStorageCtlrFailed',
    '911' => 'pollStorageCtlrActivationFailed',
    '912' => 'activateBrdCtlrFailed',
    '913' => 'pollBrdCtlrActivationFailed',
    '914' => 'activateLocalDiskFailed',
    '915' => 'powerOnServersFailed',
    '916' => 'diskZoningConfigFailed',
    '917' => 'postDiskZoneStorageInvcmcFailed',
    '918' => 'postDiskZoneStorageInvcimcFailed',
    '920' => 'completeFailed',
    '921' => 'equipmentLinkMisconnect',
    '922' => 'equipmentFruMissing',
    '923' => 'equipmentUnavailable',
    '924' => 'equipmentHotspareUnsupported',
    '925' => 'equipmentOwnershipUnsupported',
    '926' => 'equipmentIoeOwnershipUnassigned',
    '927' => 'equipmentHddslotServer2OwnershipUnassigned',
    '928' => 'chassisProfileUnassociated',
    '929' => 'chassisProfileAssociating',
    '930' => 'chassisProfileAssociated',
    '931' => 'chassisProfileDeassociating',
    '932' => 'chassisProfileUnassigned',
    '933' => 'chassisProfileAssigned',
    '934' => 'verifyUserZoneConfigFailed',
    '935' => 'pollSecureBootStatusFailed',
    '936' => 'resetSasExpanderFailed',
    '937' => 'pollLocalDiskActivateFailed',
    '938' => 'waitForActivationFailed',
    '939' => 'updateFailed',
    '940' => 'versionHolderChange',
    '941' => 'networkSanGroupDoesNotExist',
    '942' => 'updateSpLocalFailed',
    '943' => 'updateSpRemoteFailed',
    '944' => 'assertBypassWaitFailed',
    '945' => 'fabEvacOnRemotefiFailed',
    '946' => 'pollFabEvacOnRemotefiFailed',
    '947' => 'fabEvacOffRemotefiFailed',
    '948' => 'pollFabEvacOffRemotefiFailed',
    '949' => 'failOverToRemotefiFailed',
    '950' => 'pollFailOverToRemotefiFailed',
    '951' => 'activateucsmservicePackFailed',
    '952' => 'pollActivateOfucsmservicePackFailed',
    '953' => 'disableScriptablevmediaFailed',
    '954' => 'preconfigVmediaLocalFailed',
    '955' => 'preconfigVmediaPeerFailed',
    '956' => 'setupBootEnvironmentFailed',
    '957' => 'powerOnWaitFailed',
    '958' => 'runTestsFailed',
    '959' => 'logTransferFailed',
    '960' => 'waitForDebugFailed',
    '961' => 'tearDownBootEnvironmentFailed',
    '962' => 'pnuosperipheralComponentConfigFailed',
    '963' => 'configMgmtIpRulesFailed',
    '964' => 'hostosconnectFailed',
    '965' => 'configHostOsAnnotationsFailed',
    '966' => 'configServerIdentityFailed',
    '967' => 'unconfigServerIdentityFailed',
    '968' => 'kmipCertConfigFailed',
    '969' => 'kmipSaveCertFailed',
    '970' => 'estimateApplyConfigFailed',
    '971' => 'configChassisAdapterConnectivityFailed',
    '972' => 'portMisconfigure',
    '973' => 'transceiverMismatch',
    '974' => 'pciConfigIssue',
    '975' => 'fabricEvacuated',
    '976' => 'unicastMacExhausted',
    '977' => 'multicastMacExhausted',
    '978' => 'pvlifVlanMbrExhausted',
    '979' => 'pvsystemExhausted',
    '980' => 'igmpGroupExhausted',
    '981' => 'hardwareMismatch',
    '982' => 'chassisIntrusion',
    '983' => 'configProblem',
    '984' => 'networkSanGroupMisconfigured',
    '985' => 'reportErrorFailed',
    '986' => 'resolveFromPolicyMgrFailed',
    '987' => 'resolveFromOpsMgrFailed',
    '988' => 'kmipFault',
    '989' => 'hardwareInventoryMismatch',
    '990' => 'pciConfigMismatch',
    '991' => 'equipmentSecondControllerAbsent',
    '992' => 'conditionCauseHardwareInventoryMismatch',
    '993' => 'conditionCausePciConfigMismatch',
    '994' => 'healthInfo',
    '995' => 'removePeerFailed',
    '996' => 'imageCorrupted',
    '997' => 'restoreVdStatusFailed',
    '16385' => 'speedReduced',
    '16387' => 'updateAttrFailed',
    '16388' => 'persistFailed',
    '16389' => 'coreFileGenerated',
    '16391' => 'providerLostConnectivity',
    '16392' => 'controllerLostConnectivity',
    '16394' => 'serviceRegistryVersionMismatch',
    '16395' => 'providerVersionMismatch',
    '16396' => 'controllerVersionMismatch',
    '16397' => 'clientVersionMismatch',
    '16398' => 'svcRegModification',
    '16399' => 'providerCreation',
    '16400' => 'providerModification',
    '16401' => 'controllerCreation',
    '16402' => 'controllerModification',
    '16403' => 'clientCreation',
    '16404' => 'clientDeletion',
    '16405' => 'clientModification',
    '16406' => 'quiesceMgmtControllerFailed',
    '16407' => 'quiesceResMgrFailed',
    '16408' => 'quiesceOpsMgrFailed',
    '16409' => 'quiescePolicyMgrFailed',
    '16410' => 'quiesceidmgrFailed',
    