package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOSTACKMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-STACK-MIB'} = {
  url => '',
  name => 'CISCO-STACK-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-STACK-MIB'} =
    '1.3.6.1.4.1.9.5.1';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-STACK-MIB'} = {
  ciscoStackNotificationsPrefix => '1.3.6.1.4.1.9.5.0',
  ciscoStackMIB => '1.3.6.1.4.1.9.5.1',
  systemGrp => '1.3.6.1.4.1.9.5.1.1',
  sysMgmtType => '1.3.6.1.4.1.9.5.1.1.1',
  sysMgmtTypeDefinition => 'CISCO-STACK-MIB::sysMgmtType',
  sysIpAddr => '1.3.6.1.4.1.9.5.1.1.2',
  sysNetMask => '1.3.6.1.4.1.9.5.1.1.3',
  sysBroadcast => '1.3.6.1.4.1.9.5.1.1.4',
  sysTrapReceiverTable => '1.3.6.1.4.1.9.5.1.1.5',
  sysTrapReceiverEntry => '1.3.6.1.4.1.9.5.1.1.5.1',
  sysTrapReceiverType => '1.3.6.1.4.1.9.5.1.1.5.1.1',
  sysTrapReceiverTypeDefinition => 'CISCO-STACK-MIB::sysTrapReceiverType',
  sysTrapReceiverAddr => '1.3.6.1.4.1.9.5.1.1.5.1.2',
  sysTrapReceiverComm => '1.3.6.1.4.1.9.5.1.1.5.1.3',
  sysCommunityTable => '1.3.6.1.4.1.9.5.1.1.6',
  sysCommunityEntry => '1.3.6.1.4.1.9.5.1.1.6.1',
  sysCommunityAccess => '1.3.6.1.4.1.9.5.1.1.6.1.1',
  sysCommunityAccessDefinition => 'CISCO-STACK-MIB::sysCommunityAccess',
  sysCommunityString => '1.3.6.1.4.1.9.5.1.1.6.1.2',
  sysAttachType => '1.3.6.1.4.1.9.5.1.1.7',
  sysAttachTypeDefinition => 'CISCO-STACK-MIB::sysAttachType',
  sysTraffic => '1.3.6.1.4.1.9.5.1.1.8',
  sysReset => '1.3.6.1.4.1.9.5.1.1.9',
  sysResetDefinition => 'CISCO-STACK-MIB::sysReset',
  sysBaudRate => '1.3.6.1.4.1.9.5.1.1.10',
  sysBaudRateDefinition => 'CISCO-STACK-MIB::sysBaudRate',
  sysInsertMode => '1.3.6.1.4.1.9.5.1.1.11',
  sysInsertModeDefinition => 'CISCO-STACK-MIB::sysInsertMode',
  sysClearMacTime => '1.3.6.1.4.1.9.5.1.1.12',
  sysClearPortTime => '1.3.6.1.4.1.9.5.1.1.13',
  sysFddiRingTable => '1.3.6.1.4.1.9.5.1.1.14',
  sysFddiRingEntry => '1.3.6.1.4.1.9.5.1.1.14.1',
  sysFddiRingSMTIndex => '1.3.6.1.4.1.9.5.1.1.14.1.1',
  sysFddiRingAddress => '1.3.6.1.4.1.9.5.1.1.14.1.2',
  sysFddiRingNext => '1.3.6.1.4.1.9.5.1.1.14.1.3',
  sysEnableModem => '1.3.6.1.4.1.9.5.1.1.15',
  sysEnableModemDefinition => 'CISCO-STACK-MIB::sysEnableModem',
  sysEnableRedirects => '1.3.6.1.4.1.9.5.1.1.16',
  sysEnableRedirectsDefinition => 'CISCO-STACK-MIB::sysEnableRedirects',
  sysEnableRmon => '1.3.6.1.4.1.9.5.1.1.17',
  sysEnableRmonDefinition => 'CISCO-STACK-MIB::sysEnableRmon',
  sysArpAgingTime => '1.3.6.1.4.1.9.5.1.1.18',
  sysTrafficPeak => '1.3.6.1.4.1.9.5.1.1.19',
  sysTrafficPeakTime => '1.3.6.1.4.1.9.5.1.1.20',
  sysCommunityRwa => '1.3.6.1.4.1.9.5.1.1.21',
  sysCommunityRw => '1.3.6.1.4.1.9.5.1.1.22',
  sysCommunityRo => '1.3.6.1.4.1.9.5.1.1.23',
  sysEnableChassisTraps => '1.3.6.1.4.1.9.5.1.1.24',
  sysEnableChassisTrapsDefinition => 'CISCO-STACK-MIB::sysEnableChassisTraps',
  sysEnableModuleTraps => '1.3.6.1.4.1.9.5.1.1.25',
  sysEnableModuleTrapsDefinition => 'CISCO-STACK-MIB::sysEnableModuleTraps',
  sysEnableBridgeTraps => '1.3.6.1.4.1.9.5.1.1.26',
  sysEnableBridgeTrapsDefinition => 'CISCO-STACK-MIB::sysEnableBridgeTraps',
  sysIpVlan => '1.3.6.1.4.1.9.5.1.1.27',
  sysConfigChangeTime => '1.3.6.1.4.1.9.5.1.1.28',
  sysEnableRepeaterTraps => '1.3.6.1.4.1.9.5.1.1.29',
  sysEnableRepeaterTrapsDefinition => 'CISCO-STACK-MIB::sysEnableRepeaterTraps',
  sysBannerMotd => '1.3.6.1.4.1.9.5.1.1.30',
  sysEnableIpPermitTraps => '1.3.6.1.4.1.9.5.1.1.31',
  sysEnableIpPermitTrapsDefinition => 'CISCO-STACK-MIB::sysEnableIpPermitTraps',
  sysTrafficMeterTable => '1.3.6.1.4.1.9.5.1.1.32',
  sysTrafficMeterEntry => '1.3.6.1.4.1.9.5.1.1.32.1',
  sysTrafficMeterType => '1.3.6.1.4.1.9.5.1.1.32.1.1',
  sysTrafficMeterTypeDefinition => 'CISCO-STACK-MIB::sysTrafficMeterType',
  sysTrafficMeter => '1.3.6.1.4.1.9.5.1.1.32.1.2',
  sysTrafficMeterPeak => '1.3.6.1.4.1.9.5.1.1.32.1.3',
  sysTrafficMeterPeakTime => '1.3.6.1.4.1.9.5.1.1.32.1.4',
  sysEnableVmpsTraps => '1.3.6.1.4.1.9.5.1.1.33',
  sysEnableVmpsTrapsDefinition => 'CISCO-STACK-MIB::sysEnableVmpsTraps',
  sysConfigChangeInfo => '1.3.6.1.4.1.9.5.1.1.34',
  sysEnableConfigTraps => '1.3.6.1.4.1.9.5.1.1.35',
  sysEnableConfigTrapsDefinition => 'CISCO-STACK-MIB::sysEnableConfigTraps',
  sysConfigRegister => '1.3.6.1.4.1.9.5.1.1.36',
  sysBootVariable => '1.3.6.1.4.1.9.5.1.1.37',
  sysBootedImage => '1.3.6.1.4.1.9.5.1.1.38',
  sysEnableEntityTrap => '1.3.6.1.4.1.9.5.1.1.39',
  sysEnableEntityTrapDefinition => 'CISCO-STACK-MIB::sysEnableEntityTrap',
  sysEnableStpxTrap => '1.3.6.1.4.1.9.5.1.1.40',
  sysEnableStpxTrapDefinition => 'CISCO-STACK-MIB::sysEnableStpxTrap',
  sysExtendedRmonVlanModeEnable => '1.3.6.1.4.1.9.5.1.1.41',
  sysExtendedRmonVlanModeEnableDefinition => 'CISCO-STACK-MIB::sysExtendedRmonVlanModeEnable',
  sysExtendedRmonNetflowPassword => '1.3.6.1.4.1.9.5.1.1.42',
  sysExtendedRmonNetflowEnable => '1.3.6.1.4.1.9.5.1.1.43',
  sysExtendedRmonNetflowEnableDefinition => 'CISCO-STACK-MIB::sysExtendedRmonNetflowEnable',
  sysExtendedRmonVlanAgentEnable => '1.3.6.1.4.1.9.5.1.1.44',
  sysExtendedRmonVlanAgentEnableDefinition => 'CISCO-STACK-MIB::sysExtendedRmonVlanAgentEnable',
  sysExtendedRmonEnable => '1.3.6.1.4.1.9.5.1.1.45',
  sysExtendedRmonEnableDefinition => 'CISCO-STACK-MIB::sysExtendedRmonEnable',
  sysConsolePrimaryLoginAuthentication => '1.3.6.1.4.1.9.5.1.1.46',
  sysConsolePrimaryLoginAuthenticationDefinition => 'CISCO-STACK-MIB::sysConsolePrimaryLoginAuthentication',
  sysConsolePrimaryEnableAuthentication => '1.3.6.1.4.1.9.5.1.1.47',
  sysConsolePrimaryEnableAuthenticationDefinition => 'CISCO-STACK-MIB::sysConsolePrimaryEnableAuthentication',
  sysTelnetPrimaryLoginAuthentication => '1.3.6.1.4.1.9.5.1.1.48',
  sysTelnetPrimaryLoginAuthenticationDefinition => 'CISCO-STACK-MIB::sysTelnetPrimaryLoginAuthentication',
  sysTelnetPrimaryEnableAuthentication => '1.3.6.1.4.1.9.5.1.1.49',
  sysTelnetPrimaryEnableAuthenticationDefinition => 'CISCO-STACK-MIB::sysTelnetPrimaryEnableAuthentication',
  sysStartupConfigSource => '1.3.6.1.4.1.9.5.1.1.50',
  sysStartupConfigSourceDefinition => 'CISCO-STACK-MIB::sysStartupConfigSource',
  sysStartupConfigSourceFile => '1.3.6.1.4.1.9.5.1.1.51',
  sysConfigSupervisorModuleNo => '1.3.6.1.4.1.9.5.1.1.52',
  sysStandbyPortEnable => '1.3.6.1.4.1.9.5.1.1.53',
  sysStandbyPortEnableDefinition => 'CISCO-STACK-MIB::sysStandbyPortEnable',
  sysPortFastBpduGuard => '1.3.6.1.4.1.9.5.1.1.54',
  sysPortFastBpduGuardDefinition => 'CISCO-STACK-MIB::sysPortFastBpduGuard',
  sysErrDisableTimeoutEnable => '1.3.6.1.4.1.9.5.1.1.55',
  sysErrDisableTimeoutInterval => '1.3.6.1.4.1.9.5.1.1.56',
  sysTrafficMonitorHighWaterMark => '1.3.6.1.4.1.9.5.1.1.57',
  sysHighAvailabilityEnable => '1.3.6.1.4.1.9.5.1.1.58',
  sysHighAvailabilityVersioningEnable => '1.3.6.1.4.1.9.5.1.1.59',
  sysHighAvailabilityOperStatus => '1.3.6.1.4.1.9.5.1.1.60',
  sysHighAvailabilityOperStatusDefinition => 'CISCO-STACK-MIB::sysHighAvailabilityOperStatus',
  sysHighAvailabilityNotRunningReason => '1.3.6.1.4.1.9.5.1.1.61',
  sysExtendedRmonNetflowModuleMask => '1.3.6.1.4.1.9.5.1.1.62',
  sshPublicKeySize => '1.3.6.1.4.1.9.5.1.1.63',
  sysMaxRmonMemory => '1.3.6.1.4.1.9.5.1.1.64',
  sysMacReductionAdminEnable => '1.3.6.1.4.1.9.5.1.1.65',
  sysMacReductionOperEnable => '1.3.6.1.4.1.9.5.1.1.66',
  sysStatus => '1.3.6.1.4.1.9.5.1.1.67',
  sysStatusDefinition => 'CISCO-STACK-MIB::sysStatus',
  chassisGrp => '1.3.6.1.4.1.9.5.1.2',
  chassisSysType => '1.3.6.1.4.1.9.5.1.2.1',
  chassisSysTypeDefinition => 'CISCO-STACK-MIB::chassisSysType',
  chassisBkplType => '1.3.6.1.4.1.9.5.1.2.2',
  chassisBkplTypeDefinition => 'CISCO-STACK-MIB::chassisBkplType',
  chassisPs1Type => '1.3.6.1.4.1.9.5.1.2.3',
  chassisPs1TypeDefinition => 'CISCO-STACK-MIB::chassisPs1Type',
  chassisPs1Status => '1.3.6.1.4.1.9.5.1.2.4',
  chassisPs1StatusDefinition => 'CISCO-STACK-MIB::chassisPs1Status',
  chassisPs1TestResult => '1.3.6.1.4.1.9.5.1.2.5',
  chassisPs2Type => '1.3.6.1.4.1.9.5.1.2.6',
  chassisPs2TypeDefinition => 'CISCO-STACK-MIB::chassisPs2Type',
  chassisPs2Status => '1.3.6.1.4.1.9.5.1.2.7',
  chassisPs2StatusDefinition => 'CISCO-STACK-MIB::chassisPs2Status',
  chassisPs2TestResult => '1.3.6.1.4.1.9.5.1.2.8',
  chassisFanStatus => '1.3.6.1.4.1.9.5.1.2.9',
  chassisFanStatusDefinition => 'CISCO-STACK-MIB::chassisFanStatus',
  chassisFanTestResult => '1.3.6.1.4.1.9.5.1.2.10',
  chassisMinorAlarm => '1.3.6.1.4.1.9.5.1.2.11',
  chassisMinorAlarmDefinition => 'CISCO-STACK-MIB::chassisMinorAlarm',
  chassisMajorAlarm => '1.3.6.1.4.1.9.5.1.2.12',
  chassisMajorAlarmDefinition => 'CISCO-STACK-MIB::chassisMajorAlarm',
  chassisTempAlarm => '1.3.6.1.4.1.9.5.1.2.13',
  chassisTempAlarmDefinition => 'CISCO-STACK-MIB::chassisTempAlarm',
  chassisNumSlots => '1.3.6.1.4.1.9.5.1.2.14',
  chassisSlotConfig => '1.3.6.1.4.1.9.5.1.2.15',
  chassisModel => '1.3.6.1.4.1.9.5.1.2.16',
  chassisSerialNumber => '1.3.6.1.4.1.9.5.1.2.17',
  chassisComponentTable => '1.3.6.1.4.1.9.5.1.2.18',
  chassisComponentEntry => '1.3.6.1.4.1.9.5.1.2.18.1',
  chassisComponentIndex => '1.3.6.1.4.1.9.5.1.2.18.1.1',
  chassisComponentType => '1.3.6.1.4.1.9.5.1.2.18.1.2',
  chassisComponentTypeDefinition => 'CISCO-STACK-MIB::chassisComponentType',
  chassisComponentSerialNumber => '1.3.6.1.4.1.9.5.1.2.18.1.3',
  chassisComponentHwVersion => '1.3.6.1.4.1.9.5.1.2.18.1.4',
  chassisComponentModel => '1.3.6.1.4.1.9.5.1.2.18.1.5',
  chassisSerialNumberString => '1.3.6.1.4.1.9.5.1.2.19',
  chassisPs3Type => '1.3.6.1.4.1.9.5.1.2.20',
  chassisPs3TypeDefinition => 'CISCO-STACK-MIB::chassisPs3Type',
  chassisPs3Status => '1.3.6.1.4.1.9.5.1.2.21',
  chassisPs3StatusDefinition => 'CISCO-STACK-MIB::chassisPs3Status',
  chassisPs3TestResult => '1.3.6.1.4.1.9.5.1.2.22',
  chassisPEMInstalled => '1.3.6.1.4.1.9.5.1.2.23',
  moduleGrp => '1.3.6.1.4.1.9.5.1.3',
  moduleTable => '1.3.6.1.4.1.9.5.1.3.1',
  moduleEntry => '1.3.6.1.4.1.9.5.1.3.1.1',
  moduleIndex => '1.3.6.1.4.1.9.5.1.3.1.1.1',
  moduleType => '1.3.6.1.4.1.9.5.1.3.1.1.2',
  moduleTypeDefinition => 'CISCO-STACK-MIB::moduleType',
  moduleSerialNumber => '1.3.6.1.4.1.9.5.1.3.1.1.3',
  moduleHwHiVersion => '1.3.6.1.4.1.9.5.1.3.1.1.4',
  moduleHwLoVersion => '1.3.6.1.4.1.9.5.1.3.1.1.5',
  moduleFwHiVersion => '1.3.6.1.4.1.9.5.1.3.1.1.6',
  moduleFwLoVersion => '1.3.6.1.4.1.9.5.1.3.1.1.7',
  moduleSwHiVersion => '1.3.6.1.4.1.9.5.1.3.1.1.8',
  moduleSwLoVersion => '1.3.6.1.4.1.9.5.1.3.1.1.9',
  moduleStatus => '1.3.6.1.4.1.9.5.1.3.1.1.10',
  moduleStatusDefinition => 'CISCO-STACK-MIB::moduleStatus',
  moduleTestResult => '1.3.6.1.4.1.9.5.1.3.1.1.11',
  moduleAction => '1.3.6.1.4.1.9.5.1.3.1.1.12',
  moduleActionDefinition => 'CISCO-STACK-MIB::moduleAction',
  moduleName => '1.3.6.1.4.1.9.5.1.3.1.1.13',
  moduleNumPorts => '1.3.6.1.4.1.9.5.1.3.1.1.14',
  modulePortStatus => '1.3.6.1.4.1.9.5.1.3.1.1.15',
  moduleSubType => '1.3.6.1.4.1.9.5.1.3.1.1.16',
  moduleSubTypeDefinition => 'CISCO-STACK-MIB::moduleSubType',
  moduleModel => '1.3.6.1.4.1.9.5.1.3.1.1.17',
  moduleHwVersion => '1.3.6.1.4.1.9.5.1.3.1.1.18',
  moduleFwVersion => '1.3.6.1.4.1.9.5.1.3.1.1.19',
  moduleSwVersion => '1.3.6.1.4.1.9.5.1.3.1.1.20',
  moduleStandbyStatus => '1.3.6.1.4.1.9.5.1.3.1.1.21',
  moduleStandbyStatusDefinition => 'CISCO-STACK-MIB::moduleStandbyStatus',
  moduleIPAddress => '1.3.6.1.4.1.9.5.1.3.1.1.22',
  moduleIPAddressVlan => '1.3.6.1.4.1.9.5.1.3.1.1.23',
  moduleSubType2 => '1.3.6.1.4.1.9.5.1.3.1.1.24',
  moduleSubType2Definition => 'CISCO-STACK-MIB::moduleSubType2',
  moduleSlotNum => '1.3.6.1.4.1.9.5.1.3.1.1.25',
  moduleSerialNumberString => '1.3.6.1.4.1.9.5.1.3.1.1.26',
  moduleEntPhysicalIndex => '1.3.6.1.4.1.9.5.1.3.1.1.27',
  moduleAdditionalStatus => '1.3.6.1.4.1.9.5.1.3.1.1.28',
  portGrp => '1.3.6.1.4.1.9.5.1.4',
  portTable => '1.3.6.1.4.1.9.5.1.4.1',
  portEntry => '1.3.6.1.4.1.9.5.1.4.1.1',
  portModuleIndex => '1.3.6.1.4.1.9.5.1.4.1.1.1',
  portIndex => '1.3.6.1.4.1.9.5.1.4.1.1.2',
  portCrossIndex => '1.3.6.1.4.1.9.5.1.4.1.1.3',
  portName => '1.3.6.1.4.1.9.5.1.4.1.1.4',
  portType => '1.3.6.1.4.1.9.5.1.4.1.1.5',
  portTypeDefinition => 'CISCO-STACK-MIB::portType',
  portOperStatus => '1.3.6.1.4.1.9.5.1.4.1.1.6',
  portOperStatusDefinition => 'CISCO-STACK-MIB::portOperStatus',
  portCrossGroupIndex => '1.3.6.1.4.1.9.5.1.4.1.1.7',
  portAdditionalStatus => '1.3.6.1.4.1.9.5.1.4.1.1.8',
  portAdminSpeed => '1.3.6.1.4.1.9.5.1.4.1.1.9',
  portAdminSpeedDefinition => 'CISCO-STACK-MIB::portAdminSpeed',
  portDuplex => '1.3.6.1.4.1.9.5.1.4.1.1.10',
  portDuplexDefinition => 'CISCO-STACK-MIB::portDuplex',
  portIfIndex => '1.3.6.1.4.1.9.5.1.4.1.1.11',
  portSpantreeFastStart => '1.3.6.1.4.1.9.5.1.4.1.1.12',
  portSpantreeFastStartDefinition => 'CISCO-STACK-MIB::portSpantreeFastStart',
  portAdminRxFlowControl => '1.3.6.1.4.1.9.5.1.4.1.1.13',
  portAdminRxFlowControlDefinition => 'CISCO-STACK-MIB::portAdminRxFlowControl',
  portOperRxFlowControl => '1.3.6.1.4.1.9.5.1.4.1.1.14',
  portOperRxFlowControlDefinition => 'CISCO-STACK-MIB::portOperRxFlowControl',
  portAdminTxFlowControl => '1.3.6.1.4.1.9.5.1.4.1.1.15',
  portAdminTxFlowControlDefinition => 'CISCO-STACK-MIB::portAdminTxFlowControl',
  portOperTxFlowControl => '1.3.6.1.4.1.9.5.1.4.1.1.16',
  portOperTxFlowControlDefinition => 'CISCO-STACK-MIB::portOperTxFlowControl',
  portMacControlTransmitFrames => '1.3.6.1.4.1.9.5.1.4.1.1.17',
  portMacControlReceiveFrames => '1.3.6.1.4.1.9.5.1.4.1.1.18',
  portMacControlPauseTransmitFrames => '1.3.6.1.4.1.9.5.1.4.1.1.19',
  portMacControlPauseReceiveFrames => '1.3.6.1.4.1.9.5.1.4.1.1.20',
  portMacControlUnknownProtocolFrames => '1.3.6.1.4.1.9.5.1.4.1.1.21',
  portLinkFaultStatus => '1.3.6.1.4.1.9.5.1.4.1.1.22',
  portLinkFaultStatusDefinition => 'CISCO-STACK-MIB::portLinkFaultStatus',
  portAdditionalOperStatus => '1.3.6.1.4.1.9.5.1.4.1.1.23',
  portInlinePowerDetect => '1.3.6.1.4.1.9.5.1.4.1.1.24',
  portEntPhysicalIndex => '1.3.6.1.4.1.9.5.1.4.1.1.25',
  portErrDisableTimeOutEnable => '1.3.6.1.4.1.9.5.1.4.1.1.26',
  portErrDisableTimeOutEnableDefinition => 'CISCO-STACK-MIB::portErrDisableTimeOutEnable',
  tftpGrp => '1.3.6.1.4.1.9.5.1.5',
  tftpHost => '1.3.6.1.4.1.9.5.1.5.1',
  tftpFile => '1.3.6.1.4.1.9.5.1.5.2',
  tftpModule => '1.3.6.1.4.1.9.5.1.5.3',
  tftpAction => '1.3.6.1.4.1.9.5.1.5.4',
  tftpActionDefinition => 'CISCO-STACK-MIB::tftpAction',
  tftpResult => '1.3.6.1.4.1.9.5.1.5.5',
  tftpResultDefinition => 'CISCO-STACK-MIB::tftpResult',
  brouterGrp => '1.3.6.1.4.1.9.5.1.6',
  brouterEnableRip => '1.3.6.1.4.1.9.5.1.6.1',
  brouterEnableRipDefinition => 'CISCO-STACK-MIB::brouterEnableRip',
  brouterEnableSpantree => '1.3.6.1.4.1.9.5.1.6.2',
  brouterEnableSpantreeDefinition => 'CISCO-STACK-MIB::brouterEnableSpantree',
  brouterEnableGiantCheck => '1.3.6.1.4.1.9.5.1.6.3',
  brouterEnableGiantCheckDefinition => 'CISCO-STACK-MIB::brouterEnableGiantCheck',
  brouterEnableIpFragmentation => '1.3.6.1.4.1.9.5.1.6.4',
  brouterEnableIpFragmentationDefinition => 'CISCO-STACK-MIB::brouterEnableIpFragmentation',
  brouterEnableUnreachables => '1.3.6.1.4.1.9.5.1.6.5',
  brouterEnableUnreachablesDefinition => 'CISCO-STACK-MIB::brouterEnableUnreachables',
  brouterCamAgingTime => '1.3.6.1.4.1.9.5.1.6.6',
  brouterCamMode => '1.3.6.1.4.1.9.5.1.6.7',
  brouterCamModeDefinition => 'CISCO-STACK-MIB::brouterCamMode',
  brouterIpxSnapToEther => '1.3.6.1.4.1.9.5.1.6.8',
  brouterIpxSnapToEtherDefinition => 'CISCO-STACK-MIB::brouterIpxSnapToEther',
  brouterIpx8023RawToFddi => '1.3.6.1.4.1.9.5.1.6.9',
  brouterIpx8023RawToFddiDefinition => 'CISCO-STACK-MIB::brouterIpx8023RawToFddi',
  brouterEthernetReceiveMax => '1.3.6.1.4.1.9.5.1.6.10',
  brouterEthernetTransmitMax => '1.3.6.1.4.1.9.5.1.6.11',
  brouterFddiReceiveMax => '1.3.6.1.4.1.9.5.1.6.12',
  brouterFddiTransmitMax => '1.3.6.1.4.1.9.5.1.6.13',
  brouterPortTable => '1.3.6.1.4.1.9.5.1.6.14',
  brouterPortEntry => '1.3.6.1.4.1.9.5.1.6.14.1',
  brouterPortModule => '1.3.6.1.4.1.9.5.1.6.14.1.1',
  brouterPort => '1.3.6.1.4.1.9.5.1.6.14.1.2',
  brouterPortIpVlan => '1.3.6.1.4.1.9.5.1.6.14.1.3',
  brouterPortIpAddr => '1.3.6.1.4.1.9.5.1.6.14.1.4',
  brouterPortNetMask => '1.3.6.1.4.1.9.5.1.6.14.1.5',
  brouterPortBroadcast => '1.3.6.1.4.1.9.5.1.6.14.1.6',
  brouterPortBridgeVlan => '1.3.6.1.4.1.9.5.1.6.14.1.7',
  brouterPortIpHelpers => '1.3.6.1.4.1.9.5.1.6.14.1.8',
  brouterIpx8022ToEther => '1.3.6.1.4.1.9.5.1.6.15',
  brouterIpx8022ToEtherDefinition => 'CISCO-STACK-MIB::brouterIpx8022ToEther',
  brouterEnableTransitEncapsulation => '1.3.6.1.4.1.9.5.1.6.16',
  brouterEnableTransitEncapsulationDefinition => 'CISCO-STACK-MIB::brouterEnableTransitEncapsulation',
  brouterEnableFddiCheck => '1.3.6.1.4.1.9.5.1.6.17',
  brouterEnableFddiCheckDefinition => 'CISCO-STACK-MIB::brouterEnableFddiCheck',
  brouterEnableAPaRT => '1.3.6.1.4.1.9.5.1.6.18',
  brouterEnableAPaRTDefinition => 'CISCO-STACK-MIB::brouterEnableAPaRT',
  filterGrp => '1.3.6.1.4.1.9.5.1.7',
  filterMacTable => '1.3.6.1.4.1.9.5.1.7.1',
  filterMacEntry => '1.3.6.1.4.1.9.5.1.7.1.1',
  filterMacModule => '1.3.6.1.4.1.9.5.1.7.1.1.1',
  filterMacPort => '1.3.6.1.4.1.9.5.1.7.1.1.2',
  filterMacAddress => '1.3.6.1.4.1.9.5.1.7.1.1.3',
  filterMacType => '1.3.6.1.4.1.9.5.1.7.1.1.4',
  filterMacTypeDefinition => 'CISCO-STACK-MIB::filterMacType',
  filterVendorTable => '1.3.6.1.4.1.9.5.1.7.2',
  filterVendorEntry => '1.3.6.1.4.1.9.5.1.7.2.1',
  filterVendorModule => '1.3.6.1.4.1.9.5.1.7.2.1.1',
  filterVendorPort => '1.3.6.1.4.1.9.5.1.7.2.1.2',
  filterVendorId => '1.3.6.1.4.1.9.5.1.7.2.1.3',
  filterVendorType => '1.3.6.1.4.1.9.5.1.7.2.1.4',
  filterVendorTypeDefinition => 'CISCO-STACK-MIB::filterVendorType',
  filterProtocolTable => '1.3.6.1.4.1.9.5.1.7.3',
  filterProtocolEntry => '1.3.6.1.4.1.9.5.1.7.3.1',
  filterProtocolModule => '1.3.6.1.4.1.9.5.1.7.3.1.1',
  filterProtocolPort => '1.3.6.1.4.1.9.5.1.7.3.1.2',
  filterProtocolValue => '1.3.6.1.4.1.9.5.1.7.3.1.3',
  filterProtocolType => '1.3.6.1.4.1.9.5.1.7.3.1.4',
  filterProtocolTypeDefinition => 'CISCO-STACK-MIB::filterProtocolType',
  filterTestTable => '1.3.6.1.4.1.9.5.1.7.4',
  filterTestEntry => '1.3.6.1.4.1.9.5.1.7.4.1',
  filterTestModule => '1.3.6.1.4.1.9.5.1.7.4.1.1',
  filterTestPort => '1.3.6.1.4.1.9.5.1.7.4.1.2',
  filterTestIndex => '1.3.6.1.4.1.9.5.1.7.4.1.3',
  filterTestType => '1.3.6.1.4.1.9.5.1.7.4.1.4',
  filterTestTypeDefinition => 'CISCO-STACK-MIB::filterTestType',
  filterTestOffset => '1.3.6.1.4.1.9.5.1.7.4.1.5',
  filterTestValue => '1.3.6.1.4.1.9.5.1.7.4.1.6',
  filterTestMask => '1.3.6.1.4.1.9.5.1.7.4.1.7',
  filterPortTable => '1.3.6.1.4.1.9.5.1.7.5',
  filterPortEntry => '1.3.6.1.4.1.9.5.1.7.5.1',
  filterPortModule => '1.3.6.1.4.1.9.5.1.7.5.1.1',
  filterPort => '1.3.6.1.4.1.9.5.1.7.5.1.2',
  filterPortComplex => '1.3.6.1.4.1.9.5.1.7.5.1.3',
  filterPortBroadcastThrottle => '1.3.6.1.4.1.9.5.1.7.5.1.4',
  filterPortBroadcastThreshold => '1.3.6.1.4.1.9.5.1.7.5.1.5',
  filterPortBroadcastDiscards => '1.3.6.1.4.1.9.5.1.7.5.1.6',
  filterPortBroadcastThresholdFraction => '1.3.6.1.4.1.9.5.1.7.5.1.7',
  filterPortSuppressionOption => '1.3.6.1.4.1.9.5.1.7.5.1.8',
  filterPortSuppressionViolation => '1.3.6.1.4.1.9.5.1.7.5.1.9',
  filterPortSuppressionViolationDefinition => 'CISCO-STACK-MIB::filterPortSuppressionViolation',
  monitorGrp => '1.3.6.1.4.1.9.5.1.8',
  monitorSourceModule => '1.3.6.1.4.1.9.5.1.8.1',
  monitorSourcePort => '1.3.6.1.4.1.9.5.1.8.2',
  monitorDestinationModule => '1.3.6.1.4.1.9.5.1.8.3',
  monitorDestinationPort => '1.3.6.1.4.1.9.5.1.8.4',
  monitorDirection => '1.3.6.1.4.1.9.5.1.8.5',
  monitorDirectionDefinition => 'CISCO-STACK-MIB::monitorDirection',
  monitorEnable => '1.3.6.1.4.1.9.5.1.8.6',
  monitorEnableDefinition => 'CISCO-STACK-MIB::monitorEnable',
  monitorAdminSourcePorts => '1.3.6.1.4.1.9.5.1.8.7',
  monitorOperSourcePorts => '1.3.6.1.4.1.9.5.1.8.8',
  vlanGrp => '1.3.6.1.4.1.9.5.1.9',
  vlanTable => '1.3.6.1.4.1.9.5.1.9.2',
  vlanEntry => '1.3.6.1.4.1.9.5.1.9.2.1',
  vlanIndex => '1.3.6.1.4.1.9.5.1.9.2.1.1',
  vlanSpantreeEnable => '1.3.6.1.4.1.9.5.1.9.2.1.2',
  vlanSpantreeEnableDefinition => 'CISCO-STACK-MIB::vlanSpantreeEnable',
  vlanIfIndex => '1.3.6.1.4.1.9.5.1.9.2.1.3',
  vlanPortTable => '1.3.6.1.4.1.9.5.1.9.3',
  vlanPortEntry => '1.3.6.1.4.1.9.5.1.9.3.1',
  vlanPortModule => '1.3.6.1.4.1.9.5.1.9.3.1.1',
  vlanPort => '1.3.6.1.4.1.9.5.1.9.3.1.2',
  vlanPortVlan => '1.3.6.1.4.1.9.5.1.9.3.1.3',
  vlanPortIslVlansAllowed => '1.3.6.1.4.1.9.5.1.9.3.1.5',
  vlanPortSwitchLevel => '1.3.6.1.4.1.9.5.1.9.3.1.6',
  vlanPortSwitchLevelDefinition => 'CISCO-STACK-MIB::vlanPortSwitchLevel',
  vlanPortIslAdminStatus => '1.3.6.1.4.1.9.5.1.9.3.1.7',
  vlanPortIslAdminStatusDefinition => 'CISCO-STACK-MIB::vlanPortIslAdminStatus',
  vlanPortIslOperStatus => '1.3.6.1.4.1.9.5.1.9.3.1.8',
  vlanPortIslOperStatusDefinition => 'CISCO-STACK-MIB::vlanPortIslOperStatus',
  vlanPortIslPriorityVlans => '1.3.6.1.4.1.9.5.1.9.3.1.9',
  vlanPortAdminStatus => '1.3.6.1.4.1.9.5.1.9.3.1.10',
  vlanPortAdminStatusDefinition => 'CISCO-STACK-MIB::vlanPortAdminStatus',
  vlanPortOperStatus => '1.3.6.1.4.1.9.5.1.9.3.1.11',
  vlanPortOperStatusDefinition => 'CISCO-STACK-MIB::vlanPortOperStatus',
  vlanPortAuxiliaryVlan => '1.3.6.1.4.1.9.5.1.9.3.1.12',
  vmpsTable => '1.3.6.1.4.1.9.5.1.9.4',
  vmpsEntry => '1.3.6.1.4.1.9.5.1.9.4.1',
  vmpsAddr => '1.3.6.1.4.1.9.5.1.9.4.1.1',
  vmpsType => '1.3.6.1.4.1.9.5.1.9.4.1.2',
  vmpsTypeDefinition => 'CISCO-STACK-MIB::vmpsType',
  vmpsAction => '1.3.6.1.4.1.9.5.1.9.5',
  vmpsActionDefinition => 'CISCO-STACK-MIB::vmpsAction',
  vmpsAccessed => '1.3.6.1.4.1.9.5.1.9.6',
  vlanTrunkMappingMax => '1.3.6.1.4.1.9.5.1.9.7',
  vlanTrunkMappingTable => '1.3.6.1.4.1.9.5.1.9.8',
  vlanTrunkMappingEntry => '1.3.6.1.4.1.9.5.1.9.8.1',
  vlanTrunkMappingFromVlan => '1.3.6.1.4.1.9.5.1.9.8.1.1',
  vlanTrunkMappingToVlan => '1.3.6.1.4.1.9.5.1.9.8.1.2',
  vlanTrunkMappingType => '1.3.6.1.4.1.9.5.1.9.8.1.3',
  vlanTrunkMappingTypeDefinition => 'CISCO-STACK-MIB::vlanTrunkMappingType',
  vlanTrunkMappingOper => '1.3.6.1.4.1.9.5.1.9.8.1.4',
  vlanTrunkMappingStatus => '1.3.6.1.4.1.9.5.1.9.8.1.5',
  securityGrp => '1.3.6.1.4.1.9.5.1.10',
  portSecurityTable => '1.3.6.1.4.1.9.5.1.10.1',
  portSecurityEntry => '1.3.6.1.4.1.9.5.1.10.1.1',
  portSecurityModuleIndex => '1.3.6.1.4.1.9.5.1.10.1.1.1',
  portSecurityPortIndex => '1.3.6.1.4.1.9.5.1.10.1.1.2',
  portSecurityAdminStatus => '1.3.6.1.4.1.9.5.1.10.1.1.3',
  portSecurityAdminStatusDefinition => 'CISCO-STACK-MIB::portSecurityAdminStatus',
  portSecurityOperStatus => '1.3.6.1.4.1.9.5.1.10.1.1.4',
  portSecurityOperStatusDefinition => 'CISCO-STACK-MIB::portSecurityOperStatus',
  portSecurityLastSrcAddr => '1.3.6.1.4.1.9.5.1.10.1.1.5',
  portSecuritySecureSrcAddr => '1.3.6.1.4.1.9.5.1.10.1.1.6',
  portSecurityMaxSrcAddr => '1.3.6.1.4.1.9.5.1.10.1.1.7',
  portSecurityAgingTime => '1.3.6.1.4.1.9.5.1.10.1.1.8',
  portSecurityShutdownTimeOut => '1.3.6.1.4.1.9.5.1.10.1.1.9',
  portSecurityViolationPolicy => '1.3.6.1.4.1.9.5.1.10.1.1.10',
  portSecurityViolationPolicyDefinition => 'CISCO-STACK-MIB::portSecurityViolationPolicy',
  portSecurityExtTable => '1.3.6.1.4.1.9.5.1.10.2',
  portSecurityExtEntry => '1.3.6.1.4.1.9.5.1.10.2.1',
  portSecurityExtModuleIndex => '1.3.6.1.4.1.9.5.1.10.2.1.1',
  portSecurityExtPortIndex => '1.3.6.1.4.1.9.5.1.10.2.1.2',
  portSecurityExtSecureSrcAddr => '1.3.6.1.4.1.9.5.1.10.2.1.3',
  portSecurityExtControlStatus => '1.3.6.1.4.1.9.5.1.10.2.1.4',
  portSecurityExtControlStatusDefinition => 'CISCO-STACK-MIB::portSecurityExtControlStatus',
  tokenRingGrp => '1.3.6.1.4.1.9.5.1.11',
  tokenRingPortTable => '1.3.6.1.4.1.9.5.1.11.1',
  tokenRingPortEntry => '1.3.6.1.4.1.9.5.1.11.1.1',
  tokenRingModuleIndex => '1.3.6.1.4.1.9.5.1.11.1.1.1',
  tokenRingPortIndex => '1.3.6.1.4.1.9.5.1.11.1.1.2',
  tokenRingPortSetACbits => '1.3.6.1.4.1.9.5.1.11.1.1.3',
  tokenRingPortSetACbitsDefinition => 'CISCO-STACK-MIB::tokenRingPortSetACbits',
  tokenRingPortMode => '1.3.6.1.4.1.9.5.1.11.1.1.4',
  tokenRingPortModeDefinition => 'CISCO-STACK-MIB::tokenRingPortMode',
  tokenRingPortEarlyTokenRel => '1.3.6.1.4.1.9.5.1.11.1.1.9',
  tokenRingPortEarlyTokenRelDefinition => 'CISCO-STACK-MIB::tokenRingPortEarlyTokenRel',
  tokenRingPortPriorityThresh => '1.3.6.1.4.1.9.5.1.11.1.1.10',
  tokenRingPortPriorityMinXmit => '1.3.6.1.4.1.9.5.1.11.1.1.11',
  tokenRingPortCfgLossThresh => '1.3.6.1.4.1.9.5.1.11.1.1.12',
  tokenRingPortCfgLossInterval => '1.3.6.1.4.1.9.5.1.11.1.1.13',
  tokenRingDripDistCrfMode => '1.3.6.1.4.1.9.5.1.11.2',
  tokenRingDripDistCrfModeDefinition => 'CISCO-STACK-MIB::tokenRingDripDistCrfMode',
  tokenRingDripAreReductionMode => '1.3.6.1.4.1.9.5.1.11.3',
  tokenRingDripAreReductionModeDefinition => 'CISCO-STACK-MIB::tokenRingDripAreReductionMode',
  tokenRingDripLocalNodeID => '1.3.6.1.4.1.9.5.1.11.4',
  tokenRingDripLastRevision => '1.3.6.1.4.1.9.5.1.11.5',
  tokenRingDripLastChangedRevision => '1.3.6.1.4.1.9.5.1.11.6',
  tokenRingDripAdvertsReceived => '1.3.6.1.4.1.9.5.1.11.7',
  tokenRingDripAdvertsTransmitted => '1.3.6.1.4.1.9.5.1.11.8',
  tokenRingDripAdvertsProcessed => '1.3.6.1.4.1.9.5.1.11.9',
  tokenRingDripInputQueueDrops => '1.3.6.1.4.1.9.5.1.11.10',
  tokenRingDripOutputQueueDrops => '1.3.6.1.4.1.9.5.1.11.11',
  tokenRingDripLocalVlanStatusTable => '1.3.6.1.4.1.9.5.1.11.12',
  tokenRingDripLocalVlanStatusEntry => '1.3.6.1.4.1.9.5.1.11.12.1',
  tokenRingDripVlan => '1.3.6.1.4.1.9.5.1.11.12.1.1',
  tokenRingDripLocalPortStatus => '1.3.6.1.4.1.9.5.1.11.12.1.2',
  tokenRingDripLocalPortStatusDefinition => 'CISCO-STACK-MIB::tokenRingDripLocalPortStatus',
  tokenRingDripRemotePortStatus => '1.3.6.1.4.1.9.5.1.11.12.1.3',
  tokenRingDripRemotePortStatusDefinition => 'CISCO-STACK-MIB::tokenRingDripRemotePortStatus',
  tokenRingDripRemotePortConfigured => '1.3.6.1.4.1.9.5.1.11.12.1.4',
  tokenRingDripRemotePortConfiguredDefinition => 'CISCO-STACK-MIB::tokenRingDripRemotePortConfigured',
  tokenRingDripDistributedCrf => '1.3.6.1.4.1.9.5.1.11.12.1.5',
  tokenRingDripDistributedCrfDefinition => 'CISCO-STACK-MIB::tokenRingDripDistributedCrf',
  tokenRingDripBackupCrf => '1.3.6.1.4.1.9.5.1.11.12.1.6',
  tokenRingDripBackupCrfDefinition => 'CISCO-STACK-MIB::tokenRingDripBackupCrf',
  tokenRingDripOwnerNodeID => '1.3.6.1.4.1.9.5.1.11.12.1.7',
  tokenRingPortSoftErrTable => '1.3.6.1.4.1.9.5.1.11.14',
  tokenRingPortSoftErrEntry => '1.3.6.1.4.1.9.5.1.11.14.1',
  tokenRingPortSoftErrThresh => '1.3.6.1.4.1.9.5.1.11.14.1.1',
  tokenRingPortSoftErrReportInterval => '1.3.6.1.4.1.9.5.1.11.14.1.2',
  tokenRingPortSoftErrResetCounters => '1.3.6.1.4.1.9.5.1.11.14.1.3',
  tokenRingPortSoftErrResetCountersDefinition => 'CISCO-STACK-MIB::tokenRingPortSoftErrResetCounters',
  tokenRingPortSoftErrLastCounterReset => '1.3.6.1.4.1.9.5.1.11.14.1.4',
  tokenRingPortSoftErrEnable => '1.3.6.1.4.1.9.5.1.11.14.1.5',
  tokenRingPortSoftErrEnableDefinition => 'CISCO-STACK-MIB::tokenRingPortSoftErrEnable',
  multicastGrp => '1.3.6.1.4.1.9.5.1.12',
  mcastRouterTable => '1.3.6.1.4.1.9.5.1.12.1',
  mcastRouterEntry => '1.3.6.1.4.1.9.5.1.12.1.1',
  mcastRouterModuleIndex => '1.3.6.1.4.1.9.5.1.12.1.1.1',
  mcastRouterPortIndex => '1.3.6.1.4.1.9.5.1.12.1.1.2',
  mcastRouterAdminStatus => '1.3.6.1.4.1.9.5.1.12.1.1.3',
  mcastRouterAdminStatusDefinition => 'CISCO-STACK-MIB::mcastRouterAdminStatus',
  mcastRouterOperStatus => '1.3.6.1.4.1.9.5.1.12.1.1.4',
  mcastRouterOperStatusDefinition => 'CISCO-STACK-MIB::mcastRouterOperStatus',
  mcastEnableCgmp => '1.3.6.1.4.1.9.5.1.12.2',
  mcastEnableCgmpDefinition => 'CISCO-STACK-MIB::mcastEnableCgmp',
  mcastEnableIgmp => '1.3.6.1.4.1.9.5.1.12.3',
  mcastEnableIgmpDefinition => 'CISCO-STACK-MIB::mcastEnableIgmp',
  mcastEnableRgmp => '1.3.6.1.4.1.9.5.1.12.4',
  mcastEnableRgmpDefinition => 'CISCO-STACK-MIB::mcastEnableRgmp',
  dnsGrp => '1.3.6.1.4.1.9.5.1.13',
  dnsEnable => '1.3.6.1.4.1.9.5.1.13.1',
  dnsEnableDefinition => 'CISCO-STACK-MIB::dnsEnable',
  dnsServerTable => '1.3.6.1.4.1.9.5.1.13.2',
  dnsServerEntry => '1.3.6.1.4.1.9.5.1.13.2.1',
  dnsServerAddr => '1.3.6.1.4.1.9.5.1.13.2.1.1',
  dnsServerType => '1.3.6.1.4.1.9.5.1.13.2.1.2',
  dnsServerTypeDefinition => 'CISCO-STACK-MIB::dnsServerType',
  dnsDomainName => '1.3.6.1.4.1.9.5.1.13.3',
  syslogGrp => '1.3.6.1.4.1.9.5.1.14',
  syslogServerTable => '1.3.6.1.4.1.9.5.1.14.1',
  syslogServerEntry => '1.3.6.1.4.1.9.5.1.14.1.1',
  syslogServerAddr => '1.3.6.1.4.1.9.5.1.14.1.1.1',
  syslogServerType => '1.3.6.1.4.1.9.5.1.14.1.1.2',
  syslogServerTypeDefinition => 'CISCO-STACK-MIB::syslogServerType',
  syslogConsoleEnable => '1.3.6.1.4.1.9.5.1.14.2',
  syslogConsoleEnableDefinition => 'CISCO-STACK-MIB::syslogConsoleEnable',
  syslogHostEnable => '1.3.6.1.4.1.9.5.1.14.3',
  syslogHostEnableDefinition => 'CISCO-STACK-MIB::syslogHostEnable',
  syslogMessageControlTable => '1.3.6.1.4.1.9.5.1.14.4',
  syslogMessageControlEntry => '1.3.6.1.4.1.9.5.1.14.4.1',
  syslogMessageFacility => '1.3.6.1.4.1.9.5.1.14.4.1.1',
  syslogMessageFacilityDefinition => 'CISCO-STACK-MIB::syslogMessageFacility',
  syslogMessageSeverity => '1.3.6.1.4.1.9.5.1.14.4.1.2',
  syslogMessageSeverityDefinition => 'CISCO-STACK-MIB::syslogMessageSeverity',
  syslogTimeStampOption => '1.3.6.1.4.1.9.5.1.14.5',
  syslogTimeStampOptionDefinition => 'CISCO-STACK-MIB::syslogTimeStampOption',
  syslogTelnetEnable => '1.3.6.1.4.1.9.5.1.14.6',
  syslogTelnetEnableDefinition => 'CISCO-STACK-MIB::syslogTelnetEnable',
  ntpGrp => '1.3.6.1.4.1.9.5.1.15',
  ntpBcastClient => '1.3.6.1.4.1.9.5.1.15.1',
  ntpBcastClientDefinition => 'CISCO-STACK-MIB::ntpBcastClient',
  ntpBcastDelay => '1.3.6.1.4.1.9.5.1.15.2',
  ntpClient => '1.3.6.1.4.1.9.5.1.15.3',
  ntpClientDefinition => 'CISCO-STACK-MIB::ntpClient',
  ntpServerTable => '1.3.6.1.4.1.9.5.1.15.4',
  ntpServerEntry => '1.3.6.1.4.1.9.5.1.15.4.1',
  ntpServerAddress => '1.3.6.1.4.1.9.5.1.15.4.1.1',
  ntpServerType => '1.3.6.1.4.1.9.5.1.15.4.1.2',
  ntpServerTypeDefinition => 'CISCO-STACK-MIB::ntpServerType',
  ntpServerPublicKey => '1.3.6.1.4.1.9.5.1.15.4.1.3',
  ntpSummertimeStatus => '1.3.6.1.4.1.9.5.1.15.5',
  ntpSummertimeStatusDefinition => 'CISCO-STACK-MIB::ntpSummertimeStatus',
  ntpSummerTimezoneName => '1.3.6.1.4.1.9.5.1.15.6',
  ntpTimezoneName => '1.3.6.1.4.1.9.5.1.15.7',
  ntpTimezoneOffsetHour => '1.3.6.1.4.1.9.5.1.15.8',
  ntpTimezoneOffsetMinute => '1.3.6.1.4.1.9.5.1.15.9',
  ntpAuthenticationEnable => '1.3.6.1.4.1.9.5.1.15.10',
  ntpAuthenticationEnableDefinition => 'CISCO-STACK-MIB::ntpAuthenticationEnable',
  ntpAuthenticationTable => '1.3.6.1.4.1.9.5.1.15.11',
  ntpAuthenticationEntry => '1.3.6.1.4.1.9.5.1.15.11.1',
  ntpAuthenticationPublicKey => '1.3.6.1.4.1.9.5.1.15.11.1.1',
  ntpAuthenticationSecretKey => '1.3.6.1.4.1.9.5.1.15.11.1.2',
  ntpAuthenticationTrustedMode => '1.3.6.1.4.1.9.5.1.15.11.1.3',
  ntpAuthenticationTrustedModeDefinition => 'CISCO-STACK-MIB::ntpAuthenticationTrustedMode',
  ntpAuthenticationType => '1.3.6.1.4.1.9.5.1.15.11.1.4',
  ntpAuthenticationTypeDefinition => 'CISCO-STACK-MIB::ntpAuthenticationType',
  tacacsGrp => '1.3.6.1.4.1.9.5.1.16',
  tacacsLoginAuthentication => '1.3.6.1.4.1.9.5.1.16.1',
  tacacsLoginAuthenticationDefinition => 'CISCO-STACK-MIB::tacacsLoginAuthentication',
  tacacsEnableAuthentication => '1.3.6.1.4.1.9.5.1.16.2',
  tacacsEnableAuthenticationDefinition => 'CISCO-STACK-MIB::tacacsEnableAuthentication',
  tacacsLocalLoginAuthentication => '1.3.6.1.4.1.9.5.1.16.3',
  tacacsLocalLoginAuthenticationDefinition => 'CISCO-STACK-MIB::tacacsLocalLoginAuthentication',
  tacacsLocalEnableAuthentication => '1.3.6.1.4.1.9.5.1.16.4',
  tacacsLocalEnableAuthenticationDefinition => 'CISCO-STACK-MIB::tacacsLocalEnableAuthentication',
  tacacsNumLoginAttempts => '1.3.6.1.4.1.9.5.1.16.5',
  tacacsDirectedRequest => '1.3.6.1.4.1.9.5.1.16.6',
  tacacsDirectedRequestDefinition => 'CISCO-STACK-MIB::tacacsDirectedRequest',
  tacacsTimeout => '1.3.6.1.4.1.9.5.1.16.7',
  tacacsAuthKey => '1.3.6.1.4.1.9.5.1.16.8',
  tacacsServerTable => '1.3.6.1.4.1.9.5.1.16.9',
  tacacsServerEntry => '1.3.6.1.4.1.9.5.1.16.9.1',
  tacacsServerAddr => '1.3.6.1.4.1.9.5.1.16.9.1.1',
  tacacsServerType => '1.3.6.1.4.1.9.5.1.16.9.1.2',
  tacacsServerTypeDefinition => 'CISCO-STACK-MIB::tacacsServerType',
  ipPermitListGrp => '1.3.6.1.4.1.9.5.1.17',
  ipPermitEnable => '1.3.6.1.4.1.9.5.1.17.1',
  ipPermitEnableDefinition => 'CISCO-STACK-MIB::ipPermitEnable',
  ipPermitListTable => '1.3.6.1.4.1.9.5.1.17.2',
  ipPermitListEntry => '1.3.6.1.4.1.9.5.1.17.2.1',
  ipPermitAddress => '1.3.6.1.4.1.9.5.1.17.2.1.1',
  ipPermitMask => '1.3.6.1.4.1.9.5.1.17.2.1.2',
  ipPermitType => '1.3.6.1.4.1.9.5.1.17.2.1.3',
  ipPermitTypeDefinition => 'CISCO-STACK-MIB::ipPermitType',
  ipPermitAccessType => '1.3.6.1.4.1.9.5.1.17.2.1.4',
  ipPermitTelnetConnectLimit => '1.3.6.1.4.1.9.5.1.17.2.1.5',
  ipPermitSshConnectLimit => '1.3.6.1.4.1.9.5.1.17.2.1.6',
  ipPermitDeniedListTable => '1.3.6.1.4.1.9.5.1.17.3',
  ipPermitDeniedListEntry => '1.3.6.1.4.1.9.5.1.17.3.1',
  ipPermitDeniedAddress => '1.3.6.1.4.1.9.5.1.17.3.1.1',
  ipPermitDeniedAccess => '1.3.6.1.4.1.9.5.1.17.3.1.2',
  ipPermitDeniedAccessDefinition => 'CISCO-STACK-MIB::ipPermitDeniedAccess',
  ipPermitDeniedTime => '1.3.6.1.4.1.9.5.1.17.3.1.3',
  ipPermitAccessTypeEnable => '1.3.6.1.4.1.9.5.1.17.4',
  portChannelGrp => '1.3.6.1.4.1.9.5.1.18',
  portChannelTable => '1.3.6.1.4.1.9.5.1.18.1',
  portChannelEntry => '1.3.6.1.4.1.9.5.1.18.1.1',
  portChannelModuleIndex => '1.3.6.1.4.1.9.5.1.18.1.1.1',
  portChannelPortIndex => '1.3.6.1.4.1.9.5.1.18.1.1.2',
  portChannelPorts => '1.3.6.1.4.1.9.5.1.18.1.1.3',
  portChannelAdminStatus => '1.3.6.1.4.1.9.5.1.18.1.1.4',
  portChannelAdminStatusDefinition => 'CISCO-STACK-MIB::portChannelAdminStatus',
  portChannelOperStatus => '1.3.6.1.4.1.9.5.1.18.1.1.5',
  portChannelOperStatusDefinition => 'CISCO-STACK-MIB::portChannelOperStatus',
  portChannelNeighbourDeviceId => '1.3.6.1.4.1.9.5.1.18.1.1.6',
  portChannelNeighbourPortId => '1.3.6.1.4.1.9.5.1.18.1.1.7',
  portChannelProtInPackets => '1.3.6.1.4.1.9.5.1.18.1.1.8',
  portChannelProtOutPackets => '1.3.6.1.4.1.9.5.1.18.1.1.9',
  portChannelIfIndex => '1.3.6.1.4.1.9.5.1.18.1.1.10',
  portCpbGrp => '1.3.6.1.4.1.9.5.1.19',
  portCpbTable => '1.3.6.1.4.1.9.5.1.19.1',
  portCpbEntry => '1.3.6.1.4.1.9.5.1.19.1.1',
  portCpbModuleIndex => '1.3.6.1.4.1.9.5.1.19.1.1.1',
  portCpbPortIndex => '1.3.6.1.4.1.9.5.1.19.1.1.2',
  portCpbSpeed => '1.3.6.1.4.1.9.5.1.19.1.1.3',
  portCpbDuplex => '1.3.6.1.4.1.9.5.1.19.1.1.4',
  portCpbTrunkEncapsulationType => '1.3.6.1.4.1.9.5.1.19.1.1.5',
  portCpbTrunkMode => '1.3.6.1.4.1.9.5.1.19.1.1.6',
  portCpbChannel => '1.3.6.1.4.1.9.5.1.19.1.1.7',
  portCpbBroadcastSuppression => '1.3.6.1.4.1.9.5.1.19.1.1.8',
  portCpbFlowControl => '1.3.6.1.4.1.9.5.1.19.1.1.9',
  portCpbSecurity => '1.3.6.1.4.1.9.5.1.19.1.1.10',
  portCpbSecurityDefinition => 'CISCO-STACK-MIB::portCpbSecurity',
  portCpbVlanMembership => '1.3.6.1.4.1.9.5.1.19.1.1.11',
  portCpbPortfast => '1.3.6.1.4.1.9.5.1.19.1.1.12',
  portCpbPortfastDefinition => 'CISCO-STACK-MIB::portCpbPortfast',
  portCpbUdld => '1.3.6.1.4.1.9.5.1.19.1.1.13',
  portCpbUdldDefinition => 'CISCO-STACK-MIB::portCpbUdld',
  portCpbInlinePower => '1.3.6.1.4.1.9.5.1.19.1.1.14',
  portCpbAuxiliaryVlan => '1.3.6.1.4.1.9.5.1.19.1.1.15',
  portCpbSpan => '1.3.6.1.4.1.9.5.1.19.1.1.16',
  portCpbCosRewrite => '1.3.6.1.4.1.9.5.1.19.1.1.17',
  portCpbCosRewriteDefinition => 'CISCO-STACK-MIB::portCpbCosRewrite',
  portCpbTosRewrite => '1.3.6.1.4.1.9.5.1.19.1.1.18',
  portCpbCopsGrouping => '1.3.6.1.4.1.9.5.1.19.1.1.19',
  portCpbDot1x => '1.3.6.1.4.1.9.5.1.19.1.1.20',
  portCpbDot1xDefinition => 'CISCO-STACK-MIB::portCpbDot1x',
  portCpbIgmpFilter => '1.3.6.1.4.1.9.5.1.19.1.1.21',
  portCpbIgmpFilterDefinition => 'CISCO-STACK-MIB::portCpbIgmpFilter',
  portTopNGrp => '1.3.6.1.4.1.9.5.1.20',
  portTopNControlTable => '1.3.6.1.4.1.9.5.1.20.1',
  portTopNControlEntry => '1.3.6.1.4.1.9.5.1.20.1.1',
  portTopNControlIndex => '1.3.6.1.4.1.9.5.1.20.1.1.1',
  portTopNRateBase => '1.3.6.1.4.1.9.5.1.20.1.1.2',
  portTopNRateBaseDefinition => 'CISCO-STACK-MIB::portTopNRateBase',
  portTopNType => '1.3.6.1.4.1.9.5.1.20.1.1.3',
  portTopNTypeDefinition => 'CISCO-STACK-MIB::portTopNType',
  portTopNMode => '1.3.6.1.4.1.9.5.1.20.1.1.4',
  portTopNModeDefinition => 'CISCO-STACK-MIB::portTopNMode',
  portTopNReportStatus => '1.3.6.1.4.1.9.5.1.20.1.1.5',
  portTopNReportStatusDefinition => 'CISCO-STACK-MIB::portTopNReportStatus',
  portTopNDuration => '1.3.6.1.4.1.9.5.1.20.1.1.6',
  portTopNTimeRemaining => '1.3.6.1.4.1.9.5.1.20.1.1.7',
  portTopNStartTime => '1.3.6.1.4.1.9.5.1.20.1.1.8',
  portTopNRequestedSize => '1.3.6.1.4.1.9.5.1.20.1.1.9',
  portTopNGrantedSize => '1.3.6.1.4.1.9.5.1.20.1.1.10',
  portTopNOwner => '1.3.6.1.4.1.9.5.1.20.1.1.11',
  portTopNStatus => '1.3.6.1.4.1.9.5.1.20.1.1.12',
  portTopNTable => '1.3.6.1.4.1.9.5.1.20.2',
  portTopNEntry => '1.3.6.1.4.1.9.5.1.20.2.1',
  portTopNIndex => '1.3.6.1.4.1.9.5.1.20.2.1.1',
  portTopNModuleNumber => '1.3.6.1.4.1.9.5.1.20.2.1.2',
  portTopNPortNumber => '1.3.6.1.4.1.9.5.1.20.2.1.3',
  portTopNUtilization => '1.3.6.1.4.1.9.5.1.20.2.1.4',
  portTopNIOOctets => '1.3.6.1.4.1.9.5.1.20.2.1.5',
  portTopNIOPkts => '1.3.6.1.4.1.9.5.1.20.2.1.6',
  portTopNIOBroadcast => '1.3.6.1.4.1.9.5.1.20.2.1.7',
  portTopNIOMulticast => '1.3.6.1.4.1.9.5.1.20.2.1.8',
  portTopNInErrors => '1.3.6.1.4.1.9.5.1.20.2.1.9',
  portTopNBufferOverFlow => '1.3.6.1.4.1.9.5.1.20.2.1.10',
  mdgGrp => '1.3.6.1.4.1.9.5.1.21',
  mdgGatewayTable => '1.3.6.1.4.1.9.5.1.21.1',
  mdgGatewayEntry => '1.3.6.1.4.1.9.5.1.21.1.1',
  mdgGatewayAddr => '1.3.6.1.4.1.9.5.1.21.1.1.1',
  mdgGatewayType => '1.3.6.1.4.1.9.5.1.21.1.1.2',
  mdgGatewayTypeDefinition => 'CISCO-STACK-MIB::mdgGatewayType',
  radiusGrp => '1.3.6.1.4.1.9.5.1.22',
  radiusLoginAuthentication => '1.3.6.1.4.1.9.5.1.22.1',
  radiusLoginAuthenticationDefinition => 'CISCO-STACK-MIB::radiusLoginAuthentication',
  radiusEnableAuthentication => '1.3.6.1.4.1.9.5.1.22.2',
  radiusEnableAuthenticationDefinition => 'CISCO-STACK-MIB::radiusEnableAuthentication',
  radiusDeadtime => '1.3.6.1.4.1.9.5.1.22.3',
  radiusAuthKey => '1.3.6.1.4.1.9.5.1.22.4',
  radiusTimeout => '1.3.6.1.4.1.9.5.1.22.5',
  radiusRetransmits => '1.3.6.1.4.1.9.5.1.22.6',
  radiusServerTable => '1.3.6.1.4.1.9.5.1.22.7',
  radiusServerEntry => '1.3.6.1.4.1.9.5.1.22.7.1',
  radiusServerAddr => '1.3.6.1.4.1.9.5.1.22.7.1.1',
  radiusServerAuthPort => '1.3.6.1.4.1.9.5.1.22.7.1.2',
  radiusServerType => '1.3.6.1.4.1.9.5.1.22.7.1.3',
  radiusServerTypeDefinition => 'CISCO-STACK-MIB::radiusServerType',
  traceRouteGrp => '1.3.6.1.4.1.9.5.1.24',
  traceRouteMaxQueries => '1.3.6.1.4.1.9.5.1.24.1',
  traceRouteQueryTable => '1.3.6.1.4.1.9.5.1.24.2',
  traceRouteQueryEntry => '1.3.6.1.4.1.9.5.1.24.2.1',
  traceRouteQueryIndex => '1.3.6.1.4.1.9.5.1.24.2.1.1',
  traceRouteHost => '1.3.6.1.4.1.9.5.1.24.2.1.2',
  traceRouteQueryDNSEnable => '1.3.6.1.4.1.9.5.1.24.2.1.3',
  traceRouteQueryDNSEnableDefinition => 'CISCO-STACK-MIB::traceRouteQueryDNSEnable',
  traceRouteQueryWaitingTime => '1.3.6.1.4.1.9.5.1.24.2.1.4',
  traceRouteQueryInitTTL => '1.3.6.1.4.1.9.5.1.24.2.1.5',
  traceRouteQueryMaxTTL => '1.3.6.1.4.1.9.5.1.24.2.1.6',
  traceRouteQueryUDPPort => '1.3.6.1.4.1.9.5.1.24.2.1.7',
  traceRouteQueryPacketCount => '1.3.6.1.4.1.9.5.1.24.2.1.8',
  traceRouteQueryPacketSize => '1.3.6.1.4.1.9.5.1.24.2.1.9',
  traceRouteQueryTOS => '1.3.6.1.4.1.9.5.1.24.2.1.10',
  traceRouteQueryResult => '1.3.6.1.4.1.9.5.1.24.2.1.21',
  traceRouteQueryTime => '1.3.6.1.4.1.9.5.1.24.2.1.22',
  traceRouteQueryOwner => '1.3.6.1.4.1.9.5.1.24.2.1.23',
  traceRouteQueryStatus => '1.3.6.1.4.1.9.5.1.24.2.1.24',
  traceRouteQueryStatusDefinition => 'CISCO-STACK-MIB::traceRouteQueryStatus',
  traceRouteDataTable => '1.3.6.1.4.1.9.5.1.24.3',
  traceRouteDataEntry => '1.3.6.1.4.1.9.5.1.24.3.1',
  traceRouteDataIndex => '1.3.6.1.4.1.9.5.1.24.3.1.1',
  traceRouteDataGatewayName => '1.3.6.1.4.1.9.5.1.24.3.1.2',
  traceRouteDataGatewayIp => '1.3.6.1.4.1.9.5.1.24.3.1.3',
  traceRouteDataRtt => '1.3.6.1.4.1.9.5.1.24.3.1.4',
  traceRouteDataHopCount => '1.3.6.1.4.1.9.5.1.24.3.1.5',
  traceRouteDataErrors => '1.3.6.1.4.1.9.5.1.24.3.1.6',
  traceRouteDataErrorsDefinition => 'CISCO-STACK-MIB::traceRouteDataErrors',
  fileCopyGrp => '1.3.6.1.4.1.9.5.1.25',
  fileCopyProtocol => '1.3.6.1.4.1.9.5.1.25.1',
  fileCopyProtocolDefinition => 'CISCO-STACK-MIB::fileCopyProtocol',
  fileCopyRemoteServer => '1.3.6.1.4.1.9.5.1.25.2',
  fileCopySrcFileName => '1.3.6.1.4.1.9.5.1.25.3',
  fileCopyDstFileName => '1.3.6.1.4.1.9.5.1.25.4',
  fileCopyModuleNumber => '1.3.6.1.4.1.9.5.1.25.5',
  fileCopyUserName => '1.3.6.1.4.1.9.5.1.25.6',
  fileCopyAction => '1.3.6.1.4.1.9.5.1.25.7',
  fileCopyActionDefinition => 'CISCO-STACK-MIB::fileCopyAction',
  fileCopyResult => '1.3.6.1.4.1.9.5.1.25.8',
  fileCopyResultDefinition => 'CISCO-STACK-MIB::fileCopyResult',
  fileCopyResultRcpErrorMessage => '1.3.6.1.4.1.9.5.1.25.9',
  fileCopyRuntimeConfigPart => '1.3.6.1.4.1.9.5.1.25.10',
  fileCopyRuntimeConfigPartDefinition => 'CISCO-STACK-MIB::fileCopyRuntimeConfigPart',
  voiceGrp => '1.3.6.1.4.1.9.5.1.26',
  voicePortIfConfigTable => '1.3.6.1.4.1.9.5.1.26.1',
  voicePortIfConfigEntry => '1.3.6.1.4.1.9.5.1.26.1.1',
  voicePortIfConfigModuleIndex => '1.3.6.1.4.1.9.5.1.26.1.1.1',
  voicePortIfConfigPortIndex => '1.3.6.1.4.1.9.5.1.26.1.1.2',
  voicePortIfDHCPEnabled => '1.3.6.1.4.1.9.5.1.26.1.1.3',
  voicePortIfIpAddress => '1.3.6.1.4.1.9.5.1.26.1.1.4',
  voicePortIfIpNetMask => '1.3.6.1.4.1.9.5.1.26.1.1.5',
  voicePortIfTftpServerAddress => '1.3.6.1.4.1.9.5.1.26.1.1.6',
  voicePortIfGatewayAddress => '1.3.6.1.4.1.9.5.1.26.1.1.7',
  voicePortIfDnsServerAddress => '1.3.6.1.4.1.9.5.1.26.1.1.8',
  voicePortIfDnsDomain => '1.3.6.1.4.1.9.5.1.26.1.1.9',
  voicePortIfOperDnsDomain => '1.3.6.1.4.1.9.5.1.26.1.1.10',
  voicePortCallManagerTable => '1.3.6.1.4.1.9.5.1.26.2',
  voicePortCallManagerEntry => '1.3.6.1.4.1.9.5.1.26.2.1',
  voicePortModuleIndex => '1.3.6.1.4.1.9.5.1.26.2.1.1',
  voicePortIndex => '1.3.6.1.4.1.9.5.1.26.2.1.2',
  voicePortCallManagerIndex => '1.3.6.1.4.1.9.5.1.26.2.1.3',
  voicePortCallManagerIpAddr => '1.3.6.1.4.1.9.5.1.26.2.1.4',
  voicePortOperDnsServerTable => '1.3.6.1.4.1.9.5.1.26.3',
  voicePortOperDnsServerEntry => '1.3.6.1.4.1.9.5.1.26.3.1',
  voicePortDnsModuleIndex => '1.3.6.1.4.1.9.5.1.26.3.1.1',
  voicePortDnsPortIndex => '1.3.6.1.4.1.9.5.1.26.3.1.2',
  voicePortOperDnsServerIndex => '1.3.6.1.4.1.9.5.1.26.3.1.3',
  voicePortOperDnsServerIpAddr => '1.3.6.1.4.1.9.5.1.26.3.1.4',
  voicePortOperDnsServerSource => '1.3.6.1.4.1.9.5.1.26.3.1.5',
  voicePortOperDnsServerSourceDefinition => 'CISCO-STACK-MIB::voicePortOperDnsServerSource',
  portJumboFrameGrp => '1.3.6.1.4.1.9.5.1.27',
  portJumboFrameTable => '1.3.6.1.4.1.9.5.1.27.1',
  portJumboFrameEntry => '1.3.6.1.4.1.9.5.1.27.1.1',
  portJumboFrameModuleIndex => '1.3.6.1.4.1.9.5.1.27.1.1.1',
  portJumboFramePortIndex => '1.3.6.1.4.1.9.5.1.27.1.1.2',
  portJumboFrameEnable => '1.3.6.1.4.1.9.5.1.27.1.1.3',
  portJumboFrameEnableDefinition => 'CISCO-STACK-MIB::portJumboFrameEnable',
  switchAccelerationGrp => '1.3.6.1.4.1.9.5.1.28',
  switchAccelerationModuleTable => '1.3.6.1.4.1.9.5.1.28.1',
  switchAccelerationModuleEntry => '1.3.6.1.4.1.9.5.1.28.1.1',
  switchAccelerationModuleIndex => '1.3.6.1.4.1.9.5.1.28.1.1.1',
  switchAccelerationModuleEnable => '1.3.6.1.4.1.9.5.1.28.1.1.2',
  configGrp => '1.3.6.1.4.1.9.5.1.29',
  configMode => '1.3.6.1.4.1.9.5.1.29.1',
  configModeDefinition => 'CISCO-STACK-MIB::configMode',
  configTextFileLocation => '1.3.6.1.4.1.9.5.1.29.2',
  configWriteMem => '1.3.6.1.4.1.9.5.1.29.3',
  configWriteMemStatus => '1.3.6.1.4.1.9.5.1.29.4',
  configWriteMemStatusDefinition => 'CISCO-STACK-MIB::configWriteMemStatus',
  ciscoStackMIBConformance => '1.3.6.1.4.1.9.5.1.31',
  ciscoStackMIBCompliances => '1.3.6.1.4.1.9.5.1.31.1',
  ciscoStackMIBGroups => '1.3.6.1.4.1.9.5.1.31.2',
  adapterCard => '1.3.6.1.4.1.9.5.2',
  wsc1000sysID => '1.3.6.1.4.1.9.5.3',
  wsc1100sysID => '1.3.6.1.4.1.9.5.4',
  wsc1200sysID => '1.3.6.1.4.1.9.5.5',
  wsc1400sysID => '1.3.6.1.4.1.9.5.6',
  wsc5000sysID => '1.3.6.1.4.1.9.5.7',
  wsc1600sysID => '1.3.6.1.4.1.9.5.8',
  cpw1600sysID => '1.3.6.1.4.1.9.5.9',
  wsc3000sysID => '1.3.6.1.4.1.9.5.10',
  wsc2900sysID => '1.3.6.1.4.1.9.5.12',
  cpw2200sysID => '1.3.6.1.4.1.9.5.13',
  esStack => '1.3.6.1.4.1.9.5.14',
  wsc3200sysID => '1.3.6.1.4.1.9.5.15',
  cpw1900sysID => '1.3.6.1.4.1.9.5.16',
  wsc5500sysID => '1.3.6.1.4.1.9.5.17',
  wsc1900sysID => '1.3.6.1.4.1.9.5.18',
  cpw1220sysID => '1.3.6.1.4.1.9.5.19',
  wsc2820sysID => '1.3.6.1.4.1.9.5.20',
  cpw1420sysID => '1.3.6.1.4.1.9.5.21',
  dcd => '1.3.6.1.4.1.9.5.22',
  wsc3100sysID => '1.3.6.1.4.1.9.5.23',
  cpw1800sysID => '1.3.6.1.4.1.9.5.24',
  cpw1601sysID => '1.3.6.1.4.1.9.5.25',
  wsc3001sysID => '1.3.6.1.4.1.9.5.26',
  cpw1220csysID => '1.3.6.1.4.1.9.5.27',
  wsc1900csysID => '1.3.6.1.4.1.9.5.28',
  wsc5002sysID => '1.3.6.1.4.1.9.5.29',
  cpw1220isysID => '1.3.6.1.4.1.9.5.30',
  wsc1900isysID => '1.3.6.1.4.1.9.5.31',
  tsStack => '1.3.6.1.4.1.9.5.32',
  wsc3900sysID => '1.3.6.1.4.1.9.5.33',
  wsc5505sysID => '1.3.6.1.4.1.9.5.34',
  wsc2926sysID => '1.3.6.1.4.1.9.5.35',
  wsc5509sysID => '1.3.6.1.4.1.9.5.36',
  wsc3920sysID => '1.3.6.1.4.1.9.5.37',
  wsc6006sysID => '1.3.6.1.4.1.9.5.38',
  wsc6009sysID => '1.3.6.1.4.1.9.5.39',
  wsc4003sysID => '1.3.6.1.4.1.9.5.40',
  wsc4912gsysID => '1.3.6.1.4.1.9.5.41',
  wsc2948gsysID => '1.3.6.1.4.1.9.5.42',
  wsc6509sysID => '1.3.6.1.4.1.9.5.44',
  wsc6506sysID => '1.3.6.1.4.1.9.5.45',
  wsc4006sysID => '1.3.6.1.4.1.9.5.46',
  wsc6509nebsysID => '1.3.6.1.4.1.9.5.47',
  wsc6knamsysID => '1.3.6.1.4.1.9.5.48',
  wsc2980gsysID => '1.3.6.1.4.1.9.5.49',
  wsc6513sysID => '1.3.6.1.4.1.9.5.50',
  wsc2980gasysID => '1.3.6.1.4.1.9.5.51',
  cisco7603sysID => '1.3.6.1.4.1.9.5.53',
  cisco7606sysID => '1.3.6.1.4.1.9.5.54',
  cisco7609sysID => '1.3.6.1.4.1.9.5.55',
  wsc6503sysID => '1.3.6.1.4.1.9.5.56',
  wsc4503sysID => '1.3.6.1.4.1.9.5.58',
  wsc4506sysID => '1.3.6.1.4.1.9.5.59',
  cisco7613sysID => '1.3.6.1.4.1.9.5.60',
  wsc6509nebasysID => '1.3.6.1.4.1.9.5.61',
  wsc2948ggetxsysID => '1.3.6.1.4.1.9.5.62',
  cisco7604sysID => '1.3.6.1.4.1.9.5.63',
  wsc6504esysID => '1.3.6.1.4.1.9.5.64',
  wsc1900LiteFxsysID => '1.3.6.1.4.1.9.5.175',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-STACK-MIB'} = {
  sysTelnetPrimaryEnableAuthentication => {
    '1' => 'tacacs',
    '2' => 'radius',
    '3' => 'local',
  },
  sysPortFastBpduGuard => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  brouterEnableGiantCheck => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  vlanTrunkMappingType => {
    '1' => 'reservedToNonReserved',
    '2' => 'dot1qToisl',
  },
  brouterEnableFddiCheck => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  filterMacType => {
    '1' => 'deny',
    '2' => 'invalid',
    '3' => 'permit',
    '4' => 'permitSrc',
    '5' => 'permitDst',
    '6' => 'denySrc',
    '7' => 'denyDst',
    '8' => 'denySrcLearn',
  },
  radiusServerType => {
    '1' => 'invalid',
    '2' => 'primary',
    '3' => 'other',
  },
  tacacsServerType => {
    '1' => 'invalid',
    '2' => 'primary',
    '3' => 'other',
  },
  tftpAction => {
    '1' => 'other',
    '2' => 'downloadConfig',
    '3' => 'uploadConfig',
    '4' => 'downloadSw',
    '5' => 'uploadSw',
    '6' => 'downloadFw',
    '7' => 'uploadFw',
  },
  configMode => {
    '1' => 'binary',
    '2' => 'text',
  },
  sysEnableConfigTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  ipPermitEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForSnmpOnly',
  },
  radiusEnableAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  portSecurityViolationPolicy => {
    '1' => 'restrict',
    '2' => 'shutdown',
  },
  brouterEnableUnreachables => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  brouterIpx8023RawToFddi => {
    '1' => 'snap',
    '5' => 'iso8022',
    '6' => 'fddiRaw',
  },
  sysExtendedRmonNetflowEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  brouterEnableSpantree => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portTopNRateBase => {
    '1' => 'portTopNUtilization',
    '2' => 'portTopNIOOctets',
    '3' => 'portTopNIOPkts',
    '4' => 'portTopNIOBroadcastPkts',
    '5' => 'portTopNIOMulticastPkts',
    '6' => 'portTopNInErrors',
    '7' => 'portTopNBufferOverflow',
  },
  brouterEnableIpFragmentation => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  mcastRouterAdminStatus => {
    '1' => 'routerPresent',
    '3' => 'dynamic',
  },
  filterVendorType => {
    '1' => 'deny',
    '2' => 'invalid',
    '3' => 'permit',
  },
  traceRouteQueryDNSEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portTopNReportStatus => {
    '1' => 'progressing',
    '2' => 'ready',
  },
  syslogMessageFacility => {
    '1' => 'cdp',
    '2' => 'mcast',
    '3' => 'dtp',
    '4' => 'dvlan',
    '5' => 'earl',
    '6' => 'fddi',
    '7' => 'ip',
    '8' => 'pruning',
    '9' => 'snmp',
    '10' => 'spantree',
    '11' => 'system',
    '12' => 'tac',
    '13' => 'tcp',
    '14' => 'telnet',
    '15' => 'tftp',
    '16' => 'vtp',
    '17' => 'vmps',
    '18' => 'kernel',
    '19' => 'filesys',
    '20' => 'drip',
    '21' => 'pagp',
    '22' => 'mgmt',
    '23' => 'mls',
    '24' => 'protfilt',
    '25' => 'security',
    '26' => 'radius',
    '27' => 'udld',
    '28' => 'gvrp',
    '29' => 'cops',
    '30' => 'qos',
    '31' => 'acl',
    '32' => 'rsvp',
    '33' => 'ld',
    '34' => 'privatevlan',
    '35' => 'ethc',
    '36' => 'gl2pt',
    '37' => 'callhome',
    '38' => 'dhcpsnooping',
    '40' => 'diags',
    '42' => 'eou',
    '43' => 'backup',
    '44' => 'eoam',
    '45' => 'webauth',
    '46' => 'dom',
    '47' => 'mvrp',
  },
  portSecurityExtControlStatus => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  chassisPs3Type => {
    '1' => 'other',
    '2' => 'none',
    '25' => 'wsx4008',
    '32' => 'wsx4008dc',
    '42' => 'wsx4008ac650w',
    '43' => 'wsx4008dc650w',
  },
  tacacsDirectedRequest => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  tacacsEnableAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  tacacsLocalEnableAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  chassisPs3Status => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  tacacsLocalLoginAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  filterTestType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  mcastEnableCgmp => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysConsolePrimaryLoginAuthentication => {
    '1' => 'tacacs',
    '2' => 'radius',
    '3' => 'local',
  },
  sysInsertMode => {
    '1' => 'other',
    '2' => 'standard',
    '3' => 'scheduled',
    '4' => 'graceful',
  },
  sysStartupConfigSource => {
    '1' => 'flashFileRecurring',
    '2' => 'flashFileNonRecurring',
  },
  ntpAuthenticationTrustedMode => {
    '1' => 'trusted',
    '2' => 'untrusted',
  },
  vlanPortIslOperStatus => {
    '1' => 'trunking',
    '2' => 'notTrunking',
  },
  sysExtendedRmonVlanAgentEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysEnableEntityTrap => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  ntpAuthenticationType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  sysTelnetPrimaryLoginAuthentication => {
    '1' => 'tacacs',
    '2' => 'radius',
    '3' => 'local',
  },
  portCpbPortfast => {
    '1' => 'yes',
    '2' => 'no',
  },
  sysEnableModem => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  vmpsAction => {
    '1' => 'other',
    '2' => 'inProgress',
    '3' => 'success',
    '4' => 'noResponse',
    '5' => 'noPrimaryVmps',
    '6' => 'noDynamicPort',
    '7' => 'noHostConnected',
    '8' => 'reconfirm',
  },
  syslogTimeStampOption => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portLinkFaultStatus => {
    '1' => 'noFault',
    '2' => 'nearEndFault',
    '3' => 'nearEndConfigFail',
    '4' => 'farEndDisable',
    '5' => 'farEndFault',
    '6' => 'farEndConfigFail',
    '7' => 'notApplicable',
  },
  syslogTelnetEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  filterPortSuppressionViolation => {
    '1' => 'dropPackets',
    '2' => 'errdisable',
  },
  tftpResult => {
    '1' => 'inProgress',
    '2' => 'success',
    '3' => 'noResponse',
    '4' => 'tooManyRetries',
    '5' => 'noBuffers',
    '6' => 'noProcesses',
    '7' => 'badChecksum',
    '8' => 'badLength',
    '9' => 'badFlash',
    '10' => 'serverError',
    '11' => 'userCanceled',
    '12' => 'wrongCode',
    '13' => 'fileNotFound',
    '14' => 'invalidTftpHost',
    '15' => 'invalidTftpModule',
    '16' => 'accessViolation',
    '17' => 'unknownStatus',
    '18' => 'invalidStorageDevice',
    '19' => 'insufficientSpaceOnStorageDevice',
    '20' => 'insufficientDramSize',
    '21' => 'incompatibleImage',
  },
  ipPermitDeniedAccess => {
    '1' => 'telnet',
    '2' => 'snmp',
    '3' => 'ssh',
    '4' => 'http',
  },
  tokenRingPortSetACbits => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portAdminTxFlowControl => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'desired',
  },
  chassisBkplType => {
    '1' => 'other',
    '2' => 'fddi',
    '3' => 'fddiEthernet',
    '4' => 'giga',
    '5' => 'giga3',
    '6' => 'giga3E',
    '7' => 'giga12',
    '8' => 'giga16',
    '9' => 'giga40',
  },
  portSecurityOperStatus => {
    '1' => 'notShutdown',
    '2' => 'shutdown',
  },
  brouterCamMode => {
    '1' => 'filtering',
    '2' => 'forwarding',
  },
  tokenRingPortEarlyTokenRel => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysEnableModuleTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  chassisFanStatus => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  ipPermitType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  vmpsType => {
    '1' => 'invalid',
    '2' => 'primary',
    '3' => 'other',
  },
  chassisPs1Type => {
    '1' => 'other',
    '2' => 'none',
    '3' => 'w50',
    '4' => 'w200',
    '5' => 'w600',
    '6' => 'w80',
    '7' => 'w130',
    '8' => 'wsc5008',
    '9' => 'wsc5008a',
    '10' => 'w175',
    '11' => 'wsc5068',
    '12' => 'wsc5508',
    '13' => 'wsc5568',
    '14' => 'wsc5508a',
    '15' => 'w155',
    '16' => 'w175pfc',
    '17' => 'w175dc',
    '18' => 'wsc5008b',
    '19' => 'wsc5008c',
    '20' => 'wsc5068b',
    '21' => 'wscac1000',
    '22' => 'wscac1300',
    '23' => 'wscdc1000',
    '24' => 'wscdc1360',
    '25' => 'wsx4008',
    '26' => 'wsc5518',
    '27' => 'wsc5598',
    '28' => 'w120',
    '29' => 'externalPS',
    '30' => 'wscac2500w',
    '31' => 'wscdc2500w',
    '32' => 'wsx4008dc',
    '33' => 'wscac4000w',
    '34' => 'pwr4000dc',
    '35' => 'pwr950ac',
    '36' => 'pwr950dc',
    '37' => 'pwr1900ac',
    '38' => 'pwr1900dc',
    '39' => 'pwr1900ac6',
    '42' => 'wsx4008ac650w',
    '43' => 'wsx4008dc650w',
    '44' => 'wscac3000w',
    '46' => 'pwrc451000ac',
    '47' => 'pwrc452800acv',
    '48' => 'pwrc451300acv',
    '49' => 'pwrc451400dcp',
    '50' => 'wscdc3000w',
    '51' => 'pwr1400ac',
    '52' => 'w156',
    '53' => 'wscac6000w',
    '54' => 'pwr2700ac',
    '55' => 'pwr2700dc',
    '58' => 'wscac8700we',
    '59' => 'pwr2700ac4',
    '60' => 'pwr2700dc4',
    '63' => 'pwr400dc',
    '64' => 'pwr400ac',
    '105' => 'pwr6000dc',
    '106' => 'pwr1500dc',
    '150' => 'c6880x3kwac',
    '151' => 'c6880x3kwdc',
    '152' => 'c6800xl3kwac',
  },
  monitorDirection => {
    '1' => 'transmit',
    '2' => 'receive',
    '3' => 'transmitAndReceive',
  },
  filterProtocolType => {
    '1' => 'deny',
    '2' => 'invalid',
    '3' => 'permit',
  },
  tokenRingDripBackupCrf => {
    '1' => 'true',
    '2' => 'false',
  },
  chassisPs2Type => {
    '1' => 'other',
    '2' => 'none',
    '3' => 'w50',
    '4' => 'w200',
    '5' => 'w600',
    '6' => 'w80',
    '7' => 'w130',
    '8' => 'wsc5008',
    '9' => 'wsc5008a',
    '10' => 'w175',
    '11' => 'wsc5068',
    '12' => 'wsc5508',
    '13' => 'wsc5568',
    '14' => 'wsc5508a',
    '15' => 'w155',
    '16' => 'w175pfc',
    '17' => 'w175dc',
    '18' => 'wsc5008b',
    '19' => 'wsc5008c',
    '20' => 'wsc5068b',
    '21' => 'wscac1000',
    '22' => 'wscac1300',
    '23' => 'wscdc1000',
    '24' => 'wscdc1360',
    '25' => 'wsx4008',
    '26' => 'wsc5518',
    '27' => 'wsc5598',
    '28' => 'w120',
    '29' => 'externalPS',
    '30' => 'wscac2500w',
    '31' => 'wscdc2500w',
    '32' => 'wsx4008dc',
    '33' => 'wscac4000w',
    '34' => 'pwr4000dc',
    '35' => 'pwr950ac',
    '36' => 'pwr950dc',
    '37' => 'pwr1900ac',
    '38' => 'pwr1900dc',
    '39' => 'pwr1900ac6',
    '42' => 'wsx4008ac650w',
    '43' => 'wsx4008dc650w',
    '44' => 'wscac3000w',
    '46' => 'pwrc451000ac',
    '47' => 'pwrc452800acv',
    '48' => 'pwrc451300acv',
    '49' => 'pwrc451400dcp',
    '50' => 'wscdc3000w',
    '51' => 'pwr1400ac',
    '52' => 'w156',
    '53' => 'wscac6000w',
    '54' => 'pwr2700ac',
    '55' => 'pwr2700dc',
    '58' => 'wscac8700we',
    '59' => 'pwr2700ac4',
    '60' => 'pwr2700dc4',
    '63' => 'pwr400dc',
    '64' => 'pwr400ac',
    '105' => 'pwr6000dc',
    '106' => 'pwr1500dc',
    '150' => 'c6880x3kwac',
    '151' => 'c6880x3kwdc',
    '152' => 'c6800xl3kwac',
  },
  portChannelOperStatus => {
    '1' => 'channelling',
    '2' => 'notChannelling',
  },
  fileCopyAction => {
    '1' => 'other',
    '2' => 'copyConfigFromHostToRuntime',
    '3' => 'copyConfigFromRuntimeToHost',
    '4' => 'copyImageFromHostToFlash',
    '5' => 'copyImageFromFlashToHost',
    '8' => 'copyConfigFromFlashToRuntime',
    '9' => 'copyConfigFromRuntimeToFlash',
    '10' => 'copyConfigFileFromHostToFlash',
    '11' => 'copyConfigFileFromFlashToHost',
    '12' => 'copyTechReportFromRuntimeToHost',
  },
  ntpAuthenticationEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  moduleSubType2 => {
    '1' => 'other',
    '2' => 'empty',
    '3' => 'wsu5531',
    '5' => 'wsu5533',
    '6' => 'wsu5534',
    '7' => 'wsu5535',
    '8' => 'wsu5536',
    '9' => 'wsu5537',
    '10' => 'wsu5538',
    '11' => 'wsu5539',
    '102' => 'wsg6488',
    '103' => 'wsg6489',
    '104' => 'wsg6483',
    '105' => 'wsg6485',
    '106' => 'wsf6kFe48af',
    '107' => 'wsf6kGe48af',
    '108' => 'wsf6kVpwrGe',
    '109' => 'wsf6kFe48x2af',
    '207' => 'wsf6kmsfc',
    '234' => 'wsf6kmsfc2',
    '314' => 'wsu4504fxmt',
    '315' => 'wsu4502gb',
    '402' => 'wssvcidsupg',
    '403' => 'wssvccmm6e1',
    '404' => 'wssvccmm6t1',
    '405' => 'wssvccmm24fxs',
    '406' => 'wssvccmmact',
    '410' => 'aceModExpnDc',
    '411' => 'wsSvcAppProc1',
    '597' => 'wssvcpisa32',
    '598' => 'me6524msfc2a',
    '599' => 'wsf6kmsfc2a',
    '618' => 'c7600Es4Tg',
    '620' => 'c7600Es2Tg',
    '625' => 'c7600EsItu4TgLk',
    '626' => 'c7600EsItu2TgLk',
    '1001' => 'wssup720',
    '1005' => 'vsf6kmsfc5',
    '1026' => 'vsf6kmsfc3',
    '1701' => 'esm2x10ge',
    '1805' => 'c7600msfc4',
  },
  sysMgmtType => {
    '1' => 'other',
    '2' => 'snmpV1',
    '3' => 'smux',
    '4' => 'snmpV2V1',
    '5' => 'snmpV2cV1',
    '6' => 'snmpV3V2cV1',
  },
  moduleStandbyStatus => {
    '1' => 'other',
    '2' => 'active',
    '3' => 'standby',
    '4' => 'error',
  },
  sysEnableChassisTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  tokenRingDripRemotePortConfigured => {
    '1' => 'true',
    '2' => 'false',
  },
  portChannelAdminStatus => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'desirable',
    '4' => 'auto',
    '5' => 'desirableSilent',
    '6' => 'autoSilent',
  },
  brouterIpxSnapToEther => {
    '1' => 'snap',
    '2' => 'ethernetII',
    '3' => 'iso8023',
    '4' => 'raw8023',
  },
  chassisMajorAlarm => {
    '1' => 'off',
    '2' => 'on',
  },
  brouterEnableRip => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portCpbCosRewrite => {
    '1' => 'yes',
    '2' => 'no',
  },
  radiusLoginAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  tokenRingDripAreReductionMode => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  mcastEnableIgmp => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysEnableRmon => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  moduleAction => {
    '1' => 'other',
    '2' => 'reset',
    '3' => 'enable',
    '4' => 'disable',
  },
  fileCopyRuntimeConfigPart => {
    '1' => 'all',
    '2' => 'nonDefault',
  },
  sysEnableRedirects => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portCpbSecurity => {
    '1' => 'yes',
    '2' => 'no',
  },
  ntpClient => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  dnsEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysStandbyPortEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  dnsServerType => {
    '1' => 'invalid',
    '2' => 'primary',
    '3' => 'other',
  },
  portTopNType => {
    '1' => 'portTopNAllPorts',
    '2' => 'portTopNEthernet',
    '3' => 'portTopNFastEthernet',
    '4' => 'portTopNGigaEthernet',
    '5' => 'portTopNTokenRing',
    '6' => 'portTopNFDDI',
    '7' => 'portTopNAllEthernetPorts',
    '8' => 'portTopN10GigaEthernet',
  },
  sysHighAvailabilityOperStatus => {
    '1' => 'running',
    '2' => 'notRunning',
  },
  portErrDisableTimeOutEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysEnableRepeaterTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portCpbIgmpFilter => {
    '1' => 'yes',
    '2' => 'no',
  },
  chassisTempAlarm => {
    '1' => 'off',
    '2' => 'on',
    '3' => 'critical',
  },
  portCpbUdld => {
    '1' => 'yes',
    '2' => 'no',
  },
  mcastRouterOperStatus => {
    '1' => 'routerPresent',
    '2' => 'noRouter',
  },
  brouterIpx8022ToEther => {
    '1' => 'snap',
    '2' => 'ethernetII',
    '3' => 'iso8023',
    '4' => 'raw8023',
  },
  sysTrafficMeterType => {
    '1' => 'systemSwitchingBus',
    '2' => 'switchingBusA',
    '3' => 'switchingBusB',
    '4' => 'switchingBusC',
  },
  traceRouteQueryStatus => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  fileCopyProtocol => {
    '1' => 'tftp',
    '2' => 'rcp',
  },
  portAdminRxFlowControl => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'desired',
  },
  mdgGatewayType => {
    '1' => 'invalid',
    '2' => 'primary',
    '3' => 'other',
  },
  configWriteMemStatus => {
    '1' => 'inProgress',
    '2' => 'succeeded',
    '3' => 'resourceUnavailable',
    '4' => 'badFileName',
    '5' => 'someOtherError',
  },
  ntpServerType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  sysAttachType => {
    '1' => 'other',
    '2' => 'dualAttach',
    '3' => 'singleAttach',
    '4' => 'nullAttach',
    '5' => 'dualPrio',
  },
  sysCommunityAccess => {
    '1' => 'other',
    '2' => 'readOnly',
    '3' => 'readWrite',
    '4' => 'readWriteAll',
  },
  syslogHostEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysEnableIpPermitTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  vlanPortAdminStatus => {
    '1' => 'static',
    '2' => 'dynamic',
  },
  tokenRingDripDistCrfMode => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  moduleSubType => {
    '1' => 'other',
    '2' => 'empty',
    '3' => 'wsf5510',
    '4' => 'wsf5511',
    '6' => 'wsx5304',
    '7' => 'wsf5520',
    '8' => 'wsf5521',
    '9' => 'wsf5531',
    '100' => 'wsf6020',
    '101' => 'wsf6020a',
    '102' => 'wsf6kpfc',
    '103' => 'wsf6kpfc2',
    '104' => 'wsf6kvpwr',
    '105' => 'wsf6kdfc',
    '106' => 'wsf6kpfc2a',
    '107' => 'wsf6kdfca',
    '200' => 'vsp300dfc',
    '201' => 'wsf6kpfc3a',
    '202' => 'wsf6kdfc3a',
    '203' => 'wsf6700dfc3a',
    '205' => 'wsf6kdfc3bxl',
    '206' => 'wsf6kpfc3bxl',
    '207' => 'wsf6700dfc3bxl',
    '208' => 'wsf6700cfc',
    '213' => 'm7600pfc3c',
    '216' => 'wsf6kpfc3b',
    '217' => 'wsf6700dfc3b',
    '218' => 'wsf6700dfc3c',
    '221' => 'wsf6700dfc3cxl',
    '223' => 'wsf6kdfc3b',
    '224' => 'mec6524pfc3c',
    '225' => 'sip600earl',
    '226' => 'vsf6kpfc3cxl',
    '227' => 'vsf6kpfc3c',
    '228' => 'c7600esmdfc3cxl',
    '229' => 'vsf6kpfc4',
    '230' => 'c7600esmdfc3c',
    '231' => 'wsf6kdfc4exl',
    '232' => 'c7600Es3cxl',
    '233' => 'c7600Es3c',
    '234' => 'wsf6kdfc4e',
    '235' => 'vsf6kpfc4xl',
    '236' => 'wsf6kdfc4axl',
    '237' => 'wsf6kdfc4a',
    '238' => 'c6880xpfc',
    '239' => 'c6880xlepfc',
    '240' => 'c6880xdfc',
    '241' => 'c6880xledfc',
  },
  ntpSummertimeStatus => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  moduleStatus => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  sysEnableStpxTrap => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForInconOnly',
    '4' => 'enabledForRootOnly',
    '5' => 'enabledForLoopOnly',
    '6' => 'enabledForInconRootOnly',
    '7' => 'enabledForInconLoopOnly',
    '8' => 'enabledForRootLoopOnly',
  },
  sysExtendedRmonVlanModeEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portJumboFrameEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  chassisPs2Status => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  vlanPortOperStatus => {
    '1' => 'inactive',
    '2' => 'active',
    '3' => 'shutdown',
    '4' => 'vlanActiveFault',
  },
  sysBaudRate => {
    '600' => 'b600',
    '1200' => 'b1200',
    '2400' => 'b2400',
    '4800' => 'b4800',
    '9600' => 'b9600',
    '19200' => 'b19200',
    '38400' => 'b38400',
  },
  mcastEnableRgmp => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  traceRouteDataErrors => {
    '1' => 'icmpUnreachNet',
    '2' => 'icmpUnreachHost',
    '3' => 'icmpUnreachProtocol',
    '4' => 'icmpUnreachPort',
    '5' => 'icmpUnreachNeedFrag',
    '6' => 'icmpUnreachSrcFail',
    '7' => 'icmpUnreachNoNet',
    '8' => 'icmpUnreachNoHost',
    '9' => 'icmpUnreachHostIsolated',
    '10' => 'icmpUnreachNetProhib',
    '11' => 'icmpUnreachProhib',
    '12' => 'icmpUnreachNetTos',
    '13' => 'icmpUnreachHostTos',
    '14' => 'icmpUnreachAdmin',
    '15' => 'icmpUnreachHostPrec',
    '16' => 'icmpUnreachPrecedence',
    '17' => 'icmpUnknown',
    '18' => 'icmpTimeOut',
    '19' => 'icmpTTLExpired',
  },
  tokenRingDripDistributedCrf => {
    '1' => 'true',
    '2' => 'false',
  },
  vlanPortIslAdminStatus => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'desirable',
    '4' => 'auto',
    '5' => 'onNoNegotiate',
  },
  chassisSysType => {
    '1' => 'other',
    '3' => 'wsc1000',
    '4' => 'wsc1001',
    '5' => 'wsc1100',
    '6' => 'wsc5000',
    '7' => 'wsc2900',
    '8' => 'wsc5500',
    '9' => 'wsc5002',
    '10' => 'wsc5505',
    '11' => 'wsc1200',
    '12' => 'wsc1400',
    '13' => 'wsc2926',
    '14' => 'wsc5509',
    '15' => 'wsc6006',
    '16' => 'wsc6009',
    '17' => 'wsc4003',
    '18' => 'wsc5500e',
    '19' => 'wsc4912g',
    '20' => 'wsc2948g',
    '22' => 'wsc6509',
    '23' => 'wsc6506',
    '24' => 'wsc4006',
    '25' => 'wsc6509NEB',
    '26' => 'wsc2980g',
    '27' => 'wsc6513',
    '28' => 'wsc2980ga',
    '30' => 'cisco7603',
    '31' => 'cisco7606',
    '32' => 'cisco7609',
    '33' => 'wsc6503',
    '34' => 'wsc6509NEBA',
    '35' => 'wsc4507',
    '36' => 'wsc4503',
    '37' => 'wsc4506',
    '38' => 'wsc65509',
    '40' => 'cisco7613',
    '41' => 'wsc2948ggetx',
    '42' => 'cisco7604',
    '43' => 'wsc6504e',
    '45' => 'mec6524gs8s',
    '48' => 'mec6524gt8s',
    '51' => 'wsc6509ve',
    '52' => 'cisco7603s',
    '54' => 'c6880xle',
    '55' => 'c6807xl',
    '56' => 'c6880x',
  },
  ntpBcastClient => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portTopNMode => {
    '1' => 'portTopNForeground',
    '2' => 'portTopNBackground',
  },
  portOperStatus => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  sysStatus => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  vlanSpantreeEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'notApplicable',
  },
  tacacsLoginAuthentication => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForTelnetOnly',
    '4' => 'enabledForConsoleOnly',
  },
  fileCopyResult => {
    '1' => 'inProgress',
    '2' => 'success',
    '3' => 'noResponse',
    '4' => 'tooManyRetries',
    '5' => 'noBuffers',
    '6' => 'noProcesses',
    '7' => 'badChecksum',
    '8' => 'badLength',
    '9' => 'badFlash',
    '10' => 'serverError',
    '11' => 'userCanceled',
    '12' => 'wrongCode',
    '13' => 'fileNotFound',
    '14' => 'invalidHost',
    '15' => 'invalidModule',
    '16' => 'accessViolation',
    '17' => 'unknownStatus',
    '18' => 'invalidStorageDevice',
    '19' => 'insufficientSpaceOnStorageDevice',
    '20' => 'insufficientDramSize',
    '21' => 'incompatibleImage',
    '22' => 'rcpError',
  },
  portOperTxFlowControl => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'disagree',
  },
  voicePortOperDnsServerSource => {
    '1' => 'fromDhcp',
    '2' => 'fromPortConfig',
    '3' => 'fromSystemConfig',
  },
  portSpantreeFastStart => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  brouterEnableAPaRT => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portCpbDot1x => {
    '1' => 'yes',
    '2' => 'no',
  },
  tokenRingPortSoftErrResetCounters => {
    '1' => 'noop',
    '2' => 'reset',
  },
  portType => {
    '1' => 'other',
    '2' => 'cddi',
    '3' => 'fddi',
    '4' => 'tppmd',
    '5' => 'mlt3',
    '6' => 'sddi',
    '7' => 'smf',
    '8' => 'e10BaseT',
    '9' => 'e10BaseF',
    '10' => 'scf',
    '11' => 'e100BaseTX',
    '12' => 'e100BaseT4',
    '13' => 'e100BaseF',
    '14' => 'atmOc3mmf',
    '15' => 'atmOc3smf',
    '16' => 'atmOc3utp',
    '17' => 'e100BaseFsm',
    '18' => 'e10a100BaseTX',
    '19' => 'mii',
    '20' => 'vlanRouter',
    '21' => 'remoteRouter',
    '22' => 'tokenring',
    '23' => 'atmOc12mmf',
    '24' => 'atmOc12smf',
    '25' => 'atmDs3',
    '26' => 'tokenringMmf',
    '27' => 'e1000BaseLX',
    '28' => 'e1000BaseSX',
    '29' => 'e1000BaseCX',
    '30' => 'networkAnalysis',
    '31' => 'e1000Empty',
    '32' => 'e1000BaseLH',
    '33' => 'e1000BaseT',
    '34' => 'e1000UnsupportedGbic',
    '35' => 'e1000BaseZX',
    '36' => 'depi2',
    '37' => 't1',
    '38' => 'e1',
    '39' => 'fxs',
    '40' => 'fxo',
    '41' => 'transcoding',
    '42' => 'conferencing',
    '43' => 'atmOc12mm',
    '44' => 'atmOc12smi',
    '45' => 'atmOc12sml',
    '46' => 'posOc12mm',
    '47' => 'posOc12smi',
    '48' => 'posOc12sml',
    '49' => 'posOc48sms',
    '50' => 'posOc48smi',
    '51' => 'posOc48sml',
    '52' => 'posOc3mm',
    '53' => 'posOc3smi',
    '54' => 'posOc3sml',
    '55' => 'intrusionDetect',
    '56' => 'e10GBaseCPX',
    '57' => 'e10GBaseLX4',
    '59' => 'e10GBaseEX4',
    '60' => 'e10GEmpty',
    '61' => 'e10a100a1000BaseT',
    '62' => 'dptOc48mm',
    '63' => 'dptOc48smi',
    '64' => 'dptOc48sml',
    '65' => 'e10GBaseLR',
    '66' => 'chOc12smi',
    '67' => 'chOc12mm',
    '68' => 'chOc48ss',
    '69' => 'chOc48smi',
    '70' => 'e10GBaseSX4',
    '71' => 'e10GBaseER',
    '72' => 'contentEngine',
    '73' => 'ssl',
    '74' => 'firewall',
    '75' => 'vpnIpSec',
    '76' => 'ct3',
    '77' => 'e1000BaseCwdm1470',
    '78' => 'e1000BaseCwdm1490',
    '79' => 'e1000BaseCwdm1510',
    '80' => 'e1000BaseCwdm1530',
    '81' => 'e1000BaseCwdm1550',
    '82' => 'e1000BaseCwdm1570',
    '83' => 'e1000BaseCwdm1590',
    '84' => 'e1000BaseCwdm1610',
    '85' => 'e1000BaseBT',
    '86' => 'e1000BaseUnapproved',
    '87' => 'chOc3smi',
    '88' => 'mcr',
    '89' => 'coe',
    '90' => 'mwa',
    '91' => 'psd',
    '92' => 'e100BaseLX',
    '93' => 'e10GBaseSR',
    '94' => 'e10GBaseCX4',
    '95' => 'e10GBaseWdm1550',
    '96' => 'e10GBaseEdc1310',
    '97' => 'e10GBaseSW',
    '98' => 'e10GBaseLW',
    '99' => 'e10GBaseEW',
    '100' => 'lwa',
    '101' => 'aons',
    '102' => 'sslVpn',
    '103' => 'e100BaseEmpty',
    '104' => 'adsm',
    '105' => 'agsm',
    '106' => 'aces',
    '109' => 'intrusionProtect',
    '110' => 'e1000BaseSvc',
    '111' => 'e10GBaseSvc',
    '113' => 'e40GBaseEmpty',
    '1000' => 'e1000BaseUnknown',
    '1001' => 'e10GBaseUnknown',
    '1002' => 'e10GBaseUnapproved',
    '1003' => 'e1000BaseWdmRxOnly',
    '1004' => 'e1000BaseDwdm3033',
    '1005' => 'e1000BaseDwdm3112',
    '1006' => 'e1000BaseDwdm3190',
    '1007' => 'e1000BaseDwdm3268',
    '1008' => 'e1000BaseDwdm3425',
    '1009' => 'e1000BaseDwdm3504',
    '1010' => 'e1000BaseDwdm3582',
    '1011' => 'e1000BaseDwdm3661',
    '1012' => 'e1000BaseDwdm3819',
    '1013' => 'e1000BaseDwdm3898',
    '1014' => 'e1000BaseDwdm3977',
    '1015' => 'e1000BaseDwdm4056',
    '1016' => 'e1000BaseDwdm4214',
    '1017' => 'e1000BaseDwdm4294',
    '1018' => 'e1000BaseDwdm4373',
    '1019' => 'e1000BaseDwdm4453',
    '1020' => 'e1000BaseDwdm4612',
    '1021' => 'e1000BaseDwdm4692',
    '1022' => 'e1000BaseDwdm4772',
    '1023' => 'e1000BaseDwdm4851',
    '1024' => 'e1000BaseDwdm5012',
    '1025' => 'e1000BaseDwdm5092',
    '1026' => 'e1000BaseDwdm5172',
    '1027' => 'e1000BaseDwdm5252',
    '1028' => 'e1000BaseDwdm5413',
    '1029' => 'e1000BaseDwdm5494',
    '1030' => 'e1000BaseDwdm5575',
    '1031' => 'e1000BaseDwdm5655',
    '1032' => 'e1000BaseDwdm5817',
    '1033' => 'e1000BaseDwdm5898',
    '1034' => 'e1000BaseDwdm5979',
    '1035' => 'e1000BaseDwdm6061',
    '1036' => 'e10GBaseWdmRxOnly',
    '1037' => 'e10GBaseDwdm3033',
    '1038' => 'e10GBaseDwdm3112',
    '1039' => 'e10GBaseDwdm3190',
    '1040' => 'e10GBaseDwdm3268',
    '1041' => 'e10GBaseDwdm3425',
    '1042' => 'e10GBaseDwdm3504',
    '1043' => 'e10GBaseDwdm3582',
    '1044' => 'e10GBaseDwdm3661',
    '1045' => 'e10GBaseDwdm3819',
    '1046' => 'e10GBaseDwdm3898',
    '1047' => 'e10GBaseDwdm3977',
    '1048' => 'e10GBaseDwdm4056',
    '1049' => 'e10GBaseDwdm4214',
    '1050' => 'e10GBaseDwdm4294',
    '1051' => 'e10GBaseDwdm4373',
    '1052' => 'e10GBaseDwdm4453',
    '1053' => 'e10GBaseDwdm4612',
    '1054' => 'e10GBaseDwdm4692',
    '1055' => 'e10GBaseDwdm4772',
    '1056' => 'e10GBaseDwdm4851',
    '1057' => 'e10GBaseDwdm5012',
    '1058' => 'e10GBaseDwdm5092',
    '1059' => 'e10GBaseDwdm5172',
    '1060' => 'e10GBaseDwdm5252',
    '1061' => 'e10GBaseDwdm5413',
    '1062' => 'e10GBaseDwdm5494',
    '1063' => 'e10GBaseDwdm5575',
    '1064' => 'e10GBaseDwdm5655',
    '1065' => 'e10GBaseDwdm5817',
    '1066' => 'e10GBaseDwdm5898',
    '1067' => 'e10GBaseDwdm5979',
    '1068' => 'e10GBaseDwdm6061',
    '1069' => 'e1000BaseBX10D',
    '1070' => 'e1000BaseBX10U',
    '1071' => 'e100BaseUnknown',
    '1072' => 'e100BaseUnapproved',
    '1073' => 'e100BaseSX',
    '1074' => 'e100BaseBX10D',
    '1075' => 'e100BaseBX10U',
    '1076' => 'e10GBaseBad',
    '1077' => 'e10GBaseZR',
    '1078' => 'e100BaseEX',
    '1079' => 'e100BaseZX',
    '1080' => 'e10GBaseLRM',
    '1081' => 'e10GBaseTPluggable',
    '1082' => 'e10GBaseCU1M',
    '1083' => 'e10GBaseCU3M',
    '1084' => 'e10GBaseCU5M',
    '1085' => 'e10GBaseCU7M',
    '1086' => 'e10GBaseCUdot3M',
    '1087' => 'e10GBaseCU2M',
    '1088' => 'e10GBaseCU4M',
    '1089' => 'e10GBaseCU6M',
    '1090' => 'e10GBaseUSR',
    '1091' => 'e10GBaseLRMSM',
    '1092' => 'e1000BaseDwdm3346',
    '1093' => 'e1000BaseDwdm3739',
    '1094' => 'e1000BaseDwdm4134',
    '1095' => 'e1000BaseDwdm4532',
    '1096' => 'e1000BaseDwdm4931',
    '1097' => 'e1000BaseDwdm5332',
    '1098' => 'e1000BaseDwdm5736',
    '1099' => 'e1000BaseDwdm6141',
    '1100' => 'e40GBaseLR',
    '1101' => 'e40GBaseSR',
    '1102' => 'e40GBaseUnapproved',
    '1104' => 'e10GBaseDwdm3347',
    '1105' => 'e10GBaseDwdm3740',
    '1106' => 'e10GBaseDwdm4135',
    '1107' => 'e10GBaseDwdm4532',
    '1108' => 'e10GBaseDwdm4932',
    '1109' => 'e10GBaseDwdm5333',
    '1110' => 'e10GBaseDwdm5736',
    '1111' => 'e10GBaseDwdm6141',
    '1112' => 'e10GBaseACU7M',
    '1113' => 'e10GBaseACU10M',
    '1114' => 'e1000BaseEXSMD',
    '1115' => 'e1000BaseZXSMD',
    '1116' => 'e1000BaseTE',
    '1117' => 'e1000BaseSXMMD',
    '1118' => 'e1000BaseLHSMD',
    '1119' => 'e100BaseFXGE',
  },
  syslogMessageSeverity => {
    '1' => 'emergencies',
    '2' => 'alerts',
    '3' => 'critical',
    '4' => 'errors',
    '5' => 'warnings',
    '6' => 'notification',
    '7' => 'informational',
    '8' => 'debugging',
  },
  tokenRingPortSoftErrEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysExtendedRmonEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'noNAMPresent',
  },
  sysTrapReceiverType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  portDuplex => {
    '1' => 'half',
    '2' => 'full',
    '3' => 'disagree',
    '4' => 'auto',
  },
  tokenRingPortMode => {
    '1' => 'auto',
    '2' => 'fdxCport',
    '3' => 'fdxStation',
    '4' => 'hdxCport',
    '5' => 'hdxStation',
    '7' => 'riro',
  },
  sysEnableBridgeTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'enabledForNewRootOnly',
    '4' => 'enabledForTopoChangeOnly',
  },
  chassisPs1Status => {
    '1' => 'other',
    '2' => 'ok',
    '3' => 'minorFault',
    '4' => 'majorFault',
  },
  syslogServerType => {
    '1' => 'valid',
    '2' => 'invalid',
  },
  portAdminSpeed => {
    '1' => 'autoDetect',
    '2' => 'autoDetect10100',
    '10' => 's10G',
    '64000' => 's64000',
    '1544000' => 's1544000',
    '2000000' => 's2000000',
    '2048000' => 's2048000',
    '4000000' => 's4000000',
    '10000000' => 's10000000',
    '16000000' => 's16000000',
    '45000000' => 's45000000',
    '64000000' => 's64000000',
    '100000000' => 's100000000',
    '155000000' => 's155000000',
    '400000000' => 's400000000',
    '622000000' => 's622000000',
    '1000000000' => 's1000000000',
  },
  sysEnableVmpsTraps => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  portOperRxFlowControl => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'disagree',
  },
  brouterEnableTransitEncapsulation => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  tokenRingDripRemotePortStatus => {
    '1' => 'active',
    '2' => 'inactive',
  },
  syslogConsoleEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  moduleType => {
    '1' => 'other',
    '2' => 'empty',
    '3' => 'wsc1000',
    '4' => 'wsc1001',
    '5' => 'wsc1100',
    '11' => 'wsc1200',
    '12' => 'wsc1400',
    '13' => 'wsx1441',
    '14' => 'wsx1444',
    '15' => 'wsx1450',
    '16' => 'wsx1483',
    '17' => 'wsx1454',
    '18' => 'wsx1455',
    '19' => 'wsx1431',
    '20' => 'wsx1465',
    '21' => 'wsx1436',
    '22' => 'wsx1434',
    '23' => 'wsx5009',
    '24' => 'wsx5013',
    '25' => 'wsx5011',
    '26' => 'wsx5010',
    '27' => 'wsx5113',
    '28' => 'wsx5101',
    '29' => 'wsx5103',
    '30' => 'wsx5104',
    '32' => 'wsx5155',
    '33' => 'wsx5154',
    '34' => 'wsx5153',
    '35' => 'wsx5111',
    '36' => 'wsx5213',
    '37' => 'wsx5020',
    '38' => 'wsx5006',
    '39' => 'wsx5005',
    '40' => 'wsx5509',
    '41' => 'wsx5506',
    '42' => 'wsx5505',
    '43' => 'wsx5156',
    '44' => 'wsx5157',
    '45' => 'wsx5158',
    '46' => 'wsx5030',
    '47' => 'wsx5114',
    '48' => 'wsx5223',
    '49' => 'wsx5224',
    '50' => 'wsx5012',
    '52' => 'wsx5302',
    '53' => 'wsx5213a',
    '54' => 'wsx5380',
    '55' => 'wsx5201',
    '56' => 'wsx5203',
    '57' => 'wsx5530',
    '61' => 'wsx5161',
    '62' => 'wsx5162',
    '65' => 'wsx5165',
    '66' => 'wsx5166',
    '67' => 'wsx5031',
    '68' => 'wsx5410',
    '69' => 'wsx5403',
    '73' => 'wsx5201r',
    '74' => 'wsx5225r',
    '75' => 'wsx5014',
    '76' => 'wsx5015',
    '77' => 'wsx5236',
    '78' => 'wsx5540',
    '79' => 'wsx5234',
    '81' => 'wsx5012a',
    '82' => 'wsx5167',
    '83' => 'wsx5239',
    '84' => 'wsx5168',
    '85' => 'wsx5305',
    '87' => 'wsx5550',
    '88' => 'wsf5541',
    '91' => 'wsx5534',
    '92' => 'wsx5536',
    '96' => 'wsx5237',
    '200' => 'wsx6ksup12ge',
    '201' => 'wsx6408gbic',
    '202' => 'wsx6224mmmt',
    '203' => 'wsx6248rj45',
    '204' => 'wsx6248tel',
    '206' => 'wsx6302msm',
    '207' => 'wsf6kmsfc',
    '208' => 'wsx6024flmt',
    '209' => 'wsx6101oc12mmf',
    '210' => 'wsx6101oc12smf',
    '211' => 'wsx6416gemt',
    '212' => 'wsx61822pa',
    '213' => 'osm2oc12AtmMM',
    '214' => 'osm2oc12AtmSI',
    '216' => 'osm4oc12PosMM',
    '217' => 'osm4oc12PosSI',
    '218' => 'osm4oc12PosSL',
    '219' => 'wsx6ksup1a2ge',
    '220' => 'wsx6302amsm',
    '221' => 'wsx6416gbic',
    '222' => 'wsx6224ammmt',
    '223' => 'wsx6380nam',
    '224' => 'wsx6248arj45',
    '225' => 'wsx6248atel',
    '226' => 'wsx6408agbic',
    '229' => 'wsx6608t1',
    '230' => 'wsx6608e1',
    '231' => 'wsx6624fxs',
    '233' => 'wsx6316getx',
    '234' => 'wsf6kmsfc2',
    '235' => 'wsx6324mmmt',
    '236' => 'wsx6348rj45',
    '237' => 'wsx6ksup22ge',
    '238' => 'wsx6324sm',
    '239' => 'wsx6516gbic',
    '240' => 'osm4geWanGbic',
    '241' => 'osm1oc48PosSS',
    '242' => 'osm1oc48PosSI',
    '243' => 'osm1oc48PosSL',
    '244' => 'wsx6381ids',
    '245' => 'wsc6500sfm',
    '246' => 'osm16oc3PosMM',
    '247' => 'osm16oc3PosSI',
    '248' => 'osm16oc3PosSL',
    '249' => 'osm2oc12PosMM',
    '250' => 'osm2oc12PosSI',
    '251' => 'osm2oc12PosSL',
    '252' => 'wsx650210ge',
    '253' => 'osm8oc3PosMM',
    '254' => 'osm8oc3PosSI',
    '255' => 'osm8oc3PosSL',
    '258' => 'wsx6548rj45',
    '259' => 'wsx6524mmmt',
    '260' => 'wsx6066SlbApc',
    '261' => 'wsx6516getx',
    '265' => 'osm2oc48OneDptSS',
    '266' => 'osm2oc48OneDptSI',
    '267' => 'osm2oc48OneDptSL',
    '268' => 'osm2oc48OneDptSSDual',
    '269' => 'osm2oc48OneDptSIDual',
    '270' => 'osm2oc48OneDptSLDual',
    '271' => 'wsx6816gbic',
    '272' => 'osm4choc12T3MM',
    '273' => 'osm4choc12T3SI',
    '274' => 'osm8choc12T3MM',
    '275' => 'osm8choc12T3SI',
    '276' => 'osm1choc48T3SS',
    '277' => 'osm2choc48T3SS',
    '278' => 'wsx6500sfm2',
    '279' => 'osm1choc48T3SI',
    '280' => 'osm2choc48T3SI',
    '281' => 'wsx6348rj21',
    '282' => 'wsx6548rj21',
    '284' => 'wsSvcCmm',
    '285' => 'wsx650110gex4',
    '286' => 'osm4oc3PosSI',
    '289' => 'osm4oc3PosMM',
    '290' => 'wsSvcIdsm2',
    '291' => 'wsSvcNam2',
    '292' => 'wsSvcFwm1',
    '293' => 'wsSvcCe1',
    '294' => 'wsSvcSsl1',
    '295' => 'osm8choc3DS0SI',
    '296' => 'osm4choc3DS0SI',
    '297' => 'osm1choc12T1SI',
    '300' => 'wsx4012',
    '301' => 'wsx4148rj',
    '302' => 'wsx4232gbrj',
    '303' => 'wsx4306gb',
    '304' => 'wsx4418gb',
    '305' => 'wsx44162gbtx',
    '306' => 'wsx4912gb',
    '307' => 'wsx2948gbrj',
    '309' => 'wsx2948',
    '310' => 'wsx4912',
    '311' => 'wsx4424sxmt',
    '312' => 'wsx4232rjxx',
    '313' => 'wsx4148rj21',
    '317' => 'wsx4124fxmt',
    '318' => 'wsx4013',
    '319' => 'wsx4232l3',
    '320' => 'wsx4604gwy',
    '321' => 'wsx44122Gbtx',
    '322' => 'wsx2980',
    '323' => 'wsx2980rj',
    '324' => 'wsx2980gbrj',
    '325' => 'wsx4019',
    '326' => 'wsx4148rj45v',
    '330' => 'wsx4424gbrj45',
    '331' => 'wsx4148fxmt',
    '332' => 'wsx4448gblx',
    '334' => 'wsx4448gbrj45',
    '337' => 'wsx4148lxmt',
    '339' => 'wsx4548gbrj45',
    '340' => 'wsx4548gbrj45v',
    '341' => 'wsx4248rj21v',
    '342' => 'wsx4302gb',
    '343' => 'wsx4248rj45v',
    '345' => 'wsx2948ggetx',
    '346' => 'wsx2948ggetxgbrj',
    '502' => 'wsx6516aGbic',
    '503' => 'wsx6148getx',
    '506' => 'wsx6148x2rj45',
    '507' => 'wsx6196rj21',
    '509' => 'wssup32ge3b',
    '510' => 'wssup3210ge3b',
    '511' => 'mec6524gs8s',
    '512' => 'mec6524gt8s',
    '515' => 'wssup32pge',
    '516' => 'wssup32p10ge',
    '597' => 'wssvcpisa32',
    '598' => 'me6524msfc2a',
    '599' => 'wsf6kmsfc2a',
    '600' => 'osm12ct3T1',
    '601' => 'osm12t3e3',
    '602' => 'osm24t3e3',
    '603' => 'osm4GeWanGbicPlus',
    '604' => 'osm1choc12T3SI',
    '605' => 'osm2choc12T3SI',
    '606' => 'osm2oc12AtmMMPlus',
    '607' => 'osm2oc12AtmSIPlus',
    '608' => 'osm2oc12PosMMPlus',
    '609' => 'osm2oc12PosSIPlus',
    '610' => 'osm16oc3PosSIPlus',
    '611' => 'osm1oc48PosSSPlus',
    '612' => 'osm1oc48PosSIPlus',
    '613' => 'osm1oc48PosSLPlus',
    '614' => 'osm4oc3PosSIPlus',
    '615' => 'osm8oc3PosSLPlus',
    '616' => 'osm8oc3PosSIPlus',
    '617' => 'osm4oc12PosSIPlus',
    '618' => 'c7600Es4Tg3cxl',
    '620' => 'c7600Es2Tg3cxl',
    '625' => 'c76EsXt4Tg3cxl',
    '626' => 'c76EsXt2Tg3cxl',
    '627' => 'c7600Es4Tg3c',
    '629' => 'c7600Es2Tg3c',
    '633' => 'c76EsXt4Tg3c',
    '634' => 'c76EsXt2Tg3c',
    '903' => 'wsSvcIpSec1',
    '910' => 'wsSvcMwam1',
    '911' => 'wsSvcCsg1',
    '912' => 'wsx6148rj45v',
    '913' => 'wsx6148rj21v',
    '914' => 'wsSvcNam1',
    '915' => 'wsx6548getx',
    '919' => 'wsSvcPsd1',
    '920' => 'wsx6066SlbSk9',
    '921' => 'wsx6148agetx',
    '923' => 'wsx6148arj45',
    '924' => 'wsSvcWlan1k9',
    '925' => 'wsSvcAon1k9',
    '926' => 'ace106500k9',
    '927' => 'wsSvcWebVpnk9',
    '928' => 'wsx6148FeSfp',
    '929' => 'wsSvcAdm1k9',
    '930' => 'wsSvcAgm1k9',
    '936' => 'ace046500k9',
    '940' => 'wsSvcSamiBb',
    '946' => 'wsSvcWism2k9',
    '947' => 'wsSvcAsaSm1',
    '949' => 'wsSvcNam3k9',
    '950' => 'wsSvcAsaSm1k7',
    '951' => 'wsSvcVse1k9',
    '1001' => 'wssup720',
    '1002' => 'wssup720base',
    '1004' => 'm7600Sip600',
    '1007' => 'wsx6748getx',
    '1008' => 'wsx670410ge',
    '1009' => 'wsx6748sfp',
    '1010' => 'wsx6724sfp',
    '1016' => 'wsx670810ge',
    '1021' => 'vss72010g',
    '1023' => 'wsx6708a10ge',
    '1027' => 'wsx671610ge',
    '1031' => 'vssup2t10g',
    '1032' => 'wsx6148ege45at',
    '1033' => 'wsx671610t',
    '1034' => 'wsx690810g',
    '1035' => 'wsx690440g',
    '1036' => 'wsx6148egetx',
    '1037' => 'wsx6848tx',
    '1039' => 'wsx6848sfp',
    '1040' => 'wsx6824sfp',
    '1042' => 'wsx681610ge',
    '1043' => 'wsx681610t',
    '1101' => 'wsx65822pa',
    '1102' => 'm7600Sip200',
    '1103' => 'm7600Sip400',
    '1104' => 'c7600ssc400',
    '1105' => 'c7600ssc600',
    '1106' => 'esm2x10ge',
    '1301' => 'c6800ia48td',
    '1304' => 'c6800ia48fpd',
    '1400' => 'c6880x16p10g',
    '1401' => 'c6880x',
    '1402' => 'c6880xle16p10g',
    '1403' => 'c6880xle',
    '1800' => 'rsp720',
    '1801' => 'rsp720base',
    '1805' => 'c7600msfc4',
  },
  chassisMinorAlarm => {
    '1' => 'off',
    '2' => 'on',
  },
  sysConsolePrimaryEnableAuthentication => {
    '1' => 'tacacs',
    '2' => 'radius',
    '3' => 'local',
  },
  vlanPortSwitchLevel => {
    '1' => 'normal',
    '2' => 'high',
    '3' => 'notApplicable',
  },
  tokenRingDripLocalPortStatus => {
    '1' => 'active',
    '2' => 'inactive',
  },
  portSecurityAdminStatus => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  sysReset => {
    '1' => 'other',
    '2' => 'reset',
    '3' => 'resetMinDown',
  },
  chassisComponentType => {
    '1' => 'unknown',
    '2' => 'wsc6000cl',
    '3' => 'wsc6000vtt',
    '4' => 'wsc6000tempSensor',
    '5' => 'wsc6513Clock',
    '6' => 'clk7600',
    '7' => 'ws9SlotFan',
    '8' => 'fanMod9',
    '10' => 'wsc6506eFan',
    '11' => 'wsc6509eFan',
    '13' => 'wsc6503eFan',
    '14' => 'wsc6000vtte',
    '15' => 'fanMod4Hs',
    '16' => 'fan6524',
    '17' => 'fanMod6Shs',
    '18' => 'fanMod9Shs',
    '19' => 'fanMod9St',
    '20' => 'wsc6509veFan',
    '21' => 'fanMod3Hs',
    '25' => 'c6880xFan',
    '26' => 'c6807xlFan',
    '27' => 'c6800xl33vcon',
  },
  monitorEnable => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
};
