package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOSMARTLICMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-SMART-LIC-MIB'} = {
  url => '',
  name => 'CISCO-SMART-LIC-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-SMART-LIC-MIB'} =
    '1.3.6.1.4.1.9.9.831';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-SMART-LIC-MIB'} = {
  'ciscoSmartLicMIB' => '1.3.6.1.4.1.9.9.831',
  'ciscoSlaMIBObjects' => '1.3.6.1.4.1.9.9.831.0',
  'ciscoSlaInstanceId' => '1.3.6.1.4.1.9.9.831.0.1',
  'ciscoSlaSUDIInfo' => '1.3.6.1.4.1.9.9.831.0.2',
  #'ciscoSlaSUDIInfoDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaVersion' => '1.3.6.1.4.1.9.9.831.0.3',
  #'ciscoSlaVersionDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaEnabled' => '1.3.6.1.4.1.9.9.831.0.4',
  'ciscoSlaEnabledDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaEntitlementInfo' => '1.3.6.1.4.1.9.9.831.0.5',
  'ciscoSlaEntitlementInfoTable' => '1.3.6.1.4.1.9.9.831.0.5.1',
  'ciscoSlaEntitlementInfoEntry' => '1.3.6.1.4.1.9.9.831.0.5.1.1',
  'ciscoSlaEntitlementInfoIndex' => '1.3.6.1.4.1.9.9.831.0.5.1.1.1',
  'ciscoSlaEntitlementRequestCount' => '1.3.6.1.4.1.9.9.831.0.5.1.1.2',
  'ciscoSlaEntitlementTag' => '1.3.6.1.4.1.9.9.831.0.5.1.1.3',
  #'ciscoSlaEntitlementTagDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaEntitlementVersion' => '1.3.6.1.4.1.9.9.831.0.5.1.1.4',
  #'ciscoSlaEntitlementVersionDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaEntitlementEnforceMode' => '1.3.6.1.4.1.9.9.831.0.5.1.1.5',
  'ciscoSlaEntitlementEnforceModeDefinition' => 'CISCO-SMART-LIC-MIB::ciscoSlaEntitlementEnforceMode',
  'ciscoSlaEntitlementDescription' => '1.3.6.1.4.1.9.9.831.0.5.1.1.6',
  #'ciscoSlaEntitlementDescriptionDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaEntitlementFeatureName' => '1.3.6.1.4.1.9.9.831.0.5.1.1.7',
  #'ciscoSlaEntitlementFeatureNameDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaEntitlementExportAllowed' => '1.3.6.1.4.1.9.9.831.0.5.1.1.8',
  'ciscoSlaEntitlementExportAllowedDefinition' => 'CISCO-SMART-LIC-MIB::ciscoSlaEntitlementExportAllowed',
  'ciscoSlaRegistrationStatusInfo' => '1.3.6.1.4.1.9.9.831.0.6',
  # kuenstliche table
  'ciscoSlaRegistrationStatusInfoTable' => '1.3.6.1.4.1.9.9.831.0.6',
  'ciscoSlaRegistrationStatusInfoEntry' => '1.3.6.1.4.1.9.9.831.0.6',
  'ciscoSlaRegistrationStatus' => '1.3.6.1.4.1.9.9.831.0.6.1',
  'ciscoSlaRegistrationStatusDefinition' => 'CISCO-SMART-LIC-MIB::ciscoSlaRegistrationStatus',
  'ciscoSlaVirtualAccount' => '1.3.6.1.4.1.9.9.831.0.6.2',
  #'ciscoSlaVirtualAccountDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaNextCertificateExpireTime' => '1.3.6.1.4.1.9.9.831.0.6.3',
  'ciscoSlaEnterpriseAccountName' => '1.3.6.1.4.1.9.9.831.0.6.4',
  #'ciscoSlaEnterpriseAccountNameDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaRegisterTime' => '1.3.6.1.4.1.9.9.831.0.6.5',
  'ciscoSlaRegisterInitTime' => '1.3.6.1.4.1.9.9.831.0.6.5.1',
  'ciscoSlaRegisterSuccess' => '1.3.6.1.4.1.9.9.831.0.6.5.2',
  'ciscoSlaRegisterSuccessDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaRegisterFailureReason' => '1.3.6.1.4.1.9.9.831.0.6.5.3',
  #'ciscoSlaRegisterFailureReasonDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaRegisterNextRetryTime' => '1.3.6.1.4.1.9.9.831.0.6.5.4',
  'ciscoSlaRenewTime' => '1.3.6.1.4.1.9.9.831.0.6.6',
  'ciscoSlaRenewInitTime' => '1.3.6.1.4.1.9.9.831.0.6.6.1',
  'ciscoSlaRenewSuccess' => '1.3.6.1.4.1.9.9.831.0.6.6.2',
  'ciscoSlaRenewSuccessDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaRenewFailureReason' => '1.3.6.1.4.1.9.9.831.0.6.6.3',
  #'ciscoSlaRenewFailureReasonDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaRenewNextRetryTime' => '1.3.6.1.4.1.9.9.831.0.6.6.4',
  'ciscoSlaAuthorizationInfo' => '1.3.6.1.4.1.9.9.831.0.7',
  # kuenstliche table
  'ciscoSlaAuthorizationInfoTable' => '1.3.6.1.4.1.9.9.831.0.7',
  'ciscoSlaAuthorizationInfoEntry' => '1.3.6.1.4.1.9.9.831.0.7',
  'ciscoSlaAuthExpireTime' => '1.3.6.1.4.1.9.9.831.0.7.1',
  'ciscoSlaAuthComplianceStatus' => '1.3.6.1.4.1.9.9.831.0.7.2',
  #'ciscoSlaAuthComplianceStatusDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaAuthOOCStartTime' => '1.3.6.1.4.1.9.9.831.0.7.3',
  'ciscoSlaAuthEvalPeriod' => '1.3.6.1.4.1.9.9.831.0.7.4',
  'ciscoSlaAuthEvalPeriodInUse' => '1.3.6.1.4.1.9.9.831.0.7.4.1',
  'ciscoSlaAuthEvalPeriodInUseDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaAuthEvalExpiredTime' => '1.3.6.1.4.1.9.9.831.0.7.4.2',
  'ciscoSlaAuthEvalPeriodLeft' => '1.3.6.1.4.1.9.9.831.0.7.4.3',
  'ciscoSlaAuthRenewTime' => '1.3.6.1.4.1.9.9.831.0.7.5',
  'ciscoSlaAuthRenewInitTime' => '1.3.6.1.4.1.9.9.831.0.7.5.1',
  'ciscoSlaAuthRenewSuccess' => '1.3.6.1.4.1.9.9.831.0.7.5.2',
  'ciscoSlaAuthRenewSuccessDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaAuthRenewFailureReason' => '1.3.6.1.4.1.9.9.831.0.7.5.3',
  #'ciscoSlaAuthRenewFailureReasonDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaAuthRenewNextRetryTime' => '1.3.6.1.4.1.9.9.831.0.7.5.4',
  'ciscoSlaNotifObjects' => '1.3.6.1.4.1.9.9.831.0.8',
  'ciscoSlaGlobalNotifEnable' => '1.3.6.1.4.1.9.9.831.0.8.1',
  'ciscoSlaGlobalNotifEnableDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaEntitlementNotifEnable' => '1.3.6.1.4.1.9.9.831.0.8.2',
  'ciscoSlaEntitlementNotifEnableDefinition' => 'SNMPv2-TC::TruthValue',
  'ciscoSlaDeRegistrationInfo' => '1.3.6.1.4.1.9.9.831.0.9',
  'ciscoSlaFailureReason' => '1.3.6.1.4.1.9.9.831.0.9.1',
  'ciscoSlaFailureReasonDefinition' => 'CISCO-SMART-LIC-MIB::ciscoSlaFailureReason',
  'ciscoSlaDeRegisterFailureMsg' => '1.3.6.1.4.1.9.9.831.0.9.2',
  #'ciscoSlaDeRegisterFailureMsgDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaThirdPartyAndUtilityInfo' => '1.3.6.1.4.1.9.9.831.0.10',
  'ciscoSlaThirdPartyAndUtilityFailureMsg' => '1.3.6.1.4.1.9.9.831.0.10.1',
  #'ciscoSlaThirdPartyAndUtilityFailureMsgDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaExportInfo' => '1.3.6.1.4.1.9.9.831.0.11',
  'ciscoSlaExportFailureReason' => '1.3.6.1.4.1.9.9.831.0.11.1',
  'ciscoSlaExportFailureMessage' => '1.3.6.1.4.1.9.9.831.0.11.2',
  #'ciscoSlaExportFailureMessageDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaReportingInfo' => '1.3.6.1.4.1.9.9.831.0.12',
  'ciscoSlaDaysRUMAckNotReceived' => '1.3.6.1.4.1.9.9.831.0.12.1',
  'ciscoSlaDaysReportingRequired' => '1.3.6.1.4.1.9.9.831.0.12.2',
  'ciscoSlaPolicyModeInfo' => '1.3.6.1.4.1.9.9.831.0.13',
  'ciscoSlaPolicyModeFailureMessage' => '1.3.6.1.4.1.9.9.831.0.13.1',
  #'ciscoSlaPolicyModeFailureMessageDefinition' => 'SNMP-FRAMEWORK-MIB::SnmpAdminString',
  'ciscoSlaPolicyModeInitialACKState' => '1.3.6.1.4.1.9.9.831.0.13.2',
  'ciscoSlaMIBNotifs' => '1.3.6.1.4.1.9.9.831.1',
  'ciscoSlaMIBConform' => '1.3.6.1.4.1.9.9.831.2',
  'ciscoSlaMIBCompliances' => '1.3.6.1.4.1.9.9.831.2.1',
  'ciscoSlaMIBGroups' => '1.3.6.1.4.1.9.9.831.2.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-SMART-LIC-MIB'} = {
  'ciscoSlaFailureReason' => {
    '0' => 'invalid',
    '1' => 'alreadyRegistered',
    '2' => 'dailyJobTimerReset',
    '3' => 'deRegisterFailure',
  },
  'ciscoSlaEntitlementExportAllowed' => {
    '0' => 'false',
    '1' => 'true',
  },
  'ciscoSlaRegistrationStatus' => {
    '1' => 'notRegistered',
    '2' => 'registrationInProgress',
    '3' => 'registrationFailed',
    '4' => 'registrationRetryinProgress',
    '5' => 'registrationCompleted',
  },
  'ciscoSlaEntitlementEnforceMode' => {
    # welche mit ciscoSlaVersion 5.x haben meist 15
    # solche mit 4.x haben meist 3
    # ab 201703300000Z wurde EntitlementInfo refactored, aber die
    # Kritikalitaeten werden schon noch passen.
    '1' => 'initialized',
    '2' => 'waiting',
    '3' => 'authorized',
    '4' => 'outOfCompliance',
    '5' => 'overage',
    '6' => 'evaluationPeriod',
    '7' => 'evaluationExpired',
    '8' => 'authorizationExpired',
    '9' => 'gracePeriodExpired',
    '10' => 'disabled',
    '11' => 'reservedAuthorized',
    '12' => 'invalidTag',
    '13' => 'notAuthorized',
    '14' => 'notApplicable',
    '15' => 'inUse',
    '16' => 'notInUse',
  },
};
