package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCORTTMONMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-RTTMON-MIB'} = {
  url => '',
  name => 'CISCO-RTTMON-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-RTTMON-MIB'} =
    '1.3.6.1.4.1.9.9.42';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-RTTMON-MIB'} = {
  'ciscoRttMonMIB' => '1.3.6.1.4.1.9.9.42',
  'ciscoRttMonObjects' => '1.3.6.1.4.1.9.9.42.1',
  'rttMonAppl' => '1.3.6.1.4.1.9.9.42.1.1',
  'rttMonApplVersion' => '1.3.6.1.4.1.9.9.42.1.1.1',
  'rttMonApplMaxPacketDataSize' => '1.3.6.1.4.1.9.9.42.1.1.2',
  'rttMonApplTimeOfLastSet' => '1.3.6.1.4.1.9.9.42.1.1.3',
  'rttMonApplNumCtrlAdminEntry' => '1.3.6.1.4.1.9.9.42.1.1.4',
  'rttMonApplReset' => '1.3.6.1.4.1.9.9.42.1.1.5',
  'rttMonApplPreConfigedReset' => '1.3.6.1.4.1.9.9.42.1.1.6',
  'rttMonApplSupportedRttTypesTable' => '1.3.6.1.4.1.9.9.42.1.1.7',
  'rttMonApplSupportedRttTypesEntry' => '1.3.6.1.4.1.9.9.42.1.1.7.1',
  'rttMonApplSupportedRttTypes' => '1.3.6.1.4.1.9.9.42.1.1.7.1.1',
  'rttMonApplSupportedRttTypesValid' => '1.3.6.1.4.1.9.9.42.1.1.7.1.2',
  'rttMonApplSupportedProtocolsTable' => '1.3.6.1.4.1.9.9.42.1.1.8',
  'rttMonApplSupportedProtocolsEntry' => '1.3.6.1.4.1.9.9.42.1.1.8.1',
  'rttMonApplSupportedProtocols' => '1.3.6.1.4.1.9.9.42.1.1.8.1.1',
  'rttMonApplSupportedProtocolsValid' => '1.3.6.1.4.1.9.9.42.1.1.8.1.2',
  'rttMonApplPreConfigedTable' => '1.3.6.1.4.1.9.9.42.1.1.9',
  'rttMonApplPreConfigedEntry' => '1.3.6.1.4.1.9.9.42.1.1.9.1',
  'rttMonApplPreConfigedType' => '1.3.6.1.4.1.9.9.42.1.1.9.1.2',
  'rttMonApplPreConfigedTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonApplPreConfigedType',
  'rttMonApplPreConfigedName' => '1.3.6.1.4.1.9.9.42.1.1.9.1.3',
  'rttMonApplPreConfigedValid' => '1.3.6.1.4.1.9.9.42.1.1.9.1.4',
  'rttMonApplProbeCapacity' => '1.3.6.1.4.1.9.9.42.1.1.10',
  'rttMonApplFreeMemLowWaterMark' => '1.3.6.1.4.1.9.9.42.1.1.11',
  'rttMonApplLatestSetError' => '1.3.6.1.4.1.9.9.42.1.1.12',
  'rttMonApplResponder' => '1.3.6.1.4.1.9.9.42.1.1.13',
  'rttMonApplAuthTable' => '1.3.6.1.4.1.9.9.42.1.1.14',
  'rttMonApplAuthEntry' => '1.3.6.1.4.1.9.9.42.1.1.14.1',
  'rttMonApplAuthIndex' => '1.3.6.1.4.1.9.9.42.1.1.14.1.1',
  'rttMonApplAuthKeyChain' => '1.3.6.1.4.1.9.9.42.1.1.14.1.2',
  'rttMonApplAuthKeyString1' => '1.3.6.1.4.1.9.9.42.1.1.14.1.3',
  'rttMonApplAuthKeyString2' => '1.3.6.1.4.1.9.9.42.1.1.14.1.4',
  'rttMonApplAuthKeyString3' => '1.3.6.1.4.1.9.9.42.1.1.14.1.5',
  'rttMonApplAuthKeyString4' => '1.3.6.1.4.1.9.9.42.1.1.14.1.6',
  'rttMonApplAuthKeyString5' => '1.3.6.1.4.1.9.9.42.1.1.14.1.7',
  'rttMonApplAuthStatus' => '1.3.6.1.4.1.9.9.42.1.1.14.1.8',
  'rttMonApplLpdGrpStatsReset' => '1.3.6.1.4.1.9.9.42.1.1.15',
  'rttMonCtrl' => '1.3.6.1.4.1.9.9.42.1.2',
  'rttMonCtrlAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.1',
  'rttMonCtrlAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.1.1',
  'rttMonCtrlAdminIndex' => '1.3.6.1.4.1.9.9.42.1.2.1.1.1',
  'rttMonCtrlAdminOwner' => '1.3.6.1.4.1.9.9.42.1.2.1.1.2',
  'rttMonCtrlAdminTag' => '1.3.6.1.4.1.9.9.42.1.2.1.1.3',
  'rttMonCtrlAdminRttType' => '1.3.6.1.4.1.9.9.42.1.2.1.1.4',
  'rttMonCtrlAdminRttTypeDefinition' => 'CISCO-RTTMON-TC-MIB::RttMonRttType',
  'rttMonCtrlAdminThreshold' => '1.3.6.1.4.1.9.9.42.1.2.1.1.5',
  'rttMonCtrlAdminFrequency' => '1.3.6.1.4.1.9.9.42.1.2.1.1.6',
  'rttMonCtrlAdminTimeout' => '1.3.6.1.4.1.9.9.42.1.2.1.1.7',
  'rttMonCtrlAdminVerifyData' => '1.3.6.1.4.1.9.9.42.1.2.1.1.8',
  'rttMonCtrlAdminVerifyDataDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'rttMonCtrlAdminStatus' => '1.3.6.1.4.1.9.9.42.1.2.1.1.9',
  'rttMonCtrlAdminStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',

  'rttMonCtrlAdminNvgen' => '1.3.6.1.4.1.9.9.42.1.2.1.1.10',
  'rttMonCtrlAdminNvgenDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',

  'rttMonCtrlAdminGroupName' => '1.3.6.1.4.1.9.9.42.1.2.1.1.11',
  'rttMonCtrlAdminLongTag' => '1.3.6.1.4.1.9.9.42.1.2.1.1.12',
  'rttMonEchoAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.2',
  'rttMonEchoAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.2.1',
  'rttMonEchoAdminProtocol' => '1.3.6.1.4.1.9.9.42.1.2.2.1.1',
  'rttMonEchoAdminProtocolDefinition' => 'CISCO-RTTMON-TC-MIB::RttMonProtocol',

  'rttMonEchoAdminTargetAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.2',
  'rttMonEchoAdminPktDataRequestSize' => '1.3.6.1.4.1.9.9.42.1.2.2.1.3',
  'rttMonEchoAdminPktDataResponseSize' => '1.3.6.1.4.1.9.9.42.1.2.2.1.4',
  'rttMonEchoAdminTargetPort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.5',
  'rttMonEchoAdminSourceAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.6',
  'rttMonEchoAdminSourcePort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.7',
  'rttMonEchoAdminControlEnable' => '1.3.6.1.4.1.9.9.42.1.2.2.1.8',
  'rttMonEchoAdminControlEnableDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',

  'rttMonEchoAdminTOS' => '1.3.6.1.4.1.9.9.42.1.2.2.1.9',
  'rttMonEchoAdminLSREnable' => '1.3.6.1.4.1.9.9.42.1.2.2.1.10',
  'rttMonEchoAdminTargetAddressString' => '1.3.6.1.4.1.9.9.42.1.2.2.1.11',
  'rttMonEchoAdminNameServer' => '1.3.6.1.4.1.9.9.42.1.2.2.1.12',
  'rttMonEchoAdminOperation' => '1.3.6.1.4.1.9.9.42.1.2.2.1.13',
  'rttMonEchoAdminHTTPVersion' => '1.3.6.1.4.1.9.9.42.1.2.2.1.14',
  'rttMonEchoAdminURL' => '1.3.6.1.4.1.9.9.42.1.2.2.1.15',
  'rttMonEchoAdminCache' => '1.3.6.1.4.1.9.9.42.1.2.2.1.16',
  'rttMonEchoAdminInterval' => '1.3.6.1.4.1.9.9.42.1.2.2.1.17',
  'rttMonEchoAdminNumPackets' => '1.3.6.1.4.1.9.9.42.1.2.2.1.18',
  'rttMonEchoAdminProxy' => '1.3.6.1.4.1.9.9.42.1.2.2.1.19',
  'rttMonEchoAdminString1' => '1.3.6.1.4.1.9.9.42.1.2.2.1.20',
  'rttMonEchoAdminString2' => '1.3.6.1.4.1.9.9.42.1.2.2.1.21',
  'rttMonEchoAdminString3' => '1.3.6.1.4.1.9.9.42.1.2.2.1.22',
  'rttMonEchoAdminString4' => '1.3.6.1.4.1.9.9.42.1.2.2.1.23',
  'rttMonEchoAdminString5' => '1.3.6.1.4.1.9.9.42.1.2.2.1.24',
  'rttMonEchoAdminMode' => '1.3.6.1.4.1.9.9.42.1.2.2.1.25',
  'rttMonEchoAdminVrfName' => '1.3.6.1.4.1.9.9.42.1.2.2.1.26',
  'rttMonEchoAdminCodecType' => '1.3.6.1.4.1.9.9.42.1.2.2.1.27',
  'rttMonEchoAdminCodecTypeDefinition' => 'CISCO-RTTMON-TC-MIB::RttMonCodecType',

  'rttMonEchoAdminCodecInterval' => '1.3.6.1.4.1.9.9.42.1.2.2.1.28',
  'rttMonEchoAdminCodecPayload' => '1.3.6.1.4.1.9.9.42.1.2.2.1.29',
  'rttMonEchoAdminCodecNumPackets' => '1.3.6.1.4.1.9.9.42.1.2.2.1.30',
  'rttMonEchoAdminICPIFAdvFactor' => '1.3.6.1.4.1.9.9.42.1.2.2.1.31',
  'rttMonEchoAdminLSPFECType' => '1.3.6.1.4.1.9.9.42.1.2.2.1.32',
  'rttMonEchoAdminLSPFECTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonEchoAdminLSPFECType',
  'rttMonEchoAdminLSPSelector' => '1.3.6.1.4.1.9.9.42.1.2.2.1.33',
  'rttMonEchoAdminLSPReplyMode' => '1.3.6.1.4.1.9.9.42.1.2.2.1.34',
  'rttMonEchoAdminLSPTTL' => '1.3.6.1.4.1.9.9.42.1.2.2.1.35',
  'rttMonEchoAdminLSPExp' => '1.3.6.1.4.1.9.9.42.1.2.2.1.36',
  'rttMonEchoAdminPrecision' => '1.3.6.1.4.1.9.9.42.1.2.2.1.37',
  'rttMonEchoAdminPrecisionDefinition' => 'CISCO-RTTMON-MIB::rttMonEchoAdminPrecision',
  'rttMonEchoAdminProbePakPriority' => '1.3.6.1.4.1.9.9.42.1.2.2.1.38',
  'rttMonEchoAdminProbePakPriorityDefinition' => 'CISCO-RTTMON-MIB::rttMonEchoAdminProbePakPriority',
  'rttMonEchoAdminOWNTPSyncTolAbs' => '1.3.6.1.4.1.9.9.42.1.2.2.1.39',
  'rttMonEchoAdminOWNTPSyncTolPct' => '1.3.6.1.4.1.9.9.42.1.2.2.1.40',
  'rttMonEchoAdminOWNTPSyncTolType' => '1.3.6.1.4.1.9.9.42.1.2.2.1.41',
  'rttMonEchoAdminOWNTPSyncTolTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonEchoAdminOWNTPSyncTolType',
  'rttMonEchoAdminCalledNumber' => '1.3.6.1.4.1.9.9.42.1.2.2.1.42',
  'rttMonEchoAdminDetectPoint' => '1.3.6.1.4.1.9.9.42.1.2.2.1.43',
  'rttMonEchoAdminGKRegistration' => '1.3.6.1.4.1.9.9.42.1.2.2.1.44',
  'rttMonEchoAdminSourceVoicePort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.45',
  'rttMonEchoAdminCallDuration' => '1.3.6.1.4.1.9.9.42.1.2.2.1.46',
  'rttMonEchoAdminLSPReplyDscp' => '1.3.6.1.4.1.9.9.42.1.2.2.1.47',
  'rttMonEchoAdminLSPNullShim' => '1.3.6.1.4.1.9.9.42.1.2.2.1.48',
  'rttMonEchoAdminTargetMPID' => '1.3.6.1.4.1.9.9.42.1.2.2.1.49',
  'rttMonEchoAdminTargetDomainName' => '1.3.6.1.4.1.9.9.42.1.2.2.1.50',
  'rttMonEchoAdminTargetVLAN' => '1.3.6.1.4.1.9.9.42.1.2.2.1.51',
  'rttMonEchoAdminEthernetCOS' => '1.3.6.1.4.1.9.9.42.1.2.2.1.52',
  'rttMonEchoAdminLSPVccvID' => '1.3.6.1.4.1.9.9.42.1.2.2.1.53',
  'rttMonEchoAdminTargetEVC' => '1.3.6.1.4.1.9.9.42.1.2.2.1.54',
  'rttMonEchoAdminTargetMEPPort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.55',
  'rttMonEchoAdminVideoTrafficProfile' => '1.3.6.1.4.1.9.9.42.1.2.2.1.56',
  'rttMonEchoAdminDscp' => '1.3.6.1.4.1.9.9.42.1.2.2.1.57',
  'rttMonEchoAdminReserveDsp' => '1.3.6.1.4.1.9.9.42.1.2.2.1.58',
  'rttMonEchoAdminReserveDspDefinition' => 'CISCO-RTTMON-MIB::rttMonEchoAdminReserveDsp',
  'rttMonEchoAdminInputInterface' => '1.3.6.1.4.1.9.9.42.1.2.2.1.59',
  'rttMonEchoAdminEmulateSourceAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.60',
  'rttMonEchoAdminEmulateSourcePort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.61',
  'rttMonEchoAdminEmulateTargetAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.62',
  'rttMonEchoAdminEmulateTargetPort' => '1.3.6.1.4.1.9.9.42.1.2.2.1.63',
  'rttMonEchoAdminTargetMacAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.64',
  'rttMonEchoAdminSourceMacAddress' => '1.3.6.1.4.1.9.9.42.1.2.2.1.65',
  'rttMonEchoAdminSourceMPID' => '1.3.6.1.4.1.9.9.42.1.2.2.1.66',
  'rttMonEchoAdminEndPointListName' => '1.3.6.1.4.1.9.9.42.1.2.2.1.67',
  'rttMonEchoAdminSSM' => '1.3.6.1.4.1.9.9.42.1.2.2.1.68',
  'rttMonEchoAdminControlRetry' => '1.3.6.1.4.1.9.9.42.1.2.2.1.69',
  'rttMonEchoAdminControlTimeout' => '1.3.6.1.4.1.9.9.42.1.2.2.1.70',
  'rttMonEchoAdminIgmpTreeInit' => '1.3.6.1.4.1.9.9.42.1.2.2.1.71',
  'rttMonEchoAdminEnableBurst' => '1.3.6.1.4.1.9.9.42.1.2.2.1.72',
  'rttMonEchoAdminAggBurstCycles' => '1.3.6.1.4.1.9.9.42.1.2.2.1.73',
  'rttMonEchoAdminLossRatioNumFrames' => '1.3.6.1.4.1.9.9.42.1.2.2.1.74',
  'rttMonEchoAdminAvailNumFrames' => '1.3.6.1.4.1.9.9.42.1.2.2.1.75',
  'rttMonEchoAdminTstampOptimization' => '1.3.6.1.4.1.9.9.42.1.2.2.1.76',
  'rttMonEchoAdminTargetSwitchId' => '1.3.6.1.4.1.9.9.42.1.2.2.1.77',
  'rttMonEchoAdminProfileId' => '1.3.6.1.4.1.9.9.42.1.2.2.1.78',
  'rttMonEchoAdminOutputInterface' => '1.3.6.1.4.1.9.9.42.1.2.2.1.79',
  'rttMonFileIOAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.3',
  'rttMonFileIOAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.3.1',
  'rttMonFileIOAdminFilePath' => '1.3.6.1.4.1.9.9.42.1.2.3.1.1',
  'rttMonFileIOAdminSize' => '1.3.6.1.4.1.9.9.42.1.2.3.1.2',
  'rttMonFileIOAdminSizeDefinition' => 'CISCO-RTTMON-MIB::rttMonFileIOAdminSize',
  'rttMonFileIOAdminAction' => '1.3.6.1.4.1.9.9.42.1.2.3.1.3',
  'rttMonFileIOAdminActionDefinition' => 'CISCO-RTTMON-MIB::rttMonFileIOAdminAction',
  'rttMonScriptAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.4',
  'rttMonScriptAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.4.1',
  'rttMonScriptAdminName' => '1.3.6.1.4.1.9.9.42.1.2.4.1.1',
  'rttMonScriptAdminCmdLineParams' => '1.3.6.1.4.1.9.9.42.1.2.4.1.2',
  'rttMonScheduleAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.5',
  'rttMonScheduleAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.5.1',
  'rttMonScheduleAdminRttLife' => '1.3.6.1.4.1.9.9.42.1.2.5.1.1',
  'rttMonScheduleAdminRttStartTime' => '1.3.6.1.4.1.9.9.42.1.2.5.1.2',
  'rttMonScheduleAdminConceptRowAgeout' => '1.3.6.1.4.1.9.9.42.1.2.5.1.3',
  'rttMonScheduleAdminRttRecurring' => '1.3.6.1.4.1.9.9.42.1.2.5.1.4',
  'rttMonScheduleAdminConceptRowAgeoutV2' => '1.3.6.1.4.1.9.9.42.1.2.5.1.5',
  'rttMonScheduleAdminStartType' => '1.3.6.1.4.1.9.9.42.1.2.5.1.6',
  'rttMonScheduleAdminStartDelay' => '1.3.6.1.4.1.9.9.42.1.2.5.1.7',
  'rttMonReactAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.6',
  'rttMonReactAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.6.1',
  'rttMonReactAdminConnectionEnable' => '1.3.6.1.4.1.9.9.42.1.2.6.1.1',
  'rttMonReactAdminTimeoutEnable' => '1.3.6.1.4.1.9.9.42.1.2.6.1.2',
  'rttMonReactAdminThresholdType' => '1.3.6.1.4.1.9.9.42.1.2.6.1.3',
  'rttMonReactAdminThresholdTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonReactAdminThresholdType',
  'rttMonReactAdminThresholdFalling' => '1.3.6.1.4.1.9.9.42.1.2.6.1.4',
  'rttMonReactAdminThresholdCount' => '1.3.6.1.4.1.9.9.42.1.2.6.1.5',
  'rttMonReactAdminThresholdCount2' => '1.3.6.1.4.1.9.9.42.1.2.6.1.6',
  'rttMonReactAdminActionType' => '1.3.6.1.4.1.9.9.42.1.2.6.1.7',
  'rttMonReactAdminActionTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonReactAdminActionType',
  'rttMonReactAdminVerifyErrorEnable' => '1.3.6.1.4.1.9.9.42.1.2.6.1.8',
  'rttMonStatisticsAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.7',
  'rttMonStatisticsAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.7.1',
  'rttMonStatisticsAdminNumHourGroups' => '1.3.6.1.4.1.9.9.42.1.2.7.1.1',
  'rttMonStatisticsAdminNumPaths' => '1.3.6.1.4.1.9.9.42.1.2.7.1.2',
  'rttMonStatisticsAdminNumHops' => '1.3.6.1.4.1.9.9.42.1.2.7.1.3',
  'rttMonStatisticsAdminNumDistBuckets' => '1.3.6.1.4.1.9.9.42.1.2.7.1.4',
  'rttMonStatisticsAdminDistInterval' => '1.3.6.1.4.1.9.9.42.1.2.7.1.5',
  'rttMonHistoryAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.8',
  'rttMonHistoryAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.8.1',
  'rttMonHistoryAdminNumLives' => '1.3.6.1.4.1.9.9.42.1.2.8.1.1',
  'rttMonHistoryAdminNumBuckets' => '1.3.6.1.4.1.9.9.42.1.2.8.1.2',
  'rttMonHistoryAdminNumSamples' => '1.3.6.1.4.1.9.9.42.1.2.8.1.3',
  'rttMonHistoryAdminFilter' => '1.3.6.1.4.1.9.9.42.1.2.8.1.4',
  'rttMonHistoryAdminFilterDefinition' => 'CISCO-RTTMON-MIB::rttMonHistoryAdminFilter',
  'rttMonCtrlOperTable' => '1.3.6.1.4.1.9.9.42.1.2.9',
  'rttMonCtrlOperEntry' => '1.3.6.1.4.1.9.9.42.1.2.9.1',
  'rttMonCtrlOperModificationTime' => '1.3.6.1.4.1.9.9.42.1.2.9.1.1',
  'rttMonCtrlOperDiagText' => '1.3.6.1.4.1.9.9.42.1.2.9.1.2',
  'rttMonCtrlOperResetTime' => '1.3.6.1.4.1.9.9.42.1.2.9.1.3',
  'rttMonCtrlOperOctetsInUse' => '1.3.6.1.4.1.9.9.42.1.2.9.1.4',
  'rttMonCtrlOperConnectionLostOccurred' => '1.3.6.1.4.1.9.9.42.1.2.9.1.5',
  'rttMonCtrlOperConnectionLostOccurredDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'rttMonCtrlOperTimeoutOccurred' => '1.3.6.1.4.1.9.9.42.1.2.9.1.6',
  'rttMonCtrlOperTimeoutOccurredDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'rttMonCtrlOperOverThresholdOccurred' => '1.3.6.1.4.1.9.9.42.1.2.9.1.7',
  'rttMonCtrlOperOverThresholdOccurredDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'rttMonCtrlOperNumRtts' => '1.3.6.1.4.1.9.9.42.1.2.9.1.8',
  'rttMonCtrlOperRttLife' => '1.3.6.1.4.1.9.9.42.1.2.9.1.9',
  'rttMonCtrlOperState' => '1.3.6.1.4.1.9.9.42.1.2.9.1.10',
  'rttMonCtrlOperStateDefinition' => 'CISCO-RTTMON-MIB::rttMonCtrlOperState',
  'rttMonCtrlOperVerifyErrorOccurred' => '1.3.6.1.4.1.9.9.42.1.2.9.1.11',
  'rttMonCtrlOperVerifyErrorOccurredDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'rttMonLatestRttOperTable' => '1.3.6.1.4.1.9.9.42.1.2.10',
  'rttMonLatestRttOperEntry' => '1.3.6.1.4.1.9.9.42.1.2.10.1',
  'rttMonLatestRttOperCompletionTime' => '1.3.6.1.4.1.9.9.42.1.2.10.1.1',
  'rttMonLatestRttOperSense' => '1.3.6.1.4.1.9.9.42.1.2.10.1.2',
  'rttMonLatestRttOperSenseDefinition' => 'CISCO-RTTMON-TC-MIB::RttResponseSense',

  'rttMonLatestRttOperApplSpecificSense' => '1.3.6.1.4.1.9.9.42.1.2.10.1.3',
  'rttMonLatestRttOperSenseDescription' => '1.3.6.1.4.1.9.9.42.1.2.10.1.4',
  'rttMonLatestRttOperTime' => '1.3.6.1.4.1.9.9.42.1.2.10.1.5',
  'rttMonLatestRttOperAddress' => '1.3.6.1.4.1.9.9.42.1.2.10.1.6',
  'rttMonReactTriggerAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.11',
  'rttMonReactTriggerAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.11.1',
  'rttMonReactTriggerAdminRttMonCtrlAdminIndex' => '1.3.6.1.4.1.9.9.42.1.2.11.1.1',
  'rttMonReactTriggerAdminStatus' => '1.3.6.1.4.1.9.9.42.1.2.11.1.2',
  'rttMonReactTriggerOperTable' => '1.3.6.1.4.1.9.9.42.1.2.12',
  'rttMonReactTriggerOperEntry' => '1.3.6.1.4.1.9.9.42.1.2.12.1',
  'rttMonReactTriggerOperState' => '1.3.6.1.4.1.9.9.42.1.2.12.1.1',
  'rttMonReactTriggerOperStateDefinition' => 'CISCO-RTTMON-MIB::rttMonReactTriggerOperState',
  'rttMonEchoPathAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.13',
  'rttMonEchoPathAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.13.1',
  'rttMonEchoPathAdminHopIndex' => '1.3.6.1.4.1.9.9.42.1.2.13.1.1',
  'rttMonEchoPathAdminHopAddress' => '1.3.6.1.4.1.9.9.42.1.2.13.1.2',
  'rttMonGrpScheduleAdminTable' => '1.3.6.1.4.1.9.9.42.1.2.14',
  'rttMonGrpScheduleAdminEntry' => '1.3.6.1.4.1.9.9.42.1.2.14.1',
  'rttMonGrpScheduleAdminIndex' => '1.3.6.1.4.1.9.9.42.1.2.14.1.1',
  'rttMonGrpScheduleAdminProbes' => '1.3.6.1.4.1.9.9.42.1.2.14.1.2',
  'rttMonGrpScheduleAdminPeriod' => '1.3.6.1.4.1.9.9.42.1.2.14.1.3',
  'rttMonGrpScheduleAdminFrequency' => '1.3.6.1.4.1.9.9.42.1.2.14.1.4',
  'rttMonGrpScheduleAdminLife' => '1.3.6.1.4.1.9.9.42.1.2.14.1.5',
  'rttMonGrpScheduleAdminAgeout' => '1.3.6.1.4.1.9.9.42.1.2.14.1.6',
  'rttMonGrpScheduleAdminStatus' => '1.3.6.1.4.1.9.9.42.1.2.14.1.7',
  'rttMonGrpScheduleAdminFreqMax' => '1.3.6.1.4.1.9.9.42.1.2.14.1.8',
  'rttMonGrpScheduleAdminFreqMin' => '1.3.6.1.4.1.9.9.42.1.2.14.1.9',
  'rttMonGrpScheduleAdminStartTime' => '1.3.6.1.4.1.9.9.42.1.2.14.1.10',
  'rttMonGrpScheduleAdminAdd' => '1.3.6.1.4.1.9.9.42.1.2.14.1.11',
  'rttMonGrpScheduleAdminDelete' => '1.3.6.1.4.1.9.9.42.1.2.14.1.12',
  'rttMonGrpScheduleAdminReset' => '1.3.6.1.4.1.9.9.42.1.2.14.1.13',
  'rttMonGrpScheduleAdminStartType' => '1.3.6.1.4.1.9.9.42.1.2.14.1.14',
  'rttMonGrpScheduleAdminStartDelay' => '1.3.6.1.4.1.9.9.42.1.2.14.1.15',
  'rttMplsVpnMonCtrlTable' => '1.3.6.1.4.1.9.9.42.1.2.15',
  'rttMplsVpnMonCtrlEntry' => '1.3.6.1.4.1.9.9.42.1.2.15.1',
  'rttMplsVpnMonCtrlIndex' => '1.3.6.1.4.1.9.9.42.1.2.15.1.1',
  'rttMplsVpnMonCtrlRttType' => '1.3.6.1.4.1.9.9.42.1.2.15.1.2',
  'rttMplsVpnMonCtrlVrfName' => '1.3.6.1.4.1.9.9.42.1.2.15.1.3',
  'rttMplsVpnMonCtrlTag' => '1.3.6.1.4.1.9.9.42.1.2.15.1.4',
  'rttMplsVpnMonCtrlThreshold' => '1.3.6.1.4.1.9.9.42.1.2.15.1.5',
  'rttMplsVpnMonCtrlTimeout' => '1.3.6.1.4.1.9.9.42.1.2.15.1.6',
  'rttMplsVpnMonCtrlScanInterval' => '1.3.6.1.4.1.9.9.42.1.2.15.1.7',
  'rttMplsVpnMonCtrlDelScanFactor' => '1.3.6.1.4.1.9.9.42.1.2.15.1.8',
  'rttMplsVpnMonCtrlEXP' => '1.3.6.1.4.1.9.9.42.1.2.15.1.9',
  'rttMplsVpnMonCtrlRequestSize' => '1.3.6.1.4.1.9.9.42.1.2.15.1.10',
  'rttMplsVpnMonCtrlVerifyData' => '1.3.6.1.4.1.9.9.42.1.2.15.1.11',
  'rttMplsVpnMonCtrlStorageType' => '1.3.6.1.4.1.9.9.42.1.2.15.1.12',
  'rttMplsVpnMonCtrlProbeList' => '1.3.6.1.4.1.9.9.42.1.2.15.1.13',
  'rttMplsVpnMonCtrlStatus' => '1.3.6.1.4.1.9.9.42.1.2.15.1.14',
  'rttMplsVpnMonCtrlLpd' => '1.3.6.1.4.1.9.9.42.1.2.15.1.15',
  'rttMplsVpnMonCtrlLpdGrpList' => '1.3.6.1.4.1.9.9.42.1.2.15.1.16',
  'rttMplsVpnMonCtrlLpdCompTime' => '1.3.6.1.4.1.9.9.42.1.2.15.1.17',
  'rttMplsVpnMonTypeTable' => '1.3.6.1.4.1.9.9.42.1.2.16',
  'rttMplsVpnMonTypeEntry' => '1.3.6.1.4.1.9.9.42.1.2.16.1',
  'rttMplsVpnMonTypeInterval' => '1.3.6.1.4.1.9.9.42.1.2.16.1.1',
  'rttMplsVpnMonTypeNumPackets' => '1.3.6.1.4.1.9.9.42.1.2.16.1.2',
  'rttMplsVpnMonTypeDestPort' => '1.3.6.1.4.1.9.9.42.1.2.16.1.3',
  'rttMplsVpnMonTypeSecFreqType' => '1.3.6.1.4.1.9.9.42.1.2.16.1.4',
  'rttMplsVpnMonTypeSecFreqTypeDefinition' => 'CISCO-RTTMON-MIB::rttMplsVpnMonTypeSecFreqType',
  'rttMplsVpnMonTypeSecFreqValue' => '1.3.6.1.4.1.9.9.42.1.2.16.1.5',
  'rttMplsVpnMonTypeLspSelector' => '1.3.6.1.4.1.9.9.42.1.2.16.1.6',
  'rttMplsVpnMonTypeLSPReplyMode' => '1.3.6.1.4.1.9.9.42.1.2.16.1.7',
  'rttMplsVpnMonTypeLSPTTL' => '1.3.6.1.4.1.9.9.42.1.2.16.1.8',
  'rttMplsVpnMonTypeLSPReplyDscp' => '1.3.6.1.4.1.9.9.42.1.2.16.1.9',
  'rttMplsVpnMonTypeLpdMaxSessions' => '1.3.6.1.4.1.9.9.42.1.2.16.1.10',
  'rttMplsVpnMonTypeLpdSessTimeout' => '1.3.6.1.4.1.9.9.42.1.2.16.1.11',
  'rttMplsVpnMonTypeLpdEchoTimeout' => '1.3.6.1.4.1.9.9.42.1.2.16.1.12',
  'rttMplsVpnMonTypeLpdEchoInterval' => '1.3.6.1.4.1.9.9.42.1.2.16.1.13',
  'rttMplsVpnMonTypeLpdEchoNullShim' => '1.3.6.1.4.1.9.9.42.1.2.16.1.14',
  'rttMplsVpnMonTypeLpdScanPeriod' => '1.3.6.1.4.1.9.9.42.1.2.16.1.15',
  'rttMplsVpnMonTypeLpdStatHours' => '1.3.6.1.4.1.9.9.42.1.2.16.1.16',
  'rttMplsVpnMonScheduleTable' => '1.3.6.1.4.1.9.9.42.1.2.17',
  'rttMplsVpnMonScheduleEntry' => '1.3.6.1.4.1.9.9.42.1.2.17.1',
  'rttMplsVpnMonScheduleRttStartTime' => '1.3.6.1.4.1.9.9.42.1.2.17.1.1',
  'rttMplsVpnMonSchedulePeriod' => '1.3.6.1.4.1.9.9.42.1.2.17.1.2',
  'rttMplsVpnMonScheduleFrequency' => '1.3.6.1.4.1.9.9.42.1.2.17.1.3',
  'rttMplsVpnMonReactTable' => '1.3.6.1.4.1.9.9.42.1.2.18',
  'rttMplsVpnMonReactEntry' => '1.3.6.1.4.1.9.9.42.1.2.18.1',
  'rttMplsVpnMonReactConnectionEnable' => '1.3.6.1.4.1.9.9.42.1.2.18.1.1',
  'rttMplsVpnMonReactTimeoutEnable' => '1.3.6.1.4.1.9.9.42.1.2.18.1.2',
  'rttMplsVpnMonReactThresholdType' => '1.3.6.1.4.1.9.9.42.1.2.18.1.3',
  'rttMplsVpnMonReactThresholdTypeDefinition' => 'CISCO-RTTMON-MIB::rttMplsVpnMonReactThresholdType',
  'rttMplsVpnMonReactThresholdCount' => '1.3.6.1.4.1.9.9.42.1.2.18.1.4',
  'rttMplsVpnMonReactActionType' => '1.3.6.1.4.1.9.9.42.1.2.18.1.5',
  'rttMplsVpnMonReactActionTypeDefinition' => 'CISCO-RTTMON-MIB::rttMplsVpnMonReactActionType',
  'rttMplsVpnMonReactLpdNotifyType' => '1.3.6.1.4.1.9.9.42.1.2.18.1.6',
  'rttMplsVpnMonReactLpdNotifyTypeDefinition' => 'CISCO-RTTMON-MIB::rttMplsVpnMonReactLpdNotifyType',
  'rttMplsVpnMonReactLpdRetryCount' => '1.3.6.1.4.1.9.9.42.1.2.18.1.7',
  'rttMonReactTable' => '1.3.6.1.4.1.9.9.42.1.2.19',
  'rttMonReactEntry' => '1.3.6.1.4.1.9.9.42.1.2.19.1',
  'rttMonReactConfigIndex' => '1.3.6.1.4.1.9.9.42.1.2.19.1.1',
  'rttMonReactVar' => '1.3.6.1.4.1.9.9.42.1.2.19.1.2',
  'rttMonReactThresholdType' => '1.3.6.1.4.1.9.9.42.1.2.19.1.3',
  'rttMonReactThresholdTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonReactThresholdType',
  'rttMonReactActionType' => '1.3.6.1.4.1.9.9.42.1.2.19.1.4',
  'rttMonReactActionTypeDefinition' => 'CISCO-RTTMON-MIB::rttMonReactActionType',
  'rttMonReactThresholdRising' => '1.3.6.1.4.1.9.9.42.1.2.19.1.5',
  'rttMonReactThresholdFalling' => '1.3.6.1.4.1.9.9.42.1.2.19.1.6',
  'rttMonReactThresholdCountX' => '1.3.6.1.4.1.9.9.42.1.2.19.1.7',
  'rttMonReactThresholdCountY' => '1.3.6.1.4.1.9.9.42.1.2.19.1.8',
  'rttMonReactValue' => '1.3.6.1.4.1.9.9.42.1.2.19.1.9',
  'rttMonReactOccurred' => '1.3.6.1.4.1.9.9.42.1.2.19.1.10',
  'rttMonReactStatus' => '1.3.6.1.4.1.9.9.42.1.2.19.1.11',
  'rttMonGeneratedOperTable' => '1.3.6.1.4.1.9.9.42.1.2.20',
  'rttMonGeneratedOperEntry' => '1.3.6.1.4.1.9.9.42.1.2.20.1',
  'rttMonGeneratedOperRespIpAddrType' => '1.3.6.1.4.1.9.9.42.1.2.20.1.1',
  'rttMonGeneratedOperRespIpAddr' => '1.3.6.1.4.1.9.9.42.1.2.20.1.2',
  'rttMonGeneratedOperCtrlAdminIndex' => '1.3.6.1.4.1.9.9.42.1.2.20.1.3',
  'rttMonStats' => '1.3.6.1.4.1.9.9.42.1.3',
  'rttMonStatsCaptureTable' => '1.3.6.1.4.1.9.9.42.1.3.1',
  'rttMonStatsCaptureEntry' => '1.3.6.1.4.1.9.9.42.1.3.1.1',
  'rttMonStatsCaptureStartTimeIndex' => '1.3.6.1.4.1.9.9.42.1.3.1.1.1',
  'rttMonStatsCapturePathIndex' => '1.3.6.1.4.1.9.9.42.1.3.1.1.2',
  'rttMonStatsCaptureHopIndex' => '1.3.6.1.4.1.9.9.42.1.3.1.1.3',
  'rttMonStatsCaptureDistIndex' => '1.3.6.1.4.1.9.9.42.1.3.1.1.4',
  'rttMonStatsCaptureCompletions' => '1.3.6.1.4.1.9.9.42.1.3.1.1.5',
  'rttMonStatsCaptureOverThresholds' => '1.3.6.1.4.1.9.9.42.1.3.1.1.6',
  'rttMonStatsCaptureSumCompletionTime' => '1.3.6.1.4.1.9.9.42.1.3.1.1.7',
  'rttMonStatsCaptureSumCompletionTime2Low' => '1.3.6.1.4.1.9.9.42.1.3.1.1.8',
  'rttMonStatsCaptureSumCompletionTime2High' => '1.3.6.1.4.1.9.9.42.1.3.1.1.9',
  'rttMonStatsCaptureCompletionTimeMax' => '1.3.6.1.4.1.9.9.42.1.3.1.1.10',
  'rttMonStatsCaptureCompletionTimeMin' => '1.3.6.1.4.1.9.9.42.1.3.1.1.11',
  'rttMonStatsCollectTable' => '1.3.6.1.4.1.9.9.42.1.3.2',
  'rttMonStatsCollectEntry' => '1.3.6.1.4.1.9.9.42.1.3.2.1',
  'rttMonStatsCollectNumDisconnects' => '1.3.6.1.4.1.9.9.42.1.3.2.1.1',
  'rttMonStatsCollectTimeouts' => '1.3.6.1.4.1.9.9.42.1.3.2.1.2',
  'rttMonStatsCollectBusies' => '1.3.6.1.4.1.9.9.42.1.3.2.1.3',
  'rttMonStatsCollectNoConnections' => '1.3.6.1.4.1.9.9.42.1.3.2.1.4',
  'rttMonStatsCollectDrops' => '1.3.6.1.4.1.9.9.42.1.3.2.1.5',
  'rttMonStatsCollectSequenceErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.6',
  'rttMonStatsCollectVerifyErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.7',
  'rttMonStatsCollectAddress' => '1.3.6.1.4.1.9.9.42.1.3.2.1.8',
  'rttMonControlEnableErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.9',
  'rttMonStatsRetrieveErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.10',
  'rttMonStatsCollectCtrlEnErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.11',
  'rttMonStatsCollectRetrieveErrors' => '1.3.6.1.4.1.9.9.42.1.3.2.1.12',
  'rttMonStatsTotalsTable' => '1.3.6.1.4.1.9.9.42.1.3.3',
  'rttMonStatsTotalsEntry' => '1.3.6.1.4.1.9.9.42.1.3.3.1',
  'rttMonStatsTotalsElapsedTime' => '1.3.6.1.4.1.9.9.42.1.3.3.1.1',
  'rttMonStatsTotalsInitiations' => '1.3.6.1.4.1.9.9.42.1.3.3.1.2',
  'rttMonHTTPStatsTable' => '1.3.6.1.4.1.9.9.42.1.3.4',
  'rttMonHTTPStatsEntry' => '1.3.6.1.4.1.9.9.42.1.3.4.1',
  'rttMonHTTPStatsStartTimeIndex' => '1.3.6.1.4.1.9.9.42.1.3.4.1.1',
  'rttMonHTTPStatsCompletions' => '1.3.6.1.4.1.9.9.42.1.3.4.1.2',
  'rttMonHTTPStatsOverThresholds' => '1.3.6.1.4.1.9.9.42.1.3.4.1.3',
  'rttMonHTTPStatsRTTSum' => '1.3.6.1.4.1.9.9.42.1.3.4.1.4',
  'rttMonHTTPStatsRTTSum2Low' => '1.3.6.1.4.1.9.9.42.1.3.4.1.5',
  'rttMonHTTPStatsRTTSum2High' => '1.3.6.1.4.1.9.9.42.1.3.4.1.6',
  'rttMonHTTPStatsRTTMin' => '1.3.6.1.4.1.9.9.42.1.3.4.1.7',
  'rttMonHTTPStatsRTTMax' => '1.3.6.1.4.1.9.9.42.1.3.4.1.8',
  'rttMonHTTPStatsDNSRTTSum' => '1.3.6.1.4.1.9.9.42.1.3.4.1.9',
  'rttMonHTTPStatsTCPConnectRTTSum' => '1.3.6.1.4.1.9.9.42.1.3.4.1.10',
  'rttMonHTTPStatsTransactionRTTSum' => '1.3.6.1.4.1.9.9.42.1.3.4.1.11',
  'rttMonHTTPStatsMessageBodyOctetsSum' => '1.3.6.1.4.1.9.9.42.1.3.4.1.12',
  'rttMonHTTPStatsDNSServerTimeout' => '1.3.6.1.4.1.9.9.42.1.3.4.1.13',
  'rttMonHTTPStatsTCPConnectTimeout' => '1.3.6.1.4.1.9.9.42.1.3.4.1.14',
  'rttMonHTTPStatsTransactionTimeout' => '1.3.6.1.4.1.9.9.42.1.3.4.1.15',
  'rttMonHTTPStatsDNSQueryError' => '1.3.6.1.4.1.9.9.42.1.3.4.1.16',
  'rttMonHTTPStatsHTTPError' => '1.3.6.1.4.1.9.9.42.1.3.4.1.17',
  'rttMonHTTPStatsError' => '1.3.6.1.4.1.9.9.42.1.3.4.1.18',
  'rttMonHTTPStatsBusies' => '1.3.6.1.4.1.9.9.42.1.3.4.1.19',
  'rttMonJitterStatsTable' => '1.3.6.1.4.1.9.9.42.1.3.5',
  'rttMonJitterStatsEntry' => '1.3.6.1.4.1.9.9.42.1.3.5.1',
  'rttMonJitterStatsStartTimeIndex' => '1.3.6.1.4.1.9.9.42.1.3.5.1.1',
  'rttMonJitterStatsCompletions' => '1.3.6.1.4.1.9.9.42.1.3.5.1.2',
  'rttMonJitterStatsOverThresholds' => '1.3.6.1.4.1.9.9.42.1.3.5.1.3',
  'rttMonJitterStatsNumOfRTT' => '1.3.6.1.4.1.9.9.42.1.3.5.1.4',
  'rttMonJitterStatsRTTSum' => '1.3.6.1.4.1.9.9.42.1.3.5.1.5',
  'rttMonJitterStatsRTTSum2Low' => '1.3.6.1.4.1.9.9.42.1.3.5.1.6',
  'rttMonJitterStatsRTTSum2High' => '1.3.6.1.4.1.9.9.42.1.3.5.1.7',
  'rttMonJitterStatsRTTMin' => '1.3.6.1.4.1.9.9.42.1.3.5.1.8',
  'rttMonJitterStatsRTTMax' => '1.3.6.1.4.1.9.9.42.1.3.5.1.9',
  'rttMonJitterStatsMinOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.10',
  'rttMonJitterStatsMaxOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.11',
  'rttMonJitterStatsNumOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.12',
  'rttMonJitterStatsSumOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.13',
  'rttMonJitterStatsSum2PositivesSDLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.14',
  'rttMonJitterStatsSum2PositivesSDHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.15',
  'rttMonJitterStatsMinOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.16',
  'rttMonJitterStatsMaxOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.17',
  'rttMonJitterStatsNumOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.18',
  'rttMonJitterStatsSumOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.19',
  'rttMonJitterStatsSum2NegativesSDLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.20',
  'rttMonJitterStatsSum2NegativesSDHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.21',
  'rttMonJitterStatsMinOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.22',
  'rttMonJitterStatsMaxOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.23',
  'rttMonJitterStatsNumOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.24',
  'rttMonJitterStatsSumOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.25',
  'rttMonJitterStatsSum2PositivesDSLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.26',
  'rttMonJitterStatsSum2PositivesDSHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.27',
  'rttMonJitterStatsMinOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.28',
  'rttMonJitterStatsMaxOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.29',
  'rttMonJitterStatsNumOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.30',
  'rttMonJitterStatsSumOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.31',
  'rttMonJitterStatsSum2NegativesDSLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.32',
  'rttMonJitterStatsSum2NegativesDSHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.33',
  'rttMonJitterStatsPacketLossSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.34',
  'rttMonJitterStatsPacketLossDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.35',
  'rttMonJitterStatsPacketOutOfSequence' => '1.3.6.1.4.1.9.9.42.1.3.5.1.36',
  'rttMonJitterStatsPacketMIA' => '1.3.6.1.4.1.9.9.42.1.3.5.1.37',
  'rttMonJitterStatsPacketLateArrival' => '1.3.6.1.4.1.9.9.42.1.3.5.1.38',
  'rttMonJitterStatsError' => '1.3.6.1.4.1.9.9.42.1.3.5.1.39',
  'rttMonJitterStatsBusies' => '1.3.6.1.4.1.9.9.42.1.3.5.1.40',
  'rttMonJitterStatsOWSumSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.41',
  'rttMonJitterStatsOWSum2SDLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.42',
  'rttMonJitterStatsOWSum2SDHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.43',
  'rttMonJitterStatsOWMinSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.44',
  'rttMonJitterStatsOWMaxSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.45',
  'rttMonJitterStatsOWSumDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.46',
  'rttMonJitterStatsOWSum2DSLow' => '1.3.6.1.4.1.9.9.42.1.3.5.1.47',
  'rttMonJitterStatsOWSum2DSHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.48',
  'rttMonJitterStatsOWMinDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.49',
  'rttMonJitterStatsOWMaxDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.50',
  'rttMonJitterStatsNumOfOW' => '1.3.6.1.4.1.9.9.42.1.3.5.1.51',
  'rttMonJitterStatsOWMinSDNew' => '1.3.6.1.4.1.9.9.42.1.3.5.1.52',
  'rttMonJitterStatsOWMaxSDNew' => '1.3.6.1.4.1.9.9.42.1.3.5.1.53',
  'rttMonJitterStatsOWMinDSNew' => '1.3.6.1.4.1.9.9.42.1.3.5.1.54',
  'rttMonJitterStatsOWMaxDSNew' => '1.3.6.1.4.1.9.9.42.1.3.5.1.55',
  'rttMonJitterStatsMinOfMOS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.56',
  'rttMonJitterStatsMaxOfMOS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.57',
  'rttMonJitterStatsMinOfICPIF' => '1.3.6.1.4.1.9.9.42.1.3.5.1.58',
  'rttMonJitterStatsMaxOfICPIF' => '1.3.6.1.4.1.9.9.42.1.3.5.1.59',
  'rttMonJitterStatsIAJOut' => '1.3.6.1.4.1.9.9.42.1.3.5.1.60',
  'rttMonJitterStatsIAJIn' => '1.3.6.1.4.1.9.9.42.1.3.5.1.61',
  'rttMonJitterStatsAvgJitter' => '1.3.6.1.4.1.9.9.42.1.3.5.1.62',
  'rttMonJitterStatsAvgJitterSD' => '1.3.6.1.4.1.9.9.42.1.3.5.1.63',
  'rttMonJitterStatsAvgJitterDS' => '1.3.6.1.4.1.9.9.42.1.3.5.1.64',
  'rttMonJitterStatsUnSyncRTs' => '1.3.6.1.4.1.9.9.42.1.3.5.1.65',
  'rttMonJitterStatsRTTSumHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.66',
  'rttMonJitterStatsOWSumSDHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.67',
  'rttMonJitterStatsOWSumDSHigh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.68',
  'rttMonJitterStatsNumOverThresh' => '1.3.6.1.4.1.9.9.42.1.3.5.1.69',
  'rttMonLpdGrpStatsTable' => '1.3.6.1.4.1.9.9.42.1.3.7',
  'rttMonLpdGrpStatsEntry' => '1.3.6.1.4.1.9.9.42.1.3.7.1',
  'rttMonLpdGrpStatsGroupIndex' => '1.3.6.1.4.1.9.9.42.1.3.7.1.1',
  'rttMonLpdGrpStatsStartTimeIndex' => '1.3.6.1.4.1.9.9.42.1.3.7.1.2',
  'rttMonLpdGrpStatsTargetPE' => '1.3.6.1.4.1.9.9.42.1.3.7.1.3',
  'rttMonLpdGrpStatsNumOfPass' => '1.3.6.1.4.1.9.9.42.1.3.7.1.4',
  'rttMonLpdGrpStatsNumOfFail' => '1.3.6.1.4.1.9.9.42.1.3.7.1.5',
  'rttMonLpdGrpStatsNumOfTimeout' => '1.3.6.1.4.1.9.9.42.1.3.7.1.6',
  'rttMonLpdGrpStatsAvgRTT' => '1.3.6.1.4.1.9.9.42.1.3.7.1.7',
  'rttMonLpdGrpStatsMinRTT' => '1.3.6.1.4.1.9.9.42.1.3.7.1.8',
  'rttMonLpdGrpStatsMaxRTT' => '1.3.6.1.4.1.9.9.42.1.3.7.1.9',
  'rttMonLpdGrpStatsMinNumPaths' => '1.3.6.1.4.1.9.9.42.1.3.7.1.10',
  'rttMonLpdGrpStatsMaxNumPaths' => '1.3.6.1.4.1.9.9.42.1.3.7.1.11',
  'rttMonLpdGrpStatsLPDStartTime' => '1.3.6.1.4.1.9.9.42.1.3.7.1.12',
  'rttMonLpdGrpStatsLPDFailOccurred' => '1.3.6.1.4.1.9.9.42.1.3.7.1.13',
  'rttMonLpdGrpStatsLPDFailCause' => '1.3.6.1.4.1.9.9.42.1.3.7.1.14',
  'rttMonLpdGrpStatsLPDCompTime' => '1.3.6.1.4.1.9.9.42.1.3.7.1.15',
  'rttMonLpdGrpStatsGroupStatus' => '1.3.6.1.4.1.9.9.42.1.3.7.1.16',
  'rttMonLpdGrpStatsGroupProbeIndex' => '1.3.6.1.4.1.9.9.42.1.3.7.1.17',
  'rttMonLpdGrpStatsPathIds' => '1.3.6.1.4.1.9.9.42.1.3.7.1.18',
  'rttMonLpdGrpStatsProbeStatus' => '1.3.6.1.4.1.9.9.42.1.3.7.1.19',
  'rttMonLpdGrpStatsResetTime' => '1.3.6.1.4.1.9.9.42.1.3.7.1.20',
  'rttMonHistory' => '1.3.6.1.4.1.9.9.42.1.4',
  'rttMonHistoryCollectionTable' => '1.3.6.1.4.1.9.9.42.1.4.1',
  'rttMonHistoryCollectionEntry' => '1.3.6.1.4.1.9.9.42.1.4.1.1',
  'rttMonHistoryCollectionLifeIndex' => '1.3.6.1.4.1.9.9.42.1.4.1.1.1',
  'rttMonHistoryCollectionBucketIndex' => '1.3.6.1.4.1.9.9.42.1.4.1.1.2',
  'rttMonHistoryCollectionSampleIndex' => '1.3.6.1.4.1.9.9.42.1.4.1.1.3',
  'rttMonHistoryCollectionSampleTime' => '1.3.6.1.4.1.9.9.42.1.4.1.1.4',
  'rttMonHistoryCollectionAddress' => '1.3.6.1.4.1.9.9.42.1.4.1.1.5',
  'rttMonHistoryCollectionCompletionTime' => '1.3.6.1.4.1.9.9.42.1.4.1.1.6',
  'rttMonHistoryCollectionSense' => '1.3.6.1.4.1.9.9.42.1.4.1.1.7',
  'rttMonHistoryCollectionApplSpecificSense' => '1.3.6.1.4.1.9.9.42.1.4.1.1.8',
  'rttMonHistoryCollectionSenseDescription' => '1.3.6.1.4.1.9.9.42.1.4.1.1.9',
  'rttMonLatestOper' => '1.3.6.1.4.1.9.9.42.1.5',
  'rttMonLatestHTTPOperTable' => '1.3.6.1.4.1.9.9.42.1.5.1',
  'rttMonLatestHTTPOperEntry' => '1.3.6.1.4.1.9.9.42.1.5.1.1',
  'rttMonLatestHTTPOperRTT' => '1.3.6.1.4.1.9.9.42.1.5.1.1.1',
  'rttMonLatestHTTPOperDNSRTT' => '1.3.6.1.4.1.9.9.42.1.5.1.1.2',
  'rttMonLatestHTTPOperTCPConnectRTT' => '1.3.6.1.4.1.9.9.42.1.5.1.1.3',
  'rttMonLatestHTTPOperTransactionRTT' => '1.3.6.1.4.1.9.9.42.1.5.1.1.4',
  'rttMonLatestHTTPOperMessageBodyOctets' => '1.3.6.1.4.1.9.9.42.1.5.1.1.5',
  'rttMonLatestHTTPOperSense' => '1.3.6.1.4.1.9.9.42.1.5.1.1.6',
  'rttMonLatestHTTPErrorSenseDescription' => '1.3.6.1.4.1.9.9.42.1.5.1.1.7',
  'rttMonLatestJitterOperTable' => '1.3.6.1.4.1.9.9.42.1.5.2',
  'rttMonLatestJitterOperEntry' => '1.3.6.1.4.1.9.9.42.1.5.2.1',
  'rttMonLatestJitterOperNumOfRTT' => '1.3.6.1.4.1.9.9.42.1.5.2.1.1',
  'rttMonLatestJitterOperRTTSum' => '1.3.6.1.4.1.9.9.42.1.5.2.1.2',
  'rttMonLatestJitterOperRTTSum2' => '1.3.6.1.4.1.9.9.42.1.5.2.1.3',
  'rttMonLatestJitterOperRTTMin' => '1.3.6.1.4.1.9.9.42.1.5.2.1.4',
  'rttMonLatestJitterOperRTTMax' => '1.3.6.1.4.1.9.9.42.1.5.2.1.5',
  'rttMonLatestJitterOperMinOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.6',
  'rttMonLatestJitterOperMaxOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.7',
  'rttMonLatestJitterOperNumOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.8',
  'rttMonLatestJitterOperSumOfPositivesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.9',
  'rttMonLatestJitterOperSum2PositivesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.10',
  'rttMonLatestJitterOperMinOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.11',
  'rttMonLatestJitterOperMaxOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.12',
  'rttMonLatestJitterOperNumOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.13',
  'rttMonLatestJitterOperSumOfNegativesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.14',
  'rttMonLatestJitterOperSum2NegativesSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.15',
  'rttMonLatestJitterOperMinOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.16',
  'rttMonLatestJitterOperMaxOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.17',
  'rttMonLatestJitterOperNumOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.18',
  'rttMonLatestJitterOperSumOfPositivesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.19',
  'rttMonLatestJitterOperSum2PositivesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.20',
  'rttMonLatestJitterOperMinOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.21',
  'rttMonLatestJitterOperMaxOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.22',
  'rttMonLatestJitterOperNumOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.23',
  'rttMonLatestJitterOperSumOfNegativesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.24',
  'rttMonLatestJitterOperSum2NegativesDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.25',
  'rttMonLatestJitterOperPacketLossSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.26',
  'rttMonLatestJitterOperPacketLossDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.27',
  'rttMonLatestJitterOperPacketOutOfSequence' => '1.3.6.1.4.1.9.9.42.1.5.2.1.28',
  'rttMonLatestJitterOperPacketMIA' => '1.3.6.1.4.1.9.9.42.1.5.2.1.29',
  'rttMonLatestJitterOperPacketLateArrival' => '1.3.6.1.4.1.9.9.42.1.5.2.1.30',
  'rttMonLatestJitterOperSense' => '1.3.6.1.4.1.9.9.42.1.5.2.1.31',
  'rttMonLatestJitterOperSenseDefinition' => 'CISCO-RTTMON-TC-MIB::RttResponseSense',

  'rttMonLatestJitterErrorSenseDescription' => '1.3.6.1.4.1.9.9.42.1.5.2.1.32',
  'rttMonLatestJitterOperOWSumSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.33',
  'rttMonLatestJitterOperOWSum2SD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.34',
  'rttMonLatestJitterOperOWMinSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.35',
  'rttMonLatestJitterOperOWMaxSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.36',
  'rttMonLatestJitterOperOWSumDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.37',
  'rttMonLatestJitterOperOWSum2DS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.38',
  'rttMonLatestJitterOperOWMinDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.39',
  'rttMonLatestJitterOperOWMaxDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.40',
  'rttMonLatestJitterOperNumOfOW' => '1.3.6.1.4.1.9.9.42.1.5.2.1.41',
  'rttMonLatestJitterOperMOS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.42',
  'rttMonLatestJitterOperICPIF' => '1.3.6.1.4.1.9.9.42.1.5.2.1.43',
  'rttMonLatestJitterOperIAJOut' => '1.3.6.1.4.1.9.9.42.1.5.2.1.44',
  'rttMonLatestJitterOperIAJIn' => '1.3.6.1.4.1.9.9.42.1.5.2.1.45',
  'rttMonLatestJitterOperAvgJitter' => '1.3.6.1.4.1.9.9.42.1.5.2.1.46',
  'rttMonLatestJitterOperAvgSDJ' => '1.3.6.1.4.1.9.9.42.1.5.2.1.47',
  'rttMonLatestJitterOperAvgDSJ' => '1.3.6.1.4.1.9.9.42.1.5.2.1.48',
  'rttMonLatestJitterOperOWAvgSD' => '1.3.6.1.4.1.9.9.42.1.5.2.1.49',
  'rttMonLatestJitterOperOWAvgDS' => '1.3.6.1.4.1.9.9.42.1.5.2.1.50',
  'rttMonLatestJitterOperNTPState' => '1.3.6.1.4.1.9.9.42.1.5.2.1.51',
  'rttMonLatestJitterOperNTPStateDefinition' => 'CISCO-RTTMON-MIB::rttMonLatestJitterOperNTPState',
  'rttMonLatestJitterOperUnSyncRTs' => '1.3.6.1.4.1.9.9.42.1.5.2.1.52',
  'rttMonLatestJitterOperRTTSumHigh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.53',
  'rttMonLatestJitterOperRTTSum2High' => '1.3.6.1.4.1.9.9.42.1.5.2.1.54',
  'rttMonLatestJitterOperOWSumSDHigh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.55',
  'rttMonLatestJitterOperOWSum2SDHigh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.56',
  'rttMonLatestJitterOperOWSumDSHigh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.57',
  'rttMonLatestJitterOperOWSum2DSHigh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.58',
  'rttMonLatestJitterOperNumOverThresh' => '1.3.6.1.4.1.9.9.42.1.5.2.1.59',
  'rttMonNotificationsPrefix' => '1.3.6.1.4.1.9.9.42.2',
  'rttMonNotifications' => '1.3.6.1.4.1.9.9.42.2.0',
  'ciscoRttMonMibConformance' => '1.3.6.1.4.1.9.9.42.3',
  'ciscoRttMonMibCompliances' => '1.3.6.1.4.1.9.9.42.3.1',
  'ciscoRttMonMibGroups' => '1.3.6.1.4.1.9.9.42.3.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-RTTMON-MIB'} = {
  'rttMonReactAdminThresholdType' => {
    '1' => 'never',
    '2' => 'immediate',
    '3' => 'consecutive',
    '4' => 'xOfy',
    '5' => 'average',
  },
  'rttMonEchoAdminReserveDsp' => {
    '1' => 'be',
    '2' => 'gs',
    '3' => 'na',
  },
  'rttMonLatestJitterOperNTPState' => {
    '1' => 'sync',
    '2' => 'outOfSync',
  },
  'rttMonApplPreConfigedType' => {
    '1' => 'filePath',
    '2' => 'scriptName',
  },
  'rttMonFileIOAdminAction' => {
    '1' => 'write',
    '2' => 'read',
    '3' => 'writeRead',
  },
  'rttMplsVpnMonTypeSecFreqType' => {
    '1' => 'none',
    '2' => 'timeout',
    '3' => 'connectionLoss',
    '4' => 'both',
  },
  'rttMonCtrlOperState' => {
    '1' => 'reset',
    '2' => 'orderlyStop',
    '3' => 'immediateStop',
    '4' => 'pending',
    '5' => 'inactive',
    '6' => 'active',
    '7' => 'restart',
  },
  'rttMonReactActionType' => {
    '1' => 'none',
    '2' => 'trapOnly',
    '3' => 'triggerOnly',
    '4' => 'trapAndTrigger',
  },
  'rttMonHistoryAdminFilter' => {
    '1' => 'none',
    '2' => 'all',
    '3' => 'overThreshold',
    '4' => 'failures',
  },
  'rttMonEchoAdminLSPFECType' => {
    '1' => 'ldpIpv4Prefix',
  },
  'rttMplsVpnMonReactLpdNotifyType' => {
    '1' => 'none',
    '2' => 'lpdPathDiscovery',
    '3' => 'lpdGroupStatus',
    '4' => 'lpdAll',
  },
  'rttMonEchoAdminProbePakPriority' => {
    '1' => 'normal',
    '2' => 'high',
  },
  'rttMplsVpnMonReactThresholdType' => {
    '1' => 'never',
    '2' => 'immediate',
    '3' => 'consecutive',
  },
  'rttMplsVpnMonReactActionType' => {
    '1' => 'none',
    '2' => 'trapOnly',
  },
  'rttMonEchoAdminPrecision' => {
    '1' => 'milliseconds',
    '2' => 'microseconds',
  },
  'rttMonReactTriggerOperState' => {
    '1' => 'active',
    '2' => 'pending',
  },
  'rttMonReactAdminActionType' => {
    '1' => 'none',
    '2' => 'trapOnly',
    '3' => 'nmvtOnly',
    '4' => 'triggerOnly',
    '5' => 'trapAndNmvt',
    '6' => 'trapAndTrigger',
    '7' => 'nmvtAndTrigger',
    '8' => 'trapNmvtAndTrigger',
  },
  'rttMonFileIOAdminSize' => {
    '1' => 'n256',
    '2' => 'n1k',
    '3' => 'n64k',
    '4' => 'n128k',
    '5' => 'n256k',
  },
  'rttMonEchoAdminOWNTPSyncTolType' => {
    '1' => 'percent',
    '2' => 'absolute',
  },
  'rttMonReactThresholdType' => {
    '1' => 'never',
    '2' => 'immediate',
    '3' => 'consecutive',
    '4' => 'xOfy',
    '5' => 'average',
  },
};

