package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOFIREPOWERAPTCMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-FIREPOWER-AP-TC-MIB'} = {
  url => '',
  name => 'CISCO-FIREPOWER-AP-TC-MIB',
};

#$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-FIREPOWER-AP-TC-MIB'} =

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-FIREPOWER-AP-TC-MIB'} = {
  'cfprApTextualConventionsObjects' => '1.3.6.1.4.1.9.9.826.2.4',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-FIREPOWER-AP-TC-MIB'} = {
  'CfprApEtherServerIntFIoFsmTaskItem' => {
    '0' => 'nop',
    '313' => 'configSpeed',
  },
  'CfprApLsbootSanCatSanImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApBiosVfConsoleRedirectionVpPuttyKeyPad' => {
    '0' => 'platformRecommended',
    '121' => 'vt100',
    '122' => 'linux',
    '123' => 'xtermr6',
    '124' => 'sco',
    '125' => 'escn',
    '126' => 'vt400',
  },
  'CfprApEtherErrStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'alignDelta',
      '1' => 'alignDeltaAvg',
      '2' => 'alignDeltaMax',
      '3' => 'alignDeltaMin',
      '4' => 'deferredTxDelta',
      '5' => 'deferredTxDeltaAvg',
      '6' => 'deferredTxDeltaMax',
      '7' => 'deferredTxDeltaMin',
      '8' => 'fcsDelta',
      '9' => 'fcsDeltaAvg',
      '10' => 'fcsDeltaMax',
      '11' => 'fcsDeltaMin',
      '12' => 'intMacRxDelta',
      '13' => 'intMacRxDeltaAvg',
      '14' => 'intMacRxDeltaMax',
      '15' => 'intMacRxDeltaMin',
      '16' => 'intMacTxDelta',
      '17' => 'intMacTxDeltaAvg',
      '18' => 'intMacTxDeltaMax',
      '19' => 'intMacTxDeltaMin',
      '20' => 'outDiscardDelta',
      '21' => 'outDiscardDeltaAvg',
      '22' => 'outDiscardDeltaMax',
      '23' => 'outDiscardDeltaMin',
      '24' => 'rcvDelta',
      '25' => 'rcvDeltaAvg',
      '26' => 'rcvDeltaMax',
      '27' => 'rcvDeltaMin',
      '28' => 'underSizeDelta',
      '29' => 'underSizeDeltaAvg',
      '30' => 'underSizeDeltaMax',
      '31' => 'underSizeDeltaMin',
      '32' => 'xmitDelta',
      '33' => 'xmitDeltaAvg',
      '34' => 'xmitDeltaMax',
      '35' => 'xmitDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPolicyPolicyScopeFsmStageName' => {
    '0' => 'nop',
    '506' => 'releasePolicyFsmBegin',
    '507' => 'releasePolicyFsmRelease',
    '508' => 'releaseOperationFsmBegin',
    '509' => 'releaseOperationFsmRelease',
    '510' => 'releaseStorageFsmBegin',
    '511' => 'releaseStorageFsmRelease',
    '512' => 'resolveManyPolicyFsmBegin',
    '513' => 'resolveManyPolicyFsmResolveMany',
    '514' => 'resolveManyOperationFsmBegin',
    '515' => 'resolveManyOperationFsmResolveMany',
    '516' => 'resolveManyStorageFsmBegin',
    '517' => 'resolveManyStorageFsmResolveMany',
    '518' => 'releaseManyPolicyFsmBegin',
    '519' => 'releaseManyPolicyFsmReleaseMany',
    '520' => 'releaseManyOperationFsmBegin',
    '521' => 'releaseManyOperationFsmReleaseMany',
    '522' => 'releaseManyStorageFsmBegin',
    '523' => 'releaseManyStorageFsmReleaseMany',
    '524' => 'resolveAllPolicyFsmBegin',
    '525' => 'resolveAllPolicyFsmResolveAll',
    '526' => 'resolveAllOperationFsmBegin',
    '527' => 'resolveAllOperationFsmResolveAll',
    '528' => 'resolveAllStorageFsmBegin',
    '529' => 'resolveAllStorageFsmResolveAll',
    '530' => 'releaseAllPolicyFsmBegin',
    '531' => 'releaseAllPolicyFsmReleaseAll',
    '532' => 'releaseAllOperationFsmBegin',
    '533' => 'releaseAllOperationFsmReleaseAll',
    '534' => 'releaseAllStorageFsmBegin',
    '535' => 'releaseAllStorageFsmReleaseAll',
    '702' => 'releaseAllOperationFsmFail',
    '703' => 'releaseAllOperationFsmSuccess',
    '704' => 'releaseAllPolicyFsmFail',
    '705' => 'releaseAllPolicyFsmSuccess',
    '706' => 'releaseAllStorageFsmFail',
    '707' => 'releaseAllStorageFsmSuccess',
    '708' => 'releaseManyOperationFsmFail',
    '709' => 'releaseManyOperationFsmSuccess',
    '710' => 'releaseManyPolicyFsmFail',
    '711' => 'releaseManyPolicyFsmSuccess',
    '712' => 'releaseManyStorageFsmFail',
    '713' => 'releaseManyStorageFsmSuccess',
    '714' => 'releaseOperationFsmFail',
    '715' => 'releaseOperationFsmSuccess',
    '716' => 'releasePolicyFsmFail',
    '717' => 'releasePolicyFsmSuccess',
    '718' => 'releaseStorageFsmFail',
    '719' => 'releaseStorageFsmSuccess',
    '720' => 'resolveAllOperationFsmFail',
    '721' => 'resolveAllOperationFsmSuccess',
    '722' => 'resolveAllPolicyFsmFail',
    '723' => 'resolveAllPolicyFsmSuccess',
    '724' => 'resolveAllStorageFsmFail',
    '725' => 'resolveAllStorageFsmSuccess',
    '726' => 'resolveManyOperationFsmFail',
    '727' => 'resolveManyOperationFsmSuccess',
    '728' => 'resolveManyPolicyFsmFail',
    '729' => 'resolveManyPolicyFsmSuccess',
    '730' => 'resolveManyStorageFsmFail',
    '731' => 'resolveManyStorageFsmSuccess',
  },
  'CfprApVnicEtherBaseSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CfprApIdentConsType' => {
    '1' => 'vnic',
    '2' => 'vhba',
    '3' => 'server',
    '4' => 'chassis',
    '5' => 'vm',
    '6' => 'vmnic',
  },
  'CfprApAdaptorMenloNetEgStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropCmdDelta',
      '1' => 'dropCmdDeltaAvg',
      '2' => 'dropCmdDeltaMax',
      '3' => 'dropCmdDeltaMin',
      '4' => 'dropLifCfgInvalidDelta',
      '5' => 'dropLifCfgInvalidDeltaAvg',
      '6' => 'dropLifCfgInvalidDeltaMax',
      '7' => 'dropLifCfgInvalidDeltaMin',
      '8' => 'dropLifMapNoHitDelta',
      '9' => 'dropLifMapNoHitDeltaAvg',
      '10' => 'dropLifMapNoHitDeltaMax',
      '11' => 'dropLifMapNoHitDeltaMin',
      '12' => 'dropSrcBindDelta',
      '13' => 'dropSrcBindDeltaAvg',
      '14' => 'dropSrcBindDeltaMax',
      '15' => 'dropSrcBindDeltaMin',
      '16' => 'learnReqDropDelta',
      '17' => 'learnReqDropDeltaAvg',
      '18' => 'learnReqDropDeltaMax',
      '19' => 'learnReqDropDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdSlotFsmStageName' => {
    '0' => 'nop',
    '276' => 'changePlatformLogLevelBegin',
    '277' => 'changePlatformLogLevelSendCommand',
    '293' => 'formatDiskBegin',
    '294' => 'formatDiskCheckBladeReadiness',
    '295' => 'formatDiskStartDiskFormat',
    '296' => 'formatDiskResetBladePower',
    '297' => 'formatDiskWaitForDiskFormatComplete',
    '298' => 'synchTimeZoneBegin',
    '299' => 'synchTimeZoneUpdateTimeZone',
    '764' => 'changePlatformLogLevelFail',
    '765' => 'changePlatformLogLevelSuccess',
    '766' => 'formatDiskFail',
    '767' => 'formatDiskSuccess',
    '768' => 'synchTimeZoneFail',
    '769' => 'synchTimeZoneSuccess',
  },
  'CfprApSwFcoeSanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdAppInstanceFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '22' => 'samDmeSdAppInstanceStopApplicationReleaseLicense',
      '23' => 'samDmeSdAppInstanceStopApplicationStopAppInstance',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwAccessDomainType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEthMonSrcRefType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricAEthEstcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNetworkVlanCountStatus' => {
    '0' => 'withinLimit',
    '1' => 'aboveLimit',
  },
  'CfprApAdaptorEthPortMcastStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'multicastPacketsDelta',
      '5' => 'multicastPacketsDeltaAvg',
      '6' => 'multicastPacketsDeltaMax',
      '7' => 'multicastPacketsDeltaMin',
      '8' => 'unicastPacketsDelta',
      '9' => 'unicastPacketsDeltaAvg',
      '10' => 'unicastPacketsDeltaMax',
      '11' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLicenseDownloadActivity' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CfprApFirmwareImageFsmCurrentFsm' => {
    '0' => 'nop',
    '11' => 'delete',
  },
  'CfprApAdaptorHostEthIfFsmTaskItem' => {
    '0' => 'nop',
    '130' => 'circuitReset',
  },
  'CfprApExtmgmtIfType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricMonOperStateReason' => {
    '0' => 'active',
    '1' => 'noHardwareResource',
    '2' => 'noOperationalSrcDst',
    '3' => 'genericError',
    '4' => 'noSourcesConfigured',
    '5' => 'noDestinationConfigured',
    '6' => 'noSourceDestinationConfigured',
    '7' => 'sessionAdminShut',
    '8' => 'wrongDestinationMode',
    '9' => 'wrongSourceMode',
    '10' => 'tunnelMisconfDown',
    '11' => 'noFlowIdSpecified',
    '12' => 'unknown',
  },
  'CfprApAdaptorFcIfFC4StatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'controlRequestsDelta',
      '1' => 'controlRequestsDeltaAvg',
      '2' => 'controlRequestsDeltaMax',
      '3' => 'controlRequestsDeltaMin',
      '4' => 'inputMegabytesDelta',
      '5' => 'inputMegabytesDeltaAvg',
      '6' => 'inputMegabytesDeltaMax',
      '7' => 'inputMegabytesDeltaMin',
      '8' => 'inputRequestsDelta',
      '9' => 'inputRequestsDeltaAvg',
      '10' => 'inputRequestsDeltaMax',
      '11' => 'inputRequestsDeltaMin',
      '12' => 'outputMegabytesDelta',
      '13' => 'outputMegabytesDeltaAvg',
      '14' => 'outputMegabytesDeltaMax',
      '15' => 'outputMegabytesDeltaMin',
      '16' => 'outputRequestsDelta',
      '17' => 'outputRequestsDeltaAvg',
      '18' => 'outputRequestsDeltaMax',
      '19' => 'outputRequestsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeBladeFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '17' => 'samDmeComputeBladeDiagDetailDiag',
      '18' => 'samDmeComputeBladeDiagEfiDiag',
      '19' => 'samDmeComputeBladeDiagCancelDiag',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFlowMonKeyType' => {
    '0' => 'l2keys',
    '1' => 'ipv4keys',
    '2' => 'ipv6keys',
  },
  'CfprApExtvmmNetworkSetConfigQualifier' => {
    '0' => 'normal',
    '1' => 'duplicateVmndReference',
  },
  'CfprApMemoryUnitOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'degraded',
    '4' => 'poweredOff',
    '5' => 'powerProblem',
    '6' => 'removed',
    '7' => 'voltageProblem',
    '8' => 'thermalProblem',
    '9' => 'performanceProblem',
    '10' => 'accessibilityProblem',
    '11' => 'identityUnestablishable',
    '12' => 'biosPostTimeout',
    '13' => 'disabled',
    '14' => 'malformedFru',
    '51' => 'fabricConnProblem',
    '52' => 'fabricUnsupportedConn',
    '81' => 'config',
    '82' => 'equipmentProblem',
    '83' => 'decomissioning',
    '84' => 'chassisLimitExceeded',
    '100' => 'notSupported',
    '101' => 'discovery',
    '102' => 'discoveryFailed',
    '103' => 'identify',
    '104' => 'postFailure',
    '105' => 'upgradeProblem',
    '106' => 'peerCommProblem',
    '107' => 'autoUpgrade',
    '108' => 'linkActivateBlocked',
  },
  'CfprApEtherLossStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'sqetestDelta',
      '1' => 'sqetestDeltaAvg',
      '2' => 'sqetestDeltaMax',
      '3' => 'sqetestDeltaMin',
      '4' => 'carrierSenseDelta',
      '5' => 'carrierSenseDeltaAvg',
      '6' => 'carrierSenseDeltaMax',
      '7' => 'carrierSenseDeltaMin',
      '8' => 'excessCollisionDelta',
      '9' => 'excessCollisionDeltaAvg',
      '10' => 'excessCollisionDeltaMax',
      '11' => 'excessCollisionDeltaMin',
      '12' => 'giantsDelta',
      '13' => 'giantsDeltaAvg',
      '14' => 'giantsDeltaMax',
      '15' => 'giantsDeltaMin',
      '16' => 'lateCollisionDelta',
      '17' => 'lateCollisionDeltaAvg',
      '18' => 'lateCollisionDeltaMax',
      '19' => 'lateCollisionDeltaMin',
      '20' => 'multiCollisionDelta',
      '21' => 'multiCollisionDeltaAvg',
      '22' => 'multiCollisionDeltaMax',
      '23' => 'multiCollisionDeltaMin',
      '24' => 'singleCollisionDelta',
      '25' => 'singleCollisionDeltaAvg',
      '26' => 'singleCollisionDeltaMax',
      '27' => 'singleCollisionDeltaMin',
      '28' => 'symbolDelta',
      '29' => 'symbolDeltaAvg',
      '30' => 'symbolDeltaMax',
      '31' => 'symbolDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPortMode' => {
    '0' => 'unknown',
    '1' => 'access',
    '2' => 'trunk',
    '3' => 'fabric',
    '4' => 'nProxy',
    '5' => 'f',
    '6' => 'e',
    '7' => 'sd',
  },
  'CfprApLsFcZoneGroupSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApSwVlanLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
    '4' => 'pending',
    '5' => 'provisioned',
  },
  'CfprApAdaptorExtIpV6RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApStorageIOType' => {
    '0' => 'unknown',
    '1' => 'direct',
    '2' => 'cached',
  },
  'CfprApFabricFcMonDestEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApCommSyslogForwardingFacility' => {
    '0' => 'local0',
    '1' => 'local1',
    '2' => 'local2',
    '3' => 'local3',
    '4' => 'local4',
    '5' => 'local5',
    '6' => 'local6',
    '7' => 'local7',
  },
  'CfprApNetworkConnectionType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentLocatorLedFsmTaskItem' => {
    '0' => 'nop',
    '231' => 'setFeLocatorLed',
    '233' => 'setFiLocatorLed',
  },
  'CfprApStorageDisklessAction' => {
    '0' => 'unspecified',
    '1' => 'yes',
    '2' => 'no',
  },
  'CfprApStorageFileSystemStatus' => {
    '0' => 'unknown',
    '1' => 'clean',
    '2' => 'notClean',
    '3' => 'mounted',
    '4' => 'unmounted',
  },
  'CfprApCapabilityMgmtExtensionFsmStageName' => {
    '0' => 'nop',
    '429' => 'activateMgmtExtBegin',
    '430' => 'activateMgmtExtUnpackLocal',
    '431' => 'activateMgmtExtCopyRemote',
    '432' => 'activateMgmtExtApplyCatalog',
    '433' => 'activateMgmtExtRescanImages',
    '434' => 'activateMgmtExtEvaluateStatus',
    '556' => 'activateMgmtExtFail',
    '557' => 'activateMgmtExtSuccess',
  },
  'CfprApCapabilityUpdaterFsmStageName' => {
    '0' => 'nop',
    '413' => 'updaterBegin',
    '414' => 'updaterLocal',
    '415' => 'updaterUnpackLocal',
    '416' => 'updaterDeleteLocal',
    '417' => 'updaterCopyRemote',
    '418' => 'updaterApply',
    '419' => 'updaterRescanImages',
    '420' => 'updaterEvaluateStatus',
    '558' => 'updaterFail',
    '559' => 'updaterSuccess',
  },
  'CfprApConditionCallHomeCause' => {
    '0' => 'unspecified',
    '1' => 'identityUnestablishable',
    '2' => 'powerProblem',
    '3' => 'equipmentInoperable',
    '4' => 'equipmentInaccessible',
    '5' => 'vifIdsMismatch',
    '6' => 'adaptorMismatch',
    '7' => 'voltageProblem',
    '8' => 'psuInsufficient',
    '9' => 'psuMixedMode',
    '10' => 'connectivityProblem',
    '11' => 'equipmentDisabled',
    '12' => 'thermalProblem',
    '13' => 'configurationFailure',
    '14' => 'associationFailed',
    '15' => 'equipmentOffline',
    '16' => 'equipmentProblem',
    '17' => 'fruProblem',
    '18' => 'healthLedAmberBlinking',
    '19' => 'healthLedAmber',
    '20' => 'licenseGraceperiodExpired',
    '21' => 'equipmentDegraded',
    '22' => 'mgmtifDown',
    '23' => 'arpTargetsConfigError',
    '24' => 'ndiscTargetsConfigError',
    '25' => 'equipmentRemoved',
    '26' => 'limitReached',
    '27' => 'nearMaxLimit',
    '28' => 'inventoryFailed',
    '29' => 'memoryError',
    '30' => 'linkDown',
    '31' => 'electionFailure',
    '32' => 'managementServicesFailure',
    '33' => 'managementServicesUnresponsive',
    '34' => 'versionIncompatible',
    '35' => 'portFailed',
  },
  'CfprApAdaptorEthPortMcastStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'multicastPacketsDelta',
      '5' => 'multicastPacketsDeltaAvg',
      '6' => 'multicastPacketsDeltaMax',
      '7' => 'multicastPacketsDeltaMin',
      '8' => 'unicastPacketsDelta',
      '9' => 'unicastPacketsDeltaAvg',
      '10' => 'unicastPacketsDeltaMax',
      '11' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNhExecState' => {
    '0' => 'ready',
    '1' => 'init',
  },
  'CfprApSwFcMonDestEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorFcIfEventStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'invalidCRCCountDelta',
      '1' => 'invalidCRCCountDeltaAvg',
      '2' => 'invalidCRCCountDeltaMax',
      '3' => 'invalidCRCCountDeltaMin',
      '4' => 'linkFailureCountDelta',
      '5' => 'linkFailureCountDeltaAvg',
      '6' => 'linkFailureCountDeltaMax',
      '7' => 'linkFailureCountDeltaMin',
      '8' => 'lipCountDelta',
      '9' => 'lipCountDeltaAvg',
      '10' => 'lipCountDeltaMax',
      '11' => 'lipCountDeltaMin',
      '12' => 'lossOfSignalCountDelta',
      '13' => 'lossOfSignalCountDeltaAvg',
      '14' => 'lossOfSignalCountDeltaMax',
      '15' => 'lossOfSignalCountDeltaMin',
      '16' => 'lossOfSyncCountDelta',
      '17' => 'lossOfSyncCountDeltaAvg',
      '18' => 'lossOfSyncCountDeltaMax',
      '19' => 'lossOfSyncCountDeltaMin',
      '20' => 'nOSCountDelta',
      '21' => 'nOSCountDeltaAvg',
      '22' => 'nOSCountDeltaMax',
      '23' => 'nOSCountDeltaMin',
      '24' => 'secondsSinceLastResetDelta',
      '25' => 'secondsSinceLastResetDeltaAvg',
      '26' => 'secondsSinceLastResetDeltaMax',
      '27' => 'secondsSinceLastResetDeltaMin',
      '28' => 'seqProtocolErrCountDelta',
      '29' => 'seqProtocolErrCountDeltaAvg',
      '30' => 'seqProtocolErrCountDeltaMax',
      '31' => 'seqProtocolErrCountDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFcpoolBootTargetType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApComputePCIeFatalStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'acsViolationErrors',
      '1' => 'malformedTLPErrors',
      '2' => 'poisonedTLPErrors',
      '3' => 'surpriseLinkDownErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfProcessorC3ReportVpProcessorC3Report' => {
    '0' => 'platformRecommended',
    '140' => 'disabled',
    '141' => 'acpiC2',
    '142' => 'acpiC3',
  },
  'CfprApAdaptorMgmtCapOperPowerRequirement' => {
    '0' => 'none',
    '1' => 'standby',
    '2' => 'full',
  },
  'CfprApLsConfigState' => {
    '0' => 'notApplied',
    '1' => 'applying',
    '2' => 'failedToApply',
    '3' => 'applied',
  },
  'CfprApFabricNetflowConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'monitorUnresolved',
      '1' => 'exporterUnresolved',
      '2' => 'exporterProfileUnresolved',
      '3' => 'collectorUnresolved',
      '4' => 'sourceVlanUnresolved',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentMethod' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'post',
      '1' => 'configCheck',
      '2' => 'diagCheck',
      '3' => 'selCheck',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfMirroringModeVpMirroringMode' => {
    '0' => 'platformRecommended',
    '70' => 'interSocket',
    '71' => 'intraSocket',
  },
  'CfprApCommClientAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricInternalEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFcMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfUSBBootConfigVpLegacyUSBSupport' => {
    '0' => 'platformRecommended',
    '133' => 'disabled',
    '134' => 'enabled',
    '135' => 'auto',
  },
  'CfprApLsbootLanAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CfprApFirmwareInstallState' => {
    '0' => 'ready',
    '1' => 'scheduled',
    '2' => 'inProgress',
    '3' => 'failed',
    '4' => 'pendingUserAck',
    '5' => 'startPendingExtPermission',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot8LinkSpeed' => {
    '0' => 'platformRecommended',
    '267' => 'gen1',
    '268' => 'gen2',
    '269' => 'gen3',
    '270' => 'auto',
    '271' => 'disabled',
  },
  'CfprApSdAppAttributeCtrlFsmStageName' => {
    '0' => 'nop',
    '300' => 'getAppAttributesBegin',
    '301' => 'getAppAttributesGetAttributes',
    '738' => 'getAppAttributesFail',
    '739' => 'getAppAttributesSuccess',
  },
  'CfprApSmActionStages' => {
    '0' => 'available',
    '1' => 'perform',
    '2' => 'performing',
    '3' => 'failure',
    '4' => 'notAvailable',
  },
  'CfprApPolicySuspendState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot1State' => {
    '0' => 'platformRecommended',
    '174' => 'disabled',
    '175' => 'enabled',
    '176' => 'uefiOnly',
    '177' => 'legacyOnly',
  },
  'CfprApEquipmentSensorThresholdStatus' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'upperNonRecoverable',
    '3' => 'upperCritical',
    '4' => 'upperNonCritical',
    '5' => 'lowerNonCritical',
    '6' => 'lowerCritical',
    '7' => 'lowerNonRecoverable',
    '100' => 'notSupported',
  },
  'CfprApStorageFFFormatRunning' => {
    '0' => 'na',
    '1' => 'yes',
    '2' => 'no',
  },
  'CfprApFabricSanCloudFsmCurrentFsm' => {
    '0' => 'nop',
    '452' => 'switchMode',
  },
  'CfprApAdaptorMenloQueueStatsComponent' => {
    '0' => 'unknown',
    '1' => 'cpu',
    '2' => 'eth',
    '3' => 'fc',
    '4' => 'n',
  },
  'CfprApStorageKeyType' => {
    '1' => 'initiator',
    '2' => 'target',
  },
  'CfprApVmNicType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApFabricBladeLifeCycle' => {
    '1' => 'inService',
    '2' => 'outOfService',
    '3' => 'outOfServiceSlave',
  },
  'CfprApBiosVfOptionROMLoadVpLoad' => {
    '0' => 'platformRecommended',
    '164' => 'enabled',
    '165' => 'disabled',
  },
  'CfprApAaaAccess' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'readOnly',
      '1' => 'admin',
      '2' => 'operations',
      '3' => 'fault',
      '4' => 'aaa',
      '5' => 'podConfig',
      '6' => 'podPolicy',
      '7' => 'podSecurity',
      '8' => 'podQos',
      '9' => 'extLanConfig',
      '10' => 'extLanPolicy',
      '11' => 'extLanSecurity',
      '12' => 'extLanQos',
      '13' => 'extSanConfig',
      '14' => 'extSanPolicy',
      '15' => 'extSanSecurity',
      '16' => 'extSanQos',
      '17' => 'pnEquipment',
      '18' => 'pnPolicy',
      '19' => 'pnSecurity',
      '20' => 'pnMaintenance',
      '21' => 'lsConfig',
      '22' => 'lsStorage',
      '23' => 'lsNetwork',
      '24' => 'lsSecurity',
      '25' => 'lsServer',
      '26' => 'lsQos',
      '27' => 'lsConfigPolicy',
      '28' => 'lsStoragePolicy',
      '29' => 'lsNetworkPolicy',
      '30' => 'lsSecurityPolicy',
      '31' => 'lsServerPolicy',
      '32' => 'lsQosPolicy',
      '33' => 'lsExtAccess',
      '34' => 'powerMgmt',
      '36' => 'lsServerOper',
      '37' => 'lsCompute',
      '38' => 'orgManagement',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthTargetEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricExternalPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfUSBFrontPanelAccessLockVpUSBFrontPanelLock' => {
    '0' => 'platformRecommended',
    '289' => 'disabled',
    '290' => 'enabled',
  },
  'CfprApFabricLanPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApTrigOperState' => {
    '0' => 'pending',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'triggered',
    '4' => 'capReached',
  },
  'CfprApOsDeployState' => {
    '0' => 'undefined',
    '1' => 'inProgress',
    '2' => 'complete',
    '3' => 'retry',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CfprApPkiEpFsmStageName' => {
    '0' => 'nop',
    '344' => 'updateEpBegin',
    '345' => 'updateEpSetKeyRingLocal',
    '346' => 'updateEpSetKeyRingPeer',
    '347' => 'updateEpPostSetKeyRingLocal',
    '348' => 'updateEpPostSetKeyRingPeer',
    '696' => 'updateEpFail',
    '697' => 'updateEpSuccess',
  },
  'CfprApSwFcSanMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaEpAccess' => {
    '1' => 'readonly',
    '2' => 'admin',
  },
  'CfprApBiosVfIntelVTForDirectedIOVpIntelVTDATSSupport' => {
    '0' => 'platformRecommended',
    '58' => 'disabled',
    '59' => 'enabled',
  },
  'CfprApFabricSwSrvPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApPowerGroupState' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'capOk',
      '1' => 'capInsufficient',
      '2' => 'capMismatch',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtImporterFsmStageName' => {
    '0' => 'nop',
    '476' => 'importBegin',
    '477' => 'importDownloadLocal',
    '478' => 'importCleanUp',
    '479' => 'importConfigBreakout',
    '480' => 'importWaitForSwitch',
    '481' => 'importConfig',
    '482' => 'importReportResults',
    '676' => 'importFail',
    '677' => 'importSuccess',
  },
  'CfprApExtmgmtIfMonPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricEthMonDestEpAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CfprApNetworkPortType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApStorageFFDriveRemovable' => {
    '0' => 'na',
    '1' => 'yes',
    '2' => 'no',
  },
  'CfprApFirmwareFwUpgradeState' => {
    '0' => 'ready',
    '1' => 'inProgress',
    '2' => 'upgrading',
    '3' => 'updatingImageVersion',
    '4' => 'updatingPackageVersion',
    '5' => 'failed',
    '6' => 'failedUpgrade',
  },
  'CfprApEquipmentStorageMethod' => {
    '0' => 'unknown',
    '1' => 'singleFlash',
    '2' => 'dualFlash',
  },
  'CfprApSwExtUtilityFsmStageName' => {
    '0' => 'nop',
    '114' => 'confPortBreakoutBegin',
    '115' => 'confPortBreakoutPortInventorySwA',
    '116' => 'confPortBreakoutPortInventorySwB',
    '117' => 'confPortBreakoutConfigSwA',
    '118' => 'confPortBreakoutConfigSwB',
    '119' => 'confPortBreakoutVerifyBreakoutConfig',
    '120' => 'confPortBreakoutSuccess',
    '121' => 'confPortBreakoutFail',
  },
  'CfprApLsbootUsbInternalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
  },
  'CfprApFabricQuerierType' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CfprApBiosVfUSBPortConfigurationVpUSBPortKVM' => {
    '0' => 'platformRecommended',
    '310' => 'disabled',
    '311' => 'enabled',
  },
  'CfprApFabricDceSwSrvPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcMonSrcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentAsicType' => {
    '0' => 'unknown',
    '1' => 'gatos',
    '2' => 'carmel',
  },
  'CfprApStorageLunType' => {
    '0' => 'unspecified',
    '1' => 'simple',
    '2' => 'mirror',
    '3' => 'stripe',
    '4' => 'raid',
    '5' => 'stripeParity',
    '6' => 'stripeDualParity',
    '7' => 'mirrorStripe',
    '8' => 'stripeParityStripe',
    '9' => 'stripeDualParityStripe',
  },
  'CfprApQosclassFcAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApStorageIniGroupOperProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CfprApSwPhysFsmTaskItem' => {
    '0' => 'nop',
    '106' => 'confPhysical',
  },
  'CfprApBiosVfTPMSupportVpTPMSupport' => {
    '0' => 'platformRecommended',
    '354' => 'disabled',
    '355' => 'enabled',
  },
  'CfprApFabricEthSourceType' => {
    '1' => 'vnic',
    '2' => 'uplinkPort',
    '3' => 'vlan',
    '4' => 'serverPort',
    '5' => 'portChannel',
    '6' => 'hostPort',
    '7' => 'storage',
    '8' => 'nasPort',
    '9' => 'nasPortChannel',
    '10' => 'fcoeuplinkPort',
    '11' => 'fcoeuplinkPortchannel',
    '12' => 'vmNic',
    '20' => 'vhba',
  },
  'CfprApFabricEthMonDestEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot5LinkSpeed' => {
    '0' => 'platformRecommended',
    '252' => 'gen1',
    '253' => 'gen2',
    '254' => 'gen3',
    '255' => 'auto',
    '256' => 'disabled',
  },
  'CfprApVnicDynamicConReqProtection' => {
    '0' => 'none',
    '1' => 'protectedPrefA',
    '2' => 'protectedPrefB',
    '3' => 'protected',
  },
  'CfprApStoragePDriveStatus' => {
    '0' => 'unknown',
    '1' => 'online',
    '2' => 'unconfiguredGood',
    '3' => 'globalHotSpare',
    '4' => 'dedicatedHotSpare',
    '5' => 'jbod',
    '6' => 'offline',
    '7' => 'rebuilding',
    '8' => 'copyback',
    '9' => 'failed',
    '10' => 'unconfiguredBad',
    '11' => 'predictiveFailure',
    '12' => 'disabledForRemoval',
    '13' => 'foreignConfiguration',
  },
  'CfprApMgmtOperState' => {
    '0' => 'unknown',
    '1' => 'notDeployed',
    '2' => 'deployed',
    '3' => 'up',
    '4' => 'down',
  },
  'CfprApEquipmentBoardConnectorType' => {
    '1' => 'connUnlinked',
    '2' => 'connLinked',
  },
  'CfprApSwSspEthMonFsmCurrentFsm' => {
    '0' => 'nop',
    '443' => 'deploy',
  },
  'CfprApSwNetflowRecordDefProtocol' => {
    '1' => 'netflow',
  },
  'CfprApExtvmmProviderVendorType' => {
    '0' => 'unknown',
    '1' => 'vmware',
    '2' => 'microsoft',
  },
  'CfprApMgmtBackupPolicyFsmStageName' => {
    '0' => 'nop',
    '460' => 'reportConfigCopyBegin',
    '461' => 'reportConfigCopyReport',
    '660' => 'reportConfigCopyFail',
    '661' => 'reportConfigCopySuccess',
  },
  'CfprApSdAppLduLinkFsmStageName' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatusBegin',
    '290' => 'updateInterfaceStatusSendStatus',
    '756' => 'updateInterfaceStatusFail',
    '757' => 'updateInterfaceStatusSuccess',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot9State' => {
    '0' => 'platformRecommended',
    '206' => 'disabled',
    '207' => 'enabled',
    '208' => 'uefiOnly',
    '209' => 'legacyOnly',
  },
  'CfprApFabricEthLinkPolicyType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorLldpCapSupport' => {
    '1' => 'none',
    '2' => 'full',
  },
  'CfprApEquipmentPsuStateQualifier' => {
    '0' => 'unknown',
    '1' => 'failure',
    '2' => 'overCurrent',
    '3' => 'overTemperature',
    '4' => 'inputLoss',
    '5' => 'fanFailure',
    '6' => 'inputCurrentWarning',
    '7' => 'inputVoltageWarning',
    '8' => 'ambientTemperatureWarning',
    '9' => 'outputCurrentWarning',
  },
  'CfprApMgmtIfFsmCurrentFsm' => {
    '0' => 'nop',
    '395' => 'swMgmtOobIfConfig',
    '397' => 'swMgmtInbandIfConfig',
    '464' => 'virtualIfConfig',
    '467' => 'enableVip',
    '469' => 'disableVip',
    '471' => 'enableHA',
  },
  'CfprApExtpolRegistryFsmCurrentFsm' => {
    '0' => 'nop',
    '319' => 'crossDomainConfig',
    '322' => 'crossDomainDelete',
  },
  'CfprApEquipmentFexPowerSummaryHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'modulePower',
      '1' => 'modulePowerAvg',
      '2' => 'modulePowerMax',
      '3' => 'modulePowerMin',
      '4' => 'availablePower',
      '5' => 'availablePowerAvg',
      '6' => 'availablePowerMax',
      '7' => 'availablePowerMin',
      '8' => 'reservedPower',
      '9' => 'reservedPowerAvg',
      '10' => 'reservedPowerMax',
      '11' => 'reservedPowerMin',
      '12' => 'totalPower',
      '13' => 'totalPowerAvg',
      '14' => 'totalPowerMax',
      '15' => 'totalPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaRadiusEpFsmStageName' => {
    '0' => 'nop',
    '349' => 'updateEpBegin',
    '350' => 'updateEpSetEpLocal',
    '351' => 'updateEpSetEpPeer',
    '536' => 'updateEpFail',
    '537' => 'updateEpSuccess',
  },
  'CfprApDiagAdminState' => {
    '0' => 'ready',
    '1' => 'trigger',
    '2' => 'cancel',
  },
  'CfprApEquipmentRackUnitFanStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'speed',
      '1' => 'speedAvg',
      '2' => 'speedMax',
      '3' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMemoryUnitEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcSanBorderFsmStageName' => {
    '0' => 'nop',
    '100' => 'deployBegin',
    '101' => 'deployUpdateConnectivity',
    '122' => 'activateZoneSetBegin',
    '123' => 'activateZoneSetUpdateZones',
    '796' => 'activateZoneSetFail',
    '797' => 'activateZoneSetSuccess',
    '798' => 'deployFail',
    '799' => 'deploySuccess',
  },
  'CfprApSwSanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApQosPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CfprApLsbootSanImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApBiosVfProcessorPrefetchConfigVpDCUIPPrefetcher' => {
    '0' => 'platformRecommended',
    '322' => 'disabled',
    '323' => 'enabled',
  },
  'CfprApEtherFtwPortPairWdtState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFirmwareSystemFsmStageName' => {
    '0' => 'nop',
    '37' => 'deployBegin',
    '38' => 'deployWaitForDeploy',
    '39' => 'deployValidateApplicationPack',
    '40' => 'deployDeleteCurrentApplication',
    '41' => 'deployPollDeleteCurrentApplicationStatus',
    '42' => 'deploySetStartupServiceManagerVersion',
    '43' => 'deployPollStartupServiceManagerStatus',
    '44' => 'deployActivateNpuImage',
    '45' => 'deployPollNpuActivationStatus',
    '46' => 'deployActivateSystemImage',
    '47' => 'deployActivateFirmwareImage',
    '48' => 'deployRebootSystemForImageUpgrade',
    '49' => 'deployWaitForSystemReady',
    '50' => 'deployPollSystemActivationStatus',
    '51' => 'deployActivateManagerImage',
    '52' => 'deployPollManagerActivationStatus',
    '53' => 'deployActivateApplicationImage',
    '54' => 'deployPollApplicationActivationStatus',
    '55' => 'deployCompleteFirmwareUpgrade',
    '67' => 'applyCatalogPackBegin',
    '68' => 'applyCatalogPackResolveDistributableNames',
    '69' => 'applyCatalogPackResolveDistributable',
    '70' => 'applyCatalogPackResolveImages',
    '71' => 'applyCatalogPackActivateCatalog',
    '622' => 'applyCatalogPackFail',
    '623' => 'applyCatalogPackSuccess',
    '624' => 'deployFail',
    '625' => 'deploySuccess',
    '834' => 'deployCheckFirmwareUpgradeStatus',
  },
  'CfprApComputeScrubAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApVnicScsiType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApFabricFcEstcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthMonFsmStageName' => {
    '0' => 'nop',
    '439' => 'deployBegin',
    '440' => 'deployUpdateEthMon',
    '792' => 'deployFail',
    '793' => 'deploySuccess',
  },
  'CfprApApplicationDownloaderFsmStageName' => {
    '0' => 'nop',
    '332' => 'downloadBegin',
    '333' => 'downloadLocal',
    '334' => 'downloadUnpackLocal',
    '548' => 'downloadFail',
    '549' => 'downloadSuccess',
  },
  'CfprApComputeBlackListing' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFabricNetflowMonSrcEpProtocol' => {
    '1' => 'netflow',
  },
  'CfprApLicenseTransferState' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'failed',
  },
  'CfprApAdaptorMenloMcpuStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropAclDelta',
      '1' => 'dropAclDeltaAvg',
      '2' => 'dropAclDeltaMax',
      '3' => 'dropAclDeltaMin',
      '4' => 'dropOverrunDelta',
      '5' => 'dropOverrunDeltaAvg',
      '6' => 'dropOverrunDeltaMax',
      '7' => 'dropOverrunDeltaMin',
      '8' => 'dropRuntDelta',
      '9' => 'dropRuntDeltaAvg',
      '10' => 'dropRuntDeltaMax',
      '11' => 'dropRuntDeltaMin',
      '12' => 'truncateOverrunDelta',
      '13' => 'truncateOverrunDeltaAvg',
      '14' => 'truncateOverrunDeltaMax',
      '15' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEpqosDefinitionFsmCurrentFsm' => {
    '0' => 'nop',
    '384' => 'deploy',
  },
  'CfprApSysdebugLogControlLevel' => {
    '0' => 'debug0',
    '1' => 'debug1',
    '2' => 'debug2',
    '3' => 'debug3',
    '4' => 'debug4',
    '5' => 'info',
    '6' => 'warn',
    '7' => 'minor',
    '8' => 'major',
    '9' => 'crit',
  },
  'CfprApEquipmentEthPortSpeedCap' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'auto',
      '1' => 'n1g',
      '2' => 'n10g',
      '3' => 'n20g',
      '4' => 'n40g',
      '7' => 'n100m',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot9LinkSpeed' => {
    '0' => 'platformRecommended',
    '272' => 'gen1',
    '273' => 'gen2',
    '274' => 'gen3',
    '275' => 'auto',
    '276' => 'disabled',
  },
  'CfprApVnicTemplateTarget' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'vm',
      '1' => 'adaptor',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageFFDriveType' => {
    '0' => 'unknown',
    '1' => 'scu',
    '2' => 'huu',
    '3' => 'hv',
    '4' => 'drivers',
  },
  'CfprApSmAppAdminState' => {
    '0' => 'active',
    '1' => 'deleted',
  },
  'CfprApSwSystemStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'load',
      '1' => 'loadAvg',
      '2' => 'loadMax',
      '3' => 'loadMin',
      '4' => 'memAvailable',
      '5' => 'memAvailableAvg',
      '6' => 'memAvailableMax',
      '7' => 'memAvailableMin',
      '8' => 'memCached',
      '9' => 'memCachedAvg',
      '10' => 'memCachedMax',
      '11' => 'memCachedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIpIpV4StaticAddrPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CfprApAdaptorEthNVGREProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApVnicMezzMappingScheme' => {
    '1' => 'physicalCapFirst',
    '2' => 'capLoadDistribute',
  },
  'CfprApMgmtConnectionState' => {
    '0' => 'unInitialized',
    '1' => 'acknowledged',
    '2' => 'unsupportedConnectivity',
  },
  'CfprApTrigTrigOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CfprApMgmtBackupInterval' => {
    '86400' => 'n1day',
    '604800' => 'n1week',
    '1209600' => 'n2week',
  },
  'CfprApFsmCompletion' => {
    '0' => 'scheduled',
    '1' => 'processing',
    '2' => 'completed',
    '3' => 'cancelled',
  },
  'CfprApAdaptorExtIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivity',
  },
  'CfprApSwNetflowMonSessionProtocol' => {
    '1' => 'netflow',
  },
  'CfprApEquipmentEnabledStatus' => {
    '0' => 'unknown',
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApStorageVsanRefSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApStatsThr32ValuePropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CfprApFabricNetGroupType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'mgmt',
      '1' => 'vlanCompression',
      '2' => 'vlanUncompressed',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherSwitchIntFIoPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApNetworkIfStatus' => {
    '0' => 'unknown',
    '1' => 'down',
    '2' => 'up',
  },
  'CfprApStorageOperationStateType' => {
    '0' => 'partitionNonMirrored',
    '1' => 'partitionMirrored',
    '2' => 'partitionMirroredSyncing',
    '3' => 'partitionMirroredErasing',
    '4' => 'partitionMirroredUpdating',
    '5' => 'partitionNonMirroredUpdating',
    '6' => 'partitionNonMirroredErasing',
    '7' => 'partitionMirroredSyncingFail',
    '8' => 'partitionMirroredErasingFail',
    '9' => 'partitionMirroredUpdatingFail',
    '10' => 'partitionNonMirroredUpdatingFail',
    '11' => 'partitionNonMirroredErasingFail',
    '12' => 'partitionMirroredSyncingSuccess',
    '13' => 'partitionMirroredErasingSuccess',
    '14' => 'partitionMirroredUpdatingSuccess',
    '15' => 'partitionNonMirroredUpdatingSuccess',
    '16' => 'partitionNonMirroredErasingSuccess',
    '17' => 'unknown',
  },
  'CfprApAdaptorEthPortBySizeSmallStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'equals64Delta',
      '1' => 'equals64DeltaAvg',
      '2' => 'equals64DeltaMax',
      '3' => 'equals64DeltaMin',
      '4' => 'lessThan1024Delta',
      '5' => 'lessThan1024DeltaAvg',
      '6' => 'lessThan1024DeltaMax',
      '7' => 'lessThan1024DeltaMin',
      '8' => 'lessThan128Delta',
      '9' => 'lessThan128DeltaAvg',
      '10' => 'lessThan128DeltaMax',
      '11' => 'lessThan128DeltaMin',
      '12' => 'lessThan256Delta',
      '13' => 'lessThan256DeltaAvg',
      '14' => 'lessThan256DeltaMax',
      '15' => 'lessThan256DeltaMin',
      '16' => 'lessThan512Delta',
      '17' => 'lessThan512DeltaAvg',
      '18' => 'lessThan512DeltaMax',
      '19' => 'lessThan512DeltaMin',
      '20' => 'lessThan64Delta',
      '21' => 'lessThan64DeltaAvg',
      '22' => 'lessThan64DeltaMax',
      '23' => 'lessThan64DeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCallhomeAlertGroups' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'system',
      '1' => 'environmental',
      '2' => 'linecard',
      '3' => 'supervisor',
      '4' => 'inventory',
      '5' => 'test',
      '6' => 'ciscoTac',
      '7' => 'syslogPort',
      '8' => 'license',
      '9' => 'lifeCycle',
      '10' => 'diagnostic',
      '11' => 'smartLicense',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFcMonSanTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricVConInstType' => {
    '1' => 'auto',
    '2' => 'manual',
    '3' => 'policy',
  },
  'CfprApComputePhysicalFsmStageName' => {
    '0' => 'nop',
    '208' => 'swConnUpdBegin',
    '209' => 'swConnUpdA',
    '210' => 'swConnUpdB',
    '213' => 'serviceInfraDeployBegin',
    '214' => 'serviceInfraDeploySwConfigLocal',
    '215' => 'serviceInfraDeploySwConfigPeer',
    '216' => 'serviceInfraWithdrawBegin',
    '217' => 'serviceInfraWithdrawSwUnConfigLocal',
    '218' => 'serviceInfraWithdrawSwUnConfigPeer',
    '564' => 'serviceInfraDeployFail',
    '565' => 'serviceInfraDeploySuccess',
    '566' => 'serviceInfraWithdrawFail',
    '567' => 'serviceInfraWithdrawSuccess',
    '568' => 'swConnUpdFail',
    '569' => 'swConnUpdSuccess',
  },
  'CfprApFabricSspMonOperStateReason' => {
    '0' => 'active',
    '1' => 'noHardwareResource',
    '2' => 'noOperationalSrcDst',
    '3' => 'genericError',
    '4' => 'noSourcesConfigured',
    '5' => 'sessionAdminShut',
    '8' => 'directoryError',
    '12' => 'unknown',
    '16' => 'fileError',
    '32' => 'memoryOvershoot',
    '64' => 'pipeError',
    '128' => 'linkError',
  },
  'CfprApSwEthFlowMonSessionTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApTrigAckChangeDetails' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'binding',
      '1' => 'hostVirtEthIf',
      '2' => 'hostNonvirtEthIf',
      '3' => 'hostEthIfProfile',
      '4' => 'hostEthIfQos',
      '5' => 'hostEthIfNwCtrl',
      '6' => 'hostVirtFcIf',
      '7' => 'hostNonvirtFcIf',
      '8' => 'hostVirtFcIfPersBind',
      '9' => 'hostNonvirtFcIfPersBind',
      '10' => 'hostFcIfProfile',
      '11' => 'hostFcIfQos',
      '12' => 'hostFcoeIf',
      '13' => 'vif',
      '14' => 'vlan',
      '15' => 'vsan',
      '16' => 'ip',
      '17' => 'bootOrder',
      '18' => 'bootVirtVnic',
      '19' => 'bootNonvirtVnic',
      '20' => 'bootLocalStorage',
      '21' => 'bootVirtPxe',
      '22' => 'bootNonvirtPxe',
      '24' => 'bladeIdentity',
      '25' => 'agentPolicy',
      '26' => 'biosFw',
      '27' => 'storageControllerFw',
      '28' => 'adaptorHostFw',
      '29' => 'adaptorNwFw',
      '30' => 'mgmtControllerFw',
      '31' => 'localDiskPolicy',
      '32' => 'pin',
      '33' => 'sol',
      '34' => 'epAuth',
      '35' => 'biosProfile',
      '36' => 'checkpoint',
      '37' => 'implicitReboot',
      '38' => 'implicitHostFcIfProfileRedeploy',
      '39' => 'boardControllerFw',
      '40' => 'hostEthIfQosHostControl',
      '41' => 'localDiskFw',
      '42' => 'implicitHostEthIfProfileRedeploy',
      '43' => 'storagePath',
      '44' => 'bmcUpdateBiosFw',
      '45' => 'hostIfPcie',
      '46' => 'flexflashConfig',
      '48' => 'bootmodeConfig',
      '49' => 'securebootConfig',
      '50' => 'vmediaConfig',
      '51' => 'ssposUpdateFw',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPolicyControlEpFsmCurrentFsm' => {
    '0' => 'nop',
    '502' => 'operate',
  },
  'CfprApStorageFFControllerHealth' => {
    '0' => 'ffchOk',
    '1' => 'ffchMetadataFailure',
    '2' => 'ffchErrorCardsAccessError',
    '3' => 'ffchErrorOldFirmwareRunning',
    '4' => 'ffchErrorMediaWriteProtected',
    '5' => 'ffchErrorInvalidSize',
    '6' => 'ffchErrorCardSizeMismatch',
    '7' => 'ffchInconsistentMetadata',
    '8' => 'ffchErrorSecondaryUnhealthyCard',
    '9' => 'ffchErrorSdCardNotConfigured',
    '10' => 'ffchErrorInconsistantMetadataIgnored',
    '11' => 'ffchErrorSd253WithUnOrSd247',
    '12' => 'ffchErrorRebootedDuringRebuild',
    '13' => 'ffchErrorSd247CardDetected',
    '14' => 'ffchFlexdErrorSdCardOpModeMismatch',
    '15' => 'ffchFlexdErrorSdOpModeMismatchWithUn',
    '16' => 'ffchFlexdErrorImSdUnhealthySdUnIgnored',
    '17' => 'ffchFlexdErrorImSdHealthySdUnIgnored',
    '18' => 'ffchFlexdErrorImSdCardsOpModeMismatch',
    '19' => 'ffchFlexdErrorSdCard0UnhealthyOpModeMismatch',
    '20' => 'ffchFlexdErrorSdCard0HealthyOpModeMismatch',
    '21' => 'ffchFlexdErrorSdCard1UnhealthyOpModeMismatch',
    '22' => 'ffchFlexdErrorSdCard1HealthyOpModeMismatch',
    '23' => 'ffchFlexdErrorImSd0IgnoredSd1',
    '24' => 'ffchFlexdErrorImSd0Sd1Ignored',
  },
  'CfprApSdAppInstanceFsmCurrentFsm' => {
    '0' => 'nop',
    '250' => 'installApplication',
    '254' => 'startApplication',
    '263' => 'upgradeApplication',
    '267' => 'stopApplication',
    '272' => 'uninstallApplication',
    '278' => 'bundleDataPorts',
  },
  'CfprApSwEthFlowMonSessionType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareType' => {
    '0' => 'unspecified',
    '1' => 'switchKernel',
    '2' => 'switchSoftware',
    '3' => 'system',
    '4' => 'bladeController',
    '5' => 'iocard',
    '6' => 'fex',
    '7' => 'adaptor',
    '8' => 'storageController',
    '9' => 'hostNic',
    '10' => 'hostHba',
    '11' => 'hostHbaOptionrom',
    '12' => 'hostNicOptionrom',
    '13' => 'boardController',
    '14' => 'localDisk',
    '15' => 'diag',
    '16' => 'catalog',
    '17' => 'mgmtExt',
    '18' => 'debugPlugIn',
    '19' => 'switch',
    '20' => 'flexflashController',
    '22' => 'bladeSspOsController',
    '23' => 'fxosCspCompatibility',
    '24' => 'fprRommon',
    '25' => 'graphicsCard',
    '26' => 'fprFirmware',
    '27' => 'fprCspapp',
  },
  'CfprApAaaSession' => {
    '0' => 'local',
    '1' => 'remote',
    '2' => 'ipmi',
  },
  'CfprApFabricVConPlacementPref' => {
    '1' => 'physical',
    '2' => 'auto',
  },
  'CfprApPortPIoFsmStageName' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresenceBegin',
    '236' => 'inCompatSfpPresenceShutdown',
    '237' => 'inCompatSfpReplacedBegin',
    '238' => 'inCompatSfpReplacedEnablePort',
    '732' => 'inCompatSfpPresenceFail',
    '733' => 'inCompatSfpPresenceSuccess',
    '734' => 'inCompatSfpReplacedFail',
    '735' => 'inCompatSfpReplacedSuccess',
  },
  'CfprApProcessorEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inputCurrent',
      '1' => 'inputCurrentAvg',
      '2' => 'inputCurrentMax',
      '3' => 'inputCurrentMin',
      '4' => 'temperature',
      '5' => 'temperatureAvg',
      '6' => 'temperatureMax',
      '7' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricAFcoeEstcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApSysdebugCoreExportStatus' => {
    '1' => 'success',
    '2' => 'failure',
  },
  'CfprApEtherRxStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'jumboPacketsDelta',
      '5' => 'jumboPacketsDeltaAvg',
      '6' => 'jumboPacketsDeltaMax',
      '7' => 'jumboPacketsDeltaMin',
      '8' => 'multicastPacketsDelta',
      '9' => 'multicastPacketsDeltaAvg',
      '10' => 'multicastPacketsDeltaMax',
      '11' => 'multicastPacketsDeltaMin',
      '12' => 'totalBytesDelta',
      '13' => 'totalBytesDeltaAvg',
      '14' => 'totalBytesDeltaMax',
      '15' => 'totalBytesDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'unicastPacketsDelta',
      '21' => 'unicastPacketsDeltaAvg',
      '22' => 'unicastPacketsDeltaMax',
      '23' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicIPv4DnsPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CfprApEtherInternalPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApHostagAgentType' => {
    '0' => 'indeterminate',
    '1' => 'pnuosAgent',
    '2' => 'hostAgent',
  },
  'CfprApNwctrlRegistrationMode' => {
    '0' => 'onlyNativeVlan',
    '1' => 'allHostVlans',
  },
  'CfprApEquipmentSwitchIOCardFsmStageName' => {
    '0' => 'nop',
    '219' => 'fePresenceBegin',
    '220' => 'fePresenceCheckLicense',
    '221' => 'fePresenceIdentify',
    '222' => 'feConnBegin',
    '223' => 'feConnConfigureSwMgmtEndPoint',
    '224' => 'feConnConfigureVifNs',
    '580' => 'feConnFail',
    '581' => 'feConnSuccess',
    '582' => 'fePresenceFail',
    '583' => 'fePresenceSuccess',
  },
  'CfprApEtherPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresence',
    '237' => 'inCompatSfpReplaced',
  },
  'CfprApPortEthAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
  },
  'CfprApFabricAFcoeEstcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLicenseInstanceFsmTaskItem' => {
    '0' => 'nop',
    '153' => 'updateFlexlm',
  },
  'CfprApCapabilityUpdaterFsmCurrentFsm' => {
    '0' => 'nop',
    '413' => 'updater',
  },
  'CfprApMgmtEntityChassisDeviceIoState2' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'openError',
    '3' => 'readError',
    '4' => 'writeError',
  },
  'CfprApStorageBatteryType' => {
    '0' => 'unknown',
    '1' => 'battery',
    '2' => 'supercap',
  },
  'CfprApPolicyPolicyOwner' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
  },
  'CfprApStorageActualWriteType' => {
    '0' => 'unknown',
    '1' => 'writeThrough',
    '2' => 'writeBack',
  },
  'CfprApSysdebugTechSupportFsmCurrentFsm' => {
    '0' => 'nop',
    '366' => 'initiate',
    '368' => 'deleteTechSupFile',
    '371' => 'download',
  },
  'CfprApSdAppInstanceFsmTaskItem' => {
    '0' => 'nop',
    '250' => 'installApplication',
    '254' => 'startApplication',
    '263' => 'upgradeApplication',
    '267' => 'stopApplication',
    '272' => 'uninstallApplication',
    '278' => 'bundleDataPorts',
  },
  'CfprApLicenseFileFsmStageName' => {
    '0' => 'nop',
    '147' => 'installBegin',
    '148' => 'installLocal',
    '149' => 'installRemote',
    '150' => 'clearBegin',
    '151' => 'clearLocal',
    '152' => 'clearRemote',
    '636' => 'clearFail',
    '637' => 'clearSuccess',
    '638' => 'installFail',
    '639' => 'installSuccess',
  },
  'CfprApStorageConfiguredWriteType' => {
    '0' => 'unknown',
    '1' => 'writeThrough',
    '2' => 'writeBackGoodBbu',
    '3' => 'alwaysWriteBack',
  },
  'CfprApFabricFlowMonNonKeys' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'counterPacketsLong',
      '1' => 'counterBytesLong',
      '2' => 'sysUptimeFirst',
      '3' => 'sysUptimeLast',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIdentIdentType' => {
    '1' => 'mac',
    '2' => 'wwnn',
    '3' => 'wwpn',
    '4' => 'uuid',
    '5' => 'vlan',
    '6' => 'ipV4',
    '7' => 'ipV6',
    '8' => 'iqn',
  },
  'CfprApFabricLanCloudFsmStageName' => {
    '0' => 'nop',
    '449' => 'switchModeBegin',
    '450' => 'switchModeSwConfigPeer',
    '451' => 'switchModeSwConfigLocal',
    '606' => 'switchModeFail',
    '607' => 'switchModeSuccess',
  },
  'CfprApAdaptorIpV4RssHashProfileTcpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApBiosVfDirectCacheAccessVpDirectCacheAccess' => {
    '0' => 'platformRecommended',
    '62' => 'disabled',
    '63' => 'enabled',
  },
  'CfprApSdUpgradeTaskFsmTaskItem' => {
    '0' => 'nop',
    '306' => 'stopUpgradeStartApp',
  },
  'CfprApLsServerFsmCurrentFsm' => {
    '0' => 'nop',
    '158' => 'configure',
  },
  'CfprApBiosVfProcessorC6ReportVpProcessorC6Report' => {
    '0' => 'platformRecommended',
    '143' => 'disabled',
    '144' => 'enabled',
  },
  'CfprApStorageIniGroupProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CfprApSysdebugAutoCoreFileExportTargetFsmTaskItem' => {
    '0' => 'nop',
    '363' => 'configure',
  },
  'CfprApSwMonDomainLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEthEstcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmAppCommand' => {
    '0' => 'ok',
    '1' => 'retryAction',
    '2' => 'clearMgmtBootstrap',
  },
  'CfprApFabricComputePhEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CfprApDiagBladeTestType' => {
    '0' => 'disk',
    '1' => 'processor',
    '2' => 'memory',
    '3' => 'memtest',
    '4' => 'stress',
    '5' => 'pci',
  },
  'CfprApFabricEthFlowMonSrcRefType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPsuStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'fanSpeed',
      '5' => 'fanSpeedAvg',
      '6' => 'fanSpeedMax',
      '7' => 'fanSpeedMin',
      '8' => 'input210v',
      '9' => 'input210vAvg',
      '10' => 'input210vMax',
      '11' => 'input210vMin',
      '12' => 'inputCurrent',
      '13' => 'inputCurrentAvg',
      '14' => 'inputCurrentMax',
      '15' => 'inputCurrentMin',
      '16' => 'inputPower',
      '17' => 'inputPowerAvg',
      '18' => 'inputPowerMax',
      '19' => 'inputPowerMin',
      '20' => 'output12v',
      '21' => 'output12vAvg',
      '22' => 'output12vMax',
      '23' => 'output12vMin',
      '24' => 'output3v3',
      '25' => 'output3v3Avg',
      '26' => 'output3v3Max',
      '27' => 'output3v3Min',
      '28' => 'outputCurrent',
      '29' => 'outputCurrentAvg',
      '30' => 'outputCurrentMax',
      '31' => 'outputCurrentMin',
      '32' => 'outputPower',
      '33' => 'outputPowerAvg',
      '34' => 'outputPowerMax',
      '35' => 'outputPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommSvcEpFsmTaskItem' => {
    '0' => 'nop',
    '335' => 'updateSvcEp',
    '341' => 'restartWebSvc',
  },
  'CfprApVnicLanConnTemplSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '5' => 'aB',
    '6' => 'bA',
  },
  'CfprApAdaptorHostFcIfFsmStageName' => {
    '0' => 'nop',
    '135' => 'circuitResetBegin',
    '136' => 'circuitResetDisableA',
    '137' => 'circuitResetEnableA',
    '138' => 'circuitResetDisableB',
    '139' => 'circuitResetEnableB',
    '546' => 'circuitResetFail',
    '547' => 'circuitResetSuccess',
  },
  'CfprApStoragePathHA' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'initiator',
      '1' => 'target',
      '2' => 'fabric',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtExportPolicyAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApAdaptorLanCapDefaultVlan' => {
    '1' => 'nativeVlan',
    '2' => 'defaultVlan',
  },
  'CfprApEtherExternalPcAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApBiosVfOnboardSATAControllerVpSATAMode' => {
    '0' => 'platformRecommended',
    '80' => 'enhanced',
    '81' => 'ahci',
    '82' => 'swRaid',
    '83' => 'compatibility',
  },
  'CfprApFirmwareSupFirmwareFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '10' => 'samDmeFirmwareSupFirmwareDeployApplySupfw',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageSystemFsmTaskItem' => {
    '0' => 'nop',
    '325' => 'sync',
  },
  'CfprApConditionType' => {
    '0' => 'generic',
    '1' => 'fsm',
    '2' => 'network',
    '3' => 'server',
    '4' => 'configuration',
    '5' => 'sysdebug',
    '6' => 'equipment',
    '7' => 'environmental',
    '8' => 'management',
    '9' => 'connectivity',
    '10' => 'operational',
    '11' => 'security',
    '65535' => 'any',
  },
  'CfprApAdaptorExtIfPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfEnhancedIntelSpeedStepTechVpEnhancedIntelSpeedStepTech' => {
    '0' => 'platformRecommended',
    '22' => 'disabled',
    '23' => 'enabled',
  },
  'CfprApFirmwareEquipmentType' => {
    '0' => 'unknown',
    '1' => 'system',
    '2' => 'switch',
    '3' => 'iocard',
    '4' => 'server',
    '5' => 'cimc',
    '6' => 'adaptor',
    '7' => 'storageController',
    '8' => 'boardController',
    '9' => 'bios',
    '10' => 'serviceProfile',
    '11' => 'graphicsCard',
  },
  'CfprApPowerReallocation' => {
    '0' => 'chassis',
    '1' => 'none',
  },
  'CfprApGmetaCategory' => {
    '0' => 'unknown',
    '1' => 'inventory',
  },
  'CfprApEtherServerIntFIoPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeBladeFsmStageName' => {
    '0' => 'nop',
    '186' => 'diagBegin',
    '187' => 'diagConfigFeLocal',
    '188' => 'diagConfigFePeer',
    '189' => 'diagSwConfigLocal',
    '190' => 'diagSwConfigPeer',
    '191' => 'diagDisableServerConnSwB',
    '192' => 'diagEnableServerConnSwA',
    '193' => 'diagDisableServerConnSwA',
    '194' => 'diagEnableServerConnSwB',
    '195' => 'diagCleanupServerConnSwA',
    '196' => 'diagCleanupServerConnSwB',
    '197' => 'diagSwUnconfigLocal',
    '198' => 'diagSwUnconfigPeer',
    '199' => 'diagRemoveConfig',
    '200' => 'diagRestoreConfigFeLocal',
    '201' => 'diagRestoreConfigFePeer',
    '202' => 'diagEvaluateStatus',
    '203' => 'diagSuccess',
    '204' => 'diagFail',
    '208' => 'swConnUpdBegin',
    '209' => 'swConnUpdA',
    '210' => 'swConnUpdB',
    '213' => 'serviceInfraDeployBegin',
    '214' => 'serviceInfraDeploySwConfigLocal',
    '215' => 'serviceInfraDeploySwConfigPeer',
    '216' => 'serviceInfraWithdrawBegin',
    '217' => 'serviceInfraWithdrawSwUnConfigLocal',
    '218' => 'serviceInfraWithdrawSwUnConfigPeer',
    '564' => 'serviceInfraDeployFail',
    '565' => 'serviceInfraDeploySuccess',
    '566' => 'serviceInfraWithdrawFail',
    '567' => 'serviceInfraWithdrawSuccess',
    '568' => 'swConnUpdFail',
    '569' => 'swConnUpdSuccess',
  },
  'CfprApNfsMntOperState' => {
    '0' => 'unmounted',
    '1' => 'mounted',
  },
  'CfprApComputePsuClusterState' => {
    '0' => 'unknown',
    '1' => 'slot1Master',
    '2' => 'slot2Master',
    '3' => 'notClustered',
  },
  'CfprApSysdebugManualCoreFileExportTargetFsmStageName' => {
    '0' => 'nop',
    '358' => 'exportBegin',
    '359' => 'exportExecute',
    '816' => 'exportFail',
    '817' => 'exportSuccess',
  },
  'CfprApNetworkIfStatsUnits' => {
    '0' => 'raw',
    '1' => 'packets',
    '2' => 'octets',
  },
  'CfprApSwEthTargetEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwSanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApAdaptorEtherIfStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxBytesDelta',
      '1' => 'rxBytesDeltaAvg',
      '2' => 'rxBytesDeltaMax',
      '3' => 'rxBytesDeltaMin',
      '4' => 'rxDroppedDelta',
      '5' => 'rxDroppedDeltaAvg',
      '6' => 'rxDroppedDeltaMax',
      '7' => 'rxDroppedDeltaMin',
      '8' => 'rxErrorsDelta',
      '9' => 'rxErrorsDeltaAvg',
      '10' => 'rxErrorsDeltaMax',
      '11' => 'rxErrorsDeltaMin',
      '12' => 'rxPacketsDelta',
      '13' => 'rxPacketsDeltaAvg',
      '14' => 'rxPacketsDeltaMax',
      '15' => 'rxPacketsDeltaMin',
      '16' => 'txBytesDelta',
      '17' => 'txBytesDeltaAvg',
      '18' => 'txBytesDeltaMax',
      '19' => 'txBytesDeltaMin',
      '20' => 'txDroppedDelta',
      '21' => 'txDroppedDeltaAvg',
      '22' => 'txDroppedDeltaMax',
      '23' => 'txDroppedDeltaMin',
      '24' => 'txErrorsDelta',
      '25' => 'txErrorsDeltaAvg',
      '26' => 'txErrorsDeltaMax',
      '27' => 'txErrorsDeltaMin',
      '28' => 'txPacketsDelta',
      '29' => 'txPacketsDeltaAvg',
      '30' => 'txPacketsDeltaMax',
      '31' => 'txPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIqnpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApLsbootLocalHddImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
  },
  'CfprApSwConfigStatus' => {
    '1' => 'none',
    '2' => 'noVlanComp',
  },
  'CfprApEquipmentSlotArraySelector' => {
    '0' => 'unknown',
    '1' => 'psu',
    '2' => 'fan',
    '3' => 'iocard',
    '5' => 'diskSlot',
    '6' => 'driveSlot',
    '7' => 'usbPort',
    '8' => 'ethernetPort',
    '9' => 'comPort',
    '10' => 'parPort',
    '11' => 'vgaPort',
    '12' => 'dviPort',
    '13' => 'keyboardPort',
    '14' => 'mousePort',
    '15' => 'gem',
    '16' => 'blade',
  },
  'CfprApBiosVfUSBPortConfigurationVpUSBPortVMedia' => {
    '0' => 'platformRecommended',
    '312' => 'disabled',
    '313' => 'enabled',
  },
  'CfprApCommSvcEpFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '24' => 'samDmeCommSvcEpUpdateSvcEpEpChange',
      '25' => 'samDmeCommSvcEpUpdateSvcEpPropogateSettings',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdPortForwardingMode' => {
    '0' => 'individual',
    '1' => 'promiscuous',
  },
  'CfprApObserveObservedFsmStageName' => {
    '0' => 'nop',
    '239' => 'resolvePolicyFsmBegin',
    '240' => 'resolvePolicyFsmExecute',
    '241' => 'resolveResourceFsmBegin',
    '242' => 'resolveResourceFsmExecute',
    '243' => 'resolveVMFsmBegin',
    '244' => 'resolveVMFsmExecute',
    '245' => 'resolveControllerFsmBegin',
    '246' => 'resolveControllerFsmExecute',
    '688' => 'resolveControllerFsmFail',
    '689' => 'resolveControllerFsmSuccess',
    '690' => 'resolvePolicyFsmFail',
    '691' => 'resolvePolicyFsmSuccess',
    '692' => 'resolveResourceFsmFail',
    '693' => 'resolveResourceFsmSuccess',
    '694' => 'resolveVMFsmFail',
    '695' => 'resolveVMFsmSuccess',
  },
  'CfprApNetworkElementOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'removed',
  },
  'CfprApAdaptorPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApAdaptorHostFcIfFsmTaskItem' => {
    '0' => 'nop',
    '135' => 'circuitReset',
  },
  'CfprApSwEthEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBmcSELCntEqptInstIdPropId' => {
    '0' => 'unspecified',
    '673' => 'memoryUnitId',
    '1006' => 'processorUnitId',
  },
  'CfprApEquipmentCardStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temp',
      '1' => 'tempAvg',
      '2' => 'tempMax',
      '3' => 'tempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricLanCloudFsmTaskItem' => {
    '0' => 'nop',
    '449' => 'switchMode',
  },
  'CfprApFabricEthLanFlowMonExporterTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdClusterBootstrapFsmCurrentFsm' => {
    '0' => 'nop',
    '291' => 'updateClusterConfiguration',
  },
  'CfprApAdaptorEthPortErrStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'badCrcPacketsDelta',
      '1' => 'badCrcPacketsDeltaAvg',
      '2' => 'badCrcPacketsDeltaMax',
      '3' => 'badCrcPacketsDeltaMin',
      '4' => 'badLengthPacketsDelta',
      '5' => 'badLengthPacketsDeltaAvg',
      '6' => 'badLengthPacketsDeltaMax',
      '7' => 'badLengthPacketsDeltaMin',
      '8' => 'macDiscardedPacketsDelta',
      '9' => 'macDiscardedPacketsDeltaAvg',
      '10' => 'macDiscardedPacketsDeltaMax',
      '11' => 'macDiscardedPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFlowMonIpv4Keys' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ipv4SrcAddress',
      '1' => 'ipv4DestAddress',
      '2' => 'ipProtocol',
      '3' => 'ipTos',
      '4' => 'srcPort',
      '5' => 'destPort',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdClusterStatus' => {
    '0' => 'unknown',
    '1' => 'joined',
    '2' => 'left',
  },
  'CfprApBiosVfProcessorPrefetchConfigVpHardwarePrefetcher' => {
    '0' => 'platformRecommended',
    '316' => 'disabled',
    '317' => 'enabled',
  },
  'CfprApSysdebugLogControlEpFsmStageName' => {
    '0' => 'nop',
    '381' => 'logControlPersistBegin',
    '382' => 'logControlPersistLocal',
    '383' => 'logControlPersistPeer',
    '812' => 'logControlPersistFail',
    '813' => 'logControlPersistSuccess',
  },
  'CfprApFcpoolInitiatorPurpose' => {
    '0' => 'portWwn',
    '1' => 'nodeWwn',
    '2' => 'derived',
  },
  'CfprApQosclassEthBEPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CfprApBiosVfIntelVTForDirectedIOVpIntelVTDPassThroughDMASupport' => {
    '0' => 'platformRecommended',
    '60' => 'disabled',
    '61' => 'enabled',
  },
  'CfprApPoolElementOwner' => {
    '0' => 'endPoint',
    '1' => 'pool',
  },
  'CfprApVnicAScsiIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApVnicPortProfileType' => {
    '0' => 'regular',
    '1' => 'slaOnly',
  },
  'CfprApConditionLifecycle' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'flapping',
      '1' => 'soakingClear',
      '2' => 'soakingRaise',
      '3' => 'suppressed',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareHostPackConfigQualifier' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'biosImageNotSelected',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtBackupFsmTaskItem' => {
    '0' => 'nop',
    '473' => 'backup',
  },
  'CfprApEtherFtwPortPairFsmTaskItem' => {
    '0' => 'nop',
    '315' => 'configFtw',
  },
  'CfprApSwPhysFsmStageName' => {
    '0' => 'nop',
    '106' => 'confPhysicalBegin',
    '107' => 'confPhysicalPortInventorySwA',
    '108' => 'confPhysicalPortInventorySwB',
    '109' => 'confPhysicalConfigSwA',
    '110' => 'confPhysicalConfigSwB',
    '111' => 'confPhysicalVerifyPhysConfig',
    '112' => 'confPhysicalSuccess',
    '113' => 'confPhysicalFail',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot7LinkSpeed' => {
    '0' => 'platformRecommended',
    '262' => 'gen1',
    '263' => 'gen2',
    '264' => 'gen3',
    '265' => 'auto',
    '266' => 'disabled',
  },
  'CfprApFirmwareImageFsmTaskItem' => {
    '0' => 'nop',
    '11' => 'delete',
  },
  'CfprApEquipmentLedOperState' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'off',
    '3' => 'blinking',
    '4' => 'eth',
    '5' => 'fc',
  },
  'CfprApPowerGroupStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'power',
      '1' => 'powerAvg',
      '2' => 'powerMax',
      '3' => 'powerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlotMezzState' => {
    '0' => 'platformRecommended',
    '214' => 'disabled',
    '215' => 'enabled',
  },
  'CfprApSwExtUtilityFsmTaskItem' => {
    '0' => 'nop',
    '114' => 'confPortBreakout',
  },
  'CfprApFabricFcVsanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFabricRole' => {
    '0' => 'npu',
    '1' => 'cpu',
  },
  'CfprApStorageVDriveState' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'cacheDegraded',
    '3' => 'partiallyDegraded',
    '4' => 'degraded',
    '5' => 'offline',
  },
  'CfprApSysdebugLogExportPolicyFsmTaskItem' => {
    '0' => 'nop',
    '360' => 'configure',
  },
  'CfprApMgmtSource' => {
    '0' => 'unspecified',
    '1' => 'sharedLom',
    '2' => 'sideband',
  },
  'CfprApSmCspType' => {
    '0' => 'unknown',
    '1' => 'application',
    '2' => 'osPatch',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot6State' => {
    '0' => 'platformRecommended',
    '194' => 'disabled',
    '195' => 'enabled',
    '196' => 'uefiOnly',
    '197' => 'legacyOnly',
  },
  'CfprApFabricQosPrio' => {
    '0' => 'low',
    '1' => 'high',
  },
  'CfprApComputeDiscovery' => {
    '0' => 'undiscovered',
    '1' => 'inProgress',
    '2' => 'malformedFruInfo',
    '3' => 'fruNotReady',
    '4' => 'insufficientlyEquipped',
    '5' => 'invalidAdaptorIocard',
    '8' => 'failed',
    '16' => 'complete',
    '32' => 'retry',
    '64' => 'throttled',
    '128' => 'illegalFru',
    '129' => 'fruIdentityIndeterminate',
    '130' => 'fruStateIndeterminate',
    '131' => 'diagnosticsInProgress',
    '132' => 'efidiagnosticsInProgress',
    '133' => 'diagnosticsFailed',
    '134' => 'diagnosticsComplete',
    '135' => 'waitingForUserAck',
    '136' => 'userAcknowledged',
    '137' => 'waitingForMgmtAck',
    '138' => 'illegalPartNumber',
  },
  'CfprApFabricInternalDceSrvType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSwSrvEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApProcStatAdminState' => {
    '1' => 'on',
    '2' => 'clearStats',
    '3' => 'logStats',
  },
  'CfprApSdUpgradeTaskFsmStageName' => {
    '0' => 'nop',
    '306' => 'stopUpgradeStartAppBegin',
    '307' => 'stopUpgradeStartAppStopApp',
    '308' => 'stopUpgradeStartAppWaitForStopApp',
    '309' => 'stopUpgradeStartAppWaitForBladeReboot',
    '310' => 'stopUpgradeStartAppUpgradeApp',
    '311' => 'stopUpgradeStartAppWaitForUpgradeApp',
    '312' => 'stopUpgradeStartAppStartApp',
    '770' => 'stopUpgradeStartAppFail',
    '771' => 'stopUpgradeStartAppSuccess',
  },
  'CfprApVnicPlacement' => {
    '0' => 'allVnic',
    '1' => 'staticAllFirst',
    '2' => 'dynamicAllLast',
  },
  'CfprApEquipmentBeaconLedFsmStageName' => {
    '0' => 'nop',
    '247' => 'illuminateBegin',
    '248' => 'illuminateExecuteA',
    '249' => 'illuminateExecuteB',
    '576' => 'illuminateFail',
    '577' => 'illuminateSuccess',
  },
  'CfprApNhTableType' => {
    '1' => 'data',
    '2' => 'ctrl',
  },
  'CfprApSysdebugLogExportPolicyFsmStageName' => {
    '0' => 'nop',
    '360' => 'configureBegin',
    '361' => 'configureLocal',
    '362' => 'configurePeer',
    '814' => 'configureFail',
    '815' => 'configureSuccess',
  },
  'CfprApEquipmentLedColor' => {
    '0' => 'unknown',
    '1' => 'green',
    '2' => 'amber',
    '3' => 'red',
    '4' => 'blue',
  },
  'CfprApEquipmentChassisIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'chassisThermal',
      '1' => 'chassisInoperable',
      '2' => 'chassisVoltage',
      '3' => 'chassisPerf',
      '4' => 'chassisPower',
      '5' => 'removed',
      '6' => 'config',
      '7' => 'chassisPostFailure',
      '8' => 'psuThermal',
      '9' => 'psuInoperable',
      '10' => 'psuVoltage',
      '11' => 'psuPerf',
      '12' => 'psuPower',
      '13' => 'fanThermal',
      '14' => 'fanInoperable',
      '15' => 'fanVoltage',
      '16' => 'fanPerf',
      '17' => 'fanPower',
      '18' => 'iocardThermal',
      '19' => 'iocardInoperable',
      '20' => 'iocardVoltage',
      '21' => 'iocardPerf',
      '22' => 'iocardPower',
      '23' => 'computeThermal',
      '24' => 'computeInoperable',
      '25' => 'computeVoltage',
      '26' => 'computePerf',
      '27' => 'computePower',
      '28' => 'iocardInaccessible',
      '29' => 'fabricConnProblem',
      '30' => 'fabricUnsupportedConn',
      '31' => 'chassisLimitExceeded',
      '32' => 'chassisVifCapacityReduced',
      '33' => 'chassisPortChannelEnabled',
      '34' => 'chassisUnsupported',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorEthOffloadProfileTcpRxChecksum' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApVmHvType' => {
    '0' => 'unspecified',
    '1' => 'esx',
    '2' => 'kvm',
    '3' => 'hyperv',
    '4' => 'xen',
  },
  'CfprApProcessorEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inputCurrent',
      '1' => 'inputCurrentAvg',
      '2' => 'inputCurrentMax',
      '3' => 'inputCurrentMin',
      '4' => 'temperature',
      '5' => 'temperatureAvg',
      '6' => 'temperatureMax',
      '7' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricLanFlowMonCollectorType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorEthPortStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'goodPacketsDelta',
      '1' => 'goodPacketsDeltaAvg',
      '2' => 'goodPacketsDeltaMax',
      '3' => 'goodPacketsDeltaMin',
      '4' => 'pausePacketsDelta',
      '5' => 'pausePacketsDeltaAvg',
      '6' => 'pausePacketsDeltaMax',
      '7' => 'pausePacketsDeltaMin',
      '8' => 'perPriorityPausePacketsDelta',
      '9' => 'perPriorityPausePacketsDeltaAvg',
      '10' => 'perPriorityPausePacketsDeltaMax',
      '11' => 'perPriorityPausePacketsDeltaMin',
      '12' => 'pppPacketsDelta',
      '13' => 'pppPacketsDeltaAvg',
      '14' => 'pppPacketsDeltaMax',
      '15' => 'pppPacketsDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'vlanPacketsDelta',
      '21' => 'vlanPacketsDeltaAvg',
      '22' => 'vlanPacketsDeltaMax',
      '23' => 'vlanPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSwChEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApSdLinkDirection' => {
    '1' => 'rin',
    '2' => 'out',
    '3' => 'both',
  },
  'CfprApVnicIfOperState' => {
    '0' => 'indeterminate',
    '1' => 'up',
    '2' => 'down',
    '4' => 'failed',
  },
  'CfprApComputePCIeFatalReceiveStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bufferOverflowErrors',
      '1' => 'errFatalErrors',
      '2' => 'errNonFatalErrors',
      '3' => 'unsupportedRequestErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsbootLanType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
  },
  'CfprApVnicConnectionType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApEtherLossStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'sqetestDelta',
      '1' => 'sqetestDeltaAvg',
      '2' => 'sqetestDeltaMax',
      '3' => 'sqetestDeltaMin',
      '4' => 'carrierSenseDelta',
      '5' => 'carrierSenseDeltaAvg',
      '6' => 'carrierSenseDeltaMax',
      '7' => 'carrierSenseDeltaMin',
      '8' => 'excessCollisionDelta',
      '9' => 'excessCollisionDeltaAvg',
      '10' => 'excessCollisionDeltaMax',
      '11' => 'excessCollisionDeltaMin',
      '12' => 'giantsDelta',
      '13' => 'giantsDeltaAvg',
      '14' => 'giantsDeltaMax',
      '15' => 'giantsDeltaMin',
      '16' => 'lateCollisionDelta',
      '17' => 'lateCollisionDeltaAvg',
      '18' => 'lateCollisionDeltaMax',
      '19' => 'lateCollisionDeltaMin',
      '20' => 'multiCollisionDelta',
      '21' => 'multiCollisionDeltaAvg',
      '22' => 'multiCollisionDeltaMax',
      '23' => 'multiCollisionDeltaMin',
      '24' => 'singleCollisionDelta',
      '25' => 'singleCollisionDeltaAvg',
      '26' => 'singleCollisionDeltaMax',
      '27' => 'singleCollisionDeltaMin',
      '28' => 'symbolDelta',
      '29' => 'symbolDeltaAvg',
      '30' => 'symbolDeltaMax',
      '31' => 'symbolDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApSwFcSanBorderUplinkTrunking' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApMgmtIPv6IfAddrFsmCurrentFsm' => {
    '0' => 'nop',
    '399' => 'swMgmtOobIpv6IfConfig',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot2LinkSpeed' => {
    '0' => 'platformRecommended',
    '237' => 'gen1',
    '238' => 'gen2',
    '239' => 'gen3',
    '240' => 'auto',
    '241' => 'disabled',
  },
  'CfprApVmSwitchVendor' => {
    '0' => 'undetermined',
    '1' => 'vmware',
    '2' => 'microsoft',
  },
  'CfprApBiosVfConsoleRedirectionVpBaudRate' => {
    '0' => 'platformRecommended',
    '110' => 'n9600',
    '111' => 'n19200',
    '112' => 'n38400',
    '113' => 'n57600',
    '114' => 'n115200',
  },
  'CfprApPortPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresence',
    '237' => 'inCompatSfpReplaced',
  },
  'CfprApNhEpIdType' => {
    '1' => 'intf',
    '2' => 'lbgBlade',
    '3' => 'lbgClust',
    '4' => 'bcg',
    '5' => 'flg',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpPCIeSlotSASOptionROM' => {
    '0' => 'platformRecommended',
    '170' => 'disabled',
    '171' => 'enabled',
    '172' => 'uefiOnly',
    '173' => 'legacyOnly',
  },
  'CfprApFabricPcConfigStatus' => {
    '1' => 'applied',
    '2' => 'incompatibleSpeed',
  },
  'CfprApConditionCause' => {
    '0' => 'unknown',
    '1' => 'namedPolicyUnresolved',
    '2' => 'transition',
    '3' => 'vlanPermitUnresolved',
    '4' => 'groupPermitUnresolved',
    '5' => 'insufficientResources',
    '6' => 'insufficientlyEquipped',
    '7' => 'identityUnestablishable',
    '8' => 'powerProblem',
    '9' => 'thermalProblem',
    '10' => 'equipmentInoperable',
    '11' => 'discoveryFailed',
    '12' => 'associationFailed',
    '13' => 'disassociationFailed',
    '14' => 'equipmentMissing',
    '15' => 'equipmentInaccessible',
    '16' => 'vifIdsMismatch',
    '17' => 'adaptorMismatch',
    '18' => 'voltageProblem',
    '19' => 'emptyPool',
    '20' => 'equipmentProblem',
    '21' => 'boardCtrlUpgraded',
    '22' => 'vmediaMountInaccessible',
    '23' => 'decommissioned',
    '24' => 'beginFailed',
    '25' => 'fsmFailed',
    '26' => 'resolveFailed',
    '27' => 'checkInventoryStatusFailed',
    '28' => 'reportFullInventoryFailed',
    '29' => 'imageDeleted',
    '30' => 'imageUnusable',
    '31' => 'imageCannotBoot',
    '32' => 'activationFailed',
    '33' => 'cimcFirmwareMismatch',
    '34' => 'pldFirmwareMismatch',
    '35' => 'defaultHostpackMissing',
    '37' => 'localFailed',
    '38' => 'unpackLocalFailed',
    '39' => 'deleteLocalFailed',
    '40' => 'copyRemoteFailed',
    '41' => 'remoteFailed',
    '42' => 'copyExtToLocalFailed',
    '43' => 'copyExtToPeerFailed',
    '44' => 'startFailed',
    '45' => 'executeFailed',
    '46' => 'copyToLocalFailed',
    '47' => 'copyToPeerFailed',
    '48' => 'updateLocalFailed',
    '49' => 'verifyLocalFailed',
    '50' => 'resetLocalFailed',
    '51' => 'updateRemoteFailed',
    '52' => 'verifyRemoteFailed',
    '53' => 'resetRemoteFailed',
    '54' => 'copyImgFromRepFailed',
    '55' => 'copyiomimgToSubFailed',
    '56' => 'waitForReadyFailed',
    '57' => 'restoreFailed',
    '58' => 'waitForDeployFailed',
    '59' => 'validateApplicationPackFailed',
    '60' => 'deleteCurrentApplicationFailed',
    '61' => 'pollDeleteCurrentApplicationStatusFailed',
    '62' => 'setStartupServiceManagerVersionFailed',
    '63' => 'pollStartupServiceManagerStatusFailed',
    '64' => 'activateNpuImageFailed',
    '65' => 'pollNpuActivationStatusFailed',
    '66' => 'activateSystemImageFailed',
    '67' => 'activateFirmwareImageFailed',
    '68' => 'rebootSystemForImageUpgradeFailed',
    '69' => 'waitForSystemReadyFailed',
    '70' => 'pollSystemActivationStatusFailed',
    '71' => 'activateManagerImageFailed',
    '72' => 'pollManagerActivationStatusFailed',
    '73' => 'activateApplicationImageFailed',
    '74' => 'pollApplicationActivationStatusFailed',
    '75' => 'completeFirmwareUpgradeFailed',
    '76' => 'validateFirmwarePackFailed',
    '77' => 'debundlePortFailed',
    '78' => 'pollDebundlePortFailed',
    '79' => 'activateFirmwarePackFailed',
    '80' => 'pollActivateOfFirmwarePackFailed',
    '81' => 'updateImageVersionFailed',
    '82' => 'waitForFirmwareVersionUpdateFailed',
    '83' => 'updatePackageVersionFailed',
    '84' => 'resolveDistributableNamesFailed',
    '85' => 'resolveDistributableFailed',
    '86' => 'resolveImagesFailed',
    '87' => 'activateCatalogFailed',
    '88' => 'pingFailed',
    '89' => 'groupCapInsufficient',
    '90' => 'oldChassisComponentFirmware',
    '91' => 'oldFirmware',
    '92' => 'psuInsufficient',
    '93' => 'psuRedundancyFail',
    '94' => 'powerCapFail',
    '95' => 'powerConsumptionHitLimit',
    '96' => 'noAckFromBios',
    '97' => 'noCapFail',
    '98' => 'psuMixedMode',
    '99' => 'slotNotResponding',
    '100' => 'bladeNotWorking',
    '101' => 'diskFormatFailed',
    '102' => 'bladeSwap',
    '103' => 'switchConfigFailed',
    '104' => 'appinstanceNotResponding',
    '105' => 'appinstanceInstallFailed',
    '106' => 'appinstanceStartFailed',
    '107' => 'appinstanceUpdateFailed',
    '108' => 'appinstanceStopFailed',
    '109' => 'appinstanceError',
    '110' => 'logicalDeviceIncompleteConfiguration',
    '111' => 'logicalDeviceError',
    '112' => 'licenseAgreementNotAccepted',
    '113' => 'appinstanceUnsupported',
    '114' => 'appMetaCorrupted',
    '115' => 'updateFailed',
    '116' => 'stopDecoratorAppsFailed',
    '117' => 'wairForStopDecoratorsFailed',
    '118' => 'stopMainAppFailed',
    '119' => 'waitForBladeRebootFailed',
    '120' => 'waitForStopMainAppFailed',
    '121' => 'startAppsFailed',
    '122' => 'waitForPortReadyFailed',
    '123' => 'createLogicalDeviceFailed',
    '124' => 'updateConnectivityFailed',
    '125' => 'updateVlanGroupsFailed',
    '126' => 'updateEthFlowMonFailed',
    '127' => 'portInventorySwAfailed',
    '128' => 'portInventorySwBfailed',
    '129' => 'configSwAfailed',
    '130' => 'configSwBfailed',
    '131' => 'verifyPhysConfigFailed',
    '132' => 'successFailed',
    '133' => 'failFailed',
    '134' => 'verifyBreakoutConfigFailed',
    '135' => 'updateZonesFailed',
    '136' => 'noVlanOptimization',
    '137' => 'vifDown',
    '138' => 'configurationFailed',
    '139' => 'pinningMismatch',
    '140' => 'pinningMisconfig',
    '141' => 'inaccessibleVlanReferenced',
    '142' => 'referencedVlanUnresolvable',
    '143' => 'referencedRemoteVlanUnresolvable',
    '144' => 'invalidVlanInTheAllowedVlanList',
    '145' => 'vlanConflictPermit',
    '146' => 'profileConfigIncorrect',
    '147' => 'multipleConnectionPolicies',
    '148' => 'setLocalFailed',
    '149' => 'setPeerFailed',
    '150' => 'callhomeConfigError',
    '151' => 'disableFailed',
    '152' => 'enableFailed',
    '153' => 'disableAfailed',
    '154' => 'enableAfailed',
    '155' => 'disableBfailed',
    '156' => 'enableBfailed',
    '157' => 'unidentifiableFru',
    '158' => 'connectivityProblem',
    '159' => 'linkDown',
    '160' => 'linkMisconnected',
    '161' => 'linkMissing',
    '162' => 'validateLocalFailed',
    '163' => 'validateRemoteFailed',
    '164' => 'deleteRemoteFailed',
    '165' => 'equipmentDegraded',
    '166' => 'equipmentDisabled',
    '167' => 'applyTemplateFailed',
    '168' => 'applyIdentifiersFailed',
    '169' => 'checkAssignedIdentifiersForDupFailed',
    '170' => 'resolvePoliciesFailed',
    '171' => 'resolveNetworkPoliciesFailed',
    '172' => 'resolveNetworkTemplatesFailed',
    '173' => 'resolveIdentifiersFailed',
    '174' => 'applyDefaultIdentifiersFailed',
    '175' => 'checkAssignedDefaultIdentifiersForDupFailed',
    '176' => 'resolveDefaultIdentifiersFailed',
    '177' => 'resolveScheduleFailed',
    '178' => 'validatePolicyOwnershipFailed',
    '179' => 'applyPoliciesFailed',
    '180' => 'provisionStorageFailed',
    '181' => 'waitForStorageProvisionFailed',
    '182' => 'resolveBootConfigFailed',
    '183' => 'evaluateAssociationFailed',
    '184' => 'analyzeImpactFailed',
    '185' => 'waitForMaintPermissionFailed',
    '186' => 'waitForMaintWindowFailed',
    '187' => 'commitStorageFailed',
    '188' => 'waitForCommitStorageFailed',
    '189' => 'applyConfigFailed',
    '190' => 'waitForAssocCompletionFailed',
    '191' => 'configFeLocalFailed',
    '192' => 'configFePeerFailed',
    '193' => 'swConfigLocalFailed',
    '194' => 'swConfigPeerFailed',
    '195' => 'disableServerConnSwBfailed',
    '196' => 'enableServerConnSwAfailed',
    '197' => 'disableServerConnSwAfailed',
    '198' => 'enableServerConnSwBfailed',
    '199' => 'cleanupServerConnSwAfailed',
    '200' => 'cleanupServerConnSwBfailed',
    '201' => 'swUnconfigLocalFailed',
    '202' => 'swUnconfigPeerFailed',
    '203' => 'removeConfigFailed',
    '204' => 'restoreConfigFeLocalFailed',
    '205' => 'restoreConfigFePeerFailed',
    '206' => 'evaluateStatusFailed',
    '207' => 'cimcvlanCfgLocalFailed',
    '208' => 'cimcvlanCfgPeerFailed',
    '209' => 'aFailed',
    '210' => 'bFailed',
    '211' => 'swUnConfigLocalFailed',
    '212' => 'swUnConfigPeerFailed',
    '213' => 'checkLicenseFailed',
    '214' => 'identifyFailed',
    '215' => 'configureSwMgmtEndPointFailed',
    '216' => 'configureVifNsFailed',
    '217' => 'decomissionFailed',
    '218' => 'disableEndPointFailed',
    '219' => 'unIdentifyLocalFailed',
    '220' => 'unIdentifyPeerFailed',
    '221' => 'waitFailed',
    '222' => 'shutdownFailed',
    '223' => 'enablePortFailed',
    '224' => 'serverFailed',
    '225' => 'configurationFailure',
    '226' => 'maintenanceFailed',
    '227' => 'equipmentRemoved',
    '228' => 'serverInaccessible',
    '229' => 'assignmentFailed',
    '230' => 'unassociated',
    '231' => 'svnicNotPresent',
    '232' => 'nonExistentScheduler',
    '233' => 'unsupportedCimcFirmware',
    '234' => 'discoveryInProgress',
    '235' => 'configurationInProgress',
    '236' => 'unconfigurationInProgress',
    '237' => 'poweredOff',
    '238' => 'inMaintenance',
    '239' => 'underTest',
    '240' => 'serverUnassociated',
    '241' => 'serverAssociating',
    '242' => 'serverAssociated',
    '243' => 'serverDeassociating',
    '244' => 'serverUnassigned',
    '245' => 'serverAssigned',
    '246' => 'configurationNotApplied',
    '247' => 'configurationApplying',
    '248' => 'configurationApplied',
    '249' => 'newVnicVconSchemeApplied',
    '250' => 'satelliteConnectionAbsent',
    '251' => 'satelliteConnectionInit',
    '252' => 'satelliteMisConnected',
    '253' => 'unexpectedNumberOfLinks',
    '254' => 'equipmentOffline',
    '255' => 'fexUnsupported',
    '256' => 'performanceProblem',
    '257' => 'firmwareUpgradeProblem',
    '258' => 'unsupportedConnectivityConfiguration',
    '259' => 'equipmentUnacknowledged',
    '260' => 'autoFirmwareUpgrade',
    '261' => 'equipmentDisconnected',
    '262' => 'fruProblem',
    '263' => 'powerDown',
    '264' => 'act2Fail',
    '265' => 'healthLedAmberBlinking',
    '266' => 'tpmOnSlaveBoard',
    '267' => 'healthLedAmber',
    '268' => 'executeAfailed',
    '269' => 'executeBfailed',
    '270' => 'sendCommandFailed',
    '271' => 'waitStageFailed',
    '272' => 'updateAppInstanceFailed',
    '273' => 'checkBladeReadinessFailed',
    '274' => 'waitForAppsInstallationFailed',
    '275' => 'waitForLinkConfigurationFailed',
    '276' => 'releaseAppLicenseFailed',
    '277' => 'configureLinksFailed',
    '278' => 'waitForConfigCompletionFailed',
    '279' => 'updateBundleStatusFailed',
    '280' => 'sendBundleStatusFailed',
    '281' => 'sendInterfacesFailed',
    '282' => 'unconfigureLinksFailed',
    '283' => 'configureSwitchFailed',
    '284' => 'waitForSwitchConfigFailed',
    '285' => 'unconfigureLogicalDeviceFailed',
    '286' => 'sendStatusFailed',
    '287' => 'sendConfigFailed',
    '288' => 'startDiskFormatFailed',
    '289' => 'resetBladePowerFailed',
    '290' => 'waitForDiskFormatCompleteFailed',
    '291' => 'updateTimeZoneFailed',
    '292' => 'getAttributesFailed',
    '293' => 'sendUpdateFailed',
    '294' => 'stopAppFailed',
    '295' => 'waitForStopAppFailed',
    '296' => 'upgradeAppFailed',
    '297' => 'waitForUpgradeAppFailed',
    '298' => 'startAppFailed',
    '299' => 'configureFailed',
    '300' => 'clientLostConnectivity',
    '301' => 'licenseGraceperiodEntered',
    '302' => 'licenseGraceperiod10days',
    '303' => 'licenseGraceperiod30days',
    '304' => 'licenseGraceperiod60days',
    '305' => 'licenseGraceperiod90days',
    '306' => 'licenseGraceperiod119days',
    '307' => 'licenseGraceperiodExpired',
    '308' => 'licenseInsufficient',
    '309' => 'capacityExceeded',
    '310' => 'configurationError',
    '311' => 'operationFailed',
    '312' => 'equipmentUnhealthy',
    '313' => 'peerFailed',
    '314' => 'setEpLocalFailed',
    '315' => 'setEpPeerFailed',
    '316' => 'propogateEpSettingsFailed',
    '317' => 'propogateEpTimeZoneSettingsToFexIomLocalFailed',
    '318' => 'propogateEpTimeZoneSettingsToFexIomPeerFailed',
    '319' => 'providerGroupAlreadyExists',
    '320' => 'providerGroupSizeEmpty',
    '321' => 'invalidServerGroup',
    '322' => 'invalidKeyringCertificate',
    '323' => 'invalidKeyringModulus',
    '324' => 'invalidTrustpointCertChain',
    '325' => 'roleConfigError',
    '326' => 'localeConfigError',
    '327' => 'localeOrgConfigError',
    '328' => 'userRoleConfigError',
    '329' => 'userLocaleConfigError',
    '330' => 'keyringConfigError',
    '331' => 'snmpConfigError',
    '332' => 'timezoneFileNotExists',
    '333' => 'userConfigError',
    '334' => 'snmpUserConfigError',
    '335' => 'commSvcConfigError',
    '336' => 'setKeyRingLocalFailed',
    '337' => 'setKeyRingPeerFailed',
    '338' => 'postSetKeyRingLocalFailed',
    '339' => 'postSetKeyRingPeerFailed',
    '340' => 'setRealmLocalFailed',
    '341' => 'setRealmPeerFailed',
    '342' => 'setUserLocalFailed',
    '343' => 'setUserPeerFailed',
    '344' => 'serverError',
    '345' => 'tftpServerError',
    '346' => 'copySubFailed',
    '347' => 'copyPrimaryFailed',
    '348' => 'deleteSubFailed',
    '349' => 'deletePrimaryFailed',
    '350' => 'removeFailed',
    '351' => 'mgmtifDown',
    '352' => 'arpTargetsConfigError',
    '353' => 'ndiscTargetsConfigError',
    '354' => 'duplicatedAssigned',
    '355' => 'switchFailed',
    '356' => 'limitReached',
    '357' => 'nearMaxLimit',
    '358' => 'inventoryFailed',
    '359' => 'memoryError',
    '360' => 'extraPrimaryVlans',
    '361' => 'extraSecondaryVlans',
    '362' => 'extraSecondaryVlansPerPrimary',
    '363' => 'configInterfaceFailed',
    '364' => 'verifyLinkConfigFailed',
    '365' => 'setEpAfailed',
    '366' => 'setEpBfailed',
    '367' => 'bootupFailure',
    '368' => 'createLocalFailed',
    '369' => 'createRemoteFailed',
    '370' => 'suppressStatusChange',
    '371' => 'loadCatalogFailed',
    '372' => 'applyFailed',
    '373' => 'rescanImagesFailed',
    '374' => 'copyCatFromRepFailed',
    '375' => 'copyExternalRepToRemoteFailed',
    '376' => 'applyCatalogFailed',
    '377' => 'syncPortaglocalFailed',
    '378' => 'syncPortagremoteFailed',
    '379' => 'finalizeFailed',
    '380' => 'updateEthMonFailed',
    '381' => 'updateFcMonFailed',
    '382' => 'serverMoved',
    '383' => 'serverIdentificationProblem',
    '384' => 'primaryVlanMissingForIsolated',
    '385' => 'primaryVlanMissingForCommunity',
    '386' => 'emptyPinGroup',
    '387' => 'membershipDown',
    '388' => 'invalidTarget',
    '389' => 'configError',
    '390' => 'vlanMismatch',
    '391' => 'vlanErrorAssocPrimary',
    '392' => 'interfaceMisconfigured',
    '393' => 'missingPrimaryVlan',
    '394' => 'udldLinkDown',
    '395' => 'vlanMcastPolicyMisconfigured',
    '396' => 'namedVlanUnresolved',
    '397' => 'updateSspEthMonFailed',
    '398' => 'deletePcapFileFailed',
    '399' => 'syncFailed',
    '400' => 'validateConfigurationFailed',
    '401' => 'applyPhysicalFailed',
    '402' => 'waitOnPhysFailed',
    '403' => 'reportFailed',
    '404' => 'backupLocalFailed',
    '405' => 'uploadFailed',
    '406' => 'downloadLocalFailed',
    '407' => 'cleanUpFailed',
    '408' => 'configBreakoutFailed',
    '409' => 'waitForSwitchFailed',
    '410' => 'configFailed',
    '411' => 'reportResultsFailed',
    '412' => 'primaryFailed',
    '413' => 'secondaryFailed',
    '414' => 'electionFailure',
    '415' => 'managementServicesFailure',
    '416' => 'managementServicesUnresponsive',
    '417' => 'haNotReady',
    '418' => 'versionIncompatible',
    '419' => 'deviceSharedStorageError',
    '420' => 'haSshKeysMismatched',
    '421' => 'fprmProcessFailure',
    '422' => 'logCapacity',
    '423' => 'fileTransferFailed',
    '424' => 'newLink',
    '425' => 'anotherConnectionAlreadyEnabled',
    '426' => 'connectionUnused',
    '427' => 'unsupportedConnectivity',
    '428' => 'incompatibleServerFirmware',
    '429' => 'namedInbandVlanUnresolved',
    '430' => 'inbandUnsupportedServer',
    '431' => 'configBackupOutdated',
    '432' => 'leadershipChange',
    '433' => 'deviceSharedStorageIOError',
    '434' => 'registerClientFailed',
    '435' => 'verifyRegistrationFailed',
    '436' => 'mountLocalFailed',
    '437' => 'mountPeerFailed',
    '438' => 'unmountLocalFailed',
    '439' => 'unmountPeerFailed',
    '440' => 'portFailed',
    '441' => 'unsupportedTransceiver',
    '442' => 'interfaceFailed',
    '443' => 'operationalStateDown',
    '444' => 'cmcVifDown',
    '445' => 'verifyGuidFailed',
    '446' => 'unregisterFailed',
    '447' => 'cleanOldDataFailed',
    '448' => 'requestFailed',
    '449' => 'verifyFailed',
    '450' => 'resolveAllFailed',
    '451' => 'suspendModeEntered',
    '452' => 'releaseFailed',
    '453' => 'resolveManyFailed',
    '454' => 'releaseManyFailed',
    '455' => 'releaseAllFailed',
    '456' => 'thresholdCrossed',
    '457' => 'waitForChassisMoReadyFailed',
    '458' => 'unsupported',
    '459' => 'checkFirmwareUpgradeStatusFailed',
    '460' => 'defaultInfraVersionMissing',
    '461' => 'defaultInfraBundleValidationFailed',
    '464' => 'defaultInfraBundleInstallAppFailure',
  },
  'CfprApSwUtilityDomainFsmTaskItem' => {
    '0' => 'nop',
    '102' => 'deploy',
  },
  'CfprApUuidpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApComputePsuRedundancy' => {
    '1' => 'nonRedundant',
    '2' => 'nPlus1',
    '3' => 'grid',
  },
  'CfprApSwEthLanBorderTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApDcxProtState' => {
    '0' => 'noProtection',
    '1' => 'active',
    '2' => 'passive',
  },
  'CfprApEquipmentChassisConfigProgressIndicator' => {
    '0' => 'ackNotInProgress',
    '1' => 'ackInProgress',
  },
  'CfprApVmHvClInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CfprApGmetaHolderFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'samDmeGmetaHolderInventoryRegister',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommSyslogSourceFaults' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApImgsecKeyType' => {
    '0' => 'public',
    '1' => 'private',
    '2' => 'shared',
  },
  'CfprApFabricHostPortId' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CfprApFabricEthEstcPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugAutoCoreFileExportTargetFsmStageName' => {
    '0' => 'nop',
    '363' => 'configureBegin',
    '364' => 'configureLocal',
    '365' => 'configurePeer',
    '808' => 'configureFail',
    '809' => 'configureSuccess',
  },
  'CfprApAdaptorCapSpecType' => {
    '1' => 'virtualizedEthIf',
    '2' => 'virtualizedFcIf',
    '3' => 'virtualizedScsiIf',
    '4' => 'nonVirtualizedEthIf',
    '5' => 'nonVirtualizedFcIf',
    '6' => 'fcoe',
    '7' => 'protectedEthIf',
    '8' => 'protectedFcIf',
    '9' => 'protectedFcoe',
    '10' => 'pathEncapVirtual',
    '11' => 'pathEncapConsolidated',
    '12' => 'uplinkAggregation',
    '13' => 'virtualizedEthSriov',
    '14' => 'virtualizedFcSriov',
    '15' => 'virtualizedEthSriovUsnic',
    '16' => 'virtualizedEthVmq',
    '17' => 'ethFlowMonitoringNetflow',
    '18' => 'ethRoce',
    '19' => 'ethVxlan',
    '20' => 'ethNvgre',
  },
  'CfprApSdMgmtInfoFsmTaskItem' => {
    '0' => 'nop',
    '302' => 'updateMgmtInfo',
  },
  'CfprApFirmwarePlatformPackFsmCurrentFsm' => {
    '0' => 'nop',
    '34' => 'platformVersion',
  },
  'CfprApInitiatorInitiatorEpPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CfprApSysdebugTechSupportFsmStageName' => {
    '0' => 'nop',
    '366' => 'initiateBegin',
    '367' => 'initiateLocal',
    '368' => 'deleteTechSupFileBegin',
    '369' => 'deleteTechSupFileLocal',
    '370' => 'deleteTechSupFilePeer',
    '371' => 'downloadBegin',
    '372' => 'downloadCopySub',
    '373' => 'downloadCopyPrimary',
    '374' => 'downloadDeleteSub',
    '375' => 'downloadDeletePrimary',
    '818' => 'deleteTechSupFileFail',
    '819' => 'deleteTechSupFileSuccess',
    '820' => 'downloadFail',
    '821' => 'downloadSuccess',
    '822' => 'initiateFail',
    '823' => 'initiateSuccess',
  },
  'CfprApSwEthLanFlowMonitorType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtImportStatus' => {
    '0' => 'idle',
    '1' => 'downloadSucceeded',
    '2' => 'configSucceeded',
    '3' => 'succeeded',
    '4' => 'failed',
  },
  'CfprApFirmwareUpgradeCategory' => {
    '0' => 'other',
    '1' => 'dataLoad',
    '2' => 'catalog',
    '3' => 'config',
    '4' => 'serverReboot',
    '5' => 'faults',
  },
  'CfprApPortEthSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n10gbps',
    '3' => 'n20gbps',
    '4' => 'n40gbps',
    '5' => 'n100gbps',
    '7' => 'n100mbps',
  },
  'CfprApSwAccessDomainFsmTaskItem' => {
    '0' => 'nop',
    '95' => 'deploy',
  },
  'CfprApFabricSanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsbootLanBootProt' => {
    '0' => 'pxe',
    '1' => 'gpxe',
    '2' => 'iSCSI',
  },
  'CfprApAdaptorExtIfEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfSelectMemoryRASConfigurationVpSelectMemoryRASConf' => {
    '0' => 'platformRecommended',
    '64' => 'maximumPerformance',
    '65' => 'mirroring',
    '66' => 'lockstep',
    '67' => 'sparing',
  },
  'CfprApAaaCimcSessionType' => {
    '0' => 'all',
    '1' => 'kvm',
    '2' => 'vmedia',
    '3' => 'sol',
  },
  'CfprApAdaptorHostEthIfFsmStageName' => {
    '0' => 'nop',
    '130' => 'circuitResetBegin',
    '131' => 'circuitResetDisableA',
    '132' => 'circuitResetEnableA',
    '133' => 'circuitResetDisableB',
    '134' => 'circuitResetEnableB',
    '544' => 'circuitResetFail',
    '545' => 'circuitResetSuccess',
  },
  'CfprApVnicFcBasePersBind' => {
    '0' => 'disabled',
    '4' => 'enabled',
  },
  'CfprApComputeAvailability' => {
    '0' => 'unavailable',
    '1' => 'available',
  },
  'CfprApEpqosDefinitionFsmTaskItem' => {
    '0' => 'nop',
    '384' => 'deploy',
  },
  'CfprApStorageFFCardHealth' => {
    '0' => 'ffPhyHealthNa',
    '1' => 'ffPhyHealthOk',
    '2' => 'ffPhyUnhealthyRaid',
    '3' => 'ffPhyUnhealthyOther',
  },
  'CfprApCallhomeAlertThrottlingAdminState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApSysdebugExportStatus' => {
    '1' => 'success',
    '2' => 'failure',
  },
  'CfprApEtherSatelliteConnectionDisc' => {
    '0' => 'absent',
    '1' => 'present',
    '2' => 'misConnect',
    '3' => 'missing',
    '4' => 'new',
  },
  'CfprApVnicOrderScheme' => {
    '0' => 'zeroFuncAll',
    '1' => 'multiFuncAll',
    '2' => 'staticZeroFunc',
  },
  'CfprApSdSlotFsmTaskItem' => {
    '0' => 'nop',
    '276' => 'changePlatformLogLevel',
    '293' => 'formatDisk',
    '298' => 'synchTimeZone',
  },
  'CfprApBiosVfUSBBootConfigVpMakeDeviceNonBootable' => {
    '0' => 'platformRecommended',
    '131' => 'disabled',
    '132' => 'enabled',
  },
  'CfprApFabricEthLanPcVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CfprApQosclassFcPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CfprApEtherPauseStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'recvPauseDelta',
      '1' => 'recvPauseDeltaAvg',
      '2' => 'recvPauseDeltaMax',
      '3' => 'recvPauseDeltaMin',
      '4' => 'resetsDelta',
      '5' => 'resetsDeltaAvg',
      '6' => 'resetsDeltaMax',
      '7' => 'resetsDeltaMin',
      '8' => 'xmitPauseDelta',
      '9' => 'xmitPauseDeltaAvg',
      '10' => 'xmitPauseDeltaMax',
      '11' => 'xmitPauseDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricBreakoutType' => {
    '0' => 'unknown',
    '1' => 'n10g4x',
  },
  'CfprApEquipmentSlotArrayOrientation' => {
    '0' => 'unknown',
    '1' => 'vertical',
    '2' => 'horizontal',
  },
  'CfprApComputeRackUnitFsmCurrentFsm' => {
    '0' => 'nop',
    '208' => 'swConnUpd',
    '213' => 'serviceInfraDeploy',
    '216' => 'serviceInfraWithdraw',
  },
  'CfprApFabricEthLanPcLacpDetach' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApPolicyPolicyOperStatus' => {
    '0' => 'ok',
    '1' => 'resolved',
    '2' => 'released',
  },
  'CfprApSdNetMgmtBootstrapFsmStageName' => {
    '0' => 'nop',
    '304' => 'updateNetMgmtBootstrapBegin',
    '305' => 'updateNetMgmtBootstrapSendUpdate',
    '762' => 'updateNetMgmtBootstrapFail',
    '763' => 'updateNetMgmtBootstrapSuccess',
  },
  'CfprApSdAppAttributeCtrlFsmCurrentFsm' => {
    '0' => 'nop',
    '300' => 'getAppAttributes',
  },
  'CfprApSwSspEthMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthLanBorderFsmTaskItem' => {
    '0' => 'nop',
    '97' => 'deploy',
  },
  'CfprApLsmaintChangeMode' => {
    '0' => 'noChange',
    '1' => 'unconfig',
    '2' => 'forceUnconfig',
    '4' => 'rediscover',
    '8' => 'config',
    '16' => 'diagConfig',
    '32' => 'diagUnconfig',
    '64' => 'removeConfig',
    '128' => 'diag',
  },
  'CfprApPolicyControlSource' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
  },
  'CfprApComputeRackUnitMbTempStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'frontTemp',
      '5' => 'frontTempAvg',
      '6' => 'frontTempMax',
      '7' => 'frontTempMin',
      '8' => 'ioh1Temp',
      '9' => 'ioh1TempAvg',
      '10' => 'ioh1TempMax',
      '11' => 'ioh1TempMin',
      '12' => 'ioh2Temp',
      '13' => 'ioh2TempAvg',
      '14' => 'ioh2TempMax',
      '15' => 'ioh2TempMin',
      '16' => 'rearTemp',
      '17' => 'rearTempAvg',
      '18' => 'rearTempMax',
      '19' => 'rearTempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherServerIntFIoPcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApFirmwareTriggerState' => {
    '0' => 'triggered',
    '1' => 'trigger',
  },
  'CfprApFabricDceSwSrvPcAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApSysdebugCoreFileAdminState' => {
    '0' => 'init',
    '1' => 'prepareDownload',
    '2' => 'downloaded',
  },
  'CfprApBiosVfFrontPanelLockoutVpFrontPanelLockout' => {
    '0' => 'platformRecommended',
    '94' => 'disabled',
    '95' => 'enabled',
  },
  'CfprApFabricLanCloudFsmCurrentFsm' => {
    '0' => 'nop',
    '449' => 'switchMode',
  },
  'CfprApFabricEpVlanVlanType' => {
    '0' => 'regular',
    '1' => 'default',
    '2' => 'native',
    '3' => 'fcoeuplinknative',
  },
  'CfprApPowerProfilingMethod' => {
    '0' => 'unknown',
    '1' => 'default',
    '2' => 'static',
    '3' => 'pnuos',
    '4' => 'nodemgr',
  },
  'CfprApExtpolRegistryFsmTaskItem' => {
    '0' => 'nop',
    '319' => 'crossDomainConfig',
    '322' => 'crossDomainDelete',
  },
  'CfprApPolicyPolicyScopeFsmTaskItem' => {
    '0' => 'nop',
    '506' => 'releasePolicyFsm',
    '508' => 'releaseOperationFsm',
    '510' => 'releaseStorageFsm',
    '512' => 'resolveManyPolicyFsm',
    '514' => 'resolveManyOperationFsm',
    '516' => 'resolveManyStorageFsm',
    '518' => 'releaseManyPolicyFsm',
    '520' => 'releaseManyOperationFsm',
    '522' => 'releaseManyStorageFsm',
    '524' => 'resolveAllPolicyFsm',
    '526' => 'resolveAllOperationFsm',
    '528' => 'resolveAllStorageFsm',
    '530' => 'releaseAllPolicyFsm',
    '532' => 'releaseAllOperationFsm',
    '534' => 'releaseAllStorageFsm',
  },
  'CfprApAdaptorEthVxLANProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApGmetaHolderFsmCurrentFsm' => {
    '0' => 'nop',
    '3' => 'inventory',
  },
  'CfprApLicenseSmartConfigFsmStageName' => {
    '0' => 'nop',
    '156' => 'setConfigBegin',
    '157' => 'setConfigLocal',
    '642' => 'setConfigFail',
    '643' => 'setConfigSuccess',
  },
  'CfprApSwCardEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'slotOutlet1',
      '1' => 'slotOutlet1Avg',
      '2' => 'slotOutlet1Max',
      '3' => 'slotOutlet1Min',
      '4' => 'slotOutlet2',
      '5' => 'slotOutlet2Avg',
      '6' => 'slotOutlet2Max',
      '7' => 'slotOutlet2Min',
      '8' => 'slotOutlet3',
      '9' => 'slotOutlet3Avg',
      '10' => 'slotOutlet3Max',
      '11' => 'slotOutlet3Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcoeSanEpUdldAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApCallhomeHttpProxyEnable' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApAaaRadiusEpFsmCurrentFsm' => {
    '0' => 'nop',
    '349' => 'updateEp',
  },
  'CfprApFabricEthLanFlowMonitoringType' => {
    '0' => 'unknown',
    '1' => 'ethFlowMonitoring',
    '2' => 'span',
  },
  'CfprApFabricFlowMonitoringCategoryAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricVlanOperState' => {
    '1' => 'ok',
    '2' => 'errorMisconfigured',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot10LinkSpeed' => {
    '0' => 'platformRecommended',
    '277' => 'gen1',
    '278' => 'gen2',
    '279' => 'gen3',
    '280' => 'auto',
    '281' => 'disabled',
  },
  'CfprApEtherSwitchIntFIoPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPsuInputStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricLanEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtEntityMgmtServicesState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'unresponsive',
    '3' => 'down',
    '4' => 'switchoverInProgress',
  },
  'CfprApSwLanMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthLanEpUdldAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApMgmtEntityHaReadiness' => {
    '0' => 'unknown',
    '1' => 'ready',
    '2' => 'downgraded',
    '3' => 'notReady',
  },
  'CfprApBiosVfUSBConfigurationVpLegacyUSBSupport' => {
    '0' => 'platformRecommended',
    '358' => 'disabled',
    '359' => 'enabled',
    '360' => 'auto',
  },
  'CfprApExtpolConnType' => {
    '2' => 'serviceReg',
    '3' => 'identifierMgr',
    '4' => 'operationMgr',
    '5' => 'resourceMgr',
    '6' => 'statsMgr',
    '7' => 'centralMgr',
    '8' => 'virtualSwitchingMgr',
    '9' => 'policyMgr',
    '10' => 'bootMgr',
    '11' => 'vmMgr',
    '12' => 'managedEndpoint',
    '13' => 'mgmtController',
    '14' => 'storageBroker',
    '15' => 'resourceAggr',
    '18' => 'ape',
  },
  'CfprApSysdebugTechSupportAdminState' => {
    '0' => 'init',
    '1' => 'start',
    '2' => 'created',
    '3' => 'prepareDownload',
    '4' => 'delete',
  },
  'CfprApLsPowerState' => {
    '0' => 'down',
    '1' => 'up',
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
    '4' => 'hardResetImmediate',
    '5' => 'hardResetWait',
    '6' => 'softShutDown',
    '7' => 'softShutDownOnly',
    '12' => 'cmosResetImmediate',
    '13' => 'bmcResetImmediate',
    '14' => 'bmcResetWait',
    '15' => 'diagnosticInterrupt',
    '16' => 'kvmReset',
    '31' => 'adminUp',
    '32' => 'adminDown',
    '33' => 'ipmiReset',
  },
  'CfprApSwFcSanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeMbTempStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fmTempSenIo',
      '1' => 'fmTempSenIoAvg',
      '2' => 'fmTempSenIoMax',
      '3' => 'fmTempSenIoMin',
      '4' => 'fmTempSenRear',
      '5' => 'fmTempSenRearAvg',
      '6' => 'fmTempSenRearL',
      '7' => 'fmTempSenRearLAvg',
      '8' => 'fmTempSenRearLMax',
      '9' => 'fmTempSenRearLMin',
      '10' => 'fmTempSenRearMax',
      '11' => 'fmTempSenRearMin',
      '12' => 'fmTempSenRearR',
      '13' => 'fmTempSenRearRAvg',
      '14' => 'fmTempSenRearRMax',
      '15' => 'fmTempSenRearRMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricAFcoeEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIppoolDHCPMode' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFirmwareDependencySensitivity' => {
    '0' => 'global',
    '1' => 'fabric',
    '2' => 'path',
  },
  'CfprApStorageAccessType' => {
    '0' => 'unknown',
    '1' => 'readWrite',
    '2' => 'readOnly',
    '3' => 'blocked',
  },
  'CfprApFirmwareDownloaderFsmCurrentFsm' => {
    '0' => 'nop',
    '6' => 'download',
  },
  'CfprApNhPortType' => {
    '0' => 'phy',
    '1' => 'pch',
    '2' => 'vif',
  },
  'CfprApGmetaHolderFsmTaskItem' => {
    '0' => 'nop',
    '3' => 'inventory',
  },
  'CfprApPkiEpFsmTaskItem' => {
    '0' => 'nop',
    '344' => 'updateEp',
  },
  'CfprApFabricVConSelectPref' => {
    '1' => 'assignedOnly',
    '2' => 'unassignedOnly',
    '4' => 'dynamicOnly',
    '7' => 'excludeUsnic',
    '8' => 'usnicOnly',
    '11' => 'excludeDynamic',
    '13' => 'excludeUnassigned',
    '15' => 'all',
  },
  'CfprApSwSspEthMonSrcPhyEpFsmTaskItem' => {
    '0' => 'nop',
    '445' => 'delete',
  },
  'CfprApFabricSwSrvEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApFabricUdldOperState' => {
    '0' => 'unknown',
    '1' => 'unidirectional',
    '2' => 'bidirectional',
    '3' => 'txRxLoop',
    '4' => 'mismatch',
    '5' => 'echoEmpty',
    '6' => 'adminDisabled',
  },
  'CfprApFabricLanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApAdaptorMenloHostPortStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxPauseCFCDelta',
      '1' => 'rxPauseCFCDeltaAvg',
      '2' => 'rxPauseCFCDeltaMax',
      '3' => 'rxPauseCFCDeltaMin',
      '4' => 'rxPausePFCDelta',
      '5' => 'rxPausePFCDeltaAvg',
      '6' => 'rxPausePFCDeltaMax',
      '7' => 'rxPausePFCDeltaMin',
      '8' => 'txPauseCFCDelta',
      '9' => 'txPauseCFCDeltaAvg',
      '10' => 'txPauseCFCDeltaMax',
      '11' => 'txPauseCFCDeltaMin',
      '12' => 'txPausePFCDelta',
      '13' => 'txPausePFCDeltaAvg',
      '14' => 'txPausePFCDeltaMax',
      '15' => 'txPausePFCDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApGmetaHolderFsmStageName' => {
    '0' => 'nop',
    '3' => 'inventoryBegin',
    '4' => 'inventoryCheckInventoryStatus',
    '5' => 'inventoryReportFullInventory',
    '626' => 'inventoryFail',
    '627' => 'inventorySuccess',
  },
  'CfprApSdUpgradeTaskFsmCurrentFsm' => {
    '0' => 'nop',
    '306' => 'stopUpgradeStartApp',
  },
  'CfprApSdMgmtInfoFsmStageName' => {
    '0' => 'nop',
    '302' => 'updateMgmtInfoBegin',
    '303' => 'updateMgmtInfoSendUpdate',
    '760' => 'updateMgmtInfoFail',
    '761' => 'updateMgmtInfoSuccess',
  },
  'CfprApAdaptorExternalEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEpMgrFsmStageName' => {
    '0' => 'nop',
    '455' => 'configureBegin',
    '456' => 'configureValidateConfiguration',
    '457' => 'configureApplyPhysical',
    '458' => 'configureWaitOnPhys',
    '459' => 'configureApplyConfig',
    '604' => 'configureFail',
    '605' => 'configureSuccess',
  },
  'CfprApStatsCollectionDomain' => {
    '0' => 'unknown',
    '1' => 'chassis',
    '2' => 'server',
    '3' => 'port',
    '4' => 'fex',
  },
  'CfprApLsbootIScsiImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApFabricEthFlowMonLanTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApInitiatorGroupType' => {
    '1' => 'dedicated',
    '2' => 'shared',
    '3' => 'policy',
  },
  'CfprApSwEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fanCtrlrInlet1',
      '1' => 'fanCtrlrInlet1Avg',
      '2' => 'fanCtrlrInlet1Max',
      '3' => 'fanCtrlrInlet1Min',
      '4' => 'fanCtrlrInlet2',
      '5' => 'fanCtrlrInlet2Avg',
      '6' => 'fanCtrlrInlet2Max',
      '7' => 'fanCtrlrInlet2Min',
      '8' => 'fanCtrlrInlet3',
      '9' => 'fanCtrlrInlet3Avg',
      '10' => 'fanCtrlrInlet3Max',
      '11' => 'fanCtrlrInlet3Min',
      '12' => 'fanCtrlrInlet4',
      '13' => 'fanCtrlrInlet4Avg',
      '14' => 'fanCtrlrInlet4Max',
      '15' => 'fanCtrlrInlet4Min',
      '16' => 'mainBoardOutlet1',
      '17' => 'mainBoardOutlet1Avg',
      '18' => 'mainBoardOutlet1Max',
      '19' => 'mainBoardOutlet1Min',
      '20' => 'mainBoardOutlet2',
      '21' => 'mainBoardOutlet2Avg',
      '22' => 'mainBoardOutlet2Max',
      '23' => 'mainBoardOutlet2Min',
      '24' => 'psuCtrlrInlet1',
      '25' => 'psuCtrlrInlet1Avg',
      '26' => 'psuCtrlrInlet1Max',
      '27' => 'psuCtrlrInlet1Min',
      '28' => 'psuCtrlrInlet2',
      '29' => 'psuCtrlrInlet2Avg',
      '30' => 'psuCtrlrInlet2Max',
      '31' => 'psuCtrlrInlet2Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentLedLocatorState' => {
    '0' => 'inactive',
    '1' => 'off',
    '2' => 'on',
  },
  'CfprApFabricConfMode' => {
    '0' => 'none',
    '1' => 'logicalConfigInvalid',
    '2' => 'validatingConf',
    '3' => 'applyPhysTrans',
    '4' => 'confSwitch',
  },
  'CfprApVnicDefaultAction' => {
    '0' => 'none',
    '1' => 'hwInherit',
  },
  'CfprApMgmtIntAuthPolicyMethod' => {
    '0' => 'none',
    '1' => 'password',
  },
  'CfprApFabricEthLanFlowMonSrcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicAFcIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApPolicyControlledTypeFsmTaskItem' => {
    '0' => 'nop',
    '504' => 'operate',
  },
  'CfprApQosclassEthClassifiedAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApLsAgentCapability' => {
    '1' => 'l2IfConfig',
    '2' => 'l3IfConfig',
    '4' => 'hostNameConfig',
    '8' => 'stats',
    '16' => 'states',
  },
  'CfprApAdaptorEtherIfStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxBytesDelta',
      '1' => 'rxBytesDeltaAvg',
      '2' => 'rxBytesDeltaMax',
      '3' => 'rxBytesDeltaMin',
      '4' => 'rxDroppedDelta',
      '5' => 'rxDroppedDeltaAvg',
      '6' => 'rxDroppedDeltaMax',
      '7' => 'rxDroppedDeltaMin',
      '8' => 'rxErrorsDelta',
      '9' => 'rxErrorsDeltaAvg',
      '10' => 'rxErrorsDeltaMax',
      '11' => 'rxErrorsDeltaMin',
      '12' => 'rxPacketsDelta',
      '13' => 'rxPacketsDeltaAvg',
      '14' => 'rxPacketsDeltaMax',
      '15' => 'rxPacketsDeltaMin',
      '16' => 'txBytesDelta',
      '17' => 'txBytesDeltaAvg',
      '18' => 'txBytesDeltaMax',
      '19' => 'txBytesDeltaMin',
      '20' => 'txDroppedDelta',
      '21' => 'txDroppedDeltaAvg',
      '22' => 'txDroppedDeltaMax',
      '23' => 'txDroppedDeltaMin',
      '24' => 'txErrorsDelta',
      '25' => 'txErrorsDeltaAvg',
      '26' => 'txErrorsDeltaMax',
      '27' => 'txErrorsDeltaMin',
      '28' => 'txPacketsDelta',
      '29' => 'txPacketsDeltaAvg',
      '30' => 'txPacketsDeltaMax',
      '31' => 'txPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdClusterBootstrapFsmStageName' => {
    '0' => 'nop',
    '291' => 'updateClusterConfigurationBegin',
    '292' => 'updateClusterConfigurationSendConfig',
    '752' => 'updateClusterConfigurationFail',
    '753' => 'updateClusterConfigurationSuccess',
  },
  'CfprApPolicyRepairStateType' => {
    '0' => 'done',
    '1' => 'notDone',
  },
  'CfprApCommCipherSuiteMode' => {
    '1' => 'highStrength',
    '2' => 'mediumStrength',
    '3' => 'lowStrength',
    '4' => 'custom',
  },
  'CfprApAdaptorMenloMcpuStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropAclDelta',
      '1' => 'dropAclDeltaAvg',
      '2' => 'dropAclDeltaMax',
      '3' => 'dropAclDeltaMin',
      '4' => 'dropOverrunDelta',
      '5' => 'dropOverrunDeltaAvg',
      '6' => 'dropOverrunDeltaMax',
      '7' => 'dropOverrunDeltaMin',
      '8' => 'dropRuntDelta',
      '9' => 'dropRuntDeltaAvg',
      '10' => 'dropRuntDeltaMax',
      '11' => 'dropRuntDeltaMin',
      '12' => 'truncateOverrunDelta',
      '13' => 'truncateOverrunDeltaAvg',
      '14' => 'truncateOverrunDeltaMax',
      '15' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageAllocState' => {
    '0' => 'none',
    '1' => 'allocating',
    '2' => 'allocated',
    '3' => 'failed',
  },
  'CfprApFabricSwChEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeAdminPowerState' => {
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
    '4' => 'hardResetImmediate',
    '5' => 'hardResetWait',
    '12' => 'cmosResetImmediate',
    '13' => 'bmcResetImmediate',
    '14' => 'bmcResetWait',
    '15' => 'diagnosticInterrupt',
    '16' => 'kvmReset',
    '30' => 'policy',
    '31' => 'adminUp',
    '32' => 'adminDown',
    '33' => 'ipmiReset',
  },
  'CfprApFabricCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApVnicAppRole' => {
    '0' => 'none',
    '1' => 'mainCp',
    '2' => 'appCp',
    '3' => 'appIntMgmt',
    '4' => 'appExtMgmt',
    '5' => 'asaDp',
    '6' => 'appDp',
    '7' => 'offloadDp',
  },
  'CfprApSdAppAttributeCtrlFsmTaskItem' => {
    '0' => 'nop',
    '300' => 'getAppAttributes',
  },
  'CfprApBiosVfProcessorEnergyConfigurationVpPowerTechnology' => {
    '0' => 'platformRecommended',
    '333' => 'disabled',
    '334' => 'energyEfficient',
    '335' => 'performance',
    '336' => 'custom',
  },
  'CfprApAdaptorFcIfFrameStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dumpedFramesDelta',
      '1' => 'dumpedFramesDeltaAvg',
      '2' => 'dumpedFramesDeltaMax',
      '3' => 'dumpedFramesDeltaMin',
      '4' => 'errorFramesDelta',
      '5' => 'errorFramesDeltaAvg',
      '6' => 'errorFramesDeltaMax',
      '7' => 'errorFramesDeltaMin',
      '8' => 'rxFramesDelta',
      '9' => 'rxFramesDeltaAvg',
      '10' => 'rxFramesDeltaMax',
      '11' => 'rxFramesDeltaMin',
      '12' => 'txFramesDelta',
      '13' => 'txFramesDeltaAvg',
      '14' => 'txFramesDeltaMax',
      '15' => 'txFramesDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeServerDiscPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '1' => 'resolveScrubPolicy',
  },
  'CfprApFabricOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CfprApSysdebugTSCmdOptMajorType' => {
    '0' => 'chassis',
    '1' => 'fex',
    '2' => 'server',
    '3' => 'ucsm',
    '4' => 'ucsmMgmt',
  },
  'CfprApFabricFcEstcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApCommSyslogProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CfprApExtpolConnectorOperState' => {
    '0' => 'unregistered',
    '1' => 'lostVisibility',
    '2' => 'registering',
    '3' => 'synchronizing',
    '4' => 'registered',
    '5' => 'versionMismatch',
    '6' => 'registryNotReachable',
  },
  'CfprApServerConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'insufficientResources',
      '1' => 'boardControllerUpdateUnsupported',
      '2' => 'bootConfigurationInvalid',
      '3' => 'bootOrderIscsi',
      '4' => 'bootOrderPxe',
      '5' => 'bootOrderSanImagePath',
      '6' => 'computeUnavailable',
      '7' => 'computeUndiscovered',
      '8' => 'incompatBiosForSriovVnics',
      '9' => 'incompatibleBiosImage',
      '10' => 'insufficientPowerBudget',
      '11' => 'macAddressAssignment',
      '12' => 'memoryRequirement',
      '13' => 'migration',
      '14' => 'missingFirmwareImage',
      '15' => 'nonInterruptFsmRunning',
      '16' => 'physicalRequirement',
      '17' => 'powerGroupRequirement',
      '18' => 'processorRequirement',
      '19' => 'remotePolicy',
      '20' => 'serverPositionRequirement',
      '21' => 'remoteServiceProfile',
      '22' => 'systemUuidAssignment',
      '23' => 'wwnnDerivationFromVhba',
      '24' => 'resourceOwnershipConflict',
      '25' => 'bootipPolicyInvalid',
      '26' => 'hostimgPolicyInvalid',
      '27' => 'imgsecPolicyInvalid',
      '28' => 'provsrvPolicyInvalid',
      '29' => 'qosPolicyInvalid',
      '30' => 'bootConfigurationUnsupported',
      '31' => 'serverFeatureCapabilityMismatch',
      '32' => 'domainRequirement',
      '33' => 'duplicateAddressConflict',
      '34' => 'vmediaPolicyUnsupported',
      '35' => 'bootPolicyVmediaInvalid',
      '36' => 'vmediaMountConfigInvalid',
      '37' => 'softPinningVlanMismatch',
      '38' => 'cimcDowngradeRestriction',
      '39' => 'ivbCimcDowngradeRestriction',
      '40' => 'ivbBiosDowngradeRestriction',
      '41' => 'incompatibleSsposImage',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicHostNwIOPerfPref' => {
    '0' => 'none',
    '1' => 'highPerfReqd',
  },
  'CfprApSdNetMgmtBootstrapFsmCurrentFsm' => {
    '0' => 'nop',
    '304' => 'updateNetMgmtBootstrap',
  },
  'CfprApLsApply' => {
    '1' => 'onAssociation',
    '2' => 'runTime',
  },
  'CfprApPolicyPolicyScopeFsmCurrentFsm' => {
    '0' => 'nop',
    '506' => 'releasePolicyFsm',
    '508' => 'releaseOperationFsm',
    '510' => 'releaseStorageFsm',
    '512' => 'resolveManyPolicyFsm',
    '514' => 'resolveManyOperationFsm',
    '516' => 'resolveManyStorageFsm',
    '518' => 'releaseManyPolicyFsm',
    '520' => 'releaseManyOperationFsm',
    '522' => 'releaseManyStorageFsm',
    '524' => 'resolveAllPolicyFsm',
    '526' => 'resolveAllOperationFsm',
    '528' => 'resolveAllStorageFsm',
    '530' => 'releaseAllPolicyFsm',
    '532' => 'releaseAllOperationFsm',
    '534' => 'releaseAllStorageFsm',
  },
  'CfprApEquipmentPsuOutputStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfDRAMClockThrottlingVpDRAMClockThrottling' => {
    '0' => 'platformRecommended',
    '346' => 'auto',
    '347' => 'balanced',
    '348' => 'performance',
    '349' => 'energyEfficient',
  },
  'CfprApFabricExternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApSolSpeed' => {
    '6' => 'n9600',
    '7' => 'n19200',
    '8' => 'n38400',
    '9' => 'n57600',
    '10' => 'n115200',
  },
  'CfprApCommNtpProviderAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApConfigSorterDirection' => {
    '0' => 'ascending',
    '1' => 'descending',
  },
  'CfprApSwEthLanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommSvcEpFsmCurrentFsm' => {
    '0' => 'nop',
    '335' => 'updateSvcEp',
    '341' => 'restartWebSvc',
  },
  'CfprApFabricNetflowCollectorFlowProtocol' => {
    '1' => 'netflow',
  },
  'CfprApSysdebugBackupBehaviorProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApAaaAccountStatus' => {
    '0' => 'active',
    '1' => 'inactive',
  },
  'CfprApEtherServerIntFIoFsmStageName' => {
    '0' => 'nop',
    '313' => 'configSpeedBegin',
    '314' => 'configSpeedConfigure',
    '592' => 'configSpeedFail',
    '593' => 'configSpeedSuccess',
  },
  'CfprApCallhomeEpFsmCurrentFsm' => {
    '0' => 'nop',
    '124' => 'configCallhome',
  },
  'CfprApLsbootAccessType' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CfprApFirmwareSupFirmwareFsmTaskItem' => {
    '0' => 'nop',
    '56' => 'deploy',
  },
  'CfprApNetworkSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
  },
  'CfprApFirmwareAdminState' => {
    '0' => 'active',
    '1' => 'deleted',
  },
  'CfprApComputePhysicalFsmTaskItem' => {
    '0' => 'nop',
    '208' => 'swConnUpd',
    '213' => 'serviceInfraDeploy',
    '216' => 'serviceInfraWithdraw',
  },
  'CfprApAaaConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CfprApAdaptorHostFcIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CfprApFirmwareBootUnitMode' => {
    '0' => 'install',
    '1' => 'upgrade',
  },
  'CfprApFabricSSAPortType' => {
    '0' => 'data',
    '1' => 'mgmt',
    '2' => 'cluster',
    '3' => 'firepowerEventing',
  },
  'CfprApVnicEtherType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApStorageBbuStatus' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'learnCycleActive',
    '3' => 'learnCycleNeeded',
    '4' => 'failurePredicted',
    '5' => 'premiumFeatureReqd',
    '6' => 'microcodeUpdateReqd',
    '7' => 'replacementNeeded',
    '8' => 'noFlashSpace',
    '9' => 'notSupported',
    '10' => 'notPresent',
  },
  'CfprApComputeAdminMemoryState' => {
    '1' => 'policy',
    '2' => 'resetMemoryErrors',
    '3' => 'resetInProgress',
  },
  'CfprApEquipmentNetworkElementFanStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'drivePercentage',
      '1' => 'drivePercentageAvg',
      '2' => 'drivePercentageMax',
      '3' => 'drivePercentageMin',
      '4' => 'speed',
      '5' => 'speedAvg',
      '6' => 'speedMax',
      '7' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPresence' => {
    '0' => 'unknown',
    '1' => 'empty',
    '10' => 'equipped',
    '11' => 'missing',
    '12' => 'mismatch',
    '13' => 'equippedNotPrimary',
    '14' => 'equippedSlave',
    '15' => 'mismatchSlave',
    '16' => 'missingSlave',
    '20' => 'equippedIdentityUnestablishable',
    '21' => 'mismatchIdentityUnestablishable',
    '22' => 'equippedWithMalformedFru',
    '30' => 'inaccessible',
    '40' => 'unauthorized',
    '100' => 'notSupported',
  },
  'CfprApNfsMountInstFsmStageName' => {
    '0' => 'nop',
    '486' => 'mountBegin',
    '487' => 'mountRegisterClient',
    '488' => 'mountVerifyRegistration',
    '489' => 'mountMountLocal',
    '490' => 'mountMountPeer',
    '491' => 'unmountBegin',
    '492' => 'unmountUnmountLocal',
    '493' => 'unmountUnmountPeer',
    '680' => 'mountFail',
    '681' => 'mountSuccess',
    '682' => 'unmountFail',
    '683' => 'unmountSuccess',
  },
  'CfprApSwEthEstcPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwAccessEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentOperability' => {
    '0' => 'unknown',
    '1' => 'operable',
    '2' => 'inoperable',
    '3' => 'degraded',
    '4' => 'poweredOff',
    '5' => 'powerProblem',
    '6' => 'removed',
    '7' => 'voltageProblem',
    '8' => 'thermalProblem',
    '9' => 'performanceProblem',
    '10' => 'accessibilityProblem',
    '11' => 'identityUnestablishable',
    '12' => 'biosPostTimeout',
    '13' => 'disabled',
    '14' => 'malformedFru',
    '51' => 'fabricConnProblem',
    '52' => 'fabricUnsupportedConn',
    '81' => 'config',
    '82' => 'equipmentProblem',
    '83' => 'decomissioning',
    '84' => 'chassisLimitExceeded',
    '100' => 'notSupported',
    '101' => 'discovery',
    '102' => 'discoveryFailed',
    '103' => 'identify',
    '104' => 'postFailure',
    '105' => 'upgradeProblem',
    '106' => 'peerCommProblem',
    '107' => 'autoUpgrade',
    '108' => 'linkActivateBlocked',
  },
  'CfprApVnicVnicBootDev' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApDcxVIfProtRole' => {
    '0' => 'unprotected',
    '1' => 'primary',
    '2' => 'backup',
  },
  'CfprApSwFcSanBorderTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwNetflowExporterProtocol' => {
    '1' => 'netflow',
  },
  'CfprApAaaLdapEpFsmStageName' => {
    '0' => 'nop',
    '349' => 'updateEpBegin',
    '350' => 'updateEpSetEpLocal',
    '351' => 'updateEpSetEpPeer',
    '536' => 'updateEpFail',
    '537' => 'updateEpSuccess',
  },
  'CfprApSwSanMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricZoningState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApEquipmentFanStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'speed',
      '1' => 'speedAvg',
      '2' => 'speedMax',
      '3' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentFexPsuInputStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareInfraPackFsmCurrentFsm' => {
    '0' => 'nop',
    '828' => 'infraVersion',
  },
  'CfprApNfsMountDefFsmCurrentFsm' => {
    '0' => 'nop',
    '494' => 'reportNfsMountSuspend',
  },
  'CfprApVnicIScsiIfDefType' => {
    '0' => 'static',
    '1' => 'dynamicNw',
    '2' => 'option17',
    '4' => 'option43',
  },
  'CfprApSdLogicalDeviceFsmTaskItem' => {
    '0' => 'nop',
    '283' => 'configureLinks',
  },
  'CfprApLicenseConfigOperation' => {
    '0' => 'register',
    '1' => 'unregister',
    '2' => 'setdebug',
    '3' => 'cleardebug',
    '4' => 'renew',
    '5' => 'expireauth',
    '6' => 'expireeval',
    '7' => 'cadev',
    '8' => 'caprod',
  },
  'CfprApCommSvcEpFsmStageName' => {
    '0' => 'nop',
    '335' => 'updateSvcEpBegin',
    '336' => 'updateSvcEpSetEpLocal',
    '337' => 'updateSvcEpSetEpPeer',
    '338' => 'updateSvcEpPropogateEpSettings',
    '339' => 'updateSvcEpPropogateEpTimeZoneSettingsToFexIomLocal',
    '340' => 'updateSvcEpPropogateEpTimeZoneSettingsToFexIomPeer',
    '341' => 'restartWebSvcBegin',
    '342' => 'restartWebSvcLocal',
    '343' => 'restartWebSvcPeer',
    '560' => 'restartWebSvcFail',
    '561' => 'restartWebSvcSuccess',
    '562' => 'updateSvcEpFail',
    '563' => 'updateSvcEpSuccess',
  },
  'CfprApBiosVfAltitudeVpAltitude' => {
    '0' => 'platformRecommended',
    '361' => 'auto',
    '362' => 'n300M',
    '363' => 'n900M',
    '364' => 'n1500M',
    '365' => 'n3000M',
  },
  'CfprApLicenseDownloaderFsmTaskItem' => {
    '0' => 'nop',
    '140' => 'download',
  },
  'CfprApAdaptorMenloQErrorStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'popErrorsDelta',
      '5' => 'popErrorsDeltaAvg',
      '6' => 'popErrorsDeltaMax',
      '7' => 'popErrorsDeltaMin',
      '8' => 'pushErrorsDelta',
      '9' => 'pushErrorsDeltaAvg',
      '10' => 'pushErrorsDeltaMax',
      '11' => 'pushErrorsDeltaMin',
      '12' => 'uncorrectableErrorsDelta',
      '13' => 'uncorrectableErrorsDeltaAvg',
      '14' => 'uncorrectableErrorsDeltaMax',
      '15' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFcSourceType' => {
    '2' => 'uplinkPort',
    '3' => 'vsan',
    '4' => 'storage',
    '5' => 'portChannel',
    '20' => 'vhba',
  },
  'CfprApFabricVnetEpSyncEpFsmCurrentFsm' => {
    '0' => 'nop',
    '447' => 'pushVnetEpDeletion',
  },
  'CfprApMemoryType' => {
    '0' => 'undiscovered',
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'dram',
    '4' => 'edram',
    '5' => 'vram',
    '6' => 'sram',
    '7' => 'ram',
    '8' => 'rom',
    '9' => 'flash',
    '10' => 'eeprom',
    '11' => 'feprom',
    '12' => 'eprom',
    '13' => 'cdram',
    '14' => 'n3DRAM',
    '15' => 'sdram',
    '16' => 'sgram',
    '17' => 'rdram',
    '18' => 'ddr',
    '19' => 'ddr2',
    '20' => 'ddr2FbDimm',
    '24' => 'ddr3',
    '25' => 'fbd2',
  },
  'CfprApIpProtocol' => {
    '1' => 'tcp',
    '2' => 'udp',
  },
  'CfprApAdaptorHostEthIfFsmCurrentFsm' => {
    '0' => 'nop',
    '130' => 'circuitReset',
  },
  'CfprApLsOwner' => {
    '1' => 'management',
    '2' => 'physicalInherit',
    '4' => 'physicalDefaultConfig',
    '8' => 'tier',
  },
  'CfprApNwctrlAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApStorageSystemFsmStageName' => {
    '0' => 'nop',
    '325' => 'syncBegin',
    '326' => 'syncExecute',
    '784' => 'syncFail',
    '785' => 'syncSuccess',
  },
  'CfprApFabricCIoEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEtherPIoFsmStageName' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresenceBegin',
    '236' => 'inCompatSfpPresenceShutdown',
    '237' => 'inCompatSfpReplacedBegin',
    '238' => 'inCompatSfpReplacedEnablePort',
    '732' => 'inCompatSfpPresenceFail',
    '733' => 'inCompatSfpPresenceSuccess',
    '734' => 'inCompatSfpReplacedFail',
    '735' => 'inCompatSfpReplacedSuccess',
  },
  'CfprApDcxNsAllocStatus' => {
    '0' => 'available',
    '1' => 'full',
    '2' => 'exceeded',
  },
  'CfprApCallhomeAnonymousReportingAdminState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApFabricInternalDceSrvTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIpIPv4DnsPref' => {
    '0' => 'preferred',
    '1' => 'alternate',
  },
  'CfprApSwFcServerZoneGroupLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CfprApBiosVfUSBPortConfigurationVpPort6064Emulation' => {
    '0' => 'platformRecommended',
    '302' => 'disabled',
    '303' => 'enabled',
  },
  'CfprApAdaptorMenloBaseErrorStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'uncorrectableErrorsDelta',
      '5' => 'uncorrectableErrorsDeltaAvg',
      '6' => 'uncorrectableErrorsDeltaMax',
      '7' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricConfigState' => {
    '1' => 'applied',
    '2' => 'inconsistent',
  },
  'CfprApFabricWarnings' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fcZoningEnabled',
      '1' => 'configurationError',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwBorderPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfOnboardStorageVpOnboardSCUStorageSupport' => {
    '0' => 'platformRecommended',
    '84' => 'disabled',
    '85' => 'enabled',
  },
  'CfprApFirmwareFirmwareState' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'cimcFirmwareMismatch',
      '1' => 'pldFirmwareMismatch',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeABoardPower' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'test',
    '3' => 'off',
    '4' => 'online',
    '5' => 'offline',
    '6' => 'offduty',
    '7' => 'degraded',
    '8' => 'powerSave',
    '9' => 'error',
    '10' => 'ok',
    '11' => 'failed',
    '100' => 'notSupported',
  },
  'CfprApComputeRackUnitFsmStageName' => {
    '0' => 'nop',
    '208' => 'swConnUpdBegin',
    '209' => 'swConnUpdA',
    '210' => 'swConnUpdB',
    '213' => 'serviceInfraDeployBegin',
    '214' => 'serviceInfraDeploySwConfigLocal',
    '215' => 'serviceInfraDeploySwConfigPeer',
    '216' => 'serviceInfraWithdrawBegin',
    '217' => 'serviceInfraWithdrawSwUnConfigLocal',
    '218' => 'serviceInfraWithdrawSwUnConfigPeer',
    '564' => 'serviceInfraDeployFail',
    '565' => 'serviceInfraDeploySuccess',
    '566' => 'serviceInfraWithdrawFail',
    '567' => 'serviceInfraWithdrawSuccess',
    '568' => 'swConnUpdFail',
    '569' => 'swConnUpdSuccess',
  },
  'CfprApSmNetMgmtBootstrapType' => {
    '0' => 'nA',
    '1' => 'appagent',
    '2' => 'disk',
  },
  'CfprApComputePsuRedundancyOperQualifier' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'redundancyLost',
      '1' => 'redundancyDegraded',
      '2' => 'nonRedundantSufficientResources',
      '3' => 'nonRedundantInsufficientResources',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentSlotStatus' => {
    '0' => 'unknown',
    '1' => 'empty',
    '10' => 'equipped',
    '11' => 'missing',
    '12' => 'mismatch',
    '13' => 'equippedNotPrimary',
    '14' => 'equippedSlave',
    '15' => 'mismatchSlave',
    '16' => 'missingSlave',
    '20' => 'equippedIdentityUnestablishable',
    '21' => 'mismatchIdentityUnestablishable',
    '22' => 'equippedWithMalformedFru',
    '30' => 'inaccessible',
    '40' => 'unauthorized',
  },
  'CfprApSwBorderEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricLacpMode' => {
    '0' => 'none',
    '1' => 'active',
    '2' => 'on',
    '3' => 'passive',
  },
  'CfprApSwConfMode' => {
    '0' => 'none',
    '1' => 'inProgress',
    '2' => 'verifying',
    '3' => 'failed',
  },
  'CfprApSdExternalLduLinkFsmStageName' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatusBegin',
    '290' => 'updateInterfaceStatusSendStatus',
    '756' => 'updateInterfaceStatusFail',
    '757' => 'updateInterfaceStatusSuccess',
  },
  'CfprApStorageControllerStatus' => {
    '0' => 'unknown',
    '1' => 'optimal',
    '2' => 'failed',
    '3' => 'unresponsive',
  },
  'CfprApStorageTargetPath' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApSysdebugLogExportPolicyProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApNetworkPortRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApSdPortBundleOpType' => {
    '0' => 'bundled',
    '1' => 'deBundled',
  },
  'CfprApEquipmentFabricEpType' => {
    '0' => 'unknown',
    '1' => 'chassis',
    '2' => 'fex',
    '3' => 'blade',
    '4' => 'rackUnit',
  },
  'CfprApLicenseFileFsmTaskItem' => {
    '0' => 'nop',
    '147' => 'install',
    '150' => 'clear',
  },
  'CfprApOrgLevel' => {
    '0' => 'root',
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
  },
  'CfprApFabricEthPcProtocol' => {
    '1' => 'static',
    '2' => 'lacp',
  },
  'CfprApSwCimcId' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '1' => 'unused',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeServerMgmtDiscAction' => {
    '0' => 'autoAcknowledged',
    '1' => 'userAcknowledged',
  },
  'CfprApLsmaintAckChanges' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'serverIdentity',
      '1' => 'storage',
      '2' => 'networking',
      '3' => 'vnicVhbaPlacement',
      '4' => 'bootOrder',
      '5' => 'serverAssignment',
      '6' => 'operationalPolicies',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherSwitchIntFIoPcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApPortEncap' => {
    '0' => 'unknown',
    '1' => 'dot1q',
    '2' => 'isl',
    '3' => 'negotiate',
    '4' => 'proprietary',
  },
  'CfprApBiosVfConsoleRedirectionVpLegacyOSRedirection' => {
    '0' => 'platformRecommended',
    '119' => 'disabled',
    '120' => 'enabled',
  },
  'CfprApStorageConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'destructiveLocalDiskConfig',
      '1' => 'incompatibleDiskTypes',
      '2' => 'incompatibleNumberOfLocalDisks',
      '3' => 'incompatibleRaidLevel',
      '4' => 'missingRaidKey',
      '5' => 'storagePathConfigurationError',
      '6' => 'wwnnAssignment',
      '7' => 'zoneCapacity',
      '8' => 'flexflashController',
      '9' => 'flexflashCard',
      '10' => 'flexflashMetadata',
      '11' => 'storageFeatureCapabilityMismatch',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfScrubPoliciesVpPatrolScrub' => {
    '0' => 'platformRecommended',
    '324' => 'disabled',
    '325' => 'enabled',
  },
  'CfprApSwLanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApAdaptorFcIfFC4StatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'controlRequestsDelta',
      '1' => 'controlRequestsDeltaAvg',
      '2' => 'controlRequestsDeltaMax',
      '3' => 'controlRequestsDeltaMin',
      '4' => 'inputMegabytesDelta',
      '5' => 'inputMegabytesDeltaAvg',
      '6' => 'inputMegabytesDeltaMax',
      '7' => 'inputMegabytesDeltaMin',
      '8' => 'inputRequestsDelta',
      '9' => 'inputRequestsDeltaAvg',
      '10' => 'inputRequestsDeltaMax',
      '11' => 'inputRequestsDeltaMin',
      '12' => 'outputMegabytesDelta',
      '13' => 'outputMegabytesDeltaAvg',
      '14' => 'outputMegabytesDeltaMax',
      '15' => 'outputMegabytesDeltaMin',
      '16' => 'outputRequestsDelta',
      '17' => 'outputRequestsDeltaAvg',
      '18' => 'outputRequestsDeltaMax',
      '19' => 'outputRequestsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsOperState' => {
    '0' => 'indeterminate',
    '1' => 'unassociated',
    '10' => 'ok',
    '11' => 'discovery',
    '12' => 'config',
    '13' => 'unconfig',
    '14' => 'powerOff',
    '15' => 'restart',
    '20' => 'maintenance',
    '21' => 'test',
    '29' => 'computeMismatch',
    '30' => 'computeFailed',
    '31' => 'degraded',
    '32' => 'discoveryFailed',
    '33' => 'configFailure',
    '34' => 'unconfigFailed',
    '35' => 'testFailed',
    '36' => 'maintenanceFailed',
    '40' => 'removed',
    '41' => 'disabled',
    '50' => 'inaccessible',
    '60' => 'thermalProblem',
    '61' => 'powerProblem',
    '62' => 'voltageProblem',
    '63' => 'inoperable',
    '101' => 'decomissioning',
    '201' => 'biosRestore',
    '202' => 'cmosReset',
    '203' => 'diagnostics',
    '204' => 'diagnosticsFailed',
    '210' => 'pendingReboot',
    '211' => 'pendingReassociation',
    '212' => 'svnicNotPresent',
  },
  'CfprApFabricExternalLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApTrigTokenOperState' => {
    '0' => 'valid',
    '1' => 'expired',
  },
  'CfprApEquipmentPasswordState' => {
    '0' => 'unknown',
    '1' => 'set',
    '2' => 'notSet',
  },
  'CfprApProcessorUnitArch' => {
    '0' => 'any',
    '1' => 'intelP4C',
    '132' => 'opteron',
    '134' => 'turion64',
    '135' => 'dualCoreOpteron',
    '178' => 'pentium4',
    '179' => 'xeon',
    '181' => 'xeonMP',
  },
  'CfprApComputeOwner' => {
    '1' => 'policy',
    '2' => 'management',
  },
  'CfprApHostimgImgType' => {
    '0' => 'unknown',
    '1' => 'esxi',
    '2' => 'kvm',
    '3' => 'xen',
    '4' => 'linux',
    '5' => 'windows',
    '6' => 'gpxeScript',
  },
  'CfprApAdaptorEthOffloadProfileTcpSegment' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApSwEthMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysfileMutationFsmCurrentFsm' => {
    '0' => 'nop',
    '327' => 'single',
    '329' => 'global',
  },
  'CfprApSdLogicalDeviceFsmStageName' => {
    '0' => 'nop',
    '283' => 'configureLinksBegin',
    '284' => 'configureLinksSendInterfaces',
    '285' => 'configureLinksUnconfigureLinks',
    '286' => 'configureLinksConfigureSwitch',
    '287' => 'configureLinksWaitForSwitchConfig',
    '288' => 'configureLinksUnconfigureLogicalDevice',
    '758' => 'configureLinksFail',
    '759' => 'configureLinksSuccess',
  },
  'CfprApEquipmentRackUnitPsuStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'inputPower',
      '5' => 'inputPowerAvg',
      '6' => 'inputPowerMax',
      '7' => 'inputPowerMin',
      '8' => 'inputVoltage',
      '9' => 'inputVoltageAvg',
      '10' => 'inputVoltageMax',
      '11' => 'inputVoltageMin',
      '12' => 'outputCurrent',
      '13' => 'outputCurrentAvg',
      '14' => 'outputCurrentMax',
      '15' => 'outputCurrentMin',
      '16' => 'outputPower',
      '17' => 'outputPowerAvg',
      '18' => 'outputPowerMax',
      '19' => 'outputPowerMin',
      '20' => 'outputVoltage',
      '21' => 'outputVoltageAvg',
      '22' => 'outputVoltageMax',
      '23' => 'outputVoltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFlowMonitorAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApSwSystemStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'load',
      '1' => 'loadAvg',
      '2' => 'loadMax',
      '3' => 'loadMin',
      '4' => 'memAvailable',
      '5' => 'memAvailableAvg',
      '6' => 'memAvailableMax',
      '7' => 'memAvailableMin',
      '8' => 'memCached',
      '9' => 'memCachedAvg',
      '10' => 'memCachedMax',
      '11' => 'memCachedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugCoreFileOperState' => {
    '0' => 'unavailable',
    '1' => 'available',
    '2' => 'availableOnSubordinate',
    '3' => 'inProgress',
    '4' => 'failed',
  },
  'CfprApAdaptorFcErrorRecoveryProfileFcpErrorRecovery' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApComputeAlarmSeverity' => {
    '1' => 'minor',
    '2' => 'severe',
  },
  'CfprApSwVlanGroupType' => {
    '1' => 'compressed',
    '2' => 'uncompressed',
  },
  'CfprApCommSnmpConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CfprApEquipmentSlotSpanOrientation' => {
    '0' => 'unknown',
    '1' => 'inline',
    '2' => 'transverse',
  },
  'CfprApSwEthLanBorderFsmStageName' => {
    '0' => 'nop',
    '97' => 'deployBegin',
    '98' => 'deployUpdateVlanGroups',
    '99' => 'deployUpdateConnectivity',
    '788' => 'deployFail',
    '789' => 'deploySuccess',
  },
  'CfprApEtherNiErrStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'crcDelta',
      '1' => 'crcDeltaAvg',
      '2' => 'crcDeltaMax',
      '3' => 'crcDeltaMin',
      '4' => 'frameTxDelta',
      '5' => 'frameTxDeltaAvg',
      '6' => 'frameTxDeltaMax',
      '7' => 'frameTxDeltaMin',
      '8' => 'inRangeDelta',
      '9' => 'inRangeDeltaAvg',
      '10' => 'inRangeDeltaMax',
      '11' => 'inRangeDeltaMin',
      '12' => 'tooLongDelta',
      '13' => 'tooLongDeltaAvg',
      '14' => 'tooLongDeltaMax',
      '15' => 'tooLongDeltaMin',
      '16' => 'tooShortDelta',
      '17' => 'tooShortDeltaAvg',
      '18' => 'tooShortDeltaMax',
      '19' => 'tooShortDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwSspEthMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricBHVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApLicenseSmartConfigFsmTaskItem' => {
    '0' => 'nop',
    '156' => 'setConfig',
  },
  'CfprApEquipmentSecureBios' => {
    '0' => 'unknown',
    '1' => 'notSupported',
    '2' => 'supported',
  },
  'CfprApCommSshAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricSwChPhEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'remove',
  },
  'CfprApMgmtAccess' => {
    '0' => 'unspecified',
    '1' => 'inBand',
    '2' => 'outOfBand',
    '4' => 'internal',
    '8' => 'virtual',
  },
  'CfprApIdentIdDefinedInIdm' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApFabricEthEstcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApInitiatorFcInitiatorEpProt' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CfprApFirmwareUpgradeStatus' => {
    '0' => 'unknown',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'success',
    '4' => 'warnings',
    '5' => 'skipped',
  },
  'CfprApExtpolState' => {
    '0' => 'unknown',
    '1' => 'licenseOk',
    '2' => 'licenseInsufficient',
    '3' => 'licenseGraceperiod',
    '4' => 'licenseExpired',
    '5' => 'notApplicable',
  },
  'CfprApFabricEthTargetEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCallhomeAlertMessageType' => {
    '0' => 'inventory',
    '1' => 'syslog',
    '2' => 'test',
    '3' => 'diag',
    '4' => 'env',
    '5' => 'conf',
    '6' => 'telemetry',
    '100' => 'unknown',
  },
  'CfprApMgmtBackupProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApAdaptorExternalPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcSanBorderFsmTaskItem' => {
    '0' => 'nop',
    '100' => 'deploy',
    '122' => 'activateZoneSet',
  },
  'CfprApEquipmentResetOn' => {
    '0' => 'unknown',
    '1' => 'update',
    '2' => 'activate',
  },
  'CfprApCommSyslogRestrictedSeverity' => {
    '0' => 'emergencies',
    '1' => 'alerts',
    '2' => 'critical',
  },
  'CfprApAdaptorFcPortStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxBadFramesDelta',
      '1' => 'rxBadFramesDeltaAvg',
      '2' => 'rxBadFramesDeltaMax',
      '3' => 'rxBadFramesDeltaMin',
      '4' => 'rxFramesDelta',
      '5' => 'rxFramesDeltaAvg',
      '6' => 'rxFramesDeltaMax',
      '7' => 'rxFramesDeltaMin',
      '8' => 'txBadFramesDelta',
      '9' => 'txBadFramesDeltaAvg',
      '10' => 'txBadFramesDeltaMax',
      '11' => 'txBadFramesDeltaMin',
      '12' => 'txFramesDelta',
      '13' => 'txFramesDeltaAvg',
      '14' => 'txFramesDeltaMax',
      '15' => 'txFramesDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFcoeVsanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfUSBPortConfigurationVpUSBPortRear' => {
    '0' => 'platformRecommended',
    '304' => 'disabled',
    '305' => 'enabled',
  },
  'CfprApGmetaInventoryStatus' => {
    '0' => 'invDisable',
    '1' => 'invEnable',
    '2' => 'invStop',
    '3' => 'invThrottled',
  },
  'CfprApCimcvmediaDeviceType' => {
    '0' => 'unknown',
    '1' => 'cdd',
    '2' => 'hdd',
  },
  'CfprApEtherExternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApStorageFFCardMode' => {
    '0' => 'ffPhyDriveUnpairedPrimary',
    '1' => 'ffPhyDrivePrimary',
    '2' => 'ffPhyDriveSecondaryAct',
    '3' => 'ffPhyDriveSecondaryUnhealthy',
  },
  'CfprApAdaptorMenloNetInStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropFcLifInvalidDelta',
      '1' => 'dropFcLifInvalidDeltaAvg',
      '2' => 'dropFcLifInvalidDeltaMax',
      '3' => 'dropFcLifInvalidDeltaMin',
      '4' => 'dropFcMulticastDelta',
      '5' => 'dropFcMulticastDeltaAvg',
      '6' => 'dropFcMulticastDeltaMax',
      '7' => 'dropFcMulticastDeltaMin',
      '8' => 'dropNullPifDelta',
      '9' => 'dropNullPifDeltaAvg',
      '10' => 'dropNullPifDeltaMax',
      '11' => 'dropNullPifDeltaMin',
      '12' => 'fwdLookupNoHitDelta',
      '13' => 'fwdLookupNoHitDeltaAvg',
      '14' => 'fwdLookupNoHitDeltaMax',
      '15' => 'fwdLookupNoHitDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageControllerType' => {
    '0' => 'unknown',
    '1' => 'sas',
    '2' => 'sata',
    '3' => 'flash',
    '4' => 'sd',
  },
  'CfprApBiosVfProcessorCStateVpProcessorCState' => {
    '0' => 'platformRecommended',
    '145' => 'disabled',
    '146' => 'enabled',
  },
  'CfprApFabricNetflowMonSrcRefProtocol' => {
    '1' => 'netflow',
  },
  'CfprApFabricAFcoeSanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApExtpolEpFsmCurrentFsm' => {
    '0' => 'nop',
    '317' => 'registerFsm',
    '496' => 'repairCert',
  },
  'CfprApFabricConfState' => {
    '0' => 'ok',
    '1' => 'logicalConfigInvalid',
  },
  'CfprApBiosVfUSBConfigurationVpXHCIMode' => {
    '0' => 'platformRecommended',
    '356' => 'disabled',
    '357' => 'enabled',
  },
  'CfprApOsUpgradeState' => {
    '0' => 'undefined',
    '1' => 'inProgress',
    '2' => 'complete',
    '3' => 'retry',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CfprApAdaptorHostMgmtCapPresence' => {
    '0' => 'unspecified',
    '1' => 'host',
    '2' => 'cimc',
  },
  'CfprApBiosVfInterleaveConfigurationVpRankInterleaving' => {
    '0' => 'platformRecommended',
    '12' => 'auto',
    '13' => 'n1Way',
    '14' => 'n2Way',
    '15' => 'n4Way',
    '16' => 'n8Way',
  },
  'CfprApExtpolProviderFsmStageName' => {
    '0' => 'nop',
    '462' => 'reportConfigImportBegin',
    '463' => 'reportConfigImportReport',
    '598' => 'reportConfigImportFail',
    '599' => 'reportConfigImportSuccess',
  },
  'CfprApEquipmentActiveStatus' => {
    '0' => 'unknown',
    '1' => 'activated',
    '2' => 'deactivated',
  },
  'CfprApAdaptorNwMgmtCapApi' => {
    '0' => 'none',
    '1' => 'menlo',
    '2' => 'palo',
  },
  'CfprApBiosVfAssertNMIOnPERRVpAssertNMIOnPERR' => {
    '0' => 'platformRecommended',
    '98' => 'disabled',
    '99' => 'enabled',
  },
  'CfprApAdaptorVnicStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'droppedRxDelta',
      '9' => 'droppedRxDeltaAvg',
      '10' => 'droppedRxDeltaMax',
      '11' => 'droppedRxDeltaMin',
      '12' => 'droppedTxDelta',
      '13' => 'droppedTxDeltaAvg',
      '14' => 'droppedTxDeltaMax',
      '15' => 'droppedTxDeltaMin',
      '16' => 'errorsRxDelta',
      '17' => 'errorsRxDeltaAvg',
      '18' => 'errorsRxDeltaMax',
      '19' => 'errorsRxDeltaMin',
      '20' => 'errorsTxDelta',
      '21' => 'errorsTxDeltaAvg',
      '22' => 'errorsTxDeltaMax',
      '23' => 'errorsTxDeltaMin',
      '24' => 'packetsRxDelta',
      '25' => 'packetsRxDeltaAvg',
      '26' => 'packetsRxDeltaMax',
      '27' => 'packetsRxDeltaMin',
      '28' => 'packetsTxDelta',
      '29' => 'packetsTxDeltaAvg',
      '30' => 'packetsTxDeltaMax',
      '31' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysfileMutationAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CfprApSwMonSrcEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaDomainAuthRealm' => {
    '0' => 'local',
    '1' => 'radius',
    '2' => 'tacacs',
    '3' => 'ldap',
    '4' => 'none',
  },
  'CfprApDcxAdminState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CfprApNetworkLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApConditionCode' => {
    '0' => 'generic',
    '19' => 'f0019',
    '21' => 'f0021',
    '56' => 'f0056',
    '57' => 'f0057',
    '58' => 'f0058',
    '59' => 'f0059',
    '60' => 'f0060',
    '61' => 'f0061',
    '62' => 'f0062',
    '63' => 'f0063',
    '64' => 'f0064',
    '65' => 'f0065',
    '66' => 'f0066',
    '67' => 'f0067',
    '68' => 'f0068',
    '69' => 'f0069',
    '70' => 'f0070',
    '71' => 'f0071',
    '72' => 'f0072',
    '73' => 'f0073',
    '74' => 'f0074',
    '75' => 'f0075',
    '76' => 'f0076',
    '77' => 'f0077',
    '78' => 'f0078',
    '79' => 'f0079',
    '80' => 'f0080',
    '81' => 'f0081',
    '82' => 'f0082',
    '83' => 'f0083',
    '84' => 'f0084',
    '85' => 'f0085',
    '86' => 'f0086',
    '87' => 'f0087',
    '88' => 'f0088',
    '89' => 'f0089',
    '90' => 'f0090',
    '95' => 'f0095',
    '96' => 'f0096',
    '97' => 'f0097',
    '98' => 'f0098',
    '99' => 'f0099',
    '100' => 'f0100',
    '101' => 'f0101',
    '149' => 'f0149',
    '150' => 'f0150',
    '151' => 'f0151',
    '152' => 'f0152',
    '153' => 'f0153',
    '154' => 'f0154',
    '155' => 'f0155',
    '156' => 'f0156',
    '157' => 'f0157',
    '158' => 'f0158',
    '159' => 'f0159',
    '160' => 'f0160',
    '161' => 'f0161',
    '162' => 'f0162',
    '163' => 'f0163',
    '185' => 'f0185',
    '186' => 'f0186',
    '187' => 'f0187',
    '188' => 'f0188',
    '189' => 'f0189',
    '190' => 'f0190',
    '191' => 'f0191',
    '192' => 'f0192',
    '193' => 'f0193',
    '194' => 'f0194',
    '195' => 'f0195',
    '196' => 'f0196',
    '197' => 'f0197',
    '198' => 'f0198',
    '199' => 'f0199',
    '200' => 'f0200',
    '299' => 'f0299',
    '300' => 'f0300',
    '314' => 'f0314',
    '315' => 'f0315',
    '316' => 'f0316',
    '317' => 'f0317',
    '318' => 'f0318',
    '319' => 'f0319',
    '320' => 'f0320',
    '321' => 'f0321',
    '322' => 'f0322',
    '323' => 'f0323',
    '324' => 'f0324',
    '325' => 'f0325',
    '326' => 'f0326',
    '332' => 'f0332',
    '335' => 'f0335',
    '349' => 'f0349',
    '350' => 'f0350',
    '351' => 'f0351',
    '352' => 'f0352',
    '353' => 'f0353',
    '354' => 'f0354',
    '355' => 'f0355',
    '356' => 'f0356',
    '357' => 'f0357',
    '358' => 'f0358',
    '359' => 'f0359',
    '369' => 'f0369',
    '370' => 'f0370',
    '371' => 'f0371',
    '372' => 'f0372',
    '373' => 'f0373',
    '374' => 'f0374',
    '375' => 'f0375',
    '376' => 'f0376',
    '377' => 'f0377',
    '378' => 'f0378',
    '379' => 'f0379',
    '380' => 'f0380',
    '381' => 'f0381',
    '657' => 'f0657',
    '658' => 'f0658',
    '659' => 'f0659',
    '660' => 'f0660',
    '661' => 'f0661',
    '662' => 'f0662',
    '663' => 'f0663',
    '664' => 'f0664',
    '665' => 'f0665',
    '666' => 'f0666',
    '667' => 'f0667',
    '668' => 'f0668',
    '669' => 'f0669',
    '675' => 'f0675',
    '687' => 'f0687',
    '688' => 'f0688',
    '689' => 'f0689',
    '690' => 'f0690',
    '691' => 'f0691',
    '692' => 'f0692',
    '693' => 'f0693',
    '694' => 'f0694',
    '695' => 'f0695',
    '696' => 'f0696',
    '697' => 'f0697',
    '698' => 'f0698',
    '699' => 'f0699',
    '700' => 'f0700',
    '701' => 'f0701',
    '702' => 'f0702',
    '703' => 'f0703',
    '704' => 'f0704',
    '705' => 'f0705',
    '706' => 'f0706',
    '707' => 'f0707',
    '708' => 'f0708',
    '709' => 'f0709',
    '710' => 'f0710',
    '711' => 'f0711',
    '712' => 'f0712',
    '713' => 'f0713',
    '714' => 'f0714',
    '715' => 'f0715',
    '716' => 'f0716',
    '717' => 'f0717',
    '718' => 'f0718',
    '719' => 'f0719',
    '720' => 'f0720',
    '721' => 'f0721',
    '722' => 'f0722',
    '723' => 'f0723',
    '724' => 'f0724',
    '725' => 'f0725',
    '726' => 'f0726',
    '727' => 'f0727',
    '728' => 'f0728',
    '729' => 'f0729',
    '730' => 'f0730',
    '731' => 'f0731',
    '732' => 'f0732',
    '733' => 'f0733',
    '734' => 'f0734',
    '735' => 'f0735',
    '736' => 'f0736',
    '737' => 'f0737',
    '738' => 'f0738',
    '739' => 'f0739',
    '740' => 'f0740',
    '741' => 'f0741',
    '742' => 'f0742',
    '743' => 'f0743',
    '744' => 'f0744',
    '745' => 'f0745',
    '746' => 'f0746',
    '747' => 'f0747',
    '748' => 'f0748',
    '749' => 'f0749',
    '750' => 'f0750',
    '751' => 'f0751',
    '752' => 'f0752',
    '753' => 'f0753',
    '754' => 'f0754',
    '755' => 'f0755',
    '756' => 'f0756',
    '757' => 'f0757',
    '758' => 'f0758',
    '759' => 'f0759',
    '760' => 'f0760',
    '792' => 'f0792',
    '793' => 'f0793',
    '794' => 'f0794',
    '795' => 'f0795',
    '796' => 'f0796',
    '797' => 'f0797',
    '798' => 'f0798',
    '799' => 'f0799',
    '800' => 'f0800',
    '809' => 'f0809',
    '810' => 'f0810',
    '811' => 'f0811',
    '812' => 'f0812',
    '813' => 'f0813',
    '814' => 'f0814',
    '815' => 'f0815',
    '816' => 'f0816',
    '817' => 'f0817',
    '818' => 'f0818',
    '819' => 'f0819',
    '820' => 'f0820',
    '821' => 'f0821',
    '822' => 'f0822',
    '823' => 'f0823',
    '824' => 'f0824',
    '825' => 'f0825',
    '826' => 'f0826',
    '827' => 'f0827',
    '828' => 'f0828',
    '829' => 'f0829',
    '830' => 'f0830',
    '831' => 'f0831',
    '832' => 'f0832',
    '833' => 'f0833',
    '834' => 'f0834',
    '835' => 'f0835',
    '836' => 'f0836',
    '837' => 'f0837',
    '838' => 'f0838',
    '839' => 'f0839',
    '844' => 'f0844',
    '850' => 'f0850',
    '851' => 'f0851',
    '852' => 'f0852',
    '853' => 'f0853',
    '854' => 'f0854',
    '855' => 'f0855',
    '856' => 'f0856',
    '857' => 'f0857',
    '858' => 'f0858',
    '859' => 'f0859',
    '860' => 'f0860',
    '861' => 'f0861',
    '862' => 'f0862',
    '863' => 'f0863',
    '864' => 'f0864',
    '865' => 'f0865',
    '866' => 'f0866',
    '871' => 'f0871',
    '872' => 'f0872',
    '899' => 'f0899',
    '900' => 'f0900',
    '901' => 'f0901',
    '902' => 'f0902',
    '903' => 'f0903',
    '904' => 'f0904',
    '905' => 'f0905',
    '906' => 'f0906',
    '907' => 'f0907',
    '964' => 'f0964',
    '965' => 'f0965',
    '966' => 'f0966',
    '967' => 'f0967',
    '977' => 'f0977',
    '978' => 'f0978',
    '979' => 'f0979',
    '980' => 'f0980',
    '981' => 'f0981',
    '982' => 'f0982',
    '983' => 'f0983',
    '984' => 'f0984',
    '985' => 'f0985',
    '986' => 'f0986',
    '987' => 'f0987',
    '996' => 'f0996',
    '997' => 'f0997',
    '1014' => 'f1014',
    '1020' => 'f1020',
    '1038' => 'f1038',
    '1039' => 'f1039',
    '1040' => 'f1040',
    '1041' => 'f1041',
    '1042' => 'f1042',
    '1043' => 'f1043',
    '1044' => 'f1044',
    '1045' => 'f1045',
    '1046' => 'f1046',
    '1047' => 'f1047',
    '1048' => 'f1048',
    '1049' => 'f1049',
    '1050' => 'f1050',
    '1051' => 'f1051',
    '1052' => 'f1052',
    '1053' => 'f1053',
    '1054' => 'f1054',
    '1055' => 'f1055',
    '1056' => 'f1056',
    '1057' => 'f1057',
    '1058' => 'f1058',
    '1059' => 'f1059',
    '1060' => 'f1060',
    '1061' => 'f1061',
    '1062' => 'f1062',
    '1115' => 'f1115',
    '1116' => 'f1116',
    '1117' => 'f1117',
    '1118' => 'f1118',
    '1119' => 'f1119',
    '1120' => 'f1120',
    '1121' => 'f1121',
    '1122' => 'f1122',
    '1123' => 'f1123',
    '1124' => 'f1124',
    '1125' => 'f1125',
    '1126' => 'f1126',
    '1127' => 'f1127',
    '1128' => 'f1128',
    '1129' => 'f1129',
    '1130' => 'f1130',
    '1131' => 'f1131',
    '1132' => 'f1132',
    '1133' => 'f1133',
    '1134' => 'f1134',
    '1135' => 'f1135',
    '1136' => 'f1136',
    '1137' => 'f1137',
    '1138' => 'f1138',
    '1139' => 'f1139',
    '1140' => 'f1140',
    '1141' => 'f1141',
    '1150' => 'f1150',
    '1151' => 'f1151',
    '1152' => 'f1152',
    '1153' => 'f1153',
    '1154' => 'f1154',
    '1155' => 'f1155',
    '1156' => 'f1156',
    '1157' => 'f1157',
    '1158' => 'f1158',
    '1159' => 'f1159',
    '1174' => 'f1174',
    '1308' => 'f1308',
    '1309' => 'f1309',
    '1310' => 'f1310',
    '1311' => 'f1311',
    '1312' => 'f1312',
    '1313' => 'f1313',
    '16476' => 'f16476',
    '16477' => 'f16477',
    '16517' => 'f16517',
    '16518' => 'f16518',
    '16519' => 'f16519',
    '16520' => 'f16520',
    '16521' => 'f16521',
    '16522' => 'f16522',
    '16523' => 'f16523',
    '16524' => 'f16524',
    '16525' => 'f16525',
    '16526' => 'f16526',
    '16528' => 'f16528',
    '16529' => 'f16529',
    '16530' => 'f16530',
    '16585' => 'f16585',
    '16586' => 'f16586',
    '16587' => 'f16587',
    '16588' => 'f16588',
    '16589' => 'f16589',
    '16667' => 'f16667',
    '16668' => 'f16668',
    '16669' => 'f16669',
    '16670' => 'f16670',
    '16671' => 'f16671',
    '16676' => 'f16676',
    '16681' => 'f16681',
    '16682' => 'f16682',
    '16718' => 'f16718',
    '16727' => 'f16727',
    '16730' => 'f16730',
    '16731' => 'f16731',
    '16748' => 'f16748',
    '16749' => 'f16749',
    '16750' => 'f16750',
    '16751' => 'f16751',
    '16752' => 'f16752',
    '16770' => 'f16770',
    '16780' => 'f16780',
    '16803' => 'f16803',
    '16804' => 'f16804',
    '16805' => 'f16805',
    '16806' => 'f16806',
    '16807' => 'f16807',
    '16815' => 'f16815',
    '16816' => 'f16816',
    '16817' => 'f16817',
    '16818' => 'f16818',
    '16819' => 'f16819',
    '16822' => 'f16822',
    '16823' => 'f16823',
    '17063' => 'f17063',
    '17064' => 'f17064',
    '17065' => 'f17065',
    '17066' => 'f17066',
    '17149' => 'f17149',
    '17151' => 'f17151',
    '17152' => 'f17152',
    '17153' => 'f17153',
    '17154' => 'f17154',
    '17155' => 'f17155',
    '17156' => 'f17156',
    '17157' => 'f17157',
    '17158' => 'f17158',
    '17159' => 'f17159',
    '17160' => 'f17160',
    '17161' => 'f17161',
    '17162' => 'f17162',
    '17163' => 'f17163',
    '17164' => 'f17164',
    '17165' => 'f17165',
    '17166' => 'f17166',
    '17167' => 'f17167',
    '17169' => 'f17169',
    '17170' => 'f17170',
    '17185' => 'f17185',
    '17186' => 'f17186',
    '17187' => 'f17187',
    '17224' => 'f17224',
    '17226' => 'f17226',
    '17227' => 'f17227',
    '17231' => 'f17231',
    '17232' => 'f17232',
    '17233' => 'f17233',
    '17251' => 'f17251',
    '17252' => 'f17252',
    '17253' => 'f17253',
    '17254' => 'f17254',
    '17265' => 'f17265',
    '17266' => 'f17266',
    '17267' => 'f17267',
    '17268' => 'f17268',
    '17269' => 'f17269',
    '17270' => 'f17270',
    '17271' => 'f17271',
    '17272' => 'f17272',
    '17336' => 'f17336',
    '17337' => 'f17337',
    '17340' => 'f17340',
    '17347' => 'f17347',
    '17358' => 'f17358',
    '17359' => 'f17359',
    '17360' => 'f17360',
    '17373' => 'f17373',
    '17374' => 'f17374',
    '17378' => 'f17378',
    '17403' => 'f17403',
    '17408' => 'f17408',
    '17409' => 'f17409',
    '17410' => 'f17410',
    '17411' => 'f17411',
    '17420' => 'f17420',
    '17421' => 'f17421',
    '17469' => 'f17469',
    '17470' => 'f17470',
    '17476' => 'f17476',
    '17477' => 'f17477',
    '17478' => 'f17478',
    '17484' => 'f17484',
    '17490' => 'f17490',
    '17491' => 'f17491',
    '17492' => 'f17492',
    '17493' => 'f17493',
    '17494' => 'f17494',
    '17495' => 'f17495',
    '17496' => 'f17496',
    '17497' => 'f17497',
    '17498' => 'f17498',
    '17531' => 'f17531',
    '17532' => 'f17532',
    '17533' => 'f17533',
    '17554' => 'f17554',
    '17555' => 'f17555',
    '17556' => 'f17556',
    '17559' => 'f17559',
    '17560' => 'f17560',
    '17561' => 'f17561',
    '17562' => 'f17562',
    '17563' => 'f17563',
    '17564' => 'f17564',
    '17565' => 'f17565',
    '17566' => 'f17566',
    '17567' => 'f17567',
    '17568' => 'f17568',
    '17569' => 'f17569',
    '17570' => 'f17570',
    '17571' => 'f17571',
    '17572' => 'f17572',
    '17573' => 'f17573',
    '17690' => 'f17690',
    '34261' => 'f34261',
    '34263' => 'f34263',
    '34264' => 'f34264',
    '34265' => 'f34265',
    '34269' => 'f34269',
    '34271' => 'f34271',
    '34272' => 'f34272',
    '34273' => 'f34273',
    '34277' => 'f34277',
    '34279' => 'f34279',
    '34280' => 'f34280',
    '34281' => 'f34281',
    '34287' => 'f34287',
    '34289' => 'f34289',
    '34290' => 'f34290',
    '34291' => 'f34291',
    '34295' => 'f34295',
    '34297' => 'f34297',
    '34298' => 'f34298',
    '34299' => 'f34299',
    '34303' => 'f34303',
    '34305' => 'f34305',
    '34306' => 'f34306',
    '34307' => 'f34307',
    '34311' => 'f34311',
    '34313' => 'f34313',
    '34314' => 'f34314',
    '34315' => 'f34315',
    '34321' => 'f34321',
    '34323' => 'f34323',
    '34324' => 'f34324',
    '34325' => 'f34325',
    '34329' => 'f34329',
    '34331' => 'f34331',
    '34332' => 'f34332',
    '34333' => 'f34333',
    '34337' => 'f34337',
    '34339' => 'f34339',
    '34340' => 'f34340',
    '34341' => 'f34341',
    '34345' => 'f34345',
    '34347' => 'f34347',
    '34348' => 'f34348',
    '34349' => 'f34349',
    '34353' => 'f34353',
    '34355' => 'f34355',
    '34356' => 'f34356',
    '34357' => 'f34357',
    '34363' => 'f34363',
    '34365' => 'f34365',
    '34366' => 'f34366',
    '34367' => 'f34367',
    '34372' => 'f34372',
    '34383' => 'f34383',
    '34395' => 'f34395',
    '34406' => 'f34406',
    '34417' => 'f34417',
    '34428' => 'f34428',
    '34440' => 'f34440',
    '34451' => 'f34451',
    '34462' => 'f34462',
    '34474' => 'f34474',
    '34485' => 'f34485',
    '34496' => 'f34496',
    '34507' => 'f34507',
    '34841' => 'f34841',
    '34843' => 'f34843',
    '34844' => 'f34844',
    '34845' => 'f34845',
    '35108' => 'f35108',
    '35110' => 'f35110',
    '35111' => 'f35111',
    '35112' => 'f35112',
    '35116' => 'f35116',
    '35118' => 'f35118',
    '35119' => 'f35119',
    '35120' => 'f35120',
    '35124' => 'f35124',
    '35126' => 'f35126',
    '35127' => 'f35127',
    '35128' => 'f35128',
    '35132' => 'f35132',
    '35134' => 'f35134',
    '35135' => 'f35135',
    '35136' => 'f35136',
    '35140' => 'f35140',
    '35142' => 'f35142',
    '35143' => 'f35143',
    '35144' => 'f35144',
    '35148' => 'f35148',
    '35150' => 'f35150',
    '35151' => 'f35151',
    '35152' => 'f35152',
    '35156' => 'f35156',
    '35158' => 'f35158',
    '35159' => 'f35159',
    '35160' => 'f35160',
    '35164' => 'f35164',
    '35166' => 'f35166',
    '35167' => 'f35167',
    '35168' => 'f35168',
    '35174' => 'f35174',
    '35176' => 'f35176',
    '35177' => 'f35177',
    '35178' => 'f35178',
    '35182' => 'f35182',
    '35184' => 'f35184',
    '35185' => 'f35185',
    '35186' => 'f35186',
    '35190' => 'f35190',
    '35192' => 'f35192',
    '35193' => 'f35193',
    '35194' => 'f35194',
    '35200' => 'f35200',
    '35202' => 'f35202',
    '35203' => 'f35203',
    '35204' => 'f35204',
    '35208' => 'f35208',
    '35210' => 'f35210',
    '35211' => 'f35211',
    '35212' => 'f35212',
    '35216' => 'f35216',
    '35218' => 'f35218',
    '35219' => 'f35219',
    '35220' => 'f35220',
    '35844' => 'f35844',
    '35845' => 'f35845',
    '35846' => 'f35846',
    '35847' => 'f35847',
    '35854' => 'f35854',
    '35855' => 'f35855',
    '35856' => 'f35856',
    '35857' => 'f35857',
    '35864' => 'f35864',
    '35865' => 'f35865',
    '35866' => 'f35866',
    '35867' => 'f35867',
    '35874' => 'f35874',
    '35875' => 'f35875',
    '35876' => 'f35876',
    '35877' => 'f35877',
    '35884' => 'f35884',
    '35885' => 'f35885',
    '35886' => 'f35886',
    '35887' => 'f35887',
    '35894' => 'f35894',
    '35895' => 'f35895',
    '35896' => 'f35896',
    '35897' => 'f35897',
    '35907' => 'f35907',
    '35908' => 'f35908',
    '35909' => 'f35909',
    '35910' => 'f35910',
    '35917' => 'f35917',
    '35918' => 'f35918',
    '35919' => 'f35919',
    '35920' => 'f35920',
    '35927' => 'f35927',
    '35928' => 'f35928',
    '35929' => 'f35929',
    '35930' => 'f35930',
    '35937' => 'f35937',
    '35938' => 'f35938',
    '35939' => 'f35939',
    '35940' => 'f35940',
    '35947' => 'f35947',
    '35948' => 'f35948',
    '35949' => 'f35949',
    '35950' => 'f35950',
    '35957' => 'f35957',
    '35958' => 'f35958',
    '35959' => 'f35959',
    '35960' => 'f35960',
    '35970' => 'f35970',
    '35971' => 'f35971',
    '35972' => 'f35972',
    '35973' => 'f35973',
    '35980' => 'f35980',
    '35981' => 'f35981',
    '35982' => 'f35982',
    '35983' => 'f35983',
    '35990' => 'f35990',
    '35991' => 'f35991',
    '35992' => 'f35992',
    '35993' => 'f35993',
    '36000' => 'f36000',
    '36001' => 'f36001',
    '36002' => 'f36002',
    '36003' => 'f36003',
    '36010' => 'f36010',
    '36011' => 'f36011',
    '36012' => 'f36012',
    '36013' => 'f36013',
    '36020' => 'f36020',
    '36021' => 'f36021',
    '36022' => 'f36022',
    '36023' => 'f36023',
    '36030' => 'f36030',
    '36031' => 'f36031',
    '36032' => 'f36032',
    '36033' => 'f36033',
    '36043' => 'f36043',
    '36044' => 'f36044',
    '36045' => 'f36045',
    '36046' => 'f36046',
    '36053' => 'f36053',
    '36054' => 'f36054',
    '36055' => 'f36055',
    '36056' => 'f36056',
    '36063' => 'f36063',
    '36064' => 'f36064',
    '36065' => 'f36065',
    '36066' => 'f36066',
    '36073' => 'f36073',
    '36074' => 'f36074',
    '36075' => 'f36075',
    '36076' => 'f36076',
    '36083' => 'f36083',
    '36084' => 'f36084',
    '36085' => 'f36085',
    '36086' => 'f36086',
    '36096' => 'f36096',
    '36097' => 'f36097',
    '36098' => 'f36098',
    '36099' => 'f36099',
    '36106' => 'f36106',
    '36107' => 'f36107',
    '36108' => 'f36108',
    '36109' => 'f36109',
    '36116' => 'f36116',
    '36117' => 'f36117',
    '36118' => 'f36118',
    '36119' => 'f36119',
    '36129' => 'f36129',
    '36130' => 'f36130',
    '36131' => 'f36131',
    '36132' => 'f36132',
    '36139' => 'f36139',
    '36140' => 'f36140',
    '36141' => 'f36141',
    '36142' => 'f36142',
    '36149' => 'f36149',
    '36150' => 'f36150',
    '36151' => 'f36151',
    '36152' => 'f36152',
    '36161' => 'f36161',
    '36162' => 'f36162',
    '36163' => 'f36163',
    '36164' => 'f36164',
    '36171' => 'f36171',
    '36172' => 'f36172',
    '36173' => 'f36173',
    '36174' => 'f36174',
    '36181' => 'f36181',
    '36182' => 'f36182',
    '36183' => 'f36183',
    '36184' => 'f36184',
    '36191' => 'f36191',
    '36192' => 'f36192',
    '36193' => 'f36193',
    '36194' => 'f36194',
    '36203' => 'f36203',
    '36204' => 'f36204',
    '36205' => 'f36205',
    '36206' => 'f36206',
    '36213' => 'f36213',
    '36214' => 'f36214',
    '36215' => 'f36215',
    '36216' => 'f36216',
    '36223' => 'f36223',
    '36224' => 'f36224',
    '36225' => 'f36225',
    '36226' => 'f36226',
    '36233' => 'f36233',
    '36234' => 'f36234',
    '36235' => 'f36235',
    '36236' => 'f36236',
    '36243' => 'f36243',
    '36244' => 'f36244',
    '36245' => 'f36245',
    '36246' => 'f36246',
    '36253' => 'f36253',
    '36254' => 'f36254',
    '36255' => 'f36255',
    '36256' => 'f36256',
    '36263' => 'f36263',
    '36264' => 'f36264',
    '36265' => 'f36265',
    '36266' => 'f36266',
    '36273' => 'f36273',
    '36274' => 'f36274',
    '36275' => 'f36275',
    '36276' => 'f36276',
    '36285' => 'f36285',
    '36286' => 'f36286',
    '36287' => 'f36287',
    '36288' => 'f36288',
    '36295' => 'f36295',
    '36296' => 'f36296',
    '36297' => 'f36297',
    '36298' => 'f36298',
    '36305' => 'f36305',
    '36306' => 'f36306',
    '36307' => 'f36307',
    '36308' => 'f36308',
    '36315' => 'f36315',
    '36316' => 'f36316',
    '36317' => 'f36317',
    '36318' => 'f36318',
    '36325' => 'f36325',
    '36326' => 'f36326',
    '36327' => 'f36327',
    '36328' => 'f36328',
    '36337' => 'f36337',
    '36338' => 'f36338',
    '36339' => 'f36339',
    '36340' => 'f36340',
    '36347' => 'f36347',
    '36348' => 'f36348',
    '36349' => 'f36349',
    '36350' => 'f36350',
    '36360' => 'f36360',
    '36361' => 'f36361',
    '36362' => 'f36362',
    '36363' => 'f36363',
    '36370' => 'f36370',
    '36371' => 'f36371',
    '36372' => 'f36372',
    '36373' => 'f36373',
    '36380' => 'f36380',
    '36381' => 'f36381',
    '36382' => 'f36382',
    '36383' => 'f36383',
    '36390' => 'f36390',
    '36391' => 'f36391',
    '36392' => 'f36392',
    '36393' => 'f36393',
    '36403' => 'f36403',
    '36404' => 'f36404',
    '36405' => 'f36405',
    '36406' => 'f36406',
    '36413' => 'f36413',
    '36414' => 'f36414',
    '36415' => 'f36415',
    '36416' => 'f36416',
    '36423' => 'f36423',
    '36424' => 'f36424',
    '36425' => 'f36425',
    '36426' => 'f36426',
    '36433' => 'f36433',
    '36434' => 'f36434',
    '36435' => 'f36435',
    '36436' => 'f36436',
    '36446' => 'f36446',
    '36447' => 'f36447',
    '36448' => 'f36448',
    '36449' => 'f36449',
    '36456' => 'f36456',
    '36457' => 'f36457',
    '36458' => 'f36458',
    '36459' => 'f36459',
    '36466' => 'f36466',
    '36467' => 'f36467',
    '36468' => 'f36468',
    '36469' => 'f36469',
    '36479' => 'f36479',
    '36480' => 'f36480',
    '36481' => 'f36481',
    '36482' => 'f36482',
    '36489' => 'f36489',
    '36490' => 'f36490',
    '36491' => 'f36491',
    '36492' => 'f36492',
    '36499' => 'f36499',
    '36500' => 'f36500',
    '36501' => 'f36501',
    '36502' => 'f36502',
    '36509' => 'f36509',
    '36510' => 'f36510',
    '36511' => 'f36511',
    '36512' => 'f36512',
    '36519' => 'f36519',
    '36520' => 'f36520',
    '36521' => 'f36521',
    '36522' => 'f36522',
    '36532' => 'f36532',
    '36533' => 'f36533',
    '36534' => 'f36534',
    '36535' => 'f36535',
    '36542' => 'f36542',
    '36543' => 'f36543',
    '36544' => 'f36544',
    '36545' => 'f36545',
    '36552' => 'f36552',
    '36553' => 'f36553',
    '36554' => 'f36554',
    '36555' => 'f36555',
    '36562' => 'f36562',
    '36563' => 'f36563',
    '36564' => 'f36564',
    '36565' => 'f36565',
    '36575' => 'f36575',
    '36576' => 'f36576',
    '36577' => 'f36577',
    '36578' => 'f36578',
    '36585' => 'f36585',
    '36586' => 'f36586',
    '36587' => 'f36587',
    '36588' => 'f36588',
    '36595' => 'f36595',
    '36596' => 'f36596',
    '36597' => 'f36597',
    '36598' => 'f36598',
    '36605' => 'f36605',
    '36606' => 'f36606',
    '36607' => 'f36607',
    '36608' => 'f36608',
    '36619' => 'f36619',
    '36620' => 'f36620',
    '36621' => 'f36621',
    '36622' => 'f36622',
    '36629' => 'f36629',
    '36630' => 'f36630',
    '36631' => 'f36631',
    '36632' => 'f36632',
    '36639' => 'f36639',
    '36640' => 'f36640',
    '36641' => 'f36641',
    '36642' => 'f36642',
    '36649' => 'f36649',
    '36650' => 'f36650',
    '36651' => 'f36651',
    '36652' => 'f36652',
    '36663' => 'f36663',
    '36664' => 'f36664',
    '36665' => 'f36665',
    '36666' => 'f36666',
    '36673' => 'f36673',
    '36674' => 'f36674',
    '36675' => 'f36675',
    '36676' => 'f36676',
    '36683' => 'f36683',
    '36684' => 'f36684',
    '36685' => 'f36685',
    '36686' => 'f36686',
    '36693' => 'f36693',
    '36694' => 'f36694',
    '36695' => 'f36695',
    '36696' => 'f36696',
    '36706' => 'f36706',
    '36707' => 'f36707',
    '36708' => 'f36708',
    '36709' => 'f36709',
    '36716' => 'f36716',
    '36717' => 'f36717',
    '36718' => 'f36718',
    '36719' => 'f36719',
    '36726' => 'f36726',
    '36727' => 'f36727',
    '36728' => 'f36728',
    '36729' => 'f36729',
    '36736' => 'f36736',
    '36737' => 'f36737',
    '36738' => 'f36738',
    '36739' => 'f36739',
    '36746' => 'f36746',
    '36747' => 'f36747',
    '36748' => 'f36748',
    '36749' => 'f36749',
    '36759' => 'f36759',
    '36760' => 'f36760',
    '36761' => 'f36761',
    '36762' => 'f36762',
    '36769' => 'f36769',
    '36770' => 'f36770',
    '36771' => 'f36771',
    '36772' => 'f36772',
    '36779' => 'f36779',
    '36780' => 'f36780',
    '36781' => 'f36781',
    '36782' => 'f36782',
    '36789' => 'f36789',
    '36790' => 'f36790',
    '36791' => 'f36791',
    '36792' => 'f36792',
    '36802' => 'f36802',
    '36803' => 'f36803',
    '36804' => 'f36804',
    '36805' => 'f36805',
    '36812' => 'f36812',
    '36813' => 'f36813',
    '36814' => 'f36814',
    '36815' => 'f36815',
    '36822' => 'f36822',
    '36823' => 'f36823',
    '36824' => 'f36824',
    '36825' => 'f36825',
    '36832' => 'f36832',
    '36833' => 'f36833',
    '36834' => 'f36834',
    '36835' => 'f36835',
    '36845' => 'f36845',
    '36846' => 'f36846',
    '36847' => 'f36847',
    '36848' => 'f36848',
    '36855' => 'f36855',
    '36856' => 'f36856',
    '36857' => 'f36857',
    '36858' => 'f36858',
    '36865' => 'f36865',
    '36866' => 'f36866',
    '36867' => 'f36867',
    '36868' => 'f36868',
    '36875' => 'f36875',
    '36876' => 'f36876',
    '36877' => 'f36877',
    '36878' => 'f36878',
    '36887' => 'f36887',
    '36888' => 'f36888',
    '36889' => 'f36889',
    '36890' => 'f36890',
    '36897' => 'f36897',
    '36898' => 'f36898',
    '36899' => 'f36899',
    '36900' => 'f36900',
    '36907' => 'f36907',
    '36908' => 'f36908',
    '36909' => 'f36909',
    '36910' => 'f36910',
    '36917' => 'f36917',
    '36918' => 'f36918',
    '36919' => 'f36919',
    '36920' => 'f36920',
    '36927' => 'f36927',
    '36928' => 'f36928',
    '36929' => 'f36929',
    '36930' => 'f36930',
    '36937' => 'f36937',
    '36938' => 'f36938',
    '36939' => 'f36939',
    '36940' => 'f36940',
    '36947' => 'f36947',
    '36948' => 'f36948',
    '36949' => 'f36949',
    '36950' => 'f36950',
    '36957' => 'f36957',
    '36958' => 'f36958',
    '36959' => 'f36959',
    '36960' => 'f36960',
    '36969' => 'f36969',
    '36970' => 'f36970',
    '36971' => 'f36971',
    '36972' => 'f36972',
    '36979' => 'f36979',
    '36980' => 'f36980',
    '36981' => 'f36981',
    '36982' => 'f36982',
    '36989' => 'f36989',
    '36990' => 'f36990',
    '36991' => 'f36991',
    '36992' => 'f36992',
    '36999' => 'f36999',
    '37000' => 'f37000',
    '37001' => 'f37001',
    '37002' => 'f37002',
    '37011' => 'f37011',
    '37012' => 'f37012',
    '37013' => 'f37013',
    '37014' => 'f37014',
    '37021' => 'f37021',
    '37022' => 'f37022',
    '37023' => 'f37023',
    '37024' => 'f37024',
    '37031' => 'f37031',
    '37032' => 'f37032',
    '37033' => 'f37033',
    '37034' => 'f37034',
    '37041' => 'f37041',
    '37042' => 'f37042',
    '37043' => 'f37043',
    '37044' => 'f37044',
    '37051' => 'f37051',
    '37052' => 'f37052',
    '37053' => 'f37053',
    '37054' => 'f37054',
    '37061' => 'f37061',
    '37062' => 'f37062',
    '37063' => 'f37063',
    '37064' => 'f37064',
    '37071' => 'f37071',
    '37072' => 'f37072',
    '37073' => 'f37073',
    '37074' => 'f37074',
    '37081' => 'f37081',
    '37082' => 'f37082',
    '37083' => 'f37083',
    '37084' => 'f37084',
    '37200' => 'f37200',
    '37202' => 'f37202',
    '37203' => 'f37203',
    '37204' => 'f37204',
    '37208' => 'f37208',
    '37210' => 'f37210',
    '37211' => 'f37211',
    '37212' => 'f37212',
    '37216' => 'f37216',
    '37218' => 'f37218',
    '37219' => 'f37219',
    '37220' => 'f37220',
    '37226' => 'f37226',
    '37228' => 'f37228',
    '37229' => 'f37229',
    '37230' => 'f37230',
    '37236' => 'f37236',
    '37238' => 'f37238',
    '37239' => 'f37239',
    '37240' => 'f37240',
    '37246' => 'f37246',
    '37248' => 'f37248',
    '37249' => 'f37249',
    '37250' => 'f37250',
    '37255' => 'f37255',
    '37266' => 'f37266',
    '37277' => 'f37277',
    '37288' => 'f37288',
    '37879' => 'f37879',
    '37881' => 'f37881',
    '37882' => 'f37882',
    '37883' => 'f37883',
    '37887' => 'f37887',
    '37889' => 'f37889',
    '37890' => 'f37890',
    '37891' => 'f37891',
    '37895' => 'f37895',
    '37897' => 'f37897',
    '37898' => 'f37898',
    '37899' => 'f37899',
    '37903' => 'f37903',
    '37905' => 'f37905',
    '37906' => 'f37906',
    '37907' => 'f37907',
    '37911' => 'f37911',
    '37913' => 'f37913',
    '37914' => 'f37914',
    '37915' => 'f37915',
    '37919' => 'f37919',
    '37921' => 'f37921',
    '37922' => 'f37922',
    '37923' => 'f37923',
    '37929' => 'f37929',
    '37931' => 'f37931',
    '37932' => 'f37932',
    '37933' => 'f37933',
    '37937' => 'f37937',
    '37939' => 'f37939',
    '37940' => 'f37940',
    '37941' => 'f37941',
    '37945' => 'f37945',
    '37947' => 'f37947',
    '37948' => 'f37948',
    '37949' => 'f37949',
    '37953' => 'f37953',
    '37955' => 'f37955',
    '37956' => 'f37956',
    '37957' => 'f37957',
    '37963' => 'f37963',
    '37965' => 'f37965',
    '37966' => 'f37966',
    '37967' => 'f37967',
    '37971' => 'f37971',
    '37973' => 'f37973',
    '37974' => 'f37974',
    '37975' => 'f37975',
    '37979' => 'f37979',
    '37981' => 'f37981',
    '37982' => 'f37982',
    '37983' => 'f37983',
    '37987' => 'f37987',
    '37989' => 'f37989',
    '37990' => 'f37990',
    '37991' => 'f37991',
    '37995' => 'f37995',
    '37997' => 'f37997',
    '37998' => 'f37998',
    '37999' => 'f37999',
    '38003' => 'f38003',
    '38005' => 'f38005',
    '38006' => 'f38006',
    '38007' => 'f38007',
    '38014' => 'f38014',
    '38016' => 'f38016',
    '38017' => 'f38017',
    '38018' => 'f38018',
    '38022' => 'f38022',
    '38024' => 'f38024',
    '38025' => 'f38025',
    '38026' => 'f38026',
    '38030' => 'f38030',
    '38032' => 'f38032',
    '38033' => 'f38033',
    '38034' => 'f38034',
    '38040' => 'f38040',
    '38042' => 'f38042',
    '38043' => 'f38043',
    '38044' => 'f38044',
    '38048' => 'f38048',
    '38050' => 'f38050',
    '38051' => 'f38051',
    '38052' => 'f38052',
    '38056' => 'f38056',
    '38058' => 'f38058',
    '38059' => 'f38059',
    '38060' => 'f38060',
    '38067' => 'f38067',
    '38069' => 'f38069',
    '38070' => 'f38070',
    '38071' => 'f38071',
    '38075' => 'f38075',
    '38077' => 'f38077',
    '38078' => 'f38078',
    '38079' => 'f38079',
    '38083' => 'f38083',
    '38085' => 'f38085',
    '38086' => 'f38086',
    '38087' => 'f38087',
    '38094' => 'f38094',
    '38096' => 'f38096',
    '38097' => 'f38097',
    '38098' => 'f38098',
    '38104' => 'f38104',
    '38106' => 'f38106',
    '38107' => 'f38107',
    '38108' => 'f38108',
    '38114' => 'f38114',
    '38116' => 'f38116',
    '38117' => 'f38117',
    '38118' => 'f38118',
    '38122' => 'f38122',
    '38124' => 'f38124',
    '38125' => 'f38125',
    '38126' => 'f38126',
    '38130' => 'f38130',
    '38132' => 'f38132',
    '38133' => 'f38133',
    '38134' => 'f38134',
    '38138' => 'f38138',
    '38140' => 'f38140',
    '38141' => 'f38141',
    '38142' => 'f38142',
    '38146' => 'f38146',
    '38148' => 'f38148',
    '38149' => 'f38149',
    '38150' => 'f38150',
    '38157' => 'f38157',
    '38159' => 'f38159',
    '38160' => 'f38160',
    '38161' => 'f38161',
    '38165' => 'f38165',
    '38167' => 'f38167',
    '38168' => 'f38168',
    '38169' => 'f38169',
    '38173' => 'f38173',
    '38175' => 'f38175',
    '38176' => 'f38176',
    '38177' => 'f38177',
    '38181' => 'f38181',
    '38183' => 'f38183',
    '38184' => 'f38184',
    '38185' => 'f38185',
    '38191' => 'f38191',
    '38193' => 'f38193',
    '38194' => 'f38194',
    '38195' => 'f38195',
    '38199' => 'f38199',
    '38201' => 'f38201',
    '38202' => 'f38202',
    '38203' => 'f38203',
    '38207' => 'f38207',
    '38209' => 'f38209',
    '38210' => 'f38210',
    '38211' => 'f38211',
    '38218' => 'f38218',
    '38220' => 'f38220',
    '38221' => 'f38221',
    '38222' => 'f38222',
    '38226' => 'f38226',
    '38228' => 'f38228',
    '38229' => 'f38229',
    '38230' => 'f38230',
    '38234' => 'f38234',
    '38236' => 'f38236',
    '38237' => 'f38237',
    '38238' => 'f38238',
    '38242' => 'f38242',
    '38244' => 'f38244',
    '38245' => 'f38245',
    '38246' => 'f38246',
    '38250' => 'f38250',
    '38252' => 'f38252',
    '38253' => 'f38253',
    '38254' => 'f38254',
    '38258' => 'f38258',
    '38260' => 'f38260',
    '38261' => 'f38261',
    '38262' => 'f38262',
    '38268' => 'f38268',
    '38270' => 'f38270',
    '38271' => 'f38271',
    '38272' => 'f38272',
    '38276' => 'f38276',
    '38278' => 'f38278',
    '38279' => 'f38279',
    '38280' => 'f38280',
    '38287' => 'f38287',
    '38289' => 'f38289',
    '38290' => 'f38290',
    '38291' => 'f38291',
    '38506' => 'f38506',
    '38507' => 'f38507',
    '38508' => 'f38508',
    '38509' => 'f38509',
    '38516' => 'f38516',
    '38517' => 'f38517',
    '38518' => 'f38518',
    '38519' => 'f38519',
    '38526' => 'f38526',
    '38527' => 'f38527',
    '38528' => 'f38528',
    '38529' => 'f38529',
    '38536' => 'f38536',
    '38537' => 'f38537',
    '38538' => 'f38538',
    '38539' => 'f38539',
    '38546' => 'f38546',
    '38547' => 'f38547',
    '38548' => 'f38548',
    '38549' => 'f38549',
    '38556' => 'f38556',
    '38557' => 'f38557',
    '38558' => 'f38558',
    '38559' => 'f38559',
    '38568' => 'f38568',
    '38569' => 'f38569',
    '38570' => 'f38570',
    '38571' => 'f38571',
    '38578' => 'f38578',
    '38579' => 'f38579',
    '38580' => 'f38580',
    '38581' => 'f38581',
    '38588' => 'f38588',
    '38589' => 'f38589',
    '38590' => 'f38590',
    '38591' => 'f38591',
    '38598' => 'f38598',
    '38599' => 'f38599',
    '38600' => 'f38600',
    '38601' => 'f38601',
    '38608' => 'f38608',
    '38609' => 'f38609',
    '38610' => 'f38610',
    '38611' => 'f38611',
    '38618' => 'f38618',
    '38619' => 'f38619',
    '38620' => 'f38620',
    '38621' => 'f38621',
    '38630' => 'f38630',
    '38631' => 'f38631',
    '38632' => 'f38632',
    '38633' => 'f38633',
    '38640' => 'f38640',
    '38641' => 'f38641',
    '38642' => 'f38642',
    '38643' => 'f38643',
    '38650' => 'f38650',
    '38651' => 'f38651',
    '38652' => 'f38652',
    '38653' => 'f38653',
    '38660' => 'f38660',
    '38661' => 'f38661',
    '38662' => 'f38662',
    '38663' => 'f38663',
    '38670' => 'f38670',
    '38671' => 'f38671',
    '38672' => 'f38672',
    '38673' => 'f38673',
    '38680' => 'f38680',
    '38681' => 'f38681',
    '38682' => 'f38682',
    '38683' => 'f38683',
    '38690' => 'f38690',
    '38691' => 'f38691',
    '38692' => 'f38692',
    '38693' => 'f38693',
    '38700' => 'f38700',
    '38701' => 'f38701',
    '38702' => 'f38702',
    '38703' => 'f38703',
    '38710' => 'f38710',
    '38711' => 'f38711',
    '38712' => 'f38712',
    '38713' => 'f38713',
    '38722' => 'f38722',
    '38723' => 'f38723',
    '38724' => 'f38724',
    '38725' => 'f38725',
    '38732' => 'f38732',
    '38733' => 'f38733',
    '38734' => 'f38734',
    '38735' => 'f38735',
    '38742' => 'f38742',
    '38743' => 'f38743',
    '38744' => 'f38744',
    '38745' => 'f38745',
    '38752' => 'f38752',
    '38753' => 'f38753',
    '38754' => 'f38754',
    '38755' => 'f38755',
    '38762' => 'f38762',
    '38763' => 'f38763',
    '38764' => 'f38764',
    '38765' => 'f38765',
    '38774' => 'f38774',
    '38775' => 'f38775',
    '38776' => 'f38776',
    '38777' => 'f38777',
    '38784' => 'f38784',
    '38785' => 'f38785',
    '38786' => 'f38786',
    '38787' => 'f38787',
    '38794' => 'f38794',
    '38795' => 'f38795',
    '38796' => 'f38796',
    '38797' => 'f38797',
    '38804' => 'f38804',
    '38805' => 'f38805',
    '38806' => 'f38806',
    '38807' => 'f38807',
    '38814' => 'f38814',
    '38815' => 'f38815',
    '38816' => 'f38816',
    '38817' => 'f38817',
    '38824' => 'f38824',
    '38825' => 'f38825',
    '38826' => 'f38826',
    '38827' => 'f38827',
    '38834' => 'f38834',
    '38835' => 'f38835',
    '38836' => 'f38836',
    '38837' => 'f38837',
    '38844' => 'f38844',
    '38845' => 'f38845',
    '38846' => 'f38846',
    '38847' => 'f38847',
    '38856' => 'f38856',
    '38857' => 'f38857',
    '38858' => 'f38858',
    '38859' => 'f38859',
    '38866' => 'f38866',
    '38867' => 'f38867',
    '38868' => 'f38868',
    '38869' => 'f38869',
    '38876' => 'f38876',
    '38877' => 'f38877',
    '38878' => 'f38878',
    '38879' => 'f38879',
    '38888' => 'f38888',
    '38889' => 'f38889',
    '38890' => 'f38890',
    '38891' => 'f38891',
    '38898' => 'f38898',
    '38899' => 'f38899',
    '38900' => 'f38900',
    '38901' => 'f38901',
    '38908' => 'f38908',
    '38909' => 'f38909',
    '38910' => 'f38910',
    '38911' => 'f38911',
    '38918' => 'f38918',
    '38919' => 'f38919',
    '38920' => 'f38920',
    '38921' => 'f38921',
    '38928' => 'f38928',
    '38929' => 'f38929',
    '38930' => 'f38930',
    '38931' => 'f38931',
    '38938' => 'f38938',
    '38939' => 'f38939',
    '38940' => 'f38940',
    '38941' => 'f38941',
    '38948' => 'f38948',
    '38949' => 'f38949',
    '38950' => 'f38950',
    '38951' => 'f38951',
    '38958' => 'f38958',
    '38959' => 'f38959',
    '38960' => 'f38960',
    '38961' => 'f38961',
    '39841' => 'f39841',
    '39843' => 'f39843',
    '39844' => 'f39844',
    '39845' => 'f39845',
    '39852' => 'f39852',
    '39854' => 'f39854',
    '39855' => 'f39855',
    '39856' => 'f39856',
    '39860' => 'f39860',
    '39862' => 'f39862',
    '39863' => 'f39863',
    '39864' => 'f39864',
    '39869' => 'f39869',
    '39880' => 'f39880',
    '39891' => 'f39891',
    '39902' => 'f39902',
    '39913' => 'f39913',
    '40569' => 'f40569',
    '40570' => 'f40570',
    '40571' => 'f40571',
    '40572' => 'f40572',
    '40579' => 'f40579',
    '40580' => 'f40580',
    '40581' => 'f40581',
    '40582' => 'f40582',
    '40589' => 'f40589',
    '40590' => 'f40590',
    '40591' => 'f40591',
    '40592' => 'f40592',
    '40599' => 'f40599',
    '40600' => 'f40600',
    '40601' => 'f40601',
    '40602' => 'f40602',
    '40611' => 'f40611',
    '40612' => 'f40612',
    '40613' => 'f40613',
    '40614' => 'f40614',
    '40621' => 'f40621',
    '40622' => 'f40622',
    '40623' => 'f40623',
    '40624' => 'f40624',
    '40631' => 'f40631',
    '40632' => 'f40632',
    '40633' => 'f40633',
    '40634' => 'f40634',
    '40641' => 'f40641',
    '40642' => 'f40642',
    '40643' => 'f40643',
    '40644' => 'f40644',
    '40651' => 'f40651',
    '40652' => 'f40652',
    '40653' => 'f40653',
    '40654' => 'f40654',
    '40661' => 'f40661',
    '40662' => 'f40662',
    '40663' => 'f40663',
    '40664' => 'f40664',
    '40671' => 'f40671',
    '40672' => 'f40672',
    '40673' => 'f40673',
    '40674' => 'f40674',
    '40681' => 'f40681',
    '40682' => 'f40682',
    '40683' => 'f40683',
    '40684' => 'f40684',
    '40691' => 'f40691',
    '40692' => 'f40692',
    '40693' => 'f40693',
    '40694' => 'f40694',
    '40701' => 'f40701',
    '40702' => 'f40702',
    '40703' => 'f40703',
    '40704' => 'f40704',
    '42989' => 'f42989',
    '42991' => 'f42991',
    '42992' => 'f42992',
    '42993' => 'f42993',
    '77916' => 'f77916',
    '77917' => 'f77917',
    '77957' => 'f77957',
    '77958' => 'f77958',
    '77959' => 'f77959',
    '77960' => 'f77960',
    '77961' => 'f77961',
    '77962' => 'f77962',
    '77963' => 'f77963',
    '77964' => 'f77964',
    '77965' => 'f77965',
    '77966' => 'f77966',
    '77968' => 'f77968',
    '77969' => 'f77969',
    '77970' => 'f77970',
    '78025' => 'f78025',
    '78026' => 'f78026',
    '78027' => 'f78027',
    '78028' => 'f78028',
    '78029' => 'f78029',
    '78107' => 'f78107',
    '78108' => 'f78108',
    '78109' => 'f78109',
    '78110' => 'f78110',
    '78111' => 'f78111',
    '78116' => 'f78116',
    '78121' => 'f78121',
    '78122' => 'f78122',
    '78158' => 'f78158',
    '78167' => 'f78167',
    '78170' => 'f78170',
    '78171' => 'f78171',
    '78188' => 'f78188',
    '78189' => 'f78189',
    '78190' => 'f78190',
    '78191' => 'f78191',
    '78192' => 'f78192',
    '78210' => 'f78210',
    '78220' => 'f78220',
    '78243' => 'f78243',
    '78244' => 'f78244',
    '78245' => 'f78245',
    '78246' => 'f78246',
    '78247' => 'f78247',
    '78255' => 'f78255',
    '78256' => 'f78256',
    '78257' => 'f78257',
    '78258' => 'f78258',
    '78259' => 'f78259',
    '78262' => 'f78262',
    '78263' => 'f78263',
    '78503' => 'f78503',
    '78504' => 'f78504',
    '78505' => 'f78505',
    '78506' => 'f78506',
    '78589' => 'f78589',
    '78591' => 'f78591',
    '78592' => 'f78592',
    '78593' => 'f78593',
    '78594' => 'f78594',
    '78595' => 'f78595',
    '78596' => 'f78596',
    '78597' => 'f78597',
    '78598' => 'f78598',
    '78599' => 'f78599',
    '78600' => 'f78600',
    '78601' => 'f78601',
    '78602' => 'f78602',
    '78603' => 'f78603',
    '78604' => 'f78604',
    '78605' => 'f78605',
    '78606' => 'f78606',
    '78607' => 'f78607',
    '78609' => 'f78609',
    '78610' => 'f78610',
    '78625' => 'f78625',
    '78626' => 'f78626',
    '78627' => 'f78627',
    '78664' => 'f78664',
    '78666' => 'f78666',
    '78667' => 'f78667',
    '78671' => 'f78671',
    '78672' => 'f78672',
    '78673' => 'f78673',
    '78691' => 'f78691',
    '78692' => 'f78692',
    '78693' => 'f78693',
    '78694' => 'f78694',
    '78705' => 'f78705',
    '78706' => 'f78706',
    '78707' => 'f78707',
    '78708' => 'f78708',
    '78709' => 'f78709',
    '78710' => 'f78710',
    '78711' => 'f78711',
    '78712' => 'f78712',
    '78776' => 'f78776',
    '78777' => 'f78777',
    '78780' => 'f78780',
    '78787' => 'f78787',
    '78798' => 'f78798',
    '78799' => 'f78799',
    '78800' => 'f78800',
    '78813' => 'f78813',
    '78814' => 'f78814',
    '78818' => 'f78818',
    '78843' => 'f78843',
    '78848' => 'f78848',
    '78849' => 'f78849',
    '78850' => 'f78850',
    '78851' => 'f78851',
    '78860' => 'f78860',
    '78861' => 'f78861',
    '78909' => 'f78909',
    '78910' => 'f78910',
    '78916' => 'f78916',
    '78917' => 'f78917',
    '78918' => 'f78918',
    '78924' => 'f78924',
    '78930' => 'f78930',
    '78931' => 'f78931',
    '78932' => 'f78932',
    '78933' => 'f78933',
    '78934' => 'f78934',
    '78935' => 'f78935',
    '78936' => 'f78936',
    '78937' => 'f78937',
    '78938' => 'f78938',
    '78971' => 'f78971',
    '78972' => 'f78972',
    '78973' => 'f78973',
    '78994' => 'f78994',
    '78995' => 'f78995',
    '78996' => 'f78996',
    '78999' => 'f78999',
    '79000' => 'f79000',
    '79001' => 'f79001',
    '79002' => 'f79002',
    '79003' => 'f79003',
    '79004' => 'f79004',
    '79005' => 'f79005',
    '79006' => 'f79006',
    '79007' => 'f79007',
    '79008' => 'f79008',
    '79009' => 'f79009',
    '79010' => 'f79010',
    '79011' => 'f79011',
    '79012' => 'f79012',
    '79013' => 'f79013',
    '79130' => 'f79130',
    '999516' => 'f999516',
    '999517' => 'f999517',
    '999557' => 'f999557',
    '999558' => 'f999558',
    '999559' => 'f999559',
    '999560' => 'f999560',
    '999561' => 'f999561',
    '999562' => 'f999562',
    '999563' => 'f999563',
    '999564' => 'f999564',
    '999565' => 'f999565',
    '999566' => 'f999566',
    '999568' => 'f999568',
    '999569' => 'f999569',
    '999570' => 'f999570',
    '999625' => 'f999625',
    '999626' => 'f999626',
    '999627' => 'f999627',
    '999628' => 'f999628',
    '999629' => 'f999629',
    '999707' => 'f999707',
    '999708' => 'f999708',
    '999709' => 'f999709',
    '999710' => 'f999710',
    '999711' => 'f999711',
    '999716' => 'f999716',
    '999721' => 'f999721',
    '999722' => 'f999722',
    '999758' => 'f999758',
    '999767' => 'f999767',
    '999770' => 'f999770',
    '999771' => 'f999771',
    '999788' => 'f999788',
    '999789' => 'f999789',
    '999790' => 'f999790',
    '999791' => 'f999791',
    '999792' => 'f999792',
    '999810' => 'f999810',
    '999820' => 'f999820',
    '999843' => 'f999843',
    '999844' => 'f999844',
    '999845' => 'f999845',
    '999846' => 'f999846',
    '999847' => 'f999847',
    '999855' => 'f999855',
    '999856' => 'f999856',
    '999857' => 'f999857',
    '999858' => 'f999858',
    '999859' => 'f999859',
    '999862' => 'f999862',
    '999863' => 'f999863',
    '1000103' => 'f1000103',
    '1000104' => 'f1000104',
    '1000105' => 'f1000105',
    '1000106' => 'f1000106',
    '1000189' => 'f1000189',
    '1000191' => 'f1000191',
    '1000192' => 'f1000192',
    '1000193' => 'f1000193',
    '1000194' => 'f1000194',
    '1000195' => 'f1000195',
    '1000196' => 'f1000196',
    '1000197' => 'f1000197',
    '1000198' => 'f1000198',
    '1000199' => 'f1000199',
    '1000200' => 'f1000200',
    '1000201' => 'f1000201',
    '1000202' => 'f1000202',
    '1000203' => 'f1000203',
    '1000204' => 'f1000204',
    '1000205' => 'f1000205',
    '1000206' => 'f1000206',
    '1000207' => 'f1000207',
    '1000209' => 'f1000209',
    '1000210' => 'f1000210',
    '1000225' => 'f1000225',
    '1000226' => 'f1000226',
    '1000227' => 'f1000227',
    '1000264' => 'f1000264',
    '1000266' => 'f1000266',
    '1000267' => 'f1000267',
    '1000271' => 'f1000271',
    '1000272' => 'f1000272',
    '1000273' => 'f1000273',
    '1000291' => 'f1000291',
    '1000292' => 'f1000292',
    '1000293' => 'f1000293',
    '1000294' => 'f1000294',
    '1000305' => 'f1000305',
    '1000306' => 'f1000306',
    '1000307' => 'f1000307',
    '1000308' => 'f1000308',
    '1000309' => 'f1000309',
    '1000310' => 'f1000310',
    '1000311' => 'f1000311',
    '1000312' => 'f1000312',
    '1000376' => 'f1000376',
    '1000377' => 'f1000377',
    '1000380' => 'f1000380',
    '1000387' => 'f1000387',
    '1000398' => 'f1000398',
    '1000399' => 'f1000399',
    '1000400' => 'f1000400',
    '1000413' => 'f1000413',
    '1000414' => 'f1000414',
    '1000418' => 'f1000418',
    '1000443' => 'f1000443',
    '1000448' => 'f1000448',
    '1000449' => 'f1000449',
    '1000450' => 'f1000450',
    '1000451' => 'f1000451',
    '1000460' => 'f1000460',
    '1000461' => 'f1000461',
    '1000509' => 'f1000509',
    '1000510' => 'f1000510',
    '1000516' => 'f1000516',
    '1000517' => 'f1000517',
    '1000518' => 'f1000518',
    '1000524' => 'f1000524',
    '1000530' => 'f1000530',
    '1000531' => 'f1000531',
    '1000532' => 'f1000532',
    '1000533' => 'f1000533',
    '1000534' => 'f1000534',
    '1000535' => 'f1000535',
    '1000536' => 'f1000536',
    '1000537' => 'f1000537',
    '1000538' => 'f1000538',
    '1000571' => 'f1000571',
    '1000572' => 'f1000572',
    '1000573' => 'f1000573',
    '1000594' => 'f1000594',
    '1000595' => 'f1000595',
    '1000596' => 'f1000596',
    '1000599' => 'f1000599',
    '1000600' => 'f1000600',
    '1000601' => 'f1000601',
    '1000602' => 'f1000602',
    '1000603' => 'f1000603',
    '1000604' => 'f1000604',
    '1000605' => 'f1000605',
    '1000606' => 'f1000606',
    '1000607' => 'f1000607',
    '1000608' => 'f1000608',
    '1000609' => 'f1000609',
    '1000610' => 'f1000610',
    '1000611' => 'f1000611',
    '1000612' => 'f1000612',
    '1000613' => 'f1000613',
    '1000730' => 'f1000730',
    '4194305' => 'e4194305',
    '4194306' => 'e4194306',
    '4194307' => 'e4194307',
    '4194308' => 'e4194308',
    '4194309' => 'e4194309',
    '4194310' => 'e4194310',
    '4194311' => 'e4194311',
    '4194312' => 'e4194312',
    '4194313' => 'e4194313',
    '4194314' => 'e4194314',
    '4194315' => 'e4194315',
    '4194316' => 'e4194316',
    '4194317' => 'e4194317',
    '4194318' => 'e4194318',
    '4194319' => 'e4194319',
    '4194320' => 'e4194320',
    '4194321' => 'e4194321',
    '4194322' => 'e4194322',
    '4194323' => 'e4194323',
    '4194324' => 'e4194324',
    '4194325' => 'e4194325',
    '4194326' => 'e4194326',
    '4194327' => 'e4194327',
    '4194328' => 'e4194328',
    '4194329' => 'e4194329',
    '4194330' => 'e4194330',
    '4194331' => 'e4194331',
    '4194332' => 'e4194332',
    '4194333' => 'e4194333',
    '4194334' => 'e4194334',
    '4194335' => 'e4194335',
    '4194336' => 'e4194336',
    '4194337' => 'e4194337',
    '4194338' => 'e4194338',
    '4194339' => 'e4194339',
    '4194340' => 'e4194340',
    '4194341' => 'e4194341',
    '4194342' => 'e4194342',
    '4194343' => 'e4194343',
    '4194344' => 'e4194344',
    '4194345' => 'e4194345',
    '4194346' => 'e4194346',
    '4194347' => 'e4194347',
    '4194348' => 'e4194348',
    '4194349' => 'e4194349',
    '4194350' => 'e4194350',
    '4194351' => 'e4194351',
    '4194352' => 'e4194352',
    '4194353' => 'e4194353',
    '4194354' => 'e4194354',
    '4194355' => 'e4194355',
    '4194356' => 'e4194356',
    '4194357' => 'e4194357',
    '4194358' => 'e4194358',
    '4194359' => 'e4194359',
    '4194360' => 'e4194360',
    '4194361' => 'e4194361',
    '4194362' => 'e4194362',
    '4194363' => 'e4194363',
    '4194364' => 'e4194364',
    '4194365' => 'e4194365',
    '4194366' => 'e4194366',
    '4194367' => 'e4194367',
    '4194368' => 'e4194368',
    '4194369' => 'e4194369',
    '4194370' => 'e4194370',
    '4194371' => 'e4194371',
    '4194372' => 'e4194372',
    '4194373' => 'e4194373',
    '4194374' => 'e4194374',
    '4194375' => 'e4194375',
    '4194376' => 'e4194376',
    '4194377' => 'e4194377',
    '4194378' => 'e4194378',
    '4194379' => 'e4194379',
    '4194380' => 'e4194380',
    '4194381' => 'e4194381',
    '4194382' => 'e4194382',
    '4194383' => 'e4194383',
    '4194384' => 'e4194384',
    '4194385' => 'e4194385',
    '4194386' => 'e4194386',
    '4194387' => 'e4194387',
    '4194388' => 'e4194388',
    '4194389' => 'e4194389',
    '4194390' => 'e4194390',
    '4194391' => 'e4194391',
    '4194392' => 'e4194392',
    '4194393' => 'e4194393',
    '4194394' => 'e4194394',
    '4194395' => 'e4194395',
    '4194396' => 'e4194396',
    '4194397' => 'e4194397',
    '4194398' => 'e4194398',
    '4194399' => 'e4194399',
    '4194400' => 'e4194400',
    '4194401' => 'e4194401',
    '4194402' => 'e4194402',
    '4194403' => 'e4194403',
    '4194404' => 'e4194404',
    '4194405' => 'e4194405',
    '4194406' => 'e4194406',
    '4194407' => 'e4194407',
    '4194408' => 'e4194408',
    '4194409' => 'e4194409',
    '4194410' => 'e4194410',
    '4194411' => 'e4194411',
    '4194412' => 'e4194412',
    '4194413' => 'e4194413',
    '4194414' => 'e4194414',
    '4194415' => 'e4194415',
    '4194416' => 'e4194416',
    '4194417' => 'e4194417',
    '4194418' => 'e4194418',
    '4194419' => 'e4194419',
    '4194420' => 'e4194420',
    '4194421' => 'e4194421',
    '4194422' => 'e4194422',
    '4194423' => 'e4194423',
    '4194424' => 'e4194424',
    '4194425' => 'e4194425',
    '4194426' => 'e4194426',
    '4194427' => 'e4194427',
    '4194428' => 'e4194428',
    '4194429' => 'e4194429',
    '4194430' => 'e4194430',
    '4194431' => 'e4194431',
    '4194432' => 'e4194432',
    '4194433' => 'e4194433',
    '4194434' => 'e4194434',
    '4194435' => 'e4194435',
    '4194436' => 'e4194436',
    '4194437' => 'e4194437',
    '4194438' => 'e4194438',
    '4194439' => 'e4194439',
    '4194440' => 'e4194440',
    '4194441' => 'e4194441',
    '4194442' => 'e4194442',
    '4194443' => 'e4194443',
    '4194444' => 'e4194444',
    '4194445' => 'e4194445',
    '4194446' => 'e4194446',
    '4194447' => 'e4194447',
    '4194448' => 'e4194448',
    '4194449' => 'e4194449',
    '4194450' => 'e4194450',
    '4194451' => 'e4194451',
    '4194452' => 'e4194452',
    '4194453' => 'e4194453',
    '4194454' => 'e4194454',
    '4194455' => 'e4194455',
    '4194456' => 'e4194456',
    '4194457' => 'e4194457',
    '4194458' => 'e4194458',
    '4194459' => 'e4194459',
    '4194460' => 'e4194460',
    '4194461' => 'e4194461',
    '4194462' => 'e4194462',
    '4194463' => 'e4194463',
    '4194464' => 'e4194464',
    '4194465' => 'e4194465',
    '4194466' => 'e4194466',
    '4194467' => 'e4194467',
    '4194468' => 'e4194468',
    '4194469' => 'e4194469',
    '4194470' => 'e4194470',
    '4194471' => 'e4194471',
    '4194472' => 'e4194472',
    '4194473' => 'e4194473',
    '4194474' => 'e4194474',
    '4194475' => 'e4194475',
    '4194476' => 'e4194476',
    '4194477' => 'e4194477',
    '4194478' => 'e4194478',
    '4194479' => 'e4194479',
    '4194480' => 'e4194480',
    '4194481' => 'e4194481',
    '4194482' => 'e4194482',
    '4194483' => 'e4194483',
    '4194484' => 'e4194484',
    '4194485' => 'e4194485',
    '4194486' => 'e4194486',
    '4194487' => 'e4194487',
    '4194488' => 'e4194488',
    '4194489' => 'e4194489',
    '4194490' => 'e4194490',
    '4194491' => 'e4194491',
    '4194492' => 'e4194492',
    '4194493' => 'e4194493',
    '4194494' => 'e4194494',
    '4194495' => 'e4194495',
    '4194496' => 'e4194496',
    '4194497' => 'e4194497',
    '4194498' => 'e4194498',
    '4194499' => 'e4194499',
    '4194500' => 'e4194500',
    '4194501' => 'e4194501',
    '4194502' => 'e4194502',
    '4194503' => 'e4194503',
    '4194504' => 'e4194504',
    '4194505' => 'e4194505',
    '4194506' => 'e4194506',
    '4194507' => 'e4194507',
    '4194508' => 'e4194508',
    '4194509' => 'e4194509',
    '4194510' => 'e4194510',
    '4194511' => 'e4194511',
    '4194512' => 'e4194512',
    '4194513' => 'e4194513',
    '4194514' => 'e4194514',
    '4194515' => 'e4194515',
    '4194516' => 'e4194516',
    '4194517' => 'e4194517',
    '4194518' => 'e4194518',
    '4194519' => 'e4194519',
    '4194520' => 'e4194520',
    '4194521' => 'e4194521',
    '4194522' => 'e4194522',
    '4194523' => 'e4194523',
    '4194524' => 'e4194524',
    '4194525' => 'e4194525',
    '4194526' => 'e4194526',
    '4194527' => 'e4194527',
    '4194528' => 'e4194528',
    '4194529' => 'e4194529',
    '4194530' => 'e4194530',
    '4194531' => 'e4194531',
    '4194532' => 'e4194532',
    '4194533' => 'e4194533',
    '4194534' => 'e4194534',
    '4194535' => 'e4194535',
    '4194536' => 'e4194536',
    '4194537' => 'e4194537',
    '4194538' => 'e4194538',
    '4194539' => 'e4194539',
    '4194540' => 'e4194540',
    '4194541' => 'e4194541',
    '4194542' => 'e4194542',
    '4194543' => 'e4194543',
    '4194544' => 'e4194544',
    '4194545' => 'e4194545',
    '4194546' => 'e4194546',
    '4194547' => 'e4194547',
    '4194548' => 'e4194548',
    '4194549' => 'e4194549',
    '4194550' => 'e4194550',
    '4194551' => 'e4194551',
    '4194552' => 'e4194552',
    '4194553' => 'e4194553',
    '4194554' => 'e4194554',
    '4194555' => 'e4194555',
    '4194556' => 'e4194556',
    '4194557' => 'e4194557',
    '4194558' => 'e4194558',
    '4194559' => 'e4194559',
    '4194560' => 'e4194560',
    '4194561' => 'e4194561',
    '4194562' => 'e4194562',
    '4194563' => 'e4194563',
    '4194564' => 'e4194564',
    '4194565' => 'e4194565',
    '4194566' => 'e4194566',
    '4194567' => 'e4194567',
    '4194568' => 'e4194568',
    '4194569' => 'e4194569',
    '4194570' => 'e4194570',
    '4194571' => 'e4194571',
    '4194572' => 'e4194572',
    '4194573' => 'e4194573',
    '4194574' => 'e4194574',
    '4194575' => 'e4194575',
    '4194576' => 'e4194576',
    '4194577' => 'e4194577',
    '4194578' => 'e4194578',
    '4194579' => 'e4194579',
    '4194580' => 'e4194580',
    '4194581' => 'e4194581',
    '4194582' => 'e4194582',
    '4194583' => 'e4194583',
    '4194584' => 'e4194584',
    '4194585' => 'e4194585',
    '4194586' => 'e4194586',
    '4194587' => 'e4194587',
    '4194588' => 'e4194588',
    '4194589' => 'e4194589',
    '4194590' => 'e4194590',
    '4194591' => 'e4194591',
    '4194592' => 'e4194592',
    '4194593' => 'e4194593',
    '4194594' => 'e4194594',
    '4194595' => 'e4194595',
    '4194596' => 'e4194596',
    '4194597' => 'e4194597',
    '4194598' => 'e4194598',
    '4194599' => 'e4194599',
    '4194600' => 'e4194600',
    '4194601' => 'e4194601',
    '4194602' => 'e4194602',
    '4194603' => 'e4194603',
    '4194604' => 'e4194604',
    '4194605' => 'e4194605',
    '4194606' => 'e4194606',
    '4194607' => 'e4194607',
    '4194608' => 'e4194608',
    '4194609' => 'e4194609',
    '4194610' => 'e4194610',
    '4194611' => 'e4194611',
    '4194612' => 'e4194612',
    '4194613' => 'e4194613',
    '4194614' => 'e4194614',
    '4194615' => 'e4194615',
    '4194616' => 'e4194616',
    '4194617' => 'e4194617',
    '4194618' => 'e4194618',
    '4194619' => 'e4194619',
    '4194620' => 'e4194620',
    '4194621' => 'e4194621',
    '4194622' => 'e4194622',
    '4194623' => 'e4194623',
    '4194624' => 'e4194624',
    '4194625' => 'e4194625',
    '4194626' => 'e4194626',
    '4194627' => 'e4194627',
    '4194628' => 'e4194628',
    '4194629' => 'e4194629',
    '4194630' => 'e4194630',
    '4194631' => 'e4194631',
    '4194632' => 'e4194632',
    '4194633' => 'e4194633',
    '4194634' => 'e4194634',
    '4194635' => 'e4194635',
    '4194636' => 'e4194636',
    '4194637' => 'e4194637',
    '4194638' => 'e4194638',
    '4194639' => 'e4194639',
    '4194640' => 'e4194640',
    '4194641' => 'e4194641',
    '4194642' => 'e4194642',
    '4194643' => 'e4194643',
    '4194644' => 'e4194644',
    '4194645' => 'e4194645',
    '4194646' => 'e4194646',
    '4194647' => 'e4194647',
    '4194648' => 'e4194648',
    '4194649' => 'e4194649',
    '4194650' => 'e4194650',
    '4194651' => 'e4194651',
    '4194652' => 'e4194652',
    '4194653' => 'e4194653',
    '4194654' => 'e4194654',
    '4194655' => 'e4194655',
    '4194656' => 'e4194656',
    '4194657' => 'e4194657',
    '4194658' => 'e4194658',
    '4194659' => 'e4194659',
    '4194660' => 'e4194660',
    '4194661' => 'e4194661',
    '4194662' => 'e4194662',
    '4194663' => 'e4194663',
    '4194664' => 'e4194664',
    '4194665' => 'e4194665',
    '4194666' => 'e4194666',
    '4194667' => 'e4194667',
    '4194668' => 'e4194668',
    '4194669' => 'e4194669',
    '4194670' => 'e4194670',
    '4194671' => 'e4194671',
    '4194672' => 'e4194672',
    '4194673' => 'e4194673',
    '4194674' => 'e4194674',
    '4194675' => 'e4194675',
    '4194676' => 'e4194676',
    '4194677' => 'e4194677',
    '4194678' => 'e4194678',
    '4194679' => 'e4194679',
    '4194680' => 'e4194680',
    '4194681' => 'e4194681',
    '4194682' => 'e4194682',
    '4194683' => 'e4194683',
    '4194684' => 'e4194684',
    '4194685' => 'e4194685',
    '4194686' => 'e4194686',
    '4194687' => 'e4194687',
    '4194688' => 'e4194688',
    '4194689' => 'e4194689',
    '4194690' => 'e4194690',
    '4194691' => 'e4194691',
    '4194692' => 'e4194692',
    '4194693' => 'e4194693',
    '4194694' => 'e4194694',
    '4194695' => 'e4194695',
    '4194696' => 'e4194696',
    '4194697' => 'e4194697',
    '4194698' => 'e4194698',
    '4194699' => 'e4194699',
    '4194700' => 'e4194700',
    '4194701' => 'e4194701',
    '4194702' => 'e4194702',
    '4194703' => 'e4194703',
    '4194704' => 'e4194704',
    '4194705' => 'e4194705',
    '4194706' => 'e4194706',
    '4194707' => 'e4194707',
    '4194708' => 'e4194708',
    '4194709' => 'e4194709',
    '4194710' => 'e4194710',
    '4194711' => 'e4194711',
    '4194712' => 'e4194712',
    '4194713' => 'e4194713',
    '4194714' => 'e4194714',
    '4194715' => 'e4194715',
    '4194716' => 'e4194716',
    '4194717' => 'e4194717',
    '4194718' => 'e4194718',
    '4194719' => 'e4194719',
    '4194720' => 'e4194720',
    '4194721' => 'e4194721',
    '4194722' => 'e4194722',
    '4194723' => 'e4194723',
    '4194724' => 'e4194724',
    '4194725' => 'e4194725',
    '4194726' => 'e4194726',
    '4194727' => 'e4194727',
    '4194728' => 'e4194728',
    '4194729' => 'e4194729',
    '4194730' => 'e4194730',
    '4194731' => 'e4194731',
    '4194732' => 'e4194732',
    '4194733' => 'e4194733',
    '4194734' => 'e4194734',
    '4194735' => 'e4194735',
    '4194736' => 'e4194736',
    '4194737' => 'e4194737',
    '4194738' => 'e4194738',
    '4194739' => 'e4194739',
    '4194740' => 'e4194740',
    '4194741' => 'e4194741',
    '4194742' => 'e4194742',
    '4194743' => 'e4194743',
    '4194744' => 'e4194744',
    '4194745' => 'e4194745',
    '4194746' => 'e4194746',
    '4194747' => 'e4194747',
    '4194748' => 'e4194748',
    '4194749' => 'e4194749',
    '4194750' => 'e4194750',
    '4194751' => 'e4194751',
    '4194752' => 'e4194752',
    '4194753' => 'e4194753',
    '4194754' => 'e4194754',
    '4194755' => 'e4194755',
    '4194756' => 'e4194756',
    '4194757' => 'e4194757',
    '4194758' => 'e4194758',
    '4194759' => 'e4194759',
    '4194760' => 'e4194760',
    '4194761' => 'e4194761',
    '4194762' => 'e4194762',
    '4194763' => 'e4194763',
    '4194764' => 'e4194764',
    '4194765' => 'e4194765',
    '4194766' => 'e4194766',
    '4194767' => 'e4194767',
    '4194768' => 'e4194768',
    '4194769' => 'e4194769',
    '4194770' => 'e4194770',
    '4194771' => 'e4194771',
    '4194772' => 'e4194772',
    '4194773' => 'e4194773',
    '4194774' => 'e4194774',
    '4194775' => 'e4194775',
    '4194776' => 'e4194776',
    '4194777' => 'e4194777',
    '4194778' => 'e4194778',
    '4194779' => 'e4194779',
    '4194780' => 'e4194780',
    '4194781' => 'e4194781',
    '4194782' => 'e4194782',
    '4194783' => 'e4194783',
    '4194784' => 'e4194784',
    '4194785' => 'e4194785',
    '4194786' => 'e4194786',
    '4194787' => 'e4194787',
    '4194788' => 'e4194788',
    '4194789' => 'e4194789',
    '4194790' => 'e4194790',
    '4194791' => 'e4194791',
    '4194792' => 'e4194792',
    '4194793' => 'e4194793',
    '4194794' => 'e4194794',
    '4194795' => 'e4194795',
    '4194796' => 'e4194796',
    '4194797' => 'e4194797',
    '4194798' => 'e4194798',
    '4194799' => 'e4194799',
    '4194800' => 'e4194800',
    '4194801' => 'e4194801',
    '4194802' => 'e4194802',
    '4194803' => 'e4194803',
    '4194804' => 'e4194804',
    '4194805' => 'e4194805',
    '4194806' => 'e4194806',
    '4194807' => 'e4194807',
    '4194808' => 'e4194808',
    '4194809' => 'e4194809',
    '4194810' => 'e4194810',
    '4194811' => 'e4194811',
    '4194812' => 'e4194812',
    '4194813' => 'e4194813',
    '4194814' => 'e4194814',
    '4194815' => 'e4194815',
    '4194816' => 'e4194816',
    '4194817' => 'e4194817',
    '4194818' => 'e4194818',
    '4194819' => 'e4194819',
    '4194820' => 'e4194820',
    '4194821' => 'e4194821',
    '4194822' => 'e4194822',
    '4194823' => 'e4194823',
    '4194824' => 'e4194824',
    '4194825' => 'e4194825',
    '4194826' => 'e4194826',
    '4194827' => 'e4194827',
    '4194828' => 'e4194828',
    '4194829' => 'e4194829',
    '4194830' => 'e4194830',
    '4194831' => 'e4194831',
    '4194832' => 'e4194832',
    '4194833' => 'e4194833',
    '4194834' => 'e4194834',
    '4194835' => 'e4194835',
    '4194836' => 'e4194836',
    '4194837' => 'e4194837',
    '4194838' => 'e4194838',
    '4194839' => 'e4194839',
    '4194840' => 'e4194840',
    '4194841' => 'e4194841',
    '4194842' => 'e4194842',
    '4194843' => 'e4194843',
    '4194844' => 'e4194844',
    '4194845' => 'e4194845',
    '4194846' => 'e4194846',
    '4194847' => 'e4194847',
    '4194848' => 'e4194848',
    '4194849' => 'e4194849',
    '4194850' => 'e4194850',
    '4194851' => 'e4194851',
    '4194852' => 'e4194852',
    '4194853' => 'e4194853',
    '4194854' => 'e4194854',
    '4194855' => 'e4194855',
    '4194856' => 'e4194856',
    '4194857' => 'e4194857',
    '4194858' => 'e4194858',
    '4194859' => 'e4194859',
    '4194860' => 'e4194860',
    '4194861' => 'e4194861',
    '4194862' => 'e4194862',
    '4194863' => 'e4194863',
    '4194864' => 'e4194864',
    '4194865' => 'e4194865',
    '4194866' => 'e4194866',
    '4194867' => 'e4194867',
    '4194868' => 'e4194868',
    '4194869' => 'e4194869',
    '4194870' => 'e4194870',
    '4194871' => 'e4194871',
    '4194872' => 'e4194872',
    '4194873' => 'e4194873',
    '4194874' => 'e4194874',
    '4194875' => 'e4194875',
    '4194876' => 'e4194876',
    '4194877' => 'e4194877',
    '4194878' => 'e4194878',
    '4194879' => 'e4194879',
    '4194880' => 'e4194880',
    '4194881' => 'e4194881',
    '4194882' => 'e4194882',
    '4194883' => 'e4194883',
    '4194884' => 'e4194884',
    '4194885' => 'e4194885',
    '4194886' => 'e4194886',
    '4194887' => 'e4194887',
    '4194888' => 'e4194888',
    '4194889' => 'e4194889',
    '4194890' => 'e4194890',
    '4194891' => 'e4194891',
    '4194892' => 'e4194892',
    '4194893' => 'e4194893',
    '4194894' => 'e4194894',
    '4194895' => 'e4194895',
    '4194896' => 'e4194896',
    '4194897' => 'e4194897',
    '4194898' => 'e4194898',
    '4194899' => 'e4194899',
    '4194900' => 'e4194900',
    '4194901' => 'e4194901',
    '4194902' => 'e4194902',
    '4194903' => 'e4194903',
    '4194904' => 'e4194904',
    '4194905' => 'e4194905',
    '4194906' => 'e4194906',
    '4194907' => 'e4194907',
    '4194908' => 'e4194908',
    '4194909' => 'e4194909',
    '4194910' => 'e4194910',
    '4194911' => 'e4194911',
    '4194912' => 'e4194912',
    '4194913' => 'e4194913',
    '4194914' => 'e4194914',
    '4194915' => 'e4194915',
    '4194916' => 'e4194916',
    '4194917' => 'e4194917',
    '4194918' => 'e4194918',
    '4194919' => 'e4194919',
    '4194920' => 'e4194920',
    '4194921' => 'e4194921',
    '4194922' => 'e4194922',
    '4194923' => 'e4194923',
    '4194924' => 'e4194924',
    '4194925' => 'e4194925',
    '4194926' => 'e4194926',
    '4194927' => 'e4194927',
    '4194928' => 'e4194928',
    '4194929' => 'e4194929',
    '4194930' => 'e4194930',
    '4194931' => 'e4194931',
    '4194932' => 'e4194932',
    '4194933' => 'e4194933',
    '4194934' => 'e4194934',
    '4194935' => 'e4194935',
    '4194936' => 'e4194936',
    '4194937' => 'e4194937',
    '4194938' => 'e4194938',
    '4194939' => 'e4194939',
    '4194940' => 'e4194940',
    '4194941' => 'e4194941',
    '4194942' => 'e4194942',
    '4194943' => 'e4194943',
    '4194944' => 'e4194944',
    '4194945' => 'e4194945',
    '4194946' => 'e4194946',
    '4194947' => 'e4194947',
    '4194948' => 'e4194948',
    '4194949' => 'e4194949',
    '4194950' => 'e4194950',
    '4194951' => 'e4194951',
    '4194952' => 'e4194952',
    '4194953' => 'e4194953',
    '4194954' => 'e4194954',
    '4194955' => 'e4194955',
    '4194956' => 'e4194956',
    '4194957' => 'e4194957',
    '4194958' => 'e4194958',
    '4194959' => 'e4194959',
    '4194960' => 'e4194960',
    '4194961' => 'e4194961',
    '4194962' => 'e4194962',
    '4194963' => 'e4194963',
    '4194964' => 'e4194964',
    '4194965' => 'e4194965',
    '4194966' => 'e4194966',
    '4194967' => 'e4194967',
    '4194968' => 'e4194968',
    '4194969' => 'e4194969',
    '4194970' => 'e4194970',
    '4194971' => 'e4194971',
    '4194972' => 'e4194972',
    '4194973' => 'e4194973',
    '4194974' => 'e4194974',
    '4194975' => 'e4194975',
    '4194976' => 'e4194976',
    '4194977' => 'e4194977',
    '4194978' => 'e4194978',
    '4194979' => 'e4194979',
    '4194980' => 'e4194980',
    '4194981' => 'e4194981',
    '4194982' => 'e4194982',
    '4194983' => 'e4194983',
    '4194984' => 'e4194984',
    '4194985' => 'e4194985',
    '4194986' => 'e4194986',
    '4194987' => 'e4194987',
    '4194988' => 'e4194988',
    '4194989' => 'e4194989',
    '4194990' => 'e4194990',
    '4194991' => 'e4194991',
    '4194992' => 'e4194992',
    '4194993' => 'e4194993',
    '4194994' => 'e4194994',
    '4194995' => 'e4194995',
    '4194996' => 'e4194996',
    '4194997' => 'e4194997',
    '4194998' => 'e4194998',
    '4194999' => 'e4194999',
    '4195000' => 'e4195000',
    '4195001' => 'e4195001',
    '4195002' => 'e4195002',
    '4195003' => 'e4195003',
    '4195004' => 'e4195004',
    '4195005' => 'e4195005',
    '4195006' => 'e4195006',
    '4195007' => 'e4195007',
    '4195008' => 'e4195008',
    '4195009' => 'e4195009',
    '4195010' => 'e4195010',
    '4195011' => 'e4195011',
    '4195012' => 'e4195012',
    '4195013' => 'e4195013',
    '4195014' => 'e4195014',
    '4195015' => 'e4195015',
    '4195016' => 'e4195016',
    '4195017' => 'e4195017',
    '4195018' => 'e4195018',
    '4195019' => 'e4195019',
    '4195020' => 'e4195020',
    '4195021' => 'e4195021',
    '4195022' => 'e4195022',
    '4195023' => 'e4195023',
    '4195024' => 'e4195024',
    '4195025' => 'e4195025',
    '4195026' => 'e4195026',
    '4195027' => 'e4195027',
    '4195028' => 'e4195028',
    '4195029' => 'e4195029',
    '4195030' => 'e4195030',
    '4195031' => 'e4195031',
    '4195032' => 'e4195032',
    '4195033' => 'e4195033',
    '4195034' => 'e4195034',
    '4195035' => 'e4195035',
    '4195036' => 'e4195036',
    '4195037' => 'e4195037',
    '4195038' => 'e4195038',
    '4195039' => 'e4195039',
    '4195040' => 'e4195040',
    '4195041' => 'e4195041',
    '4195042' => 'e4195042',
    '4195043' => 'e4195043',
    '4195044' => 'e4195044',
    '4195045' => 'e4195045',
    '4195046' => 'e4195046',
    '4195047' => 'e4195047',
    '4195048' => 'e4195048',
    '4195049' => 'e4195049',
    '4195050' => 'e4195050',
    '4195051' => 'e4195051',
    '4195052' => 'e4195052',
    '4195053' => 'e4195053',
    '4195054' => 'e4195054',
    '4195055' => 'e4195055',
    '4195056' => 'e4195056',
    '4195057' => 'e4195057',
    '4195058' => 'e4195058',
    '4195059' => 'e4195059',
    '4195060' => 'e4195060',
    '4195061' => 'e4195061',
    '4195062' => 'e4195062',
    '4195063' => 'e4195063',
    '4195064' => 'e4195064',
    '4195065' => 'e4195065',
    '4195066' => 'e4195066',
    '4195067' => 'e4195067',
    '4195068' => 'e4195068',
    '4195069' => 'e4195069',
    '4195070' => 'e4195070',
    '4195071' => 'e4195071',
    '4195072' => 'e4195072',
    '4195073' => 'e4195073',
    '4195074' => 'e4195074',
    '4195075' => 'e4195075',
    '4195076' => 'e4195076',
    '4195077' => 'e4195077',
    '4195078' => 'e4195078',
    '4195079' => 'e4195079',
    '4195080' => 'e4195080',
    '4195081' => 'e4195081',
    '4195082' => 'e4195082',
    '4195083' => 'e4195083',
    '4195084' => 'e4195084',
    '4195085' => 'e4195085',
    '4195086' => 'e4195086',
    '4195087' => 'e4195087',
    '4195088' => 'e4195088',
    '4195089' => 'e4195089',
    '4195090' => 'e4195090',
    '4195091' => 'e4195091',
    '4195092' => 'e4195092',
    '4195093' => 'e4195093',
    '4195094' => 'e4195094',
    '4195095' => 'e4195095',
    '4195096' => 'e4195096',
    '4195097' => 'e4195097',
    '4195098' => 'e4195098',
    '4195099' => 'e4195099',
    '4195100' => 'e4195100',
    '4195101' => 'e4195101',
    '4195102' => 'e4195102',
    '4195103' => 'e4195103',
    '4195104' => 'e4195104',
    '4195105' => 'e4195105',
    '4195106' => 'e4195106',
    '4195107' => 'e4195107',
    '4195108' => 'e4195108',
    '4195109' => 'e4195109',
    '4195110' => 'e4195110',
    '4195111' => 'e4195111',
    '4195112' => 'e4195112',
    '4195113' => 'e4195113',
    '4195114' => 'e4195114',
    '4195115' => 'e4195115',
    '4195116' => 'e4195116',
    '4195117' => 'e4195117',
    '4195118' => 'e4195118',
    '4195119' => 'e4195119',
    '4195120' => 'e4195120',
    '4195121' => 'e4195121',
    '4195122' => 'e4195122',
    '4195123' => 'e4195123',
    '4195124' => 'e4195124',
    '4195125' => 'e4195125',
    '4195126' => 'e4195126',
    '4195127' => 'e4195127',
    '4195128' => 'e4195128',
    '4195129' => 'e4195129',
    '4195130' => 'e4195130',
    '4195131' => 'e4195131',
    '4195132' => 'e4195132',
    '4195133' => 'e4195133',
    '4195134' => 'e4195134',
    '4195135' => 'e4195135',
    '4195136' => 'e4195136',
    '4195137' => 'e4195137',
    '4195138' => 'e4195138',
    '4195139' => 'e4195139',
    '4195140' => 'e4195140',
    '4195141' => 'e4195141',
    '4195142' => 'e4195142',
    '4195143' => 'e4195143',
    '4195144' => 'e4195144',
    '4195145' => 'e4195145',
    '4195146' => 'e4195146',
    '4195147' => 'e4195147',
    '4195148' => 'e4195148',
    '4195149' => 'e4195149',
    '4195150' => 'e4195150',
    '4195151' => 'e4195151',
    '4195152' => 'e4195152',
    '4195153' => 'e4195153',
    '4195154' => 'e4195154',
    '4195155' => 'e4195155',
    '4195156' => 'e4195156',
    '4195157' => 'e4195157',
    '4195158' => 'e4195158',
    '4195159' => 'e4195159',
    '4195160' => 'e4195160',
    '4195161' => 'e4195161',
    '4195162' => 'e4195162',
    '4195163' => 'e4195163',
    '4195164' => 'e4195164',
    '4195165' => 'e4195165',
    '4195166' => 'e4195166',
    '4195167' => 'e4195167',
    '4195168' => 'e4195168',
    '4195169' => 'e4195169',
    '4195170' => 'e4195170',
    '4195171' => 'e4195171',
    '4195172' => 'e4195172',
    '4195173' => 'e4195173',
    '4195174' => 'e4195174',
    '4195175' => 'e4195175',
    '4195176' => 'e4195176',
    '4195177' => 'e4195177',
    '4195178' => 'e4195178',
    '4195179' => 'e4195179',
    '4195180' => 'e4195180',
    '4195181' => 'e4195181',
    '4195182' => 'e4195182',
    '4195183' => 'e4195183',
    '4195184' => 'e4195184',
    '4195185' => 'e4195185',
    '4195186' => 'e4195186',
    '4195187' => 'e4195187',
    '4195188' => 'e4195188',
    '4195189' => 'e4195189',
    '4195190' => 'e4195190',
    '4195191' => 'e4195191',
    '4195192' => 'e4195192',
    '4195193' => 'e4195193',
    '4195194' => 'e4195194',
    '4195195' => 'e4195195',
    '4195196' => 'e4195196',
    '4195197' => 'e4195197',
    '4195198' => 'e4195198',
    '4195199' => 'e4195199',
    '4195200' => 'e4195200',
    '4195201' => 'e4195201',
    '4195202' => 'e4195202',
    '4195203' => 'e4195203',
    '4195204' => 'e4195204',
    '4195205' => 'e4195205',
    '4195206' => 'e4195206',
    '4195207' => 'e4195207',
    '4195208' => 'e4195208',
    '4195209' => 'e4195209',
    '4195210' => 'e4195210',
    '4195211' => 'e4195211',
    '4195212' => 'e4195212',
    '4195213' => 'e4195213',
    '4195214' => 'e4195214',
    '4195215' => 'e4195215',
    '4195216' => 'e4195216',
    '4195217' => 'e4195217',
    '4195218' => 'e4195218',
    '4195219' => 'e4195219',
    '4195220' => 'e4195220',
    '4195221' => 'e4195221',
    '4195222' => 'e4195222',
    '4195223' => 'e4195223',
    '4195224' => 'e4195224',
    '4195225' => 'e4195225',
    '4195226' => 'e4195226',
    '4195227' => 'e4195227',
    '4195228' => 'e4195228',
    '4195229' => 'e4195229',
    '4195230' => 'e4195230',
    '4195231' => 'e4195231',
    '4195232' => 'e4195232',
    '4195233' => 'e4195233',
    '4195234' => 'e4195234',
    '4195235' => 'e4195235',
    '4195236' => 'e4195236',
    '4195237' => 'e4195237',
    '4195238' => 'e4195238',
    '4195239' => 'e4195239',
    '4195240' => 'e4195240',
    '4195241' => 'e4195241',
    '4195242' => 'e4195242',
    '4195243' => 'e4195243',
    '4195244' => 'e4195244',
    '4195245' => 'e4195245',
    '4195246' => 'e4195246',
    '4195247' => 'e4195247',
    '4195248' => 'e4195248',
    '4195249' => 'e4195249',
    '4195250' => 'e4195250',
    '4195251' => 'e4195251',
    '4195252' => 'e4195252',
    '4195253' => 'e4195253',
    '4195254' => 'e4195254',
    '4195255' => 'e4195255',
    '4195256' => 'e4195256',
    '4195257' => 'e4195257',
    '4195258' => 'e4195258',
    '4195259' => 'e4195259',
    '4195260' => 'e4195260',
    '4195261' => 'e4195261',
    '4195262' => 'e4195262',
    '4195263' => 'e4195263',
    '4195264' => 'e4195264',
    '4195265' => 'e4195265',
    '4195266' => 'e4195266',
    '4195267' => 'e4195267',
    '4195268' => 'e4195268',
    '4195269' => 'e4195269',
    '4195270' => 'e4195270',
    '4195271' => 'e4195271',
    '4195272' => 'e4195272',
    '4195273' => 'e4195273',
    '4195274' => 'e4195274',
    '4195275' => 'e4195275',
    '4195276' => 'e4195276',
    '4195277' => 'e4195277',
    '4195278' => 'e4195278',
    '4195279' => 'e4195279',
    '4195280' => 'e4195280',
    '4195281' => 'e4195281',
    '4195282' => 'e4195282',
    '4195283' => 'e4195283',
    '4195284' => 'e4195284',
    '4195285' => 'e4195285',
    '4195286' => 'e4195286',
    '4195287' => 'e4195287',
    '4195288' => 'e4195288',
    '4195289' => 'e4195289',
    '4195290' => 'e4195290',
    '4195291' => 'e4195291',
    '4195292' => 'e4195292',
    '4195293' => 'e4195293',
    '4195294' => 'e4195294',
    '4195295' => 'e4195295',
    '4195296' => 'e4195296',
    '4195297' => 'e4195297',
    '4195298' => 'e4195298',
    '4195299' => 'e4195299',
    '4195300' => 'e4195300',
    '4195301' => 'e4195301',
    '4195302' => 'e4195302',
    '4195303' => 'e4195303',
    '4195304' => 'e4195304',
    '4195305' => 'e4195305',
    '4195306' => 'e4195306',
    '4195307' => 'e4195307',
    '4195308' => 'e4195308',
    '4195309' => 'e4195309',
    '4195310' => 'e4195310',
    '4195311' => 'e4195311',
    '4195312' => 'e4195312',
    '4195313' => 'e4195313',
    '4195314' => 'e4195314',
    '4195315' => 'e4195315',
    '4195316' => 'e4195316',
    '4195317' => 'e4195317',
    '4195318' => 'e4195318',
    '4195319' => 'e4195319',
    '4195320' => 'e4195320',
    '4195321' => 'e4195321',
    '4195322' => 'e4195322',
    '4195323' => 'e4195323',
    '4195324' => 'e4195324',
    '4195325' => 'e4195325',
    '4195326' => 'e4195326',
    '4195327' => 'e4195327',
    '4195328' => 'e4195328',
    '4195329' => 'e4195329',
    '4195330' => 'e4195330',
    '4195331' => 'e4195331',
    '4195332' => 'e4195332',
    '4195333' => 'e4195333',
    '4195334' => 'e4195334',
    '4195335' => 'e4195335',
    '4195336' => 'e4195336',
    '4195337' => 'e4195337',
    '4195338' => 'e4195338',
    '4195339' => 'e4195339',
    '4195340' => 'e4195340',
    '4195341' => 'e4195341',
    '4195342' => 'e4195342',
    '4195343' => 'e4195343',
    '4195344' => 'e4195344',
    '4195345' => 'e4195345',
    '4195346' => 'e4195346',
    '4195347' => 'e4195347',
    '4195348' => 'e4195348',
    '4195349' => 'e4195349',
    '4195350' => 'e4195350',
    '4195351' => 'e4195351',
    '4195352' => 'e4195352',
    '4195353' => 'e4195353',
    '4195354' => 'e4195354',
    '4195355' => 'e4195355',
    '4195356' => 'e4195356',
    '4195357' => 'e4195357',
    '4195358' => 'e4195358',
    '4195359' => 'e4195359',
    '4195360' => 'e4195360',
    '4195361' => 'e4195361',
    '4195362' => 'e4195362',
    '4195363' => 'e4195363',
    '4195364' => 'e4195364',
    '4195365' => 'e4195365',
    '4195366' => 'e4195366',
    '4195367' => 'e4195367',
    '4195368' => 'e4195368',
    '4195369' => 'e4195369',
    '4195370' => 'e4195370',
    '4195371' => 'e4195371',
    '4195372' => 'e4195372',
    '4195373' => 'e4195373',
    '4195374' => 'e4195374',
    '4195375' => 'e4195375',
    '4195376' => 'e4195376',
    '4195377' => 'e4195377',
    '4195378' => 'e4195378',
    '4195379' => 'e4195379',
    '4195380' => 'e4195380',
    '4195381' => 'e4195381',
    '4195382' => 'e4195382',
    '4195383' => 'e4195383',
    '4195384' => 'e4195384',
    '4195385' => 'e4195385',
    '4195386' => 'e4195386',
    '4195387' => 'e4195387',
    '4195388' => 'e4195388',
    '4195389' => 'e4195389',
    '4195390' => 'e4195390',
    '4195391' => 'e4195391',
    '4195392' => 'e4195392',
    '4195393' => 'e4195393',
    '4195394' => 'e4195394',
    '4195395' => 'e4195395',
    '4195396' => 'e4195396',
    '4195397' => 'e4195397',
    '4195398' => 'e4195398',
    '4195399' => 'e4195399',
    '4195400' => 'e4195400',
    '4195401' => 'e4195401',
    '4195402' => 'e4195402',
    '4195403' => 'e4195403',
    '4195404' => 'e4195404',
    '4195405' => 'e4195405',
    '4195406' => 'e4195406',
    '4195407' => 'e4195407',
    '4195408' => 'e4195408',
    '4195409' => 'e4195409',
    '4195410' => 'e4195410',
    '4195411' => 'e4195411',
    '4195412' => 'e4195412',
    '4195413' => 'e4195413',
    '4195414' => 'e4195414',
    '4195415' => 'e4195415',
    '4195416' => 'e4195416',
    '4195417' => 'e4195417',
    '4195418' => 'e4195418',
    '4195419' => 'e4195419',
    '4195420' => 'e4195420',
    '4195421' => 'e4195421',
    '4195422' => 'e4195422',
    '4195423' => 'e4195423',
    '4195424' => 'e4195424',
    '4195425' => 'e4195425',
    '4195426' => 'e4195426',
    '4195427' => 'e4195427',
    '4195428' => 'e4195428',
    '4195429' => 'e4195429',
    '4195430' => 'e4195430',
    '4195431' => 'e4195431',
    '4195432' => 'e4195432',
    '4195433' => 'e4195433',
    '4195434' => 'e4195434',
    '4195435' => 'e4195435',
    '4195436' => 'e4195436',
    '4195437' => 'e4195437',
    '4195438' => 'e4195438',
    '4195439' => 'e4195439',
    '4195440' => 'e4195440',
    '4195441' => 'e4195441',
    '4195442' => 'e4195442',
    '4195443' => 'e4195443',
    '4195444' => 'e4195444',
    '4195445' => 'e4195445',
    '4195446' => 'e4195446',
    '4195447' => 'e4195447',
    '4195448' => 'e4195448',
    '4195449' => 'e4195449',
    '4195450' => 'e4195450',
    '4195451' => 'e4195451',
    '4195452' => 'e4195452',
    '4195453' => 'e4195453',
    '4195454' => 'e4195454',
    '4195455' => 'e4195455',
    '4195456' => 'e4195456',
    '4195457' => 'e4195457',
    '4195458' => 'e4195458',
    '4195459' => 'e4195459',
    '4195460' => 'e4195460',
    '4195461' => 'e4195461',
    '4195462' => 'e4195462',
    '4195463' => 'e4195463',
    '4195464' => 'e4195464',
    '4195465' => 'e4195465',
    '4195466' => 'e4195466',
    '4195467' => 'e4195467',
    '4195468' => 'e4195468',
    '4195469' => 'e4195469',
    '4195470' => 'e4195470',
    '4195471' => 'e4195471',
    '4195472' => 'e4195472',
    '4195473' => 'e4195473',
    '4195474' => 'e4195474',
    '4195475' => 'e4195475',
    '4195476' => 'e4195476',
    '4195477' => 'e4195477',
    '4195478' => 'e4195478',
    '4195479' => 'e4195479',
    '4195480' => 'e4195480',
    '4195481' => 'e4195481',
    '4195482' => 'e4195482',
    '4195483' => 'e4195483',
    '4195484' => 'e4195484',
    '4195485' => 'e4195485',
    '4195486' => 'e4195486',
    '4195487' => 'e4195487',
    '4195488' => 'e4195488',
    '4195489' => 'e4195489',
    '4195490' => 'e4195490',
    '4195491' => 'e4195491',
    '4195492' => 'e4195492',
    '4195493' => 'e4195493',
    '4195494' => 'e4195494',
    '4195495' => 'e4195495',
    '4195496' => 'e4195496',
    '4195497' => 'e4195497',
    '4195498' => 'e4195498',
    '4195499' => 'e4195499',
    '4195500' => 'e4195500',
    '4195501' => 'e4195501',
    '4195502' => 'e4195502',
    '4195503' => 'e4195503',
    '4195504' => 'e4195504',
    '4195505' => 'e4195505',
    '4195506' => 'e4195506',
    '4195507' => 'e4195507',
    '4195508' => 'e4195508',
    '4195509' => 'e4195509',
    '4195510' => 'e4195510',
    '4195511' => 'e4195511',
    '4195512' => 'e4195512',
    '4195513' => 'e4195513',
    '4195514' => 'e4195514',
    '4195515' => 'e4195515',
    '4195516' => 'e4195516',
    '4195517' => 'e4195517',
    '4195518' => 'e4195518',
    '4195519' => 'e4195519',
    '4195520' => 'e4195520',
    '4195521' => 'e4195521',
    '4195522' => 'e4195522',
    '4195523' => 'e4195523',
    '4195524' => 'e4195524',
    '4195525' => 'e4195525',
    '4195526' => 'e4195526',
    '4195527' => 'e4195527',
    '4195528' => 'e4195528',
    '4195529' => 'e4195529',
    '4195530' => 'e4195530',
    '4195531' => 'e4195531',
    '4195532' => 'e4195532',
    '4195533' => 'e4195533',
    '4195534' => 'e4195534',
    '4195535' => 'e4195535',
    '4195536' => 'e4195536',
    '4195537' => 'e4195537',
    '4195538' => 'e4195538',
    '4195539' => 'e4195539',
    '4195540' => 'e4195540',
    '4195541' => 'e4195541',
    '4195542' => 'e4195542',
    '4195543' => 'e4195543',
    '4195544' => 'e4195544',
    '4195545' => 'e4195545',
    '4195546' => 'e4195546',
    '4195547' => 'e4195547',
    '4195548' => 'e4195548',
    '4195549' => 'e4195549',
    '4195550' => 'e4195550',
    '4195551' => 'e4195551',
    '4195552' => 'e4195552',
    '4195553' => 'e4195553',
    '4195554' => 'e4195554',
    '4195555' => 'e4195555',
    '4195556' => 'e4195556',
    '4195557' => 'e4195557',
    '4195558' => 'e4195558',
    '4195559' => 'e4195559',
    '4195560' => 'e4195560',
    '4195561' => 'e4195561',
    '4195562' => 'e4195562',
    '4195563' => 'e4195563',
    '4195564' => 'e4195564',
    '4195565' => 'e4195565',
    '4195566' => 'e4195566',
    '4195567' => 'e4195567',
    '4195568' => 'e4195568',
    '4195569' => 'e4195569',
    '4195570' => 'e4195570',
    '4195571' => 'e4195571',
    '4195572' => 'e4195572',
    '4195573' => 'e4195573',
    '4195574' => 'e4195574',
    '4195575' => 'e4195575',
    '4195576' => 'e4195576',
    '4195577' => 'e4195577',
    '4195578' => 'e4195578',
    '4195579' => 'e4195579',
    '4195580' => 'e4195580',
    '4195581' => 'e4195581',
    '4195582' => 'e4195582',
    '4195583' => 'e4195583',
    '4195584' => 'e4195584',
    '4195585' => 'e4195585',
    '4195586' => 'e4195586',
    '4195587' => 'e4195587',
    '4195588' => 'e4195588',
    '4195589' => 'e4195589',
    '4195590' => 'e4195590',
    '4195591' => 'e4195591',
    '4195592' => 'e4195592',
    '4195593' => 'e4195593',
    '4195594' => 'e4195594',
    '4195595' => 'e4195595',
    '4195596' => 'e4195596',
    '4195597' => 'e4195597',
    '4195598' => 'e4195598',
    '4195599' => 'e4195599',
    '4195600' => 'e4195600',
    '4195601' => 'e4195601',
    '4195602' => 'e4195602',
    '4195603' => 'e4195603',
    '4195604' => 'e4195604',
    '4195605' => 'e4195605',
    '4195606' => 'e4195606',
    '4195607' => 'e4195607',
    '4195608' => 'e4195608',
    '4195609' => 'e4195609',
    '4195610' => 'e4195610',
    '4195611' => 'e4195611',
    '4195612' => 'e4195612',
    '4195613' => 'e4195613',
    '4195614' => 'e4195614',
    '4195615' => 'e4195615',
    '4195616' => 'e4195616',
    '4195617' => 'e4195617',
    '4195618' => 'e4195618',
    '4195619' => 'e4195619',
    '4195620' => 'e4195620',
    '4195621' => 'e4195621',
    '4195622' => 'e4195622',
    '4195623' => 'e4195623',
    '4195624' => 'e4195624',
    '4195625' => 'e4195625',
    '4195626' => 'e4195626',
    '4195627' => 'e4195627',
    '4195628' => 'e4195628',
    '4195629' => 'e4195629',
    '4195630' => 'e4195630',
    '4195631' => 'e4195631',
    '4195632' => 'e4195632',
    '4195633' => 'e4195633',
    '4195634' => 'e4195634',
    '4195635' => 'e4195635',
    '4195636' => 'e4195636',
    '4195637' => 'e4195637',
    '4195638' => 'e4195638',
    '4195639' => 'e4195639',
    '4195640' => 'e4195640',
    '4195641' => 'e4195641',
    '4195642' => 'e4195642',
    '4195643' => 'e4195643',
    '4195644' => 'e4195644',
    '4195645' => 'e4195645',
    '4195646' => 'e4195646',
    '4195647' => 'e4195647',
    '4195648' => 'e4195648',
    '4195649' => 'e4195649',
    '4195650' => 'e4195650',
    '4195651' => 'e4195651',
    '4195652' => 'e4195652',
    '4195653' => 'e4195653',
    '4195654' => 'e4195654',
    '4195655' => 'e4195655',
    '4195656' => 'e4195656',
    '4195657' => 'e4195657',
    '4195658' => 'e4195658',
    '4195659' => 'e4195659',
    '4195660' => 'e4195660',
    '4195661' => 'e4195661',
    '4195662' => 'e4195662',
    '4195663' => 'e4195663',
    '4195664' => 'e4195664',
    '4195665' => 'e4195665',
    '4195666' => 'e4195666',
    '4195667' => 'e4195667',
    '4195668' => 'e4195668',
    '4195669' => 'e4195669',
    '4195670' => 'e4195670',
    '4195671' => 'e4195671',
    '4195672' => 'e4195672',
    '4195673' => 'e4195673',
    '4195674' => 'e4195674',
    '4195675' => 'e4195675',
    '4195676' => 'e4195676',
    '4195677' => 'e4195677',
    '4195678' => 'e4195678',
    '4195679' => 'e4195679',
    '4195680' => 'e4195680',
    '4195681' => 'e4195681',
    '4195682' => 'e4195682',
    '4195683' => 'e4195683',
    '4195684' => 'e4195684',
    '4195685' => 'e4195685',
    '4195686' => 'e4195686',
    '4195687' => 'e4195687',
    '4195688' => 'e4195688',
    '4195689' => 'e4195689',
    '4195690' => 'e4195690',
    '4195691' => 'e4195691',
    '4195692' => 'e4195692',
    '4195693' => 'e4195693',
    '4195694' => 'e4195694',
    '4195695' => 'e4195695',
    '4195696' => 'e4195696',
    '4195697' => 'e4195697',
    '4195698' => 'e4195698',
    '4195699' => 'e4195699',
    '4195700' => 'e4195700',
    '4195701' => 'e4195701',
    '4195702' => 'e4195702',
    '4195703' => 'e4195703',
    '4195704' => 'e4195704',
    '4195705' => 'e4195705',
    '4195706' => 'e4195706',
    '4195707' => 'e4195707',
    '4195708' => 'e4195708',
    '4195709' => 'e4195709',
    '4195710' => 'e4195710',
    '4195711' => 'e4195711',
    '4195712' => 'e4195712',
    '4195713' => 'e4195713',
    '4195714' => 'e4195714',
    '4195715' => 'e4195715',
    '4195716' => 'e4195716',
    '4195717' => 'e4195717',
    '4195718' => 'e4195718',
    '4195719' => 'e4195719',
    '4195720' => 'e4195720',
    '4195721' => 'e4195721',
    '4195722' => 'e4195722',
    '4195723' => 'e4195723',
    '4195724' => 'e4195724',
    '4195725' => 'e4195725',
    '4195726' => 'e4195726',
    '4195727' => 'e4195727',
    '4195728' => 'e4195728',
    '4195729' => 'e4195729',
    '4195730' => 'e4195730',
    '4195731' => 'e4195731',
    '4195732' => 'e4195732',
    '4195733' => 'e4195733',
    '4195734' => 'e4195734',
    '4195735' => 'e4195735',
    '4195736' => 'e4195736',
    '4195737' => 'e4195737',
    '4195738' => 'e4195738',
    '4195739' => 'e4195739',
    '4195740' => 'e4195740',
    '4195741' => 'e4195741',
    '4195742' => 'e4195742',
    '4195743' => 'e4195743',
    '4195744' => 'e4195744',
    '4195745' => 'e4195745',
    '4195746' => 'e4195746',
    '4195747' => 'e4195747',
    '4195748' => 'e4195748',
    '4195749' => 'e4195749',
    '4195750' => 'e4195750',
    '4195751' => 'e4195751',
    '4195752' => 'e4195752',
    '4195753' => 'e4195753',
    '4195754' => 'e4195754',
    '4195755' => 'e4195755',
    '4195756' => 'e4195756',
    '4195757' => 'e4195757',
    '4195758' => 'e4195758',
    '4195759' => 'e4195759',
    '4195760' => 'e4195760',
    '4195761' => 'e4195761',
    '4195762' => 'e4195762',
    '4195763' => 'e4195763',
    '4195764' => 'e4195764',
    '4195765' => 'e4195765',
    '4195766' => 'e4195766',
    '4195767' => 'e4195767',
    '4195768' => 'e4195768',
    '4195769' => 'e4195769',
    '4195770' => 'e4195770',
    '4195771' => 'e4195771',
    '4195772' => 'e4195772',
    '4195773' => 'e4195773',
    '4195774' => 'e4195774',
    '4195775' => 'e4195775',
    '4195776' => 'e4195776',
    '4195777' => 'e4195777',
    '4195778' => 'e4195778',
    '4195779' => 'e4195779',
    '4195780' => 'e4195780',
    '4195781' => 'e4195781',
    '4195782' => 'e4195782',
    '4195783' => 'e4195783',
    '4195784' => 'e4195784',
    '4195785' => 'e4195785',
    '4195786' => 'e4195786',
    '4195787' => 'e4195787',
    '4195788' => 'e4195788',
    '4195789' => 'e4195789',
    '4195790' => 'e4195790',
    '4195791' => 'e4195791',
    '4195792' => 'e4195792',
    '4195793' => 'e4195793',
    '4195794' => 'e4195794',
    '4195795' => 'e4195795',
    '4195796' => 'e4195796',
    '4195797' => 'e4195797',
    '4195798' => 'e4195798',
    '4195799' => 'e4195799',
    '4195800' => 'e4195800',
    '4195801' => 'e4195801',
    '4195802' => 'e4195802',
    '4195803' => 'e4195803',
    '4195804' => 'e4195804',
    '4195805' => 'e4195805',
    '4195806' => 'e4195806',
    '4195807' => 'e4195807',
    '4195808' => 'e4195808',
    '4195809' => 'e4195809',
    '4195810' => 'e4195810',
    '4195811' => 'e4195811',
    '4195812' => 'e4195812',
    '4195813' => 'e4195813',
    '4195814' => 'e4195814',
    '4195815' => 'e4195815',
    '4195816' => 'e4195816',
    '4195817' => 'e4195817',
    '4195818' => 'e4195818',
    '4195819' => 'e4195819',
    '4195820' => 'e4195820',
    '4195821' => 'e4195821',
    '4195822' => 'e4195822',
    '4195823' => 'e4195823',
    '4195824' => 'e4195824',
    '4195825' => 'e4195825',
    '4195826' => 'e4195826',
    '4195827' => 'e4195827',
    '4195828' => 'e4195828',
    '4195829' => 'e4195829',
    '4195830' => 'e4195830',
    '4195831' => 'e4195831',
    '4195832' => 'e4195832',
    '4195833' => 'e4195833',
    '4195834' => 'e4195834',
    '4195835' => 'e4195835',
    '4195836' => 'e4195836',
    '4195837' => 'e4195837',
    '4195838' => 'e4195838',
    '4195839' => 'e4195839',
    '4195840' => 'e4195840',
    '4195841' => 'e4195841',
    '4195842' => 'e4195842',
    '4195843' => 'e4195843',
    '4195844' => 'e4195844',
    '4195845' => 'e4195845',
    '4195846' => 'e4195846',
    '4195847' => 'e4195847',
    '4195848' => 'e4195848',
    '4195849' => 'e4195849',
    '4195850' => 'e4195850',
    '4195851' => 'e4195851',
    '4195852' => 'e4195852',
    '4195853' => 'e4195853',
    '4195854' => 'e4195854',
    '4195855' => 'e4195855',
    '4195856' => 'e4195856',
    '4195857' => 'e4195857',
    '4195858' => 'e4195858',
    '4195859' => 'e4195859',
    '4195860' => 'e4195860',
    '4195861' => 'e4195861',
    '4195862' => 'e4195862',
    '4195863' => 'e4195863',
    '4195864' => 'e4195864',
    '4195865' => 'e4195865',
    '4195866' => 'e4195866',
    '4195867' => 'e4195867',
    '4195868' => 'e4195868',
    '4195869' => 'e4195869',
    '4195870' => 'e4195870',
    '4195871' => 'e4195871',
    '4195872' => 'e4195872',
    '4195873' => 'e4195873',
    '4195874' => 'e4195874',
    '4195875' => 'e4195875',
    '4195876' => 'e4195876',
    '4195877' => 'e4195877',
    '4195878' => 'e4195878',
    '4195879' => 'e4195879',
    '4195880' => 'e4195880',
    '4195881' => 'e4195881',
    '4195882' => 'e4195882',
    '4195883' => 'e4195883',
    '4195884' => 'e4195884',
    '4195885' => 'e4195885',
    '4195886' => 'e4195886',
    '4195887' => 'e4195887',
    '4195888' => 'e4195888',
    '4195889' => 'e4195889',
    '4195890' => 'e4195890',
    '4195891' => 'e4195891',
    '4195892' => 'e4195892',
    '4195893' => 'e4195893',
    '4195894' => 'e4195894',
    '4195895' => 'e4195895',
    '4195896' => 'e4195896',
    '4195897' => 'e4195897',
    '4195898' => 'e4195898',
    '4195899' => 'e4195899',
    '4195900' => 'e4195900',
    '4195901' => 'e4195901',
    '4195902' => 'e4195902',
    '4195903' => 'e4195903',
    '4195904' => 'e4195904',
    '4195905' => 'e4195905',
    '4195906' => 'e4195906',
    '4195907' => 'e4195907',
    '4195908' => 'e4195908',
    '4195909' => 'e4195909',
    '4195910' => 'e4195910',
    '4195911' => 'e4195911',
    '4195912' => 'e4195912',
    '4195913' => 'e4195913',
    '4195914' => 'e4195914',
    '4195915' => 'e4195915',
    '4195916' => 'e4195916',
    '4195917' => 'e4195917',
    '4195918' => 'e4195918',
    '4195919' => 'e4195919',
    '4195920' => 'e4195920',
    '4195921' => 'e4195921',
    '4195922' => 'e4195922',
    '4195923' => 'e4195923',
    '4195924' => 'e4195924',
    '4195925' => 'e4195925',
    '4195926' => 'e4195926',
    '4195927' => 'e4195927',
    '4195928' => 'e4195928',
    '4195929' => 'e4195929',
    '4195930' => 'e4195930',
    '4195931' => 'e4195931',
    '4195932' => 'e4195932',
    '4195933' => 'e4195933',
    '4195934' => 'e4195934',
    '4195935' => 'e4195935',
    '4195936' => 'e4195936',
    '4195937' => 'e4195937',
    '4195938' => 'e4195938',
    '4195939' => 'e4195939',
    '4195940' => 'e4195940',
    '4195941' => 'e4195941',
    '4195942' => 'e4195942',
    '4195943' => 'e4195943',
    '4195944' => 'e4195944',
    '4195945' => 'e4195945',
    '4195946' => 'e4195946',
    '4195947' => 'e4195947',
    '4195948' => 'e4195948',
    '4195949' => 'e4195949',
    '4195950' => 'e4195950',
    '4195951' => 'e4195951',
    '4195952' => 'e4195952',
    '4195953' => 'e4195953',
    '4195954' => 'e4195954',
    '4195955' => 'e4195955',
    '4195956' => 'e4195956',
    '4195957' => 'e4195957',
    '4195958' => 'e4195958',
    '4195959' => 'e4195959',
    '4195960' => 'e4195960',
    '4195961' => 'e4195961',
    '4195962' => 'e4195962',
    '4195963' => 'e4195963',
    '4195964' => 'e4195964',
    '4195965' => 'e4195965',
    '4195966' => 'e4195966',
    '4195967' => 'e4195967',
    '4195968' => 'e4195968',
    '4195969' => 'e4195969',
    '4195970' => 'e4195970',
    '4195971' => 'e4195971',
    '4195972' => 'e4195972',
    '4195973' => 'e4195973',
    '4195974' => 'e4195974',
    '4195975' => 'e4195975',
    '4195976' => 'e4195976',
    '4195977' => 'e4195977',
    '4195978' => 'e4195978',
    '4195979' => 'e4195979',
    '4195980' => 'e4195980',
    '4195981' => 'e4195981',
    '4195982' => 'e4195982',
    '4195983' => 'e4195983',
    '4195984' => 'e4195984',
    '4195985' => 'e4195985',
    '4195986' => 'e4195986',
    '4195987' => 'e4195987',
    '4195988' => 'e4195988',
    '4195989' => 'e4195989',
    '4195990' => 'e4195990',
    '4195991' => 'e4195991',
    '4195992' => 'e4195992',
    '4195993' => 'e4195993',
    '4195994' => 'e4195994',
    '4195995' => 'e4195995',
    '4195996' => 'e4195996',
    '4195997' => 'e4195997',
    '4195998' => 'e4195998',
    '4195999' => 'e4195999',
    '4196000' => 'e4196000',
    '4196001' => 'e4196001',
    '4196002' => 'e4196002',
    '4196003' => 'e4196003',
    '4196004' => 'e4196004',
    '4196005' => 'e4196005',
    '4196006' => 'e4196006',
    '4196007' => 'e4196007',
    '4196008' => 'e4196008',
    '4196009' => 'e4196009',
    '4196010' => 'e4196010',
    '4196011' => 'e4196011',
    '4196012' => 'e4196012',
    '4196013' => 'e4196013',
    '4196014' => 'e4196014',
    '4196015' => 'e4196015',
    '4196016' => 'e4196016',
    '4196017' => 'e4196017',
    '4196018' => 'e4196018',
    '4196019' => 'e4196019',
    '4196020' => 'e4196020',
    '4196021' => 'e4196021',
    '4196022' => 'e4196022',
    '4196023' => 'e4196023',
    '4196024' => 'e4196024',
    '4196025' => 'e4196025',
    '4196026' => 'e4196026',
    '4196027' => 'e4196027',
    '4196028' => 'e4196028',
    '4196029' => 'e4196029',
    '4196030' => 'e4196030',
    '4196031' => 'e4196031',
    '4196032' => 'e4196032',
    '4196033' => 'e4196033',
    '4196034' => 'e4196034',
    '4196035' => 'e4196035',
    '4196036' => 'e4196036',
    '4196037' => 'e4196037',
    '4196038' => 'e4196038',
    '4196039' => 'e4196039',
    '4196040' => 'e4196040',
    '4196041' => 'e4196041',
    '4196042' => 'e4196042',
    '4196043' => 'e4196043',
    '4196044' => 'e4196044',
    '4196045' => 'e4196045',
    '4196046' => 'e4196046',
    '4196047' => 'e4196047',
    '4196048' => 'e4196048',
    '4196049' => 'e4196049',
    '4196050' => 'e4196050',
    '4196051' => 'e4196051',
    '4196052' => 'e4196052',
    '4196053' => 'e4196053',
    '4196054' => 'e4196054',
    '4196055' => 'e4196055',
    '4196056' => 'e4196056',
    '4196057' => 'e4196057',
    '4196058' => 'e4196058',
    '4196059' => 'e4196059',
    '4196060' => 'e4196060',
    '4196061' => 'e4196061',
    '4196062' => 'e4196062',
    '4196063' => 'e4196063',
    '4196064' => 'e4196064',
    '4196065' => 'e4196065',
    '4196066' => 'e4196066',
    '4196067' => 'e4196067',
    '4196068' => 'e4196068',
    '4196069' => 'e4196069',
    '4196070' => 'e4196070',
    '4196071' => 'e4196071',
    '4196072' => 'e4196072',
    '4196073' => 'e4196073',
    '4196074' => 'e4196074',
    '4196075' => 'e4196075',
    '4522066' => 'f4522066',
    '4522408' => 'f4522408',
    '4522414' => 'f4522414',
    '4522421' => 'f4522421',
    '4522435' => 'f4522435',
    '4522448' => 'f4522448',
    '4522454' => 'f4522454',
    '4522465' => 'f4522465',
    '4522472' => 'f4522472',
    '4522474' => 'f4522474',
    '4522480' => 'f4522480',
    '4522482' => 'f4522482',
    '4522500' => 'f4522500',
    '4522502' => 'f4522502',
    '4522519' => 'f4522519',
    '4523218' => 'f4523218',
    '4523256' => 'f4523256',
    '4523262' => 'f4523262',
    '4523300' => 'f4523300',
    '4523311' => 'f4523311',
    '4523313' => 'f4523313',
    '4523349' => 'f4523349',
    '4523352' => 'f4523352',
    '4524766' => 'f4524766',
    '4524769' => 'f4524769',
    '4524774' => 'f4524774',
    '4524776' => 'f4524776',
    '4524780' => 'f4524780',
    '4524782' => 'f4524782',
    '4524789' => 'f4524789',
    '4524796' => 'f4524796',
    '4524799' => 'f4524799',
    '4524836' => 'f4524836',
    '4524852' => 'f4524852',
    '4524855' => 'f4524855',
    '4524857' => 'f4524857',
    '4524859' => 'f4524859',
    '4524861' => 'f4524861',
    '4524863' => 'f4524863',
    '4524884' => 'f4524884',
    '4524886' => 'f4524886',
    '4524888' => 'f4524888',
    '4524890' => 'f4524890',
    '4524892' => 'f4524892',
    '4524896' => 'f4524896',
    '4524898' => 'f4524898',
    '4524902' => 'f4524902',
    '4524905' => 'f4524905',
    '4524916' => 'f4524916',
    '4524925' => 'f4524925',
    '4526538' => 'f4526538',
    '4526545' => 'f4526545',
    '4526547' => 'f4526547',
    '4526549' => 'f4526549',
    '4526551' => 'f4526551',
    '4526553' => 'f4526553',
    '4526561' => 'f4526561',
    '4526563' => 'f4526563',
    '4526566' => 'f4526566',
    '4526568' => 'f4526568',
    '4526570' => 'f4526570',
    '4526572' => 'f4526572',
    '4526574' => 'f4526574',
    '4526576' => 'f4526576',
    '4526578' => 'f4526578',
    '4526580' => 'f4526580',
    '4526584' => 'f4526584',
    '4526587' => 'f4526587',
    '4526605' => 'f4526605',
    '4526646' => 'f4526646',
    '4526653' => 'f4526653',
    '4526657' => 'f4526657',
    '4526662' => 'f4526662',
    '4528969' => 'f4528969',
    '4529292' => 'f4529292',
    '4529373' => 'f4529373',
    '4529375' => 'f4529375',
    '4529380' => 'f4529380',
    '4529401' => 'f4529401',
    '4529415' => 'f4529415',
    '4529458' => 'f4529458',
    '4529464' => 'f4529464',
    '4529597' => 'f4529597',
  },
  'CfprApFlowctrlPriorityPause' => {
    '0' => 'auto',
    '1' => 'on',
  },
  'CfprApPowerMemberState' => {
    '0' => 'uninitialized',
    '1' => 'capOk',
    '2' => 'fwMismatch',
    '3' => 'psuInsufficient',
    '4' => 'psuRedundancyFailed',
    '5' => 'capInsufficient',
  },
  'CfprApEtherSwitchIntFIoType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeBladeFsmCurrentFsm' => {
    '0' => 'nop',
    '186' => 'diag',
    '208' => 'swConnUpd',
    '213' => 'serviceInfraDeploy',
    '216' => 'serviceInfraWithdraw',
  },
  'CfprApDcxState' => {
    '0' => 'unknown',
    '1' => 'present',
    '2' => 'creating',
    '3' => 'modifying',
    '4' => 'destroying',
    '5' => 'createPend',
    '6' => 'modifyPend',
    '7' => 'destroyPend',
  },
  'CfprApFabricEthLanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApOsInitState' => {
    '0' => 'undefined',
    '1' => 'inProgress',
    '2' => 'complete',
    '3' => 'retry',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CfprApFabricEthLanFlowMonCollectorTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwLanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApStorageLocalDiskConfigFlexFlashState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApBiosVfConsoleRedirectionVpConsoleRedirection' => {
    '0' => 'platformRecommended',
    '103' => 'disabled',
    '104' => 'enabled',
    '105' => 'serialPortA',
    '106' => 'serialPortB',
    '107' => 'com0',
  },
  'CfprApBiosVfOptionROMEnableVpState' => {
    '0' => 'platformRecommended',
    '166' => 'disabled',
    '167' => 'enabled',
    '168' => 'uefiOnly',
    '169' => 'legacyOnly',
  },
  'CfprApSwExtUtilityFsmCurrentFsm' => {
    '0' => 'nop',
    '114' => 'confPortBreakout',
  },
  'CfprApLicenseState' => {
    '0' => 'unknown',
    '1' => 'licenseOk',
    '2' => 'licenseInsufficient',
    '3' => 'licenseGraceperiod',
    '4' => 'licenseExpired',
    '5' => 'notApplicable',
  },
  'CfprApStorageTechnology' => {
    '0' => 'unspecified',
    '1' => 'hdd',
    '2' => 'ssd',
  },
  'CfprApIdentMetaSystemFsmTaskItem' => {
    '0' => 'nop',
    '74' => 'sync',
    '77' => 'ucscUnivSync',
  },
  'CfprApStatsCollectionPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '407' => 'updateEp',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpPCIeSlotMLOMOptionROM' => {
    '0' => 'platformRecommended',
    '216' => 'disabled',
    '217' => 'enabled',
    '218' => 'uefiOnly',
    '219' => 'legacyOnly',
  },
  'CfprApAaaUserEpFsmCurrentFsm' => {
    '0' => 'nop',
    '355' => 'updateUserEp',
  },
  'CfprApComputeMbPowerStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'consumedPower',
      '1' => 'consumedPowerAvg',
      '2' => 'consumedPowerMax',
      '3' => 'consumedPowerMin',
      '4' => 'inputCurrent',
      '5' => 'inputCurrentAvg',
      '6' => 'inputCurrentMax',
      '7' => 'inputCurrentMin',
      '8' => 'inputVoltage',
      '9' => 'inputVoltageAvg',
      '10' => 'inputVoltageMax',
      '11' => 'inputVoltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPkiModulus' => {
    '0' => 'modinvalid',
    '1536' => 'mod1536',
    '2048' => 'mod2048',
    '2560' => 'mod2560',
    '3072' => 'mod3072',
    '3584' => 'mod3584',
    '4096' => 'mod4096',
  },
  'CfprApEquipmentConnectionStatus' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'a',
      '1' => 'b',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageFcZoningType' => {
    '0' => 'none',
    '1' => 'sist',
    '2' => 'simt',
  },
  'CfprApTopInfoPolicyState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApSdAppInstanceFsmStageName' => {
    '0' => 'nop',
    '250' => 'installApplicationBegin',
    '251' => 'installApplicationSendCommand',
    '252' => 'installApplicationWaitStage',
    '253' => 'installApplicationUpdateAppInstance',
    '254' => 'startApplicationBegin',
    '255' => 'startApplicationSendCommand',
    '256' => 'startApplicationWaitStage',
    '257' => 'startApplicationUpdateAppInstance',
    '263' => 'upgradeApplicationBegin',
    '264' => 'upgradeApplicationSendCommand',
    '265' => 'upgradeApplicationWaitStage',
    '266' => 'upgradeApplicationUpdateAppInstance',
    '267' => 'stopApplicationBegin',
    '268' => 'stopApplicationReleaseAppLicense',
    '269' => 'stopApplicationSendCommand',
    '270' => 'stopApplicationWaitStage',
    '271' => 'stopApplicationUpdateAppInstance',
    '272' => 'uninstallApplicationBegin',
    '273' => 'uninstallApplicationReleaseAppLicense',
    '274' => 'uninstallApplicationSendCommand',
    '275' => 'uninstallApplicationWaitStage',
    '278' => 'bundleDataPortsBegin',
    '279' => 'bundleDataPortsConfigureLinks',
    '280' => 'bundleDataPortsWaitForConfigCompletion',
    '281' => 'bundleDataPortsUpdateBundleStatus',
    '282' => 'bundleDataPortsSendBundleStatus',
    '740' => 'bundleDataPortsFail',
    '741' => 'bundleDataPortsSuccess',
    '742' => 'installApplicationFail',
    '743' => 'installApplicationSuccess',
    '744' => 'startApplicationFail',
    '745' => 'startApplicationSuccess',
    '746' => 'stopApplicationFail',
    '747' => 'stopApplicationSuccess',
    '748' => 'uninstallApplicationFail',
    '749' => 'uninstallApplicationSuccess',
    '750' => 'upgradeApplicationFail',
    '751' => 'upgradeApplicationSuccess',
  },
  'CfprApMemoryAdminState' => {
    '1' => 'policy',
    '2' => 'resetErrors',
  },
  'CfprApBiosVfInterleaveConfigurationVpMemoryInterleaving' => {
    '0' => 'platformRecommended',
    '3' => 'numa1WayNodeInterleave',
    '4' => 'n2WayNodeInterleave',
    '5' => 'n4WayNodeInterleave',
    '6' => 'n8WayInterleavingInterSocket',
  },
  'CfprApMemoryArrayEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inputCurrent',
      '1' => 'inputCurrentAvg',
      '2' => 'inputCurrentMax',
      '3' => 'inputCurrentMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugBackupBehaviorInterval' => {
    '0' => 'never',
    '3600' => 'n1hour',
    '7200' => 'n2hours',
    '14400' => 'n4hours',
    '28800' => 'n8hours',
    '86400' => 'n24hours',
    '604800' => 'n1week',
    '2592000' => 'n1month',
  },
  'CfprApIppoolManagementMode' => {
    '0' => 'internal',
    '1' => 'external',
  },
  'CfprApFabricEthEstcPortMode' => {
    '1' => 'trunk',
    '2' => 'access',
  },
  'CfprApStorageEtherIfVlanType' => {
    '0' => 'regular',
    '1' => 'default',
    '2' => 'native',
  },
  'CfprApMemoryIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'uncorrectableEccError',
      '1' => 'correctableEccError',
      '2' => 'addressParityError',
      '3' => 'memoryMismatchError',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricMemberStatus' => {
    '0' => 'up',
    '1' => 'down',
  },
  'CfprApNetworkPhysEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApVnicConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'pinningVlanMismatch',
      '1' => 'vnicVlanAssignmentError',
      '2' => 'missingPrimaryVlan',
      '3' => 'pinnedTargetMisconfig',
      '4' => 'unresolvedVlanName',
      '5' => 'inaccessibleVlan',
      '6' => 'unresolvedVsanName',
      '7' => 'unresolvedRemoteVlanName',
      '8' => 'unresolvedRemoteVsanName',
      '9' => 'adaptorFcoeCapability',
      '10' => 'adaptorProtectedEthCapability',
      '11' => 'adaptorRequirement',
      '12' => 'connectionPlacement',
      '13' => 'dynamicVfVnic',
      '14' => 'fcoeCapacity',
      '15' => 'insufficientVhbaCapacity',
      '16' => 'insufficientVnicCapacity',
      '17' => 'invalidWwn',
      '18' => 'macDerivationVirtualizedPort',
      '19' => 'vfcVnicPvlanConflict',
      '20' => 'vifResourcesOverprovisioned',
      '21' => 'vnicNotHaReady',
      '22' => 'vnicVconProvisioningChange',
      '23' => 'wwpnAssignment',
      '24' => 'wwpnDerivationVirtualizedPort',
      '25' => 'unableToUpdateUcsm',
      '26' => 'unassociatedVlan',
      '27' => 'serviceProfileVirtualizationConflict',
      '28' => 'vnicVirtualizationConflict',
      '29' => 'virtualizationNotSupported',
      '30' => 'ungroupedDomain',
      '31' => 'missingIpv4InbandMgmtAddr',
      '32' => 'missingIpv6InbandMgmtAddr',
      '33' => 'missingIpv4Addr',
      '34' => 'vnicVirtualizationNetflowConflict',
      '35' => 'softPinningVlanMismatch',
      '36' => 'unsupportedRoceVmq',
      '37' => 'unsupportedRoceNetflow',
      '38' => 'unsupportedRoce',
      '39' => 'unsupportedVxlan',
      '40' => 'unsupportedNvgre',
      '41' => 'unsupportedNvgreDynamicVnic',
      '42' => 'unsupportedNvgreUsnic',
      '43' => 'unsupportedVxlanDynamicVnic',
      '44' => 'unsupportedVxlanUsnic',
      '45' => 'unsupportedNvgreVmq',
      '46' => 'unsupportedVxlanVmq',
      '47' => 'unsupportedVxlanNetflow',
      '48' => 'unsupportedNvgreNetflow',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorMenloStatsIndex' => {
    '0' => 'unknown',
    '1' => 'n0',
    '2' => 'n1',
    '3' => 'n0A',
    '4' => 'n0B',
    '5' => 'n1A',
    '6' => 'n1B',
  },
  'CfprApCommFilePathProtocol' => {
    '0' => 'none',
    '1' => 'workspace',
    '2' => 'volatile',
    '3' => 'ftp',
    '4' => 'tftp',
    '5' => 'scp',
    '6' => 'sftp',
    '7' => 'usbdrive',
    '8' => 'usbA',
    '9' => 'usbB',
  },
  'CfprApFabricSspEthMonAppendFlag' => {
    '1' => 'append',
    '2' => 'overwrite',
  },
  'CfprApEquipmentAdminPowerState' => {
    '1' => 'policy',
    '2' => 'cycleImmediate',
    '3' => 'cycleWait',
  },
  'CfprApProcessorErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'mirroringInterSockErrors',
      '1' => 'mirroringIntraSockErrors',
      '2' => 'smiLinkCorrErrors',
      '3' => 'smiLinkUncorrErrors',
      '4' => 'sparingErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentFexPowerSummaryThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'modulePower',
      '1' => 'modulePowerAvg',
      '2' => 'modulePowerMax',
      '3' => 'modulePowerMin',
      '4' => 'availablePower',
      '5' => 'availablePowerAvg',
      '6' => 'availablePowerMax',
      '7' => 'availablePowerMin',
      '8' => 'reservedPower',
      '9' => 'reservedPowerAvg',
      '10' => 'reservedPowerMax',
      '11' => 'reservedPowerMin',
      '12' => 'totalPower',
      '13' => 'totalPowerAvg',
      '14' => 'totalPowerMax',
      '15' => 'totalPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApObserveObservedFsmTaskItem' => {
    '0' => 'nop',
    '239' => 'resolvePolicyFsm',
    '241' => 'resolveResourceFsm',
    '243' => 'resolveVMFsm',
    '245' => 'resolveControllerFsm',
  },
  'CfprApSolAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApStatsThr64DefinitionPropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CfprApNetworkInventoryStatus' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'switchFru',
      '1' => 'vlanPortCount',
      '2' => 'cardInventory',
      '3' => 'ethPortInventory',
      '4' => 'fcPortInventory',
      '5' => 'mgmtPortInventory',
      '6' => 'ethPcInventory',
      '7' => 'fcPcInventory',
      '8' => 'switchInventory',
      '9' => 'xcvrInventory',
      '10' => 'remoteEthPortInventory',
      '11' => 'vlanCompGrpInventory',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfProcessorC7ReportVpProcessorC7Report' => {
    '0' => 'platformRecommended',
    '147' => 'disabled',
    '148' => 'enabled',
  },
  'CfprApVmComputeEpClInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CfprApRmetaModType' => {
    '0' => 'readOnly',
    '1' => 'readWrite',
    '2' => 'readCreate',
  },
  'CfprApSmAppAggregatorType' => {
    '0' => 'unknown',
    '1' => 'none',
    '2' => 'partial',
    '3' => 'full',
    '4' => 'serviceStandard',
  },
  'CfprApBiosVfProcessorC1EVpProcessorC1E' => {
    '0' => 'platformRecommended',
    '149' => 'disabled',
    '150' => 'enabled',
  },
  'CfprApPolicyIdResolvePolicyType' => {
    '0' => 'noDuplicateCheck',
    '1' => 'looseDuplicateCheck',
    '2' => 'strictDuplicateCheck',
  },
  'CfprApDiagStatus' => {
    '0' => 'complete',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'notRun',
    '4' => 'cancelled',
    '5' => 'scheduled',
  },
  'CfprApEquipmentChassisConfigState' => {
    '0' => 'unInitialized',
    '1' => 'unAcknowledged',
    '2' => 'unsupportedConnectivity',
    '3' => 'ok',
    '4' => 'removing',
    '6' => 'ackInProgress',
    '7' => 'evaluation',
    '8' => 'acknowledged',
    '9' => 'autoAck',
  },
  'CfprApFabricSwSubGroupConfigState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEquipmentCommStatus' => {
    '0' => 'unknown',
    '1' => 'connected',
    '2' => 'disconnected',
  },
  'CfprApHostimgComposition' => {
    '0' => 'complete',
    '1' => 'componentized',
  },
  'CfprApBiosVfMaxVariableMTRRSettingVpProcessorMtrr' => {
    '0' => 'platformRecommended',
    '285' => 'autoMax',
    '286' => 'n8',
  },
  'CfprApFabricFcSanUplinkTrunking' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFabricEthLanEpSpeedCap' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'auto',
      '1' => 'n1g',
      '2' => 'n10g',
      '3' => 'n20g',
      '4' => 'n40g',
      '7' => 'n100m',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorCapDefType' => {
    '1' => 'virtualizedEthIf',
    '2' => 'virtualizedFcIf',
    '3' => 'virtualizedScsiIf',
    '4' => 'nonVirtualizedEthIf',
    '5' => 'nonVirtualizedFcIf',
    '6' => 'fcoe',
    '7' => 'protectedEthIf',
    '8' => 'protectedFcIf',
    '9' => 'protectedFcoe',
    '10' => 'pathEncapVirtual',
    '11' => 'pathEncapConsolidated',
    '12' => 'uplinkAggregation',
    '13' => 'virtualizedEthSriov',
    '14' => 'virtualizedFcSriov',
    '15' => 'virtualizedEthSriovUsnic',
    '16' => 'virtualizedEthVmq',
    '17' => 'ethFlowMonitoringNetflow',
    '18' => 'ethRoce',
    '19' => 'ethVxlan',
    '20' => 'ethNvgre',
  },
  'CfprApCapabilityMgmtExtensionFsmCurrentFsm' => {
    '0' => 'nop',
    '429' => 'activateMgmtExt',
  },
  'CfprApLsbootSanImageType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApVnicSanConnTemplTarget' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'vm',
      '1' => 'adaptor',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFcMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareImageDeleted' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'a',
      '1' => 'b',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIdentIdentRequestFsmTaskItem' => {
    '0' => 'nop',
    '72' => 'updateIdent',
  },
  'CfprApFabricAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApLicenseFeatureType' => {
    '0' => 'counted',
    '1' => 'boolean',
  },
  'CfprApEquipmentLocatorLedFsmStageName' => {
    '0' => 'nop',
    '231' => 'setFeLocatorLedBegin',
    '232' => 'setFeLocatorLedExecute',
    '233' => 'setFiLocatorLedBegin',
    '234' => 'setFiLocatorLedExecute',
    '586' => 'setFeLocatorLedFail',
    '587' => 'setFeLocatorLedSuccess',
    '588' => 'setFiLocatorLedFail',
    '589' => 'setFiLocatorLedSuccess',
  },
  'CfprApFabricVsanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApFabricVnetEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApFabricVnetEpSyncEpFsmStageName' => {
    '0' => 'nop',
    '447' => 'pushVnetEpDeletionBegin',
    '448' => 'pushVnetEpDeletionSync',
    '610' => 'pushVnetEpDeletionFail',
    '611' => 'pushVnetEpDeletionSuccess',
  },
  'CfprApBiosVfSriovConfigVpSriov' => {
    '0' => 'platformRecommended',
    '92' => 'disabled',
    '93' => 'enabled',
  },
  'CfprApStorageOperState' => {
    '0' => 'ok',
    '1' => 'misconfigured',
  },
  'CfprApFcpoolInitiatorEpPurpose' => {
    '0' => 'portWwn',
    '1' => 'nodeWwn',
  },
  'CfprApVnicTemplateType' => {
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CfprApOsBootingUpType' => {
    '0' => 'outOfService',
    '1' => 'bootingUp',
    '2' => 'inService',
    '3' => 'failure',
  },
  'CfprApFabricComputeEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot3State' => {
    '0' => 'platformRecommended',
    '182' => 'disabled',
    '183' => 'enabled',
    '184' => 'uefiOnly',
    '185' => 'legacyOnly',
  },
  'CfprApAdaptorEthPortBySizeLargeStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'greaterThanOrEqualTo9216Delta',
      '1' => 'greaterThanOrEqualTo9216DeltaAvg',
      '2' => 'greaterThanOrEqualTo9216DeltaMax',
      '3' => 'greaterThanOrEqualTo9216DeltaMin',
      '4' => 'lessThan2048Delta',
      '5' => 'lessThan2048DeltaAvg',
      '6' => 'lessThan2048DeltaMax',
      '7' => 'lessThan2048DeltaMin',
      '8' => 'lessThan4096Delta',
      '9' => 'lessThan4096DeltaAvg',
      '10' => 'lessThan4096DeltaMax',
      '11' => 'lessThan4096DeltaMin',
      '12' => 'lessThan8192Delta',
      '13' => 'lessThan8192DeltaAvg',
      '14' => 'lessThan8192DeltaMax',
      '15' => 'lessThan8192DeltaMin',
      '16' => 'lessThan9216Delta',
      '17' => 'lessThan9216DeltaAvg',
      '18' => 'lessThan9216DeltaMax',
      '19' => 'lessThan9216DeltaMin',
      '20' => 'lessThanOrEqualTo1518Delta',
      '21' => 'lessThanOrEqualTo1518DeltaAvg',
      '22' => 'lessThanOrEqualTo1518DeltaMax',
      '23' => 'lessThanOrEqualTo1518DeltaMin',
      '24' => 'noBreakdownGreaterThan1518Delta',
      '25' => 'noBreakdownGreaterThan1518DeltaAvg',
      '26' => 'noBreakdownGreaterThan1518DeltaMax',
      '27' => 'noBreakdownGreaterThan1518DeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricNetflowMonSessionAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEquipmentChassisFsmStageName' => {
    '0' => 'nop',
    '225' => 'removeChassisBegin',
    '226' => 'removeChassisDecomission',
    '227' => 'removeChassisDisableEndPoint',
    '228' => 'removeChassisUnIdentifyLocal',
    '229' => 'removeChassisUnIdentifyPeer',
    '230' => 'removeChassisWait',
    '578' => 'removeChassisFail',
    '579' => 'removeChassisSuccess',
  },
  'CfprApEquipmentChassisStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inletTemp1',
      '8' => 'inputPower',
      '9' => 'inputPowerAvg',
      '10' => 'inputPowerMax',
      '11' => 'inputPowerMin',
      '12' => 'outletTemp1',
      '13' => 'outletTemp1Avg',
      '14' => 'outletTemp1Max',
      '15' => 'outletTemp1Min',
      '16' => 'outletTemp2',
      '17' => 'outletTemp2Avg',
      '18' => 'outletTemp2Max',
      '19' => 'outletTemp2Min',
      '20' => 'outputPower',
      '21' => 'outputPowerAvg',
      '22' => 'outputPowerMax',
      '23' => 'outputPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputePsuControlRedundancy' => {
    '0' => 'unknown',
    '1' => 'nonRedundant',
    '2' => 'nPlus1',
    '3' => 'grid',
  },
  'CfprApEtherServerIntFIoIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApLicenseFileState' => {
    '0' => 'unknown',
    '1' => 'installPending',
    '2' => 'installing',
    '3' => 'stale',
    '4' => 'installed',
    '5' => 'installFailed',
    '6' => 'deletePending',
    '7' => 'deleting',
    '8' => 'deleted',
    '9' => 'deleteFailed',
    '10' => 'validated',
  },
  'CfprApMgmtBackupIssue' => {
    '0' => 'none',
    '1' => 'outdated',
  },
  'CfprApStorageSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '325' => 'sync',
  },
  'CfprApQosclassEthBEDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CfprApTrigAckPrevOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CfprApEtherSwitchIntFIoPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareImageFsmStageName' => {
    '0' => 'nop',
    '11' => 'deleteBegin',
    '12' => 'deleteLocal',
    '13' => 'deleteRemote',
    '616' => 'deleteFail',
    '617' => 'deleteSuccess',
  },
  'CfprApQosclassDefinitionFsmStageName' => {
    '0' => 'nop',
    '390' => 'configGlobalQoSBegin',
    '391' => 'configGlobalQoSSetLocal',
    '392' => 'configGlobalQoSSetPeer',
    '736' => 'configGlobalQoSFail',
    '737' => 'configGlobalQoSSuccess',
  },
  'CfprApSysdebugEpLogBackupAction' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'logFull',
      '1' => 'onClear',
      '2' => 'timer',
      '3' => 'onAssocChange',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeAdminLinkAggregation' => {
    '0' => 'none',
    '1' => 'portChannel',
    '2' => 'global',
  },
  'CfprApAdaptorServiceState' => {
    '0' => 'outOfService',
    '1' => 'inService',
  },
  'CfprApFirmwareImageError' => {
    '0' => 'none',
    '1' => 'checksumFailure',
    '2' => 'filesystemError',
    '3' => 'mgmtConnectError',
    '4' => 'bootConfMissing',
    '5' => 'crcFailure',
    '6' => 'unknownError',
    '7' => 'rebuilding',
  },
  'CfprApSdExternalLduLinkFsmCurrentFsm' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatus',
  },
  'CfprApFabricLanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApSwCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApAdaptorMenloEthStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropOverrunDelta',
      '1' => 'dropOverrunDeltaAvg',
      '2' => 'dropOverrunDeltaMax',
      '3' => 'dropOverrunDeltaMin',
      '4' => 'dropRuntDelta',
      '5' => 'dropRuntDeltaAvg',
      '6' => 'dropRuntDeltaMax',
      '7' => 'dropRuntDeltaMin',
      '8' => 'truncateOverrunDelta',
      '9' => 'truncateOverrunDeltaAvg',
      '10' => 'truncateOverrunDeltaMax',
      '11' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMemoryErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'addressParityErrors',
      '1' => 'eccMultibitErrors',
      '2' => 'eccSinglebitErrors',
      '3' => 'mismatchErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApFsmLifecycle' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CfprApStatsCollectionPolicyFsmStageName' => {
    '0' => 'nop',
    '407' => 'updateEpBegin',
    '408' => 'updateEpSetEpA',
    '409' => 'updateEpSetEpB',
    '782' => 'updateEpFail',
    '783' => 'updateEpSuccess',
  },
  'CfprApNhMacVlanType' => {
    '0' => 'normal',
    '1' => 'miss',
    '2' => 'ucAll',
    '3' => 'mcAll',
    '4' => 'macAll',
    '5' => 'fpmac',
  },
  'CfprApFabricLanFlowMonExporterType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaRealmFsmTaskItem' => {
    '0' => 'nop',
    '352' => 'updateRealm',
  },
  'CfprApVnicDefBehType' => {
    '1' => 'vnic',
    '2' => 'vhba',
  },
  'CfprApAdaptorNwMgmtCapMgmtTransport' => {
    '0' => 'l2',
    '1' => 'l3',
  },
  'CfprApCommProtocol' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CfprApTrigDay' => {
    '0' => 'everyDay',
    '1' => 'monday',
    '2' => 'tuesday',
    '3' => 'wednesday',
    '4' => 'thursday',
    '5' => 'friday',
    '6' => 'saturday',
    '7' => 'sunday',
    '8' => 'oddDay',
    '9' => 'evenDay',
  },
  'CfprApFirmwareFwState' => {
    '0' => 'unknown',
    '1' => 'sameRelease',
    '2' => 'compatible',
    '3' => 'incompatible',
    '4' => 'multipleReleases',
  },
  'CfprApEtherFtwOperMode' => {
    '0' => 'noBypass',
    '2' => 'bypassReq',
    '3' => 'bypassWdt',
    '4' => 'bypassPwr',
  },
  'CfprApAaaIpmiOverLan' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApSwEthMonFsmCurrentFsm' => {
    '0' => 'nop',
    '439' => 'deploy',
  },
  'CfprApFabricAFcEstcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfMemoryMappedIOAbove4GBVpMemoryMappedIOAbove4GB' => {
    '0' => 'platformRecommended',
    '90' => 'disabled',
    '91' => 'enabled',
  },
  'CfprApQosHostControl' => {
    '0' => 'none',
    '1' => 'full',
    '2' => 'fullWithException',
  },
  'CfprApSwVlanCompType' => {
    '1' => 'included',
    '2' => 'excluded',
  },
  'CfprApPolicyControlledTypeFsmCurrentFsm' => {
    '0' => 'nop',
    '504' => 'operate',
  },
  'CfprApLsType' => {
    '0' => 'instance',
    '1' => 'initialTemplate',
    '2' => 'updatingTemplate',
  },
  'CfprApEquipmentFexCapProviderRole' => {
    '1' => 'mgmt',
    '2' => 'data',
    '3' => 'full',
  },
  'CfprApConfigImpactResponseState' => {
    '0' => 'notStarted',
    '1' => 'waiting',
    '2' => 'complete',
  },
  'CfprApFabricPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApSwMonLifeCycle' => {
    '1' => 'normal',
    '2' => 'new',
    '3' => 'deleted',
  },
  'CfprApComputeChassisDiscAction' => {
    '0' => 'immediate',
    '1' => 'userAcknowledged',
    '2' => 'n1Link',
    '3' => 'n2Link',
    '4' => 'n4Link',
    '5' => 'n8Link',
    '6' => 'platformMax',
  },
  'CfprApFabricAVlanAssocPrimaryVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
  },
  'CfprApComputeRackUnitMbTempStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'frontTemp',
      '5' => 'frontTempAvg',
      '6' => 'frontTempMax',
      '7' => 'frontTempMin',
      '8' => 'ioh1Temp',
      '9' => 'ioh1TempAvg',
      '10' => 'ioh1TempMax',
      '11' => 'ioh1TempMin',
      '12' => 'ioh2Temp',
      '13' => 'ioh2TempAvg',
      '14' => 'ioh2TempMax',
      '15' => 'ioh2TempMin',
      '16' => 'rearTemp',
      '17' => 'rearTempAvg',
      '18' => 'rearTempMax',
      '19' => 'rearTempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareComponentType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'kernel',
      '1' => 'system',
      '2' => 'combined',
      '3' => 'bootLoader',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPolicyRegistrationStateType' => {
    '0' => 'registering',
    '1' => 'registered',
    '2' => 'failed',
    '3' => 'lostVisibility',
    '4' => 'unregistered',
  },
  'CfprApFirmwareInfraPackFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '33' => 'samDmeFirmwareInfraPackInfraVersionInitRestore',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtCfgExportPolicyFsmStageName' => {
    '0' => 'nop',
    '460' => 'reportConfigCopyBegin',
    '461' => 'reportConfigCopyReport',
    '660' => 'reportConfigCopyFail',
    '661' => 'reportConfigCopySuccess',
  },
  'CfprApBiosVfIntelEntrySASRAIDModuleVpSASRAID' => {
    '0' => 'platformRecommended',
    '74' => 'disabled',
    '75' => 'enabled',
  },
  'CfprApFabricEthLanPcSpeedCap' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'auto',
      '1' => 'n1g',
      '2' => 'n10g',
      '3' => 'n20g',
      '4' => 'n40g',
      '7' => 'n100m',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugBackupFormat' => {
    '1' => 'ascii',
    '2' => 'binary',
  },
  'CfprApSmSecSvcFsmTaskItem' => {
    '0' => 'nop',
    '81' => 'restoreApplication',
    '92' => 'autoDeployCSP',
  },
  'CfprApStorageFFDriveState' => {
    '0' => 'nonraid',
    '1' => 'raid',
  },
  'CfprApBiosVfUCSMBootOrderRuleControlVpUCSMBootOrderRule' => {
    '0' => 'platformRecommended',
    '291' => 'strict',
    '292' => 'loose',
  },
  'CfprApFirmwareSupFirmwareFsmStageName' => {
    '0' => 'nop',
    '56' => 'deployBegin',
    '57' => 'deployWaitForDeploy',
    '58' => 'deployValidateFirmwarePack',
    '59' => 'deployDebundlePort',
    '60' => 'deployPollDebundlePort',
    '61' => 'deployActivateFirmwarePack',
    '62' => 'deployPollActivateOfFirmwarePack',
    '63' => 'deployUpdateImageVersion',
    '64' => 'deployWaitForFirmwareVersionUpdate',
    '65' => 'deployUpdatePackageVersion',
    '66' => 'deployCompleteFirmwareUpgrade',
    '620' => 'deployFail',
    '621' => 'deploySuccess',
  },
  'CfprApMgmtMode' => {
    '0' => 'inBand',
  },
  'CfprApSwFcSanBorderFsmCurrentFsm' => {
    '0' => 'nop',
    '100' => 'deploy',
    '122' => 'activateZoneSet',
  },
  'CfprApConditionActionIndicator' => {
    '0' => 'creation',
    '1' => 'modification',
    '2' => 'deletion',
    '3' => 'stateTransition',
    '4' => 'special',
    '5' => 'failure',
  },
  'CfprApLicenseTransport' => {
    '0' => 'ftp',
    '1' => 'tftp',
    '2' => 'scp',
    '3' => 'sftp',
    '4' => 'local',
  },
  'CfprApPolicyCleanupMode' => {
    '0' => 'localizeGlobal',
    '1' => 'deepRemoveGlobal',
  },
  'CfprApAdaptorHostFcIfHostPort' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CfprApAaaRadiusService' => {
    '0' => 'all',
    '1' => 'authorization',
    '2' => 'accounting',
  },
  'CfprApEquipmentPsuInputStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageFFCardWriteEnable' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApLsbootPurpose' => {
    '1' => 'utility',
    '2' => 'operational',
  },
  'CfprApEpqosDefinitionDelTaskFsmTaskItem' => {
    '0' => 'nop',
    '387' => 'remove',
  },
  'CfprApLsbootIScsiType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
  },
  'CfprApApplicationDownloaderFsmTaskItem' => {
    '0' => 'nop',
    '332' => 'download',
  },
  'CfprApSwEthLanFlowMonExporterTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNfsClientConfigState' => {
    '0' => 'unregistered',
    '1' => 'registered',
    '2' => 'configured',
    '3' => 'failed',
  },
  'CfprApNhTpHashType' => {
    '0' => 'normal',
    '1' => 'twoTuple',
  },
  'CfprApCommSyslogSeverity' => {
    '0' => 'emergencies',
    '1' => 'alerts',
    '2' => 'critical',
    '3' => 'errors',
    '4' => 'warnings',
    '5' => 'notifications',
    '6' => 'information',
    '7' => 'debugging',
  },
  'CfprApCallhomeEpFsmStageName' => {
    '0' => 'nop',
    '124' => 'configCallhomeBegin',
    '125' => 'configCallhomeSetLocal',
    '126' => 'configCallhomeSetPeer',
    '550' => 'configCallhomeFail',
    '551' => 'configCallhomeSuccess',
  },
  'CfprApFirmwareDistributableFsmStageName' => {
    '0' => 'nop',
    '14' => 'deleteBegin',
    '15' => 'deleteLocal',
    '16' => 'deleteRemote',
    '612' => 'deleteFail',
    '613' => 'deleteSuccess',
  },
  'CfprApVnicVnicBehPolicyType' => {
    '1' => 'vnic',
    '2' => 'vhba',
  },
  'CfprApFcpoolInitiatorsMaxPortsPerNode' => {
    '3' => 'upto3',
    '7' => 'upto7',
    '15' => 'upto15',
    '31' => 'upto31',
    '63' => 'upto63',
  },
  'CfprApEventEpCtrlLevel' => {
    '0' => 'cleared',
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
  },
  'CfprApMgmtBackupFsmStageName' => {
    '0' => 'nop',
    '473' => 'backupBegin',
    '474' => 'backupBackupLocal',
    '475' => 'backupUpload',
    '646' => 'backupFail',
    '647' => 'backupSuccess',
  },
  'CfprApComputeAdminState' => {
    '1' => 'inService',
    '2' => 'outOfService',
  },
  'CfprApBiosVfIntelVTForDirectedIOVpIntelVTDCoherencySupport' => {
    '0' => 'platformRecommended',
    '56' => 'disabled',
    '57' => 'enabled',
  },
  'CfprApMgmtPmonEntryState' => {
    '0' => 'unknown',
    '1' => 'idle',
    '2' => 'running',
    '3' => 'pending',
    '4' => 'failed',
    '5' => 'error',
    '6' => 'exitPending',
    '7' => 'terminated',
    '8' => 'killed',
  },
  'CfprApCallhomeCallhomeProtocol' => {
    '0' => 'email',
    '1' => 'https',
    '2' => 'http',
  },
  'CfprApEquipmentRackUnitFanStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'speed',
      '1' => 'speedAvg',
      '2' => 'speedMax',
      '3' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmSlotOperState' => {
    '0' => 'notAvailable',
    '1' => 'offline',
    '2' => 'online',
    '3' => 'notResponding',
    '4' => 'fault',
    '5' => 'tokenMismatch',
  },
  'CfprApVmSwitchAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApFabricNFExporterVersion' => {
    '1' => 'v9',
    '2' => 'ipfix',
  },
  'CfprApFabricFcMonFiltRefType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfVGAPriorityVpVGAPriority' => {
    '0' => 'platformRecommended',
    '328' => 'onboard',
    '329' => 'offboard',
    '330' => 'onboardVgaDisabled',
  },
  'CfprApMemoryRuntimeThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'available',
      '1' => 'availableAvg',
      '2' => 'availableMax',
      '3' => 'availableMin',
      '4' => 'cached',
      '5' => 'cachedAvg',
      '6' => 'cachedMax',
      '7' => 'cachedMin',
      '8' => 'total',
      '9' => 'totalAvg',
      '10' => 'totalMax',
      '11' => 'totalMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPsuFanStatus' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'failed',
  },
  'CfprApPkiEpFsmCurrentFsm' => {
    '0' => 'nop',
    '344' => 'updateEp',
  },
  'CfprApBiosVfAllUSBDevicesVpAllUSBDevices' => {
    '0' => 'platformRecommended',
    '300' => 'disabled',
    '301' => 'enabled',
  },
  'CfprApSmMgmtSubType' => {
    '0' => 'default',
    '1' => 'firepower',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot5State' => {
    '0' => 'platformRecommended',
    '190' => 'disabled',
    '191' => 'enabled',
    '192' => 'uefiOnly',
    '193' => 'legacyOnly',
  },
  'CfprApFabricInternalPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthLanFlowRecordDefType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLicensePeerStatus' => {
    '0' => 'noPeer',
    '1' => 'unknown',
    '2' => 'lacks',
    '3' => 'exceeds',
    '4' => 'matching',
  },
  'CfprApStatsThr64ValuePropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CfprApSwFcoeSanEpUdldMode' => {
    '0' => 'normal',
    '1' => 'aggressive',
  },
  'CfprApGmetaPollInterval' => {
    '0' => 'never',
    '1' => 'n1min',
    '2' => 'n2min',
    '5' => 'n5min',
    '10' => 'n10min',
    '15' => 'n15min',
    '30' => 'n30min',
  },
  'CfprApFabricNetflowMonExporterProtocol' => {
    '1' => 'netflow',
  },
  'CfprApPowerOperState' => {
    '0' => 'notCapped',
    '1' => 'budgeting',
    '2' => 'budgeted',
    '3' => 'deploying',
    '4' => 'deployed',
    '5' => 'discoveryRetry',
    '6' => 'nonCompliant',
    '7' => 'firmwareMismatch',
    '8' => 'discoveryBudgeted',
    '9' => 'unbudgeted',
  },
  'CfprApTrigAckDisr' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'upTime',
      '1' => 'acPowerCycle',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmSecSvcFsmStageName' => {
    '0' => 'nop',
    '81' => 'restoreApplicationBegin',
    '82' => 'restoreApplicationRestore',
    '92' => 'autoDeployCSPBegin',
    '93' => 'autoDeployCSPWaitForPortReady',
    '94' => 'autoDeployCSPCreateLogicalDevice',
    '778' => 'autoDeployCSPFail',
    '779' => 'autoDeployCSPSuccess',
    '780' => 'restoreApplicationFail',
    '781' => 'restoreApplicationSuccess',
    '833' => 'autoDeployCSPWaitForChassisMoReady',
  },
  'CfprApOsOsType' => {
    '0' => 'unspecified',
    '1' => 'pnuOS',
    '2' => 'linux',
    '3' => 'windows',
    '4' => 'solaris',
    '5' => 'vmwareESX',
    '6' => 'fxOS',
  },
  'CfprApPoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApLsbootADefBootMode' => {
    '1' => 'legacy',
    '2' => 'uefi',
  },
  'CfprApFabricDirection' => {
    '1' => 'receive',
    '2' => 'transmit',
  },
  'CfprApEtherFtwPortPairFsmStageName' => {
    '0' => 'nop',
    '315' => 'configFtwBegin',
    '316' => 'configFtwConfigure',
    '590' => 'configFtwFail',
    '591' => 'configFtwSuccess',
  },
  'CfprApSwSspLanMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorIpV6RssHashProfileTcpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApVnicIpcType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApMgmtBackupStatus' => {
    '0' => 'idle',
    '1' => 'exporting',
    '2' => 'succeeded',
    '3' => 'failed',
  },
  'CfprApSwFcZoneLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CfprApIdentRetStatus' => {
    '1' => 'succeeded',
    '2' => 'assignedByOther',
    '3' => 'outOfSync',
    '4' => 'failed',
    '5' => 'synced',
  },
  'CfprApAdaptorEthPortOutsizedStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'oversizedBadCrcPacketsDelta',
      '1' => 'oversizedBadCrcPacketsDeltaAvg',
      '2' => 'oversizedBadCrcPacketsDeltaMax',
      '3' => 'oversizedBadCrcPacketsDeltaMin',
      '4' => 'oversizedGoodCrcPacketsDelta',
      '5' => 'oversizedGoodCrcPacketsDeltaAvg',
      '6' => 'oversizedGoodCrcPacketsDeltaMax',
      '7' => 'oversizedGoodCrcPacketsDeltaMin',
      '8' => 'oversizedPacketsDelta',
      '9' => 'oversizedPacketsDeltaAvg',
      '10' => 'oversizedPacketsDeltaMax',
      '11' => 'oversizedPacketsDeltaMin',
      '12' => 'undersizedBadCrcPacketsDelta',
      '13' => 'undersizedBadCrcPacketsDeltaAvg',
      '14' => 'undersizedBadCrcPacketsDeltaMax',
      '15' => 'undersizedBadCrcPacketsDeltaMin',
      '16' => 'undersizedGoodCrcPacketsDelta',
      '17' => 'undersizedGoodCrcPacketsDeltaAvg',
      '18' => 'undersizedGoodCrcPacketsDeltaMax',
      '19' => 'undersizedGoodCrcPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApExtpolConnProtocol' => {
    '0' => 'ipv4',
    '1' => 'ipv6',
    '2' => 'unknown',
  },
  'CfprApBiosVfIntelEntrySASRAIDModuleVpSASRAIDModule' => {
    '0' => 'platformRecommended',
    '76' => 'itIrRaid',
    '77' => 'intelEsrtii',
  },
  'CfprApAdaptorIScsiCapBootOrderType' => {
    '0' => 'systemBootOrder',
    '1' => 'fddOrder',
    '2' => 'hddOrder',
    '3' => 'cdOrder',
    '6' => 'networkDeviceOrder',
    '16' => 'internalEfiShell',
    '99' => 'unknownDeviceOrder',
    '100' => 'localStorageAnyDeviceOrder',
    '101' => 'sanDeviceOrder',
    '102' => 'sanAnyDeviceOrder',
    '103' => 'internalUsbDeviceOrder',
    '104' => 'externalUsbDeviceOrder',
    '105' => 'sdcardDeviceOrder',
    '106' => 'lanAnyDeviceOrder',
    '107' => 'uefiTargetDeviceOrder',
    '108' => 'iscsiDeviceOrder',
    '109' => 'iscsiAnyDeviceOrder',
    '110' => 'cimcVmediaCddDeviceOrder',
    '111' => 'cimcVmediaHddDeviceOrder',
    '112' => 'cimcVmediaFddDeviceOrder',
    '113' => 'kvmVmediaCddDeviceOrder',
    '114' => 'kvmVmediaHddDeviceOrder',
    '115' => 'kvmVmediaFddDeviceOrder',
    '128' => 'bevOrder',
  },
  'CfprApAdaptorMenloNetInStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropFcLifInvalidDelta',
      '1' => 'dropFcLifInvalidDeltaAvg',
      '2' => 'dropFcLifInvalidDeltaMax',
      '3' => 'dropFcLifInvalidDeltaMin',
      '4' => 'dropFcMulticastDelta',
      '5' => 'dropFcMulticastDeltaAvg',
      '6' => 'dropFcMulticastDeltaMax',
      '7' => 'dropFcMulticastDeltaMin',
      '8' => 'dropNullPifDelta',
      '9' => 'dropNullPifDeltaAvg',
      '10' => 'dropNullPifDeltaMax',
      '11' => 'dropNullPifDeltaMin',
      '12' => 'fwdLookupNoHitDelta',
      '13' => 'fwdLookupNoHitDeltaAvg',
      '14' => 'fwdLookupNoHitDeltaMax',
      '15' => 'fwdLookupNoHitDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricFillPattern' => {
    '0' => 'idle',
    '1' => 'arbff',
  },
  'CfprApBiosVfUCSMBootModeControlVpUEFIBootMode' => {
    '0' => 'platformRecommended',
    '293' => 'disabled',
    '294' => 'enabled',
  },
  'CfprApMgmtControllerFsmStageName' => {
    '0' => 'nop',
    '17' => 'updateUCSManagerBegin',
    '18' => 'updateUCSManagerCopyExtToLocal',
    '19' => 'updateUCSManagerCopyExtToPeer',
    '20' => 'updateUCSManagerStart',
    '21' => 'updateUCSManagerExecute',
    '22' => 'updateSwitchBegin',
    '23' => 'updateSwitchCopyToLocal',
    '24' => 'updateSwitchCopyToPeer',
    '25' => 'updateSwitchUpdateLocal',
    '26' => 'updateSwitchVerifyLocal',
    '27' => 'updateSwitchResetLocal',
    '28' => 'updateSwitchUpdateRemote',
    '29' => 'updateSwitchVerifyRemote',
    '30' => 'updateSwitchResetRemote',
    '31' => 'updateIOMBegin',
    '32' => 'updateIOMCopyImgFromRep',
    '33' => 'updateIOMCopyIOMImgToSub',
    '205' => 'extMgmtInterfaceConfigBegin',
    '206' => 'extMgmtInterfaceConfigCIMCVlanCfgLocal',
    '207' => 'extMgmtInterfaceConfigCIMCVlanCfgPeer',
    '393' => 'registryConfigBegin',
    '394' => 'registryConfigRemove',
    '483' => 'sysConfigBegin',
    '484' => 'sysConfigPrimary',
    '485' => 'sysConfigSecondary',
    '648' => 'extMgmtInterfaceConfigFail',
    '649' => 'extMgmtInterfaceConfigSuccess',
    '650' => 'registryConfigFail',
    '651' => 'registryConfigSuccess',
    '652' => 'sysConfigFail',
    '653' => 'sysConfigSuccess',
    '654' => 'updateIOMFail',
    '655' => 'updateIOMSuccess',
    '656' => 'updateSwitchFail',
    '657' => 'updateSwitchSuccess',
    '658' => 'updateUCSManagerFail',
    '659' => 'updateUCSManagerSuccess',
  },
  'CfprApExtpolSuspendState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApFabricEthLanEpVlanStatus' => {
    '0' => 'ok',
    '1' => 'missingPrimary',
  },
  'CfprApFabricEthLanPcAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApSwEthLanFlowRecordDefTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPkiKeyringState' => {
    '1' => 'started',
    '2' => 'created',
    '3' => 'reqCreated',
    '4' => 'tpSet',
    '5' => 'completed',
  },
  'CfprApEtherPIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApNhTableHolderFsmCurrentFsm' => {
    '0' => 'nop',
    '401' => 'configureLinks',
    '405' => 'bootstrapLinks',
  },
  'CfprApStorageOperationState' => {
    '0' => 'unknown',
    '1' => 'inProgress',
    '2' => 'completed',
    '3' => 'failed',
  },
  'CfprApFabricSspMonDelPcap' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApExtvmmVnicType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApAdaptorFcPortStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxBadFramesDelta',
      '1' => 'rxBadFramesDeltaAvg',
      '2' => 'rxBadFramesDeltaMax',
      '3' => 'rxBadFramesDeltaMin',
      '4' => 'rxFramesDelta',
      '5' => 'rxFramesDeltaAvg',
      '6' => 'rxFramesDeltaMax',
      '7' => 'rxFramesDeltaMin',
      '8' => 'txBadFramesDelta',
      '9' => 'txBadFramesDeltaAvg',
      '10' => 'txBadFramesDeltaMax',
      '11' => 'txBadFramesDeltaMin',
      '12' => 'txFramesDelta',
      '13' => 'txFramesDeltaAvg',
      '14' => 'txFramesDeltaMax',
      '15' => 'txFramesDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaLdapGroupRuleTraversal' => {
    '0' => 'nonRecursive',
    '1' => 'recursive',
  },
  'CfprApBiosVfIntelHyperThreadingTechVpIntelHyperThreadingTech' => {
    '0' => 'platformRecommended',
    '24' => 'disabled',
    '25' => 'enabled',
  },
  'CfprApSysdebugEpLogCapacity' => {
    '0' => 'unknown',
    '1' => 'available',
    '2' => 'low',
    '3' => 'veryLow',
    '4' => 'full',
  },
  'CfprApFabricRecoveryAction' => {
    '0' => 'none',
    '1' => 'reset',
  },
  'CfprApFabricVlanSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApExtpolProviderFsmCurrentFsm' => {
    '0' => 'nop',
    '462' => 'reportConfigImport',
  },
  'CfprApLsResolveFromRemoteServer' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApSdMacType' => {
    '1' => 'unicast',
    '2' => 'multicast',
  },
  'CfprApAdaptorMenloEthStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropOverrunDelta',
      '1' => 'dropOverrunDeltaAvg',
      '2' => 'dropOverrunDeltaMax',
      '3' => 'dropOverrunDeltaMin',
      '4' => 'dropRuntDelta',
      '5' => 'dropRuntDeltaAvg',
      '6' => 'dropRuntDeltaMax',
      '7' => 'dropRuntDeltaMin',
      '8' => 'truncateOverrunDelta',
      '9' => 'truncateOverrunDeltaAvg',
      '10' => 'truncateOverrunDeltaMax',
      '11' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPkiCertStatus' => {
    '0' => 'valid',
    '1' => 'expired',
    '2' => 'revoked',
    '3' => 'notYetValid',
    '4' => 'emptyCert',
    '5' => 'unknown',
    '6' => 'failedToVerifyWithTp',
    '7' => 'failedToVerifyWithPrivateKey',
    '8' => 'certChainTooLong',
    '9' => 'selfSignedCertificate',
  },
  'CfprApEtherRxStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'jumboPacketsDelta',
      '5' => 'jumboPacketsDeltaAvg',
      '6' => 'jumboPacketsDeltaMax',
      '7' => 'jumboPacketsDeltaMin',
      '8' => 'multicastPacketsDelta',
      '9' => 'multicastPacketsDeltaAvg',
      '10' => 'multicastPacketsDeltaMax',
      '11' => 'multicastPacketsDeltaMin',
      '12' => 'totalBytesDelta',
      '13' => 'totalBytesDeltaAvg',
      '14' => 'totalBytesDeltaMax',
      '15' => 'totalBytesDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'unicastPacketsDelta',
      '21' => 'unicastPacketsDeltaAvg',
      '22' => 'unicastPacketsDeltaMax',
      '23' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageLearnMode' => {
    '0' => 'unknown',
    '1' => 'auto',
    '2' => 'disabled',
    '3' => 'warn',
  },
  'CfprApLsmaintAckChangeDetails' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'binding',
      '1' => 'hostVirtEthIf',
      '2' => 'hostNonvirtEthIf',
      '3' => 'hostEthIfProfile',
      '4' => 'hostEthIfQos',
      '5' => 'hostEthIfNwCtrl',
      '6' => 'hostVirtFcIf',
      '7' => 'hostNonvirtFcIf',
      '8' => 'hostVirtFcIfPersBind',
      '9' => 'hostNonvirtFcIfPersBind',
      '10' => 'hostFcIfProfile',
      '11' => 'hostFcIfQos',
      '12' => 'hostFcoeIf',
      '13' => 'vif',
      '14' => 'vlan',
      '15' => 'vsan',
      '16' => 'ip',
      '17' => 'bootOrder',
      '18' => 'bootVirtVnic',
      '19' => 'bootNonvirtVnic',
      '20' => 'bootLocalStorage',
      '21' => 'bootVirtPxe',
      '22' => 'bootNonvirtPxe',
      '24' => 'bladeIdentity',
      '25' => 'agentPolicy',
      '26' => 'biosFw',
      '27' => 'storageControllerFw',
      '28' => 'adaptorHostFw',
      '29' => 'adaptorNwFw',
      '30' => 'mgmtControllerFw',
      '31' => 'localDiskPolicy',
      '32' => 'pin',
      '33' => 'sol',
      '34' => 'epAuth',
      '35' => 'biosProfile',
      '36' => 'checkpoint',
      '37' => 'implicitReboot',
      '38' => 'implicitHostFcIfProfileRedeploy',
      '39' => 'boardControllerFw',
      '40' => 'hostEthIfQosHostControl',
      '41' => 'localDiskFw',
      '42' => 'implicitHostEthIfProfileRedeploy',
      '43' => 'storagePath',
      '44' => 'bmcUpdateBiosFw',
      '45' => 'hostIfPcie',
      '46' => 'flexflashConfig',
      '48' => 'bootmodeConfig',
      '49' => 'securebootConfig',
      '50' => 'vmediaConfig',
      '51' => 'ssposUpdateFw',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareInfraPackFsmStageName' => {
    '0' => 'nop',
    '828' => 'infraVersionBegin',
    '829' => 'infraVersionWaitForReady',
    '830' => 'infraVersionRestore',
    '831' => 'infraVersionFail',
    '832' => 'infraVersionSuccess',
  },
  'CfprApAaaAuthRealmFsmStageName' => {
    '0' => 'nop',
    '352' => 'updateRealmBegin',
    '353' => 'updateRealmSetRealmLocal',
    '354' => 'updateRealmSetRealmPeer',
    '538' => 'updateRealmFail',
    '539' => 'updateRealmSuccess',
  },
  'CfprApSdPortBundleStatus' => {
    '0' => 'unknown',
    '1' => 'failure',
    '2' => 'partial',
    '3' => 'success',
  },
  'CfprApFirmwareDistributableFsmCurrentFsm' => {
    '0' => 'nop',
    '14' => 'delete',
  },
  'CfprApAdaptorMenloFcStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropAclDelta',
      '1' => 'dropAclDeltaAvg',
      '2' => 'dropAclDeltaMax',
      '3' => 'dropAclDeltaMin',
      '4' => 'dropOverrunDelta',
      '5' => 'dropOverrunDeltaAvg',
      '6' => 'dropOverrunDeltaMax',
      '7' => 'dropOverrunDeltaMin',
      '8' => 'dropRuntDelta',
      '9' => 'dropRuntDeltaAvg',
      '10' => 'dropRuntDeltaMax',
      '11' => 'dropRuntDeltaMin',
      '12' => 'truncateOverrunDelta',
      '13' => 'truncateOverrunDeltaAvg',
      '14' => 'truncateOverrunDeltaMax',
      '15' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApIdentIdentReqIntent' => {
    '1' => 'requisition',
    '2' => 'assign',
    '3' => 'unassign',
    '4' => 'addPooled',
    '5' => 'deletePooled',
    '6' => 'checkDuplicateId',
  },
  'CfprApLicenseSmartConfigFsmCurrentFsm' => {
    '0' => 'nop',
    '156' => 'setConfig',
  },
  'CfprApNhTableHolderFsmStageName' => {
    '0' => 'nop',
    '401' => 'configureLinksBegin',
    '402' => 'configureLinksConfigInterface',
    '403' => 'configureLinksApplyConfig',
    '404' => 'configureLinksVerifyLinkConfig',
    '405' => 'bootstrapLinksBegin',
    '406' => 'bootstrapLinksApplyConfig',
    '684' => 'bootstrapLinksFail',
    '685' => 'bootstrapLinksSuccess',
    '686' => 'configureLinksFail',
    '687' => 'configureLinksSuccess',
  },
  'CfprApFirmwareTransport' => {
    '0' => 'ftp',
    '1' => 'tftp',
    '2' => 'scp',
    '3' => 'sftp',
    '4' => 'local',
    '5' => 'usbA',
    '6' => 'usbB',
  },
  'CfprApFirmwarePlatformPackFsmTaskItem' => {
    '0' => 'nop',
    '34' => 'platformVersion',
  },
  'CfprApComputeCheckPoint' => {
    '0' => 'unknown',
    '1' => 'removing',
    '2' => 'shallowCheckpoint',
    '3' => 'deepCheckpoint',
    '4' => 'discovered',
  },
  'CfprApSwUlanPurpose' => {
    '1' => 'management',
    '2' => 'boot',
    '3' => 'reserved1',
    '4' => 'reserved2',
  },
  'CfprApCommSnmpNotificationType' => {
    '1' => 'traps',
    '2' => 'informs',
  },
  'CfprApOsControllerFormatDisk' => {
    '0' => 'noOp',
    '1' => 'quickFormat',
    '2' => 'removeCfgapp',
  },
  'CfprApCapabilityMgmtExtensionFsmTaskItem' => {
    '0' => 'nop',
    '429' => 'activateMgmtExt',
  },
  'CfprApCimcvmediaErrorType' => {
    '0' => 'unknown',
    '1' => 'none',
    '2' => 'genericFailure',
    '3' => 'connectionTimeout',
    '4' => 'connectionRejected',
    '5' => 'authenticationFailed',
    '6' => 'badPath',
    '7' => 'badParam',
    '8' => 'invalidVdiskUsage',
    '9' => 'invalidVdiskType',
    '10' => 'alreadyMapped',
    '11' => 'imageStoreFull',
    '12' => 'fileNotFound',
    '13' => 'openRoFailed',
    '14' => 'openRwFailed',
    '15' => 'diskEjected',
    '16' => 'diskIoFailure',
    '17' => 'writeToReadonlyFile',
    '18' => 'mountInUse',
    '19' => 'invalidArgument',
    '20' => 'imgageDeleted',
    '21' => 'postmapError',
  },
  'CfprApFabricCdpLinkPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApMgmtExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '460' => 'reportConfigCopy',
  },
  'CfprApAdaptorCapDefFwVersionOpr' => {
    '0' => 'none',
    '1' => 'gt',
    '2' => 'lt',
  },
  'CfprApAdaptorExtEthIfFsmTaskItem' => {
    '0' => 'nop',
    '127' => 'pathReset',
  },
  'CfprApEpqosDefinitionDelTaskFsmStageName' => {
    '0' => 'nop',
    '387' => 'removeBegin',
    '388' => 'removeLocal',
    '389' => 'removePeer',
    '572' => 'removeFail',
    '573' => 'removeSuccess',
  },
  'CfprApFabricComputeEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricTargetEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEpMgrFsmCurrentFsm' => {
    '0' => 'nop',
    '455' => 'configure',
  },
  'CfprApFabricFcMonSanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthMonFsmTaskItem' => {
    '0' => 'nop',
    '439' => 'deploy',
  },
  'CfprApSdLinkFsmStageName' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatusBegin',
    '290' => 'updateInterfaceStatusSendStatus',
    '756' => 'updateInterfaceStatusFail',
    '757' => 'updateInterfaceStatusSuccess',
  },
  'CfprApStorageFFRAIDHealth' => {
    '0' => 'ffrHealthNa',
    '1' => 'ffrHealthOk',
    '2' => 'ffrHealthDegraded',
    '3' => 'ffrHealthNotReporting',
  },
  'CfprApFabricLanCloudVlanCompression' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApCommChannel' => {
    '0' => 'fullssl',
    '1' => 'noencssl',
    '2' => 'plain',
  },
  'CfprApBiosVfAssertNMIOnSERRVpAssertNMIOnSERR' => {
    '0' => 'platformRecommended',
    '96' => 'disabled',
    '97' => 'enabled',
  },
  'CfprApNfsMountDefFsmTaskItem' => {
    '0' => 'nop',
    '494' => 'reportNfsMountSuspend',
  },
  'CfprApFirmwareImagePresence' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'a',
      '1' => 'b',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaSshStr' => {
    '0' => 'none',
    '1' => 'key',
  },
  'CfprApSdCfgPortForwardingMode' => {
    '0' => 'none',
    '1' => 'individual',
    '2' => 'promiscuous',
  },
  'CfprApSdJobState' => {
    '0' => 'unknown',
    '1' => 'queued',
    '2' => 'failed',
    '3' => 'succeeded',
  },
  'CfprApStorageLocalDiskConfigFlexFlashRAIDReportingState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApMgmtControllerFsmTaskItem' => {
    '0' => 'nop',
    '17' => 'updateUCSManager',
    '22' => 'updateSwitch',
    '31' => 'updateIOM',
    '205' => 'extMgmtInterfaceConfig',
    '393' => 'registryConfig',
    '483' => 'sysConfig',
  },
  'CfprApQosclassEthBEAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFabricUdldLinkPolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApLsAssocState' => {
    '0' => 'unassociated',
    '1' => 'associating',
    '2' => 'associated',
    '3' => 'disassociating',
    '4' => 'failed',
  },
  'CfprApFabricEthLanEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFcpoolInitiatorsAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApBiosVfIntelVTForDirectedIOVpIntelVTDInterruptRemapping' => {
    '0' => 'platformRecommended',
    '54' => 'disabled',
    '55' => 'enabled',
  },
  'CfprApFabricExternalEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherServerIntFIoTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEthMonFiltEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtIPv6IfAddrFsmStageName' => {
    '0' => 'nop',
    '399' => 'swMgmtOobIpv6IfConfigBegin',
    '400' => 'swMgmtOobIpv6IfConfigSwitch',
    '662' => 'swMgmtOobIpv6IfConfigFail',
    '663' => 'swMgmtOobIpv6IfConfigSuccess',
  },
  'CfprApPowerCapAction' => {
    '0' => 'nothing',
    '1' => 'clockDown',
    '2' => 'throttled',
  },
  'CfprApEquipmentAirflowDirection' => {
    '0' => 'unknown',
    '1' => 'frontToBack',
    '2' => 'backToFront',
  },
  'CfprApEquipmentPictureType' => {
    '0' => 'unknown',
    '1' => 'front',
    '2' => 'back',
    '3' => 'top',
    '4' => 'bottom',
    '5' => 'left',
    '6' => 'right',
  },
  'CfprApMgmtEntityHaFailureReason' => {
    '0' => 'none',
    '1' => 'nodeDown',
    '2' => 'peerNodeDown',
    '3' => 'mgmtServicesUnresponsive',
    '4' => 'peerMgmtServicesUnresponsive',
    '5' => 'chassisConfigIncomplete',
    '6' => 'peerChassisConfigIncomplete',
    '7' => 'networkInterfaceDown',
  },
  'CfprApEquipmentIOCardBaseFsmTaskItem' => {
    '0' => 'nop',
    '219' => 'fePresence',
    '222' => 'feConn',
  },
  'CfprApFabricEthFlowMonLanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommSnmpAuth' => {
    '2' => 'sha',
  },
  'CfprApStorageConfiguration' => {
    '0' => 'unknown',
    '1' => 'supported',
    '2' => 'notSupported',
  },
  'CfprApFabricLacpRate' => {
    '0' => 'normal',
    '1' => 'fast',
  },
  'CfprApFabricVnetEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentBiosUpdateMethod' => {
    '0' => 'unknown',
    '1' => 'managementController',
    '2' => 'pnuos',
  },
  'CfprApSwAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEtherTxStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'jumboPacketsDelta',
      '5' => 'jumboPacketsDeltaAvg',
      '6' => 'jumboPacketsDeltaMax',
      '7' => 'jumboPacketsDeltaMin',
      '8' => 'multicastPacketsDelta',
      '9' => 'multicastPacketsDeltaAvg',
      '10' => 'multicastPacketsDeltaMax',
      '11' => 'multicastPacketsDeltaMin',
      '12' => 'totalBytesDelta',
      '13' => 'totalBytesDeltaAvg',
      '14' => 'totalBytesDeltaMax',
      '15' => 'totalBytesDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'unicastPacketsDelta',
      '21' => 'unicastPacketsDeltaAvg',
      '22' => 'unicastPacketsDeltaMax',
      '23' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEpqosDefinitionDelTaskFsmCurrentFsm' => {
    '0' => 'nop',
    '387' => 'remove',
  },
  'CfprApLsbootDefaultLocalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
  },
  'CfprApAdaptorMenloMcpuErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'popErrorsDelta',
      '5' => 'popErrorsDeltaAvg',
      '6' => 'popErrorsDeltaMax',
      '7' => 'popErrorsDeltaMin',
      '8' => 'pushErrorsDelta',
      '9' => 'pushErrorsDeltaAvg',
      '10' => 'pushErrorsDeltaMax',
      '11' => 'pushErrorsDeltaMin',
      '12' => 'uncorrectableErrorsDelta',
      '13' => 'uncorrectableErrorsDeltaAvg',
      '14' => 'uncorrectableErrorsDeltaMax',
      '15' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicFcNodeOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '8' => 'connPolicy',
  },
  'CfprApStorageFFCardSizeMismatch' => {
    '0' => 'na',
    '1' => 'mismatch',
    '2' => 'match',
  },
  'CfprApFabricFcoeSanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSspMonOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'error',
  },
  'CfprApAdaptorHostIfBootDev' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot7State' => {
    '0' => 'platformRecommended',
    '198' => 'disabled',
    '199' => 'enabled',
    '200' => 'uefiOnly',
    '201' => 'legacyOnly',
  },
  'CfprApSwSanPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricPathEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtSubject' => {
    '0' => 'unknown',
    '1' => 'blade',
    '2' => 'chassis',
    '4' => 'system',
    '8' => 'switch',
    '16' => 'adaptor',
    '32' => 'iocard',
    '64' => 'boardController',
  },
  'CfprApCommSnmpVersion' => {
    '1' => 'v1',
    '2' => 'v2c',
    '3' => 'v3',
  },
  'CfprApLsbootLanImagePathType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApComputePCIeFatalProtocolStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dllpErrors',
      '1' => 'flowControlErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNetworkSide' => {
    '0' => 'left',
    '1' => 'right',
  },
  'CfprApMgmtEntityChassisDeviceIoState3' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'openError',
    '3' => 'readError',
    '4' => 'writeError',
  },
  'CfprApBiosVfDramRefreshRateVpDramRefreshRate' => {
    '0' => 'platformRecommended',
    '17' => 'n1x',
    '18' => 'n2x',
    '19' => 'n3x',
    '20' => 'n4x',
    '21' => 'auto',
  },
  'CfprApApplicationDownloaderFsmCurrentFsm' => {
    '0' => 'nop',
    '332' => 'download',
  },
  'CfprApEquipmentPsuVoltageType' => {
    '0' => 'unknown',
    '1' => 'ac',
    '2' => 'dc',
    '3' => 'dv',
    '4' => 'hvdc',
  },
  'CfprApAaaUserInterface' => {
    '0' => 'none',
    '1' => 'shell',
    '2' => 'web',
    '3' => 'ep',
    '4' => 'kvm',
    '5' => 'vmedia',
    '6' => 'sol',
  },
  'CfprApSwFcEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFcErrStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'crcRxDelta',
      '1' => 'crcRxDeltaAvg',
      '2' => 'crcRxDeltaMax',
      '3' => 'crcRxDeltaMin',
      '4' => 'discardRxDelta',
      '5' => 'discardRxDeltaAvg',
      '6' => 'discardRxDeltaMax',
      '7' => 'discardRxDeltaMin',
      '8' => 'discardTxDelta',
      '9' => 'discardTxDeltaAvg',
      '10' => 'discardTxDeltaMax',
      '11' => 'discardTxDeltaMin',
      '12' => 'linkFailuresDelta',
      '13' => 'linkFailuresDeltaAvg',
      '14' => 'linkFailuresDeltaMax',
      '15' => 'linkFailuresDeltaMin',
      '16' => 'rxDelta',
      '17' => 'rxDeltaAvg',
      '18' => 'rxDeltaMax',
      '19' => 'rxDeltaMin',
      '20' => 'signalLossesDelta',
      '21' => 'signalLossesDeltaAvg',
      '22' => 'signalLossesDeltaMax',
      '23' => 'signalLossesDeltaMin',
      '24' => 'syncLossesDelta',
      '25' => 'syncLossesDeltaAvg',
      '26' => 'syncLossesDeltaMax',
      '27' => 'syncLossesDeltaMin',
      '28' => 'tooLongRxDelta',
      '29' => 'tooLongRxDeltaAvg',
      '30' => 'tooLongRxDeltaMax',
      '31' => 'tooLongRxDeltaMin',
      '32' => 'tooShortRxDelta',
      '33' => 'tooShortRxDeltaAvg',
      '34' => 'tooShortRxDeltaMax',
      '35' => 'tooShortRxDeltaMin',
      '36' => 'txDelta',
      '37' => 'txDeltaAvg',
      '38' => 'txDeltaMax',
      '39' => 'txDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApExtpolEpFsmTaskItem' => {
    '0' => 'nop',
    '317' => 'registerFsm',
    '496' => 'repairCert',
  },
  'CfprApEquipmentPowerCapDefProfileMethod' => {
    '0' => 'unknown',
    '1' => 'default',
    '2' => 'static',
    '3' => 'pnuos',
    '4' => 'nodemgr',
  },
  'CfprApAdaptorAdminPowerState' => {
    '0' => 'none',
    '1' => 'resetPower',
  },
  'CfprApBiosVfProcessorPrefetchConfigVpDCUStreamerPrefetch' => {
    '0' => 'platformRecommended',
    '320' => 'disabled',
    '321' => 'enabled',
  },
  'CfprApFabricFlowMonCollectorLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentSlotArrayLocation' => {
    '0' => 'unknown',
    '1' => 'front',
    '2' => 'back',
    '3' => 'top',
    '4' => 'bottom',
    '5' => 'left',
    '6' => 'right',
  },
  'CfprApSmSecSvcFsmCurrentFsm' => {
    '0' => 'nop',
    '81' => 'restoreApplication',
    '92' => 'autoDeployCSP',
  },
  'CfprApSwSspEthMonFsmTaskItem' => {
    '0' => 'nop',
    '443' => 'deploy',
  },
  'CfprApSdAppInstAdminState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CfprApAdaptorEthPortBySizeSmallStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'equals64Delta',
      '1' => 'equals64DeltaAvg',
      '2' => 'equals64DeltaMax',
      '3' => 'equals64DeltaMin',
      '4' => 'lessThan1024Delta',
      '5' => 'lessThan1024DeltaAvg',
      '6' => 'lessThan1024DeltaMax',
      '7' => 'lessThan1024DeltaMin',
      '8' => 'lessThan128Delta',
      '9' => 'lessThan128DeltaAvg',
      '10' => 'lessThan128DeltaMax',
      '11' => 'lessThan128DeltaMin',
      '12' => 'lessThan256Delta',
      '13' => 'lessThan256DeltaAvg',
      '14' => 'lessThan256DeltaMax',
      '15' => 'lessThan256DeltaMin',
      '16' => 'lessThan512Delta',
      '17' => 'lessThan512DeltaAvg',
      '18' => 'lessThan512DeltaMax',
      '19' => 'lessThan512DeltaMin',
      '20' => 'lessThan64Delta',
      '21' => 'lessThan64DeltaAvg',
      '22' => 'lessThan64DeltaMax',
      '23' => 'lessThan64DeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareTransferState' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'failed',
  },
  'CfprApComputeKvmMgmtPolicyVmediaEncryption' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApSysdebugEpLogAdminState' => {
    '0' => 'policy',
    '1' => 'backup',
    '2' => 'clear',
  },
  'CfprApSdLduFsmStageName' => {
    '0' => 'nop',
    '258' => 'provisionLDUBegin',
    '259' => 'provisionLDUCheckBladeReadiness',
    '260' => 'provisionLDUWaitForAppsInstallation',
    '261' => 'provisionLDUWaitForLinkConfiguration',
    '262' => 'provisionLDUStartApps',
    '754' => 'provisionLDUFail',
    '755' => 'provisionLDUSuccess',
  },
  'CfprApCallhomePolicyAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricFlowMonIpv6Keys' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ipv6SrcAddress',
      '1' => 'ipv6DestAddress',
      '2' => 'ipProtocol',
      '3' => 'reserved',
      '4' => 'srcPort',
      '5' => 'destPort',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtExportPolicyProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApEquipmentLocatorLedFsmCurrentFsm' => {
    '0' => 'nop',
    '231' => 'setFeLocatorLed',
    '233' => 'setFiLocatorLed',
  },
  'CfprApSdSlotFsmCurrentFsm' => {
    '0' => 'nop',
    '276' => 'changePlatformLogLevel',
    '293' => 'formatDisk',
    '298' => 'synchTimeZone',
  },
  'CfprApStorageOperationType' => {
    '0' => 'reconstruction',
    '1' => 'relearning',
    '2' => 'patrolRead',
    '3' => 'consistencyCheck',
    '4' => 'rebuild',
    '5' => 'initialization',
  },
  'CfprApFabricVConMappingScheme' => {
    '2' => 'roundRobin',
    '3' => 'linearOrdered',
    '4' => 'roundRobinToLinearOrdered',
    '5' => 'linearOrderedToRoundRobin',
  },
  'CfprApAaaLdapGroupRuleAuthorization' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApEpqosDefinitionFsmStageName' => {
    '0' => 'nop',
    '384' => 'deployBegin',
    '385' => 'deployLocal',
    '386' => 'deployPeer',
    '574' => 'deployFail',
    '575' => 'deploySuccess',
  },
  'CfprApEtherErrStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'alignDelta',
      '1' => 'alignDeltaAvg',
      '2' => 'alignDeltaMax',
      '3' => 'alignDeltaMin',
      '4' => 'deferredTxDelta',
      '5' => 'deferredTxDeltaAvg',
      '6' => 'deferredTxDeltaMax',
      '7' => 'deferredTxDeltaMin',
      '8' => 'fcsDelta',
      '9' => 'fcsDeltaAvg',
      '10' => 'fcsDeltaMax',
      '11' => 'fcsDeltaMin',
      '12' => 'intMacRxDelta',
      '13' => 'intMacRxDeltaAvg',
      '14' => 'intMacRxDeltaMax',
      '15' => 'intMacRxDeltaMin',
      '16' => 'intMacTxDelta',
      '17' => 'intMacTxDeltaAvg',
      '18' => 'intMacTxDeltaMax',
      '19' => 'intMacTxDeltaMin',
      '20' => 'outDiscardDelta',
      '21' => 'outDiscardDeltaAvg',
      '22' => 'outDiscardDeltaMax',
      '23' => 'outDiscardDeltaMin',
      '24' => 'rcvDelta',
      '25' => 'rcvDeltaAvg',
      '26' => 'rcvDeltaMax',
      '27' => 'rcvDeltaMin',
      '28' => 'underSizeDelta',
      '29' => 'underSizeDeltaAvg',
      '30' => 'underSizeDeltaMax',
      '31' => 'underSizeDeltaMin',
      '32' => 'xmitDelta',
      '33' => 'xmitDeltaAvg',
      '34' => 'xmitDeltaMax',
      '35' => 'xmitDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherFtwPortPairMode' => {
    '0' => 'disabled',
    '1' => 'standby',
    '2' => 'bypass',
  },
  'CfprApIdentMetaSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '74' => 'sync',
    '77' => 'ucscUnivSync',
  },
  'CfprApFabricSubGroupConfigState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApVnicFcBaseType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApStorageFFDriveVisible' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApSysdebugTechSupportOperState' => {
    '0' => 'unavailable',
    '1' => 'available',
    '2' => 'availableOnSubordinate',
    '3' => 'inProgress',
    '4' => 'failed',
  },
  'CfprApAdaptorAdapterStatsTrafficDir' => {
    '0' => 'unknown',
    '1' => 'tx',
    '2' => 'rx',
  },
  'CfprApVnicVirtualizationPreferenceType' => {
    '0' => 'none',
    '2' => 'sriov',
    '3' => 'sriovVmfex',
    '4' => 'sriovUsnic',
    '5' => 'vmq',
  },
  'CfprApSwEthLanFlowMonitorTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaEpFsmTaskItem' => {
    '0' => 'nop',
    '349' => 'updateEp',
  },
  'CfprApFabricAVlanTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFcStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'packetsRxDelta',
      '9' => 'packetsRxDeltaAvg',
      '10' => 'packetsRxDeltaMax',
      '11' => 'packetsRxDeltaMin',
      '12' => 'packetsTxDelta',
      '13' => 'packetsTxDeltaAvg',
      '14' => 'packetsTxDeltaMax',
      '15' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricMonOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'error',
  },
  'CfprApIdentIdentRequestFsmCurrentFsm' => {
    '0' => 'nop',
    '72' => 'updateIdent',
  },
  'CfprApLicenseInstanceFsmCurrentFsm' => {
    '0' => 'nop',
    '153' => 'updateFlexlm',
  },
  'CfprApBiosBootDevOrder' => {
    '1' => 'n1',
    '2' => 'n2',
    '3' => 'n3',
    '4' => 'n4',
    '5' => 'n5',
    '6' => 'n6',
    '7' => 'n7',
  },
  'CfprApFabricSanPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageEpAccess' => {
    '1' => 'readonly',
    '2' => 'admin',
  },
  'CfprApPowerPsuState' => {
    '0' => 'ok',
    '1' => 'insufficient',
  },
  'CfprApAdaptorHostIfAdminState' => {
    '0' => 'enabled',
    '44' => 'resetConnectivityActive',
    '45' => 'resetConnectivityPassive',
    '46' => 'resetConnectivity',
    '47' => 'disabled',
    '48' => 'disabledPassive',
    '49' => 'disabledActive',
    '50' => 'enabledPassive',
    '51' => 'enabledActive',
  },
  'CfprApAdaptorMenloBaseErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'uncorrectableErrorsDelta',
      '5' => 'uncorrectableErrorsDeltaAvg',
      '6' => 'uncorrectableErrorsDeltaMax',
      '7' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSlotAdminState' => {
    '1' => 'acknowledged',
    '3' => 'reacknowledge',
  },
  'CfprApSmAppFsmStageName' => {
    '0' => 'nop',
    '79' => 'deleteBegin',
    '80' => 'deleteLocal',
    '83' => 'updateApplicationBegin',
    '84' => 'updateApplicationUpdate',
    '772' => 'deleteFail',
    '773' => 'deleteSuccess',
    '776' => 'updateApplicationFail',
    '777' => 'updateApplicationSuccess',
  },
  'CfprApNfsPurpose' => {
    '0' => 'image',
    '1' => 'backup',
  },
  'CfprApSwFcoeEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorReachability' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'a',
      '1' => 'b',
      '7' => 'unmanaged',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugTechSupportFsmTaskItem' => {
    '0' => 'nop',
    '366' => 'initiate',
    '368' => 'deleteTechSupFile',
    '371' => 'download',
  },
  'CfprApFirmwareCompleteness' => {
    '0' => 'partial',
    '1' => 'complete',
  },
  'CfprApMgmtIfFsmStageName' => {
    '0' => 'nop',
    '395' => 'swMgmtOobIfConfigBegin',
    '396' => 'swMgmtOobIfConfigSwitch',
    '397' => 'swMgmtInbandIfConfigBegin',
    '398' => 'swMgmtInbandIfConfigSwitch',
    '464' => 'virtualIfConfigBegin',
    '465' => 'virtualIfConfigLocal',
    '466' => 'virtualIfConfigRemote',
    '467' => 'enableVipBegin',
    '468' => 'enableVipLocal',
    '469' => 'disableVipBegin',
    '470' => 'disableVipPeer',
    '471' => 'enableHABegin',
    '472' => 'enableHALocal',
    '664' => 'disableVipFail',
    '665' => 'disableVipSuccess',
    '666' => 'enableHAFail',
    '667' => 'enableHASuccess',
    '668' => 'enableVipFail',
    '669' => 'enableVipSuccess',
    '670' => 'swMgmtInbandIfConfigFail',
    '671' => 'swMgmtInbandIfConfigSuccess',
    '672' => 'swMgmtOobIfConfigFail',
    '673' => 'swMgmtOobIfConfigSuccess',
    '674' => 'virtualIfConfigFail',
    '675' => 'virtualIfConfigSuccess',
  },
  'CfprApAdaptorMenloNetEgStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropCmdDelta',
      '1' => 'dropCmdDeltaAvg',
      '2' => 'dropCmdDeltaMax',
      '3' => 'dropCmdDeltaMin',
      '4' => 'dropLifCfgInvalidDelta',
      '5' => 'dropLifCfgInvalidDeltaAvg',
      '6' => 'dropLifCfgInvalidDeltaMax',
      '7' => 'dropLifCfgInvalidDeltaMin',
      '8' => 'dropLifMapNoHitDelta',
      '9' => 'dropLifMapNoHitDeltaAvg',
      '10' => 'dropLifMapNoHitDeltaMax',
      '11' => 'dropLifMapNoHitDeltaMin',
      '12' => 'dropSrcBindDelta',
      '13' => 'dropSrcBindDeltaAvg',
      '14' => 'dropSrcBindDeltaMax',
      '15' => 'dropSrcBindDeltaMin',
      '16' => 'learnReqDropDelta',
      '17' => 'learnReqDropDeltaAvg',
      '18' => 'learnReqDropDeltaMax',
      '19' => 'learnReqDropDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPsuInputSrc' => {
    '0' => 'unknown',
    '1' => 'n210AC50380DC',
    '2' => 'n110AC',
    '3' => 'undetermined',
    '4' => 'n115AC230AC',
  },
  'CfprApLsbootStorageType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
  },
  'CfprApComputeLinkAggregation' => {
    '0' => 'none',
    '1' => 'portChannel',
  },
  'CfprApSwPktCaptureLifeCycle' => {
    '1' => 'normal',
    '2' => 'new',
    '3' => 'deleted',
  },
  'CfprApAaaTacacsPlusEpFsmCurrentFsm' => {
    '0' => 'nop',
    '349' => 'updateEp',
  },
  'CfprApMgmtEntityProblems' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'leadership',
      '1' => 'membership',
      '2' => 'umbilical',
      '3' => 'haReady',
      '4' => 'versionMismatch',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApOrgSrcMask' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'local',
      '1' => 'global',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricAVlanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfOSBootWatchdogTimerTimeoutVpOSBootWatchdogTimerTimeout' => {
    '0' => 'platformRecommended',
    '155' => 'n5Minutes',
    '156' => 'n10Minutes',
    '157' => 'n15Minutes',
    '158' => 'n20Minutes',
  },
  'CfprApAaaRealm' => {
    '0' => 'local',
    '1' => 'radius',
    '2' => 'tacacs',
    '3' => 'ldap',
    '4' => 'none',
  },
  'CfprApAdaptorMenloFcErrorStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'popErrorsDelta',
      '5' => 'popErrorsDeltaAvg',
      '6' => 'popErrorsDeltaMax',
      '7' => 'popErrorsDeltaMin',
      '8' => 'pushErrorsDelta',
      '9' => 'pushErrorsDeltaAvg',
      '10' => 'pushErrorsDeltaMax',
      '11' => 'pushErrorsDeltaMin',
      '12' => 'uncorrectableErrorsDelta',
      '13' => 'uncorrectableErrorsDeltaAvg',
      '14' => 'uncorrectableErrorsDeltaMax',
      '15' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsbootSanAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CfprApVmStatus' => {
    '0' => 'unknown',
    '1' => 'online',
    '2' => 'offline',
  },
  'CfprApHostimgDistribution' => {
    '0' => 'unknown',
    '1' => 'fedora',
  },
  'CfprApFabricNetflowMonitorFlowMonProtocol' => {
    '1' => 'netflow',
  },
  'CfprApBiosVfConsoleRedirectionVpFlowControl' => {
    '0' => 'platformRecommended',
    '108' => 'none',
    '109' => 'rtsCts',
  },
  'CfprApMgmtImporterFsmTaskItem' => {
    '0' => 'nop',
    '476' => 'import',
  },
  'CfprApBiosVfOnboardSATAControllerVpOnboardSATAController' => {
    '0' => 'platformRecommended',
    '78' => 'disabled',
    '79' => 'enabled',
  },
  'CfprApFcStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'packetsRxDelta',
      '9' => 'packetsRxDeltaAvg',
      '10' => 'packetsRxDeltaMax',
      '11' => 'packetsRxDeltaMin',
      '12' => 'packetsTxDelta',
      '13' => 'packetsTxDeltaAvg',
      '14' => 'packetsTxDeltaMax',
      '15' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVmHbaType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApFirmwareUpdatableDeployment' => {
    '0' => 'unspecified',
    '4' => 'backup',
  },
  'CfprApEquipmentChassisStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inletTemp1',
      '8' => 'inputPower',
      '9' => 'inputPowerAvg',
      '10' => 'inputPowerMax',
      '11' => 'inputPowerMin',
      '12' => 'outletTemp1',
      '13' => 'outletTemp1Avg',
      '14' => 'outletTemp1Max',
      '15' => 'outletTemp1Min',
      '16' => 'outletTemp2',
      '17' => 'outletTemp2Avg',
      '18' => 'outletTemp2Max',
      '19' => 'outletTemp2Min',
      '20' => 'outputPower',
      '21' => 'outputPowerAvg',
      '22' => 'outputPowerMax',
      '23' => 'outputPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorEthPortOutsizedStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'oversizedBadCrcPacketsDelta',
      '1' => 'oversizedBadCrcPacketsDeltaAvg',
      '2' => 'oversizedBadCrcPacketsDeltaMax',
      '3' => 'oversizedBadCrcPacketsDeltaMin',
      '4' => 'oversizedGoodCrcPacketsDelta',
      '5' => 'oversizedGoodCrcPacketsDeltaAvg',
      '6' => 'oversizedGoodCrcPacketsDeltaMax',
      '7' => 'oversizedGoodCrcPacketsDeltaMin',
      '8' => 'oversizedPacketsDelta',
      '9' => 'oversizedPacketsDeltaAvg',
      '10' => 'oversizedPacketsDeltaMax',
      '11' => 'oversizedPacketsDeltaMin',
      '12' => 'undersizedBadCrcPacketsDelta',
      '13' => 'undersizedBadCrcPacketsDeltaAvg',
      '14' => 'undersizedBadCrcPacketsDeltaMax',
      '15' => 'undersizedBadCrcPacketsDeltaMin',
      '16' => 'undersizedGoodCrcPacketsDelta',
      '17' => 'undersizedGoodCrcPacketsDeltaAvg',
      '18' => 'undersizedGoodCrcPacketsDeltaMax',
      '19' => 'undersizedGoodCrcPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricLanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApObserveObservedFsmCurrentFsm' => {
    '0' => 'nop',
    '239' => 'resolvePolicyFsm',
    '241' => 'resolveResourceFsm',
    '243' => 'resolveVMFsm',
    '245' => 'resolveControllerFsm',
  },
  'CfprApComputePhysicalFsmCurrentFsm' => {
    '0' => 'nop',
    '208' => 'swConnUpd',
    '213' => 'serviceInfraDeploy',
    '216' => 'serviceInfraWithdraw',
  },
  'CfprApBiosVfMaximumMemoryBelow4GBVpMaximumMemoryBelow4GB' => {
    '0' => 'platformRecommended',
    '88' => 'disabled',
    '89' => 'enabled',
  },
  'CfprApPolicyControlEpFsmStageName' => {
    '0' => 'nop',
    '502' => 'operateBegin',
    '503' => 'operateResolve',
    '698' => 'operateFail',
    '699' => 'operateSuccess',
  },
  'CfprApFabricAFcEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStatsThrFloatDefinitionPropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CfprApStorageFFRWType' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
  },
  'CfprApSdAppLduLinkFsmCurrentFsm' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatus',
  },
  'CfprApComputeServerDiscPolicyFsmStageName' => {
    '0' => 'nop',
    '1' => 'resolveScrubPolicyBegin',
    '2' => 'resolveScrubPolicyResolve',
    '570' => 'resolveScrubPolicyFail',
    '571' => 'resolveScrubPolicySuccess',
  },
  'CfprApFabricVConTransportPref' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fc',
      '1' => 'ethernet',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfSparingModeVpSparingMode' => {
    '0' => 'platformRecommended',
    '68' => 'dimmSparing',
    '69' => 'rankSparing',
  },
  'CfprApSdLinkOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
  },
  'CfprApFirmwareDependencyRelationship' => {
    '0' => 'special',
    '1' => 'ancestor',
    '2' => 'descendent',
  },
  'CfprApStorageOperatingModeType' => {
    '0' => 'unknown',
    '1' => 'mirror',
    '2' => 'util',
  },
  'CfprApFirmwareDownloaderFsmTaskItem' => {
    '0' => 'nop',
    '6' => 'download',
  },
  'CfprApInitiatorIScsiInitiatorEpProt' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CfprApCapabilityFeatureStatus' => {
    '0' => 'supported',
    '1' => 'unsupported',
  },
  'CfprApVmAdaptorOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '8' => 'connPolicy',
  },
  'CfprApSwSspEthMonSrcPhyEpFsmCurrentFsm' => {
    '0' => 'nop',
    '445' => 'delete',
  },
  'CfprApStorageIniGroupOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '8' => 'connPolicy',
  },
  'CfprApSwBorderDomainLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricTrafficDirection' => {
    '1' => 'rx',
    '2' => 'tx',
    '3' => 'both',
  },
  'CfprApPortPIoFsmTaskItem' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresence',
    '237' => 'inCompatSfpReplaced',
  },
  'CfprApFabricFcMonFiltEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApHostagEvent' => {
    '0' => 'none',
  },
  'CfprApDiagFailureAction' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'techSupport',
      '1' => 'waitDebug',
      '2' => 'skipRemaining',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugManualCoreFileExportTargetAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApBiosVfIntelVTForDirectedIOVpIntelVTForDirectedIO' => {
    '0' => 'platformRecommended',
    '52' => 'disabled',
    '53' => 'enabled',
  },
  'CfprApPolicyControlEpFsmTaskItem' => {
    '0' => 'nop',
    '502' => 'operate',
  },
  'CfprApBiosVfInterleaveConfigurationVpChannelInterleaving' => {
    '0' => 'platformRecommended',
    '7' => 'auto',
    '8' => 'n1Way',
    '9' => 'n2Way',
    '10' => 'n3Way',
    '11' => 'n4Way',
  },
  'CfprApExtvmmFabricNetworkType' => {
    '0' => 'notConnected',
    '1' => 'notConnectedPvlans',
    '2' => 'connected',
  },
  'CfprApSwTargetEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwarePackMode' => {
    '0' => 'staged',
    '1' => 'oneShot',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpPCIeSlotN1OptionROM' => {
    '0' => 'platformRecommended',
    '224' => 'disabled',
    '225' => 'enabled',
    '226' => 'uefiOnly',
    '227' => 'legacyOnly',
  },
  'CfprApMgmtImportAction' => {
    '0' => 'replace',
  },
  'CfprApEquipmentIOCardBaseFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '20' => 'samDmeEquipmentIOCardBaseFePresenceUcsConfig',
      '21' => 'samDmeEquipmentIOCardBaseFePresenceMiniUcsConfig',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorEthRoCEProfileAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApNfsMntAdminState' => {
    '0' => 'none',
    '1' => 'unmount',
    '2' => 'mount',
    '3' => 'remount',
  },
  'CfprApMgmtIPv6IfAddrFsmTaskItem' => {
    '0' => 'nop',
    '399' => 'swMgmtOobIpv6IfConfig',
  },
  'CfprApLsbootSanType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
  },
  'CfprApAdaptorHostVisibility' => {
    '0' => 'no',
    '1' => 'yes',
    '2' => 'osDependent',
  },
  'CfprApExtpolRegistryFsmStageName' => {
    '0' => 'nop',
    '319' => 'crossDomainConfigBegin',
    '320' => 'crossDomainConfigSetLocal',
    '321' => 'crossDomainConfigSetPeer',
    '322' => 'crossDomainDeleteBegin',
    '323' => 'crossDomainDeleteSetLocal',
    '324' => 'crossDomainDeleteSetPeer',
    '600' => 'crossDomainConfigFail',
    '601' => 'crossDomainConfigSuccess',
    '602' => 'crossDomainDeleteFail',
    '603' => 'crossDomainDeleteSuccess',
  },
  'CfprApAaaEpFsmCurrentFsm' => {
    '0' => 'nop',
    '349' => 'updateEp',
  },
  'CfprApAdaptorExtEthIfPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageLinkSpeed' => {
    '0' => 'unknown',
    '1' => 'n15Gbps',
    '2' => 'n3Gbps',
    '3' => 'n6Gbps',
    '4' => 'n12Gbps',
  },
  'CfprApSwEthMonDestEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfIntelTurboBoostTechVpIntelTurboBoostTech' => {
    '0' => 'platformRecommended',
    '1' => 'disabled',
    '2' => 'enabled',
  },
  'CfprApVmOsHvVendor' => {
    '0' => 'unspecified',
    '1' => 'vmware',
    '2' => 'redhat',
    '3' => 'microsoft',
    '4' => 'novell',
    '5' => 'oracle',
    '6' => 'citrix',
  },
  'CfprApStorageReadType' => {
    '0' => 'unknown',
    '1' => 'readAhead',
    '2' => 'normal',
  },
  'CfprApComputeBladeFsmTaskItem' => {
    '0' => 'nop',
    '186' => 'diag',
  },
  'CfprApMgmtIfFsmTaskItem' => {
    '0' => 'nop',
    '395' => 'swMgmtOobIfConfig',
    '397' => 'swMgmtInbandIfConfig',
    '464' => 'virtualIfConfig',
    '467' => 'enableVip',
    '469' => 'disableVip',
    '471' => 'enableHA',
  },
  'CfprApAdaptorVnicStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'droppedRxDelta',
      '9' => 'droppedRxDeltaAvg',
      '10' => 'droppedRxDeltaMax',
      '11' => 'droppedRxDeltaMin',
      '12' => 'droppedTxDelta',
      '13' => 'droppedTxDeltaAvg',
      '14' => 'droppedTxDeltaMax',
      '15' => 'droppedTxDeltaMin',
      '16' => 'errorsRxDelta',
      '17' => 'errorsRxDeltaAvg',
      '18' => 'errorsRxDeltaMax',
      '19' => 'errorsRxDeltaMin',
      '20' => 'errorsTxDelta',
      '21' => 'errorsTxDeltaAvg',
      '22' => 'errorsTxDeltaMax',
      '23' => 'errorsTxDeltaMin',
      '24' => 'packetsRxDelta',
      '25' => 'packetsRxDeltaAvg',
      '26' => 'packetsRxDeltaMax',
      '27' => 'packetsRxDeltaMin',
      '28' => 'packetsTxDelta',
      '29' => 'packetsTxDeltaAvg',
      '30' => 'packetsTxDeltaMax',
      '31' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwSanEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsComputeBindingOperState' => {
    '0' => 'unused',
    '1' => 'used',
    '2' => 'failedToApply',
  },
  'CfprApDcxOperState' => {
    '0' => 'unknown',
    '1' => 'adminDown',
    '2' => 'linkDown',
    '3' => 'error',
    '4' => 'active',
    '5' => 'passive',
  },
  'CfprApBiosVfResumeOnACPowerLossVpResumeOnACPowerLoss' => {
    '0' => 'platformRecommended',
    '100' => 'stayOff',
    '101' => 'lastState',
    '102' => 'reset',
  },
  'CfprApFabricFcSanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwFcZoneMemberLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CfprApFabricSanEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeIOHubEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMemoryBufferUnitEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorFcIfEventStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'invalidCRCCountDelta',
      '1' => 'invalidCRCCountDeltaAvg',
      '2' => 'invalidCRCCountDeltaMax',
      '3' => 'invalidCRCCountDeltaMin',
      '4' => 'linkFailureCountDelta',
      '5' => 'linkFailureCountDeltaAvg',
      '6' => 'linkFailureCountDeltaMax',
      '7' => 'linkFailureCountDeltaMin',
      '8' => 'lipCountDelta',
      '9' => 'lipCountDeltaAvg',
      '10' => 'lipCountDeltaMax',
      '11' => 'lipCountDeltaMin',
      '12' => 'lossOfSignalCountDelta',
      '13' => 'lossOfSignalCountDeltaAvg',
      '14' => 'lossOfSignalCountDeltaMax',
      '15' => 'lossOfSignalCountDeltaMin',
      '16' => 'lossOfSyncCountDelta',
      '17' => 'lossOfSyncCountDeltaAvg',
      '18' => 'lossOfSyncCountDeltaMax',
      '19' => 'lossOfSyncCountDeltaMin',
      '20' => 'nOSCountDelta',
      '21' => 'nOSCountDeltaAvg',
      '22' => 'nOSCountDeltaMax',
      '23' => 'nOSCountDeltaMin',
      '24' => 'secondsSinceLastResetDelta',
      '25' => 'secondsSinceLastResetDeltaAvg',
      '26' => 'secondsSinceLastResetDeltaMax',
      '27' => 'secondsSinceLastResetDeltaMin',
      '28' => 'seqProtocolErrCountDelta',
      '29' => 'seqProtocolErrCountDeltaAvg',
      '30' => 'seqProtocolErrCountDeltaMax',
      '31' => 'seqProtocolErrCountDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricTargetStatus' => {
    '0' => 'valid',
    '1' => 'invalid',
  },
  'CfprApMgmtDimmBlacklistingOperState' => {
    '0' => 'unknown',
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'unsupported',
  },
  'CfprApFabricSwitchingMode' => {
    '0' => 'endHost',
    '1' => 'switch',
    '2' => 'securityNode',
  },
  'CfprApFabricEthVlanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot8State' => {
    '0' => 'platformRecommended',
    '202' => 'disabled',
    '203' => 'enabled',
    '204' => 'uefiOnly',
    '205' => 'legacyOnly',
  },
  'CfprApFabricLacpSuspend' => {
    '0' => 'false',
    '1' => 'true',
  },
  'CfprApFabricEthEstcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLicenseType' => {
    '0' => 'increment',
    '1' => 'upgrade',
    '2' => 'feature',
  },
  'CfprApQosclassDefinitionFsmCurrentFsm' => {
    '0' => 'nop',
    '390' => 'configGlobalQoS',
  },
  'CfprApMgmtImporterFsmCurrentFsm' => {
    '0' => 'nop',
    '476' => 'import',
  },
  'CfprApOsOsMode' => {
    '0' => 'normal',
    '1' => 'failsafe',
  },
  'CfprApSdLogicalDeviceFsmCurrentFsm' => {
    '0' => 'nop',
    '283' => 'configureLinks',
  },
  'CfprApFirmwarePlatformType' => {
    '0' => 'ucs',
    '1' => 'ucsMini',
    '2' => 'sspBakerstreet',
    '3' => 'fpr2100',
  },
  'CfprApPowerPsuLineMode' => {
    '0' => 'unknown',
    '1' => 'undetermined',
    '2' => 'highLine',
    '3' => 'lowLine',
    '4' => 'mixedLine',
    '5' => 'lowerLine',
  },
  'CfprApEquipmentNetworkElementFanStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'drivePercentage',
      '1' => 'drivePercentageAvg',
      '2' => 'drivePercentageMax',
      '3' => 'drivePercentageMin',
      '4' => 'speed',
      '5' => 'speedAvg',
      '6' => 'speedMax',
      '7' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaNoRolePolicy' => {
    '0' => 'noLogin',
    '1' => 'assignDefaultRole',
  },
  'CfprApBiosVfOSBootWatchdogTimerVpOSBootWatchdogTimer' => {
    '0' => 'platformRecommended',
    '151' => 'disabled',
    '152' => 'enabled',
  },
  'CfprApStorageControllerForm' => {
    '0' => 'none',
    '1' => 'onBoard',
    '2' => 'mezzanine',
    '3' => 'pci',
    '4' => 'embedded',
  },
  'CfprApBiosVfNUMAOptimizedVpNUMAOptimized' => {
    '0' => 'platformRecommended',
    '72' => 'disabled',
    '73' => 'enabled',
  },
  'CfprApBiosVfProcessorEnergyConfigurationVpEnergyPerformance' => {
    '0' => 'platformRecommended',
    '337' => 'performance',
    '338' => 'balancedPerformance',
    '339' => 'balancedEnergy',
    '340' => 'energyEfficient',
  },
  'CfprApFabricADceSwSrvEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorInterruptMode' => {
    '1' => 'msiX',
    '2' => 'msi',
    '3' => 'intx',
  },
  'CfprApBiosVfUSBSysIdlePowerOptimizingSettingVpUSBIdlePowerOptimize' => {
    '0' => 'platformRecommended',
    '287' => 'highPerformance',
    '288' => 'lowerIdlePower',
  },
  'CfprApSmAppInstanceFsmTaskItem' => {
    '0' => 'nop',
    '85' => 'resetApplication',
  },
  'CfprApLsAgentMode' => {
    '1' => 'noAgent',
    '2' => 'readOnly',
    '4' => 'full',
  },
  'CfprApLicenseDebugFlag' => {
    '0' => 'error',
    '1' => 'debug',
    '2' => 'trace',
    '3' => 'all',
  },
  'CfprApEquipmentIOCardFsmCurrentFsm' => {
    '0' => 'nop',
    '211' => 'resetIom',
    '219' => 'fePresence',
    '222' => 'feConn',
  },
  'CfprApFabricSanCloudFsmTaskItem' => {
    '0' => 'nop',
    '452' => 'switchMode',
  },
  'CfprApFirmwareImageState' => {
    '0' => 'ready',
    '1' => 'scheduled',
    '2' => 'updating',
    '3' => 'activating',
    '4' => 'failed',
    '5' => 'setStartup',
    '6' => 'rebooting',
    '7' => 'pendingNextBoot',
    '8' => 'throttled',
    '9' => 'upgrading',
    '10' => 'autoUpdating',
    '11' => 'autoActivating',
    '12' => 'pendingPowerCycle',
    '13' => 'badImage',
    '14' => 'rebuilding',
  },
  'CfprApLicenseDownloaderFsmCurrentFsm' => {
    '0' => 'nop',
    '140' => 'download',
  },
  'CfprApSysdebugLogExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '360' => 'configure',
  },
  'CfprApFirmwarePlatformPackFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '3' => 'samDmeFirmwarePlatformPackPlatformVersionInitRestore',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareDownloadActivity' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CfprApCapabilityUpdaterFsmTaskItem' => {
    '0' => 'nop',
    '413' => 'updater',
  },
  'CfprApNfsMountInstFsmTaskItem' => {
    '0' => 'nop',
    '486' => 'mount',
    '491' => 'unmount',
  },
  'CfprApEquipmentRemovalConditions' => {
    '0' => 'unknown',
    '2' => 'notApplicable',
    '3' => 'removableWhenOff',
    '4' => 'removableWhenOnOrOff',
  },
  'CfprApFirmwareSystemFsmCurrentFsm' => {
    '0' => 'nop',
    '37' => 'deploy',
    '67' => 'applyCatalogPack',
  },
  'CfprApEquipmentPortAttribute' => {
    '0' => 'none',
    '1' => 'scalability',
  },
  'CfprApBiosVfCPUPerformanceVpCPUPerformance' => {
    '0' => 'platformRecommended',
    '282' => 'enterprise',
    '283' => 'highThroughput',
    '284' => 'hpc',
  },
  'CfprApFabricAEthLanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStatsReportingInterval' => {
    '120' => 'n2minutes',
    '900' => 'n15minutes',
    '1800' => 'n30minutes',
    '3600' => 'n60minutes',
    '7200' => 'n2hours',
    '14400' => 'n4hours',
    '28800' => 'n8hours',
  },
  'CfprApAaaSessionState' => {
    '0' => 'active',
    '1' => 'inactive',
  },
  'CfprApTrigAckChanges' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'serverIdentity',
      '1' => 'storage',
      '2' => 'networking',
      '3' => 'vnicVhbaPlacement',
      '4' => 'bootOrder',
      '5' => 'serverAssignment',
      '6' => 'operationalPolicies',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorMenloHostPortStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxPauseCFCDelta',
      '1' => 'rxPauseCFCDeltaAvg',
      '2' => 'rxPauseCFCDeltaMax',
      '3' => 'rxPauseCFCDeltaMin',
      '4' => 'rxPausePFCDelta',
      '5' => 'rxPausePFCDeltaAvg',
      '6' => 'rxPausePFCDeltaMax',
      '7' => 'rxPausePFCDeltaMin',
      '8' => 'txPauseCFCDelta',
      '9' => 'txPauseCFCDeltaAvg',
      '10' => 'txPauseCFCDeltaMax',
      '11' => 'txPauseCFCDeltaMin',
      '12' => 'txPausePFCDelta',
      '13' => 'txPausePFCDeltaAvg',
      '14' => 'txPausePFCDeltaMax',
      '15' => 'txPausePFCDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwNetflowMonitorProtocol' => {
    '1' => 'netflow',
  },
  'CfprApFabricReqIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'permitUnresolved',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmLogicalDeviceMode' => {
    '0' => 'unknown',
    '1' => 'clustered',
    '2' => 'standalone',
    '3' => 'none',
  },
  'CfprApEquipmentRackUnitPsuStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'inputPower',
      '5' => 'inputPowerAvg',
      '6' => 'inputPowerMax',
      '7' => 'inputPowerMin',
      '8' => 'inputVoltage',
      '9' => 'inputVoltageAvg',
      '10' => 'inputVoltageMax',
      '11' => 'inputVoltageMin',
      '12' => 'outputCurrent',
      '13' => 'outputCurrentAvg',
      '14' => 'outputCurrentMax',
      '15' => 'outputCurrentMin',
      '16' => 'outputPower',
      '17' => 'outputPowerAvg',
      '18' => 'outputPowerMax',
      '19' => 'outputPowerMin',
      '20' => 'outputVoltage',
      '21' => 'outputVoltageAvg',
      '22' => 'outputVoltageMax',
      '23' => 'outputVoltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApQosclassDefinitionFsmTaskItem' => {
    '0' => 'nop',
    '390' => 'configGlobalQoS',
  },
  'CfprApAaaPwdPolicy' => {
    '0' => 'enable',
    '1' => 'disable',
  },
  'CfprApSwCardEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'slotOutlet1',
      '1' => 'slotOutlet1Avg',
      '2' => 'slotOutlet1Max',
      '3' => 'slotOutlet1Min',
      '4' => 'slotOutlet2',
      '5' => 'slotOutlet2Avg',
      '6' => 'slotOutlet2Max',
      '7' => 'slotOutlet2Min',
      '8' => 'slotOutlet3',
      '9' => 'slotOutlet3Avg',
      '10' => 'slotOutlet3Max',
      '11' => 'slotOutlet3Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaExtMgmtAccess' => {
    '1' => 'kvm',
  },
  'CfprApSysdebugLogControlDomainEnum' => {
    '0' => 'sysmgmt',
  },
  'CfprApFabricFlowMonDefType' => {
    '1' => 'systemDefined',
    '2' => 'userDefined',
  },
  'CfprApBiosVfLocalX2ApicVpLocalX2Apic' => {
    '0' => 'platformRecommended',
    '26' => 'xapic',
    '27' => 'x2apic',
    '28' => 'auto',
  },
  'CfprApSdLinkFsmTaskItem' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatus',
  },
  'CfprApSysdebugCoreFsmTaskItem' => {
    '0' => 'nop',
    '376' => 'download',
  },
  'CfprApCapabilityCatalogueFsmStageName' => {
    '0' => 'nop',
    '421' => 'activateCatalogBegin',
    '422' => 'activateCatalogCopyCatFromRep',
    '423' => 'activateCatalogUnpackLocal',
    '424' => 'activateCatalogCopyExternalRepToRemote',
    '425' => 'activateCatalogCopyRemote',
    '426' => 'activateCatalogApplyCatalog',
    '427' => 'activateCatalogRescanImages',
    '428' => 'activateCatalogEvaluateStatus',
    '435' => 'deployCatalogueBegin',
    '436' => 'deployCatalogueSyncPortAGLocal',
    '437' => 'deployCatalogueSyncPortAGRemote',
    '438' => 'deployCatalogueFinalize',
    '552' => 'activateCatalogFail',
    '553' => 'activateCatalogSuccess',
    '554' => 'deployCatalogueFail',
    '555' => 'deployCatalogueSuccess',
  },
  'CfprApAaaTacacsPlusEpFsmStageName' => {
    '0' => 'nop',
    '349' => 'updateEpBegin',
    '350' => 'updateEpSetEpLocal',
    '351' => 'updateEpSetEpPeer',
    '536' => 'updateEpFail',
    '537' => 'updateEpSuccess',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot3LinkSpeed' => {
    '0' => 'platformRecommended',
    '242' => 'gen1',
    '243' => 'gen2',
    '244' => 'gen3',
    '245' => 'auto',
    '246' => 'disabled',
  },
  'CfprApFabricEstcPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApProcessorQualArch' => {
    '0' => 'any',
    '1' => 'intelP4C',
    '132' => 'opteron',
    '134' => 'turion64',
    '135' => 'dualCoreOpteron',
    '178' => 'pentium4',
    '179' => 'xeon',
    '181' => 'xeonMP',
  },
  'CfprApComputeAssociation' => {
    '0' => 'none',
    '1' => 'establishing',
    '2' => 'associated',
    '3' => 'removing',
    '4' => 'failed',
    '5' => 'throttled',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpPCIeSlotN2OptionROM' => {
    '0' => 'platformRecommended',
    '228' => 'disabled',
    '229' => 'enabled',
    '230' => 'uefiOnly',
    '231' => 'legacyOnly',
  },
  'CfprApMgmtUpgradeStatus' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'hwChangeDetected',
      '1' => 'fwChangeDetected',
      '2' => 'hwIncompatible',
      '3' => 'fwIncompatible',
      '4' => 'unsupportedHwVersion',
      '5' => 'unsupportedFwVersion',
      '6' => 'hwChangeSuccess',
      '7' => 'fwChangeSuccess',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentBoardAggregationRole' => {
    '0' => 'none',
    '1' => 'single',
    '2' => 'multiMaster',
    '3' => 'multiSlave',
  },
  'CfprApFirmwareInfraPackFsmTaskItem' => {
    '0' => 'nop',
    '828' => 'infraVersion',
  },
  'CfprApMgmtExportPolicyFsmStageName' => {
    '0' => 'nop',
    '460' => 'reportConfigCopyBegin',
    '461' => 'reportConfigCopyReport',
    '660' => 'reportConfigCopyFail',
    '661' => 'reportConfigCopySuccess',
  },
  'CfprApLsbootVirtualMediaType' => {
    '1' => 'virtualMedia',
    '2' => 'storage',
    '3' => 'lan',
    '4' => 'iscsi',
    '5' => 'san',
  },
  'CfprApAdaptorHostMgmtCapPreboot' => {
    '0' => 'none',
    '1' => 'pnuOS',
    '2' => 'efi',
  },
  'CfprApSwEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fanCtrlrInlet1',
      '1' => 'fanCtrlrInlet1Avg',
      '2' => 'fanCtrlrInlet1Max',
      '3' => 'fanCtrlrInlet1Min',
      '4' => 'fanCtrlrInlet2',
      '5' => 'fanCtrlrInlet2Avg',
      '6' => 'fanCtrlrInlet2Max',
      '7' => 'fanCtrlrInlet2Min',
      '8' => 'fanCtrlrInlet3',
      '9' => 'fanCtrlrInlet3Avg',
      '10' => 'fanCtrlrInlet3Max',
      '11' => 'fanCtrlrInlet3Min',
      '12' => 'fanCtrlrInlet4',
      '13' => 'fanCtrlrInlet4Avg',
      '14' => 'fanCtrlrInlet4Max',
      '15' => 'fanCtrlrInlet4Min',
      '16' => 'mainBoardOutlet1',
      '17' => 'mainBoardOutlet1Avg',
      '18' => 'mainBoardOutlet1Max',
      '19' => 'mainBoardOutlet1Min',
      '20' => 'mainBoardOutlet2',
      '21' => 'mainBoardOutlet2Avg',
      '22' => 'mainBoardOutlet2Max',
      '23' => 'mainBoardOutlet2Min',
      '24' => 'psuCtrlrInlet1',
      '25' => 'psuCtrlrInlet1Avg',
      '26' => 'psuCtrlrInlet1Max',
      '27' => 'psuCtrlrInlet1Min',
      '28' => 'psuCtrlrInlet2',
      '29' => 'psuCtrlrInlet2Avg',
      '30' => 'psuCtrlrInlet2Max',
      '31' => 'psuCtrlrInlet2Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfQPILinkFrequencySelectVpQPILinkFrequencySelect' => {
    '0' => 'platformRecommended',
    '350' => 'n6400',
    '351' => 'n7200',
    '352' => 'n8000',
    '353' => 'auto',
  },
  'CfprApConditionSeverity' => {
    '0' => 'cleared',
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
  },
  'CfprApCommSyslogSourceEvents' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApAdaptorMgmtCapRebootActionOnDestructive' => {
    '0' => 'none',
    '1' => 'host',
    '2' => 'adaptor',
  },
  'CfprApEtherFcoeInterfaceStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'droppedRxDelta',
      '9' => 'droppedRxDeltaAvg',
      '10' => 'droppedRxDeltaMax',
      '11' => 'droppedRxDeltaMin',
      '12' => 'droppedTxDelta',
      '13' => 'droppedTxDeltaAvg',
      '14' => 'droppedTxDeltaMax',
      '15' => 'droppedTxDeltaMin',
      '16' => 'errorsRxDelta',
      '17' => 'errorsRxDeltaAvg',
      '18' => 'errorsRxDeltaMax',
      '19' => 'errorsRxDeltaMin',
      '20' => 'errorsTxDelta',
      '21' => 'errorsTxDeltaAvg',
      '22' => 'errorsTxDeltaMax',
      '23' => 'errorsTxDeltaMin',
      '24' => 'packetsRxDelta',
      '25' => 'packetsRxDeltaAvg',
      '26' => 'packetsRxDeltaMax',
      '27' => 'packetsRxDeltaMin',
      '28' => 'packetsTxDelta',
      '29' => 'packetsTxDeltaAvg',
      '30' => 'packetsTxDeltaMax',
      '31' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPolicyControlledTypeFsmStageName' => {
    '0' => 'nop',
    '504' => 'operateBegin',
    '505' => 'operateResolveAll',
    '700' => 'operateFail',
    '701' => 'operateSuccess',
  },
  'CfprApFcpoolInitiatorsPurpose' => {
    '0' => 'nodeAndPortWwnAssignment',
    '1' => 'portWwnAssignment',
    '2' => 'nodeWwnAssignment',
  },
  'CfprApFabricInternalLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBmcSELCntStatsClassId' => {
    '0' => 'unspecified',
    '544' => 'computePCIeFatalProtocolStats',
    '545' => 'computePCIeFatalReceiveStats',
    '546' => 'computePCIeFatalCompletionStats',
    '547' => 'computePCIeFatalStats',
    '941' => 'memoryErrorStats',
    '1511' => 'processorErrorStats',
  },
  'CfprApCommSyslogClientEnum' => {
    '1' => 'primary',
    '2' => 'secondary',
    '3' => 'tertiary',
  },
  'CfprApComputeAdminTrigger' => {
    '0' => 'undiscovered',
    '1' => 'rediscover',
    '2' => 'resetToFactory',
    '3' => 'discovered',
    '4' => 'remove',
    '5' => 'migrate',
    '6' => 'decommission',
    '7' => 'upgradeFirmware',
  },
  'CfprApConditionRemoteInvRslt' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'failure',
      '1' => 'unidentifiedFail',
      '2' => 'internalError',
      '3' => 'timeout',
      '4' => 'endPointUnavailable',
      '5' => 'endPointFailed',
      '6' => 'endPointProtocolError',
      '7' => 'swDefect',
      '8' => 'fwDefect',
      '9' => 'hwDefect',
      '10' => 'resourceUnavailable',
      '11' => 'resourceCapacityExceeded',
      '12' => 'resourceDependency',
      '13' => 'capabilityNotImplementedIgnore',
      '14' => 'capabilityNotImplementedFailure',
      '15' => 'capabilityNotSupported',
      '16' => 'capabilityUnavailable',
      '17' => 'serviceNotImplementedIgnore',
      '18' => 'serviceNotImplementedFail',
      '19' => 'serviceNotSupported',
      '20' => 'serviceUnavailable',
      '21' => 'serviceProtocolError',
      '22' => 'fruIdentityIndeterminate',
      '23' => 'fruInfoMalformed',
      '24' => 'illegalFru',
      '25' => 'fruStateIndeterminate',
      '26' => 'fruNotReady',
      '27' => 'extendTimeout',
      '28' => 'taskReset',
      '29' => 'fruNotSupported',
      '30' => 'intermittentError',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorExtEthIfFsmCurrentFsm' => {
    '0' => 'nop',
    '127' => 'pathReset',
  },
  'CfprApEquipmentUnifiedPortAlgorithm' => {
    '0' => 'none',
    '1' => 'slideRuleEthFirstDoubleRow',
    '2' => 'unrestricted',
    '3' => 'slideRuleEthFirstSingleRow',
    '4' => 'slideRuleFcFirstDoubleRow',
    '5' => 'slideRuleFcFirstSingleRow',
  },
  'CfprApSwEthLanBorderFsmCurrentFsm' => {
    '0' => 'nop',
    '97' => 'deploy',
  },
  'CfprApAdaptorPurpose' => {
    '0' => 'unused',
    '1' => 'general',
    '2' => 'management',
    '3' => 'utility',
  },
  'CfprApFabricFcMonDestEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsbootSanCatSanImageType' => {
    '0' => 'primary',
    '1' => 'secondary',
  },
  'CfprApFabricEthMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysfileExporterPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CfprApFabricEthLanTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsmaintAckDisr' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'upTime',
      '1' => 'acPowerCycle',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricVlanSharingType' => {
    '0' => 'none',
    '1' => 'primary',
    '2' => 'isolated',
    '3' => 'community',
  },
  'CfprApDomainFeatureType' => {
    '0' => 'major',
    '1' => 'minor',
  },
  'CfprApCallhomeFormat' => {
    '1' => 'xml',
    '2' => 'fullTxt',
    '4' => 'shortTxt',
  },
  'CfprApEquipmentTpmType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'virtual',
  },
  'CfprApEquipmentIOCardFsmStageName' => {
    '0' => 'nop',
    '211' => 'resetIomBegin',
    '212' => 'resetIomExecute',
    '219' => 'fePresenceBegin',
    '220' => 'fePresenceCheckLicense',
    '221' => 'fePresenceIdentify',
    '222' => 'feConnBegin',
    '223' => 'feConnConfigureSwMgmtEndPoint',
    '224' => 'feConnConfigureVifNs',
    '580' => 'feConnFail',
    '581' => 'feConnSuccess',
    '582' => 'fePresenceFail',
    '583' => 'fePresenceSuccess',
    '584' => 'resetIomFail',
    '585' => 'resetIomSuccess',
  },
  'CfprApAdaptorLinkState' => {
    '0' => 'unknown',
    '1' => 'adminDown',
    '2' => 'down',
    '3' => 'error',
    '4' => 'up',
    '5' => 'unallocated',
    '6' => 'unavailable',
  },
  'CfprApSwEthLanFlowMonFsmCurrentFsm' => {
    '0' => 'nop',
    '104' => 'deploy',
  },
  'CfprApStorageProtocol' => {
    '0' => 'derived',
    '1' => 'fc',
    '2' => 'iscsi',
  },
  'CfprApAdaptorEthArfsProfileAccelaratedRFS' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApCapabilityOperStatus' => {
    '0' => 'init',
    '1' => 'downloading',
    '2' => 'downloaded',
    '3' => 'applied',
    '4' => 'failed',
  },
  'CfprApPowerGroupStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'power',
      '1' => 'powerAvg',
      '2' => 'powerMax',
      '3' => 'powerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNhLinkType' => {
    '1' => 'unicast',
    '2' => 'bcast',
  },
  'CfprApBiosVfBootOptionRetryVpBootOptionRetry' => {
    '0' => 'platformRecommended',
    '129' => 'disabled',
    '130' => 'enabled',
  },
  'CfprApSysdebugManualCoreFileExportTargetFsmCurrentFsm' => {
    '0' => 'nop',
    '358' => 'export',
  },
  'CfprApBiosVfFRB2TimerVpFRB2Timer' => {
    '0' => 'platformRecommended',
    '331' => 'disabled',
    '332' => 'enabled',
  },
  'CfprApSwUtilityDomainType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfLvDIMMSupportVpLvDDRMode' => {
    '0' => 'platformRecommended',
    '161' => 'powerSavingMode',
    '162' => 'performanceMode',
    '163' => 'auto',
  },
  'CfprApFirmwareSystemFsmTaskItem' => {
    '0' => 'nop',
    '37' => 'deploy',
    '67' => 'applyCatalogPack',
  },
  'CfprApSmLogLevel' => {
    '0' => 'debug',
    '1' => 'info',
    '2' => 'warning',
    '3' => 'error',
    '4' => 'critical',
  },
  'CfprApFabricAFcSanEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApExtpolAppCapability' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'serviceReg',
      '1' => 'identifierMgr',
      '2' => 'operationMgr',
      '3' => 'resourceMgr',
      '4' => 'virtualSwitchingMgr',
      '5' => 'policyMgr',
      '6' => 'bootMgr',
      '7' => 'vmMgr',
      '8' => 'vmAdmin',
      '9' => 'infraCryptoOffloa',
      '10' => 'vmm',
      '11' => 'vmVasw',
      '12' => 'vmFw',
      '13' => 'vmSlb',
      '14' => 'infraFw',
      '15' => 'infraSlb',
      '16' => 'ipam',
      '17' => 'pcm',
      '18' => 'infraAggr',
      '19' => 'infraWas',
      '20' => 'infraWaf',
      '21' => 'infraPasw',
      '22' => 'infraPdsw',
      '23' => 'storageBroker',
      '24' => 'orgMgr',
      '25' => 'statsMgr',
      '26' => 'centralMgr',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmNetMgmtBootstrapScope' => {
    '0' => 'global',
    '1' => 'instanceOnly',
  },
  'CfprApStorageFFCardState' => {
    '0' => 'undefined',
    '1' => 'configured',
    '2' => 'initializing',
    '3' => 'active',
    '4' => 'ignored',
    '5' => 'failed',
    '6' => 'unknown',
  },
  'CfprApCapabilityPlatform' => {
    '0' => 'ucs6100',
    '1' => 'ucs6200',
    '2' => 'ucs6324',
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpPCIeSlotHBAOptionROM' => {
    '0' => 'platformRecommended',
    '220' => 'disabled',
    '221' => 'enabled',
    '222' => 'uefiOnly',
    '223' => 'legacyOnly',
  },
  'CfprApStorageFFType' => {
    '0' => 'unknown',
    '1' => 'astoria',
    '2' => 'fx3s',
  },
  'CfprApMgmtExportPolicyFsmTaskItem' => {
    '0' => 'nop',
    '460' => 'reportConfigCopy',
  },
  'CfprApFirmwareDownloaderFsmStageName' => {
    '0' => 'nop',
    '6' => 'downloadBegin',
    '7' => 'downloadLocal',
    '8' => 'downloadUnpackLocal',
    '9' => 'downloadDeleteLocal',
    '10' => 'downloadCopyRemote',
    '614' => 'downloadFail',
    '615' => 'downloadSuccess',
  },
  'CfprApLsbootIScsiAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CfprApCommSnmpV3Privilege' => {
    '1' => 'auth',
    '2' => 'noauth',
    '3' => 'priv',
  },
  'CfprApSwFcZoneSetLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
  },
  'CfprApFabricPIoEpOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'errorMisconfigured',
  },
  'CfprApCallhomeEpConfigState' => {
    '0' => 'ok',
    '1' => 'notApplied',
  },
  'CfprApAdaptorIpV4RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApMgmtCimcSecureBootAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApMgmtBackupFsmCurrentFsm' => {
    '0' => 'nop',
    '473' => 'backup',
  },
  'CfprApVnicConnectionOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '8' => 'connPolicy',
  },
  'CfprApAdaptorEthPortErrStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'badCrcPacketsDelta',
      '1' => 'badCrcPacketsDeltaAvg',
      '2' => 'badCrcPacketsDeltaMax',
      '3' => 'badCrcPacketsDeltaMin',
      '4' => 'badLengthPacketsDelta',
      '5' => 'badLengthPacketsDeltaAvg',
      '6' => 'badLengthPacketsDeltaMax',
      '7' => 'badLengthPacketsDeltaMin',
      '8' => 'macDiscardedPacketsDelta',
      '9' => 'macDiscardedPacketsDeltaAvg',
      '10' => 'macDiscardedPacketsDeltaMax',
      '11' => 'macDiscardedPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentUuidFeatureCapUuidSupportMode' => {
    '0' => 'none',
    '1' => 'loose',
    '2' => 'strict',
  },
  'CfprApFcPIoFsmCurrentFsm' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresence',
    '237' => 'inCompatSfpReplaced',
  },
  'CfprApEquipmentPsuType' => {
    '1' => 'ac',
    '2' => 'dc',
  },
  'CfprApStorageRaidBatteryOperabilityQualifier' => {
    '0' => 'unknown',
  },
  'CfprApFlowctrlFlowControl' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApCallhomeAlertGroup' => {
    '0' => 'diagnostic',
    '1' => 'environmental',
    '100' => 'unknown',
  },
  'CfprApLicenseInstanceFsmStageName' => {
    '0' => 'nop',
    '153' => 'updateFlexlmBegin',
    '154' => 'updateFlexlmLocal',
    '155' => 'updateFlexlmRemote',
    '640' => 'updateFlexlmFail',
    '641' => 'updateFlexlmSuccess',
  },
  'CfprApMgmtBackupType' => {
    '1' => 'fullState',
    '2' => 'configAll',
  },
  'CfprApCimcvmediaMountStatus' => {
    '0' => 'unknown',
    '1' => 'mounting',
    '2' => 'mounted',
    '3' => 'unmounting',
    '4' => 'notMounted',
    '5' => 'mountFailed',
    '6' => 'unmountFailed',
  },
  'CfprApExtvmmOwnership' => {
    '1' => 'discovered',
    '2' => 'managed',
  },
  'CfprApAaaLdapVendor' => {
    '0' => 'openLdap',
    '1' => 'msAd',
  },
  'CfprApEtherPauseStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'recvPauseDelta',
      '1' => 'recvPauseDeltaAvg',
      '2' => 'recvPauseDeltaMax',
      '3' => 'recvPauseDeltaMin',
      '4' => 'resetsDelta',
      '5' => 'resetsDeltaAvg',
      '6' => 'resetsDeltaMax',
      '7' => 'resetsDeltaMin',
      '8' => 'xmitPauseDelta',
      '9' => 'xmitPauseDeltaAvg',
      '10' => 'xmitPauseDeltaMax',
      '11' => 'xmitPauseDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmDiskState' => {
    '0' => 'ok',
    '1' => 'formatting',
    '2' => 'formatFailure',
  },
  'CfprApFabricEthEstcEpPrio' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CfprApConditionAckAction' => {
    '1' => 'deleteOnClear',
    '2' => 'initialSeverity',
  },
  'CfprApSysdebugManualCoreFileExportTargetProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApMgmtCfgExportPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '460' => 'reportConfigCopy',
  },
  'CfprApMgmtImporterProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApFabricNFTransport' => {
    '1' => 'udp',
    '2' => 'sctp',
  },
  'CfprApComputeMbPowerStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'consumedPower',
      '1' => 'consumedPowerAvg',
      '2' => 'consumedPowerMax',
      '3' => 'consumedPowerMin',
      '4' => 'inputCurrent',
      '5' => 'inputCurrentAvg',
      '6' => 'inputCurrentMax',
      '7' => 'inputCurrentMin',
      '8' => 'inputVoltage',
      '9' => 'inputVoltageAvg',
      '10' => 'inputVoltageMax',
      '11' => 'inputVoltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPowerReqConflict' => {
    '0' => 'ignore',
    '1' => 'failPlacement',
  },
  'CfprApFabricLanFlowMonType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwSanBorderType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwEthLanMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot10State' => {
    '0' => 'platformRecommended',
    '210' => 'disabled',
    '211' => 'enabled',
    '212' => 'uefiOnly',
    '213' => 'legacyOnly',
  },
  'CfprApComputeMbTempStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'fmTempSenIo',
      '1' => 'fmTempSenIoAvg',
      '2' => 'fmTempSenIoMax',
      '3' => 'fmTempSenIoMin',
      '4' => 'fmTempSenRear',
      '5' => 'fmTempSenRearAvg',
      '6' => 'fmTempSenRearL',
      '7' => 'fmTempSenRearLAvg',
      '8' => 'fmTempSenRearLMax',
      '9' => 'fmTempSenRearLMin',
      '10' => 'fmTempSenRearMax',
      '11' => 'fmTempSenRearMin',
      '12' => 'fmTempSenRearR',
      '13' => 'fmTempSenRearRAvg',
      '14' => 'fmTempSenRearRMax',
      '15' => 'fmTempSenRearRMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNwctrlLinkFailAction' => {
    '0' => 'linkDown',
    '1' => 'warning',
  },
  'CfprApAdaptorMenloEthErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'dropAclDelta',
      '5' => 'dropAclDeltaAvg',
      '6' => 'dropAclDeltaMax',
      '7' => 'dropAclDeltaMin',
      '8' => 'popErrorsDelta',
      '9' => 'popErrorsDeltaAvg',
      '10' => 'popErrorsDeltaMax',
      '11' => 'popErrorsDeltaMin',
      '12' => 'pushErrorsDelta',
      '13' => 'pushErrorsDeltaAvg',
      '14' => 'pushErrorsDeltaMax',
      '15' => 'pushErrorsDeltaMin',
      '16' => 'uncorrectableErrorsDelta',
      '17' => 'uncorrectableErrorsDeltaAvg',
      '18' => 'uncorrectableErrorsDeltaMax',
      '19' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwUtilityDomainFsmCurrentFsm' => {
    '0' => 'nop',
    '102' => 'deploy',
  },
  'CfprApFabricFcZoneSharingMode' => {
    '0' => 'coalesce',
    '1' => 'clearUnmanagedZoneAll',
  },
  'CfprApVnicVhbaBehPolicyType' => {
    '1' => 'vnic',
    '2' => 'vhba',
  },
  'CfprApFabricNetflowMonSessionProtocol' => {
    '1' => 'netflow',
  },
  'CfprApSdMgmtInfoFsmCurrentFsm' => {
    '0' => 'nop',
    '302' => 'updateMgmtInfo',
  },
  'CfprApIdentMetaSystemFsmStageName' => {
    '0' => 'nop',
    '74' => 'syncBegin',
    '75' => 'syncPing',
    '76' => 'syncExecute',
    '77' => 'ucscUnivSyncBegin',
    '78' => 'ucscUnivSyncExecute',
    '630' => 'syncFail',
    '631' => 'syncSuccess',
    '632' => 'ucscUnivSyncFail',
    '633' => 'ucscUnivSyncSuccess',
  },
  'CfprApSwPhysFsmCurrentFsm' => {
    '0' => 'nop',
    '106' => 'confPhysical',
  },
  'CfprApEtherSwitchIntFIoTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentMemoryUnitDiscoveryModifierAction' => {
    '0' => 'unknown',
    '1' => 'setRevToOne',
    '2' => 'setRev',
    '3' => 'setRevStrict',
  },
  'CfprApPolicyResumeAckState' => {
    '0' => 'noAck',
    '1' => 'acked',
  },
  'CfprApComputeMemoryUnitConstraintType' => {
    '0' => 'unknown',
    '1' => 'kit',
  },
  'CfprApAdaptorMenloDcePortStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxPauseCFCDelta',
      '1' => 'rxPauseCFCDeltaAvg',
      '2' => 'rxPauseCFCDeltaMax',
      '3' => 'rxPauseCFCDeltaMin',
      '4' => 'rxPausePFCDelta',
      '5' => 'rxPausePFCDeltaAvg',
      '6' => 'rxPausePFCDeltaMax',
      '7' => 'rxPausePFCDeltaMin',
      '8' => 'txPauseCFCDelta',
      '9' => 'txPauseCFCDeltaAvg',
      '10' => 'txPauseCFCDeltaMax',
      '11' => 'txPauseCFCDeltaMin',
      '12' => 'txPausePFCDelta',
      '13' => 'txPausePFCDeltaAvg',
      '14' => 'txPausePFCDeltaMax',
      '15' => 'txPausePFCDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotOptionROMEnableVpSlot2State' => {
    '0' => 'platformRecommended',
    '178' => 'disabled',
    '179' => 'enabled',
    '180' => 'uefiOnly',
    '181' => 'legacyOnly',
  },
  'CfprApAdaptorHostFcIfPersBind' => {
    '0' => 'disabled',
    '4' => 'enabled',
  },
  'CfprApFirmwareRunningDeployment' => {
    '0' => 'unspecified',
    '1' => 'kernel',
    '2' => 'bootLoader',
    '3' => 'system',
  },
  'CfprApCapabilityCatalogueFsmCurrentFsm' => {
    '0' => 'nop',
    '421' => 'activateCatalog',
    '435' => 'deployCatalogue',
  },
  'CfprApAaaClear' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApSwSspMonDelPcap' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApAdaptorMenloFcErrorStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'popErrorsDelta',
      '5' => 'popErrorsDeltaAvg',
      '6' => 'popErrorsDeltaMax',
      '7' => 'popErrorsDeltaMin',
      '8' => 'pushErrorsDelta',
      '9' => 'pushErrorsDeltaAvg',
      '10' => 'pushErrorsDeltaMax',
      '11' => 'pushErrorsDeltaMin',
      '12' => 'uncorrectableErrorsDelta',
      '13' => 'uncorrectableErrorsDeltaAvg',
      '14' => 'uncorrectableErrorsDeltaMax',
      '15' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosDefaultAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApFabricUdldLinkPolicyMode' => {
    '0' => 'normal',
    '1' => 'aggressive',
  },
  'CfprApStorageFFCardSync' => {
    '0' => 'na',
    '1' => 'manual',
    '2' => 'auto',
    '3' => 'unknown',
  },
  'CfprApMemoryRuntimeType' => {
    '1' => 'swap',
    '2' => 'total',
  },
  'CfprApBiosVfPackageCStateLimitVpPackageCStateLimit' => {
    '0' => 'platformRecommended',
    '295' => 'noLimit',
    '296' => 'c0',
    '297' => 'c1',
    '298' => 'c3',
    '299' => 'c6',
  },
  'CfprApSwAccessDomainFsmStageName' => {
    '0' => 'nop',
    '95' => 'deployBegin',
    '96' => 'deployUpdateConnectivity',
    '786' => 'deployFail',
    '787' => 'deploySuccess',
  },
  'CfprApSysdebugLogControlEpFsmTaskItem' => {
    '0' => 'nop',
    '381' => 'logControlPersist',
  },
  'CfprApAdaptorHostEthIfHostPort' => {
    '0' => 'any',
    '1' => 'n1',
    '2' => 'n2',
    '10' => 'none',
  },
  'CfprApFabricSnoopingType' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot6LinkSpeed' => {
    '0' => 'platformRecommended',
    '257' => 'gen1',
    '258' => 'gen2',
    '259' => 'gen3',
    '260' => 'auto',
    '261' => 'disabled',
  },
  'CfprApFabricLanFlowMonSrcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdJobType' => {
    '0' => 'unknown',
    '1' => 'install',
    '2' => 'uninstall',
    '3' => 'upgrade',
    '4' => 'start',
    '5' => 'stop',
    '6' => 'formatDisk',
    '7' => 'uploadPlatformImage',
  },
  'CfprApMgmtBackupPostAction' => {
    '0' => 'none',
    '1' => 'remove',
  },
  'CfprApEquipmentPsuOutputStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageFFHasError' => {
    '0' => 'error',
    '1' => 'noError',
  },
  'CfprApSwFabricZoneNsAllocStatus' => {
    '0' => 'available',
    '1' => 'full',
  },
  'CfprApFabricInternalEpAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricEthLanFlowMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwAccessDomainLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageBootableType' => {
    '0' => 'unknown',
    '1' => 'true',
    '2' => 'false',
  },
  'CfprApEquipmentChassisPowerOperState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'failed',
    '3' => 'inputFailed',
    '4' => 'inputDegraded',
    '5' => 'outputFailed',
    '6' => 'outputDegraded',
    '7' => 'redundancyFailed',
    '8' => 'redundancyDegraded',
  },
  'CfprApFabricEthMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFaultBasePolicyClearAction' => {
    '0' => 'retain',
    '1' => 'delete',
  },
  'CfprApMgmtEntityLeadership' => {
    '0' => 'unknown',
    '1' => 'primary',
    '2' => 'subordinate',
    '3' => 'inapplicable',
    '4' => 'electionInProgress',
    '5' => 'electionFailed',
  },
  'CfprApCallhomeAlertMessageSubtype' => {
    '0' => 'nosubtype',
    '1' => 'test',
    '2' => 'full',
    '3' => 'delta',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'goldnormal',
    '7' => 'goldminor',
    '8' => 'goldmajor',
    '100' => 'unknown',
  },
  'CfprApStorageConnectionProtocol' => {
    '0' => 'unspecified',
    '1' => 'sas',
    '2' => 'sata',
  },
  'CfprApCapabilityCatalogueFsmTaskItem' => {
    '0' => 'nop',
    '421' => 'activateCatalog',
    '435' => 'deployCatalogue',
  },
  'CfprApFirmwareAutoSyncState' => {
    '0' => 'autoAcknowledge',
    '1' => 'userAcknowledge',
    '2' => 'noActions',
  },
  'CfprApAdaptorHostFcIfFsmCurrentFsm' => {
    '0' => 'nop',
    '135' => 'circuitReset',
  },
  'CfprApFabricEstcPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApBmcSELCntEqptClassId' => {
    '0' => 'unspecified',
    '125' => 'computeBoard',
    '250' => 'memoryUnit',
    '352' => 'processorUnit',
  },
  'CfprApSwEthLanBorderFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '11' => 'samDmeSwEthLanBorderDeployVlanGroupConfig',
      '12' => 'samDmeSwEthLanBorderDeployVlanGroupRetry',
      '13' => 'samDmeSwEthLanBorderDeployPortConfig',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageFFSlotENUM' => {
    '0' => 'na',
    '1' => 'n1',
    '2' => 'n2',
  },
  'CfprApStorageFFRAIDState' => {
    '0' => 'ffrStateDisabled',
    '1' => 'ffrStateEnabledNotPaired',
    '2' => 'ffrStateEnabledPairedInvalidSecondary',
    '3' => 'ffrStateEnabledPairedInvalidPrimary',
    '4' => 'ffrStateEnabledPairedInvalidBoth',
    '5' => 'ffrStateEnabledPaired',
  },
  'CfprApMemoryArrayEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'inputCurrent',
      '1' => 'inputCurrentAvg',
      '2' => 'inputCurrentMax',
      '3' => 'inputCurrentMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFirmwareBootUnitImage' => {
    '0' => 'running',
    '1' => 'backup',
  },
  'CfprApSysdebugCoreFsmStageName' => {
    '0' => 'nop',
    '376' => 'downloadBegin',
    '377' => 'downloadCopySub',
    '378' => 'downloadCopyPrimary',
    '379' => 'downloadDeleteSub',
    '380' => 'downloadDeletePrimary',
    '810' => 'downloadFail',
    '811' => 'downloadSuccess',
  },
  'CfprApStorageLocalDiskPartitionType' => {
    '1' => 'none',
    '2' => 'swap',
    '3' => 'ext2',
    '4' => 'ext3',
    '5' => 'ntfs',
    '6' => 'fat32',
  },
  'CfprApMemoryRuntimeHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'available',
      '1' => 'availableAvg',
      '2' => 'availableMax',
      '3' => 'availableMin',
      '4' => 'cached',
      '5' => 'cachedAvg',
      '6' => 'cachedMax',
      '7' => 'cachedMin',
      '8' => 'total',
      '9' => 'totalAvg',
      '10' => 'totalMax',
      '11' => 'totalMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApDiagNetworkTestType' => {
    '0' => 'eth',
    '1' => 'fc',
  },
  'CfprApLicenseDownloaderFsmStageName' => {
    '0' => 'nop',
    '140' => 'downloadBegin',
    '141' => 'downloadLocal',
    '142' => 'downloadValidateLocal',
    '143' => 'downloadCopyRemote',
    '144' => 'downloadDeleteLocal',
    '145' => 'downloadValidateRemote',
    '146' => 'downloadDeleteRemote',
    '634' => 'downloadFail',
    '635' => 'downloadSuccess',
  },
  'CfprApFabricEthLanFlowMonitorTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfCoreMultiProcessingVpCoreMultiProcessing' => {
    '0' => 'platformRecommended',
    '29' => 'all',
    '30' => 'n1',
    '31' => 'n2',
    '32' => 'n3',
    '33' => 'n4',
    '34' => 'n5',
    '35' => 'n6',
    '36' => 'n7',
    '37' => 'n8',
    '38' => 'n9',
    '39' => 'n10',
    '40' => 'n11',
    '41' => 'n12',
    '42' => 'n13',
    '43' => 'n14',
    '44' => 'n15',
    '45' => 'n16',
    '46' => 'n17',
    '47' => 'n18',
  },
  'CfprApSdClusterBootstrapFsmTaskItem' => {
    '0' => 'nop',
    '291' => 'updateClusterConfiguration',
  },
  'CfprApEtherCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApLsbootUsbFlashStorageImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
  },
  'CfprApVnicIScsiNodeOwner' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'policy',
    '4' => 'logical',
    '8' => 'connPolicy',
  },
  'CfprApPortGroupType' => {
    '1' => 'switchEther',
    '4' => 'switchFc',
    '8' => 'host',
    '16' => 'fabric',
    '17' => 'fabricPc',
    '18' => 'hostPc',
    '19' => 'adaptorExt',
    '20' => 'adaptorPc',
    '21' => 'serverPc',
  },
  'CfprApFabricPoolMemberConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'namedVlanUnresolved',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFcPIoFsmStageName' => {
    '0' => 'nop',
    '235' => 'inCompatSfpPresenceBegin',
    '236' => 'inCompatSfpPresenceShutdown',
    '237' => 'inCompatSfpReplacedBegin',
    '238' => 'inCompatSfpReplacedEnablePort',
    '732' => 'inCompatSfpPresenceFail',
    '733' => 'inCompatSfpPresenceSuccess',
    '734' => 'inCompatSfpReplacedFail',
    '735' => 'inCompatSfpReplacedSuccess',
  },
  'CfprApNetworkIfStatsType' => {
    '0' => 'generic',
    '1' => 'broadcast',
    '2' => 'multicast',
    '3' => 'unicast',
    '4' => 'total',
  },
  'CfprApFirmwarePlatformPackFsmStageName' => {
    '0' => 'nop',
    '34' => 'platformVersionBegin',
    '35' => 'platformVersionWaitForReady',
    '36' => 'platformVersionRestore',
    '618' => 'platformVersionFail',
    '619' => 'platformVersionSuccess',
  },
  'CfprApFabricEthMonLanTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommSnmpProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CfprApComputePciCapOrder' => {
    '0' => 'ascending',
    '1' => 'descending',
    '2' => 'ascendingDual',
    '3' => 'ascendingSeq',
    '4' => 'ascendingExtended',
  },
  'CfprApLsConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'insufficientResources',
      '1' => 'vnicCapacity',
      '2' => 'vhbaCapacity',
      '3' => 'fcoeCapacity',
      '4' => 'switchVirtualIfCapacity',
      '5' => 'macAddressAssignment',
      '6' => 'wwpnAssignment',
      '7' => 'wwnnAssignment',
      '8' => 'systemUuidAssignment',
      '9' => 'bootOrderSanImagePath',
      '10' => 'bootOrderPxe',
      '11' => 'computeUndiscovered',
      '12' => 'adaptorProtectedEthCapability',
      '13' => 'adaptorFcoeCapability',
      '14' => 'incompatibleNumberOfLocalDisks',
      '15' => 'adaptorRequirement',
      '16' => 'memoryRequirement',
      '17' => 'processorRequirement',
      '18' => 'serverPositionRequirement',
      '19' => 'computeUnavailable',
      '20' => 'wwnnDerivationFromVhba',
      '21' => 'bootConfigurationInvalid',
      '22' => 'connectionPlacement',
      '23' => 'wwpnDerivationVirtualizedPort',
      '24' => 'macDerivationVirtualizedPort',
      '25' => 'qosPolicyInvalid',
      '26' => 'vlanPortCapacity',
      '27' => 'physicalRequirement',
      '28' => 'destructiveLocalDiskConfig',
      '29' => 'powerGroupRequirement',
      '30' => 'migration',
      '31' => 'incompatibleBiosImage',
      '32' => 'incompatibleDiskTypes',
      '33' => 'incompatibleRaidLevel',
      '34' => 'invalidWwn',
      '35' => 'insufficientPowerBudget',
      '36' => 'bootipPolicyInvalid',
      '37' => 'hostimgPolicyInvalid',
      '38' => 'imgsecPolicyInvalid',
      '39' => 'provsrvPolicyInvalid',
      '40' => 'incompatBiosForSriovVnics',
      '41' => 'iscsiConfig',
      '42' => 'vnicNotHaReady',
      '43' => 'missingPrimaryVlan',
      '44' => 'missingRaidKey',
      '45' => 'bootOrderIscsi',
      '46' => 'vfcVnicPvlanConflict',
      '47' => 'vifResourcesOverprovisioned',
      '48' => 'pinningVlanMismatch',
      '49' => 'vnicVlanAssignmentError',
      '50' => 'iscsiInitiatorIpAddress',
      '51' => 'storagePathConfigurationError',
      '52' => 'zoneCapacity',
      '53' => 'dynamicVfVnic',
      '54' => 'boardControllerUpdateUnsupported',
      '55' => 'vnicVconProvisioningChange',
      '56' => 'namedVlanInaccessible',
      '57' => 'pinningInvalid',
      '58' => 'nonInterruptFsmRunning',
      '59' => 'missingFirmwareImage',
      '60' => 'remotePolicy',
      '61' => 'resourceOwnershipConflict',
      '62' => 'duplicateAddressConflict',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApQosclassEthClassifiedDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CfprApEquipmentCType' => {
    '0' => 'sas',
    '1' => 'flash',
  },
  'CfprApMemoryFormFactor' => {
    '0' => 'undiscovered',
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'simm',
    '9' => 'dimm',
    '10' => 'tsop',
    '12' => 'rimm',
    '13' => 'sodimm',
    '14' => 'srimm',
    '15' => 'fbDimm',
  },
  'CfprApHostagAction' => {
    '0' => 'none',
  },
  'CfprApSwVlanConfigStatusType' => {
    '1' => 'applied',
    '2' => 'unApplied',
  },
  'CfprApBiosSupportedAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApTopMode' => {
    '0' => 'unspecified',
    '1' => 'standAlone',
    '2' => 'cluster',
  },
  'CfprApSwEthLanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwUtilityDomainFsmStageName' => {
    '0' => 'nop',
    '102' => 'deployBegin',
    '103' => 'deployUpdateConnectivity',
    '804' => 'deployFail',
    '805' => 'deploySuccess',
  },
  'CfprApComputeUpgradeStatus' => {
    '0' => 'notUpgraded',
    '1' => 'upgraded',
    '2' => 'notApplicable',
  },
  'CfprApFabricCloudType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ethlan',
      '1' => 'ethestclan',
      '2' => 'ethlanmon',
      '3' => 'fcsan',
      '4' => 'fcsanmon',
      '5' => 'fcestc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosBootDevErrorCode' => {
    '0' => 'success',
    '1' => 'failure',
  },
  'CfprApSwEthMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApNhtestTestState' => {
    '0' => 'ready',
    '1' => 'config',
    '2' => 'abort',
    '3' => 'unconfig',
    '4' => 'portmac',
    '5' => 'clean',
    '6' => 'delld',
    '7' => 'allocip',
    '8' => 'freeip',
  },
  'CfprApEtherExternalPcLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwPeerStatus' => {
    '1' => 'existing',
    '2' => 'nonexisting',
  },
  'CfprApEquipmentChassisFsmCurrentFsm' => {
    '0' => 'nop',
    '225' => 'removeChassis',
  },
  'CfprApBiosVfPSTATECoordinationVpPSTATECoordination' => {
    '0' => 'platformRecommended',
    '343' => 'hwAll',
    '344' => 'swAll',
    '345' => 'swAny',
  },
  'CfprApEquipmentChassisFsmTaskItem' => {
    '0' => 'nop',
    '225' => 'removeChassis',
  },
  'CfprApSwLanBorderType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApTrigAckMode' => {
    '0' => 'immediate',
    '1' => 'userAck',
    '2' => 'timerAutomatic',
  },
  'CfprApStorageLearnCycleRequested' => {
    '0' => 'unknown',
    '1' => 'true',
    '2' => 'false',
  },
  'CfprApFabricSpannedCluster' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApCommTimeZoneConfigState' => {
    '0' => 'success',
    '1' => 'failure',
  },
  'CfprApEquipmentIOCardBaseFsmStageName' => {
    '0' => 'nop',
    '219' => 'fePresenceBegin',
    '220' => 'fePresenceCheckLicense',
    '221' => 'fePresenceIdentify',
    '222' => 'feConnBegin',
    '223' => 'feConnConfigureSwMgmtEndPoint',
    '224' => 'feConnConfigureVifNs',
    '580' => 'feConnFail',
    '581' => 'feConnSuccess',
    '582' => 'fePresenceFail',
    '583' => 'fePresenceSuccess',
  },
  'CfprApEtherServerIntFIoLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPolicyState' => {
    '0' => 'ok',
    '1' => 'outOfSync',
  },
  'CfprApSwPIoEpLc' => {
    '0' => 'available',
    '1' => 'allocated',
    '2' => 'deallocated',
    '3' => 'repurposed',
    '4' => 'pending',
  },
  'CfprApCommSyslogSourceAudits' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApAdaptorCIoEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApAdaptorMenloQStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropOverrunN0Delta',
      '1' => 'dropOverrunN0DeltaAvg',
      '2' => 'dropOverrunN0DeltaMax',
      '3' => 'dropOverrunN0DeltaMin',
      '4' => 'dropOverrunN1Delta',
      '5' => 'dropOverrunN1DeltaAvg',
      '6' => 'dropOverrunN1DeltaMax',
      '7' => 'dropOverrunN1DeltaMin',
      '8' => 'truncateOverrunN0Delta',
      '9' => 'truncateOverrunN0DeltaAvg',
      '10' => 'truncateOverrunN0DeltaMax',
      '11' => 'truncateOverrunN0DeltaMin',
      '12' => 'truncateOverrunN1Delta',
      '13' => 'truncateOverrunN1DeltaAvg',
      '14' => 'truncateOverrunN1DeltaMax',
      '15' => 'truncateOverrunN1DeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentBeaconLedFsmTaskItem' => {
    '0' => 'nop',
    '247' => 'illuminate',
  },
  'CfprApNetworkConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'conflictingVlanAccess',
      '1' => 'namedVlanInaccessible',
      '2' => 'permitUnresolved',
      '3' => 'pinningInvalid',
      '4' => 'switchVirtualIfCapacity',
      '5' => 'unsupportedMulticastPolicy',
      '6' => 'vlanPortCapacity',
      '7' => 'networkFeatureCapabilityMismatch',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSwSrvPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherServerIntFIoPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApSmClusterMode' => {
    '0' => 'spannedEtherchannel',
  },
  'CfprApPortDuplex' => {
    '1' => 'halfDuplex',
    '2' => 'fullDuplex',
    '4' => 'auto',
  },
  'CfprApEtherExternalEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricVsanOperState' => {
    '1' => 'ok',
    '2' => 'errorMisconfigured',
    '3' => 'errorReserved',
  },
  'CfprApAdaptorExtEthIfFsmStageName' => {
    '0' => 'nop',
    '127' => 'pathResetBegin',
    '128' => 'pathResetDisable',
    '129' => 'pathResetEnable',
    '542' => 'pathResetFail',
    '543' => 'pathResetSuccess',
  },
  'CfprApFabricAEthEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmAppFsmTaskItem' => {
    '0' => 'nop',
    '79' => 'delete',
    '83' => 'updateApplication',
  },
  'CfprApMgmtEntityChassisDeviceIoState1' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'openError',
    '3' => 'readError',
    '4' => 'writeError',
  },
  'CfprApAdaptorEthPortBySizeLargeStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'greaterThanOrEqualTo9216Delta',
      '1' => 'greaterThanOrEqualTo9216DeltaAvg',
      '2' => 'greaterThanOrEqualTo9216DeltaMax',
      '3' => 'greaterThanOrEqualTo9216DeltaMin',
      '4' => 'lessThan2048Delta',
      '5' => 'lessThan2048DeltaAvg',
      '6' => 'lessThan2048DeltaMax',
      '7' => 'lessThan2048DeltaMin',
      '8' => 'lessThan4096Delta',
      '9' => 'lessThan4096DeltaAvg',
      '10' => 'lessThan4096DeltaMax',
      '11' => 'lessThan4096DeltaMin',
      '12' => 'lessThan8192Delta',
      '13' => 'lessThan8192DeltaAvg',
      '14' => 'lessThan8192DeltaMax',
      '15' => 'lessThan8192DeltaMin',
      '16' => 'lessThan9216Delta',
      '17' => 'lessThan9216DeltaAvg',
      '18' => 'lessThan9216DeltaMax',
      '19' => 'lessThan9216DeltaMin',
      '20' => 'lessThanOrEqualTo1518Delta',
      '21' => 'lessThanOrEqualTo1518DeltaAvg',
      '22' => 'lessThanOrEqualTo1518DeltaMax',
      '23' => 'lessThanOrEqualTo1518DeltaMin',
      '24' => 'noBreakdownGreaterThan1518Delta',
      '25' => 'noBreakdownGreaterThan1518DeltaAvg',
      '26' => 'noBreakdownGreaterThan1518DeltaMax',
      '27' => 'noBreakdownGreaterThan1518DeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentIOCardFsmTaskItem' => {
    '0' => 'nop',
    '211' => 'resetIom',
  },
  'CfprApAdaptorExtIfPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApQosclassFcDrop' => {
    '0' => 'drop',
    '1' => 'noDrop',
  },
  'CfprApMgmtConfigState' => {
    '0' => 'incomplete',
    '1' => 'unsupportedVlan',
    '2' => 'unsupportedServer',
    '3' => 'unresolvedVlan',
    '4' => 'unsupportedFirmware',
    '5' => 'valid',
  },
  'CfprApComputePCIeFatalCompletionStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'abortErrors',
      '1' => 'timeoutErrors',
      '2' => 'unexpectedErrors',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVmMgmtPlane' => {
    '0' => 'unmanaged',
    '1' => 'vcenter',
    '2' => 'rhevM',
    '3' => 'scvmm',
  },
  'CfprApFirmwareUpgradeSeverity' => {
    '0' => 'unknown',
    '1' => 'fatal',
    '2' => 'error',
    '3' => 'warn',
    '4' => 'info',
  },
  'CfprApEquipmentIOCardStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'dimmTemp',
      '5' => 'dimmTempAvg',
      '6' => 'dimmTempMax',
      '7' => 'dimmTempMin',
      '8' => 'procTemp',
      '9' => 'procTempAvg',
      '10' => 'procTempMax',
      '11' => 'procTempMin',
      '12' => 'temp',
      '13' => 'tempAvg',
      '14' => 'tempMax',
      '15' => 'tempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentSwitchIOCardFsmCurrentFsm' => {
    '0' => 'nop',
    '219' => 'fePresence',
    '222' => 'feConn',
  },
  'CfprApEquipmentInternalFanType' => {
    '0' => 'chassis',
    '1' => 'switch',
    '2' => 'fex',
  },
  'CfprApEquipmentFanModuleStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricSanEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApComputeConnectivityRebalancing' => {
    '0' => 'immediate',
    '1' => 'userAcknowledged',
  },
  'CfprApFabricEthEstcOperPortMode' => {
    '1' => 'regularTrunk',
    '2' => 'regularAccess',
    '3' => 'promiscuousTrunk',
    '4' => 'promiscuousAccess',
  },
  'CfprApAaaEpFsmStageName' => {
    '0' => 'nop',
    '349' => 'updateEpBegin',
    '350' => 'updateEpSetEpLocal',
    '351' => 'updateEpSetEpPeer',
    '536' => 'updateEpFail',
    '537' => 'updateEpSuccess',
  },
  'CfprApEquipmentCardStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temp',
      '1' => 'tempAvg',
      '2' => 'tempMax',
      '3' => 'tempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherNiErrStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'crcDelta',
      '1' => 'crcDeltaAvg',
      '2' => 'crcDeltaMax',
      '3' => 'crcDeltaMin',
      '4' => 'frameTxDelta',
      '5' => 'frameTxDeltaAvg',
      '6' => 'frameTxDeltaMax',
      '7' => 'frameTxDeltaMin',
      '8' => 'inRangeDelta',
      '9' => 'inRangeDeltaAvg',
      '10' => 'inRangeDeltaMax',
      '11' => 'inRangeDeltaMin',
      '12' => 'tooLongDelta',
      '13' => 'tooLongDeltaAvg',
      '14' => 'tooLongDeltaMax',
      '15' => 'tooLongDeltaMin',
      '16' => 'tooShortDelta',
      '17' => 'tooShortDeltaAvg',
      '18' => 'tooShortDeltaMax',
      '19' => 'tooShortDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentDiscoveryCapOperPowerRequirement' => {
    '0' => 'none',
    '1' => 'standby',
    '2' => 'full',
  },
  'CfprApSwEstcEpLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugCoreFsmCurrentFsm' => {
    '0' => 'nop',
    '376' => 'download',
  },
  'CfprApLsbootUsbExternalImageType' => {
    '1' => 'localAny',
    '2' => 'sdCard',
    '3' => 'localLun',
    '4' => 'usbIntern',
    '5' => 'usbExtern',
  },
  'CfprApFabricNetGroupSwitchId' => {
    '0' => 'none',
    '1' => 'a',
    '2' => 'b',
    '3' => 'dual',
  },
  'CfprApEquipmentChassisAdminState' => {
    '1' => 'acknowledged',
    '2' => 'reAcknowledge',
    '3' => 'decommission',
    '4' => 'remove',
    '5' => 'enablePortChannel',
    '6' => 'disablePortChannel',
    '7' => 'autoAcknowledge',
  },
  'CfprApPortTrust' => {
    '0' => 'trusted',
    '1' => 'untrusted',
  },
  'CfprApSwSspMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFsmFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '1' => 'unused',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaUserEpFsmStageName' => {
    '0' => 'nop',
    '355' => 'updateUserEpBegin',
    '356' => 'updateUserEpSetUserLocal',
    '357' => 'updateUserEpSetUserPeer',
    '540' => 'updateUserEpFail',
    '541' => 'updateUserEpSuccess',
  },
  'CfprApFabricAVlanSharing' => {
    '0' => 'none',
    '1' => 'primary',
    '2' => 'isolated',
    '3' => 'community',
  },
  'CfprApOsControllerBootMode' => {
    '0' => 'normal',
    '1' => 'local',
    '2' => 'mio',
  },
  'CfprApMemoryUnitEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApStorageCacheType' => {
    '0' => 'unknown',
    '1' => 'noChange',
    '2' => 'enable',
    '3' => 'disable',
  },
  'CfprApComputeIOHubEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorMenloEthErrorStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'dropAclDelta',
      '5' => 'dropAclDeltaAvg',
      '6' => 'dropAclDeltaMax',
      '7' => 'dropAclDeltaMin',
      '8' => 'popErrorsDelta',
      '9' => 'popErrorsDeltaAvg',
      '10' => 'popErrorsDeltaMax',
      '11' => 'popErrorsDeltaMin',
      '12' => 'pushErrorsDelta',
      '13' => 'pushErrorsDeltaAvg',
      '14' => 'pushErrorsDeltaMax',
      '15' => 'pushErrorsDeltaMin',
      '16' => 'uncorrectableErrorsDelta',
      '17' => 'uncorrectableErrorsDeltaAvg',
      '18' => 'uncorrectableErrorsDeltaMax',
      '19' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApTrigTriggeredState' => {
    '0' => 'pending',
    '1' => 'inProgress',
    '2' => 'failed',
    '3' => 'triggered',
  },
  'CfprApFirmwareImpactType' => {
    '0' => 'activate',
    '1' => 'noimpact',
    '2' => 'reset',
    '3' => 'update',
  },
  'CfprApFabricLanFlowMonitorType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwLanEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommShellProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CfprApFabricSspMonAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEtherTxStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'broadcastPacketsDelta',
      '1' => 'broadcastPacketsDeltaAvg',
      '2' => 'broadcastPacketsDeltaMax',
      '3' => 'broadcastPacketsDeltaMin',
      '4' => 'jumboPacketsDelta',
      '5' => 'jumboPacketsDeltaAvg',
      '6' => 'jumboPacketsDeltaMax',
      '7' => 'jumboPacketsDeltaMin',
      '8' => 'multicastPacketsDelta',
      '9' => 'multicastPacketsDeltaAvg',
      '10' => 'multicastPacketsDeltaMax',
      '11' => 'multicastPacketsDeltaMin',
      '12' => 'totalBytesDelta',
      '13' => 'totalBytesDeltaAvg',
      '14' => 'totalBytesDeltaMax',
      '15' => 'totalBytesDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'unicastPacketsDelta',
      '21' => 'unicastPacketsDeltaAvg',
      '22' => 'unicastPacketsDeltaMax',
      '23' => 'unicastPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPsuStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'fanSpeed',
      '5' => 'fanSpeedAvg',
      '6' => 'fanSpeedMax',
      '7' => 'fanSpeedMin',
      '8' => 'input210v',
      '9' => 'input210vAvg',
      '10' => 'input210vMax',
      '11' => 'input210vMin',
      '12' => 'inputCurrent',
      '13' => 'inputCurrentAvg',
      '14' => 'inputCurrentMax',
      '15' => 'inputCurrentMin',
      '16' => 'inputPower',
      '17' => 'inputPowerAvg',
      '18' => 'inputPowerMax',
      '19' => 'inputPowerMin',
      '20' => 'output12v',
      '21' => 'output12vAvg',
      '22' => 'output12vMax',
      '23' => 'output12vMin',
      '24' => 'output3v3',
      '25' => 'output3v3Avg',
      '26' => 'output3v3Max',
      '27' => 'output3v3Min',
      '28' => 'outputCurrent',
      '29' => 'outputCurrentAvg',
      '30' => 'outputCurrentMax',
      '31' => 'outputCurrentMin',
      '32' => 'outputPower',
      '33' => 'outputPowerAvg',
      '34' => 'outputPowerMax',
      '35' => 'outputPowerMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaRealmFsmStageName' => {
    '0' => 'nop',
    '352' => 'updateRealmBegin',
    '353' => 'updateRealmSetRealmLocal',
    '354' => 'updateRealmSetRealmPeer',
    '538' => 'updateRealmFail',
    '539' => 'updateRealmSuccess',
  },
  'CfprApStoragePowerState' => {
    '0' => 'unknown',
    '1' => 'active',
    '2' => 'powersave',
    '3' => 'transitioning',
  },
  'CfprApFirmwareSupFirmwareFsmCurrentFsm' => {
    '0' => 'nop',
    '56' => 'deploy',
  },
  'CfprApEquipmentFexEnvStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'die1',
      '1' => 'die1Avg',
      '2' => 'die1Max',
      '3' => 'die1Min',
      '4' => 'inlet',
      '5' => 'inlet1',
      '6' => 'inlet1Avg',
      '7' => 'inlet1Max',
      '8' => 'inlet1Min',
      '9' => 'inletAvg',
      '10' => 'inletMax',
      '11' => 'inletMin',
      '12' => 'outlet1',
      '13' => 'outlet1Avg',
      '14' => 'outlet1Max',
      '15' => 'outlet1Min',
      '16' => 'outlet2',
      '17' => 'outlet2Avg',
      '18' => 'outlet2Max',
      '19' => 'outlet2Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysdebugManualCoreFileExportTargetFsmTaskItem' => {
    '0' => 'nop',
    '358' => 'export',
  },
  'CfprApFabricFcMonSrcRefType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricAccessType' => {
    '0' => 'lan',
    '1' => 'san',
  },
  'CfprApStorageControllerFaultMonitoring' => {
    '1' => 'supported',
    '2' => 'notSupported',
  },
  'CfprApSdLduFsmTaskItem' => {
    '0' => 'nop',
    '258' => 'provisionLDU',
  },
  'CfprApAdaptorDefaultAction' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApCapabilityAdminState' => {
    '0' => 'restart',
    '1' => 'idle',
  },
  'CfprApNetworkVnetEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApEquipmentCpuType' => {
    '0' => 'other',
    '1' => 'ivyBridge',
    '2' => 'sandyBridge',
  },
  'CfprApStatsThr32DefinitionPropType' => {
    '1' => 'uint32',
    '2' => 'uint64',
    '3' => 'float',
  },
  'CfprApLsFcZoneState' => {
    '0' => 'notApplied',
    '1' => 'applied',
    '2' => 'applying',
    '3' => 'applyPending',
    '4' => 'notActive',
    '5' => 'active',
    '6' => 'created',
    '7' => 'createFailed',
    '8' => 'deleted',
    '9' => 'zoneMergeFailure',
  },
  'CfprApEtherServerIntFIoType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFsmFsmStageStatus' => {
    '0' => 'fail',
    '1' => 'success',
    '2' => 'skip',
    '3' => 'pending',
    '4' => 'inProgress',
    '5' => 'throttled',
    '255' => 'nop',
  },
  'CfprApEtherServerIntFIoAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApFabricVlanAssocPrimaryVlanState' => {
    '1' => 'ok',
    '2' => 'isEmpty',
    '3' => 'doesNotExists',
    '4' => 'isNotPrimaryType',
    '5' => 'isInErrorState',
  },
  'CfprApAdaptorFcIfFrameStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dumpedFramesDelta',
      '1' => 'dumpedFramesDeltaAvg',
      '2' => 'dumpedFramesDeltaMax',
      '3' => 'dumpedFramesDeltaMin',
      '4' => 'errorFramesDelta',
      '5' => 'errorFramesDeltaAvg',
      '6' => 'errorFramesDeltaMax',
      '7' => 'errorFramesDeltaMin',
      '8' => 'rxFramesDelta',
      '9' => 'rxFramesDeltaAvg',
      '10' => 'rxFramesDeltaMax',
      '11' => 'rxFramesDeltaMin',
      '12' => 'txFramesDelta',
      '13' => 'txFramesDeltaAvg',
      '14' => 'txFramesDeltaMax',
      '15' => 'txFramesDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricVnetEpPolicyOwner' => {
    '0' => 'local',
    '1' => 'policy',
    '2' => 'pendingPolicy',
  },
  'CfprApBiosVfQuietBootVpQuietBoot' => {
    '0' => 'platformRecommended',
    '136' => 'disabled',
    '137' => 'enabled',
  },
  'CfprApFabricEthCdpPolicyProtocol' => {
    '0' => 'unknown',
    '1' => 'udld',
    '2' => 'cdp',
  },
  'CfprApComputePsuRedundancyOperState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'failed',
    '3' => 'degraded',
  },
  'CfprApMgmtStateQual' => {
    '0' => 'unspecified',
    '1' => 'valid',
    '2' => 'misconnected',
  },
  'CfprApStatsCollectionPolicyFsmTaskItem' => {
    '0' => 'nop',
    '407' => 'updateEp',
  },
  'CfprApSwEthLanFlowMonTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMoMoClassId' => {
    '0' => 'unspecified',
    '1' => 'moTopProps',
    '2' => 'topRoot',
    '3' => 'topSystem',
    '4' => 'topMetaInf',
    '5' => 'topInfoPolicy',
    '6' => 'topSysDefaults',
    '7' => 'fsmTask',
    '8' => 'fsmFsm',
    '9' => 'fsmStage',
    '10' => 'namingNamedObject',
    '11' => 'namingNamedIdentifiedObject',
    '12' => 'conditionInfo',
    '13' => 'conditionReportable',
    '14' => 'conditionMutable',
    '15' => 'conditionImmutable',
    '16' => 'conditionMultiInstanceImmutable',
    '17' => 'conditionPolicy',
    '18' => 'conditionLog',
    '19' => 'conditionLoggable',
    '20' => 'aaaLog',
    '21' => 'aaaUserAction',
    '22' => 'aaaModLR',
    '23' => 'aaaSessionLR',
    '24' => 'eventEpCtrl',
    '25' => 'eventLog',
    '26' => 'eventRecord',
    '27' => 'eventHolder',
    '28' => 'eventInst',
    '29' => 'eventPolicy',
    '30' => 'faultBaseHolder',
    '31' => 'faultLocalTypedHolder',
    '32' => 'faultHolder',
    '33' => 'faultInst',
    '34' => 'faultBasePolicy',
    '35' => 'faultPolicy',
    '36' => 'faultSuppressPolicy',
    '37' => 'faultSuppressPolicyItem',
    '38' => 'faultSuppressTask',
    '39' => 'faultAffectedClass',
    '40' => 'statsItem',
    '41' => 'statsCurr',
    '42' => 'statsHist',
    '43' => 'statsHolder',
    '44' => 'statsCollectionPolicy',
    '45' => 'statsThresholdPolicy',
    '46' => 'statsThresholdClass',
    '47' => 'statsThresholdDefinition',
    '48' => 'statsThr32Definition',
    '49' => 'statsThr64Definition',
    '50' => 'statsThrFloatDefinition',
    '51' => 'statsThresholdValue',
    '52' => 'statsThr32Value',
    '53' => 'statsThr64Value',
    '54' => 'statsThrFloatValue',
    '55' => 'gmetaEp',
    '56' => 'gmetaHolder',
    '57' => 'gmetaClass',
    '58' => 'gmetaProp',
    '59' => 'gmetaPolicyMapHolder',
    '60' => 'equipmentPOSTCodeContainer',
    '61' => 'equipmentPOSTCodeTemplate',
    '62' => 'equipmentPOSTCodeReporter',
    '63' => 'equipmentPOSTCodeData',
    '64' => 'equipmentPOSTCode',
    '65' => 'equipmentPOST',
    '66' => 'swatInjection',
    '67' => 'swatTrigger',
    '68' => 'swatCondition',
    '69' => 'swatTarget',
    '70' => 'swatAction',
    '71' => 'swatResultstats',
    '72' => 'apeManager',
    '73' => 'apeMc',
    '74' => 'apeMcTable',
    '75' => 'apeFru',
    '76' => 'apeSdr',
    '77' => 'apeReading',
    '78' => 'apeParam',
    '79' => 'apeBootMethod',
    '80' => 'apeLANBoot',
    '81' => 'apeSANBoot',
    '82' => 'apeLocalDiskBoot',
    '83' => 'apeVirtualMediaBoot',
    '84' => 'apeHostAgent',
    '85' => 'apeDcosAgManager',
    '86' => 'apeSwitchFirmwareInv',
    '87' => 'apeControllerManager',
    '88' => 'apeControllerChassis',
    '89' => 'apeControllerEeprom',
    '90' => 'apeNicAgManager',
    '91' => 'apeAdapter',
    '92' => 'apeMenlo',
    '93' => 'apePalo',
    '94' => 'apeAdapterVnic',
    '95' => 'apeMenloVnic',
    '96' => 'apePaloVnic',
    '97' => 'apeVnicStats',
    '98' => 'apeMenloVnicStats',
    '99' => 'apePaloVnicStats',
    '100' => 'computeQualItem',
    '101' => 'computeQualifiedPolicy',
    '102' => 'computePhysicalQual',
    '103' => 'computeBladePosQual',
    '104' => 'computeRackPosQual',
    '105' => 'computeChassisQual',
    '106' => 'computeSlotQual',
    '107' => 'computeRackQual',
    '108' => 'computePool',
    '109' => 'computePoolingPolicy',
    '110' => 'computePooledPhysical',
    '111' => 'computePooledSlot',
    '112' => 'computePooledRackUnit',
    '113' => 'computeConfigPolicy',
    '114' => 'computeDiscPolicy',
    '115' => 'computeServerDiscPolicy',
    '116' => 'computeAChassisDiscPolicy',
    '117' => 'computeComputeDiscPolicy',
    '118' => 'computeChassisDiscPolicy',
    '119' => 'computePoolPolicyRef',
    '120' => 'computeItem',
    '121' => 'computeIOHub',
    '122' => 'computePhysical',
    '123' => 'computeLogical',
    '124' => 'computeABoard',
    '125' => 'computeBoard',
    '126' => 'computeExtBoard',
    '127' => 'computeBoardConnector',
    '128' => 'queryresultItem',
    '129' => 'queryresultUsage',
    '130' => 'queryresultDependency',
    '131' => 'dpsecMac',
    '132' => 'powerPolicy',
    '133' => 'powerGroupQual',
    '134' => 'powerAGroup',
    '135' => 'powerGroup',
    '136' => 'dcxVc',
    '137' => 'vnicL3If',
    '138' => 'vnicIPIf',
    '139' => 'vnicIPv4If',
    '140' => 'vnicIpAddr',
    '141' => 'vnicIpV4Addr',
    '142' => 'vnicIpV6Addr',
    '143' => 'vnicIpV4AddrConf',
    '144' => 'vnicIpV4AddrExplConf',
    '145' => 'vnicIpV6AddrConf',
    '146' => 'vnicIpV6AddrExplConf',
    '147' => 'vnicIpV4ProfDerivedAddr',
    '148' => 'vnicIpV4StaticAddr',
    '149' => 'vnicIpV6StaticAddr',
    '150' => 'vnicIpV4PooledAddr',
    '151' => 'vnicIpV4MgmtPooledAddr',
    '152' => 'vnicIpV6MgmtPooledAddr',
    '153' => 'vnicIPv4Dhcp',
    '154' => 'vnicIPv4Dns',
    '155' => 'vnicIPv4StaticRoute',
    '156' => 'vnicIPv4IscsiAddr',
    '157' => 'vnicIPv4PooledIscsiAddr',
    '158' => 'vnicBootIpPolicy',
    '159' => 'vnicConReq',
    '160' => 'vnicConPolicyRef',
    '161' => 'vnicDynamicConReq',
    '162' => 'vnicDynamicConPolicy',
    '163' => 'vnicSanConnPolicy',
    '164' => 'vnicLanConnPolicy',
    '165' => 'vnicFcNode',
    '166' => 'vnicIScsiNode',
    '167' => 'vnicBootTarget',
    '168' => 'vnicVlan',
    '169' => 'vnicIScsiTargetIf',
    '170' => 'vnicIScsiStaticTargetIf',
    '171' => 'vnicLun',
    '172' => 'vnicIScsiAutoTargetIf',
    '173' => 'vnicIScsiBootParams',
    '174' => 'vnicIScsiBootVnic',
    '175' => 'vnicConnection',
    '176' => 'vnicNicConn',
    '177' => 'vnicConnDef',
    '178' => 'vnicIf',
    '179' => 'vnicABeh',
    '180' => 'vnicDefBeh',
    '181' => 'vnicVnicBehPolicy',
    '182' => 'vnicVhbaBehPolicy',
    '183' => 'vnicUsnicConReq',
    '184' => 'vnicUsnicConPolicy',
    '185' => 'vnicUsnicConPolicyRef',
    '186' => 'vnicDynamicConPolicyRef',
    '187' => 'vnicL2If',
    '188' => 'vnicAFcIf',
    '189' => 'vnicEtherBaseIf',
    '190' => 'vnicAEtherIf',
    '191' => 'vnicFcOEIf',
    '192' => 'vnicFcIf',
    '193' => 'vnicEtherIf',
    '194' => 'vnicVmqConReq',
    '195' => 'vnicVmqConPolicy',
    '196' => 'vnicVmqConPolicyRef',
    '197' => 'adaptorUnit',
    '198' => 'adaptorHostIfProfile',
    '199' => 'adaptorHostEthIfProfile',
    '200' => 'adaptorHostFcIfProfile',
    '201' => 'adaptorProfileItem',
    '202' => 'adaptorQueueProfile',
    '203' => 'adaptorFcLogiProfile',
    '204' => 'adaptorEthQueueProfile',
    '205' => 'adaptorFcQueueProfile',
    '206' => 'adaptorEthWorkQueueProfile',
    '207' => 'adaptorEthArfsProfile',
    '208' => 'adaptorEthNVGREProfile',
    '209' => 'adaptorEthVxLANProfile',
    '210' => 'adaptorEthRoCEProfile',
    '211' => 'adaptorEthRecvQueueProfile',
    '212' => 'adaptorEthCompQueueProfile',
    '213' => 'adaptorEthInterruptProfile',
    '214' => 'adaptorRssProfile',
    '215' => 'adaptorRssHashProfile',
    '216' => 'adaptorTcpIpRssHashProfile',
    '217' => 'adaptorIpV4RssHashProfile',
    '218' => 'adaptorIpV6RssHashProfile',
    '219' => 'adaptorExtIpV6RssHashProfile',
    '220' => 'adaptorEthOffloadProfile',
    '221' => 'adaptorEthFailoverProfile',
    '222' => 'adaptorFcRecvQueueProfile',
    '223' => 'adaptorFcWorkQueueProfile',
    '224' => 'adaptorFcCdbWorkQueueProfile',
    '225' => 'adaptorFcPortFLogiProfile',
    '226' => 'adaptorFcPortPLogiProfile',
    '227' => 'adaptorFcPortProfile',
    '228' => 'adaptorFcErrorRecoveryProfile',
    '229' => 'adaptorFcInterruptProfile',
    '230' => 'adaptorHostIscsiIfProfile',
    '231' => 'adaptorProtocolProfile',
    '232' => 'adaptorFruCapProvider',
    '233' => 'adaptorCapSpec',
    '234' => 'adaptorIScsiCap',
    '235' => 'adaptorBehCap',
    '236' => 'adaptorHwAddrCap',
    '237' => 'adaptorHostIf',
    '238' => 'adaptorExtEthIf',
    '239' => 'adaptorExtIf',
    '240' => 'adaptorHostEthIf',
    '241' => 'adaptorHostFcIf',
    '242' => 'adaptorHostIfConnDef',
    '243' => 'adaptorUsnicConnDef',
    '244' => 'adaptorVlan',
    '245' => 'adaptorQual',
    '246' => 'adaptorCapQual',
    '247' => 'adaptorCapDef',
    '248' => 'memoryArray',
    '249' => 'memoryBufferUnit',
    '250' => 'memoryUnit',
    '251' => 'memoryQual',
    '252' => 'lsbootADef',
    '253' => 'lsbootDef',
    '254' => 'lsbootPolicy',
    '255' => 'lsbootBootSecurity',
    '256' => 'lsbootItem',
    '257' => 'lsbootCategory',
    '258' => 'lsbootStorage',
    '259' => 'lsbootSan',
    '260' => 'lsbootLan',
    '261' => 'lsbootIScsi',
    '262' => 'lsbootImagePath',
    '263' => 'lsbootLanImagePath',
    '264' => 'lsbootIScsiImagePath',
    '265' => 'lsbootVirtualMedia',
    '266' => 'lsbootImage',
    '267' => 'lsbootRemoteImage',
    '268' => 'lsbootSanImage',
    '269' => 'lsbootSanCatSanImage',
    '270' => 'lsbootLocalImage',
    '271' => 'lsbootLocalStorage',
    '272' => 'lsbootLocalMediaItem',
    '273' => 'lsbootDefaultLocalImage',
    '274' => 'lsbootUsbFlashStorageImage',
    '275' => 'lsbootLocalHddImage',
    '276' => 'lsbootUsbInternalImage',
    '277' => 'lsbootUsbExternalImage',
    '278' => 'lsbootSanImagePath',
    '279' => 'lsbootSanCatSanImagePath',
    '280' => 'lsVConAssign',
    '281' => 'lsServerExtension',
    '282' => 'vmNic',
    '283' => 'vmAdaptor',
    '284' => 'flowctrlDefinition',
    '285' => 'flowctrlItem',
    '286' => 'configImpact',
    '287' => 'iqnpoolTransportBlock',
    '288' => 'equipmentItem',
    '289' => 'equipmentStateful',
    '290' => 'equipmentStatefulBladeComp',
    '291' => 'equipmentPsu',
    '292' => 'equipmentFanModule',
    '293' => 'equipmentFan',
    '294' => 'equipmentXcvr',
    '295' => 'equipmentLocalDiskCapProvider',
    '296' => 'equipmentProcessorUnitCapProvider',
    '297' => 'equipmentBehCap',
    '298' => 'equipmentLocalDiskDef',
    '299' => 'etherPIo',
    '300' => 'etherServerIntFIo',
    '301' => 'storageADef',
    '302' => 'storageConnectionPolicy',
    '303' => 'storageTarget',
    '304' => 'storageFcTargetEp',
    '305' => 'storageVsanRef',
    '306' => 'storageConnectionDef',
    '307' => 'storageIniGroup',
    '308' => 'storageInitiator',
    '309' => 'storageQual',
    '310' => 'storageLocalDiskConfig',
    '311' => 'storageLocalDiskConfigPolicy',
    '312' => 'storageControllerBase',
    '313' => 'storageController',
    '314' => 'storageMezzFlashLife',
    '315' => 'storageFlexFlashController',
    '316' => 'storageDevice',
    '317' => 'storageUnit',
    '318' => 'storagePhysical',
    '319' => 'storageLogical',
    '320' => 'storageLocalDiskBase',
    '321' => 'storageLocalDisk',
    '322' => 'storageRaidBattery',
    '323' => 'storageFlexFlashCard',
    '324' => 'storageFlexFlashDrive',
    '325' => 'storageFlexFlashVirtualDrive',
    '326' => 'epqosDefinition',
    '327' => 'epqosItem',
    '328' => 'epqosEgress',
    '329' => 'qosDefinition',
    '330' => 'qosItem',
    '331' => 'mgmtCimcInterface',
    '332' => 'mgmtInterface',
    '333' => 'mgmtVnet',
    '334' => 'domainFeature',
    '335' => 'domainParameter',
    '336' => 'domainServerFeature',
    '337' => 'domainNetworkFeature',
    '338' => 'domainStorageFeature',
    '339' => 'domainEnvironmentFeature',
    '340' => 'domainServerParam',
    '341' => 'domainNetworkParam',
    '342' => 'domainStorageParam',
    '343' => 'domainEnvironmentParam',
    '344' => 'poolPoolMember',
    '345' => 'networkConn',
    '346' => 'networkEp',
    '347' => 'networkCIoEp',
    '348' => 'networkIfEp',
    '349' => 'networkPhysEp',
    '350' => 'networkVnetEp',
    '351' => 'pciCard',
    '352' => 'processorUnit',
    '353' => 'processorQual',
    '354' => 'iscsiAuthProfile',
    '355' => 'graphicsCard',
    '356' => 'graphicsController',
    '357' => 'biosVFeat',
    '358' => 'biosVProfile',
    '359' => 'biosVfIntelTurboBoostTech',
    '360' => 'biosVfInterleaveConfiguration',
    '361' => 'biosVfDramRefreshRate',
    '362' => 'biosVfEnhancedIntelSpeedStepTech',
    '363' => 'clitestTypeTest',
    '364' => 'biosVfIntelHyperThreadingTech',
    '365' => 'biosVfLocalX2Apic',
    '366' => 'biosVfCoreMultiProcessing',
    '367' => 'clitestTypeTestParent',
    '368' => 'clitestTypeTestChild',
    '369' => 'clitestTypeTest2',
    '370' => 'biosVfExecuteDisableBit',
    '371' => 'biosVfIntelVirtualizationTechnology',
    '372' => 'biosVfIntelVTForDirectedIO',
    '373' => 'biosVfDirectCacheAccess',
    '374' => 'biosVfSelectMemoryRASConfiguration',
    '375' => 'biosVfSparingMode',
    '376' => 'biosVfMirroringMode',
    '377' => 'biosVfNUMAOptimized',
    '378' => 'biosVfIntelEntrySASRAIDModule',
    '379' => 'biosVfOnboardSATAController',
    '380' => 'biosVfOnboardStorage',
    '381' => 'biosVfSerialPortAEnable',
    '382' => 'biosVfMaximumMemoryBelow4GB',
    '383' => 'biosVfMemoryMappedIOAbove4GB',
    '384' => 'biosVfSriovConfig',
    '385' => 'biosVfFrontPanelLockout',
    '386' => 'biosVfAssertNMIOnSERR',
    '387' => 'biosVfAssertNMIOnPERR',
    '388' => 'biosVfResumeOnACPowerLoss',
    '389' => 'biosVfConsoleRedirection',
    '390' => 'biosVfUEFIOSUseLegacyVideo',
    '391' => 'biosVfBootOptionRetry',
    '392' => 'biosVfUSBBootConfig',
    '393' => 'biosVfQuietBoot',
    '394' => 'biosVfPOSTErrorPause',
    '395' => 'biosVfProcessorC3Report',
    '396' => 'biosVfProcessorC6Report',
    '397' => 'biosVfProcessorCState',
    '398' => 'biosVfProcessorC7Report',
    '399' => 'biosVfProcessorC1E',
    '400' => 'biosVfOSBootWatchdogTimer',
    '401' => 'biosVfOSBootWatchdogTimerPolicy',
    '402' => 'biosVfOSBootWatchdogTimerTimeout',
    '403' => 'biosVfACPI10Support',
    '404' => 'biosVfLvDIMMSupport',
    '405' => 'biosVfOptionROMLoad',
    '406' => 'biosVfOptionROMEnable',
    '407' => 'biosVfPCISlotOptionROMEnable',
    '408' => 'biosVfPCISlotLinkSpeed',
    '409' => 'biosVfCPUPerformance',
    '410' => 'biosVfMaxVariableMTRRSetting',
    '411' => 'biosVfUSBSystemIdlePowerOptimizingSetting',
    '412' => 'biosVfUSBFrontPanelAccessLock',
    '413' => 'biosVfUCSMBootOrderRuleControl',
    '414' => 'biosVfUCSMBootModeControl',
    '415' => 'biosVfPackageCStateLimit',
    '416' => 'biosVfAllUSBDevices',
    '417' => 'biosVfUSBPortConfiguration',
    '418' => 'biosVfProcessorPrefetchConfig',
    '419' => 'biosVfScrubPolicies',
    '420' => 'biosVfVGAPriority',
    '421' => 'biosVfFRB2Timer',
    '422' => 'biosVfProcessorEnergyConfiguration',
    '423' => 'biosVfFrequencyFloorOverride',
    '424' => 'biosVfPSTATECoordination',
    '425' => 'biosVfDRAMClockThrottling',
    '426' => 'biosVfQPILinkFrequencySelect',
    '427' => 'biosVfTPMSupport',
    '428' => 'biosVfUSBConfiguration',
    '429' => 'biosVfAltitude',
    '430' => 'biosUnit',
    '431' => 'biosBOT',
    '432' => 'biosBootDevGrp',
    '433' => 'biosBootDev',
    '434' => 'solDef',
    '435' => 'solPolicy',
    '436' => 'fabricVnetEp',
    '437' => 'fabricAVsan',
    '438' => 'fabricEpVlan',
    '439' => 'fabricAVlan',
    '440' => 'fabricVlan',
    '441' => 'fabricVsan',
    '442' => 'fabricMulticastPolicy',
    '443' => 'fabricVnetReq',
    '444' => 'fabricVlanReq',
    '445' => 'fabricVnetGroupReq',
    '446' => 'fabricVlanGroupReq',
    '447' => 'fabricOrgVlanPolicy',
    '448' => 'fabricSan',
    '449' => 'fabricFcSan',
    '450' => 'fabricSanPc',
    '451' => 'fabricFcSanPc',
    '452' => 'fabricSanEp',
    '453' => 'fabricAFcoeSanEp',
    '454' => 'fabricFcoeSanPc',
    '455' => 'fabricFcoeSanEp',
    '456' => 'changeChangedObjectRef',
    '457' => 'fabricLacpPolicy',
    '458' => 'fabricVCon',
    '459' => 'fabricVConProfile',
    '460' => 'fabricLan',
    '461' => 'fabricEthLan',
    '462' => 'fabricCablingSw',
    '463' => 'fabricLanPc',
    '464' => 'fabricEthLanPc',
    '465' => 'fabricUdldPolicy',
    '466' => 'fabricEthLinkProfile',
    '467' => 'fabricEthLinkPolicy',
    '468' => 'fabricEthUdldPolicy',
    '469' => 'fabricEthCdpPolicy',
    '470' => 'fabricUdldLinkPolicy',
    '471' => 'fabricCdpLinkPolicy',
    '472' => 'fabricVnetEpSyncEp',
    '473' => 'fabricChangedObjectRef',
    '474' => 'fabricInternalDceSrv',
    '475' => 'fabricDceSrv',
    '476' => 'fabricExternalEstc',
    '477' => 'fabricEthEstc',
    '478' => 'fabricFcEstc',
    '479' => 'fabricEstcEp',
    '480' => 'fabricEstcPc',
    '481' => 'fabricEthEstcPc',
    '482' => 'fabricAFcoeEstcEp',
    '483' => 'fabricFcoeEstcEp',
    '484' => 'fabricExternalEp',
    '485' => 'fabricPIoEp',
    '486' => 'fabricInternal',
    '487' => 'fabricCloud',
    '488' => 'fabricFcEstcCloud',
    '489' => 'fabricCIoEp',
    '490' => 'fabricExternalPc',
    '491' => 'fabricSanCloud',
    '492' => 'fabricLanCloud',
    '493' => 'fabricCabling',
    '494' => 'fabricEthEstcCloud',
    '495' => 'fabricLinkPolicy',
    '496' => 'fabricDomain',
    '497' => 'fabricLanAccessMgr',
    '498' => 'fabricExternal',
    '499' => 'fabricEp',
    '500' => 'cimcvmediaItem',
    '501' => 'cimcvmediaMountConfig',
    '502' => 'cimcvmediaMountConfigDef',
    '503' => 'cimcvmediaMountConfigPolicy',
    '504' => 'cimcvmediaMountInfo',
    '505' => 'cimcvmediaActualMountList',
    '506' => 'cimcvmediaActualMountEntry',
    '507' => 'cimcvmediaExtMgmtRuleEntry',
    '508' => 'cimcvmediaConfigMountEntry',
    '509' => 'portIntFIo',
    '510' => 'portServerIntFIo',
    '511' => 'portSwitchIntFIo',
    '512' => 'portPhysSwitchIo',
    '513' => 'portPIo',
    '514' => 'fcPIo',
    '515' => 'nwctrlDefinition',
    '516' => 'gmetaPolicyMapElement',
    '517' => 'computeQual',
    '518' => 'computePoolable',
    '519' => 'computePooled',
    '520' => 'computeDefaults',
    '521' => 'computePlatform',
    '522' => 'computeInitConfigPolicy',
    '523' => 'computeAutoconfigPolicy',
    '524' => 'computeBladeInheritPolicy',
    '525' => 'computeScrubPolicy',
    '526' => 'computeKvmMgmtPolicy',
    '527' => 'computeMemoryConfigPolicy',
    '528' => 'computeMemoryConfiguration',
    '529' => 'computeBladeDiscPolicy',
    '530' => 'computeServerMgmtPolicy',
    '531' => 'computeChassisConnPolicy',
    '532' => 'computePsuDef',
    '533' => 'computePsuPolicy',
    '534' => 'computePsuControl',
    '535' => 'computeRackUnit',
    '536' => 'computeMbPowerStats',
    '537' => 'computeMbPowerStatsHist',
    '538' => 'computeMbTempStats',
    '539' => 'computeMbTempStatsHist',
    '540' => 'computeRackUnitMbTempStats',
    '541' => 'computeRackUnitMbTempStatsHist',
    '542' => 'computeIOHubEnvStats',
    '543' => 'computeIOHubEnvStatsHist',
    '544' => 'computePCIeFatalProtocolStats',
    '545' => 'computePCIeFatalReceiveStats',
    '546' => 'computePCIeFatalCompletionStats',
    '547' => 'computePCIeFatalStats',
    '548' => 'domainFeatureCont',
    '549' => 'domainServerFeatureCont',
    '550' => 'domainNetworkFeatureCont',
    '551' => 'domainStorageFeatureCont',
    '552' => 'domainEnvironmentFeatureCont',
    '553' => 'computeContainer',
    '554' => 'computeVirtualContainer',
    '555' => 'computeVirtual',
    '556' => 'computePartition',
    '557' => 'computeBlade',
    '558' => 'computeRtcBattery',
    '559' => 'computeBehCap',
    '560' => 'computePciCap',
    '561' => 'computePciSlotScanDef',
    '562' => 'computeMemoryUnitConstraintDef',
    '563' => 'computePhysicalAssocCtx',
    '564' => 'computeFwSyncAck',
    '565' => 'computeBoardController',
    '566' => 'computePnuOSImage',
    '567' => 'computeHealthLedSensorAlarm',
    '568' => 'firmwareCatalogue',
    '569' => 'firmwareUnit',
    '570' => 'firmwareRunning',
    '571' => 'firmwareUpdatable',
    '572' => 'firmwareBootUnit',
    '573' => 'firmwareBootDefinition',
    '574' => 'firmwareImage',
    '575' => 'firmwareInstallable',
    '576' => 'firmwareDistImage',
    '577' => 'firmwareDistributable',
    '578' => 'firmwareBundleInfo',
    '579' => 'firmwareCspVersion',
    '580' => 'firmwareCspAppList',
    '581' => 'firmwareDistCspBlackList',
    '582' => 'firmwareDownloader',
    '583' => 'firmwareCompItem',
    '584' => 'firmwareCompSource',
    '585' => 'firmwareCompTarget',
    '586' => 'firmwarePack',
    '587' => 'firmwareImageLock',
    '588' => 'firmwareInfraPack',
    '589' => 'firmwarePlatformPack',
    '590' => 'firmwarePackItem',
    '591' => 'firmwareComputePack',
    '592' => 'firmwareComputeHostPack',
    '593' => 'firmwareComputeMgmtPack',
    '594' => 'firmwareCatalogPack',
    '595' => 'firmwareType',
    '596' => 'firmwareConstraints',
    '597' => 'firmwareConstraint',
    '598' => 'firmwareDependency',
    '599' => 'firmwareSystem',
    '600' => 'firmwareInfra',
    '601' => 'firmwarePlatform',
    '602' => 'firmwareSupFirmware',
    '603' => 'firmwareHost',
    '604' => 'firmwareBlade',
    '605' => 'firmwareRack',
    '606' => 'firmwareStatus',
    '607' => 'firmwareSystemCompCheckResult',
    '608' => 'firmwareInstallImpact',
    '609' => 'firmwareHostPackModImpact',
    '610' => 'firmwareAck',
    '611' => 'firmwareUpgradeInfo',
    '612' => 'firmwareUpgradeDetail',
    '613' => 'firmwareBundleInfoDigest',
    '614' => 'firmwareUpgradeConstraint',
    '615' => 'firmwareAutoSyncPolicy',
    '616' => 'firmwareUcscInfo',
    '617' => 'firmwareCapProvider',
    '618' => 'firmwareABundleTypeCapProvider',
    '619' => 'firmwareBundleTypeCapProvider',
    '620' => 'firmwarePlatformBundleTypeCapProvider',
    '621' => 'firmwareBundleType',
    '622' => 'firmwareSpec',
    '623' => 'identIdentCtx',
    '624' => 'identSysInfo',
    '625' => 'identMetaVerse',
    '626' => 'identMetaSystem',
    '627' => 'identIdentRequest',
    '628' => 'identRequestEp',
    '629' => 'lldpAcquired',
    '630' => 'nhtestUniTest',
    '631' => 'powerEp',
    '632' => 'powerPrioWght',
    '633' => 'powerABudget',
    '634' => 'powerPlacement',
    '635' => 'powerGroupAdditionPolicy',
    '636' => 'powerBudget',
    '637' => 'powerProfiledPower',
    '638' => 'powerGroupMember',
    '639' => 'powerChassisMember',
    '640' => 'powerRackUnitMember',
    '641' => 'powerMgmtPolicy',
    '642' => 'powerGroupStats',
    '643' => 'powerGroupStatsHist',
    '644' => 'smSecSvc',
    '645' => 'smSlot',
    '646' => 'smMonitor',
    '647' => 'smHeartbeat',
    '648' => 'smHeartbeatConfig',
    '649' => 'smDiskFileSystem',
    '650' => 'smLDTemplate',
    '651' => 'smTemplateApp',
    '652' => 'smApp',
    '653' => 'smPortRequirement',
    '654' => 'smPortSubType',
    '655' => 'smAppInstance',
    '656' => 'smResource',
    '657' => 'smLogicalDevice',
    '658' => 'smMgmtBootstrap',
    '659' => 'smIP',
    '660' => 'smIPV6',
    '661' => 'smExternalPortLink',
    '662' => 'smMac',
    '663' => 'smSystemMac',
    '664' => 'smUserMac',
    '665' => 'smClusterBootstrap',
    '666' => 'smKey',
    '667' => 'smEncryptedKey',
    '668' => 'smNetMgmtBootstrapValue',
    '669' => 'smNetMgmtBootstrapKeyLimits',
    '670' => 'smNetMgmtBootstrapKeyEnumValue',
    '671' => 'smAppAttribute',
    '672' => 'smAppAttributeValue',
    '673' => 'swSspMonDomain',
    '674' => 'swSspLanMon',
    '675' => 'swSspEthLanMon',
    '676' => 'swSspMon',
    '677' => 'swSspEthMon',
    '678' => 'swSspEthMonSrcPhyEp',
    '679' => 'swSspEthMonSrcAppLinksEp',
    '680' => 'swSspEthMonSrcAppEp',
    '681' => 'swSspEthMonFilterEp',
    '682' => 'swEnvStats',
    '683' => 'swEnvStatsHist',
    '684' => 'swCardEnvStats',
    '685' => 'swCardEnvStatsHist',
    '686' => 'swSystemStats',
    '687' => 'swSystemStatsHist',
    '688' => 'swDomain',
    '689' => 'swPIoEp',
    '690' => 'swPortBreakout',
    '691' => 'swSubGroup',
    '692' => 'swCIoEp',
    '693' => 'swBorderDomain',
    '694' => 'swBorderEp',
    '695' => 'swBorderPc',
    '696' => 'swLanBorder',
    '697' => 'swLanEp',
    '698' => 'swLanPc',
    '699' => 'swPhys',
    '700' => 'swExtUtility',
    '701' => 'swPhysEtherEp',
    '702' => 'swPhysFcEp',
    '703' => 'swEthLanBorder',
    '704' => 'swEthLanEp',
    '705' => 'swMonSrcEp',
    '706' => 'swEthMonSrcEp',
    '707' => 'swFcMonSrcEp',
    '708' => 'swEthLanPc',
    '709' => 'swVlan',
    '710' => 'swVlanGroup',
    '711' => 'swVlanRef',
    '712' => 'swUlan',
    '713' => 'swAccessDomain',
    '714' => 'swAccessEp',
    '715' => 'swEstcEp',
    '716' => 'swFcEstcEp',
    '717' => 'swEthEstcEp',
    '718' => 'swTargetEp',
    '719' => 'swEthTargetEp',
    '720' => 'swEthEstcPc',
    '721' => 'swFcoeEstcEp',
    '722' => 'swUtilityDomain',
    '723' => 'swVlanPortNs',
    '724' => 'swMonDomain',
    '725' => 'swLanMon',
    '726' => 'swSanMon',
    '727' => 'swEthLanMon',
    '728' => 'swFcSanMon',
    '729' => 'swMon',
    '730' => 'swEthMon',
    '731' => 'swFcMon',
    '732' => 'swMonDestEp',
    '733' => 'swEthMonDestEp',
    '734' => 'swFcMonDestEp',
    '735' => 'swVlanPortNsOverride',
    '736' => 'swEthLanFlowMon',
    '737' => 'swFlowMonitor',
    '738' => 'swEthLanFlowMonitor',
    '739' => 'swNetflowMonitor',
    '740' => 'swNetflowMonitorRef',
    '741' => 'swFlowRecordDef',
    '742' => 'swEthLanFlowRecordDef',
    '743' => 'swNetflowRecordDef',
    '744' => 'swFlowMonExporter',
    '745' => 'swEthLanFlowMonExporter',
    '746' => 'swNetflowExporter',
    '747' => 'swEthFlowMonSession',
    '748' => 'swNetflowMonSession',
    '749' => 'swNFExporterRef',
    '750' => 'swIpRoute',
    '751' => 'swVirtL3Intf',
    '752' => 'swSanBorder',
    '753' => 'swSanEp',
    '754' => 'swFcSanBorder',
    '755' => 'swSanPc',
    '756' => 'swFcSanEp',
    '757' => 'swFcoeSanEp',
    '758' => 'swFcSanPc',
    '759' => 'swFcoeSanPc',
    '760' => 'swVsan',
    '761' => 'swFcZoneSet',
    '762' => 'swFcServerZoneGroup',
    '763' => 'swZoneInitiatorMember',
    '764' => 'swFcZone',
    '765' => 'swFcZoneMember',
    '766' => 'swZoneTargetMember',
    '767' => 'swFabricZoneNs',
    '768' => 'swFabricZoneNsOverride',
    '769' => 'swCmclan',
    '770' => 'dcxVifEp',
    '771' => 'dcxFcoeVifEp',
    '772' => 'dcxVIf',
    '773' => 'dcxUniverse',
    '774' => 'dcxNs',
    '775' => 'vnicTempl',
    '776' => 'vnicSanConnTempl',
    '777' => 'vnicLanConnTempl',
    '778' => 'vnicFcGroupTempl',
    '779' => 'vnicProfileSet',
    '780' => 'vnicProfile',
    '781' => 'vnicVProfileAlias',
    '782' => 'vnicProfileAlias',
    '783' => 'vnicOProfileAlias',
    '784' => 'vnicInternalProfile',
    '785' => 'vnicDynamicCon',
    '786' => 'vnicDynamicIdUniverse',
    '787' => 'vnicDynamicProvider',
    '788' => 'vnicDynamicProviderEp',
    '789' => 'vnicRackServerDiscoveryProfile',
    '790' => 'vnicProfileRef',
    '791' => 'vnicVnic',
    '792' => 'vnicEtherBase',
    '793' => 'vnicMacHistory',
    '794' => 'vnicWwpnHistory',
    '795' => 'vnicWwnnHistory',
    '796' => 'vnicIqnHistory',
    '797' => 'vnicIpV4History',
    '798' => 'vnicIpV6History',
    '799' => 'vnicEther',
    '800' => 'vnicFcBase',
    '801' => 'vnicFc',
    '802' => 'vnicIScsiBase',
    '803' => 'vnicIScsiLCP',
    '804' => 'vnicIScsi',
    '805' => 'vnicIpc',
    '806' => 'vnicScsi',
    '807' => 'vnicAGroup',
    '808' => 'vnicFcGroupDef',
    '809' => 'vnicL2Lif',
    '810' => 'vnicEthLif',
    '811' => 'vnicFcLif',
    '812' => 'vnicLifVlan',
    '813' => 'vnicLifVsan',
    '814' => 'vnicAIpcIf',
    '815' => 'vnicAScsiIf',
    '816' => 'vnicIpcIf',
    '817' => 'vnicScsiIf',
    '818' => 'macpoolPool',
    '819' => 'macpoolPooled',
    '820' => 'macpoolFormat',
    '821' => 'macpoolBlock',
    '822' => 'macpoolAddr',
    '823' => 'macpoolPoolable',
    '824' => 'macpoolUniverse',
    '825' => 'callhomeItem',
    '826' => 'callhomeEp',
    '827' => 'callhomeSource',
    '828' => 'callhomeSmtp',
    '829' => 'callhomeAnonymousReporting',
    '830' => 'callhomePeriodicSystemInventory',
    '831' => 'callhomeProfile',
    '832' => 'callhomeDest',
    '833' => 'callhomePolicy',
    '834' => 'callhomeHttpProxy',
    '835' => 'callhomeTestAlert',
    '836' => 'adaptorUnitExtn',
    '837' => 'adaptorHostPort',
    '838' => 'adaptorVsan',
    '839' => 'adaptorFcOEIf',
    '840' => 'adaptorUnitAssocCtx',
    '841' => 'adaptorCIoEp',
    '842' => 'adaptorExternalPc',
    '843' => 'adaptorExtIfPc',
    '844' => 'adaptorExtEthIfPc',
    '845' => 'adaptorPIoEp',
    '846' => 'adaptorExternalEp',
    '847' => 'adaptorExtIfEp',
    '848' => 'adaptorExtEthIfPcEp',
    '849' => 'adaptorHostServiceEthIf',
    '850' => 'adaptorHostIscsiIf',
    '851' => 'adaptorIscsiTargetIf',
    '852' => 'adaptorIscsiProt',
    '853' => 'adaptorIscsiAuth',
    '854' => 'adaptorEthPortStats',
    '855' => 'adaptorEthPortStatsHist',
    '856' => 'adaptorEthPortBySizeSmallStats',
    '857' => 'adaptorEthPortBySizeSmallStatsHist',
    '858' => 'adaptorEthPortBySizeLargeStats',
    '859' => 'adaptorEthPortBySizeLargeStatsHist',
    '860' => 'adaptorEthPortOutsizedStats',
    '861' => 'adaptorEthPortOutsizedStatsHist',
    '862' => 'adaptorEthPortMcastStats',
    '863' => 'adaptorEthPortMcastStatsHist',
    '864' => 'adaptorEthPortErrStats',
    '865' => 'adaptorEthPortErrStatsHist',
    '866' => 'adaptorFcPortStats',
    '867' => 'adaptorFcPortStatsHist',
    '868' => 'adaptorVnicStats',
    '869' => 'adaptorVnicStatsHist',
    '870' => 'adaptorFcIfFC4Stats',
    '871' => 'adaptorFcIfFC4StatsHist',
    '872' => 'adaptorMenloBaseErrorStats',
    '873' => 'adaptorMenloBaseErrorStatsHist',
    '874' => 'adaptorMenloMcpuStats',
    '875' => 'adaptorMenloMcpuStatsHist',
    '876' => 'adaptorMenloMcpuErrorStats',
    '877' => 'adaptorMenloMcpuErrorStatsHist',
    '878' => 'adaptorMenloEthStats',
    '879' => 'adaptorMenloEthStatsHist',
    '880' => 'adaptorMenloEthErrorStats',
    '881' => 'adaptorMenloEthErrorStatsHist',
    '882' => 'adaptorMenloFcStats',
    '883' => 'adaptorMenloFcStatsHist',
    '884' => 'adaptorMenloFcErrorStats',
    '885' => 'adaptorMenloFcErrorStatsHist',
    '886' => 'adaptorMenloQStats',
    '887' => 'adaptorMenloQStatsHist',
    '888' => 'adaptorMenloQErrorStats',
    '889' => 'adaptorMenloQErrorStatsHist',
    '890' => 'adaptorMenloNetEgStats',
    '891' => 'adaptorMenloNetEgStatsHist',
    '892' => 'adaptorMenloNetInStats',
    '893' => 'adaptorMenloNetInStatsHist',
    '894' => 'adaptorMenloHostPortStats',
    '895' => 'adaptorMenloHostPortStatsHist',
    '896' => 'adaptorMenloDcePortStats',
    '897' => 'adaptorMenloDcePortStatsHist',
    '898' => 'adaptorEtherIfStats',
    '899' => 'adaptorEtherIfStatsHist',
    '900' => 'adaptorFcIfFrameStats',
    '901' => 'adaptorFcIfFrameStatsHist',
    '902' => 'adaptorFcIfEventStats',
    '903' => 'adaptorFcIfEventStatsHist',
    '904' => 'adaptorFwCapProvider',
    '905' => 'adaptorFruCapRef',
    '906' => 'adaptorLldpCap',
    '907' => 'adaptorLanCap',
    '908' => 'adaptorSanCap',
    '909' => 'adaptorMgmtCap',
    '910' => 'adaptorNwMgmtCap',
    '911' => 'adaptorHostMgmtCap',
    '912' => 'adaptorUplinkHwAddrCap',
    '913' => 'adaptorHostethHwAddrCap',
    '914' => 'adaptorHostfcHwAddrCap',
    '915' => 'adaptorFamilyTypeDef',
    '916' => 'adaptorDiagCap',
    '917' => 'adaptorHostPortCap',
    '918' => 'licenseEp',
    '919' => 'licenseFeature',
    '920' => 'licenseServerHostId',
    '921' => 'licenseFile',
    '922' => 'licenseSource',
    '923' => 'licenseContents',
    '924' => 'licenseFeatureLine',
    '925' => 'licenseInstance',
    '926' => 'licenseSourceFile',
    '927' => 'licenseProp',
    '928' => 'licenseDownloader',
    '929' => 'licenseSmartConfig',
    '930' => 'licenseTarget',
    '931' => 'licenseCapProvider',
    '932' => 'licenseFeatureCapProvider',
    '933' => 'memoryRuntime',
    '934' => 'memoryRuntimeHist',
    '935' => 'memoryArrayEnvStats',
    '936' => 'memoryArrayEnvStatsHist',
    '937' => 'memoryBufferUnitEnvStats',
    '938' => 'memoryBufferUnitEnvStatsHist',
    '939' => 'memoryUnitEnvStats',
    '940' => 'memoryUnitEnvStatsHist',
    '941' => 'memoryErrorStats',
    '942' => 'imgprovPolicy',
    '943' => 'imgprovTarget',
    '944' => 'imgsecPolicy',
    '945' => 'imgsecKey',
    '946' => 'hostimgPolicy',
    '947' => 'hostimgTarget',
    '948' => 'lsmaintMaintPolicy',
    '949' => 'lsmaintAck',
    '950' => 'lsServer',
    '951' => 'lsIssues',
    '952' => 'lsUuidHistory',
    '953' => 'lsPower',
    '954' => 'lsComputeBinding',
    '955' => 'lsBinding',
    '956' => 'lsRequirement',
    '957' => 'lsAgentPolicy',
    '958' => 'lsServerAssocCtx',
    '959' => 'lsFcLocale',
    '960' => 'lsFcZoneGroup',
    '961' => 'lsZoneInitiatorMember',
    '962' => 'lsFcZone',
    '963' => 'lsFcZoneMember',
    '964' => 'lsZoneTargetMember',
    '965' => 'lsVersionBeh',
    '966' => 'lsTier',
    '967' => 'extvmmNetworkSets',
    '968' => 'extvmmVMNetworkSets',
    '969' => 'extvmmFabricNetwork',
    '970' => 'extvmmFabricNetworkDefinition',
    '971' => 'extvmmVMNetworkDefinition',
    '972' => 'extvmmVMNetwork',
    '973' => 'extvmmVMNDRef',
    '974' => 'extvmmUpLinkPP',
    '975' => 'extvmmFNDReference',
    '976' => 'vmLifeCyclePolicy',
    '977' => 'vmCont',
    '978' => 'vmDirCont',
    '979' => 'vmDCOrg',
    '980' => 'vmDC',
    '981' => 'vmOrg',
    '982' => 'vmSwitch',
    '983' => 'vmVnicProfInst',
    '984' => 'vmVnicProfCl',
    '985' => 'extvmmEp',
    '986' => 'extvmmMasterExtKey',
    '987' => 'extvmmKeyInst',
    '988' => 'extvmmKeyStore',
    '989' => 'extvmmKeyRing',
    '990' => 'extvmmSwitchSet',
    '991' => 'extvmmProvider',
    '992' => 'extvmmSwitchDelTask',
    '993' => 'vmEp',
    '994' => 'vmClientContainer',
    '995' => 'vmVirtual',
    '996' => 'vmComputeEp',
    '997' => 'vmHv',
    '998' => 'vmInstance',
    '999' => 'vmHba',
    '1000' => 'vmVlan',
    '1001' => 'vmVsan',
    '1002' => 'vmVif',
    '1003' => 'configImpactResponse',
    '1004' => 'configManagedEpImpactResponse',
    '1005' => 'configSorter',
    '1006' => 'iqnpoolPool',
    '1007' => 'iqnpoolPooled',
    '1008' => 'iqnpoolAbsBlock',
    '1009' => 'iqnpoolBlock',
    '1010' => 'iqnpoolAddr',
    '1011' => 'iqnpoolFormat',
    '1012' => 'iqnpoolPoolable',
    '1013' => 'iqnpoolUniverse',
    '1014' => 'rmetaClass',
    '1015' => 'rmetaProp',
    '1016' => 'rmetaRnComponent',
    '1017' => 'ipDnsSuffix',
    '1018' => 'ipIPv4WinsServer',
    '1019' => 'observeObservedCont',
    '1020' => 'observeObserved',
    '1021' => 'observeFilter',
    '1022' => 'featureDefinition',
    '1023' => 'featureProvider',
    '1024' => 'featureBaseRef',
    '1025' => 'featureDefinitionRef',
    '1026' => 'featureDefinitionInstance',
    '1027' => 'featureFruCapProviderRef',
    '1028' => 'featureFruCapProviderInstance',
    '1029' => 'featureContextEp',
    '1030' => 'featureProviderInstance',
    '1031' => 'computeNpu',
    '1032' => 'equipmentHolder',
    '1033' => 'equipmentStatefulChComp',
    '1034' => 'equipmentEnvSensor',
    '1035' => 'equipmentCard',
    '1036' => 'equipmentIOCardBase',
    '1037' => 'equipmentSwitchCard',
    '1038' => 'equipmentBeaconLed',
    '1039' => 'equipmentChassis',
    '1040' => 'equipmentRommon',
    '1041' => 'equipmentFpga',
    '1042' => 'equipmentIOCard',
    '1043' => 'equipmentSwitchIOCard',
    '1044' => 'equipmentLed',
    '1045' => 'equipmentIndicatorLed',
    '1046' => 'equipmentLocatorLed',
    '1047' => 'equipmentHealthLed',
    '1048' => 'equipmentAssocCtx',
    '1049' => 'equipmentFex',
    '1050' => 'equipmentHwCapProvider',
    '1051' => 'equipmentPicture',
    '1052' => 'equipmentFruCapProvider',
    '1053' => 'equipmentIntegratedComponentCapProvider',
    '1054' => 'equipmentHolderCapProvider',
    '1055' => 'equipmentSwitchCapProvider',
    '1056' => 'equipmentSwitchIOCardCapProvider',
    '1057' => 'equipmentSwitchCap',
    '1058' => 'equipmentPortCap',
    '1059' => 'equipmentBreakOutCapProvider',
    '1060' => 'equipmentFailToWireCapProvider',
    '1061' => 'equipmentFailToWirePortDef',
    '1062' => 'equipmentUnifiedPortCapProvider',
    '1063' => 'equipmentMaxPortSpeedCapProvider',
    '1064' => 'equipmentServerPortCapProvider',
    '1065' => 'equipmentBeaconCapProvider',
    '1066' => 'equipmentMgmtCapProvider',
    '1067' => 'equipmentCatalogCapProvider',
    '1068' => 'equipmentMgmtExtCapProvider',
    '1069' => 'equipmentDbgPluginCapProvider',
    '1070' => 'equipmentChassisCapProvider',
    '1071' => 'equipmentBladeCapProvider',
    '1072' => 'equipmentRackUnitCapProvider',
    '1073' => 'equipmentAdvancedBootOrder',
    '1074' => 'equipmentCimcVmedia',
    '1075' => 'equipmentSecureBoot',
    '1076' => 'equipmentPowerCapDef',
    '1077' => 'equipmentBladeAGLibrary',
    '1078' => 'equipmentBaseBoardCapProvider',
    '1079' => 'equipmentTpmCapProvider',
    '1080' => 'equipmentBladeBiosCapProvider',
    '1081' => 'equipmentGraphicsCardCapProvider',
    '1082' => 'equipmentGraphicsCardCapRef',
    '1083' => 'equipmentLocalDiskControllerCapProvider',
    '1084' => 'equipmentLocalDiskControllerCapRef',
    '1085' => 'equipmentHostIfCapProvider',
    '1086' => 'equipmentMemoryUnitCapProvider',
    '1087' => 'equipmentIOCardCapProvider',
    '1088' => 'equipmentFexCapProvider',
    '1089' => 'equipmentPsuCapProvider',
    '1090' => 'equipmentFanModuleCapProvider',
    '1091' => 'equipmentGemCapProvider',
    '1092' => 'equipmentGemPortCap',
    '1093' => 'equipmentDiscoveryCap',
    '1094' => 'equipmentSecureController',
    '1095' => 'equipmentTpm',
    '1096' => 'equipmentManufacturingDef',
    '1097' => 'equipmentRackFanModuleDef',
    '1098' => 'equipmentPhysicalDef',
    '1099' => 'equipmentInbandMgmtCap',
    '1100' => 'equipmentKvmMgmtCap',
    '1101' => 'equipmentBiosDef',
    '1102' => 'equipmentDimmMapping',
    '1103' => 'equipmentDimmEntry',
    '1104' => 'equipmentServiceDef',
    '1105' => 'equipmentAdaptorDef',
    '1106' => 'equipmentPciDef',
    '1107' => 'equipmentProcessorUnitDef',
    '1108' => 'equipmentRaidDef',
    '1109' => 'equipmentFlashLife',
    '1110' => 'equipmentHDDFaultMonDef',
    '1111' => 'equipmentPortGroupDef',
    '1112' => 'equipmentFanModuleDef',
    '1113' => 'equipmentPsuDef',
    '1114' => 'equipmentPortGroupAggregationDef',
    '1115' => 'equipmentPortGroupSwComplexDef',
    '1116' => 'equipmentPortSwComplexRef',
    '1117' => 'equipmentBoardControllerDef',
    '1118' => 'equipmentFirmwareConstraint',
    '1119' => 'equipmentVersionConstraint',
    '1120' => 'equipmentBladeAggregationCapRef',
    '1121' => 'equipmentPhysDevicesPerBoard',
    '1122' => 'equipmentDowngradeConstraint',
    '1123' => 'equipmentLocalDiskControllerDef',
    '1124' => 'equipmentMemoryUnitDiscoveryModifierDef',
    '1125' => 'equipmentSlotArrayRef',
    '1126' => 'equipmentSlotArray',
    '1127' => 'equipmentBladeConnDef',
    '1128' => 'equipmentBladeIOMConnDef',
    '1129' => 'equipmentBladeSwitchConnDef',
    '1130' => 'equipmentAdaptorConnDef',
    '1131' => 'equipmentIOCardTypeDef',
    '1132' => 'equipmentSwitchTypeDef',
    '1133' => 'equipmentServerFeatureCap',
    '1134' => 'equipmentUuidFeatureCap',
    '1135' => 'equipmentChassisStats',
    '1136' => 'equipmentChassisStatsHist',
    '1137' => 'equipmentIOCardStats',
    '1138' => 'equipmentIOCardStatsHist',
    '1139' => 'equipmentPsuStats',
    '1140' => 'equipmentPsuStatsHist',
    '1141' => 'equipmentPsuInputStats',
    '1142' => 'equipmentPsuInputStatsHist',
    '1143' => 'equipmentPsuOutputStats',
    '1144' => 'equipmentPsuOutputStatsHist',
    '1145' => 'equipmentFanModuleStats',
    '1146' => 'equipmentFanModuleStatsHist',
    '1147' => 'equipmentFanStats',
    '1148' => 'equipmentFanStatsHist',
    '1149' => 'equipmentFexEnvStats',
    '1150' => 'equipmentFexEnvStatsHist',
    '1151' => 'equipmentFexPowerSummary',
    '1152' => 'equipmentFexPowerSummaryHist',
    '1153' => 'equipmentFexPsuInputStats',
    '1154' => 'equipmentFexPsuInputStatsHist',
    '1155' => 'equipmentRackUnitPsuStats',
    '1156' => 'equipmentRackUnitPsuStatsHist',
    '1157' => 'equipmentNetworkElementFanStats',
    '1158' => 'equipmentNetworkElementFanStatsHist',
    '1159' => 'equipmentRackUnitFanStats',
    '1160' => 'equipmentRackUnitFanStatsHist',
    '1161' => 'sdSysSecSvc',
    '1162' => 'sdSlot',
    '1163' => 'sdAppInstance',
    '1164' => 'sdResource',
    '1165' => 'sdLogicalDevice',
    '1166' => 'sdExternalPortLink',
    '1167' => 'sdMac',
    '1168' => 'sdSystemMac',
    '1169' => 'sdUserMac',
    '1170' => 'sdClusterBootstrap',
    '1171' => 'sdLdu',
    '1172' => 'sdLink',
    '1173' => 'sdExternalLduLink',
    '1174' => 'sdAppLduLink',
    '1175' => 'sdNPPortCfg',
    '1176' => 'sdNPInterfaceCfg',
    '1177' => 'sdNPPortBundleCfg',
    '1178' => 'sdMgmtBootstrap',
    '1179' => 'sdIP',
    '1180' => 'sdIPV6',
    '1181' => 'sdKey',
    '1182' => 'sdEncryptedKey',
    '1183' => 'sdAppAttribute',
    '1184' => 'sdAppAttributeCtrl',
    '1185' => 'sdMgmtInfo',
    '1186' => 'sdNetMgmtBootstrap',
    '1187' => 'sdInternalMgmtBootstrap',
    '1188' => 'sdUpgradeTask',
    '1189' => 'etherPortChanIdElem',
    '1190' => 'etherPortChanIdUniverse',
    '1191' => 'etherPIoEndPoint',
    '1192' => 'etherSwitchIntFIo',
    '1193' => 'etherConfig',
    '1194' => 'etherIfConfig',
    '1195' => 'etherSwIfConfig',
    '1196' => 'etherNicIfConfig',
    '1197' => 'etherCIoEp',
    '1198' => 'etherPc',
    '1199' => 'etherInternalPc',
    '1200' => 'etherExternalPc',
    '1201' => 'etherServerIntFIoPc',
    '1202' => 'etherSwitchIntFIoPc',
    '1203' => 'etherPIoEp',
    '1204' => 'etherExternalEp',
    '1205' => 'etherIntFIoEp',
    '1206' => 'etherServerIntFIoPcEp',
    '1207' => 'etherSwitchIntFIoPcEp',
    '1208' => 'etherFailToWire',
    '1209' => 'etherFtwPortPair',
    '1210' => 'etherTxStats',
    '1211' => 'etherTxStatsHist',
    '1212' => 'etherRxStats',
    '1213' => 'etherRxStatsHist',
    '1214' => 'etherErrStats',
    '1215' => 'etherErrStatsHist',
    '1216' => 'etherNiErrStats',
    '1217' => 'etherNiErrStatsHist',
    '1218' => 'etherLossStats',
    '1219' => 'etherLossStatsHist',
    '1220' => 'etherPauseStats',
    '1221' => 'etherPauseStatsHist',
    '1222' => 'etherFcoeInterfaceStats',
    '1223' => 'etherFcoeInterfaceStatsHist',
    '1224' => 'extpolConnectorContainer',
    '1225' => 'extpolEp',
    '1226' => 'extpolConnector',
    '1227' => 'extpolSvc',
    '1228' => 'extpolRegistry',
    '1229' => 'extpolProviderCont',
    '1230' => 'extpolProvider',
    '1231' => 'extpolControllerCont',
    '1232' => 'extpolController',
    '1233' => 'extpolClientCont',
    '1234' => 'extpolClient',
    '1235' => 'extpolSystemContext',
    '1236' => 'storageEp',
    '1237' => 'storageNodeEp',
    '1238' => 'storageEpUser',
    '1239' => 'storageAuthKey',
    '1240' => 'storageTransportIf',
    '1241' => 'storageTargetIf',
    '1242' => 'storageIScsiTargetIf',
    '1243' => 'storageFcTargetIf',
    '1244' => 'storageL2If',
    '1245' => 'storageFcIf',
    '1246' => 'storageEtherIf',
    '1247' => 'storageSystem',
    '1248' => 'ipIpV4Addr',
    '1249' => 'ipIPv4Dns',
    '1250' => 'ipServiceIf',
    '1251' => 'ipIpV4StaticAddr',
    '1252' => 'initiatorEp',
    '1253' => 'initiatorRequestorEp',
    '1254' => 'initiatorGroupEp',
    '1255' => 'initiatorInitiatorEp',
    '1256' => 'initiatorIScsiInitiatorEp',
    '1257' => 'initiatorFcInitiatorEp',
    '1258' => 'initiatorStoreEp',
    '1259' => 'initiatorUnitEp',
    '1260' => 'initiatorLunEp',
    '1261' => 'initiatorRequestorGrpEp',
    '1262' => 'initiatorMemberEp',
    '1263' => 'storageOperation',
    '1264' => 'storageDomainEp',
    '1265' => 'storageDrive',
    '1266' => 'storageTransportableFlashModule',
    '1267' => 'storageLocalLun',
    '1268' => 'storageVirtualDrive',
    '1269' => 'storageLocalDiskSlotEp',
    '1270' => 'storageEnclosure',
    '1271' => 'storageLunDisk',
    '1272' => 'storageItem',
    '1273' => 'storageLocalDiskConfigDef',
    '1274' => 'storageLocalDiskPartition',
    '1275' => 'sysfileEp',
    '1276' => 'sysfileRepository',
    '1277' => 'sysfileExporter',
    '1278' => 'sysfileImporter',
    '1279' => 'sysfileMutation',
    '1280' => 'sysfileInstance',
    '1281' => 'sysfileDigest',
    '1282' => 'ippoolPool',
    '1283' => 'ippoolPooled',
    '1284' => 'ippoolIpV6Pooled',
    '1285' => 'ippoolBlock',
    '1286' => 'ippoolIpV6Block',
    '1287' => 'ippoolAddr',
    '1288' => 'ippoolIpV6Addr',
    '1289' => 'ippoolPoolable',
    '1290' => 'ippoolUniverse',
    '1291' => 'applicationCatalogue',
    '1292' => 'applicationDownloader',
    '1293' => 'pkiEp',
    '1294' => 'pkiItem',
    '1295' => 'pkiCertReq',
    '1296' => 'pkiKeyRing',
    '1297' => 'pkiTP',
    '1298' => 'aaaDefinition',
    '1299' => 'aaaItem',
    '1300' => 'commDefinition',
    '1301' => 'commItem',
    '1302' => 'pkiDefinition',
    '1303' => 'aaaRealm',
    '1304' => 'aaaConfig',
    '1305' => 'aaaAuthMethod',
    '1306' => 'aaaDefaultAuth',
    '1307' => 'aaaConsoleAuth',
    '1308' => 'aaaDomainAuth',
    '1309' => 'aaaDomain',
    '1310' => 'aaaAuthRealm',
    '1311' => 'aaaEp',
    '1312' => 'aaaRadiusEp',
    '1313' => 'aaaLdapEp',
    '1314' => 'aaaTacacsPlusEp',
    '1315' => 'aaaProvider',
    '1316' => 'aaaRadiusProvider',
    '1317' => 'aaaLdapProvider',
    '1318' => 'aaaTacacsPlusProvider',
    '1319' => 'aaaLdapGroupRule',
    '1320' => 'aaaUserGroup',
    '1321' => 'aaaLdapGroup',
    '1322' => 'aaaProviderGroup',
    '1323' => 'aaaProviderRef',
    '1324' => 'aaaUserEp',
    '1325' => 'aaaSystemUser',
    '1326' => 'aaaEpAuthProfile',
    '1327' => 'aaaUserLogin',
    '1328' => 'aaaBanner',
    '1329' => 'aaaPreLoginBanner',
    '1330' => 'aaaShellLogin',
    '1331' => 'aaaWebLogin',
    '1332' => 'aaaEpLogin',
    '1333' => 'aaaRemoteUser',
    '1334' => 'aaaEpUser',
    '1335' => 'aaaUser',
    '1336' => 'aaaSshAuth',
    '1337' => 'aaaUserRole',
    '1338' => 'aaaRole',
    '1339' => 'aaaUserLocale',
    '1340' => 'aaaLocale',
    '1341' => 'aaaOrg',
    '1342' => 'aaaSession',
    '1343' => 'aaaExtMgmtCutThruTkn',
    '1344' => 'aaaPwdProfile',
    '1345' => 'aaaUserData',
    '1346' => 'aaaCimcSession',
    '1347' => 'aaaSessionInfoTable',
    '1348' => 'aaaSessionInfo',
    '1349' => 'commSvcEp',
    '1350' => 'commSvcChannel',
    '1351' => 'commWebChannel',
    '1352' => 'commEvtChannel',
    '1353' => 'commSvc',
    '1354' => 'commWeb',
    '1355' => 'commHttps',
    '1356' => 'commWsman',
    '1357' => 'commShell',
    '1358' => 'commTelnet',
    '1359' => 'commSsh',
    '1360' => 'commSnmp',
    '1361' => 'commSnmpUser',
    '1362' => 'commDateTime',
    '1363' => 'commSnmpTrap',
    '1364' => 'commDns',
    '1365' => 'commClient',
    '1366' => 'commClientItem',
    '1367' => 'commNtpProvider',
    '1368' => 'commDnsProvider',
    '1369' => 'commSyslog',
    '1370' => 'commSyslogConsole',
    '1371' => 'commSyslogMonitor',
    '1372' => 'commSyslogFile',
    '1373' => 'commSyslogClient',
    '1374' => 'commSyslogSource',
    '1375' => 'commSvcLimits',
    '1376' => 'commShellSvcLimits',
    '1377' => 'commWebSvcLimits',
    '1378' => 'sysdebugEp',
    '1379' => 'sysdebugRepository',
    '1380' => 'sysdebugCoreFileRepository',
    '1381' => 'sysdebugExporter',
    '1382' => 'sysdebugCoreFileExportTarget',
    '1383' => 'sysdebugLogExportStatus',
    '1384' => 'sysdebugLogExportPolicy',
    '1385' => 'sysdebugAutoCoreFileExportTarget',
    '1386' => 'sysdebugManualCoreFileExportTarget',
    '1387' => 'sysdebugFile',
    '1388' => 'sysdebugCore',
    '1389' => 'sysdebugTechSupFileRepository',
    '1390' => 'sysdebugTechSupport',
    '1391' => 'sysdebugTechSupportCmdOpt',
    '1392' => 'sysdebugLogControlEp',
    '1393' => 'sysdebugLogControlDomain',
    '1394' => 'sysdebugLogControlModule',
    '1395' => 'sysdebugLogControlDestinationFile',
    '1396' => 'sysdebugLogControlDestinationSyslog',
    '1397' => 'sysdebugMEpLog',
    '1398' => 'sysdebugMEpLogDef',
    '1399' => 'sysdebugMEpLogPolicy',
    '1400' => 'sysdebugLogBehavior',
    '1401' => 'sysdebugBackupBehavior',
    '1402' => 'procManager',
    '1403' => 'procProcCounts',
    '1404' => 'procTxCounts',
    '1405' => 'procStimulusCounts',
    '1406' => 'procPrtCounts',
    '1407' => 'procProcs',
    '1408' => 'procPrt',
    '1409' => 'procDoer',
    '1410' => 'procSvc',
    '1411' => 'diagSrvCapProvider',
    '1412' => 'diagCtrl',
    '1413' => 'diagRslt',
    '1414' => 'diagSrvCtrl',
    '1415' => 'diagRunPolicy',
    '1416' => 'diagTest',
    '1417' => 'diagBladeTest',
    '1418' => 'diagNetworkTest',
    '1419' => 'versionEp',
    '1420' => 'versionVersion',
    '1421' => 'versionApplication',
    '1422' => 'epqosDefinitionDelTask',
    '1423' => 'qosclassDefinition',
    '1424' => 'qosclassItem',
    '1425' => 'qosclassFc',
    '1426' => 'qosclassEth',
    '1427' => 'qosclassEthBE',
    '1428' => 'qosclassEthClassified',
    '1429' => 'extmgmtIf',
    '1430' => 'extmgmtIfMonPolicy',
    '1431' => 'extmgmtMiiStatus',
    '1432' => 'extmgmtGatewayPing',
    '1433' => 'extmgmtNdiscTargets',
    '1434' => 'extmgmtArpTargets',
    '1435' => 'poolUniverse',
    '1436' => 'poolElement',
    '1437' => 'poolPoolable',
    '1438' => 'poolPool',
    '1439' => 'networkElement',
    '1440' => 'networkOperLevel',
    '1441' => 'networkLanNeighbors',
    '1442' => 'networkANeighborEntry',
    '1443' => 'networkLanNeighborEntry',
    '1444' => 'networkSanNeighbors',
    '1445' => 'networkSanNeighborEntry',
    '1446' => 'networkIfStats',
    '1447' => 'networkDomainEp',
    '1448' => 'networkPIoEp',
    '1449' => 'fcpoolInitiators',
    '1450' => 'fcpoolInitiator',
    '1451' => 'fcpoolInitiatorEp',
    '1452' => 'fcpoolBlock',
    '1453' => 'fcpoolFormat',
    '1454' => 'fcpoolAddr',
    '1455' => 'fcpoolPoolable',
    '1456' => 'fcpoolUniverse',
    '1457' => 'fcpoolBootTarget',
    '1458' => 'nhTableHolder',
    '1459' => 'nhLinkTable',
    '1460' => 'nhEcmpIdent',
    '1461' => 'nhIpmcIdent',
    '1462' => 'nhLdevItem',
    '1463' => 'nhInstItem',
    '1464' => 'nhLinks',
    '1465' => 'nhEndPoint',
    '1466' => 'nhPortCfg',
    '1467' => 'nhMacVlanCfg',
    '1468' => 'nhSystemMac',
    '1469' => 'nhUserMac',
    '1470' => 'trigAck',
    '1471' => 'trigConfAck',
    '1472' => 'trigResAck',
    '1473' => 'trigInst',
    '1474' => 'trigWindow',
    '1475' => 'trigToken',
    '1476' => 'trigClientToken',
    '1477' => 'trigBaseSched',
    '1478' => 'trigSched',
    '1479' => 'trigLocalSched',
    '1480' => 'trigSchedWindow',
    '1481' => 'trigBaseAbsWindow',
    '1482' => 'trigAbsWindow',
    '1483' => 'trigLocalAbsWindow',
    '1484' => 'trigRecurrWindow',
    '1485' => 'trigMeta',
    '1486' => 'trigTriggered',
    '1487' => 'trigTriggerable',
    '1488' => 'trigTest',
    '1489' => 'dhcpInst',
    '1490' => 'dhcpLease',
    '1491' => 'dhcpAcquired',
    '1492' => 'osInstance',
    '1493' => 'osController',
    '1494' => 'osAgent',
    '1495' => 'pciEquipSlot',
    '1496' => 'pciUnit',
    '1497' => 'uuidpoolPool',
    '1498' => 'uuidpoolPooled',
    '1499' => 'uuidpoolBlock',
    '1500' => 'uuidpoolAddr',
    '1501' => 'uuidpoolFormat',
    '1502' => 'uuidpoolPoolable',
    '1503' => 'uuidpoolUniverse',
    '1504' => 'processorComponent',
    '1505' => 'processorCore',
    '1506' => 'processorThread',
    '1507' => 'processorRuntime',
    '1508' => 'processorRuntimeHist',
    '1509' => 'processorEnvStats',
    '1510' => 'processorEnvStatsHist',
    '1511' => 'processorErrorStats',
    '1512' => 'processorUnitAssocCtx',
    '1513' => 'biosSettings',
    '1514' => 'biosARef',
    '1515' => 'biosRef',
    '1516' => 'biosFeatureRef',
    '1517' => 'biosParameterRef',
    '1518' => 'biosSettingRef',
    '1519' => 'biosVIdentityParams',
    '1520' => 'syntheticDirectory',
    '1521' => 'syntheticFile',
    '1522' => 'syntheticFsObj',
    '1523' => 'syntheticTime',
    '1524' => 'syntheticFileSystem',
    '1525' => 'policyObject',
    '1526' => 'policyHolder',
    '1527' => 'policyBinding',
    '1528' => 'policyDefinition',
    '1529' => 'policyItem',
    '1530' => 'orgOrg',
    '1531' => 'orgSourceMask',
    '1532' => 'capabilityCatalogue',
    '1533' => 'capabilityProvider',
    '1534' => 'capabilityDef',
    '1535' => 'capabilityItem',
    '1536' => 'capabilityFeatureLimits',
    '1537' => 'capabilitySystemLimits',
    '1538' => 'capabilityNetworkLimits',
    '1539' => 'capabilityStorageLimits',
    '1540' => 'capabilityEp',
    '1541' => 'capabilityMgmtExtension',
    '1542' => 'capabilityUpdater',
    '1543' => 'capabilityUpdate',
    '1544' => 'solConfig',
    '1545' => 'solIf',
    '1546' => 'fabricLanMonCloud',
    '1547' => 'fabricSanMonCloud',
    '1548' => 'fabricEthMonLan',
    '1549' => 'fabricFcMonSan',
    '1550' => 'fabricMon',
    '1551' => 'fabricEthMon',
    '1552' => 'fabricFcMon',
    '1553' => 'fabricMonDestEp',
    '1554' => 'fabricEthMonDestEp',
    '1555' => 'fabricFcMonDestEp',
    '1556' => 'fabricMonSrcEp',
    '1557' => 'fabricEthMonSrcEp',
    '1558' => 'fabricFcMonSrcEp',
    '1559' => 'fabricMonSrcRef',
    '1560' => 'fabricEthMonSrcRef',
    '1561' => 'fabricFcMonSrcRef',
    '1562' => 'fabricMonSrcFiltEp',
    '1563' => 'fabricEthMonFiltEp',
    '1564' => 'fabricFcMonFiltEp',
    '1565' => 'fabricMonFiltRef',
    '1566' => 'fabricEthMonFiltRef',
    '1567' => 'fabricFcMonFiltRef',
    '1568' => 'fabricEpVsan',
    '1569' => 'fabricVsanEp',
    '1570' => 'fabricVsanMembership',
    '1571' => 'fabricVlanEp',
    '1572' => 'fabricVnetPermit',
    '1573' => 'fabricVlanPermit',
    '1574' => 'fabricAFcSanEp',
    '1575' => 'fabricFcSanEp',
    '1576' => 'fabricFcSanPcEp',
    '1577' => 'fabricFcoeSanPcEp',
    '1578' => 'fabricFcVsanPortEp',
    '1579' => 'fabricFcoeVsanPortEp',
    '1580' => 'fabricFcVsanPc',
    '1581' => 'fabricFcoeVsanPc',
    '1582' => 'fabricSanPinGroup',
    '1583' => 'fabricSanPinTarget',
    '1584' => 'fabricNetGroup',
    '1585' => 'fabricPooledVlan',
    '1586' => 'fabricPoolableVlan',
    '1587' => 'ipIpV4StaticTargetAddr',
    '1588' => 'fabricNetflowIPv4Addr',
    '1589' => 'fabricFlowMon',
    '1590' => 'fabricLanFlowMon',
    '1591' => 'fabricEthLanFlowMon',
    '1592' => 'fabricNetflowMonSession',
    '1593' => 'fabricFlowMonSrcEp',
    '1594' => 'fabricLanFlowMonSrcEp',
    '1595' => 'fabricEthLanFlowMonSrcEp',
    '1596' => 'fabricNetflowMonSrcEp',
    '1597' => 'fabricFlowMonSrcRef',
    '1598' => 'fabricEthFlowMonSrcRef',
    '1599' => 'fabricNetflowMonSrcRef',
    '1600' => 'fabricFlowMonExporterProfile',
    '1601' => 'fabricFlowMonDefinition',
    '1602' => 'fabricFlowMonItem',
    '1603' => 'fabricFlowMonitoringCategory',
    '1604' => 'fabricEthLanFlowMonitoring',
    '1605' => 'fabricEthFlowMonLan',
    '1606' => 'fabricFlowMonitor',
    '1607' => 'fabricLanFlowMonitor',
    '1608' => 'fabricEthLanFlowMonitor',
    '1609' => 'fabricNetflowMonitor',
    '1610' => 'fabricNetflowMonitorRef',
    '1611' => 'fabricFlowMonCollector',
    '1612' => 'fabricLanFlowMonCollector',
    '1613' => 'fabricEthLanFlowMonCollector',
    '1614' => 'fabricNetflowCollector',
    '1615' => 'fabricFlowMonExporter',
    '1616' => 'fabricLanFlowMonExporter',
    '1617' => 'fabricEthLanFlowMonExporter',
    '1618' => 'fabricNetflowMonExporter',
    '1619' => 'fabricNetflowMonExporterRef',
    '1620' => 'fabricNetflowTimeoutPolicy',
    '1621' => 'fabricLocale',
    '1622' => 'fabricPath',
    '1623' => 'fabricPathEp',
    '1624' => 'fabricPathConn',
    '1625' => 'fabricLanEp',
    '1626' => 'fabricAEthLanEp',
    '1627' => 'fabricEthVlanPortEp',
    '1628' => 'fabricEthLanEp',
    '1629' => 'fabricEthLanPcEp',
    '1630' => 'fabricLanPinGroup',
    '1631' => 'fabricLanPinTarget',
    '1632' => 'fabricSwChEp',
    '1633' => 'fabricSwChPhEp',
    '1634' => 'fabricComputeEp',
    '1635' => 'fabricChassisEp',
    '1636' => 'fabricComputeSlotEp',
    '1637' => 'fabricIf',
    '1638' => 'fabricComputePhEp',
    '1639' => 'fabricLastAckedSlot',
    '1640' => 'fabricSspLanMonCloud',
    '1641' => 'fabricSspMon',
    '1642' => 'fabricSspEthMon',
    '1643' => 'fabricSspEthMonSrcPhyTopEp',
    '1644' => 'fabricSspEthMonSrcAppLinksEp',
    '1645' => 'fabricSspEthMonSrcPhyEp',
    '1646' => 'fabricSspEthMonSrcPhyAggrEp',
    '1647' => 'fabricSspEthMonSrcAppEp',
    '1648' => 'fabricSspEthMonFilterEp',
    '1649' => 'fabricDceSwSrv',
    '1650' => 'fabricSwSrvEp',
    '1651' => 'fabricADceSwSrvEp',
    '1652' => 'fabricDceSwSrvEp',
    '1653' => 'fabricSwSrvPc',
    '1654' => 'fabricSubGroup',
    '1655' => 'fabricSwSubGroup',
    '1656' => 'fabricDceSwSrvPc',
    '1657' => 'fabricDceSwSrvPcEp',
    '1658' => 'fabricAEthEstcEp',
    '1659' => 'fabricAFcEstcEp',
    '1660' => 'fabricFcEstcEp',
    '1661' => 'fabricEthEstcEp',
    '1662' => 'fabricTargetEp',
    '1663' => 'fabricEthTargetEp',
    '1664' => 'fabricBHVlan',
    '1665' => 'fabricEthEstcPcEp',
    '1666' => 'fabricEthVlanPc',
    '1667' => 'fabricEpMgr',
    '1668' => 'fabricBreakout',
    '1669' => 'fabricInternalEp',
    '1670' => 'fabricInternalPc',
    '1671' => 'fabricPinGroup',
    '1672' => 'fabricPinTarget',
    '1673' => 'fabricZoneIdUniverse',
    '1674' => 'bmcSELCounter',
    '1675' => 'mgmtBackupExportExtPolicy',
    '1676' => 'mgmtBackupPolicyConfig',
    '1677' => 'mgmtImportConfigInfo',
    '1678' => 'mgmtExportPolicy',
    '1679' => 'mgmtCfgExportPolicy',
    '1680' => 'mgmtBackupPolicy',
    '1681' => 'mgmtEntity',
    '1682' => 'mgmtPmonEntry',
    '1683' => 'mgmtBackup',
    '1684' => 'mgmtImporter',
    '1685' => 'mgmtAccessPolicy',
    '1686' => 'mgmtAccessPolicyItem',
    '1687' => 'mgmtAccessPort',
    '1688' => 'mgmtIntAuthPolicy',
    '1689' => 'mgmtCimcSecureBoot',
    '1690' => 'mgmtController',
    '1691' => 'mgmtIf',
    '1692' => 'mgmtIPv6IfConfig',
    '1693' => 'mgmtIPv6Addr',
    '1694' => 'mgmtIPv6IfAddr',
    '1695' => 'mgmtConnection',
    '1696' => 'mgmtInbandProfile',
    '1697' => 'mgmtProfDerivedInterface',
    '1698' => 'fsmStatus',
    '1699' => 'nfsEp',
    '1700' => 'nfsMountDef',
    '1701' => 'nfsMountInst',
    '1702' => 'portDomainEp',
    '1703' => 'portTrustMode',
    '1704' => 'portGroup',
    '1705' => 'portSubGroup',
    '1706' => 'fcConfig',
    '1707' => 'fcIfConfig',
    '1708' => 'fcSwIfConfig',
    '1709' => 'fcNicIfConfig',
    '1710' => 'fcStats',
    '1711' => 'fcStatsHist',
    '1712' => 'fcErrStats',
    '1713' => 'fcErrStatsHist',
    '1714' => 'ruleDefinition',
    '1715' => 'ruleItem',
    '1716' => 'ruleRequirement',
    '1717' => 'ruleSizeRequirement',
    '1718' => 'networkruleDefinition',
    '1719' => 'networkruleItem',
    '1720' => 'networkruleRequirement',
    '1721' => 'policyControlEp',
    '1722' => 'policyCentraleSync',
    '1723' => 'policyIdResolvePolicy',
    '1724' => 'policyControl',
    '1725' => 'policyDateTime',
    '1726' => 'policyCommunication',
    '1727' => 'policyDns',
    '1728' => 'policySecurity',
    '1729' => 'policyMonitoring',
    '1730' => 'policyFault',
    '1731' => 'policyInfraFirmware',
    '1732' => 'policyConfigBackup',
    '1733' => 'policyMEp',
    '1734' => 'policyDiscovery',
    '1735' => 'policyPowerMgmt',
    '1736' => 'policyPsu',
    '1737' => 'policyControlled',
    '1738' => 'policyControlledInstance',
    '1739' => 'policyControlledType',
    '1740' => 'policyPolicyEp',
    '1741' => 'policyPolicyScopeCont',
    '1742' => 'policyPolicyScopeContext',
    '1743' => 'policyPolicyScope',
    '1744' => 'policyPolicyRequestor',
    '1745' => 'policyDigest',
    '1746' => 'policyLocalMap',
    '1747' => 'policyElement',
    '1748' => 'policyRefReq',
    '1749' => 'aaaEpFsmTask',
    '1750' => 'aaaRealmFsmTask',
    '1751' => 'aaaUserEpFsmTask',
    '1752' => 'adaptorExtEthIfFsmTask',
    '1753' => 'adaptorHostEthIfFsmTask',
    '1754' => 'adaptorHostFcIfFsmTask',
    '1755' => 'applicationDownloaderFsmTask',
    '1756' => 'callhomeEpFsmTask',
    '1757' => 'capabilityCatalogueFsmTask',
    '1758' => 'capabilityMgmtExtensionFsmTask',
    '1759' => 'capabilityUpdaterFsmTask',
    '1760' => 'commSvcEpFsmTask',
    '1761' => 'computeBladeFsmTask',
    '1762' => 'computePhysicalFsmTask',
    '1763' => 'computeServerDiscPolicyFsmTask',
    '1764' => 'epqosDefinitionDelTaskFsmTask',
    '1765' => 'epqosDefinitionFsmTask',
    '1766' => 'equipmentBeaconLedFsmTask',
    '1767' => 'equipmentChassisFsmTask',
    '1768' => 'equipmentIOCardBaseFsmTask',
    '1769' => 'equipmentIOCardFsmTask',
    '1770' => 'equipmentLocatorLedFsmTask',
    '1771' => 'etherFtwPortPairFsmTask',
    '1772' => 'etherServerIntFIoFsmTask',
    '1773' => 'extpolEpFsmTask',
    '1774' => 'extpolProviderFsmTask',
    '1775' => 'extpolRegistryFsmTask',
    '1776' => 'fabricEpMgrFsmTask',
    '1777' => 'fabricLanCloudFsmTask',
    '1778' => 'fabricSanCloudFsmTask',
    '1779' => 'fabricVnetEpSyncEpFsmTask',
    '1780' => 'firmwareDistributableFsmTask',
    '1781' => 'firmwareDownloaderFsmTask',
    '1782' => 'firmwareImageFsmTask',
    '1783' => 'firmwarePlatformPackFsmTask',
    '1784' => 'firmwareSupFirmwareFsmTask',
    '1785' => 'firmwareSystemFsmTask',
    '1786' => 'gmetaHolderFsmTask',
    '1787' => 'identIdentRequestFsmTask',
    '1788' => 'identMetaSystemFsmTask',
    '1789' => 'licenseDownloaderFsmTask',
    '1790' => 'licenseFileFsmTask',
    '1791' => 'licenseInstanceFsmTask',
    '1792' => 'licenseSmartConfigFsmTask',
    '1793' => 'lsServerFsmTask',
    '1794' => 'mgmtBackupFsmTask',
    '1795' => 'mgmtControllerFsmTask',
    '1796' => 'mgmtExportPolicyFsmTask',
    '1797' => 'mgmtIPv6IfAddrFsmTask',
    '1798' => 'mgmtIfFsmTask',
    '1799' => 'mgmtImporterFsmTask',
    '1800' => 'nfsMountDefFsmTask',
    '1801' => 'nfsMountInstFsmTask',
    '1802' => 'nhTableHolderFsmTask',
    '1803' => 'observeObservedFsmTask',
    '1804' => 'pkiEpFsmTask',
    '1805' => 'policyControlEpFsmTask',
    '1806' => 'policyControlledTypeFsmTask',
    '1807' => 'policyPolicyScopeFsmTask',
    '1808' => 'portPIoFsmTask',
    '1809' => 'qosclassDefinitionFsmTask',
    '1810' => 'sdAppAttributeCtrlFsmTask',
    '1811' => 'sdAppInstanceFsmTask',
    '1812' => 'sdClusterBootstrapFsmTask',
    '1813' => 'sdLduFsmTask',
    '1814' => 'sdLinkFsmTask',
    '1815' => 'sdLogicalDeviceFsmTask',
    '1816' => 'sdMgmtInfoFsmTask',
    '1817' => 'sdNetMgmtBootstrapFsmTask',
    '1818' => 'sdSlotFsmTask',
    '1819' => 'sdUpgradeTaskFsmTask',
    '1820' => 'smAppFsmTask',
    '1821' => 'smAppInstanceFsmTask',
    '1822' => 'smSecSvcFsmTask',
    '1823' => 'statsCollectionPolicyFsmTask',
    '1824' => 'storageSystemFsmTask',
    '1825' => 'swAccessDomainFsmTask',
    '1826' => 'swEthLanBorderFsmTask',
    '1827' => 'swEthLanFlowMonFsmTask',
    '1828' => 'swEthMonFsmTask',
    '1829' => 'swExtUtilityFsmTask',
    '1830' => 'swFcMonFsmTask',
    '1831' => 'swFcSanBorderFsmTask',
    '1832' => 'swPhysFsmTask',
    '1833' => 'swSspEthMonFsmTask',
    '1834' => 'swSspEthMonSrcPhyEpFsmTask',
    '1835' => 'swUtilityDomainFsmTask',
    '1836' => 'syntheticFsObjFsmTask',
    '1837' => 'sysdebugAutoCoreFileExportTargetFsmTask',
    '1838' => 'sysdebugCoreFsmTask',
    '1839' => 'sysdebugLogControlEpFsmTask',
    '1840' => 'sysdebugLogExportPolicyFsmTask',
    '1841' => 'sysdebugManualCoreFileExportTargetFsmTask',
    '1842' => 'sysdebugTechSupportFsmTask',
    '1843' => 'sysfileMutationFsmTask',
    '1844' => 'aaaEpFsm',
    '1845' => 'aaaEpFsmStage',
    '1846' => 'aaaLdapEpFsm',
    '1847' => 'aaaLdapEpFsmStage',
    '1848' => 'aaaRadiusEpFsm',
    '1849' => 'aaaRadiusEpFsmStage',
    '1850' => 'aaaTacacsPlusEpFsm',
    '1851' => 'aaaTacacsPlusEpFsmStage',
    '1852' => 'aaaRealmFsm',
    '1853' => 'aaaRealmFsmStage',
    '1854' => 'aaaAuthRealmFsm',
    '1855' => 'aaaAuthRealmFsmStage',
    '1856' => 'aaaUserEpFsm',
    '1857' => 'aaaUserEpFsmStage',
    '1858' => 'adaptorExtEthIfFsm',
    '1859' => 'adaptorExtEthIfFsmStage',
    '1860' => 'adaptorHostEthIfFsm',
    '1861' => 'adaptorHostEthIfFsmStage',
    '1862' => 'adaptorHostFcIfFsm',
    '1863' => 'adaptorHostFcIfFsmStage',
    '1864' => 'applicationDownloaderFsm',
    '1865' => 'applicationDownloaderFsmStage',
    '1866' => 'callhomeEpFsm',
    '1867' => 'callhomeEpFsmStage',
    '1868' => 'capabilityCatalogueFsm',
    '1869' => 'capabilityCatalogueFsmStage',
    '1870' => 'capabilityMgmtExtensionFsm',
    '1871' => 'capabilityMgmtExtensionFsmStage',
    '1872' => 'capabilityUpdaterFsm',
    '1873' => 'capabilityUpdaterFsmStage',
    '1874' => 'commSvcEpFsm',
    '1875' => 'commSvcEpFsmStage',
    '1876' => 'computeBladeFsm',
    '1877' => 'computeBladeFsmStage',
    '1878' => 'computePhysicalFsm',
    '1879' => 'computePhysicalFsmStage',
    '1880' => 'computeRackUnitFsm',
    '1881' => 'computeRackUnitFsmStage',
    '1882' => 'computeServerDiscPolicyFsm',
    '1883' => 'computeServerDiscPolicyFsmStage',
    '1884' => 'epqosDefinitionDelTaskFsm',
    '1885' => 'epqosDefinitionDelTaskFsmStage',
    '1886' => 'epqosDefinitionFsm',
    '1887' => 'epqosDefinitionFsmStage',
    '1888' => 'equipmentBeaconLedFsm',
    '1889' => 'equipmentBeaconLedFsmStage',
    '1890' => 'equipmentChassisFsm',
    '1891' => 'equipmentChassisFsmStage',
    '1892' => 'equipmentIOCardBaseFsm',
    '1893' => 'equipmentIOCardBaseFsmStage',
    '1894' => 'equipmentIOCardFsm',
    '1895' => 'equipmentIOCardFsmStage',
    '1896' => 'equipmentSwitchIOCardFsm',
    '1897' => 'equipmentSwitchIOCardFsmStage',
    '1898' => 'equipmentLocatorLedFsm',
    '1899' => 'equipmentLocatorLedFsmStage',
    '1900' => 'etherFtwPortPairFsm',
    '1901' => 'etherFtwPortPairFsmStage',
    '1902' => 'etherServerIntFIoFsm',
    '1903' => 'etherServerIntFIoFsmStage',
    '1904' => 'extpolEpFsm',
    '1905' => 'extpolEpFsmStage',
    '1906' => 'extpolProviderFsm',
    '1907' => 'extpolProviderFsmStage',
    '1908' => 'extpolRegistryFsm',
    '1909' => 'extpolRegistryFsmStage',
    '1910' => 'fabricEpMgrFsm',
    '1911' => 'fabricEpMgrFsmStage',
    '1912' => 'fabricLanCloudFsm',
    '1913' => 'fabricLanCloudFsmStage',
    '1914' => 'fabricSanCloudFsm',
    '1915' => 'fabricSanCloudFsmStage',
    '1916' => 'fabricVnetEpSyncEpFsm',
    '1917' => 'fabricVnetEpSyncEpFsmStage',
    '1918' => 'firmwareDistributableFsm',
    '1919' => 'firmwareDistributableFsmStage',
    '1920' => 'firmwareDownloaderFsm',
    '1921' => 'firmwareDownloaderFsmStage',
    '1922' => 'firmwareImageFsm',
    '1923' => 'firmwareImageFsmStage',
    '1924' => 'firmwarePlatformPackFsm',
    '1925' => 'firmwarePlatformPackFsmStage',
    '1926' => 'firmwareSupFirmwareFsm',
    '1927' => 'firmwareSupFirmwareFsmStage',
    '1928' => 'firmwareSystemFsm',
    '1929' => 'firmwareSystemFsmStage',
    '1930' => 'gmetaHolderFsm',
    '1931' => 'gmetaHolderFsmStage',
    '1932' => 'identIdentRequestFsm',
    '1933' => 'identIdentRequestFsmStage',
    '1934' => 'identMetaSystemFsm',
    '1935' => 'identMetaSystemFsmStage',
    '1936' => 'licenseDownloaderFsm',
    '1937' => 'licenseDownloaderFsmStage',
    '1938' => 'licenseFileFsm',
    '1939' => 'licenseFileFsmStage',
    '1940' => 'licenseInstanceFsm',
    '1941' => 'licenseInstanceFsmStage',
    '1942' => 'licenseSmartConfigFsm',
    '1943' => 'licenseSmartConfigFsmStage',
    '1944' => 'lsServerFsm',
    '1945' => 'lsServerFsmStage',
    '1946' => 'mgmtBackupFsm',
    '1947' => 'mgmtBackupFsmStage',
    '1948' => 'mgmtControllerFsm',
    '1949' => 'mgmtControllerFsmStage',
    '1950' => 'mgmtExportPolicyFsm',
    '1951' => 'mgmtExportPolicyFsmStage',
    '1952' => 'mgmtBackupPolicyFsm',
    '1953' => 'mgmtBackupPolicyFsmStage',
    '1954' => 'mgmtCfgExportPolicyFsm',
    '1955' => 'mgmtCfgExportPolicyFsmStage',
    '1956' => 'mgmtIPv6IfAddrFsm',
    '1957' => 'mgmtIPv6IfAddrFsmStage',
    '1958' => 'mgmtIfFsm',
    '1959' => 'mgmtIfFsmStage',
    '1960' => 'mgmtImporterFsm',
    '1961' => 'mgmtImporterFsmStage',
    '1962' => 'nfsMountDefFsm',
    '1963' => 'nfsMountDefFsmStage',
    '1964' => 'nfsMountInstFsm',
    '1965' => 'nfsMountInstFsmStage',
    '1966' => 'nhTableHolderFsm',
    '1967' => 'nhTableHolderFsmStage',
    '1968' => 'observeObservedFsm',
    '1969' => 'observeObservedFsmStage',
    '1970' => 'pkiEpFsm',
    '1971' => 'pkiEpFsmStage',
    '1972' => 'policyControlEpFsm',
    '1973' => 'policyControlEpFsmStage',
    '1974' => 'policyControlledTypeFsm',
    '1975' => 'policyControlledTypeFsmStage',
    '1976' => 'policyPolicyScopeFsm',
    '1977' => 'policyPolicyScopeFsmStage',
    '1978' => 'portPIoFsm',
    '1979' => 'portPIoFsmStage',
    '1980' => 'etherPIoFsm',
    '1981' => 'etherPIoFsmStage',
    '1982' => 'fcPIoFsm',
    '1983' => 'fcPIoFsmStage',
    '1984' => 'qosclassDefinitionFsm',
    '1985' => 'qosclassDefinitionFsmStage',
    '1986' => 'sdAppAttributeCtrlFsm',
    '1987' => 'sdAppAttributeCtrlFsmStage',
    '1988' => 'sdAppInstanceFsm',
    '1989' => 'sdAppInstanceFsmStage',
    '1990' => 'sdClusterBootstrapFsm',
    '1991' => 'sdClusterBootstrapFsmStage',
    '1992' => 'sdLduFsm',
    '1993' => 'sdLduFsmStage',
    '1994' => 'sdLinkFsm',
    '1995' => 'sdLinkFsmStage',
    '1996' => 'sdAppLduLinkFsm',
    '1997' => 'sdAppLduLinkFsmStage',
    '1998' => 'sdExternalLduLinkFsm',
    '1999' => 'sdExternalLduLinkFsmStage',
    '2000' => 'sdLogicalDeviceFsm',
    '2001' => 'sdLogicalDeviceFsmStage',
    '2002' => 'sdMgmtInfoFsm',
    '2003' => 'sdMgmtInfoFsmStage',
    '2004' => 'sdNetMgmtBootstrapFsm',
    '2005' => 'sdNetMgmtBootstrapFsmStage',
    '2006' => 'sdSlotFsm',
    '2007' => 'sdSlotFsmStage',
    '2008' => 'sdUpgradeTaskFsm',
    '2009' => 'sdUpgradeTaskFsmStage',
    '2010' => 'smAppFsm',
    '2011' => 'smAppFsmStage',
    '2012' => 'smAppInstanceFsm',
    '2013' => 'smAppInstanceFsmStage',
    '2014' => 'smSecSvcFsm',
    '2015' => 'smSecSvcFsmStage',
    '2016' => 'statsCollectionPolicyFsm',
    '2017' => 'statsCollectionPolicyFsmStage',
    '2018' => 'storageSystemFsm',
    '2019' => 'storageSystemFsmStage',
    '2020' => 'swAccessDomainFsm',
    '2021' => 'swAccessDomainFsmStage',
    '2022' => 'swEthLanBorderFsm',
    '2023' => 'swEthLanBorderFsmStage',
    '2024' => 'swEthLanFlowMonFsm',
    '2025' => 'swEthLanFlowMonFsmStage',
    '2026' => 'swEthMonFsm',
    '2027' => 'swEthMonFsmStage',
    '2028' => 'swExtUtilityFsm',
    '2029' => 'swExtUtilityFsmStage',
    '2030' => 'swFcMonFsm',
    '2031' => 'swFcMonFsmStage',
    '2032' => 'swFcSanBorderFsm',
    '2033' => 'swFcSanBorderFsmStage',
    '2034' => 'swPhysFsm',
    '2035' => 'swPhysFsmStage',
    '2036' => 'swSspEthMonFsm',
    '2037' => 'swSspEthMonFsmStage',
    '2038' => 'swSspEthMonSrcPhyEpFsm',
    '2039' => 'swSspEthMonSrcPhyEpFsmStage',
    '2040' => 'swUtilityDomainFsm',
    '2041' => 'swUtilityDomainFsmStage',
    '2042' => 'syntheticFsObjFsm',
    '2043' => 'syntheticFsObjFsmStage',
    '2044' => 'sysdebugAutoCoreFileExportTargetFsm',
    '2045' => 'sysdebugAutoCoreFileExportTargetFsmStage',
    '2046' => 'sysdebugCoreFsm',
    '2047' => 'sysdebugCoreFsmStage',
    '2048' => 'sysdebugLogControlEpFsm',
    '2049' => 'sysdebugLogControlEpFsmStage',
    '2050' => 'sysdebugLogExportPolicyFsm',
    '2051' => 'sysdebugLogExportPolicyFsmStage',
    '2052' => 'sysdebugManualCoreFileExportTargetFsm',
    '2053' => 'sysdebugManualCoreFileExportTargetFsmStage',
    '2054' => 'sysdebugTechSupportFsm',
    '2055' => 'sysdebugTechSupportFsmStage',
    '2056' => 'sysfileMutationFsm',
    '2057' => 'sysfileMutationFsmStage',
    '2058' => 'firmwareInfraPackFsmTask',
    '2059' => 'firmwareInfraPackFsm',
    '2060' => 'firmwareInfraPackFsmStage',
    '2062' => 'equipmentCardStatsHist',
  },
  'CfprApLicenseScope' => {
    '1' => 'a',
    '2' => 'b',
    '3' => 'server',
    '4' => 'unknown',
  },
  'CfprApExtpolEpFsmStageName' => {
    '0' => 'nop',
    '317' => 'registerFsmBegin',
    '318' => 'registerFsmExecute',
    '496' => 'repairCertBegin',
    '497' => 'repairCertVerifyGuid',
    '498' => 'repairCertUnregister',
    '499' => 'repairCertCleanOldData',
    '500' => 'repairCertRequest',
    '501' => 'repairCertVerify',
    '594' => 'registerFsmFail',
    '595' => 'registerFsmSuccess',
    '596' => 'repairCertFail',
    '597' => 'repairCertSuccess',
  },
  'CfprApAdaptorMenloMcpuErrorStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'correctableErrorsDelta',
      '1' => 'correctableErrorsDeltaAvg',
      '2' => 'correctableErrorsDeltaMax',
      '3' => 'correctableErrorsDeltaMin',
      '4' => 'popErrorsDelta',
      '5' => 'popErrorsDeltaAvg',
      '6' => 'popErrorsDeltaMax',
      '7' => 'popErrorsDeltaMin',
      '8' => 'pushErrorsDelta',
      '9' => 'pushErrorsDeltaAvg',
      '10' => 'pushErrorsDeltaMax',
      '11' => 'pushErrorsDeltaMin',
      '12' => 'uncorrectableErrorsDelta',
      '13' => 'uncorrectableErrorsDeltaAvg',
      '14' => 'uncorrectableErrorsDeltaMax',
      '15' => 'uncorrectableErrorsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMemoryVisibility' => {
    '0' => 'unknown',
    '1' => 'yes',
    '2' => 'no',
  },
  'CfprApComputePhysicalLowVoltageMemory' => {
    '0' => 'notApplicable',
    '1' => 'lowVoltage',
    '2' => 'regularVoltage',
  },
  'CfprApComputeServerDiscPolicyFsmTaskItem' => {
    '0' => 'nop',
    '1' => 'resolveScrubPolicy',
  },
  'CfprApMgmtBackupPolicyFsmCurrentFsm' => {
    '0' => 'nop',
    '460' => 'reportConfigCopy',
  },
  'CfprApExtpolProviderFsmTaskItem' => {
    '0' => 'nop',
    '462' => 'reportConfigImport',
  },
  'CfprApOsUpgradeReturnCode' => {
    '0' => 'null',
    '1' => 'requesting',
    '2' => 'successful',
    '3' => 'downloading',
    '4' => 'validating',
    '5' => 'failedComm',
    '6' => 'failedDownloading',
    '7' => 'failedValidation',
  },
  'CfprApAdaptorMenloFcStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'dropAclDelta',
      '1' => 'dropAclDeltaAvg',
      '2' => 'dropAclDeltaMax',
      '3' => 'dropAclDeltaMin',
      '4' => 'dropOverrunDelta',
      '5' => 'dropOverrunDeltaAvg',
      '6' => 'dropOverrunDeltaMax',
      '7' => 'dropOverrunDeltaMin',
      '8' => 'dropRuntDelta',
      '9' => 'dropRuntDeltaAvg',
      '10' => 'dropRuntDeltaMax',
      '11' => 'dropRuntDeltaMin',
      '12' => 'truncateOverrunDelta',
      '13' => 'truncateOverrunDeltaAvg',
      '14' => 'truncateOverrunDeltaMax',
      '15' => 'truncateOverrunDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicIScsiConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'initiatorName',
      '1' => 'iqnPoolName',
      '2' => 'targetName',
      '3' => 'authProfileSame',
      '4' => 'invalidTargetName',
      '5' => 'noLuns',
      '6' => 'iscsiCardinality',
      '7' => 'autoTargetAuth',
      '8' => 'autoTargetInit',
      '9' => 'noVlanIp',
      '10' => 'staticTargetMix',
      '11' => 'ipAddrDhcp',
      '12' => 'unclassified',
      '13' => 'internalCfgError',
      '14' => 'missingVlan',
      '15' => 'vnicName',
      '16' => 'allowedVlan',
      '17' => 'iscsiConfig',
      '18' => 'iscsiInitiatorIpAddress',
      '19' => 'invalidMac',
      '20' => 'nativeVlan',
      '21' => 'initTargetPasswd',
      '22' => 'initIdentity',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwSspMonDomainLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSysfileMutationFsmStageName' => {
    '0' => 'nop',
    '327' => 'singleBegin',
    '328' => 'singleExecute',
    '329' => 'globalBegin',
    '330' => 'globalLocal',
    '331' => 'globalPeer',
    '824' => 'globalFail',
    '825' => 'globalSuccess',
    '826' => 'singleFail',
    '827' => 'singleSuccess',
  },
  'CfprApLicenseFileFsmCurrentFsm' => {
    '0' => 'nop',
    '147' => 'install',
    '150' => 'clear',
  },
  'CfprApSdAppInstState' => {
    '0' => 'notInstalled',
    '1' => 'installing',
    '2' => 'installFailed',
    '3' => 'offline',
    '4' => 'starting',
    '5' => 'startFailed',
    '6' => 'started',
    '7' => 'online',
    '8' => 'stopping',
    '9' => 'stopFailed',
    '10' => 'notResponding',
    '11' => 'updating',
    '12' => 'updateFailed',
    '13' => 'updateSucceeded',
    '14' => 'unsupported',
  },
  'CfprApSwEthLanFlowMonFsmTaskItem' => {
    '0' => 'nop',
    '104' => 'deploy',
  },
  'CfprApAdaptorExtIpV6RssHashProfileTcpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApSmAppInstanceFsmStageName' => {
    '0' => 'nop',
    '85' => 'resetApplicationBegin',
    '86' => 'resetApplicationStopDecoratorApps',
    '87' => 'resetApplicationWairForStopDecorators',
    '88' => 'resetApplicationStopMainApp',
    '89' => 'resetApplicationWaitForBladeReboot',
    '90' => 'resetApplicationWaitForStopMainApp',
    '91' => 'resetApplicationStartApps',
    '774' => 'resetApplicationFail',
    '775' => 'resetApplicationSuccess',
  },
  'CfprApPortSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n2gbps',
    '3' => 'n4gbps',
    '4' => 'n8gbps',
    '5' => 'auto',
  },
  'CfprApSwSspEthMonSrcPhyEpFsmStageName' => {
    '0' => 'nop',
    '445' => 'deleteBegin',
    '446' => 'deleteDeletePcapFile',
    '802' => 'deleteFail',
    '803' => 'deleteSuccess',
  },
  'CfprApFabricEthMonLanType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAaaRealmFsmCurrentFsm' => {
    '0' => 'nop',
    '352' => 'updateRealm',
  },
  'CfprApCallhomeEpFsmTaskItem' => {
    '0' => 'nop',
    '124' => 'configCallhome',
  },
  'CfprApEtherSwitchIntFIoLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherIntFIoEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSwUtilityDomainLocale' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'server',
      '1' => 'chassis',
      '2' => 'internal',
      '3' => 'external',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsServerFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '14' => 'samDmeLsServerConfigureModification',
      '15' => 'samDmeLsServerConfigureFinalDisassoc',
      '16' => 'samDmeLsServerConfigureLsRename',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFeatureSupportabilityType' => {
    '0' => 'supported',
    '1' => 'notSupported',
    '2' => 'deprecated',
  },
  'CfprApMemoryBufferUnitEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'temperature',
      '1' => 'temperatureAvg',
      '2' => 'temperatureMax',
      '3' => 'temperatureMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEtherServerIntFIoPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorEthOffloadProfileTcpTxChecksum' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApSwFcoeSanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentFanStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'speed',
      '1' => 'speedAvg',
      '2' => 'speedMax',
      '3' => 'speedMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApComputeMode' => {
    '0' => 'none',
    '1' => 'single',
    '2' => 'scaled',
  },
  'CfprApFabricDefaultZoningState' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFabricVnetEpSyncEpFsmTaskItem' => {
    '0' => 'nop',
    '447' => 'pushVnetEpDeletion',
  },
  'CfprApBiosVfSerialPortAEnableVpSerialPortAEnable' => {
    '0' => 'platformRecommended',
    '86' => 'disabled',
    '87' => 'enabled',
  },
  'CfprApIdentIdentRequestFsmStageName' => {
    '0' => 'nop',
    '72' => 'updateIdentBegin',
    '73' => 'updateIdentExecute',
    '628' => 'updateIdentFail',
    '629' => 'updateIdentSuccess',
  },
  'CfprApSwSspEthMonFsmStageName' => {
    '0' => 'nop',
    '443' => 'deployBegin',
    '444' => 'deployUpdateSspEthMon',
    '800' => 'deployFail',
    '801' => 'deploySuccess',
  },
  'CfprApEquipmentFexPsuInputStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'current',
      '1' => 'currentAvg',
      '2' => 'currentMax',
      '3' => 'currentMin',
      '4' => 'power',
      '5' => 'powerAvg',
      '6' => 'powerMax',
      '7' => 'powerMin',
      '8' => 'voltage',
      '9' => 'voltageAvg',
      '10' => 'voltageMax',
      '11' => 'voltageMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentIOCardStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      '4' => 'dimmTemp',
      '5' => 'dimmTempAvg',
      '6' => 'dimmTempMax',
      '7' => 'dimmTempMin',
      '8' => 'procTemp',
      '9' => 'procTempAvg',
      '10' => 'procTempMax',
      '11' => 'procTempMin',
      '12' => 'temp',
      '13' => 'tempAvg',
      '14' => 'tempMax',
      '15' => 'tempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEthUdldPolicyProtocol' => {
    '0' => 'unknown',
    '1' => 'udld',
    '2' => 'cdp',
  },
  'CfprApSwBreakoutType' => {
    '0' => 'unknown',
    '1' => 'n10g4x',
  },
  'CfprApStorageOperationRequestType' => {
    '0' => 'unknown',
    '1' => 'format',
    '2' => 'reset',
    '3' => 'pair',
  },
  'CfprApEtherFcoeInterfaceStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'bytesRxDelta',
      '1' => 'bytesRxDeltaAvg',
      '2' => 'bytesRxDeltaMax',
      '3' => 'bytesRxDeltaMin',
      '4' => 'bytesTxDelta',
      '5' => 'bytesTxDeltaAvg',
      '6' => 'bytesTxDeltaMax',
      '7' => 'bytesTxDeltaMin',
      '8' => 'droppedRxDelta',
      '9' => 'droppedRxDeltaAvg',
      '10' => 'droppedRxDeltaMax',
      '11' => 'droppedRxDeltaMin',
      '12' => 'droppedTxDelta',
      '13' => 'droppedTxDeltaAvg',
      '14' => 'droppedTxDeltaMax',
      '15' => 'droppedTxDeltaMin',
      '16' => 'errorsRxDelta',
      '17' => 'errorsRxDeltaAvg',
      '18' => 'errorsRxDeltaMax',
      '19' => 'errorsRxDeltaMin',
      '20' => 'errorsTxDelta',
      '21' => 'errorsTxDeltaAvg',
      '22' => 'errorsTxDeltaMax',
      '23' => 'errorsTxDeltaMin',
      '24' => 'packetsRxDelta',
      '25' => 'packetsRxDeltaAvg',
      '26' => 'packetsRxDeltaMax',
      '27' => 'packetsRxDeltaMin',
      '28' => 'packetsTxDelta',
      '29' => 'packetsTxDeltaAvg',
      '30' => 'packetsTxDeltaMax',
      '31' => 'packetsTxDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricPathEpIfType' => {
    '0' => 'unknown',
    '1' => 'physical',
    '2' => 'aggregation',
    '3' => 'virtual',
    '4' => 'fabric',
  },
  'CfprApSwEthMonSrcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApCommDnsProviderAdminState' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'CfprApEquipmentIsSupported' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApMgmtControllerFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '1' => 'samDmeMgmtControllerUpdateSwitchActivate',
      '2' => 'samDmeMgmtControllerUpdateSwitchReset',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFabricEthMonDestEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentIOCardIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'thermal',
      '1' => 'inoperable',
      '2' => 'voltage',
      '3' => 'perf',
      '4' => 'power',
      '5' => 'removed',
      '6' => 'fabricPortProblem',
      '7' => 'postFailure',
      '8' => 'serverPortProblem',
      '9' => 'fabricpcLinkAutoAckBlocked',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicExternalMgmtIPMode' => {
    '1' => 'none',
    '2' => 'static',
    '3' => 'pooled',
  },
  'CfprApEquipmentHealthLedState' => {
    '0' => 'normal',
    '1' => 'minor',
    '2' => 'critical',
  },
  'CfprApAdaptorIpV6RssHashProfileIpHash' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFabricSanCloudFsmStageName' => {
    '0' => 'nop',
    '452' => 'switchModeBegin',
    '453' => 'switchModeSwConfigPeer',
    '454' => 'switchModeSwConfigLocal',
    '608' => 'switchModeFail',
    '609' => 'switchModeSuccess',
  },
  'CfprApSwLanPcType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot1LinkSpeed' => {
    '0' => 'platformRecommended',
    '232' => 'gen1',
    '233' => 'gen2',
    '234' => 'gen3',
    '235' => 'auto',
    '236' => 'disabled',
  },
  'CfprApNfsDefAdminState' => {
    '0' => 'disabled',
    '1' => 'enabled',
    '2' => 'suspended',
  },
  'CfprApDiagStatusIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'testFailure',
      '1' => 'runCancelled',
      '2' => 'componentError',
      '3' => 'stagesCompleted',
      '4' => 'stageFailed',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfPCISlotLinkSpeedVpPCIeSlot4LinkSpeed' => {
    '0' => 'platformRecommended',
    '247' => 'gen1',
    '248' => 'gen2',
    '249' => 'gen3',
    '250' => 'auto',
    '251' => 'disabled',
  },
  'CfprApDiagSuccessAction' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'techSupport',
      '1' => 'waitDebug',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSdInterfaceType' => {
    '0' => 'root',
    '1' => 'sub',
  },
  'CfprApEtherSwitchIntFIoIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApAdaptorRssProfileReceiveSideScaling' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApFcErrStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'crcRxDelta',
      '1' => 'crcRxDeltaAvg',
      '2' => 'crcRxDeltaMax',
      '3' => 'crcRxDeltaMin',
      '4' => 'discardRxDelta',
      '5' => 'discardRxDeltaAvg',
      '6' => 'discardRxDeltaMax',
      '7' => 'discardRxDeltaMin',
      '8' => 'discardTxDelta',
      '9' => 'discardTxDeltaAvg',
      '10' => 'discardTxDeltaMax',
      '11' => 'discardTxDeltaMin',
      '12' => 'linkFailuresDelta',
      '13' => 'linkFailuresDeltaAvg',
      '14' => 'linkFailuresDeltaMax',
      '15' => 'linkFailuresDeltaMin',
      '16' => 'rxDelta',
      '17' => 'rxDeltaAvg',
      '18' => 'rxDeltaMax',
      '19' => 'rxDeltaMin',
      '20' => 'signalLossesDelta',
      '21' => 'signalLossesDeltaAvg',
      '22' => 'signalLossesDeltaMax',
      '23' => 'signalLossesDeltaMin',
      '24' => 'syncLossesDelta',
      '25' => 'syncLossesDeltaAvg',
      '26' => 'syncLossesDeltaMax',
      '27' => 'syncLossesDeltaMin',
      '28' => 'tooLongRxDelta',
      '29' => 'tooLongRxDeltaAvg',
      '30' => 'tooLongRxDeltaMax',
      '31' => 'tooLongRxDeltaMin',
      '32' => 'tooShortRxDelta',
      '33' => 'tooShortRxDeltaAvg',
      '34' => 'tooShortRxDeltaMax',
      '35' => 'tooShortRxDeltaMin',
      '36' => 'txDelta',
      '37' => 'txDeltaAvg',
      '38' => 'txDeltaMax',
      '39' => 'txDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentOwnership' => {
    '0' => 'unknown',
    '1' => 'owned',
    '2' => 'unowned',
  },
  'CfprApSysfileMutationFsmTaskItem' => {
    '0' => 'nop',
    '327' => 'single',
    '329' => 'global',
  },
  'CfprApLsServerFsmStageName' => {
    '0' => 'nop',
    '158' => 'configureBegin',
    '159' => 'configureApplyTemplate',
    '160' => 'configureApplyIdentifiers',
    '161' => 'configureCheckAssignedIdentifiersForDup',
    '162' => 'configureResolvePolicies',
    '163' => 'configureResolveNetworkPolicies',
    '164' => 'configureResolveNetworkTemplates',
    '165' => 'configureResolveIdentifiers',
    '166' => 'configureApplyDefaultIdentifiers',
    '167' => 'configureCheckAssignedDefaultIdentifiersForDup',
    '168' => 'configureResolveDefaultIdentifiers',
    '169' => 'configureResolveDistributableNames',
    '170' => 'configureResolveDistributable',
    '171' => 'configureResolveImages',
    '172' => 'configureResolveSchedule',
    '173' => 'configureValidatePolicyOwnership',
    '174' => 'configureApplyPolicies',
    '175' => 'configureProvisionStorage',
    '176' => 'configureWaitForStorageProvision',
    '177' => 'configureResolveBootConfig',
    '178' => 'configureEvaluateAssociation',
    '179' => 'configureAnalyzeImpact',
    '180' => 'configureWaitForMaintPermission',
    '181' => 'configureWaitForMaintWindow',
    '182' => 'configureCommitStorage',
    '183' => 'configureWaitForCommitStorage',
    '184' => 'configureApplyConfig',
    '185' => 'configureWaitForAssocCompletion',
    '644' => 'configureFail',
    '645' => 'configureSuccess',
  },
  'CfprApSmAppInstanceFsmCurrentFsm' => {
    '0' => 'nop',
    '85' => 'resetApplication',
  },
  'CfprApSwEthLanFlowMonFsmStageName' => {
    '0' => 'nop',
    '104' => 'deployBegin',
    '105' => 'deployUpdateEthFlowMon',
    '790' => 'deployFail',
    '791' => 'deploySuccess',
  },
  'CfprApMacpoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApSdLduFsmCurrentFsm' => {
    '0' => 'nop',
    '258' => 'provisionLDU',
  },
  'CfprApNhTableHolderFsmTaskItem' => {
    '0' => 'nop',
    '401' => 'configureLinks',
    '405' => 'bootstrapLinks',
  },
  'CfprApSwVlanPortNsAllocStatus' => {
    '0' => 'available',
    '1' => 'exceeded',
  },
  'CfprApSwFcMonFsmCurrentFsm' => {
    '0' => 'nop',
    '441' => 'deploy',
  },
  'CfprApEquipmentFexEnvStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'die1',
      '1' => 'die1Avg',
      '2' => 'die1Max',
      '3' => 'die1Min',
      '4' => 'inlet',
      '5' => 'inlet1',
      '6' => 'inlet1Avg',
      '7' => 'inlet1Max',
      '8' => 'inlet1Min',
      '9' => 'inletAvg',
      '10' => 'inletMax',
      '11' => 'inletMin',
      '12' => 'outlet1',
      '13' => 'outlet1Avg',
      '14' => 'outlet1Max',
      '15' => 'outlet1Min',
      '16' => 'outlet2',
      '17' => 'outlet2Avg',
      '18' => 'outlet2Max',
      '19' => 'outlet2Min',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApVnicAIpcIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApSysdebugAutoCoreFileExportTargetFsmCurrentFsm' => {
    '0' => 'nop',
    '363' => 'configure',
  },
  'CfprApFabricVlanOverlapState' => {
    '0' => 'notActive',
    '1' => 'ok',
    '2' => 'sharingTypeMismatch',
    '3' => 'primaryIdMismatch',
  },
  'CfprApEtherServerIntFIoFsmCurrentFsm' => {
    '0' => 'nop',
    '313' => 'configSpeed',
  },
  'CfprApChangeStatus' => {
    '0' => 'modified',
    '1' => 'created',
    '2' => 'deleted',
    '3' => 'intentDeletion',
  },
  'CfprApFabricSanPcIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApMgmtAdminState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApLsServerFsmTaskItem' => {
    '0' => 'nop',
    '158' => 'configure',
  },
  'CfprApSysdebugAutoCoreFileExportTargetProto' => {
    '0' => 'none',
    '1' => 'ftp',
    '2' => 'tftp',
    '3' => 'scp',
    '4' => 'http',
    '5' => 'sftp',
    '6' => 'nfsCopy',
  },
  'CfprApPolicyPolicyResolveType' => {
    '0' => 'name',
    '1' => 'rn',
  },
  'CfprApAdaptorMgmtCapMode' => {
    '1' => 'full',
    '2' => 'partial',
  },
  'CfprApDiagSrvCtrlType' => {
    '1' => 'full',
    '33' => 'efi',
  },
  'CfprApEquipmentFanModuleStatsHistThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ambientTemp',
      '1' => 'ambientTempAvg',
      '2' => 'ambientTempMax',
      '3' => 'ambientTempMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApDpsecForgedTransmit' => {
    '0' => 'allow',
    '1' => 'deny',
  },
  'CfprApFabricPktCaptureAppendFlag' => {
    '1' => 'append',
    '2' => 'overwrite',
  },
  'CfprApSwFcSanPcTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApPowerPrioritySharing' => {
    '0' => 'noPreference',
    '1' => 'highestPrioInChassis',
    '2' => 'highestPrioInPowerGroup',
  },
  'CfprApAdaptorEthPortStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'goodPacketsDelta',
      '1' => 'goodPacketsDeltaAvg',
      '2' => 'goodPacketsDeltaMax',
      '3' => 'goodPacketsDeltaMin',
      '4' => 'pausePacketsDelta',
      '5' => 'pausePacketsDeltaAvg',
      '6' => 'pausePacketsDeltaMax',
      '7' => 'pausePacketsDeltaMin',
      '8' => 'perPriorityPausePacketsDelta',
      '9' => 'perPriorityPausePacketsDeltaAvg',
      '10' => 'perPriorityPausePacketsDeltaMax',
      '11' => 'perPriorityPausePacketsDeltaMin',
      '12' => 'pppPacketsDelta',
      '13' => 'pppPacketsDeltaAvg',
      '14' => 'pppPacketsDeltaMax',
      '15' => 'pppPacketsDeltaMin',
      '16' => 'totalPacketsDelta',
      '17' => 'totalPacketsDeltaAvg',
      '18' => 'totalPacketsDeltaMax',
      '19' => 'totalPacketsDeltaMin',
      '20' => 'vlanPacketsDelta',
      '21' => 'vlanPacketsDeltaAvg',
      '22' => 'vlanPacketsDeltaMax',
      '23' => 'vlanPacketsDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApLsConfigWarnings' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'kvmMgmtPolicyUnsupported',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApMgmtBackupJob' => {
    '2' => 'immediate',
  },
  'CfprApAdaptorOffloadMethod' => {
    '0' => 'virtual',
    '1' => 'physical',
    '2' => 'none',
  },
  'CfprApCallhomeAdminState' => {
    '0' => 'off',
    '1' => 'on',
  },
  'CfprApSdLinkFsmCurrentFsm' => {
    '0' => 'nop',
    '289' => 'updateInterfaceStatus',
  },
  'CfprApCimcvmediaMountConfigRetryOnMountFail' => {
    '0' => 'no',
    '1' => 'yes',
  },
  'CfprApFabricEthEstcEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApSmHeartbeatState' => {
    '0' => 'disable',
    '1' => 'enable',
  },
  'CfprApVnicAEtherIfType' => {
    '0' => 'unknown',
    '1' => 'ether',
    '4' => 'fc',
    '8' => 'scsi',
    '16' => 'ipc',
  },
  'CfprApIppoolPoolAssignmentOrder' => {
    '0' => 'default',
    '1' => 'sequential',
  },
  'CfprApCallhomeLevel' => {
    '0' => 'debug',
    '1' => 'normal',
    '2' => 'notification',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
    '7' => 'fatal',
    '8' => 'disaster',
  },
  'CfprApCommWebProto' => {
    '0' => 'none',
    '1' => 'tcp',
    '2' => 'udp',
    '3' => 'all',
  },
  'CfprApSysdebugMEpLogOperState' => {
    '0' => 'ok',
    '1' => 'permissionDeniedError',
    '2' => 'remoteCommunicationError',
    '3' => 'bmcCommunicationError',
    '4' => 'internalUcsmError',
  },
  'CfprApFirmwareSystemFsmTaskFlags' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '4' => 'samDmeFirmwareSystemDeployApplyInfra',
      '5' => 'samDmeFirmwareSystemDeployApplyApp',
      '6' => 'samDmeFirmwareSystemDeployApplyMgr',
      '7' => 'samDmeFirmwareSystemDeployApplyNpu',
      '8' => 'samDmeFirmwareSystemDeployApplySys',
      '9' => 'samDmeFirmwareSystemDeployApplyFw',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApEquipmentPowerState' => {
    '0' => 'unknown',
    '1' => 'on',
    '2' => 'test',
    '3' => 'off',
    '4' => 'online',
    '5' => 'offline',
    '6' => 'offduty',
    '7' => 'degraded',
    '8' => 'powerSave',
    '9' => 'error',
    '10' => 'ok',
    '11' => 'failed',
    '100' => 'notSupported',
  },
  'CfprApBiosVfIntelVirtualizationTechnologyVpIntelVirtTechnology' => {
    '0' => 'platformRecommended',
    '50' => 'disabled',
    '51' => 'enabled',
  },
  'CfprApSwEthLanEpUdldMode' => {
    '0' => 'normal',
    '1' => 'aggressive',
  },
  'CfprApNetworkTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosVfFrequencyFloorOverrideVpFrequencyFloorOverride' => {
    '0' => 'platformRecommended',
    '341' => 'disabled',
    '342' => 'enabled',
  },
  'CfprApTrigAckOperState' => {
    '0' => 'untriggered',
    '1' => 'evaluationPending',
    '2' => 'evaluated',
    '3' => 'waitingForUser',
    '4' => 'waitingForMaintWindow',
    '5' => 'applyPending',
    '6' => 'applied',
    '7' => 'waitingForDependency',
    '8' => 'none',
    '9' => 'expired',
    '10' => 'pending',
    '11' => 'active',
  },
  'CfprApEquipmentBeaconLedState' => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'blinking',
    '4' => 'eth',
    '5' => 'fc',
  },
  'CfprApHostimgType' => {
    '0' => 'complete',
    '1' => 'kernel',
    '2' => 'fileSystem',
    '3' => 'module',
    '4' => 'gpxeScript',
  },
  'CfprApMgmtEntityUmbilicalState' => {
    '0' => 'unknown',
    '1' => 'degraded',
    '2' => 'full',
    '3' => 'failed',
  },
  'CfprApVmInstType' => {
    '0' => 'vm',
    '1' => 'hv',
    '2' => 'computeEp',
  },
  'CfprApFabricFcMonDestEpAdminSpeed' => {
    '0' => 'indeterminate',
    '1' => 'n1gbps',
    '2' => 'n2gbps',
    '3' => 'n4gbps',
    '4' => 'n8gbps',
    '5' => 'auto',
  },
  'CfprApCimcvmediaTransport' => {
    '0' => 'unknown',
    '1' => 'nfs',
    '2' => 'cifs',
    '3' => 'http',
    '4' => 'https',
  },
  'CfprApAdaptorSanCapHostNvram' => {
    '1' => 'none',
    '2' => 'full',
  },
  'CfprApEquipmentPOSTRecoverability' => {
    '0' => 'unknown',
    '1' => 'recoverable',
    '2' => 'nonRecoverable',
  },
  'CfprApMgmtControllerFsmCurrentFsm' => {
    '0' => 'nop',
    '17' => 'updateUCSManager',
    '22' => 'updateSwitch',
    '31' => 'updateIOM',
    '205' => 'extMgmtInterfaceConfig',
    '393' => 'registryConfig',
    '483' => 'sysConfig',
  },
  'CfprApFabricVlanConfigIssues' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'conflictingVlanAccess',
      '1' => 'unsupportedMulticastPolicy',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApBiosBootDevGrpType' => {
    '0' => 'systemBootOrder',
    '1' => 'fddOrder',
    '2' => 'hddOrder',
    '3' => 'cdOrder',
    '6' => 'networkDeviceOrder',
    '16' => 'internalEfiShell',
    '99' => 'unknownDeviceOrder',
    '100' => 'localStorageAnyDeviceOrder',
    '101' => 'sanDeviceOrder',
    '102' => 'sanAnyDeviceOrder',
    '103' => 'internalUsbDeviceOrder',
    '104' => 'externalUsbDeviceOrder',
    '105' => 'sdcardDeviceOrder',
    '106' => 'lanAnyDeviceOrder',
    '107' => 'uefiTargetDeviceOrder',
    '108' => 'iscsiDeviceOrder',
    '109' => 'iscsiAnyDeviceOrder',
    '110' => 'cimcVmediaCddDeviceOrder',
    '111' => 'cimcVmediaHddDeviceOrder',
    '112' => 'cimcVmediaFddDeviceOrder',
    '113' => 'kvmVmediaCddDeviceOrder',
    '114' => 'kvmVmediaHddDeviceOrder',
    '115' => 'kvmVmediaFddDeviceOrder',
    '128' => 'bevOrder',
  },
  'CfprApBiosVfUSBPortConfigurationVpUSBPortFront' => {
    '0' => 'platformRecommended',
    '306' => 'disabled',
    '307' => 'enabled',
  },
  'CfprApAdaptorEthOffloadProfileLargeReceive' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApSysdebugLogControlEpFsmCurrentFsm' => {
    '0' => 'nop',
    '381' => 'logControlPersist',
  },
  'CfprApEquipmentIOCardBaseFsmCurrentFsm' => {
    '0' => 'nop',
    '219' => 'fePresence',
    '222' => 'feConn',
  },
  'CfprApDomainFunctionalState' => {
    '0' => 'enabled',
    '1' => 'disabled',
  },
  'CfprApSmAppFsmCurrentFsm' => {
    '0' => 'nop',
    '79' => 'delete',
    '83' => 'updateApplication',
  },
  'CfprApBiosVfProcessorPrefetchConfigVpAdjacentCacheLinePrefetcher' => {
    '0' => 'platformRecommended',
    '318' => 'disabled',
    '319' => 'enabled',
  },
  'CfprApFirmwareDistributableType' => {
    '0' => 'unknown',
    '1' => 'image',
    '2' => 'fullBundle',
    '3' => 'infrastructureBundle',
    '4' => 'bSeriesBundle',
    '5' => 'cSeriesBundle',
    '6' => 'catalog',
    '7' => 'platformBundle',
    '8' => 'firmwareFpr9kBundle',
    '9' => 'firmwareFpr4kBundle',
    '10' => 'appBundle',
  },
  'CfprApFabricAEthEstcEpIfRole' => {
    '0' => 'unknown',
    '1' => 'network',
    '2' => 'server',
    '3' => 'mgmt',
    '4' => 'diag',
    '5' => 'storage',
    '6' => 'monitor',
    '7' => 'fcoeStorage',
    '8' => 'nasStorage',
    '9' => 'fcoeNasStorage',
    '10' => 'fcoeUplink',
    '11' => 'networkFcoeUplink',
    '12' => 'service',
  },
  'CfprApFabricFcMonSrcEpType' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'lan',
      '1' => 'san',
      '2' => 'ipc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApQosclassEthClassifiedPriority' => {
    '1' => 'fc',
    '2' => 'platinum',
    '3' => 'gold',
    '4' => 'silver',
    '5' => 'bronze',
    '6' => 'bestEffort',
  },
  'CfprApCallhomeUrgency' => {
    '0' => 'emergency',
    '1' => 'alert',
    '2' => 'critical',
    '3' => 'error',
    '4' => 'warning',
    '5' => 'notice',
    '6' => 'info',
    '7' => 'debug',
  },
  'CfprApPowerLockState' => {
    '0' => 'unknown',
    '1' => 'locked',
    '2' => 'unlocked',
  },
  'CfprApLsbootStorageAccess' => {
    '0' => 'readWrite',
    '1' => 'readOnly',
    '2' => 'readWriteLocal',
    '3' => 'readWriteRemote',
    '4' => 'readOnlyLocal',
    '5' => 'readOnlyRemote',
    '6' => 'readWriteDrive',
    '7' => 'readOnlyRemoteCimc',
    '8' => 'readWriteRemoteCimc',
  },
  'CfprApSdLdOperState' => {
    '0' => 'unknown',
    '1' => 'ok',
    '2' => 'incompleteConfiguration',
  },
  'CfprApFabricOperState' => {
    '0' => 'unknown',
    '1' => 'up',
    '2' => 'down',
    '3' => 'errorMisconfigured',
  },
  'CfprApSdActionType' => {
    '0' => 'none',
    '1' => 'add',
    '2' => 'update',
    '3' => 'delete',
  },
  'CfprApFabricEthFlowMonSourceType' => {
    '1' => 'vnic',
    '2' => 'portProfile',
  },
  'CfprApSwAccessEpTransport' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'ether',
      '1' => 'dce',
      '2' => 'fc',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApAdaptorMenloDcePortStatsThresholded' => sub {
      my ($input) = @_;
      my $bit_mapping = {
      '0' => 'rxPauseCFCDelta',
      '1' => 'rxPauseCFCDeltaAvg',
      '2' => 'rxPauseCFCDeltaMax',
      '3' => 'rxPauseCFCDeltaMin',
      '4' => 'rxPausePFCDelta',
      '5' => 'rxPausePFCDeltaAvg',
      '6' => 'rxPausePFCDeltaMax',
      '7' => 'rxPausePFCDeltaMin',
      '8' => 'txPauseCFCDelta',
      '9' => 'txPauseCFCDeltaAvg',
      '10' => 'txPauseCFCDeltaMax',
      '11' => 'txPauseCFCDeltaMin',
      '12' => 'txPausePFCDelta',
      '13' => 'txPausePFCDeltaAvg',
      '14' => 'txPausePFCDeltaMax',
      '15' => 'txPausePFCDeltaMin',
      };
      my $bitstring = '';
      # Hex string: "00 00 00 00 00 00 00 08"
      if (!ref($input) && $input =~ /^([0-9A-Fa-f]{2}\s+){7}[0-9A-Fa-f]{2}$/) {
        $input =~ s/\s+//g;                     # Remove spaces
        $bitstring = unpack("B*", pack("H*", $input));
      }
      # Octet string: e.g., Net::SNMP returns binary blob like "\x00\x00\x00\x00\x00\x00\x00\x08"
      elsif (!ref($input) && $input =~ /^[\x00-\xff]{1,8}$/s) {
        $bitstring = unpack("B*", $input);
      }
      # Bitstring: already normalized
      elsif (!ref($input) && $input =~ /^[01]+$/) {
        $bitstring = $input;
      }
      else {
        return "unknown bit";
      }
      # Validation: must only contain 0s and 1s
      unless ($bitstring =~ /^[01]+$/) {
        return "no010101input";
      }
      # Scan for set bits
      my @bits = split //, $bitstring;
      my @flags;
      foreach my $i (0 .. $#bits) {
        if ($bits[$i] eq '1') {
          push @flags, $bit_mapping->{$i} if exists $bit_mapping->{$i};
        }
      }
      return join(",", @flags);
  },
  'CfprApFaultBasePolicySoakingSeverity' => {
    '1' => 'info',
    '2' => 'condition',
    '3' => 'warning',
  },
  'CfprApIppoolNetBIOSMode' => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  'CfprApNfsMountDefFsmStageName' => {
    '0' => 'nop',
    '494' => 'reportNfsMountSuspendBegin',
    '495' => 'reportNfsMountSuspendReport',
    '678' => 'reportNfsMountSuspendFail',
    '679' => 'reportNfsMountSuspendSuccess',
  },
  'CfprApEquipmentDiscoveryState' => {
    '0' => 'unknown',
    '1' => 'online',
    '2' => 'offline',
    '3' => 'discovered',
    '4' => 'unsupportedConnectivity',
    '5' => 'autoUpgrading',
  },
  'CfprApAaaLdapEpFsmCurrentFsm' => {
    '0' => 'nop',
    '349' => 'updateEp',
  },
  'CfprApConditionRule' => {
    '0' => 'generic',
    '19' => 'fabricVlanReqVlanPermitUnresolved',
    '21' => 'fabricVlanGroupReqVlanGroupPermitUnresolved',
    '56' => 'dcxNsFailed',
    '57' => 'computePhysicalInsufficientlyEquipped',
    '58' => 'computePhysicalIdentityUnestablishable',
    '59' => 'computeBoardPowerError',
    '60' => 'computeBoardPowerFail',
    '61' => 'computeAboardThermalProblem',
    '62' => 'computeAboardPowerUsageProblem',
    '63' => 'computePhysicalPowerProblem',
    '64' => 'computePhysicalThermalProblem',
    '65' => 'computePhysicalBiosPostTimeout',
    '66' => 'computePhysicalDiscoveryFailed',
    '67' => 'computePhysicalAssociationFailed',
    '68' => 'computePhysicalDisassociationFailed',
    '69' => 'computePhysicalInoperable',
    '70' => 'computePhysicalUnassignedMissing',
    '71' => 'computePhysicalAssignedMissing',
    '72' => 'computePhysicalUnidentified',
    '73' => 'computePhysicalUnassignedInaccessible',
    '74' => 'computePhysicalAssignedInaccessible',
    '75' => 'computePhysicalNetworkMisconfigured',
    '76' => 'computePhysicalAdapterMismatch',
    '77' => 'computeBoardCmosVoltageThresholdCritical',
    '78' => 'computeBoardCmosVoltageThresholdNonRecoverable',
    '79' => 'computeAboardMotherBoardVoltageThresholdUpperNonRecoverable',
    '80' => 'computeAboardMotherBoardVoltageThresholdLowerNonRecoverable',
    '81' => 'computeAboardMotherBoardVoltageUpperThresholdCritical',
    '82' => 'computeAboardMotherBoardVoltageLowerThresholdCritical',
    '83' => 'computePoolEmpty',
    '84' => 'computePhysicalPostFailure',
    '85' => 'computeRtcBatteryInoperable',
    '86' => 'computeIohubThermalNonCritical',
    '87' => 'computeIohubThermalThresholdCritical',
    '88' => 'computeIohubThermalThresholdNonRecoverable',
    '89' => 'firmwareBootUnitPowerCycleRequired',
    '90' => 'cimcvmediaActualMountEntryVmediaMountFailed',
    '95' => 'firmwarePackItemImageMissing',
    '96' => 'firmwareUpdatableImageUnusable',
    '97' => 'firmwareBootUnitCantBoot',
    '98' => 'firmwareBootUnitActivateStatusFailed',
    '99' => 'firmwareStatusCimcFirmwareMismatch',
    '100' => 'firmwareStatusPldFirmwareMismatch',
    '101' => 'firmwareAutoSyncPolicyDefaultHostPackageMissing',
    '149' => 'powerChassisMemberPowerGroupCapInsufficient',
    '150' => 'powerChassisMemberChassisFirmwareProblem',
    '151' => 'powerBudgetFirmwareMismatch',
    '152' => 'powerChassisMemberChassisPsuInsufficient',
    '153' => 'powerBudgetChassisPsuInsufficient',
    '154' => 'powerChassisMemberChassisPsuRedundanceFailure',
    '155' => 'powerBudgetPowerBudgetCmcProblem',
    '156' => 'powerBudgetPowerBudgetBmcProblem',
    '157' => 'powerBudgetPowerCapReachedCommit',
    '158' => 'powerBudgetTstateTransition',
    '159' => 'powerBudgetPowerBudgetDiscFail',
    '160' => 'powerPolicyPowerPolicyApplicationFail',
    '161' => 'powerGroupPowerGroupInsufficientBudget',
    '162' => 'powerGroupPowerGroupBudgetIncorrect',
    '163' => 'powerBudgetChassisPsuMixedMode',
    '185' => 'smSlotSmaHeartbeat',
    '186' => 'smSlotBladeNotWorking',
    '187' => 'smSlotDiskFormatFailed',
    '188' => 'smSlotBladeSwap',
    '189' => 'smSecSvcSwitchConfigFail',
    '190' => 'smAppInstanceAppNotResponding',
    '191' => 'smAppInstanceAppInstallFailed',
    '192' => 'smAppInstanceAppStartFailed',
    '193' => 'smAppInstanceAppUpdateFailed',
    '194' => 'smAppInstanceAppStopFailed',
    '195' => 'smAppInstanceAppInstanceError',
    '196' => 'smLogicalDeviceIncompleteConfig',
    '197' => 'smLogicalDeviceLogicalDeviceError',
    '198' => 'smAppLicenseAgreementNotAccepted',
    '199' => 'smAppInstanceAppInstanceUnsupported',
    '200' => 'smAppAppMetaCorrupted',
    '299' => 'swVlanPortNsVlancompNotSupport',
    '300' => 'dcxVifLinkState',
    '314' => 'vnicEtherConfigFailed',
    '315' => 'vnicEtherPinningMismatch',
    '316' => 'vnicEtherPinningMisconfig',
    '317' => 'vnicEtherIfVlanAccessFault',
    '318' => 'vnicEtherIfVlanUnresolvable',
    '319' => 'vnicEtherIfRemoteVlanUnresolvable',
    '320' => 'vnicEtherIfInvalidVlan',
    '321' => 'fabricVlanVlanConflictPermit',
    '322' => 'vnicProfileProfileConfigIncorrect',
    '323' => 'vnicIscsiConfigFailed',
    '324' => 'vnicEtherVirtualizationConflict',
    '325' => 'vnicEtherVirtualizationNetflowConflict',
    '326' => 'lsIssuesIscsiConfigFailed',
    '332' => 'macpoolPoolEmpty',
    '335' => 'callhomeEpNoSnmpPolicyForCallhome',
    '349' => 'adaptorUnitUnidentifiableFru',
    '350' => 'adaptorUnitExtnUnidentifiableFru',
    '351' => 'adaptorUnitMissing',
    '352' => 'adaptorUnitExtnMissing',
    '353' => 'adaptorUnitAdaptorReachability',
    '354' => 'adaptorHostIfLinkDown',
    '355' => 'adaptorExtIfLinkDown',
    '356' => 'adaptorHostEthIfMisConnect',
    '357' => 'adaptorHostEthIfMissing',
    '358' => 'adaptorExtEthIfMisConnect',
    '359' => 'adaptorExtEthIfMissing',
    '369' => 'memoryUnitDegraded',
    '370' => 'memoryUnitIdentityUnestablishable',
    '371' => 'memoryUnitInoperable',
    '372' => 'memoryUnitDisabled',
    '373' => 'memoryUnitThermalThresholdNonCritical',
    '374' => 'memoryBufferUnitThermalThresholdNonCritical',
    '375' => 'memoryUnitThermalThresholdCritical',
    '376' => 'memoryBufferUnitThermalThresholdCritical',
    '377' => 'memoryUnitThermalThresholdNonRecoverable',
    '378' => 'memoryBufferUnitThermalThresholdNonRecoverable',
    '379' => 'memoryArrayVoltageThresholdNonCritical',
    '380' => 'memoryArrayVoltageThresholdCritical',
    '381' => 'memoryArrayVoltageThresholdNonRecoverable',
    '657' => 'lsServerFailed',
    '658' => 'lsServerDiscoveryFailed',
    '659' => 'lsServerConfigFailure',
    '660' => 'lsServerMaintenanceFailed',
    '661' => 'lsServerRemoved',
    '662' => 'lsServerInaccessible',
    '663' => 'lsServerAssociationFailed',
    '664' => 'lsComputeBindingAssignmentRequirementsNotMet',
    '665' => 'lsServerUnassociated',
    '666' => 'lsServerSvnicNotPresent',
    '667' => 'lsServerServerUnfulfilled',
    '668' => 'lsmaintMaintPolicyUnresolvableScheduler',
    '669' => 'lsIssuesKvmPolicyUnsupported',
    '675' => 'iqnpoolPoolEmpty',
    '687' => 'etherSwitchIntfioSatelliteConnectionAbsent',
    '688' => 'etherSwitchIntfioSatelliteWiringProblem',
    '689' => 'etherSwitchIntfioSatelliteWiringNumbersUnexpected',
    '690' => 'equipmentPsuPowerSupplyProblem',
    '691' => 'equipmentPsuOffline',
    '692' => 'equipmentPsuPowerSupplyShutdown',
    '693' => 'equipmentChassisIdentityUnestablishable',
    '694' => 'equipmentFexIdentityUnestablishable',
    '695' => 'equipmentFexFexUnsupported',
    '696' => 'equipmentFanModuleDegraded',
    '697' => 'equipmentFanDegraded',
    '698' => 'equipmentChassisInoperable',
    '699' => 'equipmentChassisSeepromInoperable',
    '700' => 'equipmentFanModuleInoperable',
    '701' => 'equipmentFanInoperable',
    '702' => 'equipmentPsuInoperable',
    '703' => 'equipmentIocardRemoved',
    '704' => 'equipmentIocardInaccessible',
    '705' => 'equipmentIocardPostFailure',
    '706' => 'equipmentFexPostFailure',
    '707' => 'equipmentFanModuleMissing',
    '708' => 'equipmentFanMissing',
    '709' => 'equipmentPsuMissing',
    '710' => 'equipmentIocardThermalProblem',
    '711' => 'equipmentIocardThermalThresholdNonCritical',
    '712' => 'equipmentIocardThermalThresholdCritical',
    '713' => 'equipmentIocardThermalThresholdNonRecoverable',
    '714' => 'equipmentFanModuleThermalThresholdNonCritical',
    '715' => 'equipmentPsuThermalThresholdNonCritical',
    '716' => 'equipmentFanModuleThermalThresholdCritical',
    '717' => 'equipmentPsuThermalThresholdCritical',
    '718' => 'equipmentFanModuleThermalThresholdNonRecoverable',
    '719' => 'equipmentPsuThermalThresholdNonRecoverable',
    '720' => 'equipmentPsuVoltageThresholdNonCritical',
    '721' => 'equipmentPsuVoltageThresholdCritical',
    '722' => 'equipmentPsuVoltageThresholdNonRecoverable',
    '723' => 'equipmentPsuPerfThresholdNonCritical',
    '724' => 'equipmentPsuPerfThresholdCritical',
    '725' => 'equipmentPsuPerfThresholdNonRecoverable',
    '726' => 'equipmentFanPerfThresholdNonCritical',
    '727' => 'equipmentFanPerfThresholdCritical',
    '728' => 'equipmentFanPerfThresholdNonRecoverable',
    '729' => 'equipmentFanPerfThresholdLowerNonRecoverable',
    '730' => 'equipmentIocardFirmwareUpgrade',
    '731' => 'equipmentChassisUnsupportedConnectivity',
    '732' => 'equipmentChassisUnacknowledged',
    '733' => 'equipmentIocardUnsupportedConnectivity',
    '734' => 'equipmentIocardAutoUpgradingFirmware',
    '735' => 'equipmentIocardUnacknowledged',
    '736' => 'equipmentIocardPeerDisconnected',
    '737' => 'equipmentChassisIdentity',
    '738' => 'equipmentChassisInvalidFru',
    '739' => 'equipmentChassisPowerProblem',
    '740' => 'equipmentChassisThermalThresholdCritical',
    '741' => 'equipmentChassisThermalThresholdNonCritical',
    '742' => 'equipmentChassisThermalThresholdNonRecoverable',
    '743' => 'equipmentIocardIdentity',
    '744' => 'equipmentFexIdentity',
    '745' => 'equipmentFanModuleIdentity',
    '746' => 'equipmentPsuIdentity',
    '747' => 'equipmentPsuPowerThreshold',
    '748' => 'equipmentPsuInputError',
    '749' => 'equipmentSwitchCardPowerOff',
    '750' => 'equipmentSwitchCardAct2LiteFail',
    '751' => 'equipmentHealthLedCriticalError',
    '752' => 'equipmentTpmSlaveTpm',
    '753' => 'equipmentHealthLedMinorError',
    '754' => 'equipmentSwitchiocardRemoved',
    '755' => 'equipmentSwitchiocardThermalProblem',
    '756' => 'equipmentSwitchiocardThermalThresholdNonCritical',
    '757' => 'equipmentSwitchiocardThermalThresholdCritical',
    '758' => 'equipmentSwitchiocardThermalThresholdNonRecoverable',
    '759' => 'equipmentSwitchiocardIdentity',
    '760' => 'equipmentSwitchiocardCpuThermalThresholdCritical',
    '792' => 'extpolClientClientLostConnectivity',
    '793' => 'extpolClientGracePeriodWarning',
    '794' => 'extpolClientGracePeriodWarning2',
    '795' => 'extpolClientGracePeriodWarning3',
    '796' => 'extpolClientGracePeriodWarning4',
    '797' => 'extpolClientGracePeriodWarning5',
    '798' => 'extpolClientGracePeriodWarning6',
    '799' => 'extpolClientGracePeriodWarning7',
    '800' => 'extpolClientGracePeriodWarning1',
    '809' => 'storageLocalDiskInoperable',
    '810' => 'storageLocalDiskDegraded',
    '811' => 'storageLocalDiskSlotEpUnusable',
    '812' => 'storageItemCapacityExceeded',
    '813' => 'storageItemCapacityWarning',
    '814' => 'storageItemFilesystemIssues',
    '815' => 'storageRaidBatteryInoperable',
    '816' => 'storageMezzFlashLifeConfigurationError',
    '817' => 'storageMezzFlashLifeDegraded',
    '818' => 'storageRaidBatteryDegraded',
    '819' => 'storageRaidBatteryRelearnAborted',
    '820' => 'storageRaidBatteryRelearnFailed',
    '821' => 'storageInitiatorConfigurationError',
    '822' => 'storageControllerPatrolReadFailed',
    '823' => 'storageControllerInoperable',
    '824' => 'storageLocalDiskRebuildFailed',
    '825' => 'storageLocalDiskCopybackFailed',
    '826' => 'storageLocalDiskMissing',
    '827' => 'storageVirtualDriveInoperable',
    '828' => 'storageVirtualDriveDegraded',
    '829' => 'storageVirtualDriveReconstructionFailed',
    '830' => 'storageVirtualDriveConsistencyCheckFailed',
    '831' => 'storageFlexFlashControllerInoperable',
    '832' => 'storageFlexFlashCardInoperable',
    '833' => 'storageFlexFlashCardMissing',
    '834' => 'storageFlexFlashVirtualDriveDegraded',
    '835' => 'storageFlexFlashVirtualDriveInoperable',
    '836' => 'storageFlexFlashControllerUnhealthy',
    '837' => 'storageFlexFlashControllerMismatch',
    '838' => 'storageFlexFlashDriveUnhealthy',
    '839' => 'storageFlexFlashCardUnhealthy',
    '844' => 'ippoolPoolEmpty',
    '850' => 'aaaProviderGroupProvidergroup',
    '851' => 'aaaProviderGroupProvidergroupsize',
    '852' => 'aaaConfigServergroup',
    '853' => 'pkiKeyRingStatus',
    '854' => 'pkiKeyRingModulus',
    '855' => 'pkiTpStatus',
    '856' => 'aaaRoleRoleNotDeployed',
    '857' => 'aaaLocaleLocaleNotDeployed',
    '858' => 'aaaOrgLocaleOrgNotPresent',
    '859' => 'aaaUserRoleUserRoleNotDeployed',
    '860' => 'aaaUserLocaleUserLocaleNotDeployed',
    '861' => 'pkiKeyRingKeyRingNotDeployed',
    '862' => 'commSnmpSyscontactEmpty',
    '863' => 'commDateTimeCommTimeZoneInvalid',
    '864' => 'aaaUserLocalUserNotDeployed',
    '865' => 'commSnmpUserSnmpUserNotDeployed',
    '866' => 'commSvcEpCommSvcNotDeployed',
    '871' => 'sysdebugLogExportStatusLogExportFailure',
    '872' => 'sysdebugAutoCoreFileExportTargetAutoCoreTransferFailure',
    '899' => 'processorUnitInoperable',
    '900' => 'processorUnitThermalNonCritical',
    '901' => 'processorUnitThermalThresholdCritical',
    '902' => 'processorUnitThermalThresholdNonRecoverable',
    '903' => 'processorUnitVoltageThresholdNonCritical',
    '904' => 'processorUnitVoltageThresholdCritical',
    '905' => 'processorUnitVoltageThresholdNonRecoverable',
    '906' => 'processorUnitIdentityUnestablishable',
    '907' => 'processorUnitDisabled',
    '964' => 'extmgmtIfMgmtifdown',
    '965' => 'extmgmtArpTargetsArpTargetsNotValid',
    '966' => 'extmgmtNdiscTargetsNdiscTargetsNotValid',
    '967' => 'poolElementDuplicatedAssigned',
    '977' => 'networkElementInoperable',
    '978' => 'networkElementRemoved',
    '979' => 'swVlanPortNsResourceStatus',
    '980' => 'swVlanPortNsResourceStatusWarning',
    '981' => 'networkElementInventoryFailed',
    '982' => 'networkElementThermalThresholdCritical',
    '983' => 'networkElementMemoryerror',
    '984' => 'networkOperLevelExtraprimaryvlans',
    '985' => 'networkOperLevelExtrasecondaryvlans',
    '986' => 'swVlanExtrasecondaryvlansperprimary',
    '987' => 'fcpoolInitiatorsEmpty',
    '996' => 'osControllerFailedBladeBootup',
    '997' => 'osControllerFailedBootupRecovery',
    '1014' => 'uuidpoolPoolEmpty',
    '1020' => 'capabilityCatalogueLoadErrors',
    '1038' => 'fabricComputeSlotEpMisplacedInChassisSlot',
    '1039' => 'fabricComputeSlotEpServerIdentificationProblem',
    '1040' => 'fabricVlanPrimaryVlanMissingForIsolated',
    '1041' => 'fabricVlanPrimaryVlanMissingForCommunity',
    '1042' => 'fabricLanPinGroupEmpty',
    '1043' => 'fabricEthLanPcEpDown',
    '1044' => 'fabricEthEstcPcEpDown',
    '1045' => 'fabricPinTargetDown',
    '1046' => 'fabricDceSwSrvPcEpDown',
    '1047' => 'fabricMonSpanConfigFail',
    '1048' => 'fabricEpMgrEpTransModeFail',
    '1049' => 'fabricVlanMismatchA',
    '1050' => 'fabricVlanMismatchB',
    '1051' => 'fabricVlanErrorAssocPrimary',
    '1052' => 'fabricPioEpErrorMisconfigured',
    '1053' => 'fabricEthLanEpMissingPrimaryVlan',
    '1054' => 'fabricEthLanEpUdldLinkDown',
    '1055' => 'fabricEthLanPcEpUdldLinkDown',
    '1056' => 'fabricEthLanPcMissingPrimaryVlan',
    '1057' => 'fabricEthLanEpOverlappingVlan',
    '1058' => 'fabricEthLanPcOverlappingVlan',
    '1059' => 'fabricVlanMisconfiguredMcastPolicy',
    '1060' => 'fabricNetflowMonSessionFlowMonConfigFail',
    '1061' => 'fabricNetflowMonSessionNetflowSessionConfigFail',
    '1062' => 'fabricPooledVlanNamedVlanUnresolved',
    '1115' => 'mgmtEntityDegraded',
    '1116' => 'mgmtEntityDown',
    '1117' => 'mgmtEntityElectionFailure',
    '1118' => 'mgmtEntityManagementServicesFailure',
    '1119' => 'mgmtEntityManagementServicesUnresponsive',
    '1120' => 'mgmtEntityHaNotReady',
    '1121' => 'mgmtEntityVersionIncompatible',
    '1122' => 'mgmtEntityDevice1SharedStorageError',
    '1123' => 'mgmtEntityDevice2SharedStorageError',
    '1124' => 'mgmtEntityDevice3SharedStorageError',
    '1125' => 'mgmtEntityHaSshKeysMismatched',
    '1126' => 'mgmtPmonEntryFprmProcessFailure',
    '1127' => 'sysdebugMepLogMEpLogLog',
    '1128' => 'sysdebugMepLogMEpLogVeryLow',
    '1129' => 'sysdebugMepLogMEpLogFull',
    '1130' => 'sysdebugMepLogTransferError',
    '1131' => 'mgmtIfMisConnect',
    '1132' => 'mgmtIfMissing',
    '1133' => 'mgmtIfNew',
    '1134' => 'mgmtConnectionDisabled',
    '1135' => 'mgmtConnectionUnused',
    '1136' => 'mgmtConnectionUnsupportedConnectivity',
    '1137' => 'mgmtControllerUnsupportedDimmBlacklisting',
    '1138' => 'mgmtInterfaceNamedInbandVlanUnresolved',
    '1139' => 'mgmtInterfaceInbandUnsupportedServer',
    '1140' => 'mgmtInterfaceInbandUnsupportedFirmware',
    '1141' => 'mgmtBackupPolicyConfigConfigurationBackupOutdated',
    '1150' => 'portPioLinkDown',
    '1151' => 'portPioFailed',
    '1152' => 'portPioHardwareFailure',
    '1153' => 'portPioSfpNotPresent',
    '1154' => 'portPioInvalidSfp',
    '1155' => 'etherServerIntfioHardwareFailure',
    '1156' => 'fabricExternalPcDown',
    '1157' => 'fabricInternalPcDown',
    '1158' => 'dcxVcDown',
    '1159' => 'dcxVcMgmtVifDown',
    '1174' => 'policyControlEpSuspendModeActive',
    '1309' => 'firmwareInfraPackInfraBundleVersionMissing',
    '1310' => 'firmwareSystemInfraBundleValidationFailure',
    '1311' => 'firmwareSystemInfraBundleUpgradeFailure',
    '1312' => 'firmwareSystemFirmwareUpgradeFailure',
    '1313' => 'firmwareSystemInfraBundleInstallAppFailure',
    '16476' => 'fsmSamDmeComputeServerDiscPolicyResolveScrubPolicy',
    '16477' => 'fsmSamDmeGmetaHolderInventory',
    '16517' => 'fsmSamDmeFirmwareDownloaderDownload',
    '16518' => 'fsmSamDmeFirmwareImageDelete',
    '16519' => 'fsmSamDmeFirmwareDistributableDelete',
    '16520' => 'fsmSamDmeMgmtControllerUpdateucsmanager',
    '16521' => 'fsmSamDmeMgmtControllerUpdateSwitch',
    '16522' => 'fsmSamDmeMgmtControllerUpdateiom',
    '16523' => 'fsmSamDmeFirmwarePlatformPackPlatformVersion',
    '16524' => 'fsmSamDmeFirmwareSystemDeploy',
    '16525' => 'fsmSamDmeFirmwareSupFirmwareDeploy',
    '16526' => 'fsmSamDmeFirmwareSystemApplyCatalogPack',
    '16528' => 'fsmSamDmeIdentIdentRequestUpdateIdent',
    '16529' => 'fsmSamDmeIdentMetaSystemSync',
    '16530' => 'fsmSamDmeIdentMetaSystemUcscUnivSync',
    '16585' => 'fsmSamDmeSmAppDelete',
    '16586' => 'fsmSamDmeSmSecSvcRestoreApplication',
    '16587' => 'fsmSamDmeSmAppUpdateApplication',
    '16588' => 'fsmSamDmeSmAppInstanceResetApplication',
    '16589' => 'fsmSamDmeSmSecSvcAutoDeploycsp',
    '16667' => 'fsmSamDmeSwAccessDomainDeploy',
    '16668' => 'fsmSamDmeSwEthLanBorderDeploy',
    '16669' => 'fsmSamDmeSwFcSanBorderDeploy',
    '16670' => 'fsmSamDmeSwUtilityDomainDeploy',
    '16671' => 'fsmSamDmeSwEthLanFlowMonDeploy',
    '16676' => 'fsmSamDmeSwPhysConfPhysical',
    '16681' => 'fsmSamDmeSwExtUtilityConfPortBreakout',
    '16682' => 'fsmSamDmeSwFcSanBorderActivateZoneSet',
    '16718' => 'fsmSamDmeCallhomeEpConfigCallhome',
    '16727' => 'fsmSamDmeAdaptorExtEthIfPathReset',
    '16730' => 'fsmSamDmeAdaptorHostEthIfCircuitReset',
    '16731' => 'fsmSamDmeAdaptorHostFcIfCircuitReset',
    '16748' => 'fsmSamDmeLicenseDownloaderDownload',
    '16749' => 'fsmSamDmeLicenseFileInstall',
    '16750' => 'fsmSamDmeLicenseFileClear',
    '16751' => 'fsmSamDmeLicenseInstanceUpdateFlexlm',
    '16752' => 'fsmSamDmeLicenseSmartConfigSetConfig',
    '16770' => 'fsmSamDmeLsServerConfigure',
    '16780' => 'fsmSamDmeComputeBladeDiag',
    '16803' => 'fsmSamDmeMgmtControllerExtMgmtInterfaceConfig',
    '16804' => 'fsmSamDmeComputePhysicalSwConnUpd',
    '16805' => 'fsmSamDmeEquipmentiocardResetIom',
    '16806' => 'fsmSamDmeComputePhysicalServiceInfraDeploy',
    '16807' => 'fsmSamDmeComputePhysicalServiceInfraWithdraw',
    '16815' => 'fsmSamDmeEquipmentiocardBaseFePresence',
    '16816' => 'fsmSamDmeEquipmentiocardBaseFeConn',
    '16817' => 'fsmSamDmeEquipmentChassisRemoveChassis',
    '16818' => 'fsmSamDmeEquipmentLocatorLedSetFeLocatorLed',
    '16819' => 'fsmSamDmeEquipmentLocatorLedSetFiLocatorLed',
    '16822' => 'fsmSamDmePortpioInCompatSfpPresence',
    '16823' => 'fsmSamDmePortpioInCompatSfpReplaced',
    '17063' => 'fsmSamDmeObserveObservedResolvePolicyFsm',
    '17064' => 'fsmSamDmeObserveObservedResolveResourceFsm',
    '17065' => 'fsmSamDmeObserveObservedResolvevmfsm',
    '17066' => 'fsmSamDmeObserveObservedResolveControllerFsm',
    '17149' => 'fsmSamDmeEquipmentBeaconLedIlluminate',
    '17151' => 'fsmSamDmeSdAppInstanceInstallApplication',
    '17152' => 'fsmSamDmeSdAppInstanceStartApplication',
    '17153' => 'fsmSamDmeSdLduProvisionldu',
    '17154' => 'fsmSamDmeSdAppInstanceUpgradeApplication',
    '17155' => 'fsmSamDmeSdAppInstanceStopApplication',
    '17156' => 'fsmSamDmeSdAppInstanceUninstallApplication',
    '17157' => 'fsmSamDmeSdSlotChangePlatformLogLevel',
    '17158' => 'fsmSamDmeSdAppInstanceBundleDataPorts',
    '17159' => 'fsmSamDmeSdLogicalDeviceConfigureLinks',
    '17160' => 'fsmSamDmeSdLinkUpdateInterfaceStatus',
    '17161' => 'fsmSamDmeSdClusterBootstrapUpdateClusterConfiguration',
    '17162' => 'fsmSamDmeSdSlotFormatDisk',
    '17163' => 'fsmSamDmeSdSlotSynchTimeZone',
    '17164' => 'fsmSamDmeSdAppAttributeCtrlGetAppAttributes',
    '17165' => 'fsmSamDmeSdMgmtInfoUpdateMgmtInfo',
    '17166' => 'fsmSamDmeSdNetMgmtBootstrapUpdateNetMgmtBootstrap',
    '17167' => 'fsmSamDmeSdUpgradeTaskStopUpgradeStartApp',
    '17169' => 'fsmSamDmeEtherServerIntfioConfigSpeed',
    '17170' => 'fsmSamDmeEtherFtwPortPairConfigFtw',
    '17185' => 'fsmSamDmeExtpolEpRegisterFsm',
    '17186' => 'fsmSamDmeExtpolRegistryCrossDomainConfig',
    '17187' => 'fsmSamDmeExtpolRegistryCrossDomainDelete',
    '17224' => 'fsmSamDmeStorageSystemSync',
    '17226' => 'fsmSamDmeSysfileMutationSingle',
    '17227' => 'fsmSamDmeSysfileMutationGlobal',
    '17231' => 'fsmSamDmeApplicationDownloaderDownload',
    '17232' => 'fsmSamDmeCommSvcEpUpdateSvcEp',
    '17233' => 'fsmSamDmeCommSvcEpRestartWebSvc',
    '17251' => 'fsmSamDmePkiEpUpdateEp',
    '17252' => 'fsmSamDmeAaaEpUpdateEp',
    '17253' => 'fsmSamDmeAaaRealmUpdateRealm',
    '17254' => 'fsmSamDmeAaaUserEpUpdateUserEp',
    '17265' => 'fsmSamDmeSysdebugManualCoreFileExportTargetExport',
    '17266' => 'fsmSamDmeSysdebugLogExportPolicyConfigure',
    '17267' => 'fsmSamDmeSysdebugAutoCoreFileExportTargetConfigure',
    '17268' => 'fsmSamDmeSysdebugTechSupportInitiate',
    '17269' => 'fsmSamDmeSysdebugTechSupportDeleteTechSupFile',
    '17270' => 'fsmSamDmeSysdebugTechSupportDownload',
    '17271' => 'fsmSamDmeSysdebugCoreDownload',
    '17272' => 'fsmSamDmeSysdebugLogControlEpLogControlPersist',
    '17336' => 'fsmSamDmeEpqosDefinitionDeploy',
    '17337' => 'fsmSamDmeEpqosDefinitionDelTaskRemove',
    '17340' => 'fsmSamDmeQosclassDefinitionConfigGlobalQos',
    '17347' => 'fsmSamDmeMgmtControllerRegistryConfig',
    '17358' => 'fsmSamDmeMgmtIfSwMgmtOobIfConfig',
    '17359' => 'fsmSamDmeMgmtIfSwMgmtInbandIfConfig',
    '17360' => 'fsmSamDmeMgmtipv6IfAddrSwMgmtOobIpv6IfConfig',
    '17373' => 'fsmSamDmeNhTableHolderConfigureLinks',
    '17374' => 'fsmSamDmeNhTableHolderBootstrapLinks',
    '17378' => 'fsmSamDmeStatsCollectionPolicyUpdateEp',
    '17403' => 'fsmSamDmeSyntheticFsObjCreate',
    '17408' => 'fsmSamDmeCapabilityUpdaterUpdater',
    '17409' => 'fsmSamDmeCapabilityCatalogueActivateCatalog',
    '17410' => 'fsmSamDmeCapabilityMgmtExtensionActivateMgmtExt',
    '17411' => 'fsmSamDmeCapabilityCatalogueDeployCatalogue',
    '17420' => 'fsmSamDmeSwEthMonDeploy',
    '17421' => 'fsmSamDmeSwFcMonDeploy',
    '17469' => 'fsmSamDmeSwSspEthMonDeploy',
    '17470' => 'fsmSamDmeSwSspEthMonSrcPhyEpDelete',
    '17476' => 'fsmSamDmeFabricVnetEpSyncEpPushVnetEpDeletion',
    '17477' => 'fsmSamDmeFabricLanCloudSwitchMode',
    '17478' => 'fsmSamDmeFabricSanCloudSwitchMode',
    '17484' => 'fsmSamDmeFabricEpMgrConfigure',
    '17490' => 'fsmSamDmeMgmtExportPolicyReportConfigCopy',
    '17491' => 'fsmSamDmeExtpolProviderReportConfigImport',
    '17492' => 'fsmSamDmeMgmtIfVirtualIfConfig',
    '17493' => 'fsmSamDmeMgmtIfEnableVip',
    '17494' => 'fsmSamDmeMgmtIfDisableVip',
    '17495' => 'fsmSamDmeMgmtIfEnableha',
    '17496' => 'fsmSamDmeMgmtBackupBackup',
    '17497' => 'fsmSamDmeMgmtImporterImport',
    '17498' => 'fsmSamDmeMgmtControllerSysConfig',
    '17531' => 'fsmSamDmeNfsMountInstMount',
    '17532' => 'fsmSamDmeNfsMountInstUnmount',
    '17533' => 'fsmSamDmeNfsMountDefReportNfsMountSuspend',
    '17554' => 'fsmSamDmeExtpolEpRepairCert',
    '17555' => 'fsmSamDmePolicyControlEpOperate',
    '17556' => 'fsmSamDmePolicyControlledTypeOperate',
    '17559' => 'fsmSamDmePolicyPolicyScopeReleasePolicyFsm',
    '17560' => 'fsmSamDmePolicyPolicyScopeReleaseOperationFsm',
    '17561' => 'fsmSamDmePolicyPolicyScopeReleaseStorageFsm',
    '17562' => 'fsmSamDmePolicyPolicyScopeResolveManyPolicyFsm',
    '17563' => 'fsmSamDmePolicyPolicyScopeResolveManyOperationFsm',
    '17564' => 'fsmSamDmePolicyPolicyScopeResolveManyStorageFsm',
    '17565' => 'fsmSamDmePolicyPolicyScopeReleaseManyPolicyFsm',
    '17566' => 'fsmSamDmePolicyPolicyScopeReleaseManyOperationFsm',
    '17567' => 'fsmSamDmePolicyPolicyScopeReleaseManyStorageFsm',
    '17568' => 'fsmSamDmePolicyPolicyScopeResolveAllPolicyFsm',
    '17569' => 'fsmSamDmePolicyPolicyScopeResolveAllOperationFsm',
    '17570' => 'fsmSamDmePolicyPolicyScopeResolveAllStorageFsm',
    '17571' => 'fsmSamDmePolicyPolicyScopeReleaseAllPolicyFsm',
    '17572' => 'fsmSamDmePolicyPolicyScopeReleaseAllOperationFsm',
    '17573' => 'fsmSamDmePolicyPolicyScopeReleaseAllStorageFsm',
    '17690' => 'fsmSamDmeFirmwareInfraPackInfraVersion',
    '34261' => 'tcaComputeMbPowerStatsInputVoltage',
    '34263' => 'tcaComputeMbPowerStatsInputVoltageMin',
    '34264' => 'tcaComputeMbPowerStatsInputVoltageMax',
    '34265' => 'tcaComputeMbPowerStatsInputVoltageAvg',
    '34269' => 'tcaComputeMbPowerStatsInputCurrent',
    '34271' => 'tcaComputeMbPowerStatsInputCurrentMin',
    '34272' => 'tcaComputeMbPowerStatsInputCurrentMax',
    '34273' => 'tcaComputeMbPowerStatsInputCurrentAvg',
    '34277' => 'tcaComputeMbPowerStatsConsumedPower',
    '34279' => 'tcaComputeMbPowerStatsConsumedPowerMin',
    '34280' => 'tcaComputeMbPowerStatsConsumedPowerMax',
    '34281' => 'tcaComputeMbPowerStatsConsumedPowerAvg',
    '34287' => 'tcaComputeMbTempStatsFmTempSenIo',
    '34289' => 'tcaComputeMbTempStatsFmTempSenIoMin',
    '34290' => 'tcaComputeMbTempStatsFmTempSenIoMax',
    '34291' => 'tcaComputeMbTempStatsFmTempSenIoAvg',
    '34295' => 'tcaComputeMbTempStatsFmTempSenRear',
    '34297' => 'tcaComputeMbTempStatsFmTempSenRearMin',
    '34298' => 'tcaComputeMbTempStatsFmTempSenRearMax',
    '34299' => 'tcaComputeMbTempStatsFmTempSenRearAvg',
    '34303' => 'tcaComputeMbTempStatsFmTempSenRearl',
    '34305' => 'tcaComputeMbTempStatsFmTempSenRearlmin',
    '34306' => 'tcaComputeMbTempStatsFmTempSenRearlmax',
    '34307' => 'tcaComputeMbTempStatsFmTempSenRearlavg',
    '34311' => 'tcaComputeMbTempStatsFmTempSenRearr',
    '34313' => 'tcaComputeMbTempStatsFmTempSenRearrmin',
    '34314' => 'tcaComputeMbTempStatsFmTempSenRearrmax',
    '34315' => 'tcaComputeMbTempStatsFmTempSenRearravg',
    '34321' => 'tcaComputeRackUnitMbTempStatsFrontTemp',
    '34323' => 'tcaComputeRackUnitMbTempStatsFrontTempMin',
    '34324' => 'tcaComputeRackUnitMbTempStatsFrontTempMax',
    '34325' => 'tcaComputeRackUnitMbTempStatsFrontTempAvg',
    '34329' => 'tcaComputeRackUnitMbTempStatsRearTemp',
    '34331' => 'tcaComputeRackUnitMbTempStatsRearTempMin',
    '34332' => 'tcaComputeRackUnitMbTempStatsRearTempMax',
    '34333' => 'tcaComputeRackUnitMbTempStatsRearTempAvg',
    '34337' => 'tcaComputeRackUnitMbTempStatsAmbientTemp',
    '34339' => 'tcaComputeRackUnitMbTempStatsAmbientTempMin',
    '34340' => 'tcaComputeRackUnitMbTempStatsAmbientTempMax',
    '34341' => 'tcaComputeRackUnitMbTempStatsAmbientTempAvg',
    '34345' => 'tcaComputeRackUnitMbTempStatsIoh1Temp',
    '34347' => 'tcaComputeRackUnitMbTempStatsIoh1TempMin',
    '34348' => 'tcaComputeRackUnitMbTempStatsIoh1TempMax',
    '34349' => 'tcaComputeRackUnitMbTempStatsIoh1TempAvg',
    '34353' => 'tcaComputeRackUnitMbTempStatsIoh2Temp',
    '34355' => 'tcaComputeRackUnitMbTempStatsIoh2TempMin',
    '34356' => 'tcaComputeRackUnitMbTempStatsIoh2TempMax',
    '34357' => 'tcaComputeRackUnitMbTempStatsIoh2TempAvg',
    '34363' => 'tcaComputeIohubEnvStatsTemperature',
    '34365' => 'tcaComputeIohubEnvStatsTemperatureMin',
    '34366' => 'tcaComputeIohubEnvStatsTemperatureMax',
    '34367' => 'tcaComputeIohubEnvStatsTemperatureAvg',
    '34372' => 'tcaComputePcieFatalProtocolStatsFlowControlErrors',
    '34383' => 'tcaComputePcieFatalProtocolStatsDllpErrors',
    '34395' => 'tcaComputePcieFatalReceiveStatsUnsupportedRequestErrors',
    '34406' => 'tcaComputePcieFatalReceiveStatsErrFatalErrors',
    '34417' => 'tcaComputePcieFatalReceiveStatsErrNonFatalErrors',
    '34428' => 'tcaComputePcieFatalReceiveStatsBufferOverflowErrors',
    '34440' => 'tcaComputePcieFatalCompletionStatsUnexpectedErrors',
    '34451' => 'tcaComputePcieFatalCompletionStatsTimeoutErrors',
    '34462' => 'tcaComputePcieFatalCompletionStatsAbortErrors',
    '34474' => 'tcaComputePcieFatalStatsSurpriseLinkDownErrors',
    '34485' => 'tcaComputePcieFatalStatsPoisonedtlperrors',
    '34496' => 'tcaComputePcieFatalStatsAcsViolationErrors',
    '34507' => 'tcaComputePcieFatalStatsMalformedtlperrors',
    '34841' => 'tcaPowerGroupStatsPower',
    '34843' => 'tcaPowerGroupStatsPowerMin',
    '34844' => 'tcaPowerGroupStatsPowerMax',
    '34845' => 'tcaPowerGroupStatsPowerAvg',
    '35108' => 'tcaSwEnvStatsMainBoardOutlet1',
    '35110' => 'tcaSwEnvStatsMainBoardOutlet1Min',
    '35111' => 'tcaSwEnvStatsMainBoardOutlet1Max',
    '35112' => 'tcaSwEnvStatsMainBoardOutlet1Avg',
    '35116' => 'tcaSwEnvStatsMainBoardOutlet2',
    '35118' => 'tcaSwEnvStatsMainBoardOutlet2Min',
    '35119' => 'tcaSwEnvStatsMainBoardOutlet2Max',
    '35120' => 'tcaSwEnvStatsMainBoardOutlet2Avg',
    '35124' => 'tcaSwEnvStatsFanCtrlrInlet1',
    '35126' => 'tcaSwEnvStatsFanCtrlrInlet1Min',
    '35127' => 'tcaSwEnvStatsFanCtrlrInlet1Max',
    '35128' => 'tcaSwEnvStatsFanCtrlrInlet1Avg',
    '35132' => 'tcaSwEnvStatsFanCtrlrInlet2',
    '35134' => 'tcaSwEnvStatsFanCtrlrInlet2Min',
    '35135' => 'tcaSwEnvStatsFanCtrlrInlet2Max',
    '35136' => 'tcaSwEnvStatsFanCtrlrInlet2Avg',
    '35140' => 'tcaSwEnvStatsFanCtrlrInlet3',
    '35142' => 'tcaSwEnvStatsFanCtrlrInlet3Min',
    '35143' => 'tcaSwEnvStatsFanCtrlrInlet3Max',
    '35144' => 'tcaSwEnvStatsFanCtrlrInlet3Avg',
    '35148' => 'tcaSwEnvStatsFanCtrlrInlet4',
    '35150' => 'tcaSwEnvStatsFanCtrlrInlet4Min',
    '35151' => 'tcaSwEnvStatsFanCtrlrInlet4Max',
    '35152' => 'tcaSwEnvStatsFanCtrlrInlet4Avg',
    '35156' => 'tcaSwEnvStatsPsuCtrlrInlet1',
    '35158' => 'tcaSwEnvStatsPsuCtrlrInlet1Min',
    '35159' => 'tcaSwEnvStatsPsuCtrlrInlet1Max',
    '35160' => 'tcaSwEnvStatsPsuCtrlrInlet1Avg',
    '35164' => 'tcaSwEnvStatsPsuCtrlrInlet2',
    '35166' => 'tcaSwEnvStatsPsuCtrlrInlet2Min',
    '35167' => 'tcaSwEnvStatsPsuCtrlrInlet2Max',
    '35168' => 'tcaSwEnvStatsPsuCtrlrInlet2Avg',
    '35174' => 'tcaSwCardEnvStatsSlotOutlet1',
    '35176' => 'tcaSwCardEnvStatsSlotOutlet1Min',
    '35177' => 'tcaSwCardEnvStatsSlotOutlet1Max',
    '35178' => 'tcaSwCardEnvStatsSlotOutlet1Avg',
    '35182' => 'tcaSwCardEnvStatsSlotOutlet2',
    '35184' => 'tcaSwCardEnvStatsSlotOutlet2Min',
    '35185' => 'tcaSwCardEnvStatsSlotOutlet2Max',
    '35186' => 'tcaSwCardEnvStatsSlotOutlet2Avg',
    '35190' => 'tcaSwCardEnvStatsSlotOutlet3',
    '35192' => 'tcaSwCardEnvStatsSlotOutlet3Min',
    '35193' => 'tcaSwCardEnvStatsSlotOutlet3Max',
    '35194' => 'tcaSwCardEnvStatsSlotOutlet3Avg',
    '35200' => 'tcaSwSystemStatsMemAvailable',
    '35202' => 'tcaSwSystemStatsMemAvailableMin',
    '35203' => 'tcaSwSystemStatsMemAvailableMax',
    '35204' => 'tcaSwSystemStatsMemAvailableAvg',
    '35208' => 'tcaSwSystemStatsMemCached',
    '35210' => 'tcaSwSystemStatsMemCachedMin',
    '35211' => 'tcaSwSystemStatsMemCachedMax',
    '35212' => 'tcaSwSystemStatsMemCachedAvg',
    '35216' => 'tcaSwSystemStatsLoad',
    '35218' => 'tcaSwSystemStatsLoadMin',
    '35219' => 'tcaSwSystemStatsLoadMax',
    '35220' => 'tcaSwSystemStatsLoadAvg',
    '35844' => 'tcaAdaptorEthPortStatsTotalPacketsDelta',
    '35845' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaMin',
    '35846' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaMax',
    '35847' => 'tcaAdaptorEthPortStatsTotalPacketsDeltaAvg',
    '35854' => 'tcaAdaptorEthPortStatsGoodPacketsDelta',
    '35855' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaMin',
    '35856' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaMax',
    '35857' => 'tcaAdaptorEthPortStatsGoodPacketsDeltaAvg',
    '35864' => 'tcaAdaptorEthPortStatsVlanPacketsDelta',
    '35865' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaMin',
    '35866' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaMax',
    '35867' => 'tcaAdaptorEthPortStatsVlanPacketsDeltaAvg',
    '35874' => 'tcaAdaptorEthPortStatsPausePacketsDelta',
    '35875' => 'tcaAdaptorEthPortStatsPausePacketsDeltaMin',
    '35876' => 'tcaAdaptorEthPortStatsPausePacketsDeltaMax',
    '35877' => 'tcaAdaptorEthPortStatsPausePacketsDeltaAvg',
    '35884' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDelta',
    '35885' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaMin',
    '35886' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaMax',
    '35887' => 'tcaAdaptorEthPortStatsPerPriorityPausePacketsDeltaAvg',
    '35894' => 'tcaAdaptorEthPortStatsPppPacketsDelta',
    '35895' => 'tcaAdaptorEthPortStatsPppPacketsDeltaMin',
    '35896' => 'tcaAdaptorEthPortStatsPppPacketsDeltaMax',
    '35897' => 'tcaAdaptorEthPortStatsPppPacketsDeltaAvg',
    '35907' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64Delta',
    '35908' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaMin',
    '35909' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaMax',
    '35910' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan64DeltaAvg',
    '35917' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64Delta',
    '35918' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaMin',
    '35919' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaMax',
    '35920' => 'tcaAdaptorEthPortBySizeSmallStatsEquals64DeltaAvg',
    '35927' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128Delta',
    '35928' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaMin',
    '35929' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaMax',
    '35930' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan128DeltaAvg',
    '35937' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256Delta',
    '35938' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaMin',
    '35939' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaMax',
    '35940' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan256DeltaAvg',
    '35947' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512Delta',
    '35948' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaMin',
    '35949' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaMax',
    '35950' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan512DeltaAvg',
    '35957' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024Delta',
    '35958' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaMin',
    '35959' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaMax',
    '35960' => 'tcaAdaptorEthPortBySizeSmallStatsLessThan1024DeltaAvg',
    '35970' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518Delta',
    '35971' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaMin',
    '35972' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaMax',
    '35973' => 'tcaAdaptorEthPortBySizeLargeStatsLessThanOrEqualTo1518DeltaAvg',
    '35980' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048Delta',
    '35981' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaMin',
    '35982' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaMax',
    '35983' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan2048DeltaAvg',
    '35990' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096Delta',
    '35991' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaMin',
    '35992' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaMax',
    '35993' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan4096DeltaAvg',
    '36000' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192Delta',
    '36001' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaMin',
    '36002' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaMax',
    '36003' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan8192DeltaAvg',
    '36010' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216Delta',
    '36011' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaMin',
    '36012' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaMax',
    '36013' => 'tcaAdaptorEthPortBySizeLargeStatsLessThan9216DeltaAvg',
    '36020' => 'tcaAdaptorEthPortBySizeLargeStatsGreaterThanOrEqualTo9216Delta',
    '36021' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaMin',
    '36022' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaMax',
    '36023' => 'tcaAdaptorEthPrtBySizeLargeStatsGreaterThanOrEqualTo9216DeltaAvg',
    '36030' => 'tcaAdaptorEthPortBySizeLargeStatsNoBreakdownGreaterThan1518Delta',
    '36031' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaMin',
    '36032' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaMax',
    '36033' => 'tcaAdaptorEthPortBySizeLargeStatsNoBrkdnGreaterThan1518DeltaAvg',
    '36043' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDelta',
    '36044' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaMin',
    '36045' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaMax',
    '36046' => 'tcaAdaptorEthPortOutsizedStatsOversizedPacketsDeltaAvg',
    '36053' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDelta',
    '36054' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaMin',
    '36055' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaMax',
    '36056' => 'tcaAdaptorEthPortOutsizedStatsOversizedGoodCrcPacketsDeltaAvg',
    '36063' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDelta',
    '36064' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaMin',
    '36065' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaMax',
    '36066' => 'tcaAdaptorEthPortOutsizedStatsOversizedBadCrcPacketsDeltaAvg',
    '36073' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDelta',
    '36074' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaMin',
    '36075' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaMax',
    '36076' => 'tcaAdaptorEthPortOutsizedStatsUndersizedGoodCrcPacketsDeltaAvg',
    '36083' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDelta',
    '36084' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaMin',
    '36085' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaMax',
    '36086' => 'tcaAdaptorEthPortOutsizedStatsUndersizedBadCrcPacketsDeltaAvg',
    '36096' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDelta',
    '36097' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaMin',
    '36098' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaMax',
    '36099' => 'tcaAdaptorEthPortMcastStatsUnicastPacketsDeltaAvg',
    '36106' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDelta',
    '36107' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaMin',
    '36108' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaMax',
    '36109' => 'tcaAdaptorEthPortMcastStatsMulticastPacketsDeltaAvg',
    '36116' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDelta',
    '36117' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaMin',
    '36118' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaMax',
    '36119' => 'tcaAdaptorEthPortMcastStatsBroadcastPacketsDeltaAvg',
    '36129' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDelta',
    '36130' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaMin',
    '36131' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaMax',
    '36132' => 'tcaAdaptorEthPortErrStatsMacDiscardedPacketsDeltaAvg',
    '36139' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDelta',
    '36140' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaMin',
    '36141' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaMax',
    '36142' => 'tcaAdaptorEthPortErrStatsBadCrcPacketsDeltaAvg',
    '36149' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDelta',
    '36150' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaMin',
    '36151' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaMax',
    '36152' => 'tcaAdaptorEthPortErrStatsBadLengthPacketsDeltaAvg',
    '36161' => 'tcaAdaptorFcPortStatsRxFramesDelta',
    '36162' => 'tcaAdaptorFcPortStatsRxFramesDeltaMin',
    '36163' => 'tcaAdaptorFcPortStatsRxFramesDeltaMax',
    '36164' => 'tcaAdaptorFcPortStatsRxFramesDeltaAvg',
    '36171' => 'tcaAdaptorFcPortStatsTxFramesDelta',
    '36172' => 'tcaAdaptorFcPortStatsTxFramesDeltaMin',
    '36173' => 'tcaAdaptorFcPortStatsTxFramesDeltaMax',
    '36174' => 'tcaAdaptorFcPortStatsTxFramesDeltaAvg',
    '36181' => 'tcaAdaptorFcPortStatsRxBadFramesDelta',
    '36182' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaMin',
    '36183' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaMax',
    '36184' => 'tcaAdaptorFcPortStatsRxBadFramesDeltaAvg',
    '36191' => 'tcaAdaptorFcPortStatsTxBadFramesDelta',
    '36192' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaMin',
    '36193' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaMax',
    '36194' => 'tcaAdaptorFcPortStatsTxBadFramesDeltaAvg',
    '36203' => 'tcaAdaptorVnicStatsPacketsTxDelta',
    '36204' => 'tcaAdaptorVnicStatsPacketsTxDeltaMin',
    '36205' => 'tcaAdaptorVnicStatsPacketsTxDeltaMax',
    '36206' => 'tcaAdaptorVnicStatsPacketsTxDeltaAvg',
    '36213' => 'tcaAdaptorVnicStatsPacketsRxDelta',
    '36214' => 'tcaAdaptorVnicStatsPacketsRxDeltaMin',
    '36215' => 'tcaAdaptorVnicStatsPacketsRxDeltaMax',
    '36216' => 'tcaAdaptorVnicStatsPacketsRxDeltaAvg',
    '36223' => 'tcaAdaptorVnicStatsBytesTxDelta',
    '36224' => 'tcaAdaptorVnicStatsBytesTxDeltaMin',
    '36225' => 'tcaAdaptorVnicStatsBytesTxDeltaMax',
    '36226' => 'tcaAdaptorVnicStatsBytesTxDeltaAvg',
    '36233' => 'tcaAdaptorVnicStatsBytesRxDelta',
    '36234' => 'tcaAdaptorVnicStatsBytesRxDeltaMin',
    '36235' => 'tcaAdaptorVnicStatsBytesRxDeltaMax',
    '36236' => 'tcaAdaptorVnicStatsBytesRxDeltaAvg',
    '36243' => 'tcaAdaptorVnicStatsErrorsTxDelta',
    '36244' => 'tcaAdaptorVnicStatsErrorsTxDeltaMin',
    '36245' => 'tcaAdaptorVnicStatsErrorsTxDeltaMax',
    '36246' => 'tcaAdaptorVnicStatsErrorsTxDeltaAvg',
    '36253' => 'tcaAdaptorVnicStatsErrorsRxDelta',
    '36254' => 'tcaAdaptorVnicStatsErrorsRxDeltaMin',
    '36255' => 'tcaAdaptorVnicStatsErrorsRxDeltaMax',
    '36256' => 'tcaAdaptorVnicStatsErrorsRxDeltaAvg',
    '36263' => 'tcaAdaptorVnicStatsDroppedTxDelta',
    '36264' => 'tcaAdaptorVnicStatsDroppedTxDeltaMin',
    '36265' => 'tcaAdaptorVnicStatsDroppedTxDeltaMax',
    '36266' => 'tcaAdaptorVnicStatsDroppedTxDeltaAvg',
    '36273' => 'tcaAdaptorVnicStatsDroppedRxDelta',
    '36274' => 'tcaAdaptorVnicStatsDroppedRxDeltaMin',
    '36275' => 'tcaAdaptorVnicStatsDroppedRxDeltaMax',
    '36276' => 'tcaAdaptorVnicStatsDroppedRxDeltaAvg',
    '36285' => 'tcaAdaptorFcIffc4StatsInputRequestsDelta',
    '36286' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaMin',
    '36287' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaMax',
    '36288' => 'tcaAdaptorFcIffc4StatsInputRequestsDeltaAvg',
    '36295' => 'tcaAdaptorFcIffc4StatsOutputRequestsDelta',
    '36296' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaMin',
    '36297' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaMax',
    '36298' => 'tcaAdaptorFcIffc4StatsOutputRequestsDeltaAvg',
    '36305' => 'tcaAdaptorFcIffc4StatsControlRequestsDelta',
    '36306' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaMin',
    '36307' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaMax',
    '36308' => 'tcaAdaptorFcIffc4StatsControlRequestsDeltaAvg',
    '36315' => 'tcaAdaptorFcIffc4StatsInputMegabytesDelta',
    '36316' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaMin',
    '36317' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaMax',
    '36318' => 'tcaAdaptorFcIffc4StatsInputMegabytesDeltaAvg',
    '36325' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDelta',
    '36326' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaMin',
    '36327' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaMax',
    '36328' => 'tcaAdaptorFcIffc4StatsOutputMegabytesDeltaAvg',
    '36337' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDelta',
    '36338' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaMin',
    '36339' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaMax',
    '36340' => 'tcaAdaptorMenloBaseErrorStatsCorrectableErrorsDeltaAvg',
    '36347' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDelta',
    '36348' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaMin',
    '36349' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaMax',
    '36350' => 'tcaAdaptorMenloBaseErrorStatsUncorrectableErrorsDeltaAvg',
    '36360' => 'tcaAdaptorMenloMcpuStatsDropAclDelta',
    '36361' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaMin',
    '36362' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaMax',
    '36363' => 'tcaAdaptorMenloMcpuStatsDropAclDeltaAvg',
    '36370' => 'tcaAdaptorMenloMcpuStatsDropOverrunDelta',
    '36371' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaMin',
    '36372' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaMax',
    '36373' => 'tcaAdaptorMenloMcpuStatsDropOverrunDeltaAvg',
    '36380' => 'tcaAdaptorMenloMcpuStatsDropRuntDelta',
    '36381' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaMin',
    '36382' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaMax',
    '36383' => 'tcaAdaptorMenloMcpuStatsDropRuntDeltaAvg',
    '36390' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDelta',
    '36391' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaMin',
    '36392' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaMax',
    '36393' => 'tcaAdaptorMenloMcpuStatsTruncateOverrunDeltaAvg',
    '36403' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDelta',
    '36404' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaMin',
    '36405' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaMax',
    '36406' => 'tcaAdaptorMenloMcpuErrorStatsCorrectableErrorsDeltaAvg',
    '36413' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDelta',
    '36414' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaMin',
    '36415' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaMax',
    '36416' => 'tcaAdaptorMenloMcpuErrorStatsPopErrorsDeltaAvg',
    '36423' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDelta',
    '36424' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaMin',
    '36425' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaMax',
    '36426' => 'tcaAdaptorMenloMcpuErrorStatsPushErrorsDeltaAvg',
    '36433' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDelta',
    '36434' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaMin',
    '36435' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaMax',
    '36436' => 'tcaAdaptorMenloMcpuErrorStatsUncorrectableErrorsDeltaAvg',
    '36446' => 'tcaAdaptorMenloEthStatsDropOverrunDelta',
    '36447' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaMin',
    '36448' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaMax',
    '36449' => 'tcaAdaptorMenloEthStatsDropOverrunDeltaAvg',
    '36456' => 'tcaAdaptorMenloEthStatsDropRuntDelta',
    '36457' => 'tcaAdaptorMenloEthStatsDropRuntDeltaMin',
    '36458' => 'tcaAdaptorMenloEthStatsDropRuntDeltaMax',
    '36459' => 'tcaAdaptorMenloEthStatsDropRuntDeltaAvg',
    '36466' => 'tcaAdaptorMenloEthStatsTruncateOverrunDelta',
    '36467' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaMin',
    '36468' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaMax',
    '36469' => 'tcaAdaptorMenloEthStatsTruncateOverrunDeltaAvg',
    '36479' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDelta',
    '36480' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaMin',
    '36481' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaMax',
    '36482' => 'tcaAdaptorMenloEthErrorStatsCorrectableErrorsDeltaAvg',
    '36489' => 'tcaAdaptorMenloEthErrorStatsDropAclDelta',
    '36490' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaMin',
    '36491' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaMax',
    '36492' => 'tcaAdaptorMenloEthErrorStatsDropAclDeltaAvg',
    '36499' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDelta',
    '36500' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaMin',
    '36501' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaMax',
    '36502' => 'tcaAdaptorMenloEthErrorStatsPopErrorsDeltaAvg',
    '36509' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDelta',
    '36510' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaMin',
    '36511' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaMax',
    '36512' => 'tcaAdaptorMenloEthErrorStatsPushErrorsDeltaAvg',
    '36519' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDelta',
    '36520' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaMin',
    '36521' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaMax',
    '36522' => 'tcaAdaptorMenloEthErrorStatsUncorrectableErrorsDeltaAvg',
    '36532' => 'tcaAdaptorMenloFcStatsDropAclDelta',
    '36533' => 'tcaAdaptorMenloFcStatsDropAclDeltaMin',
    '36534' => 'tcaAdaptorMenloFcStatsDropAclDeltaMax',
    '36535' => 'tcaAdaptorMenloFcStatsDropAclDeltaAvg',
    '36542' => 'tcaAdaptorMenloFcStatsDropOverrunDelta',
    '36543' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaMin',
    '36544' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaMax',
    '36545' => 'tcaAdaptorMenloFcStatsDropOverrunDeltaAvg',
    '36552' => 'tcaAdaptorMenloFcStatsDropRuntDelta',
    '36553' => 'tcaAdaptorMenloFcStatsDropRuntDeltaMin',
    '36554' => 'tcaAdaptorMenloFcStatsDropRuntDeltaMax',
    '36555' => 'tcaAdaptorMenloFcStatsDropRuntDeltaAvg',
    '36562' => 'tcaAdaptorMenloFcStatsTruncateOverrunDelta',
    '36563' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaMin',
    '36564' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaMax',
    '36565' => 'tcaAdaptorMenloFcStatsTruncateOverrunDeltaAvg',
    '36575' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDelta',
    '36576' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaMin',
    '36577' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaMax',
    '36578' => 'tcaAdaptorMenloFcErrorStatsCorrectableErrorsDeltaAvg',
    '36585' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDelta',
    '36586' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaMin',
    '36587' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaMax',
    '36588' => 'tcaAdaptorMenloFcErrorStatsPopErrorsDeltaAvg',
    '36595' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDelta',
    '36596' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaMin',
    '36597' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaMax',
    '36598' => 'tcaAdaptorMenloFcErrorStatsPushErrorsDeltaAvg',
    '36605' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDelta',
    '36606' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaMin',
    '36607' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaMax',
    '36608' => 'tcaAdaptorMenloFcErrorStatsUncorrectableErrorsDeltaAvg',
    '36619' => 'tcaAdaptorMenloqstatsDropOverrunN0Delta',
    '36620' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaMin',
    '36621' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaMax',
    '36622' => 'tcaAdaptorMenloqstatsDropOverrunN0DeltaAvg',
    '36629' => 'tcaAdaptorMenloqstatsDropOverrunN1Delta',
    '36630' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaMin',
    '36631' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaMax',
    '36632' => 'tcaAdaptorMenloqstatsDropOverrunN1DeltaAvg',
    '36639' => 'tcaAdaptorMenloqstatsTruncateOverrunN0Delta',
    '36640' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaMin',
    '36641' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaMax',
    '36642' => 'tcaAdaptorMenloqstatsTruncateOverrunN0DeltaAvg',
    '36649' => 'tcaAdaptorMenloqstatsTruncateOverrunN1Delta',
    '36650' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaMin',
    '36651' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaMax',
    '36652' => 'tcaAdaptorMenloqstatsTruncateOverrunN1DeltaAvg',
    '36663' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDelta',
    '36664' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaMin',
    '36665' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaMax',
    '36666' => 'tcaAdaptorMenloqerrorStatsCorrectableErrorsDeltaAvg',
    '36673' => 'tcaAdaptorMenloqerrorStatsPopErrorsDelta',
    '36674' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaMin',
    '36675' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaMax',
    '36676' => 'tcaAdaptorMenloqerrorStatsPopErrorsDeltaAvg',
    '36683' => 'tcaAdaptorMenloqerrorStatsPushErrorsDelta',
    '36684' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaMin',
    '36685' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaMax',
    '36686' => 'tcaAdaptorMenloqerrorStatsPushErrorsDeltaAvg',
    '36693' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDelta',
    '36694' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaMin',
    '36695' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaMax',
    '36696' => 'tcaAdaptorMenloqerrorStatsUncorrectableErrorsDeltaAvg',
    '36706' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDelta',
    '36707' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaMin',
    '36708' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaMax',
    '36709' => 'tcaAdaptorMenloNetEgStatsLearnReqDropDeltaAvg',
    '36716' => 'tcaAdaptorMenloNetEgStatsDropCmdDelta',
    '36717' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaMin',
    '36718' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaMax',
    '36719' => 'tcaAdaptorMenloNetEgStatsDropCmdDeltaAvg',
    '36726' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDelta',
    '36727' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaMin',
    '36728' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaMax',
    '36729' => 'tcaAdaptorMenloNetEgStatsDropLifCfgInvalidDeltaAvg',
    '36736' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDelta',
    '36737' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaMin',
    '36738' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaMax',
    '36739' => 'tcaAdaptorMenloNetEgStatsDropLifMapNoHitDeltaAvg',
    '36746' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDelta',
    '36747' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaMin',
    '36748' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaMax',
    '36749' => 'tcaAdaptorMenloNetEgStatsDropSrcBindDeltaAvg',
    '36759' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDelta',
    '36760' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaMin',
    '36761' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaMax',
    '36762' => 'tcaAdaptorMenloNetInStatsFwdLookupNoHitDeltaAvg',
    '36769' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDelta',
    '36770' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaMin',
    '36771' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaMax',
    '36772' => 'tcaAdaptorMenloNetInStatsDropFcMulticastDeltaAvg',
    '36779' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDelta',
    '36780' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaMin',
    '36781' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaMax',
    '36782' => 'tcaAdaptorMenloNetInStatsDropFcLifInvalidDeltaAvg',
    '36789' => 'tcaAdaptorMenloNetInStatsDropNullPifDelta',
    '36790' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaMin',
    '36791' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaMax',
    '36792' => 'tcaAdaptorMenloNetInStatsDropNullPifDeltaAvg',
    '36802' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdelta',
    '36803' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaMin',
    '36804' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaMax',
    '36805' => 'tcaAdaptorMenloHostPortStatsRxPausecfcdeltaAvg',
    '36812' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdelta',
    '36813' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaMin',
    '36814' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaMax',
    '36815' => 'tcaAdaptorMenloHostPortStatsRxPausepfcdeltaAvg',
    '36822' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdelta',
    '36823' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaMin',
    '36824' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaMax',
    '36825' => 'tcaAdaptorMenloHostPortStatsTxPausecfcdeltaAvg',
    '36832' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdelta',
    '36833' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaMin',
    '36834' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaMax',
    '36835' => 'tcaAdaptorMenloHostPortStatsTxPausepfcdeltaAvg',
    '36845' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdelta',
    '36846' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaMin',
    '36847' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaMax',
    '36848' => 'tcaAdaptorMenloDcePortStatsRxPausecfcdeltaAvg',
    '36855' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdelta',
    '36856' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaMin',
    '36857' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaMax',
    '36858' => 'tcaAdaptorMenloDcePortStatsRxPausepfcdeltaAvg',
    '36865' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdelta',
    '36866' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaMin',
    '36867' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaMax',
    '36868' => 'tcaAdaptorMenloDcePortStatsTxPausecfcdeltaAvg',
    '36875' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdelta',
    '36876' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaMin',
    '36877' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaMax',
    '36878' => 'tcaAdaptorMenloDcePortStatsTxPausepfcdeltaAvg',
    '36887' => 'tcaAdaptorEtherIfStatsTxBytesDelta',
    '36888' => 'tcaAdaptorEtherIfStatsTxBytesDeltaMin',
    '36889' => 'tcaAdaptorEtherIfStatsTxBytesDeltaMax',
    '36890' => 'tcaAdaptorEtherIfStatsTxBytesDeltaAvg',
    '36897' => 'tcaAdaptorEtherIfStatsTxPacketsDelta',
    '36898' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaMin',
    '36899' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaMax',
    '36900' => 'tcaAdaptorEtherIfStatsTxPacketsDeltaAvg',
    '36907' => 'tcaAdaptorEtherIfStatsTxErrorsDelta',
    '36908' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaMin',
    '36909' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaMax',
    '36910' => 'tcaAdaptorEtherIfStatsTxErrorsDeltaAvg',
    '36917' => 'tcaAdaptorEtherIfStatsTxDroppedDelta',
    '36918' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaMin',
    '36919' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaMax',
    '36920' => 'tcaAdaptorEtherIfStatsTxDroppedDeltaAvg',
    '36927' => 'tcaAdaptorEtherIfStatsRxBytesDelta',
    '36928' => 'tcaAdaptorEtherIfStatsRxBytesDeltaMin',
    '36929' => 'tcaAdaptorEtherIfStatsRxBytesDeltaMax',
    '36930' => 'tcaAdaptorEtherIfStatsRxBytesDeltaAvg',
    '36937' => 'tcaAdaptorEtherIfStatsRxPacketsDelta',
    '36938' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaMin',
    '36939' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaMax',
    '36940' => 'tcaAdaptorEtherIfStatsRxPacketsDeltaAvg',
    '36947' => 'tcaAdaptorEtherIfStatsRxErrorsDelta',
    '36948' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaMin',
    '36949' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaMax',
    '36950' => 'tcaAdaptorEtherIfStatsRxErrorsDeltaAvg',
    '36957' => 'tcaAdaptorEtherIfStatsRxDroppedDelta',
    '36958' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaMin',
    '36959' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaMax',
    '36960' => 'tcaAdaptorEtherIfStatsRxDroppedDeltaAvg',
    '36969' => 'tcaAdaptorFcIfFrameStatsTxFramesDelta',
    '36970' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaMin',
    '36971' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaMax',
    '36972' => 'tcaAdaptorFcIfFrameStatsTxFramesDeltaAvg',
    '36979' => 'tcaAdaptorFcIfFrameStatsRxFramesDelta',
    '36980' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaMin',
    '36981' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaMax',
    '36982' => 'tcaAdaptorFcIfFrameStatsRxFramesDeltaAvg',
    '36989' => 'tcaAdaptorFcIfFrameStatsErrorFramesDelta',
    '36990' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaMin',
    '36991' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaMax',
    '36992' => 'tcaAdaptorFcIfFrameStatsErrorFramesDeltaAvg',
    '36999' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDelta',
    '37000' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaMin',
    '37001' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaMax',
    '37002' => 'tcaAdaptorFcIfFrameStatsDumpedFramesDeltaAvg',
    '37011' => 'tcaAdaptorFcIfEventStatsLipCountDelta',
    '37012' => 'tcaAdaptorFcIfEventStatsLipCountDeltaMin',
    '37013' => 'tcaAdaptorFcIfEventStatsLipCountDeltaMax',
    '37014' => 'tcaAdaptorFcIfEventStatsLipCountDeltaAvg',
    '37021' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDelta',
    '37022' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaMin',
    '37023' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaMax',
    '37024' => 'tcaAdaptorFcIfEventStatsInvalidcrccountDeltaAvg',
    '37031' => 'tcaAdaptorFcIfEventStatsNoscountDelta',
    '37032' => 'tcaAdaptorFcIfEventStatsNoscountDeltaMin',
    '37033' => 'tcaAdaptorFcIfEventStatsNoscountDeltaMax',
    '37034' => 'tcaAdaptorFcIfEventStatsNoscountDeltaAvg',
    '37041' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDelta',
    '37042' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaMin',
    '37043' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaMax',
    '37044' => 'tcaAdaptorFcIfEventStatsLinkFailureCountDeltaAvg',
    '37051' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDelta',
    '37052' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaMin',
    '37053' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaMax',
    '37054' => 'tcaAdaptorFcIfEventStatsLossOfSyncCountDeltaAvg',
    '37061' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDelta',
    '37062' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaMin',
    '37063' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaMax',
    '37064' => 'tcaAdaptorFcIfEventStatsLossOfSignalCountDeltaAvg',
    '37071' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDelta',
    '37072' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaMin',
    '37073' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaMax',
    '37074' => 'tcaAdaptorFcIfEventStatsSeqProtocolErrCountDeltaAvg',
    '37081' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDelta',
    '37082' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaMin',
    '37083' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaMax',
    '37084' => 'tcaAdaptorFcIfEventStatsSecondsSinceLastResetDeltaAvg',
    '37200' => 'tcaMemoryRuntimeTotal',
    '37202' => 'tcaMemoryRuntimeTotalMin',
    '37203' => 'tcaMemoryRuntimeTotalMax',
    '37204' => 'tcaMemoryRuntimeTotalAvg',
    '37208' => 'tcaMemoryRuntimeAvailable',
    '37210' => 'tcaMemoryRuntimeAvailableMin',
    '37211' => 'tcaMemoryRuntimeAvailableMax',
    '37212' => 'tcaMemoryRuntimeAvailableAvg',
    '37216' => 'tcaMemoryRuntimeCached',
    '37218' => 'tcaMemoryRuntimeCachedMin',
    '37219' => 'tcaMemoryRuntimeCachedMax',
    '37220' => 'tcaMemoryRuntimeCachedAvg',
    '37226' => 'tcaMemoryArrayEnvStatsInputCurrent',
    '37228' => 'tcaMemoryArrayEnvStatsInputCurrentMin',
    '37229' => 'tcaMemoryArrayEnvStatsInputCurrentMax',
    '37230' => 'tcaMemoryArrayEnvStatsInputCurrentAvg',
    '37236' => 'tcaMemoryBufferUnitEnvStatsTemperature',
    '37238' => 'tcaMemoryBufferUnitEnvStatsTemperatureMin',
    '37239' => 'tcaMemoryBufferUnitEnvStatsTemperatureMax',
    '37240' => 'tcaMemoryBufferUnitEnvStatsTemperatureAvg',
    '37246' => 'tcaMemoryUnitEnvStatsTemperature',
    '37248' => 'tcaMemoryUnitEnvStatsTemperatureMin',
    '37249' => 'tcaMemoryUnitEnvStatsTemperatureMax',
    '37250' => 'tcaMemoryUnitEnvStatsTemperatureAvg',
    '37255' => 'tcaMemoryErrorStatsEccMultibitErrors',
    '37266' => 'tcaMemoryErrorStatsEccSinglebitErrors',
    '37277' => 'tcaMemoryErrorStatsAddressParityErrors',
    '37288' => 'tcaMemoryErrorStatsMismatchErrors',
    '37879' => 'tcaEquipmentChassisStatsInputPower',
    '37881' => 'tcaEquipmentChassisStatsInputPowerMin',
    '37882' => 'tcaEquipmentChassisStatsInputPowerMax',
    '37883' => 'tcaEquipmentChassisStatsInputPowerAvg',
    '37887' => 'tcaEquipmentChassisStatsOutputPower',
    '37889' => 'tcaEquipmentChassisStatsOutputPowerMin',
    '37890' => 'tcaEquipmentChassisStatsOutputPowerMax',
    '37891' => 'tcaEquipmentChassisStatsOutputPowerAvg',
    '37895' => 'tcaEquipmentChassisStatsInletTemp1',
    '37897' => 'tcaEquipmentChassisStatsInletTemp1Min',
    '37898' => 'tcaEquipmentChassisStatsInletTemp1Max',
    '37899' => 'tcaEquipmentChassisStatsInletTemp1Avg',
    '37903' => 'tcaEquipmentChassisStatsInletTemp2',
    '37905' => 'tcaEquipmentChassisStatsInletTemp2Min',
    '37906' => 'tcaEquipmentChassisStatsInletTemp2Max',
    '37907' => 'tcaEquipmentChassisStatsInletTemp2Avg',
    '37911' => 'tcaEquipmentChassisStatsOutletTemp1',
    '37913' => 'tcaEquipmentChassisStatsOutletTemp1Min',
    '37914' => 'tcaEquipmentChassisStatsOutletTemp1Max',
    '37915' => 'tcaEquipmentChassisStatsOutletTemp1Avg',
    '37919' => 'tcaEquipmentChassisStatsOutletTemp2',
    '37921' => 'tcaEquipmentChassisStatsOutletTemp2Min',
    '37922' => 'tcaEquipmentChassisStatsOutletTemp2Max',
    '37923' => 'tcaEquipmentChassisStatsOutletTemp2Avg',
    '37929' => 'tcaEquipmentIocardStatsAmbientTemp',
    '37931' => 'tcaEquipmentIocardStatsAmbientTempMin',
    '37932' => 'tcaEquipmentIocardStatsAmbientTempMax',
    '37933' => 'tcaEquipmentIocardStatsAmbientTempAvg',
    '37937' => 'tcaEquipmentIocardStatsTemp',
    '37939' => 'tcaEquipmentIocardStatsTempMin',
    '37940' => 'tcaEquipmentIocardStatsTempMax',
    '37941' => 'tcaEquipmentIocardStatsTempAvg',
    '37945' => 'tcaEquipmentIocardStatsProcTemp',
    '37947' => 'tcaEquipmentIocardStatsProcTempMin',
    '37948' => 'tcaEquipmentIocardStatsProcTempMax',
    '37949' => 'tcaEquipmentIocardStatsProcTempAvg',
    '37953' => 'tcaEquipmentIocardStatsDimmTemp',
    '37955' => 'tcaEquipmentIocardStatsDimmTempMin',
    '37956' => 'tcaEquipmentIocardStatsDimmTempMax',
    '37957' => 'tcaEquipmentIocardStatsDimmTempAvg',
    '37963' => 'tcaEquipmentPsuStatsAmbientTemp',
    '37965' => 'tcaEquipmentPsuStatsAmbientTempMin',
    '37966' => 'tcaEquipmentPsuStatsAmbientTempMax',
    '37967' => 'tcaEquipmentPsuStatsAmbientTempAvg',
    '37971' => 'tcaEquipmentPsuStatsOutputCurrent',
    '37973' => 'tcaEquipmentPsuStatsOutputCurrentMin',
    '37974' => 'tcaEquipmentPsuStatsOutputCurrentMax',
    '37975' => 'tcaEquipmentPsuStatsOutputCurrentAvg',
    '37979' => 'tcaEquipmentPsuStatsOutputPower',
    '37981' => 'tcaEquipmentPsuStatsOutputPowerMin',
    '37982' => 'tcaEquipmentPsuStatsOutputPowerMax',
    '37983' => 'tcaEquipmentPsuStatsOutputPowerAvg',
    '37987' => 'tcaEquipmentPsuStatsOutput12v',
    '37989' => 'tcaEquipmentPsuStatsOutput12vMin',
    '37990' => 'tcaEquipmentPsuStatsOutput12vMax',
    '37991' => 'tcaEquipmentPsuStatsOutput12vAvg',
    '37995' => 'tcaEquipmentPsuStatsOutput3v3',
    '37997' => 'tcaEquipmentPsuStatsOutput3v3Min',
    '37998' => 'tcaEquipmentPsuStatsOutput3v3Max',
    '37999' => 'tcaEquipmentPsuStatsOutput3v3Avg',
    '38003' => 'tcaEquipmentPsuStatsInput210v',
    '38005' => 'tcaEquipmentPsuStatsInput210vMin',
    '38006' => 'tcaEquipmentPsuStatsInput210vMax',
    '38007' => 'tcaEquipmentPsuStatsInput210vAvg',
    '38014' => 'tcaEquipmentPsuStatsInputPower',
    '38016' => 'tcaEquipmentPsuStatsInputPowerMin',
    '38017' => 'tcaEquipmentPsuStatsInputPowerMax',
    '38018' => 'tcaEquipmentPsuStatsInputPowerAvg',
    '38022' => 'tcaEquipmentPsuStatsInputCurrent',
    '38024' => 'tcaEquipmentPsuStatsInputCurrentMin',
    '38025' => 'tcaEquipmentPsuStatsInputCurrentMax',
    '38026' => 'tcaEquipmentPsuStatsInputCurrentAvg',
    '38030' => 'tcaEquipmentPsuStatsFanSpeed',
    '38032' => 'tcaEquipmentPsuStatsFanSpeedMin',
    '38033' => 'tcaEquipmentPsuStatsFanSpeedMax',
    '38034' => 'tcaEquipmentPsuStatsFanSpeedAvg',
    '38040' => 'tcaEquipmentPsuInputStatsCurrent',
    '38042' => 'tcaEquipmentPsuInputStatsCurrentMin',
    '38043' => 'tcaEquipmentPsuInputStatsCurrentMax',
    '38044' => 'tcaEquipmentPsuInputStatsCurrentAvg',
    '38048' => 'tcaEquipmentPsuInputStatsVoltage',
    '38050' => 'tcaEquipmentPsuInputStatsVoltageMin',
    '38051' => 'tcaEquipmentPsuInputStatsVoltageMax',
    '38052' => 'tcaEquipmentPsuInputStatsVoltageAvg',
    '38056' => 'tcaEquipmentPsuInputStatsPower',
    '38058' => 'tcaEquipmentPsuInputStatsPowerMin',
    '38059' => 'tcaEquipmentPsuInputStatsPowerMax',
    '38060' => 'tcaEquipmentPsuInputStatsPowerAvg',
    '38067' => 'tcaEquipmentPsuOutputStatsCurrent',
    '38069' => 'tcaEquipmentPsuOutputStatsCurrentMin',
    '38070' => 'tcaEquipmentPsuOutputStatsCurrentMax',
    '38071' => 'tcaEquipmentPsuOutputStatsCurrentAvg',
    '38075' => 'tcaEquipmentPsuOutputStatsVoltage',
    '38077' => 'tcaEquipmentPsuOutputStatsVoltageMin',
    '38078' => 'tcaEquipmentPsuOutputStatsVoltageMax',
    '38079' => 'tcaEquipmentPsuOutputStatsVoltageAvg',
    '38083' => 'tcaEquipmentPsuOutputStatsPower',
    '38085' => 'tcaEquipmentPsuOutputStatsPowerMin',
    '38086' => 'tcaEquipmentPsuOutputStatsPowerMax',
    '38087' => 'tcaEquipmentPsuOutputStatsPowerAvg',
    '38094' => 'tcaEquipmentFanModuleStatsAmbientTemp',
    '38096' => 'tcaEquipmentFanModuleStatsAmbientTempMin',
    '38097' => 'tcaEquipmentFanModuleStatsAmbientTempMax',
    '38098' => 'tcaEquipmentFanModuleStatsAmbientTempAvg',
    '38104' => 'tcaEquipmentFanStatsSpeed',
    '38106' => 'tcaEquipmentFanStatsSpeedMin',
    '38107' => 'tcaEquipmentFanStatsSpeedMax',
    '38108' => 'tcaEquipmentFanStatsSpeedAvg',
    '38114' => 'tcaEquipmentFexEnvStatsOutlet1',
    '38116' => 'tcaEquipmentFexEnvStatsOutlet1Min',
    '38117' => 'tcaEquipmentFexEnvStatsOutlet1Max',
    '38118' => 'tcaEquipmentFexEnvStatsOutlet1Avg',
    '38122' => 'tcaEquipmentFexEnvStatsOutlet2',
    '38124' => 'tcaEquipmentFexEnvStatsOutlet2Min',
    '38125' => 'tcaEquipmentFexEnvStatsOutlet2Max',
    '38126' => 'tcaEquipmentFexEnvStatsOutlet2Avg',
    '38130' => 'tcaEquipmentFexEnvStatsInlet',
    '38132' => 'tcaEquipmentFexEnvStatsInletMin',
    '38133' => 'tcaEquipmentFexEnvStatsInletMax',
    '38134' => 'tcaEquipmentFexEnvStatsInletAvg',
    '38138' => 'tcaEquipmentFexEnvStatsInlet1',
    '38140' => 'tcaEquipmentFexEnvStatsInlet1Min',
    '38141' => 'tcaEquipmentFexEnvStatsInlet1Max',
    '38142' => 'tcaEquipmentFexEnvStatsInlet1Avg',
    '38146' => 'tcaEquipmentFexEnvStatsDie1',
    '38148' => 'tcaEquipmentFexEnvStatsDie1Min',
    '38149' => 'tcaEquipmentFexEnvStatsDie1Max',
    '38150' => 'tcaEquipmentFexEnvStatsDie1Avg',
    '38157' => 'tcaEquipmentFexPowerSummaryTotalPower',
    '38159' => 'tcaEquipmentFexPowerSummaryTotalPowerMin',
    '38160' => 'tcaEquipmentFexPowerSummaryTotalPowerMax',
    '38161' => 'tcaEquipmentFexPowerSummaryTotalPowerAvg',
    '38165' => 'tcaEquipmentFexPowerSummaryReservedPower',
    '38167' => 'tcaEquipmentFexPowerSummaryReservedPowerMin',
    '38168' => 'tcaEquipmentFexPowerSummaryReservedPowerMax',
    '38169' => 'tcaEquipmentFexPowerSummaryReservedPowerAvg',
    '38173' => 'tcaEquipmentFexPowerSummaryModulePower',
    '38175' => 'tcaEquipmentFexPowerSummaryModulePowerMin',
    '38176' => 'tcaEquipmentFexPowerSummaryModulePowerMax',
    '38177' => 'tcaEquipmentFexPowerSummaryModulePowerAvg',
    '38181' => 'tcaEquipmentFexPowerSummaryAvailablePower',
    '38183' => 'tcaEquipmentFexPowerSummaryAvailablePowerMin',
    '38184' => 'tcaEquipmentFexPowerSummaryAvailablePowerMax',
    '38185' => 'tcaEquipmentFexPowerSummaryAvailablePowerAvg',
    '38191' => 'tcaEquipmentFexPsuInputStatsCurrent',
    '38193' => 'tcaEquipmentFexPsuInputStatsCurrentMin',
    '38194' => 'tcaEquipmentFexPsuInputStatsCurrentMax',
    '38195' => 'tcaEquipmentFexPsuInputStatsCurrentAvg',
    '38199' => 'tcaEquipmentFexPsuInputStatsVoltage',
    '38201' => 'tcaEquipmentFexPsuInputStatsVoltageMin',
    '38202' => 'tcaEquipmentFexPsuInputStatsVoltageMax',
    '38203' => 'tcaEquipmentFexPsuInputStatsVoltageAvg',
    '38207' => 'tcaEquipmentFexPsuInputStatsPower',
    '38209' => 'tcaEquipmentFexPsuInputStatsPowerMin',
    '38210' => 'tcaEquipmentFexPsuInputStatsPowerMax',
    '38211' => 'tcaEquipmentFexPsuInputStatsPowerAvg',
    '38218' => 'tcaEquipmentRackUnitPsuStatsAmbientTemp',
    '38220' => 'tcaEquipmentRackUnitPsuStatsAmbientTempMin',
    '38221' => 'tcaEquipmentRackUnitPsuStatsAmbientTempMax',
    '38222' => 'tcaEquipmentRackUnitPsuStatsAmbientTempAvg',
    '38226' => 'tcaEquipmentRackUnitPsuStatsOutputCurrent',
    '38228' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentMin',
    '38229' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentMax',
    '38230' => 'tcaEquipmentRackUnitPsuStatsOutputCurrentAvg',
    '38234' => 'tcaEquipmentRackUnitPsuStatsOutputPower',
    '38236' => 'tcaEquipmentRackUnitPsuStatsOutputPowerMin',
    '38237' => 'tcaEquipmentRackUnitPsuStatsOutputPowerMax',
    '38238' => 'tcaEquipmentRackUnitPsuStatsOutputPowerAvg',
    '38242' => 'tcaEquipmentRackUnitPsuStatsInputPower',
    '38244' => 'tcaEquipmentRackUnitPsuStatsInputPowerMin',
    '38245' => 'tcaEquipmentRackUnitPsuStatsInputPowerMax',
    '38246' => 'tcaEquipmentRackUnitPsuStatsInputPowerAvg',
    '38250' => 'tcaEquipmentRackUnitPsuStatsOutputVoltage',
    '38252' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageMin',
    '38253' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageMax',
    '38254' => 'tcaEquipmentRackUnitPsuStatsOutputVoltageAvg',
    '38258' => 'tcaEquipmentRackUnitPsuStatsInputVoltage',
    '38260' => 'tcaEquipmentRackUnitPsuStatsInputVoltageMin',
    '38261' => 'tcaEquipmentRackUnitPsuStatsInputVoltageMax',
    '38262' => 'tcaEquipmentRackUnitPsuStatsInputVoltageAvg',
    '38268' => 'tcaEquipmentNetworkElementFanStatsSpeed',
    '38270' => 'tcaEquipmentNetworkElementFanStatsSpeedMin',
    '38271' => 'tcaEquipmentNetworkElementFanStatsSpeedMax',
    '38272' => 'tcaEquipmentNetworkElementFanStatsSpeedAvg',
    '38276' => 'tcaEquipmentNetworkElementFanStatsDrivePercentage',
    '38278' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageMin',
    '38279' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageMax',
    '38280' => 'tcaEquipmentNetworkElementFanStatsDrivePercentageAvg',
    '38287' => 'tcaEquipmentRackUnitFanStatsSpeed',
    '38289' => 'tcaEquipmentRackUnitFanStatsSpeedMin',
    '38290' => 'tcaEquipmentRackUnitFanStatsSpeedMax',
    '38291' => 'tcaEquipmentRackUnitFanStatsSpeedAvg',
    '38506' => 'tcaEtherTxStatsTotalBytesDelta',
    '38507' => 'tcaEtherTxStatsTotalBytesDeltaMin',
    '38508' => 'tcaEtherTxStatsTotalBytesDeltaMax',
    '38509' => 'tcaEtherTxStatsTotalBytesDeltaAvg',
    '38516' => 'tcaEtherTxStatsTotalPacketsDelta',
    '38517' => 'tcaEtherTxStatsTotalPacketsDeltaMin',
    '38518' => 'tcaEtherTxStatsTotalPacketsDeltaMax',
    '38519' => 'tcaEtherTxStatsTotalPacketsDeltaAvg',
    '38526' => 'tcaEtherTxStatsUnicastPacketsDelta',
    '38527' => 'tcaEtherTxStatsUnicastPacketsDeltaMin',
    '38528' => 'tcaEtherTxStatsUnicastPacketsDeltaMax',
    '38529' => 'tcaEtherTxStatsUnicastPacketsDeltaAvg',
    '38536' => 'tcaEtherTxStatsMulticastPacketsDelta',
    '38537' => 'tcaEtherTxStatsMulticastPacketsDeltaMin',
    '38538' => 'tcaEtherTxStatsMulticastPacketsDeltaMax',
    '38539' => 'tcaEtherTxStatsMulticastPacketsDeltaAvg',
    '38546' => 'tcaEtherTxStatsBroadcastPacketsDelta',
    '38547' => 'tcaEtherTxStatsBroadcastPacketsDeltaMin',
    '38548' => 'tcaEtherTxStatsBroadcastPacketsDeltaMax',
    '38549' => 'tcaEtherTxStatsBroadcastPacketsDeltaAvg',
    '38556' => 'tcaEtherTxStatsJumboPacketsDelta',
    '38557' => 'tcaEtherTxStatsJumboPacketsDeltaMin',
    '38558' => 'tcaEtherTxStatsJumboPacketsDeltaMax',
    '38559' => 'tcaEtherTxStatsJumboPacketsDeltaAvg',
    '38568' => 'tcaEtherRxStatsTotalBytesDelta',
    '38569' => 'tcaEtherRxStatsTotalBytesDeltaMin',
    '38570' => 'tcaEtherRxStatsTotalBytesDeltaMax',
    '38571' => 'tcaEtherRxStatsTotalBytesDeltaAvg',
    '38578' => 'tcaEtherRxStatsTotalPacketsDelta',
    '38579' => 'tcaEtherRxStatsTotalPacketsDeltaMin',
    '38580' => 'tcaEtherRxStatsTotalPacketsDeltaMax',
    '38581' => 'tcaEtherRxStatsTotalPacketsDeltaAvg',
    '38588' => 'tcaEtherRxStatsUnicastPacketsDelta',
    '38589' => 'tcaEtherRxStatsUnicastPacketsDeltaMin',
    '38590' => 'tcaEtherRxStatsUnicastPacketsDeltaMax',
    '38591' => 'tcaEtherRxStatsUnicastPacketsDeltaAvg',
    '38598' => 'tcaEtherRxStatsMulticastPacketsDelta',
    '38599' => 'tcaEtherRxStatsMulticastPacketsDeltaMin',
    '38600' => 'tcaEtherRxStatsMulticastPacketsDeltaMax',
    '38601' => 'tcaEtherRxStatsMulticastPacketsDeltaAvg',
    '38608' => 'tcaEtherRxStatsBroadcastPacketsDelta',
    '38609' => 'tcaEtherRxStatsBroadcastPacketsDeltaMin',
    '38610' => 'tcaEtherRxStatsBroadcastPacketsDeltaMax',
    '38611' => 'tcaEtherRxStatsBroadcastPacketsDeltaAvg',
    '38618' => 'tcaEtherRxStatsJumboPacketsDelta',
    '38619' => 'tcaEtherRxStatsJumboPacketsDeltaMin',
    '38620' => 'tcaEtherRxStatsJumboPacketsDeltaMax',
    '38621' => 'tcaEtherRxStatsJumboPacketsDeltaAvg',
    '38630' => 'tcaEtherErrStatsAlignDelta',
    '38631' => 'tcaEtherErrStatsAlignDeltaMin',
    '38632' => 'tcaEtherErrStatsAlignDeltaMax',
    '38633' => 'tcaEtherErrStatsAlignDeltaAvg',
    '38640' => 'tcaEtherErrStatsFcsDelta',
    '38641' => 'tcaEtherErrStatsFcsDeltaMin',
    '38642' => 'tcaEtherErrStatsFcsDeltaMax',
    '38643' => 'tcaEtherErrStatsFcsDeltaAvg',
    '38650' => 'tcaEtherErrStatsXmitDelta',
    '38651' => 'tcaEtherErrStatsXmitDeltaMin',
    '38652' => 'tcaEtherErrStatsXmitDeltaMax',
    '38653' => 'tcaEtherErrStatsXmitDeltaAvg',
    '38660' => 'tcaEtherErrStatsRcvDelta',
    '38661' => 'tcaEtherErrStatsRcvDeltaMin',
    '38662' => 'tcaEtherErrStatsRcvDeltaMax',
    '38663' => 'tcaEtherErrStatsRcvDeltaAvg',
    '38670' => 'tcaEtherErrStatsUnderSizeDelta',
    '38671' => 'tcaEtherErrStatsUnderSizeDeltaMin',
    '38672' => 'tcaEtherErrStatsUnderSizeDeltaMax',
    '38673' => 'tcaEtherErrStatsUnderSizeDeltaAvg',
    '38680' => 'tcaEtherErrStatsOutDiscardDelta',
    '38681' => 'tcaEtherErrStatsOutDiscardDeltaMin',
    '38682' => 'tcaEtherErrStatsOutDiscardDeltaMax',
    '38683' => 'tcaEtherErrStatsOutDiscardDeltaAvg',
    '38690' => 'tcaEtherErrStatsDeferredTxDelta',
    '38691' => 'tcaEtherErrStatsDeferredTxDeltaMin',
    '38692' => 'tcaEtherErrStatsDeferredTxDeltaMax',
    '38693' => 'tcaEtherErrStatsDeferredTxDeltaAvg',
    '38700' => 'tcaEtherErrStatsIntMacTxDelta',
    '38701' => 'tcaEtherErrStatsIntMacTxDeltaMin',
    '38702' => 'tcaEtherErrStatsIntMacTxDeltaMax',
    '38703' => 'tcaEtherErrStatsIntMacTxDeltaAvg',
    '38710' => 'tcaEtherErrStatsIntMacRxDelta',
    '38711' => 'tcaEtherErrStatsIntMacRxDeltaMin',
    '38712' => 'tcaEtherErrStatsIntMacRxDeltaMax',
    '38713' => 'tcaEtherErrStatsIntMacRxDeltaAvg',
    '38722' => 'tcaEtherNiErrStatsFrameTxDelta',
    '38723' => 'tcaEtherNiErrStatsFrameTxDeltaMin',
    '38724' => 'tcaEtherNiErrStatsFrameTxDeltaMax',
    '38725' => 'tcaEtherNiErrStatsFrameTxDeltaAvg',
    '38732' => 'tcaEtherNiErrStatsTooLongDelta',
    '38733' => 'tcaEtherNiErrStatsTooLongDeltaMin',
    '38734' => 'tcaEtherNiErrStatsTooLongDeltaMax',
    '38735' => 'tcaEtherNiErrStatsTooLongDeltaAvg',
    '38742' => 'tcaEtherNiErrStatsTooShortDelta',
    '38743' => 'tcaEtherNiErrStatsTooShortDeltaMin',
    '38744' => 'tcaEtherNiErrStatsTooShortDeltaMax',
    '38745' => 'tcaEtherNiErrStatsTooShortDeltaAvg',
    '38752' => 'tcaEtherNiErrStatsCrcDelta',
    '38753' => 'tcaEtherNiErrStatsCrcDeltaMin',
    '38754' => 'tcaEtherNiErrStatsCrcDeltaMax',
    '38755' => 'tcaEtherNiErrStatsCrcDeltaAvg',
    '38762' => 'tcaEtherNiErrStatsInRangeDelta',
    '38763' => 'tcaEtherNiErrStatsInRangeDeltaMin',
    '38764' => 'tcaEtherNiErrStatsInRangeDeltaMax',
    '38765' => 'tcaEtherNiErrStatsInRangeDeltaAvg',
    '38774' => 'tcaEtherLossStatsSingleCollisionDelta',
    '38775' => 'tcaEtherLossStatsSingleCollisionDeltaMin',
    '38776' => 'tcaEtherLossStatsSingleCollisionDeltaMax',
    '38777' => 'tcaEtherLossStatsSingleCollisionDeltaAvg',
    '38784' => 'tcaEtherLossStatsMultiCollisionDelta',
    '38785' => 'tcaEtherLossStatsMultiCollisionDeltaMin',
    '38786' => 'tcaEtherLossStatsMultiCollisionDeltaMax',
    '38787' => 'tcaEtherLossStatsMultiCollisionDeltaAvg',
    '38794' => 'tcaEtherLossStatsLateCollisionDelta',
    '38795' => 'tcaEtherLossStatsLateCollisionDeltaMin',
    '38796' => 'tcaEtherLossStatsLateCollisionDeltaMax',
    '38797' => 'tcaEtherLossStatsLateCollisionDeltaAvg',
    '38804' => 'tcaEtherLossStatsExcessCollisionDelta',
    '38805' => 'tcaEtherLossStatsExcessCollisionDeltaMin',
    '38806' => 'tcaEtherLossStatsExcessCollisionDeltaMax',
    '38807' => 'tcaEtherLossStatsExcessCollisionDeltaAvg',
    '38814' => 'tcaEtherLossStatsCarrierSenseDelta',
    '38815' => 'tcaEtherLossStatsCarrierSenseDeltaMin',
    '38816' => 'tcaEtherLossStatsCarrierSenseDeltaMax',
    '38817' => 'tcaEtherLossStatsCarrierSenseDeltaAvg',
    '38824' => 'tcaEtherLossStatsGiantsDelta',
    '38825' => 'tcaEtherLossStatsGiantsDeltaMin',
    '38826' => 'tcaEtherLossStatsGiantsDeltaMax',
    '38827' => 'tcaEtherLossStatsGiantsDeltaAvg',
    '38834' => 'tcaEtherLossStatsSymbolDelta',
    '38835' => 'tcaEtherLossStatsSymbolDeltaMin',
    '38836' => 'tcaEtherLossStatsSymbolDeltaMax',
    '38837' => 'tcaEtherLossStatsSymbolDeltaAvg',
    '38844' => 'tcaEtherLossStatsSqetestDelta',
    '38845' => 'tcaEtherLossStatsSqetestDeltaMin',
    '38846' => 'tcaEtherLossStatsSqetestDeltaMax',
    '38847' => 'tcaEtherLossStatsSqetestDeltaAvg',
    '38856' => 'tcaEtherPauseStatsRecvPauseDelta',
    '38857' => 'tcaEtherPauseStatsRecvPauseDeltaMin',
    '38858' => 'tcaEtherPauseStatsRecvPauseDeltaMax',
    '38859' => 'tcaEtherPauseStatsRecvPauseDeltaAvg',
    '38866' => 'tcaEtherPauseStatsXmitPauseDelta',
    '38867' => 'tcaEtherPauseStatsXmitPauseDeltaMin',
    '38868' => 'tcaEtherPauseStatsXmitPauseDeltaMax',
    '38869' => 'tcaEtherPauseStatsXmitPauseDeltaAvg',
    '38876' => 'tcaEtherPauseStatsResetsDelta',
    '38877' => 'tcaEtherPauseStatsResetsDeltaMin',
    '38878' => 'tcaEtherPauseStatsResetsDeltaMax',
    '38879' => 'tcaEtherPauseStatsResetsDeltaAvg',
    '38888' => 'tcaEtherFcoeInterfaceStatsPacketsTxDelta',
    '38889' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaMin',
    '38890' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaMax',
    '38891' => 'tcaEtherFcoeInterfaceStatsPacketsTxDeltaAvg',
    '38898' => 'tcaEtherFcoeInterfaceStatsPacketsRxDelta',
    '38899' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaMin',
    '38900' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaMax',
    '38901' => 'tcaEtherFcoeInterfaceStatsPacketsRxDeltaAvg',
    '38908' => 'tcaEtherFcoeInterfaceStatsBytesTxDelta',
    '38909' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaMin',
    '38910' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaMax',
    '38911' => 'tcaEtherFcoeInterfaceStatsBytesTxDeltaAvg',
    '38918' => 'tcaEtherFcoeInterfaceStatsBytesRxDelta',
    '38919' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaMin',
    '38920' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaMax',
    '38921' => 'tcaEtherFcoeInterfaceStatsBytesRxDeltaAvg',
    '38928' => 'tcaEtherFcoeInterfaceStatsErrorsTxDelta',
    '38929' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaMin',
    '38930' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaMax',
    '38931' => 'tcaEtherFcoeInterfaceStatsErrorsTxDeltaAvg',
    '38938' => 'tcaEtherFcoeInterfaceStatsErrorsRxDelta',
    '38939' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaMin',
    '38940' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaMax',
    '38941' => 'tcaEtherFcoeInterfaceStatsErrorsRxDeltaAvg',
    '38948' => 'tcaEtherFcoeInterfaceStatsDroppedTxDelta',
    '38949' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaMin',
    '38950' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaMax',
    '38951' => 'tcaEtherFcoeInterfaceStatsDroppedTxDeltaAvg',
    '38958' => 'tcaEtherFcoeInterfaceStatsDroppedRxDelta',
    '38959' => 'tcaEtherFcoeInterfaceStat