package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOFIREPOWERAPMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-FIREPOWER-AP-MIB'} = {
  url => '',
  name => 'CISCO-FIREPOWER-AP-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-FIREPOWER-AP-MIB'} =
  '1.3.6.1.4.1.9.9.826.2';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-FIREPOWER-AP-MIB'} = {
  'ciscoFirepowerMIB' => '1.3.6.1.4.1.9.9.826',
  'ciscoFirepowerApMIB' => '1.3.6.1.4.1.9.9.826.2',
  'ciscoFirepowerApMIBObjects' => '1.3.6.1.4.1.9.9.826.2.1',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-FIREPOWER-AP-MIB'} = {
  'CfprApFaultSeverity' => {
    '0' => 'cleared',
    '1' => 'info',
    '3' => 'warning',
    '4' => 'minor',
    '5' => 'major',
    '6' => 'critical',
  },
  'CfprApFaultType' => {
    '0' => 'generic',
    '1' => 'configuration',
    '2' => 'environmental',
    '3' => 'fsm',
    '4' => 'equipment',
    '5' => 'network',
    '6' => 'server',
    '7' => 'management',
    '8' => 'sysdebug',
    '9' => 'security',
    '10' => 'connectivity',
    '11' => 'operational',
  },
  'CfprApFaultProbableCause' => {
    '3' => 'vlanPermitUnresolved',
    '4' => 'groupPermitUnresolved',
    '5' => 'insufficientResources',
    '6' => 'insufficientlyEquipped',
    '7' => 'identityUnestablishable',
    '8' => 'powerProblem',
    '9' => 'thermalProblem',
    '10' => 'equipmentInoperable',
    '11' => 'discoveryFailed',
    '12' => 'associationFailed',
    '13' => 'disassociationFailed',
    '14' => 'equipmentMissing',
    '15' => 'equipmentInaccessible',
    '16' => 'vifIdsMismatch',
    '17' => 'adaptorMismatch',
    '18' => 'voltageProblem',
    '19' => 'emptyPool',
    '20' => 'equipmentProblem',
    '21' => 'boardCtrlUpgraded',
    '22' => 'vmediaMountInaccessible',
    '25' => 'fsmFailed',
    '26' => 'resolveFailed',
    '27' => 'checkInventoryStatusFailed',
    '28' => 'reportFullInventoryFailed',
    '29' => 'imageDeleted',
    '30' => 'imageUnusable',
    '31' => 'imageCannotBoot',
    '32' => 'activationFailed',
    '33' => 'cimcFirmwareMismatch',
    '34' => 'pldFirmwareMismatch',
    '35' => 'defaultHostpackMissing',
    '37' => 'localFailed',
    '38' => 'unpackLocalFailed',
    '39' => 'deleteLocalFailed',
    '40' => 'copyRemoteFailed',
    '41' => 'remoteFailed',
    '42' => 'copyExtToLocalFailed',
    '43' => 'copyExtToPeerFailed',
    '44' => 'startFailed',
    '45' => 'executeFailed',
    '46' => 'copyToLocalFailed',
    '47' => 'copyToPeerFailed',
    '48' => 'updateLocalFailed',
    '49' => 'verifyLocalFailed',
    '50' => 'resetLocalFailed',
    '51' => 'updateRemoteFailed',
    '52' => 'verifyRemoteFailed',
    '53' => 'resetRemoteFailed',
    '54' => 'copyImgFromRepFailed',
    '55' => 'copyiomimgToSubFailed',
    '56' => 'waitForReadyFailed',
    '57' => 'restoreFailed',
    '58' => 'waitForDeployFailed',
    '59' => 'validateApplicationPackFailed',
    '60' => 'deleteCurrentApplicationFailed',
    '61' => 'pollDeleteCurrentApplicationStatusFailed',
    '62' => 'setStartupServiceManagerVersionFailed',
    '63' => 'pollStartupServiceManagerStatusFailed',
    '64' => 'activateNpuImageFailed',
    '65' => 'pollNpuActivationStatusFailed',
    '66' => 'activateSystemImageFailed',
    '67' => 'activateFirmwareImageFailed',
    '68' => 'rebootSystemForImageUpgradeFailed',
    '69' => 'waitForSystemReadyFailed',
    '70' => 'pollSystemActivationStatusFailed',
    '71' => 'activateManagerImageFailed',
    '72' => 'pollManagerActivationStatusFailed',
    '73' => 'activateApplicationImageFailed',
    '74' => 'pollApplicationActivationStatusFailed',
    '75' => 'completeFirmwareUpgradeFailed',
    '76' => 'validateFirmwarePackFailed',
    '77' => 'debundlePortFailed',
    '78' => 'pollDebundlePortFailed',
    '79' => 'activateFirmwarePackFailed',
    '80' => 'pollActivateOfFirmwarePackFailed',
    '81' => 'updateImageVersionFailed',
    '82' => 'waitForFirmwareVersionUpdateFailed',
    '83' => 'updatePackageVersionFailed',
    '84' => 'resolveDistributableNamesFailed',
    '85' => 'resolveDistributableFailed',
    '86' => 'resolveImagesFailed',
    '87' => 'activateCatalogFailed',
    '88' => 'pingFailed',
    '89' => 'groupCapInsufficient',
    '90' => 'oldChassisComponentFirmware',
    '91' => 'oldFirmware',
    '92' => 'psuInsufficient',
    '93' => 'psuRedundancyFail',
    '94' => 'powerCapFail',
    '95' => 'powerConsumptionHitLimit',
    '96' => 'noAckFromBios',
    '97' => 'noCapFail',
    '98' => 'psuMixedMode',
    '99' => 'slotNotResponding',
    '100' => 'bladeNotWorking',
    '101' => 'diskFormatFailed',
    '102' => 'bladeSwap',
    '103' => 'switchConfigFailed',
    '104' => 'appinstanceNotResponding',
    '105' => 'appinstanceInstallFailed',
    '106' => 'appinstanceStartFailed',
    '107' => 'appinstanceUpdateFailed',
    '108' => 'appinstanceStopFailed',
    '109' => 'appinstanceError',
    '110' => 'logicalDeviceIncompleteConfiguration',
    '111' => 'logicalDeviceError',
    '112' => 'licenseAgreementNotAccepted',
    '113' => 'appinstanceUnsupported',
    '114' => 'appMetaCorrupted',
    '115' => 'updateFailed',
    '116' => 'stopDecoratorAppsFailed',
    '117' => 'wairForStopDecoratorsFailed',
    '118' => 'stopMainAppFailed',
    '119' => 'waitForBladeRebootFailed',
    '120' => 'waitForStopMainAppFailed',
    '121' => 'startAppsFailed',
    '122' => 'waitForPortReadyFailed',
    '123' => 'createLogicalDeviceFailed',
    '124' => 'updateConnectivityFailed',
    '125' => 'updateVlanGroupsFailed',
    '127' => 'portInventorySwAfailed',
    '128' => 'portInventorySwBfailed',
    '129' => 'configSwAfailed',
    '130' => 'configSwBfailed',
    '131' => 'verifyPhysConfigFailed',
    '134' => 'verifyBreakoutConfigFailed',
    '135' => 'updateZonesFailed',
    '136' => 'noVlanOptimization',
    '137' => 'vifDown',
    '138' => 'configurationFailed',
    '139' => 'pinningMismatch',
    '140' => 'pinningMisconfig',
    '141' => 'inaccessibleVlanReferenced',
    '142' => 'referencedVlanUnresolvable',
    '143' => 'referencedRemoteVlanUnresolvable',
    '144' => 'invalidVlanInTheAllowedVlanList',
    '145' => 'vlanConflictPermit',
    '146' => 'profileConfigIncorrect',
    '147' => 'multipleConnectionPolicies',
    '148' => 'setLocalFailed',
    '149' => 'setPeerFailed',
    '150' => 'callhomeConfigError',
    '151' => 'disableFailed',
    '152' => 'enableFailed',
    '153' => 'disableAfailed',
    '154' => 'enableAfailed',
    '155' => 'disableBfailed',
    '156' => 'enableBfailed',
    '157' => 'unidentifiableFru',
    '158' => 'connectivityProblem',
    '159' => 'linkDown',
    '160' => 'linkMisconnected',
    '161' => 'linkMissing',
    '162' => 'validateLocalFailed',
    '163' => 'validateRemoteFailed',
    '164' => 'deleteRemoteFailed',
    '165' => 'equipmentDegraded',
    '166' => 'equipmentDisabled',
    '167' => 'applyTemplateFailed',
    '168' => 'applyIdentifiersFailed',
    '169' => 'checkAssignedIdentifiersForDupFailed',
    '170' => 'resolvePoliciesFailed',
    '171' => 'resolveNetworkPoliciesFailed',
    '172' => 'resolveNetworkTemplatesFailed',
    '173' => 'resolveIdentifiersFailed',
    '174' => 'applyDefaultIdentifiersFailed',
    '175' => 'checkAssignedDefaultIdentifiersForDupFailed',
    '176' => 'resolveDefaultIdentifiersFailed',
    '177' => 'resolveScheduleFailed',
    '178' => 'validatePolicyOwnershipFailed',
    '179' => 'applyPoliciesFailed',
    '180' => 'provisionStorageFailed',
    '181' => 'waitForStorageProvisionFailed',
    '182' => 'resolveBootConfigFailed',
    '183' => 'evaluateAssociationFailed',
    '184' => 'analyzeImpactFailed',
    '185' => 'waitForMaintPermissionFailed',
    '186' => 'waitForMaintWindowFailed',
    '187' => 'commitStorageFailed',
    '188' => 'waitForCommitStorageFailed',
    '189' => 'applyConfigFailed',
    '190' => 'waitForAssocCompletionFailed',
    '191' => 'configFeLocalFailed',
    '192' => 'configFePeerFailed',
    '193' => 'swConfigLocalFailed',
    '194' => 'swConfigPeerFailed',
    '195' => 'disableServerConnSwBfailed',
    '196' => 'enableServerConnSwAfailed',
    '197' => 'disableServerConnSwAfailed',
    '198' => 'enableServerConnSwBfailed',
    '199' => 'cleanupServerConnSwAfailed',
    '200' => 'cleanupServerConnSwBfailed',
    '201' => 'swUnconfigLocalFailed',
    '202' => 'swUnconfigPeerFailed',
    '203' => 'removeConfigFailed',
    '204' => 'restoreConfigFeLocalFailed',
    '205' => 'restoreConfigFePeerFailed',
    '206' => 'evaluateStatusFailed',
    '207' => 'cimcvlanCfgLocalFailed',
    '208' => 'cimcvlanCfgPeerFailed',
    '209' => 'aFailed',
    '210' => 'bFailed',
    '211' => 'swUnConfigLocalFailed',
    '212' => 'swUnConfigPeerFailed',
    '213' => 'checkLicenseFailed',
    '214' => 'identifyFailed',
    '215' => 'configureSwMgmtEndPointFailed',
    '216' => 'configureVifNsFailed',
    '217' => 'decomissionFailed',
    '218' => 'disableEndPointFailed',
    '219' => 'unIdentifyLocalFailed',
    '220' => 'unIdentifyPeerFailed',
    '221' => 'waitFailed',
    '222' => 'shutdownFailed',
    '223' => 'enablePortFailed',
    '224' => 'serverFailed',
    '225' => 'configurationFailure',
    '226' => 'maintenanceFailed',
    '227' => 'equipmentRemoved',
    '228' => 'serverInaccessible',
    '229' => 'assignmentFailed',
    '230' => 'unassociated',
    '231' => 'svnicNotPresent',
    '232' => 'nonExistentScheduler',
    '233' => 'unsupportedCimcFirmware',
    '250' => 'satelliteConnectionAbsent',
    '252' => 'satelliteMisConnected',
    '253' => 'unexpectedNumberOfLinks',
    '254' => 'equipmentOffline',
    '255' => 'fexUnsupported',
    '256' => 'performanceProblem',
    '257' => 'firmwareUpgradeProblem',
    '258' => 'unsupportedConnectivityConfiguration',
    '259' => 'equipmentUnacknowledged',
    '260' => 'autoFirmwareUpgrade',
    '261' => 'equipmentDisconnected',
    '262' => 'fruProblem',
    '263' => 'powerDown',
    '264' => 'act2Fail',
    '265' => 'healthLedAmberBlinking',
    '266' => 'tpmOnSlaveBoard',
    '267' => 'healthLedAmber',
    '268' => 'executeAfailed',
    '269' => 'executeBfailed',
    '270' => 'sendCommandFailed',
    '271' => 'waitStageFailed',
    '272' => 'updateAppInstanceFailed',
    '273' => 'checkBladeReadinessFailed',
    '274' => 'waitForAppsInstallationFailed',
    '275' => 'waitForLinkConfigurationFailed',
    '276' => 'releaseAppLicenseFailed',
    '277' => 'configureLinksFailed',
    '278' => 'waitForConfigCompletionFailed',
    '279' => 'updateBundleStatusFailed',
    '280' => 'sendBundleStatusFailed',
    '281' => 'sendInterfacesFailed',
    '282' => 'unconfigureLinksFailed',
    '283' => 'configureSwitchFailed',
    '284' => 'waitForSwitchConfigFailed',
    '285' => 'unconfigureLogicalDeviceFailed',
    '286' => 'sendStatusFailed',
    '287' => 'sendConfigFailed',
    '288' => 'startDiskFormatFailed',
    '289' => 'resetBladePowerFailed',
    '290' => 'waitForDiskFormatCompleteFailed',
    '291' => 'updateTimeZoneFailed',
    '292' => 'getAttributesFailed',
    '293' => 'sendUpdateFailed',
    '294' => 'stopAppFailed',
    '295' => 'waitForStopAppFailed',
    '296' => 'upgradeAppFailed',
    '297' => 'waitForUpgradeAppFailed',
    '298' => 'startAppFailed',
    '299' => 'configureFailed',
    '300' => 'clientLostConnectivity',
    '301' => 'licenseGraceperiodEntered',
    '302' => 'licenseGraceperiod10days',
    '303' => 'licenseGraceperiod30days',
    '304' => 'licenseGraceperiod60days',
    '305' => 'licenseGraceperiod90days',
    '306' => 'licenseGraceperiod119days',
    '307' => 'licenseGraceperiodExpired',
    '308' => 'licenseInsufficient',
    '309' => 'capacityExceeded',
    '310' => 'configurationError',
    '311' => 'operationFailed',
    '312' => 'equipmentUnhealthy',
    '313' => 'peerFailed',
    '314' => 'setEpLocalFailed',
    '315' => 'setEpPeerFailed',
    '316' => 'propogateEpSettingsFailed',
    '317' => 'propogateEpTimeZoneSettingsToFexIomLocalFailed',
    '318' => 'propogateEpTimeZoneSettingsToFexIomPeerFailed',
    '319' => 'providerGroupAlreadyExists',
    '320' => 'providerGroupSizeEmpty',
    '321' => 'invalidServerGroup',
    '322' => 'invalidKeyringCertificate',
    '323' => 'invalidKeyringModulus',
    '324' => 'invalidTrustpointCertChain',
    '325' => 'roleConfigError',
    '326' => 'localeConfigError',
    '327' => 'localeOrgConfigError',
    '328' => 'userRoleConfigError',
    '329' => 'userLocaleConfigError',
    '330' => 'keyringConfigError',
    '331' => 'snmpConfigError',
    '332' => 'timezoneFileNotExists',
    '333' => 'userConfigError',
    '334' => 'snmpUserConfigError',
    '335' => 'commSvcConfigError',
    '336' => 'setKeyRingLocalFailed',
    '337' => 'setKeyRingPeerFailed',
    '338' => 'postSetKeyRingLocalFailed',
    '339' => 'postSetKeyRingPeerFailed',
    '340' => 'setRealmLocalFailed',
    '341' => 'setRealmPeerFailed',
    '342' => 'setUserLocalFailed',
    '343' => 'setUserPeerFailed',
    '344' => 'serverError',
    '345' => 'tftpServerError',
    '346' => 'copySubFailed',
    '347' => 'copyPrimaryFailed',
    '348' => 'deleteSubFailed',
    '349' => 'deletePrimaryFailed',
    '350' => 'removeFailed',
    '351' => 'mgmtifDown',
    '352' => 'arpTargetsConfigError',
    '353' => 'ndiscTargetsConfigError',
    '354' => 'duplicatedAssigned',
    '355' => 'switchFailed',
    '356' => 'limitReached',
    '357' => 'nearMaxLimit',
    '358' => 'inventoryFailed',
    '359' => 'memoryError',
    '360' => 'extraPrimaryVlans',
    '361' => 'extraSecondaryVlans',
    '362' => 'extraSecondaryVlansPerPrimary',
    '363' => 'configInterfaceFailed',
    '364' => 'verifyLinkConfigFailed',
    '365' => 'setEpAfailed',
    '366' => 'setEpBfailed',
    '367' => 'bootupFailure',
    '368' => 'createLocalFailed',
    '369' => 'createRemoteFailed',
    '371' => 'loadCatalogFailed',
    '372' => 'applyFailed',
    '373' => 'rescanImagesFailed',
    '374' => 'copyCatFromRepFailed',
    '375' => 'copyExternalRepToRemoteFailed',
    '376' => 'applyCatalogFailed',
    '377' => 'syncPortaglocalFailed',
    '378' => 'syncPortagremoteFailed',
    '379' => 'finalizeFailed',
    '380' => 'updateEthMonFailed',
    '382' => 'serverMoved',
    '383' => 'serverIdentificationProblem',
    '384' => 'primaryVlanMissingForIsolated',
    '385' => 'primaryVlanMissingForCommunity',
    '386' => 'emptyPinGroup',
    '387' => 'membershipDown',
    '388' => 'invalidTarget',
    '389' => 'configError',
    '390' => 'vlanMismatch',
    '391' => 'vlanErrorAssocPrimary',
    '392' => 'interfaceMisconfigured',
    '393' => 'missingPrimaryVlan',
    '394' => 'udldLinkDown',
    '395' => 'vlanMcastPolicyMisconfigured',
    '396' => 'namedVlanUnresolved',
    '397' => 'updateSspEthMonFailed',
    '398' => 'deletePcapFileFailed',
    '399' => 'syncFailed',
    '400' => 'validateConfigurationFailed',
    '401' => 'applyPhysicalFailed',
    '402' => 'waitOnPhysFailed',
    '403' => 'reportFailed',
    '404' => 'backupLocalFailed',
    '405' => 'uploadFailed',
    '406' => 'downloadLocalFailed',
    '407' => 'cleanUpFailed',
    '408' => 'configBreakoutFailed',
    '409' => 'waitForSwitchFailed',
    '410' => 'configFailed',
    '411' => 'reportResultsFailed',
    '412' => 'primaryFailed',
    '413' => 'secondaryFailed',
    '414' => 'electionFailure',
    '415' => 'managementServicesFailure',
    '416' => 'managementServicesUnresponsive',
    '417' => 'haNotReady',
    '418' => 'versionIncompatible',
    '419' => 'deviceSharedStorageError',
    '420' => 'haSshKeysMismatched',
    '421' => 'fprmProcessFailure',
    '422' => 'logCapacity',
    '423' => 'fileTransferFailed',
    '424' => 'newLink',
    '425' => 'anotherConnectionAlreadyEnabled',
    '426' => 'connectionUnused',
    '427' => 'unsupportedConnectivity',
    '428' => 'incompatibleServerFirmware',
    '429' => 'namedInbandVlanUnresolved',
    '430' => 'inbandUnsupportedServer',
    '434' => 'registerClientFailed',
    '435' => 'verifyRegistrationFailed',
    '436' => 'mountLocalFailed',
    '437' => 'mountPeerFailed',
    '438' => 'unmountLocalFailed',
    '439' => 'unmountPeerFailed',
    '440' => 'portFailed',
    '441' => 'unsupportedTransceiver',
    '442' => 'interfaceFailed',
    '443' => 'operationalStateDown',
    '444' => 'cmcVifDown',
    '445' => 'verifyGuidFailed',
    '446' => 'unregisterFailed',
    '447' => 'cleanOldDataFailed',
    '448' => 'requestFailed',
    '449' => 'verifyFailed',
    '450' => 'resolveAllFailed',
    '451' => 'suspendModeEntered',
    '452' => 'releaseFailed',
    '453' => 'resolveManyFailed',
    '454' => 'releaseManyFailed',
    '455' => 'releaseAllFailed',
    '457' => 'defaultInfraVersionMissing',
    '458' => 'defaultInfraBundleValidationFailed',
    '459' => 'defaultInfraBundleUpgradeFailure',
    '460' => 'defaultFirmwareUpgradeFailure',
    '462' => 'tooManyKeysOnSystem',
    '463' => 'devkeysInstalledOnSystem',
    '464' => 'applicationPackFailed',
    '465' => 'completeFailed',
    '466' => 'checkFirmwareUpgradeStatusFailed',
    '467' => 'waitForChassisMoReadyFailed',
    '468' => 'fanModuleUnidentified',
    '469' => 'psuUnidentified',
    '470' => 'psuFanProblem',
    '471' => 'bootProblem',
    '472' => 'unsupported',
    '473' => 'equipment',
    '474' => 'ntpConfigFailed',
    '475' => 'stopDhcpSvcFailed',
    '476' => 'checkPendingNetworkConfigFailed',
    '477' => 'applyShutdownFailed',
    '478' => 'applyRebootFailed',
    '479' => 'fpgaGoldenFailedUpgrade',
    '480' => 'deleteExtraImagesFailed',
    '481' => 'invalidKeyringEc',
    '482' => 'encryptionAlgoNotSupported',
    '483' => 'ipsecConfigError',
    '484' => 'validateKeyRingAndtpFailed',
    '485' => 'updateSwitchConfigToAppagFailed',
    '486' => 'updateSwitchPortConfigToAppagFailed',
    '487' => 'reenableSspEthMonFailed',
    '488' => 'sendInterfaceDeletingFailed',
    '489' => 'sendInterfaceAddingFailed',
    '490' => 'portInventorySwFailed',
    '491' => 'configSwFailed',
    '513' => 'freeDiskSpaceFailed',
  },
  'CfprApFaultCode' => {
    '19' => 'fltFabricVlanReqVlanPermitUnresolved',
    '21' => 'fltFabricVlanGroupReqVlanGroupPermitUnresolved',
    '56' => 'fltDcxNsFailed',
    '57' => 'fltComputePhysicalInsufficientlyEquipped',
    '58' => 'fltComputePhysicalIdentityUnestablishable',
    '59' => 'fltComputeBoardPowerError',
    '60' => 'fltComputeBoardPowerFail',
    '61' => 'fltComputeABoardThermalProblem',
    '62' => 'fltComputeABoardPowerUsageProblem',
    '63' => 'fltComputePhysicalPowerProblem',
    '65' => 'fltComputePhysicalBiosPostTimeout',
    '66' => 'fltComputePhysicalDiscoveryFailed',
    '67' => 'fltComputePhysicalAssociationFailed',
    '68' => 'fltComputePhysicalDisassociationFailed',
    '69' => 'fltComputePhysicalInoperable',
    '70' => 'fltComputePhysicalUnassignedMissing',
    '71' => 'fltComputePhysicalAssignedMissing',
    '72' => 'fltComputePhysicalUnidentified',
    '75' => 'fltComputePhysicalNetworkMisconfigured',
    '76' => 'fltComputePhysicalAdapterMismatch',
    '77' => 'fltComputeBoardCmosVoltageThresholdCritical',
    '78' => 'fltComputeBoardCmosVoltageThresholdNonRecoverable',
    '79' => 'fltComputeABoardMotherBoardVoltageThresholdUpperNonRecoverable',
    '80' => 'fltComputeABoardMotherBoardVoltageThresholdLowerNonRecoverable',
    '81' => 'fltComputeABoardMotherBoardVoltageUpperThresholdCritical',
    '82' => 'fltComputeABoardMotherBoardVoltageLowerThresholdCritical',
    '83' => 'fltComputePoolEmpty',
    '84' => 'fltComputePhysicalPostFailure',
    '85' => 'fltComputeRtcBatteryInoperable',
    '86' => 'fltComputeIOHubThermalNonCritical',
    '87' => 'fltComputeIOHubThermalThresholdCritical',
    '88' => 'fltComputeIOHubThermalThresholdNonRecoverable',
    '89' => 'fltFirmwareBootUnitPowerCycleRequired',
    '90' => 'fltCimcvmediaActualMountEntryVmediaMountFailed',
    '95' => 'fltFirmwarePackItemImageMissing',
    '96' => 'fltFirmwareUpdatableImageUnusable',
    '97' => 'fltFirmwareBootUnitCantBoot',
    '98' => 'fltFirmwareBootUnitActivateStatusFailed',
    '99' => 'fltFirmwareStatusCimcFirmwareMismatch',
    '100' => 'fltFirmwareStatusPldFirmwareMismatch',
    '101' => 'fltFirmwareAutoSyncPolicyDefaultHostPackageMissing',
    '149' => 'fltPowerChassisMemberPowerGroupCapInsufficient',
    '150' => 'fltPowerChassisMemberChassisFirmwareProblem',
    '151' => 'fltPowerBudgetFirmwareMismatch',
    '152' => 'fltPowerChassisMemberChassisPsuInsufficient',
    '153' => 'fltPowerBudgetChassisPsuInsufficient',
    '154' => 'fltPowerChassisMemberChassisPsuRedundanceFailure',
    '155' => 'fltPowerBudgetPowerBudgetCmcProblem',
    '156' => 'fltPowerBudgetPowerBudgetBmcProblem',
    '157' => 'fltPowerBudgetPowerCapReachedCommit',
    '158' => 'fltPowerBudgetTStateTransition',
    '159' => 'fltPowerBudgetPowerBudgetDiscFail',
    '160' => 'fltPowerPolicyPowerPolicyApplicationFail',
    '161' => 'fltPowerGroupPowerGroupInsufficientBudget',
    '162' => 'fltPowerGroupPowerGroupBudgetIncorrect',
    '163' => 'fltPowerBudgetChassisPsuMixedMode',
    '185' => 'fltSmSlotSmaHeartbeat',
    '186' => 'fltSmSlotBladeNotWorking',
    '187' => 'fltSmSlotDiskFormatFailed',
    '188' => 'fltSmSlotBladeSwap',
    '189' => 'fltSmSecSvcSwitchConfigFail',
    '190' => 'fltSmAppInstanceAppNotResponding',
    '191' => 'fltSmAppInstanceAppInstallFailed',
    '192' => 'fltSmAppInstanceAppStartFailed',
    '193' => 'fltSmAppInstanceAppUpdateFailed',
    '194' => 'fltSmAppInstanceAppStopFailed',
    '195' => 'fltSmAppInstanceAppInstanceError',
    '196' => 'fltSmLogicalDeviceIncompleteConfig',
    '197' => 'fltSmLogicalDeviceLogicalDeviceError',
    '198' => 'fltSmAppLicenseAgreementNotAccepted',
    '199' => 'fltSmAppInstanceAppInstanceUnsupported',
    '200' => 'fltSmAppAppMetaCorrupted',
    '299' => 'fltSwVlanPortNsVLANCompNotSupport',
    '300' => 'fltDcxVIfLinkState',
    '314' => 'fltVnicEtherConfigFailed',
    '315' => 'fltVnicEtherPinningMismatch',
    '316' => 'fltVnicEtherPinningMisconfig',
    '317' => 'fltVnicEtherIfVlanAccessFault',
    '318' => 'fltVnicEtherIfVlanUnresolvable',
    '319' => 'fltVnicEtherIfRemoteVlanUnresolvable',
    '320' => 'fltVnicEtherIfInvalidVlan',
    '321' => 'fltFabricVlanVlanConflictPermit',
    '322' => 'fltVnicProfileProfileConfigIncorrect',
    '323' => 'fltVnicIScsiConfigFailed',
    '324' => 'fltVnicEtherVirtualizationConflict',
    '325' => 'fltVnicEtherVirtualizationNetflowConflict',
    '326' => 'fltLsIssuesIscsiConfigFailed',
    '332' => 'fltMacpoolPoolEmpty',
    '335' => 'fltCallhomeEpNoSnmpPolicyForCallhome',
    '349' => 'fltAdaptorUnitUnidentifiableFru',
    '350' => 'fltAdaptorUnitExtnUnidentifiableFru',
    '351' => 'fltAdaptorUnitMissing',
    '352' => 'fltAdaptorUnitExtnMissing',
    '353' => 'fltAdaptorUnitAdaptorReachability',
    '354' => 'fltAdaptorHostIfLinkDown',
    '355' => 'fltAdaptorExtIfLinkDown',
    '356' => 'fltAdaptorHostEthIfMisConnect',
    '357' => 'fltAdaptorHostEthIfMissing',
    '358' => 'fltAdaptorExtEthIfMisConnect',
    '359' => 'fltAdaptorExtEthIfMissing',
    '369' => 'fltMemoryUnitDegraded',
    '370' => 'fltMemoryUnitIdentityUnestablishable',
    '371' => 'fltMemoryUnitInoperable',
    '372' => 'fltMemoryUnitDisabled',
    '373' => 'fltMemoryUnitThermalThresholdNonCritical',
    '374' => 'fltMemoryBufferUnitThermalThresholdNonCritical',
    '375' => 'fltMemoryUnitThermalThresholdCritical',
    '376' => 'fltMemoryBufferUnitThermalThresholdCritical',
    '377' => 'fltMemoryUnitThermalThresholdNonRecoverable',
    '378' => 'fltMemoryBufferUnitThermalThresholdNonRecoverable',
    '379' => 'fltMemoryArrayVoltageThresholdNonCritical',
    '380' => 'fltMemoryArrayVoltageThresholdCritical',
    '381' => 'fltMemoryArrayVoltageThresholdNonRecoverable',
    '657' => 'fltLsServerFailed',
    '658' => 'fltLsServerDiscoveryFailed',
    '659' => 'fltLsServerConfigFailure',
    '660' => 'fltLsServerMaintenanceFailed',
    '661' => 'fltLsServerRemoved',
    '662' => 'fltLsServerInaccessible',
    '663' => 'fltLsServerAssociationFailed',
    '664' => 'fltLsComputeBindingAssignmentRequirementsNotMet',
    '665' => 'fltLsServerUnassociated',
    '666' => 'fltLsServerSvnicNotPresent',
    '667' => 'fltLsServerServerUnfulfilled',
    '668' => 'fltLsmaintMaintPolicyUnresolvableScheduler',
    '669' => 'fltLsIssuesKvmPolicyUnsupported',
    '675' => 'fltIqnpoolPoolEmpty',
    '687' => 'fltEtherSwitchIntFIoSatelliteConnectionAbsent',
    '688' => 'fltEtherSwitchIntFIoSatelliteWiringProblem',
    '689' => 'fltEtherSwitchIntFIoSatelliteWiringNumbersUnexpected',
    '690' => 'fltEquipmentPsuPowerSupplyProblem',
    '691' => 'fltEquipmentPsuOffline',
    '692' => 'fltEquipmentPsuPowerSupplyShutdown',
    '693' => 'fltEquipmentChassisIdentityUnestablishable',
    '694' => 'fltEquipmentFexIdentityUnestablishable',
    '695' => 'fltEquipmentFexFexUnsupported',
    '696' => 'fltEquipmentFanModuleDegraded',
    '697' => 'fltEquipmentFanDegraded',
    '698' => 'fltEquipmentChassisInoperable',
    '700' => 'fltEquipmentFanModuleInoperable',
    '701' => 'fltEquipmentFanInoperable',
    '702' => 'fltEquipmentPsuInoperable',
    '703' => 'fltEquipmentIOCardRemoved',
    '704' => 'fltEquipmentIOCardInaccessible',
    '705' => 'fltEquipmentIOCardPostFailure',
    '706' => 'fltEquipmentFexPostFailure',
    '707' => 'fltEquipmentFanModuleMissing',
    '708' => 'fltEquipmentFanMissing',
    '709' => 'fltEquipmentPsuMissing',
    '710' => 'fltEquipmentIOCardThermalProblem',
    '711' => 'fltEquipmentIOCardThermalThresholdNonCritical',
    '712' => 'fltEquipmentIOCardThermalThresholdCritical',
    '713' => 'fltEquipmentIOCardThermalThresholdNonRecoverable',
    '714' => 'fltEquipmentFanModuleThermalThresholdNonCritical',
    '715' => 'fltEquipmentPsuThermalThresholdNonCritical',
    '716' => 'fltEquipmentFanModuleThermalThresholdCritical',
    '717' => 'fltEquipmentPsuThermalThresholdCritical',
    '718' => 'fltEquipmentFanModuleThermalThresholdNonRecoverable',
    '719' => 'fltEquipmentPsuThermalThresholdNonRecoverable',
    '720' => 'fltEquipmentPsuVoltageThresholdNonCritical',
    '721' => 'fltEquipmentPsuVoltageThresholdCritical',
    '722' => 'fltEquipmentPsuVoltageThresholdNonRecoverable',
    '723' => 'fltEquipmentPsuPerfThresholdNonCritical',
    '724' => 'fltEquipmentPsuPerfThresholdCritical',
    '725' => 'fltEquipmentPsuPerfThresholdNonRecoverable',
    '726' => 'fltEquipmentFanPerfThresholdNonCritical',
    '727' => 'fltEquipmentFanPerfThresholdCritical',
    '728' => 'fltEquipmentFanPerfThresholdNonRecoverable',
    '729' => 'fltEquipmentFanPerfThresholdLowerNonRecoverable',
    '730' => 'fltEquipmentIOCardFirmwareUpgrade',
    '731' => 'fltEquipmentChassisUnsupportedConnectivity',
    '732' => 'fltEquipmentChassisUnacknowledged',
    '733' => 'fltEquipmentIOCardUnsupportedConnectivity',
    '734' => 'fltEquipmentIOCardAutoUpgradingFirmware',
    '735' => 'fltEquipmentIOCardUnacknowledged',
    '736' => 'fltEquipmentIOCardPeerDisconnected',
    '737' => 'fltEquipmentChassisIdentity',
    '738' => 'fltEquipmentChassisInvalidFru',
    '739' => 'fltEquipmentChassisPowerProblem',
    '740' => 'fltEquipmentChassisThermalThresholdCritical',
    '741' => 'fltEquipmentChassisThermalThresholdNonCritical',
    '742' => 'fltEquipmentChassisThermalThresholdNonRecoverable',
    '743' => 'fltEquipmentIOCardIdentity',
    '744' => 'fltEquipmentFexIdentity',
    '745' => 'fltEquipmentFanModuleIdentity',
    '746' => 'fltEquipmentPsuIdentity',
    '747' => 'fltEquipmentPsuPowerThreshold',
    '748' => 'fltEquipmentPsuInputError',
    '749' => 'fltEquipmentSwitchCardPowerOff',
    '750' => 'fltEquipmentSwitchCardAct2LiteFail',
    '751' => 'fltEquipmentHealthLedCriticalError',
    '752' => 'fltEquipmentTpmSlaveTpm',
    '753' => 'fltEquipmentHealthLedMinorError',
    '754' => 'fltEquipmentSwitchIOCardRemoved',
    '755' => 'fltEquipmentSwitchIOCardThermalProblem',
    '756' => 'fltEquipmentSwitchIOCardThermalThresholdNonCritical',
    '757' => 'fltEquipmentSwitchIOCardThermalThresholdCritical',
    '758' => 'fltEquipmentSwitchIOCardThermalThresholdNonRecoverable',
    '759' => 'fltEquipmentSwitchIOCardIdentity',
    '760' => 'fltEquipmentSwitchIOCardCpuThermalThresholdCritical',
    '792' => 'fltExtpolClientClientLostConnectivity',
    '793' => 'fltExtpolClientGracePeriodWarning',
    '794' => 'fltExtpolClientGracePeriodWarning2',
    '795' => 'fltExtpolClientGracePeriodWarning3',
    '796' => 'fltExtpolClientGracePeriodWarning4',
    '797' => 'fltExtpolClientGracePeriodWarning5',
    '798' => 'fltExtpolClientGracePeriodWarning6',
    '799' => 'fltExtpolClientGracePeriodWarning7',
    '800' => 'fltExtpolClientGracePeriodWarning1',
    '809' => 'fltStorageLocalDiskInoperable',
    '810' => 'fltStorageLocalDiskDegraded',
    '811' => 'fltStorageLocalDiskSlotEpUnusable',
    '812' => 'fltStorageItemCapacityExceeded',
    '813' => 'fltStorageItemCapacityWarning',
    '814' => 'fltStorageItemFilesystemIssues',
    '815' => 'fltStorageRaidBatteryInoperable',
    '816' => 'fltStorageMezzFlashLifeConfigurationError',
    '817' => 'fltStorageMezzFlashLifeDegraded',
    '818' => 'fltStorageRaidBatteryDegraded',
    '819' => 'fltStorageRaidBatteryRelearnAborted',
    '820' => 'fltStorageRaidBatteryRelearnFailed',
    '822' => 'fltStorageControllerPatrolReadFailed',
    '823' => 'fltStorageControllerInoperable',
    '824' => 'fltStorageLocalDiskRebuildFailed',
    '825' => 'fltStorageLocalDiskCopybackFailed',
    '826' => 'fltStorageLocalDiskMissing',
    '827' => 'fltStorageVirtualDriveInoperable',
    '828' => 'fltStorageVirtualDriveDegraded',
    '829' => 'fltStorageVirtualDriveReconstructionFailed',
    '830' => 'fltStorageVirtualDriveConsistencyCheckFailed',
    '831' => 'fltStorageFlexFlashControllerInoperable',
    '832' => 'fltStorageFlexFlashCardInoperable',
    '833' => 'fltStorageFlexFlashCardMissing',
    '834' => 'fltStorageFlexFlashVirtualDriveDegraded',
    '835' => 'fltStorageFlexFlashVirtualDriveInoperable',
    '836' => 'fltStorageFlexFlashControllerUnhealthy',
    '837' => 'fltStorageFlexFlashControllerMismatch',
    '838' => 'fltStorageFlexFlashDriveUnhealthy',
    '839' => 'fltStorageFlexFlashCardUnhealthy',
    '844' => 'fltIppoolPoolEmpty',
    '850' => 'fltAaaProviderGroupProvidergroup',
    '851' => 'fltAaaProviderGroupProvidergroupsize',
    '852' => 'fltAaaConfigServergroup',
    '853' => 'fltPkiKeyRingStatus',
    '854' => 'fltPkiKeyRingModulus',
    '855' => 'fltPkiTPStatus',
    '856' => 'fltAaaRoleRoleNotDeployed',
    '857' => 'fltAaaLocaleLocaleNotDeployed',
    '858' => 'fltAaaOrgLocaleOrgNotPresent',
    '859' => 'fltAaaUserRoleUserRoleNotDeployed',
    '860' => 'fltAaaUserLocaleUserLocaleNotDeployed',
    '861' => 'fltPkiKeyRingKeyRingNotDeployed',
    '862' => 'fltCommSnmpSyscontactEmpty',
    '863' => 'fltCommDateTimeCommTimeZoneInvalid',
    '864' => 'fltAaaUserLocalUserNotDeployed',
    '865' => 'fltCommSnmpUserSnmpUserNotDeployed',
    '866' => 'fltCommSvcEpCommSvcNotDeployed',
    '871' => 'fltSysdebugLogExportStatusLogExportFailure',
    '872' => 'fltSysdebugAutoCoreFileExportTargetAutoCoreTransferFailure',
    '899' => 'fltProcessorUnitInoperable',
    '900' => 'fltProcessorUnitThermalNonCritical',
    '901' => 'fltProcessorUnitThermalThresholdCritical',
    '902' => 'fltProcessorUnitThermalThresholdNonRecoverable',
    '903' => 'fltProcessorUnitVoltageThresholdNonCritical',
    '904' => 'fltProcessorUnitVoltageThresholdCritical',
    '905' => 'fltProcessorUnitVoltageThresholdNonRecoverable',
    '906' => 'fltProcessorUnitIdentityUnestablishable',
    '907' => 'fltProcessorUnitDisabled',
    '964' => 'fltExtmgmtIfMgmtifdown',
    '965' => 'fltExtmgmtArpTargetsArpTargetsNotValid',
    '966' => 'fltExtmgmtNdiscTargetsNdiscTargetsNotValid',
    '967' => 'fltPoolElementDuplicatedAssigned',
    '977' => 'fltNetworkElementInoperable',
    '978' => 'fltNetworkElementRemoved',
    '979' => 'fltSwVlanPortNsResourceStatus',
    '980' => 'fltSwVlanPortNsResourceStatusWarning',
    '981' => 'fltNetworkElementInventoryFailed',
    '982' => 'fltNetworkElementThermalThresholdCritical',
    '983' => 'fltNetworkElementMemoryerror',
    '984' => 'fltNetworkOperLevelExtraprimaryvlans',
    '985' => 'fltNetworkOperLevelExtrasecondaryvlans',
    '986' => 'fltSwVlanExtrasecondaryvlansperprimary',
    '987' => 'fltFcpoolInitiatorsEmpty',
    '996' => 'fltOsControllerFailedBladeBootup',
    '997' => 'fltOsControllerFailedBootupRecovery',
    '1014' => 'fltUuidpoolPoolEmpty',
    '1020' => 'fltCapabilityCatalogueLoadErrors',
    '1038' => 'fltFabricComputeSlotEpMisplacedInChassisSlot',
    '1039' => 'fltFabricComputeSlotEpServerIdentificationProblem',
    '1040' => 'fltFabricVlanPrimaryVlanMissingForIsolated',
    '1041' => 'fltFabricVlanPrimaryVlanMissingForCommunity',
    '1042' => 'fltFabricLanPinGroupEmpty',
    '1043' => 'fltFabricEthLanPcEpDown',
    '1044' => 'fltFabricEthEstcPcEpDown',
    '1045' => 'fltFabricPinTargetDown',
    '1046' => 'fltFabricDceSwSrvPcEpDown',
    '1047' => 'fltFabricMonSpanConfigFail',
    '1048' => 'fltFabricEpMgrEpTransModeFail',
    '1049' => 'fltFabricVlanMismatchA',
    '1050' => 'fltFabricVlanMismatchB',
    '1051' => 'fltFabricVlanErrorAssocPrimary',
    '1052' => 'fltFabricPIoEpErrorMisconfigured',
    '1053' => 'fltFabricEthLanEpMissingPrimaryVlan',
    '1054' => 'fltFabricEthLanEpUdldLinkDown',
    '1055' => 'fltFabricEthLanPcEpUdldLinkDown',
    '1056' => 'fltFabricEthLanPcMissingPrimaryVlan',
    '1057' => 'fltFabricEthLanEpOverlappingVlan',
    '1058' => 'fltFabricEthLanPcOverlappingVlan',
    '1059' => 'fltFabricVlanMisconfiguredMcastPolicy',
    '1062' => 'fltFabricPooledVlanNamedVlanUnresolved',
    '1115' => 'fltMgmtEntityDegraded',
    '1116' => 'fltMgmtEntityDown',
    '1117' => 'fltMgmtEntityElectionFailure',
    '1118' => 'fltMgmtEntityManagementServicesFailure',
    '1119' => 'fltMgmtEntityManagementServicesUnresponsive',
    '1120' => 'fltMgmtEntityHaNotReady',
    '1121' => 'fltMgmtEntityVersionIncompatible',
    '1122' => 'fltMgmtEntityDevice1SharedStorageError',
    '1123' => 'fltMgmtEntityDevice2SharedStorageError',
    '1124' => 'fltMgmtEntityDevice3SharedStorageError',
    '1125' => 'fltMgmtEntityHaSshKeysMismatched',
    '1126' => 'fltMgmtPmonEntryFPRMProcessFailure',
    '1127' => 'fltSysdebugMEpLogMEpLogLog',
    '1128' => 'fltSysdebugMEpLogMEpLogVeryLow',
    '1129' => 'fltSysdebugMEpLogMEpLogFull',
    '1130' => 'fltSysdebugMEpLogTransferError',
    '1131' => 'fltMgmtIfMisConnect',
    '1132' => 'fltMgmtIfMissing',
    '1133' => 'fltMgmtIfNew',
    '1134' => 'fltMgmtConnectionDisabled',
    '1135' => 'fltMgmtConnectionUnused',
    '1136' => 'fltMgmtConnectionUnsupportedConnectivity',
    '1137' => 'fltMgmtControllerUnsupportedDimmBlacklisting',
    '1138' => 'fltMgmtInterfaceNamedInbandVlanUnresolved',
    '1139' => 'fltMgmtInterfaceInbandUnsupportedServer',
    '1140' => 'fltMgmtInterfaceInbandUnsupportedFirmware',
    '1150' => 'fltPortPIoLinkDown',
    '1151' => 'fltPortPIoFailed',
    '1152' => 'fltPortPIoHardwareFailure',
    '1153' => 'fltPortPIoSfpNotPresent',
    '1154' => 'fltPortPIoInvalidSfp',
    '1155' => 'fltEtherServerIntFIoHardwareFailure',
    '1156' => 'fltFabricExternalPcDown',
    '1157' => 'fltFabricInternalPcDown',
    '1158' => 'fltDcxVcDown',
    '1159' => 'fltDcxVcMgmtVifDown',
    '1174' => 'fltPolicyControlEpSuspendModeActive',
    '1308' => 'fltProcessorUnitThermalProblem',
    '1309' => 'fltFirmwareInfraPackInfraBundleVersionMissing',
    '1310' => 'fltFirmwareSystemInfraBundleValidationFailure',
    '1311' => 'fltFirmwareSystemInfraBundleUpgradeFailure',
    '1312' => 'fltFirmwareSystemFirmwareUpgradeFailure',
    '1314' => 'fltFirmwareSystemTooManyKeysInstalled',
    '1315' => 'fltFirmwareSystemDevkeysInstalled',
    '1322' => 'fltEquipmentFanModuleFanModuleUnidentified',
    '1323' => 'fltEquipmentPsuPsuUnidentified',
    '1324' => 'fltEquipmentPsuPsuFanProblem',
    '1325' => 'fltEquipmentChassisBootProblem',
    '1326' => 'fltEquipmentSwitchCardUnsupported',
    '1328' => 'fltStorageLocalDiskDiskUnidentified',
    '1329' => 'fltCommDateTimeCommNtpConfigurationFailed',
    '1345' => 'fltFirmwareRommonInfoFpgaGoldenTooOld',
    '1346' => 'fltPkiKeyRingEc',
    '1347' => 'fltCommSshcEncryptAlgoInvalid',
    '1348' => 'fltIpsecConnectionIpsecConnInvalidKey',
    '1349' => 'fltIpsecConnectionIpsecConnInvalidCert',
    '1350' => 'fltIpsecAuthorityIpsecAuthorInvalidTp',
    '1358' => 'fltNetworkEthLanMgmtFailed',
    '1367' => 'fltFabricMgmtLanPcEpDown',
    '1372' => 'fltStorageLocalDiskThermalThresholdCritical',
    '1373' => 'fltStorageLocalDiskSedLockedAuthFail',
    '1374' => 'fltStorageLocalDiskSedConfigAuthFail',
    '16476' => 'fsmStFailComputeServerDiscPolicyResolveScrubPolicyResolve',
    '16477' => 'fsmStFailGmetaHolderInventoryReportFullInventory',
    '16517' => 'fsmStFailFirmwareDownloaderDownloadUnpackLocal',
    '16518' => 'fsmStFailFirmwareImageDeleteRemote',
    '16519' => 'fsmStFailFirmwareDistributableDeleteRemote',
    '16520' => 'fsmStFailMgmtControllerUpdateUCSManagerStart',
    '16521' => 'fsmStFailMgmtControllerUpdateSwitchVerifyRemote',
    '16522' => 'fsmStFailMgmtControllerUpdateIOMCopyImgFromRep',
    '16523' => 'fsmStFailFirmwarePlatformPackPlatformVersionWaitForReady',
    '16524' => 'fsmStFailFirmwareSystemDeployWaitForSystemReady',
    '16525' => 'fsmStFailFirmwareSupFirmwareDeployWaitForFirmwareVersionUpdate',
    '16526' => 'fsmStFailFirmwareSystemApplyCatalogPackResolveImages',
    '16528' => 'fsmStFailIdentIdentRequestUpdateIdentExecute',
    '16529' => 'fsmStFailIdentMetaSystemSyncPing',
    '16530' => 'fsmStFailIdentMetaSystemUcscUnivSyncExecute',
    '16585' => 'fsmStFailSmAppDeleteLocal',
    '16586' => 'fsmStFailSmSecSvcRestoreApplicationRestore',
    '16587' => 'fsmStFailSmAppUpdateApplicationUpdate',
    '16588' => 'fsmStFailSmAppInstanceResetApplicationWaitForStopMainApp',
    '16589' => 'fsmStFailSmSecSvcAutoDeployCSPWaitForPortReady',
    '16667' => 'fsmStFailSwAccessDomainDeployUpdateConnectivity',
    '16668' => 'fsmStFailSwEthLanBorderDeployUpdateVlanGroups',
    '16669' => 'fsmStFailSwFcSanBorderDeployUpdateConnectivity',
    '16670' => 'fsmStFailSwUtilityDomainDeployUpdateConnectivity',
    '16676' => 'fsmStFailSwPhysConfPhysicalVerifyPhysConfig',
    '16681' => 'fsmStFailSwExtUtilityConfPortBreakoutVerifyBreakoutConfig',
    '16682' => 'fsmStFailSwFcSanBorderActivateZoneSetUpdateZones',
    '16718' => 'fsmStFailCallhomeEpConfigCallhomeSetPeer',
    '16727' => 'fsmStFailAdaptorExtEthIfPathResetEnable',
    '16730' => 'fsmStFailAdaptorHostEthIfCircuitResetEnableB',
    '16731' => 'fsmStFailAdaptorHostFcIfCircuitResetEnableB',
    '16748' => 'fsmStFailLicenseDownloaderDownloadValidateRemote',
    '16749' => 'fsmStFailLicenseFileInstallRemote',
    '16750' => 'fsmStFailLicenseFileClearRemote',
    '16751' => 'fsmStFailLicenseInstanceUpdateFlexlmRemote',
    '16752' => 'fsmStFailLicenseSmartConfigSetConfigLocal',
    '16770' => 'fsmStFailLsServerConfigureCheckAssignedIdentifiersForDup',
    '16780' => 'fsmStFailComputeBladeDiagSwUnconfigPeer',
    '16803' => 'fsmStFailMgmtControllerExtMgmtInterfaceConfigCIMCVlanCfgPeer',
    '16804' => 'fsmStFailComputePhysicalSwConnUpdB',
    '16805' => 'fsmStFailEquipmentIOCardResetIomExecute',
    '16806' => 'fsmStFailComputePhysicalServiceInfraDeploySwConfigPeer',
    '16807' => 'fsmStFailComputePhysicalServiceInfraWithdrawSwUnConfigPeer',
    '16815' => 'fsmStFailEquipmentIOCardBaseFePresenceIdentify',
    '16816' => 'fsmStFailEquipmentIOCardBaseFeConnConfigureVifNs',
    '16817' => 'fsmStFailEquipmentChassisRemoveChassisDecomission',
    '16818' => 'fsmStFailEquipmentLocatorLedSetFeLocatorLedExecute',
    '16819' => 'fsmStFailEquipmentLocatorLedSetFiLocatorLedExecute',
    '16822' => 'fsmStFailPortPIoInCompatSfpPresenceShutdown',
    '16823' => 'fsmStFailPortPIoInCompatSfpReplacedEnablePort',
    '17063' => 'fsmStFailObserveObservedResolvePolicyFsmExecute',
    '17064' => 'fsmStFailObserveObservedResolveResourceFsmExecute',
    '17065' => 'fsmStFailObserveObservedResolveVMFsmExecute',
    '17066' => 'fsmStFailObserveObservedResolveControllerFsmExecute',
    '17149' => 'fsmStFailEquipmentBeaconLedIlluminateExecuteB',
    '17151' => 'fsmStFailSdAppInstanceInstallApplicationWaitStage',
    '17152' => 'fsmStFailSdAppInstanceStartApplicationWaitStage',
    '17153' => 'fsmStFailSdLduProvisionLDUWaitForLinkConfiguration',
    '17154' => 'fsmStFailSdAppInstanceUpgradeApplicationWaitStage',
    '17155' => 'fsmStFailSdAppInstanceStopApplicationWaitStage',
    '17156' => 'fsmStFailSdAppInstanceUninstallApplicationWaitStage',
    '17157' => 'fsmStFailSdSlotChangePlatformLogLevelSendCommand',
    '17158' => 'fsmStFailSdAppInstanceBundleDataPortsWaitForConfigCompletion',
    '17159' => 'fsmStFailSdLogicalDeviceConfigureLinksWaitForSwitchConfig',
    '17161' => 'fsmStFailSdClusterBootstrapUpdateClusterConfigurationSendConfig',
    '17162' => 'fsmStFailSdSlotFormatDiskWaitForDiskFormatComplete',
    '17163' => 'fsmStFailSdSlotSynchTimeZoneUpdateTimeZone',
    '17164' => 'fsmStFailSdAppAttributeCtrlGetAppAttributesGetAttributes',
    '17165' => 'fsmStFailSdMgmtInfoUpdateMgmtInfoSendUpdate',
    '17166' => 'fsmStFailSdNetMgmtBootstrapUpdateNetMgmtBootstrapSendUpdate',
    '17167' => 'fsmStFailSdUpgradeTaskStopUpgradeStartAppWaitForUpgradeApp',
    '17169' => 'fsmStFailEtherServerIntFIoConfigSpeedConfigure',
    '17170' => 'fsmStFailEtherFtwPortPairConfigFtwConfigure',
    '17185' => 'fsmStFailExtpolEpRegisterFsmExecute',
    '17186' => 'fsmStFailExtpolRegistryCrossDomainConfigSetPeer',
    '17187' => 'fsmStFailExtpolRegistryCrossDomainDeleteSetPeer',
    '17224' => 'fsmStFailStorageSystemSyncExecute',
    '17226' => 'fsmStFailSysfileMutationSingleExecute',
    '17227' => 'fsmStFailSysfileMutationGlobalPeer',
    '17231' => 'fsmStFailApplicationDownloaderDownloadUnpackLocal',
    '17232' => 'fsmStFailCommSvcEpUpdateSvcEpSetEpPeer',
    '17233' => 'fsmStFailCommSvcEpRestartWebSvcPeer',
    '17251' => 'fsmStFailPkiEpUpdateEpValidateKeyRingAndTP',
    '17252' => 'fsmStFailAaaEpUpdateEpSetEpPeer',
    '17253' => 'fsmStFailAaaRealmUpdateRealmSetRealmPeer',
    '17254' => 'fsmStFailAaaUserEpUpdateUserEpSetUserPeer',
    '17265' => 'fsmStFailSysdebugManualCoreFileExportTargetExportExecute',
    '17266' => 'fsmStFailSysdebugLogExportPolicyConfigurePeer',
    '17267' => 'fsmStFailSysdebugAutoCoreFileExportTargetConfigurePeer',
    '17268' => 'fsmStFailSysdebugTechSupportInitiateLocal',
    '17269' => 'fsmStFailSysdebugTechSupportDeleteTechSupFilePeer',
    '17270' => 'fsmStFailSysdebugTechSupportDownloadDeleteSub',
    '17271' => 'fsmStFailSysdebugCoreDownloadDeleteSub',
    '17272' => 'fsmStFailSysdebugLogControlEpLogControlPersistPeer',
    '17336' => 'fsmStFailEpqosDefinitionDeployPeer',
    '17337' => 'fsmStFailEpqosDefinitionDelTaskRemovePeer',
    '17340' => 'fsmStFailQosclassDefinitionConfigGlobalQoSSetPeer',
    '17347' => 'fsmStFailMgmtControllerRegistryConfigRemove',
    '17358' => 'fsmStFailMgmtIfSwMgmtOobIfConfigSwitch',
    '17359' => 'fsmStFailMgmtIfSwMgmtInbandIfConfigSwitch',
    '17360' => 'fsmStFailMgmtIPv6IfAddrSwMgmtOobIpv6IfConfigSwitch',
    '17373' => 'fsmStFailNhTableHolderConfigureLinksVerifyLinkConfig',
    '17374' => 'fsmStFailNhTableHolderBootstrapLinksApplyConfig',
    '17378' => 'fsmStFailStatsCollectionPolicyUpdateEpSetEpB',
    '17403' => 'fsmStFailSyntheticFsObjCreateCreateRemote',
    '17408' => 'fsmStFailCapabilityUpdaterUpdaterUnpackLocal',
    '17409' => 'fsmStFailCapabilityCatalogueActivateCatalogUnpackLocal',
    '17410' => 'fsmStFailCapabilityMgmtExtensionActivateMgmtExtUnpackLocal',
    '17411' => 'fsmStFailCapabilityCatalogueDeployCatalogueFinalize',
    '17420' => 'fsmStFailSwEthMonDeployUpdateEthMon',
    '17469' => 'fsmStFailSwSspEthMonDeployUpdateSspEthMon',
    '17470' => 'fsmStFailSwSspEthMonSrcPhyEpDeleteDeletePcapFile',
    '17476' => 'fsmStFailFabricVnetEpSyncEpPushVnetEpDeletionSync',
    '17477' => 'fsmStFailFabricLanCloudSwitchModeSwConfigPeer',
    '17478' => 'fsmStFailFabricSanCloudSwitchModeSwConfigPeer',
    '17484' => 'fsmStFailFabricEpMgrConfigureWaitOnPhys',
    '17490' => 'fsmStFailMgmtExportPolicyReportConfigCopyReport',
    '17491' => 'fsmStFailExtpolProviderReportConfigImportReport',
    '17492' => 'fsmStFailMgmtIfVirtualIfConfigRemote',
    '17493' => 'fsmStFailMgmtIfEnableVipLocal',
    '17494' => 'fsmStFailMgmtIfDisableVipPeer',
    '17495' => 'fsmStFailMgmtIfEnableHALocal',
    '17496' => 'fsmStFailMgmtBackupBackupUpload',
    '17497' => 'fsmStFailMgmtImporterImportWaitForSwitch',
    '17498' => 'fsmStFailMgmtControllerSysConfigSecondary',
    '17531' => 'fsmStFailNfsMountInstMountVerifyRegistration',
    '17532' => 'fsmStFailNfsMountInstUnmountUnmountPeer',
    '17533' => 'fsmStFailNfsMountDefReportNfsMountSuspendReport',
    '17554' => 'fsmStFailExtpolEpRepairCertVerifyGuid',
    '17555' => 'fsmStFailPolicyControlEpOperateResolve',
    '17556' => 'fsmStFailPolicyControlledTypeOperateResolveAll',
    '17559' => 'fsmStFailPolicyPolicyScopeReleasePolicyFsmRelease',
    '17560' => 'fsmStFailPolicyPolicyScopeReleaseOperationFsmRelease',
    '17561' => 'fsmStFailPolicyPolicyScopeReleaseStorageFsmRelease',
    '17562' => 'fsmStFailPolicyPolicyScopeResolveManyPolicyFsmResolveMany',
    '17563' => 'fsmStFailPolicyPolicyScopeResolveManyOperationFsmResolveMany',
    '17564' => 'fsmStFailPolicyPolicyScopeResolveManyStorageFsmResolveMany',
    '17565' => 'fsmStFailPolicyPolicyScopeReleaseManyPolicyFsmReleaseMany',
    '17566' => 'fsmStFailPolicyPolicyScopeReleaseManyOperationFsmReleaseMany',
    '17567' => 'fsmStFailPolicyPolicyScopeReleaseManyStorageFsmReleaseMany',
    '17568' => 'fsmStFailPolicyPolicyScopeResolveAllPolicyFsmResolveAll',
    '17569' => 'fsmStFailPolicyPolicyScopeResolveAllOperationFsmResolveAll',
    '17570' => 'fsmStFailPolicyPolicyScopeResolveAllStorageFsmResolveAll',
    '17571' => 'fsmStFailPolicyPolicyScopeReleaseAllPolicyFsmReleaseAll',
    '17572' => 'fsmStFailPolicyPolicyScopeReleaseAllOperationFsmReleaseAll',
    '17573' => 'fsmStFailPolicyPolicyScopeReleaseAllStorageFsmReleaseAll',
    '17690' => 'fsmStFailFirmwareInfraPackInfraVersionWaitForReady',
    '17700' => 'fsmStFailFirmwareValidationStatusValidateComplete',
    '17711' => 'fsmStFailSdLogicalDeviceConfigureUserMacsWaitForSwitchConfig',
    '17715' => 'fsmStFailMgmtIfSwMgmtOobIfDhcpConfigStopDhcpSvc',
    '17718' => 'fsmStFailSdLduUpdateInterfaceStatusSendStatus',
    '17724' => 'fsmStFailEquipmentChassisShutdownChassisApplyShutdown',
    '17725' => 'fsmStFailEquipmentChassisRebootChassisApplyReboot',
    '17735' => 'fsmStFailIpsecEpUpdateEpApplyConfig',
    '17744' => 'fsmStFailNetworkEthLanMgmtUpdateInterfaceStatusSendStatus',
    '17745' => 'fsmStFailNetworkEthLanMgmtUpdateMgmtInterfaceStatusSendStatus',
    '17752' => 'fsmStFailSdLogicalDeviceConfigureMacsWaitForSwitchConfig',
    '77916' => 'fsmRmtErrComputeServerDiscPolicyResolveScrubPolicyResolve',
    '77917' => 'fsmRmtErrGmetaHolderInventoryReportFullInventory',
    '77957' => 'fsmRmtErrFirmwareDownloaderDownloadUnpackLocal',
    '77958' => 'fsmRmtErrFirmwareImageDeleteRemote',
    '77959' => 'fsmRmtErrFirmwareDistributableDeleteRemote',
    '77960' => 'fsmRmtErrMgmtControllerUpdateUCSManagerStart',
    '77961' => 'fsmRmtErrMgmtControllerUpdateSwitchVerifyRemote',
    '77962' => 'fsmRmtErrMgmtControllerUpdateIOMCopyImgFromRep',
    '77963' => 'fsmRmtErrFirmwarePlatformPackPlatformVersionWaitForReady',
    '77964' => 'fsmRmtErrFirmwareSystemDeployWaitForSystemReady',
    '77965' => 'fsmRmtErrFirmwareSupFirmwareDeployWaitForFirmwareVersionUpdate',
    '77966' => 'fsmRmtErrFirmwareSystemApplyCatalogPackResolveImages',
    '77968' => 'fsmRmtErrIdentIdentRequestUpdateIdentExecute',
    '77969' => 'fsmRmtErrIdentMetaSystemSyncPing',
    '77970' => 'fsmRmtErrIdentMetaSystemUcscUnivSyncExecute',
    '78025' => 'fsmRmtErrSmAppDeleteLocal',
    '78026' => 'fsmRmtErrSmSecSvcRestoreApplicationRestore',
    '78027' => 'fsmRmtErrSmAppUpdateApplicationUpdate',
    '78028' => 'fsmRmtErrSmAppInstanceResetApplicationWaitForStopMainApp',
    '78029' => 'fsmRmtErrSmSecSvcAutoDeployCSPWaitForPortReady',
    '78107' => 'fsmRmtErrSwAccessDomainDeployUpdateConnectivity',
    '78108' => 'fsmRmtErrSwEthLanBorderDeployUpdateVlanGroups',
    '78109' => 'fsmRmtErrSwFcSanBorderDeployUpdateConnectivity',
    '78110' => 'fsmRmtErrSwUtilityDomainDeployUpdateConnectivity',
    '78116' => 'fsmRmtErrSwPhysConfPhysicalVerifyPhysConfig',
    '78121' => 'fsmRmtErrSwExtUtilityConfPortBreakoutVerifyBreakoutConfig',
    '78122' => 'fsmRmtErrSwFcSanBorderActivateZoneSetUpdateZones',
    '78158' => 'fsmRmtErrCallhomeEpConfigCallhomeSetPeer',
    '78167' => 'fsmRmtErrAdaptorExtEthIfPathResetEnable',
    '78170' => 'fsmRmtErrAdaptorHostEthIfCircuitResetEnableB',
    '78171' => 'fsmRmtErrAdaptorHostFcIfCircuitResetEnableB',
    '78188' => 'fsmRmtErrLicenseDownloaderDownloadValidateRemote',
    '78189' => 'fsmRmtErrLicenseFileInstallRemote',
    '78190' => 'fsmRmtErrLicenseFileClearRemote',
    '78191' => 'fsmRmtErrLicenseInstanceUpdateFlexlmRemote',
    '78192' => 'fsmRmtErrLicenseSmartConfigSetConfigLocal',
    '78210' => 'fsmRmtErrLsServerConfigureCheckAssignedIdentifiersForDup',
    '78220' => 'fsmRmtErrComputeBladeDiagSwUnconfigPeer',
    '78243' => 'fsmRmtErrMgmtControllerExtMgmtInterfaceConfigCIMCVlanCfgPeer',
    '78244' => 'fsmRmtErrComputePhysicalSwConnUpdB',
    '78245' => 'fsmRmtErrEquipmentIOCardResetIomExecute',
    '78246' => 'fsmRmtErrComputePhysicalServiceInfraDeploySwConfigPeer',
    '78247' => 'fsmRmtErrComputePhysicalServiceInfraWithdrawSwUnConfigPeer',
    '78255' => 'fsmRmtErrEquipmentIOCardBaseFePresenceIdentify',
    '78256' => 'fsmRmtErrEquipmentIOCardBaseFeConnConfigureVifNs',
    '78257' => 'fsmRmtErrEquipmentChassisRemoveChassisDecomission',
    '78258' => 'fsmRmtErrEquipmentLocatorLedSetFeLocatorLedExecute',
    '78259' => 'fsmRmtErrEquipmentLocatorLedSetFiLocatorLedExecute',
    '78262' => 'fsmRmtErrPortPIoInCompatSfpPresenceShutdown',
    '78263' => 'fsmRmtErrPortPIoInCompatSfpReplacedEnablePort',
    '78503' => 'fsmRmtErrObserveObservedResolvePolicyFsmExecute',
    '78504' => 'fsmRmtErrObserveObservedResolveResourceFsmExecute',
    '78505' => 'fsmRmtErrObserveObservedResolveVMFsmExecute',
    '78506' => 'fsmRmtErrObserveObservedResolveControllerFsmExecute',
    '78589' => 'fsmRmtErrEquipmentBeaconLedIlluminateExecuteB',
    '78591' => 'fsmRmtErrSdAppInstanceInstallApplicationWaitStage',
    '78592' => 'fsmRmtErrSdAppInstanceStartApplicationWaitStage',
    '78593' => 'fsmRmtErrSdLduProvisionLDUWaitForLinkConfiguration',
    '78594' => 'fsmRmtErrSdAppInstanceUpgradeApplicationWaitStage',
    '78595' => 'fsmRmtErrSdAppInstanceStopApplicationWaitStage',
    '78596' => 'fsmRmtErrSdAppInstanceUninstallApplicationWaitStage',
    '78597' => 'fsmRmtErrSdSlotChangePlatformLogLevelSendCommand',
    '78598' => 'fsmRmtErrSdAppInstanceBundleDataPortsWaitForConfigCompletion',
    '78599' => 'fsmRmtErrSdLogicalDeviceConfigureLinksWaitForSwitchConfig',
    '78601' => 'fsmRmtErrSdClusterBootstrapUpdateClusterConfigurationSendConfig',
    '78602' => 'fsmRmtErrSdSlotFormatDiskWaitForDiskFormatComplete',
    '78603' => 'fsmRmtErrSdSlotSynchTimeZoneUpdateTimeZone',
    '78604' => 'fsmRmtErrSdAppAttributeCtrlGetAppAttributesGetAttributes',
    '78605' => 'fsmRmtErrSdMgmtInfoUpdateMgmtInfoSendUpdate',
    '78606' => 'fsmRmtErrSdNetMgmtBootstrapUpdateNetMgmtBootstrapSendUpdate',
    '78607' => 'fsmRmtErrSdUpgradeTaskStopUpgradeStartAppWaitForUpgradeApp',
    '78609' => 'fsmRmtErrEtherServerIntFIoConfigSpeedConfigure',
    '78610' => 'fsmRmtErrEtherFtwPortPairConfigFtwConfigure',
    '78625' => 'fsmRmtErrExtpolEpRegisterFsmExecute',
    '78626' => 'fsmRmtErrExtpolRegistryCrossDomainConfigSetPeer',
    '78627' => 'fsmRmtErrExtpolRegistryCrossDomainDeleteSetPeer',
    '78664' => 'fsmRmtErrStorageSystemSyncExecute',
    '78666' => 'fsmRmtErrSysfileMutationSingleExecute',
    '78667' => 'fsmRmtErrSysfileMutationGlobalPeer',
    '78671' => 'fsmRmtErrApplicationDownloaderDownloadUnpackLocal',
    '78672' => 'fsmRmtErrCommSvcEpUpdateSvcEpSetEpPeer',
    '78673' => 'fsmRmtErrCommSvcEpRestartWebSvcPeer',
    '78691' => 'fsmRmtErrPkiEpUpdateEpValidateKeyRingAndTP',
    '78692' => 'fsmRmtErrAaaEpUpdateEpSetEpPeer',
    '78693' => 'fsmRmtErrAaaRealmUpdateRealmSetRealmPeer',
    '78694' => 'fsmRmtErrAaaUserEpUpdateUserEpSetUserPeer',
    '78705' => 'fsmRmtErrSysdebugManualCoreFileExportTargetExportExecute',
    '78706' => 'fsmRmtErrSysdebugLogExportPolicyConfigurePeer',
    '78707' => 'fsmRmtErrSysdebugAutoCoreFileExportTargetConfigurePeer',
    '78708' => 'fsmRmtErrSysdebugTechSupportInitiateLocal',
    '78709' => 'fsmRmtErrSysdebugTechSupportDeleteTechSupFilePeer',
    '78710' => 'fsmRmtErrSysdebugTechSupportDownloadDeleteSub',
    '78711' => 'fsmRmtErrSysdebugCoreDownloadDeleteSub',
    '78712' => 'fsmRmtErrSysdebugLogControlEpLogControlPersistPeer',
    '78776' => 'fsmRmtErrEpqosDefinitionDeployPeer',
    '78777' => 'fsmRmtErrEpqosDefinitionDelTaskRemovePeer',
    '78780' => 'fsmRmtErrQosclassDefinitionConfigGlobalQoSSetPeer',
    '78787' => 'fsmRmtErrMgmtControllerRegistryConfigRemove',
    '78798' => 'fsmRmtErrMgmtIfSwMgmtOobIfConfigSwitch',
    '78799' => 'fsmRmtErrMgmtIfSwMgmtInbandIfConfigSwitch',
    '78800' => 'fsmRmtErrMgmtIPv6IfAddrSwMgmtOobIpv6IfConfigSwitch',
    '78813' => 'fsmRmtErrNhTableHolderConfigureLinksVerifyLinkConfig',
    '78814' => 'fsmRmtErrNhTableHolderBootstrapLinksApplyConfig',
    '78818' => 'fsmRmtErrStatsCollectionPolicyUpdateEpSetEpB',
    '78843' => 'fsmRmtErrSyntheticFsObjCreateCreateRemote',
    '78848' => 'fsmRmtErrCapabilityUpdaterUpdaterUnpackLocal',
    '78849' => 'fsmRmtErrCapabilityCatalogueActivateCatalogUnpackLocal',
    '78850' => 'fsmRmtErrCapabilityMgmtExtensionActivateMgmtExtUnpackLocal',
    '78851' => 'fsmRmtErrCapabilityCatalogueDeployCatalogueFinalize',
    '78860' => 'fsmRmtErrSwEthMonDeployUpdateEthMon',
    '78909' => 'fsmRmtErrSwSspEthMonDeployUpdateSspEthMon',
    '78910' => 'fsmRmtErrSwSspEthMonSrcPhyEpDeleteDeletePcapFile',
    '78916' => 'fsmRmtErrFabricVnetEpSyncEpPushVnetEpDeletionSync',
    '78917' => 'fsmRmtErrFabricLanCloudSwitchModeSwConfigPeer',
    '78918' => 'fsmRmtErrFabricSanCloudSwitchModeSwConfigPeer',
    '78924' => 'fsmRmtErrFabricEpMgrConfigureWaitOnPhys',
    '78930' => 'fsmRmtErrMgmtExportPolicyReportConfigCopyReport',
    '78931' => 'fsmRmtErrExtpolProviderReportConfigImportReport',
    '78932' => 'fsmRmtErrMgmtIfVirtualIfConfigRemote',
    '78933' => 'fsmRmtErrMgmtIfEnableVipLocal',
    '78934' => 'fsmRmtErrMgmtIfDisableVipPeer',
    '78935' => 'fsmRmtErrMgmtIfEnableHALocal',
    '78936' => 'fsmRmtErrMgmtBackupBackupUpload',
    '78937' => 'fsmRmtErrMgmtImporterImportWaitForSwitch',
    '78938' => 'fsmRmtErrMgmtControllerSysConfigSecondary',
    '78971' => 'fsmRmtErrNfsMountInstMountVerifyRegistration',
    '78972' => 'fsmRmtErrNfsMountInstUnmountUnmountPeer',
    '78973' => 'fsmRmtErrNfsMountDefReportNfsMountSuspendReport',
    '78994' => 'fsmRmtErrExtpolEpRepairCertVerifyGuid',
    '78995' => 'fsmRmtErrPolicyControlEpOperateResolve',
    '78996' => 'fsmRmtErrPolicyControlledTypeOperateResolveAll',
    '78999' => 'fsmRmtErrPolicyPolicyScopeReleasePolicyFsmRelease',
    '79000' => 'fsmRmtErrPolicyPolicyScopeReleaseOperationFsmRelease',
    '79001' => 'fsmRmtErrPolicyPolicyScopeReleaseStorageFsmRelease',
    '79002' => 'fsmRmtErrPolicyPolicyScopeResolveManyPolicyFsmResolveMany',
    '79003' => 'fsmRmtErrPolicyPolicyScopeResolveManyOperationFsmResolveMany',
    '79004' => 'fsmRmtErrPolicyPolicyScopeResolveManyStorageFsmResolveMany',
    '79005' => 'fsmRmtErrPolicyPolicyScopeReleaseManyPolicyFsmReleaseMany',
    '79006' => 'fsmRmtErrPolicyPolicyScopeReleaseManyOperationFsmReleaseMany',
    '79007' => 'fsmRmtErrPolicyPolicyScopeReleaseManyStorageFsmReleaseMany',
    '79008' => 'fsmRmtErrPolicyPolicyScopeResolveAllPolicyFsmResolveAll',
    '79009' => 'fsmRmtErrPolicyPolicyScopeResolveAllOperationFsmResolveAll',
    '79010' => 'fsmRmtErrPolicyPolicyScopeResolveAllStorageFsmResolveAll',
    '79011' => 'fsmRmtErrPolicyPolicyScopeReleaseAllPolicyFsmReleaseAll',
    '79012' => 'fsmRmtErrPolicyPolicyScopeReleaseAllOperationFsmReleaseAll',
    '79013' => 'fsmRmtErrPolicyPolicyScopeReleaseAllStorageFsmReleaseAll',
    '79130' => 'fsmRmtErrFirmwareInfraPackInfraVersionWaitForReady',
    '79140' => 'fsmRmtErrFirmwareValidationStatusValidateComplete',
    '79151' => 'fsmRmtErrSdLogicalDeviceConfigureUserMacsWaitForSwitchConfig',
    '79155' => 'fsmRmtErrMgmtIfSwMgmtOobIfDhcpConfigStopDhcpSvc',
    '79158' => 'fsmRmtErrSdLduUpdateInterfaceStatusSendStatus',
    '79164' => 'fsmRmtErrEquipmentChassisShutdownChassisApplyShutdown',
    '79165' => 'fsmRmtErrEquipmentChassisRebootChassisApplyReboot',
    '79175' => 'fsmRmtErrIpsecEpUpdateEpApplyConfig',
    '79184' => 'fsmRmtErrNetworkEthLanMgmtUpdateInterfaceStatusSendStatus',
    '79185' => 'fsmRmtErrNetworkEthLanMgmtUpdateMgmtInterfaceStatusSendStatus',
    '79192' => 'fsmRmtErrSdLogicalDeviceConfigureMacsWaitForSwitchConfig',
    '999516' => 'fsmFailComputeServerDiscPolicyResolveScrubPolicy',
    '999517' => 'fsmFailGmetaHolderInventory',
    '999557' => 'fsmFailFirmwareDownloaderDownload',
    '999558' => 'fsmFailFirmwareImageDelete',
    '999559' => 'fsmFailFirmwareDistributableDelete',
    '999560' => 'fsmFailMgmtControllerUpdateUCSManager',
    '999561' => 'fsmFailMgmtControllerUpdateSwitch',
    '999562' => 'fsmFailMgmtControllerUpdateIOM',
    '999563' => 'fsmFailFirmwarePlatformPackPlatformVersion',
    '999564' => 'fsmFailFirmwareSystemDeploy',
    '999565' => 'fsmFailFirmwareSupFirmwareDeploy',
    '999566' => 'fsmFailFirmwareSystemApplyCatalogPack',
    '999568' => 'fsmFailIdentIdentRequestUpdateIdent',
    '999569' => 'fsmFailIdentMetaSystemSync',
    '999570' => 'fsmFailIdentMetaSystemUcscUnivSync',
    '999625' => 'fsmFailSmAppDelete',
    '999626' => 'fsmFailSmSecSvcRestoreApplication',
    '999627' => 'fsmFailSmAppUpdateApplication',
    '999628' => 'fsmFailSmAppInstanceResetApplication',
    '999629' => 'fsmFailSmSecSvcAutoDeployCSP',
    '999707' => 'fsmFailSwAccessDomainDeploy',
    '999708' => 'fsmFailSwEthLanBorderDeploy',
    '999709' => 'fsmFailSwFcSanBorderDeploy',
    '999710' => 'fsmFailSwUtilityDomainDeploy',
    '999716' => 'fsmFailSwPhysConfPhysical',
    '999721' => 'fsmFailSwExtUtilityConfPortBreakout',
    '999722' => 'fsmFailSwFcSanBorderActivateZoneSet',
    '999758' => 'fsmFailCallhomeEpConfigCallhome',
    '999767' => 'fsmFailAdaptorExtEthIfPathReset',
    '999770' => 'fsmFailAdaptorHostEthIfCircuitReset',
    '999771' => 'fsmFailAdaptorHostFcIfCircuitReset',
    '999788' => 'fsmFailLicenseDownloaderDownload',
    '999789' => 'fsmFailLicenseFileInstall',
    '999790' => 'fsmFailLicenseFileClear',
    '999791' => 'fsmFailLicenseInstanceUpdateFlexlm',
    '999792' => 'fsmFailLicenseSmartConfigSetConfig',
    '999810' => 'fsmFailLsServerConfigure',
    '999820' => 'fsmFailComputeBladeDiag',
    '999843' => 'fsmFailMgmtControllerExtMgmtInterfaceConfig',
    '999844' => 'fsmFailComputePhysicalSwConnUpd',
    '999845' => 'fsmFailEquipmentIOCardResetIom',
    '999846' => 'fsmFailComputePhysicalServiceInfraDeploy',
    '999847' => 'fsmFailComputePhysicalServiceInfraWithdraw',
    '999855' => 'fsmFailEquipmentIOCardBaseFePresence',
    '999856' => 'fsmFailEquipmentIOCardBaseFeConn',
    '999857' => 'fsmFailEquipmentChassisRemoveChassis',
    '999858' => 'fsmFailEquipmentLocatorLedSetFeLocatorLed',
    '999859' => 'fsmFailEquipmentLocatorLedSetFiLocatorLed',
    '999862' => 'fsmFailPortPIoInCompatSfpPresence',
    '999863' => 'fsmFailPortPIoInCompatSfpReplaced',
    '1000103' => 'fsmFailObserveObservedResolvePolicyFsm',
    '1000104' => 'fsmFailObserveObservedResolveResourceFsm',
    '1000105' => 'fsmFailObserveObservedResolveVMFsm',
    '1000106' => 'fsmFailObserveObservedResolveControllerFsm',
    '1000189' => 'fsmFailEquipmentBeaconLedIlluminate',
    '1000191' => 'fsmFailSdAppInstanceInstallApplication',
    '1000192' => 'fsmFailSdAppInstanceStartApplication',
    '1000193' => 'fsmFailSdLduProvisionLDU',
    '1000194' => 'fsmFailSdAppInstanceUpgradeApplication',
    '1000195' => 'fsmFailSdAppInstanceStopApplication',
    '1000196' => 'fsmFailSdAppInstanceUninstallApplication',
    '1000197' => 'fsmFailSdSlotChangePlatformLogLevel',
    '1000198' => 'fsmFailSdAppInstanceBundleDataPorts',
    '1000199' => 'fsmFailSdLogicalDeviceConfigureLinks',
    '1000201' => 'fsmFailSdClusterBootstrapUpdateClusterConfiguration',
    '1000202' => 'fsmFailSdSlotFormatDisk',
    '1000203' => 'fsmFailSdSlotSynchTimeZone',
    '1000204' => 'fsmFailSdAppAttributeCtrlGetAppAttributes',
    '1000205' => 'fsmFailSdMgmtInfoUpdateMgmtInfo',
    '1000206' => 'fsmFailSdNetMgmtBootstrapUpdateNetMgmtBootstrap',
    '1000207' => 'fsmFailSdUpgradeTaskStopUpgradeStartApp',
    '1000209' => 'fsmFailEtherServerIntFIoConfigSpeed',
    '1000210' => 'fsmFailEtherFtwPortPairConfigFtw',
    '1000225' => 'fsmFailExtpolEpRegisterFsm',
    '1000226' => 'fsmFailExtpolRegistryCrossDomainConfig',
    '1000227' => 'fsmFailExtpolRegistryCrossDomainDelete',
    '1000264' => 'fsmFailStorageSystemSync',
    '1000266' => 'fsmFailSysfileMutationSingle',
    '1000267' => 'fsmFailSysfileMutationGlobal',
    '1000271' => 'fsmFailApplicationDownloaderDownload',
    '1000272' => 'fsmFailCommSvcEpUpdateSvcEp',
    '1000273' => 'fsmFailCommSvcEpRestartWebSvc',
    '1000291' => 'fsmFailPkiEpUpdateEp',
    '1000292' => 'fsmFailAaaEpUpdateEp',
    '1000293' => 'fsmFailAaaRealmUpdateRealm',
    '1000294' => 'fsmFailAaaUserEpUpdateUserEp',
    '1000305' => 'fsmFailSysdebugManualCoreFileExportTargetExport',
    '1000306' => 'fsmFailSysdebugLogExportPolicyConfigure',
    '1000307' => 'fsmFailSysdebugAutoCoreFileExportTargetConfigure',
    '1000308' => 'fsmFailSysdebugTechSupportInitiate',
    '1000309' => 'fsmFailSysdebugTechSupportDeleteTechSupFile',
    '1000310' => 'fsmFailSysdebugTechSupportDownload',
    '1000311' => 'fsmFailSysdebugCoreDownload',
    '1000312' => 'fsmFailSysdebugLogControlEpLogControlPersist',
    '1000376' => 'fsmFailEpqosDefinitionDeploy',
    '1000377' => 'fsmFailEpqosDefinitionDelTaskRemove',
    '1000380' => 'fsmFailQosclassDefinitionConfigGlobalQoS',
    '1000387' => 'fsmFailMgmtControllerRegistryConfig',
    '1000398' => 'fsmFailMgmtIfSwMgmtOobIfConfig',
    '1000399' => 'fsmFailMgmtIfSwMgmtInbandIfConfig',
    '1000400' => 'fsmFailMgmtIPv6IfAddrSwMgmtOobIpv6IfConfig',
    '1000413' => 'fsmFailNhTableHolderConfigureLinks',
    '1000414' => 'fsmFailNhTableHolderBootstrapLinks',
    '1000418' => 'fsmFailStatsCollectionPolicyUpdateEp',
    '1000443' => 'fsmFailSyntheticFsObjCreate',
    '1000448' => 'fsmFailCapabilityUpdaterUpdater',
    '1000449' => 'fsmFailCapabilityCatalogueActivateCatalog',
    '1000450' => 'fsmFailCapabilityMgmtExtensionActivateMgmtExt',
    '1000451' => 'fsmFailCapabilityCatalogueDeployCatalogue',
    '1000460' => 'fsmFailSwEthMonDeploy',
    '1000509' => 'fsmFailSwSspEthMonDeploy',
    '1000510' => 'fsmFailSwSspEthMonSrcPhyEpDelete',
    '1000516' => 'fsmFailFabricVnetEpSyncEpPushVnetEpDeletion',
    '1000517' => 'fsmFailFabricLanCloudSwitchMode',
    '1000518' => 'fsmFailFabricSanCloudSwitchMode',
    '1000524' => 'fsmFailFabricEpMgrConfigure',
    '1000530' => 'fsmFailMgmtExportPolicyReportConfigCopy',
    '1000531' => 'fsmFailExtpolProviderReportConfigImport',
    '1000532' => 'fsmFailMgmtIfVirtualIfConfig',
    '1000533' => 'fsmFailMgmtIfEnableVip',
    '1000534' => 'fsmFailMgmtIfDisableVip',
    '1000535' => 'fsmFailMgmtIfEnableHA',
    '1000536' => 'fsmFailMgmtBackupBackup',
    '1000537' => 'fsmFailMgmtImporterImport',
    '1000538' => 'fsmFailMgmtControllerSysConfig',
    '1000571' => 'fsmFailNfsMountInstMount',
    '1000572' => 'fsmFailNfsMountInstUnmount',
    '1000573' => 'fsmFailNfsMountDefReportNfsMountSuspend',
    '1000594' => 'fsmFailExtpolEpRepairCert',
    '1000595' => 'fsmFailPolicyControlEpOperate',
    '1000596' => 'fsmFailPolicyControlledTypeOperate',
    '1000599' => 'fsmFailPolicyPolicyScopeReleasePolicyFsm',
    '1000600' => 'fsmFailPolicyPolicyScopeReleaseOperationFsm',
    '1000601' => 'fsmFailPolicyPolicyScopeReleaseStorageFsm',
    '1000602' => 'fsmFailPolicyPolicyScopeResolveManyPolicyFsm',
    '1000603' => 'fsmFailPolicyPolicyScopeResolveManyOperationFsm',
    '1000604' => 'fsmFailPolicyPolicyScopeResolveManyStorageFsm',
    '1000605' => 'fsmFailPolicyPolicyScopeReleaseManyPolicyFsm',
    '1000606' => 'fsmFailPolicyPolicyScopeReleaseManyOperationFsm',
    '1000607' => 'fsmFailPolicyPolicyScopeReleaseManyStorageFsm',
    '1000608' => 'fsmFailPolicyPolicyScopeResolveAllPolicyFsm',
    '1000609' => 'fsmFailPolicyPolicyScopeResolveAllOperationFsm',
    '1000610' => 'fsmFailPolicyPolicyScopeResolveAllStorageFsm',
    '1000611' => 'fsmFailPolicyPolicyScopeReleaseAllPolicyFsm',
    '1000612' => 'fsmFailPolicyPolicyScopeReleaseAllOperationFsm',
    '1000613' => 'fsmFailPolicyPolicyScopeReleaseAllStorageFsm',
    '1000730' => 'fsmFailFirmwareInfraPackInfraVersion',
    '1000740' => 'fsmFailFirmwareValidationStatusValidate',
    '1000751' => 'fsmFailSdLogicalDeviceConfigureUserMacs',
    '1000755' => 'fsmFailMgmtIfSwMgmtOobIfDhcpConfig',
    '1000758' => 'fsmFailSdLduUpdateInterfaceStatus',
    '1000764' => 'fsmFailEquipmentChassisShutdownChassis',
    '1000765' => 'fsmFailEquipmentChassisRebootChassis',
    '1000775' => 'fsmFailIpsecEpUpdateEp',
    '1000784' => 'fsmFailNetworkEthLanMgmtUpdateInterfaceStatus',
    '1000785' => 'fsmFailNetworkEthLanMgmtUpdateMgmtInterfaceStatus',
    '1000792' => 'fsmFailSdLogicalDeviceConfigureMacs',
  },
};
