package Monitoring::GLPlugin::SNMP::MibsAndOids::ARISTABGP4V2MIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'ARISTA-BGP4V2-MIB'} = {
  url => '',
  name => 'ARISTA-BGP4V2-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'ARISTA-BGP4V2-MIB'} =
    '1.3.6.1.4.1.30065.4.1';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'ARISTA-BGP4V2-MIB'} = {
  aristaBgp4V2 => '1.3.6.1.4.1.30065.4.1',
  aristaBgp4V2Notifications => '1.3.6.1.4.1.30065.4.1.0',
  aristaBgp4V2Objects => '1.3.6.1.4.1.30065.4.1.1',
  aristaBgp4V2DiscontinuityTable => '1.3.6.1.4.1.30065.4.1.1.1',
  aristaBgp4V2DiscontinuityEntry => '1.3.6.1.4.1.30065.4.1.1.1.1',
  aristaBgp4V2DiscontinuityTime => '1.3.6.1.4.1.30065.4.1.1.1.1.1',
  aristaBgp4V2PeerTable => '1.3.6.1.4.1.30065.4.1.1.2',
  aristaBgp4V2PeerEntry => '1.3.6.1.4.1.30065.4.1.1.2.1',
  aristaBgp4V2PeerInstance => '1.3.6.1.4.1.30065.4.1.1.2.1.1',
  aristaBgp4V2PeerLocalAddrType => '1.3.6.1.4.1.30065.4.1.1.2.1.2',
  aristaBgp4V2PeerLocalAddrTypeDefinition => 'INET-ADDRESS-MIB::InetAddressType',
  aristaBgp4V2PeerLocalAddr => '1.3.6.1.4.1.30065.4.1.1.2.1.3',
  aristaBgp4V2PeerLocalAddrDefinition => 'INET-ADDRESS-MIB::InetAddress(aristaBgp4V2PeerLocalAddrType)',
  aristaBgp4V2PeerRemoteAddrType => '1.3.6.1.4.1.30065.4.1.1.2.1.4',
  aristaBgp4V2PeerRemoteAddrTypeDefinition => 'INET-ADDRESS-MIB::InetAddressType',
  aristaBgp4V2PeerRemoteAddr => '1.3.6.1.4.1.30065.4.1.1.2.1.5',
  aristaBgp4V2PeerRemoteAddrDefinition => 'INET-ADDRESS-MIB::InetAddress(aristaBgp4V2PeerRemoteAddrType)',
  aristaBgp4V2PeerLocalPort => '1.3.6.1.4.1.30065.4.1.1.2.1.6',
  aristaBgp4V2PeerLocalAs => '1.3.6.1.4.1.30065.4.1.1.2.1.7',
  aristaBgp4V2PeerLocalIdentifier => '1.3.6.1.4.1.30065.4.1.1.2.1.8',
  aristaBgp4V2PeerLocalIdentifierDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2IdentifierTC',
  aristaBgp4V2PeerRemotePort => '1.3.6.1.4.1.30065.4.1.1.2.1.9',
  aristaBgp4V2PeerRemoteAs => '1.3.6.1.4.1.30065.4.1.1.2.1.10',
  aristaBgp4V2PeerRemoteIdentifier => '1.3.6.1.4.1.30065.4.1.1.2.1.11',
  aristaBgp4V2PeerRemoteIdentifierDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2IdentifierTC',
  aristaBgp4V2PeerAdminStatus => '1.3.6.1.4.1.30065.4.1.1.2.1.12',
  aristaBgp4V2PeerAdminStatusDefinition => 'ARISTA-BGP4V2-MIB::aristaBgp4V2PeerAdminStatus',
  aristaBgp4V2PeerState => '1.3.6.1.4.1.30065.4.1.1.2.1.13',
  aristaBgp4V2PeerStateDefinition => 'ARISTA-BGP4V2-MIB::aristaBgp4V2PeerState',
  aristaBgp4V2PeerDescription => '1.3.6.1.4.1.30065.4.1.1.2.1.14',
  aristaBgp4V2PeerErrorsTable => '1.3.6.1.4.1.30065.4.1.1.3',
  aristaBgp4V2PeerErrorsEntry => '1.3.6.1.4.1.30065.4.1.1.3.1',
  aristaBgp4V2PeerLastErrorCodeReceived => '1.3.6.1.4.1.30065.4.1.1.3.1.1',
  aristaBgp4V2PeerLastErrorSubCodeReceived => '1.3.6.1.4.1.30065.4.1.1.3.1.2',
  aristaBgp4V2PeerLastErrorReceivedTime => '1.3.6.1.4.1.30065.4.1.1.3.1.3',
  aristaBgp4V2PeerLastErrorReceivedText => '1.3.6.1.4.1.30065.4.1.1.3.1.4',
  aristaBgp4V2PeerLastErrorReceivedData => '1.3.6.1.4.1.30065.4.1.1.3.1.5',
  aristaBgp4V2PeerLastErrorCodeSent => '1.3.6.1.4.1.30065.4.1.1.3.1.6',
  aristaBgp4V2PeerLastErrorSubCodeSent => '1.3.6.1.4.1.30065.4.1.1.3.1.7',
  aristaBgp4V2PeerLastErrorSentTime => '1.3.6.1.4.1.30065.4.1.1.3.1.8',
  aristaBgp4V2PeerLastErrorSentText => '1.3.6.1.4.1.30065.4.1.1.3.1.9',
  aristaBgp4V2PeerLastErrorSentData => '1.3.6.1.4.1.30065.4.1.1.3.1.10',
  aristaBgp4V2PeerEventTimesTable => '1.3.6.1.4.1.30065.4.1.1.4',
  aristaBgp4V2PeerEventTimesEntry => '1.3.6.1.4.1.30065.4.1.1.4.1',
  aristaBgp4V2PeerFsmEstablishedTime => '1.3.6.1.4.1.30065.4.1.1.4.1.1',
  aristaBgp4V2PeerInUpdatesElapsedTime => '1.3.6.1.4.1.30065.4.1.1.4.1.2',
  aristaBgp4V2PeerConfiguredTimersTable => '1.3.6.1.4.1.30065.4.1.1.5',
  aristaBgp4V2PeerConfiguredTimersEntry => '1.3.6.1.4.1.30065.4.1.1.5.1',
  aristaBgp4V2PeerConnectRetryInterval => '1.3.6.1.4.1.30065.4.1.1.5.1.1',
  aristaBgp4V2PeerHoldTimeConfigured => '1.3.6.1.4.1.30065.4.1.1.5.1.2',
  aristaBgp4V2PeerKeepAliveConfigured => '1.3.6.1.4.1.30065.4.1.1.5.1.3',
  aristaBgp4V2PeerMinASOrigInterval => '1.3.6.1.4.1.30065.4.1.1.5.1.4',
  aristaBgp4V2PeerMinRouteAdverInterval => '1.3.6.1.4.1.30065.4.1.1.5.1.5',
  aristaBgp4V2PeerNegotiatedTimersTable => '1.3.6.1.4.1.30065.4.1.1.6',
  aristaBgp4V2PeerNegotiatedTimersEntry => '1.3.6.1.4.1.30065.4.1.1.6.1',
  aristaBgp4V2PeerHoldTime => '1.3.6.1.4.1.30065.4.1.1.6.1.1',
  aristaBgp4V2PeerKeepAlive => '1.3.6.1.4.1.30065.4.1.1.6.1.2',
  aristaBgp4V2PeerCountersTable => '1.3.6.1.4.1.30065.4.1.1.7',
  aristaBgp4V2PeerCountersEntry => '1.3.6.1.4.1.30065.4.1.1.7.1',
  aristaBgp4V2PeerInUpdates => '1.3.6.1.4.1.30065.4.1.1.7.1.1',
  aristaBgp4V2PeerOutUpdates => '1.3.6.1.4.1.30065.4.1.1.7.1.2',
  aristaBgp4V2PeerInTotalMessages => '1.3.6.1.4.1.30065.4.1.1.7.1.3',
  aristaBgp4V2PeerOutTotalMessages => '1.3.6.1.4.1.30065.4.1.1.7.1.4',
  aristaBgp4V2PeerFsmEstablishedTransitions => '1.3.6.1.4.1.30065.4.1.1.7.1.5',
  aristaBgp4V2PrefixGaugesTable => '1.3.6.1.4.1.30065.4.1.1.8',
  aristaBgp4V2PrefixGaugesEntry => '1.3.6.1.4.1.30065.4.1.1.8.1',
  aristaBgp4V2PrefixGaugesAfi => '1.3.6.1.4.1.30065.4.1.1.8.1.1',
  aristaBgp4V2PrefixGaugesAfiDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2AddressFamilyIdentifierTC',
  aristaBgp4V2PrefixGaugesSafi => '1.3.6.1.4.1.30065.4.1.1.8.1.2',
  aristaBgp4V2PrefixGaugesSafiDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2SubsequentAddressFamilyIdentifierTC',
  aristaBgp4V2PrefixInPrefixes => '1.3.6.1.4.1.30065.4.1.1.8.1.3',
  aristaBgp4V2PrefixInPrefixesAccepted => '1.3.6.1.4.1.30065.4.1.1.8.1.4',
  aristaBgp4V2PrefixOutPrefixes => '1.3.6.1.4.1.30065.4.1.1.8.1.5',
  aristaBgp4V2NlriTable => '1.3.6.1.4.1.30065.4.1.1.9',
  aristaBgp4V2NlriEntry => '1.3.6.1.4.1.30065.4.1.1.9.1',
  aristaBgp4V2NlriIndex => '1.3.6.1.4.1.30065.4.1.1.9.1.1',
  aristaBgp4V2NlriAfi => '1.3.6.1.4.1.30065.4.1.1.9.1.2',
  aristaBgp4V2NlriAfiDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2AddressFamilyIdentifierTC',
  aristaBgp4V2NlriSafi => '1.3.6.1.4.1.30065.4.1.1.9.1.3',
  aristaBgp4V2NlriSafiDefinition => 'ARISTA-BGP4V2-TC-MIB::AristaBgp4V2SubsequentAddressFamilyIdentifierTC',
  aristaBgp4V2NlriPrefixType => '1.3.6.1.4.1.30065.4.1.1.9.1.4',
  aristaBgp4V2NlriPrefix => '1.3.6.1.4.1.30065.4.1.1.9.1.5',
  aristaBgp4V2NlriPrefixLen => '1.3.6.1.4.1.30065.4.1.1.9.1.6',
  aristaBgp4V2NlriBest => '1.3.6.1.4.1.30065.4.1.1.9.1.7',
  aristaBgp4V2NlriCalcLocalPref => '1.3.6.1.4.1.30065.4.1.1.9.1.8',
  aristaBgp4V2NlriOrigin => '1.3.6.1.4.1.30065.4.1.1.9.1.9',
  aristaBgp4V2NlriOriginDefinition => 'ARISTA-BGP4V2-MIB::aristaBgp4V2NlriOrigin',
  aristaBgp4V2NlriNextHopAddrType => '1.3.6.1.4.1.30065.4.1.1.9.1.10',
  aristaBgp4V2NlriNextHopAddr => '1.3.6.1.4.1.30065.4.1.1.9.1.11',
  aristaBgp4V2NlriLinkLocalNextHopAddrType => '1.3.6.1.4.1.30065.4.1.1.9.1.12',
  aristaBgp4V2NlriLinkLocalNextHopAddr => '1.3.6.1.4.1.30065.4.1.1.9.1.13',
  aristaBgp4V2NlriLocalPrefPresent => '1.3.6.1.4.1.30065.4.1.1.9.1.14',
  aristaBgp4V2NlriLocalPref => '1.3.6.1.4.1.30065.4.1.1.9.1.15',
  aristaBgp4V2NlriMedPresent => '1.3.6.1.4.1.30065.4.1.1.9.1.16',
  aristaBgp4V2NlriMed => '1.3.6.1.4.1.30065.4.1.1.9.1.17',
  aristaBgp4V2NlriAtomicAggregate => '1.3.6.1.4.1.30065.4.1.1.9.1.18',
  aristaBgp4V2NlriAggregatorPresent => '1.3.6.1.4.1.30065.4.1.1.9.1.19',
  aristaBgp4V2NlriAggregatorAS => '1.3.6.1.4.1.30065.4.1.1.9.1.20',
  aristaBgp4V2NlriAggregatorAddr => '1.3.6.1.4.1.30065.4.1.1.9.1.21',
  aristaBgp4V2NlriAsPathCalcLength => '1.3.6.1.4.1.30065.4.1.1.9.1.22',
  aristaBgp4V2NlriAsPathString => '1.3.6.1.4.1.30065.4.1.1.9.1.23',
  aristaBgp4V2NlriAsPath => '1.3.6.1.4.1.30065.4.1.1.9.1.24',
  aristaBgp4V2NlriPathAttrUnknown => '1.3.6.1.4.1.30065.4.1.1.9.1.25',
  aristaBgp4V2AdjRibsOutTable => '1.3.6.1.4.1.30065.4.1.1.10',
  aristaBgp4V2AdjRibsOutEntry => '1.3.6.1.4.1.30065.4.1.1.10.1',
  aristaBgp4V2AdjRibsOutIndex => '1.3.6.1.4.1.30065.4.1.1.10.1.1',
  aristaBgp4V2AdjRibsOutRoute => '1.3.6.1.4.1.30065.4.1.1.10.1.2',
  aristaBgp4V2Conformance => '1.3.6.1.4.1.30065.4.1.2',
  aristaBgp4V2Compliances => '1.3.6.1.4.1.30065.4.1.2.1',
  aristaBgp4V2Groups => '1.3.6.1.4.1.30065.4.1.2.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'ARISTA-BGP4V2-MIB'} = {
  aristaBgp4V2NlriOrigin => {
    '1' => 'igp',
    '2' => 'egp',
    '3' => 'incomplete',
  },
  aristaBgp4V2PeerAdminStatus => {
    '1' => 'halted',
    '2' => 'running',
  },
  aristaBgp4V2PeerState => {
    '1' => 'idle',
    '2' => 'connect',
    '3' => 'active',
    '4' => 'opensent',
    '5' => 'openconfirm',
    '6' => 'established',
  },
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'ARISTA-BGP4V2-TC-MIB'} = {
  AristaBgp4V2IdentifierTC => sub {
    my ($addr) = @_;
    return Monitoring::GLPlugin::SNMP::TableItem->new()->unhex_ip($addr);
  },
  AristaBgp4V2AddressFamilyIdentifierTC => {
    1 => 'ipv4',
    2 => 'ipv6',
  },
  AristaBgp4V2SubsequentAddressFamilyIdentifierTC => {
    1 => 'unicast',
    2 => 'multicast',
    4 => 'mpls',
  },
};

