///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSigCatch.cc  
// ---------------                                                 
// Cego signal catcher class implementation
//                                                         
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2026 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoSigCatch
//
// Description: Catch interrupt signal to trigger server termination
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoXMLdef.h"
#include "CegoSigCatch.h"

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/Host.h>

// POSIX INCLUDES
#include <signal.h>
#include <stdlib.h>
#include <string.h>

CegoSigCatch::CegoSigCatch(CegoDatabaseManager *pDBMng)
{
    _pDBMng = pDBMng;
    _terminated = false;

    init();
    install(SIGINT);
    install(SIGPIPE);

    _modId = _pDBMng->getModId("CegoSigCatch");
}

CegoSigCatch::~CegoSigCatch()  
{
}

void CegoSigCatch::sigCatch(int sig)
{   
    try
    {   
	install(SIGINT);
	install(SIGPIPE);

	if ( sig == SIGINT )
	{
	    cout << "Received interrupt signal ..." << endl;
	    
	    _pDBMng->log(_modId, Logger::NOTICE, Chain("Received interrupt signal"));

	    _terminated = true;
	    
	}
	else
	{
	    _pDBMng->log(_modId, Logger::DEBUG, Chain("Receiving broken pipe signal, ignoring  ..."));
	}
    }
    catch ( Exception e )
    {	
	Chain msg;
	e.pop(msg);	
	_pDBMng->log(_modId, Logger::LOGERR, msg);
    }
}

bool CegoSigCatch::isTerminated()
{
    return _terminated;
}
