#ifndef _CEGOREPLACER_H_INCLUDED_
#define _CEGOREPLACER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoReplacer.h
// --------------
// Cego regex replacer container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoReplacer
// 
// Description: Container class with unique replace id for cego regex replacers
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/Replacer.h>


class CegoReplacer {

public:
    

    CegoReplacer();
    CegoReplacer(const Chain& pattern, const Chain& replace);
    ~CegoReplacer();

    Chain getId() const;

    unsigned replace(const Chain& src, Chain& target);

    void clean();

    unsigned getHashPos(unsigned  hashSize) const;
    
    CegoReplacer& operator = ( const CegoReplacer& rp);
    bool operator == ( const CegoReplacer& rp);
    friend ostream& operator << (ostream& s, const CegoReplacer& rp);
    
private:
    
    Chain _pattern;
    Chain _replace;
    Replacer* _pRep;
    
};
#endif
