#ifndef _CEGOQUERYEXCEPTION_H_INCLUDED_
#define _CEGOQUERYEXCEPTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryException.h
// --------------------
// Cego query exception container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoQueryException
// 
// Description: Data structure description for cego procedure exception
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoQueryException : public Exception {

public:
  
    CegoQueryException(CegoException excep, const Chain& module, unsigned line, const Chain& msg);
    CegoQueryException(CegoException excep, const Chain& module, unsigned line, const Chain& msg, const Exception& e);
    ~CegoQueryException();
    
    CegoException getException() const;
    Chain toChain() const;
    
    CegoQueryException& operator = ( const CegoQueryException& qe);
    bool operator == ( const CegoQueryException& qe);
    friend ostream& operator << (ostream& s, const CegoQueryException& qe);
    
private:
    
    CegoException _excep;
};
#endif
